//  ----------------------------------------------------------------------------
//                   Atmel Microcontroller Software Support
//  ----------------------------------------------------------------------------
//  Copyright (c) 2008, Atmel Corporation
//
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of source code must retain the above copyright notice,
//  this list of conditions and the disclaimer below.
//
//  - Redistributions in binary form must reproduce the above copyright notice,
//  this list of conditions and the disclaimer below in the documentation and/or
//  other materials provided with the distribution.
//
//  Atmel's name may not be used to endorse or promote products derived from
//  this software without specific prior written permission.
//
//  DISCLAIMER:  THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
//  DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
//  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//  ----------------------------------------------------------------------------
//
// File Name    : AT91SAM9M11.h
// Object       : AT91SAM9M11 definitions
// Generated by : AT91 SW Application Group
// Generated on : 2008-02-18

#ifndef AT91SAM9M11_H
#define AT91SAM9M11_H

#ifndef __ASSEMBLY__
typedef volatile unsigned int AT91_REG; // Hardware register definition
#define AT91_CAST(a) (a)
#else
#define AT91_CAST(a)
#endif

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR AC97 Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_AC97C {
  AT91_REG Reserved1[2];
  AT91_REG AC97C_MR;      // Mode Register
  AT91_REG Reserved2[1];
  AT91_REG AC97C_ICA;     // Input Channel Assignment Register
  AT91_REG AC97C_OCA;     // Output Channel Assignment Register
  AT91_REG Reserved3[2];
  AT91_REG AC97C_CARHR;   // Channel A Receive Holding Register
  AT91_REG AC97C_CATHR;   // Channel A Transmit Holding Register
  AT91_REG AC97C_CASR;    // Channel A Status Register
  AT91_REG AC97C_CAMR;    // Channel A Mode Register
  AT91_REG AC97C_CBRHR;   // Channel B Receive Holding Register
  AT91_REG AC97C_CBTHR;   // Channel B Transmit Holding Register
  AT91_REG AC97C_CBSR;    // Channel B Status Register
  AT91_REG AC97C_CBMR;    // Channel B Mode Register
  AT91_REG AC97C_CORHR;   // Codec Channel Receive Holding Register
  AT91_REG AC97C_COTHR;   // Codec Channel Transmit Holding Register
  AT91_REG AC97C_COSR;    // Codec Status Register
  AT91_REG AC97C_COMR;    // Codec Mode Register
  AT91_REG AC97C_SR;      // Status Register
  AT91_REG AC97C_IER;     // Interrupt Enable Register
  AT91_REG AC97C_IDR;     // Interrupt Disable Register
  AT91_REG AC97C_IMR;     // Interrupt Mask Register
  AT91_REG Reserved4[40];
  AT91_REG AC97C_RPR;     // Receive Pointer Register
  AT91_REG AC97C_RCR;     // Receive Counter Register
  AT91_REG AC97C_TPR;     // Transmit Pointer Register
  AT91_REG AC97C_TCR;     // Transmit Counter Register
  AT91_REG AC97C_RNPR;    // Receive Next Pointer Register
  AT91_REG AC97C_RNCR;    // Receive Next Counter Register
  AT91_REG AC97C_TNPR;    // Transmit Next Pointer Register
  AT91_REG AC97C_TNCR;    // Transmit Next Counter Register
  AT91_REG AC97C_PTCR;    // Transfer Control Register
  AT91_REG AC97C_PTSR;    // Transfer Status Register
} AT91S_AC97C, *AT91PS_AC97C;
#else
#define AC97C_MR    (AT91_CAST(AT91_REG *) 0x00000008) // Mode Register
#define AC97C_ICA   (AT91_CAST(AT91_REG *) 0x00000010) // Input Channel Assignment Register
#define AC97C_OCA   (AT91_CAST(AT91_REG *) 0x00000014) // Output Channel Assignment Register
#define AC97C_CARHR (AT91_CAST(AT91_REG *) 0x00000020) // Channel A Receive Holding Register
#define AC97C_CATHR (AT91_CAST(AT91_REG *) 0x00000024) // Channel A Transmit Holding Register
#define AC97C_CASR  (AT91_CAST(AT91_REG *) 0x00000028) // Channel A Status Register
#define AC97C_CAMR  (AT91_CAST(AT91_REG *) 0x0000002C) // Channel A Mode Register
#define AC97C_CBRHR (AT91_CAST(AT91_REG *) 0x00000030) // Channel B Receive Holding Register
#define AC97C_CBTHR (AT91_CAST(AT91_REG *) 0x00000034) // Channel B Transmit Holding Register
#define AC97C_CBSR  (AT91_CAST(AT91_REG *) 0x00000038) // Channel B Status Register
#define AC97C_CBMR  (AT91_CAST(AT91_REG *) 0x0000003C) // Channel B Mode Register
#define AC97C_CORHR (AT91_CAST(AT91_REG *) 0x00000040) // Codec Channel Receive Holding Register
#define AC97C_COTHR (AT91_CAST(AT91_REG *) 0x00000044) // Codec Channel Transmit Holding Register
#define AC97C_COSR  (AT91_CAST(AT91_REG *) 0x00000048) // Codec Status Register
#define AC97C_COMR  (AT91_CAST(AT91_REG *) 0x0000004C) // Codec Mode Register
#define AC97C_SR    (AT91_CAST(AT91_REG *) 0x00000050) // Status Register
#define AC97C_IER   (AT91_CAST(AT91_REG *) 0x00000054) // Interrupt Enable Register
#define AC97C_IDR   (AT91_CAST(AT91_REG *) 0x00000058) // Interrupt Disable Register
#define AC97C_IMR   (AT91_CAST(AT91_REG *) 0x0000005C) // Interrupt Mask Register
#define AC97C_RPR   (AT91_CAST(AT91_REG *) 0x00000100) // Receive Pointer Register
#define AC97C_RCR   (AT91_CAST(AT91_REG *) 0x00000104) // Receive Counter Register
#define AC97C_TPR   (AT91_CAST(AT91_REG *) 0x00000108) // Transmit Pointer Register
#define AC97C_TCR   (AT91_CAST(AT91_REG *) 0x0000010C) // Transmit Counter Register
#define AC97C_RNPR  (AT91_CAST(AT91_REG *) 0x00000110) // Receive Next Pointer Register
#define AC97C_RNCR  (AT91_CAST(AT91_REG *) 0x00000114) // Receive Next Counter Register
#define AC97C_TNPR  (AT91_CAST(AT91_REG *) 0x00000118) // Transmit Next Pointer Register
#define AC97C_TNCR  (AT91_CAST(AT91_REG *) 0x0000011C) // Transmit Next Counter Register
#define AC97C_PTCR  (AT91_CAST(AT91_REG *) 0x00000120) // Transfer Control Register
#define AC97C_PTSR  (AT91_CAST(AT91_REG *) 0x00000124) // Transfer Status Register
#endif
// -------- AC97C_MR : (AC97C Offset: 0x8) Mode Register --------
#define AT91C_AC97C_MR_ENA (0x1 << 0) // (AC97C) AC97 Controller Global Enable
#define AT91C_AC97C_MR_WRST (0x1 << 1) // (AC97C) Warm Reset
#define AT91C_AC97C_MR_VRA (0x1 << 2) // (AC97C) Variable Rate (for Data Slots 3-12)
// -------- AC97C_ICA : (AC97C Offset: 0x10) Input Channel Assignment Register --------
#define AT91C_AC97C_ICA_CHID3 (0x7 << 0) // (AC97C) Channel ID for the input slot 3
#define   AT91C_AC97C_ICA_CHID3_NONE (0x0 << 0) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID3_CA (0x1 << 0) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID3_CB (0x2 << 0) // (AC97C) Channel B data will be received during this slot time
#define AT91C_AC97C_ICA_CHID4 (0x7 << 3) // (AC97C) Channel ID for the input slot 4
#define   AT91C_AC97C_ICA_CHID4_NONE (0x0 << 3) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID4_CA (0x1 << 3) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID4_CB (0x2 << 3) // (AC97C) Channel B data will be received during this slot time
#define AT91C_AC97C_ICA_CHID5 (0x7 << 6) // (AC97C) Channel ID for the input slot 5
#define   AT91C_AC97C_ICA_CHID5_NONE (0x0 << 6) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID5_CA (0x1 << 6) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID5_CB (0x2 << 6) // (AC97C) Channel B data will be received during this slot time
#define AT91C_AC97C_ICA_CHID6 (0x7 << 9) // (AC97C) Channel ID for the input slot 6
#define   AT91C_AC97C_ICA_CHID6_NONE (0x0 << 9) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID6_CA (0x1 << 9) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID6_CB (0x2 << 9) // (AC97C) Channel B data will be received during this slot time
#define AT91C_AC97C_ICA_CHID7 (0x7 << 12) // (AC97C) Channel ID for the input slot 7
#define   AT91C_AC97C_ICA_CHID7_NONE (0x0 << 12) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID7_CA (0x1 << 12) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID7_CB (0x2 << 12) // (AC97C) Channel B data will be received during this slot time
#define AT91C_AC97C_ICA_CHID8 (0x7 << 15) // (AC97C) Channel ID for the input slot 8
#define   AT91C_AC97C_ICA_CHID8_NONE (0x0 << 15) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID8_CA (0x1 << 15) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID8_CB (0x2 << 15) // (AC97C) Channel B data will be received during this slot time
#define AT91C_AC97C_ICA_CHID9 (0x7 << 18) // (AC97C) Channel ID for the input slot 9
#define   AT91C_AC97C_ICA_CHID9_NONE (0x0 << 18) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID9_CA (0x1 << 18) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID9_CB (0x2 << 18) // (AC97C) Channel B data will be received during this slot time
#define AT91C_AC97C_ICA_CHID10 (0x7 << 21) // (AC97C) Channel ID for the input slot 10
#define   AT91C_AC97C_ICA_CHID10_NONE (0x0 << 21) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID10_CA (0x1 << 21) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID10_CB (0x2 << 21) // (AC97C) Channel B data will be received during this slot time
#define AT91C_AC97C_ICA_CHID11 (0x7 << 24) // (AC97C) Channel ID for the input slot 11
#define   AT91C_AC97C_ICA_CHID11_NONE (0x0 << 24) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID11_CA (0x1 << 24) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID11_CB (0x2 << 24) // (AC97C) Channel B data will be received during this slot time
#define AT91C_AC97C_ICA_CHID12 (0x7 << 27) // (AC97C) Channel ID for the input slot 12
#define   AT91C_AC97C_ICA_CHID12_NONE (0x0 << 27) // (AC97C) None. No data will be received during this slot time
#define   AT91C_AC97C_ICA_CHID12_CA (0x1 << 27) // (AC97C) Channel A data will be received during this slot time.
#define   AT91C_AC97C_ICA_CHID12_CB (0x2 << 27) // (AC97C) Channel B data will be received during this slot time
// -------- AC97C_OCA : (AC97C Offset: 0x14) Output Channel Assignment Register --------
#define AT91C_AC97C_OCA_CHID3 (0x7 << 0) // (AC97C) Channel ID for the output slot 3
#define AT91C_AC97C_OCA_CHID4 (0x7 << 3) // (AC97C) Channel ID for the output slot 4
#define AT91C_AC97C_OCA_CHID5 (0x7 << 6) // (AC97C) Channel ID for the output slot 5
#define AT91C_AC97C_OCA_CHID6 (0x7 << 9) // (AC97C) Channel ID for the output slot 6
#define AT91C_AC97C_OCA_CHID7 (0x7 << 12) // (AC97C) Channel ID for the output slot 7
#define AT91C_AC97C_OCA_CHID8 (0x7 << 15) // (AC97C) Channel ID for the output slot 8
#define AT91C_AC97C_OCA_CHID9 (0x7 << 18) // (AC97C) Channel ID for the output slot 9
#define AT91C_AC97C_OCA_CHID10 (0x7 << 21) // (AC97C) Channel ID for the output slot 10
#define AT91C_AC97C_OCA_CHID11 (0x7 << 24) // (AC97C) Channel ID for the output slot 11
#define AT91C_AC97C_OCA_CHID12 (0x7 << 27) // (AC97C) Channel ID for the output slot 12
// -------- AC97C_CARHR : (AC97C Offset: 0x20) Channel A Receive Holding Register --------
#define AT91C_AC97C_CARHR_RDATA (0xfffff << 0) // (AC97C) Receive Data
// -------- AC97C_CATHR : (AC97C Offset: 0x24) Channel A Transmit Holding Register --------
#define AT91C_AC97C_CATHR_TDATA (0xfffff << 0) // (AC97C) Transmit Data
// -------- AC97C_CASR : (AC97C Offset: 0x28) Channel A Status Register --------
#define AT91C_AC97C_CASR_TXRDY (0x1 << 0) // (AC97C) Channel Transmit Ready
#define AT91C_AC97C_CASR_TXEMPTY (0x1 << 1) // (AC97C) Channel Transmit Empty
#define AT91C_AC97C_CASR_UNRUN (0x1 << 2) // (AC97C) Transmit Underrun
#define AT91C_AC97C_CASR_RXRDY (0x1 << 4) // (AC97C) Channel Receive Ready
#define AT91C_AC97C_CASR_OVRUN (0x1 << 5) // (AC97C) Receive Overrun
#define AT91C_AC97C_CASR_ENDTX (0x1 << 10) // (AC97C) End of Transmission for Channel A
#define AT91C_AC97C_CASR_TXBUFE (0x1 << 11) // (AC97C) Transmit Buffer Empty for Channel A
#define AT91C_AC97C_CASR_ENDRX (0x1 << 14) // (AC97C) End of Reception for Channel A
#define AT91C_AC97C_CASR_RXBUFF (0x1 << 15) // (AC97C) Receive Buffer Full for Channel A
// -------- AC97C_CAMR : (AC97C Offset: 0x2C) Channel A Mode Register --------
#define AT91C_AC97C_CAMR_TXRDY (0x1 << 0) // (AC97C) Channel Transmit Ready Interrupt Enable
#define AT91C_AC97C_CAMR_TXEMPTY (0x1 << 1) // (AC97C) Channel Transmit Empty Interrupt Enable
#define AT91C_AC97C_CAMR_UNRUN (0x1 << 2) // (AC97C) Transmit Underrun Interrupt Enable
#define AT91C_AC97C_CAMR_RXRDY (0x1 << 4) // (AC97C) Channel Receive Ready Interrupt Enable
#define AT91C_AC97C_CAMR_OVRUN (0x1 << 5) // (AC97C) Receive Overrun Interrupt Enable
#define AT91C_AC97C_CAMR_ENDTX (0x1 << 10) // (AC97C) End of Transmission for Channel A Interrupt Enable
#define AT91C_AC97C_CAMR_TXBUFE (0x1 << 11) // (AC97C) Transmit Buffer Empty for Channel A Interrupt Enable
#define AT91C_AC97C_CAMR_ENDRX (0x1 << 14) // (AC97C) End of Reception for Channel A Interrupt Enable
#define AT91C_AC97C_CAMR_RXBUFF (0x1 << 15) // (AC97C) Receive Buffer Full for Channel A Interrupt Enable
#define AT91C_AC97C_CAMR_SIZE (0x3 << 16) // (AC97C) Channel A Data Size
#define   AT91C_AC97C_CAMR_SIZE_20_BITS (0x0 << 16) // (AC97C) 20 bits
#define   AT91C_AC97C_CAMR_SIZE_18_BITS (0x1 << 16) // (AC97C) 18 bits
#define   AT91C_AC97C_CAMR_SIZE_16_BITS (0x2 << 16) // (AC97C) 16 bits
#define   AT91C_AC97C_CAMR_SIZE_10_BITS (0x3 << 16) // (AC97C) 10 bits
#define AT91C_AC97C_CAMR_CEM (0x1 << 18) // (AC97C) Channel A Endian Mode
#define AT91C_AC97C_CAMR_CEN (0x1 << 21) // (AC97C) Channel A Enable
#define AT91C_AC97C_CAMR_PDCEN (0x1 << 22) // (AC97C) Peripheral Data Controller Channel Enable
// -------- AC97C_CBRHR : (AC97C Offset: 0x30) Channel B Receive Holding Register --------
#define AT91C_AC97C_CBRHR_RDATA (0xfffff << 0) // (AC97C) Receive Data
// -------- AC97C_CBTHR : (AC97C Offset: 0x34) Channel B Transmit Holding Register --------
#define AT91C_AC97C_CBTHR_TDATA (0xfffff << 0) // (AC97C) Transmit Data
// -------- AC97C_CBSR : (AC97C Offset: 0x38) Channel B Status Register --------
#define AT91C_AC97C_CBSR_TXRDY (0x1 << 0) // (AC97C) Channel Transmit Ready
#define AT91C_AC97C_CBSR_TXEMPTY (0x1 << 1) // (AC97C) Channel Transmit Empty
#define AT91C_AC97C_CBSR_UNRUN (0x1 << 2) // (AC97C) Transmit Underrun
#define AT91C_AC97C_CBSR_RXRDY (0x1 << 4) // (AC97C) Channel Receive Ready
#define AT91C_AC97C_CBSR_OVRUN (0x1 << 5) // (AC97C) Receive Overrun
#define AT91C_AC97C_CBSR_ENDTX (0x1 << 9) // (AC97C) End of Transmission for Channel B
#define AT91C_AC97C_CBSR_TXBUFE (0x1 << 10) // (AC97C) Transmit Buffer Empty for Channel B
#define AT91C_AC97C_CBSR_ENDRX (0x1 << 14) // (AC97C) End of Reception for Channel B
#define AT91C_AC97C_CBSR_RXBUFF (0x1 << 15) // (AC97C) Receive Buffer Full for Channel B
// -------- AC97C_CBMR : (AC97C Offset: 0x3C) Channel B Mode Register --------
#define AT91C_AC97C_CBMR_TXRDY (0x1 << 0) // (AC97C) Channel Transmit Ready Interrupt Enable
#define AT91C_AC97C_CBMR_TXEMPTY (0x1 << 1) // (AC97C) Channel Transmit Empty Interrupt Enable
#define AT91C_AC97C_CBMR_UNRUN (0x1 << 2) // (AC97C) Transmit Underrun Interrupt Enable
#define AT91C_AC97C_CBMR_RXRDY (0x1 << 4) // (AC97C) Channel Receive Ready Interrupt Enable
#define AT91C_AC97C_CBMR_OVRUN (0x1 << 5) // (AC97C) Receive Overrun Interrupt Enable
#define AT91C_AC97C_CBMR_ENDTX (0x1 << 10) // (AC97C) End of Transmission for Channel B Interrupt Enable
#define AT91C_AC97C_CBMR_TXBUFE (0x1 << 11) // (AC97C) Transmit Buffer Empty for Channel B Interrupt Enable
#define AT91C_AC97C_CBMR_ENDRX (0x1 << 14) // (AC97C) End of Reception for Channel B Interrupt Enable
#define AT91C_AC97C_CBMR_RXBUFF (0x1 << 15) // (AC97C) Receive Buffer Full for Channel B Interrupt Enable
#define AT91C_AC97C_CBMR_SIZE (0x3 << 16) // (AC97C) Channel B Data Size
#define AT91C_AC97C_CBMR_CEM (0x1 << 18) // (AC97C) Channel B Endian Mode
#define AT91C_AC97C_CBMR_CEN (0x1 << 21) // (AC97C) Channel B Enable
#define AT91C_AC97C_CBMR_PDCEN (0x1 << 22) // (AC97C) Peripheral Data Controller Channel Enable
// -------- AC97C_CORHR : (AC97C Offset: 0x40) Codec Channel Receive Holding Register --------
#define AT91C_AC97C_CORHR_SDATA (0xffff << 0) // (AC97C) Status Data
// -------- AC97C_COTHR : (AC97C Offset: 0x44) Codec Channel Transmit Holding Register --------
#define AT91C_AC97C_COTHR_CDATA (0xffff << 0) // (AC97C) Command Data
#define AT91C_AC97C_COTHR_CADDR (0x7f << 16) // (AC97C) CODEC control register index
#define AT91C_AC97C_COTHR_READ (0x1 << 23) // (AC97C) Read-write command
// -------- AC97C_COSR : (AC97C Offset: 0x48) Codec Status Register --------
#define AT91C_AC97C_COSR_TXRDY (0x1 << 0) // (AC97C) Channel Transmit Ready
#define AT91C_AC97C_COSR_TXEMPTY (0x1 << 1) // (AC97C) Channel Transmit Empty
#define AT91C_AC97C_COSR_UNRUN (0x1 << 2) // (AC97C) Transmit Underrun
#define AT91C_AC97C_COSR_RXRDY (0x1 << 4) // (AC97C) Channel Receive Ready
#define AT91C_AC97C_COSR_OVRUN (0x1 << 5) // (AC97C) Receive Overrun
// -------- AC97C_COMR : (AC97C Offset: 0x4C) Codec Mode Register --------
#define AT91C_AC97C_COMR_TXRDY (0x1 << 0) // (AC97C) Channel Transmit Ready Interrupt Enable
#define AT91C_AC97C_COMR_TXEMPTY (0x1 << 1) // (AC97C) Channel Transmit Empty Interrupt Enable
#define AT91C_AC97C_COMR_UNRUN (0x1 << 2) // (AC97C) Transmit Underrun Interrupt Enable
#define AT91C_AC97C_COMR_RXRDY (0x1 << 4) // (AC97C) Channel Receive Ready Interrupt Enable
#define AT91C_AC97C_COMR_OVRUN (0x1 << 5) // (AC97C) Receive Overrun Interrupt Enable
// -------- AC97C_SR : (AC97C Offset: 0x50) Status Register --------
#define AT91C_AC97C_SR_SOF (0x1 << 0) // (AC97C) Start Of Frame
#define AT91C_AC97C_SR_WKUP (0x1 << 1) // (AC97C) Wake Up detection
#define AT91C_AC97C_SR_COEVT (0x1 << 2) // (AC97C) CODEC Channel Event
#define AT91C_AC97C_SR_CAEVT (0x1 << 3) // (AC97C) Channel A Event
#define AT91C_AC97C_SR_CBEVT (0x1 << 4) // (AC97C) Channel B Event
// -------- AC97C_IER : (AC97C Offset: 0x54) Interrupt Enable Register --------
// -------- AC97C_IDR : (AC97C Offset: 0x58) Interrupt Disable Register --------
#define AT91C_AC97C_IDR_SOF (0x1 << 0) // (AC97C) Start Of Frame
#define AT91C_AC97C_IDR_WKUP (0x1 << 1) // (AC97C) Wake Up
#define AT91C_AC97C_IDR_COEVT (0x1 << 2) // (AC97C) Codec Event
#define AT91C_AC97C_IDR_CAEVT (0x1 << 3) // (AC97C) Channel A Event
#define AT91C_AC97C_IDR_CBEVT (0x1 << 4) // (AC97C) Channel B Event
// -------- AC97C_IMR : (AC97C Offset: 0x5C) Interrupt Mask Register --------
#define AT91C_AC97C_IMR_SOF (0x1 << 0) // (AC97C) Start Of Frame
#define AT91C_AC97C_IMR_WKUP (0x1 << 1) // (AC97C) Wake Up
#define AT91C_AC97C_IMR_COEVT (0x1 << 2) // (AC97C) Codec Event
#define AT91C_AC97C_IMR_CAEVT (0x1 << 3) // (AC97C) Channel A Event
#define AT91C_AC97C_IMR_CBEVT (0x1 << 4) // (AC97C) Channel B Event
// -------- AC97C_RPR : (AC97C Offset: 0x100) Receive Pointer Register --------
#define AT91C_AC97C_RPR_RXPTR (0xffffffff << 0) // (AC97C) Receive Pointer Register
// -------- AC97C_RCR : (AC97C Offset: 0x104) Receive Counter Register --------
#define AT91C_AC97C_RCR_RXCTR (0xffff << 0) // (AC97C) Receive Counter Register
// -------- AC97C_TPR : (AC97C Offset: 0x108) Transmit Pointer Register --------
#define AT91C_AC97C_TPR_TXPTR (0xffffffff << 0) // (AC97C) Transmit Counter Register
// -------- AC97C_TCR : (AC97C Offset: 0x10C) Transmit Counter Register --------
#define AT91C_AC97C_TCR_TXCTR (0xffff << 0) // (AC97C) Transmit Counter Register
// -------- AC97C_RNPR : (AC97C Offset: 0x110) Receive Next Pointer Register --------
#define AT91C_AC97C_RNPR_RXNPTR (0xffffffff << 0) // (AC97C) Receive Next Pointer
// -------- AC97C_RNCR : (AC97C Offset: 0x114) Receive Next Counter Register --------
#define AT91C_AC97C_RNCR_RXNCTR (0xffff << 0) // (AC97C) Receive Next Counter
// -------- AC97C_TNPR : (AC97C Offset: 0x118) Transmit Next Pointer Register --------
#define AT91C_AC97C_TNPR_TXNPTR (0xffffffff << 0) // (AC97C) Transmit Next Pointer
// -------- AC97C_TNCR : (AC97C Offset: 0x11C) Transmit Next Counter Register --------
#define AT91C_AC97C_TNCR_TXNCTR (0xffff << 0) // (AC97C) Transmit Counter Next
// -------- AC97C_PTCR : (AC97C Offset: 0x120) Transfer Control Register --------
#define AT91C_AC97C_PTCR_RXTEN (0x1 << 0) // (AC97C) Receiver Transfer Enable
#define AT91C_AC97C_PTCR_RXTDIS (0x1 << 1) // (AC97C) Receiver Transfer Disable
#define AT91C_AC97C_PTCR_TXTEN (0x1 << 8) // (AC97C) Transmitter Transfer Enable
#define AT91C_AC97C_PTCR_TXTDIS (0x1 << 9) // (AC97C) Transmitter Transfer Disable
// -------- AC97C_PTSR : (AC97C Offset: 0x124) Transfer Status Register --------
#define AT91C_AC97C_PTSR_RXTEN (0x1 << 0) // (AC97C) Receiver Transfer Enable
#define AT91C_AC97C_PTSR_TXTEN (0x1 << 8) // (AC97C) Transmitter Transfer Enable

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Advanced Encryption Standard
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_AES {
  AT91_REG AES_CR;        // Control Register
  AT91_REG AES_MR;        // Mode Register
  AT91_REG Reserved1[2];
  AT91_REG AES_IER;       // Interrupt Enable Register
  AT91_REG AES_IDR;       // Interrupt Disable Register
  AT91_REG AES_IMR;       // Interrupt Mask Register
  AT91_REG AES_ISR;       // Interrupt Status Register
  AT91_REG AES_KEYWR[8];  // Key Word Register
  AT91_REG AES_IDATAR[4]; // Input Data Register
  AT91_REG AES_ODATAR[4]; // Output Data Register
  AT91_REG AES_IVR[4];    // Initialization Vector Register
} AT91S_AES, *AT91PS_AES;
#else
#define AES_CR     (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define AES_MR     (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define AES_IER    (AT91_CAST(AT91_REG *) 0x00000010) // Interrupt Enable Register
#define AES_IDR    (AT91_CAST(AT91_REG *) 0x00000014) // Interrupt Disable Register
#define AES_IMR    (AT91_CAST(AT91_REG *) 0x00000018) // Interrupt Mask Register
#define AES_ISR    (AT91_CAST(AT91_REG *) 0x0000001C) // Interrupt Status Register
#define AES_KEYWR  (AT91_CAST(AT91_REG *) 0x00000020) // Key Word Register
#define AES_IDATAR (AT91_CAST(AT91_REG *) 0x00000040) // Input Data Register
#define AES_ODATAR (AT91_CAST(AT91_REG *) 0x00000050) // Output Data Register
#define AES_IVR    (AT91_CAST(AT91_REG *) 0x00000060) // Initialization Vector Register
#endif
// -------- AES_CR : (AES Offset: 0x00) Control Register --------
#define AT91C_AES_CR_START (0x1 << 0) // (AES) Start Processing
#define AT91C_AES_CR_SWRST (0x1 << 8) // (AES) Software Reset
#define AT91C_AES_CR_LOADSEED (0x1 << 16) // (AES) Random Number Generator Seed Loading
// -------- AES_MR : (AES Offset: 0x04) Mode Register --------
#define AT91C_AES_MR_CIPHER (0x1 << 0) // (AES) Processing Mode
#define AT91C_AES_MR_PROCDLY (0xf << 4) // (AES) Processing Delay
#define AT91C_AES_MR_SMOD (0x3 << 8) // (AES) Start Mode
#define AT91C_AES_MR_KEYSIZE (0x3 << 10) // (AES) Key Size
#define AT91C_AES_MR_OPMOD (0x7 << 12) // (AES) Operation Mode
#define AT91C_AES_MR_LOD (0x1 << 15) // (AES) Last Output Data Mode
#define AT91C_AES_MR_CFBS (0x7 << 16) // (AES) Cipher Feedback Data Size
#define AT91C_AES_MR_CKEY (0xf << 20) // (AES) Countermeasure Key
#define AT91C_AES_MR_CTYPE (0x1f << 24) // (AES) Countermeasure Type
// -------- AES_IER : (AES Offset: 0x10) Interrupt Enable Register --------
#define AT91C_AES_IER_DATRDY (0x1 << 0) // (AES) Data Ready Interrupt Enable
#define AT91C_AES_IER_ENDRX (0x1 << 1) // (AES) End of Receive Buffer Interrupt Enable
#define AT91C_AES_IER_ENDTX (0x1 << 2) // (AES) End of Transmit Buffer Interrupt Enable
#define AT91C_AES_IER_RXBUFF (0x1 << 3) // (AES) Receive Buffer Full Interrupt Enable
#define AT91C_AES_IER_TXBUFE (0x1 << 4) // (AES) Transmit Buffer Empty Interrupt Enable
#define AT91C_AES_IER_URAD (0x1 << 8) // (AES) Unspecified Register Access Detection Interrupt Enable
// -------- AES_IDR : (AES Offset: 0x14) Interrupt Disable Register --------
#define AT91C_AES_IDR_DATRDY (0x1 << 0) // (AES) Data Ready Interrupt Disable
#define AT91C_AES_IDR_ENDRX (0x1 << 1) // (AES) End of Receive Buffer Interrupt Disable
#define AT91C_AES_IDR_ENDTX (0x1 << 2) // (AES) End of Transmit Buffer Interrupt Disable
#define AT91C_AES_IDR_RXBUFF (0x1 << 3) // (AES) Receive Buffer Full Interrupt Disable
#define AT91C_AES_IDR_TXBUFE (0x1 << 4) // (AES) Transmit Buffer Empty Interrupt Disable
#define AT91C_AES_IDR_URAD (0x1 << 8) // (AES) Unspecified Register Access Detection Interrupt Disable
// -------- AES_IMR : (AES Offset: 0x18) Interrupt Mask Register --------
#define AT91C_AES_IMR_DATRDY (0x1 << 0) // (AES) Data Ready Interrupt Mask
#define AT91C_AES_IMR_ENDRX (0x1 << 1) // (AES) End of Receive Buffer Interrupt Mask
#define AT91C_AES_IMR_ENDTX (0x1 << 2) // (AES) End of Transmit Buffer Interrupt Mask
#define AT91C_AES_IMR_RXBUFF (0x1 << 3) // (AES) Receive Buffer Full Interrupt Mask
#define AT91C_AES_IMR_TXBUFE (0x1 << 4) // (AES) Transmit Buffer Empty Interrupt Mask
#define AT91C_AES_IMR_URAD (0x1 << 8) // (AES) Unspecified Register Access Detection Interrupt Mask
// -------- AES_ISR : (AES Offset: 0x1C) Interrupt Status Register --------
#define AT91C_AES_ISR_DATRDY (0x1 << 0) // (AES) Data Ready
#define AT91C_AES_ISR_ENDRX (0x1 << 1) // (AES) End of RX Buffer
#define AT91C_AES_ISR_ENDTX (0x1 << 2) // (AES) End of TX Buffer
#define AT91C_AES_ISR_RXBUFF (0x1 << 3) // (AES) RX Buffer Full
#define AT91C_AES_ISR_TXBUFE (0x1 << 4) // (AES) TX Buffer Empty
#define AT91C_AES_ISR_URAD (0x1 << 8) // (AES) Unspecified Register Access Detection Status
#define AT91C_AES_ISR_URAT (0xf << 12) // (AES) Unspecified Register Access Type:
// -------- AES_KEYWR[8] : (AES Offset: 0x20) Key Word Register --------
#define AT91C_AES_KEYWR_KEYWx (0xffffffff << 0) // (AES) Key Word x
// -------- AES_IDATAR[4] : (AES Offset: 0x40) Input Data Register --------
#define AT91C_AES_IDATAR_IDATAx (0xffffffff << 0) // (AES) Input Data Word x
// -------- AES_ODATAR[4] : (AES Offset: 0x50) Output Data Register --------
#define AT91C_AES_ODATAR_ODATAx (0xffffffff << 0) // (AES) Output Data x
// -------- AES_IVR[4] : (AES Offset: 0x60) Initialization Vector Register --------
#define AT91C_AES_IVR_IVx (0xffffffff << 0) // (AES) Initialization Vector x

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Advanced Interrupt Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_AIC {
  AT91_REG AIC_SMR[32];  // Source Mode Register
  AT91_REG AIC_SVR[32];  // Source Vector Register
  AT91_REG AIC_IVR;      // Interrupt Vector Register
  AT91_REG AIC_FVR;      // FIQ Interrupt Vector Register
  AT91_REG AIC_ISR;      // Interrupt Status Register
  AT91_REG AIC_IPR;      // Interrupt Pending Register
  AT91_REG AIC_IMR;      // Interrupt Mask Register
  AT91_REG AIC_CISR;     // Core Interrupt Status Register
  AT91_REG Reserved1[2];
  AT91_REG AIC_IECR;     // Interrupt Enable Command Register
  AT91_REG AIC_IDCR;     // Interrupt Disable Command Register
  AT91_REG AIC_ICCR;     // Interrupt Clear Command Register
  AT91_REG AIC_ISCR;     // Interrupt Set Command Register
  AT91_REG AIC_EOICR;    // End of Interrupt Command Register
  AT91_REG AIC_SPU;      // Spurious Interrupt Vector Register
  AT91_REG AIC_DCR;      // Debug Control Register
  AT91_REG Reserved2[1];
  AT91_REG AIC_FFER;     // Fast Forcing Enable Register
  AT91_REG AIC_FFDR;     // Fast Forcing Disable Register
  AT91_REG AIC_FFSR;     // Fast Forcing Status Register
} AT91S_AIC, *AT91PS_AIC;
#else
#define AIC_SMR   (AT91_CAST(AT91_REG *) 0x00000000) // Source Mode Register
#define AIC_SVR   (AT91_CAST(AT91_REG *) 0x00000080) // Source Vector Register
#define AIC_IVR   (AT91_CAST(AT91_REG *) 0x00000100) // Interrupt Vector Register
#define AIC_FVR   (AT91_CAST(AT91_REG *) 0x00000104) // FIQ Interrupt Vector Register
#define AIC_ISR   (AT91_CAST(AT91_REG *) 0x00000108) // Interrupt Status Register
#define AIC_IPR   (AT91_CAST(AT91_REG *) 0x0000010C) // Interrupt Pending Register
#define AIC_IMR   (AT91_CAST(AT91_REG *) 0x00000110) // Interrupt Mask Register
#define AIC_CISR  (AT91_CAST(AT91_REG *) 0x00000114) // Core Interrupt Status Register
#define AIC_IECR  (AT91_CAST(AT91_REG *) 0x00000120) // Interrupt Enable Command Register
#define AIC_IDCR  (AT91_CAST(AT91_REG *) 0x00000124) // Interrupt Disable Command Register
#define AIC_ICCR  (AT91_CAST(AT91_REG *) 0x00000128) // Interrupt Clear Command Register
#define AIC_ISCR  (AT91_CAST(AT91_REG *) 0x0000012C) // Interrupt Set Command Register
#define AIC_EOICR (AT91_CAST(AT91_REG *) 0x00000130) // End of Interrupt Command Register
#define AIC_SPU   (AT91_CAST(AT91_REG *) 0x00000134) // Spurious Interrupt Vector Register
#define AIC_DCR   (AT91_CAST(AT91_REG *) 0x00000138) // Debug Control Register
#define AIC_FFER  (AT91_CAST(AT91_REG *) 0x00000140) // Fast Forcing Enable Register
#define AIC_FFDR  (AT91_CAST(AT91_REG *) 0x00000144) // Fast Forcing Disable Register
#define AIC_FFSR  (AT91_CAST(AT91_REG *) 0x00000148) // Fast Forcing Status Register
#endif
// -------- AIC_SMR[32] : (AIC Offset: 0x00) Source Mode Register --------
#define AT91C_AIC_SMR_PRIOR       ( 0x7 <<  0) // (AIC) Priority Level
#define     AT91C_AIC_SMR_PRIOR_LOWEST               ( 0x0) // (AIC) Lowest priority level
#define     AT91C_AIC_SMR_PRIOR_HIGHEST              ( 0x7) // (AIC) Highest priority level
#define AT91C_AIC_SMR_SRCTYPE     ( 0x3 <<  5) // (AIC) Interrupt Source Type
#define     AT91C_AIC_SMR_SRCTYPE_INT_LEVEL_SENSITIVE  ( 0x0 <<  5) // (AIC) Internal Sources Code Label Level Sensitive
#define     AT91C_AIC_SMR_SRCTYPE_INT_EDGE_TRIGGERED   ( 0x1 <<  5) // (AIC) Internal Sources Code Label Edge triggered
#define     AT91C_AIC_SMR_SRCTYPE_EXT_HIGH_LEVEL       ( 0x2 <<  5) // (AIC) External Sources Code Label High-level Sensitive
#define     AT91C_AIC_SMR_SRCTYPE_EXT_POSITIVE_EDGE    ( 0x3 <<  5) // (AIC) External Sources Code Label Positive Edge triggered
// -------- AIC_SVR[32] : (AIC Offset: 0x80) Source Vector Register --------
#define AT91C_AIC_SVR_VECTOR (0xffffffff << 0) // (AIC) Source Vector
// -------- AIC_IVR : (AIC Offset: 0x100) Interrupt Vector Register --------
#define AT91C_AIC_IVR_IRQV (0xffffffff << 0) // (AIC) Interrupt Vector Register
// -------- AIC_FVR : (AIC Offset: 0x104) FIQ Interrupt Vector Register --------
#define AT91C_AIC_FVR_FIQV (0xffffffff << 0) // (AIC) FIQ Vector Register
// -------- AIC_ISR : (AIC Offset: 0x108) Interrupt Status Register --------
#define AT91C_AIC_ISR_IRQID (0x1f << 0) // (AIC) Current Interrupt Identifier
// -------- AIC_IPR : (AIC Offset: 0x10C) Interrupt Pending Register --------
#define AT91C_AIC_IPR_FIQ (0x1 << 0) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_SYS (0x1 << 1) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID2 (0x1 << 2) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID3 (0x1 << 3) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID4 (0x1 << 4) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID5 (0x1 << 5) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID6 (0x1 << 6) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID7 (0x1 << 7) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID8 (0x1 << 8) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID9 (0x1 << 9) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID10 (0x1 << 10) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID11 (0x1 << 11) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID12 (0x1 << 12) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID13 (0x1 << 13) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID14 (0x1 << 14) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID15 (0x1 << 15) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID16 (0x1 << 16) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID17 (0x1 << 17) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID18 (0x1 << 18) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID19 (0x1 << 19) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID20 (0x1 << 20) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID21 (0x1 << 21) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID22 (0x1 << 22) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID23 (0x1 << 23) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID24 (0x1 << 24) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID25 (0x1 << 25) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID26 (0x1 << 26) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID27 (0x1 << 27) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID28 (0x1 << 28) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID29 (0x1 << 29) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID30 (0x1 << 30) // (AIC) Interrupt Pending
#define AT91C_AIC_IPR_PID31 (0x1 << 31) // (AIC) Interrupt Pending
// -------- AIC_IMR : (AIC Offset: 0x110) Interrupt Mask Register --------
#define AT91C_AIC_IMR_FIQ (0x1 << 0) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_SYS (0x1 << 1) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID2 (0x1 << 2) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID3 (0x1 << 3) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID4 (0x1 << 4) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID5 (0x1 << 5) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID6 (0x1 << 6) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID7 (0x1 << 7) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID8 (0x1 << 8) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID9 (0x1 << 9) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID10 (0x1 << 10) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID11 (0x1 << 11) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID12 (0x1 << 12) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID13 (0x1 << 13) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID14 (0x1 << 14) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID15 (0x1 << 15) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID16 (0x1 << 16) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID17 (0x1 << 17) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID18 (0x1 << 18) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID19 (0x1 << 19) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID20 (0x1 << 20) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID21 (0x1 << 21) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID22 (0x1 << 22) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID23 (0x1 << 23) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID24 (0x1 << 24) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID25 (0x1 << 25) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID26 (0x1 << 26) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID27 (0x1 << 27) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID28 (0x1 << 28) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID29 (0x1 << 29) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID30 (0x1 << 30) // (AIC) Interrupt Mask
#define AT91C_AIC_IMR_PID31 (0x1 << 31) // (AIC) Interrupt Mask
// -------- AIC_CISR : (AIC Offset: 0x114) Core Interrupt Status Register --------
#define AT91C_AIC_CISR_NFIQ (0x1 << 0) // (AIC) NFIQ Status
#define AT91C_AIC_CISR_NIRQ (0x1 << 1) // (AIC) NIRQ Status
// -------- AIC_IECR : (AIC Offset: 0x120) Interrupt Enable Command Register --------
#define AT91C_AIC_IECR_FIQ (0x1 << 0) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_SYS (0x1 << 1) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID2 (0x1 << 2) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID3 (0x1 << 3) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID4 (0x1 << 4) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID5 (0x1 << 5) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID6 (0x1 << 6) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID7 (0x1 << 7) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID8 (0x1 << 8) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID9 (0x1 << 9) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID10 (0x1 << 10) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID11 (0x1 << 11) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID12 (0x1 << 12) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID13 (0x1 << 13) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID14 (0x1 << 14) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID15 (0x1 << 15) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID16 (0x1 << 16) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID17 (0x1 << 17) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID18 (0x1 << 18) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID19 (0x1 << 19) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID20 (0x1 << 20) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID21 (0x1 << 21) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID22 (0x1 << 22) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID23 (0x1 << 23) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID24 (0x1 << 24) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID25 (0x1 << 25) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID26 (0x1 << 26) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID27 (0x1 << 27) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID28 (0x1 << 28) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID29 (0x1 << 29) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID30 (0x1 << 30) // (AIC) Interrupt Enable
#define AT91C_AIC_IECR_PID31 (0x1 << 31) // (AIC) Interrupt Enable
// -------- AIC_IDCR : (AIC Offset: 0x124) Interrupt Disable Command Register --------
#define AT91C_AIC_IDCR_FIQ (0x1 << 0) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_SYS (0x1 << 1) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID2 (0x1 << 2) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID3 (0x1 << 3) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID4 (0x1 << 4) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID5 (0x1 << 5) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID6 (0x1 << 6) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID7 (0x1 << 7) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID8 (0x1 << 8) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID9 (0x1 << 9) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID10 (0x1 << 10) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID11 (0x1 << 11) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID12 (0x1 << 12) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID13 (0x1 << 13) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID14 (0x1 << 14) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID15 (0x1 << 15) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID16 (0x1 << 16) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID17 (0x1 << 17) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID18 (0x1 << 18) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID19 (0x1 << 19) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID20 (0x1 << 20) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID21 (0x1 << 21) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID22 (0x1 << 22) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID23 (0x1 << 23) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID24 (0x1 << 24) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID25 (0x1 << 25) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID26 (0x1 << 26) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID27 (0x1 << 27) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID28 (0x1 << 28) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID29 (0x1 << 29) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID30 (0x1 << 30) // (AIC) Interrupt Disable
#define AT91C_AIC_IDCR_PID31 (0x1 << 31) // (AIC) Interrupt Disable
// -------- AIC_ICCR : (AIC Offset: 0x128) Interrupt Clear Command Register --------
#define AT91C_AIC_ICCR_FIQ (0x1 << 0) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_SYS (0x1 << 1) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID2 (0x1 << 2) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID3 (0x1 << 3) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID4 (0x1 << 4) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID5 (0x1 << 5) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID6 (0x1 << 6) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID7 (0x1 << 7) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID8 (0x1 << 8) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID9 (0x1 << 9) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID10 (0x1 << 10) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID11 (0x1 << 11) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID12 (0x1 << 12) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID13 (0x1 << 13) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID14 (0x1 << 14) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID15 (0x1 << 15) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID16 (0x1 << 16) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID17 (0x1 << 17) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID18 (0x1 << 18) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID19 (0x1 << 19) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID20 (0x1 << 20) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID21 (0x1 << 21) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID22 (0x1 << 22) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID23 (0x1 << 23) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID24 (0x1 << 24) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID25 (0x1 << 25) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID26 (0x1 << 26) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID27 (0x1 << 27) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID28 (0x1 << 28) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID29 (0x1 << 29) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID30 (0x1 << 30) // (AIC) Interrupt Clear
#define AT91C_AIC_ICCR_PID31 (0x1 << 31) // (AIC) Interrupt Clear
// -------- AIC_ISCR : (AIC Offset: 0x12C) Interrupt Set Command Register --------
#define AT91C_AIC_ISCR_FIQ (0x1 << 0) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_SYS (0x1 << 1) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID2 (0x1 << 2) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID3 (0x1 << 3) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID4 (0x1 << 4) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID5 (0x1 << 5) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID6 (0x1 << 6) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID7 (0x1 << 7) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID8 (0x1 << 8) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID9 (0x1 << 9) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID10 (0x1 << 10) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID11 (0x1 << 11) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID12 (0x1 << 12) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID13 (0x1 << 13) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID14 (0x1 << 14) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID15 (0x1 << 15) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID16 (0x1 << 16) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID17 (0x1 << 17) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID18 (0x1 << 18) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID19 (0x1 << 19) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID20 (0x1 << 20) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID21 (0x1 << 21) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID22 (0x1 << 22) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID23 (0x1 << 23) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID24 (0x1 << 24) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID25 (0x1 << 25) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID26 (0x1 << 26) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID27 (0x1 << 27) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID28 (0x1 << 28) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID29 (0x1 << 29) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID30 (0x1 << 30) // (AIC) Interrupt Set
#define AT91C_AIC_ISCR_PID31 (0x1 << 31) // (AIC) Interrupt Set
// -------- AIC_EOICR : (AIC Offset: 0x130) End of Interrupt Command Register --------
// -------- AIC_SPU : (AIC Offset: 0x134) Spurious Interrupt Vector Register --------
#define AT91C_AIC_SPU_SIVR (0xffffffff << 0) // (AIC) Spurious Interrupt Vector Register
// -------- AIC_DCR : (AIC Offset: 0x138) Debug Control Register --------
#define AT91C_AIC_DCR_PROT (0x1 << 0) // (AIC) Protection Mode
#define AT91C_AIC_DCR_GMSK (0x1 << 1) // (AIC) General Mask
// -------- AIC_FFER : (AIC Offset: 0x140) Fast Forcing Enable Register --------
#define AT91C_AIC_FFER_SYS (0x1 << 1) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID2 (0x1 << 2) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID3 (0x1 << 3) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID4 (0x1 << 4) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID5 (0x1 << 5) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID6 (0x1 << 6) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID7 (0x1 << 7) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID8 (0x1 << 8) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID9 (0x1 << 9) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID10 (0x1 << 10) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID11 (0x1 << 11) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID12 (0x1 << 12) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID13 (0x1 << 13) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID14 (0x1 << 14) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID15 (0x1 << 15) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID16 (0x1 << 16) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID17 (0x1 << 17) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID18 (0x1 << 18) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID19 (0x1 << 19) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID20 (0x1 << 20) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID21 (0x1 << 21) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID22 (0x1 << 22) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID23 (0x1 << 23) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID24 (0x1 << 24) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID25 (0x1 << 25) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID26 (0x1 << 26) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID27 (0x1 << 27) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID28 (0x1 << 28) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID29 (0x1 << 29) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID30 (0x1 << 30) // (AIC) Fast Forcing Enable
#define AT91C_AIC_FFER_PID31 (0x1 << 31) // (AIC) Fast Forcing Enable
// -------- AIC_FFDR : (AIC Offset: 0x144) Fast Forcing Disable Register --------
#define AT91C_AIC_FFDR_SYS (0x1 << 1) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID2 (0x1 << 2) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID3 (0x1 << 3) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID4 (0x1 << 4) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID5 (0x1 << 5) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID6 (0x1 << 6) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID7 (0x1 << 7) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID8 (0x1 << 8) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID9 (0x1 << 9) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID10 (0x1 << 10) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID11 (0x1 << 11) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID12 (0x1 << 12) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID13 (0x1 << 13) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID14 (0x1 << 14) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID15 (0x1 << 15) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID16 (0x1 << 16) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID17 (0x1 << 17) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID18 (0x1 << 18) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID19 (0x1 << 19) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID20 (0x1 << 20) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID21 (0x1 << 21) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID22 (0x1 << 22) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID23 (0x1 << 23) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID24 (0x1 << 24) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID25 (0x1 << 25) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID26 (0x1 << 26) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID27 (0x1 << 27) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID28 (0x1 << 28) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID29 (0x1 << 29) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID30 (0x1 << 30) // (AIC) Fast Forcing Disable
#define AT91C_AIC_FFDR_PID31 (0x1 << 31) // (AIC) Fast Forcing Disable
// -------- AIC_FFSR : (AIC Offset: 0x148) Fast Forcing Status Register --------
#define AT91C_AIC_FFSR_SYS (0x1 << 1) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID2 (0x1 << 2) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID3 (0x1 << 3) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID4 (0x1 << 4) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID5 (0x1 << 5) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID6 (0x1 << 6) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID7 (0x1 << 7) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID8 (0x1 << 8) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID9 (0x1 << 9) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID10 (0x1 << 10) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID11 (0x1 << 11) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID12 (0x1 << 12) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID13 (0x1 << 13) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID14 (0x1 << 14) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID15 (0x1 << 15) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID16 (0x1 << 16) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID17 (0x1 << 17) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID18 (0x1 << 18) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID19 (0x1 << 19) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID20 (0x1 << 20) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID21 (0x1 << 21) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID22 (0x1 << 22) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID23 (0x1 << 23) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID24 (0x1 << 24) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID25 (0x1 << 25) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID26 (0x1 << 26) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID27 (0x1 << 27) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID28 (0x1 << 28) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID29 (0x1 << 29) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID30 (0x1 << 30) // (AIC) Fast Forcing Status
#define AT91C_AIC_FFSR_PID31 (0x1 << 31) // (AIC) Fast Forcing Status

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Debug Unit
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_DBGU {
  AT91_REG DBGU_CR;       // Control Register
  AT91_REG DBGU_MR;       // Mode Register
  AT91_REG DBGU_IER;      // Interrupt Enable Register
  AT91_REG DBGU_IDR;      // Interrupt Disable Register
  AT91_REG DBGU_IMR;      // Interrupt Mask Register
  AT91_REG DBGU_SR;       // Status Register
  AT91_REG DBGU_RHR;      // Receive Holding Register
  AT91_REG DBGU_THR;      // Transmit Holding Register
  AT91_REG DBGU_BRGR;     // Baud Rate Generator Register
  AT91_REG Reserved1[7];
  AT91_REG DBGU_CIDR;     // Chip ID Register
  AT91_REG DBGU_EXID;     // Chip ID Extension Register
  AT91_REG DBGU_FNR;      // Force NTRST Register
  AT91_REG Reserved2[45];
  AT91_REG DBGU_RPR;      // Receive Pointer Register
  AT91_REG DBGU_RCR;      // Receive Counter Register
  AT91_REG DBGU_TPR;      // Transmit Pointer Register
  AT91_REG DBGU_TCR;      // Transmit Counter Register
  AT91_REG DBGU_RNPR;     // Receive Next Pointer Register
  AT91_REG DBGU_RNCR;     // Receive Next Counter Register
  AT91_REG DBGU_TNPR;     // Transmit Next Pointer Register
  AT91_REG DBGU_TNCR;     // Transmit Next Counter Register
  AT91_REG DBGU_PTCR;     // Transfer Control Register
  AT91_REG DBGU_PTSR;     // Transfer Status Register
} AT91S_DBGU, *AT91PS_DBGU;
#else
#define DBGU_CR   (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define DBGU_MR   (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define DBGU_IER  (AT91_CAST(AT91_REG *) 0x00000008) // Interrupt Enable Register
#define DBGU_IDR  (AT91_CAST(AT91_REG *) 0x0000000C) // Interrupt Disable Register
#define DBGU_IMR  (AT91_CAST(AT91_REG *) 0x00000010) // Interrupt Mask Register
#define DBGU_SR   (AT91_CAST(AT91_REG *) 0x00000014) // Status Register
#define DBGU_RHR  (AT91_CAST(AT91_REG *) 0x00000018) // Receive Holding Register
#define DBGU_THR  (AT91_CAST(AT91_REG *) 0x0000001C) // Transmit Holding Register
#define DBGU_BRGR (AT91_CAST(AT91_REG *) 0x00000020) // Baud Rate Generator Register
#define DBGU_CIDR (AT91_CAST(AT91_REG *) 0x00000040) // Chip ID Register
#define DBGU_EXID (AT91_CAST(AT91_REG *) 0x00000044) // Chip ID Extension Register
#define DBGU_FNR  (AT91_CAST(AT91_REG *) 0x00000048) // Force NTRST Register
#define DBGU_RPR  (AT91_CAST(AT91_REG *) 0x00000100) // Receive Pointer Register
#define DBGU_RCR  (AT91_CAST(AT91_REG *) 0x00000104) // Receive Counter Register
#define DBGU_TPR  (AT91_CAST(AT91_REG *) 0x00000108) // Transmit Pointer Register
#define DBGU_TCR  (AT91_CAST(AT91_REG *) 0x0000010C) // Transmit Counter Register
#define DBGU_RNPR (AT91_CAST(AT91_REG *) 0x00000110) // Receive Next Pointer Register
#define DBGU_RNCR (AT91_CAST(AT91_REG *) 0x00000114) // Receive Next Counter Register
#define DBGU_TNPR (AT91_CAST(AT91_REG *) 0x00000118) // Transmit Next Pointer Register
#define DBGU_TNCR (AT91_CAST(AT91_REG *) 0x0000011C) // Transmit Next Counter Register
#define DBGU_PTCR (AT91_CAST(AT91_REG *) 0x00000120) // Transfer Control Register
#define DBGU_PTSR (AT91_CAST(AT91_REG *) 0x00000124) // Transfer Status Register
#endif
// -------- DBGU_CR : (DBGU Offset: 0x0000) Control Register --------
#define AT91C_DBGU_CR_RSTRX (0x1 << 2) // (DBGU) Reset Receiver
#define AT91C_DBGU_CR_RSTTX (0x1 << 3) // (DBGU) Reset Transmitter
#define AT91C_DBGU_CR_RXEN (0x1 << 4) // (DBGU) Receiver Enable
#define AT91C_DBGU_CR_RXDIS (0x1 << 5) // (DBGU) Receiver Disable
#define AT91C_DBGU_CR_TXEN (0x1 << 6) // (DBGU) Transmitter Enable
#define AT91C_DBGU_CR_TXDIS (0x1 << 7) // (DBGU) Transmitter Disable
#define AT91C_DBGU_CR_RSTSTA (0x1 << 8) // (DBGU) Reset Status Bits
// -------- DBGU_MR : (DBGU Offset: 0x0004) Mode Register --------
#define AT91C_DBGU_MR_USMODE       ( 0xF <<  0) // (USART) Usart mode
#define     AT91C_DBGU_MR_USMODE_NORMAL               ( 0x0) // (USART) Normal
#define     AT91C_DBGU_MR_USMODE_RS485                ( 0x1) // (USART) RS485
#define     AT91C_DBGU_MR_USMODE_HWHSH                ( 0x2) // (USART) Hardware Handshaking
#define     AT91C_DBGU_MR_USMODE_MODEM                ( 0x3) // (USART) Modem
#define     AT91C_DBGU_MR_USMODE_ISO7816_0            ( 0x4) // (USART) ISO7816 protocol: T = 0
#define     AT91C_DBGU_MR_USMODE_ISO7816_1            ( 0x6) // (USART) ISO7816 protocol: T = 1
#define     AT91C_DBGU_MR_USMODE_IRDA                 ( 0x8) // (USART) IrDA
#define     AT91C_DBGU_MR_USMODE_SWHSH                ( 0xC) // (USART) Software Handshaking
#define AT91C_DBGU_MR_CLKS         ( 0x3 <<  4) // (USART) Clock Selection (Baud Rate generator Input Clock
#define     AT91C_DBGU_MR_CLKS_CLOCK                ( 0x0 <<  4) // (USART) Clock
#define     AT91C_DBGU_MR_CLKS_FDIV1                ( 0x1 <<  4) // (USART) fdiv1
#define     AT91C_DBGU_MR_CLKS_SLOW                 ( 0x2 <<  4) // (USART) slow_clock (ARM)
#define     AT91C_DBGU_MR_CLKS_EXT                  ( 0x3 <<  4) // (USART) External (SCK)
#define AT91C_DBGU_MR_CHRL         ( 0x3 <<  6) // (USART) Clock Selection (Baud Rate generator Input Clock
#define     AT91C_DBGU_MR_CHRL_5_BITS               ( 0x0 <<  6) // (USART) Character Length: 5 bits
#define     AT91C_DBGU_MR_CHRL_6_BITS               ( 0x1 <<  6) // (USART) Character Length: 6 bits
#define     AT91C_DBGU_MR_CHRL_7_BITS               ( 0x2 <<  6) // (USART) Character Length: 7 bits
#define     AT91C_DBGU_MR_CHRL_8_BITS               ( 0x3 <<  6) // (USART) Character Length: 8 bits
#define AT91C_DBGU_MR_SYNC         ( 0x1 <<  8) // (USART) Synchronous Mode Select
#define AT91C_DBGU_MR_PAR (0x7 << 9) // (DBGU) Parity Type
#define     AT91C_DBGU_MR_PAR_EVEN                 ( 0x0 <<  9) // (DBGU) Even Parity
#define     AT91C_DBGU_MR_PAR_ODD                  ( 0x1 <<  9) // (DBGU) Odd Parity
#define     AT91C_DBGU_MR_PAR_SPACE                ( 0x2 <<  9) // (DBGU) Parity forced to 0 (Space)
#define     AT91C_DBGU_MR_PAR_MARK                 ( 0x3 <<  9) // (DBGU) Parity forced to 1 (Mark)
#define     AT91C_DBGU_MR_PAR_NONE                 ( 0x4 <<  9) // (DBGU) No Parity
#define     AT91C_DBGU_MR_PAR_MULTI_DROP           ( 0x6 <<  9) // (DBGU) Multi-drop mode
#define AT91C_DBGU_MR_NBSTOP       ( 0x3 << 12) // (USART) Number of Stop bits
#define     AT91C_DBGU_MR_NBSTOP_1_BIT                ( 0x0 << 12) // (USART) 1 stop bit
#define     AT91C_DBGU_MR_NBSTOP_15_BIT               ( 0x1 << 12) // (USART) Asynchronous (SYNC=0) 2 stop bits Synchronous (SYNC=1) 2 stop bits
#define     AT91C_DBGU_MR_NBSTOP_2_BIT                ( 0x2 << 12) // (USART) 2 stop bits
#define AT91C_DBGU_MR_CHMODE (0x3 << 14) // (DBGU) Channel Mode
#define     AT91C_DBGU_MR_CHMODE_NORMAL               ( 0x0 << 14) // (DBGU) Normal Mode: The USART channel operates as an RX/TX USART.
#define     AT91C_DBGU_MR_CHMODE_AUTO                 ( 0x1 << 14) // (DBGU) Automatic Echo: Receiver Data Input is connected to the TXD pin.
#define     AT91C_DBGU_MR_CHMODE_LOCAL                ( 0x2 << 14) // (DBGU) Local Loopback: Transmitter Output Signal is connected to Receiver Input Signal.
#define     AT91C_DBGU_MR_CHMODE_REMOTE               ( 0x3 << 14) // (DBGU) Remote Loopback: RXD pin is internally connected to TXD pin.
#define AT91C_DBGU_MR_MSBF         ( 0x1 << 16) // (USART) Bit Order
#define AT91C_DBGU_MR_MODE9        ( 0x1 << 17) // (USART) 9-bit Character length
#define AT91C_DBGU_MR_CKLO         ( 0x1 << 18) // (USART) Clock Output Select
#define AT91C_DBGU_MR_OVER         ( 0x1 << 19) // (USART) Over Sampling Mode
#define AT91C_DBGU_MR_INACK        ( 0x1 << 20) // (USART) Inhibit Non Acknowledge
#define AT91C_DBGU_MR_DSNACK       ( 0x1 << 21) // (USART) Disable Successive NACK
#define AT91C_DBGU_MR_VAR_SYNC     ( 0x1 << 22) // (USART) Variable synchronization of command/data sync Start Frame Delimiter
#define AT91C_DBGU_MR_MAX_ITER     ( 0x1 << 24) // (USART) Number of Repetitions
#define AT91C_DBGU_MR_FILTER       ( 0x1 << 28) // (USART) Receive Line Filter
#define AT91C_DBGU_MR_MANMODE      ( 0x1 << 29) // (USART) Manchester Encoder/Decoder Enable
#define AT91C_DBGU_MR_MODSYNC      ( 0x1 << 30) // (USART) Manchester Synchronization mode
#define AT91C_DBGU_MR_ONEBIT       ( 0x1 << 31) // (USART) Start Frame Delimiter selector

// -------- DBGU_IER : (DBGU Offset: 0x0008) Interrupt Enable Register --------
#define AT91C_DBGU_IER_RXRDY (0x1 << 0) // (DBGU) Enable RXRDY Interrupt
#define AT91C_DBGU_IER_TXRDY (0x1 << 1) // (DBGU) Enable TXRDY Interrupt
#define AT91C_DBGU_IER_ENDRX (0x1 << 3) // (DBGU) Enable End of Receive Transfer Interrupt
#define AT91C_DBGU_IER_ENDTX (0x1 << 4) // (DBGU) Enable End of Transmit Interrupt
#define AT91C_DBGU_IER_OVRE (0x1 << 5) // (DBGU) Enable Overrun Error Interrupt
#define AT91C_DBGU_IER_FRAME (0x1 << 6) // (DBGU) Enable Framing Error Interrupt
#define AT91C_DBGU_IER_PARE (0x1 << 7) // (DBGU) Enable Parity Error Interrupt
#define AT91C_DBGU_IER_TXEMPTY (0x1 << 9) // (DBGU) Enable TXEMPTY Interrupt
#define AT91C_DBGU_IER_TXBUFE (0x1 << 11) // (DBGU) Enable Buffer Empty Interrupt
#define AT91C_DBGU_IER_RXBUFF (0x1 << 12) // (DBGU) Enable Buffer Full Interrupt
#define AT91C_DBGU_IER_COMMTX (0x1 << 30) // (DBGU) Enable COMMTX (from ARM) Interrupt
#define AT91C_DBGU_IER_COMMRX (0x1 << 31) // (DBGU) Enable COMMRX (from ARM) Interrupt
// -------- DBGU_IDR : (DBGU Offset: 0x000C) Interrupt Disable Register --------
#define AT91C_DBGU_IDR_RXRDY (0x1 << 0) // (DBGU) Disable RXRDY Interrupt
#define AT91C_DBGU_IDR_TXRDY (0x1 << 1) // (DBGU) Disable TXRDY Interrupt
#define AT91C_DBGU_IDR_ENDRX (0x1 << 3) // (DBGU) Disable End of Receive Transfer Interrupt
#define AT91C_DBGU_IDR_ENDTX (0x1 << 4) // (DBGU) Disable End of Transmit Interrupt
#define AT91C_DBGU_IDR_OVRE (0x1 << 5) // (DBGU) Disable Overrun Error Interrupt
#define AT91C_DBGU_IDR_FRAME (0x1 << 6) // (DBGU) Disable Framing Error Interrupt
#define AT91C_DBGU_IDR_PARE (0x1 << 7) // (DBGU) Disable Parity Error Interrupt
#define AT91C_DBGU_IDR_TXEMPTY (0x1 << 9) // (DBGU) Disable TXEMPTY Interrupt
#define AT91C_DBGU_IDR_TXBUFE (0x1 << 11) // (DBGU) Disable Buffer Empty Interrupt
#define AT91C_DBGU_IDR_RXBUFF (0x1 << 12) // (DBGU) Disable Buffer Full Interrupt
#define AT91C_DBGU_IDR_COMMTX (0x1 << 30) // (DBGU) Disable COMMTX (from ARM) Interrupt
#define AT91C_DBGU_IDR_COMMRX (0x1 << 31) // (DBGU) Disable COMMRX (from ARM) Interrupt
// -------- DBGU_IMR : (DBGU Offset: 0x0010) Interrupt Mask Register --------
#define AT91C_DBGU_IMR_RXRDY (0x1 << 0) // (DBGU) Mask RXRDY Interrupt
#define AT91C_DBGU_IMR_TXRDY (0x1 << 1) // (DBGU) Disable TXRDY Interrupt
#define AT91C_DBGU_IMR_ENDRX (0x1 << 3) // (DBGU) Mask End of Receive Transfer Interrupt
#define AT91C_DBGU_IMR_ENDTX (0x1 << 4) // (DBGU) Mask End of Transmit Interrupt
#define AT91C_DBGU_IMR_OVRE (0x1 << 5) // (DBGU) Mask Overrun Error Interrupt
#define AT91C_DBGU_IMR_FRAME (0x1 << 6) // (DBGU) Mask Framing Error Interrupt
#define AT91C_DBGU_IMR_PARE (0x1 << 7) // (DBGU) Mask Parity Error Interrupt
#define AT91C_DBGU_IMR_TXEMPTY (0x1 << 9) // (DBGU) Mask TXEMPTY Interrupt
#define AT91C_DBGU_IMR_TXBUFE (0x1 << 11) // (DBGU) Mask TXBUFE Interrupt
#define AT91C_DBGU_IMR_RXBUFF (0x1 << 12) // (DBGU) Mask RXBUFF Interrupt
#define AT91C_DBGU_IMR_COMMTX (0x1 << 30) // (DBGU) Mask COMMTX Interrupt
#define AT91C_DBGU_IMR_COMMRX (0x1 << 31) // (DBGU) Mask COMMRX Interrupt
// -------- DBGU_SR : (DBGU Offset: 0x0014) Status Register --------
#define AT91C_DBGU_SR_RXRDY (0x1 << 0) // (DBGU) Receiver Ready
#define AT91C_DBGU_SR_TXRDY (0x1 << 1) // (DBGU) Transmitter Ready
#define AT91C_DBGU_SR_ENDRX (0x1 << 3) // (DBGU) End of Receiver Transfer
#define AT91C_DBGU_SR_ENDTX (0x1 << 4) // (DBGU) End of Transmitter Transfer
#define AT91C_DBGU_SR_OVRE (0x1 << 5) // (DBGU) Overrun Error
#define AT91C_DBGU_SR_FRAME (0x1 << 6) // (DBGU) Framing Error
#define AT91C_DBGU_SR_PARE (0x1 << 7) // (DBGU) Parity Error
#define AT91C_DBGU_SR_TXEMPTY (0x1 << 9) // (DBGU) Transmitter Empty
#define AT91C_DBGU_SR_TXBUFE (0x1 << 11) // (DBGU) Transmission Buffer Empty
#define AT91C_DBGU_SR_RXBUFF (0x1 << 12) // (DBGU) Receive Buffer Full
#define AT91C_DBGU_SR_COMMTX (0x1 << 30) // (DBGU) Debug Communication Channel Write Status
#define AT91C_DBGU_SR_COMMRX (0x1 << 31) // (DBGU) Debug Communication Channel Read Status
// -------- DBGU_RHR : (DBGU Offset: 0x0018) Receive Holding Register --------
#define AT91C_DBGU_RHR_RXCHR (0xff << 0) // (DBGU) Received Character
// -------- DBGU_THR : (DBGU Offset: 0x001C) Transmit Holding Register --------
#define AT91C_DBGU_THR_TXCHR (0xff << 0) // (DBGU) Character to be Transmitted
// -------- DBGU_BRGR : (DBGU Offset: 0x0020) Baud Rate Generator Register --------
#define AT91C_DBGU_BRGR_CD (0xffff << 0) // (DBGU) Clock Divisor
// -------- DBGU_CIDR : (DBGU Offset: 0x0040) Chip ID Register --------
#define AT91C_DBGU_CIDR_VERSION (0x1f << 0) // (DBGU) Version of the Device
#define AT91C_DBGU_CIDR_EPROC (0x7 << 5) // (DBGU) Embedded Processor
#define AT91C_DBGU_CIDR_NVPSIZ (0xf << 8) // (DBGU) Nonvolatile Program Memory Size
#define AT91C_DBGU_CIDR_NVPSIZ2 (0xf << 12) // (DBGU)
#define AT91C_DBGU_CIDR_SRAMSIZ (0xf << 16) // (DBGU) Internal SRAM Size
#define AT91C_DBGU_CIDR_ARCH (0xff << 20) // (DBGU) Architecture Identifier
#define AT91C_DBGU_CIDR_NVPTYP (0x7 << 28) // (DBGU) Nonvolatile Program Memory Type
#define AT91C_DBGU_CIDR_EXT (0x1 << 31) // (DBGU) Extension Flag
// -------- DBGU_EXID : (DBGU Offset: 0x0044) Chip ID Extension Register --------
#define AT91C_DBGU_EXID_EXID (0xffffffff << 0) // (DBGU) Chip ID Extension
// -------- DBGU_FNR : (DBGU Offset: 0x0048) Force NTRST Register --------
#define AT91C_DBGU_FNR_FNTRST (0x1 << 0) // (DBGU) Force NTRST
// -------- DBGU_RPR : (DBGU Offset: 0x100) Receive Pointer Register --------
#define AT91C_DBGU_RPR_RXPTR (0xffffffff << 0) // (DBGU) Receive Pointer Register
// -------- DBGU_RCR : (DBGU Offset: 0x104) Receive Counter Register --------
#define AT91C_DBGU_RCR_RXCTR (0xffff << 0) // (DBGU) Receive Counter Register
// -------- DBGU_TPR : (DBGU Offset: 0x108) Transmit Pointer Register --------
#define AT91C_DBGU_TPR_TXPTR (0xffffffff << 0) // (DBGU) Transmit Counter Register
// -------- DBGU_TCR : (DBGU Offset: 0x10C) Transmit Counter Register --------
#define AT91C_DBGU_TCR_TXCTR (0xffff << 0) // (DBGU) Transmit Counter Register
// -------- DBGU_RNPR : (DBGU Offset: 0x110) Receive Next Pointer Register --------
#define AT91C_DBGU_RNPR_RXNPTR (0xffffffff << 0) // (DBGU) Receive Next Pointer
// -------- DBGU_RNCR : (DBGU Offset: 0x114) Receive Next Counter Register --------
#define AT91C_DBGU_RNCR_RXNCTR (0xffff << 0) // (DBGU) Receive Next Counter
// -------- DBGU_TNPR : (DBGU Offset: 0x118) Transmit Next Pointer Register --------
#define AT91C_DBGU_TNPR_TXNPTR (0xffffffff << 0) // (DBGU) Transmit Next Pointer
// -------- DBGU_TNCR : (DBGU Offset: 0x11C) Transmit Next Counter Register --------
#define AT91C_DBGU_TNCR_TXNCTR (0xffff << 0) // (DBGU) Transmit Counter Next
// -------- DBGU_PTCR : (DBGU Offset: 0x120) Transfer Control Register --------
#define AT91C_DBGU_PTCR_RXTEN (0x1 << 0) // (DBGU) Receiver Transfer Enable
#define AT91C_DBGU_PTCR_RXTDIS (0x1 << 1) // (DBGU) Receiver Transfer Disable
#define AT91C_DBGU_PTCR_TXTEN (0x1 << 8) // (DBGU) Transmitter Transfer Enable
#define AT91C_DBGU_PTCR_TXTDIS (0x1 << 9) // (DBGU) Transmitter Transfer Disable
// -------- DBGU_PTSR : (DBGU Offset: 0x124) Transfer Status Register --------
#define AT91C_DBGU_PTSR_RXTEN (0x1 << 0) // (DBGU) Receiver Transfer Enable
#define AT91C_DBGU_PTSR_TXTEN (0x1 << 8) // (DBGU) Transmitter Transfer Enable

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR DDR_SDR SDRAM Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_DDRSDRC {
  AT91_REG DDRSDRC_MR;    // DDRSDRC Mode Register
  AT91_REG DDRSDRC_RTR;   // DDRSDRC Refresh Timer Register
  AT91_REG DDRSDRC_CR;    // DDRSDRC Configuration Register
  AT91_REG DDRSDRC_T0PR;  // DDRSDRC Timing0 Register
  AT91_REG DDRSDRC_T1PR;  // DDRSDRC Timing1 Register
  AT91_REG DDRSDRC_T2PR;  // DDRSDRC Timing2 Register
  AT91_REG Reserved1[1];
  AT91_REG DDRSDRC_LPR;   // DDRSDRC Low-power Register
  AT91_REG DDRSDRC_MD;    // DDRSDRC Memory Device Register
  AT91_REG DDRSDRC_DLL;   // DDRSDRC DLL Information Register
  AT91_REG Reserved2[47];
  AT91_REG DDRSDRC_WPMR;  // DDRSDRC Write Protect Mode Register
  AT91_REG DDRSDRC_WPSR;  // DDRSDRC Write Protect Status Register
} AT91S_DDRSDRC, *AT91PS_DDRSDRC;
#else
#define DDRSDRC_MR   (AT91_CAST(AT91_REG *) 0x00000000) // DDRSDRC Mode Register
#define DDRSDRC_RTR  (AT91_CAST(AT91_REG *) 0x00000004) // DDRSDRC Refresh Timer Register
#define DDRSDRC_CR   (AT91_CAST(AT91_REG *) 0x00000008) // DDRSDRC Configuration Register
#define DDRSDRC_T0PR (AT91_CAST(AT91_REG *) 0x0000000C) // DDRSDRC Timing0 Register
#define DDRSDRC_T1PR (AT91_CAST(AT91_REG *) 0x00000010) // DDRSDRC Timing1 Register
#define DDRSDRC_T2PR (AT91_CAST(AT91_REG *) 0x00000014) // DDRSDRC Timing2 Register
#define DDRSDRC_LPR  (AT91_CAST(AT91_REG *) 0x0000001C) // DDRSDRC Low-power Register
#define DDRSDRC_MD   (AT91_CAST(AT91_REG *) 0x00000020) // DDRSDRC Memory Device Register
#define DDRSDRC_DLL  (AT91_CAST(AT91_REG *) 0x00000024) // DDRSDRC DLL Information Register
#define DDRSDRC_WPMR (AT91_CAST(AT91_REG *) 0x000000E4) // DDRSDRC Write Protect Mode Register
#define DDRSDRC_WPSR (AT91_CAST(AT91_REG *) 0x000000E8) // DDRSDRC Write Protect Status Register
#endif
// -------- DDRSDRC_MR : (DDRSDRC Offset: 0x00) DDRSDRC Mode Register --------
#define AT91C_DDRSDRC_MR_MODE (0x7 << 0) // (DDRSDRC) DDRSDRC Command Mode
// -------- DDRSDRC_RTR : (DDRSDRC Offset: 0x04) DDRSDRC Refresh Timer Register --------
#define AT91C_DDRSDRC_RTR_COUNT (0xfff << 0) // (DDRSDRC) DDRSDRC Refresh Timer Count
// -------- DDRSDRC_CR : (DDRSDRC Offset: 0x08) DDRSDRC Configuration Register --------
#define AT91C_DDRSDRC_CR_NC (0x3 << 0) // (DDRSDRC) Number of Column Bits
#define AT91C_DDRSDRC_CR_NR (0x3 << 2) // (DDRSDRC) Number of Row Bits
#define AT91C_DDRSDRC_CR_CAS (0x7 << 4) // (DDRSDRC) CAS Latency
#define AT91C_DDRSDRC_CR_DLL (0x1 << 7) // (DDRSDRC) Reset DLL
#define AT91C_DDRSDRC_CR_DIC__DS (0x1 << 8) // (DDRSDRC) Output Driver Impedance Control:
#define AT91C_DDRSDRC_CR_DIS_DLL (0x1 << 9) // (DDRSDRC) Disable DLL
#define AT91C_DDRSDRC_CR_OCD (0x7 << 12) // (DDRSDRC) Off-chip Driver
#define AT91C_DDRSDRC_CR_DQMS (0x1 << 16) // (DDRSDRC)
#define AT91C_DDRSDRC_CR_ENRDM (0x1 << 17) // (DDRSDRC) Enable Read Measure
#define AT91C_DDRSDRC_CR_ACTBST (0x1 << 18) // (DDRSDRC) ACTIVE Bank X to Burst Stop Read Access Bank Y
// -------- DDRSDRC_T0PR : (DDRSDRC Offset: 0x0C) DDRSDRC Timing0 Register --------
#define AT91C_DDRSDRC_T0PR_TRAS (0xf << 0) // (DDRSDRC) Active to Precharge Delay
#define AT91C_DDRSDRC_T0PR_TRCD (0xf << 4) // (DDRSDRC) Row to Column Delay
#define AT91C_DDRSDRC_T0PR_TWR (0xf << 8) // (DDRSDRC) Write Recovery Delay
#define AT91C_DDRSDRC_T0PR_TRC (0xf << 12) // (DDRSDRC) Row Cycle Delay
#define AT91C_DDRSDRC_T0PR_TRP (0xf << 16) // (DDRSDRC) Row Precharge Delay
#define AT91C_DDRSDRC_T0PR_TRRD (0xf << 20) // (DDRSDRC)
#define AT91C_DDRSDRC_T0PR_TWTR (0x7 << 24) // (DDRSDRC) Internal Write to Read Delay
#define AT91C_DDRSDRC_T0PR_REDUCE_WRRD (0x1 << 27) // (DDRSDRC)
#define AT91C_DDRSDRC_T0PR_TMRD (0xf << 28) // (DDRSDRC) Load Mode Register Command to Active or Refresh Command
// -------- DDRSDRC_T1PR : (DDRSDRC Offset: 0x10) DDRSDRC Timing1 Register --------
#define AT91C_DDRSDRC_T1PR_TRFC (0x1f << 0) // (DDRSDRC) Row Cycle Delay
#define AT91C_DDRSDRC_T1PR_TXSNR (0xff << 8) // (DDRSDRC) Exit Self Refresh Delay to Non-read Command
#define AT91C_DDRSDRC_T1PR_TXSRD (0xff << 16) // (DDRSDRC) ExiT Self Refresh Delay to Read Command
#define AT91C_DDRSDRC_T1PR_TXP (0xf << 24) // (DDRSDRC) Exit Power-down Delay to First Command
// -------- DDRSDRC_T2PR : (DDRSDRC Offset: 0x14) DDRSDRC Timing2 Register --------
#define AT91C_DDRSDRC_T2PR_TXARD (0xf << 0) // (DDRSDRC) Exit Active Power Down Delay to Read Command in Mode "Fast Exit".
#define AT91C_DDRSDRC_T2PR_TXARDS (0xf << 4) // (DDRSDRC) Exit Active Power Down Delay to Read Command in Mode "Slow Exit".
#define AT91C_DDRSDRC_T2PR_TRPA (0xf << 8) // (DDRSDRC) Row Precharge All Delay
#define AT91C_DDRSDRC_T2PR_TRTP (0x7 << 12) // (DDRSDRC) Read to Precharge
// -------- DDRSDRC_LPR : (DDRSDRC Offset: 0x1C) DDRSDRC Low-power Register --------
#define AT91C_DDRSDRC_LPR_LPCB (0x3 << 0) // (DDRSDRC) Low-power Command Bit
#define AT91C_DDRSDRC_LPR_CLK_FR (0x1 << 2) // (DDRSDRC) Clock Frozen Command Bit
#define AT91C_DDRSDRC_LPR_PASR (0x7 << 4) // (DDRSDRC) Partial Array Self Refresh
#define AT91C_DDRSDRC_LPR_TCR (0x3 << 8) // (DDRSDRC) Temperature Compensated Self Refresh
#define AT91C_DDRSDRC_LPR_DS (0x3 << 10) // (DDRSDRC) Drive Strength
#define AT91C_DDRSDRC_LPR_TIMEOUT (0x3 << 12) // (DDRSDRC)
#define AT91C_DDRSDRC_LPR_APDE (0x1 << 16) // (DDRSDRC) Active Power Down Exit Time
// -------- DDRSDRC_MD : (DDRSDRC Offset: 0x20) DDRSDRC Memory Device Register --------
#define AT91C_DDRSDRC_MD_MD (0x7 << 0) // (DDRSDRC) Memory Device
#define AT91C_DDRSDRC_MD_DBW (0x1 << 4) // (DDRSDRC) Data Bus Width
// -------- DDRSDRC_DLL : (DDRSDRC Offset: 0x24) DDRSDRC DLL Information Register --------
#define AT91C_DDRSDRC_DLL_MDINC (0x1 << 0) // (DDRSDRC) DLL Master Delay Increment
#define AT91C_DDRSDRC_DLL_MDDEC (0x1 << 1) // (DDRSDRC) DLL Master Delay Decrement
#define AT91C_DDRSDRC_DLL_MDOVF (0x1 << 2) // (DDRSDRC) DLL Master Delay Overflow Flag
#define AT91C_DDRSDRC_DLL_SDCOVF (0x1 << 3) // (DDRSDRC) DLL Slave Delay Correction Overflow Flag
#define AT91C_DDRSDRC_DLL_SDCUDF (0x1 << 4) // (DDRSDRC) DLL Slave Delay Correction Underflow Flag
#define AT91C_DDRSDRC_DLL_SDERF (0x1 << 5) // (DDRSDRC) DLL Slave Delay Correction Error Flag
#define AT91C_DDRSDRC_DLL_MDVAL (0xff << 8) // (DDRSDRC) DLL Master Delay Value
#define AT91C_DDRSDRC_DLL_SDVAL (0xff << 16) // (DDRSDRC) DLL Slave Delay Value
#define AT91C_DDRSDRC_DLL_SDCVAL (0xff << 24) // (DDRSDRC) DLL Slave Delay Correction Value
// -------- DDRSDRC_WPMR : (DDRSDRC Offset: 0xE4) DDRSDRC Write Protect Mode Register --------
#define AT91C_DDRSDRC_WPMR_WPEN (0x1 << 0) // (DDRSDRC) Write Protect Enable
#define AT91C_DDRSDRC_WPMR_WPKEY (0xffffff << 8) // (DDRSDRC) Write Protect KEY
// -------- DDRSDRC_WPSR : (DDRSDRC Offset: 0xE8) DDRSDRC Write Protect Status Register --------
#define AT91C_DDRSDRC_WPSR_WPVS (0x1 << 0) // (DDRSDRC) Write Protect Violation Status
#define AT91C_DDRSDRC_WPSR_WPVSRC (0xffff << 8) // (DDRSDRC) Write Protect Violation Source

// *****************************************************************************
//              SOFTWARE API DEFINITION  FOR HDMA Channel structure
// *****************************************************************************
#ifndef __ASSEMBLY__
typedef struct _AT91S_HDMA_CH {
    AT91_REG     HDMA_SADDR;    // HDMA Channel Source Address Register
    AT91_REG     HDMA_DADDR;    // HDMA Channel Destination Address Register
    AT91_REG     HDMA_DSCR;     // HDMA Channel Descriptor Address Register
    AT91_REG     HDMA_CTRLA;    // HDMA Channel Control A Register
    AT91_REG     HDMA_CTRLB;    // HDMA Channel Control B Register
    AT91_REG     HDMA_CFG;  // HDMA Channel Configuration Register
    AT91_REG     HDMA_SPIP;     // HDMA Channel Source Picture in Picture Configuration Register
    AT91_REG     HDMA_DPIP;     // HDMA Channel Destination Picture in Picture Configuration Register
    AT91_REG     HDMA_BDSCR;    // HDMA Reserved
    AT91_REG     HDMA_CADDR;    // HDMA Reserved
} AT91S_HDMA_CH, *AT91PS_HDMA_CH;
#else
#define HDMA_SADDR      (AT91_CAST(AT91_REG *)  0x00000000) // (HDMA_SADDR) HDMA Channel Source Address Register
#define HDMA_DADDR      (AT91_CAST(AT91_REG *)  0x00000004) // (HDMA_DADDR) HDMA Channel Destination Address Register
#define HDMA_DSCR       (AT91_CAST(AT91_REG *)  0x00000008) // (HDMA_DSCR) HDMA Channel Descriptor Address Register
#define HDMA_CTRLA      (AT91_CAST(AT91_REG *)  0x0000000C) // (HDMA_CTRLA) HDMA Channel Control A Register
#define HDMA_CTRLB      (AT91_CAST(AT91_REG *)  0x00000010) // (HDMA_CTRLB) HDMA Channel Control B Register
#define HDMA_CFG        (AT91_CAST(AT91_REG *)  0x00000014) // (HDMA_CFG) HDMA Channel Configuration Register
#define HDMA_SPIP       (AT91_CAST(AT91_REG *)  0x00000018) // (HDMA_SPIP) HDMA Channel Source Picture in Picture Configuration Register
#define HDMA_DPIP       (AT91_CAST(AT91_REG *)  0x0000001C) // (HDMA_DPIP) HDMA Channel Destination Picture in Picture Configuration Register
#define HDMA_BDSCR      (AT91_CAST(AT91_REG *)  0x00000020) // (HDMA_BDSCR) HDMA Reserved
#define HDMA_CADDR      (AT91_CAST(AT91_REG *)  0x00000024) // (HDMA_CADDR) HDMA Reserved

#endif
// -------- HDMA_SADDR : (HDMA_CH Offset: 0x0)  --------
#define AT91C_SADDR           (0x0 <<  0) // (HDMA_CH)
// -------- HDMA_DADDR : (HDMA_CH Offset: 0x4)  --------
#define AT91C_DADDR           (0x0 <<  0) // (HDMA_CH)
// -------- HDMA_DSCR : (HDMA_CH Offset: 0x8)  --------
#define AT91C_HDMA_DSCR_IF    (0x3 <<  0) // (HDMA_CH) Select AHB-Lite Interface for current channel
#define     AT91C_HDMA_DSCR_IF_0                    (0x0) // (HDMA_CH) The Buffer Transfer descriptor is fetched via AHB-Lite Interface 0.
#define     AT91C_HDMA_DSCR_IF_1                    (0x1) // (HDMA_CH) The Buffer Transfer descriptor is fetched via AHB-Lite Interface 1.
#define     AT91C_HDMA_DSCR_IF_2                    (0x2) // (HDMA_CH) The Buffer Transfer descriptor is fetched via AHB-Lite Interface 2.
#define     AT91C_HDMA_DSCR_IF_3                    (0x3) // (HDMA_CH) The Buffer Transfer descriptor is fetched via AHB-Lite Interface 3.
#define AT91C_HDMA_DSCR       (0x3FFFFFFF <<  2) // (HDMA_CH) Buffer Transfer descriptor address. This address is word aligned.
// -------- HDMA_CTRLA : (HDMA_CH Offset: 0xc)  --------
#define AT91C_HDMA_BTSIZE     (0xFFFF <<  0) // (HDMA_CH) Buffer Transfer Size.
#define AT91C_HDMA_SCSIZE     (0x7 << 16) // (HDMA_CH) Source Chunk Transfer Size.
#define     AT91C_HDMA_SCSIZE_1                    (0x0 << 16) // (HDMA_CH) 1.
#define     AT91C_HDMA_SCSIZE_4                    (0x1 << 16) // (HDMA_CH) 4.
#define     AT91C_HDMA_SCSIZE_8                    (0x2 << 16) // (HDMA_CH) 8.
#define     AT91C_HDMA_SCSIZE_16                   (0x3 << 16) // (HDMA_CH) 16.
#define     AT91C_HDMA_SCSIZE_32                   (0x4 << 16) // (HDMA_CH) 32.
#define     AT91C_HDMA_SCSIZE_64                   (0x5 << 16) // (HDMA_CH) 64.
#define     AT91C_HDMA_SCSIZE_128                  (0x6 << 16) // (HDMA_CH) 128.
#define     AT91C_HDMA_SCSIZE_256                  (0x7 << 16) // (HDMA_CH) 256.
#define AT91C_HDMA_DCSIZE     (0x7 << 20) // (HDMA_CH) Destination Chunk Transfer Size
#define     AT91C_HDMA_DCSIZE_1                    (0x0 << 20) // (HDMA_CH) 1.
#define     AT91C_HDMA_DCSIZE_4                    (0x1 << 20) // (HDMA_CH) 4.
#define     AT91C_HDMA_DCSIZE_8                    (0x2 << 20) // (HDMA_CH) 8.
#define     AT91C_HDMA_DCSIZE_16                   (0x3 << 20) // (HDMA_CH) 16.
#define     AT91C_HDMA_DCSIZE_32                   (0x4 << 20) // (HDMA_CH) 32.
#define     AT91C_HDMA_DCSIZE_64                   (0x5 << 20) // (HDMA_CH) 64.
#define     AT91C_HDMA_DCSIZE_128                  (0x6 << 20) // (HDMA_CH) 128.
#define     AT91C_HDMA_DCSIZE_256                  (0x7 << 20) // (HDMA_CH) 256.
#define AT91C_HDMA_SRC_WIDTH  (0x3 << 24) // (HDMA_CH) Source Single Transfer Size
#define     AT91C_HDMA_SRC_WIDTH_BYTE                 (0x0 << 24) // (HDMA_CH) BYTE.
#define     AT91C_HDMA_SRC_WIDTH_HALFWORD             (0x1 << 24) // (HDMA_CH) HALF-WORD.
#define     AT91C_HDMA_SRC_WIDTH_WORD                 (0x2 << 24) // (HDMA_CH) WORD.
#define AT91C_HDMA_DST_WIDTH  (0x3 << 28) // (HDMA_CH) Destination Single Transfer Size
#define     AT91C_HDMA_DST_WIDTH_BYTE                 (0x0 << 28) // (HDMA_CH) BYTE.
#define     AT91C_HDMA_DST_WIDTH_HALFWORD             (0x1 << 28) // (HDMA_CH) HALF-WORD.
#define     AT91C_HDMA_DST_WIDTH_WORD                 (0x2 << 28) // (HDMA_CH) WORD.
#define AT91C_HDMA_DONE       (0x1 << 31) // (HDMA_CH)
// -------- HDMA_CTRLB : (HDMA_CH Offset: 0x10)  --------
#define AT91C_HDMA_SIF        (0x3 <<  0) // (HDMA_CH) Source Interface Selection Field.
#define     AT91C_HDMA_SIF_0                    (0x0) // (HDMA_CH) The Source Transfer is done via AHB-Lite Interface 0.
#define     AT91C_HDMA_SIF_1                    (0x1) // (HDMA_CH) The Source Transfer is done via AHB-Lite Interface 1.
#define     AT91C_HDMA_SIF_2                    (0x2) // (HDMA_CH) The Source Transfer is done via AHB-Lite Interface 2.
#define     AT91C_HDMA_SIF_3                    (0x3) // (HDMA_CH) The Source Transfer is done via AHB-Lite Interface 3.
#define AT91C_HDMA_DIF        (0x3 <<  4) // (HDMA_CH) Destination Interface Selection Field.
#define     AT91C_HDMA_DIF_0                    (0x0 <<  4) // (HDMA_CH) The Destination Transfer is done via AHB-Lite Interface 0.
#define     AT91C_HDMA_DIF_1                    (0x1 <<  4) // (HDMA_CH) The Destination Transfer is done via AHB-Lite Interface 1.
#define     AT91C_HDMA_DIF_2                    (0x2 <<  4) // (HDMA_CH) The Destination Transfer is done via AHB-Lite Interface 2.
#define     AT91C_HDMA_DIF_3                    (0x3 <<  4) // (HDMA_CH) The Destination Transfer is done via AHB-Lite Interface 3.
#define AT91C_HDMA_SRC_PIP    (0x1 <<  8) // (HDMA_CH) Source Picture-in-Picture Mode
#define     AT91C_HDMA_SRC_PIP_DISABLE              (0x0 <<  8) // (HDMA_CH) Source Picture-in-Picture mode is disabled.
#define     AT91C_HDMA_SRC_PIP_ENABLE               (0x1 <<  8) // (HDMA_CH) Source Picture-in-Picture mode is enabled.
#define AT91C_HDMA_DST_PIP    (0x1 << 12) // (HDMA_CH) Destination Picture-in-Picture Mode
#define     AT91C_HDMA_DST_PIP_DISABLE              (0x0 << 12) // (HDMA_CH) Destination Picture-in-Picture mode is disabled.
#define     AT91C_HDMA_DST_PIP_ENABLE               (0x1 << 12) // (HDMA_CH) Destination Picture-in-Picture mode is enabled.
#define AT91C_HDMA_SRC_DSCR   (0x1 << 16) // (HDMA_CH) Source Buffer Descriptor Fetch operation
#define     AT91C_HDMA_SRC_DSCR_FETCH_FROM_MEM       (0x0 << 16) // (HDMA_CH) Source address is updated when the descriptor is fetched from the memory.
#define     AT91C_HDMA_SRC_DSCR_FETCH_DISABLE        (0x1 << 16) // (HDMA_CH) Buffer Descriptor Fetch operation is disabled for the Source.
#define AT91C_HDMA_DST_DSCR   (0x1 << 20) // (HDMA_CH) Destination Buffer Descriptor operation
#define     AT91C_HDMA_DST_DSCR_FETCH_FROM_MEM       (0x0 << 20) // (HDMA_CH) Destination address is updated when the descriptor is fetched from the memory.
#define     AT91C_HDMA_DST_DSCR_FETCH_DISABLE        (0x1 << 20) // (HDMA_CH) Buffer Descriptor Fetch operation is disabled for the destination.
#define AT91C_HDMA_FC         (0x7 << 21) // (HDMA_CH) This field defines which devices controls the size of the buffer transfer, also referred as to the Flow Controller.
#define     AT91C_HDMA_FC_MEM2MEM              (0x0 << 21) // (HDMA_CH) Memory-to-Memory (DMA Controller).
#define     AT91C_HDMA_FC_MEM2PER              (0x1 << 21) // (HDMA_CH) Memory-to-Peripheral (DMA Controller).
#define     AT91C_HDMA_FC_PER2MEM              (0x2 << 21) // (HDMA_CH) Peripheral-to-Memory (DMA Controller).
#define     AT91C_HDMA_FC_PER2PER              (0x3 << 21) // (HDMA_CH) Peripheral-to-Peripheral (DMA Controller).
#define     AT91C_HDMA_FC_PER2MEM_PER          (0x4 << 21) // (HDMA_CH) Peripheral-to-Memory (Peripheral).
#define     AT91C_HDMA_FC_MEM2PER_PER          (0x5 << 21) // (HDMA_CH) Memory-to-Peripheral (Peripheral).
#define     AT91C_HDMA_FC_PER2PER_PER          (0x6 << 21) // (HDMA_CH) Peripheral-to-Peripheral (Source Peripheral).
#define AT91C_HDMA_SRC_ADDRESS_MODE (0x3 << 24) // (HDMA_CH) Type of addressing mode
#define     AT91C_HDMA_SRC_ADDRESS_MODE_INCR                 (0x0 << 24) // (HDMA_CH) Incrementing Mode.
#define     AT91C_HDMA_SRC_ADDRESS_MODE_DECR                 (0x1 << 24) // (HDMA_CH) Decrementing Mode.
#define     AT91C_HDMA_SRC_ADDRESS_MODE_FIXED                (0x2 << 24) // (HDMA_CH) Fixed Mode.
#define AT91C_HDMA_DST_ADDRESS_MODE (0x3 << 28) // (HDMA_CH) Type of addressing mode
#define     AT91C_HDMA_DST_ADDRESS_MODE_INCR                 (0x0 << 28) // (HDMA_CH) Incrementing Mode.
#define     AT91C_HDMA_DST_ADDRESS_MODE_DECR                 (0x1 << 28) // (HDMA_CH) Decrementing Mode.
#define     AT91C_HDMA_DST_ADDRESS_MODE_FIXED                (0x2 << 28) // (HDMA_CH) Fixed Mode.
#define AT91C_HDMA_AUTO       (0x1 << 31) // (HDMA_CH) Automatic multiple buffer transfer enable
#define     AT91C_HDMA_AUTO_DISABLE              (0x0 << 31) // (HDMA_CH) Automatic multiple buffer transfer is disabled.
#define     AT91C_HDMA_AUTO_ENABLE               (0x1 << 31) // (HDMA_CH) Automatic multiple buffer transfer is enabled. This enables replay mode or contiguous mode when several buffers are transferred.
// -------- HDMA_CFG : (HDMA_CH Offset: 0x14)  --------
#define AT91C_HDMA_SRC_PER    (0xF <<  0) // (HDMA_CH) Channel Source Request is associated with peripheral identifier coded SRC_PER handshaking interface.
#define     AT91C_HDMA_SRC_PER_0                    (0x0) // (HDMA_CH) HW Handshaking Interface number 0.
#define     AT91C_HDMA_SRC_PER_1                    (0x1) // (HDMA_CH) HW Handshaking Interface number 1.
#define     AT91C_HDMA_SRC_PER_2                    (0x2) // (HDMA_CH) HW Handshaking Interface number 2.
#define     AT91C_HDMA_SRC_PER_3                    (0x3) // (HDMA_CH) HW Handshaking Interface number 3.
#define     AT91C_HDMA_SRC_PER_4                    (0x4) // (HDMA_CH) HW Handshaking Interface number 4.
#define     AT91C_HDMA_SRC_PER_5                    (0x5) // (HDMA_CH) HW Handshaking Interface number 5.
#define     AT91C_HDMA_SRC_PER_6                    (0x6) // (HDMA_CH) HW Handshaking Interface number 6.
#define     AT91C_HDMA_SRC_PER_7                    (0x7) // (HDMA_CH) HW Handshaking Interface number 7.
#define     AT91C_HDMA_SRC_PER_8                    (0x8) // (HDMA_CH) HW Handshaking Interface number 8.
#define     AT91C_HDMA_SRC_PER_9                    (0x9) // (HDMA_CH) HW Handshaking Interface number 9.
#define     AT91C_HDMA_SRC_PER_10                   (0xA) // (HDMA_CH) HW Handshaking Interface number 10.
#define     AT91C_HDMA_SRC_PER_11                   (0xB) // (HDMA_CH) HW Handshaking Interface number 11.
#define     AT91C_HDMA_SRC_PER_12                   (0xC) // (HDMA_CH) HW Handshaking Interface number 12.
#define     AT91C_HDMA_SRC_PER_13                   (0xD) // (HDMA_CH) HW Handshaking Interface number 13.
#define     AT91C_HDMA_SRC_PER_14                   (0xE) // (HDMA_CH) HW Handshaking Interface number 14.
#define     AT91C_HDMA_SRC_PER_15                   (0xF) // (HDMA_CH) HW Handshaking Interface number 15.
#define AT91C_HDMA_DST_PER    (0xF <<  4) // (HDMA_CH) Channel Destination Request is associated with peripheral identifier coded DST_PER handshaking interface.
#define     AT91C_HDMA_DST_PER_0                    (0x0 <<  4) // (HDMA_CH) HW Handshaking Interface number 0.
#define     AT91C_HDMA_DST_PER_1                    (0x1 <<  4) // (HDMA_CH) HW Handshaking Interface number 1.
#define     AT91C_HDMA_DST_PER_2                    (0x2 <<  4) // (HDMA_CH) HW Handshaking Interface number 2.
#define     AT91C_HDMA_DST_PER_3                    (0x3 <<  4) // (HDMA_CH) HW Handshaking Interface number 3.
#define     AT91C_HDMA_DST_PER_4                    (0x4 <<  4) // (HDMA_CH) HW Handshaking Interface number 4.
#define     AT91C_HDMA_DST_PER_5                    (0x5 <<  4) // (HDMA_CH) HW Handshaking Interface number 5.
#define     AT91C_HDMA_DST_PER_6                    (0x6 <<  4) // (HDMA_CH) HW Handshaking Interface number 6.
#define     AT91C_HDMA_DST_PER_7                    (0x7 <<  4) // (HDMA_CH) HW Handshaking Interface number 7.
#define     AT91C_HDMA_DST_PER_8                    (0x8 <<  4) // (HDMA_CH) HW Handshaking Interface number 8.
#define     AT91C_HDMA_DST_PER_9                    (0x9 <<  4) // (HDMA_CH) HW Handshaking Interface number 9.
#define     AT91C_HDMA_DST_PER_10                   (0xA <<  4) // (HDMA_CH) HW Handshaking Interface number 10.
#define     AT91C_HDMA_DST_PER_11                   (0xB <<  4) // (HDMA_CH) HW Handshaking Interface number 11.
#define     AT91C_HDMA_DST_PER_12                   (0xC <<  4) // (HDMA_CH) HW Handshaking Interface number 12.
#define     AT91C_HDMA_DST_PER_13                   (0xD <<  4) // (HDMA_CH) HW Handshaking Interface number 13.
#define     AT91C_HDMA_DST_PER_14                   (0xE <<  4) // (HDMA_CH) HW Handshaking Interface number 14.
#define     AT91C_HDMA_DST_PER_15                   (0xF <<  4) // (HDMA_CH) HW Handshaking Interface number 15.
#define AT91C_HDMA_SRC_REP    (0x1 <<  8) // (HDMA_CH) Source Replay Mode
#define     AT91C_HDMA_SRC_REP_CONTIGUOUS_ADDR      (0x0 <<  8) // (HDMA_CH) When automatic mode is activated, source address is contiguous between two buffers.
#define     AT91C_HDMA_SRC_REP_RELOAD_ADDR          (0x1 <<  8) // (HDMA_CH) When automatic mode is activated, the source address and the control register are reloaded from previous transfer..
#define AT91C_HDMA_SRC_H2SEL  (0x1 <<  9) // (HDMA_CH) Source Handshaking Mode
#define     AT91C_HDMA_SRC_H2SEL_SW                   (0x0 <<  9) // (HDMA_CH) Software handshaking interface is used to trigger a transfer request.
#define     AT91C_HDMA_SRC_H2SEL_HW                   (0x1 <<  9) // (HDMA_CH) Hardware handshaking interface is used to trigger a transfer request.
#define AT91C_HDMA_DST_REP    (0x1 << 12) // (HDMA_CH) Destination Replay Mode
#define     AT91C_HDMA_DST_REP_CONTIGUOUS_ADDR      (0x0 << 12) // (HDMA_CH) When automatic mode is activated, destination address is contiguous between two buffers.
#define     AT91C_HDMA_DST_REP_RELOAD_ADDR          (0x1 << 12) // (HDMA_CH) When automatic mode is activated, the destination address and the control register are reloaded from previous transfer..
#define AT91C_HDMA_DST_H2SEL  (0x1 << 13) // (HDMA_CH) Destination Handshaking Mode
#define     AT91C_HDMA_DST_H2SEL_SW                   (0x0 << 13) // (HDMA_CH) Software handshaking interface is used to trigger a transfer request.
#define     AT91C_HDMA_DST_H2SEL_HW                   (0x1 << 13) // (HDMA_CH) Hardware handshaking interface is used to trigger a transfer request.
#define AT91C_HDMA_SOD        (0x1 << 16) // (HDMA_CH) STOP ON DONE
#define     AT91C_HDMA_SOD_DISABLE              (0x0 << 16) // (HDMA_CH) STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
#define     AT91C_HDMA_SOD_ENABLE               (0x1 << 16) // (HDMA_CH) STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
#define AT91C_HDMA_LOCK_IF    (0x1 << 20) // (HDMA_CH) Interface Lock
#define     AT91C_HDMA_LOCK_IF_DISABLE              (0x0 << 20) // (HDMA_CH) Interface Lock capability is disabled.
#define     AT91C_HDMA_LOCK_IF_ENABLE               (0x1 << 20) // (HDMA_CH) Interface Lock capability is enabled.
#define AT91C_HDMA_LOCK_B     (0x1 << 21) // (HDMA_CH) AHB Bus Lock
#define     AT91C_HDMA_LOCK_B_DISABLE              (0x0 << 21) // (HDMA_CH) AHB Bus Locking capability is disabled.
#define     AT91C_HDMA_LOCK_B_ENABLE               (0x1 << 21) // (HDMA_CH) AHB Bus Locking capability is enabled.
#define AT91C_HDMA_LOCK_IF_L  (0x1 << 22) // (HDMA_CH) Master Interface Arbiter Lock
#define     AT91C_HDMA_LOCK_IF_L_CHUNK                (0x0 << 22) // (HDMA_CH) The Master Interface Arbiter is locked by the channel x for a chunk transfer.
#define     AT91C_HDMA_LOCK_IF_L_BUFFER               (0x1 << 22) // (HDMA_CH) The Master Interface Arbiter is locked by the channel x for a buffer transfer.
#define AT91C_HDMA_AHB_PROT   (0x7 << 24) // (HDMA_CH) AHB Prot
#define AT91C_HDMA_FIFOCFG    (0x3 << 28) // (HDMA_CH) FIFO Request Configuration
#define     AT91C_HDMA_FIFOCFG_LARGESTBURST         (0x0 << 28) // (HDMA_CH) The largest defined length AHB burst is performed on the destination AHB interface.
#define     AT91C_HDMA_FIFOCFG_HALFFIFO             (0x1 << 28) // (HDMA_CH) When half fifo size is available/filled a source/destination request is serviced.
#define     AT91C_HDMA_FIFOCFG_ENOUGHSPACE          (0x2 << 28) // (HDMA_CH) When there is enough space/data available to perfom a single AHB access then the request is serviced.
// -------- HDMA_SPIP : (HDMA_CH Offset: 0x18)  --------
#define AT91C_SPIP_HOLE       (0xFFFF <<  0) // (HDMA_CH) This field indicates the value to add to the address when the programmable boundary has been reached.
#define AT91C_SPIP_BOUNDARY   (0x3FF << 16) // (HDMA_CH) This field indicates the number of source transfers to perform before the automatic address increment operation.
// -------- HDMA_DPIP : (HDMA_CH Offset: 0x1c)  --------
#define AT91C_DPIP_HOLE       (0xFFFF <<  0) // (HDMA_CH) This field indicates the value to add to the address when the programmable boundary has been reached.
#define AT91C_DPIP_BOUNDARY   (0x3FF << 16) // (HDMA_CH) This field indicates the number of source transfers to perform before the automatic address increment operation.
// -------- HDMA_BDSCR : (HDMA_CH Offset: 0x20)  --------
// -------- HDMA_CADDR : (HDMA_CH Offset: 0x24)  --------

// *****************************************************************************
//              SOFTWARE API DEFINITION  FOR HDMA controller
// *****************************************************************************
#ifndef __ASSEMBLY__
typedef struct _AT91S_HDMA {
    AT91_REG     HDMA_GCFG;     // HDMA Global Configuration Register
    AT91_REG     HDMA_EN;   // HDMA Controller Enable Register
    AT91_REG     HDMA_SREQ;     // HDMA Software Single Request Register
    AT91_REG     HDMA_CREQ;     // HDMA Software Chunk Transfer Request Register
    AT91_REG     HDMA_LAST;     // HDMA Software Last Transfer Flag Register
    AT91_REG     HDMA_SYNC;     // HDMA Request Synchronization Register
    AT91_REG     HDMA_EBCIER;   // HDMA Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable register
    AT91_REG     HDMA_EBCIDR;   // HDMA Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable register
    AT91_REG     HDMA_EBCIMR;   // HDMA Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register
    AT91_REG     HDMA_EBCISR;   // HDMA Error, Chained Buffer transfer completed and Buffer transfer completed Status Register
    AT91_REG     HDMA_CHER;     // HDMA Channel Handler Enable Register
    AT91_REG     HDMA_CHDR;     // HDMA Channel Handler Disable Register
    AT91_REG     HDMA_CHSR;     // HDMA Channel Handler Status Register
    AT91_REG     HDMA_RSVD0;    // HDMA Reserved
    AT91_REG     HDMA_RSVD1;    // HDMA Reserved
    AT91S_HDMA_CH    HDMA_CH[8];    // HDMA Channel structure
} AT91S_HDMA, *AT91PS_HDMA;
#else
#define HDMA_GCFG       (AT91_CAST(AT91_REG *)  0x00000000) // (HDMA_GCFG) HDMA Global Configuration Register
#define HDMA_EN         (AT91_CAST(AT91_REG *)  0x00000004) // (HDMA_EN) HDMA Controller Enable Register
#define HDMA_SREQ       (AT91_CAST(AT91_REG *)  0x00000008) // (HDMA_SREQ) HDMA Software Single Request Register
#define HDMA_CREQ       (AT91_CAST(AT91_REG *)  0x0000000C) // (HDMA_CREQ) HDMA Software Chunk Transfer Request Register
#define HDMA_LAST       (AT91_CAST(AT91_REG *)  0x00000010) // (HDMA_LAST) HDMA Software Last Transfer Flag Register
#define HDMA_SYNC       (AT91_CAST(AT91_REG *)  0x00000014) // (HDMA_SYNC) HDMA Request Synchronization Register
#define HDMA_EBCIER     (AT91_CAST(AT91_REG *)  0x00000018) // (HDMA_EBCIER) HDMA Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable register
#define HDMA_EBCIDR     (AT91_CAST(AT91_REG *)  0x0000001C) // (HDMA_EBCIDR) HDMA Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable register
#define HDMA_EBCIMR     (AT91_CAST(AT91_REG *)  0x00000020) // (HDMA_EBCIMR) HDMA Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register
#define HDMA_EBCISR     (AT91_CAST(AT91_REG *)  0x00000024) // (HDMA_EBCISR) HDMA Error, Chained Buffer transfer completed and Buffer transfer completed Status Register
#define HDMA_CHER       (AT91_CAST(AT91_REG *)  0x00000028) // (HDMA_CHER) HDMA Channel Handler Enable Register
#define HDMA_CHDR       (AT91_CAST(AT91_REG *)  0x0000002C) // (HDMA_CHDR) HDMA Channel Handler Disable Register
#define HDMA_CHSR       (AT91_CAST(AT91_REG *)  0x00000030) // (HDMA_CHSR) HDMA Channel Handler Status Register
#define HDMA_RSVD0      (AT91_CAST(AT91_REG *)  0x00000034) // (HDMA_RSVD0) HDMA Reserved
#define HDMA_RSVD1      (AT91_CAST(AT91_REG *)  0x00000038) // (HDMA_RSVD1) HDMA Reserved

#endif
// -------- HDMA_GCFG : (HDMA Offset: 0x0)  --------
#define AT91C_HDMA_IF0_BIGEND (0x1 <<  0) // (HDMA) AHB-Lite Interface 0 endian mode.
#define     AT91C_HDMA_IF0_BIGEND_IS_LITTLE_ENDIAN     (0x0) // (HDMA) AHB-Lite Interface 0 is little endian.
#define     AT91C_HDMA_IF0_BIGEND_IS_BIG_ENDIAN        (0x1) // (HDMA) AHB-Lite Interface 0 is big endian.
#define AT91C_HDMA_IF1_BIGEND (0x1 <<  1) // (HDMA) AHB-Lite Interface 1 endian mode.
#define     AT91C_HDMA_IF1_BIGEND_IS_LITTLE_ENDIAN     (0x0 <<  1) // (HDMA) AHB-Lite Interface 1 is little endian.
#define     AT91C_HDMA_IF1_BIGEND_IS_BIG_ENDIAN        (0x1 <<  1) // (HDMA) AHB-Lite Interface 1 is big endian.
#define AT91C_HDMA_IF2_BIGEND (0x1 <<  2) // (HDMA) AHB-Lite Interface 2 endian mode.
#define     AT91C_HDMA_IF2_BIGEND_IS_LITTLE_ENDIAN     (0x0 <<  2) // (HDMA) AHB-Lite Interface 2 is little endian.
#define     AT91C_HDMA_IF2_BIGEND_IS_BIG_ENDIAN        (0x1 <<  2) // (HDMA) AHB-Lite Interface 2 is big endian.
#define AT91C_HDMA_IF3_BIGEND (0x1 <<  3) // (HDMA) AHB-Lite Interface 3 endian mode.
#define     AT91C_HDMA_IF3_BIGEND_IS_LITTLE_ENDIAN     (0x0 <<  3) // (HDMA) AHB-Lite Interface 3 is little endian.
#define     AT91C_HDMA_IF3_BIGEND_IS_BIG_ENDIAN        (0x1 <<  3) // (HDMA) AHB-Lite Interface 3 is big endian.
#define AT91C_HDMA_ARB_CFG    (0x1 <<  4) // (HDMA) Arbiter mode.
#define     AT91C_HDMA_ARB_CFG_FIXED                (0x0 <<  4) // (HDMA) Fixed priority arbiter.
#define     AT91C_HDMA_ARB_CFG_ROUND_ROBIN          (0x1 <<  4) // (HDMA) Modified round robin arbiter.
// -------- HDMA_EN : (HDMA Offset: 0x4)  --------
#define AT91C_HDMA_ENABLE     (0x1 <<  0) // (HDMA)
#define     AT91C_HDMA_ENABLE_DISABLE              (0x0) // (HDMA) Disables HDMA.
#define     AT91C_HDMA_ENABLE_ENABLE               (0x1) // (HDMA) Enables HDMA.
// -------- HDMA_SREQ : (HDMA Offset: 0x8)  --------
#define AT91C_HDMA_SSREQ0     (0x1 <<  0) // (HDMA) Request a source single transfer on channel 0
#define     AT91C_HDMA_SSREQ0_0                    (0x0) // (HDMA) No effect.
#define     AT91C_HDMA_SSREQ0_1                    (0x1) // (HDMA) Request a source single transfer on channel 0.
#define AT91C_HDMA_DSREQ0     (0x1 <<  1) // (HDMA) Request a destination single transfer on channel 0
#define     AT91C_HDMA_DSREQ0_0                    (0x0 <<  1) // (HDMA) No effect.
#define     AT91C_HDMA_DSREQ0_1                    (0x1 <<  1) // (HDMA) Request a destination single transfer on channel 0.
#define AT91C_HDMA_SSREQ1     (0x1 <<  2) // (HDMA) Request a source single transfer on channel 1
#define     AT91C_HDMA_SSREQ1_0                    (0x0 <<  2) // (HDMA) No effect.
#define     AT91C_HDMA_SSREQ1_1                    (0x1 <<  2) // (HDMA) Request a source single transfer on channel 1.
#define AT91C_HDMA_DSREQ1     (0x1 <<  3) // (HDMA) Request a destination single transfer on channel 1
#define     AT91C_HDMA_DSREQ1_0                    (0x0 <<  3) // (HDMA) No effect.
#define     AT91C_HDMA_DSREQ1_1                    (0x1 <<  3) // (HDMA) Request a destination single transfer on channel 1.
#define AT91C_HDMA_SSREQ2     (0x1 <<  4) // (HDMA) Request a source single transfer on channel 2
#define     AT91C_HDMA_SSREQ2_0                    (0x0 <<  4) // (HDMA) No effect.
#define     AT91C_HDMA_SSREQ2_1                    (0x1 <<  4) // (HDMA) Request a source single transfer on channel 2.
#define AT91C_HDMA_DSREQ2     (0x1 <<  5) // (HDMA) Request a destination single transfer on channel 2
#define     AT91C_HDMA_DSREQ2_0                    (0x0 <<  5) // (HDMA) No effect.
#define     AT91C_HDMA_DSREQ2_1                    (0x1 <<  5) // (HDMA) Request a destination single transfer on channel 2.
#define AT91C_HDMA_SSREQ3     (0x1 <<  6) // (HDMA) Request a source single transfer on channel 3
#define     AT91C_HDMA_SSREQ3_0                    (0x0 <<  6) // (HDMA) No effect.
#define     AT91C_HDMA_SSREQ3_1                    (0x1 <<  6) // (HDMA) Request a source single transfer on channel 3.
#define AT91C_HDMA_DSREQ3     (0x1 <<  7) // (HDMA) Request a destination single transfer on channel 3
#define     AT91C_HDMA_DSREQ3_0                    (0x0 <<  7) // (HDMA) No effect.
#define     AT91C_HDMA_DSREQ3_1                    (0x1 <<  7) // (HDMA) Request a destination single transfer on channel 3.
#define AT91C_HDMA_SSREQ4     (0x1 <<  8) // (HDMA) Request a source single transfer on channel 4
#define     AT91C_HDMA_SSREQ4_0                    (0x0 <<  8) // (HDMA) No effect.
#define     AT91C_HDMA_SSREQ4_1                    (0x1 <<  8) // (HDMA) Request a source single transfer on channel 4.
#define AT91C_HDMA_DSREQ4     (0x1 <<  9) // (HDMA) Request a destination single transfer on channel 4
#define     AT91C_HDMA_DSREQ4_0                    (0x0 <<  9) // (HDMA) No effect.
#define     AT91C_HDMA_DSREQ4_1                    (0x1 <<  9) // (HDMA) Request a destination single transfer on channel 4.
#define AT91C_HDMA_SSREQ5     (0x1 << 10) // (HDMA) Request a source single transfer on channel 5
#define     AT91C_HDMA_SSREQ5_0                    (0x0 << 10) // (HDMA) No effect.
#define     AT91C_HDMA_SSREQ5_1                    (0x1 << 10) // (HDMA) Request a source single transfer on channel 5.
#define AT91C_HDMA_DSREQ6     (0x1 << 11) // (HDMA) Request a destination single transfer on channel 5
#define     AT91C_HDMA_DSREQ6_0                    (0x0 << 11) // (HDMA) No effect.
#define     AT91C_HDMA_DSREQ6_1                    (0x1 << 11) // (HDMA) Request a destination single transfer on channel 5.
#define AT91C_HDMA_SSREQ6     (0x1 << 12) // (HDMA) Request a source single transfer on channel 6
#define     AT91C_HDMA_SSREQ6_0                    (0x0 << 12) // (HDMA) No effect.
#define     AT91C_HDMA_SSREQ6_1                    (0x1 << 12) // (HDMA) Request a source single transfer on channel 6.
#define AT91C_HDMA_SSREQ7     (0x1 << 14) // (HDMA) Request a source single transfer on channel 7
#define     AT91C_HDMA_SSREQ7_0                    (0x0 << 14) // (HDMA) No effect.
#define     AT91C_HDMA_SSREQ7_1                    (0x1 << 14) // (HDMA) Request a source single transfer on channel 7.
#define AT91C_HDMA_DSREQ7     (0x1 << 15) // (HDMA) Request a destination single transfer on channel 7
#define     AT91C_HDMA_DSREQ7_0                    (0x0 << 15) // (HDMA) No effect.
#define     AT91C_HDMA_DSREQ7_1                    (0x1 << 15) // (HDMA) Request a destination single transfer on channel 7.
// -------- HDMA_CREQ : (HDMA Offset: 0xc)  --------
#define AT91C_HDMA_SCREQ0     (0x1 <<  0) // (HDMA) Request a source chunk transfer on channel 0
#define     AT91C_HDMA_SCREQ0_0                    (0x0) // (HDMA) No effect.
#define     AT91C_HDMA_SCREQ0_1                    (0x1) // (HDMA) Request a source chunk transfer on channel 0.
#define AT91C_HDMA_DCREQ0     (0x1 <<  1) // (HDMA) Request a destination chunk transfer on channel 0
#define     AT91C_HDMA_DCREQ0_0                    (0x0 <<  1) // (HDMA) No effect.
#define     AT91C_HDMA_DCREQ0_1                    (0x1 <<  1) // (HDMA) Request a destination chunk transfer on channel 0.
#define AT91C_HDMA_SCREQ1     (0x1 <<  2) // (HDMA) Request a source chunk transfer on channel 1
#define     AT91C_HDMA_SCREQ1_0                    (0x0 <<  2) // (HDMA) No effect.
#define     AT91C_HDMA_SCREQ1_1                    (0x1 <<  2) // (HDMA) Request a source chunk transfer on channel 1.
#define AT91C_HDMA_DCREQ1     (0x1 <<  3) // (HDMA) Request a destination chunk transfer on channel 1
#define     AT91C_HDMA_DCREQ1_0                    (0x0 <<  3) // (HDMA) No effect.
#define     AT91C_HDMA_DCREQ1_1                    (0x1 <<  3) // (HDMA) Request a destination chunk transfer on channel 1.
#define AT91C_HDMA_SCREQ2     (0x1 <<  4) // (HDMA) Request a source chunk transfer on channel 2
#define     AT91C_HDMA_SCREQ2_0                    (0x0 <<  4) // (HDMA) No effect.
#define     AT91C_HDMA_SCREQ2_1                    (0x1 <<  4) // (HDMA) Request a source chunk transfer on channel 2.
#define AT91C_HDMA_DCREQ2     (0x1 <<  5) // (HDMA) Request a destination chunk transfer on channel 2
#define     AT91C_HDMA_DCREQ2_0                    (0x0 <<  5) // (HDMA) No effect.
#define     AT91C_HDMA_DCREQ2_1                    (0x1 <<  5) // (HDMA) Request a destination chunk transfer on channel 2.
#define AT91C_HDMA_SCREQ3     (0x1 <<  6) // (HDMA) Request a source chunk transfer on channel 3
#define     AT91C_HDMA_SCREQ3_0                    (0x0 <<  6) // (HDMA) No effect.
#define     AT91C_HDMA_SCREQ3_1                    (0x1 <<  6) // (HDMA) Request a source chunk transfer on channel 3.
#define AT91C_HDMA_DCREQ3     (0x1 <<  7) // (HDMA) Request a destination chunk transfer on channel 3
#define     AT91C_HDMA_DCREQ3_0                    (0x0 <<  7) // (HDMA) No effect.
#define     AT91C_HDMA_DCREQ3_1                    (0x1 <<  7) // (HDMA) Request a destination chunk transfer on channel 3.
#define AT91C_HDMA_SCREQ4     (0x1 <<  8) // (HDMA) Request a source chunk transfer on channel 4
#define     AT91C_HDMA_SCREQ4_0                    (0x0 <<  8) // (HDMA) No effect.
#define     AT91C_HDMA_SCREQ4_1                    (0x1 <<  8) // (HDMA) Request a source chunk transfer on channel 4.
#define AT91C_HDMA_DCREQ4     (0x1 <<  9) // (HDMA) Request a destination chunk transfer on channel 4
#define     AT91C_HDMA_DCREQ4_0                    (0x0 <<  9) // (HDMA) No effect.
#define     AT91C_HDMA_DCREQ4_1                    (0x1 <<  9) // (HDMA) Request a destination chunk transfer on channel 4.
#define AT91C_HDMA_SCREQ5     (0x1 << 10) // (HDMA) Request a source chunk transfer on channel 5
#define     AT91C_HDMA_SCREQ5_0                    (0x0 << 10) // (HDMA) No effect.
#define     AT91C_HDMA_SCREQ5_1                    (0x1 << 10) // (HDMA) Request a source chunk transfer on channel 5.
#define AT91C_HDMA_DCREQ6     (0x1 << 11) // (HDMA) Request a destination chunk transfer on channel 5
#define     AT91C_HDMA_DCREQ6_0                    (0x0 << 11) // (HDMA) No effect.
#define     AT91C_HDMA_DCREQ6_1                    (0x1 << 11) // (HDMA) Request a destination chunk transfer on channel 5.
#define AT91C_HDMA_SCREQ6     (0x1 << 12) // (HDMA) Request a source chunk transfer on channel 6
#define     AT91C_HDMA_SCREQ6_0                    (0x0 << 12) // (HDMA) No effect.
#define     AT91C_HDMA_SCREQ6_1                    (0x1 << 12) // (HDMA) Request a source chunk transfer on channel 6.
#define AT91C_HDMA_SCREQ7     (0x1 << 14) // (HDMA) Request a source chunk transfer on channel 7
#define     AT91C_HDMA_SCREQ7_0                    (0x0 << 14) // (HDMA) No effect.
#define     AT91C_HDMA_SCREQ7_1                    (0x1 << 14) // (HDMA) Request a source chunk transfer on channel 7.
#define AT91C_HDMA_DCREQ7     (0x1 << 15) // (HDMA) Request a destination chunk transfer on channel 7
#define     AT91C_HDMA_DCREQ7_0                    (0x0 << 15) // (HDMA) No effect.
#define     AT91C_HDMA_DCREQ7_1                    (0x1 << 15) // (HDMA) Request a destination chunk transfer on channel 7.
// -------- HDMA_LAST : (HDMA Offset: 0x10)  --------
#define AT91C_HDMA_SLAST0     (0x1 <<  0) // (HDMA) Indicates that this source request is the last transfer of the buffer on channel 0
#define     AT91C_HDMA_SLAST0_0                    (0x0) // (HDMA) No effect.
#define     AT91C_HDMA_SLAST0_1                    (0x1) // (HDMA) Writing one to SLASTx prior to writing one to SSREQx or SCREQx indicates that this source request is the last transfer of the buffer on channel 0.
#define AT91C_HDMA_DLAST0     (0x1 <<  1) // (HDMA) Indicates that this destination request is the last transfer of the buffer on channel 0
#define     AT91C_HDMA_DLAST0_0                    (0x0 <<  1) // (HDMA) No effect.
#define     AT91C_HDMA_DLAST0_1                    (0x1 <<  1) // (HDMA) Writing one to DLASTx prior to writing one to DSREQx or DCREQx indicates that this destination request is the last transfer of the buffer on channel 0.
#define AT91C_HDMA_SLAST1     (0x1 <<  2) // (HDMA) Indicates that this source request is the last transfer of the buffer on channel 1
#define     AT91C_HDMA_SLAST1_0                    (0x0 <<  2) // (HDMA) No effect.
#define     AT91C_HDMA_SLAST1_1                    (0x1 <<  2) // (HDMA) Writing one to SLASTx prior to writing one to SSREQx or SCREQx indicates that this source request is the last transfer of the buffer on channel 1.
#define AT91C_HDMA_DLAST1     (0x1 <<  3) // (HDMA) Indicates that this destination request is the last transfer of the buffer on channel 1
#define     AT91C_HDMA_DLAST1_0                    (0x0 <<  3) // (HDMA) No effect.
#define     AT91C_HDMA_DLAST1_1                    (0x1 <<  3) // (HDMA) Writing one to DLASTx prior to writing one to DSREQx or DCREQx indicates that this destination request is the last transfer of the buffer on channel 1.
#define AT91C_HDMA_SLAST2     (0x1 <<  4) // (HDMA) Indicates that this source request is the last transfer of the buffer on channel 2
#define     AT91C_HDMA_SLAST2_0                    (0x0 <<  4) // (HDMA) No effect.
#define     AT91C_HDMA_SLAST2_1                    (0x1 <<  4) // (HDMA) Writing one to SLASTx prior to writing one to SSREQx or SCREQx indicates that this source request is the last transfer of the buffer on channel 2.
#define AT91C_HDMA_DLAST2     (0x1 <<  5) // (HDMA) Indicates that this destination request is the last transfer of the buffer on channel 2
#define     AT91C_HDMA_DLAST2_0                    (0x0 <<  5) // (HDMA) No effect.
#define     AT91C_HDMA_DLAST2_1                    (0x1 <<  5) // (HDMA) Writing one to DLASTx prior to writing one to DSREQx or DCREQx indicates that this destination request is the last transfer of the buffer on channel 2.
#define AT91C_HDMA_SLAST3     (0x1 <<  6) // (HDMA) Indicates that this source request is the last transfer of the buffer on channel 3
#define     AT91C_HDMA_SLAST3_0                    (0x0 <<  6) // (HDMA) No effect.
#define     AT91C_HDMA_SLAST3_1                    (0x1 <<  6) // (HDMA) Writing one to SLASTx prior to writing one to SSREQx or SCREQx indicates that this source request is the last transfer of the buffer on channel 3.
#define AT91C_HDMA_DLAST3     (0x1 <<  7) // (HDMA) Indicates that this destination request is the last transfer of the buffer on channel 3
#define     AT91C_HDMA_DLAST3_0                    (0x0 <<  7) // (HDMA) No effect.
#define     AT91C_HDMA_DLAST3_1                    (0x1 <<  7) // (HDMA) Writing one to DLASTx prior to writing one to DSREQx or DCREQx indicates that this destination request is the last transfer of the buffer on channel 3.
#define AT91C_HDMA_SLAST4     (0x1 <<  8) // (HDMA) Indicates that this source request is the last transfer of the buffer on channel 4
#define     AT91C_HDMA_SLAST4_0                    (0x0 <<  8) // (HDMA) No effect.
#define     AT91C_HDMA_SLAST4_1                    (0x1 <<  8) // (HDMA) Writing one to SLASTx prior to writing one to SSREQx or SCREQx indicates that this source request is the last transfer of the buffer on channel 4.
#define AT91C_HDMA_DLAST4     (0x1 <<  9) // (HDMA) Indicates that this destination request is the last transfer of the buffer on channel 4
#define     AT91C_HDMA_DLAST4_0                    (0x0 <<  9) // (HDMA) No effect.
#define     AT91C_HDMA_DLAST4_1                    (0x1 <<  9) // (HDMA) Writing one to DLASTx prior to writing one to DSREQx or DCREQx indicates that this destination request is the last transfer of the buffer on channel 4.
#define AT91C_HDMA_SLAST5     (0x1 << 10) // (HDMA) Indicates that this source request is the last transfer of the buffer on channel 5
#define     AT91C_HDMA_SLAST5_0                    (0x0 << 10) // (HDMA) No effect.
#define     AT91C_HDMA_SLAST5_1                    (0x1 << 10) // (HDMA) Writing one to SLASTx prior to writing one to SSREQx or SCREQx indicates that this source request is the last transfer of the buffer on channel 5.
#define AT91C_HDMA_DLAST6     (0x1 << 11) // (HDMA) Indicates that this destination request is the last transfer of the buffer on channel 5
#define     AT91C_HDMA_DLAST6_0                    (0x0 << 11) // (HDMA) No effect.
#define     AT91C_HDMA_DLAST6_1                    (0x1 << 11) // (HDMA) Writing one to DLASTx prior to writing one to DSREQx or DCREQx indicates that this destination request is the last transfer of the buffer on channel 5.
#define AT91C_HDMA_SLAST6     (0x1 << 12) // (HDMA) Indicates that this source request is the last transfer of the buffer on channel 6
#define     AT91C_HDMA_SLAST6_0                    (0x0 << 12) // (HDMA) No effect.
#define     AT91C_HDMA_SLAST6_1                    (0x1 << 12) // (HDMA) Writing one to SLASTx prior to writing one to SSREQx or SCREQx indicates that this source request is the last transfer of the buffer on channel 6.
#define AT91C_HDMA_SLAST7     (0x1 << 14) // (HDMA) Indicates that this source request is the last transfer of the buffer on channel 7
#define     AT91C_HDMA_SLAST7_0                    (0x0 << 14) // (HDMA) No effect.
#define     AT91C_HDMA_SLAST7_1                    (0x1 << 14) // (HDMA) Writing one to SLASTx prior to writing one to SSREQx or SCREQx indicates that this source request is the last transfer of the buffer on channel 7.
#define AT91C_HDMA_DLAST7     (0x1 << 15) // (HDMA) Indicates that this destination request is the last transfer of the buffer on channel 7
#define     AT91C_HDMA_DLAST7_0                    (0x0 << 15) // (HDMA) No effect.
#define     AT91C_HDMA_DLAST7_1                    (0x1 << 15) // (HDMA) Writing one to DLASTx prior to writing one to DSREQx or DCREQx indicates that this destination request is the last transfer of the buffer on channel 7.
// -------- HDMA_SYNC : (HDMA Offset: 0x14)  --------
#define AT91C_SYNC_REQ        (0xFFFF <<  0) // (HDMA)
// -------- HDMA_EBCIER : (HDMA Offset: 0x18) Buffer Transfer Completed/Chained Buffer Transfer Completed/Access Error Interrupt Enable Register --------
#define AT91C_HDMA_BTC0       (0x1 <<  0) // (HDMA) Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_BTC1       (0x1 <<  1) // (HDMA) Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_BTC2       (0x1 <<  2) // (HDMA) Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_BTC3       (0x1 <<  3) // (HDMA) Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_BTC4       (0x1 <<  4) // (HDMA) Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_BTC5       (0x1 <<  5) // (HDMA) Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_BTC6       (0x1 <<  6) // (HDMA) Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_BTC7       (0x1 <<  7) // (HDMA) Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_CBTC0      (0x1 <<  8) // (HDMA) Chained Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_CBTC1      (0x1 <<  9) // (HDMA) Chained Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_CBTC2      (0x1 << 10) // (HDMA) Chained Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_CBTC3      (0x1 << 11) // (HDMA) Chained Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_CBTC4      (0x1 << 12) // (HDMA) Chained Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_CBTC5      (0x1 << 13) // (HDMA) Chained Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_CBTC6      (0x1 << 14) // (HDMA) Chained Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_CBTC7      (0x1 << 15) // (HDMA) Chained Buffer Transfer Completed Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_ERR0       (0x1 << 16) // (HDMA) Access HDMA_Error Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_ERR1       (0x1 << 17) // (HDMA) Access HDMA_Error Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_ERR2       (0x1 << 18) // (HDMA) Access HDMA_Error Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_ERR3       (0x1 << 19) // (HDMA) Access HDMA_Error Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_ERR4       (0x1 << 20) // (HDMA) Access HDMA_Error Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_ERR5       (0x1 << 21) // (HDMA) Access HDMA_Error Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_ERR6       (0x1 << 22) // (HDMA) Access HDMA_Error Interrupt Enable/Disable/Status Register
#define AT91C_HDMA_ERR7       (0x1 << 23) // (HDMA) Access HDMA_Error Interrupt Enable/Disable/Status Register
// -------- HDMA_EBCIDR : (HDMA Offset: 0x1c)  --------
// -------- HDMA_EBCIMR : (HDMA Offset: 0x20)  --------
// -------- HDMA_EBCISR : (HDMA Offset: 0x24)  --------
// -------- HDMA_CHER : (HDMA Offset: 0x28)  --------
#define AT91C_HDMA_ENA0       (0x1 <<  0) // (HDMA) When set, channel 0 enabled.
#define     AT91C_HDMA_ENA0_0                    (0x0) // (HDMA) No effect.
#define     AT91C_HDMA_ENA0_1                    (0x1) // (HDMA) Channel 0 enabled.
#define AT91C_HDMA_ENA1       (0x1 <<  1) // (HDMA) When set, channel 1 enabled.
#define     AT91C_HDMA_ENA1_0                    (0x0 <<  1) // (HDMA) No effect.
#define     AT91C_HDMA_ENA1_1                    (0x1 <<  1) // (HDMA) Channel 1 enabled.
#define AT91C_HDMA_ENA2       (0x1 <<  2) // (HDMA) When set, channel 2 enabled.
#define     AT91C_HDMA_ENA2_0                    (0x0 <<  2) // (HDMA) No effect.
#define     AT91C_HDMA_ENA2_1                    (0x1 <<  2) // (HDMA) Channel 2 enabled.
#define AT91C_HDMA_ENA3       (0x1 <<  3) // (HDMA) When set, channel 3 enabled.
#define     AT91C_HDMA_ENA3_0                    (0x0 <<  3) // (HDMA) No effect.
#define     AT91C_HDMA_ENA3_1                    (0x1 <<  3) // (HDMA) Channel 3 enabled.
#define AT91C_HDMA_ENA4       (0x1 <<  4) // (HDMA) When set, channel 4 enabled.
#define     AT91C_HDMA_ENA4_0                    (0x0 <<  4) // (HDMA) No effect.
#define     AT91C_HDMA_ENA4_1                    (0x1 <<  4) // (HDMA) Channel 4 enabled.
#define AT91C_HDMA_ENA5       (0x1 <<  5) // (HDMA) When set, channel 5 enabled.
#define     AT91C_HDMA_ENA5_0                    (0x0 <<  5) // (HDMA) No effect.
#define     AT91C_HDMA_ENA5_1                    (0x1 <<  5) // (HDMA) Channel 5 enabled.
#define AT91C_HDMA_ENA6       (0x1 <<  6) // (HDMA) When set, channel 6 enabled.
#define     AT91C_HDMA_ENA6_0                    (0x0 <<  6) // (HDMA) No effect.
#define     AT91C_HDMA_ENA6_1                    (0x1 <<  6) // (HDMA) Channel 6 enabled.
#define AT91C_HDMA_ENA7       (0x1 <<  7) // (HDMA) When set, channel 7 enabled.
#define     AT91C_HDMA_ENA7_0                    (0x0 <<  7) // (HDMA) No effect.
#define     AT91C_HDMA_ENA7_1                    (0x1 <<  7) // (HDMA) Channel 7 enabled.
#define AT91C_HDMA_SUSP0      (0x1 <<  8) // (HDMA) When set, channel 0 freezed and its current context.
#define     AT91C_HDMA_SUSP0_0                    (0x0 <<  8) // (HDMA) No effect.
#define     AT91C_HDMA_SUSP0_1                    (0x1 <<  8) // (HDMA) Channel 0 freezed.
#define AT91C_HDMA_SUSP1      (0x1 <<  9) // (HDMA) When set, channel 1 freezed and its current context.
#define     AT91C_HDMA_SUSP1_0                    (0x0 <<  9) // (HDMA) No effect.
#define     AT91C_HDMA_SUSP1_1                    (0x1 <<  9) // (HDMA) Channel 1 freezed.
#define AT91C_HDMA_SUSP2      (0x1 << 10) // (HDMA) When set, channel 2 freezed and its current context.
#define     AT91C_HDMA_SUSP2_0                    (0x0 << 10) // (HDMA) No effect.
#define     AT91C_HDMA_SUSP2_1                    (0x1 << 10) // (HDMA) Channel 2 freezed.
#define AT91C_HDMA_SUSP3      (0x1 << 11) // (HDMA) When set, channel 3 freezed and its current context.
#define     AT91C_HDMA_SUSP3_0                    (0x0 << 11) // (HDMA) No effect.
#define     AT91C_HDMA_SUSP3_1                    (0x1 << 11) // (HDMA) Channel 3 freezed.
#define AT91C_HDMA_SUSP4      (0x1 << 12) // (HDMA) When set, channel 4 freezed and its current context.
#define     AT91C_HDMA_SUSP4_0                    (0x0 << 12) // (HDMA) No effect.
#define     AT91C_HDMA_SUSP4_1                    (0x1 << 12) // (HDMA) Channel 4 freezed.
#define AT91C_HDMA_SUSP5      (0x1 << 13) // (HDMA) When set, channel 5 freezed and its current context.
#define     AT91C_HDMA_SUSP5_0                    (0x0 << 13) // (HDMA) No effect.
#define     AT91C_HDMA_SUSP5_1                    (0x1 << 13) // (HDMA) Channel 5 freezed.
#define AT91C_HDMA_SUSP6      (0x1 << 14) // (HDMA) When set, channel 6 freezed and its current context.
#define     AT91C_HDMA_SUSP6_0                    (0x0 << 14) // (HDMA) No effect.
#define     AT91C_HDMA_SUSP6_1                    (0x1 << 14) // (HDMA) Channel 6 freezed.
#define AT91C_HDMA_SUSP7      (0x1 << 15) // (HDMA) When set, channel 7 freezed and its current context.
#define     AT91C_HDMA_SUSP7_0                    (0x0 << 15) // (HDMA) No effect.
#define     AT91C_HDMA_SUSP7_1                    (0x1 << 15) // (HDMA) Channel 7 freezed.
#define AT91C_HDMA_KEEP0      (0x1 << 24) // (HDMA) When set, it resumes the channel 0 from an automatic stall state.
#define     AT91C_HDMA_KEEP0_0                    (0x0 << 24) // (HDMA) No effect.
#define     AT91C_HDMA_KEEP0_1                    (0x1 << 24) // (HDMA) Resumes the channel 0.
#define AT91C_HDMA_KEEP1      (0x1 << 25) // (HDMA) When set, it resumes the channel 1 from an automatic stall state.
#define     AT91C_HDMA_KEEP1_0                    (0x0 << 25) // (HDMA) No effect.
#define     AT91C_HDMA_KEEP1_1                    (0x1 << 25) // (HDMA) Resumes the channel 1.
#define AT91C_HDMA_KEEP2      (0x1 << 26) // (HDMA) When set, it resumes the channel 2 from an automatic stall state.
#define     AT91C_HDMA_KEEP2_0                    (0x0 << 26) // (HDMA) No effect.
#define     AT91C_HDMA_KEEP2_1                    (0x1 << 26) // (HDMA) Resumes the channel 2.
#define AT91C_HDMA_KEEP3      (0x1 << 27) // (HDMA) When set, it resumes the channel 3 from an automatic stall state.
#define     AT91C_HDMA_KEEP3_0                    (0x0 << 27) // (HDMA) No effect.
#define     AT91C_HDMA_KEEP3_1                    (0x1 << 27) // (HDMA) Resumes the channel 3.
#define AT91C_HDMA_KEEP4      (0x1 << 28) // (HDMA) When set, it resumes the channel 4 from an automatic stall state.
#define     AT91C_HDMA_KEEP4_0                    (0x0 << 28) // (HDMA) No effect.
#define     AT91C_HDMA_KEEP4_1                    (0x1 << 28) // (HDMA) Resumes the channel 4.
#define AT91C_HDMA_KEEP5      (0x1 << 29) // (HDMA) When set, it resumes the channel 5 from an automatic stall state.
#define     AT91C_HDMA_KEEP5_0                    (0x0 << 29) // (HDMA) No effect.
#define     AT91C_HDMA_KEEP5_1                    (0x1 << 29) // (HDMA) Resumes the channel 5.
#define AT91C_HDMA_KEEP6      (0x1 << 30) // (HDMA) When set, it resumes the channel 6 from an automatic stall state.
#define     AT91C_HDMA_KEEP6_0                    (0x0 << 30) // (HDMA) No effect.
#define     AT91C_HDMA_KEEP6_1                    (0x1 << 30) // (HDMA) Resumes the channel 6.
#define AT91C_HDMA_KEEP7      (0x1 << 31) // (HDMA) When set, it resumes the channel 7 from an automatic stall state.
#define     AT91C_HDMA_KEEP7_0                    (0x0 << 31) // (HDMA) No effect.
#define     AT91C_HDMA_KEEP7_1                    (0x1 << 31) // (HDMA) Resumes the channel 7.
// -------- HDMA_CHDR : (HDMA Offset: 0x2c)  --------
#define AT91C_HDMA_DIS0       (0x1 <<  0) // (HDMA) Write one to this field to disable the channel 0.
#define     AT91C_HDMA_DIS0_0                    (0x0) // (HDMA) No effect.
#define     AT91C_HDMA_DIS0_1                    (0x1) // (HDMA) Disables the channel 0.
#define AT91C_HDMA_DIS1       (0x1 <<  1) // (HDMA) Write one to this field to disable the channel 1.
#define     AT91C_HDMA_DIS1_0                    (0x0 <<  1) // (HDMA) No effect.
#define     AT91C_HDMA_DIS1_1                    (0x1 <<  1) // (HDMA) Disables the channel 1.
#define AT91C_HDMA_DIS2       (0x1 <<  2) // (HDMA) Write one to this field to disable the channel 2.
#define     AT91C_HDMA_DIS2_0                    (0x0 <<  2) // (HDMA) No effect.
#define     AT91C_HDMA_DIS2_1                    (0x1 <<  2) // (HDMA) Disables the channel 2.
#define AT91C_HDMA_DIS3       (0x1 <<  3) // (HDMA) Write one to this field to disable the channel 3.
#define     AT91C_HDMA_DIS3_0                    (0x0 <<  3) // (HDMA) No effect.
#define     AT91C_HDMA_DIS3_1                    (0x1 <<  3) // (HDMA) Disables the channel 3.
#define AT91C_HDMA_DIS4       (0x1 <<  4) // (HDMA) Write one to this field to disable the channel 4.
#define     AT91C_HDMA_DIS4_0                    (0x0 <<  4) // (HDMA) No effect.
#define     AT91C_HDMA_DIS4_1                    (0x1 <<  4) // (HDMA) Disables the channel 4.
#define AT91C_HDMA_DIS5       (0x1 <<  5) // (HDMA) Write one to this field to disable the channel 5.
#define     AT91C_HDMA_DIS5_0                    (0x0 <<  5) // (HDMA) No effect.
#define     AT91C_HDMA_DIS5_1                    (0x1 <<  5) // (HDMA) Disables the channel 5.
#define AT91C_HDMA_DIS6       (0x1 <<  6) // (HDMA) Write one to this field to disable the channel 6.
#define     AT91C_HDMA_DIS6_0                    (0x0 <<  6) // (HDMA) No effect.
#define     AT91C_HDMA_DIS6_1                    (0x1 <<  6) // (HDMA) Disables the channel 6.
#define AT91C_HDMA_DIS7       (0x1 <<  7) // (HDMA) Write one to this field to disable the channel 7.
#define     AT91C_HDMA_DIS7_0                    (0x0 <<  7) // (HDMA) No effect.
#define     AT91C_HDMA_DIS7_1                    (0x1 <<  7) // (HDMA) Disables the channel 7.
#define AT91C_HDMA_RES0       (0x1 <<  8) // (HDMA) Write one to this field to resume the channel 0 transfer restoring its context.
#define     AT91C_HDMA_RES0_0                    (0x0 <<  8) // (HDMA) No effect.
#define     AT91C_HDMA_RES0_1                    (0x1 <<  8) // (HDMA) Resumes the channel 0.
#define AT91C_HDMA_RES1       (0x1 <<  9) // (HDMA) Write one to this field to resume the channel 1 transfer restoring its context.
#define     AT91C_HDMA_RES1_0                    (0x0 <<  9) // (HDMA) No effect.
#define     AT91C_HDMA_RES1_1                    (0x1 <<  9) // (HDMA) Resumes the channel 1.
#define AT91C_HDMA_RES2       (0x1 << 10) // (HDMA) Write one to this field to resume the channel 2 transfer restoring its context.
#define     AT91C_HDMA_RES2_0                    (0x0 << 10) // (HDMA) No effect.
#define     AT91C_HDMA_RES2_1                    (0x1 << 10) // (HDMA) Resumes the channel 2.
#define AT91C_HDMA_RES3       (0x1 << 11) // (HDMA) Write one to this field to resume the channel 3 transfer restoring its context.
#define     AT91C_HDMA_RES3_0                    (0x0 << 11) // (HDMA) No effect.
#define     AT91C_HDMA_RES3_1                    (0x1 << 11) // (HDMA) Resumes the channel 3.
#define AT91C_HDMA_RES4       (0x1 << 12) // (HDMA) Write one to this field to resume the channel 4 transfer restoring its context.
#define     AT91C_HDMA_RES4_0                    (0x0 << 12) // (HDMA) No effect.
#define     AT91C_HDMA_RES4_1                    (0x1 << 12) // (HDMA) Resumes the channel 4.
#define AT91C_HDMA_RES5       (0x1 << 13) // (HDMA) Write one to this field to resume the channel 5 transfer restoring its context.
#define     AT91C_HDMA_RES5_0                    (0x0 << 13) // (HDMA) No effect.
#define     AT91C_HDMA_RES5_1                    (0x1 << 13) // (HDMA) Resumes the channel 5.
#define AT91C_HDMA_RES6       (0x1 << 14) // (HDMA) Write one to this field to resume the channel 6 transfer restoring its context.
#define     AT91C_HDMA_RES6_0                    (0x0 << 14) // (HDMA) No effect.
#define     AT91C_HDMA_RES6_1                    (0x1 << 14) // (HDMA) Resumes the channel 6.
#define AT91C_HDMA_RES7       (0x1 << 15) // (HDMA) Write one to this field to resume the channel 7 transfer restoring its context.
#define     AT91C_HDMA_RES7_0                    (0x0 << 15) // (HDMA) No effect.
#define     AT91C_HDMA_RES7_1                    (0x1 << 15) // (HDMA) Resumes the channel 7.
// -------- HDMA_CHSR : (HDMA Offset: 0x30)  --------
#define AT91C_HDMA_EMPT0      (0x1 << 16) // (HDMA) When set, channel 0 is empty.
#define     AT91C_HDMA_EMPT0_0                    (0x0 << 16) // (HDMA) No effect.
#define     AT91C_HDMA_EMPT0_1                    (0x1 << 16) // (HDMA) Channel 0 empty.
#define AT91C_HDMA_EMPT1      (0x1 << 17) // (HDMA) When set, channel 1 is empty.
#define     AT91C_HDMA_EMPT1_0                    (0x0 << 17) // (HDMA) No effect.
#define     AT91C_HDMA_EMPT1_1                    (0x1 << 17) // (HDMA) Channel 1 empty.
#define AT91C_HDMA_EMPT2      (0x1 << 18) // (HDMA) When set, channel 2 is empty.
#define     AT91C_HDMA_EMPT2_0                    (0x0 << 18) // (HDMA) No effect.
#define     AT91C_HDMA_EMPT2_1                    (0x1 << 18) // (HDMA) Channel 2 empty.
#define AT91C_HDMA_EMPT3      (0x1 << 19) // (HDMA) When set, channel 3 is empty.
#define     AT91C_HDMA_EMPT3_0                    (0x0 << 19) // (HDMA) No effect.
#define     AT91C_HDMA_EMPT3_1                    (0x1 << 19) // (HDMA) Channel 3 empty.
#define AT91C_HDMA_EMPT4      (0x1 << 20) // (HDMA) When set, channel 4 is empty.
#define     AT91C_HDMA_EMPT4_0                    (0x0 << 20) // (HDMA) No effect.
#define     AT91C_HDMA_EMPT4_1                    (0x1 << 20) // (HDMA) Channel 4 empty.
#define AT91C_HDMA_EMPT5      (0x1 << 21) // (HDMA) When set, channel 5 is empty.
#define     AT91C_HDMA_EMPT5_0                    (0x0 << 21) // (HDMA) No effect.
#define     AT91C_HDMA_EMPT5_1                    (0x1 << 21) // (HDMA) Channel 5 empty.
#define AT91C_HDMA_EMPT6      (0x1 << 22) // (HDMA) When set, channel 6 is empty.
#define     AT91C_HDMA_EMPT6_0                    (0x0 << 22) // (HDMA) No effect.
#define     AT91C_HDMA_EMPT6_1                    (0x1 << 22) // (HDMA) Channel 6 empty.
#define AT91C_HDMA_EMPT7      (0x1 << 23) // (HDMA) When set, channel 7 is empty.
#define     AT91C_HDMA_EMPT7_0                    (0x0 << 23) // (HDMA) No effect.
#define     AT91C_HDMA_EMPT7_1                    (0x1 << 23) // (HDMA) Channel 7 empty.
#define AT91C_HDMA_STAL0      (0x1 << 24) // (HDMA) When set, channel 0 is stalled.
#define     AT91C_HDMA_STAL0_0                    (0x0 << 24) // (HDMA) No effect.
#define     AT91C_HDMA_STAL0_1                    (0x1 << 24) // (HDMA) Channel 0 stalled.
#define AT91C_HDMA_STAL1      (0x1 << 25) // (HDMA) When set, channel 1 is stalled.
#define     AT91C_HDMA_STAL1_0                    (0x0 << 25) // (HDMA) No effect.
#define     AT91C_HDMA_STAL1_1                    (0x1 << 25) // (HDMA) Channel 1 stalled.
#define AT91C_HDMA_STAL2      (0x1 << 26) // (HDMA) When set, channel 2 is stalled.
#define     AT91C_HDMA_STAL2_0                    (0x0 << 26) // (HDMA) No effect.
#define     AT91C_HDMA_STAL2_1                    (0x1 << 26) // (HDMA) Channel 2 stalled.
#define AT91C_HDMA_STAL3      (0x1 << 27) // (HDMA) When set, channel 3 is stalled.
#define     AT91C_HDMA_STAL3_0                    (0x0 << 27) // (HDMA) No effect.
#define     AT91C_HDMA_STAL3_1                    (0x1 << 27) // (HDMA) Channel 3 stalled.
#define AT91C_HDMA_STAL4      (0x1 << 28) // (HDMA) When set, channel 4 is stalled.
#define     AT91C_HDMA_STAL4_0                    (0x0 << 28) // (HDMA) No effect.
#define     AT91C_HDMA_STAL4_1                    (0x1 << 28) // (HDMA) Channel 4 stalled.
#define AT91C_HDMA_STAL5      (0x1 << 29) // (HDMA) When set, channel 5 is stalled.
#define     AT91C_HDMA_STAL5_0                    (0x0 << 29) // (HDMA) No effect.
#define     AT91C_HDMA_STAL5_1                    (0x1 << 29) // (HDMA) Channel 5 stalled.
#define AT91C_HDMA_STAL6      (0x1 << 30) // (HDMA) When set, channel 6 is stalled.
#define     AT91C_HDMA_STAL6_0                    (0x0 << 30) // (HDMA) No effect.
#define     AT91C_HDMA_STAL6_1                    (0x1 << 30) // (HDMA) Channel 6 stalled.
#define AT91C_HDMA_STAL7      (0x1 << 31) // (HDMA) When set, channel 7 is stalled.
#define     AT91C_HDMA_STAL7_0                    (0x0 << 31) // (HDMA) No effect.
#define     AT91C_HDMA_STAL7_1                    (0x1 << 31) // (HDMA) Channel 7 stalled.
// -------- HDMA_RSVD : (HDMA Offset: 0x34)  --------
// -------- HDMA_RSVD : (HDMA Offset: 0x38)  --------

/*
// *****************************************************************************
//   SOFTWARE API DEFINITION FOR DMA Controller
// *****************************************************************************
#ifndef __ASSEMBLY__
typedef struct _AT91S_DMAC {
  AT91_REG DMAC_GCFG;    // DMAC Global Configuration Register
  AT91_REG DMAC_EN;      // DMAC Enable Register
  AT91_REG Reserved1[4];
  AT91_REG DMAC_EBCIER;  // DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable Register
  AT91_REG DMAC_EBCIDR;  // DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable Register
  AT91_REG DMAC_EBCIMR;  // DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register
  AT91_REG DMAC_EBCISR;  // DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Status Register
  AT91_REG DMAC_CHER;    // DMAC Channel Handler Enable Register
  AT91_REG DMAC_CHDR;    // DMAC Channel Handler Disable Register
  AT91_REG DMAC_CHSR;    // DMAC Channel Handler Status Register
  AT91_REG Reserved2[2];
  AT91_REG DMAC_SADDR0;  // DMAC Channel Source Address Register (ch_num = 0)
  AT91_REG DMAC_DADDR0;  // DMAC Channel Destination Address Register (ch_num = 0)
  AT91_REG DMAC_DSCR0;   // DMAC Channel Descriptor Address Register (ch_num = 0)
  AT91_REG DMAC_CTRLA0;  // DMAC Channel Control A Register (ch_num = 0)
  AT91_REG DMAC_CTRLB0;  // DMAC Channel Control B Register (ch_num = 0)
  AT91_REG DMAC_CFG0;    // DMAC Channel Configuration Register (ch_num = 0)
  AT91_REG DMAC_SPIP0;   // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 0)
  AT91_REG DMAC_DPIP0;   // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 0)
  AT91_REG Reserved3[2];
  AT91_REG DMAC_SADDR1;  // DMAC Channel Source Address Register (ch_num = 1)
  AT91_REG DMAC_DADDR1;  // DMAC Channel Destination Address Register (ch_num = 1)
  AT91_REG DMAC_DSCR1;   // DMAC Channel Descriptor Address Register (ch_num = 1)
  AT91_REG DMAC_CTRLA1;  // DMAC Channel Control A Register (ch_num = 1)
  AT91_REG DMAC_CTRLB1;  // DMAC Channel Control B Register (ch_num = 1)
  AT91_REG DMAC_CFG1;    // DMAC Channel Configuration Register (ch_num = 1)
  AT91_REG DMAC_SPIP1;   // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 1)
  AT91_REG DMAC_DPIP1;   // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 1)
  AT91_REG Reserved4[2];
  AT91_REG DMAC_SADDR2;  // DMAC Channel Source Address Register (ch_num = 2)
  AT91_REG DMAC_DADDR2;  // DMAC Channel Destination Address Register (ch_num = 2)
  AT91_REG DMAC_DSCR2;   // DMAC Channel Descriptor Address Register (ch_num = 2)
  AT91_REG DMAC_CTRLA2;  // DMAC Channel Control A Register (ch_num = 2)
  AT91_REG DMAC_CTRLB2;  // DMAC Channel Control B Register (ch_num = 2)
  AT91_REG DMAC_CFG2;    // DMAC Channel Configuration Register (ch_num = 2)
  AT91_REG DMAC_SPIP2;   // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 2)
  AT91_REG DMAC_DPIP2;   // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 2)
  AT91_REG Reserved5[2];
  AT91_REG DMAC_SADDR3;  // DMAC Channel Source Address Register (ch_num = 3)
  AT91_REG DMAC_DADDR3;  // DMAC Channel Destination Address Register (ch_num = 3)
  AT91_REG DMAC_DSCR3;   // DMAC Channel Descriptor Address Register (ch_num = 3)
  AT91_REG DMAC_CTRLA3;  // DMAC Channel Control A Register (ch_num = 3)
  AT91_REG DMAC_CTRLB3;  // DMAC Channel Control B Register (ch_num = 3)
  AT91_REG DMAC_CFG3;    // DMAC Channel Configuration Register (ch_num = 3)
  AT91_REG DMAC_SPIP3;   // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 3)
  AT91_REG DMAC_DPIP3;   // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 3)
  AT91_REG Reserved6[2];
  AT91_REG DMAC_SADDR4;  // DMAC Channel Source Address Register (ch_num = 4)
  AT91_REG DMAC_DADDR4;  // DMAC Channel Destination Address Register (ch_num = 4)
  AT91_REG DMAC_DSCR4;   // DMAC Channel Descriptor Address Register (ch_num = 4)
  AT91_REG DMAC_CTRLA4;  // DMAC Channel Control A Register (ch_num = 4)
  AT91_REG DMAC_CTRLB4;  // DMAC Channel Control B Register (ch_num = 4)
  AT91_REG DMAC_CFG4;    // DMAC Channel Configuration Register (ch_num = 4)
  AT91_REG DMAC_SPIP4;   // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 4)
  AT91_REG DMAC_DPIP4;   // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 4)
  AT91_REG Reserved7[2];
  AT91_REG DMAC_SADDR5;  // DMAC Channel Source Address Register (ch_num = 5)
  AT91_REG DMAC_DADDR5;  // DMAC Channel Destination Address Register (ch_num = 5)
  AT91_REG DMAC_DSCR5;   // DMAC Channel Descriptor Address Register (ch_num = 5)
  AT91_REG DMAC_CTRLA5;  // DMAC Channel Control A Register (ch_num = 5)
  AT91_REG DMAC_CTRLB5;  // DMAC Channel Control B Register (ch_num = 5)
  AT91_REG DMAC_CFG5;    // DMAC Channel Configuration Register (ch_num = 5)
  AT91_REG DMAC_SPIP5;   // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 5)
  AT91_REG DMAC_DPIP5;   // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 5)
  AT91_REG Reserved8[2];
  AT91_REG DMAC_SADDR6;  // DMAC Channel Source Address Register (ch_num = 6)
  AT91_REG DMAC_DADDR6;  // DMAC Channel Destination Address Register (ch_num = 6)
  AT91_REG DMAC_DSCR6;   // DMAC Channel Descriptor Address Register (ch_num = 6)
  AT91_REG DMAC_CTRLA6;  // DMAC Channel Control A Register (ch_num = 6)
  AT91_REG DMAC_CTRLB6;  // DMAC Channel Control B Register (ch_num = 6)
  AT91_REG DMAC_CFG6;    // DMAC Channel Configuration Register (ch_num = 6)
  AT91_REG DMAC_SPIP6;   // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 6)
  AT91_REG DMAC_DPIP6;   // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 6)
  AT91_REG Reserved9[2];
  AT91_REG DMAC_SADDR7;  // DMAC Channel Source Address Register (ch_num = 7)
  AT91_REG DMAC_DADDR7;  // DMAC Channel Destination Address Register (ch_num = 7)
  AT91_REG DMAC_DSCR7;   // DMAC Channel Descriptor Address Register (ch_num = 7)
  AT91_REG DMAC_CTRLA7;  // DMAC Channel Control A Register (ch_num = 7)
  AT91_REG DMAC_CTRLB7;  // DMAC Channel Control B Register (ch_num = 7)
  AT91_REG DMAC_CFG7;    // DMAC Channel Configuration Register (ch_num = 7)
  AT91_REG DMAC_SPIP7;   // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 7)
  AT91_REG DMAC_DPIP7;   // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 7)
} AT91S_DMAC, *AT91PS_DMAC;
#else
#define DMAC_GCFG   (AT91_CAST(AT91_REG *) 0x00000000) // DMAC Global Configuration Register
#define DMAC_EN     (AT91_CAST(AT91_REG *) 0x00000004) // DMAC Enable Register
#define DMAC_EBCIER (AT91_CAST(AT91_REG *) 0x00000018) // DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable Register
#define DMAC_EBCIDR (AT91_CAST(AT91_REG *) 0x0000001C) // DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable Register
#define DMAC_EBCIMR (AT91_CAST(AT91_REG *) 0x00000020) // DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register
#define DMAC_EBCISR (AT91_CAST(AT91_REG *) 0x00000024) // DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Status Register
#define DMAC_CHER   (AT91_CAST(AT91_REG *) 0x00000028) // DMAC Channel Handler Enable Register
#define DMAC_CHDR   (AT91_CAST(AT91_REG *) 0x0000002C) // DMAC Channel Handler Disable Register
#define DMAC_CHSR   (AT91_CAST(AT91_REG *) 0x00000030) // DMAC Channel Handler Status Register
#define DMAC_SADDR0 (AT91_CAST(AT91_REG *) 0x0000003C) // DMAC Channel Source Address Register (ch_num = 0)
#define DMAC_DADDR0 (AT91_CAST(AT91_REG *) 0x00000040) // DMAC Channel Destination Address Register (ch_num = 0)
#define DMAC_DSCR0  (AT91_CAST(AT91_REG *) 0x00000044) // DMAC Channel Descriptor Address Register (ch_num = 0)
#define DMAC_CTRLA0 (AT91_CAST(AT91_REG *) 0x00000048) // DMAC Channel Control A Register (ch_num = 0)
#define DMAC_CTRLB0 (AT91_CAST(AT91_REG *) 0x0000004C) // DMAC Channel Control B Register (ch_num = 0)
#define DMAC_CFG0   (AT91_CAST(AT91_REG *) 0x00000050) // DMAC Channel Configuration Register (ch_num = 0)
#define DMAC_SPIP0  (AT91_CAST(AT91_REG *) 0x00000054) // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 0)
#define DMAC_DPIP0  (AT91_CAST(AT91_REG *) 0x00000058) // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 0)
#define DMAC_SADDR1 (AT91_CAST(AT91_REG *) 0x00000064) // DMAC Channel Source Address Register (ch_num = 1)
#define DMAC_DADDR1 (AT91_CAST(AT91_REG *) 0x00000068) // DMAC Channel Destination Address Register (ch_num = 1)
#define DMAC_DSCR1  (AT91_CAST(AT91_REG *) 0x0000006C) // DMAC Channel Descriptor Address Register (ch_num = 1)
#define DMAC_CTRLA1 (AT91_CAST(AT91_REG *) 0x00000070) // DMAC Channel Control A Register (ch_num = 1)
#define DMAC_CTRLB1 (AT91_CAST(AT91_REG *) 0x00000074) // DMAC Channel Control B Register (ch_num = 1)
#define DMAC_CFG1   (AT91_CAST(AT91_REG *) 0x00000078) // DMAC Channel Configuration Register (ch_num = 1)
#define DMAC_SPIP1  (AT91_CAST(AT91_REG *) 0x0000007C) // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 1)
#define DMAC_DPIP1  (AT91_CAST(AT91_REG *) 0x00000080) // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 1)
#define DMAC_SADDR2 (AT91_CAST(AT91_REG *) 0x0000008C) // DMAC Channel Source Address Register (ch_num = 2)
#define DMAC_DADDR2 (AT91_CAST(AT91_REG *) 0x00000090) // DMAC Channel Destination Address Register (ch_num = 2)
#define DMAC_DSCR2  (AT91_CAST(AT91_REG *) 0x00000094) // DMAC Channel Descriptor Address Register (ch_num = 2)
#define DMAC_CTRLA2 (AT91_CAST(AT91_REG *) 0x00000098) // DMAC Channel Control A Register (ch_num = 2)
#define DMAC_CTRLB2 (AT91_CAST(AT91_REG *) 0x0000009C) // DMAC Channel Control B Register (ch_num = 2)
#define DMAC_CFG2   (AT91_CAST(AT91_REG *) 0x000000A0) // DMAC Channel Configuration Register (ch_num = 2)
#define DMAC_SPIP2  (AT91_CAST(AT91_REG *) 0x000000A4) // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 2)
#define DMAC_DPIP2  (AT91_CAST(AT91_REG *) 0x000000A8) // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 2)
#define DMAC_SADDR3 (AT91_CAST(AT91_REG *) 0x000000B4) // DMAC Channel Source Address Register (ch_num = 3)
#define DMAC_DADDR3 (AT91_CAST(AT91_REG *) 0x000000B8) // DMAC Channel Destination Address Register (ch_num = 3)
#define DMAC_DSCR3  (AT91_CAST(AT91_REG *) 0x000000BC) // DMAC Channel Descriptor Address Register (ch_num = 3)
#define DMAC_CTRLA3 (AT91_CAST(AT91_REG *) 0x000000C0) // DMAC Channel Control A Register (ch_num = 3)
#define DMAC_CTRLB3 (AT91_CAST(AT91_REG *) 0x000000C4) // DMAC Channel Control B Register (ch_num = 3)
#define DMAC_CFG3   (AT91_CAST(AT91_REG *) 0x000000C8) // DMAC Channel Configuration Register (ch_num = 3)
#define DMAC_SPIP3  (AT91_CAST(AT91_REG *) 0x000000CC) // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 3)
#define DMAC_DPIP3  (AT91_CAST(AT91_REG *) 0x000000D0) // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 3)
#define DMAC_SADDR4 (AT91_CAST(AT91_REG *) 0x000000DC) // DMAC Channel Source Address Register (ch_num = 4)
#define DMAC_DADDR4 (AT91_CAST(AT91_REG *) 0x000000E0) // DMAC Channel Destination Address Register (ch_num = 4)
#define DMAC_DSCR4  (AT91_CAST(AT91_REG *) 0x000000E4) // DMAC Channel Descriptor Address Register (ch_num = 4)
#define DMAC_CTRLA4 (AT91_CAST(AT91_REG *) 0x000000E8) // DMAC Channel Control A Register (ch_num = 4)
#define DMAC_CTRLB4 (AT91_CAST(AT91_REG *) 0x000000EC) // DMAC Channel Control B Register (ch_num = 4)
#define DMAC_CFG4   (AT91_CAST(AT91_REG *) 0x000000F0) // DMAC Channel Configuration Register (ch_num = 4)
#define DMAC_SPIP4  (AT91_CAST(AT91_REG *) 0x000000F4) // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 4)
#define DMAC_DPIP4  (AT91_CAST(AT91_REG *) 0x000000F8) // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 4)
#define DMAC_SADDR5 (AT91_CAST(AT91_REG *) 0x00000104) // DMAC Channel Source Address Register (ch_num = 5)
#define DMAC_DADDR5 (AT91_CAST(AT91_REG *) 0x00000108) // DMAC Channel Destination Address Register (ch_num = 5)
#define DMAC_DSCR5  (AT91_CAST(AT91_REG *) 0x0000010C) // DMAC Channel Descriptor Address Register (ch_num = 5)
#define DMAC_CTRLA5 (AT91_CAST(AT91_REG *) 0x00000110) // DMAC Channel Control A Register (ch_num = 5)
#define DMAC_CTRLB5 (AT91_CAST(AT91_REG *) 0x00000114) // DMAC Channel Control B Register (ch_num = 5)
#define DMAC_CFG5   (AT91_CAST(AT91_REG *) 0x00000118) // DMAC Channel Configuration Register (ch_num = 5)
#define DMAC_SPIP5  (AT91_CAST(AT91_REG *) 0x0000011C) // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 5)
#define DMAC_DPIP5  (AT91_CAST(AT91_REG *) 0x00000120) // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 5)
#define DMAC_SADDR6 (AT91_CAST(AT91_REG *) 0x0000012C) // DMAC Channel Source Address Register (ch_num = 6)
#define DMAC_DADDR6 (AT91_CAST(AT91_REG *) 0x00000130) // DMAC Channel Destination Address Register (ch_num = 6)
#define DMAC_DSCR6  (AT91_CAST(AT91_REG *) 0x00000134) // DMAC Channel Descriptor Address Register (ch_num = 6)
#define DMAC_CTRLA6 (AT91_CAST(AT91_REG *) 0x00000138) // DMAC Channel Control A Register (ch_num = 6)
#define DMAC_CTRLB6 (AT91_CAST(AT91_REG *) 0x0000013C) // DMAC Channel Control B Register (ch_num = 6)
#define DMAC_CFG6   (AT91_CAST(AT91_REG *) 0x00000140) // DMAC Channel Configuration Register (ch_num = 6)
#define DMAC_SPIP6  (AT91_CAST(AT91_REG *) 0x00000144) // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 6)
#define DMAC_DPIP6  (AT91_CAST(AT91_REG *) 0x00000148) // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 6)
#define DMAC_SADDR7 (AT91_CAST(AT91_REG *) 0x00000154) // DMAC Channel Source Address Register (ch_num = 7)
#define DMAC_DADDR7 (AT91_CAST(AT91_REG *) 0x00000158) // DMAC Channel Destination Address Register (ch_num = 7)
#define DMAC_DSCR7  (AT91_CAST(AT91_REG *) 0x0000015C) // DMAC Channel Descriptor Address Register (ch_num = 7)
#define DMAC_CTRLA7 (AT91_CAST(AT91_REG *) 0x00000160) // DMAC Channel Control A Register (ch_num = 7)
#define DMAC_CTRLB7 (AT91_CAST(AT91_REG *) 0x00000164) // DMAC Channel Control B Register (ch_num = 7)
#define DMAC_CFG7   (AT91_CAST(AT91_REG *) 0x00000168) // DMAC Channel Configuration Register (ch_num = 7)
#define DMAC_SPIP7  (AT91_CAST(AT91_REG *) 0x0000016C) // DMAC Channel Source Picture in Picture Configuration Register (ch_num = 7)
#define DMAC_DPIP7  (AT91_CAST(AT91_REG *) 0x00000170) // DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 7)
#endif
// -------- DMAC_GCFG : (DMAC Offset: 0x000) DMAC Global Configuration Register --------
#define AT91C_DMAC_GCFG_IF0_BIGEND (0x1 << 0) // (DMAC)
#define AT91C_DMAC_GCFG_IF1_BIGEND (0x1 << 1) // (DMAC)
#define AT91C_DMAC_GCFG_ARB_CFG (0x1 << 4) // (DMAC)
// -------- DMAC_EN : (DMAC Offset: 0x004) DMAC Enable Register --------
#define AT91C_DMAC_EN_ENABLE (0x1 << 0) // (DMAC)
// -------- DMAC_EBCIER : (DMAC Offset: 0x018) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable Register --------
#define AT91C_DMAC_EBCIER_BTC0 (0x1 << 0) // (DMAC)
#define AT91C_DMAC_EBCIER_BTC1 (0x1 << 1) // (DMAC)
#define AT91C_DMAC_EBCIER_BTC2 (0x1 << 2) // (DMAC)
#define AT91C_DMAC_EBCIER_BTC3 (0x1 << 3) // (DMAC)
#define AT91C_DMAC_EBCIER_BTC4 (0x1 << 4) // (DMAC)
#define AT91C_DMAC_EBCIER_BTC5 (0x1 << 5) // (DMAC)
#define AT91C_DMAC_EBCIER_BTC6 (0x1 << 6) // (DMAC)
#define AT91C_DMAC_EBCIER_BTC7 (0x1 << 7) // (DMAC)
#define AT91C_DMAC_EBCIER_CBTC0 (0x1 << 8) // (DMAC)
#define AT91C_DMAC_EBCIER_CBTC1 (0x1 << 9) // (DMAC)
#define AT91C_DMAC_EBCIER_CBTC2 (0x1 << 10) // (DMAC)
#define AT91C_DMAC_EBCIER_CBTC3 (0x1 << 11) // (DMAC)
#define AT91C_DMAC_EBCIER_CBTC4 (0x1 << 12) // (DMAC)
#define AT91C_DMAC_EBCIER_CBTC5 (0x1 << 13) // (DMAC)
#define AT91C_DMAC_EBCIER_CBTC6 (0x1 << 14) // (DMAC)
#define AT91C_DMAC_EBCIER_CBTC7 (0x1 << 15) // (DMAC)
#define AT91C_DMAC_EBCIER_ERR0 (0x1 << 16) // (DMAC)
#define AT91C_DMAC_EBCIER_ERR1 (0x1 << 17) // (DMAC)
#define AT91C_DMAC_EBCIER_ERR2 (0x1 << 18) // (DMAC)
#define AT91C_DMAC_EBCIER_ERR3 (0x1 << 19) // (DMAC)
#define AT91C_DMAC_EBCIER_ERR4 (0x1 << 20) // (DMAC)
#define AT91C_DMAC_EBCIER_ERR5 (0x1 << 21) // (DMAC)
#define AT91C_DMAC_EBCIER_ERR6 (0x1 << 22) // (DMAC)
#define AT91C_DMAC_EBCIER_ERR7 (0x1 << 23) // (DMAC)
// -------- DMAC_EBCIDR : (DMAC Offset: 0x01C) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable Register --------
#define AT91C_DMAC_EBCIDR_BTC0 (0x1 << 0) // (DMAC)
#define AT91C_DMAC_EBCIDR_BTC1 (0x1 << 1) // (DMAC)
#define AT91C_DMAC_EBCIDR_BTC2 (0x1 << 2) // (DMAC)
#define AT91C_DMAC_EBCIDR_BTC3 (0x1 << 3) // (DMAC)
#define AT91C_DMAC_EBCIDR_BTC4 (0x1 << 4) // (DMAC)
#define AT91C_DMAC_EBCIDR_BTC5 (0x1 << 5) // (DMAC)
#define AT91C_DMAC_EBCIDR_BTC6 (0x1 << 6) // (DMAC)
#define AT91C_DMAC_EBCIDR_BTC7 (0x1 << 7) // (DMAC)
#define AT91C_DMAC_EBCIDR_CBTC0 (0x1 << 8) // (DMAC)
#define AT91C_DMAC_EBCIDR_CBTC1 (0x1 << 9) // (DMAC)
#define AT91C_DMAC_EBCIDR_CBTC2 (0x1 << 10) // (DMAC)
#define AT91C_DMAC_EBCIDR_CBTC3 (0x1 << 11) // (DMAC)
#define AT91C_DMAC_EBCIDR_CBTC4 (0x1 << 12) // (DMAC)
#define AT91C_DMAC_EBCIDR_CBTC5 (0x1 << 13) // (DMAC)
#define AT91C_DMAC_EBCIDR_CBTC6 (0x1 << 14) // (DMAC)
#define AT91C_DMAC_EBCIDR_CBTC7 (0x1 << 15) // (DMAC)
#define AT91C_DMAC_EBCIDR_ERR0 (0x1 << 16) // (DMAC)
#define AT91C_DMAC_EBCIDR_ERR1 (0x1 << 17) // (DMAC)
#define AT91C_DMAC_EBCIDR_ERR2 (0x1 << 18) // (DMAC)
#define AT91C_DMAC_EBCIDR_ERR3 (0x1 << 19) // (DMAC)
#define AT91C_DMAC_EBCIDR_ERR4 (0x1 << 20) // (DMAC)
#define AT91C_DMAC_EBCIDR_ERR5 (0x1 << 21) // (DMAC)
#define AT91C_DMAC_EBCIDR_ERR6 (0x1 << 22) // (DMAC)
#define AT91C_DMAC_EBCIDR_ERR7 (0x1 << 23) // (DMAC)
// -------- DMAC_EBCIMR : (DMAC Offset: 0x020) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register --------
#define AT91C_DMAC_EBCIMR_BTC0 (0x1 << 0) // (DMAC)
#define AT91C_DMAC_EBCIMR_BTC1 (0x1 << 1) // (DMAC)
#define AT91C_DMAC_EBCIMR_BTC2 (0x1 << 2) // (DMAC)
#define AT91C_DMAC_EBCIMR_BTC3 (0x1 << 3) // (DMAC)
#define AT91C_DMAC_EBCIMR_BTC4 (0x1 << 4) // (DMAC)
#define AT91C_DMAC_EBCIMR_BTC5 (0x1 << 5) // (DMAC)
#define AT91C_DMAC_EBCIMR_BTC6 (0x1 << 6) // (DMAC)
#define AT91C_DMAC_EBCIMR_BTC7 (0x1 << 7) // (DMAC)
#define AT91C_DMAC_EBCIMR_CBTC0 (0x1 << 8) // (DMAC)
#define AT91C_DMAC_EBCIMR_CBTC1 (0x1 << 9) // (DMAC)
#define AT91C_DMAC_EBCIMR_CBTC2 (0x1 << 10) // (DMAC)
#define AT91C_DMAC_EBCIMR_CBTC3 (0x1 << 11) // (DMAC)
#define AT91C_DMAC_EBCIMR_CBTC4 (0x1 << 12) // (DMAC)
#define AT91C_DMAC_EBCIMR_CBTC5 (0x1 << 13) // (DMAC)
#define AT91C_DMAC_EBCIMR_CBTC6 (0x1 << 14) // (DMAC)
#define AT91C_DMAC_EBCIMR_CBTC7 (0x1 << 15) // (DMAC)
#define AT91C_DMAC_EBCIMR_ERR0 (0x1 << 16) // (DMAC)
#define AT91C_DMAC_EBCIMR_ERR1 (0x1 << 17) // (DMAC)
#define AT91C_DMAC_EBCIMR_ERR2 (0x1 << 18) // (DMAC)
#define AT91C_DMAC_EBCIMR_ERR3 (0x1 << 19) // (DMAC)
#define AT91C_DMAC_EBCIMR_ERR4 (0x1 << 20) // (DMAC)
#define AT91C_DMAC_EBCIMR_ERR5 (0x1 << 21) // (DMAC)
#define AT91C_DMAC_EBCIMR_ERR6 (0x1 << 22) // (DMAC)
#define AT91C_DMAC_EBCIMR_ERR7 (0x1 << 23) // (DMAC)
// -------- DMAC_EBCISR : (DMAC Offset: 0x024) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Status Register --------
#define AT91C_DMAC_EBCISR_BTC0 (0x1 << 0) // (DMAC)
#define AT91C_DMAC_EBCISR_BTC1 (0x1 << 1) // (DMAC)
#define AT91C_DMAC_EBCISR_BTC2 (0x1 << 2) // (DMAC)
#define AT91C_DMAC_EBCISR_BTC3 (0x1 << 3) // (DMAC)
#define AT91C_DMAC_EBCISR_BTC4 (0x1 << 4) // (DMAC)
#define AT91C_DMAC_EBCISR_BTC5 (0x1 << 5) // (DMAC)
#define AT91C_DMAC_EBCISR_BTC6 (0x1 << 6) // (DMAC)
#define AT91C_DMAC_EBCISR_BTC7 (0x1 << 7) // (DMAC)
#define AT91C_DMAC_EBCISR_CBTC0 (0x1 << 8) // (DMAC)
#define AT91C_DMAC_EBCISR_CBTC1 (0x1 << 9) // (DMAC)
#define AT91C_DMAC_EBCISR_CBTC2 (0x1 << 10) // (DMAC)
#define AT91C_DMAC_EBCISR_CBTC3 (0x1 << 11) // (DMAC)
#define AT91C_DMAC_EBCISR_CBTC4 (0x1 << 12) // (DMAC)
#define AT91C_DMAC_EBCISR_CBTC5 (0x1 << 13) // (DMAC)
#define AT91C_DMAC_EBCISR_CBTC6 (0x1 << 14) // (DMAC)
#define AT91C_DMAC_EBCISR_CBTC7 (0x1 << 15) // (DMAC)
#define AT91C_DMAC_EBCISR_ERR0 (0x1 << 16) // (DMAC)
#define AT91C_DMAC_EBCISR_ERR1 (0x1 << 17) // (DMAC)
#define AT91C_DMAC_EBCISR_ERR2 (0x1 << 18) // (DMAC)
#define AT91C_DMAC_EBCISR_ERR3 (0x1 << 19) // (DMAC)
#define AT91C_DMAC_EBCISR_ERR4 (0x1 << 20) // (DMAC)
#define AT91C_DMAC_EBCISR_ERR5 (0x1 << 21) // (DMAC)
#define AT91C_DMAC_EBCISR_ERR6 (0x1 << 22) // (DMAC)
#define AT91C_DMAC_EBCISR_ERR7 (0x1 << 23) // (DMAC)
// -------- DMAC_CHER : (DMAC Offset: 0x028) DMAC Channel Handler Enable Register --------
#define AT91C_DMAC_CHER_ENA0 (0x1 << 0) // (DMAC)
#define AT91C_DMAC_CHER_ENA1 (0x1 << 1) // (DMAC)
#define AT91C_DMAC_CHER_ENA2 (0x1 << 2) // (DMAC)
#define AT91C_DMAC_CHER_ENA3 (0x1 << 3) // (DMAC)
#define AT91C_DMAC_CHER_ENA4 (0x1 << 4) // (DMAC)
#define AT91C_DMAC_CHER_ENA5 (0x1 << 5) // (DMAC)
#define AT91C_DMAC_CHER_ENA6 (0x1 << 6) // (DMAC)
#define AT91C_DMAC_CHER_ENA7 (0x1 << 7) // (DMAC)
#define AT91C_DMAC_CHER_SUSP0 (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CHER_SUSP1 (0x1 << 9) // (DMAC)
#define AT91C_DMAC_CHER_SUSP2 (0x1 << 10) // (DMAC)
#define AT91C_DMAC_CHER_SUSP3 (0x1 << 11) // (DMAC)
#define AT91C_DMAC_CHER_SUSP4 (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CHER_SUSP5 (0x1 << 13) // (DMAC)
#define AT91C_DMAC_CHER_SUSP6 (0x1 << 14) // (DMAC)
#define AT91C_DMAC_CHER_SUSP7 (0x1 << 15) // (DMAC)
#define AT91C_DMAC_CHER_KEEP0 (0x1 << 24) // (DMAC)
#define AT91C_DMAC_CHER_KEEP1 (0x1 << 25) // (DMAC)
#define AT91C_DMAC_CHER_KEEP2 (0x1 << 26) // (DMAC)
#define AT91C_DMAC_CHER_KEEP3 (0x1 << 27) // (DMAC)
#define AT91C_DMAC_CHER_KEEP4 (0x1 << 28) // (DMAC)
#define AT91C_DMAC_CHER_KEEP5 (0x1 << 29) // (DMAC)
#define AT91C_DMAC_CHER_KEEP6 (0x1 << 30) // (DMAC)
#define AT91C_DMAC_CHER_KEEP7 (0x1 << 31) // (DMAC)
// -------- DMAC_CHDR : (DMAC Offset: 0x02C) DMAC Channel Handler Disable Register --------
#define AT91C_DMAC_CHDR_DIS0 (0x1 << 0) // (DMAC)
#define AT91C_DMAC_CHDR_DIS1 (0x1 << 1) // (DMAC)
#define AT91C_DMAC_CHDR_DIS2 (0x1 << 2) // (DMAC)
#define AT91C_DMAC_CHDR_DIS3 (0x1 << 3) // (DMAC)
#define AT91C_DMAC_CHDR_DIS4 (0x1 << 4) // (DMAC)
#define AT91C_DMAC_CHDR_DIS5 (0x1 << 5) // (DMAC)
#define AT91C_DMAC_CHDR_DIS6 (0x1 << 6) // (DMAC)
#define AT91C_DMAC_CHDR_DIS7 (0x1 << 7) // (DMAC)
#define AT91C_DMAC_CHDR_RES0 (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CHDR_RES1 (0x1 << 9) // (DMAC)
#define AT91C_DMAC_CHDR_RES2 (0x1 << 10) // (DMAC)
#define AT91C_DMAC_CHDR_RES3 (0x1 << 11) // (DMAC)
#define AT91C_DMAC_CHDR_RES4 (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CHDR_RES5 (0x1 << 13) // (DMAC)
#define AT91C_DMAC_CHDR_RES6 (0x1 << 14) // (DMAC)
#define AT91C_DMAC_CHDR_RES7 (0x1 << 15) // (DMAC)
// -------- DMAC_CHSR : (DMAC Offset: 0x030) DMAC Channel Handler Status Register --------
#define AT91C_DMAC_CHSR_ENA0 (0x1 << 0) // (DMAC)
#define AT91C_DMAC_CHSR_ENA1 (0x1 << 1) // (DMAC)
#define AT91C_DMAC_CHSR_ENA2 (0x1 << 2) // (DMAC)
#define AT91C_DMAC_CHSR_ENA3 (0x1 << 3) // (DMAC)
#define AT91C_DMAC_CHSR_ENA4 (0x1 << 4) // (DMAC)
#define AT91C_DMAC_CHSR_ENA5 (0x1 << 5) // (DMAC)
#define AT91C_DMAC_CHSR_ENA6 (0x1 << 6) // (DMAC)
#define AT91C_DMAC_CHSR_ENA7 (0x1 << 7) // (DMAC)
#define AT91C_DMAC_CHSR_SUSP0 (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CHSR_SUSP1 (0x1 << 9) // (DMAC)
#define AT91C_DMAC_CHSR_SUSP2 (0x1 << 10) // (DMAC)
#define AT91C_DMAC_CHSR_SUSP3 (0x1 << 11) // (DMAC)
#define AT91C_DMAC_CHSR_SUSP4 (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CHSR_SUSP5 (0x1 << 13) // (DMAC)
#define AT91C_DMAC_CHSR_SUSP6 (0x1 << 14) // (DMAC)
#define AT91C_DMAC_CHSR_SUSP7 (0x1 << 15) // (DMAC)
#define AT91C_DMAC_CHSR_EMPT0 (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CHSR_EMPT1 (0x1 << 17) // (DMAC)
#define AT91C_DMAC_CHSR_EMPT2 (0x1 << 18) // (DMAC)
#define AT91C_DMAC_CHSR_EMPT3 (0x1 << 19) // (DMAC)
#define AT91C_DMAC_CHSR_EMPT4 (0x1 << 20) // (DMAC)
#define AT91C_DMAC_CHSR_EMPT5 (0x1 << 21) // (DMAC)
#define AT91C_DMAC_CHSR_EMPT6 (0x1 << 22) // (DMAC)
#define AT91C_DMAC_CHSR_EMPT7 (0x1 << 23) // (DMAC)
#define AT91C_DMAC_CHSR_STAL0 (0x1 << 24) // (DMAC)
#define AT91C_DMAC_CHSR_STAL1 (0x1 << 25) // (DMAC)
#define AT91C_DMAC_CHSR_STAL2 (0x1 << 26) // (DMAC)
#define AT91C_DMAC_CHSR_STAL3 (0x1 << 27) // (DMAC)
#define AT91C_DMAC_CHSR_STAL4 (0x1 << 28) // (DMAC)
#define AT91C_DMAC_CHSR_STAL5 (0x1 << 29) // (DMAC)
#define AT91C_DMAC_CHSR_STAL6 (0x1 << 30) // (DMAC)
#define AT91C_DMAC_CHSR_STAL7 (0x1 << 31) // (DMAC)
// -------- DMAC_SADDR0 : (DMAC Offset: 0x3C) DMAC Channel Source Address Register (ch_num = 0) --------
#define AT91C_DMAC_SADDR0_SADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DADDR0 : (DMAC Offset: 0x40) DMAC Channel Destination Address Register (ch_num = 0) --------
#define AT91C_DMAC_DADDR0_DADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DSCR0 : (DMAC Offset: 0x44) DMAC Channel Descriptor Address Register (ch_num = 0) --------
#define AT91C_DMAC_DSCR0_DSCRx_IF (0x3 << 0) // (DMAC)
#define AT91C_DMAC_DSCR0_DSCRx (0x3fffffff << 2) // (DMAC)
// -------- DMAC_CTRLA0 : (DMAC Offset: 0x48) DMAC Channel Control A Register (ch_num = 0) --------
#define AT91C_DMAC_CTRLA0_BTSIZE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_CTRLA0_SRC_WIDTH (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLA0_DST_WIDTH (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLA0_DONE (0x1 << 31) // (DMAC)
// -------- DMAC_CTRLB0 : (DMAC Offset: 0x4C) DMAC Channel Control B Register (ch_num = 0) --------
#define AT91C_DMAC_CTRLB0_SIF (0x3 << 0) // (DMAC) Source Interface Selection Field
#define AT91C_DMAC_CTRLB0_DIF (0x3 << 4) // (DMAC) Destination Interface Selection Field
#define AT91C_DMAC_CTRLB0_SRC_PIP (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CTRLB0_DST_PIP (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CTRLB0_SRC_DSCR (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CTRLB0_DST_DSCR (0x1 << 20) // (DMAC)
#define AT91C_DMAC_CTRLB0_SRC_INCR (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLB0_DST_INCR (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLB0_AUTO (0x1 << 31) // (DMAC)
// -------- DMAC_CFG0 : (DMAC Offset: 0x50) DMAC Channel Configuration Register (ch_num = 0) --------
#define AT91C_DMAC_CFG0_SOD (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CFG0_LOCK_B (0x1 << 21) // (DMAC)
#define AT91C_DMAC_CFG0_AHB_PROT (0x7 << 24) // (DMAC)
// -------- DMAC_SPIP0 : (DMAC Offset: 0x54) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 0) --------
#define AT91C_DMAC_SPIP0_SPIP_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_SPIP0_SPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_DPIP0 : (DMAC Offset: 0x58) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 0) --------
#define AT91C_DMAC_DPIP0_DPIPE_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_DPIP0_DPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_SADDR1 : (DMAC Offset: 0x64) DMAC Channel Source Address Register (ch_num = 1) --------
#define AT91C_DMAC_SADDR1_SADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DADDR1 : (DMAC Offset: 0x68) DMAC Channel Destination Address Register (ch_num = 1) --------
#define AT91C_DMAC_DADDR1_DADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DSCR1 : (DMAC Offset: 0x6C) DMAC Channel Descriptor Address Register (ch_num = 1) --------
#define AT91C_DMAC_DSCR1_DSCRx_IF (0x3 << 0) // (DMAC)
#define AT91C_DMAC_DSCR1_DSCRx (0x3fffffff << 2) // (DMAC)
// -------- DMAC_CTRLA1 : (DMAC Offset: 0x70) DMAC Channel Control A Register (ch_num = 1) --------
#define AT91C_DMAC_CTRLA1_BTSIZE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_CTRLA1_SRC_WIDTH (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLA1_DST_WIDTH (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLA1_DONE (0x1 << 31) // (DMAC)
// -------- DMAC_CTRLB1 : (DMAC Offset: 0x74) DMAC Channel Control B Register (ch_num = 1) --------
#define AT91C_DMAC_CTRLB1_SIF (0x3 << 0) // (DMAC) Source Interface Selection Field
#define AT91C_DMAC_CTRLB1_DIF (0x3 << 4) // (DMAC) Destination Interface Selection Field
#define AT91C_DMAC_CTRLB1_SRC_PIP (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CTRLB1_DST_PIP (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CTRLB1_SRC_DSCR (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CTRLB1_DST_DSCR (0x1 << 20) // (DMAC)
#define AT91C_DMAC_CTRLB1_SRC_INCR (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLB1_DST_INCR (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLB1_AUTO (0x1 << 31) // (DMAC)
// -------- DMAC_CFG1 : (DMAC Offset: 0x78) DMAC Channel Configuration Register (ch_num = 1) --------
#define AT91C_DMAC_CFG1_SOD (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CFG1_LOCK_B (0x1 << 21) // (DMAC)
#define AT91C_DMAC_CFG1_AHB_PROT (0x7 << 24) // (DMAC)
// -------- DMAC_SPIP1 : (DMAC Offset: 0x7C) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 1) --------
#define AT91C_DMAC_SPIP1_SPIP_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_SPIP1_SPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_DPIP1 : (DMAC Offset: 0x80) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 1) --------
#define AT91C_DMAC_DPIP1_DPIPE_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_DPIP1_DPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_SADDR2 : (DMAC Offset: 0x8C) DMAC Channel Source Address Register (ch_num = 2) --------
#define AT91C_DMAC_SADDR2_SADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DADDR2 : (DMAC Offset: 0x90) DMAC Channel Destination Address Register (ch_num = 2) --------
#define AT91C_DMAC_DADDR2_DADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DSCR2 : (DMAC Offset: 0x94) DMAC Channel Descriptor Address Register (ch_num = 2) --------
#define AT91C_DMAC_DSCR2_DSCRx_IF (0x3 << 0) // (DMAC)
#define AT91C_DMAC_DSCR2_DSCRx (0x3fffffff << 2) // (DMAC)
// -------- DMAC_CTRLA2 : (DMAC Offset: 0x98) DMAC Channel Control A Register (ch_num = 2) --------
#define AT91C_DMAC_CTRLA2_BTSIZE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_CTRLA2_SRC_WIDTH (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLA2_DST_WIDTH (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLA2_DONE (0x1 << 31) // (DMAC)
// -------- DMAC_CTRLB2 : (DMAC Offset: 0x9C) DMAC Channel Control B Register (ch_num = 2) --------
#define AT91C_DMAC_CTRLB2_SIF (0x3 << 0) // (DMAC) Source Interface Selection Field
#define AT91C_DMAC_CTRLB2_DIF (0x3 << 4) // (DMAC) Destination Interface Selection Field
#define AT91C_DMAC_CTRLB2_SRC_PIP (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CTRLB2_DST_PIP (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CTRLB2_SRC_DSCR (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CTRLB2_DST_DSCR (0x1 << 20) // (DMAC)
#define AT91C_DMAC_CTRLB2_SRC_INCR (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLB2_DST_INCR (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLB2_AUTO (0x1 << 31) // (DMAC)
// -------- DMAC_CFG2 : (DMAC Offset: 0xA0) DMAC Channel Configuration Register (ch_num = 2) --------
#define AT91C_DMAC_CFG2_SOD (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CFG2_LOCK_B (0x1 << 21) // (DMAC)
#define AT91C_DMAC_CFG2_AHB_PROT (0x7 << 24) // (DMAC)
// -------- DMAC_SPIP2 : (DMAC Offset: 0xA4) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 2) --------
#define AT91C_DMAC_SPIP2_SPIP_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_SPIP2_SPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_DPIP2 : (DMAC Offset: 0xA8) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 2) --------
#define AT91C_DMAC_DPIP2_DPIPE_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_DPIP2_DPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_SADDR3 : (DMAC Offset: 0xB4) DMAC Channel Source Address Register (ch_num = 3) --------
#define AT91C_DMAC_SADDR3_SADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DADDR3 : (DMAC Offset: 0xB8) DMAC Channel Destination Address Register (ch_num = 3) --------
#define AT91C_DMAC_DADDR3_DADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DSCR3 : (DMAC Offset: 0xBC) DMAC Channel Descriptor Address Register (ch_num = 3) --------
#define AT91C_DMAC_DSCR3_DSCRx_IF (0x3 << 0) // (DMAC)
#define AT91C_DMAC_DSCR3_DSCRx (0x3fffffff << 2) // (DMAC)
// -------- DMAC_CTRLA3 : (DMAC Offset: 0xC0) DMAC Channel Control A Register (ch_num = 3) --------
#define AT91C_DMAC_CTRLA3_BTSIZE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_CTRLA3_SRC_WIDTH (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLA3_DST_WIDTH (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLA3_DONE (0x1 << 31) // (DMAC)
// -------- DMAC_CTRLB3 : (DMAC Offset: 0xC4) DMAC Channel Control B Register (ch_num = 3) --------
#define AT91C_DMAC_CTRLB3_SIF (0x3 << 0) // (DMAC) Source Interface Selection Field
#define AT91C_DMAC_CTRLB3_DIF (0x3 << 4) // (DMAC) Destination Interface Selection Field
#define AT91C_DMAC_CTRLB3_SRC_PIP (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CTRLB3_DST_PIP (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CTRLB3_SRC_DSCR (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CTRLB3_DST_DSCR (0x1 << 20) // (DMAC)
#define AT91C_DMAC_CTRLB3_SRC_INCR (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLB3_DST_INCR (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLB3_AUTO (0x1 << 31) // (DMAC)
// -------- DMAC_CFG3 : (DMAC Offset: 0xC8) DMAC Channel Configuration Register (ch_num = 3) --------
#define AT91C_DMAC_CFG3_SOD (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CFG3_LOCK_B (0x1 << 21) // (DMAC)
#define AT91C_DMAC_CFG3_AHB_PROT (0x7 << 24) // (DMAC)
// -------- DMAC_SPIP3 : (DMAC Offset: 0xCC) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 3) --------
#define AT91C_DMAC_SPIP3_SPIP_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_SPIP3_SPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_DPIP3 : (DMAC Offset: 0xD0) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 3) --------
#define AT91C_DMAC_DPIP3_DPIPE_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_DPIP3_DPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_SADDR4 : (DMAC Offset: 0xDC) DMAC Channel Source Address Register (ch_num = 4) --------
#define AT91C_DMAC_SADDR4_SADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DADDR4 : (DMAC Offset: 0xE0) DMAC Channel Destination Address Register (ch_num = 4) --------
#define AT91C_DMAC_DADDR4_DADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DSCR4 : (DMAC Offset: 0xE4) DMAC Channel Descriptor Address Register (ch_num = 4) --------
#define AT91C_DMAC_DSCR4_DSCRx_IF (0x3 << 0) // (DMAC)
#define AT91C_DMAC_DSCR4_DSCRx (0x3fffffff << 2) // (DMAC)
// -------- DMAC_CTRLA4 : (DMAC Offset: 0xE8) DMAC Channel Control A Register (ch_num = 4) --------
#define AT91C_DMAC_CTRLA4_BTSIZE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_CTRLA4_SRC_WIDTH (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLA4_DST_WIDTH (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLA4_DONE (0x1 << 31) // (DMAC)
// -------- DMAC_CTRLB4 : (DMAC Offset: 0xEC) DMAC Channel Control B Register (ch_num = 4) --------
#define AT91C_DMAC_CTRLB4_SIF (0x3 << 0) // (DMAC) Source Interface Selection Field
#define AT91C_DMAC_CTRLB4_DIF (0x3 << 4) // (DMAC) Destination Interface Selection Field
#define AT91C_DMAC_CTRLB4_SRC_PIP (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CTRLB4_DST_PIP (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CTRLB4_SRC_DSCR (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CTRLB4_DST_DSCR (0x1 << 20) // (DMAC)
#define AT91C_DMAC_CTRLB4_SRC_INCR (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLB4_DST_INCR (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLB4_AUTO (0x1 << 31) // (DMAC)
// -------- DMAC_CFG4 : (DMAC Offset: 0xF0) DMAC Channel Configuration Register (ch_num = 4) --------
#define AT91C_DMAC_CFG4_SOD (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CFG4_LOCK_B (0x1 << 21) // (DMAC)
#define AT91C_DMAC_CFG4_AHB_PROT (0x7 << 24) // (DMAC)
// -------- DMAC_SPIP4 : (DMAC Offset: 0xF4) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 4) --------
#define AT91C_DMAC_SPIP4_SPIP_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_SPIP4_SPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_DPIP4 : (DMAC Offset: 0xF8) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 4) --------
#define AT91C_DMAC_DPIP4_DPIPE_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_DPIP4_DPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_SADDR5 : (DMAC Offset: 0x104) DMAC Channel Source Address Register (ch_num = 5) --------
#define AT91C_DMAC_SADDR5_SADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DADDR5 : (DMAC Offset: 0x108) DMAC Channel Destination Address Register (ch_num = 5) --------
#define AT91C_DMAC_DADDR5_DADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DSCR5 : (DMAC Offset: 0x10C) DMAC Channel Descriptor Address Register (ch_num = 5) --------
#define AT91C_DMAC_DSCR5_DSCRx_IF (0x3 << 0) // (DMAC)
#define AT91C_DMAC_DSCR5_DSCRx (0x3fffffff << 2) // (DMAC)
// -------- DMAC_CTRLA5 : (DMAC Offset: 0x110) DMAC Channel Control A Register (ch_num = 5) --------
#define AT91C_DMAC_CTRLA5_BTSIZE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_CTRLA5_SRC_WIDTH (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLA5_DST_WIDTH (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLA5_DONE (0x1 << 31) // (DMAC)
// -------- DMAC_CTRLB5 : (DMAC Offset: 0x114) DMAC Channel Control B Register (ch_num = 5) --------
#define AT91C_DMAC_CTRLB5_SIF (0x3 << 0) // (DMAC) Source Interface Selection Field
#define AT91C_DMAC_CTRLB5_DIF (0x3 << 4) // (DMAC) Destination Interface Selection Field
#define AT91C_DMAC_CTRLB5_SRC_PIP (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CTRLB5_DST_PIP (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CTRLB5_SRC_DSCR (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CTRLB5_DST_DSCR (0x1 << 20) // (DMAC)
#define AT91C_DMAC_CTRLB5_SRC_INCR (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLB5_DST_INCR (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLB5_AUTO (0x1 << 31) // (DMAC)
// -------- DMAC_CFG5 : (DMAC Offset: 0x118) DMAC Channel Configuration Register (ch_num = 5) --------
#define AT91C_DMAC_CFG5_SOD (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CFG5_LOCK_B (0x1 << 21) // (DMAC)
#define AT91C_DMAC_CFG5_AHB_PROT (0x7 << 24) // (DMAC)
// -------- DMAC_SPIP5 : (DMAC Offset: 0x11C) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 5) --------
#define AT91C_DMAC_SPIP5_SPIP_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_SPIP5_SPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_DPIP5 : (DMAC Offset: 0x120) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 5) --------
#define AT91C_DMAC_DPIP5_DPIPE_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_DPIP5_DPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_SADDR6 : (DMAC Offset: 0x12C) DMAC Channel Source Address Register (ch_num = 6) --------
#define AT91C_DMAC_SADDR6_SADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DADDR6 : (DMAC Offset: 0x130) DMAC Channel Destination Address Register (ch_num = 6) --------
#define AT91C_DMAC_DADDR6_DADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DSCR6 : (DMAC Offset: 0x134) DMAC Channel Descriptor Address Register (ch_num = 6) --------
#define AT91C_DMAC_DSCR6_DSCRx_IF (0x3 << 0) // (DMAC)
#define AT91C_DMAC_DSCR6_DSCRx (0x3fffffff << 2) // (DMAC)
// -------- DMAC_CTRLA6 : (DMAC Offset: 0x138) DMAC Channel Control A Register (ch_num = 6) --------
#define AT91C_DMAC_CTRLA6_BTSIZE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_CTRLA6_SRC_WIDTH (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLA6_DST_WIDTH (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLA6_DONE (0x1 << 31) // (DMAC)
// -------- DMAC_CTRLB6 : (DMAC Offset: 0x13C) DMAC Channel Control B Register (ch_num = 6) --------
#define AT91C_DMAC_CTRLB6_SIF (0x3 << 0) // (DMAC) Source Interface Selection Field
#define AT91C_DMAC_CTRLB6_DIF (0x3 << 4) // (DMAC) Destination Interface Selection Field
#define AT91C_DMAC_CTRLB6_SRC_PIP (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CTRLB6_DST_PIP (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CTRLB6_SRC_DSCR (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CTRLB6_DST_DSCR (0x1 << 20) // (DMAC)
#define AT91C_DMAC_CTRLB6_SRC_INCR (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLB6_DST_INCR (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLB6_AUTO (0x1 << 31) // (DMAC)
// -------- DMAC_CFG6 : (DMAC Offset: 0x140) DMAC Channel Configuration Register (ch_num = 6) --------
#define AT91C_DMAC_CFG6_SOD (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CFG6_LOCK_B (0x1 << 21) // (DMAC)
#define AT91C_DMAC_CFG6_AHB_PROT (0x7 << 24) // (DMAC)
// -------- DMAC_SPIP6 : (DMAC Offset: 0x144) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 6) --------
#define AT91C_DMAC_SPIP6_SPIP_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_SPIP6_SPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_DPIP6 : (DMAC Offset: 0x148) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 6) --------
#define AT91C_DMAC_DPIP6_DPIPE_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_DPIP6_DPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_SADDR7 : (DMAC Offset: 0x154) DMAC Channel Source Address Register (ch_num = 7) --------
#define AT91C_DMAC_SADDR7_SADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DADDR7 : (DMAC Offset: 0x158) DMAC Channel Destination Address Register (ch_num = 7) --------
#define AT91C_DMAC_DADDR7_DADDRx (0xffffffff << 0) // (DMAC)
// -------- DMAC_DSCR7 : (DMAC Offset: 0x15C) DMAC Channel Descriptor Address Register (ch_num = 7) --------
#define AT91C_DMAC_DSCR7_DSCRx_IF (0x3 << 0) // (DMAC)
#define AT91C_DMAC_DSCR7_DSCRx (0x3fffffff << 2) // (DMAC)
// -------- DMAC_CTRLA7 : (DMAC Offset: 0x160) DMAC Channel Control A Register (ch_num = 7) --------
#define AT91C_DMAC_CTRLA7_BTSIZE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_CTRLA7_SRC_WIDTH (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLA7_DST_WIDTH (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLA7_DONE (0x1 << 31) // (DMAC)
// -------- DMAC_CTRLB7 : (DMAC Offset: 0x164) DMAC Channel Control B Register (ch_num = 7) --------
#define AT91C_DMAC_CTRLB7_SIF (0x3 << 0) // (DMAC) Source Interface Selection Field
#define AT91C_DMAC_CTRLB7_DIF (0x3 << 4) // (DMAC) Destination Interface Selection Field
#define AT91C_DMAC_CTRLB7_SRC_PIP (0x1 << 8) // (DMAC)
#define AT91C_DMAC_CTRLB7_DST_PIP (0x1 << 12) // (DMAC)
#define AT91C_DMAC_CTRLB7_SRC_DSCR (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CTRLB7_DST_DSCR (0x1 << 20) // (DMAC)
#define AT91C_DMAC_CTRLB7_SRC_INCR (0x3 << 24) // (DMAC)
#define AT91C_DMAC_CTRLB7_DST_INCR (0x3 << 28) // (DMAC)
#define AT91C_DMAC_CTRLB7_AUTO (0x1 << 31) // (DMAC)
// -------- DMAC_CFG7 : (DMAC Offset: 0x168) DMAC Channel Configuration Register (ch_num = 7) --------
#define AT91C_DMAC_CFG7_SOD (0x1 << 16) // (DMAC)
#define AT91C_DMAC_CFG7_LOCK_B (0x1 << 21) // (DMAC)
#define AT91C_DMAC_CFG7_AHB_PROT (0x7 << 24) // (DMAC)
// -------- DMAC_SPIP7 : (DMAC Offset: 0x16C) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 7) --------
#define AT91C_DMAC_SPIP7_SPIP_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_SPIP7_SPIP_BOUNDARY (0x3ff << 16) // (DMAC)
// -------- DMAC_DPIP7 : (DMAC Offset: 0x170) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 7) --------
#define AT91C_DMAC_DPIP7_DPIPE_HOLE (0xffff << 0) // (DMAC)
#define AT91C_DMAC_DPIP7_DPIP_BOUNDARY (0x3ff << 16) // (DMAC)
*/


// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Error Corrected Code Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_ECC {
  AT91_REG ECC_CTRL; // ECC Control Register
  AT91_REG ECC_MD;   // ECC Mode Register
  AT91_REG ECC_SR1;  // ECC Status1 Register
  AT91_REG ECC_PR0;  // ECC Parity Register 0
  AT91_REG ECC_PR1;  // ECC Parity Register 1
  AT91_REG ECC_SR2;  // ECC Status2 Register
  AT91_REG ECC_PR2;  // ECC Parity 2
  AT91_REG ECC_PR3;  // ECC Parity 3
  AT91_REG ECC_PR4;  // ECC Parity 4
  AT91_REG ECC_PR5;  // ECC Parity 5
  AT91_REG ECC_PR6;  // ECC Parity 6
  AT91_REG ECC_PR7;  // ECC Parity 7
  AT91_REG ECC_PR8;  // ECC Parity 8
  AT91_REG ECC_PR9;  // ECC Parity 9
  AT91_REG ECC_PR10; // ECC Parity 10
  AT91_REG ECC_PR11; // ECC Parity 11
  AT91_REG ECC_PR12; // ECC Parity 12
  AT91_REG ECC_PR13; // ECCParity 13
  AT91_REG ECC_PR14; // ECC Parity 14
  AT91_REG ECC_PR15; // ECC Parity 15
} AT91S_ECC, *AT91PS_ECC;
#else
#define ECC_CTRL (AT91_CAST(AT91_REG *) 0x00000000) // ECC Control Register
#define ECC_MD   (AT91_CAST(AT91_REG *) 0x00000004) // ECC Mode Register
#define ECC_SR1  (AT91_CAST(AT91_REG *) 0x00000008) // ECC Status1 Register
#define ECC_PR0  (AT91_CAST(AT91_REG *) 0x0000000C) // ECC Parity Register 0
#define ECC_PR1  (AT91_CAST(AT91_REG *) 0x00000010) // ECC Parity Register 1
#define ECC_SR2  (AT91_CAST(AT91_REG *) 0x00000014) // ECC Status2 Register
#define ECC_PR2  (AT91_CAST(AT91_REG *) 0x00000018) // ECC Parity 2
#define ECC_PR3  (AT91_CAST(AT91_REG *) 0x0000001C) // ECC Parity 3
#define ECC_PR4  (AT91_CAST(AT91_REG *) 0x00000020) // ECC Parity 4
#define ECC_PR5  (AT91_CAST(AT91_REG *) 0x00000024) // ECC Parity 5
#define ECC_PR6  (AT91_CAST(AT91_REG *) 0x00000028) // ECC Parity 6
#define ECC_PR7  (AT91_CAST(AT91_REG *) 0x0000002C) // ECC Parity 7
#define ECC_PR8  (AT91_CAST(AT91_REG *) 0x00000030) // ECC Parity 8
#define ECC_PR9  (AT91_CAST(AT91_REG *) 0x00000034) // ECC Parity 9
#define ECC_PR10 (AT91_CAST(AT91_REG *) 0x00000038) // ECC Parity 10
#define ECC_PR11 (AT91_CAST(AT91_REG *) 0x0000003C) // ECC Parity 11
#define ECC_PR12 (AT91_CAST(AT91_REG *) 0x00000040) // ECC Parity 12
#define ECC_PR13 (AT91_CAST(AT91_REG *) 0x00000044) // ECCParity 13
#define ECC_PR14 (AT91_CAST(AT91_REG *) 0x00000048) // ECC Parity 14
#define ECC_PR15 (AT91_CAST(AT91_REG *) 0x0000004C) // ECC Parity 15
#endif
// -------- ECC_CTRL : (ECC Offset: 0x00) ECC Control Register --------
// -------- ECC_MD : (ECC Offset: 0x04) ECC Mode Register --------
// -------- ECC_SR1 : (ECC Offset: 0x08) ECC Status1 Register --------
#define AT91C_ECC_SR1_RECERR0 (0x1 << 0) // (ECC) Recoverable Error
#define AT91C_ECC_SR1_ECCERR0 (0x3 << 1) // (ECC) ECC Error
#define AT91C_ECC_SR1_RECERR1 (0x1 << 4) // (ECC) Recoverable Error in the page between the 256th and the 511th bytes or the 512th and the 1023th bytes
#define AT91C_ECC_SR1_ECCERR1 (0x1 << 5) // (ECC) ECC Error in the page between the 256th and the 511th bytes or the 512th and the 1023th bytes
#define AT91C_ECC_SR1_MULERR1 (0x1 << 6) // (ECC) Multiple Error in the page between the 256th and the 511th bytes or the 512th and the 1023th bytes
#define AT91C_ECC_SR1_RECERR2 (0x1 << 8) // (ECC) Recoverable Error in the page between the 512th and the 767th bytes or the 1024th and the 1535th bytes
#define AT91C_ECC_SR1_ECCERR2 (0x1 << 9) // (ECC) ECC Error in the page between the 512th and the 767th bytes or the 1024th and the 1535th bytes
#define AT91C_ECC_SR1_MULERR2 (0x1 << 10) // (ECC) Multiple Error in the page between the 512th and the 767th bytes or the 1024th and the 1535th bytes
#define AT91C_ECC_SR1_RECERR3 (0x1 << 12) // (ECC) Recoverable Error in the page between the 768th and the 1023th bytes or the 1536th and the 2047th bytes
#define AT91C_ECC_SR1_ECCERR3 (0x1 << 13) // (ECC) ECC Error in the page between the 768th and the 1023th bytes or the 1536th and the 2047th bytes
#define AT91C_ECC_SR1_MULERR3 (0x1 << 14) // (ECC) Multiple Error in the page between the 768th and the 1023th bytes or the 1536th and the 2047th bytes
#define AT91C_ECC_SR1_RECERR4 (0x1 << 16) // (ECC) Recoverable Error in the page between the 1024th and the 1279th bytes or the 2048th and the 2559th bytes
#define AT91C_ECC_SR1_ECCERR4 (0x3 << 17) // (ECC) ECC Error in the page between the 1024th and the 1279th bytes or the 2048th and the 2559th bytes
#define AT91C_ECC_SR1_RECERR5 (0x1 << 20) // (ECC) Recoverable Error in the page between the 1280th and the 1535th bytes or the 2560th and the 3071th bytes
#define AT91C_ECC_SR1_ECCERR5 (0x3 << 21) // (ECC) ECC Error in the page between the 1280th and the 1535th bytes or the 2560th and the 3071th bytes
#define AT91C_ECC_SR1_RECERR6 (0x1 << 24) // (ECC) Recoverable Error in the page between the 1536th and the 1791th bytes or the 3072th and the 3583th bytes
#define AT91C_ECC_SR1_ECCERR6 (0x3 << 25) // (ECC) ECC Error in the page between the 1536th and the 1791th bytes or the 3072th and the 3583th bytes
#define AT91C_ECC_SR1_RECERR7 (0x1 << 28) // (ECC) Recoverable Error in the page between the 1792th and the 2047th bytes or the 3584th and the 4095th bytes
#define AT91C_ECC_SR1_ECCERR7 (0x3 << 29) // (ECC) ECC Error in the page between the 1792th and the 2047th bytes or the 3584th and the 4095th bytes
// -------- ECC_PR0 : (ECC Offset: 0x0C) ECC Parity Register 0 --------
#define AT91C_ECC_PR0_BITADDR (0xf << 0) // (ECC) Bit Address
#define AT91C_ECC_PR0_WORDADDR (0xfff << 4) // (ECC) Word Address
// -------- ECC_PR1 : (ECC Offset: 0x10) ECC Parity Register 1 --------
#define AT91C_ECC_PR1_NPARITY (0xffff << 0) // (ECC)
// -------- ECC_SR2 : (ECC Offset: 0x14) ECC Status2 Register --------
#define AT91C_ECC_SR2_RECERR8 (0x1 << 0) // (ECC) Recoverable Error in the page between the 2048th and the 2303th bytes
#define AT91C_ECC_SR2_ECCERR8 (0x3 << 1) // (ECC) ECC Error in the page between the 2048th and the 2303th bytes
#define AT91C_ECC_SR2_RECERR9 (0x1 << 4) // (ECC) Recoverable Error in the page between the 2304th and the 2559th bytes
#define AT91C_ECC_SR2_ECCERR9 (0x1 << 5) // (ECC) ECC Error in the page between the 2304th and the 2559th bytes
#define AT91C_ECC_SR2_MULERR9 (0x1 << 6) // (ECC) Multiple Error in the page between the 2304th and the 2559th bytes
#define AT91C_ECC_SR2_RECERR10 (0x1 << 8) // (ECC) Recoverable Error in the page between the 2560th and the 2815th bytes
#define AT91C_ECC_SR2_ECCERR10 (0x1 << 9) // (ECC) ECC Error in the page between the 2560th and the 2815th bytes
#define AT91C_ECC_SR2_MULERR10 (0x1 << 10) // (ECC) Multiple Error in the page between the 2560th and the 2815th bytes
#define AT91C_ECC_SR2_RECERR11 (0x1 << 12) // (ECC) Recoverable Error in the page between the 2816th and the 3071th bytes
#define AT91C_ECC_SR2_ECCERR11 (0x1 << 13) // (ECC) ECC Error in the page between the 2816th and the 3071th bytes
#define AT91C_ECC_SR2_MULERR11 (0x1 << 14) // (ECC) Multiple Error in the page between the 2816th and the 3071th bytes
#define AT91C_ECC_SR2_RECERR12 (0x1 << 16) // (ECC) Recoverable Error in the page between the 3072th and the 3327th bytes
#define AT91C_ECC_SR2_ECCERR12 (0x3 << 17) // (ECC) ECC Error in the page between the 3072th and the 3327th bytes
#define AT91C_ECC_SR2_RECERR13 (0x1 << 20) // (ECC) Recoverable Error in the page between the 3328th and the 3583th bytes
#define AT91C_ECC_SR2_ECCERR13 (0x3 << 21) // (ECC) ECC Error in the page between the 3328th and the 3583th bytes
#define AT91C_ECC_SR2__RECERR14 (0x1 << 24) // (ECC)
#define AT91C_ECC_SR2_ECCERR14 (0x3 << 25) // (ECC) ECC Error in the page between the 3584th and the 3839th bytes
#define AT91C_ECC_SR2_RECERR15 (0x1 << 28) // (ECC) Recoverable Error in the page between the 3840th and the 4095th bytes
#define AT91C_ECC_SR2_ECCERR15 (0x3 << 29) // (ECC) ECC Error in the page between the 3840th and the 4095th bytes
// -------- ECC_PR2 : (ECC Offset: 0x18) ECC Parity 2 --------
// -------- ECC_PR3 : (ECC Offset: 0x1C) ECC Parity 3 --------
// -------- ECC_PR4 : (ECC Offset: 0x20) ECC Parity 4 --------
// -------- ECC_PR5 : (ECC Offset: 0x24) ECC Parity 5 --------
// -------- ECC_PR6 : (ECC Offset: 0x28) ECC Parity 6 --------
// -------- ECC_PR7 : (ECC Offset: 0x2C) ECC Parity 7 --------
// -------- ECC_PR8 : (ECC Offset: 0x30) ECC Parity 8 --------
// -------- ECC_PR9 : (ECC Offset: 0x34) ECC Parity 9 --------
// -------- ECC_PR10 : (ECC Offset: 0x38) ECC Parity 10 --------
// -------- ECC_PR11 : (ECC Offset: 0x3C) ECC Parity 11 --------
// -------- ECC_PR12 : (ECC Offset: 0x40) ECC Parity 12 --------
// -------- ECC_PR13 : (ECC Offset: 0x44) ECCParity 13 --------
// -------- ECC_PR14 : (ECC Offset: 0x48) ECC Parity 14 --------
// -------- ECC_PR15 : (ECC Offset: 0x4C) ECC Parity 15 --------

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Ethernet MAC 10/100
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_EMAC {
  AT91_REG EMAC_NCR;     // Network Control Register
  AT91_REG EMAC_NCFG;    // Network Configuration Register
  AT91_REG EMAC_NSR;     // Network Status Register
  AT91_REG Reserved1[2];
  AT91_REG EMAC_TSR;     // Transmit Status Register
  AT91_REG EMAC_RBQP;    // Receive Buffer Queue Pointer Register
  AT91_REG EMAC_TBQP;    // Transmit Buffer Queue Pointer Register
  AT91_REG EMAC_RSR;     // Receive Status Register
  AT91_REG EMAC_ISR;     // Interrupt Status Register
  AT91_REG EMAC_IER;     // Interrupt Enable Register
  AT91_REG EMAC_IDR;     // Interrupt Disable Register
  AT91_REG EMAC_IMR;     // Interrupt Mask Register
  AT91_REG EMAC_MAN;     // Phy Maintenance Register
  AT91_REG EMAC_PTR;     // Pause Time Register
  AT91_REG EMAC_PFR;     // Pause Frames Received Register
  AT91_REG EMAC_FTO;     // Frames Transmitted Ok Register
  AT91_REG EMAC_SCF;     // Single Collision Frames Register
  AT91_REG EMAC_MCF;     // Multiple Collision Frames Register
  AT91_REG EMAC_FRO;     // Frames Received Ok Register
  AT91_REG EMAC_FCSE;    // Frame Check Sequence Errors Register
  AT91_REG EMAC_ALE;     // Alignment Errors Register
  AT91_REG EMAC_DTF;     // Deferred Transmission Frames Register
  AT91_REG EMAC_LCOL;    // Late Collisions Register
  AT91_REG EMAC_ECOL;    // Excessive Collisions Register
  AT91_REG EMAC_TUND;    // Transmit Underrun Errors Register
  AT91_REG EMAC_CSE;     // Carrier Sense Errors Register
  AT91_REG EMAC_RRE;     // Receive Resource Errors Register
  AT91_REG EMAC_ROV;     // Receive Overrun Errors Register
  AT91_REG EMAC_RSE;     // Receive Symbol Errors Register
  AT91_REG EMAC_ELE;     // Excessive Length Errors Register
  AT91_REG EMAC_RJA;     // Receive Jabbers Register
  AT91_REG EMAC_USF;     // Undersize Frames Register
  AT91_REG EMAC_STE;     // SQE Test Errors Register
  AT91_REG EMAC_RLE;     // Received Length Field Mismatch Register
  AT91_REG Reserved2[1];
  AT91_REG EMAC_HRB;     // Hash Register Bottom [31:0] Register
  AT91_REG EMAC_HRT;     // Hash Register Top [63:32] Register
  AT91_REG EMAC_SA1B;    // Specific Address 1 Bottom Register
  AT91_REG EMAC_SA1T;    // Specific Address 1 Top Register
  AT91_REG EMAC_SA2B;    // Specific Address 2 Bottom Register
  AT91_REG EMAC_SA2T;    // Specific Address 2 Top Register
  AT91_REG EMAC_SA3B;    // Specific Address 3 Bottom Register
  AT91_REG EMAC_SA3T;    // Specific Address 3 Top Register
  AT91_REG EMAC_SA4B;    // Specific Address 4 Bottom Register
  AT91_REG EMAC_SA4T;    // Specific Address 4 Top Register
  AT91_REG EMAC_TID;     // Type ID Checking Register
  AT91_REG Reserved3[1];
  AT91_REG EMAC_USRIO;   // User Input/Output Register
} AT91S_EMAC, *AT91PS_EMAC;
#else
#define EMAC_NCR   (AT91_CAST(AT91_REG *) 0x00000000) // Network Control Register
#define EMAC_NCFG  (AT91_CAST(AT91_REG *) 0x00000004) // Network Configuration Register
#define EMAC_NSR   (AT91_CAST(AT91_REG *) 0x00000008) // Network Status Register
#define EMAC_TSR   (AT91_CAST(AT91_REG *) 0x00000014) // Transmit Status Register
#define EMAC_RBQP  (AT91_CAST(AT91_REG *) 0x00000018) // Receive Buffer Queue Pointer Register
#define EMAC_TBQP  (AT91_CAST(AT91_REG *) 0x0000001C) // Transmit Buffer Queue Pointer Register
#define EMAC_RSR   (AT91_CAST(AT91_REG *) 0x00000020) // Receive Status Register
#define EMAC_ISR   (AT91_CAST(AT91_REG *) 0x00000024) // Interrupt Status Register
#define EMAC_IER   (AT91_CAST(AT91_REG *) 0x00000028) // Interrupt Enable Register
#define EMAC_IDR   (AT91_CAST(AT91_REG *) 0x0000002C) // Interrupt Disable Register
#define EMAC_IMR   (AT91_CAST(AT91_REG *) 0x00000030) // Interrupt Mask Register
#define EMAC_MAN   (AT91_CAST(AT91_REG *) 0x00000034) // Phy Maintenance Register
#define EMAC_PTR   (AT91_CAST(AT91_REG *) 0x00000038) // Pause Time Register
#define EMAC_PFR   (AT91_CAST(AT91_REG *) 0x0000003C) // Pause Frames Received Register
#define EMAC_FTO   (AT91_CAST(AT91_REG *) 0x00000040) // Frames Transmitted Ok Register
#define EMAC_SCF   (AT91_CAST(AT91_REG *) 0x00000044) // Single Collision Frames Register
#define EMAC_MCF   (AT91_CAST(AT91_REG *) 0x00000048) // Multiple Collision Frames Register
#define EMAC_FRO   (AT91_CAST(AT91_REG *) 0x0000004C) // Frames Received Ok Register
#define EMAC_FCSE  (AT91_CAST(AT91_REG *) 0x00000050) // Frame Check Sequence Errors Register
#define EMAC_ALE   (AT91_CAST(AT91_REG *) 0x00000054) // Alignment Errors Register
#define EMAC_DTF   (AT91_CAST(AT91_REG *) 0x00000058) // Deferred Transmission Frames Register
#define EMAC_LCOL  (AT91_CAST(AT91_REG *) 0x0000005C) // Late Collisions Register
#define EMAC_ECOL  (AT91_CAST(AT91_REG *) 0x00000060) // Excessive Collisions Register
#define EMAC_TUND  (AT91_CAST(AT91_REG *) 0x00000064) // Transmit Underrun Errors Register
#define EMAC_CSE   (AT91_CAST(AT91_REG *) 0x00000068) // Carrier Sense Errors Register
#define EMAC_RRE   (AT91_CAST(AT91_REG *) 0x0000006C) // Receive Resource Errors Register
#define EMAC_ROV   (AT91_CAST(AT91_REG *) 0x00000070) // Receive Overrun Errors Register
#define EMAC_RSE   (AT91_CAST(AT91_REG *) 0x00000074) // Receive Symbol Errors Register
#define EMAC_ELE   (AT91_CAST(AT91_REG *) 0x00000078) // Excessive Length Errors Register
#define EMAC_RJA   (AT91_CAST(AT91_REG *) 0x0000007C) // Receive Jabbers Register
#define EMAC_USF   (AT91_CAST(AT91_REG *) 0x00000080) // Undersize Frames Register
#define EMAC_STE   (AT91_CAST(AT91_REG *) 0x00000084) // SQE Test Errors Register
#define EMAC_RLE   (AT91_CAST(AT91_REG *) 0x00000088) // Received Length Field Mismatch Register
#define EMAC_HRB   (AT91_CAST(AT91_REG *) 0x00000090) // Hash Register Bottom [31:0] Register
#define EMAC_HRT   (AT91_CAST(AT91_REG *) 0x00000094) // Hash Register Top [63:32] Register
#define EMAC_SA1B  (AT91_CAST(AT91_REG *) 0x00000098) // Specific Address 1 Bottom Register
#define EMAC_SA1T  (AT91_CAST(AT91_REG *) 0x0000009C) // Specific Address 1 Top Register
#define EMAC_SA2B  (AT91_CAST(AT91_REG *) 0x000000A0) // Specific Address 2 Bottom Register
#define EMAC_SA2T  (AT91_CAST(AT91_REG *) 0x000000A4) // Specific Address 2 Top Register
#define EMAC_SA3B  (AT91_CAST(AT91_REG *) 0x000000A8) // Specific Address 3 Bottom Register
#define EMAC_SA3T  (AT91_CAST(AT91_REG *) 0x000000AC) // Specific Address 3 Top Register
#define EMAC_SA4B  (AT91_CAST(AT91_REG *) 0x000000B0) // Specific Address 4 Bottom Register
#define EMAC_SA4T  (AT91_CAST(AT91_REG *) 0x000000B4) // Specific Address 4 Top Register
#define EMAC_TID   (AT91_CAST(AT91_REG *) 0x000000B8) // Type ID Checking Register
#define EMAC_USRIO (AT91_CAST(AT91_REG *) 0x000000C0) // User Input/Output Register
#endif
// -------- EMAC_NCR : (EMAC Offset: 0x00) Network Control Register --------
#define AT91C_EMAC_NCR_LB (0x1 << 0) // (EMAC) LoopBack
#define AT91C_EMAC_NCR_LLB (0x1 << 1) // (EMAC) Loopback local
#define AT91C_EMAC_NCR_RE (0x1 << 2) // (EMAC) Receive enable
#define AT91C_EMAC_NCR_TE (0x1 << 3) // (EMAC) Transmit enable
#define AT91C_EMAC_NCR_MPE (0x1 << 4) // (EMAC) Management port enable
#define AT91C_EMAC_NCR_CLRSTAT (0x1 << 5) // (EMAC) Clear statistics registers
#define AT91C_EMAC_NCR_INCSTAT (0x1 << 6) // (EMAC) Increment statistics registers
#define AT91C_EMAC_NCR_WESTAT (0x1 << 7) // (EMAC) Write enable for statistics registers
#define AT91C_EMAC_NCR_BP (0x1 << 8) // (EMAC) Back pressure
#define AT91C_EMAC_NCR_TSTART (0x1 << 9) // (EMAC) Start transmission
#define AT91C_EMAC_NCR_THALT (0x1 << 10) // (EMAC) Transmit halt
// -------- EMAC_NCFG : (EMAC Offset: 0x04) Network Configuration Register --------
#define AT91C_EMAC_NCFG_SPD (0x1 << 0) // (EMAC) Speed
#define AT91C_EMAC_NCFG_FD (0x1 << 1) // (EMAC) Full Duplex
#define AT91C_EMAC_NCFG_JFRAME (0x1 << 3) // (EMAC) Jumbo Frames
#define AT91C_EMAC_NCFG_CAF (0x1 << 4) // (EMAC) Copy All Frames
#define AT91C_EMAC_NCFG_NBC (0x1 << 5) // (EMAC) No Broadcast
#define AT91C_EMAC_NCFG_MTI (0x1 << 6) // (EMAC) Multicast Hash Enable
#define AT91C_EMAC_NCFG_UNI (0x1 << 7) // (EMAC) Unicast Hash Enable
#define AT91C_EMAC_NCFG_BIG (0x1 << 8) // (EMAC) Receive 1536 bytes frames
#define AT91C_EMAC_NCFG_CLK (0x3 << 10) // (EMAC) MDC clock divider
#define AT91C_EMAC_NCFG_RTY (0x1 << 12) // (EMAC) Retry test
#define AT91C_EMAC_NCFG_PAE (0x1 << 13) // (EMAC) Pause Enable
#define AT91C_EMAC_NCFG_RBOF (0x3 << 14) // (EMAC) Receive Buffer Offset
#define AT91C_EMAC_NCFG_RLCE (0x1 << 16) // (EMAC) Receive Length field Checking Enable
#define AT91C_EMAC_NCFG_DRFCS (0x1 << 17) // (EMAC) Discard Receive FCS
#define AT91C_EMAC_NCFG_EFRHD (0x1 << 18) // (EMAC)
#define AT91C_EMAC_NCFG_IRXFCS (0x1 << 19) // (EMAC) Ignore RX FCS
// -------- EMAC_NSR : (EMAC Offset: 0x08) Network Status Register --------
#define AT91C_EMAC_NSR_MDIO (0x1 << 1) // (EMAC)
#define AT91C_EMAC_NSR_IDLE (0x1 << 2) // (EMAC)
// -------- EMAC_TSR : (EMAC Offset: 0x14) Transmit Status Register --------
#define AT91C_EMAC_TSR_UBR (0x1 << 0) // (EMAC) Used Bit Read
#define AT91C_EMAC_TSR_COL (0x1 << 1) // (EMAC) Collision Occurred
#define AT91C_EMAC_TSR_RLE (0x1 << 2) // (EMAC) Retry Limit exceeded
#define AT91C_EMAC_TSR_TGO (0x1 << 3) // (EMAC) Transmit Go
#define AT91C_EMAC_TSR_BEX (0x1 << 4) // (EMAC) Buffers exhausted mid frame
#define AT91C_EMAC_TSR_COMP (0x1 << 5) // (EMAC) Transmit Complete
#define AT91C_EMAC_TSR_UND (0x1 << 6) // (EMAC) Transmit Underrun
// -------- EMAC_RBQP : (EMAC Offset: 0x18) Receive Buffer Queue Pointer Register --------
#define AT91C_EMAC_RBQP_ADDR (0x3fffffff << 2) // (EMAC) Receive buffer queue pointer address
// -------- EMAC_TBQP : (EMAC Offset: 0x1C) Transmit Buffer Queue Pointer Register --------
#define AT91C_EMAC_TBQP_ADDR (0x3fffffff << 2) // (EMAC) Transmit buffer queue pointer address
// -------- EMAC_RSR : (EMAC Offset: 0x20) Receive Status Register --------
#define AT91C_EMAC_RSR_BNA (0x1 << 0) // (EMAC) Buffer Not Available
#define AT91C_EMAC_RSR_REC (0x1 << 1) // (EMAC) Frame Received
#define AT91C_EMAC_RSR_OVR (0x1 << 2) // (EMAC) Receive Overrun
// -------- EMAC_ISR : (EMAC Offset: 0x24) Interrupt Status Register --------
#define AT91C_EMAC_ISR_MFD (0x1 << 0) // (EMAC) Management Frame Done
#define AT91C_EMAC_ISR_RCOMP (0x1 << 1) // (EMAC) Receive Complete
#define AT91C_EMAC_ISR_RXUBR (0x1 << 2) // (EMAC) Receive Used Bit Read
#define AT91C_EMAC_ISR_TXUBR (0x1 << 3) // (EMAC) Transmit Used Bit Read
#define AT91C_EMAC_ISR_TUND (0x1 << 4) // (EMAC) Ethernet Transmit Buffer Underrun
#define AT91C_EMAC_ISR_RLE (0x1 << 5) // (EMAC) Retry Limit Exceeded
#define AT91C_EMAC_ISR_TXERR (0x1 << 6) // (EMAC) Transmit Error
#define AT91C_EMAC_ISR_TCOMP (0x1 << 7) // (EMAC) Transmit Complete
#define AT91C_EMAC_ISR_ROVR (0x1 << 10) // (EMAC) Receive Overrun
#define AT91C_EMAC_ISR_HRESP (0x1 << 11) // (EMAC) Hresp not OK
#define AT91C_EMAC_ISR_PFR (0x1 << 12) // (EMAC) Pause Frame Received
#define AT91C_EMAC_ISR_PTZ (0x1 << 13) // (EMAC) Pause Time Zero
// -------- EMAC_IER : (EMAC Offset: 0x28) Interrupt Enable Register --------
#define AT91C_EMAC_IER_MFD (0x1 << 0) // (EMAC) Management Frame sent
#define AT91C_EMAC_IER_RCOMP (0x1 << 1) // (EMAC) Receive Complete
#define AT91C_EMAC_IER_RXUBR (0x1 << 2) // (EMAC) Receive Used Bit Read
#define AT91C_EMAC_IER_TXUBR (0x1 << 3) // (EMAC) Transmit Used Bit Read
#define AT91C_EMAC_IER_TUND (0x1 << 4) // (EMAC) Ethernet Transmit Buffer Underrun
#define AT91C_EMAC_IER_RLE (0x1 << 5) // (EMAC) Retry Limit Exceeded
#define AT91C_EMAC_IER_TXERR (0x1 << 6) // (EMAC)
#define AT91C_EMAC_IER_TCOMP (0x1 << 7) // (EMAC) Transmit Complete
#define AT91C_EMAC_IER_ROVR (0x1 << 10) // (EMAC) Receive Overrun
#define AT91C_EMAC_IER_HRESP (0x1 << 11) // (EMAC) Hresp not OK
#define AT91C_EMAC_IER_PFR (0x1 << 12) // (EMAC) Pause Frame Received
#define AT91C_EMAC_IER_PTZ (0x1 << 13) // (EMAC) Pause Time Zero
// -------- EMAC_IDR : (EMAC Offset: 0x2C) Interrupt Disable Register --------
#define AT91C_EMAC_IDR_MFD (0x1 << 0) // (EMAC) Management Frame sent
#define AT91C_EMAC_IDR_RCOMP (0x1 << 1) // (EMAC) Receive Complete
#define AT91C_EMAC_IDR_RXUBR (0x1 << 2) // (EMAC) Receive Used Bit Read
#define AT91C_EMAC_IDR_TXUBR (0x1 << 3) // (EMAC) Transmit Used Bit Read
#define AT91C_EMAC_IDR_TUND (0x1 << 4) // (EMAC) Ethernet Transmit Buffer Underrun
#define AT91C_EMAC_IDR_RLE (0x1 << 5) // (EMAC) Retry Limit Exceeded
#define AT91C_EMAC_IDR_TXERR (0x1 << 6) // (EMAC)
#define AT91C_EMAC_IDR_TCOMP (0x1 << 7) // (EMAC) Transmit Complete
#define AT91C_EMAC_IDR_ROVR (0x1 << 10) // (EMAC) Receive Overrun
#define AT91C_EMAC_IDR_HRESP (0x1 << 11) // (EMAC) Hresp not OK
#define AT91C_EMAC_IDR_PFR (0x1 << 12) // (EMAC) Pause Frame Received
#define AT91C_EMAC_IDR_PTZ (0x1 << 13) // (EMAC) Pause Time Zero
// -------- EMAC_IMR : (EMAC Offset: 0x30) Interrupt Mask Register --------
#define AT91C_EMAC_IMR_MFD (0x1 << 0) // (EMAC) Management Frame sent
#define AT91C_EMAC_IMR_RCOMP (0x1 << 1) // (EMAC) Receive Complete
#define AT91C_EMAC_IMR_RXUBR (0x1 << 2) // (EMAC) Receive Used Bit Read
#define AT91C_EMAC_IMR_TXUBR (0x1 << 3) // (EMAC) Transmit Used Bit Read
#define AT91C_EMAC_IMR_TUND (0x1 << 4) // (EMAC) Ethernet Transmit Buffer Underrun
#define AT91C_EMAC_IMR_RLE (0x1 << 5) // (EMAC) Retry Limit Exceeded
#define AT91C_EMAC_IMR_TXERR (0x1 << 6) // (EMAC)
#define AT91C_EMAC_IMR_TCOMP (0x1 << 7) // (EMAC) Transmit Complete
#define AT91C_EMAC_IMR_ROVR (0x1 << 10) // (EMAC) Receive Overrun
#define AT91C_EMAC_IMR_HRESP (0x1 << 11) // (EMAC) Hresp not OK
#define AT91C_EMAC_IMR_PFR (0x1 << 12) // (EMAC) Pause Frame Received
#define AT91C_EMAC_IMR_PTZ (0x1 << 13) // (EMAC) Pause Time Zero
// -------- EMAC_MAN : (EMAC Offset: 0x34) Phy Maintenance Register --------
#define AT91C_EMAC_MAN_DATA (0xffff << 0) // (EMAC)
#define AT91C_EMAC_MAN_CODE (0x3 << 16) // (EMAC)
#define AT91C_EMAC_MAN_REGA (0x1f << 18) // (EMAC) Register Address
#define AT91C_EMAC_MAN_PHYA (0x1f << 23) // (EMAC) PHY Address
#define AT91C_EMAC_MAN_RW (0x3 << 28) // (EMAC) Read-write
#define AT91C_EMAC_MAN_SOF (0x3 << 30) // (EMAC) Start of frame
// -------- EMAC_PTR : (EMAC Offset: 0x38) Pause Time Register --------
#define AT91C_EMAC_PTR_PTIME (0xffff << 0) // (EMAC) Pause Time
// -------- EMAC_PFR : (EMAC Offset: 0x3C) Pause Frames Received Register --------
#define AT91C_EMAC_PFR_FROK (0xffff << 0) // (EMAC) Pause Frames received OK
// -------- EMAC_FTO : (EMAC Offset: 0x40) Frames Transmitted Ok Register --------
#define AT91C_EMAC_FTO_FTOK (0xffffff << 0) // (EMAC) Frames Transmitted OK
// -------- EMAC_SCF : (EMAC Offset: 0x44) Single Collision Frames Register --------
#define AT91C_EMAC_SCF_SCF (0xffff << 0) // (EMAC) Single Collision Frames
// -------- EMAC_MCF : (EMAC Offset: 0x48) Multiple Collision Frames Register --------
#define AT91C_EMAC_MCF_MCF (0xffff << 0) // (EMAC) Multicollision Frames
// -------- EMAC_FRO : (EMAC Offset: 0x4C) Frames Received Ok Register --------
#define AT91C_EMAC_FRO_FROK (0xffffff << 0) // (EMAC) Frames Received OK
// -------- EMAC_FCSE : (EMAC Offset: 0x50) Frame Check Sequence Errors Register --------
#define AT91C_EMAC_FCSE_FCSE (0xff << 0) // (EMAC) Frame Check Sequence Errors
// -------- EMAC_ALE : (EMAC Offset: 0x54) Alignment Errors Register --------
#define AT91C_EMAC_ALE_ALE (0xff << 0) // (EMAC) Alignment Errors
// -------- EMAC_DTF : (EMAC Offset: 0x58) Deferred Transmission Frames Register --------
#define AT91C_EMAC_DTF_DTF (0xffff << 0) // (EMAC) Deferred Transmission Frames
// -------- EMAC_LCOL : (EMAC Offset: 0x5C) Late Collisions Register --------
#define AT91C_EMAC_LCOL_LCOL (0xff << 0) // (EMAC) Late Collisions
// -------- EMAC_ECOL : (EMAC Offset: 0x60) Excessive Collisions Register --------
#define AT91C_EMAC_ECOL_EXCOL (0xff << 0) // (EMAC) Excessive Collisions
// -------- EMAC_TUND : (EMAC Offset: 0x64) Transmit Underrun Errors Register --------
#define AT91C_EMAC_TUND_TUND (0xff << 0) // (EMAC) Transmit Underruns
// -------- EMAC_CSE : (EMAC Offset: 0x68) Carrier Sense Errors Register --------
#define AT91C_EMAC_CSE_CSE (0xff << 0) // (EMAC) Carrier Sense Errors
// -------- EMAC_RRE : (EMAC Offset: 0x6C) Receive Resource Errors Register --------
#define AT91C_EMAC_RRE_RRE (0xffff << 0) // (EMAC) Receive Resource Errors
// -------- EMAC_ROV : (EMAC Offset: 0x70) Receive Overrun Errors Register --------
#define AT91C_EMAC_ROV_ROVR (0xff << 0) // (EMAC) Receive Overrun
// -------- EMAC_RSE : (EMAC Offset: 0x74) Receive Symbol Errors Register --------
#define AT91C_EMAC_RSE_RSE (0xff << 0) // (EMAC) Receive Symbol Errors
// -------- EMAC_ELE : (EMAC Offset: 0x78) Excessive Length Errors Register --------
#define AT91C_EMAC_ELE_EXL (0xff << 0) // (EMAC) Excessive Length Errors
// -------- EMAC_RJA : (EMAC Offset: 0x7C) Receive Jabbers Register --------
#define AT91C_EMAC_RJA_RJB (0xff << 0) // (EMAC) Receive Jabbers
// -------- EMAC_USF : (EMAC Offset: 0x80) Undersize Frames Register --------
#define AT91C_EMAC_USF_USF (0xff << 0) // (EMAC) Undersize frames
// -------- EMAC_STE : (EMAC Offset: 0x84) SQE Test Errors Register --------
#define AT91C_EMAC_STE_SQER (0xff << 0) // (EMAC) SQE test errors
// -------- EMAC_RLE : (EMAC Offset: 0x88) Received Length Field Mismatch Register --------
#define AT91C_EMAC_RLE_RLFM (0xff << 0) // (EMAC) Receive Length Field Mismatch
// -------- EMAC_HRB : (EMAC Offset: 0x90) Hash Register Bottom [31:0] Register --------
#define AT91C_EMAC_HRB_ADDR (0xffffffff << 0) // (EMAC)
// -------- EMAC_HRT : (EMAC Offset: 0x94) Hash Register Top [63:32] Register --------
#define AT91C_EMAC_HRT_ADDR (0xffffffff << 0) // (EMAC)
// -------- EMAC_SA1B : (EMAC Offset: 0x98) Specific Address 1 Bottom Register --------
#define AT91C_EMAC_SA1B_ADDR (0xffffffff << 0) // (EMAC)
// -------- EMAC_SA1T : (EMAC Offset: 0x9C) Specific Address 1 Top Register --------
#define AT91C_EMAC_SA1T_ADDR (0xffff << 0) // (EMAC)
// -------- EMAC_SA2B : (EMAC Offset: 0xA0) Specific Address 2 Bottom Register --------
#define AT91C_EMAC_SA2B_ADDR (0xffffffff << 0) // (EMAC)
// -------- EMAC_SA2T : (EMAC Offset: 0xA4) Specific Address 2 Top Register --------
#define AT91C_EMAC_SA2T_ADDR (0xffff << 0) // (EMAC)
// -------- EMAC_SA3B : (EMAC Offset: 0xA8) Specific Address 3 Bottom Register --------
#define AT91C_EMAC_SA3B_ADDR (0xffffffff << 0) // (EMAC)
// -------- EMAC_SA3T : (EMAC Offset: 0xAC) Specific Address 3 Top Register --------
#define AT91C_EMAC_SA3T_ADDR (0xffff << 0) // (EMAC)
// -------- EMAC_SA4B : (EMAC Offset: 0xB0) Specific Address 4 Bottom Register --------
#define AT91C_EMAC_SA4B_ADDR (0xffffffff << 0) // (EMAC)
// -------- EMAC_SA4T : (EMAC Offset: 0xB4) Specific Address 4 Top Register --------
#define AT91C_EMAC_SA4T_ADDR (0xffff << 0) // (EMAC)
// -------- EMAC_TID : (EMAC Offset: 0xB8) Type ID Checking Register --------
#define AT91C_EMAC_TID_TID (0xffff << 0) // (EMAC) Type ID checking
// -------- EMAC_USRIO : (EMAC Offset: 0xC0) User Input/Output Register --------
#define AT91C_EMAC_USRIO_RMII (0x1 << 0) // (EMAC)
#define AT91C_EMAC_USRIO_CLKEN (0x1 << 1) // (EMAC)

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Control and Timing
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_GPBR {
  AT91_REG SYS_GPBR0; // General Purpose Backup Register 0
  AT91_REG SYS_GPBR1; // General Purpose Backup Register 1
  AT91_REG SYS_GPBR2; // General Purpose Backup Register 2
  AT91_REG SYS_GPBR3; // General Purpose Backup Register 3
} AT91S_GPBR, *AT91PS_GPBR;
#else
#define SYS_GPBR0 (AT91_CAST(AT91_REG *) 0x00000000) // General Purpose Backup Register 0
#define SYS_GPBR1 (AT91_CAST(AT91_REG *) 0x00000004) // General Purpose Backup Register 1
#define SYS_GPBR2 (AT91_CAST(AT91_REG *) 0x00000008) // General Purpose Backup Register 2
#define SYS_GPBR3 (AT91_CAST(AT91_REG *) 0x0000000C) // General Purpose Backup Register 3
#endif
// -------- SYS_GPBR0 : (GPBR Offset: 0x0) General Purpose Backup Register 0 --------
#define AT91C_SYS_GPBR0_GPBR_VALUE0 (0xffffffff << 0) // (GPBR) Value of GPBR x
// -------- SYS_GPBR1 : (GPBR Offset: 0x4) General Purpose Backup Register 1 --------
#define AT91C_SYS_GPBR1_GPBR_VALUE1 (0xffffffff << 0) // (GPBR) Value of GPBR x
// -------- SYS_GPBR2 : (GPBR Offset: 0x8) General Purpose Backup Register 2 --------
#define AT91C_SYS_GPBR2_GPBR_VALUE2 (0xffffffff << 0) // (GPBR) Value of GPBR x
// -------- SYS_GPBR3 : (GPBR Offset: 0xC) General Purpose Backup Register 3 --------
#define AT91C_SYS_GPBR3_GPBR_VALUE3 (0xffffffff << 0) // (GPBR) Value of GPBR x

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Image Sensor Interface
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_ISI {
  AT91_REG ISI_CR1;      // ISI Control 1 Register
  AT91_REG ISI_CR2;      // ISI Control 2 Register
  AT91_REG ISI_SR;       // ISI Status Register
  AT91_REG ISI_IER;      // ISI Interrupt Enable Register
  AT91_REG ISI_IDR;      // ISI Interrupt Disable Register
  AT91_REG ISI_IMR;      // ISI Interrupt Mask Register
  AT91_REG Reserved1[2];
  AT91_REG ISI_PSIZE;    // ISI Preview Size Register
  AT91_REG ISI_PDECF;    // ISI Preview Decimation Factor Register
  AT91_REG ISI_PPFBD;    // ISI Preview Primary FBD Register
  AT91_REG ISI_CDBA;     // ISI Codec DMA Base Address Register
  AT91_REG ISI_Y2R_SET0; // ISI CSC YCrCb To RGB Set 0 Register
  AT91_REG ISI_Y2R_SET1; // ISI CSC YCrCb To RGB Set 1 Register
  AT91_REG ISI_R2Y_SET0; // ISI CSC RGB To YCrCb Set 0 Register
  AT91_REG ISI_R2Y_SET1; // ISI CSC RGB To YCrCb Set 1 Register
  AT91_REG ISI_R2Y_SET2; // ISI CSC RGB To YCrCb Set 2 Register
} AT91S_ISI, *AT91PS_ISI;
#else
#define ISI_CR1      (AT91_CAST(AT91_REG *) 0x00000000) // ISI Control 1 Register
#define ISI_CR2      (AT91_CAST(AT91_REG *) 0x00000004) // ISI Control 2 Register
#define ISI_SR       (AT91_CAST(AT91_REG *) 0x00000008) // ISI Status Register
#define ISI_IER      (AT91_CAST(AT91_REG *) 0x0000000C) // ISI Interrupt Enable Register
#define ISI_IDR      (AT91_CAST(AT91_REG *) 0x00000010) // ISI Interrupt Disable Register
#define ISI_IMR      (AT91_CAST(AT91_REG *) 0x00000014) // ISI Interrupt Mask Register
#define ISI_PSIZE    (AT91_CAST(AT91_REG *) 0x00000020) // ISI Preview Size Register
#define ISI_PDECF    (AT91_CAST(AT91_REG *) 0x00000024) // ISI Preview Decimation Factor Register
#define ISI_PPFBD    (AT91_CAST(AT91_REG *) 0x00000028) // ISI Preview Primary FBD Register
#define ISI_CDBA     (AT91_CAST(AT91_REG *) 0x0000002C) // ISI Codec DMA Base Address Register
#define ISI_Y2R_SET0 (AT91_CAST(AT91_REG *) 0x00000030) // ISI CSC YCrCb To RGB Set 0 Register
#define ISI_Y2R_SET1 (AT91_CAST(AT91_REG *) 0x00000034) // ISI CSC YCrCb To RGB Set 1 Register
#define ISI_R2Y_SET0 (AT91_CAST(AT91_REG *) 0x00000038) // ISI CSC RGB To YCrCb Set 0 Register
#define ISI_R2Y_SET1 (AT91_CAST(AT91_REG *) 0x0000003C) // ISI CSC RGB To YCrCb Set 1 Register
#define ISI_R2Y_SET2 (AT91_CAST(AT91_REG *) 0x00000040) // ISI CSC RGB To YCrCb Set 2 Register
#endif
// -------- ISI_CR1 : (ISI Offset: 0x00) ISI Control 1 Register --------
#define AT91C_ISI_CR1_ISI_RST (0x1 << 0) // (ISI) Image sensor interface reset
#define AT91C_ISI_CR1_ISI_DIS (0x1 << 1) // (ISI) Image sensor disable:
#define AT91C_ISI_CR1_HSYNC_POL (0x1 << 2) // (ISI) Horizontal synchronization polarity
#define AT91C_ISI_CR1_VSYNC_POL (0x1 << 3) // (ISI) Vertical synchronization polarity
#define AT91C_ISI_CR1_PIXCLK_POL (0x1 << 4) // (ISI) Pixel clock polarity
#define AT91C_ISI_CR1_EMB_SYNC (0x1 << 6) // (ISI) Embedded synchronization
#define AT91C_ISI_CR1_CRC_SYNC (0x1 << 7) // (ISI) Embedded synchronization
#define AT91C_ISI_CR1_FRATE (0x7 << 8) // (ISI) Frame rate [0..7]
#define AT91C_ISI_CR1_FULL (0x1 << 12) // (ISI) Full mode is allowed
#define AT91C_ISI_CR1_THMASK (0x3 << 13) // (ISI) Threshold mask
#define AT91C_ISI_CR1_CODEC_ON (0x1 << 15) // (ISI) Enable the codec path enable bit
#define AT91C_ISI_CR1_SLD (0xff << 16) // (ISI) Start of Line Delay
#define AT91C_ISI_CR1_SFD (0xff << 24) // (ISI) Start of Frame Delay
// -------- ISI_CR2 : (ISI Offset: 0x04) ISI Control 2 Register --------
#define AT91C_ISI_CR2_IM_VSIZE (0x7ff << 0) // (ISI) Vertical size of the Image sensor [0..2047]
#define AT91C_ISI_CR2_GS_MODE (0x1 << 11) // (ISI)
#define AT91C_ISI_CR2_RGB_MODE (0x1 << 12) // (ISI) RGB input mode
#define AT91C_ISI_CR2_GRAYSCALE (0x1 << 13) // (ISI)
#define AT91C_ISI_CR2_RGB_SWAP (0x1 << 14) // (ISI)
#define AT91C_ISI_CR2_COL_SPACE (0x1 << 15) // (ISI) Color space for the image data
#define AT91C_ISI_CR2_IM_HSIZE (0x7ff << 16) // (ISI) Horizontal size of the Image sensor [0..2047]
#define AT91C_ISI_CR2_YCC_SWAP (0x3 << 28) // (ISI) Defines the YCC image data
#define AT91C_ISI_CR2_RGB_CFG (0x3 << 30) // (ISI) Defines RGB pattern when RGB_MODE is set to 1
// -------- ISI_SR : (ISI Offset: 0x08) ISI Status Register --------
#define AT91C_ISI_SR_SOF (0x1 << 0) // (ISI) Start of frame
#define AT91C_ISI_SR_DIS (0x1 << 1) // (ISI) Image Sensor Interface disable
#define AT91C_ISI_SR_SOFTRST (0x1 << 2) // (ISI) Software reset
#define AT91C_ISI_SR_CDC_PND (0x1 << 3) // (ISI) Codec request pending
#define AT91C_ISI_SR_CRC_ERR (0x1 << 4) // (ISI) CRC synchronization error
#define AT91C_ISI_SR_FO_C_OVF (0x1 << 5) // (ISI) FIFO codec overflow
#define AT91C_ISI_SR_FO_P_OVF (0x1 << 6) // (ISI) FIFO preview overflow
#define AT91C_ISI_SR_FO_P_EMP (0x1 << 7) // (ISI)
#define AT91C_ISI_SR_FO_C_EMP (0x1 << 8) // (ISI)
#define AT91C_ISI_SR_FR_OVR (0x1 << 9) // (ISI) Frame rate overrun
// -------- ISI_IER : (ISI Offset: 0x0C) ISI Interrupt Enable Register --------
#define AT91C_ISI_IER_SOF (0x1 << 0) // (ISI) Start of Frame
#define AT91C_ISI_IER_DIS (0x1 << 1) // (ISI) Image Sensor Interface disable
#define AT91C_ISI_IER_SOFTRST (0x1 << 2) // (ISI) Soft Reset
#define AT91C_ISI_IER_CRC_ERR (0x1 << 4) // (ISI) CRC synchronization error
#define AT91C_ISI_IER_FO_C_OVF (0x1 << 5) // (ISI) FIFO codec Overflow
#define AT91C_ISI_IER_FO_P_OVF (0x1 << 6) // (ISI) FIFO preview Overflow
#define AT91C_ISI_IER_FO_P_EMP (0x1 << 7) // (ISI)
#define AT91C_ISI_IER_FO_C_EMP (0x1 << 8) // (ISI)
#define AT91C_ISI_IER_FR_OVR (0x1 << 9) // (ISI) Frame overrun
// -------- ISI_IDR : (ISI Offset: 0x10) ISI Interrupt Disable Register --------
#define AT91C_ISI_IDR_SOF (0x1 << 0) // (ISI) Start of Frame
#define AT91C_ISI_IDR_DIS (0x1 << 1) // (ISI) Image Sensor Interface disable
#define AT91C_ISI_IDR_SOFTRST (0x1 << 2) // (ISI)
#define AT91C_ISI_IDR_CRC_ERR (0x1 << 4) // (ISI) CRC synchronization error
#define AT91C_ISI_IDR_FO_C_OVF (0x1 << 5) // (ISI) FIFO codec overflow
#define AT91C_ISI_IDR_FO_P_OVF (0x1 << 6) // (ISI) FIFO preview overflow
#define AT91C_ISI_IDR_FO_P_EMP (0x1 << 7) // (ISI)
#define AT91C_ISI_IDR_FO_C_EMP (0x1 << 8) // (ISI)
#define AT91C_ISI_IDR_FR_OVR (0x1 << 9) // (ISI)
// -------- ISI_IMR : (ISI Offset: 0x14) ISI Interrupt Mask Register --------
#define AT91C_ISI_IMR_SOF (0x1 << 0) // (ISI) Start of Frame
#define AT91C_ISI_IMR_DIS (0x1 << 1) // (ISI) Image sensor interface disable
#define AT91C_ISI_IMR_SOFTRST (0x1 << 2) // (ISI)
#define AT91C_ISI_IMR_CRC_ERR (0x1 << 4) // (ISI) CRC synchronization error
#define AT91C_ISI_IMR_FO_C_OVF (0x1 << 5) // (ISI) FIFO codec overflow
#define AT91C_ISI_IMR_FO_P_OVF (0x1 << 6) // (ISI) FIFO preview overflow
#define AT91C_ISI_IMR_FO_P_EMP (0x1 << 7) // (ISI)
#define AT91C_ISI_IMR_FO_C_EMP (0x1 << 8) // (ISI)
#define AT91C_ISI_IMR_FR_OVR (0x1 << 9) // (ISI) Frame Rate Overrun
// -------- ISI_PSIZE : (ISI Offset: 0x20) ISI Preview Size Register --------
#define AT91C_ISI_PSIZE_PREV_VSIZE (0x3ff << 0) // (ISI) Vertical size for the preview path
#define AT91C_ISI_PSIZE_PREV_HSIZE (0x3ff << 16) // (ISI) Horizontal size for the preview path
// -------- ISI_PDECF : (ISI Offset: 0x24) ISI Preview Decimation Factor Register --------
#define AT91C_ISI_PDECF_DEC_FACTOR (0xff << 0) // (ISI) Decimation factor
// -------- ISI_PPFBD : (ISI Offset: 0x28) ISI Preview Primary FBD Register --------
#define AT91C_ISI_PPFBD_PREV_FBD_ADDR (0xffffffff << 0) // (ISI) Base address for preview frame buffer descriptor
// -------- ISI_CDBA : (ISI Offset: 0x2C) ISI Codec DMA Base Address Register --------
#define AT91C_ISI_CDBA_CODEC_DMA_ADDR (0xffffffff << 0) // (ISI) Base address for codec DMA
// -------- ISI_Y2R_SET0 : (ISI Offset: 0x30) ISI CSC YCrCb To RGB Set 0 Register --------
#define AT91C_ISI_Y2R_SET0_C0 (0xff << 0) // (ISI) Color Space Conversion Matrix Coefficient C0
#define AT91C_ISI_Y2R_SET0_C1 (0xff << 8) // (ISI) Color Space Conversion Matrix Coefficient C1
#define AT91C_ISI_Y2R_SET0_C2 (0xff << 16) // (ISI) Color Space Conversion Matrix Coefficient C2
#define AT91C_ISI_Y2R_SET0_C3 (0xff << 24) // (ISI) Color Space Conversion Matrix Coefficient C3
// -------- ISI_Y2R_SET1 : (ISI Offset: 0x34) ISI CSC YCrCb To RGB Set 1 Register --------
#define AT91C_ISI_Y2R_SET1_C4 (0x1ff << 0) // (ISI) Color Space Conversion Matrix coefficient C4
#define AT91C_ISI_Y2R_SET1_Yoff (0x1 << 12) // (ISI) Color Space Conversion Luminance default offset
#define AT91C_ISI_Y2R_SET1_Croff (0x1 << 13) // (ISI) Color Space Conversion Red Chrominance default offset
#define AT91C_ISI_Y2R_SET1_Cboff (0x1 << 14) // (ISI) Color Space Conversion Blue Chrominance default offset
// -------- ISI_R2Y_SET0 : (ISI Offset: 0x38) ISI CSC RGB To YCrCb Set 0 Register --------
#define AT91C_ISI_R2Y_SET0_C0 (0xff << 0) // (ISI) Color Space Conversion Matrix coefficient C0
#define AT91C_ISI_R2Y_SET0_C1 (0xff << 8) // (ISI) Color Space Conversion Matrix coefficient C1
#define AT91C_ISI_R2Y_SET0_C2 (0xff << 16) // (ISI) Color Space Conversion Matrix coefficient C2
#define AT91C_ISI_R2Y_SET0_Roff (0x1 << 24) // (ISI) Color Space Conversion Red component offset
// -------- ISI_R2Y_SET1 : (ISI Offset: 0x3C) ISI CSC RGB To YCrCb Set 1 Register --------
#define AT91C_ISI_R2Y_SET1_C3 (0xff << 0) // (ISI) Color Space Conversion Matrix coefficient C3
#define AT91C_ISI_R2Y_SET1_C4 (0xff << 8) // (ISI) Color Space Conversion Matrix coefficient C4
#define AT91C_ISI_R2Y_SET1_C5 (0xff << 16) // (ISI) Color Space Conversion Matrix coefficient C5
#define AT91C_ISI_R2Y_SET1_Goff (0x1 << 24) // (ISI) Color Space Conversion Green component offset
// -------- ISI_R2Y_SET2 : (ISI Offset: 0x40) ISI CSC RGB To YCrCb Set 2 Register --------
#define AT91C_ISI_R2Y_SET2_C6 (0xff << 0) // (ISI) Color Space Conversion Matrix coefficient C6
#define AT91C_ISI_R2Y_SET2_C7 (0xff << 8) // (ISI) Color Space Conversion Matrix coefficient C7
#define AT91C_ISI_R2Y_SET2_C8 (0xff << 16) // (ISI) Color Space Conversion Matrix coefficient C8
#define AT91C_ISI_R2Y_SET2_Boff (0x1 << 24) // (ISI) Color Space Conversion Blue component offset

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR LCD Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_LCDC {
  AT91_REG LCDC_DMABADDR1;     // DMA Base Address Register 1
  AT91_REG LCDC_DMABADDR2;     // DMA Base Address Register 2
  AT91_REG LCDC_DMAFRMPT1;     // DMA Frame Pointer Register 1
  AT91_REG LCDC_DMAFRMPT2;     // DMA Frame Pointer Register 2
  AT91_REG LCDC_DMAFRMADD1;    // DMA Frame Address Register 1
  AT91_REG LCDC_DMAFRMADD2;    // DMA Frame Address Register 2
  AT91_REG LCDC_DMAFRMCFG;     // DMA Frame Configuration Register
  AT91_REG LCDC_DMACON;        // DMA Control Register
  AT91_REG LCDC_DMA2DCFG;      // DMA Control Register
  AT91_REG Reserved1[503];
  AT91_REG LCDC_CON1;          // LCD Control Register 1
  AT91_REG LCDC_CON2;          // LCD Control Register 2
  AT91_REG LCDC_TIM1;          // LCD Timing Register 1
  AT91_REG LCDC_TIM2;          // LCD Timing Register 2
  AT91_REG LCDC_FRMCFG;        // LCD Frame Configuration Register
  AT91_REG LCDC_FIFO;          // LCD FIFO Register
  AT91_REG Reserved2[1];
  AT91_REG LCDC_DP1_2;         // Dithering Pattern DP1_2
  AT91_REG LCDC_DP4_7;         // Dithering Pattern DP4_7
  AT91_REG LCDC_DP3_5;         // Dithering Pattern DP3_5
  AT91_REG LCDC_DP2_3;         // Dithering Pattern DP2_3
  AT91_REG LCDC_DP5_7;         // Dithering Pattern DP5_7
  AT91_REG LCDC_DP3_4;         // Dithering Pattern DP3_4
  AT91_REG LCDC_DP4_5;         // Dithering Pattern DP4_5
  AT91_REG LCDC_DP6_7;         // Dithering Pattern DP6_7
  AT91_REG LCDC_PWRCON;        // Power Control Register
  AT91_REG LCDC_CONTRAST_CTR;  // Contrast Control Register
  AT91_REG LCDC_CONTRAST_VAL;  // Contrast Value Register
  AT91_REG LCDC_IER;           // LCD Interrupt Enable Register
  AT91_REG LCDC_IDR;           // LCD Interrupt Disable Register
  AT91_REG LCDC_IMR;           // LCD Interrupt Mask Register
  AT91_REG LCDC_ISR;           // LCD Interrupt Status Register
  AT91_REG LCDC_ICR;           // LCD Interrupt Clear Register
  AT91_REG Reserved3[1];
  AT91_REG LCDC_ITR;           // LCD Interrupt Test Register
  AT91_REG LCDC_IRR;           // LCD Interrupt Raw Status Register
  AT91_REG Reserved4[230];
  AT91_REG LCDC_LUTENTRY[256]; // Palette entry
} AT91S_LCDC, *AT91PS_LCDC;
#else
#define LCDC_DMABADDR1    (AT91_CAST(AT91_REG *) 0x00000000) // DMA Base Address Register 1
#define LCDC_DMABADDR2    (AT91_CAST(AT91_REG *) 0x00000004) // DMA Base Address Register 2
#define LCDC_DMAFRMPT1    (AT91_CAST(AT91_REG *) 0x00000008) // DMA Frame Pointer Register 1
#define LCDC_DMAFRMPT2    (AT91_CAST(AT91_REG *) 0x0000000C) // DMA Frame Pointer Register 2
#define LCDC_DMAFRMADD1   (AT91_CAST(AT91_REG *) 0x00000010) // DMA Frame Address Register 1
#define LCDC_DMAFRMADD2   (AT91_CAST(AT91_REG *) 0x00000014) // DMA Frame Address Register 2
#define LCDC_DMAFRMCFG    (AT91_CAST(AT91_REG *) 0x00000018) // DMA Frame Configuration Register
#define LCDC_DMACON       (AT91_CAST(AT91_REG *) 0x0000001C) // DMA Control Register
#define LCDC_DMA2DCFG     (AT91_CAST(AT91_REG *) 0x00000020) // DMA Control Register
#define LCDC_CON1         (AT91_CAST(AT91_REG *) 0x00000800) // LCD Control Register 1
#define LCDC_CON2         (AT91_CAST(AT91_REG *) 0x00000804) // LCD Control Register 2
#define LCDC_TIM1         (AT91_CAST(AT91_REG *) 0x00000808) // LCD Timing Register 1
#define LCDC_TIM2         (AT91_CAST(AT91_REG *) 0x0000080C) // LCD Timing Register 2
#define LCDC_FRMCFG       (AT91_CAST(AT91_REG *) 0x00000810) // LCD Frame Configuration Register
#define LCDC_FIFO         (AT91_CAST(AT91_REG *) 0x00000814) // LCD FIFO Register
#define LCDC_DP1_2        (AT91_CAST(AT91_REG *) 0x0000081C) // Dithering Pattern DP1_2
#define LCDC_DP4_7        (AT91_CAST(AT91_REG *) 0x00000820) // Dithering Pattern DP4_7
#define LCDC_DP3_5        (AT91_CAST(AT91_REG *) 0x00000824) // Dithering Pattern DP3_5
#define LCDC_DP2_3        (AT91_CAST(AT91_REG *) 0x00000828) // Dithering Pattern DP2_3
#define LCDC_DP5_7        (AT91_CAST(AT91_REG *) 0x0000082C) // Dithering Pattern DP5_7
#define LCDC_DP3_4        (AT91_CAST(AT91_REG *) 0x00000830) // Dithering Pattern DP3_4
#define LCDC_DP4_5        (AT91_CAST(AT91_REG *) 0x00000834) // Dithering Pattern DP4_5
#define LCDC_DP6_7        (AT91_CAST(AT91_REG *) 0x00000838) // Dithering Pattern DP6_7
#define LCDC_PWRCON       (AT91_CAST(AT91_REG *) 0x0000083C) // Power Control Register
#define LCDC_CONTRAST_CTR (AT91_CAST(AT91_REG *) 0x00000840) // Contrast Control Register
#define LCDC_CONTRAST_VAL (AT91_CAST(AT91_REG *) 0x00000844) // Contrast Value Register
#define LCDC_IER          (AT91_CAST(AT91_REG *) 0x00000848) // LCD Interrupt Enable Register
#define LCDC_IDR          (AT91_CAST(AT91_REG *) 0x0000084C) // LCD Interrupt Disable Register
#define LCDC_IMR          (AT91_CAST(AT91_REG *) 0x00000850) // LCD Interrupt Mask Register
#define LCDC_ISR          (AT91_CAST(AT91_REG *) 0x00000854) // LCD Interrupt Status Register
#define LCDC_ICR          (AT91_CAST(AT91_REG *) 0x00000858) // LCD Interrupt Clear Register
#define LCDC_ITR          (AT91_CAST(AT91_REG *) 0x00000860) // LCD Interrupt Test Register
#define LCDC_IRR          (AT91_CAST(AT91_REG *) 0x00000864) // LCD Interrupt Raw Status Register
#define LCDC_LUTENTRY     (AT91_CAST(AT91_REG *) 0x00000C00) // Palette entry
#endif
// -------- LCDC_DMABADDR1 : (LCDC Offset: 0x0) DMA Base Address Register 1 --------
#define AT91C_LCDC_DMABADDR1_BADDR_U (0x3fffffff << 2) // (LCDC)
// -------- LCDC_DMABADDR2 : (LCDC Offset: 0x4) DMA Base Address Register 2 --------
#define AT91C_LCDC_DMABADDR2_BADDR_L (0xffffffff << 0) // (LCDC)
// -------- LCDC_DMAFRMPT1 : (LCDC Offset: 0x8) DMA Frame Pointer Register 1 --------
#define AT91C_LCDC_DMAFRMPT1_FRMPT_U (0x7fffff << 0) // (LCDC)
// -------- LCDC_DMAFRMPT2 : (LCDC Offset: 0xC) DMA Frame Pointer Register 2 --------
#define AT91C_LCDC_DMAFRMPT2_FRMPT_L (0x7fffff << 0) // (LCDC)
// -------- LCDC_DMAFRMADD1 : (LCDC Offset: 0x10) DMA Frame Address Register 1 --------
#define AT91C_LCDC_DMAFRMADD1_FRMADD_U (0xffffffff << 0) // (LCDC)
// -------- LCDC_DMAFRMADD2 : (LCDC Offset: 0x14) DMA Frame Address Register 2 --------
#define AT91C_LCDC_DMAFRMADD2_FRMADD_L (0xffffffff << 0) // (LCDC)
// -------- LCDC_DMAFRMCFG : (LCDC Offset: 0x18) DMA Frame Configuration Register --------
#define AT91C_LCDC_DMAFRMCFG_FRMSIZE (0x7fffff << 0) // (LCDC) Frame Size
#define AT91C_LCDC_DMAFRMCFG_BRSTLN (0x7f << 24) // (LCDC) Burst Length
// -------- LCDC_DMACON : (LCDC Offset: 0x1C) DMA Control Register --------
#define AT91C_LCDC_DMACON_DMAEN (0x1 << 0) // (LCDC) DMA Enable
#define AT91C_LCDC_DMACON_DMARST (0x1 << 1) // (LCDC) DMA Reset (Write-only)
#define AT91C_LCDC_DMACON_DMABUSY (0x1 << 2) // (LCDC) DMA Busy
#define AT91C_LCDC_DMACON_DMAUPDT (0x1 << 3) // (LCDC) DMA Configuration Update
#define AT91C_LCDC_DMACON_DMA2DEN (0x1 << 4) // (LCDC) DMA 2D Adressing Enable
// -------- LCDC_DMA2DCFG : (LCDC Offset: 0x20) DMA Control Register --------
#define AT91C_LCDC_DMA2DCFG_ADDRINC (0xffff << 0) // (LCDC) DMA 2D Addressing Address increment
#define AT91C_LCDC_DMA2DCFG_PIXELOFF (0x1f << 24) // (LCDC) DAM2D Addressing Pixel offset
// -------- LCDC_CON1 : (LCDC Offset: 0x800) LCD Control Register 1 --------
#define AT91C_LCDC_CON1_BYPASS (0x1 << 0) // (LCDC) Bypass LCDDOTCK divider
#define AT91C_LCDC_CON1_CLKVAL (0x1ff << 12) // (LCDC) Clock divider
#define AT91C_LCDC_CON1_LINECNT (0x7ff << 21) // (LCDC) Line Counter (Read-only)
// -------- LCDC_CON2 : (LCDC Offset: 0x804) LCD Control Register 2 --------
#define AT91C_LCDC_CON2_DISTYPE (0x3 << 0) // (LCDC) Display Type
#define AT91C_LCDC_CON2_SCANMOD (0x1 << 2) // (LCDC) Scan Mode
#define AT91C_LCDC_CON2_IFWIDTH (0x3 << 3) // (LCDC) Interface width (STN)
#define AT91C_LCDC_CON2_PIXELSIZE (0x7 << 5) // (LCDC) Bits per pixel
#define AT91C_LCDC_CON2_INVVD (0x1 << 8) // (LCDC) LCDD polarity
#define AT91C_LCDC_CON2_INVFRAME (0x1 << 9) // (LCDC) LCDVSYNC polarity
#define AT91C_LCDC_CON2_INVLINE (0x1 << 10) // (LCDC) LCDHSYNC polarity
#define AT91C_LCDC_CON2_INVCLK (0x1 << 11) // (LCDC) LCDDOTCK polarity
#define AT91C_LCDC_CON2_INVDVAL (0x1 << 12) // (LCDC) LCDDEN polarity
#define AT91C_LCDC_CON2_CLKMOD (0x1 << 15) // (LCDC) LCDDOTCK mode
#define AT91C_LCDC_CON2_MEMOR (0x3 << 30) // (LCDC) Memory Ordering Format
// -------- LCDC_TIM1 : (LCDC Offset: 0x808) LCD Timing Register 1 --------
#define AT91C_LCDC_TIM1_VFP (0xff << 0) // (LCDC) Vertical Front Porch
#define AT91C_LCDC_TIM1_VBP (0xff << 8) // (LCDC) Vertical Back Porch
#define AT91C_LCDC_TIM1_VPW (0x3f << 16) // (LCDC) Vertical Synchronization pulse width
#define AT91C_LCDC_TIM1_VHDLY (0xf << 24) // (LCDC) Vertical to horizontal delay
// -------- LCDC_TIM2 : (LCDC Offset: 0x80C) LCD Timing Register 2 --------
#define AT91C_LCDC_TIM2_HBP (0xff << 0) // (LCDC) Horizontal Back Porch
#define AT91C_LCDC_TIM2_HPW (0x3f << 8) // (LCDC) Horizontal synchronization pulse width
#define AT91C_LCDC_TIM2_HFP (0x7ff << 21) // (LCDC) Horizontal Front Porch
// -------- LCDC_FRMCFG : (LCDC Offset: 0x810) LCD Frame Configuration Register --------
#define AT91C_LCDC_FRMCFG_LINEVAL (0x7ff << 0) // (LCDC) Vertical size of LCD module
#define AT91C_LCDC_FRMCFG_LINESIZE (0x7ff << 21) // (LCDC) Horizontal size of LCD module, in pixels, minus 1
// -------- LCDC_FIFO : (LCDC Offset: 0x814) LCD FIFO Register --------
#define AT91C_LCDC_FIFO_FIFOTH (0xffff << 0) // (LCDC) FIFO Threshold
// -------- LCDC_DP1_2 : (LCDC Offset: 0x81C) Dithering Pattern DP1_2 --------
#define AT91C_LCDC_DP1_2_DP1_2 (0xff << 0) // (LCDC) Pattern value for half duty cycle
// -------- LCDC_DP4_7 : (LCDC Offset: 0x820) Dithering Pattern DP4_7 --------
#define AT91C_LCDC_DP4_7_DP4_7 (0xfffffff << 0) // (LCDC) Pattern value for 4/7 duty cycle
// -------- LCDC_DP3_5 : (LCDC Offset: 0x824) Dithering Pattern DP3_5 --------
#define AT91C_LCDC_DP3_5_DP3_5 (0xfffff << 0) // (LCDC) Pattern value for 3/5 duty cycle
// -------- LCDC_DP2_3 : (LCDC Offset: 0x828) Dithering Pattern DP2_3 --------
#define AT91C_LCDC_DP2_3_DP2_3 (0xfff << 0) // (LCDC) Pattern value for 2/3 duty cycle
// -------- LCDC_DP5_7 : (LCDC Offset: 0x82C) Dithering Pattern DP5_7 --------
#define AT91C_LCDC_DP5_7_DP5_7 (0xfffffff << 0) // (LCDC) Pattern value for 5/7 duty cycle
// -------- LCDC_DP3_4 : (LCDC Offset: 0x830) Dithering Pattern DP3_4 --------
#define AT91C_LCDC_DP3_4_DP3_4 (0xffff << 0) // (LCDC) Pattern value for 3/4 duty cycle
// -------- LCDC_DP4_5 : (LCDC Offset: 0x834) Dithering Pattern DP4_5 --------
#define AT91C_LCDC_DP4_5_DP4_5 (0xfffff << 0) // (LCDC) Pattern value for 4/5 duty cycle
// -------- LCDC_DP6_7 : (LCDC Offset: 0x838) Dithering Pattern DP6_7 --------
#define AT91C_LCDC_DP6_7_DP6_7 (0xfffffff << 0) // (LCDC) Pattern value for 6/7 duty cycle
// -------- LCDC_PWRCON : (LCDC Offset: 0x83C) Power Control Register --------
#define AT91C_LCDC_PWRCON_LCD_PWR (0x1 << 0) // (LCDC) LCD module power control
#define AT91C_LCDC_PWRCON_GUARD_TIME (0x7f << 1) // (LCDC)
#define AT91C_LCDC_PWRCON_LCD_BUSY (0x1 << 31) // (LCDC)
// -------- LCDC_CONTRAST_CTR : (LCDC Offset: 0x840) Contrast Control Register --------
#define AT91C_LCDC_CONTRAST_CTR_PS (0x3 << 0) // (LCDC)
#define AT91C_LCDC_CONTRAST_CTR_POL (0x1 << 2) // (LCDC)
#define AT91C_LCDC_CONTRAST_CTR_ENA (0x1 << 3) // (LCDC)
// -------- LCDC_CONTRAST_VAL : (LCDC Offset: 0x844) Contrast Value Register --------
#define AT91C_LCDC_CONTRAST_VAL_CVAL (0xff << 0) // (LCDC)
// -------- LCDC_IER : (LCDC Offset: 0x848) LCD Interrupt Enable Register --------
#define AT91C_LCDC_IER_LNIE (0x1 << 0) // (LCDC) Line interrupt enable
#define AT91C_LCDC_IER_LSTLNIE (0x1 << 1) // (LCDC) Last line interrupt enable
#define AT91C_LCDC_IER_EOFIE (0x1 << 2) // (LCDC) DMA End of frame interrupt enable
#define AT91C_LCDC_IER_UFLWIE (0x1 << 4) // (LCDC) FIFO underflow interrupt enable
#define AT91C_LCDC_IER_OWRIE (0x1 << 5) // (LCDC) FIFO overwrite interrupt enable
#define AT91C_LCDC_IER_MERIE (0x1 << 6) // (LCDC) DMA memory error interrupt enable
// -------- LCDC_IDR : (LCDC Offset: 0x84C) LCD Interrupt Disable Register --------
#define AT91C_LCDC_IDR_LNID (0x1 << 0) // (LCDC) Line interrupt disable
#define AT91C_LCDC_IDR_LSTLNID (0x1 << 1) // (LCDC) Last line interrupt disable
#define AT91C_LCDC_IDR_EOFID (0x1 << 2) // (LCDC) DMA End of frame interrupt disable
#define AT91C_LCDC_IDR_UFLWID (0x1 << 4) // (LCDC) FIFO underflow interrupt disable
#define AT91C_LCDC_IDR_OWRID (0x1 << 5) // (LCDC) FIFO overwrite interrupt disable
#define AT91C_LCDC_IDR_MERID (0x1 << 6) // (LCDC) DMA Memory error interrupt disable
// -------- LCDC_IMR : (LCDC Offset: 0x850) LCD Interrupt Mask Register --------
#define AT91C_LCDC_IMR_LNIM (0x1 << 0) // (LCDC) Line interrupt mask
#define AT91C_LCDC_IMR_LSTLNIM (0x1 << 1) // (LCDC) Last line interrupt mask
#define AT91C_LCDC_IMR_EOFIM (0x1 << 2) // (LCDC) DMA End of frame interrupt mask
#define AT91C_LCDC_IMR_UFLWIM (0x1 << 4) // (LCDC) FIFO underflow interrupt mask
#define AT91C_LCDC_IMR_OWRIM (0x1 << 5) // (LCDC) FIFO overwrite interrupt mask
#define AT91C_LCDC_IMR_MERIM (0x1 << 6) // (LCDC) DMA Memory error interrupt mask
// -------- LCDC_ISR : (LCDC Offset: 0x854) LCD Interrupt Status Register --------
#define AT91C_LCDC_ISR_LNIS (0x1 << 0) // (LCDC) Line interrupt status
#define AT91C_LCDC_ISR_LSTLNIS (0x1 << 1) // (LCDC) Last line interrupt status
#define AT91C_LCDC_ISR_EOFIS (0x1 << 2) // (LCDC) DMA End of frame interrupt status
#define AT91C_LCDC_ISR_UFLWIS (0x1 << 4) // (LCDC) FIFO underflow interrupt status
#define AT91C_LCDC_ISR_OWRIS (0x1 << 5) // (LCDC) FIFO overwrite interrupt status
#define AT91C_LCDC_ISR_MERIS (0x1 << 6) // (LCDC) DMA Memory error interrupt status
// -------- LCDC_ICR : (LCDC Offset: 0x858) LCD Interrupt Clear Register --------
#define AT91C_LCDC_ICR_LNIC (0x1 << 0) // (LCDC) Line interrupt clear
#define AT91C_LCDC_ICR_LSTLNIC (0x1 << 1) // (LCDC) Last line interrupt clear
#define AT91C_LCDC_ICR_EOFIC (0x1 << 2) // (LCDC) DMA End of frame interrupt clear
#define AT91C_LCDC_ICR_UFLWIC (0x1 << 4) // (LCDC) FIFO underflow interrupt clear
#define AT91C_LCDC_ICR_OWRIC (0x1 << 5) // (LCDC) FIFO overwrite interrupt clear
#define AT91C_LCDC_ICR_MERIC (0x1 << 6) // (LCDC) DMA Memory error interrupt clear
// -------- LCDC_ITR : (LCDC Offset: 0x860) LCD Interrupt Test Register --------
#define AT91C_LCDC_ITR_LNIT (0x1 << 0) // (LCDC) Line interrupt test
#define AT91C_LCDC_ITR_LSTLNIT (0x1 << 1) // (LCDC) Last line interrupt test
#define AT91C_LCDC_ITR_EOFIT (0x1 << 2) // (LCDC) DMA End of frame interrupt test
#define AT91C_LCDC_ITR_UFLWIT (0x1 << 4) // (LCDC) FIFO underflow interrupt test
#define AT91C_LCDC_ITR_OWRIT (0x1 << 5) // (LCDC) FIFO overwrite interrupt test
#define AT91C_LCDC_ITR_MERIT (0x1 << 6) // (LCDC) DMA Memory error interrupt test
// -------- LCDC_IRR : (LCDC Offset: 0x864) LCD Interrupt Raw Status Register --------
#define AT91C_LCDC_IRR_LNIR (0x1 << 0) // (LCDC) Line interrupt raw status
#define AT91C_LCDC_IRR_LSTLNIR (0x1 << 1) // (LCDC) Last line interrupt raw status
#define AT91C_LCDC_IRR_EOFIR (0x1 << 2) // (LCDC) DMA End of frame interrupt raw status
#define AT91C_LCDC_IRR_UFLWIR (0x1 << 4) // (LCDC) FIFO underflow interrupt raw status
#define AT91C_LCDC_IRR_OWRIR (0x1 << 5) // (LCDC) FIFO overwrite interrupt raw status
#define AT91C_LCDC_IRR_MERIR (0x1 << 6) // (LCDC) DMA Memory error interrupt raw status
// -------- LCDC_LUTENTRY[256] : (LCDC Offset: 0xC00) Palette entry --------

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR AHB Bus Matrix
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_MATRIX {
  AT91_REG MATRIX_MCFG[16]; // Master Configuration Register
  AT91_REG MATRIX_SCFG[16]; // Slave Configuration Register
  AT91_REG MATRIX_PRAS0;    // Priority Register A for Slave 0
  AT91_REG MATRIX_PRBS0;    // Priority Register B for Slave 0
  AT91_REG MATRIX_PRAS1;    // Priority Register A for Slave 1
  AT91_REG MATRIX_PRBS1;    // Priority Register B for Slave 1
  AT91_REG MATRIX_PRAS2;    // Priority Register A for Slave 2
  AT91_REG MATRIX_PRBS2;    // Priority Register B for Slave 2
  AT91_REG MATRIX_PRAS3;    // Priority Register A for Slave 3
  AT91_REG MATRIX_PRBS3;    // Priority Register B for Slave 3
  AT91_REG MATRIX_PRAS4;    // Priority Register A for Slave 4
  AT91_REG MATRIX_PRBS4;    // Priority Register B for Slave 4
  AT91_REG MATRIX_PRAS5;    // Priority Register A for Slave 5
  AT91_REG MATRIX_PRBS5;    // Priority Register B for Slave 5
  AT91_REG MATRIX_PRAS6;    // Priority Register A for Slave 6
  AT91_REG MATRIX_PRBS6;    // Priority Register B for Slave 6
  AT91_REG MATRIX_PRAS7;    // Priority Register A for Slave 7
  AT91_REG MATRIX_PRBS7;    // Priority Register B for Slave 7
  AT91_REG MATRIX_PRAS8;    // Priority Register A for Slave 8
  AT91_REG MATRIX_PRBS8;    // Priority Register B for Slave 8
  AT91_REG MATRIX_PRAS9;    // Priority Register A for Slave 9
  AT91_REG MATRIX_PRBS9;    // Priority Register B for Slave 9
  AT91_REG MATRIX_PRAS10;   // Priority Register A for Slave 10
  AT91_REG MATRIX_PRBS10;   // Priority Register B for Slave 10
  AT91_REG MATRIX_PRAS11;   // Priority Register A for Slave 11
  AT91_REG MATRIX_PRBS11;   // Priority Register B for Slave 11
  AT91_REG MATRIX_PRAS12;   // Priority Register A for Slave 12
  AT91_REG MATRIX_PRBS12;   // Priority Register B for Slave 12
  AT91_REG MATRIX_PRAS13;   // Priority Register A for Slave 13
  AT91_REG MATRIX_PRBS13;   // Priority Register B for Slave 13
  AT91_REG MATRIX_PRAS14;   // Priority Register A for Slave 14
  AT91_REG MATRIX_PRBS14;   // Priority Register B for Slave 14
  AT91_REG MATRIX_PRAS15;   // Priority Register A for Slave 15
  AT91_REG MATRIX_PRBS15;   // Priority Register B for Slave 15
  AT91_REG MATRIX_MRCR;     // Master Remap Control Register
  AT91_REG Reserved1[3];
  AT91_REG CCFG_TCMR;
  AT91_REG CCFG_UDPHS;
  AT91_REG CCFG_VIDEO;
  AT91_REG Reserved2[3];
  AT91_REG CCFG_EBICSA;   // EBI Chip Select Assignment
  AT91_REG MATRIX_SFR[9];  //
  AT91_REG Reserved4[52];
  AT91_REG MATRIX_WPMR;     // Write Protect Mode Register
  AT91_REG MATRIX_WPSR;     // Write Protect Status Register
} AT91S_MATRIX, *AT91PS_MATRIX;
#else
#define MATRIX_MCFG   (AT91_CAST(AT91_REG *) 0x00000000) // Master Configuration Register
#define MATRIX_SCFG   (AT91_CAST(AT91_REG *) 0x00000040) // Slave Configuration Register
#define MATRIX_PRAS0  (AT91_CAST(AT91_REG *) 0x00000080) // Priority Register A for Slave 0
#define MATRIX_PRBS0  (AT91_CAST(AT91_REG *) 0x00000084) // Priority Register B for Slave 0
#define MATRIX_PRAS1  (AT91_CAST(AT91_REG *) 0x00000088) // Priority Register A for Slave 1
#define MATRIX_PRBS1  (AT91_CAST(AT91_REG *) 0x0000008C) // Priority Register B for Slave 1
#define MATRIX_PRAS2  (AT91_CAST(AT91_REG *) 0x00000090) // Priority Register A for Slave 2
#define MATRIX_PRBS2  (AT91_CAST(AT91_REG *) 0x00000094) // Priority Register B for Slave 2
#define MATRIX_PRAS3  (AT91_CAST(AT91_REG *) 0x00000098) // Priority Register A for Slave 3
#define MATRIX_PRBS3  (AT91_CAST(AT91_REG *) 0x0000009C) // Priority Register B for Slave 3
#define MATRIX_PRAS4  (AT91_CAST(AT91_REG *) 0x000000A0) // Priority Register A for Slave 4
#define MATRIX_PRBS4  (AT91_CAST(AT91_REG *) 0x000000A4) // Priority Register B for Slave 4
#define MATRIX_PRAS5  (AT91_CAST(AT91_REG *) 0x000000A8) // Priority Register A for Slave 5
#define MATRIX_PRBS5  (AT91_CAST(AT91_REG *) 0x000000AC) // Priority Register B for Slave 5
#define MATRIX_PRAS6  (AT91_CAST(AT91_REG *) 0x000000B0) // Priority Register A for Slave 6
#define MATRIX_PRBS6  (AT91_CAST(AT91_REG *) 0x000000B4) // Priority Register B for Slave 6
#define MATRIX_PRAS7  (AT91_CAST(AT91_REG *) 0x000000B8) // Priority Register A for Slave 7
#define MATRIX_PRBS7  (AT91_CAST(AT91_REG *) 0x000000BC) // Priority Register B for Slave 7
#define MATRIX_PRAS8  (AT91_CAST(AT91_REG *) 0x000000C0) // Priority Register A for Slave 8
#define MATRIX_PRBS8  (AT91_CAST(AT91_REG *) 0x000000C4) // Priority Register B for Slave 8
#define MATRIX_PRAS9  (AT91_CAST(AT91_REG *) 0x000000C8) // Priority Register A for Slave 9
#define MATRIX_PRBS9  (AT91_CAST(AT91_REG *) 0x000000CC) // Priority Register B for Slave 9
#define MATRIX_PRAS10 (AT91_CAST(AT91_REG *) 0x000000D0) // Priority Register A for Slave 10
#define MATRIX_PRBS10 (AT91_CAST(AT91_REG *) 0x000000D4) // Priority Register B for Slave 10
#define MATRIX_PRAS11 (AT91_CAST(AT91_REG *) 0x000000D8) // Priority Register A for Slave 11
#define MATRIX_PRBS11 (AT91_CAST(AT91_REG *) 0x000000DC) // Priority Register B for Slave 11
#define MATRIX_PRAS12 (AT91_CAST(AT91_REG *) 0x000000E0) // Priority Register A for Slave 12
#define MATRIX_PRBS12 (AT91_CAST(AT91_REG *) 0x000000E4) // Priority Register B for Slave 12
#define MATRIX_PRAS13 (AT91_CAST(AT91_REG *) 0x000000E8) // Priority Register A for Slave 13
#define MATRIX_PRBS13 (AT91_CAST(AT91_REG *) 0x000000EC) // Priority Register B for Slave 13
#define MATRIX_PRAS14 (AT91_CAST(AT91_REG *) 0x000000F0) // Priority Register A for Slave 14
#define MATRIX_PRBS14 (AT91_CAST(AT91_REG *) 0x000000F4) // Priority Register B for Slave 14
#define MATRIX_PRAS15 (AT91_CAST(AT91_REG *) 0x000000F8) // Priority Register A for Slave 15
#define MATRIX_PRBS15 (AT91_CAST(AT91_REG *) 0x000000FC) // Priority Register B for Slave 15
#define MATRIX_MRCR   (AT91_CAST(AT91_REG *) 0x00000100) // Master Remap Control Register
#define MATRIX_SFR    (AT91_CAST(AT91_REG *) 0x00000110) // Special Function Register
#define MATRIX_WPMR   (AT91_CAST(AT91_REG *) 0x000001E4) // Write Protect Mode Register
#define MATRIX_WPSR   (AT91_CAST(AT91_REG *) 0x000001E8) // Write Protect Status Register
#endif
// -------- MATRIX_MCFG[16] : (MATRIX Offset: 0x0000) Master Configuration Register --------
#define AT91C_MATRIX_MCFG_ULBT (0x7 << 0) // (MATRIX) Undefined Length Burst Type
// -------- MATRIX_SCFG[16] : (MATRIX Offset: 0x0040) Slave Configuration Register --------
#define AT91C_MATRIX_SCFG_SLOT_CYCLE (0x1ff << 0) // (MATRIX) Maximum Bus Grant Duration for Masters
#define AT91C_MATRIX_SCFG_DEFMSTR_TYPE (0x3 << 16) // (MATRIX) Default Master Type
#define AT91C_MATRIX_SCFG_FIXED_DEFMSTR (0xf << 18) // (MATRIX) Fixed Default Master
// -------- MATRIX_PRAS0 : (MATRIX Offset: 0x0080) Priority Register A for Slave 0 --------
#define AT91C_MATRIX_PRAS0_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS0_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS0_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS0_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS0_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS0_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS0_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS0_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS0 : (MATRIX Offset: 0x0084) Priority Register B for Slave 0 --------
#define AT91C_MATRIX_PRBS0_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS0_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS0_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS0_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS0_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS0_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS0_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS0_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS1 : (MATRIX Offset: 0x0088) Priority Register A for Slave 1 --------
#define AT91C_MATRIX_PRAS1_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS1_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS1_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS1_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS1_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS1_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS1_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS1_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS1 : (MATRIX Offset: 0x008C) Priority Register B for Slave 1 --------
#define AT91C_MATRIX_PRBS1_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS1_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS1_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS1_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS1_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS1_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS1_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS1_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS2 : (MATRIX Offset: 0x0090) Priority Register A for Slave 2 --------
#define AT91C_MATRIX_PRAS2_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS2_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS2_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS2_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS2_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS2_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS2_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS2_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS2 : (MATRIX Offset: 0x0094) Priority Register B for Slave 2 --------
#define AT91C_MATRIX_PRBS2_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS2_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS2_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS2_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS2_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS2_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS2_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS2_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS3 : (MATRIX Offset: 0x0098) Priority Register A for Slave 3 --------
#define AT91C_MATRIX_PRAS3_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS3_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS3_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS3_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS3_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS3_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS3_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS3_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS3 : (MATRIX Offset: 0x009C) Priority Register B for Slave 3 --------
#define AT91C_MATRIX_PRBS3_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS3_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS3_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS3_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS3_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS3_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS3_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS3_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS4 : (MATRIX Offset: 0x00A0) Priority Register A for Slave 4 --------
#define AT91C_MATRIX_PRAS4_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS4_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS4_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS4_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS4_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS4_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS4_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS4_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS4 : (MATRIX Offset: 0x00A4) Priority Register B for Slave 4 --------
#define AT91C_MATRIX_PRBS4_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS4_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS4_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS4_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS4_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS4_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS4_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS4_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS5 : (MATRIX Offset: 0x00A8) Priority Register A for Slave 5 --------
#define AT91C_MATRIX_PRAS5_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS5_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS5_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS5_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS5_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS5_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS5_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS5_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS5 : (MATRIX Offset: 0x00AC) Priority Register B for Slave 5 --------
#define AT91C_MATRIX_PRBS5_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS5_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS5_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS5_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS5_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS5_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS5_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS5_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS6 : (MATRIX Offset: 0x00B0) Priority Register A for Slave 6 --------
#define AT91C_MATRIX_PRAS6_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS6_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS6_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS6_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS6_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS6_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS6_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS6_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS6 : (MATRIX Offset: 0x00B4) Priority Register B for Slave 6 --------
#define AT91C_MATRIX_PRBS6_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS6_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS6_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS6_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS6_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS6_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS6_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS6_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS7 : (MATRIX Offset: 0x00B8) Priority Register A for Slave 7 --------
#define AT91C_MATRIX_PRAS7_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS7_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS7_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS7_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS7_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS7_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS7_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS7_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS7 : (MATRIX Offset: 0x00BC) Priority Register B for Slave 7 --------
#define AT91C_MATRIX_PRBS7_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS7_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS7_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS7_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS7_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS7_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS7_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS7_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS8 : (MATRIX Offset: 0x00C0) Priority Register A for Slave 8 --------
#define AT91C_MATRIX_PRAS8_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS8_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS8_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS8_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS8_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS8_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS8_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS8_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS8 : (MATRIX Offset: 0x00C4) Priority Register B for Slave 8 --------
#define AT91C_MATRIX_PRBS8_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS8_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS8_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS8_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS8_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS8_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS8_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS8_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS9 : (MATRIX Offset: 0x00C8) Priority Register A for Slave 9 --------
#define AT91C_MATRIX_PRAS9_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS9_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS9_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS9_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS9_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS9_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS9_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS9_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS9 : (MATRIX Offset: 0x00CC) Priority Register B for Slave 9 --------
#define AT91C_MATRIX_PRBS9_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS9_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS9_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS9_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS9_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS9_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS9_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS9_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS10 : (MATRIX Offset: 0x00D0) Priority Register A for Slave 10 --------
#define AT91C_MATRIX_PRAS10_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS10_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS10_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS10_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS10_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS10_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS10_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS10_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS10 : (MATRIX Offset: 0x00D4) Priority Register B for Slave 10 --------
#define AT91C_MATRIX_PRBS10_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS10_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS10_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS10_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS10_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS10_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS10_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS10_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS11 : (MATRIX Offset: 0x00D8) Priority Register A for Slave 11 --------
#define AT91C_MATRIX_PRAS11_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS11_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS11_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS11_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS11_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS11_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS11_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS11_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS11 : (MATRIX Offset: 0x00DC) Priority Register B for Slave 11 --------
#define AT91C_MATRIX_PRBS11_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS11_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS11_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS11_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS11_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS11_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS11_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS11_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS12 : (MATRIX Offset: 0x00E0) Priority Register A for Slave 12 --------
#define AT91C_MATRIX_PRAS12_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS12_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS12_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS12_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS12_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS12_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS12_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS12_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS12 : (MATRIX Offset: 0x00E4) Priority Register B for Slave 12 --------
#define AT91C_MATRIX_PRBS12_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS12_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS12_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS12_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS12_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS12_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS12_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS12_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS13 : (MATRIX Offset: 0x00E8) Priority Register A for Slave 13 --------
#define AT91C_MATRIX_PRAS13_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS13_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS13_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS13_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS13_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS13_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS13_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS13_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS13 : (MATRIX Offset: 0x00EC) Priority Register B for Slave 13 --------
#define AT91C_MATRIX_PRBS13_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS13_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS13_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS13_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS13_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS13_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS13_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS13_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS14 : (MATRIX Offset: 0x00F0) Priority Register A for Slave 14 --------
#define AT91C_MATRIX_PRAS14_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS14_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS14_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS14_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS14_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS14_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS14_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS14_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS14 : (MATRIX Offset: 0x00F4) Priority Register B for Slave 14 --------
#define AT91C_MATRIX_PRBS14_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS14_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS14_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS14_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS14_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS14_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS14_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS14_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_PRAS15 : (MATRIX Offset: 0x00F8) Priority Register A for Slave 15 --------
#define AT91C_MATRIX_PRAS15_M0PR (0x3 << 0) // (MATRIX) Master 0 Priority
#define AT91C_MATRIX_PRAS15_M1PR (0x3 << 4) // (MATRIX) Master 1 Priority
#define AT91C_MATRIX_PRAS15_M2PR (0x3 << 8) // (MATRIX) Master 2 Priority
#define AT91C_MATRIX_PRAS15_M3PR (0x3 << 12) // (MATRIX) Master 3 Priority
#define AT91C_MATRIX_PRAS15_M4PR (0x3 << 16) // (MATRIX) Master 4 Priority
#define AT91C_MATRIX_PRAS15_M5PR (0x3 << 20) // (MATRIX) Master 5 Priority
#define AT91C_MATRIX_PRAS15_M6PR (0x3 << 24) // (MATRIX) Master 6 Priority
#define AT91C_MATRIX_PRAS15_M7PR (0x3 << 28) // (MATRIX) Master 7 Priority
// -------- MATRIX_PRBS15 : (MATRIX Offset: 0x00FC) Priority Register B for Slave 15 --------
#define AT91C_MATRIX_PRBS15_M8PR (0x3 << 0) // (MATRIX) Master 8 Priority
#define AT91C_MATRIX_PRBS15_M9PR (0x3 << 4) // (MATRIX) Master 9 Priority
#define AT91C_MATRIX_PRBS15_M10PR (0x3 << 8) // (MATRIX) Master 10 Priority
#define AT91C_MATRIX_PRBS15_M11PR (0x3 << 12) // (MATRIX) Master 11 Priority
#define AT91C_MATRIX_PRBS15_M12PR (0x3 << 16) // (MATRIX) Master 12 Priority
#define AT91C_MATRIX_PRBS15_M13PR (0x3 << 20) // (MATRIX) Master 13 Priority
#define AT91C_MATRIX_PRBS15_M14PR (0x3 << 24) // (MATRIX) Master 14 Priority
#define AT91C_MATRIX_PRBS15_M15PR (0x3 << 28) // (MATRIX) Master 15 Priority
// -------- MATRIX_MRCR : (MATRIX Offset: 0x0100) Master Remap Control Register --------
#define AT91C_MATRIX_MRCR_RCB0 (0x1 << 0) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB1 (0x1 << 1) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB2 (0x1 << 2) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB3 (0x1 << 3) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB4 (0x1 << 4) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB5 (0x1 << 5) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB6 (0x1 << 6) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB7 (0x1 << 7) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB8 (0x1 << 8) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB9 (0x1 << 9) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB10 (0x1 << 10) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB11 (0x1 << 11) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB12 (0x1 << 12) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB13 (0x1 << 13) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB14 (0x1 << 14) // (MATRIX)
#define AT91C_MATRIX_MRCR_RCB15 (0x1 << 15) // (MATRIX)
// -------- CCFG_EBICSA : (MATRIX Offset: 0x0110) EBI Chip Select Assignment Register --------
#define AT91C_CCFG_EBI_CS1A (0x1 << 1) // (MATRIX) EBI Chip Select 1 Assignment
#define   AT91C_CCFG_EBI_CS1A_SMC (0x0 << 1) // (MATRIX) EBI Chip Select 1 is assigned to Static Memory Controller.
#define   AT91C_CCFG_EBI_CS1A_SDRAMC (0x1 << 1) // (MATRIX) EBI Chip Select 1 is assigned to SDRAM Controller.
#define AT91C_CCFG_EBI_CS3A (0x1 << 3) // (MATRIX) EBI Chip Select 3 Assignment
#define   AT91C_CCFG_EBI_CS3A_SMC (0x0 << 3) // (MATRIX) EBI Chip Select 3 is only assigned to Static Memory Controller and EBI_NCS3 behaves as defined by SMC.
#define   AT91C_CCFG_EBI_CS3A_NF (0x1 << 3) // (MATRIX) EBI Chip Select 3 is assigned to Static Memory Controller and the NAND Flash Logic is activated.
#define AT91C_CCFG_EBI_CS4A (0x1 << 4) // (MATRIX) EBI Chip Select 4 Assignment
#define   AT91C_CCFG_EBI_CS4A_SMC (0x0 << 4) // (MATRIX) EBI Chip Select 4 is only assigned to Static Memory Controller and EBI_NCS4 behaves as defined by SMC.
#define   AT91C_CCFG_EBI_CS4A_CF (0x1 << 4) // (MATRIX) EBI Chip Select 4 is assigned to Static Memory Controller and CompactFlash Logic (1st slot) is activated.
#define AT91C_CCFG_EBI_CS5A (0x1 << 5) // (MATRIX) EBI Chip Select 5 Assignment
#define   AT91C_CCFG_EBI_CS5A_SMC (0x0 << 5) // (MATRIX) EBI Chip Select 5 is only assigned to Static Memory Controller and EBI_NCS5 behaves as defined by SMC.
#define   AT91C_CCFG_EBI_CS5A_NF (0x1 << 5) // (MATRIX) EBI Chip Select 5 is assigned to Static Memory Controller and CompactFlash Logic (2nd slot) is activated.
#define AT91C_CCFG_EBI_DBPUC (0x1 << 8) // (MATRIX) EBI Data Bus Pull-Up Configuration
#define   AT91C_CCFG_EBI_DBPUC_SMC (0x0 << 8) // (MATRIX) EBI D0 - D15 Data Bus bits are internally pulled-up to the VDDIOM0 power supply.
#define   AT91C_CCFG_EBI_DBPUC_CF (0x1 << 8) // (MATRIX) EBI D0 - D15 Data Bus bits are not internally pulled-up.
#define AT91C_CCFG_VDDIOMSEL (0x1 << 16) // (MATRIX) Memory voltage selection
// -------- MATRIX_SFR[16] : (MATRIX Offset: 0x0110) Special Function Register --------
#define AT91C_MATRIX_SFR_SFR (0xffffffff << 0) // (MATRIX) Special Function Register Fields
// -------- MATRIX_WPMR : (MATRIX Offset: 0x01E4) Write Protect Mode Register --------
// -------- MATRIX_WPSR : (MATRIX Offset: 0x01E8) Write Protect Status Register --------

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR MultiMedia Card Interface
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_MCI {
  AT91_REG MCI_CR;          // Control Register
  AT91_REG MCI_MR;          // Mode Register
  AT91_REG MCI_DTOR;        // Data Timeout Register
  AT91_REG MCI_SDCR;        // SD/SDIO Card Register
  AT91_REG MCI_ARGR;        // Argument Register
  AT91_REG MCI_CMDR;        // Command Register
  AT91_REG MCI_BLKR;        // Block Register
  AT91_REG MCI_CSTOR;       // Completion Signal Timeout Register
  AT91_REG MCI_RSPR[4];     // Response Register
  AT91_REG MCI_RDR;         // Receive Data Register
  AT91_REG MCI_TDR;         // Transmit Data Register
  AT91_REG Reserved1[2];
  AT91_REG MCI_SR;          // Status Register
  AT91_REG MCI_IER;         // Interrupt Enable Register
  AT91_REG MCI_IDR;         // Interrupt Disable Register
  AT91_REG MCI_IMR;         // Interrupt Mask Register
  AT91_REG MCI_DMA;         // DMA Configuration Register
  AT91_REG MCI_CFG;         // Configuration Register
  AT91_REG Reserved2[35];
  AT91_REG MCI_WPMR;        // Write Protection Mode Register
  AT91_REG MCI_WPSR;        // Write Protection Status Register
  AT91_REG Reserved3[69];
  AT91_REG MCI_FIFO;        // FIFO Memory Aperture
} AT91S_MCI, *AT91PS_MCI;
#else
#define MCI_CR    (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define MCI_MR    (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define MCI_DTOR  (AT91_CAST(AT91_REG *) 0x00000008) // Data Timeout Register
#define MCI_SDCR  (AT91_CAST(AT91_REG *) 0x0000000C) // SD/SDIO Card Register
#define MCI_ARGR  (AT91_CAST(AT91_REG *) 0x00000010) // Argument Register
#define MCI_CMDR  (AT91_CAST(AT91_REG *) 0x00000014) // Command Register
#define MCI_BLKR  (AT91_CAST(AT91_REG *) 0x00000018) // Block Register
#define MCI_CSTOR (AT91_CAST(AT91_REG *) 0x0000001C) // Completion Signal Timeout Register
#define MCI_RSPR  (AT91_CAST(AT91_REG *) 0x00000020) // Response Register
#define MCI_RDR   (AT91_CAST(AT91_REG *) 0x00000030) // Receive Data Register
#define MCI_TDR   (AT91_CAST(AT91_REG *) 0x00000034) // Transmit Data Register
#define MCI_SR    (AT91_CAST(AT91_REG *) 0x00000040) // Status Register
#define MCI_IER   (AT91_CAST(AT91_REG *) 0x00000044) // Interrupt Enable Register
#define MCI_IDR   (AT91_CAST(AT91_REG *) 0x00000048) // Interrupt Disable Register
#define MCI_IMR   (AT91_CAST(AT91_REG *) 0x0000004C) // Interrupt Mask Register
#define MCI_DMA   (AT91_CAST(AT91_REG *) 0x00000050) // DMA Configuration Register
#define MCI_CFG   (AT91_CAST(AT91_REG *) 0x00000054) // Configuration Register
#define MCI_WPMR  (AT91_CAST(AT91_REG *) 0x000000E4) // Write Protection Mode Register
#define MCI_WPSR  (AT91_CAST(AT91_REG *) 0x000000E8) // Write Protection Status Register
#define MCI_FIFO  (AT91_CAST(AT91_REG *) 0x00000200) // FIFO Memory Aperture
#endif
// -------- MCI_CR : (MCI Offset: 0x00) Control Register --------
#define AT91C_MCI_CR_MCIEN (0x1 << 0) // (MCI) Multi-Media Interface Enable
#define AT91C_MCI_CR_MCIDIS (0x1 << 1) // (MCI) Multi-Media Interface Disable
#define AT91C_MCI_CR_PWSEN (0x1 << 2) // (MCI) Power Save Mode Enable
#define AT91C_MCI_CR_PWSDIS (0x1 << 3) // (MCI) Power Save Mode Disable
#define AT91C_MCI_CR_SWRST (0x1 << 7) // (MCI) Software Reset
// -------- MCI_MR : (MCI Offset: 0x04) Mode Register --------
#define AT91C_MCI_MR_CLKDIV      (0xFF <<  0) // (MCI) Clock Divider
#define AT91C_MCI_MR_PWSDIV      (0x7 <<  8) // (MCI) Power Saving Divider
#define AT91C_MCI_MR_RDPROOF     (0x1 << 11) // (MCI) Read Proof Enable
#define     AT91C_MCI_MR_RDPROOF_DISABLE              (0x0 << 11) // (MCI) Disables Read Proof
#define     AT91C_MCI_MR_RDPROOF_ENABLE               (0x1 << 11) // (MCI) Enables Read Proof
#define AT91C_MCI_MR_WRPROOF     (0x1 << 12) // (MCI) Write Proof Enable
#define     AT91C_MCI_MR_WRPROOF_DISABLE              (0x0 << 12) // (MCI) Disables Write Proof
#define     AT91C_MCI_MR_WRPROOF_ENABLE               (0x1 << 12) // (MCI) Enables Write Proof
#define AT91C_MCI_MR_PDCFBYTE    (0x1 << 13) // (MCI) PDC Force Byte Transfer
#define AT91C_MCI_MR_PDCPADV     (0x1 << 14) // (MCI) PDC Padding Value
#define AT91C_MCI_MR_PDCMODE     (0x1 << 15) // (MCI) PDC Oriented Mode
#define AT91C_MCI_MR_BLKLEN      (0xFFFF << 16) // (MCI) Data Block Length
// -------- MCI_DTOR : (MCI Offset: 0x08) Data Timeout Register --------
#define AT91C_MCI_DTOR_DTOCYC (0xf << 0) // (MCI) Data Timeout Cycle Number
#define AT91C_MCI_DTOR_DTOMUL (0x7 << 4) // (MCI) Data Timeout Multiplier
#define   AT91C_MCI_DTOR_DTOMUL_1 (0x0 << 4) // (MCI) 1
#define   AT91C_MCI_DTOR_DTOMUL_16 (0x1 << 4) // (MCI) 16
#define   AT91C_MCI_DTOR_DTOMUL_128 (0x2 << 4) // (MCI) 128
#define   AT91C_MCI_DTOR_DTOMUL_256 (0x3 << 4) // (MCI) 256
#define   AT91C_MCI_DTOR_DTOMUL_1024 (0x4 << 4) // (MCI) 1024
#define   AT91C_MCI_DTOR_DTOMUL_4096 (0x5 << 4) // (MCI) 4096
#define   AT91C_MCI_DTOR_DTOMUL_65536 (0x6 << 4) // (MCI) 65536
#define   AT91C_MCI_DTOR_DTOMUL_1048576 (0x7 << 4) // (MCI) 1048576
// -------- MCI_SDCR : (MCI Offset: 0x0C) SD/SDIO Card Register --------
#define AT91C_MCI_SDCR_SDCSEL (0x3 << 0) // (MCI) SDCard/SDIO Slot
#define AT91C_MCI_SDCR_SDCBUS (0x3 << 6) // (MCI) SDCard/SDIO Bus Width
#define 	AT91C_MCI_SDCR_SCDBUS_1BIT (0x0 <<  6) // (MCI) 1-bit data bus
#define 	AT91C_MCI_SDCR_SCDBUS_4BITS (0x2 <<  6) // (MCI) 4-bits data bus
#define 	AT91C_MCI_SDCR_SCDBUS_8BITS (0x3 <<  6) // (MCI) 8-bits data bus
// -------- MCI_ARGR : (MCI Offset: 0x10) Argument Register --------
#define AT91C_MCI_ARGR_ARG (0xffffffff << 0) // (MCI) Command Argument
// -------- MCI_CMDR : (MCI Offset: 0x14) Command Register --------
#define AT91C_MCI_CMDR_CMDNB (0x3f << 0) // (MCI) Command Number
#define AT91C_MCI_CMDR_RSPTYP (0x3 << 6) // (MCI) Response Type
#define   AT91C_MCI_CMDR_RSPTYP_NO (0x0 << 6) // (MCI) No response.
#define   AT91C_MCI_CMDR_RSPTYP_48 (0x1 << 6) // (MCI) 48-bit response.
#define   AT91C_MCI_CMDR_RSPTYP_136 (0x2 << 6) // (MCI) 136-bit response.
#define   AT91C_MCI_CMDR_RSPTYP_R1B (0x3 <<  6) // (MCI) R1b response
#define AT91C_MCI_CMDR_SPCMD (0x7 << 8) // (MCI) Special Command
#define   AT91C_MCI_CMDR_SPCMD_NONE (0x0 << 8) // (MCI) Not a special CMD.
#define   AT91C_MCI_CMDR_SPCMD_INIT (0x1 << 8) // (MCI) Initialization CMD:74 clock cycles for initialization sequence.
#define   AT91C_MCI_CMDR_SPCMD_SYNC (0x2 << 8) // (MCI) Synchronized CMD:Wait for the end of the current data block transfer before sending the pending command.
#define   AT91C_MCI_CMDR_SPCMD_IT_CMD (0x4 << 8) // (MCI) Interrupt command:Corresponds to the Interrupt Mode (CMD40).
#define   AT91C_MCI_CMDR_SPCMD_IT_REP (0x5 << 8) // (MCI) Interrupt response:Corresponds to the Interrupt Mode (CMD40).
#define AT91C_MCI_CMDR_OPDCMD (0x1 << 11) // (MCI) Open Drain Command
#define AT91C_MCI_CMDR_MAXLAT (0x1 << 12) // (MCI) Max Latency for Command to Response
#define AT91C_MCI_CMDR_TRCMD (0x3 << 16) // (MCI) Transfer Command
#define   AT91C_MCI_CMDR_TRCMD_NO (0x0 << 16) // (MCI) No data transfer
#define   AT91C_MCI_CMDR_TRCMD_START (0x1 << 16) // (MCI) Start data transfer
#define   AT91C_MCI_CMDR_TRCMD_STOP (0x2 << 16) // (MCI) Stop data transfer
#define AT91C_MCI_CMDR_TRDIR (0x1 << 18) // (MCI) Transfer Direction
#define     AT91C_MCI_CMDR_TRDIR_WRITE (0x0 << 18) // (MCI) Write
#define     AT91C_MC_CMDRI_TRDIR_READ (0x1 << 18) // (MCI) Read
#define AT91C_MCI_CMDR_TRTYP (0x7 << 19) // (MCI) Transfer Type
#define   AT91C_MCI_CMDR_TRTYP_BLOCK (0x0 << 19) // (MCI) MMC/SDCard Single Block
#define   AT91C_MCI_CMDR_TRTYP_MULTIPLE (0x1 << 19) // (MCI) MMC/SDCard Multiple Block
#define   AT91C_MCI_CMDR_TRTYP_STREAM (0x2 << 19) // (MCI) MMC Stream
#define   AT91C_MCI_CMDR_TRTYP_SDIO_BYTE (0x4 << 19) // (MCI) SDIO Byte
#define   AT91C_MCI_CMDR_TRTYP_SDIO_BLOCK (0x5 << 19) // (MCI) SDIO Block
#define AT91C_MCI_CMDR_IOSPCMD (0x3 << 24) // (MCI) SDIO Special Command
#define   AT91C_MCI_CMDR_IOSPCMD_NONE (0x0 << 24) // (MCI) Not a SDIO Special Command
#define   AT91C_MCI_CMDR_IOSPCMD_SUSPEND (0x1 << 24) // (MCI) SDIO Suspend Command
#define   AT91C_MCI_CMDR_IOSPCMD_RESUME (0x2 << 24) // (MCI) SDIO Resume Command
#define AT91C_MCI_CMDR_ATACS (0x1 << 26) // (MCI) ATA with Command Completion Signal
// -------- MCI_BLKR : (MCI Offset: 0x18) Block Register --------
#define AT91C_MCI_BLKR_BCNT (0xffff << 0) // (MCI) MMC/SDIO Block Count - SDIO Byte Count
#define AT91C_MCI_BLKR_BLKLEN (0xffff << 16) // (MCI) Data Block Length
// -------- MCI_CSTOR : (MCI Offset: 0x1C) Completion Signal Timeout Register --------
#define AT91C_MCI_CSTOR_CSTOCYC (0xf << 0) // (MCI) Completion Signal Timeout Cycle Number
#define AT91C_MCI_CSTOR_CSTOMUL (0x7 << 4) // (MCI) Completion Signal Timeout Multiplier
// -------- MCI_RSPR[4] : (MCI Offset: 0x20) Response Register --------
#define AT91C_MCI_RSPR_RSP (0xffffffff << 0) // (MCI) Response
// -------- MCI_RDR : (MCI Offset: 0x30) Receive Data Register --------
#define AT91C_MCI_RDR_DATA (0xffffffff << 0) // (MCI) Data to Read
// -------- MCI_TDR : (MCI Offset: 0x34) Transmit Data Register --------
#define AT91C_MCI_TDR_DATA (0xffffffff << 0) // (MCI) Data to Write
// -------- MCI_SR : (MCI Offset: 0x40) Status Register --------
#define AT91C_MCI_SR_CMDRDY (0x1 << 0) // (MCI) Command Ready
#define AT91C_MCI_SR_RXRDY (0x1 << 1) // (MCI) Receiver Ready
#define AT91C_MCI_SR_TXRDY (0x1 << 2) // (MCI) Transmit Ready
#define AT91C_MCI_SR_BLKE (0x1 << 3) // (MCI) Data Block Ended
#define AT91C_MCI_SR_DTIP (0x1 << 4) // (MCI) Data Transfer in Progress
#define AT91C_MCI_SR_NOTBUSY (0x1 << 5) // (MCI) MCI Not Busy
#define AT91C_MCI_SR_ENDRX (0x1 <<  6) // (MCI) End of RX Buffer flag
#define AT91C_MCI_SR_ENDTX (0x1 <<  7) // (MCI) End of TX Buffer flag
#define AT91C_MCI_SR_SDIOIRQA (0x1 << 8) // (MCI)
#define AT91C_MCI_SR_SDIOIRQB    (0x1 <<  9) // (MCI) SDIO Interrupt for Slot B
#define AT91C_MCI_SR_SDIOIRQC    (0x1 << 10) // (MCI) SDIO Interrupt for Slot C
#define AT91C_MCI_SR_SDIOIRQD    (0x1 << 11) // (MCI) SDIO Interrupt for Slot D
#define AT91C_MCI_SR_SDIOWAIT    (0x1 << 12) // (MCI) SDIO Read Wait operation flag
#define AT91C_MCI_SR_CSRCV (0x1 << 13) // (MCI) CE-ATA Completion Signal Received
#define AT91C_MCI_SR_RXBUFF (0x1 << 14) // (MCI) RX Buffer Full flag
#define AT91C_MCI_SR_TXBUFE (0x1 << 15) // (MCI) TX Buffer Empty flag
#define AT91C_MCI_SR_RINDE (0x1 << 16) // (MCI) Response Index Error
#define AT91C_MCI_SR_RDIRE (0x1 << 17) // (MCI) Response Direction Error
#define AT91C_MCI_SR_RCRCE (0x1 << 18) // (MCI) Response CRC Error
#define AT91C_MCI_SR_RENDE (0x1 << 19) // (MCI) Response End Bit Error
#define AT91C_MCI_SR_RTOE (0x1 << 20) // (MCI) Response Time-out Error
#define AT91C_MCI_SR_DCRCE (0x1 << 21) // (MCI) Data CRC Error
#define AT91C_MCI_SR_DTOE (0x1 << 22) // (MCI) Data Time-out Error
#define AT91C_MCI_SR_CSTOE (0x1 << 23) // (MCI) Completion Signal Time-out Error
#define AT91C_MCI_SR_BLKOVRE (0x1 << 24) // (MCI) DMA Block Overrun Error
#define AT91C_MCI_SR_DMADONE (0x1 << 25) // (MCI) DMA Transfer done
#define AT91C_MCI_SR_FIFOEMPTY (0x1 << 26) // (MCI) FIFO empty flag
#define AT91C_MCI_SR_XFRDONE (0x1 << 27) // (MCI) Transfer Done flag
#define AT91C_MCI_SR_OVRE (0x1 << 30) // (MCI) Overrun
#define AT91C_MCI_SR_UNRE (0x1 << 31) // (MCI) Underrun
// -------- MCI_IER : (MCI Offset: 0x44) Interrupt Enable Register --------
#define AT91C_MCI_IER_CMDRDY (0x1 << 0) // (MCI) Command Ready Interrupt Enable
#define AT91C_MCI_IER_RXRDY (0x1 << 1) // (MCI) Receiver Ready Interrupt Enable
#define AT91C_MCI_IER_TXRDY (0x1 << 2) // (MCI) Transmit Ready Interrupt Enable
#define AT91C_MCI_IER_BLKE (0x1 << 3) // (MCI) Data Block Ended Interrupt Enable
#define AT91C_MCI_IER_DTIP (0x1 << 4) // (MCI) Data Transfer in Progress Interrupt Enable
#define AT91C_MCI_IER_NOTBUSY (0x1 << 5) // (MCI) Data Not Busy Interrupt Enable
#define AT91C_MCI_IER_MCI_SDIOIRQA (0x1 << 8) // (MCI)
#define AT91C_MCI_IER_CSRCV (0x1 << 13) // (MCI) Completion Signal Received Interrupt Enable
#define AT91C_MCI_IER_RINDE (0x1 << 16) // (MCI) Response Index Error Interrupt Enable
#define AT91C_MCI_IER_RDIRE (0x1 << 17) // (MCI) Response Direction Error Interrupt Enable
#define AT91C_MCI_IER_RCRCE (0x1 << 18) // (MCI) Response CRC Error Interrupt Enable
#define AT91C_MCI_IER_RENDE (0x1 << 19) // (MCI) Response End Bit Error Interrupt Enable
#define AT91C_MCI_IER_RTOE (0x1 << 20) // (MCI) Response Time-out Error Interrupt Enable
#define AT91C_MCI_IER_DCRCE (0x1 << 21) // (MCI) Data CRC Error Interrupt Enable
#define AT91C_MCI_IER_DTOE (0x1 << 22) // (MCI) Data Time-out Error Interrupt Enable
#define AT91C_MCI_IER_CSTOE (0x1 << 23) // (MCI) Completion Signal Timeout Error Interrupt Enable
#define AT91C_MCI_IER_BLKOVRE (0x1 << 24) // (MCI) DMA Block Overrun Error Interrupt Enable
#define AT91C_MCI_IER_DMADONE (0x1 << 25) // (MCI) DMA Transfer completed Interrupt Enable
#define AT91C_MCI_IER_FIFOEMPTY (0x1 << 26) // (MCI) FIFO empty Interrupt enable
#define AT91C_MCI_IER_XFRDONE (0x1 << 27) // (MCI) Transfer Done Interrupt enable
#define AT91C_MCI_IER_OVRE (0x1 << 30) // (MCI) Overrun Interrupt Enable
#define AT91C_MCI_IER_UNRE (0x1 << 31) // (MCI) UnderRun Interrupt Enable
// -------- MCI_IDR : (MCI Offset: 0x48) Interrupt Disable Register --------
#define AT91C_MCI_IDR_CMDRDY (0x1 << 0) // (MCI) Command Ready Interrupt Disable
#define AT91C_MCI_IDR_RXRDY (0x1 << 1) // (MCI) Receiver Ready Interrupt Disable
#define AT91C_MCI_IDR_TXRDY (0x1 << 2) // (MCI) Transmit Ready Interrupt Disable
#define AT91C_MCI_IDR_BLKE (0x1 << 3) // (MCI) Data Block Ended Interrupt Disable
#define AT91C_MCI_IDR_DTIP (0x1 << 4) // (MCI) Data Transfer in Progress Interrupt Disable
#define AT91C_MCI_IDR_NOTBUSY (0x1 << 5) // (MCI) Data Not Busy Interrupt Disable
#define AT91C_MCI_IDR_MCI_SDIOIRQA (0x1 << 8) // (MCI)
#define AT91C_MCI_IDR_CSRCV (0x1 << 13) // (MCI) Completion Signal received interrupt disable
#define AT91C_MCI_IDR_RINDE (0x1 << 16) // (MCI) Response Index Error Interrupt Disable
#define AT91C_MCI_IDR_RDIRE (0x1 << 17) // (MCI) Response Direction Error Interrupt Disable
#define AT91C_MCI_IDR_RCRCE (0x1 << 18) // (MCI) Response CRC Error Interrupt Disable
#define AT91C_MCI_IDR_RENDE (0x1 << 19) // (MCI) Response End Bit Error Interrupt Disable
#define AT91C_MCI_IDR_RTOE (0x1 << 20) // (MCI) Response Time-out Error Interrupt Disable
#define AT91C_MCI_IDR_DCRCE (0x1 << 21) // (MCI) Data CRC Error Interrupt Disable
#define AT91C_MCI_IDR_DTOE (0x1 << 22) // (MCI) Data Time-out Error Interrupt Disable
#define AT91C_MCI_IDR_CSTOE (0x1 << 23) // (MCI) Completion Signal Time out Error Interrupt Disable
#define AT91C_MCI_IDR_BLKOVRE (0x1 << 24) // (MCI) DMA Block Overrun Error Interrupt Disable
#define AT91C_MCI_IDR_DMADONE (0x1 << 25) // (MCI) DMA Transfer completed Interrupt Disable
#define AT91C_MCI_IDR_FIFOEMPTY (0x1 << 26) // (MCI) FIFO empty Interrupt Disable
#define AT91C_MCI_IDR_XFRDONE (0x1 << 27) // (MCI) Transfer Done Interrupt Disable
#define AT91C_MCI_IDR_OVRE (0x1 << 30) // (MCI) Overrun Interrupt Disable
#define AT91C_MCI_IDR_UNRE (0x1 << 31) // (MCI) UnderRun Interrupt Disable
// -------- MCI_IMR : (MCI Offset: 0x4C) Interrupt Mask Register --------
#define AT91C_MCI_IMR_CMDRDY (0x1 << 0) // (MCI) Command Ready Interrupt Mask
#define AT91C_MCI_IMR_RXRDY (0x1 << 1) // (MCI) Receiver Ready Interrupt Mask
#define AT91C_MCI_IMR_TXRDY (0x1 << 2) // (MCI) Transmit Ready Interrupt Mask
#define AT91C_MCI_IMR_BLKE (0x1 << 3) // (MCI) Data Block Ended Interrupt Mask
#define AT91C_MCI_IMR_DTIP (0x1 << 4) // (MCI) Data Transfer in Progress Interrupt Mask
#define AT91C_MCI_IMR_NOTBUSY (0x1 << 5) // (MCI) Data Not Busy Interrupt Mask
#define AT91C_MCI_IMR_MCI_SDIOIRQA (0x1 << 8) // (MCI)
#define AT91C_MCI_IMR_CSRCV (0x1 << 13) // (MCI) Completion Signal Received Interrupt Mask
#define AT91C_MCI_IMR_RINDE (0x1 << 16) // (MCI) Response Index Error Interrupt Mask
#define AT91C_MCI_IMR_RDIRE (0x1 << 17) // (MCI) Response Direction Error Interrupt Mask
#define AT91C_MCI_IMR_RCRCE (0x1 << 18) // (MCI) Response CRC Error Interrupt Mask
#define AT91C_MCI_IMR_RENDE (0x1 << 19) // (MCI) Response End Bit Error Interrupt Mask
#define AT91C_MCI_IMR_RTOE (0x1 << 20) // (MCI) Response Time-out Error Interrupt Mask
#define AT91C_MCI_IMR_DCRCE (0x1 << 21) // (MCI) Data CRC Error Interrupt Mask
#define AT91C_MCI_IMR_DTOE (0x1 << 22) // (MCI) Data Time-out Error Interrupt Mask
#define AT91C_MCI_IMR_CSTOE (0x1 << 23) // (MCI) Completion Signal Time-out Error Interrupt Mask
#define AT91C_MCI_IMR_BLKOVRE (0x1 << 24) // (MCI) DMA Block Overrun Error Interrupt Mask
#define AT91C_MCI_IMR_DMADONE (0x1 << 25) // (MCI) DMA Transfer Completed Interrupt Mask
#define AT91C_MCI_IMR_FIFOEMPTY (0x1 << 26) // (MCI) FIFO Empty Interrupt Mask
#define AT91C_MCI_IMR_XFRDONE (0x1 << 27) // (MCI) Transfer Done Interrupt Mask
#define AT91C_MCI_IMR_OVRE (0x1 << 30) // (MCI) Overrun Interrupt Mask
#define AT91C_MCI_IMR_UNRE (0x1 << 31) // (MCI) UnderRun Interrupt Mask
// -------- MCI_DMA : (MCI Offset: 0x50) DMA Configuration Register --------
#define AT91C_MCI_DMA_OFFSET      (0x3 <<  0) // (MCI) DMA Write Buffer Offset
#define AT91C_MCI_DMA_CHKSIZE     (0x7 <<  4) // (MCI) DMA Channel Read/Write Chunk Size
#define     AT91C_MCI_DMA_CHKSIZE_1                    (0x0 <<  4) // (MCI) Number of data transferred is 1
#define     AT91C_MCI_DMA_CHKSIZE_4                    (0x1 <<  4) // (MCI) Number of data transferred is 4
#define     AT91C_MCI_DMA_CHKSIZE_8                    (0x2 <<  4) // (MCI) Number of data transferred is 8
#define     AT91C_MCI_DMA_CHKSIZE_16                   (0x3 <<  4) // (MCI) Number of data transferred is 16
#define     AT91C_MCI_DMA_CHKSIZE_32                   (0x4 <<  4) // (MCI) Number of data transferred is 32
#define AT91C_MCI_DMA_DMAEN       (0x1 <<  8) // (MCI) DMA Hardware Handshaking Enable
#define     AT91C_MCI_DMA_DMAEN_DISABLE              (0x0 <<  8) // (MCI) DMA interface is disabled
#define     AT91C_MCI_DMA_DMAEN_ENABLE               (0x1 <<  8) // (MCI) DMA interface is enabled
// -------- MCI_CFG : (MCI Offset: 0x54) Configuration Register --------
#define AT91C_MCI_CFG_FIFOMODE    (0x1 <<  0) // (MCI) MCI Internal FIFO Control Mode
#define     AT91C_MCI_CFG_FIFOMODE_AMOUNTDATA           (0x0) // (MCI) A write transfer starts when a sufficient amount of datas is written into the FIFO
#define     AT91C_MCI_CFG_FIFOMODE_ONEDATA              (0x1) // (MCI) A write transfer starts as soon as one data is written into the FIFO
#define AT91C_MCI_CFG_FERRCTRL    (0x1 <<  4) // (MCI) Flow Error Flag Reset Control Mode
#define     AT91C_MCI_CFG_FERRCTRL_RWCMD                (0x0 <<  4) // (MCI) When an underflow/overflow condition flag is set, a new Write/Read command is needed to reset the flag
#define     AT91C_MCI_CFG_FERRCTRL_READSR               (0x1 <<  4) // (MCI) When an underflow/overflow condition flag is set, a read status resets the flag
#define AT91C_MCI_CFG_HSMODE      (0x1 <<  8) // (MCI) High Speed Mode
#define     AT91C_MCI_CFG_HSMODE_DISABLE              (0x0 <<  8) // (MCI) Default Bus Timing Mode
#define     AT91C_MCI_CFG_HSMODE_ENABLE               (0x1 <<  8) // (MCI) High Speed Mode
#define AT91C_MCI_CFG_LSYNC       (0x1 << 12) // (MCI) Synchronize on last block
#define     AT91C_MCI_CFG_LSYNC_CURRENT              (0x0 << 12) // (MCI) Pending command sent at end of current data block
#define     AT91C_MCI_CFG_LSYNC_INFINITE             (0x1 << 12) // (MCI) Pending command sent at end of block transfer when transfer length is not infinite
// -------- MCI_WPMR : (MCI Offset: 0xE4) Write Protection Mode Register --------
#define AT91C_MCI_WPMR_WP_EN (0x1 << 0) // (MCI) Write Protection Enable
#define AT91C_MCI_WPMR_WP_KEY (0xffffff << 8) // (MCI) Write Protection Key password
// -------- MCI_WPSR : (MCI Offset: 0xE8) Write Protection Status Register --------
#define AT91C_MCI_WPSR_WP_VS (0xf << 0) // (MCI)
#define AT91C_MCI_WPSR_WP_VSRC (0xffff << 8) // (MCI) Write Protection Violation Status
// -------- MCI_FIFO[15868] : (MCI Offset: 0x200) FIFO Memory Aperture --------
#define AT91C_MCI_FIFO_DATA (0xffffffff << 0) // (MCI) Data to Read or Data to Write

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Peripheral DMA Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_PDC {
  AT91_REG Reserved1[64];
  AT91_REG PERIPH_RPR;    // Receive Pointer Register
  AT91_REG PERIPH_RCR;    // Receive Counter Register
  AT91_REG PERIPH_TPR;    // Transmit Pointer Register
  AT91_REG PERIPH_TCR;    // Transmit Counter Register
  AT91_REG PERIPH_RNPR;   // Receive Next Pointer Register
  AT91_REG PERIPH_RNCR;   // Receive Next Counter Register
  AT91_REG PERIPH_TNPR;   // Transmit Next Pointer Register
  AT91_REG PERIPH_TNCR;   // Transmit Next Counter Register
  AT91_REG PERIPH_PTCR;   // Transfer Control Register
  AT91_REG PERIPH_PTSR;   // Transfer Status Register
} AT91S_PDC, *AT91PS_PDC;
#else
#define PERIPH_RPR  (AT91_CAST(AT91_REG *) 0x00000100) // Receive Pointer Register
#define PERIPH_RCR  (AT91_CAST(AT91_REG *) 0x00000104) // Receive Counter Register
#define PERIPH_TPR  (AT91_CAST(AT91_REG *) 0x00000108) // Transmit Pointer Register
#define PERIPH_TCR  (AT91_CAST(AT91_REG *) 0x0000010C) // Transmit Counter Register
#define PERIPH_RNPR (AT91_CAST(AT91_REG *) 0x00000110) // Receive Next Pointer Register
#define PERIPH_RNCR (AT91_CAST(AT91_REG *) 0x00000114) // Receive Next Counter Register
#define PERIPH_TNPR (AT91_CAST(AT91_REG *) 0x00000118) // Transmit Next Pointer Register
#define PERIPH_TNCR (AT91_CAST(AT91_REG *) 0x0000011C) // Transmit Next Counter Register
#define PERIPH_PTCR (AT91_CAST(AT91_REG *) 0x00000120) // Transfer Control Register
#define PERIPH_PTSR (AT91_CAST(AT91_REG *) 0x00000124) // Transfer Status Register
#endif
// -------- PERIPH_RPR : (PDC Offset: 0x100) Receive Pointer Register --------
#define AT91C_PERIPH_RPR_RXPTR (0xffffffff << 0) // (PDC) Receive Pointer Register
// -------- PERIPH_RCR : (PDC Offset: 0x104) Receive Counter Register --------
#define AT91C_PERIPH_RCR_RXCTR (0xffff << 0) // (PDC) Receive Counter Register
// -------- PERIPH_TPR : (PDC Offset: 0x108) Transmit Pointer Register --------
#define AT91C_PERIPH_TPR_TXPTR (0xffffffff << 0) // (PDC) Transmit Counter Register
// -------- PERIPH_TCR : (PDC Offset: 0x10C) Transmit Counter Register --------
#define AT91C_PERIPH_TCR_TXCTR (0xffff << 0) // (PDC) Transmit Counter Register
// -------- PERIPH_RNPR : (PDC Offset: 0x110) Receive Next Pointer Register --------
#define AT91C_PERIPH_RNPR_RXNPTR (0xffffffff << 0) // (PDC) Receive Next Pointer
// -------- PERIPH_RNCR : (PDC Offset: 0x114) Receive Next Counter Register --------
#define AT91C_PERIPH_RNCR_RXNCTR (0xffff << 0) // (PDC) Receive Next Counter
// -------- PERIPH_TNPR : (PDC Offset: 0x118) Transmit Next Pointer Register --------
#define AT91C_PERIPH_TNPR_TXNPTR (0xffffffff << 0) // (PDC) Transmit Next Pointer
// -------- PERIPH_TNCR : (PDC Offset: 0x11C) Transmit Next Counter Register --------
#define AT91C_PERIPH_TNCR_TXNCTR (0xffff << 0) // (PDC) Transmit Counter Next
// -------- PERIPH_PTCR : (PDC Offset: 0x120) Transfer Control Register --------
#define AT91C_PERIPH_PTCR_RXTEN (0x1 << 0) // (PDC) Receiver Transfer Enable
#define AT91C_PERIPH_PTCR_RXTDIS (0x1 << 1) // (PDC) Receiver Transfer Disable
#define AT91C_PERIPH_PTCR_TXTEN (0x1 << 8) // (PDC) Transmitter Transfer Enable
#define AT91C_PERIPH_PTCR_TXTDIS (0x1 << 9) // (PDC) Transmitter Transfer Disable
// -------- PERIPH_PTSR : (PDC Offset: 0x124) Transfer Status Register --------
#define AT91C_PERIPH_PTSR_RXTEN (0x1 << 0) // (PDC) Receiver Transfer Enable
#define AT91C_PERIPH_PTSR_TXTEN (0x1 << 8) // (PDC) Transmitter Transfer Enable

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Parallel Input/Output
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_PIO {
  AT91_REG PIO_PER;      // PIO Enable Register
  AT91_REG PIO_PDR;      // PIO Disable Register
  AT91_REG PIO_PSR;      // PIO Status Register
  AT91_REG Reserved1[1];
  AT91_REG PIO_OER;      // Output Enable Register
  AT91_REG PIO_ODR;      // Output Disable Register
  AT91_REG PIO_OSR;      // Output Status Register
  AT91_REG Reserved2[1];
  AT91_REG PIO_IFER;     // Glitch Input Filter Enable Register
  AT91_REG PIO_IFDR;     // Glitch Input Filter Disable Register
  AT91_REG PIO_IFSR;     // Glitch Input Filter Status Register
  AT91_REG Reserved3[1];
  AT91_REG PIO_SODR;     // Set Output Data Register
  AT91_REG PIO_CODR;     // Clear Output Data Register
  AT91_REG PIO_ODSR;     // Output Data Status Register
  AT91_REG PIO_PDSR;     // Pin Data Status Register
  AT91_REG PIO_IER;      // Interrupt Enable Register
  AT91_REG PIO_IDR;      // Interrupt Disable Register
  AT91_REG PIO_IMR;      // Interrupt Mask Register
  AT91_REG PIO_ISR;      // Interrupt Status Register
  AT91_REG PIO_MDER;     // Multi-driver Enable Register
  AT91_REG PIO_MDDR;     // Multi-driver Disable Register
  AT91_REG PIO_MDSR;     // Multi-driver Status Register
  AT91_REG Reserved4[1];
  AT91_REG PIO_PUDR;     // Pull-up Disable Register
  AT91_REG PIO_PUER;     // Pull-up Enable Register
  AT91_REG PIO_PUSR;     // Pad Pull-up Status Register
  AT91_REG Reserved5[1];
  AT91_REG PIO_ASR;      // Peripheral A Select Register
  AT91_REG PIO_BSR;      // Peripheral B Select Register
  AT91_REG PIO_ABSR;     // AB Status Register
  AT91_REG Reserved6[9];
  AT91_REG PIO_OWER;     // Output Write Enable
  AT91_REG PIO_OWDR;     // Output Write Disable
  AT91_REG PIO_OWSR;     // Output Write Status Register
} AT91S_PIO, *AT91PS_PIO;
#else
#define PIO_PER  (AT91_CAST(AT91_REG *) 0x00000000) // PIO Enable Register
#define PIO_PDR  (AT91_CAST(AT91_REG *) 0x00000004) // PIO Disable Register
#define PIO_PSR  (AT91_CAST(AT91_REG *) 0x00000008) // PIO Status Register
#define PIO_OER  (AT91_CAST(AT91_REG *) 0x00000010) // Output Enable Register
#define PIO_ODR  (AT91_CAST(AT91_REG *) 0x00000014) // Output Disable Register
#define PIO_OSR  (AT91_CAST(AT91_REG *) 0x00000018) // Output Status Register
#define PIO_IFER (AT91_CAST(AT91_REG *) 0x00000020) // Glitch Input Filter Enable Register
#define PIO_IFDR (AT91_CAST(AT91_REG *) 0x00000024) // Glitch Input Filter Disable Register
#define PIO_IFSR (AT91_CAST(AT91_REG *) 0x00000028) // Glitch Input Filter Status Register
#define PIO_SODR (AT91_CAST(AT91_REG *) 0x00000030) // Set Output Data Register
#define PIO_CODR (AT91_CAST(AT91_REG *) 0x00000034) // Clear Output Data Register
#define PIO_ODSR (AT91_CAST(AT91_REG *) 0x00000038) // Output Data Status Register
#define PIO_PDSR (AT91_CAST(AT91_REG *) 0x0000003C) // Pin Data Status Register
#define PIO_IER  (AT91_CAST(AT91_REG *) 0x00000040) // Interrupt Enable Register
#define PIO_IDR  (AT91_CAST(AT91_REG *) 0x00000044) // Interrupt Disable Register
#define PIO_IMR  (AT91_CAST(AT91_REG *) 0x00000048) // Interrupt Mask Register
#define PIO_ISR  (AT91_CAST(AT91_REG *) 0x0000004C) // Interrupt Status Register
#define PIO_MDER (AT91_CAST(AT91_REG *) 0x00000050) // Multi-driver Enable Register
#define PIO_MDDR (AT91_CAST(AT91_REG *) 0x00000054) // Multi-driver Disable Register
#define PIO_MDSR (AT91_CAST(AT91_REG *) 0x00000058) // Multi-driver Status Register
#define PIO_PUDR (AT91_CAST(AT91_REG *) 0x00000060) // Pull-up Disable Register
#define PIO_PUER (AT91_CAST(AT91_REG *) 0x00000064) // Pull-up Enable Register
#define PIO_PUSR (AT91_CAST(AT91_REG *) 0x00000068) // Pad Pull-up Status Register
#define PIO_ASR  (AT91_CAST(AT91_REG *) 0x00000070) // Peripheral A Select Register
#define PIO_BSR  (AT91_CAST(AT91_REG *) 0x00000074) // Peripheral B Select Register
#define PIO_ABSR (AT91_CAST(AT91_REG *) 0x00000078) // AB Status Register
#define PIO_OWER (AT91_CAST(AT91_REG *) 0x000000A0) // Output Write Enable
#define PIO_OWDR (AT91_CAST(AT91_REG *) 0x000000A4) // Output Write Disable
#define PIO_OWSR (AT91_CAST(AT91_REG *) 0x000000A8) // Output Write Status Register
#endif
// -------- PIO_PER : (PIO Offset: 0x0000) PIO Enable Register --------
#define AT91C_PIO_PER_P0 (0x1 << 0) // (PIO) PIO Enable
#define AT91C_PIO_PER_P1 (0x1 << 1) // (PIO) PIO Enable
#define AT91C_PIO_PER_P2 (0x1 << 2) // (PIO) PIO Enable
#define AT91C_PIO_PER_P3 (0x1 << 3) // (PIO) PIO Enable
#define AT91C_PIO_PER_P4 (0x1 << 4) // (PIO) PIO Enable
#define AT91C_PIO_PER_P5 (0x1 << 5) // (PIO) PIO Enable
#define AT91C_PIO_PER_P6 (0x1 << 6) // (PIO) PIO Enable
#define AT91C_PIO_PER_P7 (0x1 << 7) // (PIO) PIO Enable
#define AT91C_PIO_PER_P8 (0x1 << 8) // (PIO) PIO Enable
#define AT91C_PIO_PER_P9 (0x1 << 9) // (PIO) PIO Enable
#define AT91C_PIO_PER_P10 (0x1 << 10) // (PIO) PIO Enable
#define AT91C_PIO_PER_P11 (0x1 << 11) // (PIO) PIO Enable
#define AT91C_PIO_PER_P12 (0x1 << 12) // (PIO) PIO Enable
#define AT91C_PIO_PER_P13 (0x1 << 13) // (PIO) PIO Enable
#define AT91C_PIO_PER_P14 (0x1 << 14) // (PIO) PIO Enable
#define AT91C_PIO_PER_P15 (0x1 << 15) // (PIO) PIO Enable
#define AT91C_PIO_PER_P16 (0x1 << 16) // (PIO) PIO Enable
#define AT91C_PIO_PER_P17 (0x1 << 17) // (PIO) PIO Enable
#define AT91C_PIO_PER_P18 (0x1 << 18) // (PIO) PIO Enable
#define AT91C_PIO_PER_P19 (0x1 << 19) // (PIO) PIO Enable
#define AT91C_PIO_PER_P20 (0x1 << 20) // (PIO) PIO Enable
#define AT91C_PIO_PER_P21 (0x1 << 21) // (PIO) PIO Enable
#define AT91C_PIO_PER_P22 (0x1 << 22) // (PIO) PIO Enable
#define AT91C_PIO_PER_P23 (0x1 << 23) // (PIO) PIO Enable
#define AT91C_PIO_PER_P24 (0x1 << 24) // (PIO) PIO Enable
#define AT91C_PIO_PER_P25 (0x1 << 25) // (PIO) PIO Enable
#define AT91C_PIO_PER_P26 (0x1 << 26) // (PIO) PIO Enable
#define AT91C_PIO_PER_P27 (0x1 << 27) // (PIO) PIO Enable
#define AT91C_PIO_PER_P28 (0x1 << 28) // (PIO) PIO Enable
#define AT91C_PIO_PER_P29 (0x1 << 29) // (PIO) PIO Enable
#define AT91C_PIO_PER_P30 (0x1 << 30) // (PIO) PIO Enable
#define AT91C_PIO_PER_P31 (0x1 << 31) // (PIO) PIO Enable
// -------- PIO_PDR : (PIO Offset: 0x0004) PIO Disable Register --------
#define AT91C_PIO_PDR_P0 (0x1 << 0) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P1 (0x1 << 1) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P2 (0x1 << 2) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P3 (0x1 << 3) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P4 (0x1 << 4) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P5 (0x1 << 5) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P6 (0x1 << 6) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P7 (0x1 << 7) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P8 (0x1 << 8) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P9 (0x1 << 9) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P10 (0x1 << 10) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P11 (0x1 << 11) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P12 (0x1 << 12) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P13 (0x1 << 13) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P14 (0x1 << 14) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P15 (0x1 << 15) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P16 (0x1 << 16) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P17 (0x1 << 17) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P18 (0x1 << 18) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P19 (0x1 << 19) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P20 (0x1 << 20) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P21 (0x1 << 21) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P22 (0x1 << 22) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P23 (0x1 << 23) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P24 (0x1 << 24) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P25 (0x1 << 25) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P26 (0x1 << 26) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P27 (0x1 << 27) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P28 (0x1 << 28) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P29 (0x1 << 29) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P30 (0x1 << 30) // (PIO) PIO Disable
#define AT91C_PIO_PDR_P31 (0x1 << 31) // (PIO) PIO Disable
// -------- PIO_PSR : (PIO Offset: 0x0008) PIO Status Register --------
#define AT91C_PIO_PSR_P0 (0x1 << 0) // (PIO) PIO Status
#define AT91C_PIO_PSR_P1 (0x1 << 1) // (PIO) PIO Status
#define AT91C_PIO_PSR_P2 (0x1 << 2) // (PIO) PIO Status
#define AT91C_PIO_PSR_P3 (0x1 << 3) // (PIO) PIO Status
#define AT91C_PIO_PSR_P4 (0x1 << 4) // (PIO) PIO Status
#define AT91C_PIO_PSR_P5 (0x1 << 5) // (PIO) PIO Status
#define AT91C_PIO_PSR_P6 (0x1 << 6) // (PIO) PIO Status
#define AT91C_PIO_PSR_P7 (0x1 << 7) // (PIO) PIO Status
#define AT91C_PIO_PSR_P8 (0x1 << 8) // (PIO) PIO Status
#define AT91C_PIO_PSR_P9 (0x1 << 9) // (PIO) PIO Status
#define AT91C_PIO_PSR_P10 (0x1 << 10) // (PIO) PIO Status
#define AT91C_PIO_PSR_P11 (0x1 << 11) // (PIO) PIO Status
#define AT91C_PIO_PSR_P12 (0x1 << 12) // (PIO) PIO Status
#define AT91C_PIO_PSR_P13 (0x1 << 13) // (PIO) PIO Status
#define AT91C_PIO_PSR_P14 (0x1 << 14) // (PIO) PIO Status
#define AT91C_PIO_PSR_P15 (0x1 << 15) // (PIO) PIO Status
#define AT91C_PIO_PSR_P16 (0x1 << 16) // (PIO) PIO Status
#define AT91C_PIO_PSR_P17 (0x1 << 17) // (PIO) PIO Status
#define AT91C_PIO_PSR_P18 (0x1 << 18) // (PIO) PIO Status
#define AT91C_PIO_PSR_P19 (0x1 << 19) // (PIO) PIO Status
#define AT91C_PIO_PSR_P20 (0x1 << 20) // (PIO) PIO Status
#define AT91C_PIO_PSR_P21 (0x1 << 21) // (PIO) PIO Status
#define AT91C_PIO_PSR_P22 (0x1 << 22) // (PIO) PIO Status
#define AT91C_PIO_PSR_P23 (0x1 << 23) // (PIO) PIO Status
#define AT91C_PIO_PSR_P24 (0x1 << 24) // (PIO) PIO Status
#define AT91C_PIO_PSR_P25 (0x1 << 25) // (PIO) PIO Status
#define AT91C_PIO_PSR_P26 (0x1 << 26) // (PIO) PIO Status
#define AT91C_PIO_PSR_P27 (0x1 << 27) // (PIO) PIO Status
#define AT91C_PIO_PSR_P28 (0x1 << 28) // (PIO) PIO Status
#define AT91C_PIO_PSR_P29 (0x1 << 29) // (PIO) PIO Status
#define AT91C_PIO_PSR_P30 (0x1 << 30) // (PIO) PIO Status
#define AT91C_PIO_PSR_P31 (0x1 << 31) // (PIO) PIO Status
// -------- PIO_OER : (PIO Offset: 0x0010) Output Enable Register --------
#define AT91C_PIO_OER_P0 (0x1 << 0) // (PIO) Output Enable
#define AT91C_PIO_OER_P1 (0x1 << 1) // (PIO) Output Enable
#define AT91C_PIO_OER_P2 (0x1 << 2) // (PIO) Output Enable
#define AT91C_PIO_OER_P3 (0x1 << 3) // (PIO) Output Enable
#define AT91C_PIO_OER_P4 (0x1 << 4) // (PIO) Output Enable
#define AT91C_PIO_OER_P5 (0x1 << 5) // (PIO) Output Enable
#define AT91C_PIO_OER_P6 (0x1 << 6) // (PIO) Output Enable
#define AT91C_PIO_OER_P7 (0x1 << 7) // (PIO) Output Enable
#define AT91C_PIO_OER_P8 (0x1 << 8) // (PIO) Output Enable
#define AT91C_PIO_OER_P9 (0x1 << 9) // (PIO) Output Enable
#define AT91C_PIO_OER_P10 (0x1 << 10) // (PIO) Output Enable
#define AT91C_PIO_OER_P11 (0x1 << 11) // (PIO) Output Enable
#define AT91C_PIO_OER_P12 (0x1 << 12) // (PIO) Output Enable
#define AT91C_PIO_OER_P13 (0x1 << 13) // (PIO) Output Enable
#define AT91C_PIO_OER_P14 (0x1 << 14) // (PIO) Output Enable
#define AT91C_PIO_OER_P15 (0x1 << 15) // (PIO) Output Enable
#define AT91C_PIO_OER_P16 (0x1 << 16) // (PIO) Output Enable
#define AT91C_PIO_OER_P17 (0x1 << 17) // (PIO) Output Enable
#define AT91C_PIO_OER_P18 (0x1 << 18) // (PIO) Output Enable
#define AT91C_PIO_OER_P19 (0x1 << 19) // (PIO) Output Enable
#define AT91C_PIO_OER_P20 (0x1 << 20) // (PIO) Output Enable
#define AT91C_PIO_OER_P21 (0x1 << 21) // (PIO) Output Enable
#define AT91C_PIO_OER_P22 (0x1 << 22) // (PIO) Output Enable
#define AT91C_PIO_OER_P23 (0x1 << 23) // (PIO) Output Enable
#define AT91C_PIO_OER_P24 (0x1 << 24) // (PIO) Output Enable
#define AT91C_PIO_OER_P25 (0x1 << 25) // (PIO) Output Enable
#define AT91C_PIO_OER_P26 (0x1 << 26) // (PIO) Output Enable
#define AT91C_PIO_OER_P27 (0x1 << 27) // (PIO) Output Enable
#define AT91C_PIO_OER_P28 (0x1 << 28) // (PIO) Output Enable
#define AT91C_PIO_OER_P29 (0x1 << 29) // (PIO) Output Enable
#define AT91C_PIO_OER_P30 (0x1 << 30) // (PIO) Output Enable
#define AT91C_PIO_OER_P31 (0x1 << 31) // (PIO) Output Enable
// -------- PIO_ODR : (PIO Offset: 0x0014) Output Disable Register --------
#define AT91C_PIO_ODR_P0 (0x1 << 0) // (PIO) Output Disable
#define AT91C_PIO_ODR_P1 (0x1 << 1) // (PIO) Output Disable
#define AT91C_PIO_ODR_P2 (0x1 << 2) // (PIO) Output Disable
#define AT91C_PIO_ODR_P3 (0x1 << 3) // (PIO) Output Disable
#define AT91C_PIO_ODR_P4 (0x1 << 4) // (PIO) Output Disable
#define AT91C_PIO_ODR_P5 (0x1 << 5) // (PIO) Output Disable
#define AT91C_PIO_ODR_P6 (0x1 << 6) // (PIO) Output Disable
#define AT91C_PIO_ODR_P7 (0x1 << 7) // (PIO) Output Disable
#define AT91C_PIO_ODR_P8 (0x1 << 8) // (PIO) Output Disable
#define AT91C_PIO_ODR_P9 (0x1 << 9) // (PIO) Output Disable
#define AT91C_PIO_ODR_P10 (0x1 << 10) // (PIO) Output Disable
#define AT91C_PIO_ODR_P11 (0x1 << 11) // (PIO) Output Disable
#define AT91C_PIO_ODR_P12 (0x1 << 12) // (PIO) Output Disable
#define AT91C_PIO_ODR_P13 (0x1 << 13) // (PIO) Output Disable
#define AT91C_PIO_ODR_P14 (0x1 << 14) // (PIO) Output Disable
#define AT91C_PIO_ODR_P15 (0x1 << 15) // (PIO) Output Disable
#define AT91C_PIO_ODR_P16 (0x1 << 16) // (PIO) Output Disable
#define AT91C_PIO_ODR_P17 (0x1 << 17) // (PIO) Output Disable
#define AT91C_PIO_ODR_P18 (0x1 << 18) // (PIO) Output Disable
#define AT91C_PIO_ODR_P19 (0x1 << 19) // (PIO) Output Disable
#define AT91C_PIO_ODR_P20 (0x1 << 20) // (PIO) Output Disable
#define AT91C_PIO_ODR_P21 (0x1 << 21) // (PIO) Output Disable
#define AT91C_PIO_ODR_P22 (0x1 << 22) // (PIO) Output Disable
#define AT91C_PIO_ODR_P23 (0x1 << 23) // (PIO) Output Disable
#define AT91C_PIO_ODR_P24 (0x1 << 24) // (PIO) Output Disable
#define AT91C_PIO_ODR_P25 (0x1 << 25) // (PIO) Output Disable
#define AT91C_PIO_ODR_P26 (0x1 << 26) // (PIO) Output Disable
#define AT91C_PIO_ODR_P27 (0x1 << 27) // (PIO) Output Disable
#define AT91C_PIO_ODR_P28 (0x1 << 28) // (PIO) Output Disable
#define AT91C_PIO_ODR_P29 (0x1 << 29) // (PIO) Output Disable
#define AT91C_PIO_ODR_P30 (0x1 << 30) // (PIO) Output Disable
#define AT91C_PIO_ODR_P31 (0x1 << 31) // (PIO) Output Disable
// -------- PIO_OSR : (PIO Offset: 0x0018) Output Status Register --------
#define AT91C_PIO_OSR_P0 (0x1 << 0) // (PIO) Output Status
#define AT91C_PIO_OSR_P1 (0x1 << 1) // (PIO) Output Status
#define AT91C_PIO_OSR_P2 (0x1 << 2) // (PIO) Output Status
#define AT91C_PIO_OSR_P3 (0x1 << 3) // (PIO) Output Status
#define AT91C_PIO_OSR_P4 (0x1 << 4) // (PIO) Output Status
#define AT91C_PIO_OSR_P5 (0x1 << 5) // (PIO) Output Status
#define AT91C_PIO_OSR_P6 (0x1 << 6) // (PIO) Output Status
#define AT91C_PIO_OSR_P7 (0x1 << 7) // (PIO) Output Status
#define AT91C_PIO_OSR_P8 (0x1 << 8) // (PIO) Output Status
#define AT91C_PIO_OSR_P9 (0x1 << 9) // (PIO) Output Status
#define AT91C_PIO_OSR_P10 (0x1 << 10) // (PIO) Output Status
#define AT91C_PIO_OSR_P11 (0x1 << 11) // (PIO) Output Status
#define AT91C_PIO_OSR_P12 (0x1 << 12) // (PIO) Output Status
#define AT91C_PIO_OSR_P13 (0x1 << 13) // (PIO) Output Status
#define AT91C_PIO_OSR_P14 (0x1 << 14) // (PIO) Output Status
#define AT91C_PIO_OSR_P15 (0x1 << 15) // (PIO) Output Status
#define AT91C_PIO_OSR_P16 (0x1 << 16) // (PIO) Output Status
#define AT91C_PIO_OSR_P17 (0x1 << 17) // (PIO) Output Status
#define AT91C_PIO_OSR_P18 (0x1 << 18) // (PIO) Output Status
#define AT91C_PIO_OSR_P19 (0x1 << 19) // (PIO) Output Status
#define AT91C_PIO_OSR_P20 (0x1 << 20) // (PIO) Output Status
#define AT91C_PIO_OSR_P21 (0x1 << 21) // (PIO) Output Status
#define AT91C_PIO_OSR_P22 (0x1 << 22) // (PIO) Output Status
#define AT91C_PIO_OSR_P23 (0x1 << 23) // (PIO) Output Status
#define AT91C_PIO_OSR_P24 (0x1 << 24) // (PIO) Output Status
#define AT91C_PIO_OSR_P25 (0x1 << 25) // (PIO) Output Status
#define AT91C_PIO_OSR_P26 (0x1 << 26) // (PIO) Output Status
#define AT91C_PIO_OSR_P27 (0x1 << 27) // (PIO) Output Status
#define AT91C_PIO_OSR_P28 (0x1 << 28) // (PIO) Output Status
#define AT91C_PIO_OSR_P29 (0x1 << 29) // (PIO) Output Status
#define AT91C_PIO_OSR_P30 (0x1 << 30) // (PIO) Output Status
#define AT91C_PIO_OSR_P31 (0x1 << 31) // (PIO) Output Status
// -------- PIO_IFER : (PIO Offset: 0x0020) Glitch Input Filter Enable Register --------
#define AT91C_PIO_IFER_P0 (0x1 << 0) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P1 (0x1 << 1) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P2 (0x1 << 2) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P3 (0x1 << 3) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P4 (0x1 << 4) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P5 (0x1 << 5) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P6 (0x1 << 6) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P7 (0x1 << 7) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P8 (0x1 << 8) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P9 (0x1 << 9) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P10 (0x1 << 10) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P11 (0x1 << 11) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P12 (0x1 << 12) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P13 (0x1 << 13) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P14 (0x1 << 14) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P15 (0x1 << 15) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P16 (0x1 << 16) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P17 (0x1 << 17) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P18 (0x1 << 18) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P19 (0x1 << 19) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P20 (0x1 << 20) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P21 (0x1 << 21) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P22 (0x1 << 22) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P23 (0x1 << 23) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P24 (0x1 << 24) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P25 (0x1 << 25) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P26 (0x1 << 26) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P27 (0x1 << 27) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P28 (0x1 << 28) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P29 (0x1 << 29) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P30 (0x1 << 30) // (PIO) Input Filter Enable
#define AT91C_PIO_IFER_P31 (0x1 << 31) // (PIO) Input Filter Enable
// -------- PIO_IFDR : (PIO Offset: 0x0024) Glitch Input Filter Disable Register --------
#define AT91C_PIO_IFDR_P0 (0x1 << 0) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P1 (0x1 << 1) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P2 (0x1 << 2) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P3 (0x1 << 3) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P4 (0x1 << 4) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P5 (0x1 << 5) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P6 (0x1 << 6) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P7 (0x1 << 7) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P8 (0x1 << 8) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P9 (0x1 << 9) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P10 (0x1 << 10) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P11 (0x1 << 11) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P12 (0x1 << 12) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P13 (0x1 << 13) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P14 (0x1 << 14) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P15 (0x1 << 15) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P16 (0x1 << 16) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P17 (0x1 << 17) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P18 (0x1 << 18) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P19 (0x1 << 19) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P20 (0x1 << 20) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P21 (0x1 << 21) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P22 (0x1 << 22) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P23 (0x1 << 23) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P24 (0x1 << 24) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P25 (0x1 << 25) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P26 (0x1 << 26) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P27 (0x1 << 27) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P28 (0x1 << 28) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P29 (0x1 << 29) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P30 (0x1 << 30) // (PIO) Input Filter Disable
#define AT91C_PIO_IFDR_P31 (0x1 << 31) // (PIO) Input Filter Disable
// -------- PIO_IFSR : (PIO Offset: 0x0028) Glitch Input Filter Status Register --------
#define AT91C_PIO_IFSR_P0 (0x1 << 0) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P1 (0x1 << 1) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P2 (0x1 << 2) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P3 (0x1 << 3) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P4 (0x1 << 4) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P5 (0x1 << 5) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P6 (0x1 << 6) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P7 (0x1 << 7) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P8 (0x1 << 8) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P9 (0x1 << 9) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P10 (0x1 << 10) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P11 (0x1 << 11) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P12 (0x1 << 12) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P13 (0x1 << 13) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P14 (0x1 << 14) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P15 (0x1 << 15) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P16 (0x1 << 16) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P17 (0x1 << 17) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P18 (0x1 << 18) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P19 (0x1 << 19) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P20 (0x1 << 20) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P21 (0x1 << 21) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P22 (0x1 << 22) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P23 (0x1 << 23) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P24 (0x1 << 24) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P25 (0x1 << 25) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P26 (0x1 << 26) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P27 (0x1 << 27) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P28 (0x1 << 28) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P29 (0x1 << 29) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P30 (0x1 << 30) // (PIO) Input Filer Status
#define AT91C_PIO_IFSR_P31 (0x1 << 31) // (PIO) Input Filer Status
// -------- PIO_SODR : (PIO Offset: 0x0030) Set Output Data Register --------
#define AT91C_PIO_SODR_P0 (0x1 << 0) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P1 (0x1 << 1) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P2 (0x1 << 2) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P3 (0x1 << 3) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P4 (0x1 << 4) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P5 (0x1 << 5) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P6 (0x1 << 6) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P7 (0x1 << 7) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P8 (0x1 << 8) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P9 (0x1 << 9) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P10 (0x1 << 10) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P11 (0x1 << 11) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P12 (0x1 << 12) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P13 (0x1 << 13) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P14 (0x1 << 14) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P15 (0x1 << 15) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P16 (0x1 << 16) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P17 (0x1 << 17) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P18 (0x1 << 18) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P19 (0x1 << 19) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P20 (0x1 << 20) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P21 (0x1 << 21) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P22 (0x1 << 22) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P23 (0x1 << 23) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P24 (0x1 << 24) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P25 (0x1 << 25) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P26 (0x1 << 26) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P27 (0x1 << 27) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P28 (0x1 << 28) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P29 (0x1 << 29) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P30 (0x1 << 30) // (PIO) Set Output Data
#define AT91C_PIO_SODR_P31 (0x1 << 31) // (PIO) Set Output Data
// -------- PIO_CODR : (PIO Offset: 0x0034) Clear Output Data Register --------
#define AT91C_PIO_CODR_P0 (0x1 << 0) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P1 (0x1 << 1) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P2 (0x1 << 2) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P3 (0x1 << 3) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P4 (0x1 << 4) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P5 (0x1 << 5) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P6 (0x1 << 6) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P7 (0x1 << 7) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P8 (0x1 << 8) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P9 (0x1 << 9) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P10 (0x1 << 10) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P11 (0x1 << 11) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P12 (0x1 << 12) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P13 (0x1 << 13) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P14 (0x1 << 14) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P15 (0x1 << 15) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P16 (0x1 << 16) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P17 (0x1 << 17) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P18 (0x1 << 18) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P19 (0x1 << 19) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P20 (0x1 << 20) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P21 (0x1 << 21) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P22 (0x1 << 22) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P23 (0x1 << 23) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P24 (0x1 << 24) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P25 (0x1 << 25) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P26 (0x1 << 26) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P27 (0x1 << 27) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P28 (0x1 << 28) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P29 (0x1 << 29) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P30 (0x1 << 30) // (PIO) Set Output Data
#define AT91C_PIO_CODR_P31 (0x1 << 31) // (PIO) Set Output Data
// -------- PIO_ODSR : (PIO Offset: 0x0038) Output Data Status Register --------
#define AT91C_PIO_ODSR_P0 (0x1 << 0) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P1 (0x1 << 1) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P2 (0x1 << 2) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P3 (0x1 << 3) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P4 (0x1 << 4) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P5 (0x1 << 5) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P6 (0x1 << 6) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P7 (0x1 << 7) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P8 (0x1 << 8) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P9 (0x1 << 9) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P10 (0x1 << 10) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P11 (0x1 << 11) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P12 (0x1 << 12) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P13 (0x1 << 13) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P14 (0x1 << 14) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P15 (0x1 << 15) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P16 (0x1 << 16) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P17 (0x1 << 17) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P18 (0x1 << 18) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P19 (0x1 << 19) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P20 (0x1 << 20) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P21 (0x1 << 21) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P22 (0x1 << 22) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P23 (0x1 << 23) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P24 (0x1 << 24) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P25 (0x1 << 25) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P26 (0x1 << 26) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P27 (0x1 << 27) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P28 (0x1 << 28) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P29 (0x1 << 29) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P30 (0x1 << 30) // (PIO) Output Data Status
#define AT91C_PIO_ODSR_P31 (0x1 << 31) // (PIO) Output Data Status
// -------- PIO_PDSR : (PIO Offset: 0x003C) Pin Data Status Register --------
#define AT91C_PIO_PDSR_P0 (0x1 << 0) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P1 (0x1 << 1) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P2 (0x1 << 2) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P3 (0x1 << 3) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P4 (0x1 << 4) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P5 (0x1 << 5) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P6 (0x1 << 6) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P7 (0x1 << 7) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P8 (0x1 << 8) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P9 (0x1 << 9) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P10 (0x1 << 10) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P11 (0x1 << 11) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P12 (0x1 << 12) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P13 (0x1 << 13) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P14 (0x1 << 14) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P15 (0x1 << 15) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P16 (0x1 << 16) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P17 (0x1 << 17) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P18 (0x1 << 18) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P19 (0x1 << 19) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P20 (0x1 << 20) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P21 (0x1 << 21) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P22 (0x1 << 22) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P23 (0x1 << 23) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P24 (0x1 << 24) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P25 (0x1 << 25) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P26 (0x1 << 26) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P27 (0x1 << 27) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P28 (0x1 << 28) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P29 (0x1 << 29) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P30 (0x1 << 30) // (PIO) Output Data Status
#define AT91C_PIO_PDSR_P31 (0x1 << 31) // (PIO) Output Data Status
// -------- PIO_IER : (PIO Offset: 0x0040) Interrupt Enable Register --------
#define AT91C_PIO_IER_P0 (0x1 << 0) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P1 (0x1 << 1) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P2 (0x1 << 2) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P3 (0x1 << 3) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P4 (0x1 << 4) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P5 (0x1 << 5) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P6 (0x1 << 6) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P7 (0x1 << 7) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P8 (0x1 << 8) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P9 (0x1 << 9) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P10 (0x1 << 10) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P11 (0x1 << 11) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P12 (0x1 << 12) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P13 (0x1 << 13) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P14 (0x1 << 14) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P15 (0x1 << 15) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P16 (0x1 << 16) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P17 (0x1 << 17) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P18 (0x1 << 18) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P19 (0x1 << 19) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P20 (0x1 << 20) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P21 (0x1 << 21) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P22 (0x1 << 22) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P23 (0x1 << 23) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P24 (0x1 << 24) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P25 (0x1 << 25) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P26 (0x1 << 26) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P27 (0x1 << 27) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P28 (0x1 << 28) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P29 (0x1 << 29) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P30 (0x1 << 30) // (PIO) Input Change Interrupt Enable
#define AT91C_PIO_IER_P31 (0x1 << 31) // (PIO) Input Change Interrupt Enable
// -------- PIO_IDR : (PIO Offset: 0x0044) Interrupt Disable Register --------
#define AT91C_PIO_IDR_P0 (0x1 << 0) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P1 (0x1 << 1) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P2 (0x1 << 2) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P3 (0x1 << 3) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P4 (0x1 << 4) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P5 (0x1 << 5) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P6 (0x1 << 6) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P7 (0x1 << 7) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P8 (0x1 << 8) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P9 (0x1 << 9) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P10 (0x1 << 10) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P11 (0x1 << 11) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P12 (0x1 << 12) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P13 (0x1 << 13) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P14 (0x1 << 14) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P15 (0x1 << 15) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P16 (0x1 << 16) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P17 (0x1 << 17) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P18 (0x1 << 18) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P19 (0x1 << 19) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P20 (0x1 << 20) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P21 (0x1 << 21) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P22 (0x1 << 22) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P23 (0x1 << 23) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P24 (0x1 << 24) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P25 (0x1 << 25) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P26 (0x1 << 26) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P27 (0x1 << 27) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P28 (0x1 << 28) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P29 (0x1 << 29) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P30 (0x1 << 30) // (PIO) Input Change Interrupt Disable
#define AT91C_PIO_IDR_P31 (0x1 << 31) // (PIO) Input Change Interrupt Disable
// -------- PIO_IMR : (PIO Offset: 0x0048) Interrupt Mask Register --------
#define AT91C_PIO_IMR_P0 (0x1 << 0) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P1 (0x1 << 1) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P2 (0x1 << 2) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P3 (0x1 << 3) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P4 (0x1 << 4) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P5 (0x1 << 5) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P6 (0x1 << 6) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P7 (0x1 << 7) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P8 (0x1 << 8) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P9 (0x1 << 9) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P10 (0x1 << 10) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P11 (0x1 << 11) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P12 (0x1 << 12) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P13 (0x1 << 13) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P14 (0x1 << 14) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P15 (0x1 << 15) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P16 (0x1 << 16) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P17 (0x1 << 17) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P18 (0x1 << 18) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P19 (0x1 << 19) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P20 (0x1 << 20) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P21 (0x1 << 21) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P22 (0x1 << 22) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P23 (0x1 << 23) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P24 (0x1 << 24) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P25 (0x1 << 25) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P26 (0x1 << 26) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P27 (0x1 << 27) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P28 (0x1 << 28) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P29 (0x1 << 29) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P30 (0x1 << 30) // (PIO) Input Change Interrupt Mask
#define AT91C_PIO_IMR_P31 (0x1 << 31) // (PIO) Input Change Interrupt Mask
// -------- PIO_ISR : (PIO Offset: 0x004C) Interrupt Status Register --------
#define AT91C_PIO_ISR_P0 (0x1 << 0) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P1 (0x1 << 1) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P2 (0x1 << 2) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P3 (0x1 << 3) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P4 (0x1 << 4) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P5 (0x1 << 5) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P6 (0x1 << 6) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P7 (0x1 << 7) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P8 (0x1 << 8) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P9 (0x1 << 9) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P10 (0x1 << 10) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P11 (0x1 << 11) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P12 (0x1 << 12) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P13 (0x1 << 13) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P14 (0x1 << 14) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P15 (0x1 << 15) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P16 (0x1 << 16) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P17 (0x1 << 17) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P18 (0x1 << 18) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P19 (0x1 << 19) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P20 (0x1 << 20) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P21 (0x1 << 21) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P22 (0x1 << 22) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P23 (0x1 << 23) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P24 (0x1 << 24) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P25 (0x1 << 25) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P26 (0x1 << 26) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P27 (0x1 << 27) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P28 (0x1 << 28) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P29 (0x1 << 29) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P30 (0x1 << 30) // (PIO) Input Change Interrupt Status
#define AT91C_PIO_ISR_P31 (0x1 << 31) // (PIO) Input Change Interrupt Status
// -------- PIO_MDER : (PIO Offset: 0x0050) Multi-driver Enable Register --------
#define AT91C_PIO_MDER_P0 (0x1 << 0) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P1 (0x1 << 1) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P2 (0x1 << 2) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P3 (0x1 << 3) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P4 (0x1 << 4) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P5 (0x1 << 5) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P6 (0x1 << 6) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P7 (0x1 << 7) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P8 (0x1 << 8) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P9 (0x1 << 9) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P10 (0x1 << 10) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P11 (0x1 << 11) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P12 (0x1 << 12) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P13 (0x1 << 13) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P14 (0x1 << 14) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P15 (0x1 << 15) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P16 (0x1 << 16) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P17 (0x1 << 17) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P18 (0x1 << 18) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P19 (0x1 << 19) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P20 (0x1 << 20) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P21 (0x1 << 21) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P22 (0x1 << 22) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P23 (0x1 << 23) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P24 (0x1 << 24) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P25 (0x1 << 25) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P26 (0x1 << 26) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P27 (0x1 << 27) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P28 (0x1 << 28) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P29 (0x1 << 29) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P30 (0x1 << 30) // (PIO) Multi Drive Enable.
#define AT91C_PIO_MDER_P31 (0x1 << 31) // (PIO) Multi Drive Enable.
// -------- PIO_MDDR : (PIO Offset: 0x0054) Multi-driver Disable Register --------
#define AT91C_PIO_MDDR_P0 (0x1 << 0) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P1 (0x1 << 1) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P2 (0x1 << 2) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P3 (0x1 << 3) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P4 (0x1 << 4) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P5 (0x1 << 5) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P6 (0x1 << 6) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P7 (0x1 << 7) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P8 (0x1 << 8) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P9 (0x1 << 9) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P10 (0x1 << 10) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P11 (0x1 << 11) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P12 (0x1 << 12) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P13 (0x1 << 13) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P14 (0x1 << 14) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P15 (0x1 << 15) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P16 (0x1 << 16) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P17 (0x1 << 17) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P18 (0x1 << 18) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P19 (0x1 << 19) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P20 (0x1 << 20) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P21 (0x1 << 21) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P22 (0x1 << 22) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P23 (0x1 << 23) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P24 (0x1 << 24) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P25 (0x1 << 25) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P26 (0x1 << 26) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P27 (0x1 << 27) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P28 (0x1 << 28) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P29 (0x1 << 29) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P30 (0x1 << 30) // (PIO) Multi Drive Disable.
#define AT91C_PIO_MDDR_P31 (0x1 << 31) // (PIO) Multi Drive Disable.
// -------- PIO_MDSR : (PIO Offset: 0x0058) Multi-driver Status Register --------
#define AT91C_PIO_MDSR_P0 (0x1 << 0) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P1 (0x1 << 1) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P2 (0x1 << 2) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P3 (0x1 << 3) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P4 (0x1 << 4) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P5 (0x1 << 5) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P6 (0x1 << 6) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P7 (0x1 << 7) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P8 (0x1 << 8) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P9 (0x1 << 9) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P10 (0x1 << 10) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P11 (0x1 << 11) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P12 (0x1 << 12) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P13 (0x1 << 13) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P14 (0x1 << 14) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P15 (0x1 << 15) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P16 (0x1 << 16) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P17 (0x1 << 17) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P18 (0x1 << 18) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P19 (0x1 << 19) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P20 (0x1 << 20) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P21 (0x1 << 21) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P22 (0x1 << 22) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P23 (0x1 << 23) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P24 (0x1 << 24) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P25 (0x1 << 25) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P26 (0x1 << 26) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P27 (0x1 << 27) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P28 (0x1 << 28) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P29 (0x1 << 29) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P30 (0x1 << 30) // (PIO) Multi Drive Status.
#define AT91C_PIO_MDSR_P31 (0x1 << 31) // (PIO) Multi Drive Status.
// -------- PIO_PUDR : (PIO Offset: 0x0060) Pull-up Disable Register --------
#define AT91C_PIO_PUDR_P0 (0x1 << 0) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P1 (0x1 << 1) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P2 (0x1 << 2) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P3 (0x1 << 3) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P4 (0x1 << 4) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P5 (0x1 << 5) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P6 (0x1 << 6) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P7 (0x1 << 7) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P8 (0x1 << 8) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P9 (0x1 << 9) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P10 (0x1 << 10) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P11 (0x1 << 11) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P12 (0x1 << 12) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P13 (0x1 << 13) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P14 (0x1 << 14) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P15 (0x1 << 15) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P16 (0x1 << 16) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P17 (0x1 << 17) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P18 (0x1 << 18) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P19 (0x1 << 19) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P20 (0x1 << 20) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P21 (0x1 << 21) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P22 (0x1 << 22) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P23 (0x1 << 23) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P24 (0x1 << 24) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P25 (0x1 << 25) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P26 (0x1 << 26) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P27 (0x1 << 27) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P28 (0x1 << 28) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P29 (0x1 << 29) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P30 (0x1 << 30) // (PIO) Pull Up Disable.
#define AT91C_PIO_PUDR_P31 (0x1 << 31) // (PIO) Pull Up Disable.
// -------- PIO_PUER : (PIO Offset: 0x0064) Pull-up Enable Register --------
#define AT91C_PIO_PUER_P0 (0x1 << 0) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P1 (0x1 << 1) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P2 (0x1 << 2) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P3 (0x1 << 3) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P4 (0x1 << 4) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P5 (0x1 << 5) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P6 (0x1 << 6) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P7 (0x1 << 7) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P8 (0x1 << 8) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P9 (0x1 << 9) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P10 (0x1 << 10) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P11 (0x1 << 11) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P12 (0x1 << 12) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P13 (0x1 << 13) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P14 (0x1 << 14) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P15 (0x1 << 15) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P16 (0x1 << 16) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P17 (0x1 << 17) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P18 (0x1 << 18) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P19 (0x1 << 19) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P20 (0x1 << 20) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P21 (0x1 << 21) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P22 (0x1 << 22) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P23 (0x1 << 23) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P24 (0x1 << 24) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P25 (0x1 << 25) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P26 (0x1 << 26) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P27 (0x1 << 27) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P28 (0x1 << 28) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P29 (0x1 << 29) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P30 (0x1 << 30) // (PIO) Pull Up Enable.
#define AT91C_PIO_PUER_P31 (0x1 << 31) // (PIO) Pull Up Enable.
// -------- PIO_PUSR : (PIO Offset: 0x0068) Pad Pull-up Status Register --------
#define AT91C_PIO_PUSR_P0 (0x1 << 0) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P1 (0x1 << 1) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P2 (0x1 << 2) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P3 (0x1 << 3) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P4 (0x1 << 4) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P5 (0x1 << 5) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P6 (0x1 << 6) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P7 (0x1 << 7) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P8 (0x1 << 8) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P9 (0x1 << 9) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P10 (0x1 << 10) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P11 (0x1 << 11) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P12 (0x1 << 12) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P13 (0x1 << 13) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P14 (0x1 << 14) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P15 (0x1 << 15) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P16 (0x1 << 16) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P17 (0x1 << 17) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P18 (0x1 << 18) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P19 (0x1 << 19) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P20 (0x1 << 20) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P21 (0x1 << 21) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P22 (0x1 << 22) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P23 (0x1 << 23) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P24 (0x1 << 24) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P25 (0x1 << 25) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P26 (0x1 << 26) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P27 (0x1 << 27) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P28 (0x1 << 28) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P29 (0x1 << 29) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P30 (0x1 << 30) // (PIO) Pull Up Status.
#define AT91C_PIO_PUSR_P31 (0x1 << 31) // (PIO) Pull Up Status.
// -------- PIO_ASR : (PIO Offset: 0x0070) Peripheral A Select Register --------
#define AT91C_PIO_ASR_P0 (0x1 << 0) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P1 (0x1 << 1) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P2 (0x1 << 2) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P3 (0x1 << 3) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P4 (0x1 << 4) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P5 (0x1 << 5) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P6 (0x1 << 6) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P7 (0x1 << 7) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P8 (0x1 << 8) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P9 (0x1 << 9) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P10 (0x1 << 10) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P11 (0x1 << 11) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P12 (0x1 << 12) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P13 (0x1 << 13) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P14 (0x1 << 14) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P15 (0x1 << 15) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P16 (0x1 << 16) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P17 (0x1 << 17) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P18 (0x1 << 18) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P19 (0x1 << 19) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P20 (0x1 << 20) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P21 (0x1 << 21) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P22 (0x1 << 22) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P23 (0x1 << 23) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P24 (0x1 << 24) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P25 (0x1 << 25) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P26 (0x1 << 26) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P27 (0x1 << 27) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P28 (0x1 << 28) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P29 (0x1 << 29) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P30 (0x1 << 30) // (PIO) Peripheral A Select.
#define AT91C_PIO_ASR_P31 (0x1 << 31) // (PIO) Peripheral A Select.
// -------- PIO_BSR : (PIO Offset: 0x0074) Peripheral B Select Register --------
#define AT91C_PIO_BSR_P0 (0x1 << 0) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P1 (0x1 << 1) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P2 (0x1 << 2) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P3 (0x1 << 3) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P4 (0x1 << 4) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P5 (0x1 << 5) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P6 (0x1 << 6) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P7 (0x1 << 7) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P8 (0x1 << 8) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P9 (0x1 << 9) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P10 (0x1 << 10) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P11 (0x1 << 11) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P12 (0x1 << 12) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P13 (0x1 << 13) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P14 (0x1 << 14) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P15 (0x1 << 15) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P16 (0x1 << 16) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P17 (0x1 << 17) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P18 (0x1 << 18) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P19 (0x1 << 19) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P20 (0x1 << 20) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P21 (0x1 << 21) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P22 (0x1 << 22) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P23 (0x1 << 23) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P24 (0x1 << 24) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P25 (0x1 << 25) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P26 (0x1 << 26) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P27 (0x1 << 27) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P28 (0x1 << 28) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P29 (0x1 << 29) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P30 (0x1 << 30) // (PIO) Peripheral B Select.
#define AT91C_PIO_BSR_P31 (0x1 << 31) // (PIO) Peripheral B Select.
// -------- PIO_ABSR : (PIO Offset: 0x0078) AB Status Register --------
#define AT91C_PIO_ABSR_P0 (0x1 << 0) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P1 (0x1 << 1) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P2 (0x1 << 2) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P3 (0x1 << 3) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P4 (0x1 << 4) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P5 (0x1 << 5) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P6 (0x1 << 6) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P7 (0x1 << 7) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P8 (0x1 << 8) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P9 (0x1 << 9) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P10 (0x1 << 10) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P11 (0x1 << 11) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P12 (0x1 << 12) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P13 (0x1 << 13) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P14 (0x1 << 14) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P15 (0x1 << 15) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P16 (0x1 << 16) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P17 (0x1 << 17) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P18 (0x1 << 18) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P19 (0x1 << 19) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P20 (0x1 << 20) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P21 (0x1 << 21) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P22 (0x1 << 22) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P23 (0x1 << 23) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P24 (0x1 << 24) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P25 (0x1 << 25) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P26 (0x1 << 26) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P27 (0x1 << 27) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P28 (0x1 << 28) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P29 (0x1 << 29) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P30 (0x1 << 30) // (PIO) Peripheral A B Status.
#define AT91C_PIO_ABSR_P31 (0x1 << 31) // (PIO) Peripheral A B Status.
// -------- PIO_OWER : (PIO Offset: 0x00A0) Output Write Enable --------
#define AT91C_PIO_OWER_P0 (0x1 << 0) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P1 (0x1 << 1) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P2 (0x1 << 2) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P3 (0x1 << 3) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P4 (0x1 << 4) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P5 (0x1 << 5) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P6 (0x1 << 6) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P7 (0x1 << 7) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P8 (0x1 << 8) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P9 (0x1 << 9) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P10 (0x1 << 10) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P11 (0x1 << 11) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P12 (0x1 << 12) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P13 (0x1 << 13) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P14 (0x1 << 14) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P15 (0x1 << 15) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P16 (0x1 << 16) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P17 (0x1 << 17) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P18 (0x1 << 18) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P19 (0x1 << 19) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P20 (0x1 << 20) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P21 (0x1 << 21) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P22 (0x1 << 22) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P23 (0x1 << 23) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P24 (0x1 << 24) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P25 (0x1 << 25) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P26 (0x1 << 26) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P27 (0x1 << 27) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P28 (0x1 << 28) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P29 (0x1 << 29) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P30 (0x1 << 30) // (PIO) Output Write Enable.
#define AT91C_PIO_OWER_P31 (0x1 << 31) // (PIO) Output Write Enable.
// -------- PIO_OWDR : (PIO Offset: 0x00A4) Output Write Disable --------
#define AT91C_PIO_OWDR_P0 (0x1 << 0) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P1 (0x1 << 1) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P2 (0x1 << 2) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P3 (0x1 << 3) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P4 (0x1 << 4) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P5 (0x1 << 5) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P6 (0x1 << 6) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P7 (0x1 << 7) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P8 (0x1 << 8) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P9 (0x1 << 9) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P10 (0x1 << 10) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P11 (0x1 << 11) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P12 (0x1 << 12) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P13 (0x1 << 13) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P14 (0x1 << 14) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P15 (0x1 << 15) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P16 (0x1 << 16) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P17 (0x1 << 17) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P18 (0x1 << 18) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P19 (0x1 << 19) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P20 (0x1 << 20) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P21 (0x1 << 21) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P22 (0x1 << 22) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P23 (0x1 << 23) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P24 (0x1 << 24) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P25 (0x1 << 25) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P26 (0x1 << 26) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P27 (0x1 << 27) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P28 (0x1 << 28) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P29 (0x1 << 29) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P30 (0x1 << 30) // (PIO) Output Write Disable.
#define AT91C_PIO_OWDR_P31 (0x1 << 31) // (PIO) Output Write Disable.
// -------- PIO_OWSR : (PIO Offset: 0x00A8) Output Write Status Register --------
#define AT91C_PIO_OWSR_P0 (0x1 << 0) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P1 (0x1 << 1) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P2 (0x1 << 2) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P3 (0x1 << 3) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P4 (0x1 << 4) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P5 (0x1 << 5) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P6 (0x1 << 6) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P7 (0x1 << 7) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P8 (0x1 << 8) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P9 (0x1 << 9) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P10 (0x1 << 10) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P11 (0x1 << 11) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P12 (0x1 << 12) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P13 (0x1 << 13) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P14 (0x1 << 14) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P15 (0x1 << 15) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P16 (0x1 << 16) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P17 (0x1 << 17) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P18 (0x1 << 18) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P19 (0x1 << 19) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P20 (0x1 << 20) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P21 (0x1 << 21) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P22 (0x1 << 22) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P23 (0x1 << 23) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P24 (0x1 << 24) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P25 (0x1 << 25) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P26 (0x1 << 26) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P27 (0x1 << 27) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P28 (0x1 << 28) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P29 (0x1 << 29) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P30 (0x1 << 30) // (PIO) Output Write Status.
#define AT91C_PIO_OWSR_P31 (0x1 << 31) // (PIO) Output Write Status.

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Periodic Interval Timer
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_PIT {
  AT91_REG PIT_MR;   // Mode Register
  AT91_REG PIT_SR;   // Status Register
  AT91_REG PIT_PIVR; // Periodic Interval Value Register
  AT91_REG PIT_PIIR; // Periodic Interval Image Register
} AT91S_PIT, *AT91PS_PIT;
#else
#define PIT_MR   (AT91_CAST(AT91_REG *) 0x00000000) // Mode Register
#define PIT_SR   (AT91_CAST(AT91_REG *) 0x00000004) // Status Register
#define PIT_PIVR (AT91_CAST(AT91_REG *) 0x00000008) // Periodic Interval Value Register
#define PIT_PIIR (AT91_CAST(AT91_REG *) 0x0000000C) // Periodic Interval Image Register
#endif
// -------- PIT_MR : (PIT Offset: 0x00) Mode Register --------
#define AT91C_PIT_MR_PIV (0xfffff << 0) // (PIT) Periodic Interval Value
#define AT91C_PIT_MR_PITEN (0x1 << 24) // (PIT) Period Interval Timer Enabled
#define AT91C_PIT_MR_PITIEN (0x1 << 25) // (PIT) Periodic Interval Timer Interrupt Enable
// -------- PIT_SR : (PIT Offset: 0x04) Status Register --------
#define AT91C_PIT_SR_PITS (0x1 << 0) // (PIT) Periodic Interval Timer Status
// -------- PIT_PIVR : (PIT Offset: 0x08) Periodic Interval Value Register --------
#define AT91C_PIT_PIVR_CPIV (0xfffff << 0) // (PIT) Current Periodic Interval Value
#define AT91C_PIT_PIVR_PICNT (0xfff << 20) // (PIT) Periodic Interval Counter
// -------- PIT_PIIR : (PIT Offset: 0x0C) Periodic Interval Image Register --------
#define AT91C_PIT_PIIR_CPIV (0xfffff << 0) // (PIT) Current Periodic Interval Value
#define AT91C_PIT_PIIR_PICNT (0xfff << 20) // (PIT) Periodic Interval Counter

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Power Management Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_PMC {
  AT91_REG PMC_SCER;     // System Clock Enable Register
  AT91_REG PMC_SCDR;     // System Clock Disable Register
  AT91_REG PMC_SCSR;     // System Clock Status Register
  AT91_REG Reserved1[1];
  AT91_REG PMC_PCER;     // Peripheral Clock Enable Register
  AT91_REG PMC_PCDR;     // Peripheral Clock Disable Register
  AT91_REG PMC_PCSR;     // Peripheral Clock Status Register
  AT91_REG CKGR_UCKR;    // UTMI Clock Register
  AT91_REG CKGR_MOR;     // Main Oscillator Register
  AT91_REG CKGR_MCFR;    // Main Clock Frequency Register
  AT91_REG CKGR_PLLAR;   // PLLA Register
  AT91_REG Reserved2[1];
  AT91_REG PMC_MCKR;     // Master Clock Register
  AT91_REG Reserved3[1];
  AT91_REG PMC_USB;      // USB Clock Register
  AT91_REG Reserved4[1];
  AT91_REG PMC_PCK[2];   // Programmable Clock 0 Register
  AT91_REG Reserved5[6];
  AT91_REG PMC_IER;      // Interrupt Enable Register
  AT91_REG PMC_IDR;      // Interrupt Disable Register
  AT91_REG PMC_SR;       // Status Register
  AT91_REG PMC_IMR;      // Interrupt Mask Register
  AT91_REG	 Reserved6[4]; 	//
  AT91_REG	 PMC_PLLICPR; 	// PLL Charge Pump Current Register
} AT91S_PMC, *AT91PS_PMC;
#else
#define PMC_SCER   (AT91_CAST(AT91_REG *) 0x00000000) // System Clock Enable Register
#define PMC_SCDR   (AT91_CAST(AT91_REG *) 0x00000004) // System Clock Disable Register
#define PMC_SCSR   (AT91_CAST(AT91_REG *) 0x00000008) // System Clock Status Register
#define PMC_PCER   (AT91_CAST(AT91_REG *) 0x00000010) // Peripheral Clock Enable Register
#define PMC_PCDR   (AT91_CAST(AT91_REG *) 0x00000014) // Peripheral Clock Disable Register
#define PMC_PCSR   (AT91_CAST(AT91_REG *) 0x00000018) // Peripheral Clock Status Register
#define CKGR_UCKR  (AT91_CAST(AT91_REG *) 0x0000001C) // UTMI Clock Register
#define CKGR_MOR   (AT91_CAST(AT91_REG *) 0x00000020) // Main Oscillator Register
#define CKGR_MCFR  (AT91_CAST(AT91_REG *) 0x00000024) // Main Clock Frequency Register
#define CKGR_PLLAR (AT91_CAST(AT91_REG *) 0x00000028) // PLLA Register
#define PMC_MCKR   (AT91_CAST(AT91_REG *) 0x00000030) // Master Clock Register
#define PMC_USB    (AT91_CAST(AT91_REG *) 0x00000038) // USB Clock Register
#define PMC_PCK    (AT91_CAST(AT91_REG *) 0x00000040) // Programmable Clock 0 Register
#define PMC_IER    (AT91_CAST(AT91_REG *) 0x00000060) // Interrupt Enable Register
#define PMC_IDR    (AT91_CAST(AT91_REG *) 0x00000064) // Interrupt Disable Register
#define PMC_SR     (AT91_CAST(AT91_REG *) 0x00000068) // Status Register
#define PMC_IMR    (AT91_CAST(AT91_REG *) 0x0000006C) // Interrupt Mask Register
#endif
// -------- PMC_SCER : (PMC Offset: 0x0000) System Clock Enable Register --------
#define AT91C_PMC_SCER_DDRCK (0x1 << 2) // (PMC) DDR Clock Enable
#define AT91C_PMC_SCER_UHP (0x1 << 6) // (PMC) USB Host OHCI Clocks Enable
#define AT91C_PMC_SCER_PCK0 (0x1 << 8) // (PMC) Programmable Clock 0 Output Enable
#define AT91C_PMC_SCER_PCK1 (0x1 << 9) // (PMC) Programmable Clock 1 Output Enable
// -------- PMC_SCDR : (PMC Offset: 0x0004) System Clock Disable Register --------
#define AT91C_PMC_SCDR_PCK (0x1 << 0) // (PMC) Processor Clock Disable
#define AT91C_PMC_SCDR_DDRCK (0x1 << 2) // (PMC) DDR Clock Disable
#define AT91C_PMC_SCDR_UHP (0x1 << 6) // (PMC) USB Host OHCI Clock Disable
#define AT91C_PMC_SCDR_PCK0 (0x1 << 8) // (PMC) Programmable Clock 0 Output Disable
#define AT91C_PMC_SCDR_PCK1 (0x1 << 9) // (PMC) Programmable Clock 1 Output Disable
// -------- PMC_SCSR : (PMC Offset: 0x0008) System Clock Status Register --------
#define AT91C_PMC_SCSR_PCK (0x1 << 0) // (PMC) Processor Clock Status
#define AT91C_PMC_SCSR_DDRCK (0x1 << 2) // (PMC) DDR Clock Status
#define AT91C_PMC_SCSR_UHP (0x1 << 6) // (PMC) USB Host Port Clock Status
#define AT91C_PMC_SCSR_PCK0 (0x1 << 8) // (PMC) Programmable Clock 0 Output Status
#define AT91C_PMC_SCSR_PCK1 (0x1 << 9) // (PMC) Programmable Clock 1 Output Status
// -------- PMC_PCER : (PMC Offset: 0x0010) Peripheral Clock Enable Register --------
#define AT91C_PMC_PCER_PID2 (0x1 << 2) // (PMC) Peripheral Clock 2 Enable
#define AT91C_PMC_PCER_PID3 (0x1 << 3) // (PMC) Peripheral Clock 3 Enable
#define AT91C_PMC_PCER_PID4 (0x1 << 4) // (PMC) Peripheral Clock 4 Enable
#define AT91C_PMC_PCER_PID5 (0x1 << 5) // (PMC) Peripheral Clock 5 Enable
#define AT91C_PMC_PCER_PID6 (0x1 << 6) // (PMC) Peripheral Clock 6 Enable
#define AT91C_PMC_PCER_PID7 (0x1 << 7) // (PMC) Peripheral Clock 7 Enable
#define AT91C_PMC_PCER_PID8 (0x1 << 8) // (PMC) Peripheral Clock 8 Enable
#define AT91C_PMC_PCER_PID9 (0x1 << 9) // (PMC) Peripheral Clock 9 Enable
#define AT91C_PMC_PCER_PID10 (0x1 << 10) // (PMC) Peripheral Clock 10 Enable
#define AT91C_PMC_PCER_PID11 (0x1 << 11) // (PMC) Peripheral Clock 11 Enable
#define AT91C_PMC_PCER_PID12 (0x1 << 12) // (PMC) Peripheral Clock 12 Enable
#define AT91C_PMC_PCER_PID13 (0x1 << 13) // (PMC) Peripheral Clock 13 Enable
#define AT91C_PMC_PCER_PID14 (0x1 << 14) // (PMC) Peripheral Clock 14 Enable
#define AT91C_PMC_PCER_PID15 (0x1 << 15) // (PMC) Peripheral Clock 15 Enable
#define AT91C_PMC_PCER_PID16 (0x1 << 16) // (PMC) Peripheral Clock 16 Enable
#define AT91C_PMC_PCER_PID17 (0x1 << 17) // (PMC) Peripheral Clock 17 Enable
#define AT91C_PMC_PCER_PID18 (0x1 << 18) // (PMC) Peripheral Clock 18 Enable
#define AT91C_PMC_PCER_PID19 (0x1 << 19) // (PMC) Peripheral Clock 19 Enable
#define AT91C_PMC_PCER_PID20 (0x1 << 20) // (PMC) Peripheral Clock 20 Enable
#define AT91C_PMC_PCER_PID21 (0x1 << 21) // (PMC) Peripheral Clock 21 Enable
#define AT91C_PMC_PCER_PID22 (0x1 << 22) // (PMC) Peripheral Clock 22 Enable
#define AT91C_PMC_PCER_PID23 (0x1 << 23) // (PMC) Peripheral Clock 23 Enable
#define AT91C_PMC_PCER_PID24 (0x1 << 24) // (PMC) Peripheral Clock 24 Enable
#define AT91C_PMC_PCER_PID25 (0x1 << 25) // (PMC) Peripheral Clock 25 Enable
#define AT91C_PMC_PCER_PID26 (0x1 << 26) // (PMC) Peripheral Clock 26 Enable
#define AT91C_PMC_PCER_PID27 (0x1 << 27) // (PMC) Peripheral Clock 27 Enable
#define AT91C_PMC_PCER_PID28 (0x1 << 28) // (PMC) Peripheral Clock 28 Enable
#define AT91C_PMC_PCER_PID29 (0x1 << 29) // (PMC) Peripheral Clock 29 Enable
#define AT91C_PMC_PCER_PID30 (0x1 << 30) // (PMC) Peripheral Clock 30 Enable
#define AT91C_PMC_PCER_PID31 (0x1 << 31) // (PMC) Peripheral Clock 31 Enable
// -------- PMC_PCDR : (PMC Offset: 0x0014) Peripheral Clock Disable Register --------
#define AT91C_PMC_PCDR_PID2 (0x1 << 2) // (PMC) Peripheral Clock 2 Disable
#define AT91C_PMC_PCDR_PID3 (0x1 << 3) // (PMC) Peripheral Clock 3 Disable
#define AT91C_PMC_PCDR_PID4 (0x1 << 4) // (PMC) Peripheral Clock 4 Disable
#define AT91C_PMC_PCDR_PID5 (0x1 << 5) // (PMC) Peripheral Clock 5 Disable
#define AT91C_PMC_PCDR_PID6 (0x1 << 6) // (PMC) Peripheral Clock 6 Disable
#define AT91C_PMC_PCDR_PID7 (0x1 << 7) // (PMC) Peripheral Clock 7 Disable
#define AT91C_PMC_PCDR_PID8 (0x1 << 8) // (PMC) Peripheral Clock 8 Disable
#define AT91C_PMC_PCDR_PID9 (0x1 << 9) // (PMC) Peripheral Clock 9 Disable
#define AT91C_PMC_PCDR_PID10 (0x1 << 10) // (PMC) Peripheral Clock 10 Disable
#define AT91C_PMC_PCDR_PID11 (0x1 << 11) // (PMC) Peripheral Clock 11 Disable
#define AT91C_PMC_PCDR_PID12 (0x1 << 12) // (PMC) Peripheral Clock 12 Disable
#define AT91C_PMC_PCDR_PID13 (0x1 << 13) // (PMC) Peripheral Clock 13 Disable
#define AT91C_PMC_PCDR_PID14 (0x1 << 14) // (PMC) Peripheral Clock 14 Disable
#define AT91C_PMC_PCDR_PID15 (0x1 << 15) // (PMC) Peripheral Clock 15 Disable
#define AT91C_PMC_PCDR_PID16 (0x1 << 16) // (PMC) Peripheral Clock 16 Disable
#define AT91C_PMC_PCDR_PID17 (0x1 << 17) // (PMC) Peripheral Clock 17 Disable
#define AT91C_PMC_PCDR_PID18 (0x1 << 18) // (PMC) Peripheral Clock 18 Disable
#define AT91C_PMC_PCDR_PID19 (0x1 << 19) // (PMC) Peripheral Clock 19 Disable
#define AT91C_PMC_PCDR_PID20 (0x1 << 20) // (PMC) Peripheral Clock 20 Disable
#define AT91C_PMC_PCDR_PID21 (0x1 << 21) // (PMC) Peripheral Clock 21 Disable
#define AT91C_PMC_PCDR_PID22 (0x1 << 22) // (PMC) Peripheral Clock 22 Disable
#define AT91C_PMC_PCDR_PID23 (0x1 << 23) // (PMC) Peripheral Clock 23 Disable
#define AT91C_PMC_PCDR_PID24 (0x1 << 24) // (PMC) Peripheral Clock 24 Disable
#define AT91C_PMC_PCDR_PID25 (0x1 << 25) // (PMC) Peripheral Clock 25 Disable
#define AT91C_PMC_PCDR_PID26 (0x1 << 26) // (PMC) Peripheral Clock 26 Disable
#define AT91C_PMC_PCDR_PID27 (0x1 << 27) // (PMC) Peripheral Clock 27 Disable
#define AT91C_PMC_PCDR_PID28 (0x1 << 28) // (PMC) Peripheral Clock 28 Disable
#define AT91C_PMC_PCDR_PID29 (0x1 << 29) // (PMC) Peripheral Clock 29 Disable
#define AT91C_PMC_PCDR_PID30 (0x1 << 30) // (PMC) Peripheral Clock 30 Disable
#define AT91C_PMC_PCDR_PID31 (0x1 << 31) // (PMC) Peripheral Clock 31 Disable
// -------- PMC_PCSR : (PMC Offset: 0x0018) Peripheral Clock Status Register --------
#define AT91C_PMC_PCSR_PID2 (0x1 << 2) // (PMC) Peripheral Clock 2 Status
#define AT91C_PMC_PCSR_PID3 (0x1 << 3) // (PMC) Peripheral Clock 3 Status
#define AT91C_PMC_PCSR_PID4 (0x1 << 4) // (PMC) Peripheral Clock 4 Status
#define AT91C_PMC_PCSR_PID5 (0x1 << 5) // (PMC) Peripheral Clock 5 Status
#define AT91C_PMC_PCSR_PID6 (0x1 << 6) // (PMC) Peripheral Clock 6 Status
#define AT91C_PMC_PCSR_PID7 (0x1 << 7) // (PMC) Peripheral Clock 7 Status
#define AT91C_PMC_PCSR_PID8 (0x1 << 8) // (PMC) Peripheral Clock 8 Status
#define AT91C_PMC_PCSR_PID9 (0x1 << 9) // (PMC) Peripheral Clock 9 Status
#define AT91C_PMC_PCSR_PID10 (0x1 << 10) // (PMC) Peripheral Clock 10 Status
#define AT91C_PMC_PCSR_PID11 (0x1 << 11) // (PMC) Peripheral Clock 11 Status
#define AT91C_PMC_PCSR_PID12 (0x1 << 12) // (PMC) Peripheral Clock 12 Status
#define AT91C_PMC_PCSR_PID13 (0x1 << 13) // (PMC) Peripheral Clock 13 Status
#define AT91C_PMC_PCSR_PID14 (0x1 << 14) // (PMC) Peripheral Clock 14 Status
#define AT91C_PMC_PCSR_PID15 (0x1 << 15) // (PMC) Peripheral Clock 15 Status
#define AT91C_PMC_PCSR_PID16 (0x1 << 16) // (PMC) Peripheral Clock 16 Status
#define AT91C_PMC_PCSR_PID17 (0x1 << 17) // (PMC) Peripheral Clock 17 Status
#define AT91C_PMC_PCSR_PID18 (0x1 << 18) // (PMC) Peripheral Clock 18 Status
#define AT91C_PMC_PCSR_PID19 (0x1 << 19) // (PMC) Peripheral Clock 19 Status
#define AT91C_PMC_PCSR_PID20 (0x1 << 20) // (PMC) Peripheral Clock 20 Status
#define AT91C_PMC_PCSR_PID21 (0x1 << 21) // (PMC) Peripheral Clock 21 Status
#define AT91C_PMC_PCSR_PID22 (0x1 << 22) // (PMC) Peripheral Clock 22 Status
#define AT91C_PMC_PCSR_PID23 (0x1 << 23) // (PMC) Peripheral Clock 23 Status
#define AT91C_PMC_PCSR_PID24 (0x1 << 24) // (PMC) Peripheral Clock 24 Status
#define AT91C_PMC_PCSR_PID25 (0x1 << 25) // (PMC) Peripheral Clock 25 Status
#define AT91C_PMC_PCSR_PID26 (0x1 << 26) // (PMC) Peripheral Clock 26 Status
#define AT91C_PMC_PCSR_PID27 (0x1 << 27) // (PMC) Peripheral Clock 27 Status
#define AT91C_PMC_PCSR_PID28 (0x1 << 28) // (PMC) Peripheral Clock 28 Status
#define AT91C_PMC_PCSR_PID29 (0x1 << 29) // (PMC) Peripheral Clock 29 Status
#define AT91C_PMC_PCSR_PID30 (0x1 << 30) // (PMC) Peripheral Clock 30 Status
#define AT91C_PMC_PCSR_PID31 (0x1 << 31) // (PMC) Peripheral Clock 31 Status
// -------- CKGR_UCKR : (PMC Offset: 0x001C) UTMI Clock Register --------
#define AT91C_CKGR_UCKR_UPLLEN (0x1 << 16) // (PMC) UTMI PLL Enable
#define AT91C_CKGR_UCKR_PLLCOUNT (0xf << 20) // (PMC) UTMI PLL Start-up Time
#define AT91C_CKGR_UCKR_BIASEN (0x1 << 24) // (PMC) UTMI BIAS Enable
#define AT91C_CKGR_UCKR_BIASCOUNT (0xf << 28) // (PMC) UTMI BIAS Start-up Time
// -------- CKGR_MOR : (PMC Offset: 0x0020) Main Oscillator Register --------
#define AT91C_CKGR_MOR_MOSCEN (0x1 << 0) // (PMC) Main Oscillator Enable
#define AT91C_CKGR_MOR_OSCBYPASS (0x1 << 1) // (PMC) Oscillator Bypass
#define AT91C_CKGR_MOR_OSCOUNT (0xff << 8) // (PMC) Main Oscillator Start-up Time
// -------- CKGR_MCFR : (PMC Offset: 0x0024) Main Clock Frequency Register --------
#define AT91C_CKGR_MCFR_MAINF (0xffff << 0) // (PMC) Main Clock Frequency
#define AT91C_CKGR_MCFR_MAINRDY (0x1 << 16) // (PMC) Main Clock Ready
// -------- CKGR_PLLAR : (PMC Offset: 0x0028) PLLA Register --------
#define AT91C_CKGR_PLLAR_DIVA (0xff << 0) // (PMC) Divider A
#define AT91C_CKGR_PLLAR_PLLACOUNT (0x3f << 8) // (PMC) PLLA Counter
#define AT91C_CKGR_PLLAR_OUTA (0x3 << 14) // (PMC) PLLA Clock Frequency Range
#define     AT91C_CKGR_PLLAR_OUTA_0                    (0x0 << 14) // (PMC) Please refer to the PLLA datasheet
#define     AT91C_CKGR_PLLAR_OUTA_1                    (0x1 << 14) // (PMC) Please refer to the PLLA datasheet
#define     AT91C_CKGR_PLLAR_OUTA_2                    (0x2 << 14) // (PMC) Please refer to the PLLA datasheet
#define     AT91C_CKGR_PLLAR_OUTA_3                    (0x3 << 14) // (PMC) Please refer to the PLLA datasheet
#define AT91C_CKGR_PLLAR_MULA (0xff << 16) // (PMC) PLLA Multiplier
#define AT91C_CKGR_PLLAR_STUCKTO1 (0x1 << 29) // (PMC)
// -------- PMC_MCKR : (PMC Offset: 0x0030) Master Clock Register --------
#define AT91C_PMC_MCKR_CSS (0x3 << 0) // (PMC) Master/Processor Clock Source Selection
#define   AT91C_PMC_MCKR_CSS_SLOW_CLK (0x0 << 0) // (PMC) Slow Clock is selected.
#define   AT91C_PMC_MCKR_CSS_MAIN_CLK (0x1 << 0) // (PMC) Main Clock is selected.
#define   AT91C_PMC_MCKR_CSS_PLLA_CLK (0x2 << 0) // (PMC) PLLA Clock is selected.
#define   AT91C_PMC_MCKR_CSS_PLLB_CLK (0x3 << 0) // (PMC) UPLL Clock is selected.
#define AT91C_PMC_MCKR_PRES (0x7 << 2) // (PMC) Master/Processor Clock Prescaler
#define   AT91C_PMC_MCKR_PRES_CLK (0x0 << 2) // (PMC) Selected clock
#define   AT91C_PMC_MCKR_PRES_CLK_2 (0x1 << 2) // (PMC) Selected clock divided by 2
#define   AT91C_PMC_MCKR_PRES_CLK_4 (0x2 << 2) // (PMC) Selected clock divided by 4
#define   AT91C_PMC_MCKR_PRES_CLK_8 (0x3 << 2) // (PMC) Selected clock divided by 8
#define   AT91C_PMC_MCKR_PRES_CLK_16 (0x4 << 2) // (PMC) Selected clock divided by 16
#define   AT91C_PMC_MCKR_PRES_CLK_32 (0x5 << 2) // (PMC) Selected clock divided by 32
#define   AT91C_PMC_MCKR_PRES_CLK_64 (0x6 << 2) // (PMC) Selected clock divided by 64
#define AT91C_PMC_MCKR_MDIV (0x3 << 8) // (PMC) Master Clock Division
#define   AT91C_PMC_MCKR_MDIV_1 (0x0 << 8) // (PMC) Master Clock is Prescaler Output Clock divided by 1.SysClk DDR is equal to MCK.
#define   AT91C_PMC_MCKR_MDIV_2 (0x1 << 8) // (PMC) Master Clock is Prescaler Output Clock divided by 2.SysClk DDR is equal to 2 x MCK.
#define   AT91C_PMC_MCKR_MDIV_4 (0x2 << 8) // (PMC) Master Clock is Prescaler Output Clock divided by 4.SysClk DDR is equal to 2 x MCK.
#define   AT91C_PMC_MCKR_MDIV_3 (0x3 << 8) // (PMC) Processor clock = 3 * Master Clock ; DDR Clock = 2 * Master Clock
#define AT91C_PMC_MCKR_PLLADIV2 (0x1 << 12) // (PMC) PLLA divisor by 2
// -------- PMC_USB : (PMC Offset: 0x0038) USB Clock Register --------
#define AT91C_PMC_USB_USBS (0x1 << 0) // (PMC) USB OHCI Input clock selection
#define AT91C_PMC_USB_USBDIV (0xf << 8) // (PMC) Divider for USB OHCI Clock.
// -------- PMC_PCK[2] : (PMC Offset: 0x0040) Programmable Clock 0 Register --------
#define AT91C_PMC_PCK_CSS (0x3 << 0) // (PMC) Master Clock Selection
#define AT91C_PMC_PCK_PRES (0x7 << 2) // (PMC) Programmable Clock Prescaler
#define AT91C_PMC_PCK_SLCKMCK (0x1 << 8) // (PMC) Slow Clock or Master Clock Selection
// -------- PMC_IER : (PMC Offset: 0x0060) Interrupt Enable Register --------
#define AT91C_PMC_IER_MOSCS (0x1 << 0) // (PMC) Main Oscillator Status Interrupt Enable
#define AT91C_PMC_IER_LOCKA (0x1 << 1) // (PMC) PLL Lock Interrupt Enable
#define AT91C_PMC_IER_MCKRDY (0x1 << 3) // (PMC) Master Clock Ready Interrupt Enable
#define AT91C_PMC_IER_LOCKU (0x1 << 6) // (PMC) UTMI PLL Lock Interrupt Enable
#define AT91C_PMC_IER_PCKRDY0 (0x1 << 8) // (PMC) Programmable Clock Ready 0 Interrupt Enable
#define AT91C_PMC_IER_PCKRDY1 (0x1 << 9) // (PMC) Programmable Clock Ready 1 Interrupt Enable
// -------- PMC_IDR : (PMC Offset: 0x0064) Interrupt Disable Register --------
#define AT91C_PMC_IDR_MOSCS (0x1 << 0) // (PMC) Main Oscillator Status Interrupt Disable
#define AT91C_PMC_IDR_LOCKA (0x1 << 1) // (PMC) PLLA Lock Interrupt Disable
#define AT91C_PMC_IDR_MCKRDY (0x1 << 3) // (PMC) Master Clock Ready Interrupt Disable
#define AT91C_PMC_IDR_LOCKU (0x1 << 6) // (PMC) UTMI PLL Lock Interrupt Disable
#define AT91C_PMC_IDR_PCKRDY0 (0x1 << 8) // (PMC) Programmable Clock Ready 0 Interrupt Disable
#define AT91C_PMC_IDR_PCKRDY1 (0x1 << 9) // (PMC) Programmable Clock Ready 1 Interrupt Disable
// -------- PMC_SR : (PMC Offset: 0x0068) Status Register --------
#define AT91C_PMC_SR_MOSCS (0x1 << 0) // (PMC) MOSCS Flag Status
#define AT91C_PMC_SR_LOCKA (0x1 << 1) // (PMC) PLLA Lock Status
#define AT91C_PMC_SR_MCKRDY (0x1 << 3) // (PMC) Master Clock Status
#define AT91C_PMC_SR_LOCKU (0x1 << 6) // (PMC) UPLL Lock Status
#define AT91C_PMC_SR_PCKRDY0 (0x1 << 8) // (PMC) Programmable Clock Ready Status
#define AT91C_PMC_SR_PCKRDY1 (0x1 << 9) // (PMC) Programmable Clock Ready Status
// -------- PMC_IMR : (PMC Offset: 0x006C) Interrupt Mask Register --------
#define AT91C_PMC_IMR_MOSCS (0x1 << 0) // (PMC) Main Oscillator Status Interrupt Mask
#define AT91C_PMC_IMR_LOCKA (0x1 << 1) // (PMC) PLLA Lock Interrupt Mask
#define AT91C_PMC_IMR_MCKRDY (0x1 << 3) // (PMC) Master Clock Ready Interrupt Mask
#define AT91C_PMC_IMR_LOCKU (0x1 << 6) // (PMC) UTMI PLL Lock Interrupt Mask
#define AT91C_PMC_IMR_PCKRDY0 (0x1 << 8) // (PMC) Programmable Clock Ready 0 Interrupt Mask
#define AT91C_PMC_IMR_PCKRDY1 (0x1 << 9) // (PMC) Programmable Clock Ready 1 Interrupt Mask
// -------- PMC_PLLICPR : (PMC Offset: 0x80) PLL Charge Pump Current Register --------
#define AT91C_PMC_ICPPLLA     (0xF <<  0) // (PMC) PLLA charge pump current setting
#define 	AT91C_PMC_ICPPLLA_0                    (0x0) // (PMC) 595-800 MHz
#define 	AT91C_PMC_ICPPLLA_1                    (0x1) // (PMC) 395-600 MHz
#define AT91C_PMC_REALLOCK    (0x1 <<  7) // (PMC) PLLs use real lock signals when 1
#define AT91C_PMC_IPLLA       (0xF <<  8) // (PMC) PLLA special setting
#define 	AT91C_PMC_IPLLA_0                    (0x0 <<  8) // (PMC) Internal LFT
#define 	AT91C_PMC_IPLLA_1                    (0x1 <<  8) // (PMC) External LFT

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Pulse Width Modulation Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_PWM {
  AT91_REG PWM_MR;         // PWM Mode Register
  AT91_REG PWM_ENA;        // PWM Enable Register
  AT91_REG PWM_DIS;        // PWM Disable Register
  AT91_REG PWM_SR;         // PWM Status Register
  AT91_REG PWM_IER;        // PWM Interrupt Enable Register
  AT91_REG PWM_IDR;        // PWM Interrupt Disable Register
  AT91_REG PWM_IMR;        // PWM Interrupt Mask Register
  AT91_REG PWM_ISR;        // PWM Interrupt Status Register
  AT91_REG Reserved1[120];
  AT91_REG PWM_CMR0;       // PWM Channel Mode Register (ch_num = 0)
  AT91_REG PWM_CDTY0;      // PWM Channel Duty Cycle Register (ch_num = 0)
  AT91_REG PWM_CPRD0;      // PWM Channel Period Register (ch_num = 0)
  AT91_REG PWM_CCNT0;      // PWM Channel Counter Register (ch_num = 0)
  AT91_REG PWM_CUPD0;      // PWM Channel Update Register (ch_num = 0)
  AT91_REG Reserved2[3];
  AT91_REG PWM_CMR1;       // PWM Channel Mode Register (ch_num = 1)
  AT91_REG PWM_CDTY1;      // PWM Channel Duty Cycle Register (ch_num = 1)
  AT91_REG PWM_CPRD1;      // PWM Channel Period Register (ch_num = 1)
  AT91_REG PWM_CCNT1;      // PWM Channel Counter Register (ch_num = 1)
  AT91_REG PWM_CUPD1;      // PWM Channel Update Register (ch_num = 1)
  AT91_REG Reserved3[3];
  AT91_REG PWM_CMR2;       // PWM Channel Mode Register (ch_num = 2)
  AT91_REG PWM_CDTY2;      // PWM Channel Duty Cycle Register (ch_num = 2)
  AT91_REG PWM_CPRD2;      // PWM Channel Period Register (ch_num = 2)
  AT91_REG PWM_CCNT2;      // PWM Channel Counter Register (ch_num = 2)
  AT91_REG PWM_CUPD2;      // PWM Channel Update Register (ch_num = 2)
  AT91_REG Reserved4[3];
  AT91_REG PWM_CMR3;       // PWM Channel Mode Register (ch_num = 3)
  AT91_REG PWM_CDTY3;      // PWM Channel Duty Cycle Register (ch_num = 3)
  AT91_REG PWM_CPRD3;      // PWM Channel Period Register (ch_num = 3)
  AT91_REG PWM_CCNT3;      // PWM Channel Counter Register (ch_num = 3)
  AT91_REG PWM_CUPD3;      // PWM Channel Update Register (ch_num = 3)
} AT91S_PWM, *AT91PS_PWM;
#else
#define PWM_MR    (AT91_CAST(AT91_REG *) 0x00000000) // PWM Mode Register
#define PWM_ENA   (AT91_CAST(AT91_REG *) 0x00000004) // PWM Enable Register
#define PWM_DIS   (AT91_CAST(AT91_REG *) 0x00000008) // PWM Disable Register
#define PWM_SR    (AT91_CAST(AT91_REG *) 0x0000000C) // PWM Status Register
#define PWM_IER   (AT91_CAST(AT91_REG *) 0x00000010) // PWM Interrupt Enable Register
#define PWM_IDR   (AT91_CAST(AT91_REG *) 0x00000014) // PWM Interrupt Disable Register
#define PWM_IMR   (AT91_CAST(AT91_REG *) 0x00000018) // PWM Interrupt Mask Register
#define PWM_ISR   (AT91_CAST(AT91_REG *) 0x0000001C) // PWM Interrupt Status Register
#define PWM_CMR0  (AT91_CAST(AT91_REG *) 0x00000200) // PWM Channel Mode Register (ch_num = 0)
#define PWM_CDTY0 (AT91_CAST(AT91_REG *) 0x00000204) // PWM Channel Duty Cycle Register (ch_num = 0)
#define PWM_CPRD0 (AT91_CAST(AT91_REG *) 0x00000208) // PWM Channel Period Register (ch_num = 0)
#define PWM_CCNT0 (AT91_CAST(AT91_REG *) 0x0000020C) // PWM Channel Counter Register (ch_num = 0)
#define PWM_CUPD0 (AT91_CAST(AT91_REG *) 0x00000210) // PWM Channel Update Register (ch_num = 0)
#define PWM_CMR1  (AT91_CAST(AT91_REG *) 0x00000220) // PWM Channel Mode Register (ch_num = 1)
#define PWM_CDTY1 (AT91_CAST(AT91_REG *) 0x00000224) // PWM Channel Duty Cycle Register (ch_num = 1)
#define PWM_CPRD1 (AT91_CAST(AT91_REG *) 0x00000228) // PWM Channel Period Register (ch_num = 1)
#define PWM_CCNT1 (AT91_CAST(AT91_REG *) 0x0000022C) // PWM Channel Counter Register (ch_num = 1)
#define PWM_CUPD1 (AT91_CAST(AT91_REG *) 0x00000230) // PWM Channel Update Register (ch_num = 1)
#define PWM_CMR2  (AT91_CAST(AT91_REG *) 0x00000240) // PWM Channel Mode Register (ch_num = 2)
#define PWM_CDTY2 (AT91_CAST(AT91_REG *) 0x00000244) // PWM Channel Duty Cycle Register (ch_num = 2)
#define PWM_CPRD2 (AT91_CAST(AT91_REG *) 0x00000248) // PWM Channel Period Register (ch_num = 2)
#define PWM_CCNT2 (AT91_CAST(AT91_REG *) 0x0000024C) // PWM Channel Counter Register (ch_num = 2)
#define PWM_CUPD2 (AT91_CAST(AT91_REG *) 0x00000250) // PWM Channel Update Register (ch_num = 2)
#define PWM_CMR3  (AT91_CAST(AT91_REG *) 0x00000260) // PWM Channel Mode Register (ch_num = 3)
#define PWM_CDTY3 (AT91_CAST(AT91_REG *) 0x00000264) // PWM Channel Duty Cycle Register (ch_num = 3)
#define PWM_CPRD3 (AT91_CAST(AT91_REG *) 0x00000268) // PWM Channel Period Register (ch_num = 3)
#define PWM_CCNT3 (AT91_CAST(AT91_REG *) 0x0000026C) // PWM Channel Counter Register (ch_num = 3)
#define PWM_CUPD3 (AT91_CAST(AT91_REG *) 0x00000270) // PWM Channel Update Register (ch_num = 3)
#endif
// -------- PWM_MR : (PWM Offset: 0x00) PWM Mode Register --------
#define AT91C_PWM_MR_DIVA (0xff << 0) // (PWM) CLKA, CLKB Divide Factor
#define AT91C_PWM_MR_PREA (0xf << 8) // (PWM)
#define   AT91C_PWM_MR_PREA_MCK (0x0 << 8) // (PWM) MCK.
#define AT91C_PWM_MR_DIVB (0xff << 16) // (PWM) CLKA, CLKB Divide Factor
#define AT91C_PWM_MR_PREB (0xf << 24) // (PWM)
#define   AT91C_PWM_MR_PREB_MCK (0x0 << 24) // (PWM) MCK.
// -------- PWM_ENA : (PWM Offset: 0x04) PWM Enable Register --------
#define AT91C_PWM_ENA_CHID0 (0x1 << 0) // (PWM) Channel ID
#define AT91C_PWM_ENA_CHID1 (0x1 << 1) // (PWM) Channel ID
#define AT91C_PWM_ENA_CHID2 (0x1 << 2) // (PWM) Channel ID
#define AT91C_PWM_ENA_CHID3 (0x1 << 3) // (PWM) Channel ID
// -------- PWM_DIS : (PWM Offset: 0x08) PWM Disable Register --------
#define AT91C_PWM_DIS_CHID0 (0x1 << 0) // (PWM) Channel ID
#define AT91C_PWM_DIS_CHID1 (0x1 << 1) // (PWM) Channel ID
#define AT91C_PWM_DIS_CHID2 (0x1 << 2) // (PWM) Channel ID
#define AT91C_PWM_DIS_CHID3 (0x1 << 3) // (PWM) Channel ID
// -------- PWM_SR : (PWM Offset: 0x0C) PWM Status Register --------
#define AT91C_PWM_SR_CHID0 (0x1 << 0) // (PWM) Channel ID
#define AT91C_PWM_SR_CHID1 (0x1 << 1) // (PWM) Channel ID
#define AT91C_PWM_SR_CHID2 (0x1 << 2) // (PWM) Channel ID
#define AT91C_PWM_SR_CHID3 (0x1 << 3) // (PWM) Channel ID
// -------- PWM_IER : (PWM Offset: 0x10) PWM Interrupt Enable Register --------
#define AT91C_PWM_IER_CHID0 (0x1 << 0) // (PWM) Channel ID.
#define AT91C_PWM_IER_CHID1 (0x1 << 1) // (PWM) Channel ID.
#define AT91C_PWM_IER_CHID2 (0x1 << 2) // (PWM) Channel ID.
#define AT91C_PWM_IER_CHID3 (0x1 << 3) // (PWM) Channel ID.
// -------- PWM_IDR : (PWM Offset: 0x14) PWM Interrupt Disable Register --------
#define AT91C_PWM_IDR_CHID0 (0x1 << 0) // (PWM) Channel ID.
#define AT91C_PWM_IDR_CHID1 (0x1 << 1) // (PWM) Channel ID.
#define AT91C_PWM_IDR_CHID2 (0x1 << 2) // (PWM) Channel ID.
#define AT91C_PWM_IDR_CHID3 (0x1 << 3) // (PWM) Channel ID.
// -------- PWM_IMR : (PWM Offset: 0x18) PWM Interrupt Mask Register --------
#define AT91C_PWM_IMR_CHID0 (0x1 << 0) // (PWM) Channel ID.
#define AT91C_PWM_IMR_CHID1 (0x1 << 1) // (PWM) Channel ID.
#define AT91C_PWM_IMR_CHID2 (0x1 << 2) // (PWM) Channel ID.
#define AT91C_PWM_IMR_CHID3 (0x1 << 3) // (PWM) Channel ID.
// -------- PWM_ISR : (PWM Offset: 0x1C) PWM Interrupt Status Register --------
#define AT91C_PWM_ISR_CHID0 (0x1 << 0) // (PWM) Channel ID
#define AT91C_PWM_ISR_CHID1 (0x1 << 1) // (PWM) Channel ID
#define AT91C_PWM_ISR_CHID2 (0x1 << 2) // (PWM) Channel ID
#define AT91C_PWM_ISR_CHID3 (0x1 << 3) // (PWM) Channel ID
// -------- PWM_CMR0 : (PWM Offset: 0x200) PWM Channel Mode Register (ch_num = 0) --------
#define AT91C_PWM_CMR0_CPRE (0xf << 0) // (PWM) Channel Pre-scaler
#define AT91C_PWM_CMR0_CALG (0x1 << 8) // (PWM) Channel Alignment
#define AT91C_PWM_CMR0_CPOL (0x1 << 9) // (PWM) Channel Polarity
#define AT91C_PWM_CMR0_CPD (0x1 << 10) // (PWM) Channel Update Period
// -------- PWM_CDTY0 : (PWM Offset: 0x204) PWM Channel Duty Cycle Register (ch_num = 0) --------
#define AT91C_PWM_CDTY0_CDTY (0xffffffff << 0) // (PWM) Channel Duty Cycle
// -------- PWM_CPRD0 : (PWM Offset: 0x208) PWM Channel Period Register (ch_num = 0) --------
#define AT91C_PWM_CPRD0_CPRD (0xffffffff << 0) // (PWM) Channel Period
// -------- PWM_CCNT0 : (PWM Offset: 0x20C) PWM Channel Counter Register (ch_num = 0) --------
#define AT91C_PWM_CCNT0_CNT (0xffffffff << 0) // (PWM) Channel Counter Register
// -------- PWM_CUPD0 : (PWM Offset: 0x210) PWM Channel Update Register (ch_num = 0) --------
#define AT91C_PWM_CUPD0_CUPD (0xffffffff << 0) // (PWM)
// -------- PWM_CMR1 : (PWM Offset: 0x220) PWM Channel Mode Register (ch_num = 1) --------
#define AT91C_PWM_CMR1_CPRE (0xf << 0) // (PWM) Channel Pre-scaler
#define AT91C_PWM_CMR1_CALG (0x1 << 8) // (PWM) Channel Alignment
#define AT91C_PWM_CMR1_CPOL (0x1 << 9) // (PWM) Channel Polarity
#define AT91C_PWM_CMR1_CPD (0x1 << 10) // (PWM) Channel Update Period
// -------- PWM_CDTY1 : (PWM Offset: 0x224) PWM Channel Duty Cycle Register (ch_num = 1) --------
#define AT91C_PWM_CDTY1_CDTY (0xffffffff << 0) // (PWM) Channel Duty Cycle
// -------- PWM_CPRD1 : (PWM Offset: 0x228) PWM Channel Period Register (ch_num = 1) --------
#define AT91C_PWM_CPRD1_CPRD (0xffffffff << 0) // (PWM) Channel Period
// -------- PWM_CCNT1 : (PWM Offset: 0x22C) PWM Channel Counter Register (ch_num = 1) --------
#define AT91C_PWM_CCNT1_CNT (0xffffffff << 0) // (PWM) Channel Counter Register
// -------- PWM_CUPD1 : (PWM Offset: 0x230) PWM Channel Update Register (ch_num = 1) --------
#define AT91C_PWM_CUPD1_CUPD (0xffffffff << 0) // (PWM)
// -------- PWM_CMR2 : (PWM Offset: 0x240) PWM Channel Mode Register (ch_num = 2) --------
#define AT91C_PWM_CMR2_CPRE (0xf << 0) // (PWM) Channel Pre-scaler
#define AT91C_PWM_CMR2_CALG (0x1 << 8) // (PWM) Channel Alignment
#define AT91C_PWM_CMR2_CPOL (0x1 << 9) // (PWM) Channel Polarity
#define AT91C_PWM_CMR2_CPD (0x1 << 10) // (PWM) Channel Update Period
// -------- PWM_CDTY2 : (PWM Offset: 0x244) PWM Channel Duty Cycle Register (ch_num = 2) --------
#define AT91C_PWM_CDTY2_CDTY (0xffffffff << 0) // (PWM) Channel Duty Cycle
// -------- PWM_CPRD2 : (PWM Offset: 0x248) PWM Channel Period Register (ch_num = 2) --------
#define AT91C_PWM_CPRD2_CPRD (0xffffffff << 0) // (PWM) Channel Period
// -------- PWM_CCNT2 : (PWM Offset: 0x24C) PWM Channel Counter Register (ch_num = 2) --------
#define AT91C_PWM_CCNT2_CNT (0xffffffff << 0) // (PWM) Channel Counter Register
// -------- PWM_CUPD2 : (PWM Offset: 0x250) PWM Channel Update Register (ch_num = 2) --------
#define AT91C_PWM_CUPD2_CUPD (0xffffffff << 0) // (PWM)
// -------- PWM_CMR3 : (PWM Offset: 0x260) PWM Channel Mode Register (ch_num = 3) --------
#define AT91C_PWM_CMR3_CPRE (0xf << 0) // (PWM) Channel Pre-scaler
#define AT91C_PWM_CMR3_CALG (0x1 << 8) // (PWM) Channel Alignment
#define AT91C_PWM_CMR3_CPOL (0x1 << 9) // (PWM) Channel Polarity
#define AT91C_PWM_CMR3_CPD (0x1 << 10) // (PWM) Channel Update Period
// -------- PWM_CDTY3 : (PWM Offset: 0x264) PWM Channel Duty Cycle Register (ch_num = 3) --------
#define AT91C_PWM_CDTY3_CDTY (0xffffffff << 0) // (PWM) Channel Duty Cycle
// -------- PWM_CPRD3 : (PWM Offset: 0x268) PWM Channel Period Register (ch_num = 3) --------
#define AT91C_PWM_CPRD3_CPRD (0xffffffff << 0) // (PWM) Channel Period
// -------- PWM_CCNT3 : (PWM Offset: 0x26C) PWM Channel Counter Register (ch_num = 3) --------
#define AT91C_PWM_CCNT3_CNT (0xffffffff << 0) // (PWM) Channel Counter Register
// -------- PWM_CUPD3 : (PWM Offset: 0x270) PWM Channel Update Register (ch_num = 3) --------
#define AT91C_PWM_CUPD3_CUPD (0xffffffff << 0) // (PWM)

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Reset Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_RSTC {
  AT91_REG RSTC_CR; // Control Register
  AT91_REG RSTC_SR; // Status Register
  AT91_REG RSTC_MR; // Mode Register
} AT91S_RSTC, *AT91PS_RSTC;
#else
#define RSTC_CR (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define RSTC_SR (AT91_CAST(AT91_REG *) 0x00000004) // Status Register
#define RSTC_MR (AT91_CAST(AT91_REG *) 0x00000008) // Mode Register
#endif
// -------- RSTC_CR : (RSTC Offset: 0x00) Control Register --------
#define AT91C_RSTC_CR_PROCRST (0x1 << 0) // (RSTC) Processor Reset
#define AT91C_RSTC_CR_PERRST (0x1 << 2) // (RSTC) Peripheral Reset
#define AT91C_RSTC_CR_EXTRST (0x1 << 3) // (RSTC) External Reset
#define AT91C_RSTC_CR_KEY (0xff << 24) // (RSTC) Password
// -------- RSTC_SR : (RSTC Offset: 0x04) Status Register --------
#define AT91C_RSTC_SR_URSTS (0x1 << 0) // (RSTC) User Reset Status
#define AT91C_RSTC_SR_RSTTYP (0x7 << 8) // (RSTC) Reset Type
#define AT91C_RSTC_SR_NRSTL (0x1 << 16) // (RSTC) NRST Pin Level
#define AT91C_RSTC_SR_SRCMP (0x1 << 17) // (RSTC) Software Reset Command in Progress
// -------- RSTC_MR : (RSTC Offset: 0x08) Mode Register --------
#define AT91C_RSTC_MR_URSTEN (0x1 << 0) // (RSTC) User Reset Enable
#define AT91C_RSTC_MR_URSTIEN (0x1 << 4) // (RSTC) User Reset Interrupt Enable
#define AT91C_RSTC_MR_ERSTL (0xf << 8) // (RSTC) External Reset Length
#define AT91C_RSTC_MR_KEY (0xff << 24) // (RSTC) Password

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Real-time Clock
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_RTC {
  AT91_REG RTC_CR;     // Control Register
  AT91_REG RTC_MR;     // Mode Register
  AT91_REG RTC_TIMR;   // Time Register
  AT91_REG RTC_CALR;   // Calendar Register
  AT91_REG RTC_TIMALR; // Time Alarm Register
  AT91_REG RTC_CALALR; // Calendar Alarm Register
  AT91_REG RTC_SR;     // Status Register
  AT91_REG RTC_SCCR;   // Status Clear Command Register
  AT91_REG RTC_IER;    // Interrupt Enable Register
  AT91_REG RTC_IDR;    // Interrupt Disable Register
  AT91_REG RTC_IMR;    // Interrupt Mask Register
  AT91_REG RTC_VER;    // Valid Entry Register
} AT91S_RTC, *AT91PS_RTC;
#else
#define RTC_CR     (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define RTC_MR     (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define RTC_TIMR   (AT91_CAST(AT91_REG *) 0x00000008) // Time Register
#define RTC_CALR   (AT91_CAST(AT91_REG *) 0x0000000C) // Calendar Register
#define RTC_TIMALR (AT91_CAST(AT91_REG *) 0x00000010) // Time Alarm Register
#define RTC_CALALR (AT91_CAST(AT91_REG *) 0x00000014) // Calendar Alarm Register
#define RTC_SR     (AT91_CAST(AT91_REG *) 0x00000018) // Status Register
#define RTC_SCCR   (AT91_CAST(AT91_REG *) 0x0000001C) // Status Clear Command Register
#define RTC_IER    (AT91_CAST(AT91_REG *) 0x00000020) // Interrupt Enable Register
#define RTC_IDR    (AT91_CAST(AT91_REG *) 0x00000024) // Interrupt Disable Register
#define RTC_IMR    (AT91_CAST(AT91_REG *) 0x00000028) // Interrupt Mask Register
#define RTC_VER    (AT91_CAST(AT91_REG *) 0x0000002C) // Valid Entry Register
#endif
// -------- RTC_CR : (RTC Offset: 0x00) Control Register --------
#define AT91C_RTC_CR_UPDTIM (0x1 << 0) // (RTC) Update Request Time Register
#define AT91C_RTC_CR_UPDCAL (0x1 << 1) // (RTC) Update Request Calendar Register
#define AT91C_RTC_CR_TIMEVSEL (0x3 << 8) // (RTC) Time Event Selection
#define   AT91C_RTC_CR_TIMEVSEL_MINUTE (0x0 << 8) // (RTC) Minute change.
#define   AT91C_RTC_CR_TIMEVSEL_HOUR (0x1 << 8) // (RTC) Hour change.
#define   AT91C_RTC_CR_TIMEVSEL_DAY24 (0x2 << 8) // (RTC) Every day at midnight.
#define   AT91C_RTC_CR_TIMEVSEL_DAY12 (0x3 << 8) // (RTC) Every day at noon.
#define AT91C_RTC_CR_CALEVSEL (0x3 << 16) // (RTC) Calendar Event Selection
#define   AT91C_RTC_CR_CALEVSEL_WEEK (0x0 << 16) // (RTC) Week change (every Monday at time 00:00:00).
#define   AT91C_RTC_CR_CALEVSEL_MONTH (0x1 << 16) // (RTC) Month change (every 01 of each month at time 00:00:00).
// -------- RTC_MR : (RTC Offset: 0x04) Mode Register --------
#define AT91C_RTC_MR_HRMOD (0x1 << 0) // (RTC) 12-/24-hour Mode
// -------- RTC_TIMR : (RTC Offset: 0x08) Time Register --------
#define AT91C_RTC_TIMR_SEC (0x7f << 0) // (RTC) Current Second
#define AT91C_RTC_TIMR_MIN (0x7f << 8) // (RTC) Current Minute
#define AT91C_RTC_TIMR_HOUR (0x3f << 16) // (RTC) Current Hour
#define AT91C_RTC_TIMR_AMPM (0x1 << 22) // (RTC) Ante Meridiem Post Meridiem Indicator
// -------- RTC_CALR : (RTC Offset: 0x0C) Calendar Register --------
#define AT91C_RTC_CALR_CENT (0x7f << 0) // (RTC) Current Century
#define AT91C_RTC_CALR_YEAR (0xff << 8) // (RTC) Current Year
#define AT91C_RTC_CALR_MONTH (0x1f << 16) // (RTC) Current Month
#define AT91C_RTC_CALR_DAY (0x7 << 21) // (RTC) Current Day
#define AT91C_RTC_CALR_DATE (0x3f << 24) // (RTC) Current Date
// -------- RTC_TIMALR : (RTC Offset: 0x10) Time Alarm Register --------
#define AT91C_RTC_TIMALR_SEC (0x7f << 0) // (RTC) Second Alarm
#define AT91C_RTC_TIMALR_SECEN (0x1 << 7) // (RTC) Second Alarm Enable
#define AT91C_RTC_TIMALR_MIN (0x7f << 8) // (RTC) Minute Alarm
#define AT91C_RTC_TIMALR_MINEN (0x1 << 15) // (RTC) Minute Alarm Enable
#define AT91C_RTC_TIMALR_HOUR (0x3f << 16) // (RTC) Hour Alarm
#define AT91C_RTC_TIMALR_AMPM (0x1 << 22) // (RTC) AM/PM Indicator
#define AT91C_RTC_TIMALR_HOUREN (0x1 << 23) // (RTC) Hour Alarm Enable
// -------- RTC_CALALR : (RTC Offset: 0x14) Calendar Alarm Register --------
#define AT91C_RTC_CALALR_MONTH (0x1f << 16) // (RTC) Month Alarm
#define AT91C_RTC_CALALR_MTHEN (0x1 << 23) // (RTC) Month Alarm Enable
#define AT91C_RTC_CALALR_DATE (0x3f << 24) // (RTC) Date Alarm
#define AT91C_RTC_CALALR_DATEEN (0x1 << 31) // (RTC) Date Alarm Enable
// -------- RTC_SR : (RTC Offset: 0x18) Status Register --------
#define AT91C_RTC_SR_ACKUPD (0x1 << 0) // (RTC) Acknowledge for Update
#define AT91C_RTC_SR_ALARM (0x1 << 1) // (RTC) Alarm Flag
#define AT91C_RTC_SR_SEC (0x1 << 2) // (RTC) Second Event
#define AT91C_RTC_SR_TIMEV (0x1 << 3) // (RTC) Time Event
#define AT91C_RTC_SR_CALEV (0x1 << 4) // (RTC) Calendar Event
// -------- RTC_SCCR : (RTC Offset: 0x1C) Status Clear Command Register --------
#define AT91C_RTC_SCCR_ACKCLR (0x1 << 0) // (RTC) Acknowledge Clear
#define AT91C_RTC_SCCR_ALRCLR (0x1 << 1) // (RTC) Alarm Clear
#define AT91C_RTC_SCCR_SECCLR (0x1 << 2) // (RTC) Second Clear
#define AT91C_RTC_SCCR_TIMCLR (0x1 << 3) // (RTC) Time Clear
#define AT91C_RTC_SCCR_CALCLR (0x1 << 4) // (RTC) Calendar Clear
// -------- RTC_IER : (RTC Offset: 0x20) Interrupt Enable Register --------
#define AT91C_RTC_IER_ACKEN (0x1 << 0) // (RTC) Acknowledge Update Interrupt Enable
#define AT91C_RTC_IER_ALREN (0x1 << 1) // (RTC) Alarm Interrupt Enable
#define AT91C_RTC_IER_SECEN (0x1 << 2) // (RTC) Second Event Interrupt Enable
#define AT91C_RTC_IER_TIMEN (0x1 << 3) // (RTC) Time Event Interrupt Enable
#define AT91C_RTC_IER_CALEN (0x1 << 4) // (RTC) Calendar Event Interrupt Enable
// -------- RTC_IDR : (RTC Offset: 0x24) Interrupt Disable Register --------
#define AT91C_RTC_IDR_ACKDIS (0x1 << 0) // (RTC) Acknowledge Update Interrupt Disable
#define AT91C_RTC_IDR_ALRDIS (0x1 << 1) // (RTC) Alarm Interrupt Disable
#define AT91C_RTC_IDR_SECDIS (0x1 << 2) // (RTC) Second Event Interrupt Disable
#define AT91C_RTC_IDR_TIMDIS (0x1 << 3) // (RTC) Time Event Interrupt Disable
#define AT91C_RTC_IDR_CALDIS (0x1 << 4) // (RTC) Calendar Event Interrupt Disable
// -------- RTC_IMR : (RTC Offset: 0x28) Interrupt Mask Register --------
#define AT91C_RTC_IMR_ACK (0x1 << 0) // (RTC) Acknowledge Update Interrupt Mask
#define AT91C_RTC_IMR_ALR (0x1 << 1) // (RTC) Alarm Interrupt Mask
#define AT91C_RTC_IMR_SEC (0x1 << 2) // (RTC) Second Event Interrupt Mask
#define AT91C_RTC_IMR_TIM (0x1 << 3) // (RTC) Time Event Interrupt Mask
#define AT91C_RTC_IMR_CAL (0x1 << 4) // (RTC) Calendar Event Interrupt Mask
// -------- RTC_VER : (RTC Offset: 0x2C) Valid Entry Register --------
#define AT91C_RTC_VER_NVTIM (0x1 << 0) // (RTC) Non-valid Time
#define AT91C_RTC_VER_NVCAL (0x1 << 1) // (RTC) Non-valid Calendar
#define AT91C_RTC_VER_NVTIMALR (0x1 << 2) // (RTC) Non-valid Time Alarm
#define AT91C_RTC_VER_NVCALALR (0x1 << 3) // (RTC) Non-valid Calendar Alarm

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Real-time Timer
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_RTT {
  AT91_REG RTT_MR; // Mode Register
  AT91_REG RTT_AR; // Alarm Register
  AT91_REG RTT_VR; // Value Register
  AT91_REG RTT_SR; // Status Register
} AT91S_RTT, *AT91PS_RTT;
#else
#define RTT_MR (AT91_CAST(AT91_REG *) 0x00000000) // Mode Register
#define RTT_AR (AT91_CAST(AT91_REG *) 0x00000004) // Alarm Register
#define RTT_VR (AT91_CAST(AT91_REG *) 0x00000008) // Value Register
#define RTT_SR (AT91_CAST(AT91_REG *) 0x0000000C) // Status Register
#endif
// -------- RTT_MR : (RTT Offset: 0x00) Mode Register --------
#define AT91C_RTT_MR_RTPRES (0xffff << 0) // (RTT) Real-time Timer Prescaler Value
#define AT91C_RTT_MR_ALMIEN (0x1 << 16) // (RTT) Alarm Interrupt Enable
#define AT91C_RTT_MR_RTTINCIEN (0x1 << 17) // (RTT) Real-time Timer Increment Interrupt Enable
#define AT91C_RTT_MR_RTTRST (0x1 << 18) // (RTT) Real-time Timer Restart
// -------- RTT_AR : (RTT Offset: 0x04) Alarm Register --------
#define AT91C_RTT_AR_ALMV (0xffffffff << 0) // (RTT) Alarm Value
// -------- RTT_VR : (RTT Offset: 0x08) Value Register --------
#define AT91C_RTT_VR_CRTV (0xffffffff << 0) // (RTT) Current Real-time Value
// -------- RTT_SR : (RTT Offset: 0x0C) Status Register --------
#define AT91C_RTT_SR_ALMS (0x1 << 0) // (RTT) Real-time Alarm Status
#define AT91C_RTT_SR_RTTINC (0x1 << 1) // (RTT) Real-time Timer Increment

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Secure Hash Algorithm
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_SHA {
  AT91_REG SHA_CR;         // Control Register
  AT91_REG SHA_MR;         // Mode Register
  AT91_REG Reserved1[2];
  AT91_REG SHA_IER;        // Interrupt Enable Register
  AT91_REG SHA_IDR;        // Interrupt Disable Register
  AT91_REG SHA_IMR;        // Interrupt Mask Register
  AT91_REG SHA_ISR;        // Interrupt Status Register
  AT91_REG Reserved2[8];
  AT91_REG SHA_IDATAR[16]; // Input Data Register
  AT91_REG SHA_ODATAR[8];  // Output Data Register
  AT91_REG Reserved3[24];
  AT91_REG SHA_RPR;        // Receive Pointer Register
  AT91_REG SHA_RCR;        // Receive Counter Register
  AT91_REG SHA_TPR;        // Transmit Pointer Register
  AT91_REG SHA_TCR;        // Transmit Counter Register
  AT91_REG SHA_RNPR;       // Receive Next Pointer Register
  AT91_REG SHA_RNCR;       // Receive Next Counter Register
  AT91_REG SHA_TNPR;       // Transmit Next Pointer Register
  AT91_REG SHA_TNCR;       // Transmit Next Counter Register
  AT91_REG SHA_PTCR;       // Transfer Control Register
  AT91_REG SHA_PTSR;       // Transfer Status Register
} AT91S_SHA, *AT91PS_SHA;
#else
#define SHA_CR     (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define SHA_MR     (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define SHA_IER    (AT91_CAST(AT91_REG *) 0x00000010) // Interrupt Enable Register
#define SHA_IDR    (AT91_CAST(AT91_REG *) 0x00000014) // Interrupt Disable Register
#define SHA_IMR    (AT91_CAST(AT91_REG *) 0x00000018) // Interrupt Mask Register
#define SHA_ISR    (AT91_CAST(AT91_REG *) 0x0000001C) // Interrupt Status Register
#define SHA_IDATAR (AT91_CAST(AT91_REG *) 0x00000040) // Input Data Register
#define SHA_ODATAR (AT91_CAST(AT91_REG *) 0x00000080) // Output Data Register
#define SHA_RPR    (AT91_CAST(AT91_REG *) 0x00000100) // Receive Pointer Register
#define SHA_RCR    (AT91_CAST(AT91_REG *) 0x00000104) // Receive Counter Register
#define SHA_TPR    (AT91_CAST(AT91_REG *) 0x00000108) // Transmit Pointer Register
#define SHA_TCR    (AT91_CAST(AT91_REG *) 0x0000010C) // Transmit Counter Register
#define SHA_RNPR   (AT91_CAST(AT91_REG *) 0x00000110) // Receive Next Pointer Register
#define SHA_RNCR   (AT91_CAST(AT91_REG *) 0x00000114) // Receive Next Counter Register
#define SHA_TNPR   (AT91_CAST(AT91_REG *) 0x00000118) // Transmit Next Pointer Register
#define SHA_TNCR   (AT91_CAST(AT91_REG *) 0x0000011C) // Transmit Next Counter Register
#define SHA_PTCR   (AT91_CAST(AT91_REG *) 0x00000120) // Transfer Control Register
#define SHA_PTSR   (AT91_CAST(AT91_REG *) 0x00000124) // Transfer Status Register
#endif
// -------- SHA_CR : (SHA Offset: 0x00) Control Register --------
#define AT91C_SHA_CR_START (0x1 << 0) // (SHA) Start Processing
#define AT91C_SHA_CR_FIRST (0x1 << 4) // (SHA) First Block of a Message
#define AT91C_SHA_CR_SWRST (0x1 << 8) // (SHA) Software Reset
// -------- SHA_MR : (SHA Offset: 0x04) Mode Register --------
#define AT91C_SHA_MR_SMOD (0x3 << 0) // (SHA) Start Mode
#define AT91C_SHA_MR_PROCDLY (0x1 << 4) // (SHA) Processing Delay
#define AT91C_SHA_MR_ALGO (0x1 << 8) // (SHA) SHA Algorithm
// -------- SHA_IER : (SHA Offset: 0x10) Interrupt Enable Register --------
#define AT91C_SHA_IER_DATRDY (0x1 << 0) // (SHA) Data Ready Interrupt Enable
#define AT91C_SHA_IER_ENDTX (0x1 << 1) // (SHA) End of Transmit Buffer Interrupt Enable
#define AT91C_SHA_IER_TXBUFE (0x1 << 2) // (SHA) Transmit Buffer Empty Interrupt Enable
#define AT91C_SHA_IER_URAD (0x1 << 8) // (SHA) Unspecified Register Access Detection Interrupt Enable
// -------- SHA_IDR : (SHA Offset: 0x14) Interrupt Disable Register --------
#define AT91C_SHA_IDR_DATRDY (0x1 << 0) // (SHA) Data Ready Interrupt Disable
#define AT91C_SHA_IDR_ENDTX (0x1 << 1) // (SHA) End of Transmit Buffer Interrupt Disable
#define AT91C_SHA_IDR_TXBUFE (0x1 << 2) // (SHA) Transmit Buffer Empty Interrupt Disable
#define AT91C_SHA_IDR_URAD (0x1 << 8) // (SHA) Unspecified Register Access Detection Interrupt Disable
// -------- SHA_IMR : (SHA Offset: 0x18) Interrupt Mask Register --------
#define AT91C_SHA_IMR_DATRDY (0x1 << 0) // (SHA) Data Ready Interrupt Mask
#define AT91C_SHA_IMR_ENDTX (0x1 << 1) // (SHA) End of Transmit Buffer Interrupt Mask
#define AT91C_SHA_IMR_TXBUFE (0x1 << 2) // (SHA) Transmit Buffer Empty Interrupt Mask
#define AT91C_SHA_IMR_URAD (0x1 << 8) // (SHA) Unspecified Register Access Detection Interrupt Mask
// -------- SHA_ISR : (SHA Offset: 0x1C) Interrupt Status Register --------
#define AT91C_SHA_ISR_DATRDY (0x1 << 0) // (SHA) Data Ready
#define AT91C_SHA_ISR_ENDTX (0x1 << 1) // (SHA) End of TX Buffer
#define AT91C_SHA_ISR_TXBUFE (0x1 << 2) // (SHA) TX Buffer Empty
#define AT91C_SHA_ISR_URAD (0x1 << 8) // (SHA) Unspecified Register Access Detection Status
#define AT91C_SHA_ISR_URAT (0x7 << 12) // (SHA) Unspecified Register Access Type
// -------- SHA_IDATAR[16] : (SHA Offset: 0x40) Input Data Register --------
#define AT91C_SHA_IDATAR_IDATAx (0xffffffff << 0) // (SHA) Input Data x
// -------- SHA_ODATAR[8] : (SHA Offset: 0x80) Output Data Register --------
#define AT91C_SHA_ODATAR_ODATAx (0xffffffff << 0) // (SHA) Output Data x
// -------- SHA_RPR : (SHA Offset: 0x100) Receive Pointer Register --------
#define AT91C_SHA_RPR_RXPTR (0xffffffff << 0) // (SHA) Receive Pointer Register
// -------- SHA_RCR : (SHA Offset: 0x104) Receive Counter Register --------
#define AT91C_SHA_RCR_RXCTR (0xffff << 0) // (SHA) Receive Counter Register
// -------- SHA_TPR : (SHA Offset: 0x108) Transmit Pointer Register --------
#define AT91C_SHA_TPR_TXPTR (0xffffffff << 0) // (SHA) Transmit Counter Register
// -------- SHA_TCR : (SHA Offset: 0x10C) Transmit Counter Register --------
#define AT91C_SHA_TCR_TXCTR (0xffff << 0) // (SHA) Transmit Counter Register
// -------- SHA_RNPR : (SHA Offset: 0x110) Receive Next Pointer Register --------
#define AT91C_SHA_RNPR_RXNPTR (0xffffffff << 0) // (SHA) Receive Next Pointer
// -------- SHA_RNCR : (SHA Offset: 0x114) Receive Next Counter Register --------
#define AT91C_SHA_RNCR_RXNCTR (0xffff << 0) // (SHA) Receive Next Counter
// -------- SHA_TNPR : (SHA Offset: 0x118) Transmit Next Pointer Register --------
#define AT91C_SHA_TNPR_TXNPTR (0xffffffff << 0) // (SHA) Transmit Next Pointer
// -------- SHA_TNCR : (SHA Offset: 0x11C) Transmit Next Counter Register --------
#define AT91C_SHA_TNCR_TXNCTR (0xffff << 0) // (SHA) Transmit Counter Next
// -------- SHA_PTCR : (SHA Offset: 0x120) Transfer Control Register --------
#define AT91C_SHA_PTCR_RXTEN (0x1 << 0) // (SHA) Receiver Transfer Enable
#define AT91C_SHA_PTCR_RXTDIS (0x1 << 1) // (SHA) Receiver Transfer Disable
#define AT91C_SHA_PTCR_TXTEN (0x1 << 8) // (SHA) Transmitter Transfer Enable
#define AT91C_SHA_PTCR_TXTDIS (0x1 << 9) // (SHA) Transmitter Transfer Disable
// -------- SHA_PTSR : (SHA Offset: 0x124) Transfer Status Register --------
#define AT91C_SHA_PTSR_RXTEN (0x1 << 0) // (SHA) Receiver Transfer Enable
#define AT91C_SHA_PTSR_TXTEN (0x1 << 8) // (SHA) Transmitter Transfer Enable

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Shutdown Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_SHDWC {
  AT91_REG SHDW_CR; // Shutdown Control Register
  AT91_REG SHDW_MR; // Shutdown Mode Register
  AT91_REG SHDW_SR; // Shutdown Status Register
} AT91S_SHDWC, *AT91PS_SHDWC;
#else
#define SHDW_CR (AT91_CAST(AT91_REG *) 0x00000000) // Shutdown Control Register
#define SHDW_MR (AT91_CAST(AT91_REG *) 0x00000004) // Shutdown Mode Register
#define SHDW_SR (AT91_CAST(AT91_REG *) 0x00000008) // Shutdown Status Register
#endif
// -------- SHDW_CR : (SHDWC Offset: 0x00) Shutdown Control Register --------
#define AT91C_SHDW_CR_SHDW (0x1 << 0) // (SHDWC) Shutdown Command
#define AT91C_SHDW_CR_KEY (0xff << 24) // (SHDWC) Password
// -------- SHDW_MR : (SHDWC Offset: 0x04) Shutdown Mode Register --------
#define AT91C_SHDW_MR_WKMODE0 (0x3 << 0) // (SHDWC) Wake-up Mode 0
#define AT91C_SHDW_MR_CPTWK0 (0xf << 4) // (SHDWC) Counter on Wake-up 0
#define AT91C_SHDW_MR_RTTWKEN (0x1 << 16) // (SHDWC) Real-time Timer Wake-up Enable
#define AT91C_SHDW_MR_RTCWKEN (0x1 << 17) // (SHDWC) Real-time Clock Wake-up Enable
// -------- SHDW_SR : (SHDWC Offset: 0x08) Shutdown Status Register --------
#define AT91C_SHDW_SR_WAKEUP0 (0x1 << 0) // (SHDWC) Wake-up 0 Status
#define AT91C_SHDW_SR_RTTWK (0x1 << 16) // (SHDWC) Real-time Timer Wake-up
#define AT91C_SHDW_SR_RTCWK (0x1 << 17) // (SHDWC) Real-time Clock Wake-up

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Static Memory Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_SMC {
  AT91_REG SMC_SETUP0; // SMC Setup Register (CS_number = 0)
  AT91_REG SMC_PULSE0; // SMC Pulse Register (CS_number = 0)
  AT91_REG SMC_CYCLE0; // SMC Cycle Register (CS_number = 0)
  AT91_REG SMC_MODE0;  // SMC Mode Register (CS_number = 0)
  AT91_REG SMC_SETUP1; // SMC Setup Register (CS_number = 1)
  AT91_REG SMC_PULSE1; // SMC Pulse Register (CS_number = 1)
  AT91_REG SMC_CYCLE1; // SMC Cycle Register (CS_number = 1)
  AT91_REG SMC_MODE1;  // SMC Mode Register (CS_number = 1)
  AT91_REG SMC_SETUP2; // SMC Setup Register (CS_number = 2)
  AT91_REG SMC_PULSE2; // SMC Pulse Register (CS_number = 2)
  AT91_REG SMC_CYCLE2; // SMC Cycle Register (CS_number = 2)
  AT91_REG SMC_MODE2;  // SMC Mode Register (CS_number = 2)
  AT91_REG SMC_SETUP3; // SMC Setup Register (CS_number = 3)
  AT91_REG SMC_PULSE3; // SMC Pulse Register (CS_number = 3)
  AT91_REG SMC_CYCLE3; // SMC Cycle Register (CS_number = 3)
  AT91_REG SMC_MODE3;  // SMC Mode Register (CS_number = 3)
  AT91_REG SMC_SETUP4; // SMC Setup Register (CS_number = 4)
  AT91_REG SMC_PULSE4; // SMC Pulse Register (CS_number = 4)
  AT91_REG SMC_CYCLE4; // SMC Cycle Register (CS_number = 4)
  AT91_REG SMC_MODE4;  // SMC Mode Register (CS_number = 4)
  AT91_REG SMC_SETUP5; // SMC Setup Register (CS_number = 5)
  AT91_REG SMC_PULSE5; // SMC Pulse Register (CS_number = 5)
  AT91_REG SMC_CYCLE5; // SMC Cycle Register (CS_number = 5)
  AT91_REG SMC_MODE5;  // SMC Mode Register (CS_number = 5)
  AT91_REG SMC_SETUP6; // SMC Setup Register (CS_number = 6)
  AT91_REG SMC_PULSE6; // SMC Pulse Register (CS_number = 6)
  AT91_REG SMC_CYCLE6; // SMC Cycle Register (CS_number = 6)
  AT91_REG SMC_MODE6;  // SMC Mode Register (CS_number = 6)
  AT91_REG SMC_SETUP7; // SMC Setup Register (CS_number = 7)
  AT91_REG SMC_PULSE7; // SMC Pulse Register (CS_number = 7)
  AT91_REG SMC_CYCLE7; // SMC Cycle Register (CS_number = 7)
  AT91_REG SMC_MODE7;  // SMC Mode Register (CS_number = 7)
} AT91S_SMC, *AT91PS_SMC;
#else
#define SMC_SETUP0 (AT91_CAST(AT91_REG *) 0x00000000) // SMC Setup Register (CS_number = 0)
#define SMC_PULSE0 (AT91_CAST(AT91_REG *) 0x00000004) // SMC Pulse Register (CS_number = 0)
#define SMC_CYCLE0 (AT91_CAST(AT91_REG *) 0x00000008) // SMC Cycle Register (CS_number = 0)
#define SMC_MODE0  (AT91_CAST(AT91_REG *) 0x0000000C) // SMC Mode Register (CS_number = 0)
#define SMC_SETUP1 (AT91_CAST(AT91_REG *) 0x00000010) // SMC Setup Register (CS_number = 1)
#define SMC_PULSE1 (AT91_CAST(AT91_REG *) 0x00000014) // SMC Pulse Register (CS_number = 1)
#define SMC_CYCLE1 (AT91_CAST(AT91_REG *) 0x00000018) // SMC Cycle Register (CS_number = 1)
#define SMC_MODE1  (AT91_CAST(AT91_REG *) 0x0000001C) // SMC Mode Register (CS_number = 1)
#define SMC_SETUP2 (AT91_CAST(AT91_REG *) 0x00000020) // SMC Setup Register (CS_number = 2)
#define SMC_PULSE2 (AT91_CAST(AT91_REG *) 0x00000024) // SMC Pulse Register (CS_number = 2)
#define SMC_CYCLE2 (AT91_CAST(AT91_REG *) 0x00000028) // SMC Cycle Register (CS_number = 2)
#define SMC_MODE2  (AT91_CAST(AT91_REG *) 0x0000002C) // SMC Mode Register (CS_number = 2)
#define SMC_SETUP3 (AT91_CAST(AT91_REG *) 0x00000030) // SMC Setup Register (CS_number = 3)
#define SMC_PULSE3 (AT91_CAST(AT91_REG *) 0x00000034) // SMC Pulse Register (CS_number = 3)
#define SMC_CYCLE3 (AT91_CAST(AT91_REG *) 0x00000038) // SMC Cycle Register (CS_number = 3)
#define SMC_MODE3  (AT91_CAST(AT91_REG *) 0x0000003C) // SMC Mode Register (CS_number = 3)
#define SMC_SETUP4 (AT91_CAST(AT91_REG *) 0x00000040) // SMC Setup Register (CS_number = 4)
#define SMC_PULSE4 (AT91_CAST(AT91_REG *) 0x00000044) // SMC Pulse Register (CS_number = 4)
#define SMC_CYCLE4 (AT91_CAST(AT91_REG *) 0x00000048) // SMC Cycle Register (CS_number = 4)
#define SMC_MODE4  (AT91_CAST(AT91_REG *) 0x0000004C) // SMC Mode Register (CS_number = 4)
#define SMC_SETUP5 (AT91_CAST(AT91_REG *) 0x00000050) // SMC Setup Register (CS_number = 5)
#define SMC_PULSE5 (AT91_CAST(AT91_REG *) 0x00000054) // SMC Pulse Register (CS_number = 5)
#define SMC_CYCLE5 (AT91_CAST(AT91_REG *) 0x00000058) // SMC Cycle Register (CS_number = 5)
#define SMC_MODE5  (AT91_CAST(AT91_REG *) 0x0000005C) // SMC Mode Register (CS_number = 5)
#define SMC_SETUP6 (AT91_CAST(AT91_REG *) 0x00000060) // SMC Setup Register (CS_number = 6)
#define SMC_PULSE6 (AT91_CAST(AT91_REG *) 0x00000064) // SMC Pulse Register (CS_number = 6)
#define SMC_CYCLE6 (AT91_CAST(AT91_REG *) 0x00000068) // SMC Cycle Register (CS_number = 6)
#define SMC_MODE6  (AT91_CAST(AT91_REG *) 0x0000006C) // SMC Mode Register (CS_number = 6)
#define SMC_SETUP7 (AT91_CAST(AT91_REG *) 0x00000070) // SMC Setup Register (CS_number = 7)
#define SMC_PULSE7 (AT91_CAST(AT91_REG *) 0x00000074) // SMC Pulse Register (CS_number = 7)
#define SMC_CYCLE7 (AT91_CAST(AT91_REG *) 0x00000078) // SMC Cycle Register (CS_number = 7)
#define SMC_MODE7  (AT91_CAST(AT91_REG *) 0x0000007C) // SMC Mode Register (CS_number = 7)
#endif
// -------- SMC_SETUP0 : (SMC Offset: 0x0) SMC Setup Register (CS_number = 0) --------
#define AT91C_SMC_SETUP0_NWE_SETUP (0x3f << 0) // (SMC) NWE Setup Length
#define AT91C_SMC_SETUP0_NCS_WR_SETUP (0x3f << 8) // (SMC) NCS Setup Length in WRITE Access
#define AT91C_SMC_SETUP0_NRD_SETUP (0x3f << 16) // (SMC) NRD Setup Length
#define AT91C_SMC_SETUP0_NCS_RD_SETUP (0x3f << 24) // (SMC) NCS Setup Length in READ Access
// -------- SMC_PULSE0 : (SMC Offset: 0x4) SMC Pulse Register (CS_number = 0) --------
#define AT91C_SMC_PULSE0_NWE_PULSE (0x7f << 0) // (SMC) NWE Pulse Length
#define AT91C_SMC_PULSE0_NCS_WR_PULSE (0x7f << 8) // (SMC) NCS Pulse Length in WRITE Access
#define AT91C_SMC_PULSE0_NRD_PULSE (0x7f << 16) // (SMC) NRD Pulse Length
#define AT91C_SMC_PULSE0_NCS_RD_PULSE (0x7f << 24) // (SMC) NCS Pulse Length in READ Access
// -------- SMC_CYCLE0 : (SMC Offset: 0x8) SMC Cycle Register (CS_number = 0) --------
#define AT91C_SMC_CYCLE0_NWE_CYCLE (0x1ff << 0) // (SMC) Total Write Cycle Length
#define AT91C_SMC_CYCLE0_NRD_CYCLE (0x1ff << 16) // (SMC) Total Read Cycle Length
// -------- SMC_MODE0 : (SMC Offset: 0xC) SMC Mode Register (CS_number = 0) --------
#define AT91C_SMC_MODE0_READ_MODE (0x1 << 0) // (SMC)
#define AT91C_SMC_MODE0_WRITE_MODE (0x1 << 1) // (SMC)
#define AT91C_SMC_MODE0_EXNW_MODE (0x3 << 4) // (SMC) NWAIT Mode
#define AT91C_SMC_MODE0_BAT (0x1 << 8) // (SMC) Byte Access Type
#define AT91C_SMC_MODE0_DBW (0x3 << 12) // (SMC) Data Bus Width
#define AT91C_SMC_MODE0_TDF_CYCLES (0xf << 16) // (SMC) Data Float Time
#define AT91C_SMC_MODE0_TDF_MODE (0x1 << 20) // (SMC) TDF Optimization
#define AT91C_SMC_MODE0_PMEN (0x1 << 24) // (SMC) Page Mode Enabled
#define AT91C_SMC_MODE0_PS (0x3 << 28) // (SMC) Page Size
// -------- SMC_SETUP1 : (SMC Offset: 0x10) SMC Setup Register (CS_number = 1) --------
#define AT91C_SMC_SETUP1_NWE_SETUP (0x3f << 0) // (SMC) NWE Setup Length
#define AT91C_SMC_SETUP1_NCS_WR_SETUP (0x3f << 8) // (SMC) NCS Setup Length in WRITE Access
#define AT91C_SMC_SETUP1_NRD_SETUP (0x3f << 16) // (SMC) NRD Setup Length
#define AT91C_SMC_SETUP1_NCS_RD_SETUP (0x3f << 24) // (SMC) NCS Setup Length in READ Access
// -------- SMC_PULSE1 : (SMC Offset: 0x14) SMC Pulse Register (CS_number = 1) --------
#define AT91C_SMC_PULSE1_NWE_PULSE (0x7f << 0) // (SMC) NWE Pulse Length
#define AT91C_SMC_PULSE1_NCS_WR_PULSE (0x7f << 8) // (SMC) NCS Pulse Length in WRITE Access
#define AT91C_SMC_PULSE1_NRD_PULSE (0x7f << 16) // (SMC) NRD Pulse Length
#define AT91C_SMC_PULSE1_NCS_RD_PULSE (0x7f << 24) // (SMC) NCS Pulse Length in READ Access
// -------- SMC_CYCLE1 : (SMC Offset: 0x18) SMC Cycle Register (CS_number = 1) --------
#define AT91C_SMC_CYCLE1_NWE_CYCLE (0x1ff << 0) // (SMC) Total Write Cycle Length
#define AT91C_SMC_CYCLE1_NRD_CYCLE (0x1ff << 16) // (SMC) Total Read Cycle Length
// -------- SMC_MODE1 : (SMC Offset: 0x1C) SMC Mode Register (CS_number = 1) --------
#define AT91C_SMC_MODE1_READ_MODE (0x1 << 0) // (SMC)
#define AT91C_SMC_MODE1_WRITE_MODE (0x1 << 1) // (SMC)
#define AT91C_SMC_MODE1_EXNW_MODE (0x3 << 4) // (SMC) NWAIT Mode
#define AT91C_SMC_MODE1_BAT (0x1 << 8) // (SMC) Byte Access Type
#define AT91C_SMC_MODE1_DBW (0x3 << 12) // (SMC) Data Bus Width
#define AT91C_SMC_MODE1_TDF_CYCLES (0xf << 16) // (SMC) Data Float Time
#define AT91C_SMC_MODE1_TDF_MODE (0x1 << 20) // (SMC) TDF Optimization
#define AT91C_SMC_MODE1_PMEN (0x1 << 24) // (SMC) Page Mode Enabled
#define AT91C_SMC_MODE1_PS (0x3 << 28) // (SMC) Page Size
// -------- SMC_SETUP2 : (SMC Offset: 0x20) SMC Setup Register (CS_number = 2) --------
#define AT91C_SMC_SETUP2_NWE_SETUP (0x3f << 0) // (SMC) NWE Setup Length
#define AT91C_SMC_SETUP2_NCS_WR_SETUP (0x3f << 8) // (SMC) NCS Setup Length in WRITE Access
#define AT91C_SMC_SETUP2_NRD_SETUP (0x3f << 16) // (SMC) NRD Setup Length
#define AT91C_SMC_SETUP2_NCS_RD_SETUP (0x3f << 24) // (SMC) NCS Setup Length in READ Access
// -------- SMC_PULSE2 : (SMC Offset: 0x24) SMC Pulse Register (CS_number = 2) --------
#define AT91C_SMC_PULSE2_NWE_PULSE (0x7f << 0) // (SMC) NWE Pulse Length
#define AT91C_SMC_PULSE2_NCS_WR_PULSE (0x7f << 8) // (SMC) NCS Pulse Length in WRITE Access
#define AT91C_SMC_PULSE2_NRD_PULSE (0x7f << 16) // (SMC) NRD Pulse Length
#define AT91C_SMC_PULSE2_NCS_RD_PULSE (0x7f << 24) // (SMC) NCS Pulse Length in READ Access
// -------- SMC_CYCLE2 : (SMC Offset: 0x28) SMC Cycle Register (CS_number = 2) --------
#define AT91C_SMC_CYCLE2_NWE_CYCLE (0x1ff << 0) // (SMC) Total Write Cycle Length
#define AT91C_SMC_CYCLE2_NRD_CYCLE (0x1ff << 16) // (SMC) Total Read Cycle Length
// -------- SMC_MODE2 : (SMC Offset: 0x2C) SMC Mode Register (CS_number = 2) --------
#define AT91C_SMC_MODE2_READ_MODE (0x1 << 0) // (SMC)
#define AT91C_SMC_MODE2_WRITE_MODE (0x1 << 1) // (SMC)
#define AT91C_SMC_MODE2_EXNW_MODE (0x3 << 4) // (SMC) NWAIT Mode
#define AT91C_SMC_MODE2_BAT (0x1 << 8) // (SMC) Byte Access Type
#define AT91C_SMC_MODE2_DBW (0x3 << 12) // (SMC) Data Bus Width
#define AT91C_SMC_MODE2_TDF_CYCLES (0xf << 16) // (SMC) Data Float Time
#define AT91C_SMC_MODE2_TDF_MODE (0x1 << 20) // (SMC) TDF Optimization
#define AT91C_SMC_MODE2_PMEN (0x1 << 24) // (SMC) Page Mode Enabled
#define AT91C_SMC_MODE2_PS (0x3 << 28) // (SMC) Page Size
// -------- SMC_SETUP3 : (SMC Offset: 0x30) SMC Setup Register (CS_number = 3) --------
#define AT91C_SMC_SETUP3_NWE_SETUP (0x3f << 0) // (SMC) NWE Setup Length
#define AT91C_SMC_SETUP3_NCS_WR_SETUP (0x3f << 8) // (SMC) NCS Setup Length in WRITE Access
#define AT91C_SMC_SETUP3_NRD_SETUP (0x3f << 16) // (SMC) NRD Setup Length
#define AT91C_SMC_SETUP3_NCS_RD_SETUP (0x3f << 24) // (SMC) NCS Setup Length in READ Access
// -------- SMC_PULSE3 : (SMC Offset: 0x34) SMC Pulse Register (CS_number = 3) --------
#define AT91C_SMC_PULSE3_NWE_PULSE (0x7f << 0) // (SMC) NWE Pulse Length
#define AT91C_SMC_PULSE3_NCS_WR_PULSE (0x7f << 8) // (SMC) NCS Pulse Length in WRITE Access
#define AT91C_SMC_PULSE3_NRD_PULSE (0x7f << 16) // (SMC) NRD Pulse Length
#define AT91C_SMC_PULSE3_NCS_RD_PULSE (0x7f << 24) // (SMC) NCS Pulse Length in READ Access
// -------- SMC_CYCLE3 : (SMC Offset: 0x38) SMC Cycle Register (CS_number = 3) --------
#define AT91C_SMC_CYCLE3_NWE_CYCLE (0x1ff << 0) // (SMC) Total Write Cycle Length
#define AT91C_SMC_CYCLE3_NRD_CYCLE (0x1ff << 16) // (SMC) Total Read Cycle Length
// -------- SMC_MODE3 : (SMC Offset: 0x3C) SMC Mode Register (CS_number = 3) --------
#define AT91C_SMC_MODE3_READ_MODE (0x1 << 0) // (SMC)
#define AT91C_SMC_MODE3_WRITE_MODE (0x1 << 1) // (SMC)
#define AT91C_SMC_MODE3_EXNW_MODE (0x3 << 4) // (SMC) NWAIT Mode
#define     AT91C_SMC_MODE3_EXNW_MODE_DISABLE        (0x0 <<  5) // (SMC) External NWAIT disabled.
#define     AT91C_SMC_MODE3_EXNW_MODE_ENABLE_FROZEN  (0x2 <<  5) // (SMC) External NWAIT enabled in frozen mode.
#define     AT91C_SMC_MODE3_EXNW_MODE_ENABLE_READY   (0x3 <<  5) // (SMC) External NWAIT enabled in ready mode.
#define AT91C_SMC_MODE3_BAT (0x1 << 8) // (SMC) Byte Access Type
#define     AT91C_SMC_MODE3_BAT_SELECT          (0x0 <<  8) // (SMC) Write controled by ncs, nbs0, nbs1, nbs2, nbs3. Read controled by ncs, nrd, nbs0, nbs1, nbs2, nbs3.
#define     AT91C_SMC_MODE3_BAT_WRITE           (0x1 <<  8) // (SMC) Write controled by ncs, nwe0, nwe1, nwe2, nwe3. Read controled by ncs and nrd.
#define AT91C_SMC_MODE3_DBW (0x3 << 12) // (SMC) Data Bus Width
#define     AT91C_SMC_MODE3_DBW_EIGTH_BITS      (0x0 << 12) // (SMC) 8 bits.
#define     AT91C_SMC_MODE3_DBW_SIXTEEN_BITS    (0x1 << 12) // (SMC) 16 bits.
#define     AT91C_SMC_MODE3_DBW_THIRTY_TWO_BITS (0x2 << 12) // (SMC) 32 bits.
#define AT91C_SMC_MODE3_TDF_CYCLES (0xf << 16) // (SMC) Data Float Time
#define AT91C_SMC_MODE3_TDF_MODE (0x1 << 20) // (SMC) TDF Optimization
#define AT91C_SMC_MODE3_PMEN (0x1 << 24) // (SMC) Page Mode Enabled
#define AT91C_SMC_MODE3_PS (0x3 << 28) // (SMC) Page Size
// -------- SMC_SETUP4 : (SMC Offset: 0x40) SMC Setup Register (CS_number = 4) --------
#define AT91C_SMC_SETUP4_NWE_SETUP (0x3f << 0) // (SMC) NWE Setup Length
#define AT91C_SMC_SETUP4_NCS_WR_SETUP (0x3f << 8) // (SMC) NCS Setup Length in WRITE Access
#define AT91C_SMC_SETUP4_NRD_SETUP (0x3f << 16) // (SMC) NRD Setup Length
#define AT91C_SMC_SETUP4_NCS_RD_SETUP (0x3f << 24) // (SMC) NCS Setup Length in READ Access
// -------- SMC_PULSE4 : (SMC Offset: 0x44) SMC Pulse Register (CS_number = 4) --------
#define AT91C_SMC_PULSE4_NWE_PULSE (0x7f << 0) // (SMC) NWE Pulse Length
#define AT91C_SMC_PULSE4_NCS_WR_PULSE (0x7f << 8) // (SMC) NCS Pulse Length in WRITE Access
#define AT91C_SMC_PULSE4_NRD_PULSE (0x7f << 16) // (SMC) NRD Pulse Length
#define AT91C_SMC_PULSE4_NCS_RD_PULSE (0x7f << 24) // (SMC) NCS Pulse Length in READ Access
// -------- SMC_CYCLE4 : (SMC Offset: 0x48) SMC Cycle Register (CS_number = 4) --------
#define AT91C_SMC_CYCLE4_NWE_CYCLE (0x1ff << 0) // (SMC) Total Write Cycle Length
#define AT91C_SMC_CYCLE4_NRD_CYCLE (0x1ff << 16) // (SMC) Total Read Cycle Length
// -------- SMC_MODE4 : (SMC Offset: 0x4C) SMC Mode Register (CS_number = 4) --------
#define AT91C_SMC_MODE4_READ_MODE (0x1 << 0) // (SMC)
#define AT91C_SMC_MODE4_WRITE_MODE (0x1 << 1) // (SMC)
#define AT91C_SMC_MODE4_EXNW_MODE (0x3 << 4) // (SMC) NWAIT Mode
#define AT91C_SMC_MODE4_BAT (0x1 << 8) // (SMC) Byte Access Type
#define AT91C_SMC_MODE4_DBW (0x3 << 12) // (SMC) Data Bus Width
#define AT91C_SMC_MODE4_TDF_CYCLES (0xf << 16) // (SMC) Data Float Time
#define AT91C_SMC_MODE4_TDF_MODE (0x1 << 20) // (SMC) TDF Optimization
#define AT91C_SMC_MODE4_PMEN (0x1 << 24) // (SMC) Page Mode Enabled
#define AT91C_SMC_MODE4_PS (0x3 << 28) // (SMC) Page Size
// -------- SMC_SETUP5 : (SMC Offset: 0x50) SMC Setup Register (CS_number = 5) --------
#define AT91C_SMC_SETUP5_NWE_SETUP (0x3f << 0) // (SMC) NWE Setup Length
#define AT91C_SMC_SETUP5_NCS_WR_SETUP (0x3f << 8) // (SMC) NCS Setup Length in WRITE Access
#define AT91C_SMC_SETUP5_NRD_SETUP (0x3f << 16) // (SMC) NRD Setup Length
#define AT91C_SMC_SETUP5_NCS_RD_SETUP (0x3f << 24) // (SMC) NCS Setup Length in READ Access
// -------- SMC_PULSE5 : (SMC Offset: 0x54) SMC Pulse Register (CS_number = 5) --------
#define AT91C_SMC_PULSE5_NWE_PULSE (0x7f << 0) // (SMC) NWE Pulse Length
#define AT91C_SMC_PULSE5_NCS_WR_PULSE (0x7f << 8) // (SMC) NCS Pulse Length in WRITE Access
#define AT91C_SMC_PULSE5_NRD_PULSE (0x7f << 16) // (SMC) NRD Pulse Length
#define AT91C_SMC_PULSE5_NCS_RD_PULSE (0x7f << 24) // (SMC) NCS Pulse Length in READ Access
// -------- SMC_CYCLE5 : (SMC Offset: 0x58) SMC Cycle Register (CS_number = 5) --------
#define AT91C_SMC_CYCLE5_NWE_CYCLE (0x1ff << 0) // (SMC) Total Write Cycle Length
#define AT91C_SMC_CYCLE5_NRD_CYCLE (0x1ff << 16) // (SMC) Total Read Cycle Length
// -------- SMC_MODE5 : (SMC Offset: 0x5C) SMC Mode Register (CS_number = 5) --------
#define AT91C_SMC_MODE5_READ_MODE (0x1 << 0) // (SMC)
#define AT91C_SMC_MODE5_WRITE_MODE (0x1 << 1) // (SMC)
#define AT91C_SMC_MODE5_EXNW_MODE (0x3 << 4) // (SMC) NWAIT Mode
#define AT91C_SMC_MODE5_BAT (0x1 << 8) // (SMC) Byte Access Type
#define AT91C_SMC_MODE5_DBW (0x3 << 12) // (SMC) Data Bus Width
#define AT91C_SMC_MODE5_TDF_CYCLES (0xf << 16) // (SMC) Data Float Time
#define AT91C_SMC_MODE5_TDF_MODE (0x1 << 20) // (SMC) TDF Optimization
#define AT91C_SMC_MODE5_PMEN (0x1 << 24) // (SMC) Page Mode Enabled
#define AT91C_SMC_MODE5_PS (0x3 << 28) // (SMC) Page Size
// -------- SMC_SETUP6 : (SMC Offset: 0x60) SMC Setup Register (CS_number = 6) --------
#define AT91C_SMC_SETUP6_NWE_SETUP (0x3f << 0) // (SMC) NWE Setup Length
#define AT91C_SMC_SETUP6_NCS_WR_SETUP (0x3f << 8) // (SMC) NCS Setup Length in WRITE Access
#define AT91C_SMC_SETUP6_NRD_SETUP (0x3f << 16) // (SMC) NRD Setup Length
#define AT91C_SMC_SETUP6_NCS_RD_SETUP (0x3f << 24) // (SMC) NCS Setup Length in READ Access
// -------- SMC_PULSE6 : (SMC Offset: 0x64) SMC Pulse Register (CS_number = 6) --------
#define AT91C_SMC_PULSE6_NWE_PULSE (0x7f << 0) // (SMC) NWE Pulse Length
#define AT91C_SMC_PULSE6_NCS_WR_PULSE (0x7f << 8) // (SMC) NCS Pulse Length in WRITE Access
#define AT91C_SMC_PULSE6_NRD_PULSE (0x7f << 16) // (SMC) NRD Pulse Length
#define AT91C_SMC_PULSE6_NCS_RD_PULSE (0x7f << 24) // (SMC) NCS Pulse Length in READ Access
// -------- SMC_CYCLE6 : (SMC Offset: 0x68) SMC Cycle Register (CS_number = 6) --------
#define AT91C_SMC_CYCLE6_NWE_CYCLE (0x1ff << 0) // (SMC) Total Write Cycle Length
#define AT91C_SMC_CYCLE6_NRD_CYCLE (0x1ff << 16) // (SMC) Total Read Cycle Length
// -------- SMC_MODE6 : (SMC Offset: 0x6C) SMC Mode Register (CS_number = 6) --------
#define AT91C_SMC_MODE6_READ_MODE (0x1 << 0) // (SMC)
#define AT91C_SMC_MODE6_WRITE_MODE (0x1 << 1) // (SMC)
#define AT91C_SMC_MODE6_EXNW_MODE (0x3 << 4) // (SMC) NWAIT Mode
#define AT91C_SMC_MODE6_BAT (0x1 << 8) // (SMC) Byte Access Type
#define AT91C_SMC_MODE6_DBW (0x3 << 12) // (SMC) Data Bus Width
#define AT91C_SMC_MODE6_TDF_CYCLES (0xf << 16) // (SMC) Data Float Time
#define AT91C_SMC_MODE6_TDF_MODE (0x1 << 20) // (SMC) TDF Optimization
#define AT91C_SMC_MODE6_PMEN (0x1 << 24) // (SMC) Page Mode Enabled
#define AT91C_SMC_MODE6_PS (0x3 << 28) // (SMC) Page Size
// -------- SMC_SETUP7 : (SMC Offset: 0x70) SMC Setup Register (CS_number = 7) --------
#define AT91C_SMC_SETUP7_NWE_SETUP (0x3f << 0) // (SMC) NWE Setup Length
#define AT91C_SMC_SETUP7_NCS_WR_SETUP (0x3f << 8) // (SMC) NCS Setup Length in WRITE Access
#define AT91C_SMC_SETUP7_NRD_SETUP (0x3f << 16) // (SMC) NRD Setup Length
#define AT91C_SMC_SETUP7_NCS_RD_SETUP (0x3f << 24) // (SMC) NCS Setup Length in READ Access
// -------- SMC_PULSE7 : (SMC Offset: 0x74) SMC Pulse Register (CS_number = 7) --------
#define AT91C_SMC_PULSE7_NWE_PULSE (0x7f << 0) // (SMC) NWE Pulse Length
#define AT91C_SMC_PULSE7_NCS_WR_PULSE (0x7f << 8) // (SMC) NCS Pulse Length in WRITE Access
#define AT91C_SMC_PULSE7_NRD_PULSE (0x7f << 16) // (SMC) NRD Pulse Length
#define AT91C_SMC_PULSE7_NCS_RD_PULSE (0x7f << 24) // (SMC) NCS Pulse Length in READ Access
// -------- SMC_CYCLE7 : (SMC Offset: 0x78) SMC Cycle Register (CS_number = 7) --------
#define AT91C_SMC_CYCLE7_NWE_CYCLE (0x1ff << 0) // (SMC) Total Write Cycle Length
#define AT91C_SMC_CYCLE7_NRD_CYCLE (0x1ff << 16) // (SMC) Total Read Cycle Length
// -------- SMC_MODE7 : (SMC Offset: 0x7C) SMC Mode Register (CS_number = 7) --------
#define AT91C_SMC_MODE7_READ_MODE (0x1 << 0) // (SMC)
#define AT91C_SMC_MODE7_WRITE_MODE (0x1 << 1) // (SMC)
#define AT91C_SMC_MODE7_EXNW_MODE (0x3 << 4) // (SMC) NWAIT Mode
#define AT91C_SMC_MODE7_BAT (0x1 << 8) // (SMC) Byte Access Type
#define AT91C_SMC_MODE7_DBW (0x3 << 12) // (SMC) Data Bus Width
#define AT91C_SMC_MODE7_TDF_CYCLES (0xf << 16) // (SMC) Data Float Time
#define AT91C_SMC_MODE7_TDF_MODE (0x1 << 20) // (SMC) TDF Optimization
#define AT91C_SMC_MODE7_PMEN (0x1 << 24) // (SMC) Page Mode Enabled
#define AT91C_SMC_MODE7_PS (0x3 << 28) // (SMC) Page Size

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Serial Peripheral Interface
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_SPI {
  AT91_REG SPI_CR;        // Control Register
  AT91_REG SPI_MR;        // Mode Register
  AT91_REG SPI_RDR;       // Receive Data Register
  AT91_REG SPI_TDR;       // Transmit Data Register
  AT91_REG SPI_SR;        // Status Register
  AT91_REG SPI_IER;       // Interrupt Enable Register
  AT91_REG SPI_IDR;       // Interrupt Disable Register
  AT91_REG SPI_IMR;       // Interrupt Mask Register
  AT91_REG Reserved1[4];
  AT91_REG SPI_CSR[4];    // Chip Select Register
  AT91_REG Reserved2[48];
  AT91_REG SPI_RPR;       // Receive Pointer Register
  AT91_REG SPI_RCR;       // Receive Counter Register
  AT91_REG SPI_TPR;       // Transmit Pointer Register
  AT91_REG SPI_TCR;       // Transmit Counter Register
  AT91_REG SPI_RNPR;      // Receive Next Pointer Register
  AT91_REG SPI_RNCR;      // Receive Next Counter Register
  AT91_REG SPI_TNPR;      // Transmit Next Pointer Register
  AT91_REG SPI_TNCR;      // Transmit Next Counter Register
  AT91_REG SPI_PTCR;      // Transfer Control Register
  AT91_REG SPI_PTSR;      // Transfer Status Register
} AT91S_SPI, *AT91PS_SPI;
#else
#define SPI_CR   (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define SPI_MR   (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define SPI_RDR  (AT91_CAST(AT91_REG *) 0x00000008) // Receive Data Register
#define SPI_TDR  (AT91_CAST(AT91_REG *) 0x0000000C) // Transmit Data Register
#define SPI_SR   (AT91_CAST(AT91_REG *) 0x00000010) // Status Register
#define SPI_IER  (AT91_CAST(AT91_REG *) 0x00000014) // Interrupt Enable Register
#define SPI_IDR  (AT91_CAST(AT91_REG *) 0x00000018) // Interrupt Disable Register
#define SPI_IMR  (AT91_CAST(AT91_REG *) 0x0000001C) // Interrupt Mask Register
#define SPI_CSR  (AT91_CAST(AT91_REG *) 0x00000030) // Chip Select Register
#define SPI_RPR  (AT91_CAST(AT91_REG *) 0x00000100) // Receive Pointer Register
#define SPI_RCR  (AT91_CAST(AT91_REG *) 0x00000104) // Receive Counter Register
#define SPI_TPR  (AT91_CAST(AT91_REG *) 0x00000108) // Transmit Pointer Register
#define SPI_TCR  (AT91_CAST(AT91_REG *) 0x0000010C) // Transmit Counter Register
#define SPI_RNPR (AT91_CAST(AT91_REG *) 0x00000110) // Receive Next Pointer Register
#define SPI_RNCR (AT91_CAST(AT91_REG *) 0x00000114) // Receive Next Counter Register
#define SPI_TNPR (AT91_CAST(AT91_REG *) 0x00000118) // Transmit Next Pointer Register
#define SPI_TNCR (AT91_CAST(AT91_REG *) 0x0000011C) // Transmit Next Counter Register
#define SPI_PTCR (AT91_CAST(AT91_REG *) 0x00000120) // Transfer Control Register
#define SPI_PTSR (AT91_CAST(AT91_REG *) 0x00000124) // Transfer Status Register
#endif
// -------- SPI_CR : (SPI Offset: 0x00) Control Register --------
#define AT91C_SPI_CR_SPIEN (0x1 << 0) // (SPI) SPI Enable
#define AT91C_SPI_CR_SPIDIS (0x1 << 1) // (SPI) SPI Disable
#define AT91C_SPI_CR_SWRST (0x1 << 7) // (SPI) SPI Software Reset
#define AT91C_SPI_CR_LASTXFER (0x1 << 24) // (SPI) Last Transfer
// -------- SPI_MR : (SPI Offset: 0x04) Mode Register --------
#define AT91C_SPI_MR_MSTR (0x1 << 0) // (SPI) Master/Slave Mode
#define AT91C_SPI_MR_PS (0x1 << 1) // (SPI) Peripheral Select
#define   AT91C_SPI_MR_PS_FIXED (0x0 << 1) // (SPI) Fixed Peripheral Select.
#define   AT91C_SPI_MR_PS_VARIABLE (0x1 << 1) // (SPI) Variable Peripheral Select.
#define AT91C_SPI_MR_PCSDEC (0x1 << 2) // (SPI) Chip Select Decode
#define AT91C_SPI_MR_MODFDIS (0x1 << 4) // (SPI) Mode Fault Detection
#define AT91C_SPI_MR_LLB (0x1 << 7) // (SPI) Local Loopback Enable
#define AT91C_SPI_MR_PCS (0xf << 16) // (SPI) Peripheral Chip Select
#define AT91C_SPI_MR_DLYBCS (0xff << 24) // (SPI) Delay Between Chip Selects
// -------- SPI_RDR : (SPI Offset: 0x08) Receive Data Register --------
#define AT91C_SPI_RDR_RD (0xffff << 0) // (SPI) Receive Data
#define AT91C_SPI_RDR_PCS (0xf << 16) // (SPI) Peripheral Chip Select
// -------- SPI_TDR : (SPI Offset: 0x0C) Transmit Data Register --------
#define AT91C_SPI_TDR_TD (0xffff << 0) // (SPI) Transmit Data
#define AT91C_SPI_TDR_PCS (0xf << 16) // (SPI) Peripheral Chip Select
#define AT91C_SPI_TDR_LASTXFER (0x1 << 24) // (SPI) Last Transfer
// -------- SPI_SR : (SPI Offset: 0x10) Status Register --------
#define AT91C_SPI_SR_RDRF (0x1 << 0) // (SPI) Receive Data Register Full
#define AT91C_SPI_SR_TDRE (0x1 << 1) // (SPI) Transmit Data Register Empty
#define AT91C_SPI_SR_MODF (0x1 << 2) // (SPI) Mode Fault Error
#define AT91C_SPI_SR_OVRES (0x1 << 3) // (SPI) Overrun Error Status
#define AT91C_SPI_SR_ENDRX (0x1 << 4) // (SPI) End of RX buffer
#define AT91C_SPI_SR_ENDTX (0x1 << 5) // (SPI) End of TX buffer
#define AT91C_SPI_SR_RXBUFF (0x1 << 6) // (SPI) RX Buffer Full
#define AT91C_SPI_SR_TXBUFE (0x1 << 7) // (SPI) TX Buffer Empty
#define AT91C_SPI_SR_NSSR (0x1 << 8) // (SPI) NSS Rising
#define AT91C_SPI_SR_TXEMPTY (0x1 << 9) // (SPI) Transmission Registers Empty
#define AT91C_SPI_SR_SPIENS (0x1 << 16) // (SPI) SPI Enable Status
// -------- SPI_IER : (SPI Offset: 0x14) Interrupt Enable Register --------
#define AT91C_SPI_IER_RDRF (0x1 << 0) // (SPI) Receive Data Register Full Interrupt Enable
#define AT91C_SPI_IER_TDRE (0x1 << 1) // (SPI) SPI Transmit Data Register Empty Interrupt Enable
#define AT91C_SPI_IER_MODF (0x1 << 2) // (SPI) Mode Fault Error Interrupt Enable
#define AT91C_SPI_IER_OVRES (0x1 << 3) // (SPI) Overrun Error Interrupt Enable
#define AT91C_SPI_IER_ENDRX (0x1 << 4) // (SPI) End of Receive Buffer Interrupt Enable
#define AT91C_SPI_IER_ENDTX (0x1 << 5) // (SPI) End of Transmit Buffer Interrupt Enable
#define AT91C_SPI_IER_RXBUFF (0x1 << 6) // (SPI) Receive Buffer Full Interrupt Enable
#define AT91C_SPI_IER_TXBUFE (0x1 << 7) // (SPI) Transmit Buffer Empty Interrupt Enable
#define AT91C_SPI_IER_NSSR (0x1 << 8) // (SPI) NSS Rising Interrupt Enable
#define AT91C_SPI_IER_TXEMPTY (0x1 << 9) // (SPI) Transmission Registers Empty Enable
// -------- SPI_IDR : (SPI Offset: 0x18) Interrupt Disable Register --------
#define AT91C_SPI_IDR_RDRF (0x1 << 0) // (SPI) Receive Data Register Full Interrupt Disable
#define AT91C_SPI_IDR_TDRE (0x1 << 1) // (SPI) SPI Transmit Data Register Empty Interrupt Disable
#define AT91C_SPI_IDR_MODF (0x1 << 2) // (SPI) Mode Fault Error Interrupt Disable
#define AT91C_SPI_IDR_OVRES (0x1 << 3) // (SPI) Overrun Error Interrupt Disable
#define AT91C_SPI_IDR_ENDRX (0x1 << 4) // (SPI) End of Receive Buffer Interrupt Disable
#define AT91C_SPI_IDR_ENDTX (0x1 << 5) // (SPI) End of Transmit Buffer Interrupt Disable
#define AT91C_SPI_IDR_RXBUFF (0x1 << 6) // (SPI) Receive Buffer Full Interrupt Disable
#define AT91C_SPI_IDR_TXBUFE (0x1 << 7) // (SPI) Transmit Buffer Empty Interrupt Disable
#define AT91C_SPI_IDR_NSSR (0x1 << 8) // (SPI) NSS Rising Interrupt Disable
#define AT91C_SPI_IDR_TXEMPTY (0x1 << 9) // (SPI) Transmission Registers Empty Disable
// -------- SPI_IMR : (SPI Offset: 0x1C) Interrupt Mask Register --------
#define AT91C_SPI_IMR_RDRF (0x1 << 0) // (SPI) Receive Data Register Full Interrupt Mask
#define AT91C_SPI_IMR_TDRE (0x1 << 1) // (SPI) SPI Transmit Data Register Empty Interrupt Mask
#define AT91C_SPI_IMR_MODF (0x1 << 2) // (SPI) Mode Fault Error Interrupt Mask
#define AT91C_SPI_IMR_OVRES (0x1 << 3) // (SPI) Overrun Error Interrupt Mask
#define AT91C_SPI_IMR_ENDRX (0x1 << 4) // (SPI) End of Receive Buffer Interrupt Mask
#define AT91C_SPI_IMR_ENDTX (0x1 << 5) // (SPI) End of Transmit Buffer Interrupt Mask
#define AT91C_SPI_IMR_RXBUFF (0x1 << 6) // (SPI) Receive Buffer Full Interrupt Mask
#define AT91C_SPI_IMR_TXBUFE (0x1 << 7) // (SPI) Transmit Buffer Empty Interrupt Mask
#define AT91C_SPI_IMR_NSSR (0x1 << 8) // (SPI) NSS Rising Interrupt Mask
#define AT91C_SPI_IMR_TXEMPTY (0x1 << 9) // (SPI) Transmission Registers Empty Mask
// -------- SPI_CSR[4] : (SPI Offset: 0x30) Chip Select Register --------
#define AT91C_SPI_CSR_CPOL (0x1 << 0) // (SPI) Clock Polarity
#define AT91C_SPI_CSR_NCPHA (0x1 << 1) // (SPI) Clock Phase
#define AT91C_SPI_CSR_CSAAT (0x1 << 3) // (SPI) Chip Select Active After Transfer
#define AT91C_SPI_CSR_BITS (0xf << 4) // (SPI) Bits Per Transfer
#define   AT91C_SPI_CSR_BITS_8 (0x0 << 4) // (SPI) 8
#define   AT91C_SPI_CSR_BITS_9 (0x1 << 4) // (SPI) 9
#define   AT91C_SPI_CSR_BITS_10 (0x2 << 4) // (SPI) 10
#define   AT91C_SPI_CSR_BITS_11 (0x3 << 4) // (SPI) 11
#define   AT91C_SPI_CSR_BITS_12 (0x4 << 4) // (SPI) 12
#define   AT91C_SPI_CSR_BITS_13 (0x5 << 4) // (SPI) 13
#define   AT91C_SPI_CSR_BITS_14 (0x6 << 4) // (SPI) 14
#define   AT91C_SPI_CSR_BITS_15 (0x7 << 4) // (SPI) 15
#define   AT91C_SPI_CSR_BITS_16 (0x8 << 4) // (SPI) 16
#define AT91C_SPI_CSR_SCBR (0xff << 8) // (SPI) Serial Clock Baud Rate
#define AT91C_SPI_CSR_DLYBS (0xff << 16) // (SPI) Delay Before SPCK
#define AT91C_SPI_CSR_DLYBCT (0xff << 24) // (SPI) Delay Between Consecutive Transfers
// -------- SPI_RPR : (SPI Offset: 0x100) Receive Pointer Register --------
#define AT91C_SPI_RPR_RXPTR (0xffffffff << 0) // (SPI) Receive Pointer Register
// -------- SPI_RCR : (SPI Offset: 0x104) Receive Counter Register --------
#define AT91C_SPI_RCR_RXCTR (0xffff << 0) // (SPI) Receive Counter Register
// -------- SPI_TPR : (SPI Offset: 0x108) Transmit Pointer Register --------
#define AT91C_SPI_TPR_TXPTR (0xffffffff << 0) // (SPI) Transmit Counter Register
// -------- SPI_TCR : (SPI Offset: 0x10C) Transmit Counter Register --------
#define AT91C_SPI_TCR_TXCTR (0xffff << 0) // (SPI) Transmit Counter Register
// -------- SPI_RNPR : (SPI Offset: 0x110) Receive Next Pointer Register --------
#define AT91C_SPI_RNPR_RXNPTR (0xffffffff << 0) // (SPI) Receive Next Pointer
// -------- SPI_RNCR : (SPI Offset: 0x114) Receive Next Counter Register --------
#define AT91C_SPI_RNCR_RXNCTR (0xffff << 0) // (SPI) Receive Next Counter
// -------- SPI_TNPR : (SPI Offset: 0x118) Transmit Next Pointer Register --------
#define AT91C_SPI_TNPR_TXNPTR (0xffffffff << 0) // (SPI) Transmit Next Pointer
// -------- SPI_TNCR : (SPI Offset: 0x11C) Transmit Next Counter Register --------
#define AT91C_SPI_TNCR_TXNCTR (0xffff << 0) // (SPI) Transmit Counter Next
// -------- SPI_PTCR : (SPI Offset: 0x120) Transfer Control Register --------
#define AT91C_SPI_PTCR_RXTEN (0x1 << 0) // (SPI) Receiver Transfer Enable
#define AT91C_SPI_PTCR_RXTDIS (0x1 << 1) // (SPI) Receiver Transfer Disable
#define AT91C_SPI_PTCR_TXTEN (0x1 << 8) // (SPI) Transmitter Transfer Enable
#define AT91C_SPI_PTCR_TXTDIS (0x1 << 9) // (SPI) Transmitter Transfer Disable
// -------- SPI_PTSR : (SPI Offset: 0x124) Transfer Status Register --------
#define AT91C_SPI_PTSR_RXTEN (0x1 << 0) // (SPI) Receiver Transfer Enable
#define AT91C_SPI_PTSR_TXTEN (0x1 << 8) // (SPI) Transmitter Transfer Enable

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Synchronous Serial Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_SSC {
  AT91_REG SSC_CR;        // Control Register
  AT91_REG SSC_CMR;       // Clock Mode Register
  AT91_REG Reserved1[2];
  AT91_REG SSC_RCMR;      // Receive Clock Mode Register
  AT91_REG SSC_RFMR;      // Receive Frame Mode Register
  AT91_REG SSC_TCMR;      // Transmit Clock Mode Register
  AT91_REG SSC_TFMR;      // Transmit Frame Mode Register
  AT91_REG SSC_RHR;       // Receive Holding Register
  AT91_REG SSC_THR;       // Transmit Holding Register
  AT91_REG Reserved2[2];
  AT91_REG SSC_RSHR;      // Receive Sync. Holding Register
  AT91_REG SSC_TSHR;      // Transmit Sync. Holding Register
  AT91_REG SSC_RC0R;      // Receive Compare 0 Register
  AT91_REG SSC_RC1R;      // Receive Compare 1 Register
  AT91_REG SSC_SR;        // Status Register
  AT91_REG SSC_IER;       // Interrupt Enable Register
  AT91_REG SSC_IDR;       // Interrupt Disable Register
  AT91_REG SSC_IMR;       // Interrupt Mask Register
  AT91_REG Reserved3[44];
  AT91_REG SSC_RPR;       // Receive Pointer Register
  AT91_REG SSC_RCR;       // Receive Counter Register
  AT91_REG SSC_TPR;       // Transmit Pointer Register
  AT91_REG SSC_TCR;       // Transmit Counter Register
  AT91_REG SSC_RNPR;      // Receive Next Pointer Register
  AT91_REG SSC_RNCR;      // Receive Next Counter Register
  AT91_REG SSC_TNPR;      // Transmit Next Pointer Register
  AT91_REG SSC_TNCR;      // Transmit Next Counter Register
  AT91_REG SSC_PTCR;      // Transfer Control Register
  AT91_REG SSC_PTSR;      // Transfer Status Register
} AT91S_SSC, *AT91PS_SSC;
#else
#define SSC_CR   (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define SSC_CMR  (AT91_CAST(AT91_REG *) 0x00000004) // Clock Mode Register
#define SSC_RCMR (AT91_CAST(AT91_REG *) 0x00000010) // Receive Clock Mode Register
#define SSC_RFMR (AT91_CAST(AT91_REG *) 0x00000014) // Receive Frame Mode Register
#define SSC_TCMR (AT91_CAST(AT91_REG *) 0x00000018) // Transmit Clock Mode Register
#define SSC_TFMR (AT91_CAST(AT91_REG *) 0x0000001C) // Transmit Frame Mode Register
#define SSC_RHR  (AT91_CAST(AT91_REG *) 0x00000020) // Receive Holding Register
#define SSC_THR  (AT91_CAST(AT91_REG *) 0x00000024) // Transmit Holding Register
#define SSC_RSHR (AT91_CAST(AT91_REG *) 0x00000030) // Receive Sync. Holding Register
#define SSC_TSHR (AT91_CAST(AT91_REG *) 0x00000034) // Transmit Sync. Holding Register
#define SSC_RC0R (AT91_CAST(AT91_REG *) 0x00000038) // Receive Compare 0 Register
#define SSC_RC1R (AT91_CAST(AT91_REG *) 0x0000003C) // Receive Compare 1 Register
#define SSC_SR   (AT91_CAST(AT91_REG *) 0x00000040) // Status Register
#define SSC_IER  (AT91_CAST(AT91_REG *) 0x00000044) // Interrupt Enable Register
#define SSC_IDR  (AT91_CAST(AT91_REG *) 0x00000048) // Interrupt Disable Register
#define SSC_IMR  (AT91_CAST(AT91_REG *) 0x0000004C) // Interrupt Mask Register
#define SSC_RPR  (AT91_CAST(AT91_REG *) 0x00000100) // Receive Pointer Register
#define SSC_RCR  (AT91_CAST(AT91_REG *) 0x00000104) // Receive Counter Register
#define SSC_TPR  (AT91_CAST(AT91_REG *) 0x00000108) // Transmit Pointer Register
#define SSC_TCR  (AT91_CAST(AT91_REG *) 0x0000010C) // Transmit Counter Register
#define SSC_RNPR (AT91_CAST(AT91_REG *) 0x00000110) // Receive Next Pointer Register
#define SSC_RNCR (AT91_CAST(AT91_REG *) 0x00000114) // Receive Next Counter Register
#define SSC_TNPR (AT91_CAST(AT91_REG *) 0x00000118) // Transmit Next Pointer Register
#define SSC_TNCR (AT91_CAST(AT91_REG *) 0x0000011C) // Transmit Next Counter Register
#define SSC_PTCR (AT91_CAST(AT91_REG *) 0x00000120) // Transfer Control Register
#define SSC_PTSR (AT91_CAST(AT91_REG *) 0x00000124) // Transfer Status Register
#endif
// -------- SSC_CR : (SSC Offset: 0x0) Control Register --------
#define AT91C_SSC_CR_RXEN (0x1 << 0) // (SSC) Receive Enable
#define AT91C_SSC_CR_RXDIS (0x1 << 1) // (SSC) Receive Disable
#define AT91C_SSC_CR_TXEN (0x1 << 8) // (SSC) Transmit Enable
#define AT91C_SSC_CR_TXDIS (0x1 << 9) // (SSC) Transmit Disable
#define AT91C_SSC_CR_SWRST (0x1 << 15) // (SSC) Software Reset
// -------- SSC_CMR : (SSC Offset: 0x4) Clock Mode Register --------
#define AT91C_SSC_CMR_DIV (0xfff << 0) // (SSC) Clock Divider
// -------- SSC_RCMR : (SSC Offset: 0x10) Receive Clock Mode Register --------
#define AT91C_SSC_RCMR_CKS (0x3 << 0) // (SSC) Receive Clock Selection
#define   AT91C_SSC_RCMR_CKS_DIV (0x0 << 0) // (SSC) Divided Clock
#define   AT91C_SSC_RCMR_CKS_TK (0x1 << 0) // (SSC) TK Clock signal
#define   AT91C_SSC_RCMR_CKS_RK (0x2 << 0) // (SSC) RK pin
#define AT91C_SSC_RCMR_CKO (0x7 << 2) // (SSC) Receive Clock Output Mode Selection
#define AT91C_SSC_RCMR_CKI (0x1 << 5) // (SSC) Receive Clock Inversion
#define AT91C_SSC_RCMR_CKG (0x3 << 6) // (SSC) Receive Clock Gating Selection
#define   AT91C_SSC_RCMR_CKG_NONE (0x0 << 6) // (SSC) None, continuous clock
#define   AT91C_SSC_RCMR_CKG_LOW (0x1 << 6) // (SSC) Receive Clock enabled only if RF Low
#define   AT91C_SSC_RCMR_CKG_HIGH (0x2 << 6) // (SSC) Receive Clock enabled only if RF High
#define AT91C_SSC_RCMR_START (0xf << 8) // (SSC) Receive Start Selection
#define AT91C_SSC_RCMR_STOP (0x1 << 12) // (SSC) Receive Stop Selection
#define AT91C_SSC_RCMR_STTDLY (0xff << 16) // (SSC) Receive Start Delay
#define AT91C_SSC_RCMR_PERIOD (0xff << 24) // (SSC) Receive Period Divider Selection
// -------- SSC_RFMR : (SSC Offset: 0x14) Receive Frame Mode Register --------
#define AT91C_SSC_RFMR_DATLEN (0x1f << 0) // (SSC) Data Length
#define AT91C_SSC_RFMR_LOOP (0x1 << 5) // (SSC) Loop Mode
#define AT91C_SSC_RFMR_MSBF (0x1 << 7) // (SSC) Most Significant Bit First
#define AT91C_SSC_RFMR_DATNB (0xf << 8) // (SSC) Data Number per Frame
#define AT91C_SSC_RFMR_FSLEN (0xf << 16) // (SSC) Receive Frame Sync Length
#define AT91C_SSC_RFMR_FSOS (0x7 << 20) // (SSC) Receive Frame Sync Output Selection
#define AT91C_SSC_RFMR_FSEDGE (0x1 << 24) // (SSC) Frame Sync Edge Detection
#define AT91C_SSC_RFMR_FSLEN_EXT (0xf << 28) // (SSC) FSLEN Field Extension
// -------- SSC_TCMR : (SSC Offset: 0x18) Transmit Clock Mode Register --------
#define AT91C_SSC_TCMR_CKS (0x3 << 0) // (SSC) Transmit Clock Selection
#define AT91C_SSC_TCMR_CKO (0x7 << 2) // (SSC) Transmit Clock Output Mode Selection
#define AT91C_SSC_TCMR_CKI (0x1 << 5) // (SSC) Transmit Clock Inversion
#define AT91C_SSC_TCMR_CKG (0x3 << 6) // (SSC) Transmit Clock Gating Selection
#define AT91C_SSC_TCMR_START (0xf << 8) // (SSC) Transmit Start Selection
#define AT91C_SSC_TCMR_STTDLY (0xff << 16) // (SSC) Transmit Start Delay
#define AT91C_SSC_TCMR_PERIOD (0xff << 24) // (SSC) Transmit Period Divider Selection
// -------- SSC_TFMR : (SSC Offset: 0x1C) Transmit Frame Mode Register --------
#define AT91C_SSC_TFMR_DATLEN (0x1f << 0) // (SSC) Data Length
#define AT91C_SSC_TFMR_DATDEF (0x1 << 5) // (SSC) Data Default Value
#define AT91C_SSC_TFMR_MSBF (0x1 << 7) // (SSC) Most Significant Bit First
#define AT91C_SSC_TFMR_DATNB (0xf << 8) // (SSC) Data Number per frame
#define AT91C_SSC_TFMR_FSLEN (0xf << 16) // (SSC) Transmit Frame Syn Length
#define AT91C_SSC_TFMR_FSOS (0x7 << 20) // (SSC) Transmit Frame Sync Output Selection
#define AT91C_SSC_TFMR_FSDEN (0x1 << 23) // (SSC) Frame Sync Data Enable
#define AT91C_SSC_TFMR_FSEDGE (0x1 << 24) // (SSC) Frame Sync Edge Detection
#define AT91C_SSC_TFMR_FSLEN_EXT (0xf << 28) // (SSC) FSLEN Field Extension
// -------- SSC_RHR : (SSC Offset: 0x20) Receive Holding Register --------
#define AT91C_SSC_RHR_RDAT (0xffffffff << 0) // (SSC) Receive Data
// -------- SSC_THR : (SSC Offset: 0x24) Transmit Holding Register --------
#define AT91C_SSC_THR_TDAT (0xffffffff << 0) // (SSC) Transmit Data
// -------- SSC_RSHR : (SSC Offset: 0x30) Receive Sync. Holding Register --------
#define AT91C_SSC_RSHR_RSDAT (0xffff << 0) // (SSC) Receive Synchronization Data
// -------- SSC_TSHR : (SSC Offset: 0x34) Transmit Sync. Holding Register --------
#define AT91C_SSC_TSHR_TSDAT (0xffff << 0) // (SSC) Transmit Synchronization Data
// -------- SSC_RC0R : (SSC Offset: 0x38) Receive Compare 0 Register --------
#define AT91C_SSC_RC0R_CP0 (0xffff << 0) // (SSC) Receive Compare Data 0
// -------- SSC_RC1R : (SSC Offset: 0x3C) Receive Compare 1 Register --------
#define AT91C_SSC_RC1R_CP1 (0xffff << 0) // (SSC) Receive Compare Data 1
// -------- SSC_SR : (SSC Offset: 0x40) Status Register --------
#define AT91C_SSC_SR_TXRDY (0x1 << 0) // (SSC) Transmit Ready
#define AT91C_SSC_SR_TXEMPTY (0x1 << 1) // (SSC) Transmit Empty
#define AT91C_SSC_SR_ENDTX (0x1 << 2) // (SSC) End of Transmission
#define AT91C_SSC_SR_TXBUFE (0x1 << 3) // (SSC) Transmit Buffer Empty
#define AT91C_SSC_SR_RXRDY (0x1 << 4) // (SSC) Receive Ready
#define AT91C_SSC_SR_OVRUN (0x1 << 5) // (SSC) Receive Overrun
#define AT91C_SSC_SR_ENDRX (0x1 << 6) // (SSC) End of Reception
#define AT91C_SSC_SR_RXBUFF (0x1 << 7) // (SSC) Receive Buffer Full
#define AT91C_SSC_SR_CP0 (0x1 << 8) // (SSC) Compare 0
#define AT91C_SSC_SR_CP1 (0x1 << 9) // (SSC) Compare 1
#define AT91C_SSC_SR_TXSYN (0x1 << 10) // (SSC) Transmit Sync
#define AT91C_SSC_SR_RXSYN (0x1 << 11) // (SSC) Receive Sync
#define AT91C_SSC_SR_TXEN (0x1 << 16) // (SSC) Transmit Enable
#define AT91C_SSC_SR_RXEN (0x1 << 17) // (SSC) Receive Enable
// -------- SSC_IER : (SSC Offset: 0x44) Interrupt Enable Register --------
#define AT91C_SSC_IER_TXRDY (0x1 << 0) // (SSC) Transmit Ready Interrupt Enable
#define AT91C_SSC_IER_TXEMPTY (0x1 << 1) // (SSC) Transmit Empty Interrupt Enable
#define AT91C_SSC_IER_ENDTX (0x1 << 2) // (SSC) End of Transmission Interrupt Enable
#define AT91C_SSC_IER_TXBUFE (0x1 << 3) // (SSC) Transmit Buffer Empty Interrupt Enable
#define AT91C_SSC_IER_RXRDY (0x1 << 4) // (SSC) Receive Ready Interrupt Enable
#define AT91C_SSC_IER_OVRUN (0x1 << 5) // (SSC) Receive Overrun Interrupt Enable
#define AT91C_SSC_IER_ENDRX (0x1 << 6) // (SSC) End of Reception Interrupt Enable
#define AT91C_SSC_IER_RXBUFF (0x1 << 7) // (SSC) Receive Buffer Full Interrupt Enable
#define AT91C_SSC_IER_CP0 (0x1 << 8) // (SSC) Compare 0 Interrupt Enable
#define AT91C_SSC_IER_CP1 (0x1 << 9) // (SSC) Compare 1 Interrupt Enable
#define AT91C_SSC_IER_TXSYN (0x1 << 10) // (SSC) Tx Sync Interrupt Enable
#define AT91C_SSC_IER_RXSYN (0x1 << 11) // (SSC) Rx Sync Interrupt Enable
// -------- SSC_IDR : (SSC Offset: 0x48) Interrupt Disable Register --------
#define AT91C_SSC_IDR_TXRDY (0x1 << 0) // (SSC) Transmit Ready Interrupt Disable
#define AT91C_SSC_IDR_TXEMPTY (0x1 << 1) // (SSC) Transmit Empty Interrupt Disable
#define AT91C_SSC_IDR_ENDTX (0x1 << 2) // (SSC) End of Transmission Interrupt Disable
#define AT91C_SSC_IDR_TXBUFE (0x1 << 3) // (SSC) Transmit Buffer Empty Interrupt Disable
#define AT91C_SSC_IDR_RXRDY (0x1 << 4) // (SSC) Receive Ready Interrupt Disable
#define AT91C_SSC_IDR_OVRUN (0x1 << 5) // (SSC) Receive Overrun Interrupt Disable
#define AT91C_SSC_IDR_ENDRX (0x1 << 6) // (SSC) End of Reception Interrupt Disable
#define AT91C_SSC_IDR_RXBUFF (0x1 << 7) // (SSC) Receive Buffer Full Interrupt Disable
#define AT91C_SSC_IDR_CP0 (0x1 << 8) // (SSC) Compare 0 Interrupt Disable
#define AT91C_SSC_IDR_CP1 (0x1 << 9) // (SSC) Compare 1 Interrupt Disable
#define AT91C_SSC_IDR_TXSYN (0x1 << 10) // (SSC) Tx Sync Interrupt Enable
#define AT91C_SSC_IDR_RXSYN (0x1 << 11) // (SSC) Rx Sync Interrupt Enable
// -------- SSC_IMR : (SSC Offset: 0x4C) Interrupt Mask Register --------
#define AT91C_SSC_IMR_TXRDY (0x1 << 0) // (SSC) Transmit Ready Interrupt Mask
#define AT91C_SSC_IMR_TXEMPTY (0x1 << 1) // (SSC) Transmit Empty Interrupt Mask
#define AT91C_SSC_IMR_ENDTX (0x1 << 2) // (SSC) End of Transmission Interrupt Mask
#define AT91C_SSC_IMR_TXBUFE (0x1 << 3) // (SSC) Transmit Buffer Empty Interrupt Mask
#define AT91C_SSC_IMR_RXRDY (0x1 << 4) // (SSC) Receive Ready Interrupt Mask
#define AT91C_SSC_IMR_OVRUN (0x1 << 5) // (SSC) Receive Overrun Interrupt Mask
#define AT91C_SSC_IMR_ENDRX (0x1 << 6) // (SSC) End of Reception Interrupt Mask
#define AT91C_SSC_IMR_RXBUF (0x1 << 7) // (SSC)
#define AT91C_SSC_IMR_CP0 (0x1 << 8) // (SSC) Compare 0 Interrupt Mask
#define AT91C_SSC_IMR_CP1 (0x1 << 9) // (SSC) Compare 1 Interrupt Mask
#define AT91C_SSC_IMR_TXSYN (0x1 << 10) // (SSC) Tx Sync Interrupt Mask
#define AT91C_SSC_IMR_RXSYN (0x1 << 11) // (SSC) Rx Sync Interrupt Mask
// -------- SSC_RPR : (SSC Offset: 0x100) Receive Pointer Register --------
#define AT91C_SSC_RPR_RXPTR (0xffffffff << 0) // (SSC) Receive Pointer Register
// -------- SSC_RCR : (SSC Offset: 0x104) Receive Counter Register --------
#define AT91C_SSC_RCR_RXCTR (0xffff << 0) // (SSC) Receive Counter Register
// -------- SSC_TPR : (SSC Offset: 0x108) Transmit Pointer Register --------
#define AT91C_SSC_TPR_TXPTR (0xffffffff << 0) // (SSC) Transmit Counter Register
// -------- SSC_TCR : (SSC Offset: 0x10C) Transmit Counter Register --------
#define AT91C_SSC_TCR_TXCTR (0xffff << 0) // (SSC) Transmit Counter Register
// -------- SSC_RNPR : (SSC Offset: 0x110) Receive Next Pointer Register --------
#define AT91C_SSC_RNPR_RXNPTR (0xffffffff << 0) // (SSC) Receive Next Pointer
// -------- SSC_RNCR : (SSC Offset: 0x114) Receive Next Counter Register --------
#define AT91C_SSC_RNCR_RXNCTR (0xffff << 0) // (SSC) Receive Next Counter
// -------- SSC_TNPR : (SSC Offset: 0x118) Transmit Next Pointer Register --------
#define AT91C_SSC_TNPR_TXNPTR (0xffffffff << 0) // (SSC) Transmit Next Pointer
// -------- SSC_TNCR : (SSC Offset: 0x11C) Transmit Next Counter Register --------
#define AT91C_SSC_TNCR_TXNCTR (0xffff << 0) // (SSC) Transmit Counter Next
// -------- SSC_PTCR : (SSC Offset: 0x120) Transfer Control Register --------
#define AT91C_SSC_PTCR_RXTEN (0x1 << 0) // (SSC) Receiver Transfer Enable
#define AT91C_SSC_PTCR_RXTDIS (0x1 << 1) // (SSC) Receiver Transfer Disable
#define AT91C_SSC_PTCR_TXTEN (0x1 << 8) // (SSC) Transmitter Transfer Enable
#define AT91C_SSC_PTCR_TXTDIS (0x1 << 9) // (SSC) Transmitter Transfer Disable
// -------- SSC_PTSR : (SSC Offset: 0x124) Transfer Status Register --------
#define AT91C_SSC_PTSR_RXTEN (0x1 << 0) // (SSC) Receiver Transfer Enable
#define AT91C_SSC_PTSR_TXTEN (0x1 << 8) // (SSC) Transmitter Transfer Enable

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Timer Counter
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_TC {
  AT91_REG TC_CCR;      // Channel Control Register
  AT91_REG TC_CMR;      // Channel Mode Register
  AT91_REG Reserved1[2];
  AT91_REG TC_CV;       // Counter Value
  AT91_REG TC_RA;       // Register A
  AT91_REG TC_RB;       // Register B
  AT91_REG TC_RC;       // Register C
  AT91_REG TC_SR;       // Status Register
  AT91_REG TC_IER;      // Interrupt Enable Register
  AT91_REG TC_IDR;      // Interrupt Disable Register
  AT91_REG TC_IMR;      // Interrupt Mask Register
  AT91_REG Reserved2[4];

  AT91_REG TC_BCR;       // Block Control Register
  AT91_REG TC_BMR;       // Block Mode Register
} AT91S_TC, *AT91PS_TC;
#else
#define TC_CCR (AT91_CAST(AT91_REG *) 0x00000000) // Channel Control Register
#define TC_CMR (AT91_CAST(AT91_REG *) 0x00000004) // Channel Mode Register
#define TC_CV  (AT91_CAST(AT91_REG *) 0x00000010) // Counter Value
#define TC_RA  (AT91_CAST(AT91_REG *) 0x00000014) // Register A
#define TC_RB  (AT91_CAST(AT91_REG *) 0x00000018) // Register B
#define TC_RC  (AT91_CAST(AT91_REG *) 0x0000001C) // Register C
#define TC_SR  (AT91_CAST(AT91_REG *) 0x00000020) // Status Register
#define TC_IER (AT91_CAST(AT91_REG *) 0x00000024) // Interrupt Enable Register
#define TC_IDR (AT91_CAST(AT91_REG *) 0x00000028) // Interrupt Disable Register
#define TC_IMR (AT91_CAST(AT91_REG *) 0x0000002C) // Interrupt Mask Register
#define TC_BCR  (AT91_CAST(AT91_REG *) 0x000000C0) // Block Control Register
#define TC_BMR  (AT91_CAST(AT91_REG *) 0x000000C4) // Block Mode Register
#endif

// -------- TC_CCR : (TC Offset: 0x0) Channel Control Register --------
#define AT91C_TC_CCR_CLKEN (0x1 << 0) // (TC) Counter Clock Enable Command
#define AT91C_TC_CCR_CLKDIS (0x1 << 1) // (TC) Counter Clock Disable Command
#define AT91C_TC_CCR_SWTRG (0x1 << 2) // (TC) Software Trigger Command
// -------- TC_CMR : (TC Offset: 0x4) Channel Mode Register --------
#define AT91C_TC_CMR_TCCLKS (0x7 << 0) // (TC) Clock Selection
#define     AT91C_TC_CMR_TCCLKS_TIMER_DIV1_CLOCK     ( 0x0) // (TC) Clock selected: TIMER_DIV1_CLOCK
#define AT91C_TC_CMR_CLKI (0x1 << 3) // (TC) Clock Invert
#define AT91C_TC_CMR_BURST (0x3 << 4) // (TC) Burst Signal Selection
#define AT91C_TC_CMR_LDBSTOP (0x1 << 6) // (TC) Counter Clock Stopped with RB Loading
#define AT91C_TC_CMR_LDBDIS (0x1 << 7) // (TC) Counter Clock Disable with RB Loading
#define AT91C_TC_CMR_ETRGEDG (0x3 << 8) // (TC) External Trigger Edge Selection
#define AT91C_TC_CMR_ABETRG (0x1 << 10) // (TC) TIOA or TIOB External Trigger Selection
#define AT91C_TC_CMR_CPCTRG (0x1 << 14) // (TC) RC Compare Trigger Enable
#define AT91C_TC_CMR_WAVE (0x1 << 15) // (TC)
#define AT91C_TC_CMR_LDRA (0x3 << 16) // (TC) RA Loading Selection
#define AT91C_TC_CMR_LDRB (0x3 << 18) // (TC) RB Loading Selection
// -------- TC_CV : (TC Offset: 0x10) Counter Value --------
#define AT91C_TC_CV_CV (0xffff << 0) // (TC) Counter Value
// -------- TC_RA : (TC Offset: 0x14) Register A --------
#define AT91C_TC_RA_RA (0xffff << 0) // (TC) Register A
// -------- TC_RB : (TC Offset: 0x18) Register B --------
#define AT91C_TC_RB_RB (0xffff << 0) // (TC) Register B
// -------- TC_RC : (TC Offset: 0x1C) Register C --------
#define AT91C_TC_RC_RC (0xffff << 0) // (TC) Register C
// -------- TC_SR : (TC Offset: 0x20) Status Register --------
#define AT91C_TC_SR_COVFS (0x1 << 0) // (TC) Counter Overflow Status
#define AT91C_TC_SR_LOVRS (0x1 << 1) // (TC) Load Overrun Status
#define AT91C_TC_SR_CPAS (0x1 << 2) // (TC) RA Compare Status
#define AT91C_TC_SR_CPBS (0x1 << 3) // (TC) RB Compare Status
#define AT91C_TC_SR_CPCS (0x1 << 4) // (TC) RC Compare Status
#define AT91C_TC_SR_LDRAS (0x1 << 5) // (TC) RA Loading Status
#define AT91C_TC_SR_LDRBS (0x1 << 6) // (TC) RB Loading Status
#define AT91C_TC_SR_ETRGS (0x1 << 7) // (TC) External Trigger Status
#define AT91C_TC_SR_CLKSTA (0x1 << 16) // (TC) Clock Enabling Status
#define AT91C_TC_SR_MTIOA (0x1 << 17) // (TC) TIOA Mirror
#define AT91C_TC_SR_MTIOB (0x1 << 18) // (TC) TIOB Mirror
// -------- TC_IER : (TC Offset: 0x24) Interrupt Enable Register --------
#define AT91C_TC_IER_COVFS (0x1 << 0) // (TC) Counter Overflow
#define AT91C_TC_IER_LOVRS (0x1 << 1) // (TC) Load Overrun
#define AT91C_TC_IER_CPAS (0x1 << 2) // (TC) RA Compare
#define AT91C_TC_IER_CPBS (0x1 << 3) // (TC) RB Compare
#define AT91C_TC_IER_CPCS (0x1 << 4) // (TC) RC Compare
#define AT91C_TC_IER_LDRAS (0x1 << 5) // (TC) RA Loading
#define AT91C_TC_IER_LDRBS (0x1 << 6) // (TC) RB Loading
#define AT91C_TC_IER_ETRGS (0x1 << 7) // (TC) External Trigger
// -------- TC_IDR : (TC Offset: 0x28) Interrupt Disable Register --------
#define AT91C_TC_IDR_COVFS (0x1 << 0) // (TC) Counter Overflow
#define AT91C_TC_IDR_LOVRS (0x1 << 1) // (TC) Load Overrun
#define AT91C_TC_IDR_CPAS (0x1 << 2) // (TC) RA Compare
#define AT91C_TC_IDR_CPBS (0x1 << 3) // (TC) RB Compare
#define AT91C_TC_IDR_CPCS (0x1 << 4) // (TC) RC Compare
#define AT91C_TC_IDR_LDRAS (0x1 << 5) // (TC) RA Loading
#define AT91C_TC_IDR_LDRBS (0x1 << 6) // (TC) RB Loading
#define AT91C_TC_IDR_ETRGS (0x1 << 7) // (TC) External Trigger
// -------- TC_IMR : (TC Offset: 0x2C) Interrupt Mask Register --------
#define AT91C_TC_IMR_COVFS (0x1 << 0) // (TC) Counter Overflow
#define AT91C_TC_IMR_LOVRS (0x1 << 1) // (TC) Load Overrun
#define AT91C_TC_IMR_CPAS (0x1 << 2) // (TC) RA Compare
#define AT91C_TC_IMR_CPBS (0x1 << 3) // (TC) RB Compare
#define AT91C_TC_IMR_CPCS (0x1 << 4) // (TC) RC Compare
#define AT91C_TC_IMR_LDRAS (0x1 << 5) // (TC) RA Loading
#define AT91C_TC_IMR_LDRBS (0x1 << 6) // (TC) RB Loading
#define AT91C_TC_IMR_ETRGS (0x1 << 7) // (TC) External Trigger


// *****************************************************************************
//              SOFTWARE API DEFINITION  FOR Timer Counter Interface
// *****************************************************************************
typedef struct _AT91S_TCB {
    AT91S_TC     TCB_TC0;   // TC Channel 0
    AT91_REG     Reserved0[4];  //
    AT91S_TC     TCB_TC1;   // TC Channel 1
    AT91_REG     Reserved1[4];  //
    AT91S_TC     TCB_TC2;   // TC Channel 2
    AT91_REG     Reserved2[4];  //
    AT91_REG     TCB_BCR;   // TC Block Control Register
    AT91_REG     TCB_BMR;   // TC Block Mode Register
} AT91S_TCB, *AT91PS_TCB;

// -------- TC_BCR : (TC Offset: 0xC0) Block Control Register --------
#define AT91C_TC_BCR_SYNC (0x1 << 0) // (TC) Synchro Command
// -------- TC_BMR : (TC Offset: 0xC4) Block Mode Register --------
#define AT91C_TC_BMR_TC0XC0S (0x3 << 0) // (TC) External Clock Signal 0 Selection
#define   AT91C_TC_BMR_TC0XC0S_TCLK0 (0x0 << 0) // (TC) TCLK0
#define   AT91C_TC_BMR_TC0XC0S_NONE (0x1 << 0) // (TC) none
#define   AT91C_TC_BMR_TC0XC0S_TIOA1 (0x2 << 0) // (TC) TIOA1
#define   AT91C_TC_BMR_TC0XC0S_TIOA2 (0x3 << 0) // (TC) TIOA2
#define AT91C_TC_BMR_TC1XC1S (0x3 << 2) // (TC) External Clock Signal 1 Selection
#define   AT91C_TC_BMR_TC1XC1S_TCLK1 (0x0 << 2) // (TC) TCLK1
#define   AT91C_TC_BMR_TC1XC1S_NONE (0x1 << 2) // (TC) none
#define   AT91C_TC_BMR_TC1XC1S_TIOA0 (0x2 << 2) // (TC) TIOA0
#define   AT91C_TC_BMR_TC1XC1S_TIOA2 (0x3 << 2) // (TC) TIOA2
#define AT91C_TC_BMR_TC2XC2S (0x3 << 4) // (TC) External Clock Signal 2 Selection
#define   AT91C_TC_BMR_TC2XC2S_TCLK2 (0x0 << 4) // (TC) TCLK2
#define   AT91C_TC_BMR_TC2XC2S_NONE (0x1 << 4) // (TC) none
#define   AT91C_TC_BMR_TC2XC2S_TIOA0 (0x2 << 4) // (TC) TIOA0
#define   AT91C_TC_BMR_TC2XC2S_TIOA1 (0x3 << 4) // (TC) TIOA1

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Triple Data Encryption Standard
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_TDES {
  AT91_REG TDES_CR;        // Control Register
  AT91_REG TDES_MR;        // Mode Register
  AT91_REG Reserved1[2];
  AT91_REG TDES_IER;       // Interrupt Enable Register
  AT91_REG TDES_IDR;       // Interrupt Disable Register
  AT91_REG TDES_IMR;       // Interrupt Mask Register
  AT91_REG TDES_ISR;       // Interrupt Status Register
  AT91_REG TDES_KEY1WR[2]; // Key 1 Word Register
  AT91_REG TDES_KEY2WR[2]; // Key 2 Word Register
  AT91_REG TDES_KEY3WR[2]; // Key 3 Word Register
  AT91_REG Reserved2[2];
  AT91_REG TDES_IDATAR[2]; // Input Data Register
  AT91_REG Reserved3[2];
  AT91_REG TDES_ODATAR[2]; // Output Data Register
  AT91_REG Reserved4[2];
  AT91_REG TDES_IVR[2];    // Initialization Vector Register
  AT91_REG Reserved5[38];
  AT91_REG TDES_RPR;       // Receive Pointer Register
  AT91_REG TDES_RCR;       // Receive Counter Register
  AT91_REG TDES_TPR;       // Transmit Pointer Register
  AT91_REG TDES_TCR;       // Transmit Counter Register
  AT91_REG TDES_RNPR;      // Receive Next Pointer Register
  AT91_REG TDES_RNCR;      // Receive Next Counter Register
  AT91_REG TDES_TNPR;      // Transmit Next Pointer Register
  AT91_REG TDES_TNCR;      // Transmit Next Counter Register
  AT91_REG TDES_PTCR;      // Transfer Control Register
  AT91_REG TDES_PTSR;      // Transfer Status Register
} AT91S_TDES, *AT91PS_TDES;
#else
#define TDES_CR     (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define TDES_MR     (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define TDES_IER    (AT91_CAST(AT91_REG *) 0x00000010) // Interrupt Enable Register
#define TDES_IDR    (AT91_CAST(AT91_REG *) 0x00000014) // Interrupt Disable Register
#define TDES_IMR    (AT91_CAST(AT91_REG *) 0x00000018) // Interrupt Mask Register
#define TDES_ISR    (AT91_CAST(AT91_REG *) 0x0000001C) // Interrupt Status Register
#define TDES_KEY1WR (AT91_CAST(AT91_REG *) 0x00000020) // Key 1 Word Register
#define TDES_KEY2WR (AT91_CAST(AT91_REG *) 0x00000028) // Key 2 Word Register
#define TDES_KEY3WR (AT91_CAST(AT91_REG *) 0x00000030) // Key 3 Word Register
#define TDES_IDATAR (AT91_CAST(AT91_REG *) 0x00000040) // Input Data Register
#define TDES_ODATAR (AT91_CAST(AT91_REG *) 0x00000050) // Output Data Register
#define TDES_IVR    (AT91_CAST(AT91_REG *) 0x00000060) // Initialization Vector Register
#define TDES_RPR    (AT91_CAST(AT91_REG *) 0x00000100) // Receive Pointer Register
#define TDES_RCR    (AT91_CAST(AT91_REG *) 0x00000104) // Receive Counter Register
#define TDES_TPR    (AT91_CAST(AT91_REG *) 0x00000108) // Transmit Pointer Register
#define TDES_TCR    (AT91_CAST(AT91_REG *) 0x0000010C) // Transmit Counter Register
#define TDES_RNPR   (AT91_CAST(AT91_REG *) 0x00000110) // Receive Next Pointer Register
#define TDES_RNCR   (AT91_CAST(AT91_REG *) 0x00000114) // Receive Next Counter Register
#define TDES_TNPR   (AT91_CAST(AT91_REG *) 0x00000118) // Transmit Next Pointer Register
#define TDES_TNCR   (AT91_CAST(AT91_REG *) 0x0000011C) // Transmit Next Counter Register
#define TDES_PTCR   (AT91_CAST(AT91_REG *) 0x00000120) // Transfer Control Register
#define TDES_PTSR   (AT91_CAST(AT91_REG *) 0x00000124) // Transfer Status Register
#endif
// -------- TDES_CR : (TDES Offset: 0x00) Control Register --------
#define AT91C_TDES_CR_START (0x1 << 0) // (TDES) Start Processing
#define AT91C_TDES_CR_SWRST (0x1 << 8) // (TDES) Software Reset
#define AT91C_TDES_CR_LOADSEED (0x1 << 16) // (TDES) Load Seed
// -------- TDES_MR : (TDES Offset: 0x04) Mode Register --------
#define AT91C_TDES_MR_CIPHER (0x1 << 0) // (TDES) Processing Mode
#define AT91C_TDES_MR_TDESMOD (0x1 << 1) // (TDES) ALGORITHM mode
#define AT91C_TDES_MR_KEYMOD (0x1 << 4) // (TDES) Key Mode
#define AT91C_TDES_MR_SMOD (0x3 << 8) // (TDES) Start Mode
#define AT91C_TDES_MR_OPMOD (0x3 << 12) // (TDES) Operation Mode
#define AT91C_TDES_MR_LOD (0x1 << 15) // (TDES) Last Output Data Mode
#define AT91C_TDES_MR_CFBS (0x3 << 16) // (TDES) Cipher Feedback Data Size
#define AT91C_TDES_MR_CKEY (0xf << 20) // (TDES) Countermeasure Key
#define AT91C_TDES_MR_CTYPE (0x3f << 24) // (TDES) Countermeasure Type
// -------- TDES_IER : (TDES Offset: 0x10) Interrupt Enable Register --------
#define AT91C_TDES_IER_DATRDY (0x1 << 0) // (TDES) Data Ready Interrupt Enable
#define AT91C_TDES_IER_ENDRX (0x1 << 1) // (TDES) End of Receive Buffer Interrupt Enable
#define AT91C_TDES_IER_ENDTX (0x1 << 2) // (TDES) End of Transmit Buffer Interrupt Enable
#define AT91C_TDES_IER_RXBUFF (0x1 << 3) // (TDES) Receive Buffer Full Interrupt Enable
#define AT91C_TDES_IER_TXBUFE (0x1 << 4) // (TDES) Transmit Buffer Empty Interrupt Enable
#define AT91C_TDES_IER_URAD (0x1 << 8) // (TDES) Unspecified Register Access Detection Interrupt Enable
// -------- TDES_IDR : (TDES Offset: 0x14) Interrupt Disable Register --------
#define AT91C_TDES_IDR_DATRDY (0x1 << 0) // (TDES) Data Ready Interrupt Disable
#define AT91C_TDES_IDR_ENDRX (0x1 << 1) // (TDES) End of Receive Buffer Interrupt Disable
#define AT91C_TDES_IDR_ENDTX (0x1 << 2) // (TDES) End of Transmit Buffer Interrupt Disable
#define AT91C_TDES_IDR_RXBUFF (0x1 << 3) // (TDES) Receive Buffer Full Interrupt Disable
#define AT91C_TDES_IDR_TXBUFE (0x1 << 4) // (TDES) Transmit Buffer Empty Interrupt Disable
#define AT91C_TDES_IDR_URAD (0x1 << 8) // (TDES) Unspecified Register Access Detection Interrupt Disable
// -------- TDES_IMR : (TDES Offset: 0x18) Interrupt Mask Register --------
#define AT91C_TDES_IMR_DATRDY (0x1 << 0) // (TDES) Data Ready Interrupt Mask
#define AT91C_TDES_IMR_ENDRX (0x1 << 1) // (TDES) End of Receive Buffer Interrupt Mask
#define AT91C_TDES_IMR_ENDTX (0x1 << 2) // (TDES) End of Transmit Buffer Interrupt Mask
#define AT91C_TDES_IMR_RXBUFF (0x1 << 3) // (TDES) Receive Buffer Full Interrupt Mask
#define AT91C_TDES_IMR_TXBUFE (0x1 << 4) // (TDES) Transmit Buffer Empty Interrupt Mask
#define AT91C_TDES_IMR_URAD (0x1 << 8) // (TDES) Unspecified Register Access Detection Interrupt Mask
// -------- TDES_ISR : (TDES Offset: 0x1C) Interrupt Status Register --------
#define AT91C_TDES_ISR_DATRDY (0x1 << 0) // (TDES) Data Ready
#define AT91C_TDES_ISR_ENDRX (0x1 << 1) // (TDES) End of RX Buffer
#define AT91C_TDES_ISR_ENDTX (0x1 << 2) // (TDES) End of TX Buffer
#define AT91C_TDES_ISR_RXBUFF (0x1 << 3) // (TDES) RX Buffer Full
#define AT91C_TDES_ISR_TXBUFE (0x1 << 4) // (TDES) TX Buffer Empty
#define AT91C_TDES_ISR_URAD (0x1 << 8) // (TDES) Unspecified Register Access Detection Status
#define AT91C_TDES_ISR_URAT (0x3 << 12) // (TDES) Unspecified Register Access Type:
// -------- TDES_KEY1WR[2] : (TDES Offset: 0x20) Key 1 Word Register --------
#define AT91C_TDES_KEY1WR_KEY1Wx (0xffffffff << 0) // (TDES) Key 1 Word x
// -------- TDES_KEY2WR[2] : (TDES Offset: 0x28) Key 2 Word Register --------
#define AT91C_TDES_KEY2WR_KEY2Wx (0xffffffff << 0) // (TDES) Key 2 Word x
// -------- TDES_KEY3WR[2] : (TDES Offset: 0x30) Key 3 Word Register --------
#define AT91C_TDES_KEY3WR_KEY3Wx (0xffffffff << 0) // (TDES) Key 3 Word x
// -------- TDES_IDATAR[2] : (TDES Offset: 0x40) Input Data Register --------
#define AT91C_TDES_IDATAR_IDATAx (0xffffffff << 0) // (TDES) Input Data x
// -------- TDES_ODATAR[2] : (TDES Offset: 0x50) Output Data Register --------
#define AT91C_TDES_ODATAR_ODATAx (0xffffffff << 0) // (TDES) Output Data x
// -------- TDES_IVR[2] : (TDES Offset: 0x60) Initialization Vector Register --------
#define AT91C_TDES_IVR_IVx (0xffffffff << 0) // (TDES) Initialization Vector x
// -------- TDES_RPR : (TDES Offset: 0x100) Receive Pointer Register --------
#define AT91C_TDES_RPR_RXPTR (0xffffffff << 0) // (TDES) Receive Pointer Register
// -------- TDES_RCR : (TDES Offset: 0x104) Receive Counter Register --------
#define AT91C_TDES_RCR_RXCTR (0xffff << 0) // (TDES) Receive Counter Register
// -------- TDES_TPR : (TDES Offset: 0x108) Transmit Pointer Register --------
#define AT91C_TDES_TPR_TXPTR (0xffffffff << 0) // (TDES) Transmit Counter Register
// -------- TDES_TCR : (TDES Offset: 0x10C) Transmit Counter Register --------
#define AT91C_TDES_TCR_TXCTR (0xffff << 0) // (TDES) Transmit Counter Register
// -------- TDES_RNPR : (TDES Offset: 0x110) Receive Next Pointer Register --------
#define AT91C_TDES_RNPR_RXNPTR (0xffffffff << 0) // (TDES) Receive Next Pointer
// -------- TDES_RNCR : (TDES Offset: 0x114) Receive Next Counter Register --------
#define AT91C_TDES_RNCR_RXNCTR (0xffff << 0) // (TDES) Receive Next Counter
// -------- TDES_TNPR : (TDES Offset: 0x118) Transmit Next Pointer Register --------
#define AT91C_TDES_TNPR_TXNPTR (0xffffffff << 0) // (TDES) Transmit Next Pointer
// -------- TDES_TNCR : (TDES Offset: 0x11C) Transmit Next Counter Register --------
#define AT91C_TDES_TNCR_TXNCTR (0xffff << 0) // (TDES) Transmit Counter Next
// -------- TDES_PTCR : (TDES Offset: 0x120) Transfer Control Register --------
#define AT91C_TDES_PTCR_RXTEN (0x1 << 0) // (TDES) Receiver Transfer Enable
#define AT91C_TDES_PTCR_RXTDIS (0x1 << 1) // (TDES) Receiver Transfer Disable
#define AT91C_TDES_PTCR_TXTEN (0x1 << 8) // (TDES) Transmitter Transfer Enable
#define AT91C_TDES_PTCR_TXTDIS (0x1 << 9) // (TDES) Transmitter Transfer Disable
// -------- TDES_PTSR : (TDES Offset: 0x124) Transfer Status Register --------
#define AT91C_TDES_PTSR_RXTEN (0x1 << 0) // (TDES) Receiver Transfer Enable
#define AT91C_TDES_PTSR_TXTEN (0x1 << 8) // (TDES) Transmitter Transfer Enable

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR True Random Number Generator
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_TRNG {
  AT91_REG TRNG_CR;       // Control Register
  AT91_REG Reserved1[4];
  AT91_REG TRNG_IER;      // Interrupt Enable Register
  AT91_REG TRNG_IDR;      // Interrupt Disable Register
  AT91_REG TRNG_IMR;      // Interrupt Mask Register
  AT91_REG TRNG_ISR;      // Interrupt Status Register
  AT91_REG Reserved2[12];
  AT91_REG TRNG_ODATA;    // Output Data Register
} AT91S_TRNG, *AT91PS_TRNG;
#else
#define TRNG_CR    (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define TRNG_IER   (AT91_CAST(AT91_REG *) 0x00000010) // Interrupt Enable Register
#define TRNG_IDR   (AT91_CAST(AT91_REG *) 0x00000014) // Interrupt Disable Register
#define TRNG_IMR   (AT91_CAST(AT91_REG *) 0x00000018) // Interrupt Mask Register
#define TRNG_ISR   (AT91_CAST(AT91_REG *) 0x0000001C) // Interrupt Status Register
#define TRNG_ODATA (AT91_CAST(AT91_REG *) 0x00000050) // Output Data Register
#endif
// -------- TRNG_CR : (TRNG Offset: 0x00) Control Register --------
#define AT91C_TRNG_CR_ENABLE (0x1 << 0) // (TRNG) Enables the TRNG to provide random values
// -------- TRNG_IER : (TRNG Offset: 0x10) Interrupt Enable Register --------
#define AT91C_TRNG_IER_DATRDY (0x1 << 0) // (TRNG) Data Ready Interrupt Enable
// -------- TRNG_IDR : (TRNG Offset: 0x14) Interrupt Disable Register --------
#define AT91C_TRNG_IDR_DATRDY (0x1 << 0) // (TRNG) Data Ready Interrupt Disable
// -------- TRNG_IMR : (TRNG Offset: 0x18) Interrupt Mask Register --------
#define AT91C_TRNG_IMR_DATRDY (0x1 << 0) // (TRNG) Data Ready Interrupt Mask
// -------- TRNG_ISR : (TRNG Offset: 0x1C) Interrupt Status Register --------
#define AT91C_TRNG_ISR_DATRDY (0x1 << 0) // (TRNG) Data Ready
// -------- TRNG_ODATA : (TRNG Offset: 0x50) Output Data Register --------
#define AT91C_TRNG_ODATA_ODATA (0xffffffff << 0) // (TRNG) Output Data

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Touch Screen ADC Controller
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_TSADCC {
  AT91_REG TSADCC_CR;     // Control Register
  AT91_REG TSADCC_MR;     // Mode Register
  AT91_REG TSADCC_TRGR;   // Trigger Register
  AT91_REG TSADCC_TSR;    // Touch Screen Register
  AT91_REG TSADCC_CHER;   // Channel Enable Register
  AT91_REG TSADCC_CHDR;   // Channel Disable Register
  AT91_REG TSADCC_CHSR;   // Channel Status Register
  AT91_REG TSADCC_SR;     // Status Register
  AT91_REG TSADCC_LCDR;   // Last Converted Data Register
  AT91_REG TSADCC_IER;    // Interrupt Enable Register
  AT91_REG TSADCC_IDR;    // Interrupt Disable Register
  AT91_REG TSADCC_IMR;    // Interrupt Mask Register
  AT91_REG TSADCC_CDR[8]; // Channel Data Register
  AT91_REG Reserved1[44];
  AT91_REG TSADCC_RPR;    // Receive Pointer Register
  AT91_REG TSADCC_RCR;    // Receive Counter Register
  AT91_REG TSADCC_TPR;    // Transmit Pointer Register
  AT91_REG TSADCC_TCR;    // Transmit Counter Register
  AT91_REG TSADCC_RNPR;   // Receive Next Pointer Register
  AT91_REG TSADCC_RNCR;   // Receive Next Counter Register
  AT91_REG TSADCC_TNPR;   // Transmit Next Pointer Register
  AT91_REG TSADCC_TNCR;   // Transmit Next Counter Register
  AT91_REG TSADCC_PTCR;   // Transfer Control Register
  AT91_REG TSADCC_PTSR;   // Transfer Status Register
} AT91S_TSADCC, *AT91PS_TSADCC;
#else
#define TSADCC_CR   (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define TSADCC_MR   (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define TSADCC_TRGR (AT91_CAST(AT91_REG *) 0x00000008) // Trigger Register
#define TSADCC_TSR  (AT91_CAST(AT91_REG *) 0x0000000C) // Touch Screen Register
#define TSADCC_CHER (AT91_CAST(AT91_REG *) 0x00000010) // Channel Enable Register
#define TSADCC_CHDR (AT91_CAST(AT91_REG *) 0x00000014) // Channel Disable Register
#define TSADCC_CHSR (AT91_CAST(AT91_REG *) 0x00000018) // Channel Status Register
#define TSADCC_SR   (AT91_CAST(AT91_REG *) 0x0000001C) // Status Register
#define TSADCC_LCDR (AT91_CAST(AT91_REG *) 0x00000020) // Last Converted Data Register
#define TSADCC_IER  (AT91_CAST(AT91_REG *) 0x00000024) // Interrupt Enable Register
#define TSADCC_IDR  (AT91_CAST(AT91_REG *) 0x00000028) // Interrupt Disable Register
#define TSADCC_IMR  (AT91_CAST(AT91_REG *) 0x0000002C) // Interrupt Mask Register
#define TSADCC_CDR  (AT91_CAST(AT91_REG *) 0x00000030) // Channel Data Register
#define TSADCC_RPR  (AT91_CAST(AT91_REG *) 0x00000100) // Receive Pointer Register
#define TSADCC_RCR  (AT91_CAST(AT91_REG *) 0x00000104) // Receive Counter Register
#define TSADCC_TPR  (AT91_CAST(AT91_REG *) 0x00000108) // Transmit Pointer Register
#define TSADCC_TCR  (AT91_CAST(AT91_REG *) 0x0000010C) // Transmit Counter Register
#define TSADCC_RNPR (AT91_CAST(AT91_REG *) 0x00000110) // Receive Next Pointer Register
#define TSADCC_RNCR (AT91_CAST(AT91_REG *) 0x00000114) // Receive Next Counter Register
#define TSADCC_TNPR (AT91_CAST(AT91_REG *) 0x00000118) // Transmit Next Pointer Register
#define TSADCC_TNCR (AT91_CAST(AT91_REG *) 0x0000011C) // Transmit Next Counter Register
#define TSADCC_PTCR (AT91_CAST(AT91_REG *) 0x00000120) // Transfer Control Register
#define TSADCC_PTSR (AT91_CAST(AT91_REG *) 0x00000124) // Transfer Status Register
#endif
// -------- TSADCC_CR : (TSADCC Offset: 0x00) Control Register --------
#define AT91C_TSADCC_CR_SWRST (0x1 << 0) // (TSADCC) Software Reset
#define AT91C_TSADCC_CR_START (0x1 << 1) // (TSADCC) Start Conversion
// -------- TSADCC_MR : (TSADCC Offset: 0x04) Mode Register --------
#define AT91C_TSADCC_MR_TSAMOD (0x3 << 0) // (TSADCC) Touch Screen ADC Mode
#define   AT91C_TSADCC_MR_TSAMOD_ADC_ONLY_MODE (0x0 << 0) // (TSADCC) ADC Mode
#define   AT91C_TSADCC_MR_TSAMOD_TS_ONLY_MODE (0x1 << 0) // (TSADCC) Touch Screen Only Mode
#define AT91C_TSADCC_MR_LOWRES (0x1 << 4) // (TSADCC) Resolution Selection
#define AT91C_TSADCC_MR_SLEEP (0x1 << 5) // (TSADCC) Sleep Mode
#define AT91C_TSADCC_MR_PENDET (0x1 << 6) // (TSADCC) Pen Detect Selection
#define AT91C_TSADCC_MR_PRESCAL (0x3f << 8) // (TSADCC) Prescaler Rate Selection
#define AT91C_TSADCC_MR_STARTUP (0x7f << 16) // (TSADCC) Start Up Time
#define AT91C_TSADCC_MR_SHTIM (0xf << 24) // (TSADCC) Sample & Hold Time for ADC Channels
#define AT91C_TSADCC_MR_PENDBC (0xf << 28) // (TSADCC) Pen Detect debouncing period
// -------- TSADCC_TRGR : (TSADCC Offset: 0x08) Trigger Register --------
#define AT91C_TSADCC_TRGR_TRGMOD (0x7 << 0) // (TSADCC) Trigger Mode
#define   AT91C_TSADCC_TRGR_TRGMOD_NO_TRIGGER (0x0 << 0) // (TSADCC) No trigger, only software trigger can start conversions
#define   AT91C_TSADCC_TRGR_TRGMOD_EXTERNAL_TRIGGER_RE (0x1 << 0) // (TSADCC) External Trigger Rising Edge
#define   AT91C_TSADCC_TRGR_TRGMOD_EXTERNAL_TRIGGER_FE (0x2 << 0) // (TSADCC) External Trigger Falling Edge
#define   AT91C_TSADCC_TRGR_TRGMOD_EXTERNAL_TRIGGER_AE (0x3 << 0) // (TSADCC) External Trigger Any Edge
#define   AT91C_TSADCC_TRGR_TRGMOD_PENDET_TRIGGER (0x4 << 0) // (TSADCC) Pen Detect Trigger (shall be selected only if PENDET is set and TSAMOD = Touch Screen only mode)
#define   AT91C_TSADCC_TRGR_TRGMOD_PERIODIC_TRIGGER (0x5 << 0) // (TSADCC) Periodic Trigger (TRGPER shall be initiated appropriately)
#define   AT91C_TSADCC_TRGR_TRGMOD_CONT_TRIGGER (0x6 << 0) // (TSADCC) Continuous Mode
#define AT91C_TSADCC_TRGR_TRGPER (0xffff << 16) // (TSADCC) Trigger Period
// -------- TSADCC_TSR : (TSADCC Offset: 0x0C) Touch Screen Register --------
#define AT91C_TSADCC_TSR_TSFREQ (0xf << 0) // (TSADCC) Touch Screen Frequency in Interleaved Mode
#define AT91C_TSADCC_TSR_TSSHTIM (0xf << 24) // (TSADCC) Sample & Hold Time for Touch Screen Channels
// -------- TSADCC_CHER : (TSADCC Offset: 0x10) Channel Enable Register --------
#define AT91C_TSADCC_CHER_CH0 (0x1 << 0) // (TSADCC) Channel 0 Enable
#define AT91C_TSADCC_CHER_CH1 (0x1 << 1) // (TSADCC) Channel 1 Enable
#define AT91C_TSADCC_CHER_CH2 (0x1 << 2) // (TSADCC) Channel 2 Enable
#define AT91C_TSADCC_CHER_CH3 (0x1 << 3) // (TSADCC) Channel 3 Enable
// -------- TSADCC_CHDR : (TSADCC Offset: 0x14) Channel Disable Register --------
#define AT91C_TSADCC_CHDR_CH0 (0x1 << 0) // (TSADCC) Channel 0 Disable
#define AT91C_TSADCC_CHDR_CH1 (0x1 << 1) // (TSADCC) Channel 1 Disable
#define AT91C_TSADCC_CHDR_CH2 (0x1 << 2) // (TSADCC) Channel 2 Disable
#define AT91C_TSADCC_CHDR_CH3 (0x1 << 3) // (TSADCC) Channel 3 Disable
// -------- TSADCC_CHSR : (TSADCC Offset: 0x18) Channel Status Register --------
#define AT91C_TSADCC_CHSR_CH0 (0x1 << 0) // (TSADCC) Channel 0 Status
#define AT91C_TSADCC_CHSR_CH1 (0x1 << 1) // (TSADCC) Channel 1 Status
#define AT91C_TSADCC_CHSR_CH2 (0x1 << 2) // (TSADCC) Channel 2 Status
#define AT91C_TSADCC_CHSR_CH3 (0x1 << 3) // (TSADCC) Channel 3 Status
// -------- TSADCC_SR : (TSADCC Offset: 0x1C) Status Register --------
#define AT91C_TSADCC_SR_EOC0 (0x1 << 0) // (TSADCC) End of Conversion 0
#define AT91C_TSADCC_SR_EOC1 (0x1 << 1) // (TSADCC) End of Conversion 1
#define AT91C_TSADCC_SR_EOC2 (0x1 << 2) // (TSADCC) End of Conversion 2
#define AT91C_TSADCC_SR_EOC3 (0x1 << 3) // (TSADCC) End of Conversion 3
#define AT91C_TSADCC_SR_OVRE0 (0x1 << 8) // (TSADCC) Overrun Error 0
#define AT91C_TSADCC_SR_OVRE1 (0x1 << 9) // (TSADCC) Overrun Error 1
#define AT91C_TSADCC_SR_OVRE2 (0x1 << 10) // (TSADCC) Overrun Error 2
#define AT91C_TSADCC_SR_OVRE3 (0x1 << 11) // (TSADCC) Overrun Error 3
#define AT91C_TSADCC_SR_DRDY (0x1 << 16) // (TSADCC) Data Ready
#define AT91C_TSADCC_SR_GOVRE (0x1 << 17) // (TSADCC) General Overrun Error
#define AT91C_TSADCC_SR_ENDRX (0x1 << 18) // (TSADCC) End of RX Buffer
#define AT91C_TSADCC_SR_RXBUFF (0x1 << 19) // (TSADCC) RX Buffer Full
#define AT91C_TSADCC_SR_PENCNT (0x1 << 20) // (TSADCC) Pen Contact
#define AT91C_TSADCC_SR_NOCNT (0x1 << 21) // (TSADCC) No Contact
// -------- TSADCC_LCDR : (TSADCC Offset: 0x20) Last Converted Data Register --------
#define AT91C_TSADCC_LCDR_LDATA (0x3ff << 0) // (TSADCC) Last Data Converted
// -------- TSADCC_IER : (TSADCC Offset: 0x24) Interrupt Enable Register --------
#define AT91C_TSADCC_IER_EOC0 (0x1 << 0) // (TSADCC) End of Conversion Interrupt Enable 0
#define AT91C_TSADCC_IER_EOC1 (0x1 << 1) // (TSADCC) End of Conversion Interrupt Enable 1
#define AT91C_TSADCC_IER_EOC2 (0x1 << 2) // (TSADCC) End of Conversion Interrupt Enable 2
#define AT91C_TSADCC_IER_EOC3 (0x1 << 3) // (TSADCC) End of Conversion Interrupt Enable 3
#define AT91C_TSADCC_IER_OVRE0 (0x1 << 8) // (TSADCC) Overrun Error Interrupt Enable 0
#define AT91C_TSADCC_IER_OVRE1 (0x1 << 9) // (TSADCC) Overrun Error Interrupt Enable 1
#define AT91C_TSADCC_IER_OVRE2 (0x1 << 10) // (TSADCC) Overrun Error Interrupt Enable 2
#define AT91C_TSADCC_IER_OVRE3 (0x1 << 11) // (TSADCC) Overrun Error Interrupt Enable 3
#define AT91C_TSADCC_IER_DRDY (0x1 << 16) // (TSADCC) Data Ready Interrupt Enable
#define AT91C_TSADCC_IER_GOVRE (0x1 << 17) // (TSADCC) General Overrun Error Interrupt Enable
#define AT91C_TSADCC_IER_ENDRX (0x1 << 18) // (TSADCC) End of Receive Buffer Interrupt Enable
#define AT91C_TSADCC_IER_RXBUFF (0x1 << 19) // (TSADCC) Receive Buffer Full Interrupt Enable
#define AT91C_TSADCC_IER_PENCNT (0x1 << 20) // (TSADCC) Pen Contact
#define AT91C_TSADCC_IER_NOCNT (0x1 << 21) // (TSADCC) No Contact
// -------- TSADCC_IDR : (TSADCC Offset: 0x28) Interrupt Disable Register --------
#define AT91C_TSADCC_IDR_EOC0 (0x1 << 0) // (TSADCC) End of Conversion Interrupt Disable 0
#define AT91C_TSADCC_IDR_EOC1 (0x1 << 1) // (TSADCC) End of Conversion Interrupt Disable 1
#define AT91C_TSADCC_IDR_EOC2 (0x1 << 2) // (TSADCC) End of Conversion Interrupt Disable 2
#define AT91C_TSADCC_IDR_EOC3 (0x1 << 3) // (TSADCC) End of Conversion Interrupt Disable 3
#define AT91C_TSADCC_IDR_OVRE0 (0x1 << 8) // (TSADCC) Overrun Error Interrupt Disable 0
#define AT91C_TSADCC_IDR_OVRE1 (0x1 << 9) // (TSADCC) Overrun Error Interrupt Disable 1
#define AT91C_TSADCC_IDR_OVRE2 (0x1 << 10) // (TSADCC) Overrun Error Interrupt Disable 2
#define AT91C_TSADCC_IDR_OVRE3 (0x1 << 11) // (TSADCC) Overrun Error Interrupt Disable 3
#define AT91C_TSADCC_IDR_DRDY (0x1 << 16) // (TSADCC) Data Ready Interrupt Disable
#define AT91C_TSADCC_IDR_GOVRE (0x1 << 17) // (TSADCC) General Overrun Error Interrupt Disable
#define AT91C_TSADCC_IDR_ENDRX (0x1 << 18) // (TSADCC) End of Receive Buffer Interrupt Disable
#define AT91C_TSADCC_IDR_RXBUFF (0x1 << 19) // (TSADCC) Receive Buffer Full Interrupt Disable
#define AT91C_TSADCC_IDR_PENCNT (0x1 << 20) // (TSADCC) Pen Contact
#define AT91C_TSADCC_IDR_NOCNT (0x1 << 21) // (TSADCC) No Contact
// -------- TSADCC_IMR : (TSADCC Offset: 0x2C) Interrupt Mask Register --------
#define AT91C_TSADCC_IMR_EOC0 (0x1 << 0) // (TSADCC) End of Conversion Interrupt Mask 0
#define AT91C_TSADCC_IMR_EOC1 (0x1 << 1) // (TSADCC) End of Conversion Interrupt Mask 1
#define AT91C_TSADCC_IMR_EOC2 (0x1 << 2) // (TSADCC) End of Conversion Interrupt Mask 2
#define AT91C_TSADCC_IMR_EOC3 (0x1 << 3) // (TSADCC) End of Conversion Interrupt Mask 3
#define AT91C_TSADCC_IMR_OVRE0 (0x1 << 8) // (TSADCC) Overrun Error Interrupt Mask 0
#define AT91C_TSADCC_IMR_OVRE1 (0x1 << 9) // (TSADCC) Overrun Error Interrupt Mask 1
#define AT91C_TSADCC_IMR_OVRE2 (0x1 << 10) // (TSADCC) Overrun Error Interrupt Mask 2
#define AT91C_TSADCC_IMR_OVRE3 (0x1 << 11) // (TSADCC) Overrun Error Interrupt Mask 3
#define AT91C_TSADCC_IMR_DRDY (0x1 << 16) // (TSADCC) Data Ready Interrupt Mask
#define AT91C_TSADCC_IMR_GOVRE (0x1 << 17) // (TSADCC) General Overrun Error Interrupt Mask
#define AT91C_TSADCC_IMR_ENDRX (0x1 << 18) // (TSADCC) End of Receive Buffer Interrupt Mask
#define AT91C_TSADCC_IMR_RXBUFF (0x1 << 19) // (TSADCC) Receive Buffer Full Interrupt Mask
#define AT91C_TSADCC_IMR_PENCNT (0x1 << 20) // (TSADCC) Pen Contact
#define AT91C_TSADCC_IMR_NOCNT (0x1 << 21) // (TSADCC) No Contact
// -------- TSADCC_CDR[8] : (TSADCC Offset: 0x30) Channel Data Register --------
#define AT91C_TSADCC_CDR_DATA (0x3ff << 0) // (TSADCC) Channel Data
// -------- TSADCC_RPR : (TSADCC Offset: 0x100) Receive Pointer Register --------
#define AT91C_TSADCC_RPR_RXPTR (0xffffffff << 0) // (TSADCC) Receive Pointer Register
// -------- TSADCC_RCR : (TSADCC Offset: 0x104) Receive Counter Register --------
#define AT91C_TSADCC_RCR_RXCTR (0xffff << 0) // (TSADCC) Receive Counter Register
// -------- TSADCC_TPR : (TSADCC Offset: 0x108) Transmit Pointer Register --------
#define AT91C_TSADCC_TPR_TXPTR (0xffffffff << 0) // (TSADCC) Transmit Counter Register
// -------- TSADCC_TCR : (TSADCC Offset: 0x10C) Transmit Counter Register --------
#define AT91C_TSADCC_TCR_TXCTR (0xffff << 0) // (TSADCC) Transmit Counter Register
// -------- TSADCC_RNPR : (TSADCC Offset: 0x110) Receive Next Pointer Register --------
#define AT91C_TSADCC_RNPR_RXNPTR (0xffffffff << 0) // (TSADCC) Receive Next Pointer
// -------- TSADCC_RNCR : (TSADCC Offset: 0x114) Receive Next Counter Register --------
#define AT91C_TSADCC_RNCR_RXNCTR (0xffff << 0) // (TSADCC) Receive Next Counter
// -------- TSADCC_TNPR : (TSADCC Offset: 0x118) Transmit Next Pointer Register --------
#define AT91C_TSADCC_TNPR_TXNPTR (0xffffffff << 0) // (TSADCC) Transmit Next Pointer
// -------- TSADCC_TNCR : (TSADCC Offset: 0x11C) Transmit Next Counter Register --------
#define AT91C_TSADCC_TNCR_TXNCTR (0xffff << 0) // (TSADCC) Transmit Counter Next
// -------- TSADCC_PTCR : (TSADCC Offset: 0x120) Transfer Control Register --------
#define AT91C_TSADCC_PTCR_RXTEN (0x1 << 0) // (TSADCC) Receiver Transfer Enable
#define AT91C_TSADCC_PTCR_RXTDIS (0x1 << 1) // (TSADCC) Receiver Transfer Disable
#define AT91C_TSADCC_PTCR_TXTEN (0x1 << 8) // (TSADCC) Transmitter Transfer Enable
#define AT91C_TSADCC_PTCR_TXTDIS (0x1 << 9) // (TSADCC) Transmitter Transfer Disable
// -------- TSADCC_PTSR : (TSADCC Offset: 0x124) Transfer Status Register --------
#define AT91C_TSADCC_PTSR_RXTEN (0x1 << 0) // (TSADCC) Receiver Transfer Enable
#define AT91C_TSADCC_PTSR_TXTEN (0x1 << 8) // (TSADCC) Transmitter Transfer Enable

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Two-wire Interface
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_TWI {
  AT91_REG TWI_CR;       // Control Register
  AT91_REG TWI_MMR;      // Master Mode Register
  AT91_REG TWI_SMR;      // Slave Mode Register
  AT91_REG TWI_IADR;     // Internal Address Register
  AT91_REG TWI_CWGR;     // Clock Waveform Generator Register
  AT91_REG Reserved1[3];
  AT91_REG TWI_SR;       // Status Register
  AT91_REG TWI_IER;      // Interrupt Enable Register
  AT91_REG TWI_IDR;      // Interrupt Disable Register
  AT91_REG TWI_IMR;      // Interrupt Mask Register
  AT91_REG TWI_RHR;      // Receive Holding Register
  AT91_REG TWI_THR;      // Transmit Holding Register
} AT91S_TWI, *AT91PS_TWI;
#else
#define TWI_CR   (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define TWI_MMR  (AT91_CAST(AT91_REG *) 0x00000004) // Master Mode Register
#define TWI_SMR  (AT91_CAST(AT91_REG *) 0x00000008) // Slave Mode Register
#define TWI_IADR (AT91_CAST(AT91_REG *) 0x0000000C) // Internal Address Register
#define TWI_CWGR (AT91_CAST(AT91_REG *) 0x00000010) // Clock Waveform Generator Register
#define TWI_SR   (AT91_CAST(AT91_REG *) 0x00000020) // Status Register
#define TWI_IER  (AT91_CAST(AT91_REG *) 0x00000024) // Interrupt Enable Register
#define TWI_IDR  (AT91_CAST(AT91_REG *) 0x00000028) // Interrupt Disable Register
#define TWI_IMR  (AT91_CAST(AT91_REG *) 0x0000002C) // Interrupt Mask Register
#define TWI_RHR  (AT91_CAST(AT91_REG *) 0x00000030) // Receive Holding Register
#define TWI_THR  (AT91_CAST(AT91_REG *) 0x00000034) // Transmit Holding Register
#endif
// -------- TWI_CR : (TWI Offset: 0x00) Control Register --------
#define AT91C_TWI_CR_START (0x1 << 0) // (TWI) Send a START Condition
#define AT91C_TWI_CR_STOP (0x1 << 1) // (TWI) Send a STOP Condition
#define AT91C_TWI_CR_MSEN (0x1 << 2) // (TWI) TWI Master Mode Enabled
#define AT91C_TWI_CR_MSDIS (0x1 << 3) // (TWI) TWI Master Mode Disabled
#define AT91C_TWI_CR_SVEN (0x1 << 4) // (TWI) TWI Slave Mode Enabled
#define AT91C_TWI_CR_SVDIS (0x1 << 5) // (TWI) TWI Slave Mode Disabled
#define AT91C_TWI_CR_QUICK (0x1 << 6) // (TWI) SMBUS Quick Command
#define AT91C_TWI_CR_SWRST (0x1 << 7) // (TWI) Software Reset
// -------- TWI_MMR : (TWI Offset: 0x04) Master Mode Register --------
#define AT91C_TWI_MMR_IADRSZ (0x3 << 8) // (TWI) Internal Device Address Size
#define   AT91C_TWI_MMR_IADRSZ_NO (0x0 << 8) // (TWI) No internal device address
#define   AT91C_TWI_MMR_IADRSZ_1_BYTE (0x1 << 8) // (TWI) One-byte internal device address
#define   AT91C_TWI_MMR_IADRSZ_2_BYTE (0x2 << 8) // (TWI) Two-byte internal device address
#define   AT91C_TWI_MMR_IADRSZ_3_BYTE (0x3 << 8) // (TWI) Three-byte internal device address
#define AT91C_TWI_MMR_MREAD (0x1 << 12) // (TWI) Master Read Direction
#define AT91C_TWI_MMR_DADR (0x7f << 16) // (TWI) Device Address
// -------- TWI_SMR : (TWI Offset: 0x08) Slave Mode Register --------
#define AT91C_TWI_SMR_SADR (0x7f << 16) // (TWI) Slave Address
// -------- TWI_IADR : (TWI Offset: 0x0C) Internal Address Register --------
#define AT91C_TWI_IADR_IADR (0xffffff << 0) // (TWI) Internal Address
// -------- TWI_CWGR : (TWI Offset: 0x10) Clock Waveform Generator Register --------
#define AT91C_TWI_CWGR_CLDIV (0xff << 0) // (TWI) Clock Low Divider
#define AT91C_TWI_CWGR_CHDIV (0xff << 8) // (TWI) Clock High Divider
#define AT91C_TWI_CWGR_CKDIV (0x7 << 16) // (TWI) Clock Divider
// -------- TWI_SR : (TWI Offset: 0x20) Status Register --------
#define AT91C_TWI_SR_TXCOMP (0x1 << 0) // (TWI) Transmission Completed (automatically set / reset)
#define AT91C_TWI_SR_RXRDY (0x1 << 1) // (TWI) Receive Holding Register Ready (automatically set / reset)
#define AT91C_TWI_SR_TXRDY (0x1 << 2) // (TWI) Transmit Holding Register Ready (automatically set / reset)
#define AT91C_TWI_SR_SVREAD (0x1 << 3) // (TWI) Slave Read (automatically set / reset)
#define AT91C_TWI_SR_SVACC (0x1 << 4) // (TWI) Slave Access (automatically set / reset)
#define AT91C_TWI_SR_GACC (0x1 << 5) // (TWI) General Call Access (clear on read)
#define AT91C_TWI_SR_OVRE (0x1 << 6) // (TWI) Overrun Error (clear on read)
#define AT91C_TWI_SR_NACK (0x1 << 8) // (TWI) Not Acknowledged (clear on read)
#define AT91C_TWI_SR_ARBLST (0x1 << 9) // (TWI) Arbitration Lost (clear on read)
#define AT91C_TWI_SR_SCLWS (0x1 << 10) // (TWI) Clock Wait State (automatically set / reset)
#define AT91C_TWI_SR_EOSACC (0x1 << 11) // (TWI) End Of Slave Access (clear on read)
#define AT91C_TWI_SR_ENDRX (0x1 << 12) // (TWI) End of RX buffer
#define AT91C_TWI_SR_ENDTX (0x1 << 13) // (TWI) End of TX buffer
#define AT91C_TWI_SR_RXBUFF (0x1 << 14) // (TWI) RX Buffer Full
#define AT91C_TWI_SR_TXBUFE (0x1 << 15) // (TWI) TX Buffer Empty
// -------- TWI_IER : (TWI Offset: 0x24) Interrupt Enable Register --------
#define AT91C_TWI_IER_TXCOMP (0x1 << 0) // (TWI) Transmission Completed Interrupt Enable
#define AT91C_TWI_IER_RXRDY (0x1 << 1) // (TWI) Receive Holding Register Ready Interrupt Enable
#define AT91C_TWI_IER_TXRDY (0x1 << 2) // (TWI) Transmit Holding Register Ready Interrupt Enable
#define AT91C_TWI_IER_SVACC (0x1 << 4) // (TWI) Slave Access Interrupt Enable
#define AT91C_TWI_IER_GACC (0x1 << 5) // (TWI) General Call Access Interrupt Enable
#define AT91C_TWI_IER_OVRE (0x1 << 6) // (TWI) Overrun Error Interrupt Enable
#define AT91C_TWI_IER_NACK (0x1 << 8) // (TWI) Not Acknowledge Interrupt Enable
#define AT91C_TWI_IER_ARBLST (0x1 << 9) // (TWI) Arbitration Lost Interrupt Enable
#define AT91C_TWI_IER_SCL_WS (0x1 << 10) // (TWI) Clock Wait State Interrupt Enable
#define AT91C_TWI_IER_EOSACC (0x1 << 11) // (TWI) End Of Slave Access Interrupt Enable
#define AT91C_TWI_IER_ENDRX (0x1 << 12) // (TWI) End of Receive Buffer Interrupt Enable
#define AT91C_TWI_IER_ENDTX (0x1 << 13) // (TWI) End of Transmit Buffer Interrupt Enable
#define AT91C_TWI_IER_RXBUFF (0x1 << 14) // (TWI) Receive Buffer Full Interrupt Enable
#define AT91C_TWI_IER_TXBUFE (0x1 << 15) // (TWI) Transmit Buffer Empty Interrupt Enable
// -------- TWI_IDR : (TWI Offset: 0x28) Interrupt Disable Register --------
#define AT91C_TWI_IDR_TXCOMP (0x1 << 0) // (TWI) Transmission Completed Interrupt Disable
#define AT91C_TWI_IDR_RXRDY (0x1 << 1) // (TWI) Receive Holding Register Ready Interrupt Disable
#define AT91C_TWI_IDR_TXRDY (0x1 << 2) // (TWI) Transmit Holding Register Ready Interrupt Disable
#define AT91C_TWI_IDR_SVACC (0x1 << 4) // (TWI) Slave Access Interrupt Disable
#define AT91C_TWI_IDR_GACC (0x1 << 5) // (TWI) General Call Access Interrupt Disable
#define AT91C_TWI_IDR_OVRE (0x1 << 6) // (TWI) Overrun Error Interrupt Disable
#define AT91C_TWI_IDR_NACK (0x1 << 8) // (TWI) Not Acknowledge Interrupt Disable
#define AT91C_TWI_IDR_ARBLST (0x1 << 9) // (TWI) Arbitration Lost Interrupt Disable
#define AT91C_TWI_IDR_SCL_WS (0x1 << 10) // (TWI) Clock Wait State Interrupt Disable
#define AT91C_TWI_IDR_EOSACC (0x1 << 11) // (TWI) End Of Slave Access Interrupt Disable
#define AT91C_TWI_IDR_ENDRX (0x1 << 12) // (TWI) End of Receive Buffer Interrupt Disable
#define AT91C_TWI_IDR_ENDTX (0x1 << 13) // (TWI) End of Transmit Buffer Interrupt Disable
#define AT91C_TWI_IDR_RXBUFF (0x1 << 14) // (TWI) Receive Buffer Full Interrupt Disable
#define AT91C_TWI_IDR_TXBUFE (0x1 << 15) // (TWI) Transmit Buffer Empty Interrupt Disable
// -------- TWI_IMR : (TWI Offset: 0x2C) Interrupt Mask Register --------
#define AT91C_TWI_IMR_TXCOMP (0x1 << 0) // (TWI) Transmission Completed Interrupt Mask
#define AT91C_TWI_IMR_RXRDY (0x1 << 1) // (TWI) Receive Holding Register Ready Interrupt Mask
#define AT91C_TWI_IMR_TXRDY (0x1 << 2) // (TWI) Transmit Holding Register Ready Interrupt Mask
#define AT91C_TWI_IMR_SVACC (0x1 << 4) // (TWI) Slave Access Interrupt Mask
#define AT91C_TWI_IMR_GACC (0x1 << 5) // (TWI) General Call Access Interrupt Mask
#define AT91C_TWI_IMR_OVRE (0x1 << 6) // (TWI) Overrun Error Interrupt Mask
#define AT91C_TWI_IMR_NACK (0x1 << 8) // (TWI) Not Acknowledge Interrupt Mask
#define AT91C_TWI_IMR_ARBLST (0x1 << 9) // (TWI) Arbitration Lost Interrupt Mask
#define AT91C_TWI_IMR_SCL_WS (0x1 << 10) // (TWI) Clock Wait State Interrupt Mask
#define AT91C_TWI_IMR_EOSACC (0x1 << 11) // (TWI) End Of Slave Access Interrupt Mask
#define AT91C_TWI_IMR_ENDRX (0x1 << 12) // (TWI) End of Receive Buffer Interrupt Mask
#define AT91C_TWI_IMR_ENDTX (0x1 << 13) // (TWI) End of Transmit Buffer Interrupt Mask
#define AT91C_TWI_IMR_RXBUFF (0x1 << 14) // (TWI) Receive Buffer Full Interrupt Mask
#define AT91C_TWI_IMR_TXBUFE (0x1 << 15) // (TWI) Transmit Buffer Empty Interrupt Mask
// -------- TWI_RHR : (TWI Offset: 0x30) Receive Holding Register --------
#define AT91C_TWI_RHR_RXDATA (0xff << 0) // (TWI) Master or Slave Receive Holding Data
// -------- TWI_THR : (TWI Offset: 0x34) Transmit Holding Register --------
#define AT91C_TWI_THR_TXDATA (0xff << 0) // (TWI) Master or Slave Transmit Holding Data

// *****************************************************************************
//              SOFTWARE API DEFINITION  FOR UDPHS Endpoint struct
// *****************************************************************************
#ifndef __ASSEMBLY__
typedef struct _AT91S_UDPHS_EPT {
    AT91_REG     UDPHS_EPTCFG;  // UDPHS Endpoint Config Register
    AT91_REG     UDPHS_EPTCTLENB;   // UDPHS Endpoint Control Enable Register
    AT91_REG     UDPHS_EPTCTLDIS;   // UDPHS Endpoint Control Disable Register
    AT91_REG     UDPHS_EPTCTL;  // UDPHS Endpoint Control Register
    AT91_REG     Reserved0[1];  //
    AT91_REG     UDPHS_EPTSETSTA;   // UDPHS Endpoint Set Status Register
    AT91_REG     UDPHS_EPTCLRSTA;   // UDPHS Endpoint Clear Status Register
    AT91_REG     UDPHS_EPTSTA;  // UDPHS Endpoint Status Register
} AT91S_UDPHS_EPT, *AT91PS_UDPHS_EPT;
#endif

// -------- UDPHS_EPTCFG : (UDPHS_EPT Offset: 0x0) UDPHS Endpoint Config Register --------
#define AT91C_UDPHS_EPT_SIZE  ( 0x7 <<  0) // (UDPHS_EPT) Endpoint Size
#define     AT91C_UDPHS_EPTCFG_EPT_SIZE_8                    ( 0x0) // (UDPHS_EPT)    8 bytes
#define     AT91C_UDPHS_EPTCFG_EPT_SIZE_16                   ( 0x1) // (UDPHS_EPT)   16 bytes
#define     AT91C_UDPHS_EPTCFG_EPT_SIZE_32                   ( 0x2) // (UDPHS_EPT)   32 bytes
#define     AT91C_UDPHS_EPTCFG_EPT_SIZE_64                   ( 0x3) // (UDPHS_EPT)   64 bytes
#define     AT91C_UDPHS_EPTCFG_EPT_SIZE_128                  ( 0x4) // (UDPHS_EPT)  128 bytes
#define     AT91C_UDPHS_EPTCFG_EPT_SIZE_256                  ( 0x5) // (UDPHS_EPT)  256 bytes
#define     AT91C_UDPHS_EPTCFG_EPT_SIZE_512                  ( 0x6) // (UDPHS_EPT)  512 bytes
#define     AT91C_UDPHS_EPTCFG_EPT_SIZE_1024                 ( 0x7) // (UDPHS_EPT) 1024 bytes
#define AT91C_UDPHS_EPT_DIR   ( 0x1 <<  3) // (UDPHS_EPT) Endpoint Direction 0:OUT, 1:IN
#define     AT91C_UDPHS_EPTCFG_EPT_DIR_OUT                  ( 0x0 <<  3) // (UDPHS_EPT) Direction OUT
#define     AT91C_UDPHS_EPTCFG_EPT_DIR_IN                   ( 0x1 <<  3) // (UDPHS_EPT) Direction IN
#define AT91C_UDPHS_EPT_TYPE  ( 0x3 <<  4) // (UDPHS_EPT) Endpoint Type
#define     AT91C_UDPHS_EPTCFG_EPT_TYPE_CTL_EPT              ( 0x0 <<  4) // (UDPHS_EPT) Control endpoint
#define     AT91C_UDPHS_EPTCFG_EPT_TYPE_ISO_EPT              ( 0x1 <<  4) // (UDPHS_EPT) Isochronous endpoint
#define     AT91C_UDPHS_EPTCFG_EPT_TYPE_BUL_EPT              ( 0x2 <<  4) // (UDPHS_EPT) Bulk endpoint
#define     AT91C_UDPHS_EPTCFG_EPT_TYPE_INT_EPT              ( 0x3 <<  4) // (UDPHS_EPT) Interrupt endpoint
#define AT91C_UDPHS_BK_NUMBER ( 0x3 <<  6) // (UDPHS_EPT) Number of Banks
#define     AT91C_UDPHS_EPTCFG_BK_NUMBER_0                    ( 0x0 <<  6) // (UDPHS_EPT) Zero Bank, the EndPoint is not mapped in memory
#define     AT91C_UDPHS_EPTCFG_BK_NUMBER_1                    ( 0x1 <<  6) // (UDPHS_EPT) One Bank (Bank0)
#define     AT91C_UDPHS_EPTCFG_BK_NUMBER_2                    ( 0x2 <<  6) // (UDPHS_EPT) Double bank (Ping-Pong : Bank0 / Bank1)
#define     AT91C_UDPHS_EPTCFG_BK_NUMBER_3                    ( 0x3 <<  6) // (UDPHS_EPT) Triple Bank (Bank0 / Bank1 / Bank2)
#define AT91C_UDPHS_EPTCFG_NB_TRANS  ( 0x3 <<  8) // (UDPHS_EPT) Number Of Transaction per Micro-Frame (High-Bandwidth iso only)
#define AT91C_UDPHS_EPTCFG_EPT_MAPD  ( 0x1 << 31) // (UDPHS_EPT) Endpoint Mapped (read only
// -------- UDPHS_EPTCTLENB : (UDPHS_EPT Offset: 0x4) UDPHS Endpoint Control Enable Register --------
#define AT91C_UDPHS_EPTCTLENB_EPT_ENABL ( 0x1 <<  0) // (UDPHS_EPT) Endpoint Enable
#define AT91C_UDPHS_EPTCTLENB_AUTO_VALID ( 0x1 <<  1) // (UDPHS_EPT) Packet Auto-Valid Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_INTDIS_DMA ( 0x1 <<  3) // (UDPHS_EPT) Endpoint Interrupts DMA Request Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_NYET_DIS  ( 0x1 <<  4) // (UDPHS_EPT) NYET Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_DATAX_RX  ( 0x1 <<  6) // (UDPHS_EPT) DATAx Interrupt Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_MDATA_RX  ( 0x1 <<  7) // (UDPHS_EPT) MDATA Interrupt Enabled/Disable
#define AT91C_UDPHS_EPTCTLENB_ERR_OVFLW ( 0x1 <<  8) // (UDPHS_EPT) OverFlow Error Interrupt Enable/Disable/Status
#define AT91C_UDPHS_EPTCTLENB_RX_BK_RDY ( 0x1 <<  9) // (UDPHS_EPT) Received OUT Data
#define AT91C_UDPHS_EPTCTLENB_TX_COMPLT ( 0x1 << 10) // (UDPHS_EPT) Transmitted IN Data Complete Interrupt Enable/Disable or Transmitted IN Data Complete (clear)
#define AT91C_UDPHS_EPTCTLENB_TX_PK_RDY ( 0x1 << 11) // (UDPHS_EPT) TX Packet Ready Interrupt Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_ERR_TRANS ( 0x1 << 11) // (UDPHS_EPT) Transaction Error Interrupt Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_RX_SETUP  ( 0x1 << 12) // (UDPHS_EPT) Received SETUP Interrupt Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_ERR_FL_ISO ( 0x1 << 12) // (UDPHS_EPT) Error Flow Clear/Interrupt Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_STALL_SNT ( 0x1 << 13) // (UDPHS_EPT) Stall Sent Clear
#define AT91C_UDPHS_EPTCTLENB_ERR_CRISO ( 0x1 << 13) // (UDPHS_EPT) CRC error / Error NB Trans / Interrupt Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_NAK_IN    ( 0x1 << 14) // (UDPHS_EPT) NAKIN ERROR FLUSH / Clear / Interrupt Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_NAK_OUT   ( 0x1 << 15) // (UDPHS_EPT) NAKOUT / Clear / Interrupt Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_BUSY_BANK ( 0x1 << 18) // (UDPHS_EPT) Busy Bank Interrupt Enable/Disable
#define AT91C_UDPHS_EPTCTLENB_SHRT_PCKT ( 0x1 << 31) // (UDPHS_EPT) Short Packet / Interrupt Enable/Disable
// -------- UDPHS_EPTCTLDIS : (UDPHS_EPT Offset: 0x8) UDPHS Endpoint Control Disable Register --------
#define AT91C_UDPHS_EPTCTLDIS_EPT_DISABL ( 0x1 <<  0) // (UDPHS_EPT) Endpoint Disable
// -------- UDPHS_EPTCTL : (UDPHS_EPT Offset: 0xc) UDPHS Endpoint Control Register --------
// -------- UDPHS_EPTSETSTA : (UDPHS_EPT Offset: 0x14) UDPHS Endpoint Set Status Register --------
#define AT91C_UDPHS_EPTSETSTA_FRCESTALL ( 0x1 <<  5) // (UDPHS_EPT) Stall Handshake Request Set/Clear/Status
#define AT91C_UDPHS_EPTSETSTA_KILL_BANK ( 0x1 <<  9) // (UDPHS_EPT) KILL Bank
#define AT91C_UDPHS_EPTSETSTA_TX_PK_RDY ( 0x1 << 11) // (UDPHS_EPT) TX Packet Ready Set
// -------- UDPHS_EPTCLRSTA : (UDPHS_EPT Offset: 0x18) UDPHS Endpoint Clear Status Register --------
#define AT91C_UDPHS_EPTCLRSTA_TOGGLESQ  ( 0x1 <<  6) // (UDPHS_EPT) Data Toggle Clear
// -------- UDPHS_EPTSTA : (UDPHS_EPT Offset: 0x1c) UDPHS Endpoint Status Register --------
#define AT91C_UDPHS_EPTSTA_TOGGLESQ_STA ( 0x3 <<  6) // (UDPHS_EPT) Toggle Sequencing
#define     AT91C_UDPHS_EPTSTA_TOGGLESQ_STA_00                   ( 0x0 <<  6) // (UDPHS_EPT) Data0
#define     AT91C_UDPHS_EPTSTA_TOGGLESQ_STA_01                   ( 0x1 <<  6) // (UDPHS_EPT) Data1
#define     AT91C_UDPHS_EPTSTA_TOGGLESQ_STA_10                   ( 0x2 <<  6) // (UDPHS_EPT) Data2 (only for High-Bandwidth Isochronous EndPoint)
#define     AT91C_UDPHS_EPTSTA_TOGGLESQ_STA_11                   ( 0x3 <<  6) // (UDPHS_EPT) MData (only for High-Bandwidth Isochronous EndPoint)
#define AT91C_UDPHS_EPTSTA_RX_BK_RDY ( 0x1 <<  9) // (UDPHS_EPT) Received OUT Data
#define AT91C_UDPHS_EPTSTA_TX_PK_RDY ( 0x1 << 11) // (UDPHS_EPT) TX Packet Ready Status
#define AT91C_UDPHS_EPTSTA_RX_SETUP  ( 0x1 << 12) // (UDPHS_EPT) Received SETUP
#define AT91C_UDPHS_EPTSTA_CURRENT_BANK ( 0x3 << 16) // (UDPHS_EPT)
#define     AT91C_UDPHS_EPTSTA_CURRENT_BANK_00                   ( 0x0 << 16) // (UDPHS_EPT) Bank 0
#define     AT91C_UDPHS_EPTSTA_CURRENT_BANK_01                   ( 0x1 << 16) // (UDPHS_EPT) Bank 1
#define     AT91C_UDPHS_EPTSTA_CURRENT_BANK_10                   ( 0x2 << 16) // (UDPHS_EPT) Bank 2
#define     AT91C_UDPHS_EPTSTA_CURRENT_BANK_11                   ( 0x3 << 16) // (UDPHS_EPT) Invalid
#define AT91C_UDPHS_EPTSTA_CONTROL_DIR ( 0x3 << 16) // (UDPHS_EPT)
#define     AT91C_UDPHS_EPTSTA_CONTROL_DIR_00                   ( 0x0 << 16) // (UDPHS_EPT) Bank 0
#define     AT91C_UDPHS_EPTSTA_CONTROL_DIR_01                   ( 0x1 << 16) // (UDPHS_EPT) Bank 1
#define     AT91C_UDPHS_EPTSTA_CONTROL_DIR_10                   ( 0x2 << 16) // (UDPHS_EPT) Bank 2
#define     AT91C_UDPHS_EPTSTA_CONTROL_DIR_11                   ( 0x3 << 16) // (UDPHS_EPT) Invalid
#define AT91C_UDPHS_EPTSTA_BUSY_BANK_STA ( 0x3 << 18) // (UDPHS_EPT) Busy Bank Number
#define     AT91C_UDPHS_EPTSTA_BUSY_BANK_STA_00                   ( 0x0 << 18) // (UDPHS_EPT) All banks are free
#define     AT91C_UDPHS_EPTSTA_BUSY_BANK_STA_01                   ( 0x1 << 18) // (UDPHS_EPT) 1 busy bank
#define     AT91C_UDPHS_EPTSTA_BUSY_BANK_STA_10                   ( 0x2 << 18) // (UDPHS_EPT) 2 busy banks
#define     AT91C_UDPHS_EPTSTA_BUSY_BANK_STA_11                   ( 0x3 << 18) // (UDPHS_EPT) 3 busy banks
#define AT91C_UDPHS_EPTSTA_BYTE_COUNT ( 0x7FF << 20) // (UDPHS_EPT) UDPHS Byte Count


// *****************************************************************************
//              SOFTWARE API DEFINITION  FOR UDPHS DMA struct
// *****************************************************************************
#ifndef __ASSEMBLY__
typedef struct _AT91S_UDPHS_DMA {
    AT91_REG     UDPHS_DMANXTDSC;   // UDPHS DMA Channel Next Descriptor Address
    AT91_REG     UDPHS_DMAADDRESS;  // UDPHS DMA Channel Address Register
    AT91_REG     UDPHS_DMACONTROL;  // UDPHS DMA Channel Control Register
    AT91_REG     UDPHS_DMASTATUS;   // UDPHS DMA Channel Status Register
} AT91S_UDPHS_DMA, *AT91PS_UDPHS_DMA;
#endif

// -------- UDPHS_DMANXTDSC : (UDPHS Offset: 0x360) UDPHS DMA Next Descriptor Address Register --------
#define AT91C_UDPHS_DMANXTDSC_NXT_DSC_ADD (0xffffffff << 0) // (UDPHS)
// -------- UDPHS_DMAADDRESS : (UDPHS Offset: 0x364) UDPHS DMA Channel Address Register --------
#define AT91C_UDPHS_DMAADDRESS_BUFF_ADD (0xffffffff << 0) // (UDPHS)
// -------- UDPHS_DMACONTROL : (UDPHS Offset: 0x368) UDPHS DMA Channel Control Register --------
#define AT91C_UDPHS_DMACONTROL_CHANN_ENB (0x1 << 0) // (UDPHS)
#define AT91C_UDPHS_DMACONTROL_LDNXT_DSC (0x1 << 1) // (UDPHS) Load Next Channel Transfer Descriptor Enable (Command)
#define AT91C_UDPHS_DMACONTROL_END_TR_EN (0x1 << 2) // (UDPHS) End of Transfer Enable (Control)
#define AT91C_UDPHS_DMACONTROL_END_B_EN (0x1 << 3) // (UDPHS) End of Buffer Enable (Control)
#define AT91C_UDPHS_DMACONTROL_END_TR_IT (0x1 << 4) // (UDPHS) End of Transfer Interrupt Enable
#define AT91C_UDPHS_DMACONTROL_END_BUFFIT (0x1 << 5) // (UDPHS) End of Buffer Interrupt Enable
#define AT91C_UDPHS_DMACONTROL_DESC_LD_IT (0x1 << 6) // (UDPHS) Descriptor Loaded Interrupt Enable
#define AT91C_UDPHS_DMACONTROL_BURST_LCK (0x1 << 7) // (UDPHS) Burst Lock Enable
#define AT91C_UDPHS_DMACONTROL_BUFF_LENGTH (0xffff << 16) // (UDPHS) Buffer Byte Length (Write-only)
// -------- UDPHS_DMASTATUS : (UDPHS Offset: 0x36C) UDPHS DMA Channel Status Register --------
#define AT91C_UDPHS_DMASTATUS_CHANN_ENB (0x1 << 0) // (UDPHS) Channel Enable Status
#define AT91C_UDPHS_DMASTATUS_CHANN_ACT (0x1 << 1) // (UDPHS) Channel Active Status
#define AT91C_UDPHS_DMASTATUS_END_TR_ST (0x1 << 4) // (UDPHS) End of Channel Transfer Status
#define AT91C_UDPHS_DMASTATUS_END_BF_ST (0x1 << 5) // (UDPHS) End of Channel Buffer Status
#define AT91C_UDPHS_DMASTATUS_DESC_LDST (0x1 << 6) // (UDPHS) Descriptor Loaded Status
#define AT91C_UDPHS_DMASTATUS_BUFF_COUNT (0xffff << 16) // (UDPHS) Buffer Byte Count
/*****/

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR USB High Speed Device Port
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_UDPHS {
  AT91_REG UDPHS_CTRL;        // UDPHS Control Register
  AT91_REG UDPHS_FNUM;        // UDPHS Frame Number Register
  AT91_REG Reserved1[2];
  AT91_REG UDPHS_IEN;         // UDPHS Interrupt Enable Register
  AT91_REG UDPHS_INTSTA;      // UDPHS Interrupt Status Register
  AT91_REG UDPHS_CLRINT;      // UDPHS Clear Interrupt Register
  AT91_REG UDPHS_EPTRST;      // UDPHS Endpoints Reset Register
  AT91_REG Reserved2[48];
  AT91_REG UDPHS_TST;         // UDPHS Test Register
  AT91_REG Reserved3[3];
  AT91_REG UDPHS_IPNAME1;     // UDPHS Name1 Register
  AT91_REG UDPHS_IPNAME2;     // UDPHS Name2 Register
  AT91_REG UDPHS_IPFEATURES;  // UDPHS Features Register
  AT91_REG Reserved4[1];
  AT91S_UDPHS_EPT  UDPHS_EPT[7];     // UDPHS Endpoint struct
  AT91_REG	 Reserved5[72]; 	//
  AT91S_UDPHS_DMA  UDPHS_DMA[6];  // UDPHS DMA channel struct (not use [0])
} AT91S_UDPHS, *AT91PS_UDPHS;
#else
#define UDPHS_CTRL        (AT91_CAST(AT91_REG *) 0x00000000) // UDPHS Control Register
#define UDPHS_FNUM        (AT91_CAST(AT91_REG *) 0x00000004) // UDPHS Frame Number Register
#define UDPHS_IEN         (AT91_CAST(AT91_REG *) 0x00000010) // UDPHS Interrupt Enable Register
#define UDPHS_INTSTA      (AT91_CAST(AT91_REG *) 0x00000014) // UDPHS Interrupt Status Register
#define UDPHS_CLRINT      (AT91_CAST(AT91_REG *) 0x00000018) // UDPHS Clear Interrupt Register
#define UDPHS_EPTRST      (AT91_CAST(AT91_REG *) 0x0000001C) // UDPHS Endpoints Reset Register
#define UDPHS_TST         (AT91_CAST(AT91_REG *) 0x000000E0) // UDPHS Test Register
#define UDPHS_IPNAME1     (AT91_CAST(AT91_REG *) 0x000000F0) // UDPHS Name1 Register
#define UDPHS_IPNAME2     (AT91_CAST(AT91_REG *) 0x000000F4) // UDPHS Name2 Register
#define UDPHS_IPFEATURES  (AT91_CAST(AT91_REG *) 0x000000F8) // UDPHS Features Register
#define UDPHS_EPTCFG0     (AT91_CAST(AT91_REG *) 0x00000100) // UDPHS Endpoint Configuration Register (endpoint = 0)
#define UDPHS_EPTCTLENB0  (AT91_CAST(AT91_REG *) 0x00000104) // UDPHS Endpoint Control Enable Register (endpoint = 0)
#define UDPHS_EPTCTLDIS0  (AT91_CAST(AT91_REG *) 0x00000108) // UDPHS Endpoint Control Disable Register (endpoint = 0)
#define UDPHS_EPTCTL0     (AT91_CAST(AT91_REG *) 0x0000010C) // UDPHS Endpoint Control Register (endpoint = 0)
#define UDPHS_EPTSETSTA0  (AT91_CAST(AT91_REG *) 0x00000114) // UDPHS Endpoint Set Status Register (endpoint = 0)
#define UDPHS_EPTCLRSTA0  (AT91_CAST(AT91_REG *) 0x00000118) // UDPHS Endpoint Clear Status Register (endpoint = 0)
#define UDPHS_EPTSTA0     (AT91_CAST(AT91_REG *) 0x0000011C) // UDPHS Endpoint Status Register (endpoint = 0)
#define UDPHS_EPTCFG1     (AT91_CAST(AT91_REG *) 0x00000120) // UDPHS Endpoint Configuration Register (endpoint = 1)
#define UDPHS_EPTCTLENB1  (AT91_CAST(AT91_REG *) 0x00000124) // UDPHS Endpoint Control Enable Register (endpoint = 1)
#define UDPHS_EPTCTLDIS1  (AT91_CAST(AT91_REG *) 0x00000128) // UDPHS Endpoint Control Disable Register (endpoint = 1)
#define UDPHS_EPTCTL1     (AT91_CAST(AT91_REG *) 0x0000012C) // UDPHS Endpoint Control Register (endpoint = 1)
#define UDPHS_EPTSETSTA1  (AT91_CAST(AT91_REG *) 0x00000134) // UDPHS Endpoint Set Status Register (endpoint = 1)
#define UDPHS_EPTCLRSTA1  (AT91_CAST(AT91_REG *) 0x00000138) // UDPHS Endpoint Clear Status Register (endpoint = 1)
#define UDPHS_EPTSTA1     (AT91_CAST(AT91_REG *) 0x0000013C) // UDPHS Endpoint Status Register (endpoint = 1)
#define UDPHS_EPTCFG2     (AT91_CAST(AT91_REG *) 0x00000140) // UDPHS Endpoint Configuration Register (endpoint = 2)
#define UDPHS_EPTCTLENB2  (AT91_CAST(AT91_REG *) 0x00000144) // UDPHS Endpoint Control Enable Register (endpoint = 2)
#define UDPHS_EPTCTLDIS2  (AT91_CAST(AT91_REG *) 0x00000148) // UDPHS Endpoint Control Disable Register (endpoint = 2)
#define UDPHS_EPTCTL2     (AT91_CAST(AT91_REG *) 0x0000014C) // UDPHS Endpoint Control Register (endpoint = 2)
#define UDPHS_EPTSETSTA2  (AT91_CAST(AT91_REG *) 0x00000154) // UDPHS Endpoint Set Status Register (endpoint = 2)
#define UDPHS_EPTCLRSTA2  (AT91_CAST(AT91_REG *) 0x00000158) // UDPHS Endpoint Clear Status Register (endpoint = 2)
#define UDPHS_EPTSTA2     (AT91_CAST(AT91_REG *) 0x0000015C) // UDPHS Endpoint Status Register (endpoint = 2)
#define UDPHS_EPTCFG3     (AT91_CAST(AT91_REG *) 0x00000160) // UDPHS Endpoint Configuration Register (endpoint = 3)
#define UDPHS_EPTCTLENB3  (AT91_CAST(AT91_REG *) 0x00000164) // UDPHS Endpoint Control Enable Register (endpoint = 3)
#define UDPHS_EPTCTLDIS3  (AT91_CAST(AT91_REG *) 0x00000168) // UDPHS Endpoint Control Disable Register (endpoint = 3)
#define UDPHS_EPTCTL3     (AT91_CAST(AT91_REG *) 0x0000016C) // UDPHS Endpoint Control Register (endpoint = 3)
#define UDPHS_EPTSETSTA3  (AT91_CAST(AT91_REG *) 0x00000174) // UDPHS Endpoint Set Status Register (endpoint = 3)
#define UDPHS_EPTCLRSTA3  (AT91_CAST(AT91_REG *) 0x00000178) // UDPHS Endpoint Clear Status Register (endpoint = 3)
#define UDPHS_EPTSTA3     (AT91_CAST(AT91_REG *) 0x0000017C) // UDPHS Endpoint Status Register (endpoint = 3)
#define UDPHS_EPTCFG4     (AT91_CAST(AT91_REG *) 0x00000180) // UDPHS Endpoint Configuration Register (endpoint = 4)
#define UDPHS_EPTCTLENB4  (AT91_CAST(AT91_REG *) 0x00000184) // UDPHS Endpoint Control Enable Register (endpoint = 4)
#define UDPHS_EPTCTLDIS4  (AT91_CAST(AT91_REG *) 0x00000188) // UDPHS Endpoint Control Disable Register (endpoint = 4)
#define UDPHS_EPTCTL4     (AT91_CAST(AT91_REG *) 0x0000018C) // UDPHS Endpoint Control Register (endpoint = 4)
#define UDPHS_EPTSETSTA4  (AT91_CAST(AT91_REG *) 0x00000194) // UDPHS Endpoint Set Status Register (endpoint = 4)
#define UDPHS_EPTCLRSTA4  (AT91_CAST(AT91_REG *) 0x00000198) // UDPHS Endpoint Clear Status Register (endpoint = 4)
#define UDPHS_EPTSTA4     (AT91_CAST(AT91_REG *) 0x0000019C) // UDPHS Endpoint Status Register (endpoint = 4)
#define UDPHS_EPTCFG5     (AT91_CAST(AT91_REG *) 0x000001A0) // UDPHS Endpoint Configuration Register (endpoint = 5)
#define UDPHS_EPTCTLENB5  (AT91_CAST(AT91_REG *) 0x000001A4) // UDPHS Endpoint Control Enable Register (endpoint = 5)
#define UDPHS_EPTCTLDIS5  (AT91_CAST(AT91_REG *) 0x000001A8) // UDPHS Endpoint Control Disable Register (endpoint = 5)
#define UDPHS_EPTCTL5     (AT91_CAST(AT91_REG *) 0x000001AC) // UDPHS Endpoint Control Register (endpoint = 5)
#define UDPHS_EPTSETSTA5  (AT91_CAST(AT91_REG *) 0x000001B4) // UDPHS Endpoint Set Status Register (endpoint = 5)
#define UDPHS_EPTCLRSTA5  (AT91_CAST(AT91_REG *) 0x000001B8) // UDPHS Endpoint Clear Status Register (endpoint = 5)
#define UDPHS_EPTSTA5     (AT91_CAST(AT91_REG *) 0x000001BC) // UDPHS Endpoint Status Register (endpoint = 5)
#define UDPHS_EPTCFG6     (AT91_CAST(AT91_REG *) 0x000001C0) // UDPHS Endpoint Configuration Register (endpoint = 6)
#define UDPHS_EPTCTLENB6  (AT91_CAST(AT91_REG *) 0x000001C4) // UDPHS Endpoint Control Enable Register (endpoint = 6)
#define UDPHS_EPTCTLDIS6  (AT91_CAST(AT91_REG *) 0x000001C8) // UDPHS Endpoint Control Disable Register (endpoint = 6)
#define UDPHS_EPTCTL6     (AT91_CAST(AT91_REG *) 0x000001CC) // UDPHS Endpoint Control Register (endpoint = 6)
#define UDPHS_EPTSETSTA6  (AT91_CAST(AT91_REG *) 0x000001D4) // UDPHS Endpoint Set Status Register (endpoint = 6)
#define UDPHS_EPTCLRSTA6  (AT91_CAST(AT91_REG *) 0x000001D8) // UDPHS Endpoint Clear Status Register (endpoint = 6)
#define UDPHS_EPTSTA6     (AT91_CAST(AT91_REG *) 0x000001DC) // UDPHS Endpoint Status Register (endpoint = 6)
#define UDPHS_DMANXTDSC1  (AT91_CAST(AT91_REG *) 0x00000320) // UDPHS DMA Next Descriptor Address Register (channel = 1)
#define UDPHS_DMAADDRESS1 (AT91_CAST(AT91_REG *) 0x00000324) // UDPHS DMA Channel Address Register (channel = 1)
#define UDPHS_DMACONTROL1 (AT91_CAST(AT91_REG *) 0x00000328) // UDPHS DMA Channel Control Register (channel = 1)
#define UDPHS_DMASTATUS1  (AT91_CAST(AT91_REG *) 0x0000032C) // UDPHS DMA Channel Status Register (channel = 1)
#define UDPHS_DMANXTDSC2  (AT91_CAST(AT91_REG *) 0x00000330) // UDPHS DMA Next Descriptor Address Register (channel = 2)
#define UDPHS_DMAADDRESS2 (AT91_CAST(AT91_REG *) 0x00000334) // UDPHS DMA Channel Address Register (channel = 2)
#define UDPHS_DMACONTROL2 (AT91_CAST(AT91_REG *) 0x00000338) // UDPHS DMA Channel Control Register (channel = 2)
#define UDPHS_DMASTATUS2  (AT91_CAST(AT91_REG *) 0x0000033C) // UDPHS DMA Channel Status Register (channel = 2)
#define UDPHS_DMANXTDSC3  (AT91_CAST(AT91_REG *) 0x00000340) // UDPHS DMA Next Descriptor Address Register (channel = 3)
#define UDPHS_DMAADDRESS3 (AT91_CAST(AT91_REG *) 0x00000344) // UDPHS DMA Channel Address Register (channel = 3)
#define UDPHS_DMACONTROL3 (AT91_CAST(AT91_REG *) 0x00000348) // UDPHS DMA Channel Control Register (channel = 3)
#define UDPHS_DMASTATUS3  (AT91_CAST(AT91_REG *) 0x0000034C) // UDPHS DMA Channel Status Register (channel = 3)
#define UDPHS_DMANXTDSC4  (AT91_CAST(AT91_REG *) 0x00000350) // UDPHS DMA Next Descriptor Address Register (channel = 4)
#define UDPHS_DMAADDRESS4 (AT91_CAST(AT91_REG *) 0x00000354) // UDPHS DMA Channel Address Register (channel = 4)
#define UDPHS_DMACONTROL4 (AT91_CAST(AT91_REG *) 0x00000358) // UDPHS DMA Channel Control Register (channel = 4)
#define UDPHS_DMASTATUS4  (AT91_CAST(AT91_REG *) 0x0000035C) // UDPHS DMA Channel Status Register (channel = 4)
#define UDPHS_DMANXTDSC5  (AT91_CAST(AT91_REG *) 0x00000360) // UDPHS DMA Next Descriptor Address Register (channel = 5)
#define UDPHS_DMAADDRESS5 (AT91_CAST(AT91_REG *) 0x00000364) // UDPHS DMA Channel Address Register (channel = 5)
#define UDPHS_DMACONTROL5 (AT91_CAST(AT91_REG *) 0x00000368) // UDPHS DMA Channel Control Register (channel = 5)
#define UDPHS_DMASTATUS5  (AT91_CAST(AT91_REG *) 0x0000036C) // UDPHS DMA Channel Status Register (channel = 5)
#endif
// -------- UDPHS_CTRL : (UDPHS Offset: 0x00) UDPHS Control Register --------
#define AT91C_UDPHS_CTRL_DEV_ADDR (0x7f << 0) // (UDPHS) UDPHS Address
#define AT91C_UDPHS_CTRL_FADDR_EN (0x1 << 7) // (UDPHS) Function Address Enable
#define AT91C_UDPHS_CTRL_EN_UDPHS (0x1 << 8) // (UDPHS) UDPHS Enable
#define AT91C_UDPHS_CTRL_DETACH (0x1 << 9) // (UDPHS) Detach Command
#define AT91C_UDPHS_CTRL_REWAKEUP (0x1 << 10) // (UDPHS) Send Remote Wake Up
#define AT91C_UDPHS_CTRL_PULLD_DIS (0x1 << 11) // (UDPHS) Pull-Down Disable
// -------- UDPHS_FNUM : (UDPHS Offset: 0x04) UDPHS Frame Number Register --------
#define AT91C_UDPHS_FNUM_MICRO_FRAME_NUM (0x7 << 0) // (UDPHS) Microframe Number
#define AT91C_UDPHS_FNUM_FRAME_NUMBER (0x7ff << 3) // (UDPHS) Frame Number as defined in the Packet Field Formats
#define AT91C_UDPHS_FNUM_FNUM_ERR (0x1 << 31) // (UDPHS) Frame Number CRC Error
// -------- UDPHS_IEN : (UDPHS Offset: 0x10) UDPHS Interrupt Enable Register --------
#define AT91C_UDPHS_IEN_DET_SUSPD (0x1 << 1) // (UDPHS) Suspend Interrupt Enable
#define AT91C_UDPHS_IEN_MICRO_SOF (0x1 << 2) // (UDPHS) Micro-SOF Interrupt Enable
#define AT91C_UDPHS_IEN_INT_SOF (0x1 << 3) // (UDPHS) SOF Interrupt Enable
#define AT91C_UDPHS_IEN_ENDRESET (0x1 << 4) // (UDPHS) End Of Reset Interrupt Enable
#define AT91C_UDPHS_IEN_WAKE_UP (0x1 << 5) // (UDPHS) Wake Up CPU Interrupt Enable
#define AT91C_UDPHS_IEN_ENDOFRSM (0x1 << 6) // (UDPHS) End Of Resume Interrupt Enable
#define AT91C_UDPHS_IEN_UPSTR_RES (0x1 << 7) // (UDPHS) Upstream Resume Interrupt Enable
#define AT91C_UDPHS_IEN_EPT_0 (0x1 << 8) // (UDPHS) Endpoint 0 Interrupt Enable
#define AT91C_UDPHS_IEN_EPT_1 (0x1 << 9) // (UDPHS) Endpoint 1 Interrupt Enable
#define AT91C_UDPHS_IEN_EPT_2 (0x1 << 10) // (UDPHS) Endpoint 2 Interrupt Enable
#define AT91C_UDPHS_IEN_EPT_3 (0x1 << 11) // (UDPHS) Endpoint 3 Interrupt Enable
#define AT91C_UDPHS_IEN_EPT_4 (0x1 << 12) // (UDPHS) Endpoint 4 Interrupt Enable
#define AT91C_UDPHS_IEN_EPT_5 (0x1 << 13) // (UDPHS) Endpoint 5 Interrupt Enable
#define AT91C_UDPHS_IEN_EPT_6 (0x1 << 14) // (UDPHS) Endpoint 6 Interrupt Enable
#define AT91C_UDPHS_IEN_DMA_1 (0x1 << 25) // (UDPHS) DMA Channel 1 Interrupt Enable
#define AT91C_UDPHS_IEN_DMA_2 (0x1 << 26) // (UDPHS) DMA Channel 2 Interrupt Enable
#define AT91C_UDPHS_IEN_DMA_3 (0x1 << 27) // (UDPHS) DMA Channel 3 Interrupt Enable
#define AT91C_UDPHS_IEN_DMA_4 (0x1 << 28) // (UDPHS) DMA Channel 4 Interrupt Enable
#define AT91C_UDPHS_IEN_DMA_5 (0x1 << 29) // (UDPHS) DMA Channel 5 Interrupt Enable
#define AT91C_UDPHS_IEN_DMA_6 (0x1 << 30) // (UDPHS) DMA Channel 6 Interrupt Enable
// -------- UDPHS_INTSTA : (UDPHS Offset: 0x14) UDPHS Interrupt Status Register --------
#define AT91C_UDPHS_INTSTA_SPEED (0x1 << 0) // (UDPHS) Speed Status
#define AT91C_UDPHS_INTSTA_DET_SUSPD (0x1 << 1) // (UDPHS) Suspend Interrupt
#define AT91C_UDPHS_INTSTA_MICRO_SOF (0x1 << 2) // (UDPHS) Micro Start Of Frame Interrupt
#define AT91C_UDPHS_INTSTA_INT_SOF (0x1 << 3) // (UDPHS) Start Of Frame Interrupt
#define AT91C_UDPHS_INTSTA_ENDRESET (0x1 << 4) // (UDPHS) End Of Reset Interrupt
#define AT91C_UDPHS_INTSTA_WAKE_UP (0x1 << 5) // (UDPHS) Wake Up CPU Interrupt
#define AT91C_UDPHS_INTSTA_ENDOFRSM (0x1 << 6) // (UDPHS) End Of Resume Interrupt
#define AT91C_UDPHS_INTSTA_UPSTR_RES (0x1 << 7) // (UDPHS) Upstream Resume Interrupt
#define AT91C_UDPHS_INTSTA_EPT_0 (0x1 << 8) // (UDPHS) Endpoint 0 Interrupt
#define AT91C_UDPHS_INTSTA_EPT_1 (0x1 << 9) // (UDPHS) Endpoint 1 Interrupt
#define AT91C_UDPHS_INTSTA_EPT_2 (0x1 << 10) // (UDPHS) Endpoint 2 Interrupt
#define AT91C_UDPHS_INTSTA_EPT_3 (0x1 << 11) // (UDPHS) Endpoint 3 Interrupt
#define AT91C_UDPHS_INTSTA_EPT_4 (0x1 << 12) // (UDPHS) Endpoint 4 Interrupt
#define AT91C_UDPHS_INTSTA_EPT_5 (0x1 << 13) // (UDPHS) Endpoint 5 Interrupt
#define AT91C_UDPHS_INTSTA_EPT_6 (0x1 << 14) // (UDPHS) Endpoint 6 Interrupt
#define AT91C_UDPHS_INTSTA_DMA_1 (0x1 << 25) // (UDPHS) DMA Channel 1 Interrupt
#define AT91C_UDPHS_INTSTA_DMA_2 (0x1 << 26) // (UDPHS) DMA Channel 2 Interrupt
#define AT91C_UDPHS_INTSTA_DMA_3 (0x1 << 27) // (UDPHS) DMA Channel 3 Interrupt
#define AT91C_UDPHS_INTSTA_DMA_4 (0x1 << 28) // (UDPHS) DMA Channel 4 Interrupt
#define AT91C_UDPHS_INTSTA_DMA_5 (0x1 << 29) // (UDPHS) DMA Channel 5 Interrupt
#define AT91C_UDPHS_INTSTA_DMA_6 (0x1 << 30) // (UDPHS) DMA Channel 6 Interrupt
// -------- UDPHS_CLRINT : (UDPHS Offset: 0x18) UDPHS Clear Interrupt Register --------
#define AT91C_UDPHS_CLRINT_DET_SUSPD (0x1 << 1) // (UDPHS) Suspend Interrupt Clear
#define AT91C_UDPHS_CLRINT_MICRO_SOF (0x1 << 2) // (UDPHS) Micro Start Of Frame Interrupt Clear
#define AT91C_UDPHS_CLRINT_INT_SOF (0x1 << 3) // (UDPHS) Start Of Frame Interrupt Clear
#define AT91C_UDPHS_CLRINT_ENDRESET (0x1 << 4) // (UDPHS) End Of Reset Interrupt Clear
#define AT91C_UDPHS_CLRINT_WAKE_UP (0x1 << 5) // (UDPHS) Wake Up CPU Interrupt Clear
#define AT91C_UDPHS_CLRINT_ENDOFRSM (0x1 << 6) // (UDPHS) End Of Resume Interrupt Clear
#define AT91C_UDPHS_CLRINT_UPSTR_RES (0x1 << 7) // (UDPHS) Upstream Resume Interrupt Clear
// -------- UDPHS_EPTRST : (UDPHS Offset: 0x1C) UDPHS Endpoints Reset Register --------
#define AT91C_UDPHS_EPTRST_EPT_0 (0x1 << 0) // (UDPHS) Endpoint 0 Reset
#define AT91C_UDPHS_EPTRST_EPT_1 (0x1 << 1) // (UDPHS) Endpoint 1 Reset
#define AT91C_UDPHS_EPTRST_EPT_2 (0x1 << 2) // (UDPHS) Endpoint 2 Reset
#define AT91C_UDPHS_EPTRST_EPT_3 (0x1 << 3) // (UDPHS) Endpoint 3 Reset
#define AT91C_UDPHS_EPTRST_EPT_4 (0x1 << 4) // (UDPHS) Endpoint 4 Reset
#define AT91C_UDPHS_EPTRST_EPT_5 (0x1 << 5) // (UDPHS) Endpoint 5 Reset
#define AT91C_UDPHS_EPTRST_EPT_6 (0x1 << 6) // (UDPHS) Endpoint 6 Reset
// -------- UDPHS_TST : (UDPHS Offset: 0xE0) UDPHS Test Register --------
#define AT91C_UDPHS_TST_SPEED_CFG (0x3 << 0) // (UDPHS) Speed Configuration
#define     AT91C_UDPHS_TST_SPEED_CFG_NM   (0x0) // (UDPHS) Normal Mode
#define     AT91C_UDPHS_TST_SPEED_CFG_RS   (0x1) // (UDPHS) Reserved
#define     AT91C_UDPHS_TST_SPEED_CFG_HS   (0x2) // (UDPHS) Force High Speed
#define     AT91C_UDPHS_TST_SPEED_CFG_FS   (0x3) // (UDPHS) Force Full-Speed
#define AT91C_UDPHS_TST_TST_J (0x1 << 2) // (UDPHS) Test J Mode
#define AT91C_UDPHS_TST_TST_K (0x1 << 3) // (UDPHS) Test K Mode
#define AT91C_UDPHS_TST_TST_PKT (0x1 << 4) // (UDPHS) Test Packet Mode
#define AT91C_UDPHS_TST_OPMODE2 (0x1 << 5) // (UDPHS) OpMode2
// -------- UDPHS_IPNAME1 : (UDPHS Offset: 0xF0) UDPHS Name1 Register --------
#define AT91C_UDPHS_IPNAME1_IP_NAME1 (0xffffffff << 0) // (UDPHS)
// -------- UDPHS_IPNAME2 : (UDPHS Offset: 0xF4) UDPHS Name2 Register --------
#define AT91C_UDPHS_IPNAME2_IP_NAME2 (0xffffffff << 0) // (UDPHS)
// -------- UDPHS_IPFEATURES : (UDPHS Offset: 0xF8) UDPHS Features Register --------
#define AT91C_UDPHS_IPFEATURES_EPT_NBR_MAX (0xf << 0) // (UDPHS) Max Number of Endpoints
#define AT91C_UDPHS_IPFEATURES_DMA_CHANNEL_NBR (0x7 << 4) // (UDPHS) Number of DMA Channels
#define AT91C_UDPHS_IPFEATURES_DMA_B_SIZ (0x1 << 7) // (UDPHS) DMA Buffer Size
#define AT91C_UDPHS_IPFEATURES_DMA_FIFO_WORD_DEPTH (0xf << 8) // (UDPHS) DMA FIFO Depth in Words
#define AT91C_UDPHS_IPFEATURES_FIFO_MAX_SIZE (0x7 << 12) // (UDPHS) DPRAM Size
#define AT91C_UDPHS_IPFEATURES_BW_DPRAM (0x1 << 15) // (UDPHS) DPRAM Byte Write Capability
#define AT91C_UDPHS_IPFEATURES_DATAB16_8 (0x1 << 16) // (UDPHS) UTMI DataBus16_8
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_1 (0x1 << 17) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_2 (0x1 << 18) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_3 (0x1 << 19) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_4 (0x1 << 20) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_5 (0x1 << 21) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_6 (0x1 << 22) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_7 (0x1 << 23) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_8 (0x1 << 24) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_9 (0x1 << 25) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_10 (0x1 << 26) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_11 (0x1 << 27) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_12 (0x1 << 28) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_13 (0x1 << 29) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_14 (0x1 << 30) // (UDPHS) Endpointx High Bandwidth Isochronous Capability
#define AT91C_UDPHS_IPFEATURES_ISO_EPT_15 (0x1 << 31) // (UDPHS) Endpointx High Bandwidth Isochronous Capability

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Universal Synchronous Asynchronous Receiver Transmitter
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_USART {
  AT91_REG US_CR;         // Control Register
  AT91_REG US_MR;         // Mode Register
  AT91_REG US_IER;        // Interrupt Enable Register
  AT91_REG US_IDR;        // Interrupt Disable Register
  AT91_REG US_IMR;        // Interrupt Mask Register
  AT91_REG US_CSR;        // Channel Status Register
  AT91_REG US_RHR;        // Receiver Holding Register
  AT91_REG US_THR;        // Transmitter Holding Register
  AT91_REG US_BRGR;       // Baud Rate Generator Register
  AT91_REG US_RTOR;       // Receiver Time-out Register
  AT91_REG US_TTGR;       // Transmitter Timeguard Register
  AT91_REG Reserved1[5];
  AT91_REG US_FIDI;       // FI DI Ratio Register
  AT91_REG US_NER;        // Number of Errors Register
  AT91_REG Reserved2[1];
  AT91_REG US_IF;         // IrDA Filter Register
  AT91_REG Reserved3[44];
  AT91_REG US_RPR;        // Receive Pointer Register
  AT91_REG US_RCR;        // Receive Counter Register
  AT91_REG US_TPR;        // Transmit Pointer Register
  AT91_REG US_TCR;        // Transmit Counter Register
  AT91_REG US_RNPR;       // Receive Next Pointer Register
  AT91_REG US_RNCR;       // Receive Next Counter Register
  AT91_REG US_TNPR;       // Transmit Next Pointer Register
  AT91_REG US_TNCR;       // Transmit Next Counter Register
  AT91_REG US_PTCR;       // Transfer Control Register
  AT91_REG US_PTSR;       // Transfer Status Register
} AT91S_USART, *AT91PS_USART;
#else
#define US_CR   (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define US_MR   (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define US_IER  (AT91_CAST(AT91_REG *) 0x00000008) // Interrupt Enable Register
#define US_IDR  (AT91_CAST(AT91_REG *) 0x0000000C) // Interrupt Disable Register
#define US_IMR  (AT91_CAST(AT91_REG *) 0x00000010) // Interrupt Mask Register
#define US_CSR  (AT91_CAST(AT91_REG *) 0x00000014) // Channel Status Register
#define US_RHR  (AT91_CAST(AT91_REG *) 0x00000018) // Receiver Holding Register
#define US_THR  (AT91_CAST(AT91_REG *) 0x0000001C) // Transmitter Holding Register
#define US_BRGR (AT91_CAST(AT91_REG *) 0x00000020) // Baud Rate Generator Register
#define US_RTOR (AT91_CAST(AT91_REG *) 0x00000024) // Receiver Time-out Register
#define US_TTGR (AT91_CAST(AT91_REG *) 0x00000028) // Transmitter Timeguard Register
#define US_FIDI (AT91_CAST(AT91_REG *) 0x00000040) // FI DI Ratio Register
#define US_NER  (AT91_CAST(AT91_REG *) 0x00000044) // Number of Errors Register
#define US_IF   (AT91_CAST(AT91_REG *) 0x0000004C) // IrDA Filter Register
#define US_RPR  (AT91_CAST(AT91_REG *) 0x00000100) // Receive Pointer Register
#define US_RCR  (AT91_CAST(AT91_REG *) 0x00000104) // Receive Counter Register
#define US_TPR  (AT91_CAST(AT91_REG *) 0x00000108) // Transmit Pointer Register
#define US_TCR  (AT91_CAST(AT91_REG *) 0x0000010C) // Transmit Counter Register
#define US_RNPR (AT91_CAST(AT91_REG *) 0x00000110) // Receive Next Pointer Register
#define US_RNCR (AT91_CAST(AT91_REG *) 0x00000114) // Receive Next Counter Register
#define US_TNPR (AT91_CAST(AT91_REG *) 0x00000118) // Transmit Next Pointer Register
#define US_TNCR (AT91_CAST(AT91_REG *) 0x0000011C) // Transmit Next Counter Register
#define US_PTCR (AT91_CAST(AT91_REG *) 0x00000120) // Transfer Control Register
#define US_PTSR (AT91_CAST(AT91_REG *) 0x00000124) // Transfer Status Register
#endif
// -------- US_CR : (USART Offset: 0x0000) Control Register --------
#define AT91C_US_CR_RSTRX (0x1 << 2) // (USART) Reset Receiver
#define AT91C_US_CR_RSTTX (0x1 << 3) // (USART) Reset Transmitter
#define AT91C_US_CR_RXEN (0x1 << 4) // (USART) Receiver Enable
#define AT91C_US_CR_RXDIS (0x1 << 5) // (USART) Receiver Disable
#define AT91C_US_CR_TXEN (0x1 << 6) // (USART) Transmitter Enable
#define AT91C_US_CR_TXDIS (0x1 << 7) // (USART) Transmitter Disable
#define AT91C_US_CR_RSTSTA (0x1 << 8) // (USART) Reset Status Bits
#define AT91C_US_CR_STTBRK (0x1 << 9) // (USART) Start Break
#define AT91C_US_CR_STPBRK (0x1 << 10) // (USART) Stop Break
#define AT91C_US_CR_STTTO (0x1 << 11) // (USART) Start Time-out
#define AT91C_US_CR_SENDA (0x1 << 12) // (USART) Send Address
#define AT91C_US_CR_RSTIT (0x1 << 13) // (USART) Reset Iterations
#define AT91C_US_CR_RSTNACK (0x1 << 14) // (USART) Reset Non Acknowledge
#define AT91C_US_CR_RETTO (0x1 << 15) // (USART) Rearm Time-out
#define AT91C_US_CR_DTREN (0x1 << 16) // (USART) Data Terminal Ready Enable
#define AT91C_US_CR_DTRDIS (0x1 << 17) // (USART) Data Terminal Ready Disable
#define AT91C_US_CR_RTSEN (0x1 << 18) // (USART) Request to Send Enable
#define AT91C_US_CR_RTSDIS (0x1 << 19) // (USART) Request to Send Disable
// -------- US_MR : (USART Offset: 0x0004) Mode Register --------
#define AT91C_US_MR_USART_MODE (0xf << 0) // (USART)
#define AT91C_US_MR_USCLKS (0x3 << 4) // (USART) Clock Selection
#define AT91C_US_MR_CHRL (0x3 << 6) // (USART) Character Length.
#define AT91C_US_MR_SYNC (0x1 << 8) // (USART) Synchronous Mode Select
#define AT91C_US_MR_PAR (0x7 << 9) // (USART) Parity Type
#define AT91C_US_MR_NBSTOP (0x3 << 12) // (USART) Number of Stop Bits
#define AT91C_US_MR_CHMODE (0x3 << 14) // (USART) Channel Mode
#define AT91C_US_MR_MSBF (0x1 << 16) // (USART) Bit Order
#define AT91C_US_MR_MODE9 (0x1 << 17) // (USART) 9-bit Character Length
#define AT91C_US_MR_CLKO (0x1 << 18) // (USART) Clock Output Select
#define AT91C_US_MR_OVER (0x1 << 19) // (USART) Oversampling Mode
#define AT91C_US_MR_INACK (0x1 << 20) // (USART) Inhibit Non Acknowledge
#define AT91C_US_MR_DSNACK (0x1 << 21) // (USART) Disable Successive NACK
#define AT91C_US_MR_MAX_ITERATION (0x7 << 24) // (USART)
#define AT91C_US_MR_FILTER (0x1 << 28) // (USART) Infrared Receive Line Filter
// -------- US_IER : (USART Offset: 0x0008) Interrupt Enable Register --------
#define AT91C_US_IER_RXRDY (0x1 << 0) // (USART) RXRDY Interrupt Enable
#define AT91C_US_IER_TXRDY (0x1 << 1) // (USART) TXRDY Interrupt Enable
#define AT91C_US_IER_RXBRK (0x1 << 2) // (USART) Receiver Break Interrupt Enable
#define AT91C_US_IER_ENDRX (0x1 << 3) // (USART) End of Receive Transfer Interrupt Enable
#define AT91C_US_IER_ENDTX (0x1 << 4) // (USART) End of Transmit Interrupt Enable
#define AT91C_US_IER_OVRE (0x1 << 5) // (USART) Overrun Error Interrupt Enable
#define AT91C_US_IER_FRAME (0x1 << 6) // (USART) Framing Error Interrupt Enable
#define AT91C_US_IER_PARE (0x1 << 7) // (USART) Parity Error Interrupt Enable
#define AT91C_US_IER_TIMEOUT (0x1 << 8) // (USART) Time-out Interrupt Enable
#define AT91C_US_IER_TXEMPTY (0x1 << 9) // (USART) TXEMPTY Interrupt Enable
#define AT91C_US_IER_ITER (0x1 << 10) // (USART) Iteration Interrupt Enable
#define AT91C_US_IER_TXBUFE (0x1 << 11) // (USART) Buffer Empty Interrupt Enable
#define AT91C_US_IER_RXBUFF (0x1 << 12) // (USART) Buffer Full Interrupt Enable
#define AT91C_US_IER_NACK (0x1 << 13) // (USART) Non Acknowledge Interrupt Enable
#define AT91C_US_IER_RIIC (0x1 << 16) // (USART) Ring Indicator Input Change Enable
#define AT91C_US_IER_DSRIC (0x1 << 17) // (USART) Data Set Ready Input Change Enable
#define AT91C_US_IER_DCDIC (0x1 << 18) // (USART) Data Carrier Detect Input Change Interrupt Enable
#define AT91C_US_IER_CTSIC (0x1 << 19) // (USART) Clear to Send Input Change Interrupt Enable
// -------- US_IDR : (USART Offset: 0x000C) Interrupt Disable Register --------
#define AT91C_US_IDR_RXRDY (0x1 << 0) // (USART) RXRDY Interrupt Disable
#define AT91C_US_IDR_TXRDY (0x1 << 1) // (USART) TXRDY Interrupt Disable
#define AT91C_US_IDR_RXBRK (0x1 << 2) // (USART) Receiver Break Interrupt Disable
#define AT91C_US_IDR_ENDRX (0x1 << 3) // (USART) End of Receive Transfer Interrupt Disable
#define AT91C_US_IDR_ENDTX (0x1 << 4) // (USART) End of Transmit Interrupt Disable
#define AT91C_US_IDR_OVRE (0x1 << 5) // (USART) Overrun Error Interrupt Disable
#define AT91C_US_IDR_FRAME (0x1 << 6) // (USART) Framing Error Interrupt Disable
#define AT91C_US_IDR_PARE (0x1 << 7) // (USART) Parity Error Interrupt Disable
#define AT91C_US_IDR_TIMEOUT (0x1 << 8) // (USART) Time-out Interrupt Disable
#define AT91C_US_IDR_TXEMPTY (0x1 << 9) // (USART) TXEMPTY Interrupt Disable
#define AT91C_US_IDR_ITER (0x1 << 10) // (USART) Iteration Interrupt Enable
#define AT91C_US_IDR_TXBUFE (0x1 << 11) // (USART) Buffer Empty Interrupt Disable
#define AT91C_US_IDR_RXBUFF (0x1 << 12) // (USART) Buffer Full Interrupt Disable
#define AT91C_US_IDR_NACK (0x1 << 13) // (USART) Non Acknowledge Interrupt Disable
#define AT91C_US_IDR_RIIC (0x1 << 16) // (USART) Ring Indicator Input Change Disable
#define AT91C_US_IDR_DSRIC (0x1 << 17) // (USART) Data Set Ready Input Change Disable
#define AT91C_US_IDR_DCDIC (0x1 << 18) // (USART) Data Carrier Detect Input Change Interrupt Disable
#define AT91C_US_IDR_CTSIC (0x1 << 19) // (USART) Clear to Send Input Change Interrupt Disable
// -------- US_IMR : (USART Offset: 0x0010) Interrupt Mask Register --------
#define AT91C_US_IMR_RXRDY (0x1 << 0) // (USART) RXRDY Interrupt Mask
#define AT91C_US_IMR_TXRDY (0x1 << 1) // (USART) TXRDY Interrupt Mask
#define AT91C_US_IMR_RXBRK (0x1 << 2) // (USART) Receiver Break Interrupt Mask
#define AT91C_US_IMR_ENDRX (0x1 << 3) // (USART) End of Receive Transfer Interrupt Mask
#define AT91C_US_IMR_ENDTX (0x1 << 4) // (USART) End of Transmit Interrupt Mask
#define AT91C_US_IMR_OVRE (0x1 << 5) // (USART) Overrun Error Interrupt Mask
#define AT91C_US_IMR_FRAME (0x1 << 6) // (USART) Framing Error Interrupt Mask
#define AT91C_US_IMR_PARE (0x1 << 7) // (USART) Parity Error Interrupt Mask
#define AT91C_US_IMR_TIMEOUT (0x1 << 8) // (USART) Time-out Interrupt Mask
#define AT91C_US_IMR_TXEMPTY (0x1 << 9) // (USART) TXEMPTY Interrupt Mask
#define AT91C_US_IMR_ITER (0x1 << 10) // (USART) Iteration Interrupt Enable
#define AT91C_US_IMR_TXBUFE (0x1 << 11) // (USART) Buffer Empty Interrupt Mask
#define AT91C_US_IMR_RXBUFF (0x1 << 12) // (USART) Buffer Full Interrupt Mask
#define AT91C_US_IMR_NACK (0x1 << 13) // (USART) Non Acknowledge Interrupt Mask
#define AT91C_US_IMR_RIIC (0x1 << 16) // (USART) Ring Indicator Input Change Mask
#define AT91C_US_IMR_DSRIC (0x1 << 17) // (USART) Data Set Ready Input Change Mask
#define AT91C_US_IMR_DCDIC (0x1 << 18) // (USART) Data Carrier Detect Input Change Interrupt Mask
#define AT91C_US_IMR_CTSIC (0x1 << 19) // (USART) Clear to Send Input Change Interrupt Mask
// -------- US_CSR : (USART Offset: 0x0014) Channel Status Register --------
#define AT91C_US_CSR_RXRDY (0x1 << 0) // (USART) Receiver Ready
#define AT91C_US_CSR_TXRDY (0x1 << 1) // (USART) Transmitter Ready
#define AT91C_US_CSR_RXBRK (0x1 << 2) // (USART) Break Received/End of Break
#define AT91C_US_CSR_ENDRX (0x1 << 3) // (USART) End of Receiver Transfer
#define AT91C_US_CSR_ENDTX (0x1 << 4) // (USART) End of Transmitter Transfer
#define AT91C_US_CSR_OVRE (0x1 << 5) // (USART) Overrun Error
#define AT91C_US_CSR_FRAME (0x1 << 6) // (USART) Framing Error
#define AT91C_US_CSR_PARE (0x1 << 7) // (USART) Parity Error
#define AT91C_US_CSR_TIMEOUT (0x1 << 8) // (USART) Receiver Time-out
#define AT91C_US_CSR_TXEMPTY (0x1 << 9) // (USART) Transmitter Empty
#define AT91C_US_CSR_ITER (0x1 << 10) // (USART) Max number of Repetitions Reached
#define AT91C_US_CSR_TXBUFE (0x1 << 11) // (USART) Transmission Buffer Empty
#define AT91C_US_CSR_RXBUFF (0x1 << 12) // (USART) Reception Buffer Full
#define AT91C_US_CSR_NACK (0x1 << 13) // (USART) Non Acknowledge
#define AT91C_US_CSR_RIIC (0x1 << 16) // (USART) Ring Indicator Input Change Flag
#define AT91C_US_CSR_DSRIC (0x1 << 17) // (USART) Data Set Ready Input Change Flag
#define AT91C_US_CSR_DCDIC (0x1 << 18) // (USART) Data Carrier Detect Input Change Flag
#define AT91C_US_CSR_CTSIC (0x1 << 19) // (USART) Clear to Send Input Change Flag
#define AT91C_US_CSR_RI (0x1 << 20) // (USART) Image of RI Input
#define AT91C_US_CSR_DSR (0x1 << 21) // (USART) Image of DSR Input
#define AT91C_US_CSR_DCD (0x1 << 22) // (USART) Image of DCD Input
#define AT91C_US_CSR_CTS (0x1 << 23) // (USART) Image of CTS Input
// -------- US_RHR : (USART Offset: 0x0018) Receiver Holding Register --------
#define AT91C_US_RHR_RXCHR (0x1ff << 0) // (USART) Received Character
#define AT91C_US_RHR_RXSYNH (0x1 << 15) // (USART) Received Sync
// -------- US_THR : (USART Offset: 0x001C) Transmitter Holding Register --------
#define AT91C_US_THR_TXCHR (0x1ff << 0) // (USART) Character to be Transmitted
#define AT91C_US_THR_TXSYNH (0x1 << 15) // (USART) Sync Field to be transmitted
// -------- US_BRGR : (USART Offset: 0x0020) Baud Rate Generator Register --------
#define AT91C_US_BRGR_CD (0xffff << 0) // (USART) Clock Divider
#define AT91C_US_BRGR_FP_ (0x7 << 16) // (USART)
// -------- US_RTOR : (USART Offset: 0x0024) Receiver Time-out Register --------
#define AT91C_US_RTOR_TO (0xffff << 0) // (USART) Time-out Value
// -------- US_TTGR : (USART Offset: 0x0028) Transmitter Timeguard Register --------
#define AT91C_US_TTGR_TG (0xff << 0) // (USART) Timeguard Value
// -------- US_FIDI : (USART Offset: 0x0040) FI DI Ratio Register --------
#define AT91C_US_FIDI_FI_DI_RATIO (0x7ff << 0) // (USART) FI Over DI Ratio Value
// -------- US_NER : (USART Offset: 0x0044) Number of Errors Register --------
#define AT91C_US_NER_NB_ERRORS (0xff << 0) // (USART) Number of Errors
// -------- US_IF : (USART Offset: 0x004C) IrDA Filter Register --------
#define AT91C_US_IF_IRDA_FILTER (0xff << 0) // (USART) IrDA Filter
// -------- US_RPR : (USART Offset: 0x100) Receive Pointer Register --------
#define AT91C_US_RPR_RXPTR (0xffffffff << 0) // (USART) Receive Pointer Register
// -------- US_RCR : (USART Offset: 0x104) Receive Counter Register --------
#define AT91C_US_RCR_RXCTR (0xffff << 0) // (USART) Receive Counter Register
// -------- US_TPR : (USART Offset: 0x108) Transmit Pointer Register --------
#define AT91C_US_TPR_TXPTR (0xffffffff << 0) // (USART) Transmit Counter Register
// -------- US_TCR : (USART Offset: 0x10C) Transmit Counter Register --------
#define AT91C_US_TCR_TXCTR (0xffff << 0) // (USART) Transmit Counter Register
// -------- US_RNPR : (USART Offset: 0x110) Receive Next Pointer Register --------
#define AT91C_US_RNPR_RXNPTR (0xffffffff << 0) // (USART) Receive Next Pointer
// -------- US_RNCR : (USART Offset: 0x114) Receive Next Counter Register --------
#define AT91C_US_RNCR_RXNCTR (0xffff << 0) // (USART) Receive Next Counter
// -------- US_TNPR : (USART Offset: 0x118) Transmit Next Pointer Register --------
#define AT91C_US_TNPR_TXNPTR (0xffffffff << 0) // (USART) Transmit Next Pointer
// -------- US_TNCR : (USART Offset: 0x11C) Transmit Next Counter Register --------
#define AT91C_US_TNCR_TXNCTR (0xffff << 0) // (USART) Transmit Counter Next
// -------- US_PTCR : (USART Offset: 0x120) Transfer Control Register --------
#define AT91C_US_PTCR_RXTEN (0x1 << 0) // (USART) Receiver Transfer Enable
#define AT91C_US_PTCR_RXTDIS (0x1 << 1) // (USART) Receiver Transfer Disable
#define AT91C_US_PTCR_TXTEN (0x1 << 8) // (USART) Transmitter Transfer Enable
#define AT91C_US_PTCR_TXTDIS (0x1 << 9) // (USART) Transmitter Transfer Disable
// -------- US_PTSR : (USART Offset: 0x124) Transfer Status Register --------
#define AT91C_US_PTSR_RXTEN (0x1 << 0) // (USART) Receiver Transfer Enable
#define AT91C_US_PTSR_TXTEN (0x1 << 8) // (USART) Transmitter Transfer Enable

// *****************************************************************************
//   SOFTWARE API DEFINITION FOR Watchdog Timer
// *****************************************************************************

#ifndef __ASSEMBLY__
typedef struct _AT91S_WDT {
  AT91_REG WDT_CR; // Control Register
  AT91_REG WDT_MR; // Mode Register
  AT91_REG WDT_SR; // Status Register
} AT91S_WDT, *AT91PS_WDT;
#else
#define WDT_CR (AT91_CAST(AT91_REG *) 0x00000000) // Control Register
#define WDT_MR (AT91_CAST(AT91_REG *) 0x00000004) // Mode Register
#define WDT_SR (AT91_CAST(AT91_REG *) 0x00000008) // Status Register
#endif
// -------- WDT_CR : (WDT Offset: 0x00) Control Register --------
#define AT91C_WDT_CR_WDRSTT (0x1 << 0) // (WDT) Watchdog Restart
#define AT91C_WDT_CR_KEY (0xff << 24) // (WDT) Password
// -------- WDT_MR : (WDT Offset: 0x04) Mode Register --------
#define AT91C_WDT_MR_WDV (0xfff << 0) // (WDT) Watchdog Counter Value
#define AT91C_WDT_MR_WDFIEN (0x1 << 12) // (WDT) Watchdog Fault Interrupt Enable
#define AT91C_WDT_MR_WDRSTEN (0x1 << 13) // (WDT) Watchdog Reset Enable
#define AT91C_WDT_MR_WDRPROC (0x1 << 14) // (WDT) Watchdog Reset Processor
#define AT91C_WDT_MR_WDDIS (0x1 << 15) // (WDT) Watchdog Disable
#define AT91C_WDT_MR_WDD (0xfff << 16) // (WDT) Watchdog Delta Value
#define AT91C_WDT_MR_WDDBGHLT (0x1 << 28) // (WDT) Watchdog Debug Halt
#define AT91C_WDT_MR_WDIDLEHLT (0x1 << 29) // (WDT) Watchdog Idle Halt
// -------- WDT_SR : (WDT Offset: 0x08) Status Register --------
#define AT91C_WDT_SR_WDUNF (0x1 << 0) // (WDT) Watchdog Underflow
#define AT91C_WDT_SR_WDERR (0x1 << 1) // (WDT) Watchdog Error

// *****************************************************************************
//   REGISTER ADDRESS DEFINITIONS FOR AT91SAM9M11
// *****************************************************************************

// ========== Register definition for LCDC peripheral ==========
#define AT91C_LCDC_DMABADDR1    (AT91_CAST(AT91_REG *) 0x00500000) // (LCDC) DMA Base Address Register 1
#define AT91C_LCDC_DMABADDR2    (AT91_CAST(AT91_REG *) 0x00500004) // (LCDC) DMA Base Address Register 2
#define AT91C_LCDC_DMAFRMPT1    (AT91_CAST(AT91_REG *) 0x00500008) // (LCDC) DMA Frame Pointer Register 1
#define AT91C_LCDC_DMAFRMPT2    (AT91_CAST(AT91_REG *) 0x0050000C) // (LCDC) DMA Frame Pointer Register 2
#define AT91C_LCDC_DMAFRMADD1   (AT91_CAST(AT91_REG *) 0x00500010) // (LCDC) DMA Frame Address Register 1
#define AT91C_LCDC_DMAFRMADD2   (AT91_CAST(AT91_REG *) 0x00500014) // (LCDC) DMA Frame Address Register 2
#define AT91C_LCDC_DMAFRMCFG    (AT91_CAST(AT91_REG *) 0x00500018) // (LCDC) DMA Frame Configuration Register
#define AT91C_LCDC_DMACON       (AT91_CAST(AT91_REG *) 0x0050001C) // (LCDC) DMA Control Register
#define AT91C_LCDC_DMA2DCFG     (AT91_CAST(AT91_REG *) 0x00500020) // (LCDC) DMA Control Register
#define AT91C_LCDC_CON1         (AT91_CAST(AT91_REG *) 0x00500800) // (LCDC) LCD Control Register 1
#define AT91C_LCDC_CON2         (AT91_CAST(AT91_REG *) 0x00500804) // (LCDC) LCD Control Register 2
#define AT91C_LCDC_TIM1         (AT91_CAST(AT91_REG *) 0x00500808) // (LCDC) LCD Timing Register 1
#define AT91C_LCDC_TIM2         (AT91_CAST(AT91_REG *) 0x0050080C) // (LCDC) LCD Timing Register 2
#define AT91C_LCDC_FRMCFG       (AT91_CAST(AT91_REG *) 0x00500810) // (LCDC) LCD Frame Configuration Register
#define AT91C_LCDC_FIFO         (AT91_CAST(AT91_REG *) 0x00500814) // (LCDC) LCD FIFO Register
#define AT91C_LCDC_DP1_2        (AT91_CAST(AT91_REG *) 0x0050081C) // (LCDC) Dithering Pattern DP1_2
#define AT91C_LCDC_DP4_7        (AT91_CAST(AT91_REG *) 0x00500820) // (LCDC) Dithering Pattern DP4_7
#define AT91C_LCDC_DP3_5        (AT91_CAST(AT91_REG *) 0x00500824) // (LCDC) Dithering Pattern DP3_5
#define AT91C_LCDC_DP2_3        (AT91_CAST(AT91_REG *) 0x00500828) // (LCDC) Dithering Pattern DP2_3
#define AT91C_LCDC_DP5_7        (AT91_CAST(AT91_REG *) 0x0050082C) // (LCDC) Dithering Pattern DP5_7
#define AT91C_LCDC_DP3_4        (AT91_CAST(AT91_REG *) 0x00500830) // (LCDC) Dithering Pattern DP3_4
#define AT91C_LCDC_DP4_5        (AT91_CAST(AT91_REG *) 0x00500834) // (LCDC) Dithering Pattern DP4_5
#define AT91C_LCDC_DP6_7        (AT91_CAST(AT91_REG *) 0x00500838) // (LCDC) Dithering Pattern DP6_7
#define AT91C_LCDC_PWRCON       (AT91_CAST(AT91_REG *) 0x0050083C) // (LCDC) Power Control Register
#define AT91C_LCDC_CONTRAST_CTR (AT91_CAST(AT91_REG *) 0x00500840) // (LCDC) Contrast Control Register
#define AT91C_LCDC_CONTRAST_VAL (AT91_CAST(AT91_REG *) 0x00500844) // (LCDC) Contrast Value Register
#define AT91C_LCDC_IER          (AT91_CAST(AT91_REG *) 0x00500848) // (LCDC) LCD Interrupt Enable Register
#define AT91C_LCDC_IDR          (AT91_CAST(AT91_REG *) 0x0050084C) // (LCDC) LCD Interrupt Disable Register
#define AT91C_LCDC_IMR          (AT91_CAST(AT91_REG *) 0x00500850) // (LCDC) LCD Interrupt Mask Register
#define AT91C_LCDC_ISR          (AT91_CAST(AT91_REG *) 0x00500854) // (LCDC) LCD Interrupt Status Register
#define AT91C_LCDC_ICR          (AT91_CAST(AT91_REG *) 0x00500858) // (LCDC) LCD Interrupt Clear Register
#define AT91C_LCDC_ITR          (AT91_CAST(AT91_REG *) 0x00500860) // (LCDC) LCD Interrupt Test Register
#define AT91C_LCDC_IRR          (AT91_CAST(AT91_REG *) 0x00500864) // (LCDC) LCD Interrupt Raw Status Register
#define AT91C_LCDC_LUTENTRY     (AT91_CAST(AT91_REG *) 0x00500C00) // (LCDC) Palette entry
// ========== Register definition for UDPHS peripheral ==========
#define AT91C_UDPHS_CTRL        (AT91_CAST(AT91_REG *) 0xFFF78000) // (UDPHS) UDPHS Control Register
#define AT91C_UDPHS_FNUM        (AT91_CAST(AT91_REG *) 0xFFF78004) // (UDPHS) UDPHS Frame Number Register
#define AT91C_UDPHS_IEN         (AT91_CAST(AT91_REG *) 0xFFF78010) // (UDPHS) UDPHS Interrupt Enable Register
#define AT91C_UDPHS_INTSTA      (AT91_CAST(AT91_REG *) 0xFFF78014) // (UDPHS) UDPHS Interrupt Status Register
#define AT91C_UDPHS_CLRINT      (AT91_CAST(AT91_REG *) 0xFFF78018) // (UDPHS) UDPHS Clear Interrupt Register
#define AT91C_UDPHS_EPTRST      (AT91_CAST(AT91_REG *) 0xFFF7801C) // (UDPHS) UDPHS Endpoints Reset Register
#define AT91C_UDPHS_TST         (AT91_CAST(AT91_REG *) 0xFFF780E0) // (UDPHS) UDPHS Test Register
#define AT91C_UDPHS_IPNAME1     (AT91_CAST(AT91_REG *) 0xFFF780F0) // (UDPHS) UDPHS Name1 Register
#define AT91C_UDPHS_IPNAME2     (AT91_CAST(AT91_REG *) 0xFFF780F4) // (UDPHS) UDPHS Name2 Register
#define AT91C_UDPHS_IPFEATURES  (AT91_CAST(AT91_REG *) 0xFFF780F8) // (UDPHS) UDPHS Features Register
#define AT91C_UDPHS_EPTCFG0     (AT91_CAST(AT91_REG *) 0xFFF78100) // (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 0)
#define AT91C_UDPHS_EPTCTLENB0  (AT91_CAST(AT91_REG *) 0xFFF78104) // (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 0)
#define AT91C_UDPHS_EPTCTLDIS0  (AT91_CAST(AT91_REG *) 0xFFF78108) // (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 0)
#define AT91C_UDPHS_EPTCTL0     (AT91_CAST(AT91_REG *) 0xFFF7810C) // (UDPHS) UDPHS Endpoint Control Register (endpoint = 0)
#define AT91C_UDPHS_EPTSETSTA0  (AT91_CAST(AT91_REG *) 0xFFF78114) // (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 0)
#define AT91C_UDPHS_EPTCLRSTA0  (AT91_CAST(AT91_REG *) 0xFFF78118) // (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 0)
#define AT91C_UDPHS_EPTSTA0     (AT91_CAST(AT91_REG *) 0xFFF7811C) // (UDPHS) UDPHS Endpoint Status Register (endpoint = 0)
#define AT91C_UDPHS_EPTCFG1     (AT91_CAST(AT91_REG *) 0xFFF78120) // (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 1)
#define AT91C_UDPHS_EPTCTLENB1  (AT91_CAST(AT91_REG *) 0xFFF78124) // (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 1)
#define AT91C_UDPHS_EPTCTLDIS1  (AT91_CAST(AT91_REG *) 0xFFF78128) // (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 1)
#define AT91C_UDPHS_EPTCTL1     (AT91_CAST(AT91_REG *) 0xFFF7812C) // (UDPHS) UDPHS Endpoint Control Register (endpoint = 1)
#define AT91C_UDPHS_EPTSETSTA1  (AT91_CAST(AT91_REG *) 0xFFF78134) // (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 1)
#define AT91C_UDPHS_EPTCLRSTA1  (AT91_CAST(AT91_REG *) 0xFFF78138) // (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 1)
#define AT91C_UDPHS_EPTSTA1     (AT91_CAST(AT91_REG *) 0xFFF7813C) // (UDPHS) UDPHS Endpoint Status Register (endpoint = 1)
#define AT91C_UDPHS_EPTCFG2     (AT91_CAST(AT91_REG *) 0xFFF78140) // (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 2)
#define AT91C_UDPHS_EPTCTLENB2  (AT91_CAST(AT91_REG *) 0xFFF78144) // (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 2)
#define AT91C_UDPHS_EPTCTLDIS2  (AT91_CAST(AT91_REG *) 0xFFF78148) // (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 2)
#define AT91C_UDPHS_EPTCTL2     (AT91_CAST(AT91_REG *) 0xFFF7814C) // (UDPHS) UDPHS Endpoint Control Register (endpoint = 2)
#define AT91C_UDPHS_EPTSETSTA2  (AT91_CAST(AT91_REG *) 0xFFF78154) // (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 2)
#define AT91C_UDPHS_EPTCLRSTA2  (AT91_CAST(AT91_REG *) 0xFFF78158) // (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 2)
#define AT91C_UDPHS_EPTSTA2     (AT91_CAST(AT91_REG *) 0xFFF7815C) // (UDPHS) UDPHS Endpoint Status Register (endpoint = 2)
#define AT91C_UDPHS_EPTCFG3     (AT91_CAST(AT91_REG *) 0xFFF78160) // (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 3)
#define AT91C_UDPHS_EPTCTLENB3  (AT91_CAST(AT91_REG *) 0xFFF78164) // (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 3)
#define AT91C_UDPHS_EPTCTLDIS3  (AT91_CAST(AT91_REG *) 0xFFF78168) // (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 3)
#define AT91C_UDPHS_EPTCTL3     (AT91_CAST(AT91_REG *) 0xFFF7816C) // (UDPHS) UDPHS Endpoint Control Register (endpoint = 3)
#define AT91C_UDPHS_EPTSETSTA3  (AT91_CAST(AT91_REG *) 0xFFF78174) // (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 3)
#define AT91C_UDPHS_EPTCLRSTA3  (AT91_CAST(AT91_REG *) 0xFFF78178) // (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 3)
#define AT91C_UDPHS_EPTSTA3     (AT91_CAST(AT91_REG *) 0xFFF7817C) // (UDPHS) UDPHS Endpoint Status Register (endpoint = 3)
#define AT91C_UDPHS_EPTCFG4     (AT91_CAST(AT91_REG *) 0xFFF78180) // (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 4)
#define AT91C_UDPHS_EPTCTLENB4  (AT91_CAST(AT91_REG *) 0xFFF78184) // (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 4)
#define AT91C_UDPHS_EPTCTLDIS4  (AT91_CAST(AT91_REG *) 0xFFF78188) // (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 4)
#define AT91C_UDPHS_EPTCTL4     (AT91_CAST(AT91_REG *) 0xFFF7818C) // (UDPHS) UDPHS Endpoint Control Register (endpoint = 4)
#define AT91C_UDPHS_EPTSETSTA4  (AT91_CAST(AT91_REG *) 0xFFF78194) // (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 4)
#define AT91C_UDPHS_EPTCLRSTA4  (AT91_CAST(AT91_REG *) 0xFFF78198) // (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 4)
#define AT91C_UDPHS_EPTSTA4     (AT91_CAST(AT91_REG *) 0xFFF7819C) // (UDPHS) UDPHS Endpoint Status Register (endpoint = 4)
#define AT91C_UDPHS_EPTCFG5     (AT91_CAST(AT91_REG *) 0xFFF781A0) // (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 5)
#define AT91C_UDPHS_EPTCTLENB5  (AT91_CAST(AT91_REG *) 0xFFF781A4) // (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 5)
#define AT91C_UDPHS_EPTCTLDIS5  (AT91_CAST(AT91_REG *) 0xFFF781A8) // (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 5)
#define AT91C_UDPHS_EPTCTL5     (AT91_CAST(AT91_REG *) 0xFFF781AC) // (UDPHS) UDPHS Endpoint Control Register (endpoint = 5)
#define AT91C_UDPHS_EPTSETSTA5  (AT91_CAST(AT91_REG *) 0xFFF781B4) // (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 5)
#define AT91C_UDPHS_EPTCLRSTA5  (AT91_CAST(AT91_REG *) 0xFFF781B8) // (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 5)
#define AT91C_UDPHS_EPTSTA5     (AT91_CAST(AT91_REG *) 0xFFF781BC) // (UDPHS) UDPHS Endpoint Status Register (endpoint = 5)
#define AT91C_UDPHS_EPTCFG6     (AT91_CAST(AT91_REG *) 0xFFF781C0) // (UDPHS) UDPHS Endpoint Configuration Register (endpoint = 6)
#define AT91C_UDPHS_EPTCTLENB6  (AT91_CAST(AT91_REG *) 0xFFF781C4) // (UDPHS) UDPHS Endpoint Control Enable Register (endpoint = 6)
#define AT91C_UDPHS_EPTCTLDIS6  (AT91_CAST(AT91_REG *) 0xFFF781C8) // (UDPHS) UDPHS Endpoint Control Disable Register (endpoint = 6)
#define AT91C_UDPHS_EPTCTL6     (AT91_CAST(AT91_REG *) 0xFFF781CC) // (UDPHS) UDPHS Endpoint Control Register (endpoint = 6)
#define AT91C_UDPHS_EPTSETSTA6  (AT91_CAST(AT91_REG *) 0xFFF781D4) // (UDPHS) UDPHS Endpoint Set Status Register (endpoint = 6)
#define AT91C_UDPHS_EPTCLRSTA6  (AT91_CAST(AT91_REG *) 0xFFF781D8) // (UDPHS) UDPHS Endpoint Clear Status Register (endpoint = 6)
#define AT91C_UDPHS_EPTSTA6     (AT91_CAST(AT91_REG *) 0xFFF781DC) // (UDPHS) UDPHS Endpoint Status Register (endpoint = 6)
#define AT91C_UDPHS_DMANXTDSC1  (AT91_CAST(AT91_REG *) 0xFFF78320) // (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 1)
#define AT91C_UDPHS_DMAADDRESS1 (AT91_CAST(AT91_REG *) 0xFFF78324) // (UDPHS) UDPHS DMA Channel Address Register (channel = 1)
#define AT91C_UDPHS_DMACONTROL1 (AT91_CAST(AT91_REG *) 0xFFF78328) // (UDPHS) UDPHS DMA Channel Control Register (channel = 1)
#define AT91C_UDPHS_DMASTATUS1  (AT91_CAST(AT91_REG *) 0xFFF7832C) // (UDPHS) UDPHS DMA Channel Status Register (channel = 1)
#define AT91C_UDPHS_DMANXTDSC2  (AT91_CAST(AT91_REG *) 0xFFF78330) // (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 2)
#define AT91C_UDPHS_DMAADDRESS2 (AT91_CAST(AT91_REG *) 0xFFF78334) // (UDPHS) UDPHS DMA Channel Address Register (channel = 2)
#define AT91C_UDPHS_DMACONTROL2 (AT91_CAST(AT91_REG *) 0xFFF78338) // (UDPHS) UDPHS DMA Channel Control Register (channel = 2)
#define AT91C_UDPHS_DMASTATUS2  (AT91_CAST(AT91_REG *) 0xFFF7833C) // (UDPHS) UDPHS DMA Channel Status Register (channel = 2)
#define AT91C_UDPHS_DMANXTDSC3  (AT91_CAST(AT91_REG *) 0xFFF78340) // (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 3)
#define AT91C_UDPHS_DMAADDRESS3 (AT91_CAST(AT91_REG *) 0xFFF78344) // (UDPHS) UDPHS DMA Channel Address Register (channel = 3)
#define AT91C_UDPHS_DMACONTROL3 (AT91_CAST(AT91_REG *) 0xFFF78348) // (UDPHS) UDPHS DMA Channel Control Register (channel = 3)
#define AT91C_UDPHS_DMASTATUS3  (AT91_CAST(AT91_REG *) 0xFFF7834C) // (UDPHS) UDPHS DMA Channel Status Register (channel = 3)
#define AT91C_UDPHS_DMANXTDSC4  (AT91_CAST(AT91_REG *) 0xFFF78350) // (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 4)
#define AT91C_UDPHS_DMAADDRESS4 (AT91_CAST(AT91_REG *) 0xFFF78354) // (UDPHS) UDPHS DMA Channel Address Register (channel = 4)
#define AT91C_UDPHS_DMACONTROL4 (AT91_CAST(AT91_REG *) 0xFFF78358) // (UDPHS) UDPHS DMA Channel Control Register (channel = 4)
#define AT91C_UDPHS_DMASTATUS4  (AT91_CAST(AT91_REG *) 0xFFF7835C) // (UDPHS) UDPHS DMA Channel Status Register (channel = 4)
#define AT91C_UDPHS_DMANXTDSC5  (AT91_CAST(AT91_REG *) 0xFFF78360) // (UDPHS) UDPHS DMA Next Descriptor Address Register (channel = 5)
#define AT91C_UDPHS_DMAADDRESS5 (AT91_CAST(AT91_REG *) 0xFFF78364) // (UDPHS) UDPHS DMA Channel Address Register (channel = 5)
#define AT91C_UDPHS_DMACONTROL5 (AT91_CAST(AT91_REG *) 0xFFF78368) // (UDPHS) UDPHS DMA Channel Control Register (channel = 5)
#define AT91C_UDPHS_DMASTATUS5  (AT91_CAST(AT91_REG *) 0xFFF7836C) // (UDPHS) UDPHS DMA Channel Status Register (channel = 5)
// ========== Register definition for TC0 peripheral ==========
#define AT91C_TC0_CCR0          (AT91_CAST(AT91_REG *) 0xFFF7C000) // (TC0) Channel Control Register (channel = 0)
#define AT91C_TC0_CMR0          (AT91_CAST(AT91_REG *) 0xFFF7C004) // (TC0) Channel Mode Register (channel = 0)
#define AT91C_TC0_CV0           (AT91_CAST(AT91_REG *) 0xFFF7C010) // (TC0) Counter Value (channel = 0)
#define AT91C_TC0_RA0           (AT91_CAST(AT91_REG *) 0xFFF7C014) // (TC0) Register A (channel = 0)
#define AT91C_TC0_RB0           (AT91_CAST(AT91_REG *) 0xFFF7C018) // (TC0) Register B (channel = 0)
#define AT91C_TC0_RC0           (AT91_CAST(AT91_REG *) 0xFFF7C01C) // (TC0) Register C (channel = 0)
#define AT91C_TC0_SR0           (AT91_CAST(AT91_REG *) 0xFFF7C020) // (TC0) Status Register (channel = 0)
#define AT91C_TC0_IER0          (AT91_CAST(AT91_REG *) 0xFFF7C024) // (TC0) Interrupt Enable Register (channel = 0)
#define AT91C_TC0_IDR0          (AT91_CAST(AT91_REG *) 0xFFF7C028) // (TC0) Interrupt Disable Register (channel = 0)
#define AT91C_TC0_IMR0          (AT91_CAST(AT91_REG *) 0xFFF7C02C) // (TC0) Interrupt Mask Register (channel = 0)
#define AT91C_TC0_CCR1          (AT91_CAST(AT91_REG *) 0xFFF7C040) // (TC0) Channel Control Register (channel = 1)
#define AT91C_TC0_CMR1          (AT91_CAST(AT91_REG *) 0xFFF7C044) // (TC0) Channel Mode Register (channel = 1)
#define AT91C_TC0_CV1           (AT91_CAST(AT91_REG *) 0xFFF7C050) // (TC0) Counter Value (channel = 1)
#define AT91C_TC0_RA1           (AT91_CAST(AT91_REG *) 0xFFF7C054) // (TC0) Register A (channel = 1)
#define AT91C_TC0_RB1           (AT91_CAST(AT91_REG *) 0xFFF7C058) // (TC0) Register B (channel = 1)
#define AT91C_TC0_RC1           (AT91_CAST(AT91_REG *) 0xFFF7C05C) // (TC0) Register C (channel = 1)
#define AT91C_TC0_SR1           (AT91_CAST(AT91_REG *) 0xFFF7C060) // (TC0) Status Register (channel = 1)
#define AT91C_TC0_IER1          (AT91_CAST(AT91_REG *) 0xFFF7C064) // (TC0) Interrupt Enable Register (channel = 1)
#define AT91C_TC0_IDR1          (AT91_CAST(AT91_REG *) 0xFFF7C068) // (TC0) Interrupt Disable Register (channel = 1)
#define AT91C_TC0_IMR1          (AT91_CAST(AT91_REG *) 0xFFF7C06C) // (TC0) Interrupt Mask Register (channel = 1)
#define AT91C_TC0_CCR2          (AT91_CAST(AT91_REG *) 0xFFF7C080) // (TC0) Channel Control Register (channel = 2)
#define AT91C_TC0_CMR2          (AT91_CAST(AT91_REG *) 0xFFF7C084) // (TC0) Channel Mode Register (channel = 2)
#define AT91C_TC0_CV2           (AT91_CAST(AT91_REG *) 0xFFF7C090) // (TC0) Counter Value (channel = 2)
#define AT91C_TC0_RA2           (AT91_CAST(AT91_REG *) 0xFFF7C094) // (TC0) Register A (channel = 2)
#define AT91C_TC0_RB2           (AT91_CAST(AT91_REG *) 0xFFF7C098) // (TC0) Register B (channel = 2)
#define AT91C_TC0_RC2           (AT91_CAST(AT91_REG *) 0xFFF7C09C) // (TC0) Register C (channel = 2)
#define AT91C_TC0_SR2           (AT91_CAST(AT91_REG *) 0xFFF7C0A0) // (TC0) Status Register (channel = 2)
#define AT91C_TC0_IER2          (AT91_CAST(AT91_REG *) 0xFFF7C0A4) // (TC0) Interrupt Enable Register (channel = 2)
#define AT91C_TC0_IDR2          (AT91_CAST(AT91_REG *) 0xFFF7C0A8) // (TC0) Interrupt Disable Register (channel = 2)
#define AT91C_TC0_IMR2          (AT91_CAST(AT91_REG *) 0xFFF7C0AC) // (TC0) Interrupt Mask Register (channel = 2)
#define AT91C_TC0_BCR           (AT91_CAST(AT91_REG *) 0xFFF7C0C0) // (TC0) Block Control Register
#define AT91C_TC0_BMR           (AT91_CAST(AT91_REG *) 0xFFF7C0C4) // (TC0) Block Mode Register
// ========== Register definition for MCI0 peripheral ==========
#define AT91C_MCI0_CR           (AT91_CAST(AT91_REG *) 0xFFF80000) // (MCI0) Control Register
#define AT91C_MCI0_MR           (AT91_CAST(AT91_REG *) 0xFFF80004) // (MCI0) Mode Register
#define AT91C_MCI0_DTOR         (AT91_CAST(AT91_REG *) 0xFFF80008) // (MCI0) Data Timeout Register
#define AT91C_MCI0_SDCR         (AT91_CAST(AT91_REG *) 0xFFF8000C) // (MCI0) SD/SDIO Card Register
#define AT91C_MCI0_ARGR         (AT91_CAST(AT91_REG *) 0xFFF80010) // (MCI0) Argument Register
#define AT91C_MCI0_CMDR         (AT91_CAST(AT91_REG *) 0xFFF80014) // (MCI0) Command Register
#define AT91C_MCI0_BLKR         (AT91_CAST(AT91_REG *) 0xFFF80018) // (MCI0) Block Register
#define AT91C_MCI0_CSTOR        (AT91_CAST(AT91_REG *) 0xFFF8001C) // (MCI0) Completion Signal Timeout Register
#define AT91C_MCI0_RSPR         (AT91_CAST(AT91_REG *) 0xFFF80020) // (MCI0) Response Register
#define AT91C_MCI0_RDR          (AT91_CAST(AT91_REG *) 0xFFF80030) // (MCI0) Receive Data Register
#define AT91C_MCI0_TDR          (AT91_CAST(AT91_REG *) 0xFFF80034) // (MCI0) Transmit Data Register
#define AT91C_MCI0_SR           (AT91_CAST(AT91_REG *) 0xFFF80040) // (MCI0) Status Register
#define AT91C_MCI0_IER          (AT91_CAST(AT91_REG *) 0xFFF80044) // (MCI0) Interrupt Enable Register
#define AT91C_MCI0_IDR          (AT91_CAST(AT91_REG *) 0xFFF80048) // (MCI0) Interrupt Disable Register
#define AT91C_MCI0_IMR          (AT91_CAST(AT91_REG *) 0xFFF8004C) // (MCI0) Interrupt Mask Register
#define AT91C_MCI0_DMA          (AT91_CAST(AT91_REG *) 0xFFF80050) // (MCI0) DMA Configuration Register
#define AT91C_MCI0_CFG          (AT91_CAST(AT91_REG *) 0xFFF80054) // (MCI0) Configuration Register
#define AT91C_MCI0_WPMR         (AT91_CAST(AT91_REG *) 0xFFF800E4) // (MCI0) Write Protection Mode Register
#define AT91C_MCI0_WPSR         (AT91_CAST(AT91_REG *) 0xFFF800E8) // (MCI0) Write Protection Status Register
#define AT91C_MCI0_FIFO         (AT91_CAST(AT91_REG *) 0xFFF80200) // (MCI0) FIFO Memory Aperture
// ========== Register definition for TWI0 peripheral ==========
#define AT91C_TWI0_CR           (AT91_CAST(AT91_REG *) 0xFFF84000) // (TWI0) Control Register
#define AT91C_TWI0_MMR          (AT91_CAST(AT91_REG *) 0xFFF84004) // (TWI0) Master Mode Register
#define AT91C_TWI0_SMR          (AT91_CAST(AT91_REG *) 0xFFF84008) // (TWI0) Slave Mode Register
#define AT91C_TWI0_IADR         (AT91_CAST(AT91_REG *) 0xFFF8400C) // (TWI0) Internal Address Register
#define AT91C_TWI0_CWGR         (AT91_CAST(AT91_REG *) 0xFFF84010) // (TWI0) Clock Waveform Generator Register
#define AT91C_TWI0_SR           (AT91_CAST(AT91_REG *) 0xFFF84020) // (TWI0) Status Register
#define AT91C_TWI0_IER          (AT91_CAST(AT91_REG *) 0xFFF84024) // (TWI0) Interrupt Enable Register
#define AT91C_TWI0_IDR          (AT91_CAST(AT91_REG *) 0xFFF84028) // (TWI0) Interrupt Disable Register
#define AT91C_TWI0_IMR          (AT91_CAST(AT91_REG *) 0xFFF8402C) // (TWI0) Interrupt Mask Register
#define AT91C_TWI0_RHR          (AT91_CAST(AT91_REG *) 0xFFF84030) // (TWI0) Receive Holding Register
#define AT91C_TWI0_THR          (AT91_CAST(AT91_REG *) 0xFFF84034) // (TWI0) Transmit Holding Register
// ========== Register definition for TWI1 peripheral ==========
#define AT91C_TWI1_CR           (AT91_CAST(AT91_REG *) 0xFFF88000) // (TWI1) Control Register
#define AT91C_TWI1_MMR          (AT91_CAST(AT91_REG *) 0xFFF88004) // (TWI1) Master Mode Register
#define AT91C_TWI1_SMR          (AT91_CAST(AT91_REG *) 0xFFF88008) // (TWI1) Slave Mode Register
#define AT91C_TWI1_IADR         (AT91_CAST(AT91_REG *) 0xFFF8800C) // (TWI1) Internal Address Register
#define AT91C_TWI1_CWGR         (AT91_CAST(AT91_REG *) 0xFFF88010) // (TWI1) Clock Waveform Generator Register
#define AT91C_TWI1_SR           (AT91_CAST(AT91_REG *) 0xFFF88020) // (TWI1) Status Register
#define AT91C_TWI1_IER          (AT91_CAST(AT91_REG *) 0xFFF88024) // (TWI1) Interrupt Enable Register
#define AT91C_TWI1_IDR          (AT91_CAST(AT91_REG *) 0xFFF88028) // (TWI1) Interrupt Disable Register
#define AT91C_TWI1_IMR          (AT91_CAST(AT91_REG *) 0xFFF8802C) // (TWI1) Interrupt Mask Register
#define AT91C_TWI1_RHR          (AT91_CAST(AT91_REG *) 0xFFF88030) // (TWI1) Receive Holding Register
#define AT91C_TWI1_THR          (AT91_CAST(AT91_REG *) 0xFFF88034) // (TWI1) Transmit Holding Register
// ========== Register definition for USART0 peripheral ==========
#define AT91C_USART0_CR         (AT91_CAST(AT91_REG *) 0xFFF8C000) // (USART0) Control Register
#define AT91C_USART0_MR         (AT91_CAST(AT91_REG *) 0xFFF8C004) // (USART0) Mode Register
#define AT91C_USART0_IER        (AT91_CAST(AT91_REG *) 0xFFF8C008) // (USART0) Interrupt Enable Register
#define AT91C_USART0_IDR        (AT91_CAST(AT91_REG *) 0xFFF8C00C) // (USART0) Interrupt Disable Register
#define AT91C_USART0_IMR        (AT91_CAST(AT91_REG *) 0xFFF8C010) // (USART0) Interrupt Mask Register
#define AT91C_USART0_CSR        (AT91_CAST(AT91_REG *) 0xFFF8C014) // (USART0) Channel Status Register
#define AT91C_USART0_RHR        (AT91_CAST(AT91_REG *) 0xFFF8C018) // (USART0) Receiver Holding Register
#define AT91C_USART0_THR        (AT91_CAST(AT91_REG *) 0xFFF8C01C) // (USART0) Transmitter Holding Register
#define AT91C_USART0_BRGR       (AT91_CAST(AT91_REG *) 0xFFF8C020) // (USART0) Baud Rate Generator Register
#define AT91C_USART0_RTOR       (AT91_CAST(AT91_REG *) 0xFFF8C024) // (USART0) Receiver Time-out Register
#define AT91C_USART0_TTGR       (AT91_CAST(AT91_REG *) 0xFFF8C028) // (USART0) Transmitter Timeguard Register
#define AT91C_USART0_FIDI       (AT91_CAST(AT91_REG *) 0xFFF8C040) // (USART0) FI DI Ratio Register
#define AT91C_USART0_NER        (AT91_CAST(AT91_REG *) 0xFFF8C044) // (USART0) Number of Errors Register
#define AT91C_USART0_IF         (AT91_CAST(AT91_REG *) 0xFFF8C04C) // (USART0) IrDA Filter Register
#define AT91C_USART0_RPR        (AT91_CAST(AT91_REG *) 0xFFF8C100) // (USART0) Receive Pointer Register
#define AT91C_USART0_RCR        (AT91_CAST(AT91_REG *) 0xFFF8C104) // (USART0) Receive Counter Register
#define AT91C_USART0_TPR        (AT91_CAST(AT91_REG *) 0xFFF8C108) // (USART0) Transmit Pointer Register
#define AT91C_USART0_TCR        (AT91_CAST(AT91_REG *) 0xFFF8C10C) // (USART0) Transmit Counter Register
#define AT91C_USART0_RNPR       (AT91_CAST(AT91_REG *) 0xFFF8C110) // (USART0) Receive Next Pointer Register
#define AT91C_USART0_RNCR       (AT91_CAST(AT91_REG *) 0xFFF8C114) // (USART0) Receive Next Counter Register
#define AT91C_USART0_TNPR       (AT91_CAST(AT91_REG *) 0xFFF8C118) // (USART0) Transmit Next Pointer Register
#define AT91C_USART0_TNCR       (AT91_CAST(AT91_REG *) 0xFFF8C11C) // (USART0) Transmit Next Counter Register
#define AT91C_USART0_PTCR       (AT91_CAST(AT91_REG *) 0xFFF8C120) // (USART0) Transfer Control Register
#define AT91C_USART0_PTSR       (AT91_CAST(AT91_REG *) 0xFFF8C124) // (USART0) Transfer Status Register
// ========== Register definition for USART1 peripheral ==========
#define AT91C_USART1_CR         (AT91_CAST(AT91_REG *) 0xFFF90000) // (USART1) Control Register
#define AT91C_USART1_MR         (AT91_CAST(AT91_REG *) 0xFFF90004) // (USART1) Mode Register
#define AT91C_USART1_IER        (AT91_CAST(AT91_REG *) 0xFFF90008) // (USART1) Interrupt Enable Register
#define AT91C_USART1_IDR        (AT91_CAST(AT91_REG *) 0xFFF9000C) // (USART1) Interrupt Disable Register
#define AT91C_USART1_IMR        (AT91_CAST(AT91_REG *) 0xFFF90010) // (USART1) Interrupt Mask Register
#define AT91C_USART1_CSR        (AT91_CAST(AT91_REG *) 0xFFF90014) // (USART1) Channel Status Register
#define AT91C_USART1_RHR        (AT91_CAST(AT91_REG *) 0xFFF90018) // (USART1) Receiver Holding Register
#define AT91C_USART1_THR        (AT91_CAST(AT91_REG *) 0xFFF9001C) // (USART1) Transmitter Holding Register
#define AT91C_USART1_BRGR       (AT91_CAST(AT91_REG *) 0xFFF90020) // (USART1) Baud Rate Generator Register
#define AT91C_USART1_RTOR       (AT91_CAST(AT91_REG *) 0xFFF90024) // (USART1) Receiver Time-out Register
#define AT91C_USART1_TTGR       (AT91_CAST(AT91_REG *) 0xFFF90028) // (USART1) Transmitter Timeguard Register
#define AT91C_USART1_FIDI       (AT91_CAST(AT91_REG *) 0xFFF90040) // (USART1) FI DI Ratio Register
#define AT91C_USART1_NER        (AT91_CAST(AT91_REG *) 0xFFF90044) // (USART1) Number of Errors Register
#define AT91C_USART1_IF         (AT91_CAST(AT91_REG *) 0xFFF9004C) // (USART1) IrDA Filter Register
#define AT91C_USART1_RPR        (AT91_CAST(AT91_REG *) 0xFFF90100) // (USART1) Receive Pointer Register
#define AT91C_USART1_RCR        (AT91_CAST(AT91_REG *) 0xFFF90104) // (USART1) Receive Counter Register
#define AT91C_USART1_TPR        (AT91_CAST(AT91_REG *) 0xFFF90108) // (USART1) Transmit Pointer Register
#define AT91C_USART1_TCR        (AT91_CAST(AT91_REG *) 0xFFF9010C) // (USART1) Transmit Counter Register
#define AT91C_USART1_RNPR       (AT91_CAST(AT91_REG *) 0xFFF90110) // (USART1) Receive Next Pointer Register
#define AT91C_USART1_RNCR       (AT91_CAST(AT91_REG *) 0xFFF90114) // (USART1) Receive Next Counter Register
#define AT91C_USART1_TNPR       (AT91_CAST(AT91_REG *) 0xFFF90118) // (USART1) Transmit Next Pointer Register
#define AT91C_USART1_TNCR       (AT91_CAST(AT91_REG *) 0xFFF9011C) // (USART1) Transmit Next Counter Register
#define AT91C_USART1_PTCR       (AT91_CAST(AT91_REG *) 0xFFF90120) // (USART1) Transfer Control Register
#define AT91C_USART1_PTSR       (AT91_CAST(AT91_REG *) 0xFFF90124) // (USART1) Transfer Status Register
// ========== Register definition for USART2 peripheral ==========
#define AT91C_USART2_CR         (AT91_CAST(AT91_REG *) 0xFFF94000) // (USART2) Control Register
#define AT91C_USART2_MR         (AT91_CAST(AT91_REG *) 0xFFF94004) // (USART2) Mode Register
#define AT91C_USART2_IER        (AT91_CAST(AT91_REG *) 0xFFF94008) // (USART2) Interrupt Enable Register
#define AT91C_USART2_IDR        (AT91_CAST(AT91_REG *) 0xFFF9400C) // (USART2) Interrupt Disable Register
#define AT91C_USART2_IMR        (AT91_CAST(AT91_REG *) 0xFFF94010) // (USART2) Interrupt Mask Register
#define AT91C_USART2_CSR        (AT91_CAST(AT91_REG *) 0xFFF94014) // (USART2) Channel Status Register
#define AT91C_USART2_RHR        (AT91_CAST(AT91_REG *) 0xFFF94018) // (USART2) Receiver Holding Register
#define AT91C_USART2_THR        (AT91_CAST(AT91_REG *) 0xFFF9401C) // (USART2) Transmitter Holding Register
#define AT91C_USART2_BRGR       (AT91_CAST(AT91_REG *) 0xFFF94020) // (USART2) Baud Rate Generator Register
#define AT91C_USART2_RTOR       (AT91_CAST(AT91_REG *) 0xFFF94024) // (USART2) Receiver Time-out Register
#define AT91C_USART2_TTGR       (AT91_CAST(AT91_REG *) 0xFFF94028) // (USART2) Transmitter Timeguard Register
#define AT91C_USART2_FIDI       (AT91_CAST(AT91_REG *) 0xFFF94040) // (USART2) FI DI Ratio Register
#define AT91C_USART2_NER        (AT91_CAST(AT91_REG *) 0xFFF94044) // (USART2) Number of Errors Register
#define AT91C_USART2_IF         (AT91_CAST(AT91_REG *) 0xFFF9404C) // (USART2) IrDA Filter Register
#define AT91C_USART2_RPR        (AT91_CAST(AT91_REG *) 0xFFF94100) // (USART2) Receive Pointer Register
#define AT91C_USART2_RCR        (AT91_CAST(AT91_REG *) 0xFFF94104) // (USART2) Receive Counter Register
#define AT91C_USART2_TPR        (AT91_CAST(AT91_REG *) 0xFFF94108) // (USART2) Transmit Pointer Register
#define AT91C_USART2_TCR        (AT91_CAST(AT91_REG *) 0xFFF9410C) // (USART2) Transmit Counter Register
#define AT91C_USART2_RNPR       (AT91_CAST(AT91_REG *) 0xFFF94110) // (USART2) Receive Next Pointer Register
#define AT91C_USART2_RNCR       (AT91_CAST(AT91_REG *) 0xFFF94114) // (USART2) Receive Next Counter Register
#define AT91C_USART2_TNPR       (AT91_CAST(AT91_REG *) 0xFFF94118) // (USART2) Transmit Next Pointer Register
#define AT91C_USART2_TNCR       (AT91_CAST(AT91_REG *) 0xFFF9411C) // (USART2) Transmit Next Counter Register
#define AT91C_USART2_PTCR       (AT91_CAST(AT91_REG *) 0xFFF94120) // (USART2) Transfer Control Register
#define AT91C_USART2_PTSR       (AT91_CAST(AT91_REG *) 0xFFF94124) // (USART2) Transfer Status Register
// ========== Register definition for USART3 peripheral ==========
#define AT91C_USART3_CR         (AT91_CAST(AT91_REG *) 0xFFF98000) // (USART3) Control Register
#define AT91C_USART3_MR         (AT91_CAST(AT91_REG *) 0xFFF98004) // (USART3) Mode Register
#define AT91C_USART3_IER        (AT91_CAST(AT91_REG *) 0xFFF98008) // (USART3) Interrupt Enable Register
#define AT91C_USART3_IDR        (AT91_CAST(AT91_REG *) 0xFFF9800C) // (USART3) Interrupt Disable Register
#define AT91C_USART3_IMR        (AT91_CAST(AT91_REG *) 0xFFF98010) // (USART3) Interrupt Mask Register
#define AT91C_USART3_CSR        (AT91_CAST(AT91_REG *) 0xFFF98014) // (USART3) Channel Status Register
#define AT91C_USART3_RHR        (AT91_CAST(AT91_REG *) 0xFFF98018) // (USART3) Receiver Holding Register
#define AT91C_USART3_THR        (AT91_CAST(AT91_REG *) 0xFFF9801C) // (USART3) Transmitter Holding Register
#define AT91C_USART3_BRGR       (AT91_CAST(AT91_REG *) 0xFFF98020) // (USART3) Baud Rate Generator Register
#define AT91C_USART3_RTOR       (AT91_CAST(AT91_REG *) 0xFFF98024) // (USART3) Receiver Time-out Register
#define AT91C_USART3_TTGR       (AT91_CAST(AT91_REG *) 0xFFF98028) // (USART3) Transmitter Timeguard Register
#define AT91C_USART3_FIDI       (AT91_CAST(AT91_REG *) 0xFFF98040) // (USART3) FI DI Ratio Register
#define AT91C_USART3_NER        (AT91_CAST(AT91_REG *) 0xFFF98044) // (USART3) Number of Errors Register
#define AT91C_USART3_IF         (AT91_CAST(AT91_REG *) 0xFFF9804C) // (USART3) IrDA Filter Register
#define AT91C_USART3_RPR        (AT91_CAST(AT91_REG *) 0xFFF98100) // (USART3) Receive Pointer Register
#define AT91C_USART3_RCR        (AT91_CAST(AT91_REG *) 0xFFF98104) // (USART3) Receive Counter Register
#define AT91C_USART3_TPR        (AT91_CAST(AT91_REG *) 0xFFF98108) // (USART3) Transmit Pointer Register
#define AT91C_USART3_TCR        (AT91_CAST(AT91_REG *) 0xFFF9810C) // (USART3) Transmit Counter Register
#define AT91C_USART3_RNPR       (AT91_CAST(AT91_REG *) 0xFFF98110) // (USART3) Receive Next Pointer Register
#define AT91C_USART3_RNCR       (AT91_CAST(AT91_REG *) 0xFFF98114) // (USART3) Receive Next Counter Register
#define AT91C_USART3_TNPR       (AT91_CAST(AT91_REG *) 0xFFF98118) // (USART3) Transmit Next Pointer Register
#define AT91C_USART3_TNCR       (AT91_CAST(AT91_REG *) 0xFFF9811C) // (USART3) Transmit Next Counter Register
#define AT91C_USART3_PTCR       (AT91_CAST(AT91_REG *) 0xFFF98120) // (USART3) Transfer Control Register
#define AT91C_USART3_PTSR       (AT91_CAST(AT91_REG *) 0xFFF98124) // (USART3) Transfer Status Register
// ========== Register definition for SSC0 peripheral ==========
#define AT91C_SSC0_CR           (AT91_CAST(AT91_REG *) 0xFFF9C000) // (SSC0) Control Register
#define AT91C_SSC0_CMR          (AT91_CAST(AT91_REG *) 0xFFF9C004) // (SSC0) Clock Mode Register
#define AT91C_SSC0_RCMR         (AT91_CAST(AT91_REG *) 0xFFF9C010) // (SSC0) Receive Clock Mode Register
#define AT91C_SSC0_RFMR         (AT91_CAST(AT91_REG *) 0xFFF9C014) // (SSC0) Receive Frame Mode Register
#define AT91C_SSC0_TCMR         (AT91_CAST(AT91_REG *) 0xFFF9C018) // (SSC0) Transmit Clock Mode Register
#define AT91C_SSC0_TFMR         (AT91_CAST(AT91_REG *) 0xFFF9C01C) // (SSC0) Transmit Frame Mode Register
#define AT91C_SSC0_RHR          (AT91_CAST(AT91_REG *) 0xFFF9C020) // (SSC0) Receive Holding Register
#define AT91C_SSC0_THR          (AT91_CAST(AT91_REG *) 0xFFF9C024) // (SSC0) Transmit Holding Register
#define AT91C_SSC0_RSHR         (AT91_CAST(AT91_REG *) 0xFFF9C030) // (SSC0) Receive Sync. Holding Register
#define AT91C_SSC0_TSHR         (AT91_CAST(AT91_REG *) 0xFFF9C034) // (SSC0) Transmit Sync. Holding Register
#define AT91C_SSC0_RC0R         (AT91_CAST(AT91_REG *) 0xFFF9C038) // (SSC0) Receive Compare 0 Register
#define AT91C_SSC0_RC1R         (AT91_CAST(AT91_REG *) 0xFFF9C03C) // (SSC0) Receive Compare 1 Register
#define AT91C_SSC0_SR           (AT91_CAST(AT91_REG *) 0xFFF9C040) // (SSC0) Status Register
#define AT91C_SSC0_IER          (AT91_CAST(AT91_REG *) 0xFFF9C044) // (SSC0) Interrupt Enable Register
#define AT91C_SSC0_IDR          (AT91_CAST(AT91_REG *) 0xFFF9C048) // (SSC0) Interrupt Disable Register
#define AT91C_SSC0_IMR          (AT91_CAST(AT91_REG *) 0xFFF9C04C) // (SSC0) Interrupt Mask Register
#define AT91C_SSC0_RPR          (AT91_CAST(AT91_REG *) 0xFFF9C100) // (SSC0) Receive Pointer Register
#define AT91C_SSC0_RCR          (AT91_CAST(AT91_REG *) 0xFFF9C104) // (SSC0) Receive Counter Register
#define AT91C_SSC0_TPR          (AT91_CAST(AT91_REG *) 0xFFF9C108) // (SSC0) Transmit Pointer Register
#define AT91C_SSC0_TCR          (AT91_CAST(AT91_REG *) 0xFFF9C10C) // (SSC0) Transmit Counter Register
#define AT91C_SSC0_RNPR         (AT91_CAST(AT91_REG *) 0xFFF9C110) // (SSC0) Receive Next Pointer Register
#define AT91C_SSC0_RNCR         (AT91_CAST(AT91_REG *) 0xFFF9C114) // (SSC0) Receive Next Counter Register
#define AT91C_SSC0_TNPR         (AT91_CAST(AT91_REG *) 0xFFF9C118) // (SSC0) Transmit Next Pointer Register
#define AT91C_SSC0_TNCR         (AT91_CAST(AT91_REG *) 0xFFF9C11C) // (SSC0) Transmit Next Counter Register
#define AT91C_SSC0_PTCR         (AT91_CAST(AT91_REG *) 0xFFF9C120) // (SSC0) Transfer Control Register
#define AT91C_SSC0_PTSR         (AT91_CAST(AT91_REG *) 0xFFF9C124) // (SSC0) Transfer Status Register
// ========== Register definition for SSC1 peripheral ==========
#define AT91C_SSC1_CR           (AT91_CAST(AT91_REG *) 0xFFFA0000) // (SSC1) Control Register
#define AT91C_SSC1_CMR          (AT91_CAST(AT91_REG *) 0xFFFA0004) // (SSC1) Clock Mode Register
#define AT91C_SSC1_RCMR         (AT91_CAST(AT91_REG *) 0xFFFA0010) // (SSC1) Receive Clock Mode Register
#define AT91C_SSC1_RFMR         (AT91_CAST(AT91_REG *) 0xFFFA0014) // (SSC1) Receive Frame Mode Register
#define AT91C_SSC1_TCMR         (AT91_CAST(AT91_REG *) 0xFFFA0018) // (SSC1) Transmit Clock Mode Register
#define AT91C_SSC1_TFMR         (AT91_CAST(AT91_REG *) 0xFFFA001C) // (SSC1) Transmit Frame Mode Register
#define AT91C_SSC1_RHR          (AT91_CAST(AT91_REG *) 0xFFFA0020) // (SSC1) Receive Holding Register
#define AT91C_SSC1_THR          (AT91_CAST(AT91_REG *) 0xFFFA0024) // (SSC1) Transmit Holding Register
#define AT91C_SSC1_RSHR         (AT91_CAST(AT91_REG *) 0xFFFA0030) // (SSC1) Receive Sync. Holding Register
#define AT91C_SSC1_TSHR         (AT91_CAST(AT91_REG *) 0xFFFA0034) // (SSC1) Transmit Sync. Holding Register
#define AT91C_SSC1_RC0R         (AT91_CAST(AT91_REG *) 0xFFFA0038) // (SSC1) Receive Compare 0 Register
#define AT91C_SSC1_RC1R         (AT91_CAST(AT91_REG *) 0xFFFA003C) // (SSC1) Receive Compare 1 Register
#define AT91C_SSC1_SR           (AT91_CAST(AT91_REG *) 0xFFFA0040) // (SSC1) Status Register
#define AT91C_SSC1_IER          (AT91_CAST(AT91_REG *) 0xFFFA0044) // (SSC1) Interrupt Enable Register
#define AT91C_SSC1_IDR          (AT91_CAST(AT91_REG *) 0xFFFA0048) // (SSC1) Interrupt Disable Register
#define AT91C_SSC1_IMR          (AT91_CAST(AT91_REG *) 0xFFFA004C) // (SSC1) Interrupt Mask Register
#define AT91C_SSC1_RPR          (AT91_CAST(AT91_REG *) 0xFFFA0100) // (SSC1) Receive Pointer Register
#define AT91C_SSC1_RCR          (AT91_CAST(AT91_REG *) 0xFFFA0104) // (SSC1) Receive Counter Register
#define AT91C_SSC1_TPR          (AT91_CAST(AT91_REG *) 0xFFFA0108) // (SSC1) Transmit Pointer Register
#define AT91C_SSC1_TCR          (AT91_CAST(AT91_REG *) 0xFFFA010C) // (SSC1) Transmit Counter Register
#define AT91C_SSC1_RNPR         (AT91_CAST(AT91_REG *) 0xFFFA0110) // (SSC1) Receive Next Pointer Register
#define AT91C_SSC1_RNCR         (AT91_CAST(AT91_REG *) 0xFFFA0114) // (SSC1) Receive Next Counter Register
#define AT91C_SSC1_TNPR         (AT91_CAST(AT91_REG *) 0xFFFA0118) // (SSC1) Transmit Next Pointer Register
#define AT91C_SSC1_TNCR         (AT91_CAST(AT91_REG *) 0xFFFA011C) // (SSC1) Transmit Next Counter Register
#define AT91C_SSC1_PTCR         (AT91_CAST(AT91_REG *) 0xFFFA0120) // (SSC1) Transfer Control Register
#define AT91C_SSC1_PTSR         (AT91_CAST(AT91_REG *) 0xFFFA0124) // (SSC1) Transfer Status Register
// ========== Register definition for SPI0 peripheral ==========
#define AT91C_SPI0_CR           (AT91_CAST(AT91_REG *) 0xFFFA4000) // (SPI0) Control Register
#define AT91C_SPI0_MR           (AT91_CAST(AT91_REG *) 0xFFFA4004) // (SPI0) Mode Register
#define AT91C_SPI0_RDR          (AT91_CAST(AT91_REG *) 0xFFFA4008) // (SPI0) Receive Data Register
#define AT91C_SPI0_TDR          (AT91_CAST(AT91_REG *) 0xFFFA400C) // (SPI0) Transmit Data Register
#define AT91C_SPI0_SR           (AT91_CAST(AT91_REG *) 0xFFFA4010) // (SPI0) Status Register
#define AT91C_SPI0_IER          (AT91_CAST(AT91_REG *) 0xFFFA4014) // (SPI0) Interrupt Enable Register
#define AT91C_SPI0_IDR          (AT91_CAST(AT91_REG *) 0xFFFA4018) // (SPI0) Interrupt Disable Register
#define AT91C_SPI0_IMR          (AT91_CAST(AT91_REG *) 0xFFFA401C) // (SPI0) Interrupt Mask Register
#define AT91C_SPI0_CSR          (AT91_CAST(AT91_REG *) 0xFFFA4030) // (SPI0) Chip Select Register
#define AT91C_SPI0_RPR          (AT91_CAST(AT91_REG *) 0xFFFA4100) // (SPI0) Receive Pointer Register
#define AT91C_SPI0_RCR          (AT91_CAST(AT91_REG *) 0xFFFA4104) // (SPI0) Receive Counter Register
#define AT91C_SPI0_TPR          (AT91_CAST(AT91_REG *) 0xFFFA4108) // (SPI0) Transmit Pointer Register
#define AT91C_SPI0_TCR          (AT91_CAST(AT91_REG *) 0xFFFA410C) // (SPI0) Transmit Counter Register
#define AT91C_SPI0_RNPR         (AT91_CAST(AT91_REG *) 0xFFFA4110) // (SPI0) Receive Next Pointer Register
#define AT91C_SPI0_RNCR         (AT91_CAST(AT91_REG *) 0xFFFA4114) // (SPI0) Receive Next Counter Register
#define AT91C_SPI0_TNPR         (AT91_CAST(AT91_REG *) 0xFFFA4118) // (SPI0) Transmit Next Pointer Register
#define AT91C_SPI0_TNCR         (AT91_CAST(AT91_REG *) 0xFFFA411C) // (SPI0) Transmit Next Counter Register
#define AT91C_SPI0_PTCR         (AT91_CAST(AT91_REG *) 0xFFFA4120) // (SPI0) Transfer Control Register
#define AT91C_SPI0_PTSR         (AT91_CAST(AT91_REG *) 0xFFFA4124) // (SPI0) Transfer Status Register
// ========== Register definition for SPI1 peripheral ==========
#define AT91C_SPI1_CR           (AT91_CAST(AT91_REG *) 0xFFFA8000) // (SPI1) Control Register
#define AT91C_SPI1_MR           (AT91_CAST(AT91_REG *) 0xFFFA8004) // (SPI1) Mode Register
#define AT91C_SPI1_RDR          (AT91_CAST(AT91_REG *) 0xFFFA8008) // (SPI1) Receive Data Register
#define AT91C_SPI1_TDR          (AT91_CAST(AT91_REG *) 0xFFFA800C) // (SPI1) Transmit Data Register
#define AT91C_SPI1_SR           (AT91_CAST(AT91_REG *) 0xFFFA8010) // (SPI1) Status Register
#define AT91C_SPI1_IER          (AT91_CAST(AT91_REG *) 0xFFFA8014) // (SPI1) Interrupt Enable Register
#define AT91C_SPI1_IDR          (AT91_CAST(AT91_REG *) 0xFFFA8018) // (SPI1) Interrupt Disable Register
#define AT91C_SPI1_IMR          (AT91_CAST(AT91_REG *) 0xFFFA801C) // (SPI1) Interrupt Mask Register
#define AT91C_SPI1_CSR          (AT91_CAST(AT91_REG *) 0xFFFA8030) // (SPI1) Chip Select Register
#define AT91C_SPI1_RPR          (AT91_CAST(AT91_REG *) 0xFFFA8100) // (SPI1) Receive Pointer Register
#define AT91C_SPI1_RCR          (AT91_CAST(AT91_REG *) 0xFFFA8104) // (SPI1) Receive Counter Register
#define AT91C_SPI1_TPR          (AT91_CAST(AT91_REG *) 0xFFFA8108) // (SPI1) Transmit Pointer Register
#define AT91C_SPI1_TCR          (AT91_CAST(AT91_REG *) 0xFFFA810C) // (SPI1) Transmit Counter Register
#define AT91C_SPI1_RNPR         (AT91_CAST(AT91_REG *) 0xFFFA8110) // (SPI1) Receive Next Pointer Register
#define AT91C_SPI1_RNCR         (AT91_CAST(AT91_REG *) 0xFFFA8114) // (SPI1) Receive Next Counter Register
#define AT91C_SPI1_TNPR         (AT91_CAST(AT91_REG *) 0xFFFA8118) // (SPI1) Transmit Next Pointer Register
#define AT91C_SPI1_TNCR         (AT91_CAST(AT91_REG *) 0xFFFA811C) // (SPI1) Transmit Next Counter Register
#define AT91C_SPI1_PTCR         (AT91_CAST(AT91_REG *) 0xFFFA8120) // (SPI1) Transfer Control Register
#define AT91C_SPI1_PTSR         (AT91_CAST(AT91_REG *) 0xFFFA8124) // (SPI1) Transfer Status Register
// ========== Register definition for AC97C peripheral ==========
#define AT91C_AC97C_MR          (AT91_CAST(AT91_REG *) 0xFFFAC008) // (AC97C) Mode Register
#define AT91C_AC97C_ICA         (AT91_CAST(AT91_REG *) 0xFFFAC010) // (AC97C) Input Channel Assignment Register
#define AT91C_AC97C_OCA         (AT91_CAST(AT91_REG *) 0xFFFAC014) // (AC97C) Output Channel Assignment Register
#define AT91C_AC97C_CARHR       (AT91_CAST(AT91_REG *) 0xFFFAC020) // (AC97C) Channel A Receive Holding Register
#define AT91C_AC97C_CATHR       (AT91_CAST(AT91_REG *) 0xFFFAC024) // (AC97C) Channel A Transmit Holding Register
#define AT91C_AC97C_CASR        (AT91_CAST(AT91_REG *) 0xFFFAC028) // (AC97C) Channel A Status Register
#define AT91C_AC97C_CAMR        (AT91_CAST(AT91_REG *) 0xFFFAC02C) // (AC97C) Channel A Mode Register
#define AT91C_AC97C_CBRHR       (AT91_CAST(AT91_REG *) 0xFFFAC030) // (AC97C) Channel B Receive Holding Register
#define AT91C_AC97C_CBTHR       (AT91_CAST(AT91_REG *) 0xFFFAC034) // (AC97C) Channel B Transmit Holding Register
#define AT91C_AC97C_CBSR        (AT91_CAST(AT91_REG *) 0xFFFAC038) // (AC97C) Channel B Status Register
#define AT91C_AC97C_CBMR        (AT91_CAST(AT91_REG *) 0xFFFAC03C) // (AC97C) Channel B Mode Register
#define AT91C_AC97C_CORHR       (AT91_CAST(AT91_REG *) 0xFFFAC040) // (AC97C) Codec Channel Receive Holding Register
#define AT91C_AC97C_COTHR       (AT91_CAST(AT91_REG *) 0xFFFAC044) // (AC97C) Codec Channel Transmit Holding Register
#define AT91C_AC97C_COSR        (AT91_CAST(AT91_REG *) 0xFFFAC048) // (AC97C) Codec Status Register
#define AT91C_AC97C_COMR        (AT91_CAST(AT91_REG *) 0xFFFAC04C) // (AC97C) Codec Mode Register
#define AT91C_AC97C_SR          (AT91_CAST(AT91_REG *) 0xFFFAC050) // (AC97C) Status Register
#define AT91C_AC97C_IER         (AT91_CAST(AT91_REG *) 0xFFFAC054) // (AC97C) Interrupt Enable Register
#define AT91C_AC97C_IDR         (AT91_CAST(AT91_REG *) 0xFFFAC058) // (AC97C) Interrupt Disable Register
#define AT91C_AC97C_IMR         (AT91_CAST(AT91_REG *) 0xFFFAC05C) // (AC97C) Interrupt Mask Register
#define AT91C_AC97C_RPR         (AT91_CAST(AT91_REG *) 0xFFFAC100) // (AC97C) Receive Pointer Register
#define AT91C_AC97C_RCR         (AT91_CAST(AT91_REG *) 0xFFFAC104) // (AC97C) Receive Counter Register
#define AT91C_AC97C_TPR         (AT91_CAST(AT91_REG *) 0xFFFAC108) // (AC97C) Transmit Pointer Register
#define AT91C_AC97C_TCR         (AT91_CAST(AT91_REG *) 0xFFFAC10C) // (AC97C) Transmit Counter Register
#define AT91C_AC97C_RNPR        (AT91_CAST(AT91_REG *) 0xFFFAC110) // (AC97C) Receive Next Pointer Register
#define AT91C_AC97C_RNCR        (AT91_CAST(AT91_REG *) 0xFFFAC114) // (AC97C) Receive Next Counter Register
#define AT91C_AC97C_TNPR        (AT91_CAST(AT91_REG *) 0xFFFAC118) // (AC97C) Transmit Next Pointer Register
#define AT91C_AC97C_TNCR        (AT91_CAST(AT91_REG *) 0xFFFAC11C) // (AC97C) Transmit Next Counter Register
#define AT91C_AC97C_PTCR        (AT91_CAST(AT91_REG *) 0xFFFAC120) // (AC97C) Transfer Control Register
#define AT91C_AC97C_PTSR        (AT91_CAST(AT91_REG *) 0xFFFAC124) // (AC97C) Transfer Status Register
// ========== Register definition for TSADCC peripheral ==========
#define AT91C_TSADCC_CR         (AT91_CAST(AT91_REG *) 0xFFFB0000) // (TSADCC) Control Register
#define AT91C_TSADCC_MR         (AT91_CAST(AT91_REG *) 0xFFFB0004) // (TSADCC) Mode Register
#define AT91C_TSADCC_TRGR       (AT91_CAST(AT91_REG *) 0xFFFB0008) // (TSADCC) Trigger Register
#define AT91C_TSADCC_TSR        (AT91_CAST(AT91_REG *) 0xFFFB000C) // (TSADCC) Touch Screen Register
#define AT91C_TSADCC_CHER       (AT91_CAST(AT91_REG *) 0xFFFB0010) // (TSADCC) Channel Enable Register
#define AT91C_TSADCC_CHDR       (AT91_CAST(AT91_REG *) 0xFFFB0014) // (TSADCC) Channel Disable Register
#define AT91C_TSADCC_CHSR       (AT91_CAST(AT91_REG *) 0xFFFB0018) // (TSADCC) Channel Status Register
#define AT91C_TSADCC_SR         (AT91_CAST(AT91_REG *) 0xFFFB001C) // (TSADCC) Status Register
#define AT91C_TSADCC_LCDR       (AT91_CAST(AT91_REG *) 0xFFFB0020) // (TSADCC) Last Converted Data Register
#define AT91C_TSADCC_IER        (AT91_CAST(AT91_REG *) 0xFFFB0024) // (TSADCC) Interrupt Enable Register
#define AT91C_TSADCC_IDR        (AT91_CAST(AT91_REG *) 0xFFFB0028) // (TSADCC) Interrupt Disable Register
#define AT91C_TSADCC_IMR        (AT91_CAST(AT91_REG *) 0xFFFB002C) // (TSADCC) Interrupt Mask Register
#define AT91C_TSADCC_CDR        (AT91_CAST(AT91_REG *) 0xFFFB0030) // (TSADCC) Channel Data Register
#define AT91C_TSADCC_RPR        (AT91_CAST(AT91_REG *) 0xFFFB0100) // (TSADCC) Receive Pointer Register
#define AT91C_TSADCC_RCR        (AT91_CAST(AT91_REG *) 0xFFFB0104) // (TSADCC) Receive Counter Register
#define AT91C_TSADCC_TPR        (AT91_CAST(AT91_REG *) 0xFFFB0108) // (TSADCC) Transmit Pointer Register
#define AT91C_TSADCC_TCR        (AT91_CAST(AT91_REG *) 0xFFFB010C) // (TSADCC) Transmit Counter Register
#define AT91C_TSADCC_RNPR       (AT91_CAST(AT91_REG *) 0xFFFB0110) // (TSADCC) Receive Next Pointer Register
#define AT91C_TSADCC_RNCR       (AT91_CAST(AT91_REG *) 0xFFFB0114) // (TSADCC) Receive Next Counter Register
#define AT91C_TSADCC_TNPR       (AT91_CAST(AT91_REG *) 0xFFFB0118) // (TSADCC) Transmit Next Pointer Register
#define AT91C_TSADCC_TNCR       (AT91_CAST(AT91_REG *) 0xFFFB011C) // (TSADCC) Transmit Next Counter Register
#define AT91C_TSADCC_PTCR       (AT91_CAST(AT91_REG *) 0xFFFB0120) // (TSADCC) Transfer Control Register
#define AT91C_TSADCC_PTSR       (AT91_CAST(AT91_REG *) 0xFFFB0124) // (TSADCC) Transfer Status Register
// ========== Register definition for ISI peripheral ==========
#define AT91C_ISI_CR1           (AT91_CAST(AT91_REG *) 0xFFFB4000) // (ISI) ISI Control 1 Register
#define AT91C_ISI_CR2           (AT91_CAST(AT91_REG *) 0xFFFB4004) // (ISI) ISI Control 2 Register
#define AT91C_ISI_SR            (AT91_CAST(AT91_REG *) 0xFFFB4008) // (ISI) ISI Status Register
#define AT91C_ISI_IER           (AT91_CAST(AT91_REG *) 0xFFFB400C) // (ISI) ISI Interrupt Enable Register
#define AT91C_ISI_IDR           (AT91_CAST(AT91_REG *) 0xFFFB4010) // (ISI) ISI Interrupt Disable Register
#define AT91C_ISI_IMR           (AT91_CAST(AT91_REG *) 0xFFFB4014) // (ISI) ISI Interrupt Mask Register
#define AT91C_ISI_PSIZE         (AT91_CAST(AT91_REG *) 0xFFFB4020) // (ISI) ISI Preview Size Register
#define AT91C_ISI_PDECF         (AT91_CAST(AT91_REG *) 0xFFFB4024) // (ISI) ISI Preview Decimation Factor Register
#define AT91C_ISI_PPFBD         (AT91_CAST(AT91_REG *) 0xFFFB4028) // (ISI) ISI Preview Primary FBD Register
#define AT91C_ISI_CDBA          (AT91_CAST(AT91_REG *) 0xFFFB402C) // (ISI) ISI Codec DMA Base Address Register
#define AT91C_ISI_Y2R_SET0      (AT91_CAST(AT91_REG *) 0xFFFB4030) // (ISI) ISI CSC YCrCb To RGB Set 0 Register
#define AT91C_ISI_Y2R_SET1      (AT91_CAST(AT91_REG *) 0xFFFB4034) // (ISI) ISI CSC YCrCb To RGB Set 1 Register
#define AT91C_ISI_R2Y_SET0      (AT91_CAST(AT91_REG *) 0xFFFB4038) // (ISI) ISI CSC RGB To YCrCb Set 0 Register
#define AT91C_ISI_R2Y_SET1      (AT91_CAST(AT91_REG *) 0xFFFB403C) // (ISI) ISI CSC RGB To YCrCb Set 1 Register
#define AT91C_ISI_R2Y_SET2      (AT91_CAST(AT91_REG *) 0xFFFB4040) // (ISI) ISI CSC RGB To YCrCb Set 2 Register
// ========== Register definition for PWM peripheral ==========
#define AT91C_PWM_MR            (AT91_CAST(AT91_REG *) 0xFFFB8000) // (PWM) PWM Mode Register
#define AT91C_PWM_ENA           (AT91_CAST(AT91_REG *) 0xFFFB8004) // (PWM) PWM Enable Register
#define AT91C_PWM_DIS           (AT91_CAST(AT91_REG *) 0xFFFB8008) // (PWM) PWM Disable Register
#define AT91C_PWM_SR            (AT91_CAST(AT91_REG *) 0xFFFB800C) // (PWM) PWM Status Register
#define AT91C_PWM_IER           (AT91_CAST(AT91_REG *) 0xFFFB8010) // (PWM) PWM Interrupt Enable Register
#define AT91C_PWM_IDR           (AT91_CAST(AT91_REG *) 0xFFFB8014) // (PWM) PWM Interrupt Disable Register
#define AT91C_PWM_IMR           (AT91_CAST(AT91_REG *) 0xFFFB8018) // (PWM) PWM Interrupt Mask Register
#define AT91C_PWM_ISR           (AT91_CAST(AT91_REG *) 0xFFFB801C) // (PWM) PWM Interrupt Status Register
#define AT91C_PWM_CMR0          (AT91_CAST(AT91_REG *) 0xFFFB8200) // (PWM) PWM Channel Mode Register (ch_num = 0)
#define AT91C_PWM_CDTY0         (AT91_CAST(AT91_REG *) 0xFFFB8204) // (PWM) PWM Channel Duty Cycle Register (ch_num = 0)
#define AT91C_PWM_CPRD0         (AT91_CAST(AT91_REG *) 0xFFFB8208) // (PWM) PWM Channel Period Register (ch_num = 0)
#define AT91C_PWM_CCNT0         (AT91_CAST(AT91_REG *) 0xFFFB820C) // (PWM) PWM Channel Counter Register (ch_num = 0)
#define AT91C_PWM_CUPD0         (AT91_CAST(AT91_REG *) 0xFFFB8210) // (PWM) PWM Channel Update Register (ch_num = 0)
#define AT91C_PWM_CMR1          (AT91_CAST(AT91_REG *) 0xFFFB8220) // (PWM) PWM Channel Mode Register (ch_num = 1)
#define AT91C_PWM_CDTY1         (AT91_CAST(AT91_REG *) 0xFFFB8224) // (PWM) PWM Channel Duty Cycle Register (ch_num = 1)
#define AT91C_PWM_CPRD1         (AT91_CAST(AT91_REG *) 0xFFFB8228) // (PWM) PWM Channel Period Register (ch_num = 1)
#define AT91C_PWM_CCNT1         (AT91_CAST(AT91_REG *) 0xFFFB822C) // (PWM) PWM Channel Counter Register (ch_num = 1)
#define AT91C_PWM_CUPD1         (AT91_CAST(AT91_REG *) 0xFFFB8230) // (PWM) PWM Channel Update Register (ch_num = 1)
#define AT91C_PWM_CMR2          (AT91_CAST(AT91_REG *) 0xFFFB8240) // (PWM) PWM Channel Mode Register (ch_num = 2)
#define AT91C_PWM_CDTY2         (AT91_CAST(AT91_REG *) 0xFFFB8244) // (PWM) PWM Channel Duty Cycle Register (ch_num = 2)
#define AT91C_PWM_CPRD2         (AT91_CAST(AT91_REG *) 0xFFFB8248) // (PWM) PWM Channel Period Register (ch_num = 2)
#define AT91C_PWM_CCNT2         (AT91_CAST(AT91_REG *) 0xFFFB824C) // (PWM) PWM Channel Counter Register (ch_num = 2)
#define AT91C_PWM_CUPD2         (AT91_CAST(AT91_REG *) 0xFFFB8250) // (PWM) PWM Channel Update Register (ch_num = 2)
#define AT91C_PWM_CMR3          (AT91_CAST(AT91_REG *) 0xFFFB8260) // (PWM) PWM Channel Mode Register (ch_num = 3)
#define AT91C_PWM_CDTY3         (AT91_CAST(AT91_REG *) 0xFFFB8264) // (PWM) PWM Channel Duty Cycle Register (ch_num = 3)
#define AT91C_PWM_CPRD3         (AT91_CAST(AT91_REG *) 0xFFFB8268) // (PWM) PWM Channel Period Register (ch_num = 3)
#define AT91C_PWM_CCNT3         (AT91_CAST(AT91_REG *) 0xFFFB826C) // (PWM) PWM Channel Counter Register (ch_num = 3)
#define AT91C_PWM_CUPD3         (AT91_CAST(AT91_REG *) 0xFFFB8270) // (PWM) PWM Channel Update Register (ch_num = 3)
// ========== Register definition for EMAC peripheral ==========
#define AT91C_EMAC_NCR          (AT91_CAST(AT91_REG *) 0xFFFBC000) // (EMAC) Network Control Register
#define AT91C_EMAC_NCFG         (AT91_CAST(AT91_REG *) 0xFFFBC004) // (EMAC) Network Configuration Register
#define AT91C_EMAC_NSR          (AT91_CAST(AT91_REG *) 0xFFFBC008) // (EMAC) Network Status Register
#define AT91C_EMAC_TSR          (AT91_CAST(AT91_REG *) 0xFFFBC014) // (EMAC) Transmit Status Register
#define AT91C_EMAC_RBQP         (AT91_CAST(AT91_REG *) 0xFFFBC018) // (EMAC) Receive Buffer Queue Pointer Register
#define AT91C_EMAC_TBQP         (AT91_CAST(AT91_REG *) 0xFFFBC01C) // (EMAC) Transmit Buffer Queue Pointer Register
#define AT91C_EMAC_RSR          (AT91_CAST(AT91_REG *) 0xFFFBC020) // (EMAC) Receive Status Register
#define AT91C_EMAC_ISR          (AT91_CAST(AT91_REG *) 0xFFFBC024) // (EMAC) Interrupt Status Register
#define AT91C_EMAC_IER          (AT91_CAST(AT91_REG *) 0xFFFBC028) // (EMAC) Interrupt Enable Register
#define AT91C_EMAC_IDR          (AT91_CAST(AT91_REG *) 0xFFFBC02C) // (EMAC) Interrupt Disable Register
#define AT91C_EMAC_IMR          (AT91_CAST(AT91_REG *) 0xFFFBC030) // (EMAC) Interrupt Mask Register
#define AT91C_EMAC_MAN          (AT91_CAST(AT91_REG *) 0xFFFBC034) // (EMAC) Phy Maintenance Register
#define AT91C_EMAC_PTR          (AT91_CAST(AT91_REG *) 0xFFFBC038) // (EMAC) Pause Time Register
#define AT91C_EMAC_PFR          (AT91_CAST(AT91_REG *) 0xFFFBC03C) // (EMAC) Pause Frames Received Register
#define AT91C_EMAC_FTO          (AT91_CAST(AT91_REG *) 0xFFFBC040) // (EMAC) Frames Transmitted Ok Register
#define AT91C_EMAC_SCF          (AT91_CAST(AT91_REG *) 0xFFFBC044) // (EMAC) Single Collision Frames Register
#define AT91C_EMAC_MCF          (AT91_CAST(AT91_REG *) 0xFFFBC048) // (EMAC) Multiple Collision Frames Register
#define AT91C_EMAC_FRO          (AT91_CAST(AT91_REG *) 0xFFFBC04C) // (EMAC) Frames Received Ok Register
#define AT91C_EMAC_FCSE         (AT91_CAST(AT91_REG *) 0xFFFBC050) // (EMAC) Frame Check Sequence Errors Register
#define AT91C_EMAC_ALE          (AT91_CAST(AT91_REG *) 0xFFFBC054) // (EMAC) Alignment Errors Register
#define AT91C_EMAC_DTF          (AT91_CAST(AT91_REG *) 0xFFFBC058) // (EMAC) Deferred Transmission Frames Register
#define AT91C_EMAC_LCOL         (AT91_CAST(AT91_REG *) 0xFFFBC05C) // (EMAC) Late Collisions Register
#define AT91C_EMAC_ECOL         (AT91_CAST(AT91_REG *) 0xFFFBC060) // (EMAC) Excessive Collisions Register
#define AT91C_EMAC_TUND         (AT91_CAST(AT91_REG *) 0xFFFBC064) // (EMAC) Transmit Underrun Errors Register
#define AT91C_EMAC_CSE          (AT91_CAST(AT91_REG *) 0xFFFBC068) // (EMAC) Carrier Sense Errors Register
#define AT91C_EMAC_RRE          (AT91_CAST(AT91_REG *) 0xFFFBC06C) // (EMAC) Receive Resource Errors Register
#define AT91C_EMAC_ROV          (AT91_CAST(AT91_REG *) 0xFFFBC070) // (EMAC) Receive Overrun Errors Register
#define AT91C_EMAC_RSE          (AT91_CAST(AT91_REG *) 0xFFFBC074) // (EMAC) Receive Symbol Errors Register
#define AT91C_EMAC_ELE          (AT91_CAST(AT91_REG *) 0xFFFBC078) // (EMAC) Excessive Length Errors Register
#define AT91C_EMAC_RJA          (AT91_CAST(AT91_REG *) 0xFFFBC07C) // (EMAC) Receive Jabbers Register
#define AT91C_EMAC_USF          (AT91_CAST(AT91_REG *) 0xFFFBC080) // (EMAC) Undersize Frames Register
#define AT91C_EMAC_STE          (AT91_CAST(AT91_REG *) 0xFFFBC084) // (EMAC) SQE Test Errors Register
#define AT91C_EMAC_RLE          (AT91_CAST(AT91_REG *) 0xFFFBC088) // (EMAC) Received Length Field Mismatch Register
#define AT91C_EMAC_HRB          (AT91_CAST(AT91_REG *) 0xFFFBC090) // (EMAC) Hash Register Bottom [31:0] Register
#define AT91C_EMAC_HRT          (AT91_CAST(AT91_REG *) 0xFFFBC094) // (EMAC) Hash Register Top [63:32] Register
#define AT91C_EMAC_SA1B         (AT91_CAST(AT91_REG *) 0xFFFBC098) // (EMAC) Specific Address 1 Bottom Register
#define AT91C_EMAC_SA1T         (AT91_CAST(AT91_REG *) 0xFFFBC09C) // (EMAC) Specific Address 1 Top Register
#define AT91C_EMAC_SA2B         (AT91_CAST(AT91_REG *) 0xFFFBC0A0) // (EMAC) Specific Address 2 Bottom Register
#define AT91C_EMAC_SA2T         (AT91_CAST(AT91_REG *) 0xFFFBC0A4) // (EMAC) Specific Address 2 Top Register
#define AT91C_EMAC_SA3B         (AT91_CAST(AT91_REG *) 0xFFFBC0A8) // (EMAC) Specific Address 3 Bottom Register
#define AT91C_EMAC_SA3T         (AT91_CAST(AT91_REG *) 0xFFFBC0AC) // (EMAC) Specific Address 3 Top Register
#define AT91C_EMAC_SA4B         (AT91_CAST(AT91_REG *) 0xFFFBC0B0) // (EMAC) Specific Address 4 Bottom Register
#define AT91C_EMAC_SA4T         (AT91_CAST(AT91_REG *) 0xFFFBC0B4) // (EMAC) Specific Address 4 Top Register
#define AT91C_EMAC_TID          (AT91_CAST(AT91_REG *) 0xFFFBC0B8) // (EMAC) Type ID Checking Register
#define AT91C_EMAC_USRIO        (AT91_CAST(AT91_REG *) 0xFFFBC0C0) // (EMAC) User Input/Output Register
// ========== Register definition for AES peripheral ==========
#define AT91C_AES_CR            (AT91_CAST(AT91_REG *) 0xFFFC0000) // (AES) Control Register
#define AT91C_AES_MR            (AT91_CAST(AT91_REG *) 0xFFFC0004) // (AES) Mode Register
#define AT91C_AES_IER           (AT91_CAST(AT91_REG *) 0xFFFC0010) // (AES) Interrupt Enable Register
#define AT91C_AES_IDR           (AT91_CAST(AT91_REG *) 0xFFFC0014) // (AES) Interrupt Disable Register
#define AT91C_AES_IMR           (AT91_CAST(AT91_REG *) 0xFFFC0018) // (AES) Interrupt Mask Register
#define AT91C_AES_ISR           (AT91_CAST(AT91_REG *) 0xFFFC001C) // (AES) Interrupt Status Register
#define AT91C_AES_KEYWR         (AT91_CAST(AT91_REG *) 0xFFFC0020) // (AES) Key Word Register
#define AT91C_AES_IDATAR        (AT91_CAST(AT91_REG *) 0xFFFC0040) // (AES) Input Data Register
#define AT91C_AES_ODATAR        (AT91_CAST(AT91_REG *) 0xFFFC0050) // (AES) Output Data Register
#define AT91C_AES_IVR           (AT91_CAST(AT91_REG *) 0xFFFC0060) // (AES) Initialization Vector Register
// ========== Register definition for TDES peripheral ==========
#define AT91C_TDES_CR           (AT91_CAST(AT91_REG *) 0xFFFC4000) // (TDES) Control Register
#define AT91C_TDES_MR           (AT91_CAST(AT91_REG *) 0xFFFC4004) // (TDES) Mode Register
#define AT91C_TDES_IER          (AT91_CAST(AT91_REG *) 0xFFFC4010) // (TDES) Interrupt Enable Register
#define AT91C_TDES_IDR          (AT91_CAST(AT91_REG *) 0xFFFC4014) // (TDES) Interrupt Disable Register
#define AT91C_TDES_IMR          (AT91_CAST(AT91_REG *) 0xFFFC4018) // (TDES) Interrupt Mask Register
#define AT91C_TDES_ISR          (AT91_CAST(AT91_REG *) 0xFFFC401C) // (TDES) Interrupt Status Register
#define AT91C_TDES_KEY1WR       (AT91_CAST(AT91_REG *) 0xFFFC4020) // (TDES) Key 1 Word Register
#define AT91C_TDES_KEY2WR       (AT91_CAST(AT91_REG *) 0xFFFC4028) // (TDES) Key 2 Word Register
#define AT91C_TDES_KEY3WR       (AT91_CAST(AT91_REG *) 0xFFFC4030) // (TDES) Key 3 Word Register
#define AT91C_TDES_IDATAR       (AT91_CAST(AT91_REG *) 0xFFFC4040) // (TDES) Input Data Register
#define AT91C_TDES_ODATAR       (AT91_CAST(AT91_REG *) 0xFFFC4050) // (TDES) Output Data Register
#define AT91C_TDES_IVR          (AT91_CAST(AT91_REG *) 0xFFFC4060) // (TDES) Initialization Vector Register
#define AT91C_TDES_RPR          (AT91_CAST(AT91_REG *) 0xFFFC4100) // (TDES) Receive Pointer Register
#define AT91C_TDES_RCR          (AT91_CAST(AT91_REG *) 0xFFFC4104) // (TDES) Receive Counter Register
#define AT91C_TDES_TPR          (AT91_CAST(AT91_REG *) 0xFFFC4108) // (TDES) Transmit Pointer Register
#define AT91C_TDES_TCR          (AT91_CAST(AT91_REG *) 0xFFFC410C) // (TDES) Transmit Counter Register
#define AT91C_TDES_RNPR         (AT91_CAST(AT91_REG *) 0xFFFC4110) // (TDES) Receive Next Pointer Register
#define AT91C_TDES_RNCR         (AT91_CAST(AT91_REG *) 0xFFFC4114) // (TDES) Receive Next Counter Register
#define AT91C_TDES_TNPR         (AT91_CAST(AT91_REG *) 0xFFFC4118) // (TDES) Transmit Next Pointer Register
#define AT91C_TDES_TNCR         (AT91_CAST(AT91_REG *) 0xFFFC411C) // (TDES) Transmit Next Counter Register
#define AT91C_TDES_PTCR         (AT91_CAST(AT91_REG *) 0xFFFC4120) // (TDES) Transfer Control Register
#define AT91C_TDES_PTSR         (AT91_CAST(AT91_REG *) 0xFFFC4124) // (TDES) Transfer Status Register
// ========== Register definition for SHA peripheral ==========
#define AT91C_SHA_CR            (AT91_CAST(AT91_REG *) 0xFFFC8000) // (SHA) Control Register
#define AT91C_SHA_MR            (AT91_CAST(AT91_REG *) 0xFFFC8004) // (SHA) Mode Register
#define AT91C_SHA_IER           (AT91_CAST(AT91_REG *) 0xFFFC8010) // (SHA) Interrupt Enable Register
#define AT91C_SHA_IDR           (AT91_CAST(AT91_REG *) 0xFFFC8014) // (SHA) Interrupt Disable Register
#define AT91C_SHA_IMR           (AT91_CAST(AT91_REG *) 0xFFFC8018) // (SHA) Interrupt Mask Register
#define AT91C_SHA_ISR           (AT91_CAST(AT91_REG *) 0xFFFC801C) // (SHA) Interrupt Status Register
#define AT91C_SHA_IDATAR        (AT91_CAST(AT91_REG *) 0xFFFC8040) // (SHA) Input Data Register
#define AT91C_SHA_ODATAR        (AT91_CAST(AT91_REG *) 0xFFFC8080) // (SHA) Output Data Register
#define AT91C_SHA_RPR           (AT91_CAST(AT91_REG *) 0xFFFC8100) // (SHA) Receive Pointer Register
#define AT91C_SHA_RCR           (AT91_CAST(AT91_REG *) 0xFFFC8104) // (SHA) Receive Counter Register
#define AT91C_SHA_TPR           (AT91_CAST(AT91_REG *) 0xFFFC8108) // (SHA) Transmit Pointer Register
#define AT91C_SHA_TCR           (AT91_CAST(AT91_REG *) 0xFFFC810C) // (SHA) Transmit Counter Register
#define AT91C_SHA_RNPR          (AT91_CAST(AT91_REG *) 0xFFFC8110) // (SHA) Receive Next Pointer Register
#define AT91C_SHA_RNCR          (AT91_CAST(AT91_REG *) 0xFFFC8114) // (SHA) Receive Next Counter Register
#define AT91C_SHA_TNPR          (AT91_CAST(AT91_REG *) 0xFFFC8118) // (SHA) Transmit Next Pointer Register
#define AT91C_SHA_TNCR          (AT91_CAST(AT91_REG *) 0xFFFC811C) // (SHA) Transmit Next Counter Register
#define AT91C_SHA_PTCR          (AT91_CAST(AT91_REG *) 0xFFFC8120) // (SHA) Transfer Control Register
#define AT91C_SHA_PTSR          (AT91_CAST(AT91_REG *) 0xFFFC8124) // (SHA) Transfer Status Register
// ========== Register definition for TRNG peripheral ==========
#define AT91C_TRNG_CR           (AT91_CAST(AT91_REG *) 0xFFFCC000) // (TRNG) Control Register
#define AT91C_TRNG_IER          (AT91_CAST(AT91_REG *) 0xFFFCC010) // (TRNG) Interrupt Enable Register
#define AT91C_TRNG_IDR          (AT91_CAST(AT91_REG *) 0xFFFCC014) // (TRNG) Interrupt Disable Register
#define AT91C_TRNG_IMR          (AT91_CAST(AT91_REG *) 0xFFFCC018) // (TRNG) Interrupt Mask Register
#define AT91C_TRNG_ISR          (AT91_CAST(AT91_REG *) 0xFFFCC01C) // (TRNG) Interrupt Status Register
#define AT91C_TRNG_ODATA        (AT91_CAST(AT91_REG *) 0xFFFCC050) // (TRNG) Output Data Register
// ========== Register definition for MCI1 peripheral ==========
#define AT91C_MCI1_CR           (AT91_CAST(AT91_REG *) 0xFFFD0000) // (MCI1) Control Register
#define AT91C_MCI1_MR           (AT91_CAST(AT91_REG *) 0xFFFD0004) // (MCI1) Mode Register
#define AT91C_MCI1_DTOR         (AT91_CAST(AT91_REG *) 0xFFFD0008) // (MCI1) Data Timeout Register
#define AT91C_MCI1_SDCR         (AT91_CAST(AT91_REG *) 0xFFFD000C) // (MCI1) SD/SDIO Card Register
#define AT91C_MCI1_ARGR         (AT91_CAST(AT91_REG *) 0xFFFD0010) // (MCI1) Argument Register
#define AT91C_MCI1_CMDR         (AT91_CAST(AT91_REG *) 0xFFFD0014) // (MCI1) Command Register
#define AT91C_MCI1_BLKR         (AT91_CAST(AT91_REG *) 0xFFFD0018) // (MCI1) Block Register
#define AT91C_MCI1_CSTOR        (AT91_CAST(AT91_REG *) 0xFFFD001C) // (MCI1) Completion Signal Timeout Register
#define AT91C_MCI1_RSPR         (AT91_CAST(AT91_REG *) 0xFFFD0020) // (MCI1) Response Register
#define AT91C_MCI1_RDR          (AT91_CAST(AT91_REG *) 0xFFFD0030) // (MCI1) Receive Data Register
#define AT91C_MCI1_TDR          (AT91_CAST(AT91_REG *) 0xFFFD0034) // (MCI1) Transmit Data Register
#define AT91C_MCI1_SR           (AT91_CAST(AT91_REG *) 0xFFFD0040) // (MCI1) Status Register
#define AT91C_MCI1_IER          (AT91_CAST(AT91_REG *) 0xFFFD0044) // (MCI1) Interrupt Enable Register
#define AT91C_MCI1_IDR          (AT91_CAST(AT91_REG *) 0xFFFD0048) // (MCI1) Interrupt Disable Register
#define AT91C_MCI1_IMR          (AT91_CAST(AT91_REG *) 0xFFFD004C) // (MCI1) Interrupt Mask Register
#define AT91C_MCI1_DMA          (AT91_CAST(AT91_REG *) 0xFFFD0050) // (MCI1) DMA Configuration Register
#define AT91C_MCI1_CFG          (AT91_CAST(AT91_REG *) 0xFFFD0054) // (MCI1) Configuration Register
#define AT91C_MCI1_WPMR         (AT91_CAST(AT91_REG *) 0xFFFD00E4) // (MCI1) Write Protection Mode Register
#define AT91C_MCI1_WPSR         (AT91_CAST(AT91_REG *) 0xFFFD00E8) // (MCI1) Write Protection Status Register
#define AT91C_MCI1_FIFO         (AT91_CAST(AT91_REG *) 0xFFFD0200) // (MCI1) FIFO Memory Aperture
// ========== Register definition for TC1 peripheral ==========
#define AT91C_TC1_CCR0          (AT91_CAST(AT91_REG *) 0xFFFD4000) // (TC1) Channel Control Register (channel = 0)
#define AT91C_TC1_CMR0          (AT91_CAST(AT91_REG *) 0xFFFD4004) // (TC1) Channel Mode Register (channel = 0)
#define AT91C_TC1_CV0           (AT91_CAST(AT91_REG *) 0xFFFD4010) // (TC1) Counter Value (channel = 0)
#define AT91C_TC1_RA0           (AT91_CAST(AT91_REG *) 0xFFFD4014) // (TC1) Register A (channel = 0)
#define AT91C_TC1_RB0           (AT91_CAST(AT91_REG *) 0xFFFD4018) // (TC1) Register B (channel = 0)
#define AT91C_TC1_RC0           (AT91_CAST(AT91_REG *) 0xFFFD401C) // (TC1) Register C (channel = 0)
#define AT91C_TC1_SR0           (AT91_CAST(AT91_REG *) 0xFFFD4020) // (TC1) Status Register (channel = 0)
#define AT91C_TC1_IER0          (AT91_CAST(AT91_REG *) 0xFFFD4024) // (TC1) Interrupt Enable Register (channel = 0)
#define AT91C_TC1_IDR0          (AT91_CAST(AT91_REG *) 0xFFFD4028) // (TC1) Interrupt Disable Register (channel = 0)
#define AT91C_TC1_IMR0          (AT91_CAST(AT91_REG *) 0xFFFD402C) // (TC1) Interrupt Mask Register (channel = 0)
#define AT91C_TC1_CCR1          (AT91_CAST(AT91_REG *) 0xFFFD4040) // (TC1) Channel Control Register (channel = 1)
#define AT91C_TC1_CMR1          (AT91_CAST(AT91_REG *) 0xFFFD4044) // (TC1) Channel Mode Register (channel = 1)
#define AT91C_TC1_CV1           (AT91_CAST(AT91_REG *) 0xFFFD4050) // (TC1) Counter Value (channel = 1)
#define AT91C_TC1_RA1           (AT91_CAST(AT91_REG *) 0xFFFD4054) // (TC1) Register A (channel = 1)
#define AT91C_TC1_RB1           (AT91_CAST(AT91_REG *) 0xFFFD4058) // (TC1) Register B (channel = 1)
#define AT91C_TC1_RC1           (AT91_CAST(AT91_REG *) 0xFFFD405C) // (TC1) Register C (channel = 1)
#define AT91C_TC1_SR1           (AT91_CAST(AT91_REG *) 0xFFFD4060) // (TC1) Status Register (channel = 1)
#define AT91C_TC1_IER1          (AT91_CAST(AT91_REG *) 0xFFFD4064) // (TC1) Interrupt Enable Register (channel = 1)
#define AT91C_TC1_IDR1          (AT91_CAST(AT91_REG *) 0xFFFD4068) // (TC1) Interrupt Disable Register (channel = 1)
#define AT91C_TC1_IMR1          (AT91_CAST(AT91_REG *) 0xFFFD406C) // (TC1) Interrupt Mask Register (channel = 1)
#define AT91C_TC1_CCR2          (AT91_CAST(AT91_REG *) 0xFFFD4080) // (TC1) Channel Control Register (channel = 2)
#define AT91C_TC1_CMR2          (AT91_CAST(AT91_REG *) 0xFFFD4084) // (TC1) Channel Mode Register (channel = 2)
#define AT91C_TC1_CV2           (AT91_CAST(AT91_REG *) 0xFFFD4090) // (TC1) Counter Value (channel = 2)
#define AT91C_TC1_RA2           (AT91_CAST(AT91_REG *) 0xFFFD4094) // (TC1) Register A (channel = 2)
#define AT91C_TC1_RB2           (AT91_CAST(AT91_REG *) 0xFFFD4098) // (TC1) Register B (channel = 2)
#define AT91C_TC1_RC2           (AT91_CAST(AT91_REG *) 0xFFFD409C) // (TC1) Register C (channel = 2)
#define AT91C_TC1_SR2           (AT91_CAST(AT91_REG *) 0xFFFD40A0) // (TC1) Status Register (channel = 2)
#define AT91C_TC1_IER2          (AT91_CAST(AT91_REG *) 0xFFFD40A4) // (TC1) Interrupt Enable Register (channel = 2)
#define AT91C_TC1_IDR2          (AT91_CAST(AT91_REG *) 0xFFFD40A8) // (TC1) Interrupt Disable Register (channel = 2)
#define AT91C_TC1_IMR2          (AT91_CAST(AT91_REG *) 0xFFFD40AC) // (TC1) Interrupt Mask Register (channel = 2)
#define AT91C_TC1_BCR           (AT91_CAST(AT91_REG *) 0xFFFD40C0) // (TC1) Block Control Register
#define AT91C_TC1_BMR           (AT91_CAST(AT91_REG *) 0xFFFD40C4) // (TC1) Block Mode Register
// ========== Register definition for DDRSDRC1 peripheral ==========
#define AT91C_DDRSDRC1_MR       (AT91_CAST(AT91_REG *) 0xFFFFE400) // (DDRSDRC1) DDRSDRC Mode Register
#define AT91C_DDRSDRC1_RTR      (AT91_CAST(AT91_REG *) 0xFFFFE404) // (DDRSDRC1) DDRSDRC Refresh Timer Register
#define AT91C_DDRSDRC1_CR       (AT91_CAST(AT91_REG *) 0xFFFFE408) // (DDRSDRC1) DDRSDRC Configuration Register
#define AT91C_DDRSDRC1_T0PR     (AT91_CAST(AT91_REG *) 0xFFFFE40C) // (DDRSDRC1) DDRSDRC Timing0 Register
#define AT91C_DDRSDRC1_T1PR     (AT91_CAST(AT91_REG *) 0xFFFFE410) // (DDRSDRC1) DDRSDRC Timing1 Register
#define AT91C_DDRSDRC1_T2PR     (AT91_CAST(AT91_REG *) 0xFFFFE414) // (DDRSDRC1) DDRSDRC Timing2 Register
#define AT91C_DDRSDRC1_LPR      (AT91_CAST(AT91_REG *) 0xFFFFE41C) // (DDRSDRC1) DDRSDRC Low-power Register
#define AT91C_DDRSDRC1_MD       (AT91_CAST(AT91_REG *) 0xFFFFE420) // (DDRSDRC1) DDRSDRC Memory Device Register
#define AT91C_DDRSDRC1_DLL      (AT91_CAST(AT91_REG *) 0xFFFFE424) // (DDRSDRC1) DDRSDRC DLL Information Register
#define AT91C_DDRSDRC1_WPMR     (AT91_CAST(AT91_REG *) 0xFFFFE4E4) // (DDRSDRC1) DDRSDRC Write Protect Mode Register
#define AT91C_DDRSDRC1_WPSR     (AT91_CAST(AT91_REG *) 0xFFFFE4E8) // (DDRSDRC1) DDRSDRC Write Protect Status Register
// ========== Register definition for DDRSDRC0 peripheral ==========
#define AT91C_DDRSDRC0_MR       (AT91_CAST(AT91_REG *) 0xFFFFE600) // (DDRSDRC0) DDRSDRC Mode Register
#define AT91C_DDRSDRC0_RTR      (AT91_CAST(AT91_REG *) 0xFFFFE604) // (DDRSDRC0) DDRSDRC Refresh Timer Register
#define AT91C_DDRSDRC0_CR       (AT91_CAST(AT91_REG *) 0xFFFFE608) // (DDRSDRC0) DDRSDRC Configuration Register
#define AT91C_DDRSDRC0_T0PR     (AT91_CAST(AT91_REG *) 0xFFFFE60C) // (DDRSDRC0) DDRSDRC Timing0 Register
#define AT91C_DDRSDRC0_T1PR     (AT91_CAST(AT91_REG *) 0xFFFFE610) // (DDRSDRC0) DDRSDRC Timing1 Register
#define AT91C_DDRSDRC0_T2PR     (AT91_CAST(AT91_REG *) 0xFFFFE614) // (DDRSDRC0) DDRSDRC Timing2 Register
#define AT91C_DDRSDRC0_LPR      (AT91_CAST(AT91_REG *) 0xFFFFE61C) // (DDRSDRC0) DDRSDRC Low-power Register
#define AT91C_DDRSDRC0_MD       (AT91_CAST(AT91_REG *) 0xFFFFE620) // (DDRSDRC0) DDRSDRC Memory Device Register
#define AT91C_DDRSDRC0_DLL      (AT91_CAST(AT91_REG *) 0xFFFFE624) // (DDRSDRC0) DDRSDRC DLL Information Register
#define AT91C_DDRSDRC0_WPMR     (AT91_CAST(AT91_REG *) 0xFFFFE6E4) // (DDRSDRC0) DDRSDRC Write Protect Mode Register
#define AT91C_DDRSDRC0_WPSR     (AT91_CAST(AT91_REG *) 0xFFFFE6E8) // (DDRSDRC0) DDRSDRC Write Protect Status Register
// ========== Register definition for SMC peripheral ==========
#define AT91C_SMC_SETUP0        (AT91_CAST(AT91_REG *) 0xFFFFE800) // (SMC) SMC Setup Register (CS_number = 0)
#define AT91C_SMC_PULSE0        (AT91_CAST(AT91_REG *) 0xFFFFE804) // (SMC) SMC Pulse Register (CS_number = 0)
#define AT91C_SMC_CYCLE0        (AT91_CAST(AT91_REG *) 0xFFFFE808) // (SMC) SMC Cycle Register (CS_number = 0)
#define AT91C_SMC_MODE0         (AT91_CAST(AT91_REG *) 0xFFFFE80C) // (SMC) SMC Mode Register (CS_number = 0)
#define AT91C_SMC_SETUP1        (AT91_CAST(AT91_REG *) 0xFFFFE810) // (SMC) SMC Setup Register (CS_number = 1)
#define AT91C_SMC_PULSE1        (AT91_CAST(AT91_REG *) 0xFFFFE814) // (SMC) SMC Pulse Register (CS_number = 1)
#define AT91C_SMC_CYCLE1        (AT91_CAST(AT91_REG *) 0xFFFFE818) // (SMC) SMC Cycle Register (CS_number = 1)
#define AT91C_SMC_MODE1         (AT91_CAST(AT91_REG *) 0xFFFFE81C) // (SMC) SMC Mode Register (CS_number = 1)
#define AT91C_SMC_SETUP2        (AT91_CAST(AT91_REG *) 0xFFFFE820) // (SMC) SMC Setup Register (CS_number = 2)
#define AT91C_SMC_PULSE2        (AT91_CAST(AT91_REG *) 0xFFFFE824) // (SMC) SMC Pulse Register (CS_number = 2)
#define AT91C_SMC_CYCLE2        (AT91_CAST(AT91_REG *) 0xFFFFE828) // (SMC) SMC Cycle Register (CS_number = 2)
#define AT91C_SMC_MODE2         (AT91_CAST(AT91_REG *) 0xFFFFE82C) // (SMC) SMC Mode Register (CS_number = 2)
#define AT91C_SMC_SETUP3        (AT91_CAST(AT91_REG *) 0xFFFFE830) // (SMC) SMC Setup Register (CS_number = 3)
#define AT91C_SMC_PULSE3        (AT91_CAST(AT91_REG *) 0xFFFFE834) // (SMC) SMC Pulse Register (CS_number = 3)
#define AT91C_SMC_CYCLE3        (AT91_CAST(AT91_REG *) 0xFFFFE838) // (SMC) SMC Cycle Register (CS_number = 3)
#define AT91C_SMC_MODE3         (AT91_CAST(AT91_REG *) 0xFFFFE83C) // (SMC) SMC Mode Register (CS_number = 3)
#define AT91C_SMC_SETUP4        (AT91_CAST(AT91_REG *) 0xFFFFE840) // (SMC) SMC Setup Register (CS_number = 4)
#define AT91C_SMC_PULSE4        (AT91_CAST(AT91_REG *) 0xFFFFE844) // (SMC) SMC Pulse Register (CS_number = 4)
#define AT91C_SMC_CYCLE4        (AT91_CAST(AT91_REG *) 0xFFFFE848) // (SMC) SMC Cycle Register (CS_number = 4)
#define AT91C_SMC_MODE4         (AT91_CAST(AT91_REG *) 0xFFFFE84C) // (SMC) SMC Mode Register (CS_number = 4)
#define AT91C_SMC_SETUP5        (AT91_CAST(AT91_REG *) 0xFFFFE850) // (SMC) SMC Setup Register (CS_number = 5)
#define AT91C_SMC_PULSE5        (AT91_CAST(AT91_REG *) 0xFFFFE854) // (SMC) SMC Pulse Register (CS_number = 5)
#define AT91C_SMC_CYCLE5        (AT91_CAST(AT91_REG *) 0xFFFFE858) // (SMC) SMC Cycle Register (CS_number = 5)
#define AT91C_SMC_MODE5         (AT91_CAST(AT91_REG *) 0xFFFFE85C) // (SMC) SMC Mode Register (CS_number = 5)
#define AT91C_SMC_SETUP6        (AT91_CAST(AT91_REG *) 0xFFFFE860) // (SMC) SMC Setup Register (CS_number = 6)
#define AT91C_SMC_PULSE6        (AT91_CAST(AT91_REG *) 0xFFFFE864) // (SMC) SMC Pulse Register (CS_number = 6)
#define AT91C_SMC_CYCLE6        (AT91_CAST(AT91_REG *) 0xFFFFE868) // (SMC) SMC Cycle Register (CS_number = 6)
#define AT91C_SMC_MODE6         (AT91_CAST(AT91_REG *) 0xFFFFE86C) // (SMC) SMC Mode Register (CS_number = 6)
#define AT91C_SMC_SETUP7        (AT91_CAST(AT91_REG *) 0xFFFFE870) // (SMC) SMC Setup Register (CS_number = 7)
#define AT91C_SMC_PULSE7        (AT91_CAST(AT91_REG *) 0xFFFFE874) // (SMC) SMC Pulse Register (CS_number = 7)
#define AT91C_SMC_CYCLE7        (AT91_CAST(AT91_REG *) 0xFFFFE878) // (SMC) SMC Cycle Register (CS_number = 7)
#define AT91C_SMC_MODE7         (AT91_CAST(AT91_REG *) 0xFFFFE87C) // (SMC) SMC Mode Register (CS_number = 7)
// ========== Register definition for MATRIX peripheral ==========
#define AT91C_MATRIX_MCFG       (AT91_CAST(AT91_REG *) 0xFFFFEA00) // (MATRIX) Master Configuration Register
#define AT91C_MATRIX_SCFG       (AT91_CAST(AT91_REG *) 0xFFFFEA40) // (MATRIX) Slave Configuration Register
#define AT91C_MATRIX_PRAS0      (AT91_CAST(AT91_REG *) 0xFFFFEA80) // (MATRIX) Priority Register A for Slave 0
#define AT91C_MATRIX_PRBS0      (AT91_CAST(AT91_REG *) 0xFFFFEA84) // (MATRIX) Priority Register B for Slave 0
#define AT91C_MATRIX_PRAS1      (AT91_CAST(AT91_REG *) 0xFFFFEA88) // (MATRIX) Priority Register A for Slave 1
#define AT91C_MATRIX_PRBS1      (AT91_CAST(AT91_REG *) 0xFFFFEA8C) // (MATRIX) Priority Register B for Slave 1
#define AT91C_MATRIX_PRAS2      (AT91_CAST(AT91_REG *) 0xFFFFEA90) // (MATRIX) Priority Register A for Slave 2
#define AT91C_MATRIX_PRBS2      (AT91_CAST(AT91_REG *) 0xFFFFEA94) // (MATRIX) Priority Register B for Slave 2
#define AT91C_MATRIX_PRAS3      (AT91_CAST(AT91_REG *) 0xFFFFEA98) // (MATRIX) Priority Register A for Slave 3
#define AT91C_MATRIX_PRBS3      (AT91_CAST(AT91_REG *) 0xFFFFEA9C) // (MATRIX) Priority Register B for Slave 3
#define AT91C_MATRIX_PRAS4      (AT91_CAST(AT91_REG *) 0xFFFFEAA0) // (MATRIX) Priority Register A for Slave 4
#define AT91C_MATRIX_PRBS4      (AT91_CAST(AT91_REG *) 0xFFFFEAA4) // (MATRIX) Priority Register B for Slave 4
#define AT91C_MATRIX_PRAS5      (AT91_CAST(AT91_REG *) 0xFFFFEAA8) // (MATRIX) Priority Register A for Slave 5
#define AT91C_MATRIX_PRBS5      (AT91_CAST(AT91_REG *) 0xFFFFEAAC) // (MATRIX) Priority Register B for Slave 5
#define AT91C_MATRIX_PRAS6      (AT91_CAST(AT91_REG *) 0xFFFFEAB0) // (MATRIX) Priority Register A for Slave 6
#define AT91C_MATRIX_PRBS6      (AT91_CAST(AT91_REG *) 0xFFFFEAB4) // (MATRIX) Priority Register B for Slave 6
#define AT91C_MATRIX_PRAS7      (AT91_CAST(AT91_REG *) 0xFFFFEAB8) // (MATRIX) Priority Register A for Slave 7
#define AT91C_MATRIX_PRBS7      (AT91_CAST(AT91_REG *) 0xFFFFEABC) // (MATRIX) Priority Register B for Slave 7
#define AT91C_MATRIX_PRAS8      (AT91_CAST(AT91_REG *) 0xFFFFEAC0) // (MATRIX) Priority Register A for Slave 8
#define AT91C_MATRIX_PRBS8      (AT91_CAST(AT91_REG *) 0xFFFFEAC4) // (MATRIX) Priority Register B for Slave 8
#define AT91C_MATRIX_PRAS9      (AT91_CAST(AT91_REG *) 0xFFFFEAC8) // (MATRIX) Priority Register A for Slave 9
#define AT91C_MATRIX_PRBS9      (AT91_CAST(AT91_REG *) 0xFFFFEACC) // (MATRIX) Priority Register B for Slave 9
#define AT91C_MATRIX_PRAS10     (AT91_CAST(AT91_REG *) 0xFFFFEAD0) // (MATRIX) Priority Register A for Slave 10
#define AT91C_MATRIX_PRBS10     (AT91_CAST(AT91_REG *) 0xFFFFEAD4) // (MATRIX) Priority Register B for Slave 10
#define AT91C_MATRIX_PRAS11     (AT91_CAST(AT91_REG *) 0xFFFFEAD8) // (MATRIX) Priority Register A for Slave 11
#define AT91C_MATRIX_PRBS11     (AT91_CAST(AT91_REG *) 0xFFFFEADC) // (MATRIX) Priority Register B for Slave 11
#define AT91C_MATRIX_PRAS12     (AT91_CAST(AT91_REG *) 0xFFFFEAE0) // (MATRIX) Priority Register A for Slave 12
#define AT91C_MATRIX_PRBS12     (AT91_CAST(AT91_REG *) 0xFFFFEAE4) // (MATRIX) Priority Register B for Slave 12
#define AT91C_MATRIX_PRAS13     (AT91_CAST(AT91_REG *) 0xFFFFEAE8) // (MATRIX) Priority Register A for Slave 13
#define AT91C_MATRIX_PRBS13     (AT91_CAST(AT91_REG *) 0xFFFFEAEC) // (MATRIX) Priority Register B for Slave 13
#define AT91C_MATRIX_PRAS14     (AT91_CAST(AT91_REG *) 0xFFFFEAF0) // (MATRIX) Priority Register A for Slave 14
#define AT91C_MATRIX_PRBS14     (AT91_CAST(AT91_REG *) 0xFFFFEAF4) // (MATRIX) Priority Register B for Slave 14
#define AT91C_MATRIX_PRAS15     (AT91_CAST(AT91_REG *) 0xFFFFEAF8) // (MATRIX) Priority Register A for Slave 15
#define AT91C_MATRIX_PRBS15     (AT91_CAST(AT91_REG *) 0xFFFFEAFC) // (MATRIX) Priority Register B for Slave 15
#define AT91C_MATRIX_MRCR       (AT91_CAST(AT91_REG *) 0xFFFFEB00) // (MATRIX) Master Remap Control Register
#define AT91C_MATRIX_SFR        (AT91_CAST(AT91_REG *) 0xFFFFEB10) // (MATRIX) Special Function Register
#define AT91C_MATRIX_WPMR       (AT91_CAST(AT91_REG *) 0xFFFFEBE4) // (MATRIX) Write Protect Mode Register
#define AT91C_MATRIX_WPSR       (AT91_CAST(AT91_REG *) 0xFFFFEBE8) // (MATRIX) Write Protect Status Register
// ========== Register definition for DMAC peripheral ==========
#define AT91C_DMAC_GCFG         (AT91_CAST(AT91_REG *) 0xFFFFEC00) // (DMAC) DMAC Global Configuration Register
#define AT91C_DMAC_EN           (AT91_CAST(AT91_REG *) 0xFFFFEC04) // (DMAC) DMAC Enable Register
#define AT91C_DMAC_EBCIER       (AT91_CAST(AT91_REG *) 0xFFFFEC18) // (DMAC) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable Register
#define AT91C_DMAC_EBCIDR       (AT91_CAST(AT91_REG *) 0xFFFFEC1C) // (DMAC) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable Register
#define AT91C_DMAC_EBCIMR       (AT91_CAST(AT91_REG *) 0xFFFFEC20) // (DMAC) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register
#define AT91C_DMAC_EBCISR       (AT91_CAST(AT91_REG *) 0xFFFFEC24) // (DMAC) DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Status Register
#define AT91C_DMAC_CHER         (AT91_CAST(AT91_REG *) 0xFFFFEC28) // (DMAC) DMAC Channel Handler Enable Register
#define AT91C_DMAC_CHDR         (AT91_CAST(AT91_REG *) 0xFFFFEC2C) // (DMAC) DMAC Channel Handler Disable Register
#define AT91C_DMAC_CHSR         (AT91_CAST(AT91_REG *) 0xFFFFEC30) // (DMAC) DMAC Channel Handler Status Register
#define AT91C_DMAC_SADDR0       (AT91_CAST(AT91_REG *) 0xFFFFEC3C) // (DMAC) DMAC Channel Source Address Register (ch_num = 0)
#define AT91C_DMAC_DADDR0       (AT91_CAST(AT91_REG *) 0xFFFFEC40) // (DMAC) DMAC Channel Destination Address Register (ch_num = 0)
#define AT91C_DMAC_DSCR0        (AT91_CAST(AT91_REG *) 0xFFFFEC44) // (DMAC) DMAC Channel Descriptor Address Register (ch_num = 0)
#define AT91C_DMAC_CTRLA0       (AT91_CAST(AT91_REG *) 0xFFFFEC48) // (DMAC) DMAC Channel Control A Register (ch_num = 0)
#define AT91C_DMAC_CTRLB0       (AT91_CAST(AT91_REG *) 0xFFFFEC4C) // (DMAC) DMAC Channel Control B Register (ch_num = 0)
#define AT91C_DMAC_CFG0         (AT91_CAST(AT91_REG *) 0xFFFFEC50) // (DMAC) DMAC Channel Configuration Register (ch_num = 0)
#define AT91C_DMAC_SPIP0        (AT91_CAST(AT91_REG *) 0xFFFFEC54) // (DMAC) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 0)
#define AT91C_DMAC_DPIP0        (AT91_CAST(AT91_REG *) 0xFFFFEC58) // (DMAC) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 0)
#define AT91C_DMAC_SADDR1       (AT91_CAST(AT91_REG *) 0xFFFFEC64) // (DMAC) DMAC Channel Source Address Register (ch_num = 1)
#define AT91C_DMAC_DADDR1       (AT91_CAST(AT91_REG *) 0xFFFFEC68) // (DMAC) DMAC Channel Destination Address Register (ch_num = 1)
#define AT91C_DMAC_DSCR1        (AT91_CAST(AT91_REG *) 0xFFFFEC6C) // (DMAC) DMAC Channel Descriptor Address Register (ch_num = 1)
#define AT91C_DMAC_CTRLA1       (AT91_CAST(AT91_REG *) 0xFFFFEC70) // (DMAC) DMAC Channel Control A Register (ch_num = 1)
#define AT91C_DMAC_CTRLB1       (AT91_CAST(AT91_REG *) 0xFFFFEC74) // (DMAC) DMAC Channel Control B Register (ch_num = 1)
#define AT91C_DMAC_CFG1         (AT91_CAST(AT91_REG *) 0xFFFFEC78) // (DMAC) DMAC Channel Configuration Register (ch_num = 1)
#define AT91C_DMAC_SPIP1        (AT91_CAST(AT91_REG *) 0xFFFFEC7C) // (DMAC) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 1)
#define AT91C_DMAC_DPIP1        (AT91_CAST(AT91_REG *) 0xFFFFEC80) // (DMAC) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 1)
#define AT91C_DMAC_SADDR2       (AT91_CAST(AT91_REG *) 0xFFFFEC8C) // (DMAC) DMAC Channel Source Address Register (ch_num = 2)
#define AT91C_DMAC_DADDR2       (AT91_CAST(AT91_REG *) 0xFFFFEC90) // (DMAC) DMAC Channel Destination Address Register (ch_num = 2)
#define AT91C_DMAC_DSCR2        (AT91_CAST(AT91_REG *) 0xFFFFEC94) // (DMAC) DMAC Channel Descriptor Address Register (ch_num = 2)
#define AT91C_DMAC_CTRLA2       (AT91_CAST(AT91_REG *) 0xFFFFEC98) // (DMAC) DMAC Channel Control A Register (ch_num = 2)
#define AT91C_DMAC_CTRLB2       (AT91_CAST(AT91_REG *) 0xFFFFEC9C) // (DMAC) DMAC Channel Control B Register (ch_num = 2)
#define AT91C_DMAC_CFG2         (AT91_CAST(AT91_REG *) 0xFFFFECA0) // (DMAC) DMAC Channel Configuration Register (ch_num = 2)
#define AT91C_DMAC_SPIP2        (AT91_CAST(AT91_REG *) 0xFFFFECA4) // (DMAC) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 2)
#define AT91C_DMAC_DPIP2        (AT91_CAST(AT91_REG *) 0xFFFFECA8) // (DMAC) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 2)
#define AT91C_DMAC_SADDR3       (AT91_CAST(AT91_REG *) 0xFFFFECB4) // (DMAC) DMAC Channel Source Address Register (ch_num = 3)
#define AT91C_DMAC_DADDR3       (AT91_CAST(AT91_REG *) 0xFFFFECB8) // (DMAC) DMAC Channel Destination Address Register (ch_num = 3)
#define AT91C_DMAC_DSCR3        (AT91_CAST(AT91_REG *) 0xFFFFECBC) // (DMAC) DMAC Channel Descriptor Address Register (ch_num = 3)
#define AT91C_DMAC_CTRLA3       (AT91_CAST(AT91_REG *) 0xFFFFECC0) // (DMAC) DMAC Channel Control A Register (ch_num = 3)
#define AT91C_DMAC_CTRLB3       (AT91_CAST(AT91_REG *) 0xFFFFECC4) // (DMAC) DMAC Channel Control B Register (ch_num = 3)
#define AT91C_DMAC_CFG3         (AT91_CAST(AT91_REG *) 0xFFFFECC8) // (DMAC) DMAC Channel Configuration Register (ch_num = 3)
#define AT91C_DMAC_SPIP3        (AT91_CAST(AT91_REG *) 0xFFFFECCC) // (DMAC) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 3)
#define AT91C_DMAC_DPIP3        (AT91_CAST(AT91_REG *) 0xFFFFECD0) // (DMAC) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 3)
#define AT91C_DMAC_SADDR4       (AT91_CAST(AT91_REG *) 0xFFFFECDC) // (DMAC) DMAC Channel Source Address Register (ch_num = 4)
#define AT91C_DMAC_DADDR4       (AT91_CAST(AT91_REG *) 0xFFFFECE0) // (DMAC) DMAC Channel Destination Address Register (ch_num = 4)
#define AT91C_DMAC_DSCR4        (AT91_CAST(AT91_REG *) 0xFFFFECE4) // (DMAC) DMAC Channel Descriptor Address Register (ch_num = 4)
#define AT91C_DMAC_CTRLA4       (AT91_CAST(AT91_REG *) 0xFFFFECE8) // (DMAC) DMAC Channel Control A Register (ch_num = 4)
#define AT91C_DMAC_CTRLB4       (AT91_CAST(AT91_REG *) 0xFFFFECEC) // (DMAC) DMAC Channel Control B Register (ch_num = 4)
#define AT91C_DMAC_CFG4         (AT91_CAST(AT91_REG *) 0xFFFFECF0) // (DMAC) DMAC Channel Configuration Register (ch_num = 4)
#define AT91C_DMAC_SPIP4        (AT91_CAST(AT91_REG *) 0xFFFFECF4) // (DMAC) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 4)
#define AT91C_DMAC_DPIP4        (AT91_CAST(AT91_REG *) 0xFFFFECF8) // (DMAC) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 4)
#define AT91C_DMAC_SADDR5       (AT91_CAST(AT91_REG *) 0xFFFFED04) // (DMAC) DMAC Channel Source Address Register (ch_num = 5)
#define AT91C_DMAC_DADDR5       (AT91_CAST(AT91_REG *) 0xFFFFED08) // (DMAC) DMAC Channel Destination Address Register (ch_num = 5)
#define AT91C_DMAC_DSCR5        (AT91_CAST(AT91_REG *) 0xFFFFED0C) // (DMAC) DMAC Channel Descriptor Address Register (ch_num = 5)
#define AT91C_DMAC_CTRLA5       (AT91_CAST(AT91_REG *) 0xFFFFED10) // (DMAC) DMAC Channel Control A Register (ch_num = 5)
#define AT91C_DMAC_CTRLB5       (AT91_CAST(AT91_REG *) 0xFFFFED14) // (DMAC) DMAC Channel Control B Register (ch_num = 5)
#define AT91C_DMAC_CFG5         (AT91_CAST(AT91_REG *) 0xFFFFED18) // (DMAC) DMAC Channel Configuration Register (ch_num = 5)
#define AT91C_DMAC_SPIP5        (AT91_CAST(AT91_REG *) 0xFFFFED1C) // (DMAC) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 5)
#define AT91C_DMAC_DPIP5        (AT91_CAST(AT91_REG *) 0xFFFFED20) // (DMAC) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 5)
#define AT91C_DMAC_SADDR6       (AT91_CAST(AT91_REG *) 0xFFFFED2C) // (DMAC) DMAC Channel Source Address Register (ch_num = 6)
#define AT91C_DMAC_DADDR6       (AT91_CAST(AT91_REG *) 0xFFFFED30) // (DMAC) DMAC Channel Destination Address Register (ch_num = 6)
#define AT91C_DMAC_DSCR6        (AT91_CAST(AT91_REG *) 0xFFFFED34) // (DMAC) DMAC Channel Descriptor Address Register (ch_num = 6)
#define AT91C_DMAC_CTRLA6       (AT91_CAST(AT91_REG *) 0xFFFFED38) // (DMAC) DMAC Channel Control A Register (ch_num = 6)
#define AT91C_DMAC_CTRLB6       (AT91_CAST(AT91_REG *) 0xFFFFED3C) // (DMAC) DMAC Channel Control B Register (ch_num = 6)
#define AT91C_DMAC_CFG6         (AT91_CAST(AT91_REG *) 0xFFFFED40) // (DMAC) DMAC Channel Configuration Register (ch_num = 6)
#define AT91C_DMAC_SPIP6        (AT91_CAST(AT91_REG *) 0xFFFFED44) // (DMAC) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 6)
#define AT91C_DMAC_DPIP6        (AT91_CAST(AT91_REG *) 0xFFFFED48) // (DMAC) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 6)
#define AT91C_DMAC_SADDR7       (AT91_CAST(AT91_REG *) 0xFFFFED54) // (DMAC) DMAC Channel Source Address Register (ch_num = 7)
#define AT91C_DMAC_DADDR7       (AT91_CAST(AT91_REG *) 0xFFFFED58) // (DMAC) DMAC Channel Destination Address Register (ch_num = 7)
#define AT91C_DMAC_DSCR7        (AT91_CAST(AT91_REG *) 0xFFFFED5C) // (DMAC) DMAC Channel Descriptor Address Register (ch_num = 7)
#define AT91C_DMAC_CTRLA7       (AT91_CAST(AT91_REG *) 0xFFFFED60) // (DMAC) DMAC Channel Control A Register (ch_num = 7)
#define AT91C_DMAC_CTRLB7       (AT91_CAST(AT91_REG *) 0xFFFFED64) // (DMAC) DMAC Channel Control B Register (ch_num = 7)
#define AT91C_DMAC_CFG7         (AT91_CAST(AT91_REG *) 0xFFFFED68) // (DMAC) DMAC Channel Configuration Register (ch_num = 7)
#define AT91C_DMAC_SPIP7        (AT91_CAST(AT91_REG *) 0xFFFFED6C) // (DMAC) DMAC Channel Source Picture in Picture Configuration Register (ch_num = 7)
#define AT91C_DMAC_DPIP7        (AT91_CAST(AT91_REG *) 0xFFFFED70) // (DMAC) DMAC Channel Destination Picture in Picture Configuration Register (ch_num = 7)
// ========== Register definition for DBGU peripheral ==========
#define AT91C_DBGU_CR           (AT91_CAST(AT91_REG *) 0xFFFFEE00) // (DBGU) Control Register
#define AT91C_DBGU_MR           (AT91_CAST(AT91_REG *) 0xFFFFEE04) // (DBGU) Mode Register
#define AT91C_DBGU_IER          (AT91_CAST(AT91_REG *) 0xFFFFEE08) // (DBGU) Interrupt Enable Register
#define AT91C_DBGU_IDR          (AT91_CAST(AT91_REG *) 0xFFFFEE0C) // (DBGU) Interrupt Disable Register
#define AT91C_DBGU_IMR          (AT91_CAST(AT91_REG *) 0xFFFFEE10) // (DBGU) Interrupt Mask Register
#define AT91C_DBGU_SR           (AT91_CAST(AT91_REG *) 0xFFFFEE14) // (DBGU) Status Register
#define AT91C_DBGU_RHR          (AT91_CAST(AT91_REG *) 0xFFFFEE18) // (DBGU) Receive Holding Register
#define AT91C_DBGU_THR          (AT91_CAST(AT91_REG *) 0xFFFFEE1C) // (DBGU) Transmit Holding Register
#define AT91C_DBGU_BRGR         (AT91_CAST(AT91_REG *) 0xFFFFEE20) // (DBGU) Baud Rate Generator Register
#define AT91C_DBGU_CIDR         (AT91_CAST(AT91_REG *) 0xFFFFEE40) // (DBGU) Chip ID Register
#define AT91C_DBGU_EXID         (AT91_CAST(AT91_REG *) 0xFFFFEE44) // (DBGU) Chip ID Extension Register
#define AT91C_DBGU_FNR          (AT91_CAST(AT91_REG *) 0xFFFFEE48) // (DBGU) Force NTRST Register
#define AT91C_DBGU_RPR          (AT91_CAST(AT91_REG *) 0xFFFFEF00) // (DBGU) Receive Pointer Register
#define AT91C_DBGU_RCR          (AT91_CAST(AT91_REG *) 0xFFFFEF04) // (DBGU) Receive Counter Register
#define AT91C_DBGU_TPR          (AT91_CAST(AT91_REG *) 0xFFFFEF08) // (DBGU) Transmit Pointer Register
#define AT91C_DBGU_TCR          (AT91_CAST(AT91_REG *) 0xFFFFEF0C) // (DBGU) Transmit Counter Register
#define AT91C_DBGU_RNPR         (AT91_CAST(AT91_REG *) 0xFFFFEF10) // (DBGU) Receive Next Pointer Register
#define AT91C_DBGU_RNCR         (AT91_CAST(AT91_REG *) 0xFFFFEF14) // (DBGU) Receive Next Counter Register
#define AT91C_DBGU_TNPR         (AT91_CAST(AT91_REG *) 0xFFFFEF18) // (DBGU) Transmit Next Pointer Register
#define AT91C_DBGU_TNCR         (AT91_CAST(AT91_REG *) 0xFFFFEF1C) // (DBGU) Transmit Next Counter Register
#define AT91C_DBGU_PTCR         (AT91_CAST(AT91_REG *) 0xFFFFEF20) // (DBGU) Transfer Control Register
#define AT91C_DBGU_PTSR         (AT91_CAST(AT91_REG *) 0xFFFFEF24) // (DBGU) Transfer Status Register
// ========== Register definition for AIC peripheral ==========
#define AT91C_AIC_SMR           (AT91_CAST(AT91_REG *) 0xFFFFF000) // (AIC) Source Mode Register
#define AT91C_AIC_SVR           (AT91_CAST(AT91_REG *) 0xFFFFF080) // (AIC) Source Vector Register
#define AT91C_AIC_IVR           (AT91_CAST(AT91_REG *) 0xFFFFF100) // (AIC) Interrupt Vector Register
#define AT91C_AIC_FVR           (AT91_CAST(AT91_REG *) 0xFFFFF104) // (AIC) FIQ Interrupt Vector Register
#define AT91C_AIC_ISR           (AT91_CAST(AT91_REG *) 0xFFFFF108) // (AIC) Interrupt Status Register
#define AT91C_AIC_IPR           (AT91_CAST(AT91_REG *) 0xFFFFF10C) // (AIC) Interrupt Pending Register
#define AT91C_AIC_IMR           (AT91_CAST(AT91_REG *) 0xFFFFF110) // (AIC) Interrupt Mask Register
#define AT91C_AIC_CISR          (AT91_CAST(AT91_REG *) 0xFFFFF114) // (AIC) Core Interrupt Status Register
#define AT91C_AIC_IECR          (AT91_CAST(AT91_REG *) 0xFFFFF120) // (AIC) Interrupt Enable Command Register
#define AT91C_AIC_IDCR          (AT91_CAST(AT91_REG *) 0xFFFFF124) // (AIC) Interrupt Disable Command Register
#define AT91C_AIC_ICCR          (AT91_CAST(AT91_REG *) 0xFFFFF128) // (AIC) Interrupt Clear Command Register
#define AT91C_AIC_ISCR          (AT91_CAST(AT91_REG *) 0xFFFFF12C) // (AIC) Interrupt Set Command Register
#define AT91C_AIC_EOICR         (AT91_CAST(AT91_REG *) 0xFFFFF130) // (AIC) End of Interrupt Command Register
#define AT91C_AIC_SPU           (AT91_CAST(AT91_REG *) 0xFFFFF134) // (AIC) Spurious Interrupt Vector Register
#define AT91C_AIC_DCR           (AT91_CAST(AT91_REG *) 0xFFFFF138) // (AIC) Debug Control Register
#define AT91C_AIC_FFER          (AT91_CAST(AT91_REG *) 0xFFFFF140) // (AIC) Fast Forcing Enable Register
#define AT91C_AIC_FFDR          (AT91_CAST(AT91_REG *) 0xFFFFF144) // (AIC) Fast Forcing Disable Register
#define AT91C_AIC_FFSR          (AT91_CAST(AT91_REG *) 0xFFFFF148) // (AIC) Fast Forcing Status Register
// ========== Register definition for PIOA peripheral ==========
#define AT91C_PIOA_PER          (AT91_CAST(AT91_REG *) 0xFFFFF200) // (PIOA) PIO Enable Register
#define AT91C_PIOA_PDR          (AT91_CAST(AT91_REG *) 0xFFFFF204) // (PIOA) PIO Disable Register
#define AT91C_PIOA_PSR          (AT91_CAST(AT91_REG *) 0xFFFFF208) // (PIOA) PIO Status Register
#define AT91C_PIOA_OER          (AT91_CAST(AT91_REG *) 0xFFFFF210) // (PIOA) Output Enable Register
#define AT91C_PIOA_ODR          (AT91_CAST(AT91_REG *) 0xFFFFF214) // (PIOA) Output Disable Register
#define AT91C_PIOA_OSR          (AT91_CAST(AT91_REG *) 0xFFFFF218) // (PIOA) Output Status Register
#define AT91C_PIOA_IFER         (AT91_CAST(AT91_REG *) 0xFFFFF220) // (PIOA) Glitch Input Filter Enable Register
#define AT91C_PIOA_IFDR         (AT91_CAST(AT91_REG *) 0xFFFFF224) // (PIOA) Glitch Input Filter Disable Register
#define AT91C_PIOA_IFSR         (AT91_CAST(AT91_REG *) 0xFFFFF228) // (PIOA) Glitch Input Filter Status Register
#define AT91C_PIOA_SODR         (AT91_CAST(AT91_REG *) 0xFFFFF230) // (PIOA) Set Output Data Register
#define AT91C_PIOA_CODR         (AT91_CAST(AT91_REG *) 0xFFFFF234) // (PIOA) Clear Output Data Register
#define AT91C_PIOA_ODSR         (AT91_CAST(AT91_REG *) 0xFFFFF238) // (PIOA) Output Data Status Register
#define AT91C_PIOA_PDSR         (AT91_CAST(AT91_REG *) 0xFFFFF23C) // (PIOA) Pin Data Status Register
#define AT91C_PIOA_IER          (AT91_CAST(AT91_REG *) 0xFFFFF240) // (PIOA) Interrupt Enable Register
#define AT91C_PIOA_IDR          (AT91_CAST(AT91_REG *) 0xFFFFF244) // (PIOA) Interrupt Disable Register
#define AT91C_PIOA_IMR          (AT91_CAST(AT91_REG *) 0xFFFFF248) // (PIOA) Interrupt Mask Register
#define AT91C_PIOA_ISR          (AT91_CAST(AT91_REG *) 0xFFFFF24C) // (PIOA) Interrupt Status Register
#define AT91C_PIOA_MDER         (AT91_CAST(AT91_REG *) 0xFFFFF250) // (PIOA) Multi-driver Enable Register
#define AT91C_PIOA_MDDR         (AT91_CAST(AT91_REG *) 0xFFFFF254) // (PIOA) Multi-driver Disable Register
#define AT91C_PIOA_MDSR         (AT91_CAST(AT91_REG *) 0xFFFFF258) // (PIOA) Multi-driver Status Register
#define AT91C_PIOA_PUDR         (AT91_CAST(AT91_REG *) 0xFFFFF260) // (PIOA) Pull-up Disable Register
#define AT91C_PIOA_PUER         (AT91_CAST(AT91_REG *) 0xFFFFF264) // (PIOA) Pull-up Enable Register
#define AT91C_PIOA_PUSR         (AT91_CAST(AT91_REG *) 0xFFFFF268) // (PIOA) Pad Pull-up Status Register
#define AT91C_PIOA_ASR          (AT91_CAST(AT91_REG *) 0xFFFFF270) // (PIOA) Peripheral A Select Register
#define AT91C_PIOA_BSR          (AT91_CAST(AT91_REG *) 0xFFFFF274) // (PIOA) Peripheral B Select Register
#define AT91C_PIOA_ABSR         (AT91_CAST(AT91_REG *) 0xFFFFF278) // (PIOA) AB Status Register
#define AT91C_PIOA_OWER         (AT91_CAST(AT91_REG *) 0xFFFFF2A0) // (PIOA) Output Write Enable
#define AT91C_PIOA_OWDR         (AT91_CAST(AT91_REG *) 0xFFFFF2A4) // (PIOA) Output Write Disable
#define AT91C_PIOA_OWSR         (AT91_CAST(AT91_REG *) 0xFFFFF2A8) // (PIOA) Output Write Status Register
// ========== Register definition for PIOB peripheral ==========
#define AT91C_PIOB_PER          (AT91_CAST(AT91_REG *) 0xFFFFF400) // (PIOB) PIO Enable Register
#define AT91C_PIOB_PDR          (AT91_CAST(AT91_REG *) 0xFFFFF404) // (PIOB) PIO Disable Register
#define AT91C_PIOB_PSR          (AT91_CAST(AT91_REG *) 0xFFFFF408) // (PIOB) PIO Status Register
#define AT91C_PIOB_OER          (AT91_CAST(AT91_REG *) 0xFFFFF410) // (PIOB) Output Enable Register
#define AT91C_PIOB_ODR          (AT91_CAST(AT91_REG *) 0xFFFFF414) // (PIOB) Output Disable Register
#define AT91C_PIOB_OSR          (AT91_CAST(AT91_REG *) 0xFFFFF418) // (PIOB) Output Status Register
#define AT91C_PIOB_IFER         (AT91_CAST(AT91_REG *) 0xFFFFF420) // (PIOB) Glitch Input Filter Enable Register
#define AT91C_PIOB_IFDR         (AT91_CAST(AT91_REG *) 0xFFFFF424) // (PIOB) Glitch Input Filter Disable Register
#define AT91C_PIOB_IFSR         (AT91_CAST(AT91_REG *) 0xFFFFF428) // (PIOB) Glitch Input Filter Status Register
#define AT91C_PIOB_SODR         (AT91_CAST(AT91_REG *) 0xFFFFF430) // (PIOB) Set Output Data Register
#define AT91C_PIOB_CODR         (AT91_CAST(AT91_REG *) 0xFFFFF434) // (PIOB) Clear Output Data Register
#define AT91C_PIOB_ODSR         (AT91_CAST(AT91_REG *) 0xFFFFF438) // (PIOB) Output Data Status Register
#define AT91C_PIOB_PDSR         (AT91_CAST(AT91_REG *) 0xFFFFF43C) // (PIOB) Pin Data Status Register
#define AT91C_PIOB_IER          (AT91_CAST(AT91_REG *) 0xFFFFF440) // (PIOB) Interrupt Enable Register
#define AT91C_PIOB_IDR          (AT91_CAST(AT91_REG *) 0xFFFFF444) // (PIOB) Interrupt Disable Register
#define AT91C_PIOB_IMR          (AT91_CAST(AT91_REG *) 0xFFFFF448) // (PIOB) Interrupt Mask Register
#define AT91C_PIOB_ISR          (AT91_CAST(AT91_REG *) 0xFFFFF44C) // (PIOB) Interrupt Status Register
#define AT91C_PIOB_MDER         (AT91_CAST(AT91_REG *) 0xFFFFF450) // (PIOB) Multi-driver Enable Register
#define AT91C_PIOB_MDDR         (AT91_CAST(AT91_REG *) 0xFFFFF454) // (PIOB) Multi-driver Disable Register
#define AT91C_PIOB_MDSR         (AT91_CAST(AT91_REG *) 0xFFFFF458) // (PIOB) Multi-driver Status Register
#define AT91C_PIOB_PUDR         (AT91_CAST(AT91_REG *) 0xFFFFF460) // (PIOB) Pull-up Disable Register
#define AT91C_PIOB_PUER         (AT91_CAST(AT91_REG *) 0xFFFFF464) // (PIOB) Pull-up Enable Register
#define AT91C_PIOB_PUSR         (AT91_CAST(AT91_REG *) 0xFFFFF468) // (PIOB) Pad Pull-up Status Register
#define AT91C_PIOB_ASR          (AT91_CAST(AT91_REG *) 0xFFFFF470) // (PIOB) Peripheral A Select Register
#define AT91C_PIOB_BSR          (AT91_CAST(AT91_REG *) 0xFFFFF474) // (PIOB) Peripheral B Select Register
#define AT91C_PIOB_ABSR         (AT91_CAST(AT91_REG *) 0xFFFFF478) // (PIOB) AB Status Register
#define AT91C_PIOB_OWER         (AT91_CAST(AT91_REG *) 0xFFFFF4A0) // (PIOB) Output Write Enable
#define AT91C_PIOB_OWDR         (AT91_CAST(AT91_REG *) 0xFFFFF4A4) // (PIOB) Output Write Disable
#define AT91C_PIOB_OWSR         (AT91_CAST(AT91_REG *) 0xFFFFF4A8) // (PIOB) Output Write Status Register
// ========== Register definition for PIOC peripheral ==========
#define AT91C_PIOC_PER          (AT91_CAST(AT91_REG *) 0xFFFFF600) // (PIOC) PIO Enable Register
#define AT91C_PIOC_PDR          (AT91_CAST(AT91_REG *) 0xFFFFF604) // (PIOC) PIO Disable Register
#define AT91C_PIOC_PSR          (AT91_CAST(AT91_REG *) 0xFFFFF608) // (PIOC) PIO Status Register
#define AT91C_PIOC_OER          (AT91_CAST(AT91_REG *) 0xFFFFF610) // (PIOC) Output Enable Register
#define AT91C_PIOC_ODR          (AT91_CAST(AT91_REG *) 0xFFFFF614) // (PIOC) Output Disable Register
#define AT91C_PIOC_OSR          (AT91_CAST(AT91_REG *) 0xFFFFF618) // (PIOC) Output Status Register
#define AT91C_PIOC_IFER         (AT91_CAST(AT91_REG *) 0xFFFFF620) // (PIOC) Glitch Input Filter Enable Register
#define AT91C_PIOC_IFDR         (AT91_CAST(AT91_REG *) 0xFFFFF624) // (PIOC) Glitch Input Filter Disable Register
#define AT91C_PIOC_IFSR         (AT91_CAST(AT91_REG *) 0xFFFFF628) // (PIOC) Glitch Input Filter Status Register
#define AT91C_PIOC_SODR         (AT91_CAST(AT91_REG *) 0xFFFFF630) // (PIOC) Set Output Data Register
#define AT91C_PIOC_CODR         (AT91_CAST(AT91_REG *) 0xFFFFF634) // (PIOC) Clear Output Data Register
#define AT91C_PIOC_ODSR         (AT91_CAST(AT91_REG *) 0xFFFFF638) // (PIOC) Output Data Status Register
#define AT91C_PIOC_PDSR         (AT91_CAST(AT91_REG *) 0xFFFFF63C) // (PIOC) Pin Data Status Register
#define AT91C_PIOC_IER          (AT91_CAST(AT91_REG *) 0xFFFFF640) // (PIOC) Interrupt Enable Register
#define AT91C_PIOC_IDR          (AT91_CAST(AT91_REG *) 0xFFFFF644) // (PIOC) Interrupt Disable Register
#define AT91C_PIOC_IMR          (AT91_CAST(AT91_REG *) 0xFFFFF648) // (PIOC) Interrupt Mask Register
#define AT91C_PIOC_ISR          (AT91_CAST(AT91_REG *) 0xFFFFF64C) // (PIOC) Interrupt Status Register
#define AT91C_PIOC_MDER         (AT91_CAST(AT91_REG *) 0xFFFFF650) // (PIOC) Multi-driver Enable Register
#define AT91C_PIOC_MDDR         (AT91_CAST(AT91_REG *) 0xFFFFF654) // (PIOC) Multi-driver Disable Register
#define AT91C_PIOC_MDSR         (AT91_CAST(AT91_REG *) 0xFFFFF658) // (PIOC) Multi-driver Status Register
#define AT91C_PIOC_PUDR         (AT91_CAST(AT91_REG *) 0xFFFFF660) // (PIOC) Pull-up Disable Register
#define AT91C_PIOC_PUER         (AT91_CAST(AT91_REG *) 0xFFFFF664) // (PIOC) Pull-up Enable Register
#define AT91C_PIOC_PUSR         (AT91_CAST(AT91_REG *) 0xFFFFF668) // (PIOC) Pad Pull-up Status Register
#define AT91C_PIOC_ASR          (AT91_CAST(AT91_REG *) 0xFFFFF670) // (PIOC) Peripheral A Select Register
#define AT91C_PIOC_BSR          (AT91_CAST(AT91_REG *) 0xFFFFF674) // (PIOC) Peripheral B Select Register
#define AT91C_PIOC_ABSR         (AT91_CAST(AT91_REG *) 0xFFFFF678) // (PIOC) AB Status Register
#define AT91C_PIOC_OWER         (AT91_CAST(AT91_REG *) 0xFFFFF6A0) // (PIOC) Output Write Enable
#define AT91C_PIOC_OWDR         (AT91_CAST(AT91_REG *) 0xFFFFF6A4) // (PIOC) Output Write Disable
#define AT91C_PIOC_OWSR         (AT91_CAST(AT91_REG *) 0xFFFFF6A8) // (PIOC) Output Write Status Register
// ========== Register definition for PIOD peripheral ==========
#define AT91C_PIOD_PER          (AT91_CAST(AT91_REG *) 0xFFFFF800) // (PIOD) PIO Enable Register
#define AT91C_PIOD_PDR          (AT91_CAST(AT91_REG *) 0xFFFFF804) // (PIOD) PIO Disable Register
#define AT91C_PIOD_PSR          (AT91_CAST(AT91_REG *) 0xFFFFF808) // (PIOD) PIO Status Register
#define AT91C_PIOD_OER          (AT91_CAST(AT91_REG *) 0xFFFFF810) // (PIOD) Output Enable Register
#define AT91C_PIOD_ODR          (AT91_CAST(AT91_REG *) 0xFFFFF814) // (PIOD) Output Disable Register
#define AT91C_PIOD_OSR          (AT91_CAST(AT91_REG *) 0xFFFFF818) // (PIOD) Output Status Register
#define AT91C_PIOD_IFER         (AT91_CAST(AT91_REG *) 0xFFFFF820) // (PIOD) Glitch Input Filter Enable Register
#define AT91C_PIOD_IFDR         (AT91_CAST(AT91_REG *) 0xFFFFF824) // (PIOD) Glitch Input Filter Disable Register
#define AT91C_PIOD_IFSR         (AT91_CAST(AT91_REG *) 0xFFFFF828) // (PIOD) Glitch Input Filter Status Register
#define AT91C_PIOD_SODR         (AT91_CAST(AT91_REG *) 0xFFFFF830) // (PIOD) Set Output Data Register
#define AT91C_PIOD_CODR         (AT91_CAST(AT91_REG *) 0xFFFFF834) // (PIOD) Clear Output Data Register
#define AT91C_PIOD_ODSR         (AT91_CAST(AT91_REG *) 0xFFFFF838) // (PIOD) Output Data Status Register
#define AT91C_PIOD_PDSR         (AT91_CAST(AT91_REG *) 0xFFFFF83C) // (PIOD) Pin Data Status Register
#define AT91C_PIOD_IER          (AT91_CAST(AT91_REG *) 0xFFFFF840) // (PIOD) Interrupt Enable Register
#define AT91C_PIOD_IDR          (AT91_CAST(AT91_REG *) 0xFFFFF844) // (PIOD) Interrupt Disable Register
#define AT91C_PIOD_IMR          (AT91_CAST(AT91_REG *) 0xFFFFF848) // (PIOD) Interrupt Mask Register
#define AT91C_PIOD_ISR          (AT91_CAST(AT91_REG *) 0xFFFFF84C) // (PIOD) Interrupt Status Register
#define AT91C_PIOD_MDER         (AT91_CAST(AT91_REG *) 0xFFFFF850) // (PIOD) Multi-driver Enable Register
#define AT91C_PIOD_MDDR         (AT91_CAST(AT91_REG *) 0xFFFFF854) // (PIOD) Multi-driver Disable Register
#define AT91C_PIOD_MDSR         (AT91_CAST(AT91_REG *) 0xFFFFF858) // (PIOD) Multi-driver Status Register
#define AT91C_PIOD_PUDR         (AT91_CAST(AT91_REG *) 0xFFFFF860) // (PIOD) Pull-up Disable Register
#define AT91C_PIOD_PUER         (AT91_CAST(AT91_REG *) 0xFFFFF864) // (PIOD) Pull-up Enable Register
#define AT91C_PIOD_PUSR         (AT91_CAST(AT91_REG *) 0xFFFFF868) // (PIOD) Pad Pull-up Status Register
#define AT91C_PIOD_ASR          (AT91_CAST(AT91_REG *) 0xFFFFF870) // (PIOD) Peripheral A Select Register
#define AT91C_PIOD_BSR          (AT91_CAST(AT91_REG *) 0xFFFFF874) // (PIOD) Peripheral B Select Register
#define AT91C_PIOD_ABSR         (AT91_CAST(AT91_REG *) 0xFFFFF878) // (PIOD) AB Status Register
#define AT91C_PIOD_OWER         (AT91_CAST(AT91_REG *) 0xFFFFF8A0) // (PIOD) Output Write Enable
#define AT91C_PIOD_OWDR         (AT91_CAST(AT91_REG *) 0xFFFFF8A4) // (PIOD) Output Write Disable
#define AT91C_PIOD_OWSR         (AT91_CAST(AT91_REG *) 0xFFFFF8A8) // (PIOD) Output Write Status Register
// ========== Register definition for PIOE peripheral ==========
#define AT91C_PIOE_PER          (AT91_CAST(AT91_REG *) 0xFFFFFA00) // (PIOE) PIO Enable Register
#define AT91C_PIOE_PDR          (AT91_CAST(AT91_REG *) 0xFFFFFA04) // (PIOE) PIO Disable Register
#define AT91C_PIOE_PSR          (AT91_CAST(AT91_REG *) 0xFFFFFA08) // (PIOE) PIO Status Register
#define AT91C_PIOE_OER          (AT91_CAST(AT91_REG *) 0xFFFFFA10) // (PIOE) Output Enable Register
#define AT91C_PIOE_ODR          (AT91_CAST(AT91_REG *) 0xFFFFFA14) // (PIOE) Output Disable Register
#define AT91C_PIOE_OSR          (AT91_CAST(AT91_REG *) 0xFFFFFA18) // (PIOE) Output Status Register
#define AT91C_PIOE_IFER         (AT91_CAST(AT91_REG *) 0xFFFFFA20) // (PIOE) Glitch Input Filter Enable Register
#define AT91C_PIOE_IFDR         (AT91_CAST(AT91_REG *) 0xFFFFFA24) // (PIOE) Glitch Input Filter Disable Register
#define AT91C_PIOE_IFSR         (AT91_CAST(AT91_REG *) 0xFFFFFA28) // (PIOE) Glitch Input Filter Status Register
#define AT91C_PIOE_SODR         (AT91_CAST(AT91_REG *) 0xFFFFFA30) // (PIOE) Set Output Data Register
#define AT91C_PIOE_CODR         (AT91_CAST(AT91_REG *) 0xFFFFFA34) // (PIOE) Clear Output Data Register
#define AT91C_PIOE_ODSR         (AT91_CAST(AT91_REG *) 0xFFFFFA38) // (PIOE) Output Data Status Register
#define AT91C_PIOE_PDSR         (AT91_CAST(AT91_REG *) 0xFFFFFA3C) // (PIOE) Pin Data Status Register
#define AT91C_PIOE_IER          (AT91_CAST(AT91_REG *) 0xFFFFFA40) // (PIOE) Interrupt Enable Register
#define AT91C_PIOE_IDR          (AT91_CAST(AT91_REG *) 0xFFFFFA44) // (PIOE) Interrupt Disable Register
#define AT91C_PIOE_IMR          (AT91_CAST(AT91_REG *) 0xFFFFFA48) // (PIOE) Interrupt Mask Register
#define AT91C_PIOE_ISR          (AT91_CAST(AT91_REG *) 0xFFFFFA4C) // (PIOE) Interrupt Status Register
#define AT91C_PIOE_MDER         (AT91_CAST(AT91_REG *) 0xFFFFFA50) // (PIOE) Multi-driver Enable Register
#define AT91C_PIOE_MDDR         (AT91_CAST(AT91_REG *) 0xFFFFFA54) // (PIOE) Multi-driver Disable Register
#define AT91C_PIOE_MDSR         (AT91_CAST(AT91_REG *) 0xFFFFFA58) // (PIOE) Multi-driver Status Register
#define AT91C_PIOE_PUDR         (AT91_CAST(AT91_REG *) 0xFFFFFA60) // (PIOE) Pull-up Disable Register
#define AT91C_PIOE_PUER         (AT91_CAST(AT91_REG *) 0xFFFFFA64) // (PIOE) Pull-up Enable Register
#define AT91C_PIOE_PUSR         (AT91_CAST(AT91_REG *) 0xFFFFFA68) // (PIOE) Pad Pull-up Status Register
#define AT91C_PIOE_ASR          (AT91_CAST(AT91_REG *) 0xFFFFFA70) // (PIOE) Peripheral A Select Register
#define AT91C_PIOE_BSR          (AT91_CAST(AT91_REG *) 0xFFFFFA74) // (PIOE) Peripheral B Select Register
#define AT91C_PIOE_ABSR         (AT91_CAST(AT91_REG *) 0xFFFFFA78) // (PIOE) AB Status Register
#define AT91C_PIOE_OWER         (AT91_CAST(AT91_REG *) 0xFFFFFAA0) // (PIOE) Output Write Enable
#define AT91C_PIOE_OWDR         (AT91_CAST(AT91_REG *) 0xFFFFFAA4) // (PIOE) Output Write Disable
#define AT91C_PIOE_OWSR         (AT91_CAST(AT91_REG *) 0xFFFFFAA8) // (PIOE) Output Write Status Register
// ========== Register definition for PMC peripheral ==========
#define AT91C_PMC_SCER          (AT91_CAST(AT91_REG *) 0xFFFFFC00) // (PMC) System Clock Enable Register
#define AT91C_PMC_SCDR          (AT91_CAST(AT91_REG *) 0xFFFFFC04) // (PMC) System Clock Disable Register
#define AT91C_PMC_SCSR          (AT91_CAST(AT91_REG *) 0xFFFFFC08) // (PMC) System Clock Status Register
#define AT91C_PMC_PCER          (AT91_CAST(AT91_REG *) 0xFFFFFC10) // (PMC) Peripheral Clock Enable Register
#define AT91C_PMC_PCDR          (AT91_CAST(AT91_REG *) 0xFFFFFC14) // (PMC) Peripheral Clock Disable Register
#define AT91C_PMC_PCSR          (AT91_CAST(AT91_REG *) 0xFFFFFC18) // (PMC) Peripheral Clock Status Register
#define AT91C_PMC_UCKR          (AT91_CAST(AT91_REG *) 0xFFFFFC1C) // (PMC) UTMI Clock Register
#define AT91C_PMC_MOR           (AT91_CAST(AT91_REG *) 0xFFFFFC20) // (PMC) Main Oscillator Register
#define AT91C_PMC_MCFR          (AT91_CAST(AT91_REG *) 0xFFFFFC24) // (PMC) Main Clock Frequency Register
#define AT91C_PMC_PLLAR         (AT91_CAST(AT91_REG *) 0xFFFFFC28) // (PMC) PLLA Register
#define AT91C_PMC_MCKR          (AT91_CAST(AT91_REG *) 0xFFFFFC30) // (PMC) Master Clock Register
#define AT91C_PMC_USB           (AT91_CAST(AT91_REG *) 0xFFFFFC38) // (PMC) USB Clock Register
#define AT91C_PMC_PCK           (AT91_CAST(AT91_REG *) 0xFFFFFC40) // (PMC) Programmable Clock 0 Register
#define AT91C_PMC_IER           (AT91_CAST(AT91_REG *) 0xFFFFFC60) // (PMC) Interrupt Enable Register
#define AT91C_PMC_IDR           (AT91_CAST(AT91_REG *) 0xFFFFFC64) // (PMC) Interrupt Disable Register
#define AT91C_PMC_SR            (AT91_CAST(AT91_REG *) 0xFFFFFC68) // (PMC) Status Register
#define AT91C_PMC_IMR           (AT91_CAST(AT91_REG *) 0xFFFFFC6C) // (PMC) Interrupt Mask Register
// ========== Register definition for RSTC peripheral ==========
#define AT91C_RSTC_CR           (AT91_CAST(AT91_REG *) 0xFFFFFD00) // (RSTC) Control Register
#define AT91C_RSTC_SR           (AT91_CAST(AT91_REG *) 0xFFFFFD04) // (RSTC) Status Register
#define AT91C_RSTC_MR           (AT91_CAST(AT91_REG *) 0xFFFFFD08) // (RSTC) Mode Register
// ========== Register definition for SHDWC peripheral ==========
#define AT91C_SHDWC_CR          (AT91_CAST(AT91_REG *) 0xFFFFFD10) // (SHDWC) Shutdown Control Register
#define AT91C_SHDWC_MR          (AT91_CAST(AT91_REG *) 0xFFFFFD14) // (SHDWC) Shutdown Mode Register
#define AT91C_SHDWC_SR          (AT91_CAST(AT91_REG *) 0xFFFFFD18) // (SHDWC) Shutdown Status Register
// ========== Register definition for RTT peripheral ==========
#define AT91C_RTT_MR            (AT91_CAST(AT91_REG *) 0xFFFFFD20) // (RTT) Mode Register
#define AT91C_RTT_AR            (AT91_CAST(AT91_REG *) 0xFFFFFD24) // (RTT) Alarm Register
#define AT91C_RTT_VR            (AT91_CAST(AT91_REG *) 0xFFFFFD28) // (RTT) Value Register
#define AT91C_RTT_SR            (AT91_CAST(AT91_REG *) 0xFFFFFD2C) // (RTT) Status Register
// ========== Register definition for PIT peripheral ==========
#define AT91C_PIT_MR            (AT91_CAST(AT91_REG *) 0xFFFFFD30) // (PIT) Mode Register
#define AT91C_PIT_SR            (AT91_CAST(AT91_REG *) 0xFFFFFD34) // (PIT) Status Register
#define AT91C_PIT_PIVR          (AT91_CAST(AT91_REG *) 0xFFFFFD38) // (PIT) Periodic Interval Value Register
#define AT91C_PIT_PIIR          (AT91_CAST(AT91_REG *) 0xFFFFFD3C) // (PIT) Periodic Interval Image Register
// ========== Register definition for WDT peripheral ==========
#define AT91C_WDT_CR            (AT91_CAST(AT91_REG *) 0xFFFFFD40) // (WDT) Control Register
#define AT91C_WDT_MR            (AT91_CAST(AT91_REG *) 0xFFFFFD44) // (WDT) Mode Register
#define AT91C_WDT_SR            (AT91_CAST(AT91_REG *) 0xFFFFFD48) // (WDT) Status Register
// ========== Register definition for GPBR peripheral ==========
#define AT91C_GPBR_GPBR0        (AT91_CAST(AT91_REG *) 0xFFFFFD60) // (GPBR) General Purpose Backup Register 0
#define AT91C_GPBR_GPBR1        (AT91_CAST(AT91_REG *) 0xFFFFFD64) // (GPBR) General Purpose Backup Register 1
#define AT91C_GPBR_GPBR2        (AT91_CAST(AT91_REG *) 0xFFFFFD68) // (GPBR) General Purpose Backup Register 2
#define AT91C_GPBR_GPBR3        (AT91_CAST(AT91_REG *) 0xFFFFFD6C) // (GPBR) General Purpose Backup Register 3
// ========== Register definition for RTC peripheral ==========
#define AT91C_RTC_CR            (AT91_CAST(AT91_REG *) 0xFFFFFD80) // (RTC) Control Register
#define AT91C_RTC_MR            (AT91_CAST(AT91_REG *) 0xFFFFFD84) // (RTC) Mode Register
#define AT91C_RTC_TIMR          (AT91_CAST(AT91_REG *) 0xFFFFFD88) // (RTC) Time Register
#define AT91C_RTC_CALR          (AT91_CAST(AT91_REG *) 0xFFFFFD8C) // (RTC) Calendar Register
#define AT91C_RTC_TIMALR        (AT91_CAST(AT91_REG *) 0xFFFFFD90) // (RTC) Time Alarm Register
#define AT91C_RTC_CALALR        (AT91_CAST(AT91_REG *) 0xFFFFFD94) // (RTC) Calendar Alarm Register
#define AT91C_RTC_SR            (AT91_CAST(AT91_REG *) 0xFFFFFD98) // (RTC) Status Register
#define AT91C_RTC_SCCR          (AT91_CAST(AT91_REG *) 0xFFFFFD9C) // (RTC) Status Clear Command Register
#define AT91C_RTC_IER           (AT91_CAST(AT91_REG *) 0xFFFFFDA0) // (RTC) Interrupt Enable Register
#define AT91C_RTC_IDR           (AT91_CAST(AT91_REG *) 0xFFFFFDA4) // (RTC) Interrupt Disable Register
#define AT91C_RTC_IMR           (AT91_CAST(AT91_REG *) 0xFFFFFDA8) // (RTC) Interrupt Mask Register
#define AT91C_RTC_VER           (AT91_CAST(AT91_REG *) 0xFFFFFDAC) // (RTC) Valid Entry Register

// *****************************************************************************
//   PERIPHERAL ID DEFINITIONS FOR AT91SAM9M11
// *****************************************************************************

#define AT91C_ID_FIQ          ( 0) // Advanced Interrupt Controller (FIQ)
#define AT91C_ID_SYS          ( 1) // System Controller Interrupt (SYS)
#define AT91C_ID_PIOA         ( 2) // Parallel I/O Controller A (PIOA)
#define AT91C_ID_PIOB         ( 3) // Parallel I/O Controller B (PIOB)
#define AT91C_ID_PIOC         ( 4) // Parallel I/O Controller C (PIOC)
#define AT91C_ID_PIODE        ( 5) // Parallel I/O Controller D + Parallel I/O Controller E (PIODE)
#define AT91C_ID_TRNG         ( 6) // True Random Number Generator (TRNG)
#define AT91C_ID_USART0       ( 7) // USART 0 (USART0)
#define AT91C_ID_USART1       ( 8) // USART 1 (USART1)
#define AT91C_ID_USART2       ( 9) // USART 2 (USART2)
#define AT91C_ID_USART3       (10) // USART 3 (USART3)
#define AT91C_ID_MCI0         (11) // High Speed Multimedia Card Interface 0 (MCI0)
#define AT91C_ID_TWI0         (12) // Two-Wire Interface 0 (TWI0)
#define AT91C_ID_TWI1         (13) // Two-Wire Interface 1 (TWI1)
#define AT91C_ID_SPI0         (14) // Serial Peripheral Interface (SPI0)
#define AT91C_ID_SPI1         (15) // Serial Peripheral Interface (SPI1)
#define AT91C_ID_SSC0         (16) // Synchronous Serial Controller 0 (SSC0)
#define AT91C_ID_SSC1         (17) // Synchronous Serial Controller 1 (SSC1)
#define AT91C_ID_TC05         (18) // Timer Counter 0 + Timer Counter 1 + Timer Counter 2 + Timer Counter 3 + Timer Counter 4 + Timer Counter 5 (TC05)
#define AT91C_ID_PWM          (19) // Pulse Width Modulation Controller (PWM)
#define AT91C_ID_TSADCC       (20) // Touch Screen ADC Controller (TSADCC)
//#define AT91C_ID_DMAC         (21) // DMA Controller (DMAC)
#define AT91C_ID_HDMA         (21) // HDMA
#define AT91C_ID_UHPHS        (22) // USB Host High Speed (UHPHS)
#define AT91C_ID_LCDC         (23) // LCD Controller (LCDC)
#define AT91C_ID_AC97C        (24) // AC97 Controller (AC97C)
#define AT91C_ID_EMAC         (25) // Ethernet MAC (EMAC)
#define AT91C_ID_ISI          (26) // Image Sensor Interface (ISI)
#define AT91C_ID_UDPHS        (27) // USB Device High Speed (UDPHS)
#define AT91C_ID_AES_TDES_SHA (28) // Advanced Encryption Standard + Triple Data Encryption Standard + Secure Hash Algorithm (AES_TDES_SHA)
#define AT91C_ID_MCI1         (29) // High Speed Multimedia Card Interface 1 (MCI1)
#define AT91C_ID_VDEC         (30) // Video Decoder (VDEC)
#define AT91C_ID_IRQ          (31) // Advanced Interrupt Controller (IRQ)

// *****************************************************************************
//   BASE ADDRESS DEFINITIONS FOR AT91SAM9M11
// *****************************************************************************

#define AT91C_BASE_LCDC       (AT91_CAST(AT91PS_LCDC      ) 0x00500000) // (LCDC      ) Base Address
#define AT91C_BASE_UDPHS_FIFO    (AT91_CAST(unsigned int *) 0x00600000) // (UDPHS FIFO    ) Base Address
#define AT91C_BASE_UHP_OHCI_FIFO (AT91_CAST(unsigned int *) 0x00700000) // (UHP_OHCI      ) Base Address
#define AT91C_BASE_UHP_EHCI_FIFO (AT91_CAST(unsigned int *) 0x00800000) // (UHP_EHCI      ) Base Address
#define AT91C_BASE_UDPHS      (AT91_CAST(AT91PS_UDPHS     ) 0xFFF78000) // (UDPHS     ) Base Address
#define AT91C_BASE_TC0        (AT91_CAST(AT91PS_TC        ) 0xFFF7C000) // (TC0       ) Base Address
#define AT91C_BASE_MCI0       (AT91_CAST(AT91PS_MCI       ) 0xFFF80000) // (MCI0      ) Base Address
#define AT91C_BASE_TWI0       (AT91_CAST(AT91PS_TWI       ) 0xFFF84000) // (TWI0      ) Base Address
#define AT91C_BASE_TWI1       (AT91_CAST(AT91PS_TWI       ) 0xFFF88000) // (TWI1      ) Base Address
#define AT91C_BASE_USART0     (AT91_CAST(AT91PS_USART     ) 0xFFF8C000) // (USART0    ) Base Address
#define AT91C_BASE_PDC_USART0 (AT91_CAST(AT91PS_PDC       ) 0xFFF8C100) // (PDC_USART0) Base Address
#define AT91C_BASE_USART1     (AT91_CAST(AT91PS_USART     ) 0xFFF90000) // (USART1    ) Base Address
#define AT91C_BASE_PDC_USART1 (AT91_CAST(AT91PS_PDC       ) 0xFFF90100) // (PDC_USART1) Base Address
#define AT91C_BASE_USART2     (AT91_CAST(AT91PS_USART     ) 0xFFF94000) // (USART2    ) Base Address
#define AT91C_BASE_PDC_USART2 (AT91_CAST(AT91PS_PDC       ) 0xFFF94100) // (PDC_USART2) Base Address
#define AT91C_BASE_USART3     (AT91_CAST(AT91PS_USART     ) 0xFFF98000) // (USART3    ) Base Address
#define AT91C_BASE_PDC_USART3 (AT91_CAST(AT91PS_PDC       ) 0xFFF98100) // (PDC_USART3) Base Address
#define AT91C_BASE_SSC0       (AT91_CAST(AT91PS_SSC       ) 0xFFF9C000) // (SSC0      ) Base Address
#define AT91C_BASE_PDC_SSC0   (AT91_CAST(AT91PS_PDC       ) 0xFFF9C100) // (PDC_SSC0  ) Base Address
#define AT91C_BASE_SSC1       (AT91_CAST(AT91PS_SSC       ) 0xFFFA0000) // (SSC1      ) Base Address
#define AT91C_BASE_PDC_SSC1   (AT91_CAST(AT91PS_PDC       ) 0xFFFA0100) // (PDC_SSC1  ) Base Address
#define AT91C_BASE_SPI0       (AT91_CAST(AT91PS_SPI       ) 0xFFFA4000) // (SPI0      ) Base Address
#define AT91C_BASE_PDC_SPI0   (AT91_CAST(AT91PS_PDC       ) 0xFFFA4100) // (PDC_SPI0  ) Base Address
#define AT91C_BASE_SPI1       (AT91_CAST(AT91PS_SPI       ) 0xFFFA8000) // (SPI1      ) Base Address
#define AT91C_BASE_PDC_SPI1   (AT91_CAST(AT91PS_PDC       ) 0xFFFA8100) // (PDC_SPI1  ) Base Address
#define AT91C_BASE_AC97C      (AT91_CAST(AT91PS_AC97C     ) 0xFFFAC000) // (AC97C     ) Base Address
#define AT91C_BASE_PDC_AC97C  (AT91_CAST(AT91PS_PDC       ) 0xFFFAC100) // (PDC_AC97C ) Base Address
#define AT91C_BASE_TSADCC     (AT91_CAST(AT91PS_TSADCC    ) 0xFFFB0000) // (TSADCC    ) Base Address
#define AT91C_BASE_PDC_TSADCC (AT91_CAST(AT91PS_PDC       ) 0xFFFB0100) // (PDC_TSADCC) Base Address
#define AT91C_BASE_ISI        (AT91_CAST(AT91PS_ISI       ) 0xFFFB4000) // (ISI       ) Base Address
#define AT91C_BASE_PWM        (AT91_CAST(AT91PS_PWM       ) 0xFFFB8000) // (PWM       ) Base Address
#define AT91C_BASE_EMAC       (AT91_CAST(AT91PS_EMAC      ) 0xFFFBC000) // (EMAC      ) Base Address
#define AT91C_BASE_AES        (AT91_CAST(AT91PS_AES       ) 0xFFFC0000) // (AES       ) Base Address
#define AT91C_BASE_TDES       (AT91_CAST(AT91PS_TDES      ) 0xFFFC4000) // (TDES      ) Base Address
#define AT91C_BASE_PDC_TDES   (AT91_CAST(AT91PS_PDC       ) 0xFFFC4100) // (PDC_TDES  ) Base Address
#define AT91C_BASE_SHA        (AT91_CAST(AT91PS_SHA       ) 0xFFFC8000) // (SHA       ) Base Address
#define AT91C_BASE_PDC_SHA    (AT91_CAST(AT91PS_PDC       ) 0xFFFC8100) // (PDC_SHA   ) Base Address
#define AT91C_BASE_TRNG       (AT91_CAST(AT91PS_TRNG      ) 0xFFFCC000) // (TRNG      ) Base Address
#define AT91C_BASE_MCI1       (AT91_CAST(AT91PS_MCI       ) 0xFFFD0000) // (MCI1      ) Base Address
#define AT91C_BASE_TC1        (AT91_CAST(AT91PS_TC        ) 0xFFFD4000) // (TC1       ) Base Address
#define AT91C_BASE_DDRSDRC1   (AT91_CAST(AT91PS_DDRSDRC   ) 0xFFFFE400) // (DDRSDRC1  ) Base Address
#define AT91C_BASE_DDRSDRC0   (AT91_CAST(AT91PS_DDRSDRC   ) 0xFFFFE600) // (DDRSDRC0  ) Base Address
#define AT91C_BASE_SMC        (AT91_CAST(AT91PS_SMC       ) 0xFFFFE800) // (SMC       ) Base Address
#define AT91C_BASE_MATRIX     (AT91_CAST(AT91PS_MATRIX    ) 0xFFFFEA00) // (MATRIX    ) Base Address
//#define AT91C_BASE_DMAC       (AT91_CAST(AT91PS_DMAC      ) 0xFFFFEC00) // (DMAC      ) Base Address
#define AT91C_BASE_HDMA      (AT91_CAST(AT91PS_HDMA)    0xFFFFEC00) // (HDMA) Base Address
#define AT91C_BASE_HDMA_CH_0 (AT91_CAST(AT91PS_HDMA_CH)     0xFFFFEC3C) // (HDMA_CH_0) Base Address
#define AT91C_BASE_HDMA_CH_1 (AT91_CAST(AT91PS_HDMA_CH)     0xFFFFEC64) // (HDMA_CH_1) Base Address
#define AT91C_BASE_HDMA_CH_2 (AT91_CAST(AT91PS_HDMA_CH)     0xFFFFEC8C) // (HDMA_CH_2) Base Address
#define AT91C_BASE_HDMA_CH_3 (AT91_CAST(AT91PS_HDMA_CH)     0xFFFFECB4) // (HDMA_CH_3) Base Address
#define AT91C_BASE_HDMA_CH_4 (AT91_CAST(AT91PS_HDMA_CH)     0xFFFFECDC) // (HDMA_CH_4) Base Address
#define AT91C_BASE_HDMA_CH_5 (AT91_CAST(AT91PS_HDMA_CH)     0xFFFFED04) // (HDMA_CH_5) Base Address
#define AT91C_BASE_HDMA_CH_6 (AT91_CAST(AT91PS_HDMA_CH)     0xFFFFED2C) // (HDMA_CH_6) Base Address
#define AT91C_BASE_HDMA_CH_7 (AT91_CAST(AT91PS_HDMA_CH)     0xFFFFED54) // (HDMA_CH_7) Base Address
#define AT91C_BASE_DBGU       (AT91_CAST(AT91PS_DBGU      ) 0xFFFFEE00) // (DBGU      ) Base Address
#define AT91C_BASE_PDC_DBGU   (AT91_CAST(AT91PS_PDC       ) 0xFFFFEF00) // (PDC_DBGU  ) Base Address
#define AT91C_BASE_AIC        (AT91_CAST(AT91PS_AIC       ) 0xFFFFF000) // (AIC       ) Base Address
#define AT91C_BASE_PIOA       (AT91_CAST(AT91PS_PIO       ) 0xFFFFF200) // (PIOA      ) Base Address
#define AT91C_BASE_PIOB       (AT91_CAST(AT91PS_PIO       ) 0xFFFFF400) // (PIOB      ) Base Address
#define AT91C_BASE_PIOC       (AT91_CAST(AT91PS_PIO       ) 0xFFFFF600) // (PIOC      ) Base Address
#define AT91C_BASE_PIOD       (AT91_CAST(AT91PS_PIO       ) 0xFFFFF800) // (PIOD      ) Base Address
#define AT91C_BASE_PIOE       (AT91_CAST(AT91PS_PIO       ) 0xFFFFFA00) // (PIOE      ) Base Address
#define AT91C_BASE_PMC        (AT91_CAST(AT91PS_PMC       ) 0xFFFFFC00) // (PMC       ) Base Address
#define AT91C_BASE_RSTC       (AT91_CAST(AT91PS_RSTC      ) 0xFFFFFD00) // (RSTC      ) Base Address
#define AT91C_BASE_SHDWC      (AT91_CAST(AT91PS_SHDWC     ) 0xFFFFFD10) // (SHDWC     ) Base Address
#define AT91C_BASE_RTT        (AT91_CAST(AT91PS_RTT       ) 0xFFFFFD20) // (RTT       ) Base Address
#define AT91C_BASE_PIT        (AT91_CAST(AT91PS_PIT       ) 0xFFFFFD30) // (PIT       ) Base Address
#define AT91C_BASE_WDT        (AT91_CAST(AT91PS_WDT       ) 0xFFFFFD40) // (WDT       ) Base Address
#define AT91C_BASE_GPBR       (AT91_CAST(AT91PS_GPBR      ) 0xFFFFFD60) // (GPBR      ) Base Address
#define AT91C_BASE_RTC        (AT91_CAST(AT91PS_RTC       ) 0xFFFFFD80) // (RTC       ) Base Address

// *****************************************************************************
//   PIO DEFINITIONS FOR AT91SAM9M11
// *****************************************************************************

#define AT91C_PIO_PC0          (1 << 0) // Pin Controlled by PC0
#define AT91C_PC0_DQM2         (AT91C_PIO_PC0)
#define AT91C_PIO_PC1          (1 << 1) // Pin Controlled by PC1
#define AT91C_PC1_DQM3         (AT91C_PIO_PC1)
#define AT91C_PIO_PC2          (1 << 2) // Pin Controlled by PC2
#define AT91C_PC2_A19          (AT91C_PIO_PC2)
#define AT91C_PIO_PC3          (1 << 3) // Pin Controlled by PC3
#define AT91C_PC3_A20          (AT91C_PIO_PC3)
#define AT91C_PIO_PC4          (1 << 4) // Pin Controlled by PC4
#define AT91C_PC4_A21_NANDALE  (AT91C_PIO_PC4)
#define AT91C_PIO_PC5          (1 << 5) // Pin Controlled by PC5
#define AT91C_PC5_A22_NANDCLE  (AT91C_PIO_PC5)
#define AT91C_PIO_PC6          (1 << 6) // Pin Controlled by PC6
#define AT91C_PC6_A23          (AT91C_PIO_PC6)
#define AT91C_PIO_PC7          (1 << 7) // Pin Controlled by PC7
#define AT91C_PC7_A24          (AT91C_PIO_PC7)
#define AT91C_PIO_PC8          (1 << 8) // Pin Controlled by PC8
#define AT91C_PC8_CFCE1        (AT91C_PIO_PC8)
#define AT91C_PIO_PC9          (1 << 9) // Pin Controlled by PC9
#define AT91C_PC9_CFCE2        (AT91C_PIO_PC9)
#define AT91C_PC9_RTS2         (AT91C_PIO_PC9)
#define AT91C_PIO_PC10         (1 << 10) // Pin Controlled by PC10
#define AT91C_PC10_NCS4_CFCS0  (AT91C_PIO_PC10)
#define AT91C_PC10_TCLK2       (AT91C_PIO_PC10)
#define AT91C_PIO_PC11         (1 << 11) // Pin Controlled by PC11
#define AT91C_PC11_NCS5_CFCS1  (AT91C_PIO_PC11)
#define AT91C_PC11_CTS2        (AT91C_PIO_PC11)
#define AT91C_PIO_PC12         (1 << 12) // Pin Controlled by PC12
#define AT91C_PC12_A25_CFRNW   (AT91C_PIO_PC12)
#define AT91C_PIO_PC13         (1 << 13) // Pin Controlled by PC13
#define AT91C_PC13_NCS2        (AT91C_PIO_PC13)
#define AT91C_PIO_PC14         (1 << 14) // Pin Controlled by PC14
#define AT91C_PC14_NCS3_NANDCS (AT91C_PIO_PC14)
#define AT91C_PIO_PC15         (1 << 15) // Pin Controlled by PC15
#define AT91C_PC15_NWAIT       (AT91C_PIO_PC15)
#define AT91C_PIO_PC16         (1 << 16) // Pin Controlled by PC16
#define AT91C_PC16_D16         (AT91C_PIO_PC16)
#define AT91C_PIO_PC17         (1 << 17) // Pin Controlled by PC17
#define AT91C_PC17_D17         (AT91C_PIO_PC17)
#define AT91C_PIO_PC18         (1 << 18) // Pin Controlled by PC18
#define AT91C_PC18_D18         (AT91C_PIO_PC18)
#define AT91C_PIO_PC19         (1 << 19) // Pin Controlled by PC19
#define AT91C_PC19_D19         (AT91C_PIO_PC19)
#define AT91C_PIO_PC20         (1 << 20) // Pin Controlled by PC20
#define AT91C_PC20_D20         (AT91C_PIO_PC20)
#define AT91C_PIO_PC21         (1 << 21) // Pin Controlled by PC21
#define AT91C_PC21_D21         (AT91C_PIO_PC21)
#define AT91C_PIO_PC22         (1 << 22) // Pin Controlled by PC22
#define AT91C_PC22_D22         (AT91C_PIO_PC22)
#define AT91C_PIO_PC23         (1 << 23) // Pin Controlled by PC23
#define AT91C_PC23_D23         (AT91C_PIO_PC23)
#define AT91C_PIO_PC24         (1 << 24) // Pin Controlled by PC24
#define AT91C_PC24_D24         (AT91C_PIO_PC24)
#define AT91C_PIO_PC25         (1 << 25) // Pin Controlled by PC25
#define AT91C_PC25_D25         (AT91C_PIO_PC25)
#define AT91C_PIO_PC26         (1 << 26) // Pin Controlled by PC26
#define AT91C_PC26_D26         (AT91C_PIO_PC26)
#define AT91C_PIO_PC27         (1 << 27) // Pin Controlled by PC27
#define AT91C_PC27_D27         (AT91C_PIO_PC27)
#define AT91C_PIO_PC28         (1 << 28) // Pin Controlled by PC28
#define AT91C_PC28_D28         (AT91C_PIO_PC28)
#define AT91C_PIO_PC29         (1 << 29) // Pin Controlled by PC29
#define AT91C_PC29_D29         (AT91C_PIO_PC29)
#define AT91C_PIO_PC30         (1 << 30) // Pin Controlled by PC30
#define AT91C_PC30_D30         (AT91C_PIO_PC30)
#define AT91C_PIO_PC31         (1 << 31) // Pin Controlled by PC31
#define AT91C_PC31_D31         (AT91C_PIO_PC31)
#define AT91C_PIO_PA0          (1 << 0) // Pin Controlled by PA0
#define AT91C_PA0_MCI0_CK      (AT91C_PIO_PA0)
#define AT91C_PA0_TCLK3        (AT91C_PIO_PA0)
#define AT91C_PIO_PA1          (1 << 1) // Pin Controlled by PA1
#define AT91C_PA1_MCI0_CDA     (AT91C_PIO_PA1)
#define AT91C_PA1_TIOA3        (AT91C_PIO_PA1)
#define AT91C_PIO_PA2          (1 << 2) // Pin Controlled by PA2
#define AT91C_PA2_MCI0_DA0     (AT91C_PIO_PA2)
#define AT91C_PA2_TIOB3        (AT91C_PIO_PA2)
#define AT91C_PIO_PA3          (1 << 3) // Pin Controlled by PA3
#define AT91C_PA3_MCI0_DA1     (AT91C_PIO_PA3)
#define AT91C_PA3_TCLK4        (AT91C_PIO_PA3)
#define AT91C_PIO_PA4          (1 << 4) // Pin Controlled by PA4
#define AT91C_PA4_MCI0_DA2     (AT91C_PIO_PA4)
#define AT91C_PA4_TIOA4        (AT91C_PIO_PA4)
#define AT91C_PIO_PA5          (1 << 5) // Pin Controlled by PA5
#define AT91C_PA5_MCI0_DA3     (AT91C_PIO_PA5)
#define AT91C_PA5_TIOB4        (AT91C_PIO_PA5)
#define AT91C_PIO_PA6          (1 << 6) // Pin Controlled by PA6
#define AT91C_PA6_MCI0_DA4     (AT91C_PIO_PA6)
#define AT91C_PA6_ETX2         (AT91C_PIO_PA6)
#define AT91C_PIO_PA7          (1 << 7) // Pin Controlled by PA7
#define AT91C_PA7_MCI0_DA5     (AT91C_PIO_PA7)
#define AT91C_PA7_ETX3         (AT91C_PIO_PA7)
#define AT91C_PIO_PA8          (1 << 8) // Pin Controlled by PA8
#define AT91C_PA8_MCI0_DA6     (AT91C_PIO_PA8)
#define AT91C_PA8_ERX2         (AT91C_PIO_PA8)
#define AT91C_PIO_PA9          (1 << 9) // Pin Controlled by PA9
#define AT91C_PA9_MCI0_DA7     (AT91C_PIO_PA9)
#define AT91C_PA9_ERX3         (AT91C_PIO_PA9)
#define AT91C_PIO_PA10         (1 << 10) // Pin Controlled by PA10
#define AT91C_PA10_ETX0        (AT91C_PIO_PA10)
#define AT91C_PIO_PA11         (1 << 11) // Pin Controlled by PA11
#define AT91C_PA11_ETX1        (AT91C_PIO_PA11)
#define AT91C_PIO_PA12         (1 << 12) // Pin Controlled by PA12
#define AT91C_PA12_ERX0        (AT91C_PIO_PA12)
#define AT91C_PIO_PA13         (1 << 13) // Pin Controlled by PA13
#define AT91C_PA13_ERX1        (AT91C_PIO_PA13)
#define AT91C_PIO_PA14         (1 << 14) // Pin Controlled by PA14
#define AT91C_PA14_ETXEN       (AT91C_PIO_PA14)
#define AT91C_PIO_PA15         (1 << 15) // Pin Controlled by PA15
#define AT91C_PA15_ERXDV       (AT91C_PIO_PA15)
#define AT91C_PIO_PA16         (1 << 16) // Pin Controlled by PA16
#define AT91C_PA16_ERXER       (AT91C_PIO_PA16)
#define AT91C_PIO_PA17         (1 << 17) // Pin Controlled by PA17
#define AT91C_PA17_ETXCK       (AT91C_PIO_PA17)
#define AT91C_PIO_PA18         (1 << 18) // Pin Controlled by PA18
#define AT91C_PA18_EMDC        (AT91C_PIO_PA18)
#define AT91C_PIO_PA19         (1 << 19) // Pin Controlled by PA19
#define AT91C_PA19_EMDIO       (AT91C_PIO_PA19)
#define AT91C_PIO_PA20         (1 << 20) // Pin Controlled by PA20
#define AT91C_PA20_TWD0        (AT91C_PIO_PA20)
#define AT91C_PIO_PA21         (1 << 21) // Pin Controlled by PA21
#define AT91C_PA21_TWCK0       (AT91C_PIO_PA21)
#define AT91C_PIO_PA22         (1 << 22) // Pin Controlled by PA22
#define AT91C_PA22_MCI1_CDA    (AT91C_PIO_PA22)
#define AT91C_PA22_SCK3        (AT91C_PIO_PA22)
#define AT91C_PIO_PA23         (1 << 23) // Pin Controlled by PA23
#define AT91C_PA23_MCI1_DA0    (AT91C_PIO_PA23)
#define AT91C_PA23_RTS3        (AT91C_PIO_PA23)
#define AT91C_PIO_PA24         (1 << 24) // Pin Controlled by PA24
#define AT91C_PA24_MCI1_DA1    (AT91C_PIO_PA24)
#define AT91C_PA24_CTS3        (AT91C_PIO_PA24)
#define AT91C_PIO_PA25         (1 << 25) // Pin Controlled by PA25
#define AT91C_PA25_MCI1_DA2    (AT91C_PIO_PA25)
#define AT91C_PA25_PWM3        (AT91C_PIO_PA25)
#define AT91C_PIO_PA26         (1 << 26) // Pin Controlled by PA26
#define AT91C_PA26_MCI1_DA3    (AT91C_PIO_PA26)
#define AT91C_PA26_TIOB2       (AT91C_PIO_PA26)
#define AT91C_PIO_PA27         (1 << 27) // Pin Controlled by PA27
#define AT91C_PA27_MCI1_DA4    (AT91C_PIO_PA27)
#define AT91C_PA27_ETXER       (AT91C_PIO_PA27)
#define AT91C_PIO_PA28         (1 << 28) // Pin Controlled by PA28
#define AT91C_PA28_MCI1_DA5    (AT91C_PIO_PA28)
#define AT91C_PA28_ERXCK       (AT91C_PIO_PA28)
#define AT91C_PIO_PA29         (1 << 29) // Pin Controlled by PA29
#define AT91C_PA29_MCI1_DA6    (AT91C_PIO_PA29)
#define AT91C_PA29_ECRS        (AT91C_PIO_PA29)
#define AT91C_PIO_PA30         (1 << 30) // Pin Controlled by PA30
#define AT91C_PA30_MCI1_DA7    (AT91C_PIO_PA30)
#define AT91C_PA30_ECOL        (AT91C_PIO_PA30)
#define AT91C_PIO_PA31         (1 << 31) // Pin Controlled by PA31
#define AT91C_PA31_MCI1_CK     (AT91C_PIO_PA31)
#define AT91C_PA31_PCK0        (AT91C_PIO_PA31)
#define AT91C_PIO_PB0          (1 << 0) // Pin Controlled by PB0
#define AT91C_PB0_SPI0_MISO    (AT91C_PIO_PB0)
#define AT91C_PIO_PB1          (1 << 1) // Pin Controlled by PB1
#define AT91C_PB1_SPI0_MOSI    (AT91C_PIO_PB1)
#define AT91C_PIO_PB2          (1 << 2) // Pin Controlled by PB2
#define AT91C_PB2_SPI0_SPCK    (AT91C_PIO_PB2)
#define AT91C_PIO_PB3          (1 << 3) // Pin Controlled by PB3
#define AT91C_PB3_SPI0_NPCS0   (AT91C_PIO_PB3)
#define AT91C_PIO_PB4          (1 << 4) // Pin Controlled by PB4
#define AT91C_PB4_TXD1         (AT91C_PIO_PB4)
#define AT91C_PIO_PB5          (1 << 5) // Pin Controlled by PB5
#define AT91C_PB5_RXD1         (AT91C_PIO_PB5)
#define AT91C_PIO_PB6          (1 << 6) // Pin Controlled by PB6
#define AT91C_PB6_TXD2         (AT91C_PIO_PB6)
#define AT91C_PIO_PB7          (1 << 7) // Pin Controlled by PB7
#define AT91C_PB7_RXD2         (AT91C_PIO_PB7)
#define AT91C_PIO_PB8          (1 << 8) // Pin Controlled by PB8
#define AT91C_PB8_TXD3         (AT91C_PIO_PB8)
#define AT91C_PB8_ISI_D8       (AT91C_PIO_PB8)
#define AT91C_PIO_PB9          (1 << 9) // Pin Controlled by PB9
#define AT91C_PB9_RXD3         (AT91C_PIO_PB9)
#define AT91C_PB9_ISI_D9       (AT91C_PIO_PB9)
#define AT91C_PIO_PB10         (1 << 10) // Pin Controlled by PB10
#define AT91C_PB10_TWD1        (AT91C_PIO_PB10)
#define AT91C_PB10_ISI_D10     (AT91C_PIO_PB10)
#define AT91C_PIO_PB11         (1 << 11) // Pin Controlled by PB11
#define AT91C_PB11_TWCK1       (AT91C_PIO_PB11)
#define AT91C_PB11_ISI_D11     (AT91C_PIO_PB11)
#define AT91C_PIO_PB12         (1 << 12) // Pin Controlled by PB12
#define AT91C_PB12_DRXD        (AT91C_PIO_PB12)
#define AT91C_PIO_PB13         (1 << 13) // Pin Controlled by PB13
#define AT91C_PB13_DTXD        (AT91C_PIO_PB13)
#define AT91C_PIO_PB14         (1 << 14) // Pin Controlled by PB14
#define AT91C_PB14_SPI1_MISO   (AT91C_PIO_PB14)
#define AT91C_PIO_PB15         (1 << 15) // Pin Controlled by PB15
#define AT91C_PB15_SPI1_MOSI   (AT91C_PIO_PB15)
#define AT91C_PB15_CTS0        (AT91C_PIO_PB15)
#define AT91C_PIO_PB16         (1 << 16) // Pin Controlled by PB16
#define AT91C_PB16_SPI1_SPCK   (AT91C_PIO_PB16)
#define AT91C_PB16_SCK0        (AT91C_PIO_PB16)
#define AT91C_PIO_PB17         (1 << 17) // Pin Controlled by PB17
#define AT91C_PB17_SPI1_NPCS0  (AT91C_PIO_PB17)
#define AT91C_PB17_RTS0        (AT91C_PIO_PB17)
#define AT91C_PIO_PB18         (1 << 18) // Pin Controlled by PB18
#define AT91C_PB18_RXD0        (AT91C_PIO_PB18)
#define AT91C_PB18_SPI0_NPCS1  (AT91C_PIO_PB18)
#define AT91C_PIO_PB19         (1 << 19) // Pin Controlled by PB19
#define AT91C_PB19_TXD0        (AT91C_PIO_PB19)
#define AT91C_PB19_SPI0_NPCS2  (AT91C_PIO_PB19)
#define AT91C_PIO_PB20         (1 << 20) // Pin Controlled by PB20
#define AT91C_PB20_ISI_D0      (AT91C_PIO_PB20)
#define AT91C_PIO_PB21         (1 << 21) // Pin Controlled by PB21
#define AT91C_PB21_ISI_D1      (AT91C_PIO_PB21)
#define AT91C_PIO_PB22         (1 << 22) // Pin Controlled by PB22
#define AT91C_PB22_ISI_D2      (AT91C_PIO_PB22)
#define AT91C_PIO_PB23         (1 << 23) // Pin Controlled by PB23
#define AT91C_PB23_ISI_D3      (AT91C_PIO_PB23)
#define AT91C_PIO_PB24         (1 << 24) // Pin Controlled by PB24
#define AT91C_PB24_ISI_D4      (AT91C_PIO_PB24)
#define AT91C_PIO_PB25         (1 << 25) // Pin Controlled by PB25
#define AT91C_PB25_ISI_D5      (AT91C_PIO_PB25)
#define AT91C_PIO_PB26         (1 << 26) // Pin Controlled by PB26
#define AT91C_PB26_ISI_D6      (AT91C_PIO_PB26)
#define AT91C_PIO_PB27         (1 << 27) // Pin Controlled by PB27
#define AT91C_PB27_ISI_D7      (AT91C_PIO_PB27)
#define AT91C_PIO_PB28         (1 << 28) // Pin Controlled by PB28
#define AT91C_PB28_ISI_PCK     (AT91C_PIO_PB28)
#define AT91C_PIO_PB29         (1 << 29) // Pin Controlled by PB29
#define AT91C_PB29_ISI_VSYNC   (AT91C_PIO_PB29)
#define AT91C_PIO_PB30         (1 << 30) // Pin Controlled by PB30
#define AT91C_PB30_ISI_HSYNC   (AT91C_PIO_PB30)
#define AT91C_PIO_PB31         (1 << 31) // Pin Controlled by PB31
#define AT91C_PB31_ISI_MCK     (AT91C_PIO_PB31)
#define AT91C_PB31_PCK1        (AT91C_PIO_PB31)
#define AT91C_PIO_PD0          (1 << 0) // Pin Controlled by PD0
#define AT91C_PD0_TK0          (AT91C_PIO_PD0)
#define AT91C_PD0_PWM3         (AT91C_PIO_PD0)
#define AT91C_PIO_PD1          (1 << 1) // Pin Controlled by PD1
#define AT91C_PD1_TF0          (AT91C_PIO_PD1)
#define AT91C_PIO_PD2          (1 << 2) // Pin Controlled by PD2
#define AT91C_PD2_TD0          (AT91C_PIO_PD2)
#define AT91C_PIO_PD3          (1 << 3) // Pin Controlled by PD3
#define AT91C_PD3_RD0          (AT91C_PIO_PD3)
#define AT91C_PIO_PD4          (1 << 4) // Pin Controlled by PD4
#define AT91C_PD4_RK0          (AT91C_PIO_PD4)
#define AT91C_PIO_PD5          (1 << 5) // Pin Controlled by PD5
#define AT91C_PD5_RF0          (AT91C_PIO_PD5)
#define AT91C_PIO_PD6          (1 << 6) // Pin Controlled by PD6
#define AT91C_PD6_AC97RX       (AT91C_PIO_PD6)
#define AT91C_PIO_PD7          (1 << 7) // Pin Controlled by PD7
#define AT91C_PD7_AC97TX       (AT91C_PIO_PD7)
#define AT91C_PD7_TIOA5        (AT91C_PIO_PD7)
#define AT91C_PIO_PD8          (1 << 8) // Pin Controlled by PD8
#define AT91C_PD8_AC97FS       (AT91C_PIO_PD8)
#define AT91C_PD8_TIOB5        (AT91C_PIO_PD8)
#define AT91C_PIO_PD9          (1 << 9) // Pin Controlled by PD9
#define AT91C_PD9_AC97CK       (AT91C_PIO_PD9)
#define AT91C_PD9_TCLK5        (AT91C_PIO_PD9)
#define AT91C_PIO_PD10         (1 << 10) // Pin Controlled by PD10
#define AT91C_PD10_TD1         (AT91C_PIO_PD10)
#define AT91C_PIO_PD11         (1 << 11) // Pin Controlled by PD11
#define AT91C_PD11_RD1         (AT91C_PIO_PD11)
#define AT91C_PIO_PD12         (1 << 12) // Pin Controlled by PD12
#define AT91C_PD12_TK1         (AT91C_PIO_PD12)
#define AT91C_PD12_PCK0        (AT91C_PIO_PD12)
#define AT91C_PIO_PD13         (1 << 13) // Pin Controlled by PD13
#define AT91C_PD13_RK1         (AT91C_PIO_PD13)
#define AT91C_PIO_PD14         (1 << 14) // Pin Controlled by PD14
#define AT91C_PD14_TF1         (AT91C_PIO_PD14)
#define AT91C_PIO_PD15         (1 << 15) // Pin Controlled by PD15
#define AT91C_PD15_RF1         (AT91C_PIO_PD15)
#define AT91C_PIO_PD16         (1 << 16) // Pin Controlled by PD16
#define AT91C_PD16_RTS1        (AT91C_PIO_PD16)
#define AT91C_PIO_PD17         (1 << 17) // Pin Controlled by PD17
#define AT91C_PD17_CTS1        (AT91C_PIO_PD17)
#define AT91C_PIO_PD18         (1 << 18) // Pin Controlled by PD18
#define AT91C_PD18_SPI1_NPCS2  (AT91C_PIO_PD18)
#define AT91C_PD18_IRQ         (AT91C_PIO_PD18)
#define AT91C_PIO_PD19         (1 << 19) // Pin Controlled by PD19
#define AT91C_PD19_SPI1_NPCS3  (AT91C_PIO_PD19)
#define AT91C_PD19_FIQ         (AT91C_PIO_PD19)
#define AT91C_PIO_PD20         (1 << 20) // Pin Controlled by PD20
#define AT91C_PD20_TIOA0       (AT91C_PIO_PD20)
#define AT91C_PIO_PD21         (1 << 21) // Pin Controlled by PD21
#define AT91C_PD21_TIOA1       (AT91C_PIO_PD21)
#define AT91C_PIO_PD22         (1 << 22) // Pin Controlled by PD22
#define AT91C_PD22_TIOA2       (AT91C_PIO_PD22)
#define AT91C_PIO_PD23         (1 << 23) // Pin Controlled by PD23
#define AT91C_PD23_TCLK0       (AT91C_PIO_PD23)
#define AT91C_PIO_PD24         (1 << 24) // Pin Controlled by PD24
#define AT91C_PD24_SPI0_NPCS1  (AT91C_PIO_PD24)
#define AT91C_PD24_PWM0        (AT91C_PIO_PD24)
#define AT91C_PIO_PD25         (1 << 25) // Pin Controlled by PD25
#define AT91C_PD25_SPI0_NPCS2  (AT91C_PIO_PD25)
#define AT91C_PD25_PWM1        (AT91C_PIO_PD25)
#define AT91C_PIO_PD26         (1 << 26) // Pin Controlled by PD26
#define AT91C_PD26_PCK0        (AT91C_PIO_PD26)
#define AT91C_PD26_PWM2        (AT91C_PIO_PD26)
#define AT91C_PIO_PD27         (1 << 27) // Pin Controlled by PD27
#define AT91C_PD27_PCK1        (AT91C_PIO_PD27)
#define AT91C_PD27_SPI0_NPCS3  (AT91C_PIO_PD27)
#define AT91C_PIO_PD28         (1 << 28) // Pin Controlled by PD28
#define AT91C_PD28_TSADTRG     (AT91C_PIO_PD28)
#define AT91C_PD28_SPI1_NPCS1  (AT91C_PIO_PD28)
#define AT91C_PIO_PD29         (1 << 29) // Pin Controlled by PD29
#define AT91C_PD29_TCLK1       (AT91C_PIO_PD29)
#define AT91C_PD29_SCK1        (AT91C_PIO_PD29)
#define AT91C_PIO_PD30         (1 << 30) // Pin Controlled by PD30
#define AT91C_PD30_TIOB0       (AT91C_PIO_PD30)
#define AT91C_PD30_SCK2        (AT91C_PIO_PD30)
#define AT91C_PIO_PD31         (1 << 31) // Pin Controlled by PD31
#define AT91C_PD31_TIOB1       (AT91C_PIO_PD31)
#define AT91C_PD31_PWM1        (AT91C_PIO_PD31)
#define AT91C_PIO_PE0          (1 << 0) // Pin Controlled by PE0
#define AT91C_PE0_LCDPWR       (AT91C_PIO_PE0)
#define AT91C_PE0_PCK0         (AT91C_PIO_PE0)
#define AT91C_PIO_PE1          (1 << 1) // Pin Controlled by PE1
#define AT91C_PE1_LCDMOD       (AT91C_PIO_PE1)
#define AT91C_PIO_PE2          (1 << 2) // Pin Controlled by PE2
#define AT91C_PE2_LCDCC        (AT91C_PIO_PE2)
#define AT91C_PIO_PE3          (1 << 3) // Pin Controlled by PE3
#define AT91C_PE3_LCDVSYNC     (AT91C_PIO_PE3)
#define AT91C_PIO_PE4          (1 << 4) // Pin Controlled by PE4
#define AT91C_PE4_LCDHSYNC     (AT91C_PIO_PE4)
#define AT91C_PIO_PE5          (1 << 5) // Pin Controlled by PE5
#define AT91C_PE5_LCDDOTCK     (AT91C_PIO_PE5)
#define AT91C_PIO_PE6          (1 << 6) // Pin Controlled by PE6
#define AT91C_PE6_LCDDEN       (AT91C_PIO_PE6)
#define AT91C_PIO_PE7          (1 << 7) // Pin Controlled by PE7
#define AT91C_PE7_LCDD0        (AT91C_PIO_PE7)
#define AT91C_PE7_LCDD2        (AT91C_PIO_PE7)
#define AT91C_PIO_PE8          (1 << 8) // Pin Controlled by PE8
#define AT91C_PE8_LCDD1        (AT91C_PIO_PE8)
#define AT91C_PE8_LCDD3        (AT91C_PIO_PE8)
#define AT91C_PIO_PE9          (1 << 9) // Pin Controlled by PE9
#define AT91C_PE9_LCDD2        (AT91C_PIO_PE9)
#define AT91C_PE9_LCDD4        (AT91C_PIO_PE9)
#define AT91C_PIO_PE10         (1 << 10) // Pin Controlled by PE10
#define AT91C_PE10_LCDD3       (AT91C_PIO_PE10)
#define AT91C_PE10_LCDD5       (AT91C_PIO_PE10)
#define AT91C_PIO_PE11         (1 << 11) // Pin Controlled by PE11
#define AT91C_PE11_LCDD4       (AT91C_PIO_PE11)
#define AT91C_PE11_LCDD6       (AT91C_PIO_PE11)
#define AT91C_PIO_PE12         (1 << 12) // Pin Controlled by PE12
#define AT91C_PE12_LCDD5       (AT91C_PIO_PE12)
#define AT91C_PE12_LCDD7       (AT91C_PIO_PE12)
#define AT91C_PIO_PE13         (1 << 13) // Pin Controlled by PE13
#define AT91C_PE13_LCDD6       (AT91C_PIO_PE13)
#define AT91C_PE13_LCDD10      (AT91C_PIO_PE13)
#define AT91C_PIO_PE14         (1 << 14) // Pin Controlled by PE14
#define AT91C_PE14_LCDD7       (AT91C_PIO_PE14)
#define AT91C_PE14_LCDD11      (AT91C_PIO_PE14)
#define AT91C_PIO_PE15         (1 << 15) // Pin Controlled by PE15
#define AT91C_PE15_LCDD8       (AT91C_PIO_PE15)
#define AT91C_PE15_LCDD12      (AT91C_PIO_PE15)
#define AT91C_PIO_PE16         (1 << 16) // Pin Controlled by PE16
#define AT91C_PE16_LCDD9       (AT91C_PIO_PE16)
#define AT91C_PE16_LCDD13      (AT91C_PIO_PE16)
#define AT91C_PIO_PE17         (1 << 17) // Pin Controlled by PE17
#define AT91C_PE17_LCDD10      (AT91C_PIO_PE17)
#define AT91C_PE17_LCDD14      (AT91C_PIO_PE17)
#define AT91C_PIO_PE18         (1 << 18) // Pin Controlled by PE18
#define AT91C_PE18_LCDD11      (AT91C_PIO_PE18)
#define AT91C_PE18_LCDD15      (AT91C_PIO_PE18)
#define AT91C_PIO_PE19         (1 << 19) // Pin Controlled by PE19
#define AT91C_PE19_LCDD12      (AT91C_PIO_PE19)
#define AT91C_PE19_LCDD18      (AT91C_PIO_PE19)
#define AT91C_PIO_PE20         (1 << 20) // Pin Controlled by PE20
#define AT91C_PE20_LCDD13      (AT91C_PIO_PE20)
#define AT91C_PE20_LCDD19      (AT91C_PIO_PE20)
#define AT91C_PIO_PE21         (1 << 21) // Pin Controlled by PE21
#define AT91C_PE21_LCDD14      (AT91C_PIO_PE21)
#define AT91C_PE21_LCDD20      (AT91C_PIO_PE21)
#define AT91C_PIO_PE22         (1 << 22) // Pin Controlled by PE22
#define AT91C_PE22_LCDD15      (AT91C_PIO_PE22)
#define AT91C_PE22_LCDD21      (AT91C_PIO_PE22)
#define AT91C_PIO_PE23         (1 << 23) // Pin Controlled by PE23
#define AT91C_PE23_LCDD16      (AT91C_PIO_PE23)
#define AT91C_PE23_LCDD22      (AT91C_PIO_PE23)
#define AT91C_PIO_PE24         (1 << 24) // Pin Controlled by PE24
#define AT91C_PE24_LCDD17      (AT91C_PIO_PE24)
#define AT91C_PE24_LCDD23      (AT91C_PIO_PE24)
#define AT91C_PIO_PE25         (1 << 25) // Pin Controlled by PE25
#define AT91C_PE25_LCDD18      (AT91C_PIO_PE25)
#define AT91C_PIO_PE26         (1 << 26) // Pin Controlled by PE26
#define AT91C_PE26_LCDD19      (AT91C_PIO_PE26)
#define AT91C_PIO_PE27         (1 << 27) // Pin Controlled by PE27
#define AT91C_PE27_LCDD20      (AT91C_PIO_PE27)
#define AT91C_PIO_PE28         (1 << 28) // Pin Controlled by PE28
#define AT91C_PE28_LCDD21      (AT91C_PIO_PE28)
#define AT91C_PIO_PE29         (1 << 29) // Pin Controlled by PE29
#define AT91C_PE29_LCDD22      (AT91C_PIO_PE29)
#define AT91C_PIO_PE30         (1 << 30) // Pin Controlled by PE30
#define AT91C_PE30_LCDD23      (AT91C_PIO_PE30)
#define AT91C_PIO_PE31         (1 << 31) // Pin Controlled by PE31
#define AT91C_PE31_PWM2        (AT91C_PIO_PE31)
#define AT91C_PE31_PCK1        (AT91C_PIO_PE31)

// *****************************************************************************
//   MEMORY MAPPING DEFINITIONS FOR AT91SAM9M11
// *****************************************************************************

#define AT91C_EBI_CS0 (0x10000000) // EBI Chip Select 0 base address
#define AT91C_EBI_CS2 (0x30000000) // EBI Chip Select 2 base address
#define AT91C_EBI_CS3 (0x40000000) // EBI Chip Select 3 base address
#define AT91C_EBI_NF  (0x40000000) // NAND Flash on EBI Chip Select 3 base address
#define AT91C_EBI_CS4 (0x50000000) // EBI Chip Select 4 base address
#define AT91C_EBI_CF0 (0x50000000) // CompactFlash 0 on EBI Chip Select 4 base address
#define AT91C_EBI_CS5 (0x60000000) // EBI Chip Select 5 base address
#define AT91C_EBI_CF1 (0x60000000) // CompactFlash 1 on EBI Chip Select 5 base address
#define AT91C_ITCM    (0x00100000) // Instruction Tightly Coupled Memory base address
#define AT91C_DTCM    (0x00200000) // Data Tightly Coupled Memory base address
#define AT91C_IRAM    (0x00300000) // Internal RAM base address
#define AT91C_IROM    (0x00400000) // Internal ROM base address

#endif // AT91SAM9M11_H
