/**
 * \file
 *
 * \brief Clock system configuration.
 *
 * Copyright (c) 2012 Atmel Corporation. All rights reserved.
 *
 * \asf_license_start
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 *    AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * \asf_license_stop
 *
 */
#ifndef CONF_CLOCK_H_INCLUDED
#define CONF_CLOCK_H_INCLUDED

// ===== System clock uses DFLL
#define CONFIG_SYSCLK_SOURCE        SYSCLK_SRC_RCFAST//SYSCLK_SRC_RCSYS//SYSCLK_SRC_RCFAST//SYSCLK_SRC_DFLL// SYSCLK_SRC_RCFAST
#define CONFIG_SYSCLK_CPU_FREQ      OSC_RCFAST12M_NOMINAL_HZ//SYSCLK_SRC_RCSYS//SYSCLK_SRC_RCFAST//SYSCLK_SRC_DFLL// SYSCLK_SRC_RCFAST

#define CONFIG_RCFAST_FRANGE        2
// ===== DFLL Options
//#define CONFIG_DFLL0_SOURCE         GENCLK_SRC_OSC32K
//#define CONFIG_DFLL0_MUL            4 /* Fdfll = (Fclk * DFLL_mul) / DFLL_div */
//#define CONFIG_DFLL0_DIV            1 /* Fdfll = (Fclk * DFLL_mul) / DFLL_div */
//#define CONFIG_DFLL0_FREQ           (32768*CONFIG_DFLL0_MUL)/CONFIG_DFLL0_DIV

// ===== PLL Options
#define CONFIG_PLL0_SOURCE            PLL_SRC_GCLK9 // PLL_SRC_GCLK9 // PLL_SRC_OSC0
#define CONFIG_PLL0_MUL               (48000000 / 4000000) /* Fpll = (Fclk * PLL_mul) / PLL_div */
#define CONFIG_PLL0_DIV               1 /* Fpll = (Fclk * PLL_mul) / PLL_div */

#define CONFIG_GCLK9_SOURCE           (SCIF_GC_USES_RCFAST)
#define CONFIG_GCLK9_FREQ             (OSC_RCFAST12M_NOMINAL_HZ)
#define CONFIG_GCLK9_DIV              1
// ===== Disable all non-essential peripheral clocks
#define CONFIG_SYSCLK_INIT_CPUMASK  0
#define CONFIG_SYSCLK_INIT_PBAMASK  0
#define CONFIG_SYSCLK_INIT_PBBMASK  0
#define CONFIG_SYSCLK_INIT_PBCMASK  0
#define CONFIG_SYSCLK_INIT_PBDMASK  0
#define CONFIG_SYSCLK_INIT_HSBMASK  0

// ===== System Clock Bus Division Options
#define CONFIG_SYSCLK_CPU_DIV       0 /* Fcpu = Fsys/(2 ^ CPU_div) */
#define CONFIG_SYSCLK_HSB_DIV       0 /* Fcpu = Fsys/(2 ^ CPU_div) */
#define CONFIG_SYSCLK_PBA_DIV       0 /* Fpba = Fsys/(2 ^ PBA_div) */
#define CONFIG_SYSCLK_PBB_DIV       0 /* Fpbb = Fsys/(2 ^ PBB_div) */

#define  CONFIG_USBCLK_SOURCE USBCLK_SRC_PLL0
//#define CONFIG_PLL1_MUL             8
//#define CONFIG_PLL1_DIV             2
//#define CONFIG_USBCLK_SOURCE        USBCLK_SRC_PLL1
#define CONFIG_USBCLK_DIV           1 // Fusb = Fsys/(2 ^ USB_div)



#endif /* CONF_CLOCK_H_INCLUDED */
