/* ---------------------------------------------------------------------------- */
/*                  Atmel Microcontroller Software Support                      */
/* ---------------------------------------------------------------------------- */
/* Copyright (c) 2012, Atmel Corporation                                        */
/*                                                                              */
/* All rights reserved.                                                         */
/*                                                                              */
/* Redistribution and use in source and binary forms, with or without           */
/* modification, are permitted provided that the following condition is met:    */
/*                                                                              */
/* - Redistributions of source code must retain the above copyright notice,     */
/* this list of conditions and the disclaimer below.                            */
/*                                                                              */
/* Atmel's name may not be used to endorse or promote products derived from     */
/* this software without specific prior written permission.                     */
/*                                                                              */
/* DISCLAIMER:  THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR   */
/* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE   */
/* DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,      */
/* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,  */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING         */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, */
/* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                           */
/* ---------------------------------------------------------------------------- */
/*                                                                              */
/* File Name    : SAM4L4.h */
/* Object       : SAM4L4 definitions */
/* Generated by : AT91 SW Application Group */
/* Generated on : 2012-08-07 */

#ifndef SAM4L4_H
#define SAM4L4_H

/** \addtogroup SAM4L4_definitions SAM4L4 definitions
  This file defines all structures and symbols for SAM4L4:
    - registers and bitfields
    - peripheral base address
    - peripheral ID
    - PIO definitions
*/
/*@{*/

#ifdef __cplusplus
 extern "C" {
#endif

#ifndef __ASSEMBLY__
#include <stdint.h>
#ifndef __cplusplus
typedef volatile const uint32_t RoReg;   /**< Read only 32-bit register (volatile const unsigned int) */
typedef volatile const uint16_t RoReg16; /**< Read only 16-bit register (volatile const unsigned int) */
typedef volatile const uint8_t  RoReg8;  /**< Read only  8-bit register (volatile const unsigned int) */
#else
typedef volatile       uint32_t RoReg;   /**< Read only 32-bit register (volatile const unsigned int) */
typedef volatile       uint16_t RoReg16; /**< Read only 16-bit register (volatile const unsigned int) */
typedef volatile       uint8_t  RoReg8;  /**< Read only  8-bit register (volatile const unsigned int) */
#endif
typedef volatile       uint32_t WoReg;   /**< Write only 32-bit register (volatile unsigned int) */
typedef volatile       uint16_t WoReg16; /**< Write only 16-bit register (volatile unsigned int) */
typedef volatile       uint32_t WoReg8;  /**< Write only  8-bit register (volatile unsigned int) */
typedef volatile       uint32_t RwReg;   /**< Read-Write 32-bit register (volatile unsigned int) */
typedef volatile       uint16_t RwReg16; /**< Read-Write 16-bit register (volatile unsigned int) */
typedef volatile       uint8_t  RwReg8;  /**< Read-Write  8-bit register (volatile unsigned int) */
#define CAST(type, value) ((type *)(value))
#define REG_ACCESS(type, address) (*(type*)(address)) /**< C code: Register value */
#else
#define CAST(type, value) (value)
#define REG_ACCESS(type, address) (address) /**< Assembly code: Register address */
#endif

/* ************************************************************************** */
/*   CMSIS DEFINITIONS FOR SAM4L4 */
/* ************************************************************************** */
/** \addtogroup SAM4L4_cmsis CMSIS Definitions */
/*@{*/


/**< Interrupt Number Definition */
typedef enum IRQn
{
/******  Cortex-M4 Processor Exceptions Numbers ******************************/
  NonMaskableInt_IRQn   = -14, /**<  2 Non Maskable Interrupt                */
  HardFault_IRQn        = -13, /**<  3 Cortex-M4 Hard Fault Interrupt        */
  MemoryManagement_IRQn = -12, /**<  4 Cortex-M4 Memory Management Interrupt */
  BusFault_IRQn         = -11, /**<  5 Cortex-M4 Bus Fault Interrupt         */
  UsageFault_IRQn       = -10, /**<  6 Cortex-M4 Usage Fault Interrupt       */
  SVCall_IRQn           = -5,  /**< 11 Cortex-M4 SV Call Interrupt           */
  DebugMonitor_IRQn     = -4,  /**< 12 Cortex-M4 Debug Monitor Interrupt     */
  PendSV_IRQn           = -2,  /**< 14 Cortex-M4 Pend SV Interrupt           */
  SysTick_IRQn          = -1,  /**< 15 Cortex-M4 System Tick Interrupt       */
  /******  SAM4L4 specific Interrupt Numbers *********************************/
  HFLASHC_IRQn          =  0, /**<  0 SAM4L4 Flash Controller (HFLASHC) */
  PDCA_0_IRQn           =  1, /**<  1 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_1_IRQn           =  2, /**<  2 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_2_IRQn           =  3, /**<  3 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_3_IRQn           =  4, /**<  4 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_4_IRQn           =  5, /**<  5 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_5_IRQn           =  6, /**<  6 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_6_IRQn           =  7, /**<  7 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_7_IRQn           =  8, /**<  8 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_8_IRQn           =  9, /**<  9 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_9_IRQn           = 10, /**< 10 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_10_IRQn          = 11, /**< 11 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_11_IRQn          = 12, /**< 12 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_12_IRQn          = 13, /**< 13 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_13_IRQn          = 14, /**< 14 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_14_IRQn          = 15, /**< 15 SAM4L4 Peripheral DMA Controller (PDCA) */
  PDCA_15_IRQn          = 16, /**< 16 SAM4L4 Peripheral DMA Controller (PDCA) */
  CRCCU_IRQn            = 17, /**< 17 SAM4L4 CRC Calculation Unit (CRCCU) */
  USBC_IRQn             = 18, /**< 18 SAM4L4 USB 2.0 Interface (USBC) */
  PEVC_TR_IRQn          = 19, /**< 19 SAM4L4 Peripheral Event Controller (PEVC) */
  PEVC_OV_IRQn          = 20, /**< 20 SAM4L4 Peripheral Event Controller (PEVC) */
  AESA_IRQn             = 21, /**< 21 SAM4L4 Advanced Encryption Standard (AESA) */
  PM_IRQn               = 22, /**< 22 SAM4L4 Power Manager (PM) */
  SCIF_IRQn             = 23, /**< 23 SAM4L4 System Control Interface (SCIF) */
  FREQM_IRQn            = 24, /**< 24 SAM4L4 Frequency Meter (FREQM) */
  GPIO_0_IRQn           = 25, /**< 25 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_1_IRQn           = 26, /**< 26 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_2_IRQn           = 27, /**< 27 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_3_IRQn           = 28, /**< 28 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_4_IRQn           = 29, /**< 29 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_5_IRQn           = 30, /**< 30 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_6_IRQn           = 31, /**< 31 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_7_IRQn           = 32, /**< 32 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_8_IRQn           = 33, /**< 33 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_9_IRQn           = 34, /**< 34 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_10_IRQn          = 35, /**< 35 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  GPIO_11_IRQn          = 36, /**< 36 SAM4L4 General-Purpose Input/Output Controller (GPIO) */
  BPM_IRQn              = 37, /**< 37 SAM4L4 Backup Power Manager (BPM) */
  BSCIF_IRQn            = 38, /**< 38 SAM4L4 Backup System Control Interface (BSCIF) */
  AST_ALARM_IRQn        = 39, /**< 39 SAM4L4 Asynchronous Timer (AST) */
  AST_PER_IRQn          = 40, /**< 40 SAM4L4 Asynchronous Timer (AST) */
  AST_OVF_IRQn          = 41, /**< 41 SAM4L4 Asynchronous Timer (AST) */
  AST_READY_IRQn        = 42, /**< 42 SAM4L4 Asynchronous Timer (AST) */
  AST_CLKREADY_IRQn     = 43, /**< 43 SAM4L4 Asynchronous Timer (AST) */
  WDT_IRQn              = 44, /**< 44 SAM4L4 Watchdog Timer (WDT) */
  EIC_1_IRQn            = 45, /**< 45 SAM4L4 External Interrupt Controller (EIC) */
  EIC_2_IRQn            = 46, /**< 46 SAM4L4 External Interrupt Controller (EIC) */
  EIC_3_IRQn            = 47, /**< 47 SAM4L4 External Interrupt Controller (EIC) */
  EIC_4_IRQn            = 48, /**< 48 SAM4L4 External Interrupt Controller (EIC) */
  EIC_5_IRQn            = 49, /**< 49 SAM4L4 External Interrupt Controller (EIC) */
  EIC_6_IRQn            = 50, /**< 50 SAM4L4 External Interrupt Controller (EIC) */
  EIC_7_IRQn            = 51, /**< 51 SAM4L4 External Interrupt Controller (EIC) */
  EIC_8_IRQn            = 52, /**< 52 SAM4L4 External Interrupt Controller (EIC) */
  IISC_IRQn             = 53, /**< 53 SAM4L4 Inter-IC Sound (I2S) Controller (IISC) */
  SPI_IRQn              = 54, /**< 54 SAM4L4 Serial Peripheral Interface (SPI) */
  TC00_IRQn             = 55, /**< 55 SAM4L4 Timer/Counter 0 (TC0) */
  TC01_IRQn             = 56, /**< 56 SAM4L4 Timer/Counter 0 (TC0) */
  TC02_IRQn             = 57, /**< 57 SAM4L4 Timer/Counter 0 (TC0) */
  TC10_IRQn             = 58, /**< 58 SAM4L4 Timer/Counter 1 (TC1) */
  TC11_IRQn             = 59, /**< 59 SAM4L4 Timer/Counter 1 (TC1) */
  TC12_IRQn             = 60, /**< 60 SAM4L4 Timer/Counter 1 (TC1) */
  TWIM0_IRQn            = 61, /**< 61 SAM4L4 Two-wire Master Interface 0 (TWIM0) */
  TWIS0_IRQn            = 62, /**< 62 SAM4L4 Two-wire Slave Interface 0 (TWIS0) */
  TWIM1_IRQn            = 63, /**< 63 SAM4L4 Two-wire Master Interface 1 (TWIM1) */
  TWIS1_IRQn            = 64, /**< 64 SAM4L4 Two-wire Slave Interface 1 (TWIS1) */
  USART0_IRQn           = 65, /**< 65 SAM4L4 Universal Synchronous Asynchronous Receiver Transmitter 0 (USART0) */
  USART1_IRQn           = 66, /**< 66 SAM4L4 Universal Synchronous Asynchronous Receiver Transmitter 1 (USART1) */
  USART2_IRQn           = 67, /**< 67 SAM4L4 Universal Synchronous Asynchronous Receiver Transmitter 2 (USART2) */
  USART3_IRQn           = 68, /**< 68 SAM4L4 Universal Synchronous Asynchronous Receiver Transmitter 3 (USART3) */
  ADCIFE_IRQn           = 69, /**< 69 SAM4L4 ADC controller interface (ADCIFE) */
  DACC_IRQn             = 70, /**< 70 SAM4L4 DAC Controller (DACC) */
  ACIFC_IRQn            = 71, /**< 71 SAM4L4 Analog Comparator Interface (ACIFC) */
  ABDACB_IRQn           = 72, /**< 72 SAM4L4 Audio Bitstream DAC (ABDACB) */
  TRNG_IRQn             = 73, /**< 73 SAM4L4 True Random Number Generator (TRNG) */
  PARC_IRQn             = 74, /**< 74 SAM4L4 Parallel Capture (PARC) */
  CATB_IRQn             = 75, /**< 75 SAM4L4 Capacitive Touch Module B (CATB) */
  PTC_IRQn              = 76, /**< 76 SAM4L4  (PTC) */
  TWIM2_IRQn            = 77, /**< 77 SAM4L4 Two-wire Master Interface 2 (TWIM2) */
  TWIM3_IRQn            = 78, /**< 78 SAM4L4 Two-wire Master Interface 3 (TWIM3) */
  LCDCA_IRQn            = 79  /**< 79 SAM4L4 LCD Controller (LCDCA) */
} IRQn_Type;


/* Cortex-M4 core handlers */
void Reset_Handler      ( void );
void NMI_Handler        ( void );
void HardFault_Handler  ( void );
void MemManage_Handler  ( void );
void BusFault_Handler   ( void );
void UsageFault_Handler ( void );
void SVC_Handler        ( void );
void DebugMon_Handler   ( void );
void PendSV_Handler     ( void );
void SysTick_Handler    ( void );

/* Peripherals handlers */

void HFLASHC_Handler( void );
void PDCA_0_Handler( void );
void PDCA_1_Handler( void );
void PDCA_2_Handler( void );
void PDCA_3_Handler( void );
void PDCA_4_Handler( void );
void PDCA_5_Handler( void );
void PDCA_6_Handler( void );
void PDCA_7_Handler( void );
void PDCA_8_Handler( void );
void PDCA_9_Handler( void );
void PDCA_10_Handler( void );
void PDCA_11_Handler( void );
void PDCA_12_Handler( void );
void PDCA_13_Handler( void );
void PDCA_14_Handler( void );
void PDCA_15_Handler( void );
void CRCCU_Handler( void );
void USBC_Handler( void );
void PEVC_TR_Handler( void );
void PEVC_OV_Handler( void );
void AESA_Handler( void );
void PM_Handler( void );
void SCIF_Handler( void );
void FREQM_Handler( void );
void GPIO_0_Handler( void );
void GPIO_1_Handler( void );
void GPIO_2_Handler( void );
void GPIO_3_Handler( void );
void GPIO_4_Handler( void );
void GPIO_5_Handler( void );
void GPIO_6_Handler( void );
void GPIO_7_Handler( void );
void GPIO_8_Handler( void );
void GPIO_9_Handler( void );
void GPIO_10_Handler( void );
void GPIO_11_Handler( void );
void BPM_Handler( void );
void BSCIF_Handler( void );
void AST_ALARM_Handler( void );
void AST_PER_Handler( void );
void AST_OVF_Handler( void );
void AST_READY_Handler( void );
void AST_CLKREADY_Handler( void );
void WDT_Handler( void );
void EIC_1_Handler( void );
void EIC_2_Handler( void );
void EIC_3_Handler( void );
void EIC_4_Handler( void );
void EIC_5_Handler( void );
void EIC_6_Handler( void );
void EIC_7_Handler( void );
void EIC_8_Handler( void );
void IISC_Handler( void );
void SPI_Handler( void );
void TC00_Handler( void );
void TC01_Handler( void );
void TC02_Handler( void );
void TC10_Handler( void );
void TC11_Handler( void );
void TC12_Handler( void );
void TWIM0_Handler( void );
void TWIS0_Handler( void );
void TWIM1_Handler( void );
void TWIS1_Handler( void );
void USART0_Handler( void );
void USART1_Handler( void );
void USART2_Handler( void );
void USART3_Handler( void );
void ADCIFE_Handler( void );
void DACC_Handler( void );
void ACIFC_Handler( void );
void ABDACB_Handler( void );
void TRNG_Handler( void );
void PARC_Handler( void );
void CATB_Handler( void );
void PTC_Handler( void );
void TWIM2_Handler( void );
void TWIM3_Handler( void );
void LCDCA_Handler( void );

/*
 * \brief Configuration of the Cortex-M4 Processor and Core Peripherals
 */

#define __MPU_PRESENT          1 /**< SAM4L4 does provide a MPU */
#define __NVIC_PRIO_BITS       4 /**< SAM4L4 uses 4 Bits for the Priority Levels */
#define __Vendor_SysTickConfig 0 /**< Set to 1 if different SysTick Config is used */
#define __FPU_PRESENT          0 /**< SAM4L4 does not provide a FPU */

/**
 * \brief CMSIS includes
 */

#include <core_cm4.h>

/*@}*/

/* ************************************************************************** */
/**  SOFTWARE PERIPHERAL API DEFINITION FOR SAM4L4 */
/* ************************************************************************** */
/** \addtogroup SAM4L4_api Peripheral Software API */
/*@{*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR ABDACB */
/* ============================================================================= */
/** \addtogroup SAM4L4_ABDACB Audio Bitstream DAC */
/*@{*/

#define REV_ABDACB     0x100

#ifndef __ASSEMBLY__
/** \brief ABDACB hardware registers */
typedef struct {
  RwReg   CR;          /**< \brief (ABDACB Offset: 0x00) Control Register */
  RwReg   SDR0;        /**< \brief (ABDACB Offset: 0x04) Sample Data Register 0 */
  RwReg   SDR1;        /**< \brief (ABDACB Offset: 0x08) Sample Data Register 1 */
  RwReg   VCR0;        /**< \brief (ABDACB Offset: 0x0C) Volume Control Register 0 */
  RwReg   VCR1;        /**< \brief (ABDACB Offset: 0x10) Volume Control Register 1 */
  WoReg   IER;         /**< \brief (ABDACB Offset: 0x14) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (ABDACB Offset: 0x18) Interupt Disable Register */
  RoReg   IMR;         /**< \brief (ABDACB Offset: 0x1C) Interrupt Mask Register */
  RoReg   SR;          /**< \brief (ABDACB Offset: 0x20) Status Register */
  WoReg   SCR;         /**< \brief (ABDACB Offset: 0x24) Status Clear Register */
  RoReg   PARAMETER;   /**< \brief (ABDACB Offset: 0x28) Parameter Register */
  RoReg   VERSION;     /**< \brief (ABDACB Offset: 0x2C) Version Register */
} Abdacb;
#endif /* __ASSEMBLY__ */
/* -------- ABDACB_CR : (ABDACB Offset: 0x00) Control Register -------- */
#define ABDACB_CR_EN                (0x1u <<  0) /**< \brief (ABDACB_CR) Enable */
#define   ABDACB_CR_EN_0            (0x0u <<  0) /**< \brief (ABDACB_CR) Audio DAC is disabled */
#define   ABDACB_CR_EN_1            (0x1u <<  0) /**< \brief (ABDACB_CR) Audio DAC is enabled */
#define ABDACB_CR_SWAP              (0x1u <<  1) /**< \brief (ABDACB_CR) Swap Channels */
#define   ABDACB_CR_SWAP_0          (0x0u <<  1) /**< \brief (ABDACB_CR) The CHANNEL0 and CHANNEL1 samples will not be swapped when writing the Audio DAC Sample Data Register (SDR) */
#define   ABDACB_CR_SWAP_1          (0x1u <<  1) /**< \brief (ABDACB_CR) The CHANNEL0 and CHANNEL1 samples will be swapped when writing the Audio DAC Sample Data Register (SDR) */
#define ABDACB_CR_ALTUPR            (0x1u <<  3) /**< \brief (ABDACB_CR) Alternative up-sampling ratio */
#define ABDACB_CR_CMOC              (0x1u <<  4) /**< \brief (ABDACB_CR) Common mode offset control */
#define ABDACB_CR_MONO              (0x1u <<  5) /**< \brief (ABDACB_CR) Mono mode */
#define ABDACB_CR_SWRST             (0x1u <<  7) /**< \brief (ABDACB_CR) Software reset */
#define ABDACB_CR_DATAFORMAT_Pos    16
#define ABDACB_CR_DATAFORMAT_Msk    (0x7u << ABDACB_CR_DATAFORMAT_Pos) /**< \brief (ABDACB_CR) Data word format */
#define ABDACB_CR_DATAFORMAT(value) ((ABDACB_CR_DATAFORMAT_Msk & ((value) << ABDACB_CR_DATAFORMAT_Pos)))
#define ABDACB_CR_FS_Pos            24
#define ABDACB_CR_FS_Msk            (0xFu << ABDACB_CR_FS_Pos) /**< \brief (ABDACB_CR) Sampling frequency */
#define ABDACB_CR_FS(value)         ((ABDACB_CR_FS_Msk & ((value) << ABDACB_CR_FS_Pos)))
/* -------- ABDACB_SDR0 : (ABDACB Offset: 0x04) Sample Data Register 0 -------- */
#define ABDACB_SDR0_DATA_Pos        0
#define ABDACB_SDR0_DATA_Msk        (0xFFFFFFFFu << ABDACB_SDR0_DATA_Pos) /**< \brief (ABDACB_SDR0) Sample Data */
#define ABDACB_SDR0_DATA(value)     ((ABDACB_SDR0_DATA_Msk & ((value) << ABDACB_SDR0_DATA_Pos)))
/* -------- ABDACB_SDR1 : (ABDACB Offset: 0x08) Sample Data Register 1 -------- */
#define ABDACB_SDR1_DATA_Pos        0
#define ABDACB_SDR1_DATA_Msk        (0xFFFFFFFFu << ABDACB_SDR1_DATA_Pos) /**< \brief (ABDACB_SDR1) Sample Data */
#define ABDACB_SDR1_DATA(value)     ((ABDACB_SDR1_DATA_Msk & ((value) << ABDACB_SDR1_DATA_Pos)))
/* -------- ABDACB_VCR0 : (ABDACB Offset: 0x0C) Volume Control Register 0 -------- */
#define ABDACB_VCR0_VOLUME_Pos      0
#define ABDACB_VCR0_VOLUME_Msk      (0x7FFFu << ABDACB_VCR0_VOLUME_Pos) /**< \brief (ABDACB_VCR0) Volume Control */
#define ABDACB_VCR0_VOLUME(value)   ((ABDACB_VCR0_VOLUME_Msk & ((value) << ABDACB_VCR0_VOLUME_Pos)))
#define ABDACB_VCR0_MUTE            (0x1u << 31) /**< \brief (ABDACB_VCR0) Mute */
/* -------- ABDACB_VCR1 : (ABDACB Offset: 0x10) Volume Control Register 1 -------- */
#define ABDACB_VCR1_VOLUME_Pos      0
#define ABDACB_VCR1_VOLUME_Msk      (0x7FFFu << ABDACB_VCR1_VOLUME_Pos) /**< \brief (ABDACB_VCR1) Volume Control */
#define ABDACB_VCR1_VOLUME(value)   ((ABDACB_VCR1_VOLUME_Msk & ((value) << ABDACB_VCR1_VOLUME_Pos)))
#define ABDACB_VCR1_MUTE            (0x1u << 31) /**< \brief (ABDACB_VCR1) Mute */
/* -------- ABDACB_IER : (ABDACB Offset: 0x14) Interrupt Enable Register -------- */
#define ABDACB_IER_TXRDY            (0x1u <<  1) /**< \brief (ABDACB_IER) Transmit Ready Interrupt Enable */
#define   ABDACB_IER_TXRDY_0        (0x0u <<  1) /**< \brief (ABDACB_IER) No effect */
#define   ABDACB_IER_TXRDY_1        (0x1u <<  1) /**< \brief (ABDACB_IER) Enables the Audio DAC TX Ready interrupt */
#define ABDACB_IER_TXUR             (0x1u <<  2) /**< \brief (ABDACB_IER) Transmit Underrun Interrupt Enable */
#define   ABDACB_IER_TXUR_0         (0x0u <<  2) /**< \brief (ABDACB_IER) No effect */
#define   ABDACB_IER_TXUR_1         (0x1u <<  2) /**< \brief (ABDACB_IER) Enables the Audio DAC Underrun interrupt */
/* -------- ABDACB_IDR : (ABDACB Offset: 0x18) Interupt Disable Register -------- */
#define ABDACB_IDR_TXRDY            (0x1u <<  1) /**< \brief (ABDACB_IDR) Transmit Ready Interrupt Disable */
#define   ABDACB_IDR_TXRDY_0        (0x0u <<  1) /**< \brief (ABDACB_IDR) No effect */
#define   ABDACB_IDR_TXRDY_1        (0x1u <<  1) /**< \brief (ABDACB_IDR) Disable the Audio DAC TX Ready interrupt */
#define ABDACB_IDR_TXUR             (0x1u <<  2) /**< \brief (ABDACB_IDR) Transmit Underrun Interrupt Disable */
#define   ABDACB_IDR_TXUR_0         (0x0u <<  2) /**< \brief (ABDACB_IDR) No effect */
#define   ABDACB_IDR_TXUR_1         (0x1u <<  2) /**< \brief (ABDACB_IDR) Disable the Audio DAC Underrun interrupt */
/* -------- ABDACB_IMR : (ABDACB Offset: 0x1C) Interrupt Mask Register -------- */
#define ABDACB_IMR_TXRDY            (0x1u <<  1) /**< \brief (ABDACB_IMR) Transmit Ready Interrupt Mask */
#define   ABDACB_IMR_TXRDY_0        (0x0u <<  1) /**< \brief (ABDACB_IMR) The Audio DAC TX Ready interrupt is disabled */
#define   ABDACB_IMR_TXRDY_1        (0x1u <<  1) /**< \brief (ABDACB_IMR) The Audio DAC TX Ready interrupt is enabled */
#define ABDACB_IMR_TXUR             (0x1u <<  2) /**< \brief (ABDACB_IMR) Transmit Underrun Interrupt Mask */
#define   ABDACB_IMR_TXUR_0         (0x0u <<  2) /**< \brief (ABDACB_IMR) The Audio DAC Underrun interrupt is disabled */
#define   ABDACB_IMR_TXUR_1         (0x1u <<  2) /**< \brief (ABDACB_IMR) The Audio DAC Underrun interrupt is enabled */
/* -------- ABDACB_SR : (ABDACB Offset: 0x20) Status Register -------- */
#define ABDACB_SR_BUSY              (0x1u <<  0) /**< \brief (ABDACB_SR) ABDACB Busy */
#define ABDACB_SR_TXRDY             (0x1u <<  1) /**< \brief (ABDACB_SR) Transmit Ready */
#define   ABDACB_SR_TXRDY_0         (0x0u <<  1) /**< \brief (ABDACB_SR) No Audio DAC TX Ready has occured since the last time ISR was read or since reset */
#define   ABDACB_SR_TXRDY_1         (0x1u <<  1) /**< \brief (ABDACB_SR) At least one Audio DAC TX Ready has occured since the last time ISR was read or since reset */
#define ABDACB_SR_TXUR              (0x1u <<  2) /**< \brief (ABDACB_SR) Transmit Underrun */
#define   ABDACB_SR_TXUR_0          (0x0u <<  2) /**< \brief (ABDACB_SR) No Audio DAC Underrun has occured since the last time ISR was read or since reset */
#define   ABDACB_SR_TXUR_1          (0x1u <<  2) /**< \brief (ABDACB_SR) At least one Audio DAC Underrun has occured since the last time ISR was read or since reset */
/* -------- ABDACB_SCR : (ABDACB Offset: 0x24) Status Clear Register -------- */
#define ABDACB_SCR_TXRDY            (0x1u <<  1) /**< \brief (ABDACB_SCR) Transmit Ready Interrupt Clear */
#define   ABDACB_SCR_TXRDY_0        (0x0u <<  1) /**< \brief (ABDACB_SCR) No effect */
#define   ABDACB_SCR_TXRDY_1        (0x1u <<  1) /**< \brief (ABDACB_SCR) Clear the Audio DAC TX Ready interrupt */
#define ABDACB_SCR_TXUR             (0x1u <<  2) /**< \brief (ABDACB_SCR) Transmit Underrun Interrupt Clear */
#define   ABDACB_SCR_TXUR_0         (0x0u <<  2) /**< \brief (ABDACB_SCR) No effect */
#define   ABDACB_SCR_TXUR_1         (0x1u <<  2) /**< \brief (ABDACB_SCR) Clear the Audio DAC Underrun interrupt */
/* -------- ABDACB_VERSION : (ABDACB Offset: 0x2C) Version Register -------- */
#define ABDACB_VERSION_VERSION_Pos    0
#define ABDACB_VERSION_VERSION_Msk    (0xFFFu << ABDACB_VERSION_VERSION_Pos) /**< \brief (ABDACB_VERSION) Version Number */
#define ABDACB_VERSION_VERSION(value) ((ABDACB_VERSION_VERSION_Msk & ((value) << ABDACB_VERSION_VERSION_Pos)))
#define ABDACB_VERSION_VARIANT_Pos    16
#define ABDACB_VERSION_VARIANT_Msk    (0xFu << ABDACB_VERSION_VARIANT_Pos) /**< \brief (ABDACB_VERSION) Variant Number */
#define ABDACB_VERSION_VARIANT(value) ((ABDACB_VERSION_VARIANT_Msk & ((value) << ABDACB_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR ACIFC */
/* ============================================================================= */
/** \addtogroup SAM4L4_ACIFC Analog Comparator Interface */
/*@{*/

#define REV_ACIFC      0x101

#ifndef __ASSEMBLY__
/** \brief AcifcConf hardware registers */
typedef struct {
  RwReg   CONF;        /**< \brief (AcifcConf Offset: 0x00) AC Configuration Register */
} AcifcConf;
/** \brief AcifcConfw hardware registers */
typedef struct {
  RwReg   CONFW;       /**< \brief (AcifcConfw Offset: 0x00) Window configuration Register */
} AcifcConfw;
/** \brief ACIFC hardware registers */
typedef struct {
  RwReg   CTRL;        /**< \brief (ACIFC Offset: 0x00) Control Register */
  RoReg   SR;          /**< \brief (ACIFC Offset: 0x04) Status Register */
  RoReg   Reserved1[2];
  WoReg   IER;         /**< \brief (ACIFC Offset: 0x10) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (ACIFC Offset: 0x14) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (ACIFC Offset: 0x18) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (ACIFC Offset: 0x1C) Interrupt Status Register */
  WoReg   ICR;         /**< \brief (ACIFC Offset: 0x20) Interrupt Status Clear Register */
  RwReg   TR;          /**< \brief (ACIFC Offset: 0x24) Test Register */
  RoReg   Reserved2[2];
  RoReg   PARAMETER;   /**< \brief (ACIFC Offset: 0x30) Parameter Register */
  RoReg   VERSION;     /**< \brief (ACIFC Offset: 0x34) Version Register */
  RoReg   Reserved3[18];
  AcifcConfw Confw[4]; /**< \brief (ACIFC Offset: 0x80) AcifcConfw groups */
  RoReg   Reserved4[16];
  AcifcConf Conf[8]; /**< \brief (ACIFC Offset: 0xD0) AcifcConf groups */
} Acifc;
#endif /* __ASSEMBLY__ */
/* -------- ACIFC_CTRL : (ACIFC Offset: 0x00) Control Register -------- */
#define ACIFC_CTRL_EN               (0x1u <<  0) /**< \brief (ACIFC_CTRL) ACIFC Enable */
#define ACIFC_CTRL_EVENTEN          (0x1u <<  1) /**< \brief (ACIFC_CTRL) Peripheral Event Trigger Enable */
#define ACIFC_CTRL_USTART           (0x1u <<  4) /**< \brief (ACIFC_CTRL) User Start Single Comparison */
#define ACIFC_CTRL_ESTART           (0x1u <<  5) /**< \brief (ACIFC_CTRL) Peripheral Event Start Single Comparison */
#define ACIFC_CTRL_ACTEST           (0x1u <<  7) /**< \brief (ACIFC_CTRL) Analog Comparator Test Mode */
/* -------- ACIFC_SR : (ACIFC Offset: 0x04) Status Register -------- */
#define ACIFC_SR_ACCS0              (0x1u <<  0) /**< \brief (ACIFC_SR) AC0 Current Comparison Status */
#define ACIFC_SR_ACRDY0             (0x1u <<  1) /**< \brief (ACIFC_SR) AC0 Ready */
#define ACIFC_SR_ACCS1              (0x1u <<  2) /**< \brief (ACIFC_SR) AC1 Current Comparison Status */
#define ACIFC_SR_ACRDY1             (0x1u <<  3) /**< \brief (ACIFC_SR) AC1 Ready */
#define ACIFC_SR_ACCS2              (0x1u <<  4) /**< \brief (ACIFC_SR) AC2 Current Comparison Status */
#define ACIFC_SR_ACRDY2             (0x1u <<  5) /**< \brief (ACIFC_SR) AC2 Ready */
#define ACIFC_SR_ACCS3              (0x1u <<  6) /**< \brief (ACIFC_SR) AC3 Current Comparison Status */
#define ACIFC_SR_ACRDY3             (0x1u <<  7) /**< \brief (ACIFC_SR) AC3 Ready */
#define ACIFC_SR_ACCS4              (0x1u <<  8) /**< \brief (ACIFC_SR) AC4 Current Comparison Status */
#define ACIFC_SR_ACRDY4             (0x1u <<  9) /**< \brief (ACIFC_SR) AC4 Ready */
#define ACIFC_SR_ACCS5              (0x1u << 10) /**< \brief (ACIFC_SR) AC5 Current Comparison Status */
#define ACIFC_SR_ACRDY5             (0x1u << 11) /**< \brief (ACIFC_SR) AC5 Ready */
#define ACIFC_SR_ACCS6              (0x1u << 12) /**< \brief (ACIFC_SR) AC6 Current Comparison Status */
#define ACIFC_SR_ACRDY6             (0x1u << 13) /**< \brief (ACIFC_SR) AC6 Ready */
#define ACIFC_SR_ACCS7              (0x1u << 14) /**< \brief (ACIFC_SR) AC7 Current Comparison Status */
#define ACIFC_SR_ACRDY7             (0x1u << 15) /**< \brief (ACIFC_SR) AC7 Ready */
#define ACIFC_SR_WFCS0              (0x1u << 24) /**< \brief (ACIFC_SR) Window0 Mode Current Status */
#define ACIFC_SR_WFCS1              (0x1u << 25) /**< \brief (ACIFC_SR) Window1 Mode Current Status */
#define ACIFC_SR_WFCS2              (0x1u << 26) /**< \brief (ACIFC_SR) Window2 Mode Current Status */
#define ACIFC_SR_WFCS3              (0x1u << 27) /**< \brief (ACIFC_SR) Window3 Mode Current Status */
/* -------- ACIFC_IER : (ACIFC Offset: 0x10) Interrupt Enable Register -------- */
#define ACIFC_IER_ACINT0            (0x1u <<  0) /**< \brief (ACIFC_IER) AC0 Interrupt Enable */
#define ACIFC_IER_SUTINT0           (0x1u <<  1) /**< \brief (ACIFC_IER) AC0 Startup Time Interrupt Enable */
#define ACIFC_IER_ACINT1            (0x1u <<  2) /**< \brief (ACIFC_IER) AC1 Interrupt Enable */
#define ACIFC_IER_SUTINT1           (0x1u <<  3) /**< \brief (ACIFC_IER) AC1 Startup Time Interrupt Enable */
#define ACIFC_IER_ACINT2            (0x1u <<  4) /**< \brief (ACIFC_IER) AC2 Interrupt Enable */
#define ACIFC_IER_SUTINT2           (0x1u <<  5) /**< \brief (ACIFC_IER) AC2 Startup Time Interrupt Enable */
#define ACIFC_IER_ACINT3            (0x1u <<  6) /**< \brief (ACIFC_IER) AC3 Interrupt Enable */
#define ACIFC_IER_SUTINT3           (0x1u <<  7) /**< \brief (ACIFC_IER) AC3 Startup Time Interrupt Enable */
#define ACIFC_IER_ACINT4            (0x1u <<  8) /**< \brief (ACIFC_IER) AC4 Interrupt Enable */
#define ACIFC_IER_SUTINT4           (0x1u <<  9) /**< \brief (ACIFC_IER) AC4 Startup Time Interrupt Enable */
#define ACIFC_IER_ACINT5            (0x1u << 10) /**< \brief (ACIFC_IER) AC5 Interrupt Enable */
#define ACIFC_IER_SUTINT5           (0x1u << 11) /**< \brief (ACIFC_IER) AC5 Startup Time Interrupt Enable */
#define ACIFC_IER_ACINT6            (0x1u << 12) /**< \brief (ACIFC_IER) AC6 Interrupt Enable */
#define ACIFC_IER_SUTINT6           (0x1u << 13) /**< \brief (ACIFC_IER) AC6 Startup Time Interrupt Enable */
#define ACIFC_IER_ACINT7            (0x1u << 14) /**< \brief (ACIFC_IER) AC7 Interrupt Enable */
#define ACIFC_IER_SUTINT7           (0x1u << 15) /**< \brief (ACIFC_IER) AC7 Startup Time Interrupt Enable */
#define ACIFC_IER_WFINT0            (0x1u << 24) /**< \brief (ACIFC_IER) Window0 Mode Interrupt Enable */
#define ACIFC_IER_WFINT1            (0x1u << 25) /**< \brief (ACIFC_IER) Window1 Mode Interrupt Enable */
#define ACIFC_IER_WFINT2            (0x1u << 26) /**< \brief (ACIFC_IER) Window2 Mode Interrupt Enable */
#define ACIFC_IER_WFINT3            (0x1u << 27) /**< \brief (ACIFC_IER) Window3 Mode Interrupt Enable */
/* -------- ACIFC_IDR : (ACIFC Offset: 0x14) Interrupt Disable Register -------- */
#define ACIFC_IDR_ACINT0            (0x1u <<  0) /**< \brief (ACIFC_IDR) AC0 Interrupt Disable */
#define ACIFC_IDR_SUTINT0           (0x1u <<  1) /**< \brief (ACIFC_IDR) AC0 Startup Time Interrupt Disable */
#define ACIFC_IDR_ACINT1            (0x1u <<  2) /**< \brief (ACIFC_IDR) AC1 Interrupt Disable */
#define ACIFC_IDR_SUTINT1           (0x1u <<  3) /**< \brief (ACIFC_IDR) AC1 Startup Time Interrupt Disable */
#define ACIFC_IDR_ACINT2            (0x1u <<  4) /**< \brief (ACIFC_IDR) AC2 Interrupt Disable */
#define ACIFC_IDR_SUTINT2           (0x1u <<  5) /**< \brief (ACIFC_IDR) AC2 Startup Time Interrupt Disable */
#define ACIFC_IDR_ACINT3            (0x1u <<  6) /**< \brief (ACIFC_IDR) AC3 Interrupt Disable */
#define ACIFC_IDR_SUTINT3           (0x1u <<  7) /**< \brief (ACIFC_IDR) AC3 Startup Time Interrupt Disable */
#define ACIFC_IDR_ACINT4            (0x1u <<  8) /**< \brief (ACIFC_IDR) AC4 Interrupt Disable */
#define ACIFC_IDR_SUTINT4           (0x1u <<  9) /**< \brief (ACIFC_IDR) AC4 Startup Time Interrupt Disable */
#define ACIFC_IDR_ACINT5            (0x1u << 10) /**< \brief (ACIFC_IDR) AC5 Interrupt Disable */
#define ACIFC_IDR_SUTINT5           (0x1u << 11) /**< \brief (ACIFC_IDR) AC5 Startup Time Interrupt Disable */
#define ACIFC_IDR_ACINT6            (0x1u << 12) /**< \brief (ACIFC_IDR) AC6 Interrupt Disable */
#define ACIFC_IDR_SUTINT6           (0x1u << 13) /**< \brief (ACIFC_IDR) AC6 Startup Time Interrupt Disable */
#define ACIFC_IDR_ACINT7            (0x1u << 14) /**< \brief (ACIFC_IDR) AC7 Interrupt Disable */
#define ACIFC_IDR_SUTINT7           (0x1u << 15) /**< \brief (ACIFC_IDR) AC7 Startup Time Interrupt Disable */
#define ACIFC_IDR_WFINT0            (0x1u << 24) /**< \brief (ACIFC_IDR) Window0 Mode Interrupt Disable */
#define ACIFC_IDR_WFINT1            (0x1u << 25) /**< \brief (ACIFC_IDR) Window1 Mode Interrupt Disable */
#define ACIFC_IDR_WFINT2            (0x1u << 26) /**< \brief (ACIFC_IDR) Window2 Mode Interrupt Disable */
#define ACIFC_IDR_WFINT3            (0x1u << 27) /**< \brief (ACIFC_IDR) Window3 Mode Interrupt Disable */
/* -------- ACIFC_IMR : (ACIFC Offset: 0x18) Interrupt Mask Register -------- */
#define ACIFC_IMR_ACINT0            (0x1u <<  0) /**< \brief (ACIFC_IMR) AC0 Interrupt Mask */
#define ACIFC_IMR_SUTINT0           (0x1u <<  1) /**< \brief (ACIFC_IMR) AC0 Startup Time Interrupt Mask */
#define ACIFC_IMR_ACINT1            (0x1u <<  2) /**< \brief (ACIFC_IMR) AC1 Interrupt Mask */
#define ACIFC_IMR_SUTINT1           (0x1u <<  3) /**< \brief (ACIFC_IMR) AC1 Startup Time Interrupt Mask */
#define ACIFC_IMR_ACINT2            (0x1u <<  4) /**< \brief (ACIFC_IMR) AC2 Interrupt Mask */
#define ACIFC_IMR_SUTINT2           (0x1u <<  5) /**< \brief (ACIFC_IMR) AC2 Startup Time Interrupt Mask */
#define ACIFC_IMR_ACINT3            (0x1u <<  6) /**< \brief (ACIFC_IMR) AC3 Interrupt Mask */
#define ACIFC_IMR_SUTINT3           (0x1u <<  7) /**< \brief (ACIFC_IMR) AC3 Startup Time Interrupt Mask */
#define ACIFC_IMR_ACINT4            (0x1u <<  8) /**< \brief (ACIFC_IMR) AC4 Interrupt Mask */
#define ACIFC_IMR_SUTINT4           (0x1u <<  9) /**< \brief (ACIFC_IMR) AC4 Startup Time Interrupt Mask */
#define ACIFC_IMR_ACINT5            (0x1u << 10) /**< \brief (ACIFC_IMR) AC5 Interrupt Mask */
#define ACIFC_IMR_SUTINT5           (0x1u << 11) /**< \brief (ACIFC_IMR) AC5 Startup Time Interrupt Mask */
#define ACIFC_IMR_ACINT6            (0x1u << 12) /**< \brief (ACIFC_IMR) AC6 Interrupt Mask */
#define ACIFC_IMR_SUTINT6           (0x1u << 13) /**< \brief (ACIFC_IMR) AC6 Startup Time Interrupt Mask */
#define ACIFC_IMR_ACINT7            (0x1u << 14) /**< \brief (ACIFC_IMR) AC7 Interrupt Mask */
#define ACIFC_IMR_SUTINT7           (0x1u << 15) /**< \brief (ACIFC_IMR) AC7 Startup Time Interrupt Mask */
#define ACIFC_IMR_WFINT0            (0x1u << 24) /**< \brief (ACIFC_IMR) Window0 Mode Interrupt Mask */
#define ACIFC_IMR_WFINT1            (0x1u << 25) /**< \brief (ACIFC_IMR) Window1 Mode Interrupt Mask */
#define ACIFC_IMR_WFINT2            (0x1u << 26) /**< \brief (ACIFC_IMR) Window2 Mode Interrupt Mask */
#define ACIFC_IMR_WFINT3            (0x1u << 27) /**< \brief (ACIFC_IMR) Window3 Mode Interrupt Mask */
/* -------- ACIFC_ISR : (ACIFC Offset: 0x1C) Interrupt Status Register -------- */
#define ACIFC_ISR_ACINT0            (0x1u <<  0) /**< \brief (ACIFC_ISR) AC0 Interrupt Status */
#define ACIFC_ISR_SUTINT0           (0x1u <<  1) /**< \brief (ACIFC_ISR) AC0 Startup Time Interrupt Status */
#define ACIFC_ISR_ACINT1            (0x1u <<  2) /**< \brief (ACIFC_ISR) AC1 Interrupt Status */
#define ACIFC_ISR_SUTINT1           (0x1u <<  3) /**< \brief (ACIFC_ISR) AC1 Startup Time Interrupt Status */
#define ACIFC_ISR_ACINT2            (0x1u <<  4) /**< \brief (ACIFC_ISR) AC2 Interrupt Status */
#define ACIFC_ISR_SUTINT2           (0x1u <<  5) /**< \brief (ACIFC_ISR) AC2 Startup Time Interrupt Status */
#define ACIFC_ISR_ACINT3            (0x1u <<  6) /**< \brief (ACIFC_ISR) AC3 Interrupt Status */
#define ACIFC_ISR_SUTINT3           (0x1u <<  7) /**< \brief (ACIFC_ISR) AC3 Startup Time Interrupt Status */
#define ACIFC_ISR_ACINT4            (0x1u <<  8) /**< \brief (ACIFC_ISR) AC4 Interrupt Status */
#define ACIFC_ISR_SUTINT4           (0x1u <<  9) /**< \brief (ACIFC_ISR) AC4 Startup Time Interrupt Status */
#define ACIFC_ISR_ACINT5            (0x1u << 10) /**< \brief (ACIFC_ISR) AC5 Interrupt Status */
#define ACIFC_ISR_SUTINT5           (0x1u << 11) /**< \brief (ACIFC_ISR) AC5 Startup Time Interrupt Status */
#define ACIFC_ISR_ACINT6            (0x1u << 12) /**< \brief (ACIFC_ISR) AC6 Interrupt Status */
#define ACIFC_ISR_SUTINT6           (0x1u << 13) /**< \brief (ACIFC_ISR) AC6 Startup Time Interrupt Status */
#define ACIFC_ISR_ACINT7            (0x1u << 14) /**< \brief (ACIFC_ISR) AC7 Interrupt Status */
#define ACIFC_ISR_SUTINT7           (0x1u << 15) /**< \brief (ACIFC_ISR) AC7 Startup Time Interrupt Status */
#define ACIFC_ISR_WFINT0            (0x1u << 24) /**< \brief (ACIFC_ISR) Window0 Mode Interrupt Status */
#define ACIFC_ISR_WFINT1            (0x1u << 25) /**< \brief (ACIFC_ISR) Window1 Mode Interrupt Status */
#define ACIFC_ISR_WFINT2            (0x1u << 26) /**< \brief (ACIFC_ISR) Window2 Mode Interrupt Status */
#define ACIFC_ISR_WFINT3            (0x1u << 27) /**< \brief (ACIFC_ISR) Window3 Mode Interrupt Status */
/* -------- ACIFC_ICR : (ACIFC Offset: 0x20) Interrupt Status Clear Register -------- */
#define ACIFC_ICR_ACINT0            (0x1u <<  0) /**< \brief (ACIFC_ICR) AC0 Interrupt Status Clear */
#define ACIFC_ICR_SUTINT0           (0x1u <<  1) /**< \brief (ACIFC_ICR) AC0 Startup Time Interrupt Status Clear */
#define ACIFC_ICR_ACINT1            (0x1u <<  2) /**< \brief (ACIFC_ICR) AC1 Interrupt Status Clear */
#define ACIFC_ICR_SUTINT1           (0x1u <<  3) /**< \brief (ACIFC_ICR) AC1 Startup Time Interrupt Status Clear */
#define ACIFC_ICR_ACINT2            (0x1u <<  4) /**< \brief (ACIFC_ICR) AC2 Interrupt Status Clear */
#define ACIFC_ICR_SUTINT2           (0x1u <<  5) /**< \brief (ACIFC_ICR) AC2 Startup Time Interrupt Status Clear */
#define ACIFC_ICR_ACINT3            (0x1u <<  6) /**< \brief (ACIFC_ICR) AC3 Interrupt Status Clear */
#define ACIFC_ICR_SUTINT3           (0x1u <<  7) /**< \brief (ACIFC_ICR) AC3 Startup Time Interrupt Status Clear */
#define ACIFC_ICR_ACINT4            (0x1u <<  8) /**< \brief (ACIFC_ICR) AC4 Interrupt Status Clear */
#define ACIFC_ICR_SUTINT4           (0x1u <<  9) /**< \brief (ACIFC_ICR) AC4 Startup Time Interrupt Status Clear */
#define ACIFC_ICR_ACINT5            (0x1u << 10) /**< \brief (ACIFC_ICR) AC5 Interrupt Status Clear */
#define ACIFC_ICR_SUTINT5           (0x1u << 11) /**< \brief (ACIFC_ICR) AC5 Startup Time Interrupt Status Clear */
#define ACIFC_ICR_ACINT6            (0x1u << 12) /**< \brief (ACIFC_ICR) AC6 Interrupt Status Clear */
#define ACIFC_ICR_SUTINT6           (0x1u << 13) /**< \brief (ACIFC_ICR) AC6 Startup Time Interrupt Status Clear */
#define ACIFC_ICR_ACINT7            (0x1u << 14) /**< \brief (ACIFC_ICR) AC7 Interrupt Status Clear */
#define ACIFC_ICR_SUTINT7           (0x1u << 15) /**< \brief (ACIFC_ICR) AC7 Startup Time Interrupt Status Clear */
#define ACIFC_ICR_WFINT0            (0x1u << 24) /**< \brief (ACIFC_ICR) Window0 Mode Interrupt Status Clear */
#define ACIFC_ICR_WFINT1            (0x1u << 25) /**< \brief (ACIFC_ICR) Window1 Mode Interrupt Status Clear */
#define ACIFC_ICR_WFINT2            (0x1u << 26) /**< \brief (ACIFC_ICR) Window2 Mode Interrupt Status Clear */
#define ACIFC_ICR_WFINT3            (0x1u << 27) /**< \brief (ACIFC_ICR) Window3 Mode Interrupt Status Clear */
/* -------- ACIFC_TR : (ACIFC Offset: 0x24) Test Register -------- */
#define ACIFC_TR_ACTEST0            (0x1u <<  0) /**< \brief (ACIFC_TR) AC0 Output Override Value */
#define ACIFC_TR_ACTEST1            (0x1u <<  1) /**< \brief (ACIFC_TR) AC1 Output Override Value */
#define ACIFC_TR_ACTEST2            (0x1u <<  2) /**< \brief (ACIFC_TR) AC2 Output Override Value */
#define ACIFC_TR_ACTEST3            (0x1u <<  3) /**< \brief (ACIFC_TR) AC3 Output Override Value */
#define ACIFC_TR_ACTEST4            (0x1u <<  4) /**< \brief (ACIFC_TR) AC4 Output Override Value */
#define ACIFC_TR_ACTEST5            (0x1u <<  5) /**< \brief (ACIFC_TR) AC5 Output Override Value */
#define ACIFC_TR_ACTEST6            (0x1u <<  6) /**< \brief (ACIFC_TR) AC6 Output Override Value */
#define ACIFC_TR_ACTEST7            (0x1u <<  7) /**< \brief (ACIFC_TR) AC7 Output Override Value */
/* -------- ACIFC_PARAMETER : (ACIFC Offset: 0x30) Parameter Register -------- */
#define ACIFC_PARAMETER_ACIMPL0     (0x1u <<  0) /**< \brief (ACIFC_PARAMETER) Analog Comparator 0 Implemented */
#define ACIFC_PARAMETER_ACIMPL1     (0x1u <<  1) /**< \brief (ACIFC_PARAMETER) Analog Comparator 1 Implemented */
#define ACIFC_PARAMETER_ACIMPL2     (0x1u <<  2) /**< \brief (ACIFC_PARAMETER) Analog Comparator 2 Implemented */
#define ACIFC_PARAMETER_ACIMPL3     (0x1u <<  3) /**< \brief (ACIFC_PARAMETER) Analog Comparator 3 Implemented */
#define ACIFC_PARAMETER_ACIMPL4     (0x1u <<  4) /**< \brief (ACIFC_PARAMETER) Analog Comparator 4 Implemented */
#define ACIFC_PARAMETER_ACIMPL5     (0x1u <<  5) /**< \brief (ACIFC_PARAMETER) Analog Comparator 5 Implemented */
#define ACIFC_PARAMETER_ACIMPL6     (0x1u <<  6) /**< \brief (ACIFC_PARAMETER) Analog Comparator 6 Implemented */
#define ACIFC_PARAMETER_ACIMPL7     (0x1u <<  7) /**< \brief (ACIFC_PARAMETER) Analog Comparator 7 Implemented */
#define ACIFC_PARAMETER_WIMPL0      (0x1u << 16) /**< \brief (ACIFC_PARAMETER) Window0 Mode  Implemented */
#define ACIFC_PARAMETER_WIMPL1      (0x1u << 17) /**< \brief (ACIFC_PARAMETER) Window1 Mode  Implemented */
#define ACIFC_PARAMETER_WIMPL2      (0x1u << 18) /**< \brief (ACIFC_PARAMETER) Window2 Mode  Implemented */
#define ACIFC_PARAMETER_WIMPL3      (0x1u << 19) /**< \brief (ACIFC_PARAMETER) Window3 Mode  Implemented */
/* -------- ACIFC_VERSION : (ACIFC Offset: 0x34) Version Register -------- */
#define ACIFC_VERSION_VERSION_Pos    0
#define ACIFC_VERSION_VERSION_Msk    (0xFFFu << ACIFC_VERSION_VERSION_Pos) /**< \brief (ACIFC_VERSION) Version Number */
#define ACIFC_VERSION_VERSION(value) ((ACIFC_VERSION_VERSION_Msk & ((value) << ACIFC_VERSION_VERSION_Pos)))
#define ACIFC_VERSION_VARIANT_Pos    16
#define ACIFC_VERSION_VARIANT_Msk    (0xFu << ACIFC_VERSION_VARIANT_Pos) /**< \brief (ACIFC_VERSION) Variant Number */
#define ACIFC_VERSION_VARIANT(value) ((ACIFC_VERSION_VARIANT_Msk & ((value) << ACIFC_VERSION_VARIANT_Pos)))
/* -------- ACIFC_CONFW : (ACIFC Offset: 0x80) Confw Window configuration Register -------- */
#define ACIFC_CONFW_WIS_Pos         0
#define ACIFC_CONFW_WIS_Msk         (0x7u << ACIFC_CONFW_WIS_Pos) /**< \brief (ACIFC_CONFW) Window Mode Interrupt Settings */
#define ACIFC_CONFW_WIS(value)      ((ACIFC_CONFW_WIS_Msk & ((value) << ACIFC_CONFW_WIS_Pos)))
#define ACIFC_CONFW_WEVSRC_Pos      8
#define ACIFC_CONFW_WEVSRC_Msk      (0x7u << ACIFC_CONFW_WEVSRC_Pos) /**< \brief (ACIFC_CONFW) Peripheral Event Sourse Selection for Window Mode */
#define ACIFC_CONFW_WEVSRC(value)   ((ACIFC_CONFW_WEVSRC_Msk & ((value) << ACIFC_CONFW_WEVSRC_Pos)))
#define ACIFC_CONFW_WEVEN           (0x1u << 11) /**< \brief (ACIFC_CONFW) Window Peripheral Event Enable */
#define ACIFC_CONFW_WFEN            (0x1u << 16) /**< \brief (ACIFC_CONFW) Window Mode Enable */
/* -------- ACIFC_CONF : (ACIFC Offset: 0xD0) Conf AC Configuration Register -------- */
#define ACIFC_CONF_IS_Pos           0
#define ACIFC_CONF_IS_Msk           (0x3u << ACIFC_CONF_IS_Pos) /**< \brief (ACIFC_CONF) Interupt Settings */
#define ACIFC_CONF_IS(value)        ((ACIFC_CONF_IS_Msk & ((value) << ACIFC_CONF_IS_Pos)))
#define ACIFC_CONF_MODE_Pos         4
#define ACIFC_CONF_MODE_Msk         (0x3u << ACIFC_CONF_MODE_Pos) /**< \brief (ACIFC_CONF) Analog Comparator Mode */
#define ACIFC_CONF_MODE(value)      ((ACIFC_CONF_MODE_Msk & ((value) << ACIFC_CONF_MODE_Pos)))
#define ACIFC_CONF_INSELN_Pos       8
#define ACIFC_CONF_INSELN_Msk       (0x3u << ACIFC_CONF_INSELN_Pos) /**< \brief (ACIFC_CONF) Negative Input Select */
#define ACIFC_CONF_INSELN(value)    ((ACIFC_CONF_INSELN_Msk & ((value) << ACIFC_CONF_INSELN_Pos)))
#define ACIFC_CONF_EVENN            (0x1u << 16) /**< \brief (ACIFC_CONF) Peripheral Event Enable Negative */
#define ACIFC_CONF_EVENP            (0x1u << 17) /**< \brief (ACIFC_CONF) Peripheral Event Enable Positive */
#define ACIFC_CONF_HYS_Pos          24
#define ACIFC_CONF_HYS_Msk          (0x3u << ACIFC_CONF_HYS_Pos) /**< \brief (ACIFC_CONF) Hysteresis Voltage Value */
#define ACIFC_CONF_HYS(value)       ((ACIFC_CONF_HYS_Msk & ((value) << ACIFC_CONF_HYS_Pos)))
#define ACIFC_CONF_FAST             (0x1u << 26) /**< \brief (ACIFC_CONF) Fast Mode Enable */
#define ACIFC_CONF_ALWAYSON         (0x1u << 27) /**< \brief (ACIFC_CONF) Always On */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR ADCIFE */
/* ============================================================================= */
/** \addtogroup SAM4L4_ADCIFE ADC controller interface */
/*@{*/

#define REV_ADCIFE     0x100

#ifndef __ASSEMBLY__
/** \brief ADCIFE hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (ADCIFE Offset: 0x00) Control Register */
  RwReg   CFG;         /**< \brief (ADCIFE Offset: 0x04) Configuration Register */
  RoReg   SR;          /**< \brief (ADCIFE Offset: 0x08) Status Register */
  WoReg   SCR;         /**< \brief (ADCIFE Offset: 0x0C) Status Clear Register */
  RwReg   RTS;         /**< \brief (ADCIFE Offset: 0x10) Resistive Touch Screen Register */
  RwReg   SEQCFG;      /**< \brief (ADCIFE Offset: 0x14) Sequencer Configuration Register */
  WoReg   CDMA;        /**< \brief (ADCIFE Offset: 0x18) Configuration Direct Memory Access Register */
  RwReg   TIM;         /**< \brief (ADCIFE Offset: 0x1C) Timing Configuration Register */
  RwReg   ITIMER;      /**< \brief (ADCIFE Offset: 0x20) Internal Timer Register */
  RwReg   WCFG;        /**< \brief (ADCIFE Offset: 0x24) Window Monitor Configuration Register */
  RwReg   WTH;         /**< \brief (ADCIFE Offset: 0x28) Window Monitor Threshold Configuration Register */
  RoReg   LCV;         /**< \brief (ADCIFE Offset: 0x2C) Sequencer Last Converted Value Register */
  WoReg   IER;         /**< \brief (ADCIFE Offset: 0x30) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (ADCIFE Offset: 0x34) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (ADCIFE Offset: 0x38) Interrupt Mask Register */
  RwReg   CALIB;       /**< \brief (ADCIFE Offset: 0x3C) Calibration Register */
  RoReg   VERSION;     /**< \brief (ADCIFE Offset: 0x40) Version Register */
  RoReg   PARAMETER;   /**< \brief (ADCIFE Offset: 0x44) Parameter Register */
} Adcife;
#endif /* __ASSEMBLY__ */
/* -------- ADCIFE_CR : (ADCIFE Offset: 0x00) Control Register -------- */
#define ADCIFE_CR_SWRST             (0x1u <<  0) /**< \brief (ADCIFE_CR) Software reset */
#define ADCIFE_CR_TSTOP             (0x1u <<  1) /**< \brief (ADCIFE_CR) Internal timer stop bit */
#define ADCIFE_CR_TSTART            (0x1u <<  2) /**< \brief (ADCIFE_CR) Internal timer start bit */
#define ADCIFE_CR_STRIG             (0x1u <<  3) /**< \brief (ADCIFE_CR) Sequencer trigger */
#define ADCIFE_CR_REFBUFEN          (0x1u <<  4) /**< \brief (ADCIFE_CR) Reference buffer enable */
#define ADCIFE_CR_REFBUFDIS         (0x1u <<  5) /**< \brief (ADCIFE_CR) Reference buffer disable */
#define ADCIFE_CR_EN                (0x1u <<  8) /**< \brief (ADCIFE_CR) ADCIFD enable */
#define ADCIFE_CR_DIS               (0x1u <<  9) /**< \brief (ADCIFE_CR) ADCIFD disable */
#define ADCIFE_CR_BGREQEN           (0x1u << 10) /**< \brief (ADCIFE_CR) Bandgap buffer request enable */
#define ADCIFE_CR_BGREQDIS          (0x1u << 11) /**< \brief (ADCIFE_CR) Bandgap buffer request disable */
/* -------- ADCIFE_CFG : (ADCIFE Offset: 0x04) Configuration Register -------- */
#define ADCIFE_CFG_REFSEL_Pos       1
#define ADCIFE_CFG_REFSEL_Msk       (0x7u << ADCIFE_CFG_REFSEL_Pos) /**< \brief (ADCIFE_CFG) ADC Reference Selection */
#define ADCIFE_CFG_REFSEL(value)    ((ADCIFE_CFG_REFSEL_Msk & ((value) << ADCIFE_CFG_REFSEL_Pos)))
#define ADCIFE_CFG_SPEED_Pos        4
#define ADCIFE_CFG_SPEED_Msk        (0x3u << ADCIFE_CFG_SPEED_Pos) /**< \brief (ADCIFE_CFG) ADC current reduction */
#define ADCIFE_CFG_SPEED(value)     ((ADCIFE_CFG_SPEED_Msk & ((value) << ADCIFE_CFG_SPEED_Pos)))
#define ADCIFE_CFG_CLKSEL           (0x1u <<  6) /**< \brief (ADCIFE_CFG) Clock Selection for sequencer/ADC cell */
#define ADCIFE_CFG_PRESCAL_Pos      8
#define ADCIFE_CFG_PRESCAL_Msk      (0x7u << ADCIFE_CFG_PRESCAL_Pos) /**< \brief (ADCIFE_CFG) Prescaler Rate Selection */
#define ADCIFE_CFG_PRESCAL(value)   ((ADCIFE_CFG_PRESCAL_Msk & ((value) << ADCIFE_CFG_PRESCAL_Pos)))
/* -------- ADCIFE_SR : (ADCIFE Offset: 0x08) Status Register -------- */
#define ADCIFE_SR_SEOC              (0x1u <<  0) /**< \brief (ADCIFE_SR) Sequencer end of conversion */
#define ADCIFE_SR_LOVR              (0x1u <<  1) /**< \brief (ADCIFE_SR) Sequencer last converted value overrun */
#define ADCIFE_SR_WM                (0x1u <<  2) /**< \brief (ADCIFE_SR) Window monitor */
#define ADCIFE_SR_SMTRG             (0x1u <<  3) /**< \brief (ADCIFE_SR) Sequencer missed trigger event */
#define ADCIFE_SR_SUTD              (0x1u <<  4) /**< \brief (ADCIFE_SR) Start-up time done */
#define ADCIFE_SR_TTO               (0x1u <<  5) /**< \brief (ADCIFE_SR) Timer time-out */
#define ADCIFE_SR_EN                (0x1u << 24) /**< \brief (ADCIFE_SR) Enable Status */
#define ADCIFE_SR_TBUSY             (0x1u << 25) /**< \brief (ADCIFE_SR) Timer busy */
#define ADCIFE_SR_SBUSY             (0x1u << 26) /**< \brief (ADCIFE_SR) Sequencer busy */
#define ADCIFE_SR_CBUSY             (0x1u << 27) /**< \brief (ADCIFE_SR) Conversion busy */
#define ADCIFE_SR_REFBUF            (0x1u << 28) /**< \brief (ADCIFE_SR) Reference buffer status */
/* -------- ADCIFE_SCR : (ADCIFE Offset: 0x0C) Status Clear Register -------- */
#define ADCIFE_SCR_SEOC             (0x1u <<  0) /**< \brief (ADCIFE_SCR) Sequencer end of conversion */
#define ADCIFE_SCR_LOVR             (0x1u <<  1) /**< \brief (ADCIFE_SCR) Sequencer last converted value overrun */
#define ADCIFE_SCR_WM               (0x1u <<  2) /**< \brief (ADCIFE_SCR) Window monitor */
#define ADCIFE_SCR_SMTRG            (0x1u <<  3) /**< \brief (ADCIFE_SCR) Sequencer missed trigger event */
#define ADCIFE_SCR_SUTD             (0x1u <<  4) /**< \brief (ADCIFE_SCR) Start-up time done */
#define ADCIFE_SCR_TTO              (0x1u <<  5) /**< \brief (ADCIFE_SCR) Timer time-out */
/* -------- ADCIFE_RTS : (ADCIFE Offset: 0x10) Resistive Touch Screen Register -------- */
/* -------- ADCIFE_SEQCFG : (ADCIFE Offset: 0x14) Sequencer Configuration Register -------- */
#define ADCIFE_SEQCFG_HWLA          (0x1u <<  0) /**< \brief (ADCIFE_SEQCFG) Half word left adjust */
#define ADCIFE_SEQCFG_BIPOLAR       (0x1u <<  2) /**< \brief (ADCIFE_SEQCFG) Bipolar Mode */
#define ADCIFE_SEQCFG_GAIN_Pos      4
#define ADCIFE_SEQCFG_GAIN_Msk      (0x7u << ADCIFE_SEQCFG_GAIN_Pos) /**< \brief (ADCIFE_SEQCFG) Gain factor */
#define ADCIFE_SEQCFG_GAIN(value)   ((ADCIFE_SEQCFG_GAIN_Msk & ((value) << ADCIFE_SEQCFG_GAIN_Pos)))
#define ADCIFE_SEQCFG_GCOMP         (0x1u <<  7) /**< \brief (ADCIFE_SEQCFG) Gain Compensation */
#define ADCIFE_SEQCFG_TRGSEL_Pos    8
#define ADCIFE_SEQCFG_TRGSEL_Msk    (0x7u << ADCIFE_SEQCFG_TRGSEL_Pos) /**< \brief (ADCIFE_SEQCFG) Trigger selection */
#define ADCIFE_SEQCFG_TRGSEL(value) ((ADCIFE_SEQCFG_TRGSEL_Msk & ((value) << ADCIFE_SEQCFG_TRGSEL_Pos)))
#define ADCIFE_SEQCFG_RES           (0x1u << 12) /**< \brief (ADCIFE_SEQCFG) Resolution */
#define ADCIFE_SEQCFG_INTERNAL_Pos    14
#define ADCIFE_SEQCFG_INTERNAL_Msk    (0x3u << ADCIFE_SEQCFG_INTERNAL_Pos) /**< \brief (ADCIFE_SEQCFG) Internal Voltage Source Selection */
#define ADCIFE_SEQCFG_INTERNAL(value) ((ADCIFE_SEQCFG_INTERNAL_Msk & ((value) << ADCIFE_SEQCFG_INTERNAL_Pos)))
#define ADCIFE_SEQCFG_MUXPOS_Pos    16
#define ADCIFE_SEQCFG_MUXPOS_Msk    (0xFu << ADCIFE_SEQCFG_MUXPOS_Pos) /**< \brief (ADCIFE_SEQCFG) MUX selection on Positive ADC input channel */
#define ADCIFE_SEQCFG_MUXPOS(value) ((ADCIFE_SEQCFG_MUXPOS_Msk & ((value) << ADCIFE_SEQCFG_MUXPOS_Pos)))
#define ADCIFE_SEQCFG_MUXNEG_Pos    20
#define ADCIFE_SEQCFG_MUXNEG_Msk    (0x7u << ADCIFE_SEQCFG_MUXNEG_Pos) /**< \brief (ADCIFE_SEQCFG) MUX selection on Negative ADC input channel */
#define ADCIFE_SEQCFG_MUXNEG(value) ((ADCIFE_SEQCFG_MUXNEG_Msk & ((value) << ADCIFE_SEQCFG_MUXNEG_Pos)))
#define ADCIFE_SEQCFG_ZOOMRANGE_Pos    28
#define ADCIFE_SEQCFG_ZOOMRANGE_Msk    (0x7u << ADCIFE_SEQCFG_ZOOMRANGE_Pos) /**< \brief (ADCIFE_SEQCFG) Zoom shift/unipolar reference source selection */
#define ADCIFE_SEQCFG_ZOOMRANGE(value) ((ADCIFE_SEQCFG_ZOOMRANGE_Msk & ((value) << ADCIFE_SEQCFG_ZOOMRANGE_Pos)))
/* -------- ADCIFE_FIRST_DMA_WORD_CDMA : (ADCIFE Offset: 0x18) Configuration Direct Memory Access Register -------- */
#define ADCIFE_FIRST_DMA_WORD_CDMA_HWLA (0x1u <<  0) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_BIPOLAR (0x1u <<  2) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_STRIG (0x1u <<  3) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_GAIN_Pos    4
#define ADCIFE_FIRST_DMA_WORD_CDMA_GAIN_Msk    (0x7u << ADCIFE_FIRST_DMA_WORD_CDMA_GAIN_Pos) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_GAIN(value) ((ADCIFE_FIRST_DMA_WORD_CDMA_GAIN_Msk & ((value) << ADCIFE_FIRST_DMA_WORD_CDMA_GAIN_Pos)))
#define ADCIFE_FIRST_DMA_WORD_CDMA_GCOMP (0x1u <<  7) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_ENSTUP (0x1u <<  8) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_RES (0x1u << 12) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_TSS (0x1u << 13) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA) Internal timer start or stop bit */
#define ADCIFE_FIRST_DMA_WORD_CDMA_INTERNAL_Pos    14
#define ADCIFE_FIRST_DMA_WORD_CDMA_INTERNAL_Msk    (0x3u << ADCIFE_FIRST_DMA_WORD_CDMA_INTERNAL_Pos) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_INTERNAL(value) ((ADCIFE_FIRST_DMA_WORD_CDMA_INTERNAL_Msk & ((value) << ADCIFE_FIRST_DMA_WORD_CDMA_INTERNAL_Pos)))
#define ADCIFE_FIRST_DMA_WORD_CDMA_MUXPOS_Pos    16
#define ADCIFE_FIRST_DMA_WORD_CDMA_MUXPOS_Msk    (0xFu << ADCIFE_FIRST_DMA_WORD_CDMA_MUXPOS_Pos) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_MUXPOS(value) ((ADCIFE_FIRST_DMA_WORD_CDMA_MUXPOS_Msk & ((value) << ADCIFE_FIRST_DMA_WORD_CDMA_MUXPOS_Pos)))
#define ADCIFE_FIRST_DMA_WORD_CDMA_MUXNEG_Pos    20
#define ADCIFE_FIRST_DMA_WORD_CDMA_MUXNEG_Msk    (0x7u << ADCIFE_FIRST_DMA_WORD_CDMA_MUXNEG_Pos) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_MUXNEG(value) ((ADCIFE_FIRST_DMA_WORD_CDMA_MUXNEG_Msk & ((value) << ADCIFE_FIRST_DMA_WORD_CDMA_MUXNEG_Pos)))
#define ADCIFE_FIRST_DMA_WORD_CDMA_ZOOMRANGE_Pos    28
#define ADCIFE_FIRST_DMA_WORD_CDMA_ZOOMRANGE_Msk    (0x7u << ADCIFE_FIRST_DMA_WORD_CDMA_ZOOMRANGE_Pos) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA)  */
#define ADCIFE_FIRST_DMA_WORD_CDMA_ZOOMRANGE(value) ((ADCIFE_FIRST_DMA_WORD_CDMA_ZOOMRANGE_Msk & ((value) << ADCIFE_FIRST_DMA_WORD_CDMA_ZOOMRANGE_Pos)))
#define ADCIFE_FIRST_DMA_WORD_CDMA_DW (0x1u << 31) /**< \brief (ADCIFE_FIRST_DMA_WORD_CDMA) Double Word transmitting */
/* -------- ADCIFE_SECOND_DMA_WORD_CDMA : (ADCIFE Offset: 0x18) Configuration Direct Memory Access Register -------- */
#define ADCIFE_SECOND_DMA_WORD_CDMA_LT_Pos    0
#define ADCIFE_SECOND_DMA_WORD_CDMA_LT_Msk    (0xFFFu << ADCIFE_SECOND_DMA_WORD_CDMA_LT_Pos) /**< \brief (ADCIFE_SECOND_DMA_WORD_CDMA)  */
#define ADCIFE_SECOND_DMA_WORD_CDMA_LT(value) ((ADCIFE_SECOND_DMA_WORD_CDMA_LT_Msk & ((value) << ADCIFE_SECOND_DMA_WORD_CDMA_LT_Pos)))
#define ADCIFE_SECOND_DMA_WORD_CDMA_WM_Pos    12
#define ADCIFE_SECOND_DMA_WORD_CDMA_WM_Msk    (0x7u << ADCIFE_SECOND_DMA_WORD_CDMA_WM_Pos) /**< \brief (ADCIFE_SECOND_DMA_WORD_CDMA)  */
#define ADCIFE_SECOND_DMA_WORD_CDMA_WM(value) ((ADCIFE_SECOND_DMA_WORD_CDMA_WM_Msk & ((value) << ADCIFE_SECOND_DMA_WORD_CDMA_WM_Pos)))
#define ADCIFE_SECOND_DMA_WORD_CDMA_HT_Pos    16
#define ADCIFE_SECOND_DMA_WORD_CDMA_HT_Msk    (0xFFFu << ADCIFE_SECOND_DMA_WORD_CDMA_HT_Pos) /**< \brief (ADCIFE_SECOND_DMA_WORD_CDMA)  */
#define ADCIFE_SECOND_DMA_WORD_CDMA_HT(value) ((ADCIFE_SECOND_DMA_WORD_CDMA_HT_Msk & ((value) << ADCIFE_SECOND_DMA_WORD_CDMA_HT_Pos)))
#define ADCIFE_SECOND_DMA_WORD_CDMA_DW (0x1u << 31) /**< \brief (ADCIFE_SECOND_DMA_WORD_CDMA)  */
/* -------- ADCIFE_TIM : (ADCIFE Offset: 0x1C) Timing Configuration Register -------- */
#define ADCIFE_TIM_STARTUP_Pos      0
#define ADCIFE_TIM_STARTUP_Msk      (0x1Fu << ADCIFE_TIM_STARTUP_Pos) /**< \brief (ADCIFE_TIM) Startup time */
#define ADCIFE_TIM_STARTUP(value)   ((ADCIFE_TIM_STARTUP_Msk & ((value) << ADCIFE_TIM_STARTUP_Pos)))
#define ADCIFE_TIM_ENSTUP           (0x1u <<  8) /**< \brief (ADCIFE_TIM) Enable Startup */
/* -------- ADCIFE_ITIMER : (ADCIFE Offset: 0x20) Internal Timer Register -------- */
#define ADCIFE_ITIMER_ITMC_Pos      0
#define ADCIFE_ITIMER_ITMC_Msk      (0xFFFFu << ADCIFE_ITIMER_ITMC_Pos) /**< \brief (ADCIFE_ITIMER) Internal timer max counter */
#define ADCIFE_ITIMER_ITMC(value)   ((ADCIFE_ITIMER_ITMC_Msk & ((value) << ADCIFE_ITIMER_ITMC_Pos)))
/* -------- ADCIFE_WCFG : (ADCIFE Offset: 0x24) Window Monitor Configuration Register -------- */
#define ADCIFE_WCFG_WM_Pos          12
#define ADCIFE_WCFG_WM_Msk          (0x7u << ADCIFE_WCFG_WM_Pos) /**< \brief (ADCIFE_WCFG) Window Monitor Mode */
#define ADCIFE_WCFG_WM(value)       ((ADCIFE_WCFG_WM_Msk & ((value) << ADCIFE_WCFG_WM_Pos)))
/* -------- ADCIFE_WTH : (ADCIFE Offset: 0x28) Window Monitor Threshold Configuration Register -------- */
#define ADCIFE_WTH_LT_Pos           0
#define ADCIFE_WTH_LT_Msk           (0xFFFu << ADCIFE_WTH_LT_Pos) /**< \brief (ADCIFE_WTH) Low threshold */
#define ADCIFE_WTH_LT(value)        ((ADCIFE_WTH_LT_Msk & ((value) << ADCIFE_WTH_LT_Pos)))
#define ADCIFE_WTH_HT_Pos           16
#define ADCIFE_WTH_HT_Msk           (0xFFFu << ADCIFE_WTH_HT_Pos) /**< \brief (ADCIFE_WTH) High Threshold */
#define ADCIFE_WTH_HT(value)        ((ADCIFE_WTH_HT_Msk & ((value) << ADCIFE_WTH_HT_Pos)))
/* -------- ADCIFE_LCV : (ADCIFE Offset: 0x2C) Sequencer Last Converted Value Register -------- */
#define ADCIFE_LCV_LCV_Pos          0
#define ADCIFE_LCV_LCV_Msk          (0xFFFFu << ADCIFE_LCV_LCV_Pos) /**< \brief (ADCIFE_LCV) Last converted value */
#define ADCIFE_LCV_LCV(value)       ((ADCIFE_LCV_LCV_Msk & ((value) << ADCIFE_LCV_LCV_Pos)))
#define ADCIFE_LCV_LCPC_Pos         16
#define ADCIFE_LCV_LCPC_Msk         (0xFu << ADCIFE_LCV_LCPC_Pos) /**< \brief (ADCIFE_LCV) Last converted positive channel */
#define ADCIFE_LCV_LCPC(value)      ((ADCIFE_LCV_LCPC_Msk & ((value) << ADCIFE_LCV_LCPC_Pos)))
#define ADCIFE_LCV_LCNC_Pos         20
#define ADCIFE_LCV_LCNC_Msk         (0x7u << ADCIFE_LCV_LCNC_Pos) /**< \brief (ADCIFE_LCV) Last converted negative channel */
#define ADCIFE_LCV_LCNC(value)      ((ADCIFE_LCV_LCNC_Msk & ((value) << ADCIFE_LCV_LCNC_Pos)))
/* -------- ADCIFE_IER : (ADCIFE Offset: 0x30) Interrupt Enable Register -------- */
#define ADCIFE_IER_SEOC             (0x1u <<  0) /**< \brief (ADCIFE_IER) Sequencer end of conversion Interrupt Enable */
#define ADCIFE_IER_LOVR             (0x1u <<  1) /**< \brief (ADCIFE_IER) Sequencer last converted value overrun Interrupt Enable */
#define ADCIFE_IER_WM               (0x1u <<  2) /**< \brief (ADCIFE_IER) Window monitor Interrupt Enable */
#define ADCIFE_IER_SMTRG            (0x1u <<  3) /**< \brief (ADCIFE_IER) Sequencer missed trigger event Interrupt Enable */
#define ADCIFE_IER_SUTD             (0x1u <<  4) /**< \brief (ADCIFE_IER) Start-up time done */
#define ADCIFE_IER_TTO              (0x1u <<  5) /**< \brief (ADCIFE_IER) Timer time-out Interrupt Enable */
/* -------- ADCIFE_IDR : (ADCIFE Offset: 0x34) Interrupt Disable Register -------- */
#define ADCIFE_IDR_SEOC             (0x1u <<  0) /**< \brief (ADCIFE_IDR) Sequencer end of conversion Interrupt Disable */
#define ADCIFE_IDR_LOVR             (0x1u <<  1) /**< \brief (ADCIFE_IDR) Sequencer last converted value overrun Interrupt Disable */
#define ADCIFE_IDR_WM               (0x1u <<  2) /**< \brief (ADCIFE_IDR) Window monitor Interrupt Disable */
#define ADCIFE_IDR_SMTRG            (0x1u <<  3) /**< \brief (ADCIFE_IDR) Sequencer missed trigger event Interrupt Disable */
#define ADCIFE_IDR_SUTD             (0x1u <<  4) /**< \brief (ADCIFE_IDR) Start-up time done */
#define ADCIFE_IDR_TTO              (0x1u <<  5) /**< \brief (ADCIFE_IDR) Timer time-out Interrupt Disable */
/* -------- ADCIFE_IMR : (ADCIFE Offset: 0x38) Interrupt Mask Register -------- */
#define ADCIFE_IMR_SEOC             (0x1u <<  0) /**< \brief (ADCIFE_IMR) Sequencer end of conversion Interrupt Mask */
#define ADCIFE_IMR_LOVR             (0x1u <<  1) /**< \brief (ADCIFE_IMR) Sequencer last converted value overrun Interrupt Mask */
#define ADCIFE_IMR_WM               (0x1u <<  2) /**< \brief (ADCIFE_IMR) Window monitor Interrupt Mask */
#define ADCIFE_IMR_SMTRG            (0x1u <<  3) /**< \brief (ADCIFE_IMR) Sequencer missed trigger event Interrupt Mask */
#define ADCIFE_IMR_SUTD             (0x1u <<  4) /**< \brief (ADCIFE_IMR) Start-up time done */
#define ADCIFE_IMR_TTO              (0x1u <<  5) /**< \brief (ADCIFE_IMR) Timer time-out Interrupt Mask */
/* -------- ADCIFE_CALIB : (ADCIFE Offset: 0x3C) Calibration Register -------- */
#define ADCIFE_CALIB_CALIB_Pos      0
#define ADCIFE_CALIB_CALIB_Msk      (0xFFu << ADCIFE_CALIB_CALIB_Pos) /**< \brief (ADCIFE_CALIB) Calibration Value */
#define ADCIFE_CALIB_CALIB(value)   ((ADCIFE_CALIB_CALIB_Msk & ((value) << ADCIFE_CALIB_CALIB_Pos)))
#define ADCIFE_CALIB_BIASSEL        (0x1u <<  8) /**< \brief (ADCIFE_CALIB) Select bias mode */
#define ADCIFE_CALIB_BIASCAL_Pos    12
#define ADCIFE_CALIB_BIASCAL_Msk    (0xFu << ADCIFE_CALIB_BIASCAL_Pos) /**< \brief (ADCIFE_CALIB) Bias Calibration */
#define ADCIFE_CALIB_BIASCAL(value) ((ADCIFE_CALIB_BIASCAL_Msk & ((value) << ADCIFE_CALIB_BIASCAL_Pos)))
#define ADCIFE_CALIB_FCD            (0x1u << 16) /**< \brief (ADCIFE_CALIB) Flash Calibration Done */
/* -------- ADCIFE_VERSION : (ADCIFE Offset: 0x40) Version Register -------- */
#define ADCIFE_VERSION_VERSION_Pos    0
#define ADCIFE_VERSION_VERSION_Msk    (0xFFFu << ADCIFE_VERSION_VERSION_Pos) /**< \brief (ADCIFE_VERSION) Version number */
#define ADCIFE_VERSION_VERSION(value) ((ADCIFE_VERSION_VERSION_Msk & ((value) << ADCIFE_VERSION_VERSION_Pos)))
#define ADCIFE_VERSION_VARIANT_Pos    16
#define ADCIFE_VERSION_VARIANT_Msk    (0xFu << ADCIFE_VERSION_VARIANT_Pos) /**< \brief (ADCIFE_VERSION) Variant number */
#define ADCIFE_VERSION_VARIANT(value) ((ADCIFE_VERSION_VARIANT_Msk & ((value) << ADCIFE_VERSION_VARIANT_Pos)))
/* -------- ADCIFE_PARAMETER : (ADCIFE Offset: 0x44) Parameter Register -------- */
#define ADCIFE_PARAMETER_N_Pos      0
#define ADCIFE_PARAMETER_N_Msk      (0xFFu << ADCIFE_PARAMETER_N_Pos) /**< \brief (ADCIFE_PARAMETER) Number of channels */
#define ADCIFE_PARAMETER_N(value)   ((ADCIFE_PARAMETER_N_Msk & ((value) << ADCIFE_PARAMETER_N_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR AESA */
/* ============================================================================= */
/** \addtogroup SAM4L4_AESA Advanced Encryption Standard */
/*@{*/

#define REV_AESA       0x102

#ifndef __ASSEMBLY__
/** \brief AesaInitvect hardware registers */
typedef struct {
  WoReg   INITVECT;    /**< \brief (AesaInitvect Offset: 0x00) Initialization Vector Register 0 */
} AesaInitvect;
/** \brief AesaKey hardware registers */
typedef struct {
  WoReg   KEY;         /**< \brief (AesaKey Offset: 0x00) Key Register 0 */
} AesaKey;
/** \brief AESA hardware registers */
typedef struct {
  RwReg   CTRL;        /**< \brief (AESA Offset: 0x00) Control Register */
  RwReg   MODE;        /**< \brief (AESA Offset: 0x04) Mode Register */
  RwReg   DATABUFPTR;  /**< \brief (AESA Offset: 0x08) Data Buffer Pointer Register */
  RoReg   SR;          /**< \brief (AESA Offset: 0x0C) Status Register */
  WoReg   IER;         /**< \brief (AESA Offset: 0x10) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (AESA Offset: 0x14) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (AESA Offset: 0x18) Interrupt Mask Register */
  RoReg   Reserved1[1];
  AesaKey Key[8]; /**< \brief (AESA Offset: 0x20) AesaKey groups */
  AesaInitvect Initvect[4]; /**< \brief (AESA Offset: 0x40) AesaInitvect groups */
  WoReg   IDATA;       /**< \brief (AESA Offset: 0x50) Input Data Register */
  RoReg   Reserved2[3];
  RoReg   ODATA;       /**< \brief (AESA Offset: 0x60) Output Data Register */
  RoReg   Reserved3[3];
  WoReg   DRNGSEED;    /**< \brief (AESA Offset: 0x70) DRNG Seed Register */
  RoReg   Reserved4[33];
  RoReg   PARAMETER;   /**< \brief (AESA Offset: 0xF8) Parameter Register */
  RoReg   VERSION;     /**< \brief (AESA Offset: 0xFC) Version Register */
} Aesa;
#endif /* __ASSEMBLY__ */
/* -------- AESA_CTRL : (AESA Offset: 0x00) Control Register -------- */
#define AESA_CTRL_ENABLE            (0x1u <<  0) /**< \brief (AESA_CTRL) Enable Module */
#define AESA_CTRL_DKEYGEN           (0x1u <<  1) /**< \brief (AESA_CTRL) Decryption Key Generate */
#define AESA_CTRL_NEWMSG            (0x1u <<  2) /**< \brief (AESA_CTRL) New Message */
#define AESA_CTRL_SWRST             (0x1u <<  8) /**< \brief (AESA_CTRL) Software Reset */
/* -------- AESA_MODE : (AESA Offset: 0x04) Mode Register -------- */
#define AESA_MODE_ENCRYPT           (0x1u <<  0) /**< \brief (AESA_MODE) Encryption */
#define AESA_MODE_KEYSIZE_Pos       1
#define AESA_MODE_KEYSIZE_Msk       (0x3u << AESA_MODE_KEYSIZE_Pos) /**< \brief (AESA_MODE) Key Size */
#define AESA_MODE_KEYSIZE(value)    ((AESA_MODE_KEYSIZE_Msk & ((value) << AESA_MODE_KEYSIZE_Pos)))
#define AESA_MODE_DMA               (0x1u <<  3) /**< \brief (AESA_MODE) DMA Mode */
#define AESA_MODE_OPMODE_Pos        4
#define AESA_MODE_OPMODE_Msk        (0x7u << AESA_MODE_OPMODE_Pos) /**< \brief (AESA_MODE) Confidentiality Mode of Operation */
#define AESA_MODE_OPMODE(value)     ((AESA_MODE_OPMODE_Msk & ((value) << AESA_MODE_OPMODE_Pos)))
#define AESA_MODE_CFBS_Pos          8
#define AESA_MODE_CFBS_Msk          (0x7u << AESA_MODE_CFBS_Pos) /**< \brief (AESA_MODE) Cipher Feedback Data Segment Size */
#define AESA_MODE_CFBS(value)       ((AESA_MODE_CFBS_Msk & ((value) << AESA_MODE_CFBS_Pos)))
#define AESA_MODE_CTYPE_Pos         16
#define AESA_MODE_CTYPE_Msk         (0xFu << AESA_MODE_CTYPE_Pos) /**< \brief (AESA_MODE) Countermeasure Type */
#define AESA_MODE_CTYPE(value)      ((AESA_MODE_CTYPE_Msk & ((value) << AESA_MODE_CTYPE_Pos)))
/* -------- AESA_DATABUFPTR : (AESA Offset: 0x08) Data Buffer Pointer Register -------- */
#define AESA_DATABUFPTR_IDATAW_Pos    0
#define AESA_DATABUFPTR_IDATAW_Msk    (0x3u << AESA_DATABUFPTR_IDATAW_Pos) /**< \brief (AESA_DATABUFPTR) Input Data Word */
#define AESA_DATABUFPTR_IDATAW(value) ((AESA_DATABUFPTR_IDATAW_Msk & ((value) << AESA_DATABUFPTR_IDATAW_Pos)))
#define AESA_DATABUFPTR_ODATAW_Pos    4
#define AESA_DATABUFPTR_ODATAW_Msk    (0x3u << AESA_DATABUFPTR_ODATAW_Pos) /**< \brief (AESA_DATABUFPTR) Output Data Word */
#define AESA_DATABUFPTR_ODATAW(value) ((AESA_DATABUFPTR_ODATAW_Msk & ((value) << AESA_DATABUFPTR_ODATAW_Pos)))
/* -------- AESA_SR : (AESA Offset: 0x0C) Status Register -------- */
#define AESA_SR_ODATARDY            (0x1u <<  0) /**< \brief (AESA_SR) Output Data Ready */
#define AESA_SR_IBUFRDY             (0x1u << 16) /**< \brief (AESA_SR) Input Buffer Ready */
/* -------- AESA_IER : (AESA Offset: 0x10) Interrupt Enable Register -------- */
#define AESA_IER_ODATARDY           (0x1u <<  0) /**< \brief (AESA_IER) Output Data Ready Interrupt Enable */
#define AESA_IER_IBUFRDY            (0x1u << 16) /**< \brief (AESA_IER) Input Buffer Ready Interrupt Enable */
/* -------- AESA_IDR : (AESA Offset: 0x14) Interrupt Disable Register -------- */
#define AESA_IDR_ODATARDY           (0x1u <<  0) /**< \brief (AESA_IDR) Output Data Ready Interrupt Disable */
#define AESA_IDR_IBUFRDY            (0x1u << 16) /**< \brief (AESA_IDR) Input Buffer Ready Interrupt Disable */
/* -------- AESA_IMR : (AESA Offset: 0x18) Interrupt Mask Register -------- */
#define AESA_IMR_ODATARDY           (0x1u <<  0) /**< \brief (AESA_IMR) Output Data Ready Interrupt Mask */
#define AESA_IMR_IBUFRDY            (0x1u << 16) /**< \brief (AESA_IMR) Input Buffer Ready Interrupt Mask */
/* -------- AESA_KEY : (AESA Offset: 0x20) Key Key Register 0 -------- */
#define AESA_KEY_KEY0_Pos           0
#define AESA_KEY_KEY0_Msk           (0xFFFFFFFFu << AESA_KEY_KEY0_Pos) /**< \brief (AESA_KEY) Key Word 0 */
#define AESA_KEY_KEY0(value)        ((AESA_KEY_KEY0_Msk & ((value) << AESA_KEY_KEY0_Pos)))
/* -------- AESA_INITVECT : (AESA Offset: 0x40) Initvect Initialization Vector Register 0 -------- */
#define AESA_INITVECT_INITVECT0_Pos    0
#define AESA_INITVECT_INITVECT0_Msk    (0xFFFFFFFFu << AESA_INITVECT_INITVECT0_Pos) /**< \brief (AESA_INITVECT) Initialization Vector Word 0 */
#define AESA_INITVECT_INITVECT0(value) ((AESA_INITVECT_INITVECT0_Msk & ((value) << AESA_INITVECT_INITVECT0_Pos)))
/* -------- AESA_IDATA : (AESA Offset: 0x50) Input Data Register -------- */
#define AESA_IDATA_IDATA_Pos        0
#define AESA_IDATA_IDATA_Msk        (0xFFFFFFFFu << AESA_IDATA_IDATA_Pos) /**< \brief (AESA_IDATA) Input Data */
#define AESA_IDATA_IDATA(value)     ((AESA_IDATA_IDATA_Msk & ((value) << AESA_IDATA_IDATA_Pos)))
/* -------- AESA_ODATA : (AESA Offset: 0x60) Output Data Register -------- */
#define AESA_ODATA_ODATA_Pos        0
#define AESA_ODATA_ODATA_Msk        (0xFFFFFFFFu << AESA_ODATA_ODATA_Pos) /**< \brief (AESA_ODATA) Output Data */
#define AESA_ODATA_ODATA(value)     ((AESA_ODATA_ODATA_Msk & ((value) << AESA_ODATA_ODATA_Pos)))
/* -------- AESA_DRNGSEED : (AESA Offset: 0x70) DRNG Seed Register -------- */
#define AESA_DRNGSEED_SEED_Pos      0
#define AESA_DRNGSEED_SEED_Msk      (0xFFFFFFFFu << AESA_DRNGSEED_SEED_Pos) /**< \brief (AESA_DRNGSEED) DRNG Seed */
#define AESA_DRNGSEED_SEED(value)   ((AESA_DRNGSEED_SEED_Msk & ((value) << AESA_DRNGSEED_SEED_Pos)))
/* -------- AESA_PARAMETER : (AESA Offset: 0xF8) Parameter Register -------- */
#define AESA_PARAMETER_KEYSIZE_Pos    0
#define AESA_PARAMETER_KEYSIZE_Msk    (0x3u << AESA_PARAMETER_KEYSIZE_Pos) /**< \brief (AESA_PARAMETER) Maximum Key Size */
#define AESA_PARAMETER_KEYSIZE(value) ((AESA_PARAMETER_KEYSIZE_Msk & ((value) << AESA_PARAMETER_KEYSIZE_Pos)))
#define AESA_PARAMETER_OPMODE_Pos    2
#define AESA_PARAMETER_OPMODE_Msk    (0x7u << AESA_PARAMETER_OPMODE_Pos) /**< \brief (AESA_PARAMETER) Maximum Number of Confidentiality Modes of Operation */
#define AESA_PARAMETER_OPMODE(value) ((AESA_PARAMETER_OPMODE_Msk & ((value) << AESA_PARAMETER_OPMODE_Pos)))
#define AESA_PARAMETER_CTRMEAS      (0x1u <<  8) /**< \brief (AESA_PARAMETER) Countermeasures */
/* -------- AESA_VERSION : (AESA Offset: 0xFC) Version Register -------- */
#define AESA_VERSION_VERSION_Pos    0
#define AESA_VERSION_VERSION_Msk    (0xFFFu << AESA_VERSION_VERSION_Pos) /**< \brief (AESA_VERSION) Version Number */
#define AESA_VERSION_VERSION(value) ((AESA_VERSION_VERSION_Msk & ((value) << AESA_VERSION_VERSION_Pos)))
#define AESA_VERSION_VARIANT_Pos    16
#define AESA_VERSION_VARIANT_Msk    (0xFu << AESA_VERSION_VARIANT_Pos) /**< \brief (AESA_VERSION) Variant Number */
#define AESA_VERSION_VARIANT(value) ((AESA_VERSION_VARIANT_Msk & ((value) << AESA_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR AST */
/* ============================================================================= */
/** \addtogroup SAM4L4_AST Asynchronous Timer */
/*@{*/

#define REV_AST        0x311

#ifndef __ASSEMBLY__
/** \brief AST hardware registers */
typedef struct {
  RwReg   CR;          /**< \brief (AST Offset: 0x00) Control Register */
  RwReg   CV;          /**< \brief (AST Offset: 0x04) Counter Value */
  RoReg   SR;          /**< \brief (AST Offset: 0x08) Status Register */
  WoReg   SCR;         /**< \brief (AST Offset: 0x0C) Status Clear Register */
  WoReg   IER;         /**< \brief (AST Offset: 0x10) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (AST Offset: 0x14) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (AST Offset: 0x18) Interrupt Mask Register */
  RwReg   WER;         /**< \brief (AST Offset: 0x1C) Wake Enable Register */
  RwReg   AR0;         /**< \brief (AST Offset: 0x20) Alarm Register 0 */
  RwReg   AR1;         /**< \brief (AST Offset: 0x24) Alarm Register 1 */
  RoReg   Reserved1[2];
  RwReg   PIR0;        /**< \brief (AST Offset: 0x30) Periodic Interval Register 0 */
  RwReg   PIR1;        /**< \brief (AST Offset: 0x34) Periodic Interval Register 1 */
  RoReg   Reserved2[2];
  RwReg   CLOCK;       /**< \brief (AST Offset: 0x40) Clock Control Register */
  RwReg   DTR;         /**< \brief (AST Offset: 0x44) Digital Tuner Register */
  WoReg   EVE;         /**< \brief (AST Offset: 0x48) Event Enable Register */
  WoReg   EVD;         /**< \brief (AST Offset: 0x4C) Event Disable Register */
  RoReg   EVM;         /**< \brief (AST Offset: 0x50) Event Mask Register */
  RwReg   CALV;        /**< \brief (AST Offset: 0x54) Calendar Value */
  RoReg   Reserved3[38];
  RoReg   PARAMETER;   /**< \brief (AST Offset: 0xF0) Parameter Register */
  RoReg   Reserved4[2];
  RoReg   VERSION;     /**< \brief (AST Offset: 0xFC) Version Register */
} Ast;
#endif /* __ASSEMBLY__ */
/* -------- AST_CR : (AST Offset: 0x00) Control Register -------- */
#define AST_CR_EN                   (0x1u <<  0) /**< \brief (AST_CR) Enable */
#define   AST_CR_EN_0               (0x0u <<  0) /**< \brief (AST_CR) The AST is disabled. */
#define   AST_CR_EN_1               (0x1u <<  0) /**< \brief (AST_CR) The AST is enabled */
#define AST_CR_PCLR                 (0x1u <<  1) /**< \brief (AST_CR) Prescaler Clear */
#define AST_CR_CAL                  (0x1u <<  2) /**< \brief (AST_CR) Calendar mode */
#define AST_CR_CA0                  (0x1u <<  8) /**< \brief (AST_CR) Clear on Alarm 0 */
#define AST_CR_CA1                  (0x1u <<  9) /**< \brief (AST_CR) Clear on Alarm 1 */
#define AST_CR_PSEL_Pos             16
#define AST_CR_PSEL_Msk             (0x1Fu << AST_CR_PSEL_Pos) /**< \brief (AST_CR) Prescaler Select */
#define AST_CR_PSEL(value)          ((AST_CR_PSEL_Msk & ((value) << AST_CR_PSEL_Pos)))
/* -------- AST_CV : (AST Offset: 0x04) Counter Value -------- */
#define AST_CV_VALUE_Pos            0
#define AST_CV_VALUE_Msk            (0xFFFFFFFFu << AST_CV_VALUE_Pos) /**< \brief (AST_CV) AST Value */
#define AST_CV_VALUE(value)         ((AST_CV_VALUE_Msk & ((value) << AST_CV_VALUE_Pos)))
/* -------- AST_SR : (AST Offset: 0x08) Status Register -------- */
#define AST_SR_OVF                  (0x1u <<  0) /**< \brief (AST_SR) Overflow */
#define AST_SR_ALARM0               (0x1u <<  8) /**< \brief (AST_SR) Alarm 0 */
#define AST_SR_ALARM1               (0x1u <<  9) /**< \brief (AST_SR) Alarm 1 */
#define AST_SR_PER0                 (0x1u << 16) /**< \brief (AST_SR) Periodic 0 */
#define AST_SR_PER1                 (0x1u << 17) /**< \brief (AST_SR) Periodic 1 */
#define AST_SR_BUSY                 (0x1u << 24) /**< \brief (AST_SR) AST Busy */
#define   AST_SR_BUSY_0             (0x0u << 24) /**< \brief (AST_SR) The AST accepts writes to CV, WER, DTR, SCR, AR, PIR and CR */
#define   AST_SR_BUSY_1             (0x1u << 24) /**< \brief (AST_SR) The AST is busy and will discard writes to CV, WER, DTR, SCR, AR, PIR and CR */
#define AST_SR_READY                (0x1u << 25) /**< \brief (AST_SR) AST Ready */
#define AST_SR_CLKBUSY              (0x1u << 28) /**< \brief (AST_SR) Clock Busy */
#define   AST_SR_CLKBUSY_0          (0x0u << 28) /**< \brief (AST_SR) The clock is ready and can be changed */
#define   AST_SR_CLKBUSY_1          (0x1u << 28) /**< \brief (AST_SR) CEN has been written and the clock is busy */
#define AST_SR_CLKRDY               (0x1u << 29) /**< \brief (AST_SR) Clock Ready */
/* -------- AST_SCR : (AST Offset: 0x0C) Status Clear Register -------- */
#define AST_SCR_OVF                 (0x1u <<  0) /**< \brief (AST_SCR) Overflow */
#define AST_SCR_ALARM0              (0x1u <<  8) /**< \brief (AST_SCR) Alarm 0 */
#define AST_SCR_ALARM1              (0x1u <<  9) /**< \brief (AST_SCR) Alarm 1 */
#define AST_SCR_PER0                (0x1u << 16) /**< \brief (AST_SCR) Periodic 0 */
#define AST_SCR_PER1                (0x1u << 17) /**< \brief (AST_SCR) Periodic 1 */
#define AST_SCR_READY               (0x1u << 25) /**< \brief (AST_SCR) AST Ready */
#define AST_SCR_CLKRDY              (0x1u << 29) /**< \brief (AST_SCR) Clock Ready */
/* -------- AST_IER : (AST Offset: 0x10) Interrupt Enable Register -------- */
#define AST_IER_OVF                 (0x1u <<  0) /**< \brief (AST_IER) Overflow */
#define   AST_IER_OVF_0             (0x0u <<  0) /**< \brief (AST_IER) No effect */
#define   AST_IER_OVF_1             (0x1u <<  0) /**< \brief (AST_IER) Enable Interrupt. */
#define AST_IER_ALARM0              (0x1u <<  8) /**< \brief (AST_IER) Alarm 0 */
#define   AST_IER_ALARM0_0          (0x0u <<  8) /**< \brief (AST_IER) No effect */
#define   AST_IER_ALARM0_1          (0x1u <<  8) /**< \brief (AST_IER) Enable interrupt */
#define AST_IER_ALARM1              (0x1u <<  9) /**< \brief (AST_IER) Alarm 1 */
#define   AST_IER_ALARM1_0          (0x0u <<  9) /**< \brief (AST_IER) No effect */
#define   AST_IER_ALARM1_1          (0x1u <<  9) /**< \brief (AST_IER) Enable interrupt */
#define AST_IER_PER0                (0x1u << 16) /**< \brief (AST_IER) Periodic 0 */
#define   AST_IER_PER0_0            (0x0u << 16) /**< \brief (AST_IER) No effect */
#define   AST_IER_PER0_1            (0x1u << 16) /**< \brief (AST_IER) Enable interrupt */
#define AST_IER_PER1                (0x1u << 17) /**< \brief (AST_IER) Periodic 1 */
#define   AST_IER_PER1_0            (0x0u << 17) /**< \brief (AST_IER) No effect */
#define   AST_IER_PER1_1            (0x1u << 17) /**< \brief (AST_IER) Enable interrupt */
#define AST_IER_READY               (0x1u << 25) /**< \brief (AST_IER) AST Ready */
#define   AST_IER_READY_0           (0x0u << 25) /**< \brief (AST_IER) No effect */
#define   AST_IER_READY_1           (0x1u << 25) /**< \brief (AST_IER) Enable interrupt */
#define AST_IER_CLKRDY              (0x1u << 29) /**< \brief (AST_IER) Clock Ready */
#define   AST_IER_CLKRDY_0          (0x0u << 29) /**< \brief (AST_IER) No effect */
#define   AST_IER_CLKRDY_1          (0x1u << 29) /**< \brief (AST_IER) Enable interrupt */
/* -------- AST_IDR : (AST Offset: 0x14) Interrupt Disable Register -------- */
#define AST_IDR_OVF                 (0x1u <<  0) /**< \brief (AST_IDR) Overflow */
#define   AST_IDR_OVF_0             (0x0u <<  0) /**< \brief (AST_IDR) No effect */
#define   AST_IDR_OVF_1             (0x1u <<  0) /**< \brief (AST_IDR) Disable Interrupt. */
#define AST_IDR_ALARM0              (0x1u <<  8) /**< \brief (AST_IDR) Alarm 0 */
#define   AST_IDR_ALARM0_0          (0x0u <<  8) /**< \brief (AST_IDR) No effect */
#define   AST_IDR_ALARM0_1          (0x1u <<  8) /**< \brief (AST_IDR) Disable interrupt */
#define AST_IDR_ALARM1              (0x1u <<  9) /**< \brief (AST_IDR) Alarm 1 */
#define   AST_IDR_ALARM1_0          (0x0u <<  9) /**< \brief (AST_IDR) No effect */
#define   AST_IDR_ALARM1_1          (0x1u <<  9) /**< \brief (AST_IDR) Disable interrupt */
#define AST_IDR_PER0                (0x1u << 16) /**< \brief (AST_IDR) Periodic 0 */
#define   AST_IDR_PER0_0            (0x0u << 16) /**< \brief (AST_IDR) No effet */
#define   AST_IDR_PER0_1            (0x1u << 16) /**< \brief (AST_IDR) Disalbe interrupt */
#define AST_IDR_PER1                (0x1u << 17) /**< \brief (AST_IDR) Periodic 1 */
#define   AST_IDR_PER1_0            (0x0u << 17) /**< \brief (AST_IDR) No effect */
#define   AST_IDR_PER1_1            (0x1u << 17) /**< \brief (AST_IDR) Disable interrupt */
#define AST_IDR_READY               (0x1u << 25) /**< \brief (AST_IDR) AST Ready */
#define   AST_IDR_READY_0           (0x0u << 25) /**< \brief (AST_IDR) No effect */
#define   AST_IDR_READY_1           (0x1u << 25) /**< \brief (AST_IDR) Disable interrupt */
#define AST_IDR_CLKRDY              (0x1u << 29) /**< \brief (AST_IDR) Clock Ready */
#define   AST_IDR_CLKRDY_0          (0x0u << 29) /**< \brief (AST_IDR) No effect */
#define   AST_IDR_CLKRDY_1          (0x1u << 29) /**< \brief (AST_IDR) Disable interrupt */
/* -------- AST_IMR : (AST Offset: 0x18) Interrupt Mask Register -------- */
#define AST_IMR_OVF                 (0x1u <<  0) /**< \brief (AST_IMR) Overflow */
#define   AST_IMR_OVF_0             (0x0u <<  0) /**< \brief (AST_IMR) Interrupt is disabled */
#define   AST_IMR_OVF_1             (0x1u <<  0) /**< \brief (AST_IMR) Interrupt is enabled. */
#define AST_IMR_ALARM0              (0x1u <<  8) /**< \brief (AST_IMR) Alarm 0 */
#define   AST_IMR_ALARM0_0          (0x0u <<  8) /**< \brief (AST_IMR) Interupt is disabled */
#define   AST_IMR_ALARM0_1          (0x1u <<  8) /**< \brief (AST_IMR) Interrupt is enabled */
#define AST_IMR_ALARM1              (0x1u <<  9) /**< \brief (AST_IMR) Alarm 1 */
#define   AST_IMR_ALARM1_0          (0x0u <<  9) /**< \brief (AST_IMR) Interrupt is disabled */
#define   AST_IMR_ALARM1_1          (0x1u <<  9) /**< \brief (AST_IMR) Interrupt is enabled */
#define AST_IMR_PER0                (0x1u << 16) /**< \brief (AST_IMR) Periodic 0 */
#define   AST_IMR_PER0_0            (0x0u << 16) /**< \brief (AST_IMR) Interrupt is disabled */
#define   AST_IMR_PER0_1            (0x1u << 16) /**< \brief (AST_IMR) Interrupt is enabled */
#define AST_IMR_PER1                (0x1u << 17) /**< \brief (AST_IMR) Periodic 1 */
#define   AST_IMR_PER1_0            (0x0u << 17) /**< \brief (AST_IMR) Interrupt is disabled */
#define   AST_IMR_PER1_1            (0x1u << 17) /**< \brief (AST_IMR) Interrupt is enabled */
#define AST_IMR_READY               (0x1u << 25) /**< \brief (AST_IMR) AST Ready */
#define   AST_IMR_READY_0           (0x0u << 25) /**< \brief (AST_IMR) Interrupt is disabled */
#define   AST_IMR_READY_1           (0x1u << 25) /**< \brief (AST_IMR) Interrupt is enabled */
#define AST_IMR_CLKRDY              (0x1u << 29) /**< \brief (AST_IMR) Clock Ready */
#define   AST_IMR_CLKRDY_0          (0x0u << 29) /**< \brief (AST_IMR) Interrupt is disabled */
#define   AST_IMR_CLKRDY_1          (0x1u << 29) /**< \brief (AST_IMR) Interrupt is enabled */
/* -------- AST_WER : (AST Offset: 0x1C) Wake Enable Register -------- */
#define AST_WER_OVF                 (0x1u <<  0) /**< \brief (AST_WER) Overflow */
#define   AST_WER_OVF_0             (0x0u <<  0) /**< \brief (AST_WER) The corresponing event will not wake up the CPU from sleep mode */
#define   AST_WER_OVF_1             (0x1u <<  0) /**< \brief (AST_WER) The corresponding event will wake up the CPU from sleep mode */
#define AST_WER_ALARM0              (0x1u <<  8) /**< \brief (AST_WER) Alarm 0 */
#define   AST_WER_ALARM0_0          (0x0u <<  8) /**< \brief (AST_WER) The corresponing event will not wake up the CPU from sleep mode */
#define   AST_WER_ALARM0_1          (0x1u <<  8) /**< \brief (AST_WER) The corresponding event will wake up the CPU from sleep mode */
#define AST_WER_ALARM1              (0x1u <<  9) /**< \brief (AST_WER) Alarm 1 */
#define   AST_WER_ALARM1_0          (0x0u <<  9) /**< \brief (AST_WER) The corresponing event will not wake up the CPU from sleep mode */
#define   AST_WER_ALARM1_1          (0x1u <<  9) /**< \brief (AST_WER) The corresponding event will wake up the CPU from sleep mode */
#define AST_WER_PER0                (0x1u << 16) /**< \brief (AST_WER) Periodic 0 */
#define   AST_WER_PER0_0            (0x0u << 16) /**< \brief (AST_WER) The corresponing event will not wake up the CPU from sleep mode */
#define   AST_WER_PER0_1            (0x1u << 16) /**< \brief (AST_WER) The corresponding event will wake up the CPU from sleep mode */
#define AST_WER_PER1                (0x1u << 17) /**< \brief (AST_WER) Periodic 1 */
#define   AST_WER_PER1_0            (0x0u << 17) /**< \brief (AST_WER) The corresponing event will not wake up the CPU from sleep mode */
#define   AST_WER_PER1_1            (0x1u << 17) /**< \brief (AST_WER) The corresponding event will wake up the CPU from sleep mode */
/* -------- AST_AR0 : (AST Offset: 0x20) Alarm Register 0 -------- */
#define AST_AR0_VALUE_Pos           0
#define AST_AR0_VALUE_Msk           (0xFFFFFFFFu << AST_AR0_VALUE_Pos) /**< \brief (AST_AR0) Alarm Value */
#define AST_AR0_VALUE(value)        ((AST_AR0_VALUE_Msk & ((value) << AST_AR0_VALUE_Pos)))
/* -------- AST_AR1 : (AST Offset: 0x24) Alarm Register 1 -------- */
#define AST_AR1_VALUE_Pos           0
#define AST_AR1_VALUE_Msk           (0xFFFFFFFFu << AST_AR1_VALUE_Pos) /**< \brief (AST_AR1) Alarm Value */
#define AST_AR1_VALUE(value)        ((AST_AR1_VALUE_Msk & ((value) << AST_AR1_VALUE_Pos)))
/* -------- AST_PIR0 : (AST Offset: 0x30) Periodic Interval Register 0 -------- */
#define AST_PIR0_INSEL_Pos          0
#define AST_PIR0_INSEL_Msk          (0x1Fu << AST_PIR0_INSEL_Pos) /**< \brief (AST_PIR0) Interval Select */
#define AST_PIR0_INSEL(value)       ((AST_PIR0_INSEL_Msk & ((value) << AST_PIR0_INSEL_Pos)))
/* -------- AST_PIR1 : (AST Offset: 0x34) Periodic Interval Register 1 -------- */
#define AST_PIR1_INSEL_Pos          0
#define AST_PIR1_INSEL_Msk          (0x1Fu << AST_PIR1_INSEL_Pos) /**< \brief (AST_PIR1) Interval Select */
#define AST_PIR1_INSEL(value)       ((AST_PIR1_INSEL_Msk & ((value) << AST_PIR1_INSEL_Pos)))
/* -------- AST_CLOCK : (AST Offset: 0x40) Clock Control Register -------- */
#define AST_CLOCK_CEN               (0x1u <<  0) /**< \brief (AST_CLOCK) Clock Enable */
#define   AST_CLOCK_CEN_0           (0x0u <<  0) /**< \brief (AST_CLOCK) The clock is disabled */
#define   AST_CLOCK_CEN_1           (0x1u <<  0) /**< \brief (AST_CLOCK) The clock is enabled */
#define AST_CLOCK_CSSEL_Pos         8
#define AST_CLOCK_CSSEL_Msk         (0x7u << AST_CLOCK_CSSEL_Pos) /**< \brief (AST_CLOCK) Clock Source Selection */
#define AST_CLOCK_CSSEL(value)      ((AST_CLOCK_CSSEL_Msk & ((value) << AST_CLOCK_CSSEL_Pos)))
#define   AST_CLOCK_CSSEL_SLOWCLOCK (0x0u <<  8) /**< \brief (AST_CLOCK) Slow clock */
#define   AST_CLOCK_CSSEL_32KHZCLK  (0x1u <<  8) /**< \brief (AST_CLOCK) 32 kHz clock */
#define   AST_CLOCK_CSSEL_PBCLOCK   (0x2u <<  8) /**< \brief (AST_CLOCK) PB clock */
#define   AST_CLOCK_CSSEL_GCLK      (0x3u <<  8) /**< \brief (AST_CLOCK) Generic clock */
#define   AST_CLOCK_CSSEL_1KHZCLK   (0x4u <<  8) /**< \brief (AST_CLOCK) 1kHz clock from 32 kHz oscillator */
/* -------- AST_DTR : (AST Offset: 0x44) Digital Tuner Register -------- */
#define AST_DTR_EXP_Pos             0
#define AST_DTR_EXP_Msk             (0x1Fu << AST_DTR_EXP_Pos) /**< \brief (AST_DTR) EXP */
#define AST_DTR_EXP(value)          ((AST_DTR_EXP_Msk & ((value) << AST_DTR_EXP_Pos)))
#define AST_DTR_ADD                 (0x1u <<  5) /**< \brief (AST_DTR) ADD */
#define AST_DTR_VALUE_Pos           8
#define AST_DTR_VALUE_Msk           (0xFFu << AST_DTR_VALUE_Pos) /**< \brief (AST_DTR) VALUE */
#define AST_DTR_VALUE(value)        ((AST_DTR_VALUE_Msk & ((value) << AST_DTR_VALUE_Pos)))
/* -------- AST_EVE : (AST Offset: 0x48) Event Enable Register -------- */
#define AST_EVE_OVF                 (0x1u <<  0) /**< \brief (AST_EVE) Overflow */
#define AST_EVE_ALARM0              (0x1u <<  8) /**< \brief (AST_EVE) Alarm 0 */
#define AST_EVE_ALARM1              (0x1u <<  9) /**< \brief (AST_EVE) Alarm 1 */
#define AST_EVE_PER0                (0x1u << 16) /**< \brief (AST_EVE) Perioidc 0 */
#define AST_EVE_PER1                (0x1u << 17) /**< \brief (AST_EVE) Periodic 1 */
/* -------- AST_EVD : (AST Offset: 0x4C) Event Disable Register -------- */
#define AST_EVD_OVF                 (0x1u <<  0) /**< \brief (AST_EVD) Overflow */
#define AST_EVD_ALARM0              (0x1u <<  8) /**< \brief (AST_EVD) Alarm 0 */
#define AST_EVD_ALARM1              (0x1u <<  9) /**< \brief (AST_EVD) Alarm 1 */
#define AST_EVD_PER0                (0x1u << 16) /**< \brief (AST_EVD) Perioidc 0 */
#define AST_EVD_PER1                (0x1u << 17) /**< \brief (AST_EVD) Periodic 1 */
/* -------- AST_EVM : (AST Offset: 0x50) Event Mask Register -------- */
#define AST_EVM_OVF                 (0x1u <<  0) /**< \brief (AST_EVM) Overflow */
#define AST_EVM_ALARM0              (0x1u <<  8) /**< \brief (AST_EVM) Alarm 0 */
#define AST_EVM_ALARM1              (0x1u <<  9) /**< \brief (AST_EVM) Alarm 1 */
#define AST_EVM_PER0                (0x1u << 16) /**< \brief (AST_EVM) Perioidc 0 */
#define AST_EVM_PER1                (0x1u << 17) /**< \brief (AST_EVM) Periodic 1 */
/* -------- AST_CALV : (AST Offset: 0x54) Calendar Value -------- */
#define AST_CALV_SEC_Pos            0
#define AST_CALV_SEC_Msk            (0x3Fu << AST_CALV_SEC_Pos) /**< \brief (AST_CALV) Second */
#define AST_CALV_SEC(value)         ((AST_CALV_SEC_Msk & ((value) << AST_CALV_SEC_Pos)))
#define AST_CALV_MIN_Pos            6
#define AST_CALV_MIN_Msk            (0x3Fu << AST_CALV_MIN_Pos) /**< \brief (AST_CALV) Minute */
#define AST_CALV_MIN(value)         ((AST_CALV_MIN_Msk & ((value) << AST_CALV_MIN_Pos)))
#define AST_CALV_HOUR_Pos           12
#define AST_CALV_HOUR_Msk           (0x1Fu << AST_CALV_HOUR_Pos) /**< \brief (AST_CALV) Hour */
#define AST_CALV_HOUR(value)        ((AST_CALV_HOUR_Msk & ((value) << AST_CALV_HOUR_Pos)))
#define AST_CALV_DAY_Pos            17
#define AST_CALV_DAY_Msk            (0x1Fu << AST_CALV_DAY_Pos) /**< \brief (AST_CALV) Day */
#define AST_CALV_DAY(value)         ((AST_CALV_DAY_Msk & ((value) << AST_CALV_DAY_Pos)))
#define AST_CALV_MONTH_Pos          22
#define AST_CALV_MONTH_Msk          (0xFu << AST_CALV_MONTH_Pos) /**< \brief (AST_CALV) Month */
#define AST_CALV_MONTH(value)       ((AST_CALV_MONTH_Msk & ((value) << AST_CALV_MONTH_Pos)))
#define AST_CALV_YEAR_Pos           26
#define AST_CALV_YEAR_Msk           (0x3Fu << AST_CALV_YEAR_Pos) /**< \brief (AST_CALV) Year */
#define AST_CALV_YEAR(value)        ((AST_CALV_YEAR_Msk & ((value) << AST_CALV_YEAR_Pos)))
/* -------- AST_PARAMETER : (AST Offset: 0xF0) Parameter Register -------- */
#define AST_PARAMETER_DT            (0x1u <<  0) /**< \brief (AST_PARAMETER) Digital Tuner */
#define   AST_PARAMETER_DT_OFF      (0x0u <<  0) /**< \brief (AST_PARAMETER) Digital tuner off */
#define   AST_PARAMETER_DT_ON       (0x1u <<  0) /**< \brief (AST_PARAMETER) Digital tuner on */
#define AST_PARAMETER_DTEXPWA       (0x1u <<  1) /**< \brief (AST_PARAMETER) Digital Tuner Exponent Writeable */
#define   AST_PARAMETER_DTEXPWA_0   (0x0u <<  1) /**< \brief (AST_PARAMETER) Digital tuner exponent is a constant value. Writes to EXP bitfield in DTR will be discarded. */
#define   AST_PARAMETER_DTEXPWA_1   (0x1u <<  1) /**< \brief (AST_PARAMETER) Digital tuner exponent is chosen by writing to EXP bitfield in DTR */
#define AST_PARAMETER_DTEXPVALUE_Pos    2
#define AST_PARAMETER_DTEXPVALUE_Msk    (0x1Fu << AST_PARAMETER_DTEXPVALUE_Pos) /**< \brief (AST_PARAMETER) Digital Tuner Exponent Value */
#define AST_PARAMETER_DTEXPVALUE(value) ((AST_PARAMETER_DTEXPVALUE_Msk & ((value) << AST_PARAMETER_DTEXPVALUE_Pos)))
#define AST_PARAMETER_NUMAR_Pos     8
#define AST_PARAMETER_NUMAR_Msk     (0x3u << AST_PARAMETER_NUMAR_Pos) /**< \brief (AST_PARAMETER) Number of alarm comparators */
#define AST_PARAMETER_NUMAR(value)  ((AST_PARAMETER_NUMAR_Msk & ((value) << AST_PARAMETER_NUMAR_Pos)))
#define   AST_PARAMETER_NUMAR_ZERO  (0x0u <<  8) /**< \brief (AST_PARAMETER) No alarm comparators */
#define   AST_PARAMETER_NUMAR_ONE   (0x1u <<  8) /**< \brief (AST_PARAMETER) One alarm comparator */
#define   AST_PARAMETER_NUMAR_TWO   (0x2u <<  8) /**< \brief (AST_PARAMETER) Two alarm comparators */
#define AST_PARAMETER_NUMPIR        (0x1u << 12) /**< \brief (AST_PARAMETER) Number of periodic comparators */
#define   AST_PARAMETER_NUMPIR_ONE  (0x0u << 12) /**< \brief (AST_PARAMETER) One periodic comparator */
#define   AST_PARAMETER_NUMPIR_TWO  (0x1u << 12) /**< \brief (AST_PARAMETER) Two periodic comparators */
#define AST_PARAMETER_PIR0WA        (0x1u << 14) /**< \brief (AST_PARAMETER) Periodic Interval 0 Writeable */
#define   AST_PARAMETER_PIR0WA_0    (0x0u << 14) /**< \brief (AST_PARAMETER) Periodic alarm prescaler 0 tapping is a constant value. Writes to INSEL bitfield in PIR0 will be discarded. */
#define   AST_PARAMETER_PIR0WA_1    (0x1u << 14) /**< \brief (AST_PARAMETER) Periodic alarm prescaler 0 tapping is chosen by writing to INSEL bitfield in PIR0 */
#define AST_PARAMETER_PIR1WA        (0x1u << 15) /**< \brief (AST_PARAMETER) Periodic Interval 1 Writeable */
#define   AST_PARAMETER_PIR1WA_0    (0x0u << 15) /**< \brief (AST_PARAMETER) Writes to PIR1 will be discarded */
#define   AST_PARAMETER_PIR1WA_1    (0x1u << 15) /**< \brief (AST_PARAMETER) PIR1 can be written */
#define AST_PARAMETER_PER0VALUE_Pos    16
#define AST_PARAMETER_PER0VALUE_Msk    (0x1Fu << AST_PARAMETER_PER0VALUE_Pos) /**< \brief (AST_PARAMETER) Periodic Interval 0 Value */
#define AST_PARAMETER_PER0VALUE(value) ((AST_PARAMETER_PER0VALUE_Msk & ((value) << AST_PARAMETER_PER0VALUE_Pos)))
#define AST_PARAMETER_PER1VALUE_Pos    24
#define AST_PARAMETER_PER1VALUE_Msk    (0x1Fu << AST_PARAMETER_PER1VALUE_Pos) /**< \brief (AST_PARAMETER) Periodic Interval 1 Value */
#define AST_PARAMETER_PER1VALUE(value) ((AST_PARAMETER_PER1VALUE_Msk & ((value) << AST_PARAMETER_PER1VALUE_Pos)))
/* -------- AST_VERSION : (AST Offset: 0xFC) Version Register -------- */
#define AST_VERSION_VERSION_Pos     0
#define AST_VERSION_VERSION_Msk     (0xFFFu << AST_VERSION_VERSION_Pos) /**< \brief (AST_VERSION) Version Number */
#define AST_VERSION_VERSION(value)  ((AST_VERSION_VERSION_Msk & ((value) << AST_VERSION_VERSION_Pos)))
#define AST_VERSION_VARIANT_Pos     16
#define AST_VERSION_VARIANT_Msk     (0xFu << AST_VERSION_VARIANT_Pos) /**< \brief (AST_VERSION) Variant Number */
#define AST_VERSION_VARIANT(value)  ((AST_VERSION_VARIANT_Msk & ((value) << AST_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR BPM */
/* ============================================================================= */
/** \addtogroup SAM4L4_BPM Backup Power Manager */
/*@{*/

#define REV_BPM        0x120

#ifndef __ASSEMBLY__
/** \brief BPM hardware registers */
typedef struct {
  WoReg   IER;         /**< \brief (BPM Offset: 0x00) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (BPM Offset: 0x04) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (BPM Offset: 0x08) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (BPM Offset: 0x0C) Interrupt Status Register */
  WoReg   ICR;         /**< \brief (BPM Offset: 0x10) Interrupt Clear Register */
  RoReg   SR;          /**< \brief (BPM Offset: 0x14) Status Register */
  WoReg   UNLOCK;      /**< \brief (BPM Offset: 0x18) Unlock Register */
  RwReg   PMCON;       /**< \brief (BPM Offset: 0x1C) Power Mode Control Register */
  RoReg   Reserved1[2];
  RoReg   BKUPWCAUSE;  /**< \brief (BPM Offset: 0x28) Backup Wake up Cause Register */
  RwReg   BKUPWEN;     /**< \brief (BPM Offset: 0x2C) Backup Wake up Enable Register */
  RwReg   BKUPPMUX;    /**< \brief (BPM Offset: 0x30) Backup Pin Muxing Register */
  RwReg   IORET;       /**< \brief (BPM Offset: 0x34) Input Output Retention Register */
  RoReg   Reserved2[2];
  RwReg   BPR;         /**< \brief (BPM Offset: 0x40) Bypass Register */
  RoReg   FWRUNPS;     /**< \brief (BPM Offset: 0x44) Factory Word Run PS Register */
  RoReg   FWPSAVEPS;   /**< \brief (BPM Offset: 0x48) Factory Word Power Save PS Register */
  RoReg   Reserved3[44];
  RoReg   VERSION;     /**< \brief (BPM Offset: 0xFC) Version Register */
} Bpm;
#endif /* __ASSEMBLY__ */
/* -------- BPM_IER : (BPM Offset: 0x00) Interrupt Enable Register -------- */
#define BPM_IER_PSOK                (0x1u <<  0) /**< \brief (BPM_IER) Power Scaling OK Interrupt Enable */
#define BPM_IER_AE                  (0x1u << 31) /**< \brief (BPM_IER) Access Error Interrupt Enable */
/* -------- BPM_IDR : (BPM Offset: 0x04) Interrupt Disable Register -------- */
#define BPM_IDR_PSOK                (0x1u <<  0) /**< \brief (BPM_IDR) Power Scaling OK Interrupt Disable */
#define BPM_IDR_AE                  (0x1u << 31) /**< \brief (BPM_IDR) Access Error Interrupt Disable */
/* -------- BPM_IMR : (BPM Offset: 0x08) Interrupt Mask Register -------- */
#define BPM_IMR_PSOK                (0x1u <<  0) /**< \brief (BPM_IMR) Power Scaling OK Interrupt Mask */
#define BPM_IMR_AE                  (0x1u << 31) /**< \brief (BPM_IMR) Access Error Interrupt Mask */
/* -------- BPM_ISR : (BPM Offset: 0x0C) Interrupt Status Register -------- */
#define BPM_ISR_PSOK                (0x1u <<  0) /**< \brief (BPM_ISR) Power Scaling OK Interrupt Status */
#define BPM_ISR_AE                  (0x1u << 31) /**< \brief (BPM_ISR) Access Error Interrupt Status */
/* -------- BPM_ICR : (BPM Offset: 0x10) Interrupt Clear Register -------- */
#define BPM_ICR_PSOK                (0x1u <<  0) /**< \brief (BPM_ICR) Power Scaling OK Interrupt Status Clear */
#define BPM_ICR_AE                  (0x1u << 31) /**< \brief (BPM_ICR) Access Error Interrupt Status Clear */
/* -------- BPM_SR : (BPM Offset: 0x14) Status Register -------- */
#define BPM_SR_PSOK                 (0x1u <<  0) /**< \brief (BPM_SR) Power Scaling OK Status */
/* -------- BPM_UNLOCK : (BPM Offset: 0x18) Unlock Register -------- */
#define BPM_UNLOCK_ADDR_Pos         0
#define BPM_UNLOCK_ADDR_Msk         (0x3FFu << BPM_UNLOCK_ADDR_Pos) /**< \brief (BPM_UNLOCK) Unlock Address */
#define BPM_UNLOCK_ADDR(value)      ((BPM_UNLOCK_ADDR_Msk & ((value) << BPM_UNLOCK_ADDR_Pos)))
#define BPM_UNLOCK_KEY_Pos          24
#define BPM_UNLOCK_KEY_Msk          (0xFFu << BPM_UNLOCK_KEY_Pos) /**< \brief (BPM_UNLOCK) Unlock Key */
#define BPM_UNLOCK_KEY(value)       ((BPM_UNLOCK_KEY_Msk & ((value) << BPM_UNLOCK_KEY_Pos)))
/* -------- BPM_PMCON : (BPM Offset: 0x1C) Power Mode Control Register -------- */
#define BPM_PMCON_PS_Pos            0
#define BPM_PMCON_PS_Msk            (0x3u << BPM_PMCON_PS_Pos) /**< \brief (BPM_PMCON) Power Scaling Configuration Value */
#define BPM_PMCON_PS(value)         ((BPM_PMCON_PS_Msk & ((value) << BPM_PMCON_PS_Pos)))
#define BPM_PMCON_PSCREQ            (0x1u <<  2) /**< \brief (BPM_PMCON) Power Scaling Change Request */
#define BPM_PMCON_PSCM              (0x1u <<  3) /**< \brief (BPM_PMCON) Power Scaling Change Mode */
#define BPM_PMCON_BKUP              (0x1u <<  8) /**< \brief (BPM_PMCON) BACKUP Mode */
#define BPM_PMCON_RET               (0x1u <<  9) /**< \brief (BPM_PMCON) RETENTION Mode */
#define BPM_PMCON_SLEEP_Pos         12
#define BPM_PMCON_SLEEP_Msk         (0x3u << BPM_PMCON_SLEEP_Pos) /**< \brief (BPM_PMCON) SLEEP mode Configuration */
#define BPM_PMCON_SLEEP(value)      ((BPM_PMCON_SLEEP_Msk & ((value) << BPM_PMCON_SLEEP_Pos)))
#define BPM_PMCON_CK32S             (0x1u << 16) /**< \brief (BPM_PMCON) 32Khz-1Khz Clock Source Selection */
#define BPM_PMCON_FASTWKUP          (0x1u << 24) /**< \brief (BPM_PMCON) Fast Wakeup */
/* -------- BPM_BKUPPMUX : (BPM Offset: 0x30) Backup Pin Muxing Register -------- */
#define BPM_BKUPPMUX_BKUPPMUX_Pos    0
#define BPM_BKUPPMUX_BKUPPMUX_Msk    (0x1FFu << BPM_BKUPPMUX_BKUPPMUX_Pos) /**< \brief (BPM_BKUPPMUX) Backup Pin Muxing */
#define BPM_BKUPPMUX_BKUPPMUX(value) ((BPM_BKUPPMUX_BKUPPMUX_Msk & ((value) << BPM_BKUPPMUX_BKUPPMUX_Pos)))
/* -------- BPM_IORET : (BPM Offset: 0x34) Input Output Retention Register -------- */
#define BPM_IORET_RET               (0x1u <<  0) /**< \brief (BPM_IORET) Retention on I/O lines after waking up from the BACKUP mode */
/* -------- BPM_BPR : (BPM Offset: 0x40) Bypass Register -------- */
#define BPM_BPR_RUNPSPB             (0x1u <<  0) /**< \brief (BPM_BPR) Run Mode Power Scaling Preset Bypass */
#define BPM_BPR_PSMPSPB             (0x1u <<  1) /**< \brief (BPM_BPR) Power Save Mode Power Scaling Preset Bypass */
#define BPM_BPR_SEQSTN              (0x1u <<  2) /**< \brief (BPM_BPR) Sequencial Startup from ULP (Active Low) */
#define BPM_BPR_PSBTD               (0x1u <<  3) /**< \brief (BPM_BPR) Power Scaling Bias Timing Disable */
#define BPM_BPR_PSHFD               (0x1u <<  4) /**< \brief (BPM_BPR) Power Scaling Halt Flash Until VREGOK Disable */
#define BPM_BPR_DLYRSTD             (0x1u <<  5) /**< \brief (BPM_BPR) Delaying Reset Disable */
#define BPM_BPR_BIASSEN             (0x1u <<  6) /**< \brief (BPM_BPR) Bias Switch Enable */
#define BPM_BPR_LATSEN              (0x1u <<  7) /**< \brief (BPM_BPR) Latdel Switch Enable */
#define BPM_BPR_BOD18CONT           (0x1u <<  8) /**< \brief (BPM_BPR) BOD18 in continuous mode not disabled in WAIT/RET/BACKUP modes */
#define BPM_BPR_POBS                (0x1u <<  9) /**< \brief (BPM_BPR) Pico Uart Observability */
#define BPM_BPR_FFFW                (0x1u << 10) /**< \brief (BPM_BPR) Force Flash Fast Wakeup */
#define BPM_BPR_FBRDYEN             (0x1u << 11) /**< \brief (BPM_BPR) Flash Bias Ready Enable */
#define BPM_BPR_FVREFSEN            (0x1u << 12) /**< \brief (BPM_BPR) Flash Vref Switch Enable */
/* -------- BPM_FWRUNPS : (BPM Offset: 0x44) Factory Word Run PS Register -------- */
#define BPM_FWRUNPS_REGLEVEL_Pos    0
#define BPM_FWRUNPS_REGLEVEL_Msk    (0xFu << BPM_FWRUNPS_REGLEVEL_Pos) /**< \brief (BPM_FWRUNPS) Regulator Voltage Level */
#define BPM_FWRUNPS_REGLEVEL(value) ((BPM_FWRUNPS_REGLEVEL_Msk & ((value) << BPM_FWRUNPS_REGLEVEL_Pos)))
#define BPM_FWRUNPS_REGTYPE_Pos     4
#define BPM_FWRUNPS_REGTYPE_Msk     (0x3u << BPM_FWRUNPS_REGTYPE_Pos) /**< \brief (BPM_FWRUNPS) Regulator Type */
#define BPM_FWRUNPS_REGTYPE(value)  ((BPM_FWRUNPS_REGTYPE_Msk & ((value) << BPM_FWRUNPS_REGTYPE_Pos)))
#define   BPM_FWRUNPS_REGTYPE_NORMAL (0x0u <<  4) /**< \brief (BPM_FWRUNPS)  */
#define   BPM_FWRUNPS_REGTYPE_LP    (0x1u <<  4) /**< \brief (BPM_FWRUNPS)  */
#define   BPM_FWRUNPS_REGTYPE_XULP  (0x2u <<  4) /**< \brief (BPM_FWRUNPS)  */
#define BPM_FWRUNPS_REFTYPE_Pos     6
#define BPM_FWRUNPS_REFTYPE_Msk     (0x3u << BPM_FWRUNPS_REFTYPE_Pos) /**< \brief (BPM_FWRUNPS) Reference Type */
#define BPM_FWRUNPS_REFTYPE(value)  ((BPM_FWRUNPS_REFTYPE_Msk & ((value) << BPM_FWRUNPS_REFTYPE_Pos)))
#define   BPM_FWRUNPS_REFTYPE_BOTH  (0x0u <<  6) /**< \brief (BPM_FWRUNPS)  */
#define   BPM_FWRUNPS_REFTYPE_BG    (0x1u <<  6) /**< \brief (BPM_FWRUNPS)  */
#define   BPM_FWRUNPS_REFTYPE_LPBG  (0x2u <<  6) /**< \brief (BPM_FWRUNPS)  */
#define   BPM_FWRUNPS_REFTYPE_INTERNAL (0x3u <<  6) /**< \brief (BPM_FWRUNPS)  */
#define BPM_FWRUNPS_FLASHLATDEL_Pos    8
#define BPM_FWRUNPS_FLASHLATDEL_Msk    (0x1Fu << BPM_FWRUNPS_FLASHLATDEL_Pos) /**< \brief (BPM_FWRUNPS) Flash Latch Delay Value */
#define BPM_FWRUNPS_FLASHLATDEL(value) ((BPM_FWRUNPS_FLASHLATDEL_Msk & ((value) << BPM_FWRUNPS_FLASHLATDEL_Pos)))
#define BPM_FWRUNPS_FLASHBIAS_Pos    13
#define BPM_FWRUNPS_FLASHBIAS_Msk    (0xFu << BPM_FWRUNPS_FLASHBIAS_Pos) /**< \brief (BPM_FWRUNPS) Flash Bias Value */
#define BPM_FWRUNPS_FLASHBIAS(value) ((BPM_FWRUNPS_FLASHBIAS_Msk & ((value) << BPM_FWRUNPS_FLASHBIAS_Pos)))
#define BPM_FWRUNPS_FPPW            (0x1u << 17) /**< \brief (BPM_FWRUNPS) Flash Pico Power Mode */
#define BPM_FWRUNPS_RC115_Pos       18
#define BPM_FWRUNPS_RC115_Msk       (0x7Fu << BPM_FWRUNPS_RC115_Pos) /**< \brief (BPM_FWRUNPS) RC 115KHZ Calibration Value */
#define BPM_FWRUNPS_RC115(value)    ((BPM_FWRUNPS_RC115_Msk & ((value) << BPM_FWRUNPS_RC115_Pos)))
#define BPM_FWRUNPS_RCFAST_Pos      25
#define BPM_FWRUNPS_RCFAST_Msk      (0x7Fu << BPM_FWRUNPS_RCFAST_Pos) /**< \brief (BPM_FWRUNPS) RCFAST Calibration Value */
#define BPM_FWRUNPS_RCFAST(value)   ((BPM_FWRUNPS_RCFAST_Msk & ((value) << BPM_FWRUNPS_RCFAST_Pos)))
/* -------- BPM_FWPSAVEPS : (BPM Offset: 0x48) Factory Word Power Save PS Register -------- */
#define BPM_FWPSAVEPS_WREGLEVEL_Pos    0
#define BPM_FWPSAVEPS_WREGLEVEL_Msk    (0xFu << BPM_FWPSAVEPS_WREGLEVEL_Pos) /**< \brief (BPM_FWPSAVEPS) Wait mode Regulator Level */
#define BPM_FWPSAVEPS_WREGLEVEL(value) ((BPM_FWPSAVEPS_WREGLEVEL_Msk & ((value) << BPM_FWPSAVEPS_WREGLEVEL_Pos)))
#define BPM_FWPSAVEPS_WBIAS_Pos     4
#define BPM_FWPSAVEPS_WBIAS_Msk     (0xFu << BPM_FWPSAVEPS_WBIAS_Pos) /**< \brief (BPM_FWPSAVEPS) Bias in wait mode */
#define BPM_FWPSAVEPS_WBIAS(value)  ((BPM_FWPSAVEPS_WBIAS_Msk & ((value) << BPM_FWPSAVEPS_WBIAS_Pos)))
#define BPM_FWPSAVEPS_WLATDEL_Pos    8
#define BPM_FWPSAVEPS_WLATDEL_Msk    (0x1Fu << BPM_FWPSAVEPS_WLATDEL_Pos) /**< \brief (BPM_FWPSAVEPS) Flash Latdel in wait mode */
#define BPM_FWPSAVEPS_WLATDEL(value) ((BPM_FWPSAVEPS_WLATDEL_Msk & ((value) << BPM_FWPSAVEPS_WLATDEL_Pos)))
#define BPM_FWPSAVEPS_RREGLEVEL_Pos    13
#define BPM_FWPSAVEPS_RREGLEVEL_Msk    (0xFu << BPM_FWPSAVEPS_RREGLEVEL_Pos) /**< \brief (BPM_FWPSAVEPS) Retention mode Regulator Level */
#define BPM_FWPSAVEPS_RREGLEVEL(value) ((BPM_FWPSAVEPS_RREGLEVEL_Msk & ((value) << BPM_FWPSAVEPS_RREGLEVEL_Pos)))
#define BPM_FWPSAVEPS_RBIAS_Pos     17
#define BPM_FWPSAVEPS_RBIAS_Msk     (0xFu << BPM_FWPSAVEPS_RBIAS_Pos) /**< \brief (BPM_FWPSAVEPS) Bias in Retention mode */
#define BPM_FWPSAVEPS_RBIAS(value)  ((BPM_FWPSAVEPS_RBIAS_Msk & ((value) << BPM_FWPSAVEPS_RBIAS_Pos)))
#define BPM_FWPSAVEPS_RLATDEL_Pos    21
#define BPM_FWPSAVEPS_RLATDEL_Msk    (0x1Fu << BPM_FWPSAVEPS_RLATDEL_Pos) /**< \brief (BPM_FWPSAVEPS) Flash Latdel in Retention mode */
#define BPM_FWPSAVEPS_RLATDEL(value) ((BPM_FWPSAVEPS_RLATDEL_Msk & ((value) << BPM_FWPSAVEPS_RLATDEL_Pos)))
#define BPM_FWPSAVEPS_BREGLEVEL_Pos    26
#define BPM_FWPSAVEPS_BREGLEVEL_Msk    (0xFu << BPM_FWPSAVEPS_BREGLEVEL_Pos) /**< \brief (BPM_FWPSAVEPS) Backup mode Regulator Level */
#define BPM_FWPSAVEPS_BREGLEVEL(value) ((BPM_FWPSAVEPS_BREGLEVEL_Msk & ((value) << BPM_FWPSAVEPS_BREGLEVEL_Pos)))
#define BPM_FWPSAVEPS_POR18DIS      (0x1u << 30) /**< \brief (BPM_FWPSAVEPS) POR 18 Disable */
#define BPM_FWPSAVEPS_FWSAS         (0x1u << 31) /**< \brief (BPM_FWPSAVEPS) Flash Wait State Automatic Switching */
/* -------- BPM_VERSION : (BPM Offset: 0xFC) Version Register -------- */
#define BPM_VERSION_VERSION_Pos     0
#define BPM_VERSION_VERSION_Msk     (0xFFFu << BPM_VERSION_VERSION_Pos) /**< \brief (BPM_VERSION) Version Number */
#define BPM_VERSION_VERSION(value)  ((BPM_VERSION_VERSION_Msk & ((value) << BPM_VERSION_VERSION_Pos)))
#define BPM_VERSION_VARIANT_Pos     16
#define BPM_VERSION_VARIANT_Msk     (0xFu << BPM_VERSION_VARIANT_Pos) /**< \brief (BPM_VERSION) Variant Number */
#define BPM_VERSION_VARIANT(value)  ((BPM_VERSION_VARIANT_Msk & ((value) << BPM_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR BSCIF */
/* ============================================================================= */
/** \addtogroup SAM4L4_BSCIF Backup System Control Interface */
/*@{*/

#define REV_BSCIF      0x100

#ifndef __ASSEMBLY__
/** \brief BscifBr hardware registers */
typedef struct {
  RwReg   BR;          /**< \brief (BscifBr Offset: 0x000) Backup Register */
} BscifBr;
/** \brief BSCIF hardware registers */
typedef struct {
  WoReg   IER;         /**< \brief (BSCIF Offset: 0x000) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (BSCIF Offset: 0x004) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (BSCIF Offset: 0x008) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (BSCIF Offset: 0x00C) Interrupt Status Register */
  WoReg   ICR;         /**< \brief (BSCIF Offset: 0x010) Interrupt Clear Register */
  RoReg   PCLKSR;      /**< \brief (BSCIF Offset: 0x014) Power and Clocks Status Register */
  WoReg   UNLOCK;      /**< \brief (BSCIF Offset: 0x018) Unlock Register */
  RwReg   CSCR;        /**< \brief (BSCIF Offset: 0x01C) Chip Specific Configuration Register */
  RwReg   OSCCTRL32;   /**< \brief (BSCIF Offset: 0x020) Oscillator 32 Control Register */
  RwReg   RC32KCR;     /**< \brief (BSCIF Offset: 0x024) 32 kHz RC Oscillator Control Register */
  RwReg   RC32KTUNE;   /**< \brief (BSCIF Offset: 0x028) 32kHz RC Oscillator Tuning Register */
  RwReg   BOD33CTRL;   /**< \brief (BSCIF Offset: 0x02C) BOD33 Control Register */
  RwReg   BOD33LEVEL;  /**< \brief (BSCIF Offset: 0x030) BOD33 Level Register */
  RwReg   BOD33SAMPLING; /**< \brief (BSCIF Offset: 0x034) BOD33 Sampling Control Register */
  RwReg   BOD18CTRL;   /**< \brief (BSCIF Offset: 0x038) BOD18 Control Register */
  RwReg   BOD18LEVEL;  /**< \brief (BSCIF Offset: 0x03C) BOD18 Level Register */
  RwReg   BOD18SAMPLING;
  RwReg   VREGCR;      /**< \brief (BSCIF Offset: 0x044) Voltage Regulator Configuration Register */
  RoReg   Reserved2[1];
  RwReg   VREGNCSR;    /**< \brief (BSCIF Offset: 0x04C) Normal Mode Control and Status Register */
  RwReg   VREGLPCSR;   /**< \brief (BSCIF Offset: 0x050) LP Mode Control and Status Register */
  RoReg   Reserved3[1];
  RwReg   RC1MCR;      /**< \brief (BSCIF Offset: 0x058) 1MHz RC Clock Configuration Register */
  RwReg   BGCR;        /**< \brief (BSCIF Offset: 0x05C) Bandgap Calibration Register */
  RwReg   BGCTRL;      /**< \brief (BSCIF Offset: 0x060) Bandgap Control Register */
  RoReg   BGSR;        /**< \brief (BSCIF Offset: 0x064) Bandgap Status Register */
  RoReg   Reserved4[4];
  BscifBr Br[4]; /**< \brief (BSCIF Offset: 0x078) BscifBr groups */
  RoReg   Reserved5[215];
  RoReg   BRIFBVERSION; /**< \brief (BSCIF Offset: 0x3E4) Backup Register Interface Version Register */
  RoReg   BGREFIFBVERSION; /**< \brief (BSCIF Offset: 0x3E8) BGREFIFB Version Register */
  RoReg   VREGIFGVERSION; /**< \brief (BSCIF Offset: 0x3EC) VREGIFA Version Register */
  RoReg   BODIFCVERSION; /**< \brief (BSCIF Offset: 0x3F0) BODIFC Version Register */
  RoReg   RC32KIFBVERSION; /**< \brief (BSCIF Offset: 0x3F4) 32 kHz RC Oscillator Version Register */
  RoReg   OSC32IFAVERSION; /**< \brief (BSCIF Offset: 0x3F8) 32 KHz Oscillator Version Register */
  RoReg   VERSION;     /**< \brief (BSCIF Offset: 0x3FC) BSCIF Version Register */
} Bscif;
#endif /* __ASSEMBLY__ */
/* -------- BSCIF_IER : (BSCIF Offset: 0x000) Interrupt Enable Register -------- */
#define BSCIF_IER_OSC32RDY          (0x1u <<  0) /**< \brief (BSCIF_IER)  */
#define BSCIF_IER_RC32KRDY          (0x1u <<  1) /**< \brief (BSCIF_IER)  */
#define BSCIF_IER_RC32KLOCK         (0x1u <<  2) /**< \brief (BSCIF_IER)  */
#define BSCIF_IER_RC32KREFE         (0x1u <<  3) /**< \brief (BSCIF_IER)  */
#define BSCIF_IER_RC32KSAT          (0x1u <<  4) /**< \brief (BSCIF_IER)  */
#define BSCIF_IER_BOD33DET          (0x1u <<  5) /**< \brief (BSCIF_IER) BOD33 Detected */
#define BSCIF_IER_BOD18DET          (0x1u <<  6) /**< \brief (BSCIF_IER) BOD18 Detected */
#define BSCIF_IER_BOD33SYNRDY       (0x1u <<  7) /**< \brief (BSCIF_IER) BOD33 Synchronization Ready */
#define BSCIF_IER_BOD18SYNRDY       (0x1u <<  8) /**< \brief (BSCIF_IER) BOD18 Synchronization Ready */
#define BSCIF_IER_SSWRDY            (0x1u <<  9) /**< \brief (BSCIF_IER) VREG Stop Switching Ready */
#define BSCIF_IER_VREGOK            (0x1u << 10) /**< \brief (BSCIF_IER) Main VREG OK */
#define BSCIF_IER_LPBGRDY           (0x1u << 12) /**< \brief (BSCIF_IER) Low Power Bandgap Voltage Reference Ready */
#define BSCIF_IER_AE                (0x1u << 31) /**< \brief (BSCIF_IER) Access Error */
/* -------- BSCIF_IDR : (BSCIF Offset: 0x004) Interrupt Disable Register -------- */
#define BSCIF_IDR_OSC32RDY          (0x1u <<  0) /**< \brief (BSCIF_IDR)  */
#define BSCIF_IDR_RC32KRDY          (0x1u <<  1) /**< \brief (BSCIF_IDR)  */
#define BSCIF_IDR_RC32KLOCK         (0x1u <<  2) /**< \brief (BSCIF_IDR)  */
#define BSCIF_IDR_RC32KREFE         (0x1u <<  3) /**< \brief (BSCIF_IDR)  */
#define BSCIF_IDR_RC32KSAT          (0x1u <<  4) /**< \brief (BSCIF_IDR)  */
#define BSCIF_IDR_BOD33DET          (0x1u <<  5) /**< \brief (BSCIF_IDR) BOD33 Detected */
#define BSCIF_IDR_BOD18DET          (0x1u <<  6) /**< \brief (BSCIF_IDR) BOD18 Detected */
#define BSCIF_IDR_BOD33SYNRDY       (0x1u <<  7) /**< \brief (BSCIF_IDR) BOD33 Synchronization Ready */
#define BSCIF_IDR_BOD18SYNRDY       (0x1u <<  8) /**< \brief (BSCIF_IDR) BOD18 Synchronization Ready */
#define BSCIF_IDR_SSWRDY            (0x1u <<  9) /**< \brief (BSCIF_IDR) VREG Stop Switching Ready */
#define BSCIF_IDR_VREGOK            (0x1u << 10) /**< \brief (BSCIF_IDR) Mai n VREG OK */
#define BSCIF_IDR_LPBGRDY           (0x1u << 12) /**< \brief (BSCIF_IDR) Low Power Bandgap Voltage Reference Ready */
#define BSCIF_IDR_AE                (0x1u << 31) /**< \brief (BSCIF_IDR) Access Error */
/* -------- BSCIF_IMR : (BSCIF Offset: 0x008) Interrupt Mask Register -------- */
#define BSCIF_IMR_OSC32RDY          (0x1u <<  0) /**< \brief (BSCIF_IMR)  */
#define BSCIF_IMR_RC32KRDY          (0x1u <<  1) /**< \brief (BSCIF_IMR)  */
#define BSCIF_IMR_RC32KLOCK         (0x1u <<  2) /**< \brief (BSCIF_IMR)  */
#define BSCIF_IMR_RC32KREFE         (0x1u <<  3) /**< \brief (BSCIF_IMR)  */
#define BSCIF_IMR_RC32KSAT          (0x1u <<  4) /**< \brief (BSCIF_IMR)  */
#define BSCIF_IMR_BOD33DET          (0x1u <<  5) /**< \brief (BSCIF_IMR) BOD33 Detected */
#define BSCIF_IMR_BOD18DET          (0x1u <<  6) /**< \brief (BSCIF_IMR) BOD18 Detected */
#define BSCIF_IMR_BOD33SYNRDY       (0x1u <<  7) /**< \brief (BSCIF_IMR) BOD33 Synchronization Ready */
#define BSCIF_IMR_BOD18SYNRDY       (0x1u <<  8) /**< \brief (BSCIF_IMR) BOD18 Synchronization Ready */
#define BSCIF_IMR_SSWRDY            (0x1u <<  9) /**< \brief (BSCIF_IMR) VREG Stop Switching Ready */
#define BSCIF_IMR_VREGOK            (0x1u << 10) /**< \brief (BSCIF_IMR) Main VREG OK */
#define BSCIF_IMR_LPBGRDY           (0x1u << 12) /**< \brief (BSCIF_IMR) Low Power Bandgap Voltage Reference Ready */
#define BSCIF_IMR_AE                (0x1u << 31) /**< \brief (BSCIF_IMR) Access Error */
/* -------- BSCIF_ISR : (BSCIF Offset: 0x00C) Interrupt Status Register -------- */
#define BSCIF_ISR_OSC32RDY          (0x1u <<  0) /**< \brief (BSCIF_ISR)  */
#define BSCIF_ISR_RC32KRDY          (0x1u <<  1) /**< \brief (BSCIF_ISR)  */
#define BSCIF_ISR_RC32KLOCK         (0x1u <<  2) /**< \brief (BSCIF_ISR)  */
#define BSCIF_ISR_RC32KREFE         (0x1u <<  3) /**< \brief (BSCIF_ISR)  */
#define BSCIF_ISR_RC32KSAT          (0x1u <<  4) /**< \brief (BSCIF_ISR)  */
#define BSCIF_ISR_BOD33DET          (0x1u <<  5) /**< \brief (BSCIF_ISR) BOD33 Detected */
#define BSCIF_ISR_BOD18DET          (0x1u <<  6) /**< \brief (BSCIF_ISR) BOD18 Detected */
#define BSCIF_ISR_BOD33SYNRDY       (0x1u <<  7) /**< \brief (BSCIF_ISR) BOD33 Synchronization Ready */
#define BSCIF_ISR_BOD18SYNRDY       (0x1u <<  8) /**< \brief (BSCIF_ISR) BOD18 Synchronization Ready */
#define BSCIF_ISR_SSWRDY            (0x1u <<  9) /**< \brief (BSCIF_ISR) VREG Stop Switching Ready */
#define BSCIF_ISR_VREGOK            (0x1u << 10) /**< \brief (BSCIF_ISR) Main VREG OK */
#define BSCIF_ISR_LPBGRDY           (0x1u << 12) /**< \brief (BSCIF_ISR) Low Power Bandgap Voltage Reference Ready */
#define BSCIF_ISR_AE                (0x1u << 31) /**< \brief (BSCIF_ISR) Access Error */
/* -------- BSCIF_ICR : (BSCIF Offset: 0x010) Interrupt Clear Register -------- */
#define BSCIF_ICR_OSC32RDY          (0x1u <<  0) /**< \brief (BSCIF_ICR)  */
#define BSCIF_ICR_RC32KRDY          (0x1u <<  1) /**< \brief (BSCIF_ICR)  */
#define BSCIF_ICR_RC32KLOCK         (0x1u <<  2) /**< \brief (BSCIF_ICR)  */
#define BSCIF_ICR_RC32KREFE         (0x1u <<  3) /**< \brief (BSCIF_ICR)  */
#define BSCIF_ICR_RC32KSAT          (0x1u <<  4) /**< \brief (BSCIF_ICR)  */
#define BSCIF_ICR_BOD33DET          (0x1u <<  5) /**< \brief (BSCIF_ICR) BOD33 Detected */
#define BSCIF_ICR_BOD18DET          (0x1u <<  6) /**< \brief (BSCIF_ICR) BOD18 Detected */
#define BSCIF_ICR_BOD33SYNRDY       (0x1u <<  7) /**< \brief (BSCIF_ICR) BOD33 Synchronization Ready */
#define BSCIF_ICR_BOD18SYNRDY       (0x1u <<  8) /**< \brief (BSCIF_ICR) BOD18 Synchronization Ready */
#define BSCIF_ICR_SSWRDY            (0x1u <<  9) /**< \brief (BSCIF_ICR) VREG Stop Switching Ready */
#define BSCIF_ICR_VREGOK            (0x1u << 10) /**< \brief (BSCIF_ICR) Main VREG OK */
#define BSCIF_ICR_LPBGRDY           (0x1u << 12) /**< \brief (BSCIF_ICR) Low Power Bandgap Voltage Reference Ready */
#define BSCIF_ICR_AE                (0x1u << 31) /**< \brief (BSCIF_ICR) Access Error */
/* -------- BSCIF_PCLKSR : (BSCIF Offset: 0x014) Power and Clocks Status Register -------- */
#define BSCIF_PCLKSR_OSC32RDY       (0x1u <<  0) /**< \brief (BSCIF_PCLKSR)  */
#define BSCIF_PCLKSR_RC32KRDY       (0x1u <<  1) /**< \brief (BSCIF_PCLKSR)  */
#define BSCIF_PCLKSR_RC32KLOCK      (0x1u <<  2) /**< \brief (BSCIF_PCLKSR)  */
#define BSCIF_PCLKSR_RC32KREFE      (0x1u <<  3) /**< \brief (BSCIF_PCLKSR)  */
#define BSCIF_PCLKSR_RC32KSAT       (0x1u <<  4) /**< \brief (BSCIF_PCLKSR)  */
#define BSCIF_PCLKSR_BOD33DET       (0x1u <<  5) /**< \brief (BSCIF_PCLKSR) BOD33 Detected */
#define BSCIF_PCLKSR_BOD18DET       (0x1u <<  6) /**< \brief (BSCIF_PCLKSR) BOD18 Detected */
#define BSCIF_PCLKSR_BOD33SYNRDY    (0x1u <<  7) /**< \brief (BSCIF_PCLKSR) BOD33 Synchronization Ready */
#define BSCIF_PCLKSR_BOD18SYNRDY    (0x1u <<  8) /**< \brief (BSCIF_PCLKSR) BOD18 Synchronization Ready */
#define BSCIF_PCLKSR_SSWRDY         (0x1u <<  9) /**< \brief (BSCIF_PCLKSR) VREG Stop Switching Ready */
#define BSCIF_PCLKSR_VREGOK         (0x1u << 10) /**< \brief (BSCIF_PCLKSR) Main VREG OK */
#define BSCIF_PCLKSR_RC1MRDY        (0x1u << 11) /**< \brief (BSCIF_PCLKSR) RC 1MHz Oscillator Ready */
#define BSCIF_PCLKSR_LPBGRDY        (0x1u << 12) /**< \brief (BSCIF_PCLKSR) Low Power Bandgap Voltage Reference Ready */
/* -------- BSCIF_UNLOCK : (BSCIF Offset: 0x018) Unlock Register -------- */
#define BSCIF_UNLOCK_ADDR_Pos       0
#define BSCIF_UNLOCK_ADDR_Msk       (0x3FFu << BSCIF_UNLOCK_ADDR_Pos) /**< \brief (BSCIF_UNLOCK) Unlock Address */
#define BSCIF_UNLOCK_ADDR(value)    ((BSCIF_UNLOCK_ADDR_Msk & ((value) << BSCIF_UNLOCK_ADDR_Pos)))
#define BSCIF_UNLOCK_KEY_Pos        24
#define BSCIF_UNLOCK_KEY_Msk        (0xFFu << BSCIF_UNLOCK_KEY_Pos) /**< \brief (BSCIF_UNLOCK) Unlock Key */
#define BSCIF_UNLOCK_KEY(value)     ((BSCIF_UNLOCK_KEY_Msk & ((value) << BSCIF_UNLOCK_KEY_Pos)))
#define   BSCIF_UNLOCK_KEY_VALID    (0xAAu << 24) /**< \brief (BSCIF_UNLOCK) Valid Key to Unlock register */
/* -------- BSCIF_CSCR : (BSCIF Offset: 0x01C) Chip Specific Configuration Register -------- */
/* -------- BSCIF_OSCCTRL32 : (BSCIF Offset: 0x020) Oscillator 32 Control Register -------- */
#define BSCIF_OSCCTRL32_OSC32EN     (0x1u <<  0) /**< \brief (BSCIF_OSCCTRL32) 32 KHz Oscillator Enable */
#define BSCIF_OSCCTRL32_PINSEL      (0x1u <<  1) /**< \brief (BSCIF_OSCCTRL32) Pins Select */
#define BSCIF_OSCCTRL32_EN32K       (0x1u <<  2) /**< \brief (BSCIF_OSCCTRL32) 32 KHz output Enable */
#define BSCIF_OSCCTRL32_EN1K        (0x1u <<  3) /**< \brief (BSCIF_OSCCTRL32) 1 KHz output Enable */
#define BSCIF_OSCCTRL32_MODE_Pos    8
#define BSCIF_OSCCTRL32_MODE_Msk    (0x7u << BSCIF_OSCCTRL32_MODE_Pos) /**< \brief (BSCIF_OSCCTRL32) Oscillator Mode */
#define BSCIF_OSCCTRL32_MODE(value) ((BSCIF_OSCCTRL32_MODE_Msk & ((value) << BSCIF_OSCCTRL32_MODE_Pos)))
#define BSCIF_OSCCTRL32_SELCURR_Pos    12
#define BSCIF_OSCCTRL32_SELCURR_Msk    (0xFu << BSCIF_OSCCTRL32_SELCURR_Pos) /**< \brief (BSCIF_OSCCTRL32) Current selection */
#define BSCIF_OSCCTRL32_SELCURR(value) ((BSCIF_OSCCTRL32_SELCURR_Msk & ((value) << BSCIF_OSCCTRL32_SELCURR_Pos)))
#define BSCIF_OSCCTRL32_STARTUP_Pos    16
#define BSCIF_OSCCTRL32_STARTUP_Msk    (0x7u << BSCIF_OSCCTRL32_STARTUP_Pos) /**< \brief (BSCIF_OSCCTRL32) Oscillator Start-up Time */
#define BSCIF_OSCCTRL32_STARTUP(value) ((BSCIF_OSCCTRL32_STARTUP_Msk & ((value) << BSCIF_OSCCTRL32_STARTUP_Pos)))
/* -------- BSCIF_RC32KCR : (BSCIF Offset: 0x024) 32 kHz RC Oscillator Control Register -------- */
#define BSCIF_RC32KCR_EN            (0x1u <<  0) /**< \brief (BSCIF_RC32KCR) Enable as Generic clock source */
#define BSCIF_RC32KCR_TCEN          (0x1u <<  1) /**< \brief (BSCIF_RC32KCR) Temperature Compensation Enable */
#define BSCIF_RC32KCR_EN32K         (0x1u <<  2) /**< \brief (BSCIF_RC32KCR) Enable 32 KHz output */
#define BSCIF_RC32KCR_EN1K          (0x1u <<  3) /**< \brief (BSCIF_RC32KCR) Enable 1 kHz output */
#define BSCIF_RC32KCR_MODE          (0x1u <<  4) /**< \brief (BSCIF_RC32KCR) Mode Selection */
#define BSCIF_RC32KCR_REF           (0x1u <<  5) /**< \brief (BSCIF_RC32KCR) Reference select */
#define BSCIF_RC32KCR_FCD           (0x1u <<  7) /**< \brief (BSCIF_RC32KCR) Flash calibration done */
/* -------- BSCIF_RC32KTUNE : (BSCIF Offset: 0x028) 32kHz RC Oscillator Tuning Register -------- */
#define BSCIF_RC32KTUNE_FINE_Pos    0
#define BSCIF_RC32KTUNE_FINE_Msk    (0x3Fu << BSCIF_RC32KTUNE_FINE_Pos) /**< \brief (BSCIF_RC32KTUNE) Fine value */
#define BSCIF_RC32KTUNE_FINE(value) ((BSCIF_RC32KTUNE_FINE_Msk & ((value) << BSCIF_RC32KTUNE_FINE_Pos)))
#define BSCIF_RC32KTUNE_COARSE_Pos    16
#define BSCIF_RC32KTUNE_COARSE_Msk    (0x7Fu << BSCIF_RC32KTUNE_COARSE_Pos) /**< \brief (BSCIF_RC32KTUNE) Coarse Value */
#define BSCIF_RC32KTUNE_COARSE(value) ((BSCIF_RC32KTUNE_COARSE_Msk & ((value) << BSCIF_RC32KTUNE_COARSE_Pos)))
/* -------- BSCIF_BOD33CTRL : (BSCIF Offset: 0x02C) BOD33 Control Register -------- */
#define BSCIF_BOD33CTRL_EN          (0x1u <<  0) /**< \brief (BSCIF_BOD33CTRL) Enable */
#define BSCIF_BOD33CTRL_HYST        (0x1u <<  1) /**< \brief (BSCIF_BOD33CTRL) BOD Hysteresis */
#define BSCIF_BOD33CTRL_ACTION_Pos    8
#define BSCIF_BOD33CTRL_ACTION_Msk    (0x3u << BSCIF_BOD33CTRL_ACTION_Pos) /**< \brief (BSCIF_BOD33CTRL) Action */
#define BSCIF_BOD33CTRL_ACTION(value) ((BSCIF_BOD33CTRL_ACTION_Msk & ((value) << BSCIF_BOD33CTRL_ACTION_Pos)))
#define BSCIF_BOD33CTRL_MODE        (0x1u << 16) /**< \brief (BSCIF_BOD33CTRL) Operation modes */
#define BSCIF_BOD33CTRL_FCD         (0x1u << 30) /**< \brief (BSCIF_BOD33CTRL) BOD Fuse Calibration Done */
#define BSCIF_BOD33CTRL_SFV         (0x1u << 31) /**< \brief (BSCIF_BOD33CTRL) BOD Control Register Store Final Value */
/* -------- BSCIF_BOD33LEVEL : (BSCIF Offset: 0x030) BOD33 Level Register -------- */
#define BSCIF_BOD33LEVEL_VAL_Pos    0
#define BSCIF_BOD33LEVEL_VAL_Msk    (0x3Fu << BSCIF_BOD33LEVEL_VAL_Pos) /**< \brief (BSCIF_BOD33LEVEL) BOD Value */
#define BSCIF_BOD33LEVEL_VAL(value) ((BSCIF_BOD33LEVEL_VAL_Msk & ((value) << BSCIF_BOD33LEVEL_VAL_Pos)))
/* -------- BSCIF_BOD33SAMPLING : (BSCIF Offset: 0x034) BOD33 Sampling Control Register -------- */
#define BSCIF_BOD33SAMPLING_CEN     (0x1u <<  0) /**< \brief (BSCIF_BOD33SAMPLING) Clock Enable */
#define BSCIF_BOD33SAMPLING_CSSEL   (0x1u <<  1) /**< \brief (BSCIF_BOD33SAMPLING) Clock Source Select */
#define BSCIF_BOD33SAMPLING_PSEL_Pos    8
#define BSCIF_BOD33SAMPLING_PSEL_Msk    (0xFu << BSCIF_BOD33SAMPLING_PSEL_Pos) /**< \brief (BSCIF_BOD33SAMPLING) Prescaler Select */
#define BSCIF_BOD33SAMPLING_PSEL(value) ((BSCIF_BOD33SAMPLING_PSEL_Msk & ((value) << BSCIF_BOD33SAMPLING_PSEL_Pos)))
/* -------- BSCIF_BOD18CTRL : (BSCIF Offset: 0x038) BOD18 Control Register -------- */
#define BSCIF_BOD18CTRL_EN          (0x1u <<  0) /**< \brief (BSCIF_BOD18CTRL) Enable */
#define BSCIF_BOD18CTRL_HYST        (0x1u <<  1) /**< \brief (BSCIF_BOD18CTRL) BOD Hysteresis */
#define BSCIF_BOD18CTRL_ACTION_Pos    8
#define BSCIF_BOD18CTRL_ACTION_Msk    (0x3u << BSCIF_BOD18CTRL_ACTION_Pos) /**< \brief (BSCIF_BOD18CTRL) Action */
#define BSCIF_BOD18CTRL_ACTION(value) ((BSCIF_BOD18CTRL_ACTION_Msk & ((value) << BSCIF_BOD18CTRL_ACTION_Pos)))
#define BSCIF_BOD18CTRL_MODE        (0x1u << 16) /**< \brief (BSCIF_BOD18CTRL) Operation modes */
#define BSCIF_BOD18CTRL_FCD         (0x1u << 30) /**< \brief (BSCIF_BOD18CTRL) BOD Fuse Calibration Done */
#define BSCIF_BOD18CTRL_SFV         (0x1u << 31) /**< \brief (BSCIF_BOD18CTRL) BOD Control Register Store Final Value */
/* -------- BSCIF_BOD18LEVEL : (BSCIF Offset: 0x03C) BOD18 Level Register -------- */
#define BSCIF_BOD18LEVEL_VAL_Pos    0
#define BSCIF_BOD18LEVEL_VAL_Msk    (0x3Fu << BSCIF_BOD18LEVEL_VAL_Pos) /**< \brief (BSCIF_BOD18LEVEL) BOD Value */
#define BSCIF_BOD18LEVEL_VAL(value) ((BSCIF_BOD18LEVEL_VAL_Msk & ((value) << BSCIF_BOD18LEVEL_VAL_Pos)))
#define BSCIF_BOD18LEVEL_RANGE      (0x1u << 31) /**< \brief (BSCIF_BOD18LEVEL) BOD Threshold Range */
/* -------- BSCIF_VREGCR : (BSCIF Offset: 0x044) Voltage Regulator Configuration Register -------- */
#define BSCIF_VREGCR_DIS            (0x1u <<  0) /**< \brief (BSCIF_VREGCR) Voltage Regulator disable */
#define BSCIF_VREGCR_SSG            (0x1u <<  8) /**< \brief (BSCIF_VREGCR) Spread Spectrum Generator Enable */
#define BSCIF_VREGCR_SSW            (0x1u <<  9) /**< \brief (BSCIF_VREGCR) Stop Switching */
#define BSCIF_VREGCR_SSWEVT         (0x1u << 10) /**< \brief (BSCIF_VREGCR) Stop Switching On Event Enable */
#define BSCIF_VREGCR_SFV            (0x1u << 31) /**< \brief (BSCIF_VREGCR) Store Final Value */
/* -------- BSCIF_VREGNCSR : (BSCIF Offset: 0x04C) Normal Mode Control and Status Register -------- */
/* -------- BSCIF_VREGLPCSR : (BSCIF Offset: 0x050) LP Mode Control and Status Register -------- */
/* -------- BSCIF_RC1MCR : (BSCIF Offset: 0x058) 1MHz RC Clock Configuration Register -------- */
#define BSCIF_RC1MCR_CLKOE          (0x1u <<  0) /**< \brief (BSCIF_RC1MCR) 1MHz RC Osc Clock Output Enable */
#define BSCIF_RC1MCR_FCD            (0x1u <<  7) /**< \brief (BSCIF_RC1MCR) Flash Calibration Done */
#define BSCIF_RC1MCR_CLKCAL_Pos     8
#define BSCIF_RC1MCR_CLKCAL_Msk     (0x1Fu << BSCIF_RC1MCR_CLKCAL_Pos) /**< \brief (BSCIF_RC1MCR) 1MHz RC Osc Calibration */
#define BSCIF_RC1MCR_CLKCAL(value)  ((BSCIF_RC1MCR_CLKCAL_Msk & ((value) << BSCIF_RC1MCR_CLKCAL_Pos)))
/* -------- BSCIF_BGCR : (BSCIF Offset: 0x05C) Bandgap Calibration Register -------- */
/* -------- BSCIF_BGCTRL : (BSCIF Offset: 0x060) Bandgap Control Register -------- */
#define BSCIF_BGCTRL_ADCISEL_Pos    0
#define BSCIF_BGCTRL_ADCISEL_Msk    (0x3u << BSCIF_BGCTRL_ADCISEL_Pos) /**< \brief (BSCIF_BGCTRL) ADC Input Selection */
#define BSCIF_BGCTRL_ADCISEL(value) ((BSCIF_BGCTRL_ADCISEL_Msk & ((value) << BSCIF_BGCTRL_ADCISEL_Pos)))
#define   BSCIF_BGCTRL_ADCISEL_DIS  (0x0u <<  0) /**< \brief (BSCIF_BGCTRL)  */
#define   BSCIF_BGCTRL_ADCISEL_VTEMP (0x1u <<  0) /**< \brief (BSCIF_BGCTRL)  */
#define   BSCIF_BGCTRL_ADCISEL_VREF (0x2u <<  0) /**< \brief (BSCIF_BGCTRL)  */
#define BSCIF_BGCTRL_TSEN           (0x1u <<  8) /**< \brief (BSCIF_BGCTRL) Temperature Sensor Enable */
/* -------- BSCIF_BGSR : (BSCIF Offset: 0x064) Bandgap Status Register -------- */
#define BSCIF_BGSR_BGBUFRDY_Pos     0
#define BSCIF_BGSR_BGBUFRDY_Msk     (0xFFu << BSCIF_BGSR_BGBUFRDY_Pos) /**< \brief (BSCIF_BGSR) Bandgap Buffer Ready */
#define BSCIF_BGSR_BGBUFRDY(value)  ((BSCIF_BGSR_BGBUFRDY_Msk & ((value) << BSCIF_BGSR_BGBUFRDY_Pos)))
#define   BSCIF_BGSR_BGBUFRDY_FLASH (0x1u <<  0) /**< \brief (BSCIF_BGSR)  */
#define   BSCIF_BGSR_BGBUFRDY_PLL   (0x2u <<  0) /**< \brief (BSCIF_BGSR)  */
#define   BSCIF_BGSR_BGBUFRDY_VREG  (0x4u <<  0) /**< \brief (BSCIF_BGSR)  */
#define   BSCIF_BGSR_BGBUFRDY_BUFRR (0x8u <<  0) /**< \brief (BSCIF_BGSR)  */
#define   BSCIF_BGSR_BGBUFRDY_ADC   (0x10u <<  0) /**< \brief (BSCIF_BGSR)  */
#define   BSCIF_BGSR_BGBUFRDY_LCD   (0x20u <<  0) /**< \brief (BSCIF_BGSR)  */
#define BSCIF_BGSR_BGRDY            (0x1u << 16) /**< \brief (BSCIF_BGSR) Bandgap Voltage Reference Ready */
#define BSCIF_BGSR_LPBGRDY          (0x1u << 17) /**< \brief (BSCIF_BGSR) Low Power Bandgap Voltage Reference Ready */
#define BSCIF_BGSR_VREF_Pos         18
#define BSCIF_BGSR_VREF_Msk         (0x3u << BSCIF_BGSR_VREF_Pos) /**< \brief (BSCIF_BGSR) Voltage Reference Used by the System */
#define BSCIF_BGSR_VREF(value)      ((BSCIF_BGSR_VREF_Msk & ((value) << BSCIF_BGSR_VREF_Pos)))
/* -------- BSCIF_BRIFBVERSION : (BSCIF Offset: 0x3E4) Backup Register Interface Version Register -------- */
#define BSCIF_BRIFBVERSION_VERSION_Pos    0
#define BSCIF_BRIFBVERSION_VERSION_Msk    (0xFFFu << BSCIF_BRIFBVERSION_VERSION_Pos) /**< \brief (BSCIF_BRIFBVERSION) Version Number */
#define BSCIF_BRIFBVERSION_VERSION(value) ((BSCIF_BRIFBVERSION_VERSION_Msk & ((value) << BSCIF_BRIFBVERSION_VERSION_Pos)))
#define BSCIF_BRIFBVERSION_VARIANT_Pos    16
#define BSCIF_BRIFBVERSION_VARIANT_Msk    (0xFu << BSCIF_BRIFBVERSION_VARIANT_Pos) /**< \brief (BSCIF_BRIFBVERSION) Variant Number */
#define BSCIF_BRIFBVERSION_VARIANT(value) ((BSCIF_BRIFBVERSION_VARIANT_Msk & ((value) << BSCIF_BRIFBVERSION_VARIANT_Pos)))
/* -------- BSCIF_BGREFIFBVERSION : (BSCIF Offset: 0x3E8) BGREFIFB Version Register -------- */
#define BSCIF_BGREFIFBVERSION_VERSION_Pos    0
#define BSCIF_BGREFIFBVERSION_VERSION_Msk    (0xFFFu << BSCIF_BGREFIFBVERSION_VERSION_Pos) /**< \brief (BSCIF_BGREFIFBVERSION) Version Number */
#define BSCIF_BGREFIFBVERSION_VERSION(value) ((BSCIF_BGREFIFBVERSION_VERSION_Msk & ((value) << BSCIF_BGREFIFBVERSION_VERSION_Pos)))
#define BSCIF_BGREFIFBVERSION_VARIANT_Pos    16
#define BSCIF_BGREFIFBVERSION_VARIANT_Msk    (0xFu << BSCIF_BGREFIFBVERSION_VARIANT_Pos) /**< \brief (BSCIF_BGREFIFBVERSION) Variant Number */
#define BSCIF_BGREFIFBVERSION_VARIANT(value) ((BSCIF_BGREFIFBVERSION_VARIANT_Msk & ((value) << BSCIF_BGREFIFBVERSION_VARIANT_Pos)))
/* -------- BSCIF_VREGIFGVERSION : (BSCIF Offset: 0x3EC) VREGIFA Version Register -------- */
#define BSCIF_VREGIFGVERSION_VERSION_Pos    0
#define BSCIF_VREGIFGVERSION_VERSION_Msk    (0xFFFu << BSCIF_VREGIFGVERSION_VERSION_Pos) /**< \brief (BSCIF_VREGIFGVERSION) Version Number */
#define BSCIF_VREGIFGVERSION_VERSION(value) ((BSCIF_VREGIFGVERSION_VERSION_Msk & ((value) << BSCIF_VREGIFGVERSION_VERSION_Pos)))
#define BSCIF_VREGIFGVERSION_VARIANT_Pos    16
#define BSCIF_VREGIFGVERSION_VARIANT_Msk    (0xFu << BSCIF_VREGIFGVERSION_VARIANT_Pos) /**< \brief (BSCIF_VREGIFGVERSION) Variant Number */
#define BSCIF_VREGIFGVERSION_VARIANT(value) ((BSCIF_VREGIFGVERSION_VARIANT_Msk & ((value) << BSCIF_VREGIFGVERSION_VARIANT_Pos)))
/* -------- BSCIF_BODIFCVERSION : (BSCIF Offset: 0x3F0) BODIFC Version Register -------- */
#define BSCIF_BODIFCVERSION_VERSION_Pos    0
#define BSCIF_BODIFCVERSION_VERSION_Msk    (0xFFFu << BSCIF_BODIFCVERSION_VERSION_Pos) /**< \brief (BSCIF_BODIFCVERSION) Version Number */
#define BSCIF_BODIFCVERSION_VERSION(value) ((BSCIF_BODIFCVERSION_VERSION_Msk & ((value) << BSCIF_BODIFCVERSION_VERSION_Pos)))
#define BSCIF_BODIFCVERSION_VARIANT_Pos    16
#define BSCIF_BODIFCVERSION_VARIANT_Msk    (0xFu << BSCIF_BODIFCVERSION_VARIANT_Pos) /**< \brief (BSCIF_BODIFCVERSION) Variant Number */
#define BSCIF_BODIFCVERSION_VARIANT(value) ((BSCIF_BODIFCVERSION_VARIANT_Msk & ((value) << BSCIF_BODIFCVERSION_VARIANT_Pos)))
/* -------- BSCIF_RC32KIFBVERSION : (BSCIF Offset: 0x3F4) 32 kHz RC Oscillator Version Register -------- */
#define BSCIF_RC32KIFBVERSION_VERSION_Pos    0
#define BSCIF_RC32KIFBVERSION_VERSION_Msk    (0xFFFu << BSCIF_RC32KIFBVERSION_VERSION_Pos) /**< \brief (BSCIF_RC32KIFBVERSION) Version number */
#define BSCIF_RC32KIFBVERSION_VERSION(value) ((BSCIF_RC32KIFBVERSION_VERSION_Msk & ((value) << BSCIF_RC32KIFBVERSION_VERSION_Pos)))
#define BSCIF_RC32KIFBVERSION_VARIANT_Pos    16
#define BSCIF_RC32KIFBVERSION_VARIANT_Msk    (0xFu << BSCIF_RC32KIFBVERSION_VARIANT_Pos) /**< \brief (BSCIF_RC32KIFBVERSION) Variant number */
#define BSCIF_RC32KIFBVERSION_VARIANT(value) ((BSCIF_RC32KIFBVERSION_VARIANT_Msk & ((value) << BSCIF_RC32KIFBVERSION_VARIANT_Pos)))
/* -------- BSCIF_OSC32IFAVERSION : (BSCIF Offset: 0x3F8) 32 KHz Oscillator Version Register -------- */
#define BSCIF_OSC32IFAVERSION_VERSION_Pos    0
#define BSCIF_OSC32IFAVERSION_VERSION_Msk    (0xFFFu << BSCIF_OSC32IFAVERSION_VERSION_Pos) /**< \brief (BSCIF_OSC32IFAVERSION) Version number */
#define BSCIF_OSC32IFAVERSION_VERSION(value) ((BSCIF_OSC32IFAVERSION_VERSION_Msk & ((value) << BSCIF_OSC32IFAVERSION_VERSION_Pos)))
#define BSCIF_OSC32IFAVERSION_VARIANT_Pos    16
#define BSCIF_OSC32IFAVERSION_VARIANT_Msk    (0xFu << BSCIF_OSC32IFAVERSION_VARIANT_Pos) /**< \brief (BSCIF_OSC32IFAVERSION) Variant nubmer */
#define BSCIF_OSC32IFAVERSION_VARIANT(value) ((BSCIF_OSC32IFAVERSION_VARIANT_Msk & ((value) << BSCIF_OSC32IFAVERSION_VARIANT_Pos)))
/* -------- BSCIF_VERSION : (BSCIF Offset: 0x3FC) BSCIF Version Register -------- */
#define BSCIF_VERSION_VERSION_Pos    0
#define BSCIF_VERSION_VERSION_Msk    (0xFFFu << BSCIF_VERSION_VERSION_Pos) /**< \brief (BSCIF_VERSION) Version Number */
#define BSCIF_VERSION_VERSION(value) ((BSCIF_VERSION_VERSION_Msk & ((value) << BSCIF_VERSION_VERSION_Pos)))
#define BSCIF_VERSION_VARIANT_Pos    16
#define BSCIF_VERSION_VARIANT_Msk    (0xFu << BSCIF_VERSION_VARIANT_Pos) /**< \brief (BSCIF_VERSION) Variant Number */
#define BSCIF_VERSION_VARIANT(value) ((BSCIF_VERSION_VARIANT_Msk & ((value) << BSCIF_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR CATB */
/* ============================================================================= */
/** \addtogroup SAM4L4_CATB Capacitive Touch Module B */
/*@{*/

#define REV_CATB       0x100

#ifndef __ASSEMBLY__
/** \brief CatbIntch hardware registers */
typedef struct {
  RoReg   INTCH;       /**< \brief (CatbIntch Offset: 0x00) In-Touch Status Register 0 */
} CatbIntch;
/** \brief CatbIntchclr hardware registers */
typedef struct {
  WoReg   INTCHCLR;    /**< \brief (CatbIntchclr Offset: 0x00) In-Touch Status Clear Register 0 */
} CatbIntchclr;
/** \brief CatbOuttch hardware registers */
typedef struct {
  RoReg   OUTTCH;      /**< \brief (CatbOuttch Offset: 0x00) Out-of-Touch Status Register 0 */
} CatbOuttch;
/** \brief CatbOuttchclr hardware registers */
typedef struct {
  WoReg   OUTTCHCLR;   /**< \brief (CatbOuttchclr Offset: 0x00) Out-of-Touch Status Clear Register 0 */
} CatbOuttchclr;
/** \brief CATB hardware registers */
#define CATB_STATUS_REG_NUMBER 1
typedef struct {
  RwReg   CR;          /**< \brief (CATB Offset: 0x00) Control Register */
  RwReg   CNTCR;       /**< \brief (CATB Offset: 0x04) Counter Control Register */
  RwReg   IDLE;        /**< \brief (CATB Offset: 0x08) Sensor Idle Level */
  RoReg   LEVEL;       /**< \brief (CATB Offset: 0x0C) Sensor Relative Level */
  RoReg   RAW;         /**< \brief (CATB Offset: 0x10) Sensor Raw Value */
  RwReg   TIMING;      /**< \brief (CATB Offset: 0x14) Filter Timing Register */
  RwReg   THRESH;      /**< \brief (CATB Offset: 0x18) Threshold Register */
  RwReg   PINSEL;      /**< \brief (CATB Offset: 0x1C) Pin Selection Register */
  RwReg   DMA;         /**< \brief (CATB Offset: 0x20) Direct Memory Access Register */
  RoReg   ISR;         /**< \brief (CATB Offset: 0x24) Interrupt Status Register */
  WoReg   IER;         /**< \brief (CATB Offset: 0x28) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (CATB Offset: 0x2C) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (CATB Offset: 0x30) Interrupt Mask Register */
  WoReg   SCR;         /**< \brief (CATB Offset: 0x34) Status Clear Register */
  RoReg   Reserved1[2];
  CatbIntch Intch[CATB_STATUS_REG_NUMBER]; /**< \brief (CATB Offset: 0x40) CatbIntch groups */
  CatbIntch Reserved2[4 - CATB_STATUS_REG_NUMBER];
  CatbIntchclr Intchclr[CATB_STATUS_REG_NUMBER]; /**< \brief (CATB Offset: 0x50) CatbIntchclr groups */
  CatbIntchclr Reserved3[4 - CATB_STATUS_REG_NUMBER];
  CatbOuttch Outtch[CATB_STATUS_REG_NUMBER]; /**< \brief (CATB Offset: 0x60) CatbOuttch groups */
  CatbOuttch Reserved4[4 - CATB_STATUS_REG_NUMBER];
  CatbOuttchclr Outtchclr[CATB_STATUS_REG_NUMBER]; /**< \brief (CATB Offset: 0x70) CatbOuttchclr groups */
  CatbOuttchclr Reserved5[4 - CATB_STATUS_REG_NUMBER];
  RoReg   Reserved6[30];
  RoReg   PARAMETER;   /**< \brief (CATB Offset: 0xF8) Parameter Register */
  RoReg   VERSION;     /**< \brief (CATB Offset: 0xFC) Version Register */
} Catb;
#endif /* __ASSEMBLY__ */
/* -------- CATB_CR : (CATB Offset: 0x00) Control Register -------- */
#define CATB_CR_EN                  (0x1u <<  0) /**< \brief (CATB_CR) Module Enable */
#define CATB_CR_RUN                 (0x1u <<  1) /**< \brief (CATB_CR) Start Operation */
#define CATB_CR_IIDLE               (0x1u <<  2) /**< \brief (CATB_CR) Initialize Idle Value */
#define CATB_CR_ETRIG               (0x1u <<  3) /**< \brief (CATB_CR) Event Triggered Operation */
#define CATB_CR_INTRES              (0x1u <<  4) /**< \brief (CATB_CR) Internal Resistors */
#define CATB_CR_CKSEL               (0x1u <<  5) /**< \brief (CATB_CR) Clock Select */
#define CATB_CR_DIFF                (0x1u <<  6) /**< \brief (CATB_CR) Differential Mode */
#define CATB_CR_DMAEN               (0x1u <<  7) /**< \brief (CATB_CR) DMA Enable */
#define CATB_CR_ESAMPLES_Pos        8
#define CATB_CR_ESAMPLES_Msk        (0x7Fu << CATB_CR_ESAMPLES_Pos) /**< \brief (CATB_CR) Number of Event Samples */
#define CATB_CR_ESAMPLES(value)     ((CATB_CR_ESAMPLES_Msk & ((value) << CATB_CR_ESAMPLES_Pos)))
#define CATB_CR_CHARGET_Pos         16
#define CATB_CR_CHARGET_Msk         (0xFu << CATB_CR_CHARGET_Pos) /**< \brief (CATB_CR) Charge Time */
#define CATB_CR_CHARGET(value)      ((CATB_CR_CHARGET_Msk & ((value) << CATB_CR_CHARGET_Pos)))
#define CATB_CR_SWRST               (0x1u << 31) /**< \brief (CATB_CR) Software Reset */
/* -------- CATB_CNTCR : (CATB Offset: 0x04) Counter Control Register -------- */
#define CATB_CNTCR_TOP_Pos          0
#define CATB_CNTCR_TOP_Msk          (0xFFFFFFu << CATB_CNTCR_TOP_Pos) /**< \brief (CATB_CNTCR) Counter Top Value */
#define CATB_CNTCR_TOP(value)       ((CATB_CNTCR_TOP_Msk & ((value) << CATB_CNTCR_TOP_Pos)))
#define CATB_CNTCR_SPREAD_Pos       24
#define CATB_CNTCR_SPREAD_Msk       (0xFu << CATB_CNTCR_SPREAD_Pos) /**< \brief (CATB_CNTCR) Spread Spectrum */
#define CATB_CNTCR_SPREAD(value)    ((CATB_CNTCR_SPREAD_Msk & ((value) << CATB_CNTCR_SPREAD_Pos)))
#define CATB_CNTCR_REPEAT_Pos       28
#define CATB_CNTCR_REPEAT_Msk       (0x7u << CATB_CNTCR_REPEAT_Pos) /**< \brief (CATB_CNTCR) Repeat Measurements */
#define CATB_CNTCR_REPEAT(value)    ((CATB_CNTCR_REPEAT_Msk & ((value) << CATB_CNTCR_REPEAT_Pos)))
/* -------- CATB_IDLE : (CATB Offset: 0x08) Sensor Idle Level -------- */
#define CATB_IDLE_FIDLE_Pos         0
#define CATB_IDLE_FIDLE_Msk         (0xFFFu << CATB_IDLE_FIDLE_Pos) /**< \brief (CATB_IDLE) Fractional Sensor Idle */
#define CATB_IDLE_FIDLE(value)      ((CATB_IDLE_FIDLE_Msk & ((value) << CATB_IDLE_FIDLE_Pos)))
#define CATB_IDLE_RIDLE_Pos         12
#define CATB_IDLE_RIDLE_Msk         (0xFFFFu << CATB_IDLE_RIDLE_Pos) /**< \brief (CATB_IDLE) Integer Sensor Idle */
#define CATB_IDLE_RIDLE(value)      ((CATB_IDLE_RIDLE_Msk & ((value) << CATB_IDLE_RIDLE_Pos)))
/* -------- CATB_LEVEL : (CATB Offset: 0x0C) Sensor Relative Level -------- */
#define CATB_LEVEL_FLEVEL_Pos       0
#define CATB_LEVEL_FLEVEL_Msk       (0xFFFu << CATB_LEVEL_FLEVEL_Pos) /**< \brief (CATB_LEVEL) Fractional Sensor Level */
#define CATB_LEVEL_FLEVEL(value)    ((CATB_LEVEL_FLEVEL_Msk & ((value) << CATB_LEVEL_FLEVEL_Pos)))
#define CATB_LEVEL_RLEVEL_Pos       12
#define CATB_LEVEL_RLEVEL_Msk       (0xFFu << CATB_LEVEL_RLEVEL_Pos) /**< \brief (CATB_LEVEL) Integer Sensor Level */
#define CATB_LEVEL_RLEVEL(value)    ((CATB_LEVEL_RLEVEL_Msk & ((value) << CATB_LEVEL_RLEVEL_Pos)))
/* -------- CATB_RAW : (CATB Offset: 0x10) Sensor Raw Value -------- */
#define CATB_RAW_RAWA_Pos           16
#define CATB_RAW_RAWA_Msk           (0xFFu << CATB_RAW_RAWA_Pos) /**< \brief (CATB_RAW) Current Sensor Raw Value */
#define CATB_RAW_RAWA(value)        ((CATB_RAW_RAWA_Msk & ((value) << CATB_RAW_RAWA_Pos)))
#define CATB_RAW_RAWB_Pos           24
#define CATB_RAW_RAWB_Msk           (0xFFu << CATB_RAW_RAWB_Pos) /**< \brief (CATB_RAW) Last Sensor Raw Value */
#define CATB_RAW_RAWB(value)        ((CATB_RAW_RAWB_Msk & ((value) << CATB_RAW_RAWB_Pos)))
/* -------- CATB_TIMING : (CATB Offset: 0x14) Filter Timing Register -------- */
#define CATB_TIMING_TLEVEL_Pos      0
#define CATB_TIMING_TLEVEL_Msk      (0xFFFu << CATB_TIMING_TLEVEL_Pos) /**< \brief (CATB_TIMING) Relative Level Smoothing */
#define CATB_TIMING_TLEVEL(value)   ((CATB_TIMING_TLEVEL_Msk & ((value) << CATB_TIMING_TLEVEL_Pos)))
#define CATB_TIMING_TIDLE_Pos       16
#define CATB_TIMING_TIDLE_Msk       (0xFFFu << CATB_TIMING_TIDLE_Pos) /**< \brief (CATB_TIMING) Idle Smoothening */
#define CATB_TIMING_TIDLE(value)    ((CATB_TIMING_TIDLE_Msk & ((value) << CATB_TIMING_TIDLE_Pos)))
/* -------- CATB_THRESH : (CATB Offset: 0x18) Threshold Register -------- */
#define CATB_THRESH_FTHRESH_Pos     0
#define CATB_THRESH_FTHRESH_Msk     (0xFFFu << CATB_THRESH_FTHRESH_Pos) /**< \brief (CATB_THRESH) Fractional part of Threshold Value */
#define CATB_THRESH_FTHRESH(value)  ((CATB_THRESH_FTHRESH_Msk & ((value) << CATB_THRESH_FTHRESH_Pos)))
#define CATB_THRESH_RTHRESH_Pos     12
#define CATB_THRESH_RTHRESH_Msk     (0xFFu << CATB_THRESH_RTHRESH_Pos) /**< \brief (CATB_THRESH) Rational part of Threshold Value */
#define CATB_THRESH_RTHRESH(value)  ((CATB_THRESH_RTHRESH_Msk & ((value) << CATB_THRESH_RTHRESH_Pos)))
#define CATB_THRESH_DIR             (0x1u << 23) /**< \brief (CATB_THRESH) Threshold Direction */
#define CATB_THRESH_LENGTH_Pos      24
#define CATB_THRESH_LENGTH_Msk      (0x1Fu << CATB_THRESH_LENGTH_Pos) /**< \brief (CATB_THRESH) Threshold Length */
#define CATB_THRESH_LENGTH(value)   ((CATB_THRESH_LENGTH_Msk & ((value) << CATB_THRESH_LENGTH_Pos)))
/* -------- CATB_PINSEL : (CATB Offset: 0x1C) Pin Selection Register -------- */
#define CATB_PINSEL_PINSEL_Pos      0
#define CATB_PINSEL_PINSEL_Msk      (0xFFu << CATB_PINSEL_PINSEL_Pos) /**< \brief (CATB_PINSEL) Pin Select */
#define CATB_PINSEL_PINSEL(value)   ((CATB_PINSEL_PINSEL_Msk & ((value) << CATB_PINSEL_PINSEL_Pos)))
/* -------- CATB_DMA : (CATB Offset: 0x20) Direct Memory Access Register -------- */
#define CATB_DMA_DMA_Pos            0
#define CATB_DMA_DMA_Msk            (0xFFFFFFFFu << CATB_DMA_DMA_Pos) /**< \brief (CATB_DMA) Direct Memory Access */
#define CATB_DMA_DMA(value)         ((CATB_DMA_DMA_Msk & ((value) << CATB_DMA_DMA_Pos)))
/* -------- CATB_ISR : (CATB Offset: 0x24) Interrupt Status Register -------- */
#define CATB_ISR_SAMPLE             (0x1u <<  0) /**< \brief (CATB_ISR) Sample Ready Interrupt Status */
#define CATB_ISR_INTCH              (0x1u <<  1) /**< \brief (CATB_ISR) In-touch Interrupt Status */
#define CATB_ISR_OUTTCH             (0x1u <<  2) /**< \brief (CATB_ISR) Out-of-Touch Interrupt Status */
/* -------- CATB_IER : (CATB Offset: 0x28) Interrupt Enable Register -------- */
#define CATB_IER_SAMPLE             (0x1u <<  0) /**< \brief (CATB_IER) Sample Ready Interrupt Enable */
#define CATB_IER_INTCH              (0x1u <<  1) /**< \brief (CATB_IER) In-touch Interrupt Enable */
#define CATB_IER_OUTTCH             (0x1u <<  2) /**< \brief (CATB_IER) Out-of-Touch Interrupt Enable */
/* -------- CATB_IDR : (CATB Offset: 0x2C) Interrupt Disable Register -------- */
#define CATB_IDR_SAMPLE             (0x1u <<  0) /**< \brief (CATB_IDR) Sample Ready Interrupt Disable */
#define CATB_IDR_INTCH              (0x1u <<  1) /**< \brief (CATB_IDR) In-touch Interrupt Disable */
#define CATB_IDR_OUTTCH             (0x1u <<  2) /**< \brief (CATB_IDR) Out-of-Touch Interrupt Disable */
/* -------- CATB_IMR : (CATB Offset: 0x30) Interrupt Mask Register -------- */
#define CATB_IMR_SAMPLE             (0x1u <<  0) /**< \brief (CATB_IMR) Sample Ready Interrupt Mask */
#define CATB_IMR_INTCH              (0x1u <<  1) /**< \brief (CATB_IMR) In-touch Interrupt Mask */
#define CATB_IMR_OUTTCH             (0x1u <<  2) /**< \brief (CATB_IMR) Out-of-Touch Interrupt Mask */
/* -------- CATB_SCR : (CATB Offset: 0x34) Status Clear Register -------- */
#define CATB_SCR_SAMPLE             (0x1u <<  0) /**< \brief (CATB_SCR) Sample Ready */
#define CATB_SCR_INTCH              (0x1u <<  1) /**< \brief (CATB_SCR) In-touch */
#define CATB_SCR_OUTTCH             (0x1u <<  2) /**< \brief (CATB_SCR) Out-of-Touch */
/* -------- CATB_INTCH : (CATB Offset: 0x40) Intch In-Touch Status Register 0 -------- */
#define CATB_INTCH_INTCH_Pos        0
#define CATB_INTCH_INTCH_Msk        (0xFFFFFFFFu << CATB_INTCH_INTCH_Pos) /**< \brief (CATB_INTCH) In-Touch */
#define CATB_INTCH_INTCH(value)     ((CATB_INTCH_INTCH_Msk & ((value) << CATB_INTCH_INTCH_Pos)))
/* -------- CATB_INTCHCLR : (CATB Offset: 0x50) Intchclr In-Touch Status Clear Register 0 -------- */
#define CATB_INTCHCLR_INTCHCLR_Pos    0
#define CATB_INTCHCLR_INTCHCLR_Msk    (0xFFFFFFFFu << CATB_INTCHCLR_INTCHCLR_Pos) /**< \brief (CATB_INTCHCLR) In-Touch Clear */
#define CATB_INTCHCLR_INTCHCLR(value) ((CATB_INTCHCLR_INTCHCLR_Msk & ((value) << CATB_INTCHCLR_INTCHCLR_Pos)))
/* -------- CATB_OUTTCH : (CATB Offset: 0x60) Outtch Out-of-Touch Status Register 0 -------- */
#define CATB_OUTTCH_OUTTCH_Pos      0
#define CATB_OUTTCH_OUTTCH_Msk      (0xFFFFFFFFu << CATB_OUTTCH_OUTTCH_Pos) /**< \brief (CATB_OUTTCH) Out-of-Touch */
#define CATB_OUTTCH_OUTTCH(value)   ((CATB_OUTTCH_OUTTCH_Msk & ((value) << CATB_OUTTCH_OUTTCH_Pos)))
/* -------- CATB_OUTTCHCLR : (CATB Offset: 0x70) Outtchclr Out-of-Touch Status Clear Register 0 -------- */
#define CATB_OUTTCHCLR_OUTTCHCLR_Pos    0
#define CATB_OUTTCHCLR_OUTTCHCLR_Msk    (0xFFFFFFFFu << CATB_OUTTCHCLR_OUTTCHCLR_Pos) /**< \brief (CATB_OUTTCHCLR) Out of Touch */
#define CATB_OUTTCHCLR_OUTTCHCLR(value) ((CATB_OUTTCHCLR_OUTTCHCLR_Msk & ((value) << CATB_OUTTCHCLR_OUTTCHCLR_Pos)))
/* -------- CATB_PARAMETER : (CATB Offset: 0xF8) Parameter Register -------- */
#define CATB_PARAMETER_NPINS_Pos    0
#define CATB_PARAMETER_NPINS_Msk    (0xFFu << CATB_PARAMETER_NPINS_Pos) /**< \brief (CATB_PARAMETER) Number of Pins */
#define CATB_PARAMETER_NPINS(value) ((CATB_PARAMETER_NPINS_Msk & ((value) << CATB_PARAMETER_NPINS_Pos)))
#define CATB_PARAMETER_NSTATUS_Pos    8
#define CATB_PARAMETER_NSTATUS_Msk    (0xFFu << CATB_PARAMETER_NSTATUS_Pos) /**< \brief (CATB_PARAMETER) Number of Status bits */
#define CATB_PARAMETER_NSTATUS(value) ((CATB_PARAMETER_NSTATUS_Msk & ((value) << CATB_PARAMETER_NSTATUS_Pos)))
#define CATB_PARAMETER_FRACTIONAL_Pos    16
#define CATB_PARAMETER_FRACTIONAL_Msk    (0xFu << CATB_PARAMETER_FRACTIONAL_Pos) /**< \brief (CATB_PARAMETER) Number of Fractional bits */
#define CATB_PARAMETER_FRACTIONAL(value) ((CATB_PARAMETER_FRACTIONAL_Msk & ((value) << CATB_PARAMETER_FRACTIONAL_Pos)))
/* -------- CATB_VERSION : (CATB Offset: 0xFC) Version Register -------- */
#define CATB_VERSION_VERSION_Pos    0
#define CATB_VERSION_VERSION_Msk    (0xFFFu << CATB_VERSION_VERSION_Pos) /**< \brief (CATB_VERSION) Version number */
#define CATB_VERSION_VERSION(value) ((CATB_VERSION_VERSION_Msk & ((value) << CATB_VERSION_VERSION_Pos)))
#define CATB_VERSION_VARIANT_Pos    16
#define CATB_VERSION_VARIANT_Msk    (0xFu << CATB_VERSION_VARIANT_Pos) /**< \brief (CATB_VERSION) Variant number */
#define CATB_VERSION_VARIANT(value) ((CATB_VERSION_VARIANT_Msk & ((value) << CATB_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR CHIPID */
/* ============================================================================= */
/** \addtogroup SAM4L4_CHIPID Chip ID Registers */
/*@{*/

#define REV_CHIPID     0x100

#ifndef __ASSEMBLY__
/** \brief CHIPID hardware registers */
typedef struct {
  RoReg   Reserved1[208];
  RoReg   CIDR;        /**< \brief (CHIPID Offset: 0x340) Chip ID Register */
  RoReg   EXID;        /**< \brief (CHIPID Offset: 0x344) Chip ID Extension Register */
} Chipid;
#endif /* __ASSEMBLY__ */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR CRCCU */
/* ============================================================================= */
/** \addtogroup SAM4L4_CRCCU CRC Calculation Unit */
/*@{*/

#define REV_CRCCU      0x202

#ifndef __ASSEMBLY__
/** \brief CRCCU hardware registers */
typedef struct {
  RwReg   DSCR;        /**< \brief (CRCCU Offset: 0x00) Descriptor Base Register */
  RoReg   Reserved1[1];
  WoReg   DMAEN;       /**< \brief (CRCCU Offset: 0x08) DMA Enable Register */
  WoReg   DMADIS;      /**< \brief (CRCCU Offset: 0x0C) DMA Disable Register */
  RoReg   DMASR;       /**< \brief (CRCCU Offset: 0x10) DMA Status Register */
  WoReg   DMAIER;      /**< \brief (CRCCU Offset: 0x14) DMA Interrupt Enable Register */
  WoReg   DMAIDR;      /**< \brief (CRCCU Offset: 0x18) DMA Interrupt Disable Register */
  RoReg   DMAIMR;      /**< \brief (CRCCU Offset: 0x1C) DMA Interrupt Mask Register */
  RoReg   DMAISR;      /**< \brief (CRCCU Offset: 0x20) DMA Interrupt Status Register */
  RoReg   Reserved2[4];
  WoReg   CR;          /**< \brief (CRCCU Offset: 0x34) Control Register */
  RwReg   MR;          /**< \brief (CRCCU Offset: 0x38) Mode Register */
  RoReg   SR;          /**< \brief (CRCCU Offset: 0x3C) Status Register */
  WoReg   IER;         /**< \brief (CRCCU Offset: 0x40) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (CRCCU Offset: 0x44) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (CRCCU Offset: 0x48) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (CRCCU Offset: 0x4C) Interrupt Status Register */
  RoReg   Reserved3[43];
  RoReg   VERSION;     /**< \brief (CRCCU Offset: 0xFC) Version Register */
} Crccu;
#endif /* __ASSEMBLY__ */
/* -------- CRCCU_DSCR : (CRCCU Offset: 0x00) Descriptor Base Register -------- */
#define CRCCU_DSCR_DSCR_Pos         9
#define CRCCU_DSCR_DSCR_Msk         (0x7FFFFFu << CRCCU_DSCR_DSCR_Pos) /**< \brief (CRCCU_DSCR) Description Base Address */
#define CRCCU_DSCR_DSCR(value)      ((CRCCU_DSCR_DSCR_Msk & ((value) << CRCCU_DSCR_DSCR_Pos)))
/* -------- CRCCU_DMAEN : (CRCCU Offset: 0x08) DMA Enable Register -------- */
#define CRCCU_DMAEN_DMAEN           (0x1u <<  0) /**< \brief (CRCCU_DMAEN) DMA Enable */
/* -------- CRCCU_DMADIS : (CRCCU Offset: 0x0C) DMA Disable Register -------- */
#define CRCCU_DMADIS_DMADIS         (0x1u <<  0) /**< \brief (CRCCU_DMADIS) DMA Disable */
/* -------- CRCCU_DMASR : (CRCCU Offset: 0x10) DMA Status Register -------- */
#define CRCCU_DMASR_DMASR           (0x1u <<  0) /**< \brief (CRCCU_DMASR) DMA Channel Status */
/* -------- CRCCU_DMAIER : (CRCCU Offset: 0x14) DMA Interrupt Enable Register -------- */
#define CRCCU_DMAIER_DMAIER         (0x1u <<  0) /**< \brief (CRCCU_DMAIER) DMA Interrupt Enable */
/* -------- CRCCU_DMAIDR : (CRCCU Offset: 0x18) DMA Interrupt Disable Register -------- */
#define CRCCU_DMAIDR_DMAIDR         (0x1u <<  0) /**< \brief (CRCCU_DMAIDR) DMA Interrupt Disable */
/* -------- CRCCU_DMAIMR : (CRCCU Offset: 0x1C) DMA Interrupt Mask Register -------- */
#define CRCCU_DMAIMR_DMAIMR         (0x1u <<  0) /**< \brief (CRCCU_DMAIMR) DMA Interrupt Mask */
/* -------- CRCCU_DMAISR : (CRCCU Offset: 0x20) DMA Interrupt Status Register -------- */
#define CRCCU_DMAISR_DMAISR         (0x1u <<  0) /**< \brief (CRCCU_DMAISR) DMA Interrupt Status */
/* -------- CRCCU_CR : (CRCCU Offset: 0x34) Control Register -------- */
#define CRCCU_CR_RESET              (0x1u <<  0) /**< \brief (CRCCU_CR) Reset CRCComputation */
/* -------- CRCCU_MR : (CRCCU Offset: 0x38) Mode Register -------- */
#define CRCCU_MR_ENABLE             (0x1u <<  0) /**< \brief (CRCCU_MR) CRC Computation Enable */
#define CRCCU_MR_COMPARE            (0x1u <<  1) /**< \brief (CRCCU_MR) CRC Compare */
#define CRCCU_MR_PTYPE_Pos          2
#define CRCCU_MR_PTYPE_Msk          (0x3u << CRCCU_MR_PTYPE_Pos) /**< \brief (CRCCU_MR) Polynomial Type */
#define CRCCU_MR_PTYPE(value)       ((CRCCU_MR_PTYPE_Msk & ((value) << CRCCU_MR_PTYPE_Pos)))
#define CRCCU_MR_DIVIDER_Pos        4
#define CRCCU_MR_DIVIDER_Msk        (0xFu << CRCCU_MR_DIVIDER_Pos) /**< \brief (CRCCU_MR) Bandwidth Divider */
#define CRCCU_MR_DIVIDER(value)     ((CRCCU_MR_DIVIDER_Msk & ((value) << CRCCU_MR_DIVIDER_Pos)))
/* -------- CRCCU_SR : (CRCCU Offset: 0x3C) Status Register -------- */
#define CRCCU_SR_CRC_Pos            0
#define CRCCU_SR_CRC_Msk            (0xFFFFFFFFu << CRCCU_SR_CRC_Pos) /**< \brief (CRCCU_SR) Cyclic Redundancy Check Value */
#define CRCCU_SR_CRC(value)         ((CRCCU_SR_CRC_Msk & ((value) << CRCCU_SR_CRC_Pos)))
/* -------- CRCCU_IER : (CRCCU Offset: 0x40) Interrupt Enable Register -------- */
#define CRCCU_IER_ERRIER            (0x1u <<  0) /**< \brief (CRCCU_IER) CRC Error Interrupt Enable */
/* -------- CRCCU_IDR : (CRCCU Offset: 0x44) Interrupt Disable Register -------- */
#define CRCCU_IDR_ERRIDR            (0x1u <<  0) /**< \brief (CRCCU_IDR) CRC Error Interrupt Disable */
/* -------- CRCCU_IMR : (CRCCU Offset: 0x48) Interrupt Mask Register -------- */
#define CRCCU_IMR_ERRIMR            (0x1u <<  0) /**< \brief (CRCCU_IMR) CRC Error Interrupt Mask */
/* -------- CRCCU_ISR : (CRCCU Offset: 0x4C) Interrupt Status Register -------- */
#define CRCCU_ISR_ERRISR            (0x1u <<  0) /**< \brief (CRCCU_ISR) CRC Error Interrupt Status */
/* -------- CRCCU_VERSION : (CRCCU Offset: 0xFC) Version Register -------- */
#define CRCCU_VERSION_VERSION_Pos    0
#define CRCCU_VERSION_VERSION_Msk    (0xFFFu << CRCCU_VERSION_VERSION_Pos) /**< \brief (CRCCU_VERSION) Version Number */
#define CRCCU_VERSION_VERSION(value) ((CRCCU_VERSION_VERSION_Msk & ((value) << CRCCU_VERSION_VERSION_Pos)))
#define CRCCU_VERSION_VARIANT_Pos    16
#define CRCCU_VERSION_VARIANT_Msk    (0xFu << CRCCU_VERSION_VARIANT_Pos) /**< \brief (CRCCU_VERSION) Variant Number */
#define CRCCU_VERSION_VARIANT(value) ((CRCCU_VERSION_VARIANT_Msk & ((value) << CRCCU_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR DACC */
/* ============================================================================= */
/** \addtogroup SAM4L4_DACC DAC Controller */
/*@{*/

#define REV_DACC       0x111

#ifndef __ASSEMBLY__
/** \brief DACC hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (DACC Offset: 0x00) Control Register */
  RwReg   MR;          /**< \brief (DACC Offset: 0x04) Mode Register */
  WoReg   CDR;         /**< \brief (DACC Offset: 0x08) Conversion Data Register */
  WoReg   IER;         /**< \brief (DACC Offset: 0x0C) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (DACC Offset: 0x10) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (DACC Offset: 0x14) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (DACC Offset: 0x18) Interrupt Status Register */
  RoReg   Reserved1[50];
  RwReg   WPMR;        /**< \brief (DACC Offset: 0xE4) Write Protect Mode Register */
  RoReg   WPSR;        /**< \brief (DACC Offset: 0xE8) Write Protect Status Register */
  RoReg   Reserved2[4];
  RoReg   VERSION;     /**< \brief (DACC Offset: 0xFC) Version Register */
} Dacc;
#endif /* __ASSEMBLY__ */
/* -------- DACC_CR : (DACC Offset: 0x00) Control Register -------- */
#define DACC_CR_SWRST               (0x1u <<  0) /**< \brief (DACC_CR) Software Reset */
/* -------- DACC_MR : (DACC Offset: 0x04) Mode Register -------- */
#define DACC_MR_TRGEN               (0x1u <<  0) /**< \brief (DACC_MR) Trigger Enable */
#define DACC_MR_TRGSEL_Pos          1
#define DACC_MR_TRGSEL_Msk          (0x7u << DACC_MR_TRGSEL_Pos) /**< \brief (DACC_MR) Trigger Selection */
#define DACC_MR_TRGSEL(value)       ((DACC_MR_TRGSEL_Msk & ((value) << DACC_MR_TRGSEL_Pos)))
#define DACC_MR_DACEN               (0x1u <<  4) /**< \brief (DACC_MR) DAC Enable */
#define DACC_MR_WORD                (0x1u <<  5) /**< \brief (DACC_MR) Word Transfer */
#define DACC_MR_STARTUP_Pos         8
#define DACC_MR_STARTUP_Msk         (0xFFu << DACC_MR_STARTUP_Pos) /**< \brief (DACC_MR) Startup Time Selection */
#define DACC_MR_STARTUP(value)      ((DACC_MR_STARTUP_Msk & ((value) << DACC_MR_STARTUP_Pos)))
#define DACC_MR_CLKDIV_Pos          16
#define DACC_MR_CLKDIV_Msk          (0xFFFFu << DACC_MR_CLKDIV_Pos) /**< \brief (DACC_MR) Clock Divider for Internal Trigger */
#define DACC_MR_CLKDIV(value)       ((DACC_MR_CLKDIV_Msk & ((value) << DACC_MR_CLKDIV_Pos)))
/* -------- DACC_CDR : (DACC Offset: 0x08) Conversion Data Register -------- */
#define DACC_CDR_DATA_Pos           0
#define DACC_CDR_DATA_Msk           (0xFFFFFFFFu << DACC_CDR_DATA_Pos) /**< \brief (DACC_CDR) Data to Convert */
#define DACC_CDR_DATA(value)        ((DACC_CDR_DATA_Msk & ((value) << DACC_CDR_DATA_Pos)))
/* -------- DACC_IER : (DACC Offset: 0x0C) Interrupt Enable Register -------- */
#define DACC_IER_TXRDY              (0x1u <<  0) /**< \brief (DACC_IER) Transmit Ready Interrupt Enable */
/* -------- DACC_IDR : (DACC Offset: 0x10) Interrupt Disable Register -------- */
#define DACC_IDR_TXRDY              (0x1u <<  0) /**< \brief (DACC_IDR) Transmit Ready Interrupt Disable */
/* -------- DACC_IMR : (DACC Offset: 0x14) Interrupt Mask Register -------- */
#define DACC_IMR_TXRDY              (0x1u <<  0) /**< \brief (DACC_IMR) Transmit Ready Interrupt Mask */
/* -------- DACC_ISR : (DACC Offset: 0x18) Interrupt Status Register -------- */
#define DACC_ISR_TXRDY              (0x1u <<  0) /**< \brief (DACC_ISR) Transmit Ready Interrupt Status */
/* -------- DACC_WPMR : (DACC Offset: 0xE4) Write Protect Mode Register -------- */
#define DACC_WPMR_WPEN              (0x1u <<  0) /**< \brief (DACC_WPMR) Write Protect Enable */
#define DACC_WPMR_WPKEY_Pos         8
#define DACC_WPMR_WPKEY_Msk         (0xFFFFFFu << DACC_WPMR_WPKEY_Pos) /**< \brief (DACC_WPMR) Write Protect Key */
#define DACC_WPMR_WPKEY(value)      ((DACC_WPMR_WPKEY_Msk & ((value) << DACC_WPMR_WPKEY_Pos)))
/* -------- DACC_WPSR : (DACC Offset: 0xE8) Write Protect Status Register -------- */
#define DACC_WPSR_WPROTERR          (0x1u <<  0) /**< \brief (DACC_WPSR) Write Protection Error */
#define DACC_WPSR_WPROTADDR_Pos     8
#define DACC_WPSR_WPROTADDR_Msk     (0xFFu << DACC_WPSR_WPROTADDR_Pos) /**< \brief (DACC_WPSR) Write Protection Error Address */
#define DACC_WPSR_WPROTADDR(value)  ((DACC_WPSR_WPROTADDR_Msk & ((value) << DACC_WPSR_WPROTADDR_Pos)))
/* -------- DACC_VERSION : (DACC Offset: 0xFC) Version Register -------- */
#define DACC_VERSION_VERSION_Pos    0
#define DACC_VERSION_VERSION_Msk    (0xFFFu << DACC_VERSION_VERSION_Pos) /**< \brief (DACC_VERSION) Version Number */
#define DACC_VERSION_VERSION(value) ((DACC_VERSION_VERSION_Msk & ((value) << DACC_VERSION_VERSION_Pos)))
#define DACC_VERSION_VARIANT_Pos    16
#define DACC_VERSION_VARIANT_Msk    (0x7u << DACC_VERSION_VARIANT_Pos) /**< \brief (DACC_VERSION) Variant Number */
#define DACC_VERSION_VARIANT(value) ((DACC_VERSION_VARIANT_Msk & ((value) << DACC_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR EIC */
/* ============================================================================= */
/** \addtogroup SAM4L4_EIC External Interrupt Controller */
/*@{*/

#define REV_EIC        0x302

#ifndef __ASSEMBLY__
/** \brief EIC hardware registers */
typedef struct {
  WoReg   IER;         /**< \brief (EIC Offset: 0x000) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (EIC Offset: 0x004) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (EIC Offset: 0x008) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (EIC Offset: 0x00C) Interrupt Status Register */
  WoReg   ICR;         /**< \brief (EIC Offset: 0x010) Interrupt Clear Register */
  RwReg   MODE;        /**< \brief (EIC Offset: 0x014) Mode Register */
  RwReg   EDGE;        /**< \brief (EIC Offset: 0x018) Edge Register */
  RwReg   LEVEL;       /**< \brief (EIC Offset: 0x01C) Level Register */
  RwReg   FILTER;      /**< \brief (EIC Offset: 0x020) Filter Register */
  RoReg   Reserved1[1];
  RwReg   ASYNC;       /**< \brief (EIC Offset: 0x028) Asynchronous Register */
  RoReg   Reserved2[1];
  WoReg   EN;          /**< \brief (EIC Offset: 0x030) Enable Register */
  WoReg   DIS;         /**< \brief (EIC Offset: 0x034) Disable Register */
  RoReg   CTRL;        /**< \brief (EIC Offset: 0x038) Control Register */
  RoReg   Reserved3[240];
  RoReg   VERSION;     /**< \brief (EIC Offset: 0x3FC) Version Register */
} Eic;
#endif /* __ASSEMBLY__ */
/* -------- EIC_IER : (EIC Offset: 0x000) Interrupt Enable Register -------- */
#define EIC_IER_NMI                 (0x1u <<  0) /**< \brief (EIC_IER) External Non Maskable CPU interrupt */
#define EIC_IER_INT1                (0x1u <<  1) /**< \brief (EIC_IER) External Interrupt 1 */
#define   EIC_IER_INT1_0            (0x0u <<  1) /**< \brief (EIC_IER) No effect */
#define   EIC_IER_INT1_1            (0x1u <<  1) /**< \brief (EIC_IER) Enable Interrupt. */
#define EIC_IER_INT2                (0x1u <<  2) /**< \brief (EIC_IER) External Interrupt 2 */
#define   EIC_IER_INT2_0            (0x0u <<  2) /**< \brief (EIC_IER) No effect */
#define   EIC_IER_INT2_1            (0x1u <<  2) /**< \brief (EIC_IER) Enable Interrupt. */
#define EIC_IER_INT3                (0x1u <<  3) /**< \brief (EIC_IER) External Interrupt 3 */
#define   EIC_IER_INT3_0            (0x0u <<  3) /**< \brief (EIC_IER) No effect */
#define   EIC_IER_INT3_1            (0x1u <<  3) /**< \brief (EIC_IER) Enable Interrupt. */
#define EIC_IER_INT4                (0x1u <<  4) /**< \brief (EIC_IER) External Interrupt 4 */
#define   EIC_IER_INT4_0            (0x0u <<  4) /**< \brief (EIC_IER) No effect */
#define   EIC_IER_INT4_1            (0x1u <<  4) /**< \brief (EIC_IER) Enable Interrupt. */
#define EIC_IER_INT5                (0x1u <<  5) /**< \brief (EIC_IER) External Interrupt 5 */
#define EIC_IER_INT6                (0x1u <<  6) /**< \brief (EIC_IER) External Interrupt 6 */
#define EIC_IER_INT7                (0x1u <<  7) /**< \brief (EIC_IER) External Interrupt 7 */
#define EIC_IER_INT8                (0x1u <<  8) /**< \brief (EIC_IER) External Interrupt 8 */
#define EIC_IER_INT9                (0x1u <<  9) /**< \brief (EIC_IER) External Interrupt 9 */
#define EIC_IER_INT10               (0x1u << 10) /**< \brief (EIC_IER) External Interrupt 10 */
#define EIC_IER_INT11               (0x1u << 11) /**< \brief (EIC_IER) External Interrupt 11 */
#define EIC_IER_INT12               (0x1u << 12) /**< \brief (EIC_IER) External Interrupt 12 */
#define EIC_IER_INT13               (0x1u << 13) /**< \brief (EIC_IER) External Interrupt 13 */
#define EIC_IER_INT14               (0x1u << 14) /**< \brief (EIC_IER) External Interrupt 14 */
#define EIC_IER_INT15               (0x1u << 15) /**< \brief (EIC_IER) External Interrupt 15 */
/* -------- EIC_IDR : (EIC Offset: 0x004) Interrupt Disable Register -------- */
#define EIC_IDR_NMI                 (0x1u <<  0) /**< \brief (EIC_IDR) External Non Maskable CPU interrupt */
#define EIC_IDR_INT1                (0x1u <<  1) /**< \brief (EIC_IDR) External Interrupt 1 */
#define   EIC_IDR_INT1_0            (0x0u <<  1) /**< \brief (EIC_IDR) No effect */
#define   EIC_IDR_INT1_1            (0x1u <<  1) /**< \brief (EIC_IDR) Disable Interrupt. */
#define EIC_IDR_INT2                (0x1u <<  2) /**< \brief (EIC_IDR) External Interrupt 2 */
#define   EIC_IDR_INT2_0            (0x0u <<  2) /**< \brief (EIC_IDR) No effect */
#define   EIC_IDR_INT2_1            (0x1u <<  2) /**< \brief (EIC_IDR) Disable Interrupt. */
#define EIC_IDR_INT3                (0x1u <<  3) /**< \brief (EIC_IDR) External Interrupt 3 */
#define   EIC_IDR_INT3_0            (0x0u <<  3) /**< \brief (EIC_IDR) No effect */
#define   EIC_IDR_INT3_1            (0x1u <<  3) /**< \brief (EIC_IDR) Disable Interrupt. */
#define EIC_IDR_INT4                (0x1u <<  4) /**< \brief (EIC_IDR) External Interrupt 4 */
#define   EIC_IDR_INT4_0            (0x0u <<  4) /**< \brief (EIC_IDR) No effect */
#define   EIC_IDR_INT4_1            (0x1u <<  4) /**< \brief (EIC_IDR) Disable Interrupt. */
#define EIC_IDR_INT5                (0x1u <<  5) /**< \brief (EIC_IDR) External Interrupt 5 */
#define EIC_IDR_INT6                (0x1u <<  6) /**< \brief (EIC_IDR) External Interrupt 6 */
#define EIC_IDR_INT7                (0x1u <<  7) /**< \brief (EIC_IDR) External Interrupt 7 */
#define EIC_IDR_INT8                (0x1u <<  8) /**< \brief (EIC_IDR) External Interrupt 8 */
#define EIC_IDR_INT9                (0x1u <<  9) /**< \brief (EIC_IDR) External Interrupt 9 */
#define EIC_IDR_INT10               (0x1u << 10) /**< \brief (EIC_IDR) External Interrupt 10 */
#define EIC_IDR_INT11               (0x1u << 11) /**< \brief (EIC_IDR) External Interrupt 11 */
#define EIC_IDR_INT12               (0x1u << 12) /**< \brief (EIC_IDR) External Interrupt 12 */
#define EIC_IDR_INT13               (0x1u << 13) /**< \brief (EIC_IDR) External Interrupt 13 */
#define EIC_IDR_INT14               (0x1u << 14) /**< \brief (EIC_IDR) External Interrupt 14 */
#define EIC_IDR_INT15               (0x1u << 15) /**< \brief (EIC_IDR) External Interrupt 15 */
/* -------- EIC_IMR : (EIC Offset: 0x008) Interrupt Mask Register -------- */
#define EIC_IMR_NMI                 (0x1u <<  0) /**< \brief (EIC_IMR) External Non Maskable CPU interrupt */
#define EIC_IMR_INT1                (0x1u <<  1) /**< \brief (EIC_IMR) External Interrupt 1 */
#define   EIC_IMR_INT1_0            (0x0u <<  1) /**< \brief (EIC_IMR) Interrupt is disabled */
#define   EIC_IMR_INT1_1            (0x1u <<  1) /**< \brief (EIC_IMR) Interrupt is enabled. */
#define EIC_IMR_INT2                (0x1u <<  2) /**< \brief (EIC_IMR) External Interrupt 2 */
#define   EIC_IMR_INT2_0            (0x0u <<  2) /**< \brief (EIC_IMR) Interrupt is disabled */
#define   EIC_IMR_INT2_1            (0x1u <<  2) /**< \brief (EIC_IMR) Interrupt is enabled. */
#define EIC_IMR_INT3                (0x1u <<  3) /**< \brief (EIC_IMR) External Interrupt 3 */
#define   EIC_IMR_INT3_0            (0x0u <<  3) /**< \brief (EIC_IMR) Interrupt is disabled */
#define   EIC_IMR_INT3_1            (0x1u <<  3) /**< \brief (EIC_IMR) Interrupt is enabled. */
#define EIC_IMR_INT4                (0x1u <<  4) /**< \brief (EIC_IMR) External Interrupt 4 */
#define   EIC_IMR_INT4_0            (0x0u <<  4) /**< \brief (EIC_IMR) Interrupt is disabled */
#define   EIC_IMR_INT4_1            (0x1u <<  4) /**< \brief (EIC_IMR) Interrupt is enabled. */
#define EIC_IMR_INT5                (0x1u <<  5) /**< \brief (EIC_IMR) External Interrupt 5 */
#define EIC_IMR_INT6                (0x1u <<  6) /**< \brief (EIC_IMR) External Interrupt 6 */
#define EIC_IMR_INT7                (0x1u <<  7) /**< \brief (EIC_IMR) External Interrupt 7 */
#define EIC_IMR_INT8                (0x1u <<  8) /**< \brief (EIC_IMR) External Interrupt 8 */
#define EIC_IMR_INT9                (0x1u <<  9) /**< \brief (EIC_IMR) External Interrupt 9 */
#define EIC_IMR_INT10               (0x1u << 10) /**< \brief (EIC_IMR) External Interrupt 10 */
#define EIC_IMR_INT11               (0x1u << 11) /**< \brief (EIC_IMR) External Interrupt 11 */
#define EIC_IMR_INT12               (0x1u << 12) /**< \brief (EIC_IMR) External Interrupt 12 */
#define EIC_IMR_INT13               (0x1u << 13) /**< \brief (EIC_IMR) External Interrupt 13 */
#define EIC_IMR_INT14               (0x1u << 14) /**< \brief (EIC_IMR) External Interrupt 14 */
#define EIC_IMR_INT15               (0x1u << 15) /**< \brief (EIC_IMR) External Interrupt 15 */
/* -------- EIC_ISR : (EIC Offset: 0x00C) Interrupt Status Register -------- */
#define EIC_ISR_NMI                 (0x1u <<  0) /**< \brief (EIC_ISR) External Non Maskable CPU interrupt */
#define EIC_ISR_INT1                (0x1u <<  1) /**< \brief (EIC_ISR) External Interrupt 1 */
#define   EIC_ISR_INT1_0            (0x0u <<  1) /**< \brief (EIC_ISR) An interrupt event has not occurred */
#define   EIC_ISR_INT1_1            (0x1u <<  1) /**< \brief (EIC_ISR) An interrupt event has occurred. */
#define EIC_ISR_INT2                (0x1u <<  2) /**< \brief (EIC_ISR) External Interrupt 2 */
#define   EIC_ISR_INT2_0            (0x0u <<  2) /**< \brief (EIC_ISR) An interrupt event has not occurred */
#define   EIC_ISR_INT2_1            (0x1u <<  2) /**< \brief (EIC_ISR) An interrupt event has occurred. */
#define EIC_ISR_INT3                (0x1u <<  3) /**< \brief (EIC_ISR) External Interrupt 3 */
#define   EIC_ISR_INT3_0            (0x0u <<  3) /**< \brief (EIC_ISR) An interrupt event has not occurred */
#define   EIC_ISR_INT3_1            (0x1u <<  3) /**< \brief (EIC_ISR) An interrupt event has occurred. */
#define EIC_ISR_INT4                (0x1u <<  4) /**< \brief (EIC_ISR) External Interrupt 4 */
#define   EIC_ISR_INT4_0            (0x0u <<  4) /**< \brief (EIC_ISR) An interrupt event has not occurred */
#define   EIC_ISR_INT4_1            (0x1u <<  4) /**< \brief (EIC_ISR) An interrupt event has occurred. */
#define EIC_ISR_INT5                (0x1u <<  5) /**< \brief (EIC_ISR) External Interrupt 5 */
#define EIC_ISR_INT6                (0x1u <<  6) /**< \brief (EIC_ISR) External Interrupt 6 */
#define EIC_ISR_INT7                (0x1u <<  7) /**< \brief (EIC_ISR) External Interrupt 7 */
#define EIC_ISR_INT8                (0x1u <<  8) /**< \brief (EIC_ISR) External Interrupt 8 */
#define EIC_ISR_INT9                (0x1u <<  9) /**< \brief (EIC_ISR) External Interrupt 9 */
#define EIC_ISR_INT10               (0x1u << 10) /**< \brief (EIC_ISR) External Interrupt 10 */
#define EIC_ISR_INT11               (0x1u << 11) /**< \brief (EIC_ISR) External Interrupt 11 */
#define EIC_ISR_INT12               (0x1u << 12) /**< \brief (EIC_ISR) External Interrupt 12 */
#define EIC_ISR_INT13               (0x1u << 13) /**< \brief (EIC_ISR) External Interrupt 13 */
#define EIC_ISR_INT14               (0x1u << 14) /**< \brief (EIC_ISR) External Interrupt 14 */
#define EIC_ISR_INT15               (0x1u << 15) /**< \brief (EIC_ISR) External Interrupt 15 */
/* -------- EIC_ICR : (EIC Offset: 0x010) Interrupt Clear Register -------- */
#define EIC_ICR_NMI                 (0x1u <<  0) /**< \brief (EIC_ICR) External Non Maskable CPU interrupt */
#define EIC_ICR_INT1                (0x1u <<  1) /**< \brief (EIC_ICR) External Interrupt 1 */
#define   EIC_ICR_INT1_0            (0x0u <<  1) /**< \brief (EIC_ICR) No effect */
#define   EIC_ICR_INT1_1            (0x1u <<  1) /**< \brief (EIC_ICR) Clear Interrupt. */
#define EIC_ICR_INT2                (0x1u <<  2) /**< \brief (EIC_ICR) External Interrupt 2 */
#define   EIC_ICR_INT2_0            (0x0u <<  2) /**< \brief (EIC_ICR) No effect */
#define   EIC_ICR_INT2_1            (0x1u <<  2) /**< \brief (EIC_ICR) Clear Interrupt. */
#define EIC_ICR_INT3                (0x1u <<  3) /**< \brief (EIC_ICR) External Interrupt 3 */
#define   EIC_ICR_INT3_0            (0x0u <<  3) /**< \brief (EIC_ICR) No effect */
#define   EIC_ICR_INT3_1            (0x1u <<  3) /**< \brief (EIC_ICR) Clear Interrupt. */
#define EIC_ICR_INT4                (0x1u <<  4) /**< \brief (EIC_ICR) External Interrupt 4 */
#define   EIC_ICR_INT4_0            (0x0u <<  4) /**< \brief (EIC_ICR) No effect */
#define   EIC_ICR_INT4_1            (0x1u <<  4) /**< \brief (EIC_ICR) Clear Interrupt. */
#define EIC_ICR_INT5                (0x1u <<  5) /**< \brief (EIC_ICR) External Interrupt 5 */
#define EIC_ICR_INT6                (0x1u <<  6) /**< \brief (EIC_ICR) External Interrupt 6 */
#define EIC_ICR_INT7                (0x1u <<  7) /**< \brief (EIC_ICR) External Interrupt 7 */
#define EIC_ICR_INT8                (0x1u <<  8) /**< \brief (EIC_ICR) External Interrupt 8 */
#define EIC_ICR_INT9                (0x1u <<  9) /**< \brief (EIC_ICR) External Interrupt 9 */
#define EIC_ICR_INT10               (0x1u << 10) /**< \brief (EIC_ICR) External Interrupt 10 */
#define EIC_ICR_INT11               (0x1u << 11) /**< \brief (EIC_ICR) External Interrupt 11 */
#define EIC_ICR_INT12               (0x1u << 12) /**< \brief (EIC_ICR) External Interrupt 12 */
#define EIC_ICR_INT13               (0x1u << 13) /**< \brief (EIC_ICR) External Interrupt 13 */
#define EIC_ICR_INT14               (0x1u << 14) /**< \brief (EIC_ICR) External Interrupt 14 */
#define EIC_ICR_INT15               (0x1u << 15) /**< \brief (EIC_ICR) External Interrupt 15 */
/* -------- EIC_MODE : (EIC Offset: 0x014) Mode Register -------- */
#define EIC_MODE_NMI                (0x1u <<  0) /**< \brief (EIC_MODE) External Non Maskable CPU interrupt */
#define EIC_MODE_INT1               (0x1u <<  1) /**< \brief (EIC_MODE) External Interrupt 1 */
#define   EIC_MODE_INT1_0           (0x0u <<  1) /**< \brief (EIC_MODE) Edge triggered interrupt */
#define   EIC_MODE_INT1_1           (0x1u <<  1) /**< \brief (EIC_MODE) Level triggered interrupt */
#define EIC_MODE_INT2               (0x1u <<  2) /**< \brief (EIC_MODE) External Interrupt 2 */
#define   EIC_MODE_INT2_0           (0x0u <<  2) /**< \brief (EIC_MODE) Edge triggered interrupt */
#define   EIC_MODE_INT2_1           (0x1u <<  2) /**< \brief (EIC_MODE) Level triggered interrupt */
#define EIC_MODE_INT3               (0x1u <<  3) /**< \brief (EIC_MODE) External Interrupt 3 */
#define   EIC_MODE_INT3_0           (0x0u <<  3) /**< \brief (EIC_MODE) Edge triggered interrupt */
#define   EIC_MODE_INT3_1           (0x1u <<  3) /**< \brief (EIC_MODE) Level triggered interrupt */
#define EIC_MODE_INT4               (0x1u <<  4) /**< \brief (EIC_MODE) External Interrupt 4 */
#define   EIC_MODE_INT4_0           (0x0u <<  4) /**< \brief (EIC_MODE) Edge triggered interrupt */
#define   EIC_MODE_INT4_1           (0x1u <<  4) /**< \brief (EIC_MODE) Level triggered interrupt */
#define EIC_MODE_INT5               (0x1u <<  5) /**< \brief (EIC_MODE) External Interrupt 5 */
#define EIC_MODE_INT6               (0x1u <<  6) /**< \brief (EIC_MODE) External Interrupt 6 */
#define EIC_MODE_INT7               (0x1u <<  7) /**< \brief (EIC_MODE) External Interrupt 7 */
#define EIC_MODE_INT8               (0x1u <<  8) /**< \brief (EIC_MODE) External Interrupt 8 */
#define EIC_MODE_INT9               (0x1u <<  9) /**< \brief (EIC_MODE) External Interrupt 9 */
#define EIC_MODE_INT10              (0x1u << 10) /**< \brief (EIC_MODE) External Interrupt 10 */
#define EIC_MODE_INT11              (0x1u << 11) /**< \brief (EIC_MODE) External Interrupt 11 */
#define EIC_MODE_INT12              (0x1u << 12) /**< \brief (EIC_MODE) External Interrupt 12 */
#define EIC_MODE_INT13              (0x1u << 13) /**< \brief (EIC_MODE) External Interrupt 13 */
#define EIC_MODE_INT14              (0x1u << 14) /**< \brief (EIC_MODE) External Interrupt 14 */
#define EIC_MODE_INT15              (0x1u << 15) /**< \brief (EIC_MODE) External Interrupt 15 */
/* -------- EIC_EDGE : (EIC Offset: 0x018) Edge Register -------- */
#define EIC_EDGE_NMI                (0x1u <<  0) /**< \brief (EIC_EDGE) External Non Maskable CPU interrupt */
#define EIC_EDGE_INT1               (0x1u <<  1) /**< \brief (EIC_EDGE) External Interrupt 1 */
#define   EIC_EDGE_INT1_0           (0x0u <<  1) /**< \brief (EIC_EDGE) Triggers on falling edge */
#define   EIC_EDGE_INT1_1           (0x1u <<  1) /**< \brief (EIC_EDGE) Triggers on rising edge. */
#define EIC_EDGE_INT2               (0x1u <<  2) /**< \brief (EIC_EDGE) External Interrupt 2 */
#define   EIC_EDGE_INT2_0           (0x0u <<  2) /**< \brief (EIC_EDGE) Triggers on falling edge */
#define   EIC_EDGE_INT2_1           (0x1u <<  2) /**< \brief (EIC_EDGE) Triggers on rising edge. */
#define EIC_EDGE_INT3               (0x1u <<  3) /**< \brief (EIC_EDGE) External Interrupt 3 */
#define   EIC_EDGE_INT3_0           (0x0u <<  3) /**< \brief (EIC_EDGE) Triggers on falling edge */
#define   EIC_EDGE_INT3_1           (0x1u <<  3) /**< \brief (EIC_EDGE) Triggers on rising edge. */
#define EIC_EDGE_INT4               (0x1u <<  4) /**< \brief (EIC_EDGE) External Interrupt 4 */
#define   EIC_EDGE_INT4_0           (0x0u <<  4) /**< \brief (EIC_EDGE) Triggers on falling edge */
#define   EIC_EDGE_INT4_1           (0x1u <<  4) /**< \brief (EIC_EDGE) Triggers on rising edge. */
#define EIC_EDGE_INT5               (0x1u <<  5) /**< \brief (EIC_EDGE) External Interrupt 5 */
#define EIC_EDGE_INT6               (0x1u <<  6) /**< \brief (EIC_EDGE) External Interrupt 6 */
#define EIC_EDGE_INT7               (0x1u <<  7) /**< \brief (EIC_EDGE) External Interrupt 7 */
#define EIC_EDGE_INT8               (0x1u <<  8) /**< \brief (EIC_EDGE) External Interrupt 8 */
#define EIC_EDGE_INT9               (0x1u <<  9) /**< \brief (EIC_EDGE) External Interrupt 9 */
#define EIC_EDGE_INT10              (0x1u << 10) /**< \brief (EIC_EDGE) External Interrupt 10 */
#define EIC_EDGE_INT11              (0x1u << 11) /**< \brief (EIC_EDGE) External Interrupt 11 */
#define EIC_EDGE_INT12              (0x1u << 12) /**< \brief (EIC_EDGE) External Interrupt 12 */
#define EIC_EDGE_INT13              (0x1u << 13) /**< \brief (EIC_EDGE) External Interrupt 13 */
#define EIC_EDGE_INT14              (0x1u << 14) /**< \brief (EIC_EDGE) External Interrupt 14 */
#define EIC_EDGE_INT15              (0x1u << 15) /**< \brief (EIC_EDGE) External Interrupt 15 */
/* -------- EIC_LEVEL : (EIC Offset: 0x01C) Level Register -------- */
#define EIC_LEVEL_NMI               (0x1u <<  0) /**< \brief (EIC_LEVEL) External Non Maskable CPU interrupt */
#define EIC_LEVEL_INT1              (0x1u <<  1) /**< \brief (EIC_LEVEL) External Interrupt 1 */
#define EIC_LEVEL_INT2              (0x1u <<  2) /**< \brief (EIC_LEVEL) External Interrupt 2 */
#define EIC_LEVEL_INT3              (0x1u <<  3) /**< \brief (EIC_LEVEL) External Interrupt 3 */
#define EIC_LEVEL_INT4              (0x1u <<  4) /**< \brief (EIC_LEVEL) External Interrupt 4 */
#define EIC_LEVEL_INT5              (0x1u <<  5) /**< \brief (EIC_LEVEL) External Interrupt 5 */
#define EIC_LEVEL_INT6              (0x1u <<  6) /**< \brief (EIC_LEVEL) External Interrupt 6 */
#define EIC_LEVEL_INT7              (0x1u <<  7) /**< \brief (EIC_LEVEL) External Interrupt 7 */
#define EIC_LEVEL_INT8              (0x1u <<  8) /**< \brief (EIC_LEVEL) External Interrupt 8 */
#define EIC_LEVEL_INT9              (0x1u <<  9) /**< \brief (EIC_LEVEL) External Interrupt 9 */
#define EIC_LEVEL_INT10             (0x1u << 10) /**< \brief (EIC_LEVEL) External Interrupt 10 */
#define EIC_LEVEL_INT11             (0x1u << 11) /**< \brief (EIC_LEVEL) External Interrupt 11 */
#define EIC_LEVEL_INT12             (0x1u << 12) /**< \brief (EIC_LEVEL) External Interrupt 12 */
#define EIC_LEVEL_INT13             (0x1u << 13) /**< \brief (EIC_LEVEL) External Interrupt 13 */
#define EIC_LEVEL_INT14             (0x1u << 14) /**< \brief (EIC_LEVEL) External Interrupt 14 */
#define EIC_LEVEL_INT15             (0x1u << 15) /**< \brief (EIC_LEVEL) External Interrupt 15 */
/* -------- EIC_FILTER : (EIC Offset: 0x020) Filter Register -------- */
#define EIC_FILTER_NMI              (0x1u <<  0) /**< \brief (EIC_FILTER) External Non Maskable CPU interrupt */
#define EIC_FILTER_INT1             (0x1u <<  1) /**< \brief (EIC_FILTER) External Interrupt 1 */
#define EIC_FILTER_INT2             (0x1u <<  2) /**< \brief (EIC_FILTER) External Interrupt 2 */
#define EIC_FILTER_INT3             (0x1u <<  3) /**< \brief (EIC_FILTER) External Interrupt 3 */
#define EIC_FILTER_INT4             (0x1u <<  4) /**< \brief (EIC_FILTER) External Interrupt 4 */
#define EIC_FILTER_INT5             (0x1u <<  5) /**< \brief (EIC_FILTER) External Interrupt 5 */
#define EIC_FILTER_INT6             (0x1u <<  6) /**< \brief (EIC_FILTER) External Interrupt 6 */
#define EIC_FILTER_INT7             (0x1u <<  7) /**< \brief (EIC_FILTER) External Interrupt 7 */
#define EIC_FILTER_INT8             (0x1u <<  8) /**< \brief (EIC_FILTER) External Interrupt 8 */
#define EIC_FILTER_INT9             (0x1u <<  9) /**< \brief (EIC_FILTER) External Interrupt 9 */
#define EIC_FILTER_INT10            (0x1u << 10) /**< \brief (EIC_FILTER) External Interrupt 10 */
#define EIC_FILTER_INT11            (0x1u << 11) /**< \brief (EIC_FILTER) External Interrupt 11 */
#define EIC_FILTER_INT12            (0x1u << 12) /**< \brief (EIC_FILTER) External Interrupt 12 */
#define EIC_FILTER_INT13            (0x1u << 13) /**< \brief (EIC_FILTER) External Interrupt 13 */
#define EIC_FILTER_INT14            (0x1u << 14) /**< \brief (EIC_FILTER) External Interrupt 14 */
#define EIC_FILTER_INT15            (0x1u << 15) /**< \brief (EIC_FILTER) External Interrupt 15 */
/* -------- EIC_ASYNC : (EIC Offset: 0x028) Asynchronous Register -------- */
#define EIC_ASYNC_NMI               (0x1u <<  0) /**< \brief (EIC_ASYNC) External Non Maskable CPU interrupt */
#define EIC_ASYNC_INT1              (0x1u <<  1) /**< \brief (EIC_ASYNC) External Interrupt 1 */
#define EIC_ASYNC_INT2              (0x1u <<  2) /**< \brief (EIC_ASYNC) External Interrupt 2 */
#define EIC_ASYNC_INT3              (0x1u <<  3) /**< \brief (EIC_ASYNC) External Interrupt 3 */
#define EIC_ASYNC_INT4              (0x1u <<  4) /**< \brief (EIC_ASYNC) External Interrupt 4 */
#define EIC_ASYNC_INT5              (0x1u <<  5) /**< \brief (EIC_ASYNC) External Interrupt 5 */
#define EIC_ASYNC_INT6              (0x1u <<  6) /**< \brief (EIC_ASYNC) External Interrupt 6 */
#define EIC_ASYNC_INT7              (0x1u <<  7) /**< \brief (EIC_ASYNC) External Interrupt 7 */
#define EIC_ASYNC_INT8              (0x1u <<  8) /**< \brief (EIC_ASYNC) External Interrupt 8 */
#define EIC_ASYNC_INT9              (0x1u <<  9) /**< \brief (EIC_ASYNC) External Interrupt 9 */
#define EIC_ASYNC_INT10             (0x1u << 10) /**< \brief (EIC_ASYNC) External Interrupt 10 */
#define EIC_ASYNC_INT11             (0x1u << 11) /**< \brief (EIC_ASYNC) External Interrupt 11 */
#define EIC_ASYNC_INT12             (0x1u << 12) /**< \brief (EIC_ASYNC) External Interrupt 12 */
#define EIC_ASYNC_INT13             (0x1u << 13) /**< \brief (EIC_ASYNC) External Interrupt 13 */
#define EIC_ASYNC_INT14             (0x1u << 14) /**< \brief (EIC_ASYNC) External Interrupt 14 */
#define EIC_ASYNC_INT15             (0x1u << 15) /**< \brief (EIC_ASYNC) External Interrupt 15 */
/* -------- EIC_EN : (EIC Offset: 0x030) Enable Register -------- */
#define EIC_EN_NMI                  (0x1u <<  0) /**< \brief (EIC_EN) External Non Maskable CPU interrupt */
#define EIC_EN_INT1                 (0x1u <<  1) /**< \brief (EIC_EN) External Interrupt 1 */
#define EIC_EN_INT2                 (0x1u <<  2) /**< \brief (EIC_EN) External Interrupt 2 */
#define EIC_EN_INT3                 (0x1u <<  3) /**< \brief (EIC_EN) External Interrupt 3 */
#define EIC_EN_INT4                 (0x1u <<  4) /**< \brief (EIC_EN) External Interrupt 4 */
#define EIC_EN_INT5                 (0x1u <<  5) /**< \brief (EIC_EN) External Interrupt 5 */
#define EIC_EN_INT6                 (0x1u <<  6) /**< \brief (EIC_EN) External Interrupt 6 */
#define EIC_EN_INT7                 (0x1u <<  7) /**< \brief (EIC_EN) External Interrupt 7 */
#define EIC_EN_INT8                 (0x1u <<  8) /**< \brief (EIC_EN) External Interrupt 8 */
#define EIC_EN_INT9                 (0x1u <<  9) /**< \brief (EIC_EN) External Interrupt 9 */
#define EIC_EN_INT10                (0x1u << 10) /**< \brief (EIC_EN) External Interrupt 10 */
#define EIC_EN_INT11                (0x1u << 11) /**< \brief (EIC_EN) External Interrupt 11 */
#define EIC_EN_INT12                (0x1u << 12) /**< \brief (EIC_EN) External Interrupt 12 */
#define EIC_EN_INT13                (0x1u << 13) /**< \brief (EIC_EN) External Interrupt 13 */
#define EIC_EN_INT14                (0x1u << 14) /**< \brief (EIC_EN) External Interrupt 14 */
#define EIC_EN_INT15                (0x1u << 15) /**< \brief (EIC_EN) External Interrupt 15 */
/* -------- EIC_DIS : (EIC Offset: 0x034) Disable Register -------- */
#define EIC_DIS_NMI                 (0x1u <<  0) /**< \brief (EIC_DIS) External Non Maskable CPU interrupt */
#define EIC_DIS_INT1                (0x1u <<  1) /**< \brief (EIC_DIS) External Interrupt 1 */
#define EIC_DIS_INT2                (0x1u <<  2) /**< \brief (EIC_DIS) External Interrupt 2 */
#define EIC_DIS_INT3                (0x1u <<  3) /**< \brief (EIC_DIS) External Interrupt 3 */
#define EIC_DIS_INT4                (0x1u <<  4) /**< \brief (EIC_DIS) External Interrupt 4 */
#define EIC_DIS_INT5                (0x1u <<  5) /**< \brief (EIC_DIS) External Interrupt 5 */
#define EIC_DIS_INT6                (0x1u <<  6) /**< \brief (EIC_DIS) External Interrupt 6 */
#define EIC_DIS_INT7                (0x1u <<  7) /**< \brief (EIC_DIS) External Interrupt 7 */
#define EIC_DIS_INT8                (0x1u <<  8) /**< \brief (EIC_DIS) External Interrupt 8 */
#define EIC_DIS_INT9                (0x1u <<  9) /**< \brief (EIC_DIS) External Interrupt 9 */
#define EIC_DIS_INT10               (0x1u << 10) /**< \brief (EIC_DIS) External Interrupt 10 */
#define EIC_DIS_INT11               (0x1u << 11) /**< \brief (EIC_DIS) External Interrupt 11 */
#define EIC_DIS_INT12               (0x1u << 12) /**< \brief (EIC_DIS) External Interrupt 12 */
#define EIC_DIS_INT13               (0x1u << 13) /**< \brief (EIC_DIS) External Interrupt 13 */
#define EIC_DIS_INT14               (0x1u << 14) /**< \brief (EIC_DIS) External Interrupt 14 */
#define EIC_DIS_INT15               (0x1u << 15) /**< \brief (EIC_DIS) External Interrupt 15 */
/* -------- EIC_CTRL : (EIC Offset: 0x038) Control Register -------- */
#define EIC_CTRL_NMI                (0x1u <<  0) /**< \brief (EIC_CTRL) External Non Maskable CPU interrupt */
#define EIC_CTRL_INT1               (0x1u <<  1) /**< \brief (EIC_CTRL) External Interrupt 1 */
#define EIC_CTRL_INT2               (0x1u <<  2) /**< \brief (EIC_CTRL) External Interrupt 2 */
#define EIC_CTRL_INT3               (0x1u <<  3) /**< \brief (EIC_CTRL) External Interrupt 3 */
#define EIC_CTRL_INT4               (0x1u <<  4) /**< \brief (EIC_CTRL) External Interrupt 4 */
#define EIC_CTRL_INT5               (0x1u <<  5) /**< \brief (EIC_CTRL) External Interrupt 5 */
#define EIC_CTRL_INT6               (0x1u <<  6) /**< \brief (EIC_CTRL) External Interrupt 6 */
#define EIC_CTRL_INT7               (0x1u <<  7) /**< \brief (EIC_CTRL) External Interrupt 7 */
#define EIC_CTRL_INT8               (0x1u <<  8) /**< \brief (EIC_CTRL) External Interrupt 8 */
#define EIC_CTRL_INT9               (0x1u <<  9) /**< \brief (EIC_CTRL) External Interrupt 9 */
#define EIC_CTRL_INT10              (0x1u << 10) /**< \brief (EIC_CTRL) External Interrupt 10 */
#define EIC_CTRL_INT11              (0x1u << 11) /**< \brief (EIC_CTRL) External Interrupt 11 */
#define EIC_CTRL_INT12              (0x1u << 12) /**< \brief (EIC_CTRL) External Interrupt 12 */
#define EIC_CTRL_INT13              (0x1u << 13) /**< \brief (EIC_CTRL) External Interrupt 13 */
#define EIC_CTRL_INT14              (0x1u << 14) /**< \brief (EIC_CTRL) External Interrupt 14 */
#define EIC_CTRL_INT15              (0x1u << 15) /**< \brief (EIC_CTRL) External Interrupt 15 */
/* -------- EIC_VERSION : (EIC Offset: 0x3FC) Version Register -------- */
#define EIC_VERSION_VERSION_Pos     0
#define EIC_VERSION_VERSION_Msk     (0xFFFu << EIC_VERSION_VERSION_Pos) /**< \brief (EIC_VERSION) Version bits */
#define EIC_VERSION_VERSION(value)  ((EIC_VERSION_VERSION_Msk & ((value) << EIC_VERSION_VERSION_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR FLASHCALW */
/* ============================================================================= */
/** \addtogroup SAM4L4_FLASHCALW Flash Controller */
/*@{*/

#define REV_FLASHCALW  0x110

#ifndef __ASSEMBLY__
/** \brief FLASHCALW hardware registers */
typedef struct {
  RwReg   FCR;         /**< \brief (FLASHCALW Offset: 0x00) Flash Controller Control Register */
  RwReg   FCMD;        /**< \brief (FLASHCALW Offset: 0x04) Flash Controller Command Register */
  RwReg   FSR;         /**< \brief (FLASHCALW Offset: 0x08) Flash Controller Status Register */
  RoReg   FPR;         /**< \brief (FLASHCALW Offset: 0x0C) Flash Controller Parameter Register */
  RoReg   VERSION;     /**< \brief (FLASHCALW Offset: 0x10) Flash Controller Version Register */
  RwReg   FGPFRHI;     /**< \brief (FLASHCALW Offset: 0x14) Flash Controller General Purpose Fuse Register High */
  RwReg   FGPFRLO;     /**< \brief (FLASHCALW Offset: 0x18) Flash Controller General Purpose Fuse Register Low */
} Flashcalw;
#endif /* __ASSEMBLY__ */
/* -------- FLASHCALW_FCR : (FLASHCALW Offset: 0x00) Flash Controller Control Register -------- */
#define FLASHCALW_FCR_FRDY          (0x1u <<  0) /**< \brief (FLASHCALW_FCR) Flash Ready Interrupt Enable */
#define   FLASHCALW_FCR_FRDY_0      (0x0u <<  0) /**< \brief (FLASHCALW_FCR) Flash Ready does not generate an interrupt */
#define   FLASHCALW_FCR_FRDY_1      (0x1u <<  0) /**< \brief (FLASHCALW_FCR) Flash Ready generates an interrupt */
#define FLASHCALW_FCR_LOCKE         (0x1u <<  2) /**< \brief (FLASHCALW_FCR) Lock Error Interrupt Enable */
#define   FLASHCALW_FCR_LOCKE_0     (0x0u <<  2) /**< \brief (FLASHCALW_FCR) Lock Error does not generate an interrupt */
#define   FLASHCALW_FCR_LOCKE_1     (0x1u <<  2) /**< \brief (FLASHCALW_FCR) Lock Error generates an interrupt */
#define FLASHCALW_FCR_PROGE         (0x1u <<  3) /**< \brief (FLASHCALW_FCR) Programming Error Interrupt Enable */
#define   FLASHCALW_FCR_PROGE_0     (0x0u <<  3) /**< \brief (FLASHCALW_FCR) Programming Error does not generate an interrupt */
#define   FLASHCALW_FCR_PROGE_1     (0x1u <<  3) /**< \brief (FLASHCALW_FCR) Programming Error generates an interrupt */
#define FLASHCALW_FCR_FWS           (0x1u <<  6) /**< \brief (FLASHCALW_FCR) Flash Wait State */
#define   FLASHCALW_FCR_FWS_0       (0x0u <<  6) /**< \brief (FLASHCALW_FCR) The flash is read with 0 wait states */
#define   FLASHCALW_FCR_FWS_1       (0x1u <<  6) /**< \brief (FLASHCALW_FCR) The flash is read with 1 wait states */
#define FLASHCALW_FCR_WS1OPT        (0x1u <<  7) /**< \brief (FLASHCALW_FCR) Wait State 1 Optimization */
/* -------- FLASHCALW_FCMD : (FLASHCALW Offset: 0x04) Flash Controller Command Register -------- */
#define FLASHCALW_FCMD_CMD_Pos      0
#define FLASHCALW_FCMD_CMD_Msk      (0x3Fu << FLASHCALW_FCMD_CMD_Pos) /**< \brief (FLASHCALW_FCMD) Command */
#define FLASHCALW_FCMD_CMD(value)   ((FLASHCALW_FCMD_CMD_Msk & ((value) << FLASHCALW_FCMD_CMD_Pos)))
#define   FLASHCALW_FCMD_CMD_NOP    (0x0u <<  0) /**< \brief (FLASHCALW_FCMD) No Operation */
#define   FLASHCALW_FCMD_CMD_WP     (0x1u <<  0) /**< \brief (FLASHCALW_FCMD) Write Page */
#define   FLASHCALW_FCMD_CMD_EP     (0x2u <<  0) /**< \brief (FLASHCALW_FCMD) Erase Page */
#define   FLASHCALW_FCMD_CMD_CPB    (0x3u <<  0) /**< \brief (FLASHCALW_FCMD) Clear Page Buffer */
#define   FLASHCALW_FCMD_CMD_LP     (0x4u <<  0) /**< \brief (FLASHCALW_FCMD) Lock Region containing page */
#define   FLASHCALW_FCMD_CMD_UP     (0x5u <<  0) /**< \brief (FLASHCALW_FCMD) Unlock Region containing page */
#define   FLASHCALW_FCMD_CMD_EA     (0x6u <<  0) /**< \brief (FLASHCALW_FCMD) Erase All, including secuity and fuse bits */
#define   FLASHCALW_FCMD_CMD_WGPB   (0x7u <<  0) /**< \brief (FLASHCALW_FCMD) Write General-Purpose fuse Bit */
#define   FLASHCALW_FCMD_CMD_EGPB   (0x8u <<  0) /**< \brief (FLASHCALW_FCMD) Erase General-Purpose fuse Bit */
#define   FLASHCALW_FCMD_CMD_SSB    (0x9u <<  0) /**< \brief (FLASHCALW_FCMD) Set Security Bit */
#define   FLASHCALW_FCMD_CMD_PGPFB  (0xAu <<  0) /**< \brief (FLASHCALW_FCMD) Program GPFuse Byte */
#define   FLASHCALW_FCMD_CMD_EAGPF  (0xBu <<  0) /**< \brief (FLASHCALW_FCMD) Erase All GP Fuses */
#define   FLASHCALW_FCMD_CMD_QPR    (0xCu <<  0) /**< \brief (FLASHCALW_FCMD) Quick Page Read */
#define   FLASHCALW_FCMD_CMD_WUP    (0xDu <<  0) /**< \brief (FLASHCALW_FCMD) Write User Page */
#define   FLASHCALW_FCMD_CMD_EUP    (0xEu <<  0) /**< \brief (FLASHCALW_FCMD) Erase User Page */
#define   FLASHCALW_FCMD_CMD_QPRUP  (0xFu <<  0) /**< \brief (FLASHCALW_FCMD) Quick Page Read User Page */
#define FLASHCALW_FCMD_PAGEN_Pos    8
#define FLASHCALW_FCMD_PAGEN_Msk    (0xFFFFu << FLASHCALW_FCMD_PAGEN_Pos) /**< \brief (FLASHCALW_FCMD) Page number */
#define FLASHCALW_FCMD_PAGEN(value) ((FLASHCALW_FCMD_PAGEN_Msk & ((value) << FLASHCALW_FCMD_PAGEN_Pos)))
#define FLASHCALW_FCMD_KEY_Pos      24
#define FLASHCALW_FCMD_KEY_Msk      (0xFFu << FLASHCALW_FCMD_KEY_Pos) /**< \brief (FLASHCALW_FCMD) Write protection key */
#define FLASHCALW_FCMD_KEY(value)   ((FLASHCALW_FCMD_KEY_Msk & ((value) << FLASHCALW_FCMD_KEY_Pos)))
#define   FLASHCALW_FCMD_KEY_KEY    (0xA5u << 24) /**< \brief (FLASHCALW_FCMD)  */
/* -------- FLASHCALW_FSR : (FLASHCALW Offset: 0x08) Flash Controller Status Register -------- */
#define FLASHCALW_FSR_FRDY          (0x1u <<  0) /**< \brief (FLASHCALW_FSR) Flash Ready Status */
#define FLASHCALW_FSR_LOCKE         (0x1u <<  2) /**< \brief (FLASHCALW_FSR) Lock Error Status */
#define FLASHCALW_FSR_PROGE         (0x1u <<  3) /**< \brief (FLASHCALW_FSR) Programming Error Status */
#define FLASHCALW_FSR_SECURITY      (0x1u <<  4) /**< \brief (FLASHCALW_FSR) Security Bit Status */
#define FLASHCALW_FSR_QPRR          (0x1u <<  5) /**< \brief (FLASHCALW_FSR) Quick Page Read Result */
#define FLASHCALW_FSR_HSMODE        (0x1u <<  6) /**< \brief (FLASHCALW_FSR) High Speed Mode */
#define FLASHCALW_FSR_ECCERR_Pos    8
#define FLASHCALW_FSR_ECCERR_Msk    (0x3u << FLASHCALW_FSR_ECCERR_Pos) /**< \brief (FLASHCALW_FSR) ECC Error Status */
#define FLASHCALW_FSR_ECCERR(value) ((FLASHCALW_FSR_ECCERR_Msk & ((value) << FLASHCALW_FSR_ECCERR_Pos)))
#define FLASHCALW_FSR_LOCK0         (0x1u << 16) /**< \brief (FLASHCALW_FSR) Lock Region 0 Lock Status */
#define FLASHCALW_FSR_LOCK1         (0x1u << 17) /**< \brief (FLASHCALW_FSR) Lock Region 1 Lock Status */
#define FLASHCALW_FSR_LOCK2         (0x1u << 18) /**< \brief (FLASHCALW_FSR) Lock Region 2 Lock Status */
#define FLASHCALW_FSR_LOCK3         (0x1u << 19) /**< \brief (FLASHCALW_FSR) Lock Region 3 Lock Status */
#define FLASHCALW_FSR_LOCK4         (0x1u << 20) /**< \brief (FLASHCALW_FSR) Lock Region 4 Lock Status */
#define FLASHCALW_FSR_LOCK5         (0x1u << 21) /**< \brief (FLASHCALW_FSR) Lock Region 5 Lock Status */
#define FLASHCALW_FSR_LOCK6         (0x1u << 22) /**< \brief (FLASHCALW_FSR) Lock Region 6 Lock Status */
#define FLASHCALW_FSR_LOCK7         (0x1u << 23) /**< \brief (FLASHCALW_FSR) Lock Region 7 Lock Status */
#define FLASHCALW_FSR_LOCK8         (0x1u << 24) /**< \brief (FLASHCALW_FSR) Lock Region 8 Lock Status */
#define FLASHCALW_FSR_LOCK9         (0x1u << 25) /**< \brief (FLASHCALW_FSR) Lock Region 9 Lock Status */
#define FLASHCALW_FSR_LOCK10        (0x1u << 26) /**< \brief (FLASHCALW_FSR) Lock Region 10 Lock Status */
#define FLASHCALW_FSR_LOCK11        (0x1u << 27) /**< \brief (FLASHCALW_FSR) Lock Region 11 Lock Status */
#define FLASHCALW_FSR_LOCK12        (0x1u << 28) /**< \brief (FLASHCALW_FSR) Lock Region 12 Lock Status */
#define FLASHCALW_FSR_LOCK13        (0x1u << 29) /**< \brief (FLASHCALW_FSR) Lock Region 13 Lock Status */
#define FLASHCALW_FSR_LOCK14        (0x1u << 30) /**< \brief (FLASHCALW_FSR) Lock Region 14 Lock Status */
#define FLASHCALW_FSR_LOCK15        (0x1u << 31) /**< \brief (FLASHCALW_FSR) Lock Region 15 Lock Status */
/* -------- FLASHCALW_FPR : (FLASHCALW Offset: 0x0C) Flash Controller Parameter Register -------- */
#define FLASHCALW_FPR_FSZ_Pos       0
#define FLASHCALW_FPR_FSZ_Msk       (0xFu << FLASHCALW_FPR_FSZ_Pos) /**< \brief (FLASHCALW_FPR) Flash Size */
#define FLASHCALW_FPR_FSZ(value)    ((FLASHCALW_FPR_FSZ_Msk & ((value) << FLASHCALW_FPR_FSZ_Pos)))
#define FLASHCALW_FPR_PSZ_Pos       8
#define FLASHCALW_FPR_PSZ_Msk       (0x7u << FLASHCALW_FPR_PSZ_Pos) /**< \brief (FLASHCALW_FPR) Page Size */
#define FLASHCALW_FPR_PSZ(value)    ((FLASHCALW_FPR_PSZ_Msk & ((value) << FLASHCALW_FPR_PSZ_Pos)))
/* -------- FLASHCALW_VERSION : (FLASHCALW Offset: 0x10) Flash Controller Version Register -------- */
#define FLASHCALW_VERSION_VERSION_Pos    0
#define FLASHCALW_VERSION_VERSION_Msk    (0xFFFu << FLASHCALW_VERSION_VERSION_Pos) /**< \brief (FLASHCALW_VERSION) Version Number */
#define FLASHCALW_VERSION_VERSION(value) ((FLASHCALW_VERSION_VERSION_Msk & ((value) << FLASHCALW_VERSION_VERSION_Pos)))
#define FLASHCALW_VERSION_VARIANT_Pos    16
#define FLASHCALW_VERSION_VARIANT_Msk    (0xFu << FLASHCALW_VERSION_VARIANT_Pos) /**< \brief (FLASHCALW_VERSION) Variant Number */
#define FLASHCALW_VERSION_VARIANT(value) ((FLASHCALW_VERSION_VARIANT_Msk & ((value) << FLASHCALW_VERSION_VARIANT_Pos)))
/* -------- FLASHCALW_FGPFRHI : (FLASHCALW Offset: 0x14) Flash Controller General Purpose Fuse Register High -------- */
#define FLASHCALW_FGPFRHI_GPF32     (0x1u <<  0) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 32 */
#define FLASHCALW_FGPFRHI_GPF33     (0x1u <<  1) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 33 */
#define FLASHCALW_FGPFRHI_GPF34     (0x1u <<  2) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 34 */
#define FLASHCALW_FGPFRHI_GPF35     (0x1u <<  3) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 35 */
#define FLASHCALW_FGPFRHI_GPF36     (0x1u <<  4) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 36 */
#define FLASHCALW_FGPFRHI_GPF37     (0x1u <<  5) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 37 */
#define FLASHCALW_FGPFRHI_GPF38     (0x1u <<  6) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 38 */
#define FLASHCALW_FGPFRHI_GPF39     (0x1u <<  7) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 39 */
#define FLASHCALW_FGPFRHI_GPF40     (0x1u <<  8) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 40 */
#define FLASHCALW_FGPFRHI_GPF41     (0x1u <<  9) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 41 */
#define FLASHCALW_FGPFRHI_GPF42     (0x1u << 10) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 42 */
#define FLASHCALW_FGPFRHI_GPF43     (0x1u << 11) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 43 */
#define FLASHCALW_FGPFRHI_GPF44     (0x1u << 12) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 44 */
#define FLASHCALW_FGPFRHI_GPF45     (0x1u << 13) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 45 */
#define FLASHCALW_FGPFRHI_GPF46     (0x1u << 14) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 46 */
#define FLASHCALW_FGPFRHI_GPF47     (0x1u << 15) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 47 */
#define FLASHCALW_FGPFRHI_GPF48     (0x1u << 16) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 48 */
#define FLASHCALW_FGPFRHI_GPF49     (0x1u << 17) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 49 */
#define FLASHCALW_FGPFRHI_GPF50     (0x1u << 18) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 50 */
#define FLASHCALW_FGPFRHI_GPF51     (0x1u << 19) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 51 */
#define FLASHCALW_FGPFRHI_GPF52     (0x1u << 20) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 52 */
#define FLASHCALW_FGPFRHI_GPF53     (0x1u << 21) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 53 */
#define FLASHCALW_FGPFRHI_GPF54     (0x1u << 22) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 54 */
#define FLASHCALW_FGPFRHI_GPF55     (0x1u << 23) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 55 */
#define FLASHCALW_FGPFRHI_GPF56     (0x1u << 24) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 56 */
#define FLASHCALW_FGPFRHI_GPF57     (0x1u << 25) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 57 */
#define FLASHCALW_FGPFRHI_GPF58     (0x1u << 26) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 58 */
#define FLASHCALW_FGPFRHI_GPF59     (0x1u << 27) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 59 */
#define FLASHCALW_FGPFRHI_GPF60     (0x1u << 28) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 60 */
#define FLASHCALW_FGPFRHI_GPF61     (0x1u << 29) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 61 */
#define FLASHCALW_FGPFRHI_GPF62     (0x1u << 30) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 62 */
#define FLASHCALW_FGPFRHI_GPF63     (0x1u << 31) /**< \brief (FLASHCALW_FGPFRHI) General Purpose Fuse 63 */
/* -------- FLASHCALW_FGPFRLO : (FLASHCALW Offset: 0x18) Flash Controller General Purpose Fuse Register Low -------- */
#define FLASHCALW_FGPFRLO_LOCK0     (0x1u <<  0) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 0 */
#define FLASHCALW_FGPFRLO_LOCK1     (0x1u <<  1) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 1 */
#define FLASHCALW_FGPFRLO_LOCK2     (0x1u <<  2) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 2 */
#define FLASHCALW_FGPFRLO_LOCK3     (0x1u <<  3) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 3 */
#define FLASHCALW_FGPFRLO_LOCK4     (0x1u <<  4) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 4 */
#define FLASHCALW_FGPFRLO_LOCK5     (0x1u <<  5) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 5 */
#define FLASHCALW_FGPFRLO_LOCK6     (0x1u <<  6) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 6 */
#define FLASHCALW_FGPFRLO_LOCK7     (0x1u <<  7) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 7 */
#define FLASHCALW_FGPFRLO_LOCK8     (0x1u <<  8) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 8 */
#define FLASHCALW_FGPFRLO_LOCK9     (0x1u <<  9) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 9 */
#define FLASHCALW_FGPFRLO_LOCK10    (0x1u << 10) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 10 */
#define FLASHCALW_FGPFRLO_LOCK11    (0x1u << 11) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 11 */
#define FLASHCALW_FGPFRLO_LOCK12    (0x1u << 12) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 12 */
#define FLASHCALW_FGPFRLO_LOCK13    (0x1u << 13) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 13 */
#define FLASHCALW_FGPFRLO_LOCK14    (0x1u << 14) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 14 */
#define FLASHCALW_FGPFRLO_LOCK15    (0x1u << 15) /**< \brief (FLASHCALW_FGPFRLO) Lock Bit 15 */
#define FLASHCALW_FGPFRLO_GPF16     (0x1u << 16) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 16 */
#define FLASHCALW_FGPFRLO_GPF17     (0x1u << 17) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 17 */
#define FLASHCALW_FGPFRLO_GPF18     (0x1u << 18) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 18 */
#define FLASHCALW_FGPFRLO_GPF19     (0x1u << 19) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 19 */
#define FLASHCALW_FGPFRLO_GPF20     (0x1u << 20) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 20 */
#define FLASHCALW_FGPFRLO_GPF21     (0x1u << 21) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 21 */
#define FLASHCALW_FGPFRLO_GPF22     (0x1u << 22) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 22 */
#define FLASHCALW_FGPFRLO_GPF23     (0x1u << 23) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 23 */
#define FLASHCALW_FGPFRLO_GPF24     (0x1u << 24) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 24 */
#define FLASHCALW_FGPFRLO_GPF25     (0x1u << 25) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 25 */
#define FLASHCALW_FGPFRLO_GPF26     (0x1u << 26) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 26 */
#define FLASHCALW_FGPFRLO_GPF27     (0x1u << 27) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 27 */
#define FLASHCALW_FGPFRLO_GPF28     (0x1u << 28) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 28 */
#define FLASHCALW_FGPFRLO_GPF29     (0x1u << 29) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 29 */
#define FLASHCALW_FGPFRLO_GPF30     (0x1u << 30) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 30 */
#define FLASHCALW_FGPFRLO_GPF31     (0x1u << 31) /**< \brief (FLASHCALW_FGPFRLO) General Purpose Fuse 31 */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR FREQM */
/* ============================================================================= */
/** \addtogroup SAM4L4_FREQM Frequency Meter */
/*@{*/

#define REV_FREQM      0x311

#ifndef __ASSEMBLY__
/** \brief FREQM hardware registers */
typedef struct {
  WoReg   CTRL;        /**< \brief (FREQM Offset: 0x000) Control register */
  RwReg   MODE;        /**< \brief (FREQM Offset: 0x004) Mode  register */
  RoReg   STATUS;      /**< \brief (FREQM Offset: 0x008) Status  register */
  RoReg   VALUE;       /**< \brief (FREQM Offset: 0x00C) Value register */
  WoReg   IER;         /**< \brief (FREQM Offset: 0x010) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (FREQM Offset: 0x014) Interrupt Diable Register */
  RoReg   IMR;         /**< \brief (FREQM Offset: 0x018) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (FREQM Offset: 0x01C) Interrupt Status Register */
  WoReg   ICR;         /**< \brief (FREQM Offset: 0x020) Interrupt Clear Register */
  RoReg   Reserved1[246];
  RoReg   VERSION;     /**< \brief (FREQM Offset: 0x3FC) Version Register */
} Freqm;
#endif /* __ASSEMBLY__ */
/* -------- FREQM_CTRL : (FREQM Offset: 0x000) Control register -------- */
#define FREQM_CTRL_START            (0x1u <<  0) /**< \brief (FREQM_CTRL) Start frequency measurement */
/* -------- FREQM_MODE : (FREQM Offset: 0x004) Mode  register -------- */
#define FREQM_MODE_REFSEL_Pos       0
#define FREQM_MODE_REFSEL_Msk       (0x3u << FREQM_MODE_REFSEL_Pos) /**< \brief (FREQM_MODE) Reference Clock Selection */
#define FREQM_MODE_REFSEL(value)    ((FREQM_MODE_REFSEL_Msk & ((value) << FREQM_MODE_REFSEL_Pos)))
#define FREQM_MODE_REFNUM_Pos       8
#define FREQM_MODE_REFNUM_Msk       (0xFFu << FREQM_MODE_REFNUM_Pos) /**< \brief (FREQM_MODE) Number of Reference CLock Cycles */
#define FREQM_MODE_REFNUM(value)    ((FREQM_MODE_REFNUM_Msk & ((value) << FREQM_MODE_REFNUM_Pos)))
#define FREQM_MODE_CLKSEL_Pos       16
#define FREQM_MODE_CLKSEL_Msk       (0x1Fu << FREQM_MODE_CLKSEL_Pos) /**< \brief (FREQM_MODE) Clock Source Selection */
#define FREQM_MODE_CLKSEL(value)    ((FREQM_MODE_CLKSEL_Msk & ((value) << FREQM_MODE_CLKSEL_Pos)))
#define FREQM_MODE_REFCEN           (0x1u << 31) /**< \brief (FREQM_MODE) Reference Clock Enable */
/* -------- FREQM_STATUS : (FREQM Offset: 0x008) Status  register -------- */
#define FREQM_STATUS_BUSY           (0x1u <<  0) /**< \brief (FREQM_STATUS) Frequency measurement on-going */
#define FREQM_STATUS_RCLKBUSY       (0x1u <<  1) /**< \brief (FREQM_STATUS) Reference Clock busy */
/* -------- FREQM_VALUE : (FREQM Offset: 0x00C) Value register -------- */
#define FREQM_VALUE_VALUE_Pos       0
#define FREQM_VALUE_VALUE_Msk       (0xFFFFFFu << FREQM_VALUE_VALUE_Pos) /**< \brief (FREQM_VALUE) Measured frequency */
#define FREQM_VALUE_VALUE(value)    ((FREQM_VALUE_VALUE_Msk & ((value) << FREQM_VALUE_VALUE_Pos)))
/* -------- FREQM_IER : (FREQM Offset: 0x010) Interrupt Enable Register -------- */
#define FREQM_IER_DONE              (0x1u <<  0) /**< \brief (FREQM_IER) Frequency measurment done */
#define FREQM_IER_RCLKRDY           (0x1u <<  1) /**< \brief (FREQM_IER) Reference Clock ready */
/* -------- FREQM_IDR : (FREQM Offset: 0x014) Interrupt Diable Register -------- */
#define FREQM_IDR_DONE              (0x1u <<  0) /**< \brief (FREQM_IDR) Frequency measurment done */
#define FREQM_IDR_RCLKRDY           (0x1u <<  1) /**< \brief (FREQM_IDR) Reference Clock ready */
/* -------- FREQM_IMR : (FREQM Offset: 0x018) Interrupt Mask Register -------- */
#define FREQM_IMR_DONE              (0x1u <<  0) /**< \brief (FREQM_IMR) Frequency measurment done */
#define FREQM_IMR_RCLKRDY           (0x1u <<  1) /**< \brief (FREQM_IMR) Reference Clock ready */
/* -------- FREQM_ISR : (FREQM Offset: 0x01C) Interrupt Status Register -------- */
#define FREQM_ISR_DONE              (0x1u <<  0) /**< \brief (FREQM_ISR) Frequency measurment done */
#define FREQM_ISR_RCLKRDY           (0x1u <<  1) /**< \brief (FREQM_ISR) Reference Clock ready */
/* -------- FREQM_ICR : (FREQM Offset: 0x020) Interrupt Clear Register -------- */
#define FREQM_ICR_DONE              (0x1u <<  0) /**< \brief (FREQM_ICR) Frequency measurment done */
#define FREQM_ICR_RCLKRDY           (0x1u <<  1) /**< \brief (FREQM_ICR) Reference Clock ready */
/* -------- FREQM_VERSION : (FREQM Offset: 0x3FC) Version Register -------- */
#define FREQM_VERSION_VERSION_Pos    0
#define FREQM_VERSION_VERSION_Msk    (0xFFFu << FREQM_VERSION_VERSION_Pos) /**< \brief (FREQM_VERSION) Version number */
#define FREQM_VERSION_VERSION(value) ((FREQM_VERSION_VERSION_Msk & ((value) << FREQM_VERSION_VERSION_Pos)))
#define FREQM_VERSION_VARIANT_Pos    16
#define FREQM_VERSION_VARIANT_Msk    (0xFu << FREQM_VERSION_VARIANT_Pos) /**< \brief (FREQM_VERSION) Variant number */
#define FREQM_VERSION_VARIANT(value) ((FREQM_VERSION_VARIANT_Msk & ((value) << FREQM_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR GLOC */
/* ============================================================================= */
/** \addtogroup SAM4L4_GLOC Glue Logic Controller */
/*@{*/

#define REV_GLOC       0x102

#ifndef __ASSEMBLY__
/** \brief GlocLut hardware registers */
typedef struct {
  RwReg   CR;          /**< \brief (GlocLut Offset: 0x00) Control Register */
  RwReg   TRUTH;       /**< \brief (GlocLut Offset: 0x04) Truth Register */
} GlocLut;
/** \brief GLOC hardware registers */
#define GLOC_LUTS 2
typedef struct {
  GlocLut Lut[GLOC_LUTS]; /**< \brief (GLOC Offset: 0x00) GlocLut groups */
  GlocLut Reserved1[7 - GLOC_LUTS];
  RoReg   PARAMETER;   /**< \brief (GLOC Offset: 0x38) Parameter Register */
  RoReg   VERSION;     /**< \brief (GLOC Offset: 0x3C) Version Register */
} Gloc;
#endif /* __ASSEMBLY__ */
/* -------- GLOC_CR : (GLOC Offset: 0x00) Lut Control Register -------- */
#define GLOC_CR_AEN_Pos             0
#define GLOC_CR_AEN_Msk             (0xFu << GLOC_CR_AEN_Pos) /**< \brief (GLOC_CR) Input mask */
#define GLOC_CR_AEN(value)          ((GLOC_CR_AEN_Msk & ((value) << GLOC_CR_AEN_Pos)))
#define GLOC_CR_FILTEN              (0x1u << 31) /**< \brief (GLOC_CR) Filter enable */
/* -------- GLOC_TRUTH : (GLOC Offset: 0x04) Lut Truth Register -------- */
#define GLOC_TRUTH_TRUTH_Pos        0
#define GLOC_TRUTH_TRUTH_Msk        (0xFFFFu << GLOC_TRUTH_TRUTH_Pos) /**< \brief (GLOC_TRUTH) Truth */
#define GLOC_TRUTH_TRUTH(value)     ((GLOC_TRUTH_TRUTH_Msk & ((value) << GLOC_TRUTH_TRUTH_Pos)))
/* -------- GLOC_PARAMETER : (GLOC Offset: 0x38) Parameter Register -------- */
#define GLOC_PARAMETER_LUTS_Pos     0
#define GLOC_PARAMETER_LUTS_Msk     (0xFFu << GLOC_PARAMETER_LUTS_Pos) /**< \brief (GLOC_PARAMETER) LUTs */
#define GLOC_PARAMETER_LUTS(value)  ((GLOC_PARAMETER_LUTS_Msk & ((value) << GLOC_PARAMETER_LUTS_Pos)))
/* -------- GLOC_VERSION : (GLOC Offset: 0x3C) Version Register -------- */
#define GLOC_VERSION_VERSION_Pos    0
#define GLOC_VERSION_VERSION_Msk    (0xFFFu << GLOC_VERSION_VERSION_Pos) /**< \brief (GLOC_VERSION) Version */
#define GLOC_VERSION_VERSION(value) ((GLOC_VERSION_VERSION_Msk & ((value) << GLOC_VERSION_VERSION_Pos)))
#define GLOC_VERSION_VARIANT_Pos    16
#define GLOC_VERSION_VARIANT_Msk    (0xFu << GLOC_VERSION_VARIANT_Pos) /**< \brief (GLOC_VERSION) Variant */
#define GLOC_VERSION_VARIANT(value) ((GLOC_VERSION_VARIANT_Msk & ((value) << GLOC_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR GPIO */
/* ============================================================================= */
/** \addtogroup SAM4L4_GPIO General-Purpose Input/Output Controller */
/*@{*/

#define REV_GPIO       0x215

#ifndef __ASSEMBLY__
/** \brief GpioPort hardware registers */
typedef struct {
  RwReg   GPER;        /**< \brief (GpioPort Offset: 0x000) GPIO Enable Register */
  WoReg   GPERS;       /**< \brief (GpioPort Offset: 0x004) GPIO Enable Register - Set */
  WoReg   GPERC;       /**< \brief (GpioPort Offset: 0x008) GPIO Enable Register - Clear */
  WoReg   GPERT;       /**< \brief (GpioPort Offset: 0x00C) GPIO Enable Register - Toggle */
  RwReg   PMR0;        /**< \brief (GpioPort Offset: 0x010) Peripheral Mux Register 0 */
  WoReg   PMR0S;       /**< \brief (GpioPort Offset: 0x014) Peripheral Mux Register 0 - Set */
  WoReg   PMR0C;       /**< \brief (GpioPort Offset: 0x018) Peripheral Mux Register 0 - Clear */
  WoReg   PMR0T;       /**< \brief (GpioPort Offset: 0x01C) Peripheral Mux Register 0 - Toggle */
  RwReg   PMR1;        /**< \brief (GpioPort Offset: 0x020) Peripheral Mux Register 1 */
  WoReg   PMR1S;       /**< \brief (GpioPort Offset: 0x024) Peripheral Mux Register 1 - Set */
  WoReg   PMR1C;       /**< \brief (GpioPort Offset: 0x028) Peripheral Mux Register 1 - Clear */
  WoReg   PMR1T;       /**< \brief (GpioPort Offset: 0x02C) Peripheral Mux Register 1 - Toggle */
  RwReg   PMR2;        /**< \brief (GpioPort Offset: 0x030) Peripheral Mux Register 2 */
  WoReg   PMR2S;       /**< \brief (GpioPort Offset: 0x034) Peripheral Mux Register 2 - Set */
  WoReg   PMR2C;       /**< \brief (GpioPort Offset: 0x038) Peripheral Mux Register 2 - Clear */
  WoReg   PMR2T;       /**< \brief (GpioPort Offset: 0x03C) Peripheral Mux Register 2 - Toggle */
  RwReg   ODER;        /**< \brief (GpioPort Offset: 0x040) Output Driver Enable Register */
  WoReg   ODERS;       /**< \brief (GpioPort Offset: 0x044) Output Driver Enable Register - Set */
  WoReg   ODERC;       /**< \brief (GpioPort Offset: 0x048) Output Driver Enable Register - Clear */
  WoReg   ODERT;       /**< \brief (GpioPort Offset: 0x04C) Output Driver Enable Register - Toggle */
  RwReg   OVR;         /**< \brief (GpioPort Offset: 0x050) Output Value Register */
  WoReg   OVRS;        /**< \brief (GpioPort Offset: 0x054) Output Value Register - Set */
  WoReg   OVRC;        /**< \brief (GpioPort Offset: 0x058) Output Value Register - Clear */
  WoReg   OVRT;        /**< \brief (GpioPort Offset: 0x05C) Output Value Register - Toggle */
  RoReg   PVR;         /**< \brief (GpioPort Offset: 0x060) Pin Value Register */
  RoReg   Reserved1[3];
  RwReg   PUER;        /**< \brief (GpioPort Offset: 0x070) Pull-up Enable Register */
  WoReg   PUERS;       /**< \brief (GpioPort Offset: 0x074) Pull-up Enable Register - Set */
  WoReg   PUERC;       /**< \brief (GpioPort Offset: 0x078) Pull-up Enable Register - Clear */
  WoReg   PUERT;       /**< \brief (GpioPort Offset: 0x07C) Pull-up Enable Register - Toggle */
  RwReg   PDER;        /**< \brief (GpioPort Offset: 0x080) Pull-down Enable Register */
  WoReg   PDERS;       /**< \brief (GpioPort Offset: 0x084) Pull-down Enable Register - Set */
  WoReg   PDERC;       /**< \brief (GpioPort Offset: 0x088) Pull-down Enable Register - Clear */
  WoReg   PDERT;       /**< \brief (GpioPort Offset: 0x08C) Pull-down Enable Register - Toggle */
  RwReg   IER;         /**< \brief (GpioPort Offset: 0x090) Interrupt Enable Register */
  WoReg   IERS;        /**< \brief (GpioPort Offset: 0x094) Interrupt Enable Register - Set */
  WoReg   IERC;        /**< \brief (GpioPort Offset: 0x098) Interrupt Enable Register - Clear */
  WoReg   IERT;        /**< \brief (GpioPort Offset: 0x09C) Interrupt Enable Register - Toggle */
  RwReg   IMR0;        /**< \brief (GpioPort Offset: 0x0A0) Interrupt Mode Register 0 */
  WoReg   IMR0S;       /**< \brief (GpioPort Offset: 0x0A4) Interrupt Mode Register 0 - Set */
  WoReg   IMR0C;       /**< \brief (GpioPort Offset: 0x0A8) Interrupt Mode Register 0 - Clear */
  WoReg   IMR0T;       /**< \brief (GpioPort Offset: 0x0AC) Interrupt Mode Register 0 - Toggle */
  RwReg   IMR1;        /**< \brief (GpioPort Offset: 0x0B0) Interrupt Mode Register 1 */
  WoReg   IMR1S;       /**< \brief (GpioPort Offset: 0x0B4) Interrupt Mode Register 1 - Set */
  WoReg   IMR1C;       /**< \brief (GpioPort Offset: 0x0B8) Interrupt Mode Register 1 - Clear */
  WoReg   IMR1T;       /**< \brief (GpioPort Offset: 0x0BC) Interrupt Mode Register 1 - Toggle */
  RwReg   GFER;        /**< \brief (GpioPort Offset: 0x0C0) Glitch Filter Enable Register */
  WoReg   GFERS;       /**< \brief (GpioPort Offset: 0x0C4) Glitch Filter Enable Register - Set */
  WoReg   GFERC;       /**< \brief (GpioPort Offset: 0x0C8) Glitch Filter Enable Register - Clear */
  WoReg   GFERT;       /**< \brief (GpioPort Offset: 0x0CC) Glitch Filter Enable Register - Toggle */
  RoReg   IFR;         /**< \brief (GpioPort Offset: 0x0D0) Interrupt Flag Register */
  RoReg   Reserved2[1];
  WoReg   IFRC;        /**< \brief (GpioPort Offset: 0x0D8) Interrupt Flag Register - Clear */
  RoReg   Reserved3[1];
  RwReg   ODMER;       /**< \brief (GpioPort Offset: 0x0E0) Open Drain Mode Register */
  WoReg   ODMERS;      /**< \brief (GpioPort Offset: 0x0E4) Open Drain Mode Register - Set */
  WoReg   ODMERC;      /**< \brief (GpioPort Offset: 0x0E8) Open Drain Mode Register - Clear */
  WoReg   ODMERT;      /**< \brief (GpioPort Offset: 0x0EC) Open Drain Mode Register - Toggle */
  RoReg   Reserved4[4];
  RwReg   ODCR0;       /**< \brief (GpioPort Offset: 0x100) Output Driving Capability Register 0 */
  RwReg   ODCR0S;      /**< \brief (GpioPort Offset: 0x104) Output Driving Capability Register 0 - Set */
  RwReg   ODCR0C;      /**< \brief (GpioPort Offset: 0x108) Output Driving Capability Register 0 - Clear */
  RwReg   ODCR0T;      /**< \brief (GpioPort Offset: 0x10C) Output Driving Capability Register 0 - Toggle */
  RwReg   ODCR1;       /**< \brief (GpioPort Offset: 0x110) Output Driving Capability Register 1 */
  RwReg   ODCR1S;      /**< \brief (GpioPort Offset: 0x114) Output Driving Capability Register 1 - Set */
  RwReg   ODCR1C;      /**< \brief (GpioPort Offset: 0x118) Output Driving Capability Register 1 - Clear */
  RwReg   ODCR1T;      /**< \brief (GpioPort Offset: 0x11C) Output Driving Capability Register 1 - Toggle */
  RoReg   Reserved5[4];
  RwReg   OSRR0;       /**< \brief (GpioPort Offset: 0x130) Output Slew Rate Register 0 */
  RwReg   OSRR0S;      /**< \brief (GpioPort Offset: 0x134) Output Slew Rate Register 0 - Set */
  RwReg   OSRR0C;      /**< \brief (GpioPort Offset: 0x138) Output Slew Rate Register 0 - Clear */
  RwReg   OSRR0T;      /**< \brief (GpioPort Offset: 0x13C) Output Slew Rate Register 0 - Toggle */
  RoReg   Reserved6[8];
  RwReg   STER;        /**< \brief (GpioPort Offset: 0x160) Schmitt Trigger Enable Register */
  RwReg   STERS;       /**< \brief (GpioPort Offset: 0x164) Schmitt Trigger Enable Register - Set */
  RwReg   STERC;       /**< \brief (GpioPort Offset: 0x168) Schmitt Trigger Enable Register - Clear */
  RwReg   STERT;       /**< \brief (GpioPort Offset: 0x16C) Schmitt Trigger Enable Register - Toggle */
  RoReg   Reserved7[4];
  RwReg   EVER;        /**< \brief (GpioPort Offset: 0x180) Event Enable Register */
  WoReg   EVERS;       /**< \brief (GpioPort Offset: 0x184) Event Enable Register - Set */
  WoReg   EVERC;       /**< \brief (GpioPort Offset: 0x188) Event Enable Register - Clear */
  WoReg   EVERT;       /**< \brief (GpioPort Offset: 0x18C) Event Enable Register - Toggle */
  RoReg   Reserved8[4];
  RwReg   LOCK;        /**< \brief (GpioPort Offset: 0x1A0) Lock Register */
  WoReg   LOCKS;       /**< \brief (GpioPort Offset: 0x1A4) Lock Register - Set */
  WoReg   LOCKC;       /**< \brief (GpioPort Offset: 0x1A8) Lock Register - Clear */
  WoReg   LOCKT;       /**< \brief (GpioPort Offset: 0x1AC) Lock Register - Toggle */
  RoReg   Reserved9[12];
  WoReg   UNLOCK;      /**< \brief (GpioPort Offset: 0x1E0) Unlock Register */
  RwReg   ASR;         /**< \brief (GpioPort Offset: 0x1E4) Access Status Register */
  RoReg   Reserved10[4];
  RoReg   PARAMETER;   /**< \brief (GpioPort Offset: 0x1F8) Parameter Register */
  RoReg   VERSION;     /**< \brief (GpioPort Offset: 0x1FC) Version Register */
} GpioPort;
/** \brief GPIO hardware registers */
#define GPIO_PORT_LENGTH 3
typedef struct {
  GpioPort Port[GPIO_PORT_LENGTH]; /**< \brief (GPIO Offset: 0x000) GpioPort groups */
  GpioPort Reserved1[64 - GPIO_PORT_LENGTH];
} Gpio;
#endif /* __ASSEMBLY__ */
/* -------- GPIO_GPER : (GPIO Offset: 0x000) Port GPIO Enable Register -------- */
#define GPIO_GPER_P0                (0x1u <<  0) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P1                (0x1u <<  1) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P2                (0x1u <<  2) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P3                (0x1u <<  3) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P4                (0x1u <<  4) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P5                (0x1u <<  5) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P6                (0x1u <<  6) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P7                (0x1u <<  7) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P8                (0x1u <<  8) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P9                (0x1u <<  9) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P10               (0x1u << 10) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P11               (0x1u << 11) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P12               (0x1u << 12) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P13               (0x1u << 13) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P14               (0x1u << 14) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P15               (0x1u << 15) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P16               (0x1u << 16) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P17               (0x1u << 17) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P18               (0x1u << 18) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P19               (0x1u << 19) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P20               (0x1u << 20) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P21               (0x1u << 21) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P22               (0x1u << 22) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P23               (0x1u << 23) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P24               (0x1u << 24) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P25               (0x1u << 25) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P26               (0x1u << 26) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P27               (0x1u << 27) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P28               (0x1u << 28) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P29               (0x1u << 29) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P30               (0x1u << 30) /**< \brief (GPIO_GPER) GPIO Enable */
#define GPIO_GPER_P31               (0x1u << 31) /**< \brief (GPIO_GPER) GPIO Enable */
/* -------- GPIO_GPERS : (GPIO Offset: 0x004) Port GPIO Enable Register - Set -------- */
#define GPIO_GPERS_P0               (0x1u <<  0) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P1               (0x1u <<  1) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P2               (0x1u <<  2) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P3               (0x1u <<  3) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P4               (0x1u <<  4) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P5               (0x1u <<  5) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P6               (0x1u <<  6) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P7               (0x1u <<  7) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P8               (0x1u <<  8) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P9               (0x1u <<  9) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P10              (0x1u << 10) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P11              (0x1u << 11) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P12              (0x1u << 12) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P13              (0x1u << 13) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P14              (0x1u << 14) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P15              (0x1u << 15) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P16              (0x1u << 16) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P17              (0x1u << 17) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P18              (0x1u << 18) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P19              (0x1u << 19) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P20              (0x1u << 20) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P21              (0x1u << 21) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P22              (0x1u << 22) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P23              (0x1u << 23) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P24              (0x1u << 24) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P25              (0x1u << 25) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P26              (0x1u << 26) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P27              (0x1u << 27) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P28              (0x1u << 28) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P29              (0x1u << 29) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P30              (0x1u << 30) /**< \brief (GPIO_GPERS) GPIO Enable */
#define GPIO_GPERS_P31              (0x1u << 31) /**< \brief (GPIO_GPERS) GPIO Enable */
/* -------- GPIO_GPERC : (GPIO Offset: 0x008) Port GPIO Enable Register - Clear -------- */
#define GPIO_GPERC_P0               (0x1u <<  0) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P1               (0x1u <<  1) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P2               (0x1u <<  2) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P3               (0x1u <<  3) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P4               (0x1u <<  4) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P5               (0x1u <<  5) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P6               (0x1u <<  6) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P7               (0x1u <<  7) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P8               (0x1u <<  8) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P9               (0x1u <<  9) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P10              (0x1u << 10) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P11              (0x1u << 11) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P12              (0x1u << 12) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P13              (0x1u << 13) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P14              (0x1u << 14) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P15              (0x1u << 15) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P16              (0x1u << 16) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P17              (0x1u << 17) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P18              (0x1u << 18) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P19              (0x1u << 19) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P20              (0x1u << 20) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P21              (0x1u << 21) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P22              (0x1u << 22) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P23              (0x1u << 23) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P24              (0x1u << 24) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P25              (0x1u << 25) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P26              (0x1u << 26) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P27              (0x1u << 27) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P28              (0x1u << 28) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P29              (0x1u << 29) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P30              (0x1u << 30) /**< \brief (GPIO_GPERC) GPIO Enable */
#define GPIO_GPERC_P31              (0x1u << 31) /**< \brief (GPIO_GPERC) GPIO Enable */
/* -------- GPIO_GPERT : (GPIO Offset: 0x00C) Port GPIO Enable Register - Toggle -------- */
#define GPIO_GPERT_P0               (0x1u <<  0) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P1               (0x1u <<  1) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P2               (0x1u <<  2) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P3               (0x1u <<  3) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P4               (0x1u <<  4) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P5               (0x1u <<  5) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P6               (0x1u <<  6) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P7               (0x1u <<  7) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P8               (0x1u <<  8) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P9               (0x1u <<  9) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P10              (0x1u << 10) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P11              (0x1u << 11) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P12              (0x1u << 12) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P13              (0x1u << 13) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P14              (0x1u << 14) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P15              (0x1u << 15) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P16              (0x1u << 16) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P17              (0x1u << 17) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P18              (0x1u << 18) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P19              (0x1u << 19) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P20              (0x1u << 20) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P21              (0x1u << 21) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P22              (0x1u << 22) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P23              (0x1u << 23) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P24              (0x1u << 24) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P25              (0x1u << 25) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P26              (0x1u << 26) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P27              (0x1u << 27) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P28              (0x1u << 28) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P29              (0x1u << 29) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P30              (0x1u << 30) /**< \brief (GPIO_GPERT) GPIO Enable */
#define GPIO_GPERT_P31              (0x1u << 31) /**< \brief (GPIO_GPERT) GPIO Enable */
/* -------- GPIO_PMR0 : (GPIO Offset: 0x010) Port Peripheral Mux Register 0 -------- */
#define GPIO_PMR0_P0                (0x1u <<  0) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P1                (0x1u <<  1) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P2                (0x1u <<  2) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P3                (0x1u <<  3) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P4                (0x1u <<  4) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P5                (0x1u <<  5) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P6                (0x1u <<  6) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P7                (0x1u <<  7) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P8                (0x1u <<  8) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P9                (0x1u <<  9) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P10               (0x1u << 10) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P11               (0x1u << 11) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P12               (0x1u << 12) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P13               (0x1u << 13) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P14               (0x1u << 14) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P15               (0x1u << 15) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P16               (0x1u << 16) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P17               (0x1u << 17) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P18               (0x1u << 18) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P19               (0x1u << 19) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P20               (0x1u << 20) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P21               (0x1u << 21) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P22               (0x1u << 22) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P23               (0x1u << 23) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P24               (0x1u << 24) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P25               (0x1u << 25) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P26               (0x1u << 26) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P27               (0x1u << 27) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P28               (0x1u << 28) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P29               (0x1u << 29) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P30               (0x1u << 30) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0_P31               (0x1u << 31) /**< \brief (GPIO_PMR0) Peripheral Multiplexer Select bit 0 */
/* -------- GPIO_PMR0S : (GPIO Offset: 0x014) Port Peripheral Mux Register 0 - Set -------- */
#define GPIO_PMR0S_P0               (0x1u <<  0) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P1               (0x1u <<  1) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P2               (0x1u <<  2) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P3               (0x1u <<  3) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P4               (0x1u <<  4) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P5               (0x1u <<  5) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P6               (0x1u <<  6) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P7               (0x1u <<  7) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P8               (0x1u <<  8) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P9               (0x1u <<  9) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P10              (0x1u << 10) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P11              (0x1u << 11) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P12              (0x1u << 12) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P13              (0x1u << 13) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P14              (0x1u << 14) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P15              (0x1u << 15) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P16              (0x1u << 16) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P17              (0x1u << 17) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P18              (0x1u << 18) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P19              (0x1u << 19) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P20              (0x1u << 20) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P21              (0x1u << 21) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P22              (0x1u << 22) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P23              (0x1u << 23) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P24              (0x1u << 24) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P25              (0x1u << 25) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P26              (0x1u << 26) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P27              (0x1u << 27) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P28              (0x1u << 28) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P29              (0x1u << 29) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P30              (0x1u << 30) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0S_P31              (0x1u << 31) /**< \brief (GPIO_PMR0S) Peripheral Multiplexer Select bit 0 */
/* -------- GPIO_PMR0C : (GPIO Offset: 0x018) Port Peripheral Mux Register 0 - Clear -------- */
#define GPIO_PMR0C_P0               (0x1u <<  0) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P1               (0x1u <<  1) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P2               (0x1u <<  2) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P3               (0x1u <<  3) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P4               (0x1u <<  4) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P5               (0x1u <<  5) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P6               (0x1u <<  6) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P7               (0x1u <<  7) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P8               (0x1u <<  8) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P9               (0x1u <<  9) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P10              (0x1u << 10) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P11              (0x1u << 11) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P12              (0x1u << 12) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P13              (0x1u << 13) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P14              (0x1u << 14) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P15              (0x1u << 15) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P16              (0x1u << 16) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P17              (0x1u << 17) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P18              (0x1u << 18) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P19              (0x1u << 19) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P20              (0x1u << 20) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P21              (0x1u << 21) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P22              (0x1u << 22) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P23              (0x1u << 23) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P24              (0x1u << 24) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P25              (0x1u << 25) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P26              (0x1u << 26) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P27              (0x1u << 27) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P28              (0x1u << 28) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P29              (0x1u << 29) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P30              (0x1u << 30) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0C_P31              (0x1u << 31) /**< \brief (GPIO_PMR0C) Peripheral Multiplexer Select bit 0 */
/* -------- GPIO_PMR0T : (GPIO Offset: 0x01C) Port Peripheral Mux Register 0 - Toggle -------- */
#define GPIO_PMR0T_P0               (0x1u <<  0) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P1               (0x1u <<  1) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P2               (0x1u <<  2) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P3               (0x1u <<  3) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P4               (0x1u <<  4) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P5               (0x1u <<  5) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P6               (0x1u <<  6) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P7               (0x1u <<  7) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P8               (0x1u <<  8) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P9               (0x1u <<  9) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P10              (0x1u << 10) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P11              (0x1u << 11) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P12              (0x1u << 12) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P13              (0x1u << 13) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P14              (0x1u << 14) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P15              (0x1u << 15) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P16              (0x1u << 16) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P17              (0x1u << 17) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P18              (0x1u << 18) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P19              (0x1u << 19) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P20              (0x1u << 20) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P21              (0x1u << 21) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P22              (0x1u << 22) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P23              (0x1u << 23) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P24              (0x1u << 24) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P25              (0x1u << 25) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P26              (0x1u << 26) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P27              (0x1u << 27) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P28              (0x1u << 28) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P29              (0x1u << 29) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P30              (0x1u << 30) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
#define GPIO_PMR0T_P31              (0x1u << 31) /**< \brief (GPIO_PMR0T) Peripheral Multiplexer Select bit 0 */
/* -------- GPIO_PMR1 : (GPIO Offset: 0x020) Port Peripheral Mux Register 1 -------- */
#define GPIO_PMR1_P0                (0x1u <<  0) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P1                (0x1u <<  1) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P2                (0x1u <<  2) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P3                (0x1u <<  3) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P4                (0x1u <<  4) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P5                (0x1u <<  5) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P6                (0x1u <<  6) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P7                (0x1u <<  7) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P8                (0x1u <<  8) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P9                (0x1u <<  9) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P10               (0x1u << 10) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P11               (0x1u << 11) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P12               (0x1u << 12) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P13               (0x1u << 13) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P14               (0x1u << 14) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P15               (0x1u << 15) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P16               (0x1u << 16) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P17               (0x1u << 17) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P18               (0x1u << 18) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P19               (0x1u << 19) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P20               (0x1u << 20) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P21               (0x1u << 21) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P22               (0x1u << 22) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P23               (0x1u << 23) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P24               (0x1u << 24) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P25               (0x1u << 25) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P26               (0x1u << 26) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P27               (0x1u << 27) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P28               (0x1u << 28) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P29               (0x1u << 29) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P30               (0x1u << 30) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1_P31               (0x1u << 31) /**< \brief (GPIO_PMR1) Peripheral Multiplexer Select bit 1 */
/* -------- GPIO_PMR1S : (GPIO Offset: 0x024) Port Peripheral Mux Register 1 - Set -------- */
#define GPIO_PMR1S_P0               (0x1u <<  0) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P1               (0x1u <<  1) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P2               (0x1u <<  2) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P3               (0x1u <<  3) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P4               (0x1u <<  4) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P5               (0x1u <<  5) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P6               (0x1u <<  6) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P7               (0x1u <<  7) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P8               (0x1u <<  8) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P9               (0x1u <<  9) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P10              (0x1u << 10) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P11              (0x1u << 11) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P12              (0x1u << 12) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P13              (0x1u << 13) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P14              (0x1u << 14) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P15              (0x1u << 15) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P16              (0x1u << 16) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P17              (0x1u << 17) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P18              (0x1u << 18) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P19              (0x1u << 19) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P20              (0x1u << 20) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P21              (0x1u << 21) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P22              (0x1u << 22) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P23              (0x1u << 23) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P24              (0x1u << 24) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P25              (0x1u << 25) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P26              (0x1u << 26) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P27              (0x1u << 27) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P28              (0x1u << 28) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P29              (0x1u << 29) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P30              (0x1u << 30) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1S_P31              (0x1u << 31) /**< \brief (GPIO_PMR1S) Peripheral Multiplexer Select bit 1 */
/* -------- GPIO_PMR1C : (GPIO Offset: 0x028) Port Peripheral Mux Register 1 - Clear -------- */
#define GPIO_PMR1C_P0               (0x1u <<  0) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P1               (0x1u <<  1) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P2               (0x1u <<  2) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P3               (0x1u <<  3) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P4               (0x1u <<  4) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P5               (0x1u <<  5) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P6               (0x1u <<  6) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P7               (0x1u <<  7) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P8               (0x1u <<  8) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P9               (0x1u <<  9) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P10              (0x1u << 10) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P11              (0x1u << 11) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P12              (0x1u << 12) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P13              (0x1u << 13) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P14              (0x1u << 14) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P15              (0x1u << 15) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P16              (0x1u << 16) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P17              (0x1u << 17) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P18              (0x1u << 18) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P19              (0x1u << 19) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P20              (0x1u << 20) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P21              (0x1u << 21) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P22              (0x1u << 22) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P23              (0x1u << 23) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P24              (0x1u << 24) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P25              (0x1u << 25) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P26              (0x1u << 26) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P27              (0x1u << 27) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P28              (0x1u << 28) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P29              (0x1u << 29) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P30              (0x1u << 30) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1C_P31              (0x1u << 31) /**< \brief (GPIO_PMR1C) Peripheral Multiplexer Select bit 1 */
/* -------- GPIO_PMR1T : (GPIO Offset: 0x02C) Port Peripheral Mux Register 1 - Toggle -------- */
#define GPIO_PMR1T_P0               (0x1u <<  0) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P1               (0x1u <<  1) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P2               (0x1u <<  2) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P3               (0x1u <<  3) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P4               (0x1u <<  4) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P5               (0x1u <<  5) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P6               (0x1u <<  6) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P7               (0x1u <<  7) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P8               (0x1u <<  8) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P9               (0x1u <<  9) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P10              (0x1u << 10) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P11              (0x1u << 11) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P12              (0x1u << 12) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P13              (0x1u << 13) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P14              (0x1u << 14) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P15              (0x1u << 15) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P16              (0x1u << 16) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P17              (0x1u << 17) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P18              (0x1u << 18) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P19              (0x1u << 19) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P20              (0x1u << 20) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P21              (0x1u << 21) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P22              (0x1u << 22) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P23              (0x1u << 23) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P24              (0x1u << 24) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P25              (0x1u << 25) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P26              (0x1u << 26) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P27              (0x1u << 27) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P28              (0x1u << 28) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P29              (0x1u << 29) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P30              (0x1u << 30) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
#define GPIO_PMR1T_P31              (0x1u << 31) /**< \brief (GPIO_PMR1T) Peripheral Multiplexer Select bit 1 */
/* -------- GPIO_PMR2 : (GPIO Offset: 0x030) Port Peripheral Mux Register 2 -------- */
#define GPIO_PMR2_P0                (0x1u <<  0) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P1                (0x1u <<  1) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P2                (0x1u <<  2) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P3                (0x1u <<  3) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P4                (0x1u <<  4) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P5                (0x1u <<  5) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P6                (0x1u <<  6) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P7                (0x1u <<  7) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P8                (0x1u <<  8) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P9                (0x1u <<  9) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P10               (0x1u << 10) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P11               (0x1u << 11) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P12               (0x1u << 12) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P13               (0x1u << 13) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P14               (0x1u << 14) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P15               (0x1u << 15) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P16               (0x1u << 16) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P17               (0x1u << 17) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P18               (0x1u << 18) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P19               (0x1u << 19) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P20               (0x1u << 20) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P21               (0x1u << 21) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P22               (0x1u << 22) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P23               (0x1u << 23) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P24               (0x1u << 24) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P25               (0x1u << 25) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P26               (0x1u << 26) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P27               (0x1u << 27) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P28               (0x1u << 28) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P29               (0x1u << 29) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P30               (0x1u << 30) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2_P31               (0x1u << 31) /**< \brief (GPIO_PMR2) Peripheral Multiplexer Select bit 2 */
/* -------- GPIO_PMR2S : (GPIO Offset: 0x034) Port Peripheral Mux Register 2 - Set -------- */
#define GPIO_PMR2S_P0               (0x1u <<  0) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P1               (0x1u <<  1) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P2               (0x1u <<  2) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P3               (0x1u <<  3) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P4               (0x1u <<  4) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P5               (0x1u <<  5) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P6               (0x1u <<  6) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P7               (0x1u <<  7) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P8               (0x1u <<  8) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P9               (0x1u <<  9) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P10              (0x1u << 10) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P11              (0x1u << 11) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P12              (0x1u << 12) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P13              (0x1u << 13) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P14              (0x1u << 14) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P15              (0x1u << 15) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P16              (0x1u << 16) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P17              (0x1u << 17) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P18              (0x1u << 18) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P19              (0x1u << 19) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P20              (0x1u << 20) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P21              (0x1u << 21) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P22              (0x1u << 22) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P23              (0x1u << 23) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P24              (0x1u << 24) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P25              (0x1u << 25) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P26              (0x1u << 26) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P27              (0x1u << 27) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P28              (0x1u << 28) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P29              (0x1u << 29) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P30              (0x1u << 30) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2S_P31              (0x1u << 31) /**< \brief (GPIO_PMR2S) Peripheral Multiplexer Select bit 2 */
/* -------- GPIO_PMR2C : (GPIO Offset: 0x038) Port Peripheral Mux Register 2 - Clear -------- */
#define GPIO_PMR2C_P0               (0x1u <<  0) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P1               (0x1u <<  1) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P2               (0x1u <<  2) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P3               (0x1u <<  3) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P4               (0x1u <<  4) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P5               (0x1u <<  5) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P6               (0x1u <<  6) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P7               (0x1u <<  7) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P8               (0x1u <<  8) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P9               (0x1u <<  9) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P10              (0x1u << 10) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P11              (0x1u << 11) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P12              (0x1u << 12) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P13              (0x1u << 13) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P14              (0x1u << 14) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P15              (0x1u << 15) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P16              (0x1u << 16) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P17              (0x1u << 17) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P18              (0x1u << 18) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P19              (0x1u << 19) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P20              (0x1u << 20) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P21              (0x1u << 21) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P22              (0x1u << 22) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P23              (0x1u << 23) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P24              (0x1u << 24) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P25              (0x1u << 25) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P26              (0x1u << 26) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P27              (0x1u << 27) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P28              (0x1u << 28) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P29              (0x1u << 29) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P30              (0x1u << 30) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2C_P31              (0x1u << 31) /**< \brief (GPIO_PMR2C) Peripheral Multiplexer Select bit 2 */
/* -------- GPIO_PMR2T : (GPIO Offset: 0x03C) Port Peripheral Mux Register 2 - Toggle -------- */
#define GPIO_PMR2T_P0               (0x1u <<  0) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P1               (0x1u <<  1) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P2               (0x1u <<  2) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P3               (0x1u <<  3) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P4               (0x1u <<  4) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P5               (0x1u <<  5) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P6               (0x1u <<  6) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P7               (0x1u <<  7) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P8               (0x1u <<  8) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P9               (0x1u <<  9) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P10              (0x1u << 10) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P11              (0x1u << 11) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P12              (0x1u << 12) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P13              (0x1u << 13) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P14              (0x1u << 14) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P15              (0x1u << 15) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P16              (0x1u << 16) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P17              (0x1u << 17) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P18              (0x1u << 18) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P19              (0x1u << 19) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P20              (0x1u << 20) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P21              (0x1u << 21) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P22              (0x1u << 22) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P23              (0x1u << 23) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P24              (0x1u << 24) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P25              (0x1u << 25) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P26              (0x1u << 26) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P27              (0x1u << 27) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P28              (0x1u << 28) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P29              (0x1u << 29) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P30              (0x1u << 30) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
#define GPIO_PMR2T_P31              (0x1u << 31) /**< \brief (GPIO_PMR2T) Peripheral Multiplexer Select bit 2 */
/* -------- GPIO_ODER : (GPIO Offset: 0x040) Port Output Driver Enable Register -------- */
#define GPIO_ODER_P0                (0x1u <<  0) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P1                (0x1u <<  1) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P2                (0x1u <<  2) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P3                (0x1u <<  3) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P4                (0x1u <<  4) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P5                (0x1u <<  5) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P6                (0x1u <<  6) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P7                (0x1u <<  7) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P8                (0x1u <<  8) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P9                (0x1u <<  9) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P10               (0x1u << 10) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P11               (0x1u << 11) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P12               (0x1u << 12) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P13               (0x1u << 13) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P14               (0x1u << 14) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P15               (0x1u << 15) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P16               (0x1u << 16) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P17               (0x1u << 17) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P18               (0x1u << 18) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P19               (0x1u << 19) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P20               (0x1u << 20) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P21               (0x1u << 21) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P22               (0x1u << 22) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P23               (0x1u << 23) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P24               (0x1u << 24) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P25               (0x1u << 25) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P26               (0x1u << 26) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P27               (0x1u << 27) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P28               (0x1u << 28) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P29               (0x1u << 29) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P30               (0x1u << 30) /**< \brief (GPIO_ODER) Output Driver Enable */
#define GPIO_ODER_P31               (0x1u << 31) /**< \brief (GPIO_ODER) Output Driver Enable */
/* -------- GPIO_ODERS : (GPIO Offset: 0x044) Port Output Driver Enable Register - Set -------- */
#define GPIO_ODERS_P0               (0x1u <<  0) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P1               (0x1u <<  1) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P2               (0x1u <<  2) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P3               (0x1u <<  3) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P4               (0x1u <<  4) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P5               (0x1u <<  5) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P6               (0x1u <<  6) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P7               (0x1u <<  7) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P8               (0x1u <<  8) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P9               (0x1u <<  9) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P10              (0x1u << 10) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P11              (0x1u << 11) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P12              (0x1u << 12) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P13              (0x1u << 13) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P14              (0x1u << 14) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P15              (0x1u << 15) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P16              (0x1u << 16) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P17              (0x1u << 17) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P18              (0x1u << 18) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P19              (0x1u << 19) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P20              (0x1u << 20) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P21              (0x1u << 21) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P22              (0x1u << 22) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P23              (0x1u << 23) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P24              (0x1u << 24) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P25              (0x1u << 25) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P26              (0x1u << 26) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P27              (0x1u << 27) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P28              (0x1u << 28) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P29              (0x1u << 29) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P30              (0x1u << 30) /**< \brief (GPIO_ODERS) Output Driver Enable */
#define GPIO_ODERS_P31              (0x1u << 31) /**< \brief (GPIO_ODERS) Output Driver Enable */
/* -------- GPIO_ODERC : (GPIO Offset: 0x048) Port Output Driver Enable Register - Clear -------- */
#define GPIO_ODERC_P0               (0x1u <<  0) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P1               (0x1u <<  1) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P2               (0x1u <<  2) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P3               (0x1u <<  3) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P4               (0x1u <<  4) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P5               (0x1u <<  5) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P6               (0x1u <<  6) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P7               (0x1u <<  7) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P8               (0x1u <<  8) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P9               (0x1u <<  9) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P10              (0x1u << 10) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P11              (0x1u << 11) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P12              (0x1u << 12) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P13              (0x1u << 13) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P14              (0x1u << 14) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P15              (0x1u << 15) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P16              (0x1u << 16) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P17              (0x1u << 17) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P18              (0x1u << 18) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P19              (0x1u << 19) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P20              (0x1u << 20) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P21              (0x1u << 21) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P22              (0x1u << 22) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P23              (0x1u << 23) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P24              (0x1u << 24) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P25              (0x1u << 25) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P26              (0x1u << 26) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P27              (0x1u << 27) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P28              (0x1u << 28) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P29              (0x1u << 29) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P30              (0x1u << 30) /**< \brief (GPIO_ODERC) Output Driver Enable */
#define GPIO_ODERC_P31              (0x1u << 31) /**< \brief (GPIO_ODERC) Output Driver Enable */
/* -------- GPIO_ODERT : (GPIO Offset: 0x04C) Port Output Driver Enable Register - Toggle -------- */
#define GPIO_ODERT_P0               (0x1u <<  0) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P1               (0x1u <<  1) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P2               (0x1u <<  2) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P3               (0x1u <<  3) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P4               (0x1u <<  4) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P5               (0x1u <<  5) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P6               (0x1u <<  6) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P7               (0x1u <<  7) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P8               (0x1u <<  8) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P9               (0x1u <<  9) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P10              (0x1u << 10) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P11              (0x1u << 11) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P12              (0x1u << 12) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P13              (0x1u << 13) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P14              (0x1u << 14) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P15              (0x1u << 15) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P16              (0x1u << 16) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P17              (0x1u << 17) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P18              (0x1u << 18) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P19              (0x1u << 19) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P20              (0x1u << 20) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P21              (0x1u << 21) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P22              (0x1u << 22) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P23              (0x1u << 23) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P24              (0x1u << 24) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P25              (0x1u << 25) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P26              (0x1u << 26) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P27              (0x1u << 27) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P28              (0x1u << 28) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P29              (0x1u << 29) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P30              (0x1u << 30) /**< \brief (GPIO_ODERT) Output Driver Enable */
#define GPIO_ODERT_P31              (0x1u << 31) /**< \brief (GPIO_ODERT) Output Driver Enable */
/* -------- GPIO_OVR : (GPIO Offset: 0x050) Port Output Value Register -------- */
#define GPIO_OVR_P0                 (0x1u <<  0) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P1                 (0x1u <<  1) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P2                 (0x1u <<  2) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P3                 (0x1u <<  3) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P4                 (0x1u <<  4) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P5                 (0x1u <<  5) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P6                 (0x1u <<  6) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P7                 (0x1u <<  7) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P8                 (0x1u <<  8) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P9                 (0x1u <<  9) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P10                (0x1u << 10) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P11                (0x1u << 11) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P12                (0x1u << 12) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P13                (0x1u << 13) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P14                (0x1u << 14) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P15                (0x1u << 15) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P16                (0x1u << 16) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P17                (0x1u << 17) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P18                (0x1u << 18) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P19                (0x1u << 19) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P20                (0x1u << 20) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P21                (0x1u << 21) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P22                (0x1u << 22) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P23                (0x1u << 23) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P24                (0x1u << 24) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P25                (0x1u << 25) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P26                (0x1u << 26) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P27                (0x1u << 27) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P28                (0x1u << 28) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P29                (0x1u << 29) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P30                (0x1u << 30) /**< \brief (GPIO_OVR) Output Value */
#define GPIO_OVR_P31                (0x1u << 31) /**< \brief (GPIO_OVR) Output Value */
/* -------- GPIO_OVRS : (GPIO Offset: 0x054) Port Output Value Register - Set -------- */
#define GPIO_OVRS_P0                (0x1u <<  0) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P1                (0x1u <<  1) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P2                (0x1u <<  2) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P3                (0x1u <<  3) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P4                (0x1u <<  4) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P5                (0x1u <<  5) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P6                (0x1u <<  6) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P7                (0x1u <<  7) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P8                (0x1u <<  8) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P9                (0x1u <<  9) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P10               (0x1u << 10) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P11               (0x1u << 11) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P12               (0x1u << 12) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P13               (0x1u << 13) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P14               (0x1u << 14) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P15               (0x1u << 15) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P16               (0x1u << 16) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P17               (0x1u << 17) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P18               (0x1u << 18) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P19               (0x1u << 19) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P20               (0x1u << 20) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P21               (0x1u << 21) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P22               (0x1u << 22) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P23               (0x1u << 23) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P24               (0x1u << 24) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P25               (0x1u << 25) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P26               (0x1u << 26) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P27               (0x1u << 27) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P28               (0x1u << 28) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P29               (0x1u << 29) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P30               (0x1u << 30) /**< \brief (GPIO_OVRS) Output Value */
#define GPIO_OVRS_P31               (0x1u << 31) /**< \brief (GPIO_OVRS) Output Value */
/* -------- GPIO_OVRC : (GPIO Offset: 0x058) Port Output Value Register - Clear -------- */
#define GPIO_OVRC_P0                (0x1u <<  0) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P1                (0x1u <<  1) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P2                (0x1u <<  2) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P3                (0x1u <<  3) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P4                (0x1u <<  4) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P5                (0x1u <<  5) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P6                (0x1u <<  6) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P7                (0x1u <<  7) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P8                (0x1u <<  8) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P9                (0x1u <<  9) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P10               (0x1u << 10) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P11               (0x1u << 11) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P12               (0x1u << 12) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P13               (0x1u << 13) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P14               (0x1u << 14) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P15               (0x1u << 15) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P16               (0x1u << 16) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P17               (0x1u << 17) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P18               (0x1u << 18) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P19               (0x1u << 19) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P20               (0x1u << 20) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P21               (0x1u << 21) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P22               (0x1u << 22) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P23               (0x1u << 23) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P24               (0x1u << 24) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P25               (0x1u << 25) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P26               (0x1u << 26) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P27               (0x1u << 27) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P28               (0x1u << 28) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P29               (0x1u << 29) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P30               (0x1u << 30) /**< \brief (GPIO_OVRC) Output Value */
#define GPIO_OVRC_P31               (0x1u << 31) /**< \brief (GPIO_OVRC) Output Value */
/* -------- GPIO_OVRT : (GPIO Offset: 0x05C) Port Output Value Register - Toggle -------- */
#define GPIO_OVRT_P0                (0x1u <<  0) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P1                (0x1u <<  1) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P2                (0x1u <<  2) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P3                (0x1u <<  3) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P4                (0x1u <<  4) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P5                (0x1u <<  5) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P6                (0x1u <<  6) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P7                (0x1u <<  7) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P8                (0x1u <<  8) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P9                (0x1u <<  9) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P10               (0x1u << 10) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P11               (0x1u << 11) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P12               (0x1u << 12) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P13               (0x1u << 13) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P14               (0x1u << 14) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P15               (0x1u << 15) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P16               (0x1u << 16) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P17               (0x1u << 17) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P18               (0x1u << 18) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P19               (0x1u << 19) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P20               (0x1u << 20) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P21               (0x1u << 21) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P22               (0x1u << 22) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P23               (0x1u << 23) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P24               (0x1u << 24) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P25               (0x1u << 25) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P26               (0x1u << 26) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P27               (0x1u << 27) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P28               (0x1u << 28) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P29               (0x1u << 29) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P30               (0x1u << 30) /**< \brief (GPIO_OVRT) Output Value */
#define GPIO_OVRT_P31               (0x1u << 31) /**< \brief (GPIO_OVRT) Output Value */
/* -------- GPIO_PVR : (GPIO Offset: 0x060) Port Pin Value Register -------- */
#define GPIO_PVR_P0                 (0x1u <<  0) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P1                 (0x1u <<  1) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P2                 (0x1u <<  2) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P3                 (0x1u <<  3) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P4                 (0x1u <<  4) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P5                 (0x1u <<  5) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P6                 (0x1u <<  6) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P7                 (0x1u <<  7) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P8                 (0x1u <<  8) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P9                 (0x1u <<  9) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P10                (0x1u << 10) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P11                (0x1u << 11) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P12                (0x1u << 12) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P13                (0x1u << 13) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P14                (0x1u << 14) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P15                (0x1u << 15) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P16                (0x1u << 16) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P17                (0x1u << 17) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P18                (0x1u << 18) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P19                (0x1u << 19) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P20                (0x1u << 20) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P21                (0x1u << 21) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P22                (0x1u << 22) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P23                (0x1u << 23) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P24                (0x1u << 24) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P25                (0x1u << 25) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P26                (0x1u << 26) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P27                (0x1u << 27) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P28                (0x1u << 28) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P29                (0x1u << 29) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P30                (0x1u << 30) /**< \brief (GPIO_PVR) Pin Value */
#define GPIO_PVR_P31                (0x1u << 31) /**< \brief (GPIO_PVR) Pin Value */
/* -------- GPIO_PUER : (GPIO Offset: 0x070) Port Pull-up Enable Register -------- */
#define GPIO_PUER_P0                (0x1u <<  0) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P1                (0x1u <<  1) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P2                (0x1u <<  2) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P3                (0x1u <<  3) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P4                (0x1u <<  4) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P5                (0x1u <<  5) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P6                (0x1u <<  6) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P7                (0x1u <<  7) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P8                (0x1u <<  8) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P9                (0x1u <<  9) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P10               (0x1u << 10) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P11               (0x1u << 11) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P12               (0x1u << 12) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P13               (0x1u << 13) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P14               (0x1u << 14) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P15               (0x1u << 15) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P16               (0x1u << 16) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P17               (0x1u << 17) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P18               (0x1u << 18) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P19               (0x1u << 19) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P20               (0x1u << 20) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P21               (0x1u << 21) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P22               (0x1u << 22) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P23               (0x1u << 23) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P24               (0x1u << 24) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P25               (0x1u << 25) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P26               (0x1u << 26) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P27               (0x1u << 27) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P28               (0x1u << 28) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P29               (0x1u << 29) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P30               (0x1u << 30) /**< \brief (GPIO_PUER) Pull-up Enable */
#define GPIO_PUER_P31               (0x1u << 31) /**< \brief (GPIO_PUER) Pull-up Enable */
/* -------- GPIO_PUERS : (GPIO Offset: 0x074) Port Pull-up Enable Register - Set -------- */
#define GPIO_PUERS_P0               (0x1u <<  0) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P1               (0x1u <<  1) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P2               (0x1u <<  2) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P3               (0x1u <<  3) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P4               (0x1u <<  4) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P5               (0x1u <<  5) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P6               (0x1u <<  6) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P7               (0x1u <<  7) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P8               (0x1u <<  8) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P9               (0x1u <<  9) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P10              (0x1u << 10) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P11              (0x1u << 11) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P12              (0x1u << 12) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P13              (0x1u << 13) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P14              (0x1u << 14) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P15              (0x1u << 15) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P16              (0x1u << 16) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P17              (0x1u << 17) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P18              (0x1u << 18) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P19              (0x1u << 19) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P20              (0x1u << 20) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P21              (0x1u << 21) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P22              (0x1u << 22) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P23              (0x1u << 23) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P24              (0x1u << 24) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P25              (0x1u << 25) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P26              (0x1u << 26) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P27              (0x1u << 27) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P28              (0x1u << 28) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P29              (0x1u << 29) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P30              (0x1u << 30) /**< \brief (GPIO_PUERS) Pull-up Enable */
#define GPIO_PUERS_P31              (0x1u << 31) /**< \brief (GPIO_PUERS) Pull-up Enable */
/* -------- GPIO_PUERC : (GPIO Offset: 0x078) Port Pull-up Enable Register - Clear -------- */
#define GPIO_PUERC_P0               (0x1u <<  0) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P1               (0x1u <<  1) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P2               (0x1u <<  2) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P3               (0x1u <<  3) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P4               (0x1u <<  4) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P5               (0x1u <<  5) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P6               (0x1u <<  6) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P7               (0x1u <<  7) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P8               (0x1u <<  8) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P9               (0x1u <<  9) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P10              (0x1u << 10) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P11              (0x1u << 11) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P12              (0x1u << 12) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P13              (0x1u << 13) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P14              (0x1u << 14) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P15              (0x1u << 15) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P16              (0x1u << 16) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P17              (0x1u << 17) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P18              (0x1u << 18) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P19              (0x1u << 19) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P20              (0x1u << 20) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P21              (0x1u << 21) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P22              (0x1u << 22) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P23              (0x1u << 23) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P24              (0x1u << 24) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P25              (0x1u << 25) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P26              (0x1u << 26) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P27              (0x1u << 27) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P28              (0x1u << 28) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P29              (0x1u << 29) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P30              (0x1u << 30) /**< \brief (GPIO_PUERC) Pull-up Enable */
#define GPIO_PUERC_P31              (0x1u << 31) /**< \brief (GPIO_PUERC) Pull-up Enable */
/* -------- GPIO_PUERT : (GPIO Offset: 0x07C) Port Pull-up Enable Register - Toggle -------- */
#define GPIO_PUERT_P0               (0x1u <<  0) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P1               (0x1u <<  1) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P2               (0x1u <<  2) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P3               (0x1u <<  3) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P4               (0x1u <<  4) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P5               (0x1u <<  5) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P6               (0x1u <<  6) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P7               (0x1u <<  7) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P8               (0x1u <<  8) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P9               (0x1u <<  9) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P10              (0x1u << 10) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P11              (0x1u << 11) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P12              (0x1u << 12) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P13              (0x1u << 13) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P14              (0x1u << 14) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P15              (0x1u << 15) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P16              (0x1u << 16) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P17              (0x1u << 17) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P18              (0x1u << 18) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P19              (0x1u << 19) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P20              (0x1u << 20) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P21              (0x1u << 21) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P22              (0x1u << 22) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P23              (0x1u << 23) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P24              (0x1u << 24) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P25              (0x1u << 25) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P26              (0x1u << 26) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P27              (0x1u << 27) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P28              (0x1u << 28) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P29              (0x1u << 29) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P30              (0x1u << 30) /**< \brief (GPIO_PUERT) Pull-up Enable */
#define GPIO_PUERT_P31              (0x1u << 31) /**< \brief (GPIO_PUERT) Pull-up Enable */
/* -------- GPIO_PDER : (GPIO Offset: 0x080) Port Pull-down Enable Register -------- */
#define GPIO_PDER_P0                (0x1u <<  0) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P1                (0x1u <<  1) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P2                (0x1u <<  2) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P3                (0x1u <<  3) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P4                (0x1u <<  4) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P5                (0x1u <<  5) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P6                (0x1u <<  6) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P7                (0x1u <<  7) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P8                (0x1u <<  8) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P9                (0x1u <<  9) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P10               (0x1u << 10) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P11               (0x1u << 11) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P12               (0x1u << 12) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P13               (0x1u << 13) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P14               (0x1u << 14) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P15               (0x1u << 15) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P16               (0x1u << 16) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P17               (0x1u << 17) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P18               (0x1u << 18) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P19               (0x1u << 19) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P20               (0x1u << 20) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P21               (0x1u << 21) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P22               (0x1u << 22) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P23               (0x1u << 23) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P24               (0x1u << 24) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P25               (0x1u << 25) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P26               (0x1u << 26) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P27               (0x1u << 27) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P28               (0x1u << 28) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P29               (0x1u << 29) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P30               (0x1u << 30) /**< \brief (GPIO_PDER) Pull-down Enable */
#define GPIO_PDER_P31               (0x1u << 31) /**< \brief (GPIO_PDER) Pull-down Enable */
/* -------- GPIO_PDERS : (GPIO Offset: 0x084) Port Pull-down Enable Register - Set -------- */
#define GPIO_PDERS_P0               (0x1u <<  0) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P1               (0x1u <<  1) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P2               (0x1u <<  2) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P3               (0x1u <<  3) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P4               (0x1u <<  4) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P5               (0x1u <<  5) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P6               (0x1u <<  6) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P7               (0x1u <<  7) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P8               (0x1u <<  8) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P9               (0x1u <<  9) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P10              (0x1u << 10) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P11              (0x1u << 11) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P12              (0x1u << 12) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P13              (0x1u << 13) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P14              (0x1u << 14) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P15              (0x1u << 15) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P16              (0x1u << 16) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P17              (0x1u << 17) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P18              (0x1u << 18) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P19              (0x1u << 19) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P20              (0x1u << 20) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P21              (0x1u << 21) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P22              (0x1u << 22) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P23              (0x1u << 23) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P24              (0x1u << 24) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P25              (0x1u << 25) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P26              (0x1u << 26) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P27              (0x1u << 27) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P28              (0x1u << 28) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P29              (0x1u << 29) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P30              (0x1u << 30) /**< \brief (GPIO_PDERS) Pull-down Enable */
#define GPIO_PDERS_P31              (0x1u << 31) /**< \brief (GPIO_PDERS) Pull-down Enable */
/* -------- GPIO_PDERC : (GPIO Offset: 0x088) Port Pull-down Enable Register - Clear -------- */
#define GPIO_PDERC_P0               (0x1u <<  0) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P1               (0x1u <<  1) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P2               (0x1u <<  2) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P3               (0x1u <<  3) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P4               (0x1u <<  4) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P5               (0x1u <<  5) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P6               (0x1u <<  6) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P7               (0x1u <<  7) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P8               (0x1u <<  8) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P9               (0x1u <<  9) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P10              (0x1u << 10) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P11              (0x1u << 11) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P12              (0x1u << 12) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P13              (0x1u << 13) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P14              (0x1u << 14) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P15              (0x1u << 15) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P16              (0x1u << 16) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P17              (0x1u << 17) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P18              (0x1u << 18) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P19              (0x1u << 19) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P20              (0x1u << 20) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P21              (0x1u << 21) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P22              (0x1u << 22) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P23              (0x1u << 23) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P24              (0x1u << 24) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P25              (0x1u << 25) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P26              (0x1u << 26) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P27              (0x1u << 27) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P28              (0x1u << 28) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P29              (0x1u << 29) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P30              (0x1u << 30) /**< \brief (GPIO_PDERC) Pull-down Enable */
#define GPIO_PDERC_P31              (0x1u << 31) /**< \brief (GPIO_PDERC) Pull-down Enable */
/* -------- GPIO_PDERT : (GPIO Offset: 0x08C) Port Pull-down Enable Register - Toggle -------- */
#define GPIO_PDERT_P0               (0x1u <<  0) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P1               (0x1u <<  1) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P2               (0x1u <<  2) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P3               (0x1u <<  3) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P4               (0x1u <<  4) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P5               (0x1u <<  5) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P6               (0x1u <<  6) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P7               (0x1u <<  7) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P8               (0x1u <<  8) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P9               (0x1u <<  9) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P10              (0x1u << 10) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P11              (0x1u << 11) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P12              (0x1u << 12) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P13              (0x1u << 13) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P14              (0x1u << 14) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P15              (0x1u << 15) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P16              (0x1u << 16) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P17              (0x1u << 17) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P18              (0x1u << 18) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P19              (0x1u << 19) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P20              (0x1u << 20) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P21              (0x1u << 21) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P22              (0x1u << 22) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P23              (0x1u << 23) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P24              (0x1u << 24) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P25              (0x1u << 25) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P26              (0x1u << 26) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P27              (0x1u << 27) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P28              (0x1u << 28) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P29              (0x1u << 29) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P30              (0x1u << 30) /**< \brief (GPIO_PDERT) Pull-down Enable */
#define GPIO_PDERT_P31              (0x1u << 31) /**< \brief (GPIO_PDERT) Pull-down Enable */
/* -------- GPIO_IER : (GPIO Offset: 0x090) Port Interrupt Enable Register -------- */
#define GPIO_IER_P0                 (0x1u <<  0) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P1                 (0x1u <<  1) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P2                 (0x1u <<  2) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P3                 (0x1u <<  3) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P4                 (0x1u <<  4) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P5                 (0x1u <<  5) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P6                 (0x1u <<  6) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P7                 (0x1u <<  7) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P8                 (0x1u <<  8) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P9                 (0x1u <<  9) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P10                (0x1u << 10) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P11                (0x1u << 11) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P12                (0x1u << 12) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P13                (0x1u << 13) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P14                (0x1u << 14) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P15                (0x1u << 15) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P16                (0x1u << 16) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P17                (0x1u << 17) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P18                (0x1u << 18) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P19                (0x1u << 19) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P20                (0x1u << 20) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P21                (0x1u << 21) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P22                (0x1u << 22) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P23                (0x1u << 23) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P24                (0x1u << 24) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P25                (0x1u << 25) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P26                (0x1u << 26) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P27                (0x1u << 27) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P28                (0x1u << 28) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P29                (0x1u << 29) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P30                (0x1u << 30) /**< \brief (GPIO_IER) Interrupt Enable */
#define GPIO_IER_P31                (0x1u << 31) /**< \brief (GPIO_IER) Interrupt Enable */
/* -------- GPIO_IERS : (GPIO Offset: 0x094) Port Interrupt Enable Register - Set -------- */
#define GPIO_IERS_P0                (0x1u <<  0) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P1                (0x1u <<  1) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P2                (0x1u <<  2) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P3                (0x1u <<  3) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P4                (0x1u <<  4) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P5                (0x1u <<  5) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P6                (0x1u <<  6) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P7                (0x1u <<  7) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P8                (0x1u <<  8) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P9                (0x1u <<  9) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P10               (0x1u << 10) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P11               (0x1u << 11) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P12               (0x1u << 12) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P13               (0x1u << 13) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P14               (0x1u << 14) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P15               (0x1u << 15) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P16               (0x1u << 16) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P17               (0x1u << 17) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P18               (0x1u << 18) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P19               (0x1u << 19) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P20               (0x1u << 20) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P21               (0x1u << 21) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P22               (0x1u << 22) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P23               (0x1u << 23) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P24               (0x1u << 24) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P25               (0x1u << 25) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P26               (0x1u << 26) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P27               (0x1u << 27) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P28               (0x1u << 28) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P29               (0x1u << 29) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P30               (0x1u << 30) /**< \brief (GPIO_IERS) Interrupt Enable */
#define GPIO_IERS_P31               (0x1u << 31) /**< \brief (GPIO_IERS) Interrupt Enable */
/* -------- GPIO_IERC : (GPIO Offset: 0x098) Port Interrupt Enable Register - Clear -------- */
#define GPIO_IERC_P0                (0x1u <<  0) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P1                (0x1u <<  1) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P2                (0x1u <<  2) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P3                (0x1u <<  3) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P4                (0x1u <<  4) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P5                (0x1u <<  5) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P6                (0x1u <<  6) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P7                (0x1u <<  7) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P8                (0x1u <<  8) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P9                (0x1u <<  9) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P10               (0x1u << 10) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P11               (0x1u << 11) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P12               (0x1u << 12) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P13               (0x1u << 13) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P14               (0x1u << 14) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P15               (0x1u << 15) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P16               (0x1u << 16) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P17               (0x1u << 17) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P18               (0x1u << 18) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P19               (0x1u << 19) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P20               (0x1u << 20) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P21               (0x1u << 21) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P22               (0x1u << 22) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P23               (0x1u << 23) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P24               (0x1u << 24) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P25               (0x1u << 25) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P26               (0x1u << 26) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P27               (0x1u << 27) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P28               (0x1u << 28) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P29               (0x1u << 29) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P30               (0x1u << 30) /**< \brief (GPIO_IERC) Interrupt Enable */
#define GPIO_IERC_P31               (0x1u << 31) /**< \brief (GPIO_IERC) Interrupt Enable */
/* -------- GPIO_IERT : (GPIO Offset: 0x09C) Port Interrupt Enable Register - Toggle -------- */
#define GPIO_IERT_P0                (0x1u <<  0) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P1                (0x1u <<  1) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P2                (0x1u <<  2) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P3                (0x1u <<  3) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P4                (0x1u <<  4) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P5                (0x1u <<  5) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P6                (0x1u <<  6) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P7                (0x1u <<  7) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P8                (0x1u <<  8) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P9                (0x1u <<  9) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P10               (0x1u << 10) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P11               (0x1u << 11) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P12               (0x1u << 12) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P13               (0x1u << 13) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P14               (0x1u << 14) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P15               (0x1u << 15) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P16               (0x1u << 16) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P17               (0x1u << 17) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P18               (0x1u << 18) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P19               (0x1u << 19) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P20               (0x1u << 20) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P21               (0x1u << 21) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P22               (0x1u << 22) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P23               (0x1u << 23) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P24               (0x1u << 24) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P25               (0x1u << 25) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P26               (0x1u << 26) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P27               (0x1u << 27) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P28               (0x1u << 28) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P29               (0x1u << 29) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P30               (0x1u << 30) /**< \brief (GPIO_IERT) Interrupt Enable */
#define GPIO_IERT_P31               (0x1u << 31) /**< \brief (GPIO_IERT) Interrupt Enable */
/* -------- GPIO_IMR0 : (GPIO Offset: 0x0A0) Port Interrupt Mode Register 0 -------- */
#define GPIO_IMR0_P0                (0x1u <<  0) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P1                (0x1u <<  1) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P2                (0x1u <<  2) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P3                (0x1u <<  3) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P4                (0x1u <<  4) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P5                (0x1u <<  5) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P6                (0x1u <<  6) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P7                (0x1u <<  7) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P8                (0x1u <<  8) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P9                (0x1u <<  9) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P10               (0x1u << 10) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P11               (0x1u << 11) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P12               (0x1u << 12) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P13               (0x1u << 13) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P14               (0x1u << 14) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P15               (0x1u << 15) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P16               (0x1u << 16) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P17               (0x1u << 17) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P18               (0x1u << 18) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P19               (0x1u << 19) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P20               (0x1u << 20) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P21               (0x1u << 21) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P22               (0x1u << 22) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P23               (0x1u << 23) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P24               (0x1u << 24) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P25               (0x1u << 25) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P26               (0x1u << 26) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P27               (0x1u << 27) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P28               (0x1u << 28) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P29               (0x1u << 29) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P30               (0x1u << 30) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
#define GPIO_IMR0_P31               (0x1u << 31) /**< \brief (GPIO_IMR0) Interrupt Mode Bit 0 */
/* -------- GPIO_IMR0S : (GPIO Offset: 0x0A4) Port Interrupt Mode Register 0 - Set -------- */
#define GPIO_IMR0S_P0               (0x1u <<  0) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P1               (0x1u <<  1) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P2               (0x1u <<  2) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P3               (0x1u <<  3) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P4               (0x1u <<  4) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P5               (0x1u <<  5) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P6               (0x1u <<  6) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P7               (0x1u <<  7) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P8               (0x1u <<  8) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P9               (0x1u <<  9) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P10              (0x1u << 10) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P11              (0x1u << 11) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P12              (0x1u << 12) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P13              (0x1u << 13) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P14              (0x1u << 14) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P15              (0x1u << 15) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P16              (0x1u << 16) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P17              (0x1u << 17) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P18              (0x1u << 18) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P19              (0x1u << 19) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P20              (0x1u << 20) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P21              (0x1u << 21) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P22              (0x1u << 22) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P23              (0x1u << 23) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P24              (0x1u << 24) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P25              (0x1u << 25) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P26              (0x1u << 26) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P27              (0x1u << 27) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P28              (0x1u << 28) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P29              (0x1u << 29) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P30              (0x1u << 30) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
#define GPIO_IMR0S_P31              (0x1u << 31) /**< \brief (GPIO_IMR0S) Interrupt Mode Bit 0 */
/* -------- GPIO_IMR0C : (GPIO Offset: 0x0A8) Port Interrupt Mode Register 0 - Clear -------- */
#define GPIO_IMR0C_P0               (0x1u <<  0) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P1               (0x1u <<  1) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P2               (0x1u <<  2) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P3               (0x1u <<  3) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P4               (0x1u <<  4) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P5               (0x1u <<  5) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P6               (0x1u <<  6) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P7               (0x1u <<  7) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P8               (0x1u <<  8) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P9               (0x1u <<  9) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P10              (0x1u << 10) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P11              (0x1u << 11) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P12              (0x1u << 12) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P13              (0x1u << 13) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P14              (0x1u << 14) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P15              (0x1u << 15) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P16              (0x1u << 16) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P17              (0x1u << 17) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P18              (0x1u << 18) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P19              (0x1u << 19) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P20              (0x1u << 20) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P21              (0x1u << 21) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P22              (0x1u << 22) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P23              (0x1u << 23) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P24              (0x1u << 24) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P25              (0x1u << 25) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P26              (0x1u << 26) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P27              (0x1u << 27) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P28              (0x1u << 28) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P29              (0x1u << 29) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P30              (0x1u << 30) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
#define GPIO_IMR0C_P31              (0x1u << 31) /**< \brief (GPIO_IMR0C) Interrupt Mode Bit 0 */
/* -------- GPIO_IMR0T : (GPIO Offset: 0x0AC) Port Interrupt Mode Register 0 - Toggle -------- */
#define GPIO_IMR0T_P0               (0x1u <<  0) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P1               (0x1u <<  1) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P2               (0x1u <<  2) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P3               (0x1u <<  3) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P4               (0x1u <<  4) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P5               (0x1u <<  5) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P6               (0x1u <<  6) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P7               (0x1u <<  7) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P8               (0x1u <<  8) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P9               (0x1u <<  9) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P10              (0x1u << 10) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P11              (0x1u << 11) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P12              (0x1u << 12) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P13              (0x1u << 13) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P14              (0x1u << 14) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P15              (0x1u << 15) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P16              (0x1u << 16) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P17              (0x1u << 17) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P18              (0x1u << 18) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P19              (0x1u << 19) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P20              (0x1u << 20) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P21              (0x1u << 21) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P22              (0x1u << 22) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P23              (0x1u << 23) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P24              (0x1u << 24) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P25              (0x1u << 25) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P26              (0x1u << 26) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P27              (0x1u << 27) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P28              (0x1u << 28) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P29              (0x1u << 29) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P30              (0x1u << 30) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
#define GPIO_IMR0T_P31              (0x1u << 31) /**< \brief (GPIO_IMR0T) Interrupt Mode Bit 0 */
/* -------- GPIO_IMR1 : (GPIO Offset: 0x0B0) Port Interrupt Mode Register 1 -------- */
#define GPIO_IMR1_P0                (0x1u <<  0) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P1                (0x1u <<  1) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P2                (0x1u <<  2) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P3                (0x1u <<  3) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P4                (0x1u <<  4) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P5                (0x1u <<  5) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P6                (0x1u <<  6) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P7                (0x1u <<  7) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P8                (0x1u <<  8) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P9                (0x1u <<  9) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P10               (0x1u << 10) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P11               (0x1u << 11) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P12               (0x1u << 12) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P13               (0x1u << 13) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P14               (0x1u << 14) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P15               (0x1u << 15) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P16               (0x1u << 16) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P17               (0x1u << 17) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P18               (0x1u << 18) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P19               (0x1u << 19) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P20               (0x1u << 20) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P21               (0x1u << 21) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P22               (0x1u << 22) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P23               (0x1u << 23) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P24               (0x1u << 24) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P25               (0x1u << 25) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P26               (0x1u << 26) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P27               (0x1u << 27) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P28               (0x1u << 28) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P29               (0x1u << 29) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P30               (0x1u << 30) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
#define GPIO_IMR1_P31               (0x1u << 31) /**< \brief (GPIO_IMR1) Interrupt Mode Bit 1 */
/* -------- GPIO_IMR1S : (GPIO Offset: 0x0B4) Port Interrupt Mode Register 1 - Set -------- */
#define GPIO_IMR1S_P0               (0x1u <<  0) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P1               (0x1u <<  1) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P2               (0x1u <<  2) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P3               (0x1u <<  3) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P4               (0x1u <<  4) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P5               (0x1u <<  5) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P6               (0x1u <<  6) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P7               (0x1u <<  7) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P8               (0x1u <<  8) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P9               (0x1u <<  9) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P10              (0x1u << 10) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P11              (0x1u << 11) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P12              (0x1u << 12) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P13              (0x1u << 13) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P14              (0x1u << 14) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P15              (0x1u << 15) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P16              (0x1u << 16) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P17              (0x1u << 17) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P18              (0x1u << 18) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P19              (0x1u << 19) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P20              (0x1u << 20) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P21              (0x1u << 21) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P22              (0x1u << 22) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P23              (0x1u << 23) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P24              (0x1u << 24) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P25              (0x1u << 25) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P26              (0x1u << 26) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P27              (0x1u << 27) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P28              (0x1u << 28) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P29              (0x1u << 29) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P30              (0x1u << 30) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
#define GPIO_IMR1S_P31              (0x1u << 31) /**< \brief (GPIO_IMR1S) Interrupt Mode Bit 1 */
/* -------- GPIO_IMR1C : (GPIO Offset: 0x0B8) Port Interrupt Mode Register 1 - Clear -------- */
#define GPIO_IMR1C_P0               (0x1u <<  0) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P1               (0x1u <<  1) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P2               (0x1u <<  2) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P3               (0x1u <<  3) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P4               (0x1u <<  4) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P5               (0x1u <<  5) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P6               (0x1u <<  6) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P7               (0x1u <<  7) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P8               (0x1u <<  8) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P9               (0x1u <<  9) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P10              (0x1u << 10) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P11              (0x1u << 11) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P12              (0x1u << 12) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P13              (0x1u << 13) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P14              (0x1u << 14) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P15              (0x1u << 15) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P16              (0x1u << 16) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P17              (0x1u << 17) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P18              (0x1u << 18) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P19              (0x1u << 19) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P20              (0x1u << 20) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P21              (0x1u << 21) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P22              (0x1u << 22) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P23              (0x1u << 23) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P24              (0x1u << 24) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P25              (0x1u << 25) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P26              (0x1u << 26) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P27              (0x1u << 27) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P28              (0x1u << 28) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P29              (0x1u << 29) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P30              (0x1u << 30) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
#define GPIO_IMR1C_P31              (0x1u << 31) /**< \brief (GPIO_IMR1C) Interrupt Mode Bit 1 */
/* -------- GPIO_IMR1T : (GPIO Offset: 0x0BC) Port Interrupt Mode Register 1 - Toggle -------- */
#define GPIO_IMR1T_P0               (0x1u <<  0) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P1               (0x1u <<  1) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P2               (0x1u <<  2) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P3               (0x1u <<  3) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P4               (0x1u <<  4) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P5               (0x1u <<  5) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P6               (0x1u <<  6) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P7               (0x1u <<  7) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P8               (0x1u <<  8) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P9               (0x1u <<  9) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P10              (0x1u << 10) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P11              (0x1u << 11) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P12              (0x1u << 12) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P13              (0x1u << 13) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P14              (0x1u << 14) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P15              (0x1u << 15) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P16              (0x1u << 16) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P17              (0x1u << 17) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P18              (0x1u << 18) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P19              (0x1u << 19) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P20              (0x1u << 20) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P21              (0x1u << 21) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P22              (0x1u << 22) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P23              (0x1u << 23) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P24              (0x1u << 24) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P25              (0x1u << 25) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P26              (0x1u << 26) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P27              (0x1u << 27) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P28              (0x1u << 28) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P29              (0x1u << 29) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P30              (0x1u << 30) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
#define GPIO_IMR1T_P31              (0x1u << 31) /**< \brief (GPIO_IMR1T) Interrupt Mode Bit 1 */
/* -------- GPIO_GFER : (GPIO Offset: 0x0C0) Port Glitch Filter Enable Register -------- */
#define GPIO_GFER_P0                (0x1u <<  0) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P1                (0x1u <<  1) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P2                (0x1u <<  2) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P3                (0x1u <<  3) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P4                (0x1u <<  4) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P5                (0x1u <<  5) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P6                (0x1u <<  6) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P7                (0x1u <<  7) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P8                (0x1u <<  8) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P9                (0x1u <<  9) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P10               (0x1u << 10) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P11               (0x1u << 11) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P12               (0x1u << 12) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P13               (0x1u << 13) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P14               (0x1u << 14) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P15               (0x1u << 15) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P16               (0x1u << 16) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P17               (0x1u << 17) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P18               (0x1u << 18) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P19               (0x1u << 19) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P20               (0x1u << 20) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P21               (0x1u << 21) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P22               (0x1u << 22) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P23               (0x1u << 23) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P24               (0x1u << 24) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P25               (0x1u << 25) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P26               (0x1u << 26) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P27               (0x1u << 27) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P28               (0x1u << 28) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P29               (0x1u << 29) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P30               (0x1u << 30) /**< \brief (GPIO_GFER) Glitch Filter Enable */
#define GPIO_GFER_P31               (0x1u << 31) /**< \brief (GPIO_GFER) Glitch Filter Enable */
/* -------- GPIO_GFERS : (GPIO Offset: 0x0C4) Port Glitch Filter Enable Register - Set -------- */
#define GPIO_GFERS_P0               (0x1u <<  0) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P1               (0x1u <<  1) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P2               (0x1u <<  2) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P3               (0x1u <<  3) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P4               (0x1u <<  4) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P5               (0x1u <<  5) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P6               (0x1u <<  6) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P7               (0x1u <<  7) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P8               (0x1u <<  8) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P9               (0x1u <<  9) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P10              (0x1u << 10) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P11              (0x1u << 11) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P12              (0x1u << 12) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P13              (0x1u << 13) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P14              (0x1u << 14) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P15              (0x1u << 15) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P16              (0x1u << 16) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P17              (0x1u << 17) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P18              (0x1u << 18) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P19              (0x1u << 19) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P20              (0x1u << 20) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P21              (0x1u << 21) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P22              (0x1u << 22) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P23              (0x1u << 23) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P24              (0x1u << 24) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P25              (0x1u << 25) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P26              (0x1u << 26) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P27              (0x1u << 27) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P28              (0x1u << 28) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P29              (0x1u << 29) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P30              (0x1u << 30) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
#define GPIO_GFERS_P31              (0x1u << 31) /**< \brief (GPIO_GFERS) Glitch Filter Enable */
/* -------- GPIO_GFERC : (GPIO Offset: 0x0C8) Port Glitch Filter Enable Register - Clear -------- */
#define GPIO_GFERC_P0               (0x1u <<  0) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P1               (0x1u <<  1) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P2               (0x1u <<  2) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P3               (0x1u <<  3) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P4               (0x1u <<  4) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P5               (0x1u <<  5) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P6               (0x1u <<  6) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P7               (0x1u <<  7) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P8               (0x1u <<  8) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P9               (0x1u <<  9) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P10              (0x1u << 10) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P11              (0x1u << 11) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P12              (0x1u << 12) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P13              (0x1u << 13) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P14              (0x1u << 14) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P15              (0x1u << 15) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P16              (0x1u << 16) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P17              (0x1u << 17) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P18              (0x1u << 18) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P19              (0x1u << 19) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P20              (0x1u << 20) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P21              (0x1u << 21) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P22              (0x1u << 22) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P23              (0x1u << 23) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P24              (0x1u << 24) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P25              (0x1u << 25) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P26              (0x1u << 26) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P27              (0x1u << 27) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P28              (0x1u << 28) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P29              (0x1u << 29) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P30              (0x1u << 30) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
#define GPIO_GFERC_P31              (0x1u << 31) /**< \brief (GPIO_GFERC) Glitch Filter Enable */
/* -------- GPIO_GFERT : (GPIO Offset: 0x0CC) Port Glitch Filter Enable Register - Toggle -------- */
#define GPIO_GFERT_P0               (0x1u <<  0) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P1               (0x1u <<  1) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P2               (0x1u <<  2) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P3               (0x1u <<  3) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P4               (0x1u <<  4) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P5               (0x1u <<  5) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P6               (0x1u <<  6) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P7               (0x1u <<  7) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P8               (0x1u <<  8) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P9               (0x1u <<  9) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P10              (0x1u << 10) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P11              (0x1u << 11) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P12              (0x1u << 12) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P13              (0x1u << 13) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P14              (0x1u << 14) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P15              (0x1u << 15) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P16              (0x1u << 16) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P17              (0x1u << 17) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P18              (0x1u << 18) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P19              (0x1u << 19) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P20              (0x1u << 20) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P21              (0x1u << 21) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P22              (0x1u << 22) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P23              (0x1u << 23) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P24              (0x1u << 24) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P25              (0x1u << 25) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P26              (0x1u << 26) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P27              (0x1u << 27) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P28              (0x1u << 28) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P29              (0x1u << 29) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P30              (0x1u << 30) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
#define GPIO_GFERT_P31              (0x1u << 31) /**< \brief (GPIO_GFERT) Glitch Filter Enable */
/* -------- GPIO_IFR : (GPIO Offset: 0x0D0) Port Interrupt Flag Register -------- */
#define GPIO_IFR_P0                 (0x1u <<  0) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P1                 (0x1u <<  1) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P2                 (0x1u <<  2) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P3                 (0x1u <<  3) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P4                 (0x1u <<  4) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P5                 (0x1u <<  5) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P6                 (0x1u <<  6) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P7                 (0x1u <<  7) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P8                 (0x1u <<  8) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P9                 (0x1u <<  9) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P10                (0x1u << 10) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P11                (0x1u << 11) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P12                (0x1u << 12) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P13                (0x1u << 13) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P14                (0x1u << 14) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P15                (0x1u << 15) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P16                (0x1u << 16) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P17                (0x1u << 17) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P18                (0x1u << 18) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P19                (0x1u << 19) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P20                (0x1u << 20) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P21                (0x1u << 21) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P22                (0x1u << 22) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P23                (0x1u << 23) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P24                (0x1u << 24) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P25                (0x1u << 25) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P26                (0x1u << 26) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P27                (0x1u << 27) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P28                (0x1u << 28) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P29                (0x1u << 29) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P30                (0x1u << 30) /**< \brief (GPIO_IFR) Interrupt Flag */
#define GPIO_IFR_P31                (0x1u << 31) /**< \brief (GPIO_IFR) Interrupt Flag */
/* -------- GPIO_IFRC : (GPIO Offset: 0x0D8) Port Interrupt Flag Register - Clear -------- */
#define GPIO_IFRC_P0                (0x1u <<  0) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P1                (0x1u <<  1) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P2                (0x1u <<  2) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P3                (0x1u <<  3) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P4                (0x1u <<  4) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P5                (0x1u <<  5) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P6                (0x1u <<  6) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P7                (0x1u <<  7) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P8                (0x1u <<  8) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P9                (0x1u <<  9) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P10               (0x1u << 10) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P11               (0x1u << 11) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P12               (0x1u << 12) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P13               (0x1u << 13) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P14               (0x1u << 14) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P15               (0x1u << 15) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P16               (0x1u << 16) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P17               (0x1u << 17) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P18               (0x1u << 18) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P19               (0x1u << 19) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P20               (0x1u << 20) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P21               (0x1u << 21) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P22               (0x1u << 22) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P23               (0x1u << 23) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P24               (0x1u << 24) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P25               (0x1u << 25) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P26               (0x1u << 26) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P27               (0x1u << 27) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P28               (0x1u << 28) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P29               (0x1u << 29) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P30               (0x1u << 30) /**< \brief (GPIO_IFRC) Interrupt Flag */
#define GPIO_IFRC_P31               (0x1u << 31) /**< \brief (GPIO_IFRC) Interrupt Flag */
/* -------- GPIO_ODMER : (GPIO Offset: 0x0E0) Port Open Drain Mode Register -------- */
#define GPIO_ODMER_P0               (0x1u <<  0) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P1               (0x1u <<  1) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P2               (0x1u <<  2) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P3               (0x1u <<  3) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P4               (0x1u <<  4) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P5               (0x1u <<  5) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P6               (0x1u <<  6) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P7               (0x1u <<  7) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P8               (0x1u <<  8) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P9               (0x1u <<  9) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P10              (0x1u << 10) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P11              (0x1u << 11) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P12              (0x1u << 12) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P13              (0x1u << 13) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P14              (0x1u << 14) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P15              (0x1u << 15) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P16              (0x1u << 16) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P17              (0x1u << 17) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P18              (0x1u << 18) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P19              (0x1u << 19) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P20              (0x1u << 20) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P21              (0x1u << 21) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P22              (0x1u << 22) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P23              (0x1u << 23) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P24              (0x1u << 24) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P25              (0x1u << 25) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P26              (0x1u << 26) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P27              (0x1u << 27) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P28              (0x1u << 28) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P29              (0x1u << 29) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P30              (0x1u << 30) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
#define GPIO_ODMER_P31              (0x1u << 31) /**< \brief (GPIO_ODMER) Open Drain Mode Enable */
/* -------- GPIO_ODMERS : (GPIO Offset: 0x0E4) Port Open Drain Mode Register - Set -------- */
#define GPIO_ODMERS_P0              (0x1u <<  0) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P1              (0x1u <<  1) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P2              (0x1u <<  2) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P3              (0x1u <<  3) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P4              (0x1u <<  4) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P5              (0x1u <<  5) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P6              (0x1u <<  6) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P7              (0x1u <<  7) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P8              (0x1u <<  8) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P9              (0x1u <<  9) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P10             (0x1u << 10) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P11             (0x1u << 11) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P12             (0x1u << 12) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P13             (0x1u << 13) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P14             (0x1u << 14) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P15             (0x1u << 15) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P16             (0x1u << 16) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P17             (0x1u << 17) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P18             (0x1u << 18) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P19             (0x1u << 19) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P20             (0x1u << 20) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P21             (0x1u << 21) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P22             (0x1u << 22) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P23             (0x1u << 23) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P24             (0x1u << 24) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P25             (0x1u << 25) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P26             (0x1u << 26) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P27             (0x1u << 27) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P28             (0x1u << 28) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P29             (0x1u << 29) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P30             (0x1u << 30) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
#define GPIO_ODMERS_P31             (0x1u << 31) /**< \brief (GPIO_ODMERS) Open Drain Mode Enable */
/* -------- GPIO_ODMERC : (GPIO Offset: 0x0E8) Port Open Drain Mode Register - Clear -------- */
#define GPIO_ODMERC_P0              (0x1u <<  0) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P1              (0x1u <<  1) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P2              (0x1u <<  2) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P3              (0x1u <<  3) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P4              (0x1u <<  4) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P5              (0x1u <<  5) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P6              (0x1u <<  6) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P7              (0x1u <<  7) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P8              (0x1u <<  8) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P9              (0x1u <<  9) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P10             (0x1u << 10) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P11             (0x1u << 11) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P12             (0x1u << 12) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P13             (0x1u << 13) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P14             (0x1u << 14) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P15             (0x1u << 15) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P16             (0x1u << 16) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P17             (0x1u << 17) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P18             (0x1u << 18) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P19             (0x1u << 19) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P20             (0x1u << 20) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P21             (0x1u << 21) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P22             (0x1u << 22) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P23             (0x1u << 23) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P24             (0x1u << 24) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P25             (0x1u << 25) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P26             (0x1u << 26) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P27             (0x1u << 27) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P28             (0x1u << 28) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P29             (0x1u << 29) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P30             (0x1u << 30) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
#define GPIO_ODMERC_P31             (0x1u << 31) /**< \brief (GPIO_ODMERC) Open Drain Mode Enable */
/* -------- GPIO_ODMERT : (GPIO Offset: 0x0EC) Port Open Drain Mode Register - Toggle -------- */
#define GPIO_ODMERT_P0              (0x1u <<  0) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P1              (0x1u <<  1) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P2              (0x1u <<  2) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P3              (0x1u <<  3) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P4              (0x1u <<  4) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P5              (0x1u <<  5) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P6              (0x1u <<  6) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P7              (0x1u <<  7) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P8              (0x1u <<  8) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P9              (0x1u <<  9) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P10             (0x1u << 10) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P11             (0x1u << 11) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P12             (0x1u << 12) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P13             (0x1u << 13) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P14             (0x1u << 14) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P15             (0x1u << 15) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P16             (0x1u << 16) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P17             (0x1u << 17) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P18             (0x1u << 18) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P19             (0x1u << 19) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P20             (0x1u << 20) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P21             (0x1u << 21) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P22             (0x1u << 22) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P23             (0x1u << 23) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P24             (0x1u << 24) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P25             (0x1u << 25) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P26             (0x1u << 26) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P27             (0x1u << 27) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P28             (0x1u << 28) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P29             (0x1u << 29) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P30             (0x1u << 30) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
#define GPIO_ODMERT_P31             (0x1u << 31) /**< \brief (GPIO_ODMERT) Open Drain Mode Enable */
/* -------- GPIO_ODCR0 : (GPIO Offset: 0x100) Port Output Driving Capability Register 0 -------- */
#define GPIO_ODCR0_P0               (0x1u <<  0) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P1               (0x1u <<  1) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P2               (0x1u <<  2) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P3               (0x1u <<  3) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P4               (0x1u <<  4) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P5               (0x1u <<  5) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P6               (0x1u <<  6) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P7               (0x1u <<  7) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P8               (0x1u <<  8) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P9               (0x1u <<  9) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P10              (0x1u << 10) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P11              (0x1u << 11) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P12              (0x1u << 12) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P13              (0x1u << 13) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P14              (0x1u << 14) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P15              (0x1u << 15) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P16              (0x1u << 16) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P17              (0x1u << 17) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P18              (0x1u << 18) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P19              (0x1u << 19) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P20              (0x1u << 20) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P21              (0x1u << 21) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P22              (0x1u << 22) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P23              (0x1u << 23) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P24              (0x1u << 24) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P25              (0x1u << 25) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P26              (0x1u << 26) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P27              (0x1u << 27) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P28              (0x1u << 28) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P29              (0x1u << 29) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P30              (0x1u << 30) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0_P31              (0x1u << 31) /**< \brief (GPIO_ODCR0) Output Driving Capability Register Bit 0 */
/* -------- GPIO_ODCR0S : (GPIO Offset: 0x104) Port Output Driving Capability Register 0 - Set -------- */
#define GPIO_ODCR0S_P0              (0x1u <<  0) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P1              (0x1u <<  1) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P2              (0x1u <<  2) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P3              (0x1u <<  3) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P4              (0x1u <<  4) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P5              (0x1u <<  5) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P6              (0x1u <<  6) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P7              (0x1u <<  7) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P8              (0x1u <<  8) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P9              (0x1u <<  9) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P10             (0x1u << 10) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P11             (0x1u << 11) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P12             (0x1u << 12) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P13             (0x1u << 13) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P14             (0x1u << 14) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P15             (0x1u << 15) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P16             (0x1u << 16) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P17             (0x1u << 17) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P18             (0x1u << 18) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P19             (0x1u << 19) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P20             (0x1u << 20) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P21             (0x1u << 21) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P22             (0x1u << 22) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P23             (0x1u << 23) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P24             (0x1u << 24) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P25             (0x1u << 25) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P26             (0x1u << 26) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P27             (0x1u << 27) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P28             (0x1u << 28) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P29             (0x1u << 29) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P30             (0x1u << 30) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0S_P31             (0x1u << 31) /**< \brief (GPIO_ODCR0S) Output Driving Capability Register Bit 0 */
/* -------- GPIO_ODCR0C : (GPIO Offset: 0x108) Port Output Driving Capability Register 0 - Clear -------- */
#define GPIO_ODCR0C_P0              (0x1u <<  0) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P1              (0x1u <<  1) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P2              (0x1u <<  2) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P3              (0x1u <<  3) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P4              (0x1u <<  4) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P5              (0x1u <<  5) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P6              (0x1u <<  6) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P7              (0x1u <<  7) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P8              (0x1u <<  8) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P9              (0x1u <<  9) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P10             (0x1u << 10) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P11             (0x1u << 11) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P12             (0x1u << 12) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P13             (0x1u << 13) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P14             (0x1u << 14) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P15             (0x1u << 15) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P16             (0x1u << 16) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P17             (0x1u << 17) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P18             (0x1u << 18) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P19             (0x1u << 19) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P20             (0x1u << 20) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P21             (0x1u << 21) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P22             (0x1u << 22) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P23             (0x1u << 23) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P24             (0x1u << 24) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P25             (0x1u << 25) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P26             (0x1u << 26) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P27             (0x1u << 27) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P28             (0x1u << 28) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P29             (0x1u << 29) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P30             (0x1u << 30) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0C_P31             (0x1u << 31) /**< \brief (GPIO_ODCR0C) Output Driving Capability Register Bit 0 */
/* -------- GPIO_ODCR0T : (GPIO Offset: 0x10C) Port Output Driving Capability Register 0 - Toggle -------- */
#define GPIO_ODCR0T_P0              (0x1u <<  0) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P1              (0x1u <<  1) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P2              (0x1u <<  2) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P3              (0x1u <<  3) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P4              (0x1u <<  4) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P5              (0x1u <<  5) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P6              (0x1u <<  6) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P7              (0x1u <<  7) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P8              (0x1u <<  8) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P9              (0x1u <<  9) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P10             (0x1u << 10) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P11             (0x1u << 11) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P12             (0x1u << 12) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P13             (0x1u << 13) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P14             (0x1u << 14) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P15             (0x1u << 15) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P16             (0x1u << 16) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P17             (0x1u << 17) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P18             (0x1u << 18) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P19             (0x1u << 19) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P20             (0x1u << 20) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P21             (0x1u << 21) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P22             (0x1u << 22) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P23             (0x1u << 23) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P24             (0x1u << 24) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P25             (0x1u << 25) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P26             (0x1u << 26) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P27             (0x1u << 27) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P28             (0x1u << 28) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P29             (0x1u << 29) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P30             (0x1u << 30) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
#define GPIO_ODCR0T_P31             (0x1u << 31) /**< \brief (GPIO_ODCR0T) Output Driving Capability Register Bit 0 */
/* -------- GPIO_ODCR1 : (GPIO Offset: 0x110) Port Output Driving Capability Register 1 -------- */
#define GPIO_ODCR1_P0               (0x1u <<  0) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P1               (0x1u <<  1) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P2               (0x1u <<  2) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P3               (0x1u <<  3) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P4               (0x1u <<  4) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P5               (0x1u <<  5) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P6               (0x1u <<  6) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P7               (0x1u <<  7) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P8               (0x1u <<  8) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P9               (0x1u <<  9) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P10              (0x1u << 10) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P11              (0x1u << 11) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P12              (0x1u << 12) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P13              (0x1u << 13) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P14              (0x1u << 14) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P15              (0x1u << 15) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P16              (0x1u << 16) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P17              (0x1u << 17) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P18              (0x1u << 18) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P19              (0x1u << 19) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P20              (0x1u << 20) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P21              (0x1u << 21) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P22              (0x1u << 22) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P23              (0x1u << 23) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P24              (0x1u << 24) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P25              (0x1u << 25) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P26              (0x1u << 26) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P27              (0x1u << 27) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P28              (0x1u << 28) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P29              (0x1u << 29) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P30              (0x1u << 30) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1_P31              (0x1u << 31) /**< \brief (GPIO_ODCR1) Output Driving Capability Register Bit 1 */
/* -------- GPIO_ODCR1S : (GPIO Offset: 0x114) Port Output Driving Capability Register 1 - Set -------- */
#define GPIO_ODCR1S_P0              (0x1u <<  0) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P1              (0x1u <<  1) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P2              (0x1u <<  2) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P3              (0x1u <<  3) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P4              (0x1u <<  4) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P5              (0x1u <<  5) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P6              (0x1u <<  6) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P7              (0x1u <<  7) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P8              (0x1u <<  8) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P9              (0x1u <<  9) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P10             (0x1u << 10) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P11             (0x1u << 11) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P12             (0x1u << 12) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P13             (0x1u << 13) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P14             (0x1u << 14) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P15             (0x1u << 15) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P16             (0x1u << 16) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P17             (0x1u << 17) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P18             (0x1u << 18) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P19             (0x1u << 19) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P20             (0x1u << 20) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P21             (0x1u << 21) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P22             (0x1u << 22) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P23             (0x1u << 23) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P24             (0x1u << 24) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P25             (0x1u << 25) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P26             (0x1u << 26) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P27             (0x1u << 27) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P28             (0x1u << 28) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P29             (0x1u << 29) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P30             (0x1u << 30) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1S_P31             (0x1u << 31) /**< \brief (GPIO_ODCR1S) Output Driving Capability Register Bit 1 */
/* -------- GPIO_ODCR1C : (GPIO Offset: 0x118) Port Output Driving Capability Register 1 - Clear -------- */
#define GPIO_ODCR1C_P0              (0x1u <<  0) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P1              (0x1u <<  1) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P2              (0x1u <<  2) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P3              (0x1u <<  3) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P4              (0x1u <<  4) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P5              (0x1u <<  5) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P6              (0x1u <<  6) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P7              (0x1u <<  7) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P8              (0x1u <<  8) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P9              (0x1u <<  9) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P10             (0x1u << 10) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P11             (0x1u << 11) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P12             (0x1u << 12) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P13             (0x1u << 13) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P14             (0x1u << 14) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P15             (0x1u << 15) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P16             (0x1u << 16) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P17             (0x1u << 17) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P18             (0x1u << 18) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P19             (0x1u << 19) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P20             (0x1u << 20) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P21             (0x1u << 21) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P22             (0x1u << 22) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P23             (0x1u << 23) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P24             (0x1u << 24) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P25             (0x1u << 25) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P26             (0x1u << 26) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P27             (0x1u << 27) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P28             (0x1u << 28) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P29             (0x1u << 29) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P30             (0x1u << 30) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1C_P31             (0x1u << 31) /**< \brief (GPIO_ODCR1C) Output Driving Capability Register Bit 1 */
/* -------- GPIO_ODCR1T : (GPIO Offset: 0x11C) Port Output Driving Capability Register 1 - Toggle -------- */
#define GPIO_ODCR1T_P0              (0x1u <<  0) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P1              (0x1u <<  1) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P2              (0x1u <<  2) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P3              (0x1u <<  3) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P4              (0x1u <<  4) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P5              (0x1u <<  5) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P6              (0x1u <<  6) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P7              (0x1u <<  7) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P8              (0x1u <<  8) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P9              (0x1u <<  9) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P10             (0x1u << 10) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P11             (0x1u << 11) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P12             (0x1u << 12) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P13             (0x1u << 13) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P14             (0x1u << 14) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P15             (0x1u << 15) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P16             (0x1u << 16) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P17             (0x1u << 17) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P18             (0x1u << 18) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P19             (0x1u << 19) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P20             (0x1u << 20) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P21             (0x1u << 21) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P22             (0x1u << 22) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P23             (0x1u << 23) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P24             (0x1u << 24) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P25             (0x1u << 25) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P26             (0x1u << 26) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P27             (0x1u << 27) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P28             (0x1u << 28) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P29             (0x1u << 29) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P30             (0x1u << 30) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
#define GPIO_ODCR1T_P31             (0x1u << 31) /**< \brief (GPIO_ODCR1T) Output Driving Capability Register Bit 1 */
/* -------- GPIO_OSRR0 : (GPIO Offset: 0x130) Port Output Slew Rate Register 0 -------- */
#define GPIO_OSRR0_P0               (0x1u <<  0) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P1               (0x1u <<  1) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P2               (0x1u <<  2) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P3               (0x1u <<  3) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P4               (0x1u <<  4) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P5               (0x1u <<  5) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P6               (0x1u <<  6) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P7               (0x1u <<  7) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P8               (0x1u <<  8) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P9               (0x1u <<  9) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P10              (0x1u << 10) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P11              (0x1u << 11) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P12              (0x1u << 12) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P13              (0x1u << 13) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P14              (0x1u << 14) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P15              (0x1u << 15) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P16              (0x1u << 16) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P17              (0x1u << 17) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P18              (0x1u << 18) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P19              (0x1u << 19) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P20              (0x1u << 20) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P21              (0x1u << 21) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P22              (0x1u << 22) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P23              (0x1u << 23) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P24              (0x1u << 24) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P25              (0x1u << 25) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P26              (0x1u << 26) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P27              (0x1u << 27) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P28              (0x1u << 28) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P29              (0x1u << 29) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P30              (0x1u << 30) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
#define GPIO_OSRR0_P31              (0x1u << 31) /**< \brief (GPIO_OSRR0) Output Slew Rate Control Enable */
/* -------- GPIO_OSRR0S : (GPIO Offset: 0x134) Port Output Slew Rate Register 0 - Set -------- */
#define GPIO_OSRR0S_P0              (0x1u <<  0) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P1              (0x1u <<  1) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P2              (0x1u <<  2) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P3              (0x1u <<  3) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P4              (0x1u <<  4) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P5              (0x1u <<  5) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P6              (0x1u <<  6) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P7              (0x1u <<  7) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P8              (0x1u <<  8) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P9              (0x1u <<  9) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P10             (0x1u << 10) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P11             (0x1u << 11) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P12             (0x1u << 12) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P13             (0x1u << 13) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P14             (0x1u << 14) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P15             (0x1u << 15) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P16             (0x1u << 16) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P17             (0x1u << 17) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P18             (0x1u << 18) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P19             (0x1u << 19) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P20             (0x1u << 20) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P21             (0x1u << 21) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P22             (0x1u << 22) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P23             (0x1u << 23) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P24             (0x1u << 24) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P25             (0x1u << 25) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P26             (0x1u << 26) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P27             (0x1u << 27) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P28             (0x1u << 28) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P29             (0x1u << 29) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P30             (0x1u << 30) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
#define GPIO_OSRR0S_P31             (0x1u << 31) /**< \brief (GPIO_OSRR0S) Output Slew Rate Control Enable */
/* -------- GPIO_OSRR0C : (GPIO Offset: 0x138) Port Output Slew Rate Register 0 - Clear -------- */
#define GPIO_OSRR0C_P0              (0x1u <<  0) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P1              (0x1u <<  1) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P2              (0x1u <<  2) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P3              (0x1u <<  3) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P4              (0x1u <<  4) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P5              (0x1u <<  5) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P6              (0x1u <<  6) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P7              (0x1u <<  7) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P8              (0x1u <<  8) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P9              (0x1u <<  9) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P10             (0x1u << 10) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P11             (0x1u << 11) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P12             (0x1u << 12) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P13             (0x1u << 13) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P14             (0x1u << 14) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P15             (0x1u << 15) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P16             (0x1u << 16) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P17             (0x1u << 17) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P18             (0x1u << 18) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P19             (0x1u << 19) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P20             (0x1u << 20) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P21             (0x1u << 21) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P22             (0x1u << 22) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P23             (0x1u << 23) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P24             (0x1u << 24) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P25             (0x1u << 25) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P26             (0x1u << 26) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P27             (0x1u << 27) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P28             (0x1u << 28) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P29             (0x1u << 29) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P30             (0x1u << 30) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
#define GPIO_OSRR0C_P31             (0x1u << 31) /**< \brief (GPIO_OSRR0C) Output Slew Rate Control Enable */
/* -------- GPIO_OSRR0T : (GPIO Offset: 0x13C) Port Output Slew Rate Register 0 - Toggle -------- */
#define GPIO_OSRR0T_P0              (0x1u <<  0) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P1              (0x1u <<  1) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P2              (0x1u <<  2) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P3              (0x1u <<  3) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P4              (0x1u <<  4) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P5              (0x1u <<  5) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P6              (0x1u <<  6) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P7              (0x1u <<  7) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P8              (0x1u <<  8) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P9              (0x1u <<  9) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P10             (0x1u << 10) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P11             (0x1u << 11) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P12             (0x1u << 12) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P13             (0x1u << 13) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P14             (0x1u << 14) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P15             (0x1u << 15) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P16             (0x1u << 16) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P17             (0x1u << 17) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P18             (0x1u << 18) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P19             (0x1u << 19) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P20             (0x1u << 20) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P21             (0x1u << 21) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P22             (0x1u << 22) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P23             (0x1u << 23) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P24             (0x1u << 24) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P25             (0x1u << 25) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P26             (0x1u << 26) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P27             (0x1u << 27) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P28             (0x1u << 28) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P29             (0x1u << 29) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P30             (0x1u << 30) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
#define GPIO_OSRR0T_P31             (0x1u << 31) /**< \brief (GPIO_OSRR0T) Output Slew Rate Control Enable */
/* -------- GPIO_STER : (GPIO Offset: 0x160) Port Schmitt Trigger Enable Register -------- */
#define GPIO_STER_P0                (0x1u <<  0) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P1                (0x1u <<  1) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P2                (0x1u <<  2) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P3                (0x1u <<  3) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P4                (0x1u <<  4) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P5                (0x1u <<  5) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P6                (0x1u <<  6) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P7                (0x1u <<  7) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P8                (0x1u <<  8) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P9                (0x1u <<  9) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P10               (0x1u << 10) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P11               (0x1u << 11) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P12               (0x1u << 12) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P13               (0x1u << 13) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P14               (0x1u << 14) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P15               (0x1u << 15) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P16               (0x1u << 16) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P17               (0x1u << 17) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P18               (0x1u << 18) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P19               (0x1u << 19) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P20               (0x1u << 20) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P21               (0x1u << 21) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P22               (0x1u << 22) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P23               (0x1u << 23) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P24               (0x1u << 24) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P25               (0x1u << 25) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P26               (0x1u << 26) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P27               (0x1u << 27) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P28               (0x1u << 28) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P29               (0x1u << 29) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P30               (0x1u << 30) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
#define GPIO_STER_P31               (0x1u << 31) /**< \brief (GPIO_STER) Schmitt Trigger Enable */
/* -------- GPIO_STERS : (GPIO Offset: 0x164) Port Schmitt Trigger Enable Register - Set -------- */
#define GPIO_STERS_P0               (0x1u <<  0) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P1               (0x1u <<  1) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P2               (0x1u <<  2) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P3               (0x1u <<  3) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P4               (0x1u <<  4) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P5               (0x1u <<  5) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P6               (0x1u <<  6) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P7               (0x1u <<  7) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P8               (0x1u <<  8) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P9               (0x1u <<  9) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P10              (0x1u << 10) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P11              (0x1u << 11) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P12              (0x1u << 12) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P13              (0x1u << 13) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P14              (0x1u << 14) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P15              (0x1u << 15) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P16              (0x1u << 16) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P17              (0x1u << 17) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P18              (0x1u << 18) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P19              (0x1u << 19) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P20              (0x1u << 20) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P21              (0x1u << 21) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P22              (0x1u << 22) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P23              (0x1u << 23) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P24              (0x1u << 24) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P25              (0x1u << 25) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P26              (0x1u << 26) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P27              (0x1u << 27) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P28              (0x1u << 28) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P29              (0x1u << 29) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P30              (0x1u << 30) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
#define GPIO_STERS_P31              (0x1u << 31) /**< \brief (GPIO_STERS) Schmitt Trigger Enable */
/* -------- GPIO_STERC : (GPIO Offset: 0x168) Port Schmitt Trigger Enable Register - Clear -------- */
#define GPIO_STERC_P0               (0x1u <<  0) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P1               (0x1u <<  1) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P2               (0x1u <<  2) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P3               (0x1u <<  3) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P4               (0x1u <<  4) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P5               (0x1u <<  5) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P6               (0x1u <<  6) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P7               (0x1u <<  7) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P8               (0x1u <<  8) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P9               (0x1u <<  9) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P10              (0x1u << 10) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P11              (0x1u << 11) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P12              (0x1u << 12) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P13              (0x1u << 13) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P14              (0x1u << 14) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P15              (0x1u << 15) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P16              (0x1u << 16) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P17              (0x1u << 17) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P18              (0x1u << 18) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P19              (0x1u << 19) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P20              (0x1u << 20) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P21              (0x1u << 21) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P22              (0x1u << 22) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P23              (0x1u << 23) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P24              (0x1u << 24) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P25              (0x1u << 25) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P26              (0x1u << 26) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P27              (0x1u << 27) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P28              (0x1u << 28) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P29              (0x1u << 29) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P30              (0x1u << 30) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
#define GPIO_STERC_P31              (0x1u << 31) /**< \brief (GPIO_STERC) Schmitt Trigger Enable */
/* -------- GPIO_STERT : (GPIO Offset: 0x16C) Port Schmitt Trigger Enable Register - Toggle -------- */
#define GPIO_STERT_P0               (0x1u <<  0) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P1               (0x1u <<  1) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P2               (0x1u <<  2) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P3               (0x1u <<  3) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P4               (0x1u <<  4) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P5               (0x1u <<  5) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P6               (0x1u <<  6) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P7               (0x1u <<  7) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P8               (0x1u <<  8) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P9               (0x1u <<  9) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P10              (0x1u << 10) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P11              (0x1u << 11) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P12              (0x1u << 12) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P13              (0x1u << 13) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P14              (0x1u << 14) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P15              (0x1u << 15) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P16              (0x1u << 16) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P17              (0x1u << 17) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P18              (0x1u << 18) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P19              (0x1u << 19) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P20              (0x1u << 20) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P21              (0x1u << 21) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P22              (0x1u << 22) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P23              (0x1u << 23) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P24              (0x1u << 24) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P25              (0x1u << 25) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P26              (0x1u << 26) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P27              (0x1u << 27) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P28              (0x1u << 28) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P29              (0x1u << 29) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P30              (0x1u << 30) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
#define GPIO_STERT_P31              (0x1u << 31) /**< \brief (GPIO_STERT) Schmitt Trigger Enable */
/* -------- GPIO_EVER : (GPIO Offset: 0x180) Port Event Enable Register -------- */
#define GPIO_EVER_P0                (0x1u <<  0) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P1                (0x1u <<  1) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P2                (0x1u <<  2) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P3                (0x1u <<  3) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P4                (0x1u <<  4) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P5                (0x1u <<  5) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P6                (0x1u <<  6) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P7                (0x1u <<  7) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P8                (0x1u <<  8) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P9                (0x1u <<  9) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P10               (0x1u << 10) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P11               (0x1u << 11) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P12               (0x1u << 12) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P13               (0x1u << 13) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P14               (0x1u << 14) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P15               (0x1u << 15) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P16               (0x1u << 16) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P17               (0x1u << 17) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P18               (0x1u << 18) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P19               (0x1u << 19) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P20               (0x1u << 20) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P21               (0x1u << 21) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P22               (0x1u << 22) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P23               (0x1u << 23) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P24               (0x1u << 24) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P25               (0x1u << 25) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P26               (0x1u << 26) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P27               (0x1u << 27) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P28               (0x1u << 28) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P29               (0x1u << 29) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P30               (0x1u << 30) /**< \brief (GPIO_EVER) Event Enable */
#define GPIO_EVER_P31               (0x1u << 31) /**< \brief (GPIO_EVER) Event Enable */
/* -------- GPIO_EVERS : (GPIO Offset: 0x184) Port Event Enable Register - Set -------- */
#define GPIO_EVERS_P0               (0x1u <<  0) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P1               (0x1u <<  1) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P2               (0x1u <<  2) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P3               (0x1u <<  3) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P4               (0x1u <<  4) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P5               (0x1u <<  5) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P6               (0x1u <<  6) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P7               (0x1u <<  7) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P8               (0x1u <<  8) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P9               (0x1u <<  9) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P10              (0x1u << 10) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P11              (0x1u << 11) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P12              (0x1u << 12) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P13              (0x1u << 13) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P14              (0x1u << 14) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P15              (0x1u << 15) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P16              (0x1u << 16) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P17              (0x1u << 17) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P18              (0x1u << 18) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P19              (0x1u << 19) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P20              (0x1u << 20) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P21              (0x1u << 21) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P22              (0x1u << 22) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P23              (0x1u << 23) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P24              (0x1u << 24) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P25              (0x1u << 25) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P26              (0x1u << 26) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P27              (0x1u << 27) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P28              (0x1u << 28) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P29              (0x1u << 29) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P30              (0x1u << 30) /**< \brief (GPIO_EVERS) Event Enable */
#define GPIO_EVERS_P31              (0x1u << 31) /**< \brief (GPIO_EVERS) Event Enable */
/* -------- GPIO_EVERC : (GPIO Offset: 0x188) Port Event Enable Register - Clear -------- */
#define GPIO_EVERC_P0               (0x1u <<  0) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P1               (0x1u <<  1) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P2               (0x1u <<  2) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P3               (0x1u <<  3) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P4               (0x1u <<  4) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P5               (0x1u <<  5) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P6               (0x1u <<  6) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P7               (0x1u <<  7) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P8               (0x1u <<  8) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P9               (0x1u <<  9) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P10              (0x1u << 10) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P11              (0x1u << 11) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P12              (0x1u << 12) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P13              (0x1u << 13) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P14              (0x1u << 14) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P15              (0x1u << 15) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P16              (0x1u << 16) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P17              (0x1u << 17) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P18              (0x1u << 18) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P19              (0x1u << 19) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P20              (0x1u << 20) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P21              (0x1u << 21) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P22              (0x1u << 22) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P23              (0x1u << 23) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P24              (0x1u << 24) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P25              (0x1u << 25) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P26              (0x1u << 26) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P27              (0x1u << 27) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P28              (0x1u << 28) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P29              (0x1u << 29) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P30              (0x1u << 30) /**< \brief (GPIO_EVERC) Event Enable */
#define GPIO_EVERC_P31              (0x1u << 31) /**< \brief (GPIO_EVERC) Event Enable */
/* -------- GPIO_EVERT : (GPIO Offset: 0x18C) Port Event Enable Register - Toggle -------- */
#define GPIO_EVERT_P0               (0x1u <<  0) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P1               (0x1u <<  1) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P2               (0x1u <<  2) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P3               (0x1u <<  3) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P4               (0x1u <<  4) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P5               (0x1u <<  5) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P6               (0x1u <<  6) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P7               (0x1u <<  7) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P8               (0x1u <<  8) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P9               (0x1u <<  9) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P10              (0x1u << 10) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P11              (0x1u << 11) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P12              (0x1u << 12) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P13              (0x1u << 13) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P14              (0x1u << 14) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P15              (0x1u << 15) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P16              (0x1u << 16) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P17              (0x1u << 17) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P18              (0x1u << 18) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P19              (0x1u << 19) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P20              (0x1u << 20) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P21              (0x1u << 21) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P22              (0x1u << 22) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P23              (0x1u << 23) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P24              (0x1u << 24) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P25              (0x1u << 25) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P26              (0x1u << 26) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P27              (0x1u << 27) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P28              (0x1u << 28) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P29              (0x1u << 29) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P30              (0x1u << 30) /**< \brief (GPIO_EVERT) Event Enable */
#define GPIO_EVERT_P31              (0x1u << 31) /**< \brief (GPIO_EVERT) Event Enable */
/* -------- GPIO_LOCK : (GPIO Offset: 0x1A0) Port Lock Register -------- */
#define GPIO_LOCK_P0                (0x1u <<  0) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P1                (0x1u <<  1) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P2                (0x1u <<  2) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P3                (0x1u <<  3) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P4                (0x1u <<  4) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P5                (0x1u <<  5) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P6                (0x1u <<  6) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P7                (0x1u <<  7) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P8                (0x1u <<  8) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P9                (0x1u <<  9) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P10               (0x1u << 10) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P11               (0x1u << 11) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P12               (0x1u << 12) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P13               (0x1u << 13) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P14               (0x1u << 14) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P15               (0x1u << 15) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P16               (0x1u << 16) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P17               (0x1u << 17) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P18               (0x1u << 18) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P19               (0x1u << 19) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P20               (0x1u << 20) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P21               (0x1u << 21) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P22               (0x1u << 22) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P23               (0x1u << 23) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P24               (0x1u << 24) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P25               (0x1u << 25) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P26               (0x1u << 26) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P27               (0x1u << 27) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P28               (0x1u << 28) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P29               (0x1u << 29) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P30               (0x1u << 30) /**< \brief (GPIO_LOCK) Lock State */
#define GPIO_LOCK_P31               (0x1u << 31) /**< \brief (GPIO_LOCK) Lock State */
/* -------- GPIO_LOCKS : (GPIO Offset: 0x1A4) Port Lock Register - Set -------- */
#define GPIO_LOCKS_P0               (0x1u <<  0) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P1               (0x1u <<  1) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P2               (0x1u <<  2) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P3               (0x1u <<  3) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P4               (0x1u <<  4) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P5               (0x1u <<  5) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P6               (0x1u <<  6) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P7               (0x1u <<  7) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P8               (0x1u <<  8) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P9               (0x1u <<  9) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P10              (0x1u << 10) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P11              (0x1u << 11) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P12              (0x1u << 12) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P13              (0x1u << 13) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P14              (0x1u << 14) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P15              (0x1u << 15) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P16              (0x1u << 16) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P17              (0x1u << 17) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P18              (0x1u << 18) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P19              (0x1u << 19) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P20              (0x1u << 20) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P21              (0x1u << 21) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P22              (0x1u << 22) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P23              (0x1u << 23) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P24              (0x1u << 24) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P25              (0x1u << 25) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P26              (0x1u << 26) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P27              (0x1u << 27) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P28              (0x1u << 28) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P29              (0x1u << 29) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P30              (0x1u << 30) /**< \brief (GPIO_LOCKS) Lock State */
#define GPIO_LOCKS_P31              (0x1u << 31) /**< \brief (GPIO_LOCKS) Lock State */
/* -------- GPIO_LOCKC : (GPIO Offset: 0x1A8) Port Lock Register - Clear -------- */
#define GPIO_LOCKC_P0               (0x1u <<  0) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P1               (0x1u <<  1) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P2               (0x1u <<  2) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P3               (0x1u <<  3) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P4               (0x1u <<  4) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P5               (0x1u <<  5) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P6               (0x1u <<  6) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P7               (0x1u <<  7) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P8               (0x1u <<  8) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P9               (0x1u <<  9) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P10              (0x1u << 10) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P11              (0x1u << 11) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P12              (0x1u << 12) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P13              (0x1u << 13) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P14              (0x1u << 14) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P15              (0x1u << 15) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P16              (0x1u << 16) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P17              (0x1u << 17) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P18              (0x1u << 18) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P19              (0x1u << 19) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P20              (0x1u << 20) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P21              (0x1u << 21) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P22              (0x1u << 22) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P23              (0x1u << 23) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P24              (0x1u << 24) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P25              (0x1u << 25) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P26              (0x1u << 26) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P27              (0x1u << 27) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P28              (0x1u << 28) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P29              (0x1u << 29) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P30              (0x1u << 30) /**< \brief (GPIO_LOCKC) Lock State */
#define GPIO_LOCKC_P31              (0x1u << 31) /**< \brief (GPIO_LOCKC) Lock State */
/* -------- GPIO_LOCKT : (GPIO Offset: 0x1AC) Port Lock Register - Toggle -------- */
#define GPIO_LOCKT_P0               (0x1u <<  0) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P1               (0x1u <<  1) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P2               (0x1u <<  2) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P3               (0x1u <<  3) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P4               (0x1u <<  4) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P5               (0x1u <<  5) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P6               (0x1u <<  6) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P7               (0x1u <<  7) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P8               (0x1u <<  8) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P9               (0x1u <<  9) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P10              (0x1u << 10) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P11              (0x1u << 11) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P12              (0x1u << 12) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P13              (0x1u << 13) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P14              (0x1u << 14) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P15              (0x1u << 15) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P16              (0x1u << 16) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P17              (0x1u << 17) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P18              (0x1u << 18) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P19              (0x1u << 19) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P20              (0x1u << 20) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P21              (0x1u << 21) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P22              (0x1u << 22) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P23              (0x1u << 23) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P24              (0x1u << 24) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P25              (0x1u << 25) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P26              (0x1u << 26) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P27              (0x1u << 27) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P28              (0x1u << 28) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P29              (0x1u << 29) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P30              (0x1u << 30) /**< \brief (GPIO_LOCKT) Lock State */
#define GPIO_LOCKT_P31              (0x1u << 31) /**< \brief (GPIO_LOCKT) Lock State */
/* -------- GPIO_UNLOCK : (GPIO Offset: 0x1E0) Port Unlock Register -------- */
#define GPIO_UNLOCK_OFFSET_Pos      0
#define GPIO_UNLOCK_OFFSET_Msk      (0x3FFu << GPIO_UNLOCK_OFFSET_Pos) /**< \brief (GPIO_UNLOCK) Offset Register */
#define GPIO_UNLOCK_OFFSET(value)   ((GPIO_UNLOCK_OFFSET_Msk & ((value) << GPIO_UNLOCK_OFFSET_Pos)))
#define GPIO_UNLOCK_KEY_Pos         24
#define GPIO_UNLOCK_KEY_Msk         (0xFFu << GPIO_UNLOCK_KEY_Pos) /**< \brief (GPIO_UNLOCK) Unlocking Key */
#define GPIO_UNLOCK_KEY(value)      ((GPIO_UNLOCK_KEY_Msk & ((value) << GPIO_UNLOCK_KEY_Pos)))
/* -------- GPIO_ASR : (GPIO Offset: 0x1E4) Port Access Status Register -------- */
#define GPIO_ASR_AR                 (0x1u <<  0) /**< \brief (GPIO_ASR) Access Error */
/* -------- GPIO_PARAMETER : (GPIO Offset: 0x1F8) Port Parameter Register -------- */
#define GPIO_PARAMETER_PARAMETER_Pos    0
#define GPIO_PARAMETER_PARAMETER_Msk    (0xFFFFFFFFu << GPIO_PARAMETER_PARAMETER_Pos) /**< \brief (GPIO_PARAMETER) Parameter */
#define GPIO_PARAMETER_PARAMETER(value) ((GPIO_PARAMETER_PARAMETER_Msk & ((value) << GPIO_PARAMETER_PARAMETER_Pos)))
/* -------- GPIO_VERSION : (GPIO Offset: 0x1FC) Port Version Register -------- */
#define GPIO_VERSION_VERSION_Pos    0
#define GPIO_VERSION_VERSION_Msk    (0xFFFu << GPIO_VERSION_VERSION_Pos) /**< \brief (GPIO_VERSION) Version Number */
#define GPIO_VERSION_VERSION(value) ((GPIO_VERSION_VERSION_Msk & ((value) << GPIO_VERSION_VERSION_Pos)))
#define GPIO_VERSION_VARIANT_Pos    16
#define GPIO_VERSION_VARIANT_Msk    (0xFu << GPIO_VERSION_VARIANT_Pos) /**< \brief (GPIO_VERSION) Variant Number */
#define GPIO_VERSION_VARIANT(value) ((GPIO_VERSION_VARIANT_Msk & ((value) << GPIO_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR HCACHE */
/* ============================================================================= */
/** \addtogroup SAM4L4_HCACHE Cortex M I&D Cache Controller */
/*@{*/

#define REV_HCACHE     0x101

#ifndef __ASSEMBLY__
/** \brief HCACHE hardware registers */
typedef struct {
  RoReg   Reserved1[2];
  WoReg   CTRL;        /**< \brief (HCACHE Offset: 0x08) Control Register */
  RwReg   SR;          /**< \brief (HCACHE Offset: 0x0C) Status Register */
  RoReg   Reserved2[4];
  WoReg   MAINT0;      /**< \brief (HCACHE Offset: 0x20) Maintenance Register 0 */
  WoReg   MAINT1;      /**< \brief (HCACHE Offset: 0x24) Maintenance Register 1 */
  RwReg   MCFG;        /**< \brief (HCACHE Offset: 0x28) Monitor Configuration Register */
  RwReg   MEN;         /**< \brief (HCACHE Offset: 0x2C) Monitor Enable Register */
  WoReg   MCTRL;       /**< \brief (HCACHE Offset: 0x30) Monitor Control Register */
  RoReg   MSR;         /**< \brief (HCACHE Offset: 0x34) Monitor Status Register */
  RoReg   Reserved3[49];
  RoReg   VERSION;     /**< \brief (HCACHE Offset: 0xFC) Version Register */
} Hcache;
#endif /* __ASSEMBLY__ */
/* -------- HCACHE_CTRL : (HCACHE Offset: 0x08) Control Register -------- */
#define HCACHE_CTRL_CEN             (0x1u <<  0) /**< \brief (HCACHE_CTRL) Cache Enable */
#define   HCACHE_CTRL_CEN_NO        (0x0u <<  0) /**< \brief (HCACHE_CTRL) Disable Cache Controller */
#define   HCACHE_CTRL_CEN_YES       (0x1u <<  0) /**< \brief (HCACHE_CTRL) Enable Cache Controller */
/* -------- HCACHE_SR : (HCACHE Offset: 0x0C) Status Register -------- */
#define HCACHE_SR_CSTS              (0x1u <<  0) /**< \brief (HCACHE_SR) Cache Controller Status */
#define   HCACHE_SR_CSTS_DIS        (0x0u <<  0) /**< \brief (HCACHE_SR) Cache Controller Disabled */
#define   HCACHE_SR_CSTS_EN         (0x1u <<  0) /**< \brief (HCACHE_SR) Cache Controller Enabled */
/* -------- HCACHE_MAINT0 : (HCACHE Offset: 0x20) Maintenance Register 0 -------- */
#define HCACHE_MAINT0_INVALL        (0x1u <<  0) /**< \brief (HCACHE_MAINT0) Cache Controller Invalidate All */
#define   HCACHE_MAINT0_INVALL_NO   (0x0u <<  0) /**< \brief (HCACHE_MAINT0) No effect */
#define   HCACHE_MAINT0_INVALL_YES  (0x1u <<  0) /**< \brief (HCACHE_MAINT0) Invalidate all cache entries */
/* -------- HCACHE_MAINT1 : (HCACHE Offset: 0x24) Maintenance Register 1 -------- */
#define HCACHE_MAINT1_INDEX_Pos     4
#define HCACHE_MAINT1_INDEX_Msk     (0xFu << HCACHE_MAINT1_INDEX_Pos) /**< \brief (HCACHE_MAINT1) Invalidate Index */
#define HCACHE_MAINT1_INDEX(value)  ((HCACHE_MAINT1_INDEX_Msk & ((value) << HCACHE_MAINT1_INDEX_Pos)))
/* -------- HCACHE_MCFG : (HCACHE Offset: 0x28) Monitor Configuration Register -------- */
#define HCACHE_MCFG_MODE_Pos        0
#define HCACHE_MCFG_MODE_Msk        (0x3u << HCACHE_MCFG_MODE_Pos) /**< \brief (HCACHE_MCFG) Cache Controller Monitor Counter Mode */
#define HCACHE_MCFG_MODE(value)     ((HCACHE_MCFG_MODE_Msk & ((value) << HCACHE_MCFG_MODE_Pos)))
#define   HCACHE_MCFG_MODE_CYCLE    (0x0u <<  0) /**< \brief (HCACHE_MCFG) Cycle Counter */
#define   HCACHE_MCFG_MODE_IHIT     (0x1u <<  0) /**< \brief (HCACHE_MCFG) Instruction Hit Counter */
#define   HCACHE_MCFG_MODE_DHIT     (0x2u <<  0) /**< \brief (HCACHE_MCFG) Data Hit Counter */
/* -------- HCACHE_MEN : (HCACHE Offset: 0x2C) Monitor Enable Register -------- */
#define HCACHE_MEN_MENABLE          (0x1u <<  0) /**< \brief (HCACHE_MEN) Monitor Enable */
#define   HCACHE_MEN_MENABLE_DIS    (0x0u <<  0) /**< \brief (HCACHE_MEN) Disable Monitor Counter */
#define   HCACHE_MEN_MENABLE_EN     (0x1u <<  0) /**< \brief (HCACHE_MEN) Enable Monitor Counter */
/* -------- HCACHE_MCTRL : (HCACHE Offset: 0x30) Monitor Control Register -------- */
#define HCACHE_MCTRL_SWRST          (0x1u <<  0) /**< \brief (HCACHE_MCTRL) Monitor Software Reset */
#define   HCACHE_MCTRL_SWRST_NO     (0x0u <<  0) /**< \brief (HCACHE_MCTRL) No effect */
#define   HCACHE_MCTRL_SWRST_YES    (0x1u <<  0) /**< \brief (HCACHE_MCTRL) Reset event counter register */
/* -------- HCACHE_MSR : (HCACHE Offset: 0x34) Monitor Status Register -------- */
#define HCACHE_MSR_EVENTCNT_Pos     0
#define HCACHE_MSR_EVENTCNT_Msk     (0xFFFFFFFFu << HCACHE_MSR_EVENTCNT_Pos) /**< \brief (HCACHE_MSR) Monitor Event Counter */
#define HCACHE_MSR_EVENTCNT(value)  ((HCACHE_MSR_EVENTCNT_Msk & ((value) << HCACHE_MSR_EVENTCNT_Pos)))
/* -------- HCACHE_VERSION : (HCACHE Offset: 0xFC) Version Register -------- */
#define HCACHE_VERSION_VERSION_Pos    0
#define HCACHE_VERSION_VERSION_Msk    (0xFFFu << HCACHE_VERSION_VERSION_Pos) /**< \brief (HCACHE_VERSION) VERSION */
#define HCACHE_VERSION_VERSION(value) ((HCACHE_VERSION_VERSION_Msk & ((value) << HCACHE_VERSION_VERSION_Pos)))
#define HCACHE_VERSION_MFN_Pos      16
#define HCACHE_VERSION_MFN_Msk      (0xFu << HCACHE_VERSION_MFN_Pos) /**< \brief (HCACHE_VERSION) MFN */
#define HCACHE_VERSION_MFN(value)   ((HCACHE_VERSION_MFN_Msk & ((value) << HCACHE_VERSION_MFN_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR HMATRIXB */
/* ============================================================================= */
/** \addtogroup SAM4L4_HMATRIXB HSB Matrix */
/*@{*/

#define REV_HMATRIXB   0x130

#ifndef __ASSEMBLY__
/** \brief HmatrixbMcfg hardware registers */
typedef struct {
  RwReg   MCFG;        /**< \brief (HmatrixbMcfg Offset: 0x000) Master Configuration Register 0 */
} HmatrixbMcfg;
/** \brief HmatrixbPrs hardware registers */
typedef struct {
  RwReg   PRAS;        /**< \brief (HmatrixbPrs Offset: 0x000) Priority Register A for Slave 0 */
  RwReg   PRBS;        /**< \brief (HmatrixbPrs Offset: 0x004) Priority Register B for Slave 0 */
} HmatrixbPrs;
/** \brief HmatrixbScfg hardware registers */
typedef struct {
  RwReg   SCFG;        /**< \brief (HmatrixbScfg Offset: 0x000) Slave Configuration Register 0 */
} HmatrixbScfg;
/** \brief HmatrixbSfr hardware registers */
typedef struct {
  RwReg   SFR;         /**< \brief (HmatrixbSfr Offset: 0x000) Special Function Register 0 */
} HmatrixbSfr;
/** \brief HMATRIXB hardware registers */
typedef struct {
  HmatrixbMcfg Mcfg[16]; /**< \brief (HMATRIXB Offset: 0x000) HmatrixbMcfg groups */
  HmatrixbScfg Scfg[16]; /**< \brief (HMATRIXB Offset: 0x040) HmatrixbScfg groups */
  HmatrixbPrs Prs[16]; /**< \brief (HMATRIXB Offset: 0x080) HmatrixbPrs groups */
  RwReg   MRCR;        /**< \brief (HMATRIXB Offset: 0x100) Master Remap Control Register */
  RoReg   Reserved1[3];
  HmatrixbSfr Sfr[16]; /**< \brief (HMATRIXB Offset: 0x110) HmatrixbSfr groups */
} Hmatrixb;
#endif /* __ASSEMBLY__ */
/* -------- HMATRIXB_MCFG : (HMATRIXB Offset: 0x000) Mcfg Master Configuration Register 0 -------- */
#define HMATRIXB_MCFG_ULBT_Pos      0
#define HMATRIXB_MCFG_ULBT_Msk      (0x7u << HMATRIXB_MCFG_ULBT_Pos) /**< \brief (HMATRIXB_MCFG) Undefined Length Burst Type */
#define HMATRIXB_MCFG_ULBT(value)   ((HMATRIXB_MCFG_ULBT_Msk & ((value) << HMATRIXB_MCFG_ULBT_Pos)))
#define   HMATRIXB_MCFG_ULBT_INFINITE (0x0u <<  0) /**< \brief (HMATRIXB_MCFG) Infinite Length */
#define   HMATRIXB_MCFG_ULBT_SINGLE (0x1u <<  0) /**< \brief (HMATRIXB_MCFG) Single Access */
#define   HMATRIXB_MCFG_ULBT_FOUR_BEAT (0x2u <<  0) /**< \brief (HMATRIXB_MCFG) Four Beat Burst */
#define   HMATRIXB_MCFG_ULBT_EIGHT_BEAT (0x3u <<  0) /**< \brief (HMATRIXB_MCFG) Eight Beat Burst */
#define   HMATRIXB_MCFG_ULBT_SIXTEEN_BEAT (0x4u <<  0) /**< \brief (HMATRIXB_MCFG) Sixteen Beat Burst */
/* -------- HMATRIXB_SCFG : (HMATRIXB Offset: 0x040) Scfg Slave Configuration Register 0 -------- */
#define HMATRIXB_SCFG_SLOT_CYCLE_Pos    0
#define HMATRIXB_SCFG_SLOT_CYCLE_Msk    (0xFFu << HMATRIXB_SCFG_SLOT_CYCLE_Pos) /**< \brief (HMATRIXB_SCFG) Maximum Number of Allowed Cycles for a Burst */
#define HMATRIXB_SCFG_SLOT_CYCLE(value) ((HMATRIXB_SCFG_SLOT_CYCLE_Msk & ((value) << HMATRIXB_SCFG_SLOT_CYCLE_Pos)))
#define HMATRIXB_SCFG_DEFMSTR_TYPE_Pos    16
#define HMATRIXB_SCFG_DEFMSTR_TYPE_Msk    (0x3u << HMATRIXB_SCFG_DEFMSTR_TYPE_Pos) /**< \brief (HMATRIXB_SCFG) Default Master Type */
#define HMATRIXB_SCFG_DEFMSTR_TYPE(value) ((HMATRIXB_SCFG_DEFMSTR_TYPE_Msk & ((value) << HMATRIXB_SCFG_DEFMSTR_TYPE_Pos)))
#define   HMATRIXB_SCFG_DEFMSTR_TYPE_NO_DEFAULT (0x0u << 16) /**< \brief (HMATRIXB_SCFG) No Default Master. At the end of current slave access, if no other master request is pending, the slave is deconnected from all masters. This resusts in having a one cycle latency for the first transfer of a burst. */
#define   HMATRIXB_SCFG_DEFMSTR_TYPE_LAST_DEFAULT (0x1u << 16) /**< \brief (HMATRIXB_SCFG) Last Default Master At the end of current slave access, if no other master request is pending, the slave stay connected with the last master havingaccessed it.This resusts in not having the one cycle latency when the last master re-trying access on the slave. */
#define   HMATRIXB_SCFG_DEFMSTR_TYPE_FIXED_DEFAULT (0x2u << 16) /**< \brief (HMATRIXB_SCFG) Fixed Default Master At the end of current slave access, if no other master request is pending, the slave connects with fixed master which numberis in FIXED_DEFMSTR register.This resusts in not having the one cycle latency when the fixed master re-trying access on the slave. */
#define HMATRIXB_SCFG_FIXED_DEFMSTR_Pos    18
#define HMATRIXB_SCFG_FIXED_DEFMSTR_Msk    (0xFu << HMATRIXB_SCFG_FIXED_DEFMSTR_Pos) /**< \brief (HMATRIXB_SCFG) Fixed Index of Default Master */
#define HMATRIXB_SCFG_FIXED_DEFMSTR(value) ((HMATRIXB_SCFG_FIXED_DEFMSTR_Msk & ((value) << HMATRIXB_SCFG_FIXED_DEFMSTR_Pos)))
#define HMATRIXB_SCFG_ARBT          (0x1u << 24) /**< \brief (HMATRIXB_SCFG) Arbitration Type */
#define   HMATRIXB_SCFG_ARBT_ROUND_ROBIN (0x0u << 24) /**< \brief (HMATRIXB_SCFG) Round-Robin Arbitration */
#define   HMATRIXB_SCFG_ARBT_FIXED_PRIORITY (0x1u << 24) /**< \brief (HMATRIXB_SCFG) Fixed Priority Arbitration */
/* -------- HMATRIXB_PRAS : (HMATRIXB Offset: 0x080) Prs Priority Register A for Slave 0 -------- */
#define HMATRIXB_PRAS_M0PR_Pos      0
#define HMATRIXB_PRAS_M0PR_Msk      (0xFu << HMATRIXB_PRAS_M0PR_Pos) /**< \brief (HMATRIXB_PRAS) Master 0 Priority */
#define HMATRIXB_PRAS_M0PR(value)   ((HMATRIXB_PRAS_M0PR_Msk & ((value) << HMATRIXB_PRAS_M0PR_Pos)))
#define HMATRIXB_PRAS_M1PR_Pos      4
#define HMATRIXB_PRAS_M1PR_Msk      (0xFu << HMATRIXB_PRAS_M1PR_Pos) /**< \brief (HMATRIXB_PRAS) Master 1 Priority */
#define HMATRIXB_PRAS_M1PR(value)   ((HMATRIXB_PRAS_M1PR_Msk & ((value) << HMATRIXB_PRAS_M1PR_Pos)))
#define HMATRIXB_PRAS_M2PR_Pos      8
#define HMATRIXB_PRAS_M2PR_Msk      (0xFu << HMATRIXB_PRAS_M2PR_Pos) /**< \brief (HMATRIXB_PRAS) Master 2 Priority */
#define HMATRIXB_PRAS_M2PR(value)   ((HMATRIXB_PRAS_M2PR_Msk & ((value) << HMATRIXB_PRAS_M2PR_Pos)))
#define HMATRIXB_PRAS_M3PR_Pos      12
#define HMATRIXB_PRAS_M3PR_Msk      (0xFu << HMATRIXB_PRAS_M3PR_Pos) /**< \brief (HMATRIXB_PRAS) Master 3 Priority */
#define HMATRIXB_PRAS_M3PR(value)   ((HMATRIXB_PRAS_M3PR_Msk & ((value) << HMATRIXB_PRAS_M3PR_Pos)))
#define HMATRIXB_PRAS_M4PR_Pos      16
#define HMATRIXB_PRAS_M4PR_Msk      (0xFu << HMATRIXB_PRAS_M4PR_Pos) /**< \brief (HMATRIXB_PRAS) Master 4 Priority */
#define HMATRIXB_PRAS_M4PR(value)   ((HMATRIXB_PRAS_M4PR_Msk & ((value) << HMATRIXB_PRAS_M4PR_Pos)))
#define HMATRIXB_PRAS_M5PR_Pos      20
#define HMATRIXB_PRAS_M5PR_Msk      (0xFu << HMATRIXB_PRAS_M5PR_Pos) /**< \brief (HMATRIXB_PRAS) Master 5 Priority */
#define HMATRIXB_PRAS_M5PR(value)   ((HMATRIXB_PRAS_M5PR_Msk & ((value) << HMATRIXB_PRAS_M5PR_Pos)))
#define HMATRIXB_PRAS_M6PR_Pos      24
#define HMATRIXB_PRAS_M6PR_Msk      (0xFu << HMATRIXB_PRAS_M6PR_Pos) /**< \brief (HMATRIXB_PRAS) Master 6 Priority */
#define HMATRIXB_PRAS_M6PR(value)   ((HMATRIXB_PRAS_M6PR_Msk & ((value) << HMATRIXB_PRAS_M6PR_Pos)))
#define HMATRIXB_PRAS_M7PR_Pos      28
#define HMATRIXB_PRAS_M7PR_Msk      (0xFu << HMATRIXB_PRAS_M7PR_Pos) /**< \brief (HMATRIXB_PRAS) Master 7 Priority */
#define HMATRIXB_PRAS_M7PR(value)   ((HMATRIXB_PRAS_M7PR_Msk & ((value) << HMATRIXB_PRAS_M7PR_Pos)))
/* -------- HMATRIXB_PRBS : (HMATRIXB Offset: 0x084) Prs Priority Register B for Slave 0 -------- */
#define HMATRIXB_PRBS_M8PR_Pos      0
#define HMATRIXB_PRBS_M8PR_Msk      (0xFu << HMATRIXB_PRBS_M8PR_Pos) /**< \brief (HMATRIXB_PRBS) Master 8 Priority */
#define HMATRIXB_PRBS_M8PR(value)   ((HMATRIXB_PRBS_M8PR_Msk & ((value) << HMATRIXB_PRBS_M8PR_Pos)))
#define HMATRIXB_PRBS_M9PR_Pos      4
#define HMATRIXB_PRBS_M9PR_Msk      (0xFu << HMATRIXB_PRBS_M9PR_Pos) /**< \brief (HMATRIXB_PRBS) Master 9 Priority */
#define HMATRIXB_PRBS_M9PR(value)   ((HMATRIXB_PRBS_M9PR_Msk & ((value) << HMATRIXB_PRBS_M9PR_Pos)))
#define HMATRIXB_PRBS_M10PR_Pos     8
#define HMATRIXB_PRBS_M10PR_Msk     (0xFu << HMATRIXB_PRBS_M10PR_Pos) /**< \brief (HMATRIXB_PRBS) Master 10 Priority */
#define HMATRIXB_PRBS_M10PR(value)  ((HMATRIXB_PRBS_M10PR_Msk & ((value) << HMATRIXB_PRBS_M10PR_Pos)))
#define HMATRIXB_PRBS_M11PR_Pos     12
#define HMATRIXB_PRBS_M11PR_Msk     (0xFu << HMATRIXB_PRBS_M11PR_Pos) /**< \brief (HMATRIXB_PRBS) Master 11 Priority */
#define HMATRIXB_PRBS_M11PR(value)  ((HMATRIXB_PRBS_M11PR_Msk & ((value) << HMATRIXB_PRBS_M11PR_Pos)))
#define HMATRIXB_PRBS_M12PR_Pos     16
#define HMATRIXB_PRBS_M12PR_Msk     (0xFu << HMATRIXB_PRBS_M12PR_Pos) /**< \brief (HMATRIXB_PRBS) Master 12 Priority */
#define HMATRIXB_PRBS_M12PR(value)  ((HMATRIXB_PRBS_M12PR_Msk & ((value) << HMATRIXB_PRBS_M12PR_Pos)))
#define HMATRIXB_PRBS_M13PR_Pos     20
#define HMATRIXB_PRBS_M13PR_Msk     (0xFu << HMATRIXB_PRBS_M13PR_Pos) /**< \brief (HMATRIXB_PRBS) Master 13 Priority */
#define HMATRIXB_PRBS_M13PR(value)  ((HMATRIXB_PRBS_M13PR_Msk & ((value) << HMATRIXB_PRBS_M13PR_Pos)))
#define HMATRIXB_PRBS_M14PR_Pos     24
#define HMATRIXB_PRBS_M14PR_Msk     (0xFu << HMATRIXB_PRBS_M14PR_Pos) /**< \brief (HMATRIXB_PRBS) Master 14 Priority */
#define HMATRIXB_PRBS_M14PR(value)  ((HMATRIXB_PRBS_M14PR_Msk & ((value) << HMATRIXB_PRBS_M14PR_Pos)))
#define HMATRIXB_PRBS_M15PR_Pos     28
#define HMATRIXB_PRBS_M15PR_Msk     (0xFu << HMATRIXB_PRBS_M15PR_Pos) /**< \brief (HMATRIXB_PRBS) Master 15 Priority */
#define HMATRIXB_PRBS_M15PR(value)  ((HMATRIXB_PRBS_M15PR_Msk & ((value) << HMATRIXB_PRBS_M15PR_Pos)))
/* -------- HMATRIXB_MRCR : (HMATRIXB Offset: 0x100) Master Remap Control Register -------- */
#define HMATRIXB_MRCR_RCB0          (0x1u <<  0) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 0 */
#define   HMATRIXB_MRCR_RCB0_0      (0x0u <<  0) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB0_1      (0x1u <<  0) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB1          (0x1u <<  1) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 1 */
#define   HMATRIXB_MRCR_RCB1_0      (0x0u <<  1) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB1_1      (0x1u <<  1) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB2          (0x1u <<  2) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 2 */
#define   HMATRIXB_MRCR_RCB2_0      (0x0u <<  2) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB2_1      (0x1u <<  2) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB3          (0x1u <<  3) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 3 */
#define   HMATRIXB_MRCR_RCB3_0      (0x0u <<  3) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB3_1      (0x1u <<  3) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB4          (0x1u <<  4) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 4 */
#define   HMATRIXB_MRCR_RCB4_0      (0x0u <<  4) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB4_1      (0x1u <<  4) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB5          (0x1u <<  5) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 5 */
#define   HMATRIXB_MRCR_RCB5_0      (0x0u <<  5) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB5_1      (0x1u <<  5) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB6          (0x1u <<  6) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 6 */
#define   HMATRIXB_MRCR_RCB6_0      (0x0u <<  6) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB6_1      (0x1u <<  6) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB7          (0x1u <<  7) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 7 */
#define   HMATRIXB_MRCR_RCB7_0      (0x0u <<  7) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB7_1      (0x1u <<  7) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB8          (0x1u <<  8) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 8 */
#define   HMATRIXB_MRCR_RCB8_0      (0x0u <<  8) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB8_1      (0x1u <<  8) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB9          (0x1u <<  9) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 9 */
#define   HMATRIXB_MRCR_RCB9_0      (0x0u <<  9) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB9_1      (0x1u <<  9) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB10         (0x1u << 10) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 10 */
#define   HMATRIXB_MRCR_RCB10_0     (0x0u << 10) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB10_1     (0x1u << 10) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB11         (0x1u << 11) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 11 */
#define   HMATRIXB_MRCR_RCB11_0     (0x0u << 11) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB11_1     (0x1u << 11) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB12         (0x1u << 12) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 12 */
#define   HMATRIXB_MRCR_RCB12_0     (0x0u << 12) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB12_1     (0x1u << 12) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB13         (0x1u << 13) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 13 */
#define   HMATRIXB_MRCR_RCB13_0     (0x0u << 13) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB13_1     (0x1u << 13) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB14         (0x1u << 14) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 14 */
#define   HMATRIXB_MRCR_RCB14_0     (0x0u << 14) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB14_1     (0x1u << 14) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
#define HMATRIXB_MRCR_RCB15         (0x1u << 15) /**< \brief (HMATRIXB_MRCR) Remap Command bit for Master 15 */
#define   HMATRIXB_MRCR_RCB15_0     (0x0u << 15) /**< \brief (HMATRIXB_MRCR) Disable remapped address decoding for master */
#define   HMATRIXB_MRCR_RCB15_1     (0x1u << 15) /**< \brief (HMATRIXB_MRCR) Enable remapped address decoding for master */
/* -------- HMATRIXB_SFR : (HMATRIXB Offset: 0x110) Sfr Special Function Register 0 -------- */
#define HMATRIXB_SFR_SFR_Pos        0
#define HMATRIXB_SFR_SFR_Msk        (0xFFFFFFFFu << HMATRIXB_SFR_SFR_Pos) /**< \brief (HMATRIXB_SFR) Special Function Register */
#define HMATRIXB_SFR_SFR(value)     ((HMATRIXB_SFR_SFR_Msk & ((value) << HMATRIXB_SFR_SFR_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR IISC */
/* ============================================================================= */
/** \addtogroup SAM4L4_IISC Inter-IC Sound (I2S) Controller */
/*@{*/

#define REV_IISC       0x100

#ifndef __ASSEMBLY__
/** \brief IISC hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (IISC Offset: 0x00) Control Register */
  RwReg   MR;          /**< \brief (IISC Offset: 0x04) Mode Register */
  RoReg   SR;          /**< \brief (IISC Offset: 0x08) Status Register */
  WoReg   SCR;         /**< \brief (IISC Offset: 0x0C) Status Clear Register */
  WoReg   SSR;         /**< \brief (IISC Offset: 0x10) Status Set Register */
  WoReg   IER;         /**< \brief (IISC Offset: 0x14) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (IISC Offset: 0x18) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (IISC Offset: 0x1C) Interrupt Mask Register */
  RoReg   RHR;         /**< \brief (IISC Offset: 0x20) Receive Holding Register */
  WoReg   THR;         /**< \brief (IISC Offset: 0x24) Transmit Holding Register */
  RoReg   VERSION;     /**< \brief (IISC Offset: 0x28) Version Register */
  RoReg   PARAMETER;   /**< \brief (IISC Offset: 0x2C) Parameter Register */
} Iisc;
#endif /* __ASSEMBLY__ */
/* -------- IISC_CR : (IISC Offset: 0x00) Control Register -------- */
#define IISC_CR_RXEN                (0x1u <<  0) /**< \brief (IISC_CR) Receive Enable */
#define   IISC_CR_RXEN_OFF          (0x0u <<  0) /**< \brief (IISC_CR) No effect */
#define   IISC_CR_RXEN_ON           (0x1u <<  0) /**< \brief (IISC_CR) Enables Data Receive if RXDIS is not set */
#define IISC_CR_RXDIS               (0x1u <<  1) /**< \brief (IISC_CR) Receive Disable */
#define   IISC_CR_RXDIS_OFF         (0x0u <<  1) /**< \brief (IISC_CR) No effect */
#define   IISC_CR_RXDIS_ON          (0x1u <<  1) /**< \brief (IISC_CR) Disables Data Receive */
#define IISC_CR_CKEN                (0x1u <<  2) /**< \brief (IISC_CR) Clocks Enable */
#define   IISC_CR_CKEN_OFF          (0x0u <<  2) /**< \brief (IISC_CR) No effect */
#define   IISC_CR_CKEN_ON           (0x1u <<  2) /**< \brief (IISC_CR) Enables clocks if CKDIS is not set */
#define IISC_CR_CKDIS               (0x1u <<  3) /**< \brief (IISC_CR) Clocks Disable */
#define   IISC_CR_CKDIS_OFF         (0x0u <<  3) /**< \brief (IISC_CR) No effect */
#define   IISC_CR_CKDIS_ON          (0x1u <<  3) /**< \brief (IISC_CR) Disables clocks */
#define IISC_CR_TXEN                (0x1u <<  4) /**< \brief (IISC_CR) Transmit Enable */
#define   IISC_CR_TXEN_OFF          (0x0u <<  4) /**< \brief (IISC_CR) No effect */
#define   IISC_CR_TXEN_ON           (0x1u <<  4) /**< \brief (IISC_CR) Enables Data Transmit if TXDIS is not set */
#define IISC_CR_TXDIS               (0x1u <<  5) /**< \brief (IISC_CR) Transmit Disable */
#define   IISC_CR_TXDIS_OFF         (0x0u <<  5) /**< \brief (IISC_CR) No effect */
#define   IISC_CR_TXDIS_ON          (0x1u <<  5) /**< \brief (IISC_CR) Disables Data Transmit */
#define IISC_CR_SWRST               (0x1u <<  7) /**< \brief (IISC_CR) Software Reset */
#define   IISC_CR_SWRST_OFF         (0x0u <<  7) /**< \brief (IISC_CR) No effect */
#define   IISC_CR_SWRST_ON          (0x1u <<  7) /**< \brief (IISC_CR) Performs a software reset. Has priority on any other bit in CR */
/* -------- IISC_MR : (IISC Offset: 0x04) Mode Register -------- */
#define IISC_MR_MODE                (0x1u <<  0) /**< \brief (IISC_MR) Master/Slave/Controller Mode */
#define   IISC_MR_MODE_SLAVE        (0x0u <<  0) /**< \brief (IISC_MR) Slave mode (only serial data handled, clocks received from external master or controller) */
#define   IISC_MR_MODE_MASTER       (0x1u <<  0) /**< \brief (IISC_MR) Master mode (clocks generated and output by IISC, serial data handled if CR.RXEN and/or CR.TXEN written to 1) */
#define IISC_MR_DATALENGTH_Pos      2
#define IISC_MR_DATALENGTH_Msk      (0x7u << IISC_MR_DATALENGTH_Pos) /**< \brief (IISC_MR) Data Word Length */
#define IISC_MR_DATALENGTH(value)   ((IISC_MR_DATALENGTH_Msk & ((value) << IISC_MR_DATALENGTH_Pos)))
#define   IISC_MR_DATALENGTH_32     (0x0u <<  2) /**< \brief (IISC_MR) 32 bits */
#define   IISC_MR_DATALENGTH_24     (0x1u <<  2) /**< \brief (IISC_MR) 24 bits */
#define   IISC_MR_DATALENGTH_20     (0x2u <<  2) /**< \brief (IISC_MR) 20 bits */
#define   IISC_MR_DATALENGTH_18     (0x3u <<  2) /**< \brief (IISC_MR) 18 bits */
#define   IISC_MR_DATALENGTH_16     (0x4u <<  2) /**< \brief (IISC_MR) 16 bits */
#define   IISC_MR_DATALENGTH_16C    (0x5u <<  2) /**< \brief (IISC_MR) 16 bits compact stereo */
#define   IISC_MR_DATALENGTH_8      (0x6u <<  2) /**< \brief (IISC_MR) 8 bits */
#define   IISC_MR_DATALENGTH_8C     (0x7u <<  2) /**< \brief (IISC_MR) 8 bits compact stereo */
#define IISC_MR_RXMONO              (0x1u <<  8) /**< \brief (IISC_MR) Receiver Mono */
#define   IISC_MR_RXMONO_STEREO     (0x0u <<  8) /**< \brief (IISC_MR) Normal mode */
#define   IISC_MR_RXMONO_MONO       (0x1u <<  8) /**< \brief (IISC_MR) Left channel data is duplicated to right channel */
#define IISC_MR_RXDMA               (0x1u <<  9) /**< \brief (IISC_MR) Single or Multiple DMA Channels for Receiver */
#define   IISC_MR_RXDMA_SINGLE      (0x0u <<  9) /**< \brief (IISC_MR) Single DMA channel */
#define   IISC_MR_RXDMA_MULTIPLE    (0x1u <<  9) /**< \brief (IISC_MR) One DMA channel per data channel */
#define IISC_MR_RXLOOP              (0x1u << 10) /**< \brief (IISC_MR) Loop-back Test Mode */
#define   IISC_MR_RXLOOP_OFF        (0x0u << 10) /**< \brief (IISC_MR) Normal mode */
#define   IISC_MR_RXLOOP_ON         (0x1u << 10) /**< \brief (IISC_MR) ISDO internally connected to ISDI */
#define IISC_MR_TXMONO              (0x1u << 12) /**< \brief (IISC_MR) Transmitter Mono */
#define   IISC_MR_TXMONO_STEREO     (0x0u << 12) /**< \brief (IISC_MR) Normal mode */
#define   IISC_MR_TXMONO_MONO       (0x1u << 12) /**< \brief (IISC_MR) Left channel data is duplicated to right channel */
#define IISC_MR_TXDMA               (0x1u << 13) /**< \brief (IISC_MR) Single or Multiple DMA Channels for Transmitter */
#define   IISC_MR_TXDMA_SINGLE      (0x0u << 13) /**< \brief (IISC_MR) Single DMA channel */
#define   IISC_MR_TXDMA_MULTIPLE    (0x1u << 13) /**< \brief (IISC_MR) One DMA channel per data channel */
#define IISC_MR_TXSAME              (0x1u << 14) /**< \brief (IISC_MR) Transmit Data when Underrun */
#define   IISC_MR_TXSAME_ZERO       (0x0u << 14) /**< \brief (IISC_MR) Zero data transmitted in case of underrun */
#define   IISC_MR_TXSAME_SAME       (0x1u << 14) /**< \brief (IISC_MR) Last data transmitted in case of underrun */
#define IISC_MR_IMCKFS_Pos          24
#define IISC_MR_IMCKFS_Msk          (0x3Fu << IISC_MR_IMCKFS_Pos) /**< \brief (IISC_MR) Master Clock to fs Ratio */
#define IISC_MR_IMCKFS(value)       ((IISC_MR_IMCKFS_Msk & ((value) << IISC_MR_IMCKFS_Pos)))
#define   IISC_MR_IMCKFS_16         (0x0u << 24) /**< \brief (IISC_MR) 16 fs */
#define   IISC_MR_IMCKFS_32         (0x1u << 24) /**< \brief (IISC_MR) 32 fs */
#define   IISC_MR_IMCKFS_64         (0x3u << 24) /**< \brief (IISC_MR) 64 fs */
#define   IISC_MR_IMCKFS_128        (0x7u << 24) /**< \brief (IISC_MR) 128 fs */
#define   IISC_MR_IMCKFS_256        (0xFu << 24) /**< \brief (IISC_MR) 256 fs */
#define   IISC_MR_IMCKFS_384        (0x17u << 24) /**< \brief (IISC_MR) 384 fs */
#define   IISC_MR_IMCKFS_512        (0x1Fu << 24) /**< \brief (IISC_MR) 512 fs */
#define   IISC_MR_IMCKFS_768        (0x2Fu << 24) /**< \brief (IISC_MR) 768 fs */
#define   IISC_MR_IMCKFS_1024       (0x3Fu << 24) /**< \brief (IISC_MR) 1024 fs */
#define IISC_MR_IMCKMODE            (0x1u << 30) /**< \brief (IISC_MR) Master Clock Mode */
#define   IISC_MR_IMCKMODE_NO_IMCK  (0x0u << 30) /**< \brief (IISC_MR) No IMCK generated */
#define   IISC_MR_IMCKMODE_IMCK     (0x1u << 30) /**< \brief (IISC_MR) IMCK generated */
#define IISC_MR_IWS24               (0x1u << 31) /**< \brief (IISC_MR) IWS Data Slot Width */
#define   IISC_MR_IWS24_32          (0x0u << 31) /**< \brief (IISC_MR) IWS Data Slot is 32-bit wide for DATALENGTH=18/20/24-bit */
#define   IISC_MR_IWS24_24          (0x1u << 31) /**< \brief (IISC_MR) IWS Data Slot is 24-bit wide for DATALENGTH=18/20/24-bit */
/* -------- IISC_SR : (IISC Offset: 0x08) Status Register -------- */
#define IISC_SR_RXEN                (0x1u <<  0) /**< \brief (IISC_SR) Receive Enable */
#define   IISC_SR_RXEN_OFF          (0x0u <<  0) /**< \brief (IISC_SR) Receiver is effectively disabled, following a CR.RXDIS or CR.SWRST request */
#define   IISC_SR_RXEN_ON           (0x1u <<  0) /**< \brief (IISC_SR) Receiver is effectively enabled, following a CR.RXEN request */
#define IISC_SR_RXRDY               (0x1u <<  1) /**< \brief (IISC_SR) Receive Ready */
#define   IISC_SR_RXRDY_EMPTY       (0x0u <<  1) /**< \brief (IISC_SR) The register RHR is empty and can't be read */
#define   IISC_SR_RXRDY_FULL        (0x1u <<  1) /**< \brief (IISC_SR) The register RHR is full and is ready to be read */
#define IISC_SR_RXOR                (0x1u <<  2) /**< \brief (IISC_SR) Receive Overrun */
#define   IISC_SR_RXOR_NO           (0x0u <<  2) /**< \brief (IISC_SR) No overrun */
#define   IISC_SR_RXOR_YES          (0x1u <<  2) /**< \brief (IISC_SR) The previous received data has not been read. This data is lost */
#define IISC_SR_TXEN                (0x1u <<  4) /**< \brief (IISC_SR) Transmit Enable */
#define   IISC_SR_TXEN_OFF          (0x0u <<  4) /**< \brief (IISC_SR) Transmitter is effectively disabled, following a CR.TXDIS or CR.SWRST request */
#define   IISC_SR_TXEN_ON           (0x1u <<  4) /**< \brief (IISC_SR) Transmitter is effectively enabled, following a CR.TXEN request */
#define IISC_SR_TXRDY               (0x1u <<  5) /**< \brief (IISC_SR) Transmit Ready */
#define   IISC_SR_TXRDY_FULL        (0x0u <<  5) /**< \brief (IISC_SR) The register THR is full and can't be written */
#define   IISC_SR_TXRDY_EMPTY       (0x1u <<  5) /**< \brief (IISC_SR) The register THR is empty and is ready to be written */
#define IISC_SR_TXUR                (0x1u <<  6) /**< \brief (IISC_SR) Transmit Underrun */
#define   IISC_SR_TXUR_NO           (0x0u <<  6) /**< \brief (IISC_SR) No underrun */
#define   IISC_SR_TXUR_YES          (0x1u <<  6) /**< \brief (IISC_SR) The last bit of the last data written to the register THR has been set. Until the next write to THR, data will be sent according to MR.TXSAME field */
#define IISC_SR_RXORCH_Pos          8
#define IISC_SR_RXORCH_Msk          (0x3u << IISC_SR_RXORCH_Pos) /**< \brief (IISC_SR) Receive Overrun Channels */
#define IISC_SR_RXORCH(value)       ((IISC_SR_RXORCH_Msk & ((value) << IISC_SR_RXORCH_Pos)))
#define   IISC_SR_RXORCH_LEFT       (0x0u <<  8) /**< \brief (IISC_SR) Overrun first occurred on left channel */
#define   IISC_SR_RXORCH_RIGHT      (0x1u <<  8) /**< \brief (IISC_SR) Overrun first occurred on right channel */
#define IISC_SR_TXURCH_Pos          20
#define IISC_SR_TXURCH_Msk          (0x3u << IISC_SR_TXURCH_Pos) /**< \brief (IISC_SR) Transmit Underrun Channels */
#define IISC_SR_TXURCH(value)       ((IISC_SR_TXURCH_Msk & ((value) << IISC_SR_TXURCH_Pos)))
#define   IISC_SR_TXURCH_LEFT       (0x0u << 20) /**< \brief (IISC_SR) Underrun first occurred on left channel */
#define   IISC_SR_TXURCH_RIGHT      (0x1u << 20) /**< \brief (IISC_SR) Underrun first occurred on right channel */
/* -------- IISC_SCR : (IISC Offset: 0x0C) Status Clear Register -------- */
#define IISC_SCR_RXOR               (0x1u <<  2) /**< \brief (IISC_SCR) Receive Overrun */
#define   IISC_SCR_RXOR_NO          (0x0u <<  2) /**< \brief (IISC_SCR) No effect */
#define   IISC_SCR_RXOR_CLEAR       (0x1u <<  2) /**< \brief (IISC_SCR) Clears the corresponding SR bit */
#define IISC_SCR_TXUR               (0x1u <<  6) /**< \brief (IISC_SCR) Transmit Underrun */
#define   IISC_SCR_TXUR_NO          (0x0u <<  6) /**< \brief (IISC_SCR) No effect */
#define   IISC_SCR_TXUR_CLEAR       (0x1u <<  6) /**< \brief (IISC_SCR) Clears the corresponding SR bit */
#define IISC_SCR_RXORCH_Pos         8
#define IISC_SCR_RXORCH_Msk         (0x3u << IISC_SCR_RXORCH_Pos) /**< \brief (IISC_SCR) Receive Overrun Channels */
#define IISC_SCR_RXORCH(value)      ((IISC_SCR_RXORCH_Msk & ((value) << IISC_SCR_RXORCH_Pos)))
#define IISC_SCR_TXURCH_Pos         20
#define IISC_SCR_TXURCH_Msk         (0x3u << IISC_SCR_TXURCH_Pos) /**< \brief (IISC_SCR) Transmit Underrun Channels */
#define IISC_SCR_TXURCH(value)      ((IISC_SCR_TXURCH_Msk & ((value) << IISC_SCR_TXURCH_Pos)))
/* -------- IISC_SSR : (IISC Offset: 0x10) Status Set Register -------- */
#define IISC_SSR_RXOR               (0x1u <<  2) /**< \brief (IISC_SSR) Receive Overrun */
#define   IISC_SSR_RXOR_NO          (0x0u <<  2) /**< \brief (IISC_SSR) No effect */
#define   IISC_SSR_RXOR_SET         (0x1u <<  2) /**< \brief (IISC_SSR) Sets corresponding SR bit */
#define IISC_SSR_TXUR               (0x1u <<  6) /**< \brief (IISC_SSR) Transmit Underrun */
#define   IISC_SSR_TXUR_NO          (0x0u <<  6) /**< \brief (IISC_SSR) No effect */
#define   IISC_SSR_TXUR_SET         (0x1u <<  6) /**< \brief (IISC_SSR) Sets corresponding SR bit */
#define IISC_SSR_RXORCH_Pos         8
#define IISC_SSR_RXORCH_Msk         (0x3u << IISC_SSR_RXORCH_Pos) /**< \brief (IISC_SSR) Receive Overrun Channels */
#define IISC_SSR_RXORCH(value)      ((IISC_SSR_RXORCH_Msk & ((value) << IISC_SSR_RXORCH_Pos)))
#define IISC_SSR_TXURCH_Pos         20
#define IISC_SSR_TXURCH_Msk         (0x3u << IISC_SSR_TXURCH_Pos) /**< \brief (IISC_SSR) Transmit Underrun Channels */
#define IISC_SSR_TXURCH(value)      ((IISC_SSR_TXURCH_Msk & ((value) << IISC_SSR_TXURCH_Pos)))
/* -------- IISC_IER : (IISC Offset: 0x14) Interrupt Enable Register -------- */
#define IISC_IER_RXRDY              (0x1u <<  1) /**< \brief (IISC_IER) Receiver Ready Interrupt Enable */
#define   IISC_IER_RXRDY_OFF        (0x0u <<  1) /**< \brief (IISC_IER) No effect */
#define   IISC_IER_RXRDY_ON         (0x1u <<  1) /**< \brief (IISC_IER) Enables the corresponding interrupt */
#define IISC_IER_RXOR               (0x1u <<  2) /**< \brief (IISC_IER) Receive Overrun Interrupt Enable */
#define   IISC_IER_RXOR_OFF         (0x0u <<  2) /**< \brief (IISC_IER) No effect */
#define   IISC_IER_RXOR_ON          (0x1u <<  2) /**< \brief (IISC_IER) Enables the corresponding interrupt */
#define IISC_IER_TXRDY              (0x1u <<  5) /**< \brief (IISC_IER) Transmit Ready Interrupt Enable */
#define   IISC_IER_TXRDY_OFF        (0x0u <<  5) /**< \brief (IISC_IER) No effect */
#define   IISC_IER_TXRDY_ON         (0x1u <<  5) /**< \brief (IISC_IER) Enables the corresponding interrupt */
#define IISC_IER_TXUR               (0x1u <<  6) /**< \brief (IISC_IER) Transmit Underrun Interrupt Enable */
#define   IISC_IER_TXUR_OFF         (0x0u <<  6) /**< \brief (IISC_IER) No effect */
#define   IISC_IER_TXUR_ON          (0x1u <<  6) /**< \brief (IISC_IER) Enables the corresponding interrupt */
/* -------- IISC_IDR : (IISC Offset: 0x18) Interrupt Disable Register -------- */
#define IISC_IDR_RXRDY              (0x1u <<  1) /**< \brief (IISC_IDR) Receive Ready Interrupt Disable */
#define   IISC_IDR_RXRDY_OFF        (0x0u <<  1) /**< \brief (IISC_IDR) No effect */
#define   IISC_IDR_RXRDY_ON         (0x1u <<  1) /**< \brief (IISC_IDR) Disables the corresponding interrupt */
#define IISC_IDR_RXOR               (0x1u <<  2) /**< \brief (IISC_IDR) Receive Overrun Interrupt Disable */
#define   IISC_IDR_RXOR_OFF         (0x0u <<  2) /**< \brief (IISC_IDR) No effect */
#define   IISC_IDR_RXOR_ON          (0x1u <<  2) /**< \brief (IISC_IDR) Disables the corresponding interrupt */
#define IISC_IDR_TXRDY              (0x1u <<  5) /**< \brief (IISC_IDR) Transmit Ready Interrupt Disable */
#define   IISC_IDR_TXRDY_OFF        (0x0u <<  5) /**< \brief (IISC_IDR) No effect */
#define   IISC_IDR_TXRDY_ON         (0x1u <<  5) /**< \brief (IISC_IDR) Disables the corresponding interrupt */
#define IISC_IDR_TXUR               (0x1u <<  6) /**< \brief (IISC_IDR) Transmit Underrun Interrupt Disable */
#define   IISC_IDR_TXUR_OFF         (0x0u <<  6) /**< \brief (IISC_IDR) No effect */
#define   IISC_IDR_TXUR_ON          (0x1u <<  6) /**< \brief (IISC_IDR) Disables the corresponding interrupt */
/* -------- IISC_IMR : (IISC Offset: 0x1C) Interrupt Mask Register -------- */
#define IISC_IMR_RXRDY              (0x1u <<  1) /**< \brief (IISC_IMR) Receive Ready Interrupt Mask */
#define   IISC_IMR_RXRDY_DISABLED   (0x0u <<  1) /**< \brief (IISC_IMR) The corresponding interrupt is disabled */
#define   IISC_IMR_RXRDY_ENABLED    (0x1u <<  1) /**< \brief (IISC_IMR) The corresponding interrupt is enabled */
#define IISC_IMR_RXOR               (0x1u <<  2) /**< \brief (IISC_IMR) Receive Overrun Interrupt Mask */
#define   IISC_IMR_RXOR_DISABLED    (0x0u <<  2) /**< \brief (IISC_IMR) The corresponding interrupt is disabled */
#define   IISC_IMR_RXOR_ENABLED     (0x1u <<  2) /**< \brief (IISC_IMR) The corresponding interrupt is enabled */
#define IISC_IMR_TXRDY              (0x1u <<  5) /**< \brief (IISC_IMR) Transmit Ready Interrupt Mask */
#define   IISC_IMR_TXRDY_DISABLED   (0x0u <<  5) /**< \brief (IISC_IMR) The corresponding interrupt is disabled */
#define   IISC_IMR_TXRDY_ENABLED    (0x1u <<  5) /**< \brief (IISC_IMR) The corresponding interrupt is enabled */
#define IISC_IMR_TXUR               (0x1u <<  6) /**< \brief (IISC_IMR) Transmit Underrun Interrupt Mask */
#define   IISC_IMR_TXUR_DISABLED    (0x0u <<  6) /**< \brief (IISC_IMR) The corresponding interrupt is disabled */
#define   IISC_IMR_TXUR_ENABLED     (0x1u <<  6) /**< \brief (IISC_IMR) The corresponding interrupt is enabled */
/* -------- IISC_RHR : (IISC Offset: 0x20) Receive Holding Register -------- */
#define IISC_RHR_RDAT_Pos           0
#define IISC_RHR_RDAT_Msk           (0xFFFFFFFFu << IISC_RHR_RDAT_Pos) /**< \brief (IISC_RHR) Receive Data */
#define IISC_RHR_RDAT(value)        ((IISC_RHR_RDAT_Msk & ((value) << IISC_RHR_RDAT_Pos)))
/* -------- IISC_THR : (IISC Offset: 0x24) Transmit Holding Register -------- */
#define IISC_THR_TDAT_Pos           0
#define IISC_THR_TDAT_Msk           (0xFFFFFFFFu << IISC_THR_TDAT_Pos) /**< \brief (IISC_THR) Transmit Data */
#define IISC_THR_TDAT(value)        ((IISC_THR_TDAT_Msk & ((value) << IISC_THR_TDAT_Pos)))
/* -------- IISC_VERSION : (IISC Offset: 0x28) Version Register -------- */
#define IISC_VERSION_VERSION_Pos    0
#define IISC_VERSION_VERSION_Msk    (0xFFFu << IISC_VERSION_VERSION_Pos) /**< \brief (IISC_VERSION) Reserved. Value subject to change. No functionality associated. This is the Atmel internal version of the macrocell. */
#define IISC_VERSION_VERSION(value) ((IISC_VERSION_VERSION_Msk & ((value) << IISC_VERSION_VERSION_Pos)))
#define IISC_VERSION_VARIANT_Pos    16
#define IISC_VERSION_VARIANT_Msk    (0xFu << IISC_VERSION_VARIANT_Pos) /**< \brief (IISC_VERSION) Reserved. Value subject to change. No functionality associated. */
#define IISC_VERSION_VARIANT(value) ((IISC_VERSION_VARIANT_Msk & ((value) << IISC_VERSION_VARIANT_Pos)))
/* -------- IISC_PARAMETER : (IISC Offset: 0x2C) Parameter Register -------- */
#define IISC_PARAMETER_FORMAT       (0x1u <<  7) /**< \brief (IISC_PARAMETER) Data protocol format */
#define   IISC_PARAMETER_FORMAT_I2S (0x0u <<  7) /**< \brief (IISC_PARAMETER) I2S format, stereo with IWS low for left channel */
#define IISC_PARAMETER_NBCHAN_Pos    16
#define IISC_PARAMETER_NBCHAN_Msk    (0x1Fu << IISC_PARAMETER_NBCHAN_Pos) /**< \brief (IISC_PARAMETER) Maximum number of channels - 1 */
#define IISC_PARAMETER_NBCHAN(value) ((IISC_PARAMETER_NBCHAN_Msk & ((value) << IISC_PARAMETER_NBCHAN_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR LCDCA */
/* ============================================================================= */
/** \addtogroup SAM4L4_LCDCA LCD Controller */
/*@{*/

#define REV_LCDCA      0x100

#ifndef __ASSEMBLY__
/** \brief LCDCA hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (LCDCA Offset: 0x00) Control Register */
  RwReg   CFG;         /**< \brief (LCDCA Offset: 0x04) Configuration Register */
  RwReg   TIM;         /**< \brief (LCDCA Offset: 0x08) Timing Register */
  RoReg   SR;          /**< \brief (LCDCA Offset: 0x0C) Status Register */
  WoReg   SCR;         /**< \brief (LCDCA Offset: 0x10) Status Clear Register */
  RwReg   DRL0;        /**< \brief (LCDCA Offset: 0x14) Data Register Low 0 */
  RwReg   DRH0;        /**< \brief (LCDCA Offset: 0x18) Data Register High 0 */
  RwReg   DRL1;        /**< \brief (LCDCA Offset: 0x1C) Data Register Low 1 */
  RwReg   DRH1;        /**< \brief (LCDCA Offset: 0x20) Data Register High 1 */
  RwReg   DRL2;        /**< \brief (LCDCA Offset: 0x24) Data Register Low 2 */
  RwReg   DRH2;        /**< \brief (LCDCA Offset: 0x28) Data Register High 2 */
  RwReg   DRL3;        /**< \brief (LCDCA Offset: 0x2C) Data Register Low 3 */
  RwReg   DRH3;        /**< \brief (LCDCA Offset: 0x30) Data Register High 3 */
  WoReg   IADR;        /**< \brief (LCDCA Offset: 0x34) Indirect Access Data Register */
  RwReg   BCFG;        /**< \brief (LCDCA Offset: 0x38) Blink Configuration Register */
  RwReg   CSRCFG;      /**< \brief (LCDCA Offset: 0x3C) Circular Shift Register Configuration */
  RwReg   CMCFG;       /**< \brief (LCDCA Offset: 0x40) Character Mapping Configuration Register */
  WoReg   CMDR;        /**< \brief (LCDCA Offset: 0x44) Character Mapping Data Register */
  RwReg   ACMCFG;      /**< \brief (LCDCA Offset: 0x48) Automated Character Mapping Configuration Register */
  WoReg   ACMDR;       /**< \brief (LCDCA Offset: 0x4C) Automated Character Mapping Data Register */
  RwReg   ABMCFG;      /**< \brief (LCDCA Offset: 0x50) Automated Bit Mapping Configuration Register */
  WoReg   ABMDR;       /**< \brief (LCDCA Offset: 0x54) Automated Bit Mapping Data Register */
  WoReg   IER;         /**< \brief (LCDCA Offset: 0x58) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (LCDCA Offset: 0x5C) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (LCDCA Offset: 0x60) Interrupt Mask Register */
  RoReg   VERSION;     /**< \brief (LCDCA Offset: 0x64) Version Register */
} Lcdca;
#endif /* __ASSEMBLY__ */
/* -------- LCDCA_CR : (LCDCA Offset: 0x00) Control Register -------- */
#define LCDCA_CR_DIS                (0x1u <<  0) /**< \brief (LCDCA_CR) Disable */
#define LCDCA_CR_EN                 (0x1u <<  1) /**< \brief (LCDCA_CR) Enable */
#define LCDCA_CR_FC0DIS             (0x1u <<  2) /**< \brief (LCDCA_CR) Frame Counter 0 Disable */
#define LCDCA_CR_FC0EN              (0x1u <<  3) /**< \brief (LCDCA_CR) Frame Counter 0 Enable */
#define LCDCA_CR_FC1DIS             (0x1u <<  4) /**< \brief (LCDCA_CR) Frame Counter 1 Disable */
#define LCDCA_CR_FC1EN              (0x1u <<  5) /**< \brief (LCDCA_CR) Frame Counter 1 Enable */
#define LCDCA_CR_FC2DIS             (0x1u <<  6) /**< \brief (LCDCA_CR) Frame Counter 2 Disable */
#define LCDCA_CR_FC2EN              (0x1u <<  7) /**< \brief (LCDCA_CR) Frame Counter 2 Enable */
#define LCDCA_CR_CDM                (0x1u <<  8) /**< \brief (LCDCA_CR) Clear Display Memory */
#define LCDCA_CR_WDIS               (0x1u <<  9) /**< \brief (LCDCA_CR) Wake up Disable */
#define LCDCA_CR_WEN                (0x1u << 10) /**< \brief (LCDCA_CR) Wake up Enable */
#define LCDCA_CR_BSTART             (0x1u << 11) /**< \brief (LCDCA_CR) Blinking Start */
#define LCDCA_CR_BSTOP              (0x1u << 12) /**< \brief (LCDCA_CR) Blinking Stop */
#define LCDCA_CR_CSTART             (0x1u << 13) /**< \brief (LCDCA_CR) Circular Shift Start */
#define LCDCA_CR_CSTOP              (0x1u << 14) /**< \brief (LCDCA_CR) Circular Shift Stop */
/* -------- LCDCA_CFG : (LCDCA Offset: 0x04) Configuration Register -------- */
#define LCDCA_CFG_XBIAS             (0x1u <<  0) /**< \brief (LCDCA_CFG) External Bias Generation */
#define LCDCA_CFG_WMOD              (0x1u <<  1) /**< \brief (LCDCA_CFG) Waveform Mode */
#define LCDCA_CFG_BLANK             (0x1u <<  2) /**< \brief (LCDCA_CFG) Blank LCD */
#define LCDCA_CFG_LOCK              (0x1u <<  3) /**< \brief (LCDCA_CFG) Lock */
#define LCDCA_CFG_DUTY_Pos          8
#define LCDCA_CFG_DUTY_Msk          (0x3u << LCDCA_CFG_DUTY_Pos) /**< \brief (LCDCA_CFG) Duty Select */
#define LCDCA_CFG_DUTY(value)       ((LCDCA_CFG_DUTY_Msk & ((value) << LCDCA_CFG_DUTY_Pos)))
#define LCDCA_CFG_FCST_Pos          16
#define LCDCA_CFG_FCST_Msk          (0x3Fu << LCDCA_CFG_FCST_Pos) /**< \brief (LCDCA_CFG) Fine Contrast */
#define LCDCA_CFG_FCST(value)       ((LCDCA_CFG_FCST_Msk & ((value) << LCDCA_CFG_FCST_Pos)))
#define LCDCA_CFG_NSU_Pos           24
#define LCDCA_CFG_NSU_Msk           (0x3Fu << LCDCA_CFG_NSU_Pos) /**< \brief (LCDCA_CFG) Number of Segment Terminals in Use */
#define LCDCA_CFG_NSU(value)        ((LCDCA_CFG_NSU_Msk & ((value) << LCDCA_CFG_NSU_Pos)))
/* -------- LCDCA_TIM : (LCDCA Offset: 0x08) Timing Register -------- */
#define LCDCA_TIM_PRESC             (0x1u <<  0) /**< \brief (LCDCA_TIM) LCD Prescaler Select */
#define LCDCA_TIM_CLKDIV_Pos        1
#define LCDCA_TIM_CLKDIV_Msk        (0x7u << LCDCA_TIM_CLKDIV_Pos) /**< \brief (LCDCA_TIM) LCD Clock Division */
#define LCDCA_TIM_CLKDIV(value)     ((LCDCA_TIM_CLKDIV_Msk & ((value) << LCDCA_TIM_CLKDIV_Pos)))
#define LCDCA_TIM_FC0_Pos           8
#define LCDCA_TIM_FC0_Msk           (0x1Fu << LCDCA_TIM_FC0_Pos) /**< \brief (LCDCA_TIM) Frame Counter 0 */
#define LCDCA_TIM_FC0(value)        ((LCDCA_TIM_FC0_Msk & ((value) << LCDCA_TIM_FC0_Pos)))
#define LCDCA_TIM_FC0PB             (0x1u << 13) /**< \brief (LCDCA_TIM) Frame Counter 0 Prescaler Bypass */
#define LCDCA_TIM_FC1_Pos           16
#define LCDCA_TIM_FC1_Msk           (0x1Fu << LCDCA_TIM_FC1_Pos) /**< \brief (LCDCA_TIM) Frame Counter 1 */
#define LCDCA_TIM_FC1(value)        ((LCDCA_TIM_FC1_Msk & ((value) << LCDCA_TIM_FC1_Pos)))
#define LCDCA_TIM_FC2_Pos           24
#define LCDCA_TIM_FC2_Msk           (0x1Fu << LCDCA_TIM_FC2_Pos) /**< \brief (LCDCA_TIM) Frame Counter 2 */
#define LCDCA_TIM_FC2(value)        ((LCDCA_TIM_FC2_Msk & ((value) << LCDCA_TIM_FC2_Pos)))
/* -------- LCDCA_SR : (LCDCA Offset: 0x0C) Status Register -------- */
#define LCDCA_SR_FC0R               (0x1u <<  0) /**< \brief (LCDCA_SR) Frame Counter 0 Rollover */
#define LCDCA_SR_FC0S               (0x1u <<  1) /**< \brief (LCDCA_SR) Frame Counter 0 Status */
#define LCDCA_SR_FC1S               (0x1u <<  2) /**< \brief (LCDCA_SR) Frame Counter 1 Status */
#define LCDCA_SR_FC2S               (0x1u <<  3) /**< \brief (LCDCA_SR) Frame Counter 2 Status */
#define LCDCA_SR_EN                 (0x1u <<  4) /**< \brief (LCDCA_SR) LCDCA Status */
#define LCDCA_SR_WEN                (0x1u <<  5) /**< \brief (LCDCA_SR) Wake up Status */
#define LCDCA_SR_BLKS               (0x1u <<  6) /**< \brief (LCDCA_SR) Blink Status */
#define LCDCA_SR_CSRS               (0x1u <<  7) /**< \brief (LCDCA_SR) Circular Shift Register Status */
#define LCDCA_SR_CPS                (0x1u <<  8) /**< \brief (LCDCA_SR) Charge Pump Status */
/* -------- LCDCA_SCR : (LCDCA Offset: 0x10) Status Clear Register -------- */
#define LCDCA_SCR_FC0R              (0x1u <<  0) /**< \brief (LCDCA_SCR) Frame Counter 0 Rollover */
/* -------- LCDCA_DRL0 : (LCDCA Offset: 0x14) Data Register Low 0 -------- */
#define LCDCA_DRL0_DATA_Pos         0
#define LCDCA_DRL0_DATA_Msk         (0xFFFFFFFFu << LCDCA_DRL0_DATA_Pos) /**< \brief (LCDCA_DRL0) Segments Value */
#define LCDCA_DRL0_DATA(value)      ((LCDCA_DRL0_DATA_Msk & ((value) << LCDCA_DRL0_DATA_Pos)))
/* -------- LCDCA_DRH0 : (LCDCA Offset: 0x18) Data Register High 0 -------- */
#define LCDCA_DRH0_DATA_Pos         0
#define LCDCA_DRH0_DATA_Msk         (0xFFu << LCDCA_DRH0_DATA_Pos) /**< \brief (LCDCA_DRH0) Segments Value */
#define LCDCA_DRH0_DATA(value)      ((LCDCA_DRH0_DATA_Msk & ((value) << LCDCA_DRH0_DATA_Pos)))
/* -------- LCDCA_DRL1 : (LCDCA Offset: 0x1C) Data Register Low 1 -------- */
#define LCDCA_DRL1_DATA_Pos         0
#define LCDCA_DRL1_DATA_Msk         (0xFFFFFFFFu << LCDCA_DRL1_DATA_Pos) /**< \brief (LCDCA_DRL1) Segments Value */
#define LCDCA_DRL1_DATA(value)      ((LCDCA_DRL1_DATA_Msk & ((value) << LCDCA_DRL1_DATA_Pos)))
/* -------- LCDCA_DRH1 : (LCDCA Offset: 0x20) Data Register High 1 -------- */
#define LCDCA_DRH1_DATA_Pos         0
#define LCDCA_DRH1_DATA_Msk         (0xFFu << LCDCA_DRH1_DATA_Pos) /**< \brief (LCDCA_DRH1) Segments Value */
#define LCDCA_DRH1_DATA(value)      ((LCDCA_DRH1_DATA_Msk & ((value) << LCDCA_DRH1_DATA_Pos)))
/* -------- LCDCA_DRL2 : (LCDCA Offset: 0x24) Data Register Low 2 -------- */
#define LCDCA_DRL2_DATA_Pos         0
#define LCDCA_DRL2_DATA_Msk         (0xFFFFFFFFu << LCDCA_DRL2_DATA_Pos) /**< \brief (LCDCA_DRL2) Segments Value */
#define LCDCA_DRL2_DATA(value)      ((LCDCA_DRL2_DATA_Msk & ((value) << LCDCA_DRL2_DATA_Pos)))
/* -------- LCDCA_DRH2 : (LCDCA Offset: 0x28) Data Register High 2 -------- */
#define LCDCA_DRH2_DATA_Pos         0
#define LCDCA_DRH2_DATA_Msk         (0xFFu << LCDCA_DRH2_DATA_Pos) /**< \brief (LCDCA_DRH2) Segments Value */
#define LCDCA_DRH2_DATA(value)      ((LCDCA_DRH2_DATA_Msk & ((value) << LCDCA_DRH2_DATA_Pos)))
/* -------- LCDCA_DRL3 : (LCDCA Offset: 0x2C) Data Register Low 3 -------- */
#define LCDCA_DRL3_DATA_Pos         0
#define LCDCA_DRL3_DATA_Msk         (0xFFFFFFFFu << LCDCA_DRL3_DATA_Pos) /**< \brief (LCDCA_DRL3) Segments Value */
#define LCDCA_DRL3_DATA(value)      ((LCDCA_DRL3_DATA_Msk & ((value) << LCDCA_DRL3_DATA_Pos)))
/* -------- LCDCA_DRH3 : (LCDCA Offset: 0x30) Data Register High 3 -------- */
#define LCDCA_DRH3_DATA_Pos         0
#define LCDCA_DRH3_DATA_Msk         (0xFFu << LCDCA_DRH3_DATA_Pos) /**< \brief (LCDCA_DRH3) Segments Value */
#define LCDCA_DRH3_DATA(value)      ((LCDCA_DRH3_DATA_Msk & ((value) << LCDCA_DRH3_DATA_Pos)))
/* -------- LCDCA_IADR : (LCDCA Offset: 0x34) Indirect Access Data Register -------- */
#define LCDCA_IADR_DATA_Pos         0
#define LCDCA_IADR_DATA_Msk         (0xFFu << LCDCA_IADR_DATA_Pos) /**< \brief (LCDCA_IADR) Segments Value */
#define LCDCA_IADR_DATA(value)      ((LCDCA_IADR_DATA_Msk & ((value) << LCDCA_IADR_DATA_Pos)))
#define LCDCA_IADR_DMASK_Pos        8
#define LCDCA_IADR_DMASK_Msk        (0xFFu << LCDCA_IADR_DMASK_Pos) /**< \brief (LCDCA_IADR) Data Mask */
#define LCDCA_IADR_DMASK(value)     ((LCDCA_IADR_DMASK_Msk & ((value) << LCDCA_IADR_DMASK_Pos)))
#define LCDCA_IADR_OFF_Pos          16
#define LCDCA_IADR_OFF_Msk          (0x1Fu << LCDCA_IADR_OFF_Pos) /**< \brief (LCDCA_IADR) Byte Offset */
#define LCDCA_IADR_OFF(value)       ((LCDCA_IADR_OFF_Msk & ((value) << LCDCA_IADR_OFF_Pos)))
/* -------- LCDCA_BCFG : (LCDCA Offset: 0x38) Blink Configuration Register -------- */
#define LCDCA_BCFG_MODE             (0x1u <<  0) /**< \brief (LCDCA_BCFG) Blinking Mode */
#define LCDCA_BCFG_FCS_Pos          1
#define LCDCA_BCFG_FCS_Msk          (0x3u << LCDCA_BCFG_FCS_Pos) /**< \brief (LCDCA_BCFG) Frame Counter Selection */
#define LCDCA_BCFG_FCS(value)       ((LCDCA_BCFG_FCS_Msk & ((value) << LCDCA_BCFG_FCS_Pos)))
#define LCDCA_BCFG_BSS0_Pos         8
#define LCDCA_BCFG_BSS0_Msk         (0xFu << LCDCA_BCFG_BSS0_Pos) /**< \brief (LCDCA_BCFG) Blink Segment Selection 0 */
#define LCDCA_BCFG_BSS0(value)      ((LCDCA_BCFG_BSS0_Msk & ((value) << LCDCA_BCFG_BSS0_Pos)))
#define LCDCA_BCFG_BSS1_Pos         12
#define LCDCA_BCFG_BSS1_Msk         (0xFu << LCDCA_BCFG_BSS1_Pos) /**< \brief (LCDCA_BCFG) Blink Segment Selection 1 */
#define LCDCA_BCFG_BSS1(value)      ((LCDCA_BCFG_BSS1_Msk & ((value) << LCDCA_BCFG_BSS1_Pos)))
/* -------- LCDCA_CSRCFG : (LCDCA Offset: 0x3C) Circular Shift Register Configuration -------- */
#define LCDCA_CSRCFG_DIR            (0x1u <<  0) /**< \brief (LCDCA_CSRCFG) Direction */
#define LCDCA_CSRCFG_FCS_Pos        1
#define LCDCA_CSRCFG_FCS_Msk        (0x3u << LCDCA_CSRCFG_FCS_Pos) /**< \brief (LCDCA_CSRCFG) Frame Counter Selection */
#define LCDCA_CSRCFG_FCS(value)     ((LCDCA_CSRCFG_FCS_Msk & ((value) << LCDCA_CSRCFG_FCS_Pos)))
#define LCDCA_CSRCFG_SIZE_Pos       3
#define LCDCA_CSRCFG_SIZE_Msk       (0x7u << LCDCA_CSRCFG_SIZE_Pos) /**< \brief (LCDCA_CSRCFG) Size */
#define LCDCA_CSRCFG_SIZE(value)    ((LCDCA_CSRCFG_SIZE_Msk & ((value) << LCDCA_CSRCFG_SIZE_Pos)))
#define LCDCA_CSRCFG_DATA_Pos       8
#define LCDCA_CSRCFG_DATA_Msk       (0xFFu << LCDCA_CSRCFG_DATA_Pos) /**< \brief (LCDCA_CSRCFG) Circular Shift Register Value */
#define LCDCA_CSRCFG_DATA(value)    ((LCDCA_CSRCFG_DATA_Msk & ((value) << LCDCA_CSRCFG_DATA_Pos)))
/* -------- LCDCA_CMCFG : (LCDCA Offset: 0x40) Character Mapping Configuration Register -------- */
#define LCDCA_CMCFG_DREV            (0x1u <<  0) /**< \brief (LCDCA_CMCFG) Digit Reverse Mode */
#define LCDCA_CMCFG_TDG_Pos         1
#define LCDCA_CMCFG_TDG_Msk         (0x3u << LCDCA_CMCFG_TDG_Pos) /**< \brief (LCDCA_CMCFG) Type of Digit */
#define LCDCA_CMCFG_TDG(value)      ((LCDCA_CMCFG_TDG_Msk & ((value) << LCDCA_CMCFG_TDG_Pos)))
#define LCDCA_CMCFG_STSEG_Pos       8
#define LCDCA_CMCFG_STSEG_Msk       (0x3Fu << LCDCA_CMCFG_STSEG_Pos) /**< \brief (LCDCA_CMCFG) Start Segment */
#define LCDCA_CMCFG_STSEG(value)    ((LCDCA_CMCFG_STSEG_Msk & ((value) << LCDCA_CMCFG_STSEG_Pos)))
/* -------- LCDCA_CMDR : (LCDCA Offset: 0x44) Character Mapping Data Register -------- */
#define LCDCA_CMDR_ASCII_Pos        0
#define LCDCA_CMDR_ASCII_Msk        (0x7Fu << LCDCA_CMDR_ASCII_Pos) /**< \brief (LCDCA_CMDR) ASCII Code */
#define LCDCA_CMDR_ASCII(value)     ((LCDCA_CMDR_ASCII_Msk & ((value) << LCDCA_CMDR_ASCII_Pos)))
/* -------- LCDCA_ACMCFG : (LCDCA Offset: 0x48) Automated Character Mapping Configuration Register -------- */
#define LCDCA_ACMCFG_EN             (0x1u <<  0) /**< \brief (LCDCA_ACMCFG) Enable */
#define LCDCA_ACMCFG_FCS_Pos        1
#define LCDCA_ACMCFG_FCS_Msk        (0x3u << LCDCA_ACMCFG_FCS_Pos) /**< \brief (LCDCA_ACMCFG) Frame Counter Selection */
#define LCDCA_ACMCFG_FCS(value)     ((LCDCA_ACMCFG_FCS_Msk & ((value) << LCDCA_ACMCFG_FCS_Pos)))
#define LCDCA_ACMCFG_MODE           (0x1u <<  3) /**< \brief (LCDCA_ACMCFG) Mode (sequential or scrolling) */
#define LCDCA_ACMCFG_DREV           (0x1u <<  4) /**< \brief (LCDCA_ACMCFG) Digit Reverse */
#define LCDCA_ACMCFG_TDG_Pos        5
#define LCDCA_ACMCFG_TDG_Msk        (0x3u << LCDCA_ACMCFG_TDG_Pos) /**< \brief (LCDCA_ACMCFG) Type of Digit */
#define LCDCA_ACMCFG_TDG(value)     ((LCDCA_ACMCFG_TDG_Msk & ((value) << LCDCA_ACMCFG_TDG_Pos)))
#define LCDCA_ACMCFG_STSEG_Pos      8
#define LCDCA_ACMCFG_STSEG_Msk      (0x3Fu << LCDCA_ACMCFG_STSEG_Pos) /**< \brief (LCDCA_ACMCFG) Start Segment */
#define LCDCA_ACMCFG_STSEG(value)   ((LCDCA_ACMCFG_STSEG_Msk & ((value) << LCDCA_ACMCFG_STSEG_Pos)))
#define LCDCA_ACMCFG_STEPS_Pos      16
#define LCDCA_ACMCFG_STEPS_Msk      (0xFFu << LCDCA_ACMCFG_STEPS_Pos) /**< \brief (LCDCA_ACMCFG) Scrolling Steps */
#define LCDCA_ACMCFG_STEPS(value)   ((LCDCA_ACMCFG_STEPS_Msk & ((value) << LCDCA_ACMCFG_STEPS_Pos)))
#define LCDCA_ACMCFG_DIGN_Pos       24
#define LCDCA_ACMCFG_DIGN_Msk       (0xFu << LCDCA_ACMCFG_DIGN_Pos) /**< \brief (LCDCA_ACMCFG) Digit Number */
#define LCDCA_ACMCFG_DIGN(value)    ((LCDCA_ACMCFG_DIGN_Msk & ((value) << LCDCA_ACMCFG_DIGN_Pos)))
/* -------- LCDCA_ACMDR : (LCDCA Offset: 0x4C) Automated Character Mapping Data Register -------- */
#define LCDCA_ACMDR_ASCII_Pos       0
#define LCDCA_ACMDR_ASCII_Msk       (0x7Fu << LCDCA_ACMDR_ASCII_Pos) /**< \brief (LCDCA_ACMDR) ASCII Code */
#define LCDCA_ACMDR_ASCII(value)    ((LCDCA_ACMDR_ASCII_Msk & ((value) << LCDCA_ACMDR_ASCII_Pos)))
/* -------- LCDCA_ABMCFG : (LCDCA Offset: 0x50) Automated Bit Mapping Configuration Register -------- */
#define LCDCA_ABMCFG_EN             (0x1u <<  0) /**< \brief (LCDCA_ABMCFG) Enable */
#define LCDCA_ABMCFG_FCS_Pos        1
#define LCDCA_ABMCFG_FCS_Msk        (0x3u << LCDCA_ABMCFG_FCS_Pos) /**< \brief (LCDCA_ABMCFG) Frame Counter Selection */
#define LCDCA_ABMCFG_FCS(value)     ((LCDCA_ABMCFG_FCS_Msk & ((value) << LCDCA_ABMCFG_FCS_Pos)))
#define LCDCA_ABMCFG_SIZE_Pos       8
#define LCDCA_ABMCFG_SIZE_Msk       (0x1Fu << LCDCA_ABMCFG_SIZE_Pos) /**< \brief (LCDCA_ABMCFG) Size */
#define LCDCA_ABMCFG_SIZE(value)    ((LCDCA_ABMCFG_SIZE_Msk & ((value) << LCDCA_ABMCFG_SIZE_Pos)))
/* -------- LCDCA_ABMDR : (LCDCA Offset: 0x54) Automated Bit Mapping Data Register -------- */
#define LCDCA_ABMDR_DATA_Pos        0
#define LCDCA_ABMDR_DATA_Msk        (0xFFu << LCDCA_ABMDR_DATA_Pos) /**< \brief (LCDCA_ABMDR) Segments Value */
#define LCDCA_ABMDR_DATA(value)     ((LCDCA_ABMDR_DATA_Msk & ((value) << LCDCA_ABMDR_DATA_Pos)))
#define LCDCA_ABMDR_DMASK_Pos       8
#define LCDCA_ABMDR_DMASK_Msk       (0xFFu << LCDCA_ABMDR_DMASK_Pos) /**< \brief (LCDCA_ABMDR) Data Mask */
#define LCDCA_ABMDR_DMASK(value)    ((LCDCA_ABMDR_DMASK_Msk & ((value) << LCDCA_ABMDR_DMASK_Pos)))
#define LCDCA_ABMDR_OFF_Pos         16
#define LCDCA_ABMDR_OFF_Msk         (0x1Fu << LCDCA_ABMDR_OFF_Pos) /**< \brief (LCDCA_ABMDR) Byte Offset */
#define LCDCA_ABMDR_OFF(value)      ((LCDCA_ABMDR_OFF_Msk & ((value) << LCDCA_ABMDR_OFF_Pos)))
/* -------- LCDCA_IER : (LCDCA Offset: 0x58) Interrupt Enable Register -------- */
#define LCDCA_IER_FC0R              (0x1u <<  0) /**< \brief (LCDCA_IER) Frame Counter 0 Rollover */
/* -------- LCDCA_IDR : (LCDCA Offset: 0x5C) Interrupt Disable Register -------- */
#define LCDCA_IDR_FC0R              (0x1u <<  0) /**< \brief (LCDCA_IDR) Frame Counter 0 Rollover */
/* -------- LCDCA_IMR : (LCDCA Offset: 0x60) Interrupt Mask Register -------- */
#define LCDCA_IMR_FC0R              (0x1u <<  0) /**< \brief (LCDCA_IMR) Frame Counter 0 Rollover */
/* -------- LCDCA_VERSION : (LCDCA Offset: 0x64) Version Register -------- */
#define LCDCA_VERSION_VERSION_Pos    0
#define LCDCA_VERSION_VERSION_Msk    (0xFFFu << LCDCA_VERSION_VERSION_Pos) /**< \brief (LCDCA_VERSION) Version Number */
#define LCDCA_VERSION_VERSION(value) ((LCDCA_VERSION_VERSION_Msk & ((value) << LCDCA_VERSION_VERSION_Pos)))
#define LCDCA_VERSION_VARIANT_Pos    16
#define LCDCA_VERSION_VARIANT_Msk    (0xFu << LCDCA_VERSION_VARIANT_Pos) /**< \brief (LCDCA_VERSION) Variant Number */
#define LCDCA_VERSION_VARIANT(value) ((LCDCA_VERSION_VARIANT_Msk & ((value) << LCDCA_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR PARC */
/* ============================================================================= */
/** \addtogroup SAM4L4_PARC Parallel Capture */
/*@{*/

#define REV_PARC       0x100

#ifndef __ASSEMBLY__
/** \brief PARC hardware registers */
typedef struct {
  RwReg   CFG;         /**< \brief (PARC Offset: 0x00) Configuration Register */
  RwReg   CR;          /**< \brief (PARC Offset: 0x04) Control Register */
  WoReg   IER;         /**< \brief (PARC Offset: 0x08) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (PARC Offset: 0x0C) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (PARC Offset: 0x10) Interrupt Mask Register */
  RoReg   SR;          /**< \brief (PARC Offset: 0x14) Status Register */
  WoReg   ICR;         /**< \brief (PARC Offset: 0x18) Interrupt Status Clear Register */
  RoReg   RHR;         /**< \brief (PARC Offset: 0x1C) Receive Holding Register */
  RoReg   VERSION;     /**< \brief (PARC Offset: 0x20) Version Register */
} Parc;
#endif /* __ASSEMBLY__ */
/* -------- PARC_CFG : (PARC Offset: 0x00) Configuration Register -------- */
#define PARC_CFG_DSIZE_Pos          0
#define PARC_CFG_DSIZE_Msk          (0x3u << PARC_CFG_DSIZE_Pos) /**< \brief (PARC_CFG) Data Size */
#define PARC_CFG_DSIZE(value)       ((PARC_CFG_DSIZE_Msk & ((value) << PARC_CFG_DSIZE_Pos)))
#define PARC_CFG_SMODE_Pos          2
#define PARC_CFG_SMODE_Msk          (0x3u << PARC_CFG_SMODE_Pos) /**< \brief (PARC_CFG) Sampling Mode */
#define PARC_CFG_SMODE(value)       ((PARC_CFG_SMODE_Msk & ((value) << PARC_CFG_SMODE_Pos)))
#define PARC_CFG_EMODE              (0x1u <<  4) /**< \brief (PARC_CFG) Events Mode */
#define PARC_CFG_EDGE               (0x1u <<  5) /**< \brief (PARC_CFG) Sampling Edge Select */
#define PARC_CFG_HALF               (0x1u <<  6) /**< \brief (PARC_CFG) Half Capture */
#define PARC_CFG_ODD                (0x1u <<  7) /**< \brief (PARC_CFG) Odd Capture */
/* -------- PARC_CR : (PARC Offset: 0x04) Control Register -------- */
#define PARC_CR_EN                  (0x1u <<  0) /**< \brief (PARC_CR) Enable */
#define PARC_CR_DIS                 (0x1u <<  1) /**< \brief (PARC_CR) Disable */
#define PARC_CR_START               (0x1u <<  2) /**< \brief (PARC_CR) Start Capture */
#define PARC_CR_STOP                (0x1u <<  3) /**< \brief (PARC_CR) Stop Capture */
/* -------- PARC_IER : (PARC Offset: 0x08) Interrupt Enable Register -------- */
#define PARC_IER_DRDY               (0x1u <<  2) /**< \brief (PARC_IER) Data Ready Interrupt Enable */
#define PARC_IER_OVR                (0x1u <<  3) /**< \brief (PARC_IER) Overrun Interrupt Enable */
/* -------- PARC_IDR : (PARC Offset: 0x0C) Interrupt Disable Register -------- */
#define PARC_IDR_DRDY               (0x1u <<  2) /**< \brief (PARC_IDR) Data Ready Interrupt Disable */
#define PARC_IDR_OVR                (0x1u <<  3) /**< \brief (PARC_IDR) Overrun Interrupt Disable */
/* -------- PARC_IMR : (PARC Offset: 0x10) Interrupt Mask Register -------- */
#define PARC_IMR_DRDY               (0x1u <<  2) /**< \brief (PARC_IMR) Data Ready Interrupt Mask */
#define PARC_IMR_OVR                (0x1u <<  3) /**< \brief (PARC_IMR) Overrun Interrupt Mask */
/* -------- PARC_SR : (PARC Offset: 0x14) Status Register -------- */
#define PARC_SR_EN                  (0x1u <<  0) /**< \brief (PARC_SR) Enable Status */
#define PARC_SR_CS                  (0x1u <<  1) /**< \brief (PARC_SR) Capture Status */
#define PARC_SR_DRDY                (0x1u <<  2) /**< \brief (PARC_SR) Data Ready Interrupt Status */
#define PARC_SR_OVR                 (0x1u <<  3) /**< \brief (PARC_SR) Overrun Interrupt Status */
/* -------- PARC_ICR : (PARC Offset: 0x18) Interrupt Status Clear Register -------- */
#define PARC_ICR_DRDY               (0x1u <<  2) /**< \brief (PARC_ICR) Data Ready Interrupt Status Clear */
#define PARC_ICR_OVR                (0x1u <<  3) /**< \brief (PARC_ICR) Overrun Interrupt Status Clear */
/* -------- PARC_RHR : (PARC Offset: 0x1C) Receive Holding Register -------- */
#define PARC_RHR_CDATA_Pos          0
#define PARC_RHR_CDATA_Msk          (0xFFFFFFFFu << PARC_RHR_CDATA_Pos) /**< \brief (PARC_RHR) Captured Data */
#define PARC_RHR_CDATA(value)       ((PARC_RHR_CDATA_Msk & ((value) << PARC_RHR_CDATA_Pos)))
/* -------- PARC_VERSION : (PARC Offset: 0x20) Version Register -------- */
#define PARC_VERSION_VERSION_Pos    0
#define PARC_VERSION_VERSION_Msk    (0xFFFu << PARC_VERSION_VERSION_Pos) /**< \brief (PARC_VERSION) Version Number */
#define PARC_VERSION_VERSION(value) ((PARC_VERSION_VERSION_Msk & ((value) << PARC_VERSION_VERSION_Pos)))
#define PARC_VERSION_VARIANT_Pos    16
#define PARC_VERSION_VARIANT_Msk    (0xFu << PARC_VERSION_VARIANT_Pos) /**< \brief (PARC_VERSION) Variant Number */
#define PARC_VERSION_VARIANT(value) ((PARC_VERSION_VARIANT_Msk & ((value) << PARC_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR PDCA */
/* ============================================================================= */
/** \addtogroup SAM4L4_PDCA Peripheral DMA Controller */
/*@{*/

#define REV_PDCA       0x124

#ifndef __ASSEMBLY__
/** \brief PdcaChannel hardware registers */
typedef struct {
  RwReg   MAR;         /**< \brief (PdcaChannel Offset: 0x000) Memory Address Register */
  RwReg   PSR;         /**< \brief (PdcaChannel Offset: 0x004) Peripheral Select Register */
  RwReg   TCR;         /**< \brief (PdcaChannel Offset: 0x008) Transfer Counter Register */
  RwReg   MARR;        /**< \brief (PdcaChannel Offset: 0x00C) Memory Address Reload Register */
  RwReg   TCRR;        /**< \brief (PdcaChannel Offset: 0x010) Transfer Counter Reload Register */
  WoReg   CR;          /**< \brief (PdcaChannel Offset: 0x014) Control Register */
  RwReg   MR;          /**< \brief (PdcaChannel Offset: 0x018) Mode Register */
  RoReg   SR;          /**< \brief (PdcaChannel Offset: 0x01C) Status Register */
  WoReg   IER;         /**< \brief (PdcaChannel Offset: 0x020) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (PdcaChannel Offset: 0x024) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (PdcaChannel Offset: 0x028) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (PdcaChannel Offset: 0x02C) Interrupt Status Register */
  RoReg   Reserved1[4];
} PdcaChannel;
/** \brief PDCA hardware registers */
#define PDCA_CHANNEL_LENGTH 16
typedef struct {
  PdcaChannel Channel[PDCA_CHANNEL_LENGTH]; /**< \brief (PDCA Offset: 0x000) PdcaChannel groups */
  PdcaChannel Reserved1[32 - PDCA_CHANNEL_LENGTH];
  RwReg   PCONTROL;    /**< \brief (PDCA Offset: 0x800) Performance Control Register */
  RoReg   PRDATA0;     /**< \brief (PDCA Offset: 0x804) Channel 0 Read Data Cycles */
  RoReg   PRSTALL0;    /**< \brief (PDCA Offset: 0x808) Channel 0 Read Stall Cycles */
  RoReg   PRLAT0;      /**< \brief (PDCA Offset: 0x80C) Channel 0 Read Max Latency */
  RoReg   PWDATA0;     /**< \brief (PDCA Offset: 0x810) Channel 0 Write Data Cycles */
  RoReg   PWSTALL0;    /**< \brief (PDCA Offset: 0x814) Channel 0 Write Stall Cycles */
  RoReg   PWLAT0;      /**< \brief (PDCA Offset: 0x818) Channel0 Write Max Latency */
  RoReg   PRDATA1;     /**< \brief (PDCA Offset: 0x81C) Channel 1 Read Data Cycles */
  RoReg   PRSTALL1;    /**< \brief (PDCA Offset: 0x820) Channel Read Stall Cycles */
  RoReg   PRLAT1;      /**< \brief (PDCA Offset: 0x824) Channel 1 Read Max Latency */
  RoReg   PWDATA1;     /**< \brief (PDCA Offset: 0x828) Channel 1 Write Data Cycles */
  RoReg   PWSTALL1;    /**< \brief (PDCA Offset: 0x82C) Channel 1 Write stall Cycles */
  RoReg   PWLAT1;      /**< \brief (PDCA Offset: 0x830) Channel 1 Read Max Latency */
  RoReg   VERSION;     /**< \brief (PDCA Offset: 0x834) Version Register */
} Pdca;
#endif /* __ASSEMBLY__ */
/* -------- PDCA_MAR : (PDCA Offset: 0x000) Channel Memory Address Register -------- */
#define PDCA_MAR_MADDR_Pos          0
#define PDCA_MAR_MADDR_Msk          (0xFFFFFFFFu << PDCA_MAR_MADDR_Pos) /**< \brief (PDCA_MAR) Memory Address */
#define PDCA_MAR_MADDR(value)       ((PDCA_MAR_MADDR_Msk & ((value) << PDCA_MAR_MADDR_Pos)))
/* -------- PDCA_PSR : (PDCA Offset: 0x004) Channel Peripheral Select Register -------- */
#define PDCA_PSR_PID_Pos            0
#define PDCA_PSR_PID_Msk            (0xFFu << PDCA_PSR_PID_Pos) /**< \brief (PDCA_PSR) Peripheral Identifier */
#define PDCA_PSR_PID(value)         ((PDCA_PSR_PID_Msk & ((value) << PDCA_PSR_PID_Pos)))
/* -------- PDCA_TCR : (PDCA Offset: 0x008) Channel Transfer Counter Register -------- */
#define PDCA_TCR_TCV_Pos            0
#define PDCA_TCR_TCV_Msk            (0xFFFFu << PDCA_TCR_TCV_Pos) /**< \brief (PDCA_TCR) Transfer Counter Value */
#define PDCA_TCR_TCV(value)         ((PDCA_TCR_TCV_Msk & ((value) << PDCA_TCR_TCV_Pos)))
/* -------- PDCA_MARR : (PDCA Offset: 0x00C) Channel Memory Address Reload Register -------- */
#define PDCA_MARR_MARV_Pos          0
#define PDCA_MARR_MARV_Msk          (0xFFFFFFFFu << PDCA_MARR_MARV_Pos) /**< \brief (PDCA_MARR) Memory Address Reload Value */
#define PDCA_MARR_MARV(value)       ((PDCA_MARR_MARV_Msk & ((value) << PDCA_MARR_MARV_Pos)))
/* -------- PDCA_TCRR : (PDCA Offset: 0x010) Channel Transfer Counter Reload Register -------- */
#define PDCA_TCRR_TCRV_Pos          0
#define PDCA_TCRR_TCRV_Msk          (0xFFFFu << PDCA_TCRR_TCRV_Pos) /**< \brief (PDCA_TCRR) Transfer Counter Reload Value */
#define PDCA_TCRR_TCRV(value)       ((PDCA_TCRR_TCRV_Msk & ((value) << PDCA_TCRR_TCRV_Pos)))
/* -------- PDCA_CR : (PDCA Offset: 0x014) Channel Control Register -------- */
#define PDCA_CR_TEN                 (0x1u <<  0) /**< \brief (PDCA_CR) Transfer Enable */
#define PDCA_CR_TDIS                (0x1u <<  1) /**< \brief (PDCA_CR) Transfer Disable */
#define PDCA_CR_ECLR                (0x1u <<  8) /**< \brief (PDCA_CR) Error Clear */
/* -------- PDCA_MR : (PDCA Offset: 0x018) Channel Mode Register -------- */
#define PDCA_MR_SIZE_Pos            0
#define PDCA_MR_SIZE_Msk            (0x3u << PDCA_MR_SIZE_Pos) /**< \brief (PDCA_MR) Transfer size */
#define PDCA_MR_SIZE(value)         ((PDCA_MR_SIZE_Msk & ((value) << PDCA_MR_SIZE_Pos)))
#define   PDCA_MR_SIZE_BYTE         (0x0u <<  0) /**< \brief (PDCA_MR)  */
#define   PDCA_MR_SIZE_HALF_WORD    (0x1u <<  0) /**< \brief (PDCA_MR)  */
#define   PDCA_MR_SIZE_WORD         (0x2u <<  0) /**< \brief (PDCA_MR)  */
#define PDCA_MR_ETRIG               (0x1u <<  2) /**< \brief (PDCA_MR) Event trigger */
#define PDCA_MR_RING                (0x1u <<  3) /**< \brief (PDCA_MR) Ring Buffer */
/* -------- PDCA_SR : (PDCA Offset: 0x01C) Channel Status Register -------- */
#define PDCA_SR_TEN                 (0x1u <<  0) /**< \brief (PDCA_SR) Transfer Enabled */
/* -------- PDCA_IER : (PDCA Offset: 0x020) Channel Interrupt Enable Register -------- */
#define PDCA_IER_RCZ                (0x1u <<  0) /**< \brief (PDCA_IER) Reload Counter Zero */
#define PDCA_IER_TRC                (0x1u <<  1) /**< \brief (PDCA_IER) Transfer Complete */
#define PDCA_IER_TERR               (0x1u <<  2) /**< \brief (PDCA_IER) Transfer Error */
/* -------- PDCA_IDR : (PDCA Offset: 0x024) Channel Interrupt Disable Register -------- */
#define PDCA_IDR_RCZ                (0x1u <<  0) /**< \brief (PDCA_IDR) Reload Counter Zero */
#define PDCA_IDR_TRC                (0x1u <<  1) /**< \brief (PDCA_IDR) Transfer Complete */
#define PDCA_IDR_TERR               (0x1u <<  2) /**< \brief (PDCA_IDR) Transfer Error */
/* -------- PDCA_IMR : (PDCA Offset: 0x028) Channel Interrupt Mask Register -------- */
#define PDCA_IMR_RCZ                (0x1u <<  0) /**< \brief (PDCA_IMR) Reload Counter Zero */
#define PDCA_IMR_TRC                (0x1u <<  1) /**< \brief (PDCA_IMR) Transfer Complete */
#define PDCA_IMR_TERR               (0x1u <<  2) /**< \brief (PDCA_IMR) Transfer Error */
/* -------- PDCA_ISR : (PDCA Offset: 0x02C) Channel Interrupt Status Register -------- */
#define PDCA_ISR_RCZ                (0x1u <<  0) /**< \brief (PDCA_ISR) Reload Counter Zero */
#define PDCA_ISR_TRC                (0x1u <<  1) /**< \brief (PDCA_ISR) Transfer Complete */
#define PDCA_ISR_TERR               (0x1u <<  2) /**< \brief (PDCA_ISR) Transfer Error */
/* -------- PDCA_PCONTROL : (PDCA Offset: 0x800) Performance Control Register -------- */
#define PDCA_PCONTROL_CH0EN         (0x1u <<  0) /**< \brief (PDCA_PCONTROL) Channel 0 Enabled */
#define PDCA_PCONTROL_CH1EN         (0x1u <<  1) /**< \brief (PDCA_PCONTROL) Channel 1 Enabled. */
#define PDCA_PCONTROL_CH0OF         (0x1u <<  4) /**< \brief (PDCA_PCONTROL) Channel 0 Overflow Freeze */
#define PDCA_PCONTROL_CH1OF         (0x1u <<  5) /**< \brief (PDCA_PCONTROL) Channel 1 overflow freeze */
#define PDCA_PCONTROL_CH0RES        (0x1u <<  8) /**< \brief (PDCA_PCONTROL) Channel 0 counter reset */
#define PDCA_PCONTROL_CH1RES        (0x1u <<  9) /**< \brief (PDCA_PCONTROL) Channel 1 counter reset */
#define PDCA_PCONTROL_MON0CH_Pos    16
#define PDCA_PCONTROL_MON0CH_Msk    (0x3Fu << PDCA_PCONTROL_MON0CH_Pos) /**< \brief (PDCA_PCONTROL) PDCA Channel to monitor with counter 0 */
#define PDCA_PCONTROL_MON0CH(value) ((PDCA_PCONTROL_MON0CH_Msk & ((value) << PDCA_PCONTROL_MON0CH_Pos)))
#define PDCA_PCONTROL_MON1CH_Pos    24
#define PDCA_PCONTROL_MON1CH_Msk    (0x3Fu << PDCA_PCONTROL_MON1CH_Pos) /**< \brief (PDCA_PCONTROL) PDCA Channel to monitor with counter 1 */
#define PDCA_PCONTROL_MON1CH(value) ((PDCA_PCONTROL_MON1CH_Msk & ((value) << PDCA_PCONTROL_MON1CH_Pos)))
/* -------- PDCA_PRDATA0 : (PDCA Offset: 0x804) Channel 0 Read Data Cycles -------- */
#define PDCA_PRDATA0_DATA_Pos       0
#define PDCA_PRDATA0_DATA_Msk       (0xFFFFFFFFu << PDCA_PRDATA0_DATA_Pos) /**< \brief (PDCA_PRDATA0) Data Cycles Counted Since Last reset */
#define PDCA_PRDATA0_DATA(value)    ((PDCA_PRDATA0_DATA_Msk & ((value) << PDCA_PRDATA0_DATA_Pos)))
/* -------- PDCA_PRSTALL0 : (PDCA Offset: 0x808) Channel 0 Read Stall Cycles -------- */
#define PDCA_PRSTALL0_STALL_Pos     0
#define PDCA_PRSTALL0_STALL_Msk     (0xFFFFFFFFu << PDCA_PRSTALL0_STALL_Pos) /**< \brief (PDCA_PRSTALL0) Stall Cycles counted since last reset */
#define PDCA_PRSTALL0_STALL(value)  ((PDCA_PRSTALL0_STALL_Msk & ((value) << PDCA_PRSTALL0_STALL_Pos)))
/* -------- PDCA_PRLAT0 : (PDCA Offset: 0x80C) Channel 0 Read Max Latency -------- */
#define PDCA_PRLAT0_LAT_Pos         0
#define PDCA_PRLAT0_LAT_Msk         (0xFFFFu << PDCA_PRLAT0_LAT_Pos) /**< \brief (PDCA_PRLAT0) Maximum Transfer Initiation cycles counted since last reset */
#define PDCA_PRLAT0_LAT(value)      ((PDCA_PRLAT0_LAT_Msk & ((value) << PDCA_PRLAT0_LAT_Pos)))
/* -------- PDCA_PWDATA0 : (PDCA Offset: 0x810) Channel 0 Write Data Cycles -------- */
#define PDCA_PWDATA0_DATA_Pos       0
#define PDCA_PWDATA0_DATA_Msk       (0xFFFFFFFFu << PDCA_PWDATA0_DATA_Pos) /**< \brief (PDCA_PWDATA0) Data Cycles Counted since last Reset */
#define PDCA_PWDATA0_DATA(value)    ((PDCA_PWDATA0_DATA_Msk & ((value) << PDCA_PWDATA0_DATA_Pos)))
/* -------- PDCA_PWSTALL0 : (PDCA Offset: 0x814) Channel 0 Write Stall Cycles -------- */
#define PDCA_PWSTALL0_STALL_Pos     0
#define PDCA_PWSTALL0_STALL_Msk     (0xFFFFFFFFu << PDCA_PWSTALL0_STALL_Pos) /**< \brief (PDCA_PWSTALL0) Stall cycles counted since last reset */
#define PDCA_PWSTALL0_STALL(value)  ((PDCA_PWSTALL0_STALL_Msk & ((value) << PDCA_PWSTALL0_STALL_Pos)))
/* -------- PDCA_PWLAT0 : (PDCA Offset: 0x818) Channel0 Write Max Latency -------- */
#define PDCA_PWLAT0_LAT_Pos         0
#define PDCA_PWLAT0_LAT_Msk         (0xFFFFu << PDCA_PWLAT0_LAT_Pos) /**< \brief (PDCA_PWLAT0) Maximum transfer initiation cycles counted since last reset */
#define PDCA_PWLAT0_LAT(value)      ((PDCA_PWLAT0_LAT_Msk & ((value) << PDCA_PWLAT0_LAT_Pos)))
/* -------- PDCA_PRDATA1 : (PDCA Offset: 0x81C) Channel 1 Read Data Cycles -------- */
#define PDCA_PRDATA1_DATA_Pos       0
#define PDCA_PRDATA1_DATA_Msk       (0xFFFFFFFFu << PDCA_PRDATA1_DATA_Pos) /**< \brief (PDCA_PRDATA1) Data Cycles Counted Since Last reset */
#define PDCA_PRDATA1_DATA(value)    ((PDCA_PRDATA1_DATA_Msk & ((value) << PDCA_PRDATA1_DATA_Pos)))
/* -------- PDCA_PRSTALL1 : (PDCA Offset: 0x820) Channel Read Stall Cycles -------- */
#define PDCA_PRSTALL1_STALL_Pos     0
#define PDCA_PRSTALL1_STALL_Msk     (0xFFFFFFFFu << PDCA_PRSTALL1_STALL_Pos) /**< \brief (PDCA_PRSTALL1) Stall Cycles Counted since last reset */
#define PDCA_PRSTALL1_STALL(value)  ((PDCA_PRSTALL1_STALL_Msk & ((value) << PDCA_PRSTALL1_STALL_Pos)))
/* -------- PDCA_PRLAT1 : (PDCA Offset: 0x824) Channel 1 Read Max Latency -------- */
#define PDCA_PRLAT1_LAT_Pos         0
#define PDCA_PRLAT1_LAT_Msk         (0xFFFFu << PDCA_PRLAT1_LAT_Pos) /**< \brief (PDCA_PRLAT1) Maximum Transfer initiation cycles counted since last reset */
#define PDCA_PRLAT1_LAT(value)      ((PDCA_PRLAT1_LAT_Msk & ((value) << PDCA_PRLAT1_LAT_Pos)))
/* -------- PDCA_PWDATA1 : (PDCA Offset: 0x828) Channel 1 Write Data Cycles -------- */
#define PDCA_PWDATA1_DATA_Pos       0
#define PDCA_PWDATA1_DATA_Msk       (0xFFFFFFFFu << PDCA_PWDATA1_DATA_Pos) /**< \brief (PDCA_PWDATA1) Data cycles Counted Since last reset */
#define PDCA_PWDATA1_DATA(value)    ((PDCA_PWDATA1_DATA_Msk & ((value) << PDCA_PWDATA1_DATA_Pos)))
/* -------- PDCA_PWSTALL1 : (PDCA Offset: 0x82C) Channel 1 Write stall Cycles -------- */
#define PDCA_PWSTALL1_STALL_Pos     0
#define PDCA_PWSTALL1_STALL_Msk     (0xFFFFFFFFu << PDCA_PWSTALL1_STALL_Pos) /**< \brief (PDCA_PWSTALL1) Stall cycles counted since last reset */
#define PDCA_PWSTALL1_STALL(value)  ((PDCA_PWSTALL1_STALL_Msk & ((value) << PDCA_PWSTALL1_STALL_Pos)))
/* -------- PDCA_PWLAT1 : (PDCA Offset: 0x830) Channel 1 Read Max Latency -------- */
#define PDCA_PWLAT1_LAT_Pos         0
#define PDCA_PWLAT1_LAT_Msk         (0xFFFFu << PDCA_PWLAT1_LAT_Pos) /**< \brief (PDCA_PWLAT1) Maximum transfer initiation cycles counted since last reset */
#define PDCA_PWLAT1_LAT(value)      ((PDCA_PWLAT1_LAT_Msk & ((value) << PDCA_PWLAT1_LAT_Pos)))
/* -------- PDCA_VERSION : (PDCA Offset: 0x834) Version Register -------- */
#define PDCA_VERSION_VERSION_Pos    0
#define PDCA_VERSION_VERSION_Msk    (0xFFFu << PDCA_VERSION_VERSION_Pos) /**< \brief (PDCA_VERSION) Version Number */
#define PDCA_VERSION_VERSION(value) ((PDCA_VERSION_VERSION_Msk & ((value) << PDCA_VERSION_VERSION_Pos)))
#define PDCA_VERSION_VARIANT_Pos    16
#define PDCA_VERSION_VARIANT_Msk    (0xFu << PDCA_VERSION_VARIANT_Pos) /**< \brief (PDCA_VERSION) Variant Number */
#define PDCA_VERSION_VARIANT(value) ((PDCA_VERSION_VARIANT_Msk & ((value) << PDCA_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR PEVC */
/* ============================================================================= */
/** \addtogroup SAM4L4_PEVC Peripheral Event Controller */
/*@{*/

#define REV_PEVC       0x200

#ifndef __ASSEMBLY__
/** \brief PevcChmx hardware registers */
typedef struct {
  RwReg   CHMX;        /**< \brief (PevcChmx Offset: 0x000) Channel Multiplexer 0 */
} PevcChmx;
/** \brief PevcEvs hardware registers */
typedef struct {
  RwReg   EVS;         /**< \brief (PevcEvs Offset: 0x000) Event Shaper 0 */
} PevcEvs;
/** \brief PEVC hardware registers */
#define PEVC_TRIGOUT_BITS 19
#define PEVC_EVIN_BITS 31
typedef struct {
  RoReg   CHSR;        /**< \brief (PEVC Offset: 0x000) Channel Status Register */
  WoReg   CHER;        /**< \brief (PEVC Offset: 0x004) Channel Enable Register */
  WoReg   CHDR;        /**< \brief (PEVC Offset: 0x008) Channel Disable Register */
  RoReg   Reserved1[1];
  WoReg   SEV;         /**< \brief (PEVC Offset: 0x010) Software Event */
  RoReg   BUSY;        /**< \brief (PEVC Offset: 0x014) Channel / User Busy */
  RoReg   Reserved2[2];
  WoReg   TRIER;       /**< \brief (PEVC Offset: 0x020) Trigger Interrupt Mask Enable Register */
  WoReg   TRIDR;       /**< \brief (PEVC Offset: 0x024) Trigger Interrupt Mask Disable Register */
  RoReg   TRIMR;       /**< \brief (PEVC Offset: 0x028) Trigger Interrupt Mask Register */
  RoReg   Reserved3[1];
  RoReg   TRSR;        /**< \brief (PEVC Offset: 0x030) Trigger Status Register */
  WoReg   TRSCR;       /**< \brief (PEVC Offset: 0x034) Trigger Status Clear Register */
  RoReg   Reserved4[2];
  WoReg   OVIER;       /**< \brief (PEVC Offset: 0x040) Overrun Interrupt Mask Enable Register */
  WoReg   OVIDR;       /**< \brief (PEVC Offset: 0x044) Overrun Interrupt Mask Disable Register */
  RoReg   OVIMR;       /**< \brief (PEVC Offset: 0x048) Overrun Interrupt Mask Register */
  RoReg   Reserved5[1];
  RoReg   OVSR;        /**< \brief (PEVC Offset: 0x050) Overrun Status Register */
  WoReg   OVSCR;       /**< \brief (PEVC Offset: 0x054) Overrun Status Clear Register */
  RoReg   Reserved6[42];
  PevcChmx Chmx[PEVC_TRIGOUT_BITS]; /**< \brief (PEVC Offset: 0x100) PevcChmx groups */
  PevcChmx Reserved7[32 - PEVC_TRIGOUT_BITS];
  RoReg   Reserved8[32];
  PevcEvs Evs[PEVC_EVIN_BITS]; /**< \brief (PEVC Offset: 0x200) PevcEvs groups */
  PevcEvs Reserved9[64 - PEVC_EVIN_BITS];
  RwReg   IGFDR;       /**< \brief (PEVC Offset: 0x300) Input Glitch Filter Divider Register */
  RoReg   Reserved10[61];
  RoReg   PARAMETER;   /**< \brief (PEVC Offset: 0x3F8) Parameter */
  RoReg   VERSION;     /**< \brief (PEVC Offset: 0x3FC) Version */
} Pevc;
#endif /* __ASSEMBLY__ */
/* -------- PEVC_CHSR : (PEVC Offset: 0x000) Channel Status Register -------- */
#define PEVC_CHSR_CHS_Pos           0
#define PEVC_CHSR_CHS_Msk           (0xFFFFFFFFu << PEVC_CHSR_CHS_Pos) /**< \brief (PEVC_CHSR) Channel Status */
#define PEVC_CHSR_CHS(value)        ((PEVC_CHSR_CHS_Msk & ((value) << PEVC_CHSR_CHS_Pos)))
#define   PEVC_CHSR_CHS_0           (0x0u <<  0) /**< \brief (PEVC_CHSR) Channel j Disabled */
#define   PEVC_CHSR_CHS_1           (0x1u <<  0) /**< \brief (PEVC_CHSR) Channel j Enabled */
/* -------- PEVC_CHER : (PEVC Offset: 0x004) Channel Enable Register -------- */
#define PEVC_CHER_CHE_Pos           0
#define PEVC_CHER_CHE_Msk           (0xFFFFFFFFu << PEVC_CHER_CHE_Pos) /**< \brief (PEVC_CHER) Channel Enable */
#define PEVC_CHER_CHE(value)        ((PEVC_CHER_CHE_Msk & ((value) << PEVC_CHER_CHE_Pos)))
#define   PEVC_CHER_CHE_0           (0x0u <<  0) /**< \brief (PEVC_CHER) No Action */
#define   PEVC_CHER_CHE_1           (0x1u <<  0) /**< \brief (PEVC_CHER) Enable Channel j */
/* -------- PEVC_CHDR : (PEVC Offset: 0x008) Channel Disable Register -------- */
#define PEVC_CHDR_CHD_Pos           0
#define PEVC_CHDR_CHD_Msk           (0xFFFFFFFFu << PEVC_CHDR_CHD_Pos) /**< \brief (PEVC_CHDR) Channel Disable */
#define PEVC_CHDR_CHD(value)        ((PEVC_CHDR_CHD_Msk & ((value) << PEVC_CHDR_CHD_Pos)))
#define   PEVC_CHDR_CHD_0           (0x0u <<  0) /**< \brief (PEVC_CHDR) No Action */
#define   PEVC_CHDR_CHD_1           (0x1u <<  0) /**< \brief (PEVC_CHDR) Disable Channel j */
/* -------- PEVC_SEV : (PEVC Offset: 0x010) Software Event -------- */
#define PEVC_SEV_SEV_Pos            0
#define PEVC_SEV_SEV_Msk            (0xFFFFFFFFu << PEVC_SEV_SEV_Pos) /**< \brief (PEVC_SEV) Software Event */
#define PEVC_SEV_SEV(value)         ((PEVC_SEV_SEV_Msk & ((value) << PEVC_SEV_SEV_Pos)))
#define   PEVC_SEV_SEV_0            (0x0u <<  0) /**< \brief (PEVC_SEV) No Action */
#define   PEVC_SEV_SEV_1            (0x1u <<  0) /**< \brief (PEVC_SEV) CPU forces software event to channel j */
/* -------- PEVC_BUSY : (PEVC Offset: 0x014) Channel / User Busy -------- */
#define PEVC_BUSY_BUSY_Pos          0
#define PEVC_BUSY_BUSY_Msk          (0xFFFFFFFFu << PEVC_BUSY_BUSY_Pos) /**< \brief (PEVC_BUSY) Channel Status */
#define PEVC_BUSY_BUSY(value)       ((PEVC_BUSY_BUSY_Msk & ((value) << PEVC_BUSY_BUSY_Pos)))
#define   PEVC_BUSY_BUSY_0          (0x0u <<  0) /**< \brief (PEVC_BUSY) No Action */
#define   PEVC_BUSY_BUSY_1          (0x1u <<  0) /**< \brief (PEVC_BUSY) Channel j or User j is Busy */
/* -------- PEVC_TRIER : (PEVC Offset: 0x020) Trigger Interrupt Mask Enable Register -------- */
#define PEVC_TRIER_TRIE_Pos         0
#define PEVC_TRIER_TRIE_Msk         (0xFFFFFFFFu << PEVC_TRIER_TRIE_Pos) /**< \brief (PEVC_TRIER) Trigger Interrupt Enable */
#define PEVC_TRIER_TRIE(value)      ((PEVC_TRIER_TRIE_Msk & ((value) << PEVC_TRIER_TRIE_Pos)))
#define   PEVC_TRIER_TRIE_0         (0x0u <<  0) /**< \brief (PEVC_TRIER) No Action */
#define   PEVC_TRIER_TRIE_1         (0x1u <<  0) /**< \brief (PEVC_TRIER) Enable Trigger j Interrupt */
/* -------- PEVC_TRIDR : (PEVC Offset: 0x024) Trigger Interrupt Mask Disable Register -------- */
#define PEVC_TRIDR_TRID_Pos         0
#define PEVC_TRIDR_TRID_Msk         (0xFFFFFFFFu << PEVC_TRIDR_TRID_Pos) /**< \brief (PEVC_TRIDR) Trigger Interrupt Disable */
#define PEVC_TRIDR_TRID(value)      ((PEVC_TRIDR_TRID_Msk & ((value) << PEVC_TRIDR_TRID_Pos)))
#define   PEVC_TRIDR_TRID_0         (0x0u <<  0) /**< \brief (PEVC_TRIDR) No Action */
#define   PEVC_TRIDR_TRID_1         (0x1u <<  0) /**< \brief (PEVC_TRIDR) Disable Trigger j Interrupt */
/* -------- PEVC_TRIMR : (PEVC Offset: 0x028) Trigger Interrupt Mask Register -------- */
#define PEVC_TRIMR_TRIM_Pos         0
#define PEVC_TRIMR_TRIM_Msk         (0xFFFFFFFFu << PEVC_TRIMR_TRIM_Pos) /**< \brief (PEVC_TRIMR) Trigger Interrupt Mask */
#define PEVC_TRIMR_TRIM(value)      ((PEVC_TRIMR_TRIM_Msk & ((value) << PEVC_TRIMR_TRIM_Pos)))
#define   PEVC_TRIMR_TRIM_0         (0x0u <<  0) /**< \brief (PEVC_TRIMR) Trigger j Interrupt Disabled */
#define   PEVC_TRIMR_TRIM_1         (0x1u <<  0) /**< \brief (PEVC_TRIMR) Trigger j Interrupt Enabled */
/* -------- PEVC_TRSR : (PEVC Offset: 0x030) Trigger Status Register -------- */
#define PEVC_TRSR_TRS_Pos           0
#define PEVC_TRSR_TRS_Msk           (0xFFFFFFFFu << PEVC_TRSR_TRS_Pos) /**< \brief (PEVC_TRSR) Trigger Interrupt Status */
#define PEVC_TRSR_TRS(value)        ((PEVC_TRSR_TRS_Msk & ((value) << PEVC_TRSR_TRS_Pos)))
#define   PEVC_TRSR_TRS_0           (0x0u <<  0) /**< \brief (PEVC_TRSR) Channel j did not send out an Event in the past */
#define   PEVC_TRSR_TRS_1           (0x1u <<  0) /**< \brief (PEVC_TRSR) Channel j did send out an Event in the past */
/* -------- PEVC_TRSCR : (PEVC Offset: 0x034) Trigger Status Clear Register -------- */
#define PEVC_TRSCR_TRSC_Pos         0
#define PEVC_TRSCR_TRSC_Msk         (0xFFFFFFFFu << PEVC_TRSCR_TRSC_Pos) /**< \brief (PEVC_TRSCR) Trigger Interrupt Status Clear */
#define PEVC_TRSCR_TRSC(value)      ((PEVC_TRSCR_TRSC_Msk & ((value) << PEVC_TRSCR_TRSC_Pos)))
#define   PEVC_TRSCR_TRSC_0         (0x0u <<  0) /**< \brief (PEVC_TRSCR) No Action */
#define   PEVC_TRSCR_TRSC_1         (0x1u <<  0) /**< \brief (PEVC_TRSCR) Clear TRSR[j] */
/* -------- PEVC_OVIER : (PEVC Offset: 0x040) Overrun Interrupt Mask Enable Register -------- */
#define PEVC_OVIER_OVIE_Pos         0
#define PEVC_OVIER_OVIE_Msk         (0xFFFFFFFFu << PEVC_OVIER_OVIE_Pos) /**< \brief (PEVC_OVIER) Overrun Interrupt Enable */
#define PEVC_OVIER_OVIE(value)      ((PEVC_OVIER_OVIE_Msk & ((value) << PEVC_OVIER_OVIE_Pos)))
#define   PEVC_OVIER_OVIE_0         (0x0u <<  0) /**< \brief (PEVC_OVIER) No Action */
#define   PEVC_OVIER_OVIE_1         (0x1u <<  0) /**< \brief (PEVC_OVIER) Enable Overrun Interrupt for Channel j */
/* -------- PEVC_OVIDR : (PEVC Offset: 0x044) Overrun Interrupt Mask Disable Register -------- */
#define PEVC_OVIDR_OVID_Pos         0
#define PEVC_OVIDR_OVID_Msk         (0xFFFFFFFFu << PEVC_OVIDR_OVID_Pos) /**< \brief (PEVC_OVIDR) Overrun Interrupt Disable */
#define PEVC_OVIDR_OVID(value)      ((PEVC_OVIDR_OVID_Msk & ((value) << PEVC_OVIDR_OVID_Pos)))
#define   PEVC_OVIDR_OVID_0         (0x0u <<  0) /**< \brief (PEVC_OVIDR) No Action */
#define   PEVC_OVIDR_OVID_1         (0x1u <<  0) /**< \brief (PEVC_OVIDR) Enable Overrun Interrupt for Channel j */
/* -------- PEVC_OVIMR : (PEVC Offset: 0x048) Overrun Interrupt Mask Register -------- */
#define PEVC_OVIMR_OVIM_Pos         0
#define PEVC_OVIMR_OVIM_Msk         (0xFFFFFFFFu << PEVC_OVIMR_OVIM_Pos) /**< \brief (PEVC_OVIMR) Overrun Interrupt Mask */
#define PEVC_OVIMR_OVIM(value)      ((PEVC_OVIMR_OVIM_Msk & ((value) << PEVC_OVIMR_OVIM_Pos)))
#define   PEVC_OVIMR_OVIM_0         (0x0u <<  0) /**< \brief (PEVC_OVIMR) Overrun Interrupt for Channel j Disabled */
#define   PEVC_OVIMR_OVIM_1         (0x1u <<  0) /**< \brief (PEVC_OVIMR) Overrun Interrupt for Channel j Enabled */
/* -------- PEVC_OVSR : (PEVC Offset: 0x050) Overrun Status Register -------- */
#define PEVC_OVSR_OVS_Pos           0
#define PEVC_OVSR_OVS_Msk           (0xFFFFFFFFu << PEVC_OVSR_OVS_Pos) /**< \brief (PEVC_OVSR) Overrun Interrupt Status */
#define PEVC_OVSR_OVS(value)        ((PEVC_OVSR_OVS_Msk & ((value) << PEVC_OVSR_OVS_Pos)))
#define   PEVC_OVSR_OVS_0           (0x0u <<  0) /**< \brief (PEVC_OVSR) No Overrun occured on Channel j */
#define   PEVC_OVSR_OVS_1           (0x1u <<  0) /**< \brief (PEVC_OVSR) Overrun occured on Channel j */
/* -------- PEVC_OVSCR : (PEVC Offset: 0x054) Overrun Status Clear Register -------- */
#define PEVC_OVSCR_OVSC_Pos         0
#define PEVC_OVSCR_OVSC_Msk         (0xFFFFFFFFu << PEVC_OVSCR_OVSC_Pos) /**< \brief (PEVC_OVSCR) Overrun Interrupt Status Clear */
#define PEVC_OVSCR_OVSC(value)      ((PEVC_OVSCR_OVSC_Msk & ((value) << PEVC_OVSCR_OVSC_Pos)))
#define   PEVC_OVSCR_OVSC_0         (0x0u <<  0) /**< \brief (PEVC_OVSCR) No Action */
#define   PEVC_OVSCR_OVSC_1         (0x1u <<  0) /**< \brief (PEVC_OVSCR) Clear Overrun Status Bit j */
/* -------- PEVC_CHMX : (PEVC Offset: 0x100) Chmx Channel Multiplexer 0 -------- */
#define PEVC_CHMX_EVMX_Pos          0
#define PEVC_CHMX_EVMX_Msk          (0x3Fu << PEVC_CHMX_EVMX_Pos) /**< \brief (PEVC_CHMX) Event Multiplexer */
#define PEVC_CHMX_EVMX(value)       ((PEVC_CHMX_EVMX_Msk & ((value) << PEVC_CHMX_EVMX_Pos)))
#define   PEVC_CHMX_EVMX_0          (0x0u <<  0) /**< \brief (PEVC_CHMX) Event 0 */
#define   PEVC_CHMX_EVMX_1          (0x1u <<  0) /**< \brief (PEVC_CHMX) Event 1 */
#define PEVC_CHMX_SMX               (0x1u <<  8) /**< \brief (PEVC_CHMX) Software Event Multiplexer */
#define   PEVC_CHMX_SMX_0           (0x0u <<  8) /**< \brief (PEVC_CHMX) Hardware events */
#define   PEVC_CHMX_SMX_1           (0x1u <<  8) /**< \brief (PEVC_CHMX) Software event */
/* -------- PEVC_EVS : (PEVC Offset: 0x200) Evs Event Shaper 0 -------- */
#define PEVC_EVS_EN                 (0x1u <<  0) /**< \brief (PEVC_EVS) Event Shaper Enable */
#define   PEVC_EVS_EN_0             (0x0u <<  0) /**< \brief (PEVC_EVS) No Action */
#define   PEVC_EVS_EN_1             (0x1u <<  0) /**< \brief (PEVC_EVS) Event Shaper enable */
#define PEVC_EVS_IGFR               (0x1u << 16) /**< \brief (PEVC_EVS) Input Glitch Filter Rise */
#define   PEVC_EVS_IGFR_0           (0x0u << 16) /**< \brief (PEVC_EVS) No Action */
#define   PEVC_EVS_IGFR_1           (0x1u << 16) /**< \brief (PEVC_EVS) Input Glitch Filter : a rising edge on event input will raise trigger output */
#define PEVC_EVS_IGFF               (0x1u << 17) /**< \brief (PEVC_EVS) Input Glitch Filter Fall */
#define   PEVC_EVS_IGFF_0           (0x0u << 17) /**< \brief (PEVC_EVS) No Action */
#define   PEVC_EVS_IGFF_1           (0x1u << 17) /**< \brief (PEVC_EVS) Input Glitch Filter : a falling edge on event input will raise trigger output */
#define PEVC_EVS_IGFON              (0x1u << 18) /**< \brief (PEVC_EVS) Input Glitch Filter Status */
/* -------- PEVC_IGFDR : (PEVC Offset: 0x300) Input Glitch Filter Divider Register -------- */
#define PEVC_IGFDR_IGFDR_Pos        0
#define PEVC_IGFDR_IGFDR_Msk        (0xFu << PEVC_IGFDR_IGFDR_Pos) /**< \brief (PEVC_IGFDR) Input Glitch Filter Divider Register */
#define PEVC_IGFDR_IGFDR(value)     ((PEVC_IGFDR_IGFDR_Msk & ((value) << PEVC_IGFDR_IGFDR_Pos)))
/* -------- PEVC_PARAMETER : (PEVC Offset: 0x3F8) Parameter -------- */
#define PEVC_PARAMETER_IGF_COUNT_Pos    0
#define PEVC_PARAMETER_IGF_COUNT_Msk    (0xFFu << PEVC_PARAMETER_IGF_COUNT_Pos) /**< \brief (PEVC_PARAMETER) Number of Input Glitch Filters */
#define PEVC_PARAMETER_IGF_COUNT(value) ((PEVC_PARAMETER_IGF_COUNT_Msk & ((value) << PEVC_PARAMETER_IGF_COUNT_Pos)))
#define PEVC_PARAMETER_EVS_COUNT_Pos    8
#define PEVC_PARAMETER_EVS_COUNT_Msk    (0xFFu << PEVC_PARAMETER_EVS_COUNT_Pos) /**< \brief (PEVC_PARAMETER) Number of Event Shapers */
#define PEVC_PARAMETER_EVS_COUNT(value) ((PEVC_PARAMETER_EVS_COUNT_Msk & ((value) << PEVC_PARAMETER_EVS_COUNT_Pos)))
#define PEVC_PARAMETER_EVIN_Pos     16
#define PEVC_PARAMETER_EVIN_Msk     (0xFFu << PEVC_PARAMETER_EVIN_Pos) /**< \brief (PEVC_PARAMETER) Number of Event Inputs / Generators */
#define PEVC_PARAMETER_EVIN(value)  ((PEVC_PARAMETER_EVIN_Msk & ((value) << PEVC_PARAMETER_EVIN_Pos)))
#define PEVC_PARAMETER_TRIGOUT_Pos    24
#define PEVC_PARAMETER_TRIGOUT_Msk    (0xFFu << PEVC_PARAMETER_TRIGOUT_Pos) /**< \brief (PEVC_PARAMETER) Number of Trigger Outputs / Channels / Users */
#define PEVC_PARAMETER_TRIGOUT(value) ((PEVC_PARAMETER_TRIGOUT_Msk & ((value) << PEVC_PARAMETER_TRIGOUT_Pos)))
/* -------- PEVC_VERSION : (PEVC Offset: 0x3FC) Version -------- */
#define PEVC_VERSION_VERSION_Pos    0
#define PEVC_VERSION_VERSION_Msk    (0xFFFu << PEVC_VERSION_VERSION_Pos) /**< \brief (PEVC_VERSION) Version Number */
#define PEVC_VERSION_VERSION(value) ((PEVC_VERSION_VERSION_Msk & ((value) << PEVC_VERSION_VERSION_Pos)))
#define PEVC_VERSION_VARIANT_Pos    16
#define PEVC_VERSION_VARIANT_Msk    (0xFu << PEVC_VERSION_VARIANT_Pos) /**< \brief (PEVC_VERSION) Variant Number */
#define PEVC_VERSION_VARIANT(value) ((PEVC_VERSION_VARIANT_Msk & ((value) << PEVC_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR PICOUART */
/* ============================================================================= */
/** \addtogroup SAM4L4_PICOUART Pico UART */
/*@{*/

#define REV_PICOUART   0x101

#ifndef __ASSEMBLY__
/** \brief PICOUART hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (PICOUART Offset: 0x00) Control Register */
  RwReg   CFG;         /**< \brief (PICOUART Offset: 0x04) Configuration Register */
  RoReg   SR;          /**< \brief (PICOUART Offset: 0x08) Status Register */
  RoReg   RHR;         /**< \brief (PICOUART Offset: 0x0C) Receive Holding Register */
  RoReg   Reserved1[4];
  RoReg   VERSION;     /**< \brief (PICOUART Offset: 0x20) Version Register */
} Picouart;
#endif /* __ASSEMBLY__ */
/* -------- PICOUART_CR : (PICOUART Offset: 0x00) Control Register -------- */
#define PICOUART_CR_EN              (0x1u <<  0) /**< \brief (PICOUART_CR) Enable */
#define PICOUART_CR_DIS             (0x1u <<  1) /**< \brief (PICOUART_CR) Disable */
/* -------- PICOUART_CFG : (PICOUART Offset: 0x04) Configuration Register -------- */
#define PICOUART_CFG_SOURCE_Pos     0
#define PICOUART_CFG_SOURCE_Msk     (0x3u << PICOUART_CFG_SOURCE_Pos) /**< \brief (PICOUART_CFG) Source Enable Mode */
#define PICOUART_CFG_SOURCE(value)  ((PICOUART_CFG_SOURCE_Msk & ((value) << PICOUART_CFG_SOURCE_Pos)))
#define PICOUART_CFG_ACTION         (0x1u <<  2) /**< \brief (PICOUART_CFG) Action to perform */
#define PICOUART_CFG_MATCH_Pos      8
#define PICOUART_CFG_MATCH_Msk      (0xFFu << PICOUART_CFG_MATCH_Pos) /**< \brief (PICOUART_CFG) Data Match */
#define PICOUART_CFG_MATCH(value)   ((PICOUART_CFG_MATCH_Msk & ((value) << PICOUART_CFG_MATCH_Pos)))
/* -------- PICOUART_SR : (PICOUART Offset: 0x08) Status Register -------- */
#define PICOUART_SR_EN              (0x1u <<  0) /**< \brief (PICOUART_SR) Enable Interrupt Status */
#define PICOUART_SR_DRDY            (0x1u <<  1) /**< \brief (PICOUART_SR) Data Ready Interrupt Status */
/* -------- PICOUART_RHR : (PICOUART Offset: 0x0C) Receive Holding Register -------- */
#define PICOUART_RHR_CDATA_Pos      0
#define PICOUART_RHR_CDATA_Msk      (0xFFFFFFFFu << PICOUART_RHR_CDATA_Pos) /**< \brief (PICOUART_RHR) Received Data */
#define PICOUART_RHR_CDATA(value)   ((PICOUART_RHR_CDATA_Msk & ((value) << PICOUART_RHR_CDATA_Pos)))
/* -------- PICOUART_VERSION : (PICOUART Offset: 0x20) Version Register -------- */
#define PICOUART_VERSION_VERSION_Pos    0
#define PICOUART_VERSION_VERSION_Msk    (0xFFFu << PICOUART_VERSION_VERSION_Pos) /**< \brief (PICOUART_VERSION) Version Number */
#define PICOUART_VERSION_VERSION(value) ((PICOUART_VERSION_VERSION_Msk & ((value) << PICOUART_VERSION_VERSION_Pos)))
#define PICOUART_VERSION_VARIANT_Pos    16
#define PICOUART_VERSION_VARIANT_Msk    (0xFu << PICOUART_VERSION_VARIANT_Pos) /**< \brief (PICOUART_VERSION) Variant Number */
#define PICOUART_VERSION_VARIANT(value) ((PICOUART_VERSION_VARIANT_Msk & ((value) << PICOUART_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR PM */
/* ============================================================================= */
/** \addtogroup SAM4L4_PM Power Manager */
/*@{*/

#define REV_PM         0x441

#ifndef __ASSEMBLY__
/** \brief PM hardware registers */
typedef struct {
  RwReg   MCCTRL;      /**< \brief (PM Offset: 0x000) Main Clock Control */
  RwReg   CPUSEL;      /**< \brief (PM Offset: 0x004) CPU Clock Select */
  RoReg   Reserved1[1];
  RwReg   PBASEL;      /**< \brief (PM Offset: 0x00C) PBA Clock Select */
  RwReg   PBBSEL;      /**< \brief (PM Offset: 0x010) PBB Clock Select */
  RwReg   PBCSEL;      /**< \brief (PM Offset: 0x014) PBC Clock Select */
  RwReg   PBDSEL;      /**< \brief (PM Offset: 0x018) PBD Clock Select */
  RoReg   Reserved2[1];
  RwReg   CPUMASK;     /**< \brief (PM Offset: 0x020) CPU Mask */
  RwReg   HSBMASK;     /**< \brief (PM Offset: 0x024) HSB Mask */
  RwReg   PBAMASK;     /**< \brief (PM Offset: 0x028) PBA Mask */
  RwReg   PBBMASK;     /**< \brief (PM Offset: 0x02C) PBB Mask */
  RwReg   PBCMASK;     /**< \brief (PM Offset: 0x030) PBC Mask */
  RwReg   PBDMASK;     /**< \brief (PM Offset: 0x034) PBD Mask */
  RoReg   Reserved3[2];
  RwReg   PBADIVMASK;  /**< \brief (PM Offset: 0x040) PBA Divided Clock Mask */
  RoReg   Reserved4[4];
  RwReg   CFDCTRL;     /**< \brief (PM Offset: 0x054) Clock Failure Detector Control */
  WoReg   UNLOCK;      /**< \brief (PM Offset: 0x058) Unlock Register */
  RoReg   Reserved5[25];
  WoReg   IER;         /**< \brief (PM Offset: 0x0C0) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (PM Offset: 0x0C4) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (PM Offset: 0x0C8) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (PM Offset: 0x0CC) Interrupt Status Register */
  WoReg   ICR;         /**< \brief (PM Offset: 0x0D0) Interrupt Clear Register */
  RoReg   SR;          /**< \brief (PM Offset: 0x0D4) Status Register */
  RoReg   Reserved6[34];
  RwReg   PPCR;        /**< \brief (PM Offset: 0x160) Peripheral Power Control Register */
  RoReg   Reserved7[7];
  RoReg   RCAUSE;      /**< \brief (PM Offset: 0x180) Reset Cause Register */
  RoReg   WCAUSE;      /**< \brief (PM Offset: 0x184) Wake Cause Register */
  RwReg   AWEN;        /**< \brief (PM Offset: 0x188) Asynchronous Wake Enable */
  RoReg   Reserved8[1];
  RwReg   OBS;         /**< \brief (PM Offset: 0x190) Obsvervability */
  RwReg   FASTSLEEP;   /**< \brief (PM Offset: 0x194) Fast Sleep Register */
  RoReg   Reserved9[152];
  RoReg   CONFIG;      /**< \brief (PM Offset: 0x3F8) Configuration Register */
  RoReg   VERSION;     /**< \brief (PM Offset: 0x3FC) Version Register */
} Pm;
#endif /* __ASSEMBLY__ */
/* -------- PM_MCCTRL : (PM Offset: 0x000) Main Clock Control -------- */
#define PM_MCCTRL_MCSEL_Pos         0
#define PM_MCCTRL_MCSEL_Msk         (0x7u << PM_MCCTRL_MCSEL_Pos) /**< \brief (PM_MCCTRL) Main Clock Select */
#define PM_MCCTRL_MCSEL(value)      ((PM_MCCTRL_MCSEL_Msk & ((value) << PM_MCCTRL_MCSEL_Pos)))
/* -------- PM_CPUSEL : (PM Offset: 0x004) CPU Clock Select -------- */
#define PM_CPUSEL_CPUSEL_Pos        0
#define PM_CPUSEL_CPUSEL_Msk        (0x7u << PM_CPUSEL_CPUSEL_Pos) /**< \brief (PM_CPUSEL) CPU Clock Select */
#define PM_CPUSEL_CPUSEL(value)     ((PM_CPUSEL_CPUSEL_Msk & ((value) << PM_CPUSEL_CPUSEL_Pos)))
#define   PM_CPUSEL_CPUSEL_0        (0x0u <<  0) /**< \brief (PM_CPUSEL) fCPU:fmain. CPUDIV: */
#define   PM_CPUSEL_CPUSEL_1        (0x1u <<  0) /**< \brief (PM_CPUSEL) fCPU:fmain / 2^(CPUSEL+1) */
#define PM_CPUSEL_CPUDIV            (0x1u <<  7) /**< \brief (PM_CPUSEL) CPU Division */
/* -------- PM_PBASEL : (PM Offset: 0x00C) PBA Clock Select -------- */
#define PM_PBASEL_PBSEL_Pos         0
#define PM_PBASEL_PBSEL_Msk         (0x7u << PM_PBASEL_PBSEL_Pos) /**< \brief (PM_PBASEL) PBA Clock Select */
#define PM_PBASEL_PBSEL(value)      ((PM_PBASEL_PBSEL_Msk & ((value) << PM_PBASEL_PBSEL_Pos)))
#define PM_PBASEL_PBDIV             (0x1u <<  7) /**< \brief (PM_PBASEL) PBA Division Select */
/* -------- PM_PBBSEL : (PM Offset: 0x010) PBB Clock Select -------- */
#define PM_PBBSEL_PBSEL_Pos         0
#define PM_PBBSEL_PBSEL_Msk         (0x7u << PM_PBBSEL_PBSEL_Pos) /**< \brief (PM_PBBSEL) PBB Clock Select */
#define PM_PBBSEL_PBSEL(value)      ((PM_PBBSEL_PBSEL_Msk & ((value) << PM_PBBSEL_PBSEL_Pos)))
#define PM_PBBSEL_PBDIV             (0x1u <<  7) /**< \brief (PM_PBBSEL) PBB Division Select */
/* -------- PM_PBCSEL : (PM Offset: 0x014) PBC Clock Select -------- */
#define PM_PBCSEL_PBSEL_Pos         0
#define PM_PBCSEL_PBSEL_Msk         (0x7u << PM_PBCSEL_PBSEL_Pos) /**< \brief (PM_PBCSEL) PBC Clock Select */
#define PM_PBCSEL_PBSEL(value)      ((PM_PBCSEL_PBSEL_Msk & ((value) << PM_PBCSEL_PBSEL_Pos)))
#define PM_PBCSEL_PBDIV             (0x1u <<  7) /**< \brief (PM_PBCSEL) PBC Division Select */
/* -------- PM_PBDSEL : (PM Offset: 0x018) PBD Clock Select -------- */
#define PM_PBDSEL_PBSEL_Pos         0
#define PM_PBDSEL_PBSEL_Msk         (0x7u << PM_PBDSEL_PBSEL_Pos) /**< \brief (PM_PBDSEL) PBD Clock Select */
#define PM_PBDSEL_PBSEL(value)      ((PM_PBDSEL_PBSEL_Msk & ((value) << PM_PBDSEL_PBSEL_Pos)))
#define PM_PBDSEL_PBDIV             (0x1u <<  7) /**< \brief (PM_PBDSEL) PBD Division Select */
/* -------- PM_CPUMASK : (PM Offset: 0x020) CPU Mask -------- */
#define PM_CPUMASK_OCD              (0x1u <<  0) /**< \brief (PM_CPUMASK) OCD CPU Clock Mask */
/* -------- PM_HSBMASK : (PM Offset: 0x024) HSB Mask -------- */
#define PM_HSBMASK_PDCA             (0x1u <<  0) /**< \brief (PM_HSBMASK) PDCA HSB Clock Mask */
#define PM_HSBMASK_HFLASHC          (0x1u <<  1) /**< \brief (PM_HSBMASK) HFLASHC HSB Clock Mask */
#define PM_HSBMASK_HRAMC1           (0x1u <<  2) /**< \brief (PM_HSBMASK) HRAMC1 HSB Clock Mask */
#define PM_HSBMASK_USBC             (0x1u <<  3) /**< \brief (PM_HSBMASK) USBC HSB Clock Mask */
#define PM_HSBMASK_CRCCU            (0x1u <<  4) /**< \brief (PM_HSBMASK) CRCCU HSB Clock Mask */
#define PM_HSBMASK_HTOP0            (0x1u <<  5) /**< \brief (PM_HSBMASK) HTOP0 HSB Clock Mask */
#define PM_HSBMASK_HTOP1            (0x1u <<  6) /**< \brief (PM_HSBMASK) HTOP1 HSB Clock Mask */
#define PM_HSBMASK_HTOP2            (0x1u <<  7) /**< \brief (PM_HSBMASK) HTOP2 HSB Clock Mask */
#define PM_HSBMASK_HTOP3            (0x1u <<  8) /**< \brief (PM_HSBMASK) HTOP3 HSB Clock Mask */
#define PM_HSBMASK_AESA             (0x1u <<  9) /**< \brief (PM_HSBMASK) AESA HSB Clock Mask */
/* -------- PM_PBAMASK : (PM Offset: 0x028) PBA Mask -------- */
#define PM_PBAMASK_IISC             (0x1u <<  0) /**< \brief (PM_PBAMASK) IISC PB Clock Mask */
#define PM_PBAMASK_SPI              (0x1u <<  1) /**< \brief (PM_PBAMASK) SPI PB Clock Mask */
#define PM_PBAMASK_TC0              (0x1u <<  2) /**< \brief (PM_PBAMASK) TC0 PB Clock Mask */
#define PM_PBAMASK_TC1              (0x1u <<  3) /**< \brief (PM_PBAMASK) TC1 PB Clock Mask */
#define PM_PBAMASK_TWIM0            (0x1u <<  4) /**< \brief (PM_PBAMASK) TWIM0 PB Clock Mask */
#define PM_PBAMASK_TWIS0            (0x1u <<  5) /**< \brief (PM_PBAMASK) TWIS0 PB Clock Mask */
#define PM_PBAMASK_TWIM1            (0x1u <<  6) /**< \brief (PM_PBAMASK) TWIM1 PB Clock Mask */
#define PM_PBAMASK_TWIS1            (0x1u <<  7) /**< \brief (PM_PBAMASK) TWIS1 PB Clock Mask */
#define PM_PBAMASK_USART0           (0x1u <<  8) /**< \brief (PM_PBAMASK) USART0 PB Clock Mask */
#define PM_PBAMASK_USART1           (0x1u <<  9) /**< \brief (PM_PBAMASK) USART1 PB Clock Mask */
#define PM_PBAMASK_USART2           (0x1u << 10) /**< \brief (PM_PBAMASK) USART2 PB Clock Mask */
#define PM_PBAMASK_USART3           (0x1u << 11) /**< \brief (PM_PBAMASK) USART3 PB Clock Mask */
#define PM_PBAMASK_ADCIFE           (0x1u << 12) /**< \brief (PM_PBAMASK) ADCIFE PB Clock Mask */
#define PM_PBAMASK_DACC             (0x1u << 13) /**< \brief (PM_PBAMASK) DACC PB Clock Mask */
#define PM_PBAMASK_ACIFC            (0x1u << 14) /**< \brief (PM_PBAMASK) ACIFC PB Clock Mask */
#define PM_PBAMASK_GLOC             (0x1u << 15) /**< \brief (PM_PBAMASK) GLOC PB Clock Mask */
#define PM_PBAMASK_ABDACB           (0x1u << 16) /**< \brief (PM_PBAMASK) ABDACB PB Clock Mask */
#define PM_PBAMASK_TRNG             (0x1u << 17) /**< \brief (PM_PBAMASK) TRNG PB Clock Mask */
#define PM_PBAMASK_PARC             (0x1u << 18) /**< \brief (PM_PBAMASK) PARC PB Clock Mask */
#define PM_PBAMASK_CATB             (0x1u << 19) /**< \brief (PM_PBAMASK) CATB PB Clock Mask */
#define PM_PBAMASK_TWIM2            (0x1u << 21) /**< \brief (PM_PBAMASK) TWIM2 PB Clock Mask */
#define PM_PBAMASK_TWIM3            (0x1u << 22) /**< \brief (PM_PBAMASK) TWIM3 PB Clock Mask */
#define PM_PBAMASK_LCDCA            (0x1u << 23) /**< \brief (PM_PBAMASK) LCDCA PB Clock Mask */
/* -------- PM_PBBMASK : (PM Offset: 0x02C) PBB Mask -------- */
#define PM_PBBMASK_HFLASHC          (0x1u <<  0) /**< \brief (PM_PBBMASK) HFLASHC PB Clock Mask */
#define PM_PBBMASK_HCACHE           (0x1u <<  1) /**< \brief (PM_PBBMASK) HCACHE PB Clock Mask */
#define PM_PBBMASK_HMATRIX          (0x1u <<  2) /**< \brief (PM_PBBMASK) HMATRIX PB Clock Mask */
#define PM_PBBMASK_PDCA             (0x1u <<  3) /**< \brief (PM_PBBMASK) PDCA PB Clock Mask */
#define PM_PBBMASK_CRCCU            (0x1u <<  4) /**< \brief (PM_PBBMASK) CRCCU PB Clock Mask */
#define PM_PBBMASK_USBC             (0x1u <<  5) /**< \brief (PM_PBBMASK) USBC PB Clock Mask */
#define PM_PBBMASK_PEVC             (0x1u <<  6) /**< \brief (PM_PBBMASK) PEVC PB Clock Mask */
/* -------- PM_PBCMASK : (PM Offset: 0x030) PBC Mask -------- */
#define PM_PBCMASK_PM               (0x1u <<  0) /**< \brief (PM_PBCMASK) PM PB Clock Mask */
#define PM_PBCMASK_CHIPID           (0x1u <<  1) /**< \brief (PM_PBCMASK) CHIPID PB Clock Mask */
#define PM_PBCMASK_SCIF             (0x1u <<  2) /**< \brief (PM_PBCMASK) SCIF PB Clock Mask */
#define PM_PBCMASK_FREQM            (0x1u <<  3) /**< \brief (PM_PBCMASK) FREQM PB Clock Mask */
#define PM_PBCMASK_GPIO             (0x1u <<  4) /**< \brief (PM_PBCMASK) GPIO PB Clock Mask */
/* -------- PM_PBDMASK : (PM Offset: 0x034) PBD Mask -------- */
#define PM_PBDMASK_BPM              (0x1u <<  0) /**< \brief (PM_PBDMASK) BPM PB Clock Mask */
#define PM_PBDMASK_BSCIF            (0x1u <<  1) /**< \brief (PM_PBDMASK) BSCIF PB Clock Mask */
#define PM_PBDMASK_AST              (0x1u <<  2) /**< \brief (PM_PBDMASK) AST PB Clock Mask */
#define PM_PBDMASK_WDT              (0x1u <<  3) /**< \brief (PM_PBDMASK) WDT PB Clock Mask */
#define PM_PBDMASK_EIC              (0x1u <<  4) /**< \brief (PM_PBDMASK) EIC PB Clock Mask */
#define PM_PBDMASK_PICOUART         (0x1u <<  5) /**< \brief (PM_PBDMASK) PICOUART PB Clock Mask */
/* -------- PM_CFDCTRL : (PM Offset: 0x054) Clock Failure Detector Control -------- */
#define PM_CFDCTRL_CFDEN            (0x1u <<  0) /**< \brief (PM_CFDCTRL) Clock Failure Detection Enable */
#define PM_CFDCTRL_SFV              (0x1u << 31) /**< \brief (PM_CFDCTRL) Store Final Value */
/* -------- PM_UNLOCK : (PM Offset: 0x058) Unlock Register -------- */
#define PM_UNLOCK_ADDR_Pos          0
#define PM_UNLOCK_ADDR_Msk          (0x3FFu << PM_UNLOCK_ADDR_Pos) /**< \brief (PM_UNLOCK) Unlock Address */
#define PM_UNLOCK_ADDR(value)       ((PM_UNLOCK_ADDR_Msk & ((value) << PM_UNLOCK_ADDR_Pos)))
#define PM_UNLOCK_KEY_Pos           24
#define PM_UNLOCK_KEY_Msk           (0xFFu << PM_UNLOCK_KEY_Pos) /**< \brief (PM_UNLOCK) Unlock Key */
#define PM_UNLOCK_KEY(value)        ((PM_UNLOCK_KEY_Msk & ((value) << PM_UNLOCK_KEY_Pos)))
/* -------- PM_IER : (PM Offset: 0x0C0) Interrupt Enable Register -------- */
#define PM_IER_CFD                  (0x1u <<  0) /**< \brief (PM_IER) Clock Failure Detected Interrupt Enable */
#define PM_IER_CKRDY                (0x1u <<  5) /**< \brief (PM_IER) Clock Ready Interrupt Enable */
#define PM_IER_WAKE                 (0x1u <<  8) /**< \brief (PM_IER) Wake up Interrupt Enable */
#define   PM_IER_WAKE_0             (0x0u <<  8) /**< \brief (PM_IER) No effect */
#define   PM_IER_WAKE_1             (0x1u <<  8) /**< \brief (PM_IER) Disable Interrupt. */
#define PM_IER_AE                   (0x1u << 31) /**< \brief (PM_IER) Access Error Interrupt Enable */
/* -------- PM_IDR : (PM Offset: 0x0C4) Interrupt Disable Register -------- */
#define PM_IDR_CFD                  (0x1u <<  0) /**< \brief (PM_IDR) Clock Failure Detected Interrupt Disable */
#define PM_IDR_CKRDY                (0x1u <<  5) /**< \brief (PM_IDR) Clock Ready Interrupt Disable */
#define PM_IDR_WAKE                 (0x1u <<  8) /**< \brief (PM_IDR) Wake up Interrupt Disable */
#define   PM_IDR_WAKE_0             (0x0u <<  8) /**< \brief (PM_IDR) No effect */
#define   PM_IDR_WAKE_1             (0x1u <<  8) /**< \brief (PM_IDR) Disable Interrupt. */
#define PM_IDR_AE                   (0x1u << 31) /**< \brief (PM_IDR) Access Error Interrupt Disable */
/* -------- PM_IMR : (PM Offset: 0x0C8) Interrupt Mask Register -------- */
#define PM_IMR_CFD                  (0x1u <<  0) /**< \brief (PM_IMR) Clock Failure Detected Interrupt Mask */
#define PM_IMR_CKRDY                (0x1u <<  5) /**< \brief (PM_IMR) Clock Ready Interrupt Mask */
#define PM_IMR_WAKE                 (0x1u <<  8) /**< \brief (PM_IMR) Wake up Interrupt Mask */
#define   PM_IMR_WAKE_0             (0x0u <<  8) /**< \brief (PM_IMR) No effect */
#define   PM_IMR_WAKE_1             (0x1u <<  8) /**< \brief (PM_IMR) Disable Interrupt. */
#define PM_IMR_AE                   (0x1u << 31) /**< \brief (PM_IMR) Access Error Interrupt Mask */
/* -------- PM_ISR : (PM Offset: 0x0CC) Interrupt Status Register -------- */
#define PM_ISR_CFD                  (0x1u <<  0) /**< \brief (PM_ISR) Clock Failure Detected Interrupt Status */
#define PM_ISR_CKRDY                (0x1u <<  5) /**< \brief (PM_ISR) Clock Ready Interrupt Status */
#define PM_ISR_WAKE                 (0x1u <<  8) /**< \brief (PM_ISR) Wake up Interrupt Status */
#define   PM_ISR_WAKE_0             (0x0u <<  8) /**< \brief (PM_ISR) No effect */
#define   PM_ISR_WAKE_1             (0x1u <<  8) /**< \brief (PM_ISR) Disable Interrupt. */
#define PM_ISR_AE                   (0x1u << 31) /**< \brief (PM_ISR) Access Error Interrupt Status */
/* -------- PM_ICR : (PM Offset: 0x0D0) Interrupt Clear Register -------- */
#define PM_ICR_CFD                  (0x1u <<  0) /**< \brief (PM_ICR) Clock Failure Detected Interrupt Status Clear */
#define PM_ICR_CKRDY                (0x1u <<  5) /**< \brief (PM_ICR) Clock Ready Interrupt Status Clear */
#define PM_ICR_WAKE                 (0x1u <<  8) /**< \brief (PM_ICR) Wake up Interrupt Status Clear */
#define PM_ICR_AE                   (0x1u << 31) /**< \brief (PM_ICR) Access Error Interrupt Status Clear */
/* -------- PM_SR : (PM Offset: 0x0D4) Status Register -------- */
#define PM_SR_CFD                   (0x1u <<  0) /**< \brief (PM_SR) Clock Failure Detected */
#define PM_SR_OCP                   (0x1u <<  1) /**< \brief (PM_SR) Over Clock Detected */
#define PM_SR_CKRDY                 (0x1u <<  5) /**< \brief (PM_SR) Clock Ready */
#define PM_SR_WAKE                  (0x1u <<  8) /**< \brief (PM_SR) Wake up */
#define   PM_SR_WAKE_0              (0x0u <<  8) /**< \brief (PM_SR) No effect */
#define   PM_SR_WAKE_1              (0x1u <<  8) /**< \brief (PM_SR) Disable Interrupt. */
#define PM_SR_PERRDY                (0x1u << 28) /**< \brief (PM_SR) Peripheral Ready */
#define PM_SR_AE                    (0x1u << 31) /**< \brief (PM_SR) Access Error */
/* -------- PM_PPCR : (PM Offset: 0x160) Peripheral Power Control Register -------- */
#define PM_PPCR_RSTPUN              (0x1u <<  0) /**< \brief (PM_PPCR) Reset Pullup */
#define PM_PPCR_CATBRCMASK          (0x1u <<  1) /**< \brief (PM_PPCR) CAT Request Clock Mask */
#define PM_PPCR_ACIFCRCMASK         (0x1u <<  2) /**< \brief (PM_PPCR) ACIFC Request Clock Mask */
#define PM_PPCR_ASTRCMASK           (0x1u <<  3) /**< \brief (PM_PPCR) AST Request Clock Mask */
#define PM_PPCR_TWIS0RCMASK         (0x1u <<  4) /**< \brief (PM_PPCR) TWIS0 Request Clock Mask */
#define PM_PPCR_TWIS1RCMASK         (0x1u <<  5) /**< \brief (PM_PPCR) TWIS1 Request Clock Mask */
#define PM_PPCR_PEVCRCMASK          (0x1u <<  6) /**< \brief (PM_PPCR) PEVC Request Clock Mask */
#define PM_PPCR_ADCIFERCMASK        (0x1u <<  7) /**< \brief (PM_PPCR) ADCIFE Request Clock Mask */
#define PM_PPCR_VREGRCMASK          (0x1u <<  8) /**< \brief (PM_PPCR) VREG Request Clock Mask */
#define PM_PPCR_FWBGREF             (0x1u <<  9) /**< \brief (PM_PPCR) Flash Wait BGREF */
#define PM_PPCR_FWBOD18             (0x1u << 10) /**< \brief (PM_PPCR) Flash Wait BOD18 */
/* -------- PM_RCAUSE : (PM Offset: 0x180) Reset Cause Register -------- */
#define PM_RCAUSE_POR               (0x1u <<  0) /**< \brief (PM_RCAUSE) Power-on Reset */
#define PM_RCAUSE_BOD               (0x1u <<  1) /**< \brief (PM_RCAUSE) Brown-out Reset */
#define PM_RCAUSE_EXT               (0x1u <<  2) /**< \brief (PM_RCAUSE) External Reset Pin */
#define PM_RCAUSE_WDT               (0x1u <<  3) /**< \brief (PM_RCAUSE) Watchdog Reset */
#define PM_RCAUSE_OCDRST            (0x1u <<  8) /**< \brief (PM_RCAUSE) OCD Reset */
#define PM_RCAUSE_POR33             (0x1u << 10) /**< \brief (PM_RCAUSE) Power-on Reset */
#define PM_RCAUSE_BOD33             (0x1u << 13) /**< \brief (PM_RCAUSE) Brown-out 3.3V Reset */
/* -------- PM_WCAUSE : (PM Offset: 0x184) Wake Cause Register -------- */
#define PM_WCAUSE_TWI_SLAVE_0_Pos    0
#define PM_WCAUSE_TWI_SLAVE_0_Msk    (0xFFFFu << PM_WCAUSE_TWI_SLAVE_0_Pos) /**< \brief (PM_WCAUSE) Two-wire Slave Interface 0 */
#define PM_WCAUSE_TWI_SLAVE_0(value) ((PM_WCAUSE_TWI_SLAVE_0_Msk & ((value) << PM_WCAUSE_TWI_SLAVE_0_Pos)))
#define PM_WCAUSE_TWI_SLAVE_1       (0x1u <<  1) /**< \brief (PM_WCAUSE) Two-wire Slave Interface 1 */
#define PM_WCAUSE_USBC              (0x1u <<  2) /**< \brief (PM_WCAUSE) USB Device and Embedded Host Interface */
#define PM_WCAUSE_PSOK              (0x1u <<  3) /**< \brief (PM_WCAUSE) Power Scaling OK */
#define PM_WCAUSE_BOD18_IRQ         (0x1u <<  4) /**< \brief (PM_WCAUSE) BOD18 Interrupt */
#define PM_WCAUSE_BOD33_IRQ         (0x1u <<  5) /**< \brief (PM_WCAUSE) BOD33 Interrupt */
#define PM_WCAUSE_PICOUART          (0x1u <<  6) /**< \brief (PM_WCAUSE) Picopower UART */
#define PM_WCAUSE_LCDCA             (0x1u <<  7) /**< \brief (PM_WCAUSE) LCD Controller */
#define PM_WCAUSE_EIC               (0x1u << 16) /**< \brief (PM_WCAUSE) External Interrupt Controller */
#define PM_WCAUSE_AST               (0x1u << 17) /**< \brief (PM_WCAUSE) Asynchronous Timer */
/* -------- PM_AWEN : (PM Offset: 0x188) Asynchronous Wake Enable -------- */
#define PM_AWEN_AWEN_Pos            0
#define PM_AWEN_AWEN_Msk            (0xFFFFFFFFu << PM_AWEN_AWEN_Pos) /**< \brief (PM_AWEN) Asynchronous Wake Up */
#define PM_AWEN_AWEN(value)         ((PM_AWEN_AWEN_Msk & ((value) << PM_AWEN_AWEN_Pos)))
/* -------- PM_OBS : (PM Offset: 0x190) Obsvervability -------- */
/* -------- PM_FASTSLEEP : (PM Offset: 0x194) Fast Sleep Register -------- */
#define PM_FASTSLEEP_OSC            (0x1u <<  0) /**< \brief (PM_FASTSLEEP) Oscillator */
#define PM_FASTSLEEP_PLL            (0x1u <<  8) /**< \brief (PM_FASTSLEEP) PLL */
#define PM_FASTSLEEP_FASTRCOSC_Pos    16
#define PM_FASTSLEEP_FASTRCOSC_Msk    (0x1Fu << PM_FASTSLEEP_FASTRCOSC_Pos) /**< \brief (PM_FASTSLEEP) RC80 or FLO */
#define PM_FASTSLEEP_FASTRCOSC(value) ((PM_FASTSLEEP_FASTRCOSC_Msk & ((value) << PM_FASTSLEEP_FASTRCOSC_Pos)))
#define PM_FASTSLEEP_DFLL           (0x1u << 24) /**< \brief (PM_FASTSLEEP) DFLL */
/* -------- PM_CONFIG : (PM Offset: 0x3F8) Configuration Register -------- */
#define PM_CONFIG_PBA               (0x1u <<  0) /**< \brief (PM_CONFIG) APBA Implemented */
#define PM_CONFIG_PBB               (0x1u <<  1) /**< \brief (PM_CONFIG) APBB Implemented */
#define PM_CONFIG_PBC               (0x1u <<  2) /**< \brief (PM_CONFIG) APBC Implemented */
#define PM_CONFIG_PBD               (0x1u <<  3) /**< \brief (PM_CONFIG) APBD Implemented */
#define PM_CONFIG_HSBPEVC           (0x1u <<  7) /**< \brief (PM_CONFIG) HSB PEVC Clock Implemented */
/* -------- PM_VERSION : (PM Offset: 0x3FC) Version Register -------- */
#define PM_VERSION_VERSION_Pos      0
#define PM_VERSION_VERSION_Msk      (0xFFFu << PM_VERSION_VERSION_Pos) /**< \brief (PM_VERSION) Version number */
#define PM_VERSION_VERSION(value)   ((PM_VERSION_VERSION_Msk & ((value) << PM_VERSION_VERSION_Pos)))
#define PM_VERSION_VARIANT_Pos      16
#define PM_VERSION_VARIANT_Msk      (0xFu << PM_VERSION_VARIANT_Pos) /**< \brief (PM_VERSION) Variant number */
#define PM_VERSION_VARIANT(value)   ((PM_VERSION_VARIANT_Msk & ((value) << PM_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR PTC */
/* ============================================================================= */
/** \addtogroup SAM4L4_PTC  */
/*@{*/

#define REV_PTC        0x100

#ifndef __ASSEMBLY__
/** \brief PTC hardware registers */
typedef struct {
  RoReg   Reserved1[63];
  RoReg   DMA;         /**< \brief (PTC Offset: 0xFC)  */
} Ptc;
#endif /* __ASSEMBLY__ */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR SCIF */
/* ============================================================================= */
/** \addtogroup SAM4L4_SCIF System Control Interface */
/*@{*/

#define REV_SCIF       0x130

#ifndef __ASSEMBLY__
/** \brief ScifGcctrl hardware registers */
typedef struct {
  RwReg   GCCTRL;      /**< \brief (ScifGcctrl Offset: 0x000) Generic Clock Control */
} ScifGcctrl;
/** \brief ScifPll hardware registers */
typedef struct {
  RwReg   PLL;         /**< \brief (ScifPll Offset: 0x000) PLL0 Control Register */
} ScifPll;
/** \brief SCIF hardware registers */
typedef struct {
  WoReg   IER;         /**< \brief (SCIF Offset: 0x000) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (SCIF Offset: 0x004) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (SCIF Offset: 0x008) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (SCIF Offset: 0x00C) Interrupt Status Register */
  WoReg   ICR;         /**< \brief (SCIF Offset: 0x010) Interrupt Clear Register */
  RoReg   PCLKSR;      /**< \brief (SCIF Offset: 0x014) Power and Clocks Status Register */
  WoReg   UNLOCK;      /**< \brief (SCIF Offset: 0x018) Unlock Register */
  RwReg   CSCR;        /**< \brief (SCIF Offset: 0x01C) Chip Specific Configuration Register */
  RwReg   OSCCTRL0;    /**< \brief (SCIF Offset: 0x020) Oscillator Control Register */
  ScifPll Pll[1]; /**< \brief (SCIF Offset: 0x024) ScifPll groups */
  RwReg   DFLL0CONF;   /**< \brief (SCIF Offset: 0x028) DFLL0 Config Register */
  RwReg   DFLL0VAL;    /**< \brief (SCIF Offset: 0x02C) DFLL Value Register */
  RwReg   DFLL0MUL;    /**< \brief (SCIF Offset: 0x030) DFLL0 Multiplier Register */
  RwReg   DFLL0STEP;   /**< \brief (SCIF Offset: 0x034) DFLL0 Step Register */
  RwReg   DFLL0SSG;    /**< \brief (SCIF Offset: 0x038) DFLL0 Spread Spectrum Generator Control Register */
  RoReg   DFLL0RATIO;  /**< \brief (SCIF Offset: 0x03C) DFLL0 Ratio Registe */
  WoReg   DFLL0SYNC;   /**< \brief (SCIF Offset: 0x040) DFLL0 Synchronization Register */
  RwReg   RCCR;        /**< \brief (SCIF Offset: 0x044) System RC Oscillator Calibration Register */
  RwReg   RCFASTCFG;   /**< \brief (SCIF Offset: 0x048) 4/8/12 MHz RC Oscillator Configuration
Register */
  RwReg   RCFASTSR;    /**< \brief (SCIF Offset: 0x04C) 4/8/12 MHz RC Oscillator Status Register */
  RwReg   RC80MCR;     /**< \brief (SCIF Offset: 0x050) 80 MHz RC Oscillator Register */
  RoReg   Reserved1[4];
  RwReg   HRPCR;       /**< \brief (SCIF Offset: 0x064) High Resolution Prescaler Control Register */
  RwReg   FPCR;        /**< \brief (SCIF Offset: 0x068) Fractional Prescaler Control Register */
  RwReg   FPMUL;       /**< \brief (SCIF Offset: 0x06C) Fractional Prescaler Multiplier Register */
  RwReg   FPDIV;       /**< \brief (SCIF Offset: 0x070) Fractional Prescaler DIVIDER Register */
  ScifGcctrl Gcctrl[12]; /**< \brief (SCIF Offset: 0x074) ScifGcctrl groups */
  RoReg   Reserved2[205];
  RoReg   RCFASTVERSION; /**< \brief (SCIF Offset: 0x3D8) 4/8/12 MHz RC Oscillator Version Register */
  RoReg   GCLKPRESCVERSION; /**< \brief (SCIF Offset: 0x3DC) Generic Clock Prescaler Version Register */
  RoReg   PLLIFAVERSION; /**< \brief (SCIF Offset: 0x3E0) PLL Version Register */
  RoReg   OSCIFAVERSION; /**< \brief (SCIF Offset: 0x3E4) Oscillator 0 Version Register */
  RoReg   DFLLIFBVERSION; /**< \brief (SCIF Offset: 0x3E8) DFLL Version Register */
  RoReg   RCOSCIFAVERSION; /**< \brief (SCIF Offset: 0x3EC) System RC Oscillator Version Register */
  RoReg   FLOVERSION;  /**< \brief (SCIF Offset: 0x3F0) Frequency Locked Oscillator Version Register */
  RoReg   RC80MVERSION; /**< \brief (SCIF Offset: 0x3F4) 80MHz RC Oscillator Version Register */
  RoReg   GCLKIFVERSION; /**< \brief (SCIF Offset: 0x3F8) Generic Clock Version Register */
  RoReg   VERSION;     /**< \brief (SCIF Offset: 0x3FC) SCIF Version Register */
} Scif;
#endif /* __ASSEMBLY__ */
/* -------- SCIF_IER : (SCIF Offset: 0x000) Interrupt Enable Register -------- */
#define SCIF_IER_OSC0RDY            (0x1u <<  0) /**< \brief (SCIF_IER)  */
#define SCIF_IER_DFLL0LOCKC         (0x1u <<  1) /**< \brief (SCIF_IER)  */
#define SCIF_IER_DFLL0LOCKF         (0x1u <<  2) /**< \brief (SCIF_IER)  */
#define SCIF_IER_DFLL0RDY           (0x1u <<  3) /**< \brief (SCIF_IER)  */
#define SCIF_IER_DFLL0RCS           (0x1u <<  4) /**< \brief (SCIF_IER)  */
#define SCIF_IER_DFLL0OOB           (0x1u <<  5) /**< \brief (SCIF_IER)  */
#define SCIF_IER_PLLLOCK0           (0x1u <<  6) /**< \brief (SCIF_IER)  */
#define SCIF_IER_PLLLOCKLOST0       (0x1u <<  7) /**< \brief (SCIF_IER)  */
#define SCIF_IER_RCFASTLOCK         (0x1u << 13) /**< \brief (SCIF_IER)  */
#define SCIF_IER_RCFASTLOCKLOST     (0x1u << 14) /**< \brief (SCIF_IER)  */
#define SCIF_IER_AE                 (0x1u << 31) /**< \brief (SCIF_IER)  */
/* -------- SCIF_IDR : (SCIF Offset: 0x004) Interrupt Disable Register -------- */
#define SCIF_IDR_OSC0RDY            (0x1u <<  0) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_DFLL0LOCKC         (0x1u <<  1) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_DFLL0LOCKF         (0x1u <<  2) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_DFLL0RDY           (0x1u <<  3) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_DFLL0RCS           (0x1u <<  4) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_DFLL0OOB           (0x1u <<  5) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_PLLLOCK0           (0x1u <<  6) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_PLLLOCKLOST0       (0x1u <<  7) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_RCFASTLOCK         (0x1u << 13) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_RCFASTLOCKLOST     (0x1u << 14) /**< \brief (SCIF_IDR)  */
#define SCIF_IDR_AE                 (0x1u << 31) /**< \brief (SCIF_IDR)  */
/* -------- SCIF_IMR : (SCIF Offset: 0x008) Interrupt Mask Register -------- */
#define SCIF_IMR_OSC0RDY            (0x1u <<  0) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_DFLL0LOCKC         (0x1u <<  1) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_DFLL0LOCKF         (0x1u <<  2) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_DFLL0RDY           (0x1u <<  3) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_DFLL0RCS           (0x1u <<  4) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_DFLL0OOB           (0x1u <<  5) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_PLLLOCK0           (0x1u <<  6) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_PLLLOCKLOST0       (0x1u <<  7) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_RCFASTLOCK         (0x1u << 13) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_RCFASTLOCKLOST     (0x1u << 14) /**< \brief (SCIF_IMR)  */
#define SCIF_IMR_AE                 (0x1u << 31) /**< \brief (SCIF_IMR)  */
/* -------- SCIF_ISR : (SCIF Offset: 0x00C) Interrupt Status Register -------- */
#define SCIF_ISR_OSC0RDY            (0x1u <<  0) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_DFLL0LOCKC         (0x1u <<  1) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_DFLL0LOCKF         (0x1u <<  2) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_DFLL0RDY           (0x1u <<  3) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_DFLL0RCS           (0x1u <<  4) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_DFLL0OOB           (0x1u <<  5) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_PLLLOCK0           (0x1u <<  6) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_PLLLOCKLOST0       (0x1u <<  7) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_RCFASTLOCK         (0x1u << 13) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_RCFASTLOCKLOST     (0x1u << 14) /**< \brief (SCIF_ISR)  */
#define SCIF_ISR_AE                 (0x1u << 31) /**< \brief (SCIF_ISR)  */
/* -------- SCIF_ICR : (SCIF Offset: 0x010) Interrupt Clear Register -------- */
#define SCIF_ICR_OSC0RDY            (0x1u <<  0) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_DFLL0LOCKC         (0x1u <<  1) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_DFLL0LOCKF         (0x1u <<  2) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_DFLL0RDY           (0x1u <<  3) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_DFLL0RCS           (0x1u <<  4) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_DFLL0OOB           (0x1u <<  5) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_PLLLOCK0           (0x1u <<  6) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_PLLLOCKLOST0       (0x1u <<  7) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_RCFASTLOCK         (0x1u << 13) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_RCFASTLOCKLOST     (0x1u << 14) /**< \brief (SCIF_ICR)  */
#define SCIF_ICR_AE                 (0x1u << 31) /**< \brief (SCIF_ICR)  */
/* -------- SCIF_PCLKSR : (SCIF Offset: 0x014) Power and Clocks Status Register -------- */
#define SCIF_PCLKSR_OSC0RDY         (0x1u <<  0) /**< \brief (SCIF_PCLKSR) OSC0 Ready */
#define SCIF_PCLKSR_DFLL0LOCKC      (0x1u <<  1) /**< \brief (SCIF_PCLKSR) DFLL0 Locked on Coarse Value */
#define SCIF_PCLKSR_DFLL0LOCKF      (0x1u <<  2) /**< \brief (SCIF_PCLKSR) DFLL0 Locked on Fine Value */
#define SCIF_PCLKSR_DFLL0RDY        (0x1u <<  3) /**< \brief (SCIF_PCLKSR) DFLL0 Synchronization Ready */
#define SCIF_PCLKSR_DFLL0RCS        (0x1u <<  4) /**< \brief (SCIF_PCLKSR) DFLL0 Reference Clock Stopped */
#define SCIF_PCLKSR_DFLL0OOB        (0x1u <<  5) /**< \brief (SCIF_PCLKSR) DFLL0 Track Out Of Bounds */
#define SCIF_PCLKSR_PLL0LOCK        (0x1u <<  6) /**< \brief (SCIF_PCLKSR) PLL0 Locked on Accurate value */
#define SCIF_PCLKSR_PLLL0LOCKLOST   (0x1u <<  7) /**< \brief (SCIF_PCLKSR) PLL0 lock lost value */
#define SCIF_PCLKSR_RCFASTLOCK      (0x1u << 13) /**< \brief (SCIF_PCLKSR) RCFAST Locked on Accurate value */
#define SCIF_PCLKSR_RCFASTLOCKLOST  (0x1u << 14) /**< \brief (SCIF_PCLKSR) RCFAST lock lost value */
/* -------- SCIF_UNLOCK : (SCIF Offset: 0x018) Unlock Register -------- */
#define SCIF_UNLOCK_ADDR_Pos        0
#define SCIF_UNLOCK_ADDR_Msk        (0x3FFu << SCIF_UNLOCK_ADDR_Pos) /**< \brief (SCIF_UNLOCK) Unlock Address */
#define SCIF_UNLOCK_ADDR(value)     ((SCIF_UNLOCK_ADDR_Msk & ((value) << SCIF_UNLOCK_ADDR_Pos)))
#define SCIF_UNLOCK_KEY_Pos         24
#define SCIF_UNLOCK_KEY_Msk         (0xFFu << SCIF_UNLOCK_KEY_Pos) /**< \brief (SCIF_UNLOCK) Unlock Key */
#define SCIF_UNLOCK_KEY(value)      ((SCIF_UNLOCK_KEY_Msk & ((value) << SCIF_UNLOCK_KEY_Pos)))
/* -------- SCIF_OSCCTRL0 : (SCIF Offset: 0x020) Oscillator Control Register -------- */
#define SCIF_OSCCTRL0_MODE          (0x1u <<  0) /**< \brief (SCIF_OSCCTRL0) Oscillator Mode */
#define SCIF_OSCCTRL0_GAIN_Pos      1
#define SCIF_OSCCTRL0_GAIN_Msk      (0x3u << SCIF_OSCCTRL0_GAIN_Pos) /**< \brief (SCIF_OSCCTRL0) Gain */
#define SCIF_OSCCTRL0_GAIN(value)   ((SCIF_OSCCTRL0_GAIN_Msk & ((value) << SCIF_OSCCTRL0_GAIN_Pos)))
#define SCIF_OSCCTRL0_AGC           (0x1u <<  3) /**< \brief (SCIF_OSCCTRL0) Automatic Gain Control */
#define SCIF_OSCCTRL0_STARTUP_Pos    8
#define SCIF_OSCCTRL0_STARTUP_Msk    (0xFu << SCIF_OSCCTRL0_STARTUP_Pos) /**< \brief (SCIF_OSCCTRL0) Oscillator Start-up Time */
#define SCIF_OSCCTRL0_STARTUP(value) ((SCIF_OSCCTRL0_STARTUP_Msk & ((value) << SCIF_OSCCTRL0_STARTUP_Pos)))
#define SCIF_OSCCTRL0_OSCEN         (0x1u << 16) /**< \brief (SCIF_OSCCTRL0) Oscillator Enable */
/* -------- SCIF_PLL : (SCIF Offset: 0x024) Pll PLL0 Control Register -------- */
#define SCIF_PLL_PLLEN              (0x1u <<  0) /**< \brief (SCIF_PLL) PLL Enable */
#define SCIF_PLL_PLLOSC_Pos         1
#define SCIF_PLL_PLLOSC_Msk         (0x3u << SCIF_PLL_PLLOSC_Pos) /**< \brief (SCIF_PLL) PLL Oscillator Select */
#define SCIF_PLL_PLLOSC(value)      ((SCIF_PLL_PLLOSC_Msk & ((value) << SCIF_PLL_PLLOSC_Pos)))
#define SCIF_PLL_PLLOPT_Pos         3
#define SCIF_PLL_PLLOPT_Msk         (0x7u << SCIF_PLL_PLLOPT_Pos) /**< \brief (SCIF_PLL) PLL Option */
#define SCIF_PLL_PLLOPT(value)      ((SCIF_PLL_PLLOPT_Msk & ((value) << SCIF_PLL_PLLOPT_Pos)))
#define SCIF_PLL_PLLDIV_Pos         8
#define SCIF_PLL_PLLDIV_Msk         (0xFu << SCIF_PLL_PLLDIV_Pos) /**< \brief (SCIF_PLL) PLL Division Factor */
#define SCIF_PLL_PLLDIV(value)      ((SCIF_PLL_PLLDIV_Msk & ((value) << SCIF_PLL_PLLDIV_Pos)))
#define SCIF_PLL_PLLMUL_Pos         16
#define SCIF_PLL_PLLMUL_Msk         (0xFu << SCIF_PLL_PLLMUL_Pos) /**< \brief (SCIF_PLL) PLL Multiply Factor */
#define SCIF_PLL_PLLMUL(value)      ((SCIF_PLL_PLLMUL_Msk & ((value) << SCIF_PLL_PLLMUL_Pos)))
#define SCIF_PLL_PLLCOUNT_Pos       24
#define SCIF_PLL_PLLCOUNT_Msk       (0x3Fu << SCIF_PLL_PLLCOUNT_Pos) /**< \brief (SCIF_PLL) PLL Count */
#define SCIF_PLL_PLLCOUNT(value)    ((SCIF_PLL_PLLCOUNT_Msk & ((value) << SCIF_PLL_PLLCOUNT_Pos)))
/* -------- SCIF_DFLL0CONF : (SCIF Offset: 0x028) DFLL0 Config Register -------- */
#define SCIF_DFLL0CONF_EN           (0x1u <<  0) /**< \brief (SCIF_DFLL0CONF) Enable */
#define SCIF_DFLL0CONF_MODE         (0x1u <<  1) /**< \brief (SCIF_DFLL0CONF) Mode Selection */
#define SCIF_DFLL0CONF_STABLE       (0x1u <<  2) /**< \brief (SCIF_DFLL0CONF) Stable DFLL Frequency */
#define SCIF_DFLL0CONF_LLAW         (0x1u <<  3) /**< \brief (SCIF_DFLL0CONF) Lose Lock After Wake */
#define SCIF_DFLL0CONF_CCDIS        (0x1u <<  5) /**< \brief (SCIF_DFLL0CONF) Chill Cycle Disable */
#define SCIF_DFLL0CONF_QLDIS        (0x1u <<  6) /**< \brief (SCIF_DFLL0CONF) Quick Lock Disable */
#define SCIF_DFLL0CONF_RANGE_Pos    16
#define SCIF_DFLL0CONF_RANGE_Msk    (0x3u << SCIF_DFLL0CONF_RANGE_Pos) /**< \brief (SCIF_DFLL0CONF) Range Value */
#define SCIF_DFLL0CONF_RANGE(value) ((SCIF_DFLL0CONF_RANGE_Msk & ((value) << SCIF_DFLL0CONF_RANGE_Pos)))
#define SCIF_DFLL0CONF_FCD          (0x1u << 23) /**< \brief (SCIF_DFLL0CONF) Fuse Calibration Done */
#define SCIF_DFLL0CONF_CALIB_Pos    24
#define SCIF_DFLL0CONF_CALIB_Msk    (0xFu << SCIF_DFLL0CONF_CALIB_Pos) /**< \brief (SCIF_DFLL0CONF) Calibration Value */
#define SCIF_DFLL0CONF_CALIB(value) ((SCIF_DFLL0CONF_CALIB_Msk & ((value) << SCIF_DFLL0CONF_CALIB_Pos)))
/* -------- SCIF_DFLL0VAL : (SCIF Offset: 0x02C) DFLL Value Register -------- */
#define SCIF_DFLL0VAL_FINE_Pos      0
#define SCIF_DFLL0VAL_FINE_Msk      (0xFFu << SCIF_DFLL0VAL_FINE_Pos) /**< \brief (SCIF_DFLL0VAL) Fine Value */
#define SCIF_DFLL0VAL_FINE(value)   ((SCIF_DFLL0VAL_FINE_Msk & ((value) << SCIF_DFLL0VAL_FINE_Pos)))
#define SCIF_DFLL0VAL_COARSE_Pos    16
#define SCIF_DFLL0VAL_COARSE_Msk    (0x1Fu << SCIF_DFLL0VAL_COARSE_Pos) /**< \brief (SCIF_DFLL0VAL) Coarse Value */
#define SCIF_DFLL0VAL_COARSE(value) ((SCIF_DFLL0VAL_COARSE_Msk & ((value) << SCIF_DFLL0VAL_COARSE_Pos)))
/* -------- SCIF_DFLL0MUL : (SCIF Offset: 0x030) DFLL0 Multiplier Register -------- */
#define SCIF_DFLL0MUL_MUL_Pos       0
#define SCIF_DFLL0MUL_MUL_Msk       (0xFFFFu << SCIF_DFLL0MUL_MUL_Pos) /**< \brief (SCIF_DFLL0MUL) DFLL Multiply Factor */
#define SCIF_DFLL0MUL_MUL(value)    ((SCIF_DFLL0MUL_MUL_Msk & ((value) << SCIF_DFLL0MUL_MUL_Pos)))
/* -------- SCIF_DFLL0STEP : (SCIF Offset: 0x034) DFLL0 Step Register -------- */
#define SCIF_DFLL0STEP_FSTEP_Pos    0
#define SCIF_DFLL0STEP_FSTEP_Msk    (0xFFu << SCIF_DFLL0STEP_FSTEP_Pos) /**< \brief (SCIF_DFLL0STEP) Fine Maximum Step */
#define SCIF_DFLL0STEP_FSTEP(value) ((SCIF_DFLL0STEP_FSTEP_Msk & ((value) << SCIF_DFLL0STEP_FSTEP_Pos)))
#define SCIF_DFLL0STEP_CSTEP_Pos    16
#define SCIF_DFLL0STEP_CSTEP_Msk    (0x1Fu << SCIF_DFLL0STEP_CSTEP_Pos) /**< \brief (SCIF_DFLL0STEP) Coarse Maximum Step */
#define SCIF_DFLL0STEP_CSTEP(value) ((SCIF_DFLL0STEP_CSTEP_Msk & ((value) << SCIF_DFLL0STEP_CSTEP_Pos)))
/* -------- SCIF_DFLL0SSG : (SCIF Offset: 0x038) DFLL0 Spread Spectrum Generator Control Register -------- */
#define SCIF_DFLL0SSG_EN            (0x1u <<  0) /**< \brief (SCIF_DFLL0SSG) Enable */
#define SCIF_DFLL0SSG_PRBS          (0x1u <<  1) /**< \brief (SCIF_DFLL0SSG) Pseudo Random Bit Sequence */
#define SCIF_DFLL0SSG_AMPLITUDE_Pos    8
#define SCIF_DFLL0SSG_AMPLITUDE_Msk    (0x1Fu << SCIF_DFLL0SSG_AMPLITUDE_Pos) /**< \brief (SCIF_DFLL0SSG) SSG Amplitude */
#define SCIF_DFLL0SSG_AMPLITUDE(value) ((SCIF_DFLL0SSG_AMPLITUDE_Msk & ((value) << SCIF_DFLL0SSG_AMPLITUDE_Pos)))
#define SCIF_DFLL0SSG_STEPSIZE_Pos    16
#define SCIF_DFLL0SSG_STEPSIZE_Msk    (0x1Fu << SCIF_DFLL0SSG_STEPSIZE_Pos) /**< \brief (SCIF_DFLL0SSG) SSG Step Size */
#define SCIF_DFLL0SSG_STEPSIZE(value) ((SCIF_DFLL0SSG_STEPSIZE_Msk & ((value) << SCIF_DFLL0SSG_STEPSIZE_Pos)))
/* -------- SCIF_DFLL0RATIO : (SCIF Offset: 0x03C) DFLL0 Ratio Registe -------- */
#define SCIF_DFLL0RATIO_RATIODIFF_Pos    0
#define SCIF_DFLL0RATIO_RATIODIFF_Msk    (0xFFFFu << SCIF_DFLL0RATIO_RATIODIFF_Pos) /**< \brief (SCIF_DFLL0RATIO) Multiplication Ratio Difference */
#define SCIF_DFLL0RATIO_RATIODIFF(value) ((SCIF_DFLL0RATIO_RATIODIFF_Msk & ((value) << SCIF_DFLL0RATIO_RATIODIFF_Pos)))
/* -------- SCIF_DFLL0SYNC : (SCIF Offset: 0x040) DFLL0 Synchronization Register -------- */
#define SCIF_DFLL0SYNC_SYNC         (0x1u <<  0) /**< \brief (SCIF_DFLL0SYNC) Synchronization */
/* -------- SCIF_RCCR : (SCIF Offset: 0x044) System RC Oscillator Calibration Register -------- */
#define SCIF_RCCR_CALIB_Pos         0
#define SCIF_RCCR_CALIB_Msk         (0x3FFu << SCIF_RCCR_CALIB_Pos) /**< \brief (SCIF_RCCR) Calibration Value */
#define SCIF_RCCR_CALIB(value)      ((SCIF_RCCR_CALIB_Msk & ((value) << SCIF_RCCR_CALIB_Pos)))
#define SCIF_RCCR_FCD               (0x1u << 16) /**< \brief (SCIF_RCCR) Flash Calibration Done */
/* -------- SCIF_RCFASTCFG : (SCIF Offset: 0x048) 4/8/12 MHz RC Oscillator Configuration
Register -------- */
#define SCIF_RCFASTCFG_EN           (0x1u <<  0) /**< \brief (SCIF_RCFASTCFG) Oscillator Enable */
#define SCIF_RCFASTCFG_TUNEEN       (0x1u <<  1) /**< \brief (SCIF_RCFASTCFG) Tuner Enable */
#define SCIF_RCFASTCFG_JITMODE      (0x1u <<  2) /**< \brief (SCIF_RCFASTCFG) Jitter Mode */
#define SCIF_RCFASTCFG_NBPERIODS_Pos    4
#define SCIF_RCFASTCFG_NBPERIODS_Msk    (0x7u << SCIF_RCFASTCFG_NBPERIODS_Pos) /**< \brief (SCIF_RCFASTCFG) Number of 32kHz Periods */
#define SCIF_RCFASTCFG_NBPERIODS(value) ((SCIF_RCFASTCFG_NBPERIODS_Msk & ((value) << SCIF_RCFASTCFG_NBPERIODS_Pos)))
#define SCIF_RCFASTCFG_FCD          (0x1u <<  7) /**< \brief (SCIF_RCFASTCFG) RCFAST Fuse Calibration Done */
#define SCIF_RCFASTCFG_FRANGE_Pos    8
#define SCIF_RCFASTCFG_FRANGE_Msk    (0x3u << SCIF_RCFASTCFG_FRANGE_Pos) /**< \brief (SCIF_RCFASTCFG) Frequency Range */
#define SCIF_RCFASTCFG_FRANGE(value) ((SCIF_RCFASTCFG_FRANGE_Msk & ((value) << SCIF_RCFASTCFG_FRANGE_Pos)))
#define SCIF_RCFASTCFG_LOCKMARGIN_Pos    12
#define SCIF_RCFASTCFG_LOCKMARGIN_Msk    (0xFu << SCIF_RCFASTCFG_LOCKMARGIN_Pos) /**< \brief (SCIF_RCFASTCFG) Accepted Count Error for Lock */
#define SCIF_RCFASTCFG_LOCKMARGIN(value) ((SCIF_RCFASTCFG_LOCKMARGIN_Msk & ((value) << SCIF_RCFASTCFG_LOCKMARGIN_Pos)))
#define SCIF_RCFASTCFG_CALIB_Pos    16
#define SCIF_RCFASTCFG_CALIB_Msk    (0x7Fu << SCIF_RCFASTCFG_CALIB_Pos) /**< \brief (SCIF_RCFASTCFG) Oscillator Calibration Value */
#define SCIF_RCFASTCFG_CALIB(value) ((SCIF_RCFASTCFG_CALIB_Msk & ((value) << SCIF_RCFASTCFG_CALIB_Pos)))
/* -------- SCIF_RCFASTSR : (SCIF Offset: 0x04C) 4/8/12 MHz RC Oscillator Status Register -------- */
#define SCIF_RCFASTSR_CURTRIM_Pos    0
#define SCIF_RCFASTSR_CURTRIM_Msk    (0x7Fu << SCIF_RCFASTSR_CURTRIM_Pos) /**< \brief (SCIF_RCFASTSR) Current Trim Value */
#define SCIF_RCFASTSR_CURTRIM(value) ((SCIF_RCFASTSR_CURTRIM_Msk & ((value) << SCIF_RCFASTSR_CURTRIM_Pos)))
#define SCIF_RCFASTSR_CNTERR_Pos    16
#define SCIF_RCFASTSR_CNTERR_Msk    (0x1Fu << SCIF_RCFASTSR_CNTERR_Pos) /**< \brief (SCIF_RCFASTSR) Current Count Error */
#define SCIF_RCFASTSR_CNTERR(value) ((SCIF_RCFASTSR_CNTERR_Msk & ((value) << SCIF_RCFASTSR_CNTERR_Pos)))
#define SCIF_RCFASTSR_SIGN          (0x1u << 21) /**< \brief (SCIF_RCFASTSR) Sign of Current Count Error */
#define SCIF_RCFASTSR_LOCK          (0x1u << 24) /**< \brief (SCIF_RCFASTSR) Lock */
#define SCIF_RCFASTSR_LOCKLOST      (0x1u << 25) /**< \brief (SCIF_RCFASTSR) Lock Lost */
#define SCIF_RCFASTSR_UPDATED       (0x1u << 31) /**< \brief (SCIF_RCFASTSR) Current Trim Value Updated */
/* -------- SCIF_RC80MCR : (SCIF Offset: 0x050) 80 MHz RC Oscillator Register -------- */
#define SCIF_RC80MCR_EN             (0x1u <<  0) /**< \brief (SCIF_RC80MCR) Enable */
#define SCIF_RC80MCR_FCD            (0x1u <<  7) /**< \brief (SCIF_RC80MCR) Flash Calibration Done */
#define SCIF_RC80MCR_CALIB_Pos      16
#define SCIF_RC80MCR_CALIB_Msk      (0x3u << SCIF_RC80MCR_CALIB_Pos) /**< \brief (SCIF_RC80MCR) Calibration Value */
#define SCIF_RC80MCR_CALIB(value)   ((SCIF_RC80MCR_CALIB_Msk & ((value) << SCIF_RC80MCR_CALIB_Pos)))
/* -------- SCIF_HRPCR : (SCIF Offset: 0x064) High Resolution Prescaler Control Register -------- */
#define SCIF_HRPCR_HRPEN            (0x1u <<  0) /**< \brief (SCIF_HRPCR) High Resolution Prescaler Enable */
#define SCIF_HRPCR_CKSEL_Pos        1
#define SCIF_HRPCR_CKSEL_Msk        (0x7u << SCIF_HRPCR_CKSEL_Pos) /**< \brief (SCIF_HRPCR) Clock Input Selection */
#define SCIF_HRPCR_CKSEL(value)     ((SCIF_HRPCR_CKSEL_Msk & ((value) << SCIF_HRPCR_CKSEL_Pos)))
#define SCIF_HRPCR_HRCOUNT_Pos      8
#define SCIF_HRPCR_HRCOUNT_Msk      (0xFFFFFFu << SCIF_HRPCR_HRCOUNT_Pos) /**< \brief (SCIF_HRPCR) High Resolution Counter */
#define SCIF_HRPCR_HRCOUNT(value)   ((SCIF_HRPCR_HRCOUNT_Msk & ((value) << SCIF_HRPCR_HRCOUNT_Pos)))
/* -------- SCIF_FPCR : (SCIF Offset: 0x068) Fractional Prescaler Control Register -------- */
#define SCIF_FPCR_FPEN              (0x1u <<  0) /**< \brief (SCIF_FPCR) High Resolution Prescaler Enable */
#define SCIF_FPCR_CKSEL_Pos         1
#define SCIF_FPCR_CKSEL_Msk         (0x7u << SCIF_FPCR_CKSEL_Pos) /**< \brief (SCIF_FPCR) Clock Input Selection */
#define SCIF_FPCR_CKSEL(value)      ((SCIF_FPCR_CKSEL_Msk & ((value) << SCIF_FPCR_CKSEL_Pos)))
/* -------- SCIF_FPMUL : (SCIF Offset: 0x06C) Fractional Prescaler Multiplier Register -------- */
#define SCIF_FPMUL_FPMUL_Pos        0
#define SCIF_FPMUL_FPMUL_Msk        (0xFFFFu << SCIF_FPMUL_FPMUL_Pos) /**< \brief (SCIF_FPMUL) Fractional Prescaler Multiplication Factor */
#define SCIF_FPMUL_FPMUL(value)     ((SCIF_FPMUL_FPMUL_Msk & ((value) << SCIF_FPMUL_FPMUL_Pos)))
/* -------- SCIF_FPDIV : (SCIF Offset: 0x070) Fractional Prescaler DIVIDER Register -------- */
#define SCIF_FPDIV_FPDIV_Pos        0
#define SCIF_FPDIV_FPDIV_Msk        (0xFFFFu << SCIF_FPDIV_FPDIV_Pos) /**< \brief (SCIF_FPDIV) Fractional Prescaler Division Factor */
#define SCIF_FPDIV_FPDIV(value)     ((SCIF_FPDIV_FPDIV_Msk & ((value) << SCIF_FPDIV_FPDIV_Pos)))
/* -------- SCIF_GCCTRL : (SCIF Offset: 0x074) Gcctrl Generic Clock Control -------- */
#define SCIF_GCCTRL_CEN             (0x1u <<  0) /**< \brief (SCIF_GCCTRL) Clock Enable */
#define SCIF_GCCTRL_DIVEN           (0x1u <<  1) /**< \brief (SCIF_GCCTRL) Divide Enable */
#define SCIF_GCCTRL_OSCSEL_Pos      8
#define SCIF_GCCTRL_OSCSEL_Msk      (0x1Fu << SCIF_GCCTRL_OSCSEL_Pos) /**< \brief (SCIF_GCCTRL) Clock Select */
#define SCIF_GCCTRL_OSCSEL(value)   ((SCIF_GCCTRL_OSCSEL_Msk & ((value) << SCIF_GCCTRL_OSCSEL_Pos)))
#define SCIF_GCCTRL_DIV_Pos         16
#define SCIF_GCCTRL_DIV_Msk         (0xFFFFu << SCIF_GCCTRL_DIV_Pos) /**< \brief (SCIF_GCCTRL) Division Factor */
#define SCIF_GCCTRL_DIV(value)      ((SCIF_GCCTRL_DIV_Msk & ((value) << SCIF_GCCTRL_DIV_Pos)))
/* -------- SCIF_RCFASTVERSION : (SCIF Offset: 0x3D8) 4/8/12 MHz RC Oscillator Version Register -------- */
#define SCIF_RCFASTVERSION_VERSION_Pos    0
#define SCIF_RCFASTVERSION_VERSION_Msk    (0xFFFu << SCIF_RCFASTVERSION_VERSION_Pos) /**< \brief (SCIF_RCFASTVERSION) Version number */
#define SCIF_RCFASTVERSION_VERSION(value) ((SCIF_RCFASTVERSION_VERSION_Msk & ((value) << SCIF_RCFASTVERSION_VERSION_Pos)))
#define SCIF_RCFASTVERSION_VARIANT_Pos    16
#define SCIF_RCFASTVERSION_VARIANT_Msk    (0xFu << SCIF_RCFASTVERSION_VARIANT_Pos) /**< \brief (SCIF_RCFASTVERSION) Variant number */
#define SCIF_RCFASTVERSION_VARIANT(value) ((SCIF_RCFASTVERSION_VARIANT_Msk & ((value) << SCIF_RCFASTVERSION_VARIANT_Pos)))
/* -------- SCIF_GCLKPRESCVERSION : (SCIF Offset: 0x3DC) Generic Clock Prescaler Version Register -------- */
#define SCIF_GCLKPRESCVERSION_VERSION_Pos    0
#define SCIF_GCLKPRESCVERSION_VERSION_Msk    (0xFFFu << SCIF_GCLKPRESCVERSION_VERSION_Pos) /**< \brief (SCIF_GCLKPRESCVERSION) Version number */
#define SCIF_GCLKPRESCVERSION_VERSION(value) ((SCIF_GCLKPRESCVERSION_VERSION_Msk & ((value) << SCIF_GCLKPRESCVERSION_VERSION_Pos)))
#define SCIF_GCLKPRESCVERSION_VARIANT_Pos    16
#define SCIF_GCLKPRESCVERSION_VARIANT_Msk    (0xFu << SCIF_GCLKPRESCVERSION_VARIANT_Pos) /**< \brief (SCIF_GCLKPRESCVERSION) Variant number */
#define SCIF_GCLKPRESCVERSION_VARIANT(value) ((SCIF_GCLKPRESCVERSION_VARIANT_Msk & ((value) << SCIF_GCLKPRESCVERSION_VARIANT_Pos)))
/* -------- SCIF_PLLIFAVERSION : (SCIF Offset: 0x3E0) PLL Version Register -------- */
#define SCIF_PLLIFAVERSION_VERSION_Pos    0
#define SCIF_PLLIFAVERSION_VERSION_Msk    (0xFFFu << SCIF_PLLIFAVERSION_VERSION_Pos) /**< \brief (SCIF_PLLIFAVERSION) Version number */
#define SCIF_PLLIFAVERSION_VERSION(value) ((SCIF_PLLIFAVERSION_VERSION_Msk & ((value) << SCIF_PLLIFAVERSION_VERSION_Pos)))
#define SCIF_PLLIFAVERSION_VARIANT_Pos    16
#define SCIF_PLLIFAVERSION_VARIANT_Msk    (0xFu << SCIF_PLLIFAVERSION_VARIANT_Pos) /**< \brief (SCIF_PLLIFAVERSION) Variant nubmer */
#define SCIF_PLLIFAVERSION_VARIANT(value) ((SCIF_PLLIFAVERSION_VARIANT_Msk & ((value) << SCIF_PLLIFAVERSION_VARIANT_Pos)))
/* -------- SCIF_OSCIFAVERSION : (SCIF Offset: 0x3E4) Oscillator 0 Version Register -------- */
#define SCIF_OSCIFAVERSION_VERSION_Pos    0
#define SCIF_OSCIFAVERSION_VERSION_Msk    (0xFFFu << SCIF_OSCIFAVERSION_VERSION_Pos) /**< \brief (SCIF_OSCIFAVERSION) Version number */
#define SCIF_OSCIFAVERSION_VERSION(value) ((SCIF_OSCIFAVERSION_VERSION_Msk & ((value) << SCIF_OSCIFAVERSION_VERSION_Pos)))
#define SCIF_OSCIFAVERSION_VARIANT_Pos    16
#define SCIF_OSCIFAVERSION_VARIANT_Msk    (0xFu << SCIF_OSCIFAVERSION_VARIANT_Pos) /**< \brief (SCIF_OSCIFAVERSION) Variant nubmer */
#define SCIF_OSCIFAVERSION_VARIANT(value) ((SCIF_OSCIFAVERSION_VARIANT_Msk & ((value) << SCIF_OSCIFAVERSION_VARIANT_Pos)))
/* -------- SCIF_DFLLIFBVERSION : (SCIF Offset: 0x3E8) DFLL Version Register -------- */
#define SCIF_DFLLIFBVERSION_VERSION_Pos    0
#define SCIF_DFLLIFBVERSION_VERSION_Msk    (0xFFFu << SCIF_DFLLIFBVERSION_VERSION_Pos) /**< \brief (SCIF_DFLLIFBVERSION) Version number */
#define SCIF_DFLLIFBVERSION_VERSION(value) ((SCIF_DFLLIFBVERSION_VERSION_Msk & ((value) << SCIF_DFLLIFBVERSION_VERSION_Pos)))
#define SCIF_DFLLIFBVERSION_VARIANT_Pos    16
#define SCIF_DFLLIFBVERSION_VARIANT_Msk    (0xFu << SCIF_DFLLIFBVERSION_VARIANT_Pos) /**< \brief (SCIF_DFLLIFBVERSION) Variant number */
#define SCIF_DFLLIFBVERSION_VARIANT(value) ((SCIF_DFLLIFBVERSION_VARIANT_Msk & ((value) << SCIF_DFLLIFBVERSION_VARIANT_Pos)))
/* -------- SCIF_RCOSCIFAVERSION : (SCIF Offset: 0x3EC) System RC Oscillator Version Register -------- */
#define SCIF_RCOSCIFAVERSION_VERSION_Pos    0
#define SCIF_RCOSCIFAVERSION_VERSION_Msk    (0xFFFu << SCIF_RCOSCIFAVERSION_VERSION_Pos) /**< \brief (SCIF_RCOSCIFAVERSION) Version number */
#define SCIF_RCOSCIFAVERSION_VERSION(value) ((SCIF_RCOSCIFAVERSION_VERSION_Msk & ((value) << SCIF_RCOSCIFAVERSION_VERSION_Pos)))
#define SCIF_RCOSCIFAVERSION_VARIANT_Pos    16
#define SCIF_RCOSCIFAVERSION_VARIANT_Msk    (0xFu << SCIF_RCOSCIFAVERSION_VARIANT_Pos) /**< \brief (SCIF_RCOSCIFAVERSION) Variant number */
#define SCIF_RCOSCIFAVERSION_VARIANT(value) ((SCIF_RCOSCIFAVERSION_VARIANT_Msk & ((value) << SCIF_RCOSCIFAVERSION_VARIANT_Pos)))
/* -------- SCIF_FLOVERSION : (SCIF Offset: 0x3F0) Frequency Locked Oscillator Version Register -------- */
#define SCIF_FLOVERSION_VERSION_Pos    0
#define SCIF_FLOVERSION_VERSION_Msk    (0xFFFu << SCIF_FLOVERSION_VERSION_Pos) /**< \brief (SCIF_FLOVERSION) Version number */
#define SCIF_FLOVERSION_VERSION(value) ((SCIF_FLOVERSION_VERSION_Msk & ((value) << SCIF_FLOVERSION_VERSION_Pos)))
#define SCIF_FLOVERSION_VARIANT_Pos    16
#define SCIF_FLOVERSION_VARIANT_Msk    (0xFu << SCIF_FLOVERSION_VARIANT_Pos) /**< \brief (SCIF_FLOVERSION) Variant number */
#define SCIF_FLOVERSION_VARIANT(value) ((SCIF_FLOVERSION_VARIANT_Msk & ((value) << SCIF_FLOVERSION_VARIANT_Pos)))
/* -------- SCIF_RC80MVERSION : (SCIF Offset: 0x3F4) 80MHz RC Oscillator Version Register -------- */
#define SCIF_RC80MVERSION_VERSION_Pos    0
#define SCIF_RC80MVERSION_VERSION_Msk    (0xFFFu << SCIF_RC80MVERSION_VERSION_Pos) /**< \brief (SCIF_RC80MVERSION) Version number */
#define SCIF_RC80MVERSION_VERSION(value) ((SCIF_RC80MVERSION_VERSION_Msk & ((value) << SCIF_RC80MVERSION_VERSION_Pos)))
#define SCIF_RC80MVERSION_VARIANT_Pos    16
#define SCIF_RC80MVERSION_VARIANT_Msk    (0xFu << SCIF_RC80MVERSION_VARIANT_Pos) /**< \brief (SCIF_RC80MVERSION) Variant number */
#define SCIF_RC80MVERSION_VARIANT(value) ((SCIF_RC80MVERSION_VARIANT_Msk & ((value) << SCIF_RC80MVERSION_VARIANT_Pos)))
/* -------- SCIF_GCLKIFVERSION : (SCIF Offset: 0x3F8) Generic Clock Version Register -------- */
#define SCIF_GCLKIFVERSION_VERSION_Pos    0
#define SCIF_GCLKIFVERSION_VERSION_Msk    (0xFFFu << SCIF_GCLKIFVERSION_VERSION_Pos) /**< \brief (SCIF_GCLKIFVERSION) Version number */
#define SCIF_GCLKIFVERSION_VERSION(value) ((SCIF_GCLKIFVERSION_VERSION_Msk & ((value) << SCIF_GCLKIFVERSION_VERSION_Pos)))
#define SCIF_GCLKIFVERSION_VARIANT_Pos    16
#define SCIF_GCLKIFVERSION_VARIANT_Msk    (0xFu << SCIF_GCLKIFVERSION_VARIANT_Pos) /**< \brief (SCIF_GCLKIFVERSION) Variant number */
#define SCIF_GCLKIFVERSION_VARIANT(value) ((SCIF_GCLKIFVERSION_VARIANT_Msk & ((value) << SCIF_GCLKIFVERSION_VARIANT_Pos)))
/* -------- SCIF_VERSION : (SCIF Offset: 0x3FC) SCIF Version Register -------- */
#define SCIF_VERSION_VERSION_Pos    0
#define SCIF_VERSION_VERSION_Msk    (0xFFFu << SCIF_VERSION_VERSION_Pos) /**< \brief (SCIF_VERSION) Version number */
#define SCIF_VERSION_VERSION(value) ((SCIF_VERSION_VERSION_Msk & ((value) << SCIF_VERSION_VERSION_Pos)))
#define SCIF_VERSION_VARIANT_Pos    16
#define SCIF_VERSION_VARIANT_Msk    (0xFu << SCIF_VERSION_VARIANT_Pos) /**< \brief (SCIF_VERSION) Variant number */
#define SCIF_VERSION_VARIANT(value) ((SCIF_VERSION_VARIANT_Msk & ((value) << SCIF_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR SMAP */
/* ============================================================================= */
/** \addtogroup SAM4L4_SMAP System Manager Access Port */
/*@{*/

#define REV_SMAP       0x100

#ifndef __ASSEMBLY__
/** \brief SMAP hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (SMAP Offset: 0x00) Control Register */
  RoReg   SR;          /**< \brief (SMAP Offset: 0x04) Status Register */
  WoReg   SCR;         /**< \brief (SMAP Offset: 0x08) Status Clear Register */
  RwReg   ADDR;        /**< \brief (SMAP Offset: 0x0C) Address Register */
  RwReg   LENGTH;      /**< \brief (SMAP Offset: 0x10) Length Register */
  RwReg   DATA;        /**< \brief (SMAP Offset: 0x14) Data Register */
  RoReg   Reserved1[4];
  RoReg   VERSION;     /**< \brief (SMAP Offset: 0x28) VERSION register */
  RoReg   Reserved2[49];
  RoReg   CIDR;        /**< \brief (SMAP Offset: 0xF0) Chip ID Register */
  RoReg   EXID;        /**< \brief (SMAP Offset: 0xF4) Chip ID Extension Register */
  RoReg   Reserved3[1];
  RoReg   IDR;         /**< \brief (SMAP Offset: 0xFC) AP Identification register */
} Smap;
#endif /* __ASSEMBLY__ */
/* -------- SMAP_CR : (SMAP Offset: 0x00) Control Register -------- */
#define SMAP_CR_EN                  (0x1u <<  0) /**< \brief (SMAP_CR) Enable */
#define SMAP_CR_DIS                 (0x1u <<  1) /**< \brief (SMAP_CR) Disable */
#define SMAP_CR_CRC                 (0x1u <<  2) /**< \brief (SMAP_CR) User Page Read */
#define SMAP_CR_FSPR                (0x1u <<  3) /**< \brief (SMAP_CR) Flash Supplementary Page Read */
#define SMAP_CR_CE                  (0x1u <<  4) /**< \brief (SMAP_CR) Chip Erase */
/* -------- SMAP_SR : (SMAP Offset: 0x04) Status Register -------- */
#define SMAP_SR_DONE                (0x1u <<  0) /**< \brief (SMAP_SR) Operation done */
#define SMAP_SR_HCR                 (0x1u <<  1) /**< \brief (SMAP_SR) Hold Core reset */
#define SMAP_SR_BERR                (0x1u <<  2) /**< \brief (SMAP_SR) Bus error */
#define SMAP_SR_FAIL                (0x1u <<  3) /**< \brief (SMAP_SR) Failure */
#define SMAP_SR_LCK                 (0x1u <<  4) /**< \brief (SMAP_SR) Lock */
#define SMAP_SR_EN                  (0x1u <<  8) /**< \brief (SMAP_SR) Enabled */
#define SMAP_SR_PROT                (0x1u <<  9) /**< \brief (SMAP_SR) Protected */
#define SMAP_SR_DBGP                (0x1u << 10) /**< \brief (SMAP_SR) Debugger Present */
#define SMAP_SR_STATE_Pos           24
#define SMAP_SR_STATE_Msk           (0x7u << SMAP_SR_STATE_Pos) /**< \brief (SMAP_SR) State */
#define SMAP_SR_STATE(value)        ((SMAP_SR_STATE_Msk & ((value) << SMAP_SR_STATE_Pos)))
/* -------- SMAP_SCR : (SMAP Offset: 0x08) Status Clear Register -------- */
#define SMAP_SCR_DONE               (0x1u <<  0) /**< \brief (SMAP_SCR) Done */
#define SMAP_SCR_HCR                (0x1u <<  1) /**< \brief (SMAP_SCR) Hold Core Register */
#define SMAP_SCR_BERR               (0x1u <<  2) /**< \brief (SMAP_SCR) Bus error */
#define SMAP_SCR_FAIL               (0x1u <<  3) /**< \brief (SMAP_SCR) Failure */
#define SMAP_SCR_LCK                (0x1u <<  4) /**< \brief (SMAP_SCR) Lock error */
/* -------- SMAP_ADDR : (SMAP Offset: 0x0C) Address Register -------- */
#define SMAP_ADDR_ADDR_Pos          2
#define SMAP_ADDR_ADDR_Msk          (0x3FFFFFFFu << SMAP_ADDR_ADDR_Pos) /**< \brief (SMAP_ADDR) Address Value */
#define SMAP_ADDR_ADDR(value)       ((SMAP_ADDR_ADDR_Msk & ((value) << SMAP_ADDR_ADDR_Pos)))
/* -------- SMAP_LENGTH : (SMAP Offset: 0x10) Length Register -------- */
#define SMAP_LENGTH_LENGTH_Pos      2
#define SMAP_LENGTH_LENGTH_Msk      (0x3FFFFFFFu << SMAP_LENGTH_LENGTH_Pos) /**< \brief (SMAP_LENGTH) Length Register */
#define SMAP_LENGTH_LENGTH(value)   ((SMAP_LENGTH_LENGTH_Msk & ((value) << SMAP_LENGTH_LENGTH_Pos)))
/* -------- SMAP_DATA : (SMAP Offset: 0x14) Data Register -------- */
#define SMAP_DATA_DATA_Pos          0
#define SMAP_DATA_DATA_Msk          (0xFFFFFFFFu << SMAP_DATA_DATA_Pos) /**< \brief (SMAP_DATA) Generic data register */
#define SMAP_DATA_DATA(value)       ((SMAP_DATA_DATA_Msk & ((value) << SMAP_DATA_DATA_Pos)))
/* -------- SMAP_VERSION : (SMAP Offset: 0x28) VERSION register -------- */
#define SMAP_VERSION_VERSION_Pos    0
#define SMAP_VERSION_VERSION_Msk    (0xFFFu << SMAP_VERSION_VERSION_Pos) /**< \brief (SMAP_VERSION) Version number */
#define SMAP_VERSION_VERSION(value) ((SMAP_VERSION_VERSION_Msk & ((value) << SMAP_VERSION_VERSION_Pos)))
#define SMAP_VERSION_VARIANT_Pos    16
#define SMAP_VERSION_VARIANT_Msk    (0xFu << SMAP_VERSION_VARIANT_Pos) /**< \brief (SMAP_VERSION) Variant number */
#define SMAP_VERSION_VARIANT(value) ((SMAP_VERSION_VARIANT_Msk & ((value) << SMAP_VERSION_VARIANT_Pos)))
/* -------- SMAP_CIDR : (SMAP Offset: 0xF0) Chip ID Register -------- */
#define SMAP_CIDR_VERSION_Pos       0
#define SMAP_CIDR_VERSION_Msk       (0x1Fu << SMAP_CIDR_VERSION_Pos) /**< \brief (SMAP_CIDR) Version of the Device */
#define SMAP_CIDR_VERSION(value)    ((SMAP_CIDR_VERSION_Msk & ((value) << SMAP_CIDR_VERSION_Pos)))
#define SMAP_CIDR_EPROC_Pos         5
#define SMAP_CIDR_EPROC_Msk         (0x7u << SMAP_CIDR_EPROC_Pos) /**< \brief (SMAP_CIDR) Embedded Processor */
#define SMAP_CIDR_EPROC(value)      ((SMAP_CIDR_EPROC_Msk & ((value) << SMAP_CIDR_EPROC_Pos)))
#define SMAP_CIDR_NVPSIZ_Pos        8
#define SMAP_CIDR_NVPSIZ_Msk        (0xFu << SMAP_CIDR_NVPSIZ_Pos) /**< \brief (SMAP_CIDR) Nonvolatile Program Memory Size */
#define SMAP_CIDR_NVPSIZ(value)     ((SMAP_CIDR_NVPSIZ_Msk & ((value) << SMAP_CIDR_NVPSIZ_Pos)))
#define SMAP_CIDR_NVPSIZ2_Pos       12
#define SMAP_CIDR_NVPSIZ2_Msk       (0xFu << SMAP_CIDR_NVPSIZ2_Pos) /**< \brief (SMAP_CIDR) Second Nonvolatile Program Memory Size */
#define SMAP_CIDR_NVPSIZ2(value)    ((SMAP_CIDR_NVPSIZ2_Msk & ((value) << SMAP_CIDR_NVPSIZ2_Pos)))
#define SMAP_CIDR_SRAMSIZ_Pos       16
#define SMAP_CIDR_SRAMSIZ_Msk       (0x1Fu << SMAP_CIDR_SRAMSIZ_Pos) /**< \brief (SMAP_CIDR) Internal SRAM Size */
#define SMAP_CIDR_SRAMSIZ(value)    ((SMAP_CIDR_SRAMSIZ_Msk & ((value) << SMAP_CIDR_SRAMSIZ_Pos)))
#define SMAP_CIDR_ARCH_Pos          21
#define SMAP_CIDR_ARCH_Msk          (0x7Fu << SMAP_CIDR_ARCH_Pos) /**< \brief (SMAP_CIDR) Architecture Identifier */
#define SMAP_CIDR_ARCH(value)       ((SMAP_CIDR_ARCH_Msk & ((value) << SMAP_CIDR_ARCH_Pos)))
#define SMAP_CIDR_NVPTYP_Pos        28
#define SMAP_CIDR_NVPTYP_Msk        (0x7u << SMAP_CIDR_NVPTYP_Pos) /**< \brief (SMAP_CIDR) Nonvolatile Program Memory Type */
#define SMAP_CIDR_NVPTYP(value)     ((SMAP_CIDR_NVPTYP_Msk & ((value) << SMAP_CIDR_NVPTYP_Pos)))
#define SMAP_CIDR_EXT               (0x1u << 31) /**< \brief (SMAP_CIDR) Extension Flag */
/* -------- SMAP_EXID : (SMAP Offset: 0xF4) Chip ID Extension Register -------- */
#define SMAP_EXID_EXID_Pos          0
#define SMAP_EXID_EXID_Msk          (0xFFFFFFFFu << SMAP_EXID_EXID_Pos) /**< \brief (SMAP_EXID) Chip ID Extension */
#define SMAP_EXID_EXID(value)       ((SMAP_EXID_EXID_Msk & ((value) << SMAP_EXID_EXID_Pos)))
/* -------- SMAP_IDR : (SMAP Offset: 0xFC) AP Identification register -------- */
#define SMAP_IDR_APIDV_Pos          0
#define SMAP_IDR_APIDV_Msk          (0xFu << SMAP_IDR_APIDV_Pos) /**< \brief (SMAP_IDR) AP Identification Variant */
#define SMAP_IDR_APIDV(value)       ((SMAP_IDR_APIDV_Msk & ((value) << SMAP_IDR_APIDV_Pos)))
#define SMAP_IDR_APID_Pos           4
#define SMAP_IDR_APID_Msk           (0xFu << SMAP_IDR_APID_Pos) /**< \brief (SMAP_IDR) AP Identification */
#define SMAP_IDR_APID(value)        ((SMAP_IDR_APID_Msk & ((value) << SMAP_IDR_APID_Pos)))
#define SMAP_IDR_CLSS               (0x1u << 16) /**< \brief (SMAP_IDR) Class */
#define SMAP_IDR_IC_Pos             17
#define SMAP_IDR_IC_Msk             (0x7Fu << SMAP_IDR_IC_Pos) /**< \brief (SMAP_IDR) JEP-106 Identity Code */
#define SMAP_IDR_IC(value)          ((SMAP_IDR_IC_Msk & ((value) << SMAP_IDR_IC_Pos)))
#define SMAP_IDR_CC_Pos             24
#define SMAP_IDR_CC_Msk             (0xFu << SMAP_IDR_CC_Pos) /**< \brief (SMAP_IDR) JEP-106 Continuation Code */
#define SMAP_IDR_CC(value)          ((SMAP_IDR_CC_Msk & ((value) << SMAP_IDR_CC_Pos)))
#define SMAP_IDR_REVISION_Pos       28
#define SMAP_IDR_REVISION_Msk       (0xFu << SMAP_IDR_REVISION_Pos) /**< \brief (SMAP_IDR) Revision */
#define SMAP_IDR_REVISION(value)    ((SMAP_IDR_REVISION_Msk & ((value) << SMAP_IDR_REVISION_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR SPI */
/* ============================================================================= */
/** \addtogroup SAM4L4_SPI Serial Peripheral Interface */
/*@{*/

#define REV_SPI        0x211

#ifndef __ASSEMBLY__
/** \brief SPI hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (SPI Offset: 0x00) Control Register */
  RwReg   MR;          /**< \brief (SPI Offset: 0x04) Mode Register */
  RoReg   RDR;         /**< \brief (SPI Offset: 0x08) Receive Data Register */
  WoReg   TDR;         /**< \brief (SPI Offset: 0x0C) Transmit Data Register */
  RoReg   SR;          /**< \brief (SPI Offset: 0x10) Status Register */
  WoReg   IER;         /**< \brief (SPI Offset: 0x14) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (SPI Offset: 0x18) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (SPI Offset: 0x1C) Interrupt Mask Register */
  RoReg   Reserved1[4];
  RwReg   CSR0;        /**< \brief (SPI Offset: 0x30) Chip Select Register 0 */
  RwReg   CSR1;        /**< \brief (SPI Offset: 0x34) Chip Select Register 1 */
  RwReg   CSR2;        /**< \brief (SPI Offset: 0x38) Chip Select Register 2 */
  RwReg   CSR3;        /**< \brief (SPI Offset: 0x3C) Chip Select Register 3 */
  RoReg   Reserved2[41];
  RwReg   WPCR;        /**< \brief (SPI Offset: 0xE4) Write Protection control Register */
  RoReg   WPSR;        /**< \brief (SPI Offset: 0xE8) Write Protection status Register */
  RoReg   Reserved3[3];
  RoReg   FEATURES;    /**< \brief (SPI Offset: 0xF8) Features Register */
  RoReg   VERSION;     /**< \brief (SPI Offset: 0xFC) Version Register */
} Spi;
#endif /* __ASSEMBLY__ */
/* -------- SPI_CR : (SPI Offset: 0x00) Control Register -------- */
#define SPI_CR_SPIEN                (0x1u <<  0) /**< \brief (SPI_CR) SPI Enable */
#define   SPI_CR_SPIEN_0            (0x0u <<  0) /**< \brief (SPI_CR) No effect. */
#define   SPI_CR_SPIEN_1            (0x1u <<  0) /**< \brief (SPI_CR) Enables the SPI to transfer and receive data. */
#define SPI_CR_SPIDIS               (0x1u <<  1) /**< \brief (SPI_CR) SPI Disable */
#define   SPI_CR_SPIDIS_0           (0x0u <<  1) /**< \brief (SPI_CR) No effect. */
#define   SPI_CR_SPIDIS_1           (0x1u <<  1) /**< \brief (SPI_CR) Disables the SPI.All pins are set in input mode and no data is received or transmitted.If a transfer is in progress, the transfer is finished before the SPI is disabled.If both SPIEN and SPIDIS are equal to one when the control register is written, the SPI is disabled. */
#define SPI_CR_SWRST                (0x1u <<  7) /**< \brief (SPI_CR) SPI Software Reset */
#define   SPI_CR_SWRST_0            (0x0u <<  7) /**< \brief (SPI_CR) No effect. */
#define   SPI_CR_SWRST_1            (0x1u <<  7) /**< \brief (SPI_CR) Reset the SPI. A software-triggered hardware reset of the SPI interface is performed. */
#define SPI_CR_FLUSHFIFO            (0x1u <<  8) /**< \brief (SPI_CR) Flush FIFO command */
#define SPI_CR_LASTXFER             (0x1u << 24) /**< \brief (SPI_CR) Last Transfer */
#define   SPI_CR_LASTXFER_0         (0x0u << 24) /**< \brief (SPI_CR) No effect. */
#define   SPI_CR_LASTXFER_1         (0x1u << 24) /**< \brief (SPI_CR) The current NPCS will be deasserted after the character written in TD has been transferred. When CSAAT is set, thisallows to close the communication with the current serial peripheral by raising the corresponding NPCS line as soon as TDtransfer has completed. */
/* -------- SPI_MR : (SPI Offset: 0x04) Mode Register -------- */
#define SPI_MR_MSTR                 (0x1u <<  0) /**< \brief (SPI_MR) Master/Slave Mode */
#define   SPI_MR_MSTR_0             (0x0u <<  0) /**< \brief (SPI_MR) SPI is in Slave mode. */
#define   SPI_MR_MSTR_1             (0x1u <<  0) /**< \brief (SPI_MR) SPI is in Master mode. */
#define SPI_MR_PS                   (0x1u <<  1) /**< \brief (SPI_MR) Peripheral Select */
#define   SPI_MR_PS_0               (0x0u <<  1) /**< \brief (SPI_MR) Fixed Peripheral Select. */
#define   SPI_MR_PS_1               (0x1u <<  1) /**< \brief (SPI_MR) Variable Peripheral Select. */
#define SPI_MR_PCSDEC               (0x1u <<  2) /**< \brief (SPI_MR) Chip Select Decode */
#define   SPI_MR_PCSDEC_0           (0x0u <<  2) /**< \brief (SPI_MR) The chip selects are directly connected to a peripheral device. */
#define   SPI_MR_PCSDEC_1           (0x1u <<  2) /**< \brief (SPI_MR) The four chip select lines are connected to a 4- to 16-bit decoder.When PCSDEC equals one, up to 15 Chip Select signals can be generated with the four lines using an external 4- to 16-bitdecoder. The Chip Select Registers define the characteristics of the 16 chip selects according to the following rules:CSR0 defines peripheral chip select signals 0 to 3.CSR1 defines peripheral chip select signals 4 to 7.CSR2 defines peripheral chip select signals 8 to 11.CSR3 defines peripheral chip select signals 12 to 15. */
#define SPI_MR_MODFDIS              (0x1u <<  4) /**< \brief (SPI_MR) Mode Fault Detection */
#define   SPI_MR_MODFDIS_0          (0x0u <<  4) /**< \brief (SPI_MR) Mode fault detection is enabled. */
#define   SPI_MR_MODFDIS_1          (0x1u <<  4) /**< \brief (SPI_MR) Mode fault detection is disabled. */
#define SPI_MR_WDRBT                (0x1u <<  5) /**< \brief (SPI_MR) wait data read before transfer */
#define SPI_MR_RXFIFOEN             (0x1u <<  6) /**< \brief (SPI_MR) FIFO in Reception Enable */
#define SPI_MR_LLB                  (0x1u <<  7) /**< \brief (SPI_MR) Local Loopback Enable */
#define   SPI_MR_LLB_0              (0x0u <<  7) /**< \brief (SPI_MR) Local loopback path disabled. */
#define   SPI_MR_LLB_1              (0x1u <<  7) /**< \brief (SPI_MR) Local loopback path enabled.LLB controls the local loopback on the data serializer for testing in Master Mode only. */
#define SPI_MR_PCS_Pos              16
#define SPI_MR_PCS_Msk              (0xFu << SPI_MR_PCS_Pos) /**< \brief (SPI_MR) Peripheral Chip Select */
#define SPI_MR_PCS(value)           ((SPI_MR_PCS_Msk & ((value) << SPI_MR_PCS_Pos)))
#define SPI_MR_DLYBCS_Pos           24
#define SPI_MR_DLYBCS_Msk           (0xFFu << SPI_MR_DLYBCS_Pos) /**< \brief (SPI_MR) Delay Between Chip Selects */
#define SPI_MR_DLYBCS(value)        ((SPI_MR_DLYBCS_Msk & ((value) << SPI_MR_DLYBCS_Pos)))
/* -------- SPI_RDR : (SPI Offset: 0x08) Receive Data Register -------- */
#define SPI_RDR_RD_Pos              0
#define SPI_RDR_RD_Msk              (0xFFFFu << SPI_RDR_RD_Pos) /**< \brief (SPI_RDR) Receive Data */
#define SPI_RDR_RD(value)           ((SPI_RDR_RD_Msk & ((value) << SPI_RDR_RD_Pos)))
#define SPI_RDR_PCS_Pos             16
#define SPI_RDR_PCS_Msk             (0xFu << SPI_RDR_PCS_Pos) /**< \brief (SPI_RDR) Peripheral Chip Select */
#define SPI_RDR_PCS(value)          ((SPI_RDR_PCS_Msk & ((value) << SPI_RDR_PCS_Pos)))
/* -------- SPI_TDR : (SPI Offset: 0x0C) Transmit Data Register -------- */
#define SPI_TDR_TD_Pos              0
#define SPI_TDR_TD_Msk              (0xFFFFu << SPI_TDR_TD_Pos) /**< \brief (SPI_TDR) Transmit Data */
#define SPI_TDR_TD(value)           ((SPI_TDR_TD_Msk & ((value) << SPI_TDR_TD_Pos)))
#define SPI_TDR_PCS_Pos             16
#define SPI_TDR_PCS_Msk             (0xFu << SPI_TDR_PCS_Pos) /**< \brief (SPI_TDR) Peripheral Chip Select */
#define SPI_TDR_PCS(value)          ((SPI_TDR_PCS_Msk & ((value) << SPI_TDR_PCS_Pos)))
#define SPI_TDR_LASTXFER            (0x1u << 24) /**< \brief (SPI_TDR) Last Transfer */
#define   SPI_TDR_LASTXFER_0        (0x0u << 24) /**< \brief (SPI_TDR) No effect. */
#define   SPI_TDR_LASTXFER_1        (0x1u << 24) /**< \brief (SPI_TDR) The current NPCS will be deasserted after the character written in TD has been transferred. When CSAAT is set, thisallows to close the communication with the current serial peripheral by raising the corresponding NPCS line as soon as TDtransfer has completed. */
/* -------- SPI_SR : (SPI Offset: 0x10) Status Register -------- */
#define SPI_SR_RDRF                 (0x1u <<  0) /**< \brief (SPI_SR) Receive Data Register Full */
#define   SPI_SR_RDRF_0             (0x0u <<  0) /**< \brief (SPI_SR) No data has been received since the last read of RDR */
#define   SPI_SR_RDRF_1             (0x1u <<  0) /**< \brief (SPI_SR) Data has been received and the received data has been transferred from the serializer to RDR since the last readof RDR. */
#define SPI_SR_TDRE                 (0x1u <<  1) /**< \brief (SPI_SR) Transmit Data Register Empty */
#define   SPI_SR_TDRE_0             (0x0u <<  1) /**< \brief (SPI_SR) Data has been written to TDR and not yet transferred to the serializer. */
#define   SPI_SR_TDRE_1             (0x1u <<  1) /**< \brief (SPI_SR) The last data written in the Transmit Data Register has been transferred to the serializer.TDRE equals zero when the SPI is disabled or at reset. The SPI enable command sets this bit to one. */
#define SPI_SR_MODF                 (0x1u <<  2) /**< \brief (SPI_SR) Mode Fault Error */
#define   SPI_SR_MODF_0             (0x0u <<  2) /**< \brief (SPI_SR) No Mode Fault has been detected since the last read of SR. */
#define   SPI_SR_MODF_1             (0x1u <<  2) /**< \brief (SPI_SR) A Mode Fault occurred since the last read of the SR. */
#define SPI_SR_OVRES                (0x1u <<  3) /**< \brief (SPI_SR) Overrun Error Status */
#define   SPI_SR_OVRES_0            (0x0u <<  3) /**< \brief (SPI_SR) No overrun has been detected since the last read of SR. */
#define   SPI_SR_OVRES_1            (0x1u <<  3) /**< \brief (SPI_SR) An overrun has occurred since the last read of SR. */
#define SPI_SR_ENDRX                (0x1u <<  4) /**< \brief (SPI_SR) End of RX buffer */
#define   SPI_SR_ENDRX_0            (0x0u <<  4) /**< \brief (SPI_SR) The Receive Counter Register has not reached 0 since the last write in RCR or RNCR. */
#define   SPI_SR_ENDRX_1            (0x1u <<  4) /**< \brief (SPI_SR) The Receive Counter Register has reached 0 since the last write in RCR or RNCR. */
#define SPI_SR_ENDTX                (0x1u <<  5) /**< \brief (SPI_SR) End of TX buffer */
#define   SPI_SR_ENDTX_0            (0x0u <<  5) /**< \brief (SPI_SR) The Transmit Counter Register has not reached 0 since the last write in TCR or TNCR. */
#define   SPI_SR_ENDTX_1            (0x1u <<  5) /**< \brief (SPI_SR) The Transmit Counter Register has reached 0 since the last write in TCR or TNCR. */
#define SPI_SR_RXBUFF               (0x1u <<  6) /**< \brief (SPI_SR) RX Buffer Full */
#define   SPI_SR_RXBUFF_0           (0x0u <<  6) /**< \brief (SPI_SR) RCR or RNCR has a value other than 0. */
#define   SPI_SR_RXBUFF_1           (0x1u <<  6) /**< \brief (SPI_SR) Both RCR and RNCR has a value of 0. */
#define SPI_SR_TXBUFE               (0x1u <<  7) /**< \brief (SPI_SR) TX Buffer Empty */
#define   SPI_SR_TXBUFE_0           (0x0u <<  7) /**< \brief (SPI_SR) TCR or TNCR has a value other than 0. */
#define   SPI_SR_TXBUFE_1           (0x1u <<  7) /**< \brief (SPI_SR) Both TCR and TNCR has a value of 0. */
#define SPI_SR_NSSR                 (0x1u <<  8) /**< \brief (SPI_SR) NSS Rising */
#define   SPI_SR_NSSR_0             (0x0u <<  8) /**< \brief (SPI_SR) No rising edge detected on NSS pin since last read. */
#define   SPI_SR_NSSR_1             (0x1u <<  8) /**< \brief (SPI_SR) A rising edge occurred on NSS pin since last read. */
#define SPI_SR_TXEMPTY              (0x1u <<  9) /**< \brief (SPI_SR) Transmission Registers Empty */
#define   SPI_SR_TXEMPTY_0          (0x0u <<  9) /**< \brief (SPI_SR) As soon as data is written in TDR. */
#define   SPI_SR_TXEMPTY_1          (0x1u <<  9) /**< \brief (SPI_SR) TDR and internal shifter are empty. If a transfer delay has been defined, TXEMPTY is set after the completion ofsuch delay. */
#define SPI_SR_UNDES                (0x1u << 10) /**< \brief (SPI_SR) Underrun Error Status (Slave Mode Only) */
#define SPI_SR_SPIENS               (0x1u << 16) /**< \brief (SPI_SR) SPI Enable Status */
#define   SPI_SR_SPIENS_0           (0x0u << 16) /**< \brief (SPI_SR) SPI is disabled. */
#define   SPI_SR_SPIENS_1           (0x1u << 16) /**< \brief (SPI_SR) SPI is enabled. */
/* -------- SPI_IER : (SPI Offset: 0x14) Interrupt Enable Register -------- */
#define SPI_IER_RDRF                (0x1u <<  0) /**< \brief (SPI_IER) Receive Data Register Full Interrupt Enable */
#define   SPI_IER_RDRF_0            (0x0u <<  0) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_RDRF_1            (0x1u <<  0) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_TDRE                (0x1u <<  1) /**< \brief (SPI_IER) Transmit Data Register Empty Interrupt Enable */
#define   SPI_IER_TDRE_0            (0x0u <<  1) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_TDRE_1            (0x1u <<  1) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_MODF                (0x1u <<  2) /**< \brief (SPI_IER) Mode Fault Error Interrupt Enable */
#define   SPI_IER_MODF_0            (0x0u <<  2) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_MODF_1            (0x1u <<  2) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_OVRES               (0x1u <<  3) /**< \brief (SPI_IER) Overrun Error Interrupt Enable */
#define   SPI_IER_OVRES_0           (0x0u <<  3) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_OVRES_1           (0x1u <<  3) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_ENDRX               (0x1u <<  4) /**< \brief (SPI_IER) End of Receive Buffer Interrupt Enable */
#define   SPI_IER_ENDRX_0           (0x0u <<  4) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_ENDRX_1           (0x1u <<  4) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_ENDTX               (0x1u <<  5) /**< \brief (SPI_IER) End of Transmit Buffer Interrupt Enable */
#define   SPI_IER_ENDTX_0           (0x0u <<  5) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_ENDTX_1           (0x1u <<  5) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_RXBUFF              (0x1u <<  6) /**< \brief (SPI_IER) Receive Buffer Full Interrupt Enable */
#define   SPI_IER_RXBUFF_0          (0x0u <<  6) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_RXBUFF_1          (0x1u <<  6) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_TXBUFE              (0x1u <<  7) /**< \brief (SPI_IER) Transmit Buffer Empty Interrupt Enable */
#define   SPI_IER_TXBUFE_0          (0x0u <<  7) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_TXBUFE_1          (0x1u <<  7) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_NSSR                (0x1u <<  8) /**< \brief (SPI_IER) NSS Rising Interrupt Enable */
#define   SPI_IER_NSSR_0            (0x0u <<  8) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_NSSR_1            (0x1u <<  8) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_TXEMPTY             (0x1u <<  9) /**< \brief (SPI_IER) Transmission Registers Empty Enable */
#define   SPI_IER_TXEMPTY_0         (0x0u <<  9) /**< \brief (SPI_IER) No effect. */
#define   SPI_IER_TXEMPTY_1         (0x1u <<  9) /**< \brief (SPI_IER) Enables the corresponding interrupt. */
#define SPI_IER_UNDES               (0x1u << 10) /**< \brief (SPI_IER) Underrun Error Interrupt Enable */
/* -------- SPI_IDR : (SPI Offset: 0x18) Interrupt Disable Register -------- */
#define SPI_IDR_RDRF                (0x1u <<  0) /**< \brief (SPI_IDR) Receive Data Register Full Interrupt Disable */
#define   SPI_IDR_RDRF_0            (0x0u <<  0) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_RDRF_1            (0x1u <<  0) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_TDRE                (0x1u <<  1) /**< \brief (SPI_IDR) Transmit Data Register Empty Interrupt Disable */
#define   SPI_IDR_TDRE_0            (0x0u <<  1) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_TDRE_1            (0x1u <<  1) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_MODF                (0x1u <<  2) /**< \brief (SPI_IDR) Mode Fault Error Interrupt Disable */
#define   SPI_IDR_MODF_0            (0x0u <<  2) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_MODF_1            (0x1u <<  2) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_OVRES               (0x1u <<  3) /**< \brief (SPI_IDR) Overrun Error Interrupt Disable */
#define   SPI_IDR_OVRES_0           (0x0u <<  3) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_OVRES_1           (0x1u <<  3) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_ENDRX               (0x1u <<  4) /**< \brief (SPI_IDR) End of Receive Buffer Interrupt Disable */
#define   SPI_IDR_ENDRX_0           (0x0u <<  4) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_ENDRX_1           (0x1u <<  4) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_ENDTX               (0x1u <<  5) /**< \brief (SPI_IDR) End of Transmit Buffer Interrupt Disable */
#define   SPI_IDR_ENDTX_0           (0x0u <<  5) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_ENDTX_1           (0x1u <<  5) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_RXBUFF              (0x1u <<  6) /**< \brief (SPI_IDR) Receive Buffer Full Interrupt Disable */
#define   SPI_IDR_RXBUFF_0          (0x0u <<  6) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_RXBUFF_1          (0x1u <<  6) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_TXBUFE              (0x1u <<  7) /**< \brief (SPI_IDR) Transmit Buffer Empty Interrupt Disable */
#define   SPI_IDR_TXBUFE_0          (0x0u <<  7) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_TXBUFE_1          (0x1u <<  7) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_NSSR                (0x1u <<  8) /**< \brief (SPI_IDR) NSS Rising Interrupt Disable */
#define   SPI_IDR_NSSR_0            (0x0u <<  8) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_NSSR_1            (0x1u <<  8) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_TXEMPTY             (0x1u <<  9) /**< \brief (SPI_IDR) Transmission Registers Empty Disable */
#define   SPI_IDR_TXEMPTY_0         (0x0u <<  9) /**< \brief (SPI_IDR) No effect. */
#define   SPI_IDR_TXEMPTY_1         (0x1u <<  9) /**< \brief (SPI_IDR) Disables the corresponding interrupt. */
#define SPI_IDR_UNDES               (0x1u << 10) /**< \brief (SPI_IDR) Underrun Error Interrupt Disable */
/* -------- SPI_IMR : (SPI Offset: 0x1C) Interrupt Mask Register -------- */
#define SPI_IMR_RDRF                (0x1u <<  0) /**< \brief (SPI_IMR) Receive Data Register Full Interrupt Mask */
#define   SPI_IMR_RDRF_0            (0x0u <<  0) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_RDRF_1            (0x1u <<  0) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_TDRE                (0x1u <<  1) /**< \brief (SPI_IMR) Transmit Data Register Empty Interrupt Mask */
#define   SPI_IMR_TDRE_0            (0x0u <<  1) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_TDRE_1            (0x1u <<  1) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_MODF                (0x1u <<  2) /**< \brief (SPI_IMR) Mode Fault Error Interrupt Mask */
#define   SPI_IMR_MODF_0            (0x0u <<  2) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_MODF_1            (0x1u <<  2) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_OVRES               (0x1u <<  3) /**< \brief (SPI_IMR) Overrun Error Interrupt Mask */
#define   SPI_IMR_OVRES_0           (0x0u <<  3) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_OVRES_1           (0x1u <<  3) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_ENDRX               (0x1u <<  4) /**< \brief (SPI_IMR) End of Receive Buffer Interrupt Mask */
#define   SPI_IMR_ENDRX_0           (0x0u <<  4) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_ENDRX_1           (0x1u <<  4) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_ENDTX               (0x1u <<  5) /**< \brief (SPI_IMR) End of Transmit Buffer Interrupt Mask */
#define   SPI_IMR_ENDTX_0           (0x0u <<  5) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_ENDTX_1           (0x1u <<  5) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_RXBUFF              (0x1u <<  6) /**< \brief (SPI_IMR) Receive Buffer Full Interrupt Mask */
#define   SPI_IMR_RXBUFF_0          (0x0u <<  6) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_RXBUFF_1          (0x1u <<  6) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_TXBUFE              (0x1u <<  7) /**< \brief (SPI_IMR) Transmit Buffer Empty Interrupt Mask */
#define   SPI_IMR_TXBUFE_0          (0x0u <<  7) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_TXBUFE_1          (0x1u <<  7) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_NSSR                (0x1u <<  8) /**< \brief (SPI_IMR) NSS Rising Interrupt Mask */
#define   SPI_IMR_NSSR_0            (0x0u <<  8) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_NSSR_1            (0x1u <<  8) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_TXEMPTY             (0x1u <<  9) /**< \brief (SPI_IMR) Transmission Registers Empty Mask */
#define   SPI_IMR_TXEMPTY_0         (0x0u <<  9) /**< \brief (SPI_IMR) The corresponding interrupt is not enabled. */
#define   SPI_IMR_TXEMPTY_1         (0x1u <<  9) /**< \brief (SPI_IMR) The corresponding interrupt is enabled. */
#define SPI_IMR_UNDES               (0x1u << 10) /**< \brief (SPI_IMR) Underrun Error Interrupt Mask */
/* -------- SPI_CSR0 : (SPI Offset: 0x30) Chip Select Register 0 -------- */
#define SPI_CSR0_CPOL               (0x1u <<  0) /**< \brief (SPI_CSR0) Clock Polarity */
#define   SPI_CSR0_CPOL_0           (0x0u <<  0) /**< \brief (SPI_CSR0) The inactive state value of SPCK is logic level zero. */
#define   SPI_CSR0_CPOL_1           (0x1u <<  0) /**< \brief (SPI_CSR0) The inactive state value of SPCK is logic level one.CPOL is used to determine the inactive state value of the serial clock (SPCK). It is used with NCPHA to produce therequired clock/data relationship between master and slave devices. */
#define SPI_CSR0_NCPHA              (0x1u <<  1) /**< \brief (SPI_CSR0) Clock Phase */
#define   SPI_CSR0_NCPHA_0          (0x0u <<  1) /**< \brief (SPI_CSR0) Data is changed on the leading edge of SPCK and captured on the following edge of SPCK. */
#define   SPI_CSR0_NCPHA_1          (0x1u <<  1) /**< \brief (SPI_CSR0) Data is captured on the leading edge of SPCK and changed on the following edge of SPCK.NCPHA determines which edge of SPCK causes data to change and which edge causes data to be captured. NCPHA isused with CPOL to produce the required clock/data relationship between master and slave devices. */
#define SPI_CSR0_CSNAAT             (0x1u <<  2) /**< \brief (SPI_CSR0) Chip Select Not Active After Transfer */
#define SPI_CSR0_CSAAT              (0x1u <<  3) /**< \brief (SPI_CSR0) Chip Select Active After Transfer */
#define   SPI_CSR0_CSAAT_0          (0x0u <<  3) /**< \brief (SPI_CSR0) The Peripheral Chip Select Line rises as soon as the last transfer is achieved. */
#define   SPI_CSR0_CSAAT_1          (0x1u <<  3) /**< \brief (SPI_CSR0) The Peripheral Chip Select does not rise after the last transfer is achieved. It remains active until a new transfer isrequested on a different chip select. */
#define SPI_CSR0_BITS_Pos           4
#define SPI_CSR0_BITS_Msk           (0xFu << SPI_CSR0_BITS_Pos) /**< \brief (SPI_CSR0) Bits Per Transfer */
#define SPI_CSR0_BITS(value)        ((SPI_CSR0_BITS_Msk & ((value) << SPI_CSR0_BITS_Pos)))
#define   SPI_CSR0_BITS_8_BPT       (0x0u <<  4) /**< \brief (SPI_CSR0) 8 bits per transfer */
#define   SPI_CSR0_BITS_9_BPT       (0x1u <<  4) /**< \brief (SPI_CSR0) 9 bits per transfer */
#define   SPI_CSR0_BITS_10_BPT      (0x2u <<  4) /**< \brief (SPI_CSR0) 10 bits per transfer */
#define   SPI_CSR0_BITS_11_BPT      (0x3u <<  4) /**< \brief (SPI_CSR0) 11 bits per transfer */
#define   SPI_CSR0_BITS_12_BPT      (0x4u <<  4) /**< \brief (SPI_CSR0) 12 bits per transfer */
#define   SPI_CSR0_BITS_13_BPT      (0x5u <<  4) /**< \brief (SPI_CSR0) 13 bits per transfer */
#define   SPI_CSR0_BITS_14_BPT      (0x6u <<  4) /**< \brief (SPI_CSR0) 14 bits per transfer */
#define   SPI_CSR0_BITS_15_BPT      (0x7u <<  4) /**< \brief (SPI_CSR0) 15 bits per transfer */
#define   SPI_CSR0_BITS_16_BPT      (0x8u <<  4) /**< \brief (SPI_CSR0) 16 bits per transfer */
#define SPI_CSR0_SCBR_Pos           8
#define SPI_CSR0_SCBR_Msk           (0xFFu << SPI_CSR0_SCBR_Pos) /**< \brief (SPI_CSR0) Serial Clock Baud Rate */
#define SPI_CSR0_SCBR(value)        ((SPI_CSR0_SCBR_Msk & ((value) << SPI_CSR0_SCBR_Pos)))
#define SPI_CSR0_DLYBS_Pos          16
#define SPI_CSR0_DLYBS_Msk          (0xFFu << SPI_CSR0_DLYBS_Pos) /**< \brief (SPI_CSR0) Delay Before SPCK */
#define SPI_CSR0_DLYBS(value)       ((SPI_CSR0_DLYBS_Msk & ((value) << SPI_CSR0_DLYBS_Pos)))
#define SPI_CSR0_DLYBCT_Pos         24
#define SPI_CSR0_DLYBCT_Msk         (0xFFu << SPI_CSR0_DLYBCT_Pos) /**< \brief (SPI_CSR0) Delay Between Consecutive Transfers */
#define SPI_CSR0_DLYBCT(value)      ((SPI_CSR0_DLYBCT_Msk & ((value) << SPI_CSR0_DLYBCT_Pos)))
/* -------- SPI_CSR1 : (SPI Offset: 0x34) Chip Select Register 1 -------- */
#define SPI_CSR1_CPOL               (0x1u <<  0) /**< \brief (SPI_CSR1) Clock Polarity */
#define   SPI_CSR1_CPOL_0           (0x0u <<  0) /**< \brief (SPI_CSR1) The inactive state value of SPCK is logic level zero. */
#define   SPI_CSR1_CPOL_1           (0x1u <<  0) /**< \brief (SPI_CSR1) The inactive state value of SPCK is logic level one.CPOL is used to determine the inactive state value of the serial clock (SPCK). It is used with NCPHA to produce therequired clock/data relationship between master and slave devices. */
#define SPI_CSR1_NCPHA              (0x1u <<  1) /**< \brief (SPI_CSR1) Clock Phase */
#define   SPI_CSR1_NCPHA_0          (0x0u <<  1) /**< \brief (SPI_CSR1) Data is changed on the leading edge of SPCK and captured on the following edge of SPCK. */
#define   SPI_CSR1_NCPHA_1          (0x1u <<  1) /**< \brief (SPI_CSR1) Data is captured on the leading edge of SPCK and changed on the following edge of SPCK.NCPHA determines which edge of SPCK causes data to change and which edge causes data to be captured. NCPHA isused with CPOL to produce the required clock/data relationship between master and slave devices. */
#define SPI_CSR1_CSNAAT             (0x1u <<  2) /**< \brief (SPI_CSR1) Chip Select Not Active After Transfer */
#define SPI_CSR1_CSAAT              (0x1u <<  3) /**< \brief (SPI_CSR1) Chip Select Active After Transfer */
#define   SPI_CSR1_CSAAT_0          (0x0u <<  3) /**< \brief (SPI_CSR1) The Peripheral Chip Select Line rises as soon as the last transfer is achieved. */
#define   SPI_CSR1_CSAAT_1          (0x1u <<  3) /**< \brief (SPI_CSR1) The Peripheral Chip Select does not rise after the last transfer is achieved. It remains active until a new transfer isrequested on a different chip select. */
#define SPI_CSR1_BITS_Pos           4
#define SPI_CSR1_BITS_Msk           (0xFu << SPI_CSR1_BITS_Pos) /**< \brief (SPI_CSR1) Bits Per Transfer */
#define SPI_CSR1_BITS(value)        ((SPI_CSR1_BITS_Msk & ((value) << SPI_CSR1_BITS_Pos)))
#define   SPI_CSR1_BITS_8_BPT       (0x0u <<  4) /**< \brief (SPI_CSR1) 8 bits per transfer */
#define   SPI_CSR1_BITS_9_BPT       (0x1u <<  4) /**< \brief (SPI_CSR1) 9 bits per transfer */
#define   SPI_CSR1_BITS_10_BPT      (0x2u <<  4) /**< \brief (SPI_CSR1) 10 bits per transfer */
#define   SPI_CSR1_BITS_11_BPT      (0x3u <<  4) /**< \brief (SPI_CSR1) 11 bits per transfer */
#define   SPI_CSR1_BITS_12_BPT      (0x4u <<  4) /**< \brief (SPI_CSR1) 12 bits per transfer */
#define   SPI_CSR1_BITS_13_BPT      (0x5u <<  4) /**< \brief (SPI_CSR1) 13 bits per transfer */
#define   SPI_CSR1_BITS_14_BPT      (0x6u <<  4) /**< \brief (SPI_CSR1) 14 bits per transfer */
#define   SPI_CSR1_BITS_15_BPT      (0x7u <<  4) /**< \brief (SPI_CSR1) 15 bits per transfer */
#define   SPI_CSR1_BITS_16_BPT      (0x8u <<  4) /**< \brief (SPI_CSR1) 16 bits per transfer */
#define SPI_CSR1_SCBR_Pos           8
#define SPI_CSR1_SCBR_Msk           (0xFFu << SPI_CSR1_SCBR_Pos) /**< \brief (SPI_CSR1) Serial Clock Baud Rate */
#define SPI_CSR1_SCBR(value)        ((SPI_CSR1_SCBR_Msk & ((value) << SPI_CSR1_SCBR_Pos)))
#define SPI_CSR1_DLYBS_Pos          16
#define SPI_CSR1_DLYBS_Msk          (0xFFu << SPI_CSR1_DLYBS_Pos) /**< \brief (SPI_CSR1) Delay Before SPCK */
#define SPI_CSR1_DLYBS(value)       ((SPI_CSR1_DLYBS_Msk & ((value) << SPI_CSR1_DLYBS_Pos)))
#define SPI_CSR1_DLYBCT_Pos         24
#define SPI_CSR1_DLYBCT_Msk         (0xFFu << SPI_CSR1_DLYBCT_Pos) /**< \brief (SPI_CSR1) Delay Between Consecutive Transfers */
#define SPI_CSR1_DLYBCT(value)      ((SPI_CSR1_DLYBCT_Msk & ((value) << SPI_CSR1_DLYBCT_Pos)))
/* -------- SPI_CSR2 : (SPI Offset: 0x38) Chip Select Register 2 -------- */
#define SPI_CSR2_CPOL               (0x1u <<  0) /**< \brief (SPI_CSR2) Clock Polarity */
#define   SPI_CSR2_CPOL_0           (0x0u <<  0) /**< \brief (SPI_CSR2) The inactive state value of SPCK is logic level zero. */
#define   SPI_CSR2_CPOL_1           (0x1u <<  0) /**< \brief (SPI_CSR2) The inactive state value of SPCK is logic level one.CPOL is used to determine the inactive state value of the serial clock (SPCK). It is used with NCPHA to produce therequired clock/data relationship between master and slave devices. */
#define SPI_CSR2_NCPHA              (0x1u <<  1) /**< \brief (SPI_CSR2) Clock Phase */
#define   SPI_CSR2_NCPHA_0          (0x0u <<  1) /**< \brief (SPI_CSR2) Data is changed on the leading edge of SPCK and captured on the following edge of SPCK. */
#define   SPI_CSR2_NCPHA_1          (0x1u <<  1) /**< \brief (SPI_CSR2) Data is captured on the leading edge of SPCK and changed on the following edge of SPCK.NCPHA determines which edge of SPCK causes data to change and which edge causes data to be captured. NCPHA isused with CPOL to produce the required clock/data relationship between master and slave devices. */
#define SPI_CSR2_CSNAAT             (0x1u <<  2) /**< \brief (SPI_CSR2) Chip Select Not Active After Transfer */
#define SPI_CSR2_CSAAT              (0x1u <<  3) /**< \brief (SPI_CSR2) Chip Select Active After Transfer */
#define   SPI_CSR2_CSAAT_0          (0x0u <<  3) /**< \brief (SPI_CSR2) The Peripheral Chip Select Line rises as soon as the last transfer is achieved. */
#define   SPI_CSR2_CSAAT_1          (0x1u <<  3) /**< \brief (SPI_CSR2) The Peripheral Chip Select does not rise after the last transfer is achieved. It remains active until a new transfer isrequested on a different chip select. */
#define SPI_CSR2_BITS_Pos           4
#define SPI_CSR2_BITS_Msk           (0xFu << SPI_CSR2_BITS_Pos) /**< \brief (SPI_CSR2) Bits Per Transfer */
#define SPI_CSR2_BITS(value)        ((SPI_CSR2_BITS_Msk & ((value) << SPI_CSR2_BITS_Pos)))
#define   SPI_CSR2_BITS_8_BPT       (0x0u <<  4) /**< \brief (SPI_CSR2) 8 bits per transfer */
#define   SPI_CSR2_BITS_9_BPT       (0x1u <<  4) /**< \brief (SPI_CSR2) 9 bits per transfer */
#define   SPI_CSR2_BITS_10_BPT      (0x2u <<  4) /**< \brief (SPI_CSR2) 10 bits per transfer */
#define   SPI_CSR2_BITS_11_BPT      (0x3u <<  4) /**< \brief (SPI_CSR2) 11 bits per transfer */
#define   SPI_CSR2_BITS_12_BPT      (0x4u <<  4) /**< \brief (SPI_CSR2) 12 bits per transfer */
#define   SPI_CSR2_BITS_13_BPT      (0x5u <<  4) /**< \brief (SPI_CSR2) 13 bits per transfer */
#define   SPI_CSR2_BITS_14_BPT      (0x6u <<  4) /**< \brief (SPI_CSR2) 14 bits per transfer */
#define   SPI_CSR2_BITS_15_BPT      (0x7u <<  4) /**< \brief (SPI_CSR2) 15 bits per transfer */
#define   SPI_CSR2_BITS_16_BPT      (0x8u <<  4) /**< \brief (SPI_CSR2) 16 bits per transfer */
#define SPI_CSR2_SCBR_Pos           8
#define SPI_CSR2_SCBR_Msk           (0xFFu << SPI_CSR2_SCBR_Pos) /**< \brief (SPI_CSR2) Serial Clock Baud Rate */
#define SPI_CSR2_SCBR(value)        ((SPI_CSR2_SCBR_Msk & ((value) << SPI_CSR2_SCBR_Pos)))
#define SPI_CSR2_DLYBS_Pos          16
#define SPI_CSR2_DLYBS_Msk          (0xFFu << SPI_CSR2_DLYBS_Pos) /**< \brief (SPI_CSR2) Delay Before SPCK */
#define SPI_CSR2_DLYBS(value)       ((SPI_CSR2_DLYBS_Msk & ((value) << SPI_CSR2_DLYBS_Pos)))
#define SPI_CSR2_DLYBCT_Pos         24
#define SPI_CSR2_DLYBCT_Msk         (0xFFu << SPI_CSR2_DLYBCT_Pos) /**< \brief (SPI_CSR2) Delay Between Consecutive Transfers */
#define SPI_CSR2_DLYBCT(value)      ((SPI_CSR2_DLYBCT_Msk & ((value) << SPI_CSR2_DLYBCT_Pos)))
/* -------- SPI_CSR3 : (SPI Offset: 0x3C) Chip Select Register 3 -------- */
#define SPI_CSR3_CPOL               (0x1u <<  0) /**< \brief (SPI_CSR3) Clock Polarity */
#define   SPI_CSR3_CPOL_0           (0x0u <<  0) /**< \brief (SPI_CSR3) The inactive state value of SPCK is logic level zero. */
#define   SPI_CSR3_CPOL_1           (0x1u <<  0) /**< \brief (SPI_CSR3) The inactive state value of SPCK is logic level one.CPOL is used to determine the inactive state value of the serial clock (SPCK). It is used with NCPHA to produce therequired clock/data relationship between master and slave devices. */
#define SPI_CSR3_NCPHA              (0x1u <<  1) /**< \brief (SPI_CSR3) Clock Phase */
#define   SPI_CSR3_NCPHA_0          (0x0u <<  1) /**< \brief (SPI_CSR3) Data is changed on the leading edge of SPCK and captured on the following edge of SPCK. */
#define   SPI_CSR3_NCPHA_1          (0x1u <<  1) /**< \brief (SPI_CSR3) Data is captured on the leading edge of SPCK and changed on the following edge of SPCK.NCPHA determines which edge of SPCK causes data to change and which edge causes data to be captured. NCPHA isused with CPOL to produce the required clock/data relationship between master and slave devices. */
#define SPI_CSR3_CSNAAT             (0x1u <<  2) /**< \brief (SPI_CSR3) Chip Select Not Active After Transfer */
#define SPI_CSR3_CSAAT              (0x1u <<  3) /**< \brief (SPI_CSR3) Chip Select Active After Transfer */
#define   SPI_CSR3_CSAAT_0          (0x0u <<  3) /**< \brief (SPI_CSR3) The Peripheral Chip Select Line rises as soon as the last transfer is achieved. */
#define   SPI_CSR3_CSAAT_1          (0x1u <<  3) /**< \brief (SPI_CSR3) The Peripheral Chip Select does not rise after the last transfer is achieved. It remains active until a new transfer isrequested on a different chip select. */
#define SPI_CSR3_BITS_Pos           4
#define SPI_CSR3_BITS_Msk           (0xFu << SPI_CSR3_BITS_Pos) /**< \brief (SPI_CSR3) Bits Per Transfer */
#define SPI_CSR3_BITS(value)        ((SPI_CSR3_BITS_Msk & ((value) << SPI_CSR3_BITS_Pos)))
#define   SPI_CSR3_BITS_8_BPT       (0x0u <<  4) /**< \brief (SPI_CSR3) 8 bits per transfer */
#define   SPI_CSR3_BITS_9_BPT       (0x1u <<  4) /**< \brief (SPI_CSR3) 9 bits per transfer */
#define   SPI_CSR3_BITS_10_BPT      (0x2u <<  4) /**< \brief (SPI_CSR3) 10 bits per transfer */
#define   SPI_CSR3_BITS_11_BPT      (0x3u <<  4) /**< \brief (SPI_CSR3) 11 bits per transfer */
#define   SPI_CSR3_BITS_12_BPT      (0x4u <<  4) /**< \brief (SPI_CSR3) 12 bits per transfer */
#define   SPI_CSR3_BITS_13_BPT      (0x5u <<  4) /**< \brief (SPI_CSR3) 13 bits per transfer */
#define   SPI_CSR3_BITS_14_BPT      (0x6u <<  4) /**< \brief (SPI_CSR3) 14 bits per transfer */
#define   SPI_CSR3_BITS_15_BPT      (0x7u <<  4) /**< \brief (SPI_CSR3) 15 bits per transfer */
#define   SPI_CSR3_BITS_16_BPT      (0x8u <<  4) /**< \brief (SPI_CSR3) 16 bits per transfer */
#define SPI_CSR3_SCBR_Pos           8
#define SPI_CSR3_SCBR_Msk           (0xFFu << SPI_CSR3_SCBR_Pos) /**< \brief (SPI_CSR3) Serial Clock Baud Rate */
#define SPI_CSR3_SCBR(value)        ((SPI_CSR3_SCBR_Msk & ((value) << SPI_CSR3_SCBR_Pos)))
#define SPI_CSR3_DLYBS_Pos          16
#define SPI_CSR3_DLYBS_Msk          (0xFFu << SPI_CSR3_DLYBS_Pos) /**< \brief (SPI_CSR3) Delay Before SPCK */
#define SPI_CSR3_DLYBS(value)       ((SPI_CSR3_DLYBS_Msk & ((value) << SPI_CSR3_DLYBS_Pos)))
#define SPI_CSR3_DLYBCT_Pos         24
#define SPI_CSR3_DLYBCT_Msk         (0xFFu << SPI_CSR3_DLYBCT_Pos) /**< \brief (SPI_CSR3) Delay Between Consecutive Transfers */
#define SPI_CSR3_DLYBCT(value)      ((SPI_CSR3_DLYBCT_Msk & ((value) << SPI_CSR3_DLYBCT_Pos)))
/* -------- SPI_WPCR : (SPI Offset: 0xE4) Write Protection control Register -------- */
#define SPI_WPCR_SPIWPEN            (0x1u <<  0) /**< \brief (SPI_WPCR) SPI write Protection Enable */
#define SPI_WPCR_SPIWPKEY_Pos       8
#define SPI_WPCR_SPIWPKEY_Msk       (0xFFFFFFu << SPI_WPCR_SPIWPKEY_Pos) /**< \brief (SPI_WPCR) SPI write Protection Key Password */
#define SPI_WPCR_SPIWPKEY(value)    ((SPI_WPCR_SPIWPKEY_Msk & ((value) << SPI_WPCR_SPIWPKEY_Pos)))
#define   SPI_WPCR_SPIWPKEY_VALUE   (0x535049u <<  8) /**< \brief (SPI_WPCR) SPI Write Protection Key Password */
/* -------- SPI_WPSR : (SPI Offset: 0xE8) Write Protection status Register -------- */
#define SPI_WPSR_SPIWPVS_Pos        0
#define SPI_WPSR_SPIWPVS_Msk        (0x7u << SPI_WPSR_SPIWPVS_Pos) /**< \brief (SPI_WPSR) SPI write protection Violation Status */
#define SPI_WPSR_SPIWPVS(value)     ((SPI_WPSR_SPIWPVS_Msk & ((value) << SPI_WPSR_SPIWPVS_Pos)))
#define   SPI_WPSR_SPIWPVS_WRITE_WITH_WP (0x1u <<  0) /**< \brief (SPI_WPSR) The Write Protection has blocked a Write access to a protected register (since the last read). */
#define   SPI_WPSR_SPIWPVS_SWRST_WITH_WP (0x2u <<  0) /**< \brief (SPI_WPSR) Software Reset has been performed while Write Protection was enabled (since the last read or since the last write access on MR, IER, IDR or CSRx). */
#define   SPI_WPSR_SPIWPVS_UNEXPECTED_WRITE (0x4u <<  0) /**< \brief (SPI_WPSR) Write accesses have been detected on MR (while a chip select was active) or on CSRi (while the Chip Select “i” was active) since the last read. */
#define SPI_WPSR_SPIWPVSRC_Pos      8
#define SPI_WPSR_SPIWPVSRC_Msk      (0xFFu << SPI_WPSR_SPIWPVSRC_Pos) /**< \brief (SPI_WPSR) SPI write Protection Violation source */
#define SPI_WPSR_SPIWPVSRC(value)   ((SPI_WPSR_SPIWPVSRC_Msk & ((value) << SPI_WPSR_SPIWPVSRC_Pos)))
/* -------- SPI_FEATURES : (SPI Offset: 0xF8) Features Register -------- */
#define SPI_FEATURES_NCS_Pos        0
#define SPI_FEATURES_NCS_Msk        (0xFu << SPI_FEATURES_NCS_Pos) /**< \brief (SPI_FEATURES) Number of Chip Selects */
#define SPI_FEATURES_NCS(value)     ((SPI_FEATURES_NCS_Msk & ((value) << SPI_FEATURES_NCS_Pos)))
#define SPI_FEATURES_PCONF          (0x1u <<  4) /**< \brief (SPI_FEATURES) Polarity is Configurable */
#define SPI_FEATURES_PPNCONF        (0x1u <<  5) /**< \brief (SPI_FEATURES) Polarity is Positive if Polarity is not Configurable */
#define SPI_FEATURES_PHCONF         (0x1u <<  6) /**< \brief (SPI_FEATURES) Phase is Configurable */
#define SPI_FEATURES_PHZNCONF       (0x1u <<  7) /**< \brief (SPI_FEATURES) Phase is Zero if Phase is not Configurable */
#define SPI_FEATURES_LENCONF        (0x1u <<  8) /**< \brief (SPI_FEATURES) Character Length is Configurable */
#define SPI_FEATURES_LENNCONF_Pos    9
#define SPI_FEATURES_LENNCONF_Msk    (0x7Fu << SPI_FEATURES_LENNCONF_Pos) /**< \brief (SPI_FEATURES) Character Length if not Configurable */
#define SPI_FEATURES_LENNCONF(value) ((SPI_FEATURES_LENNCONF_Msk & ((value) << SPI_FEATURES_LENNCONF_Pos)))
#define SPI_FEATURES_EXTDEC         (0x1u << 16) /**< \brief (SPI_FEATURES) External Decoder is True */
#define SPI_FEATURES_CSNAATIMPL     (0x1u << 17) /**< \brief (SPI_FEATURES) CSNAAT Features are Implemented */
#define SPI_FEATURES_BRPBHSB        (0x1u << 18) /**< \brief (SPI_FEATURES) Bridge Type is PB to HSB */
#define SPI_FEATURES_FIFORIMPL      (0x1u << 19) /**< \brief (SPI_FEATURES) FIFO in Reception is Implemented */
#define SPI_FEATURES_SWPIMPL        (0x1u << 20) /**< \brief (SPI_FEATURES) Spurious Write Protection is Implemented */
/* -------- SPI_VERSION : (SPI Offset: 0xFC) Version Register -------- */
#define SPI_VERSION_VERSION_Pos     0
#define SPI_VERSION_VERSION_Msk     (0xFFFu << SPI_VERSION_VERSION_Pos) /**< \brief (SPI_VERSION) Version */
#define SPI_VERSION_VERSION(value)  ((SPI_VERSION_VERSION_Msk & ((value) << SPI_VERSION_VERSION_Pos)))
#define SPI_VERSION_MFN_Pos         16
#define SPI_VERSION_MFN_Msk         (0x7u << SPI_VERSION_MFN_Pos) /**< \brief (SPI_VERSION) mfn */
#define SPI_VERSION_MFN(value)      ((SPI_VERSION_MFN_Msk & ((value) << SPI_VERSION_MFN_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR TC */
/* ============================================================================= */
/** \addtogroup SAM4L4_TC Timer/Counter */
/*@{*/

#define REV_TC         0x402

#ifndef __ASSEMBLY__
/** \brief TcChannel hardware registers */
typedef struct {
  WoReg   CCR;         /**< \brief (TcChannel Offset: 0x00) Channel Control Register Channel 0 */
  RwReg   CMR;         /**< \brief (TcChannel Offset: 0x04) Channel Mode Register Channel 0 */
  RwReg   SMC;         /**< \brief (TcChannel Offset: 0x08) Stepper Motor Mode Register */
  RoReg   Reserved1[1];
  RoReg   CV;          /**< \brief (TcChannel Offset: 0x10) Counter Value Channel 0 */
  RwReg   RA;          /**< \brief (TcChannel Offset: 0x14) Register A Channel 0 */
  RwReg   RB;          /**< \brief (TcChannel Offset: 0x18) Register B Channel 0 */
  RwReg   RC;          /**< \brief (TcChannel Offset: 0x1C) Register C Channel 0 */
  RoReg   SR;          /**< \brief (TcChannel Offset: 0x20) Status Register Channel 0 */
  WoReg   IER;         /**< \brief (TcChannel Offset: 0x24) Interrupt Enable Register Channel 0 */
  WoReg   IDR;         /**< \brief (TcChannel Offset: 0x28) Interrupt Disable Register Channel 0 */
  RoReg   IMR;         /**< \brief (TcChannel Offset: 0x2C) Interrupt Mask Register Channel 0 */
  RoReg   Reserved2[4];
} TcChannel;
/** \brief TC hardware registers */
typedef struct {
  TcChannel Channel[3]; /**< \brief (TC Offset: 0x00) TcChannel groups */
  WoReg   BCR;         /**< \brief (TC Offset: 0xC0) TC Block Control Register */
  RwReg   BMR;         /**< \brief (TC Offset: 0xC4) TC Block Mode Register */
  WoReg   QIER;        /**< \brief (TC Offset: 0xC8) QDEC Interrupt Enable Register */
  WoReg   QIDR;        /**< \brief (TC Offset: 0xCC) QDEC Interrupt Disable Register */
  RoReg   QIMR;        /**< \brief (TC Offset: 0xD0) QDEC Interrupt Mask Register */
  RoReg   QISR;        /**< \brief (TC Offset: 0xD4) QDEC Interrupt Status Register */
  RwReg   FMR;         /**< \brief (TC Offset: 0xD8) Fault Mode Register */
  RoReg   Reserved1[2];
  RwReg   WPMR;        /**< \brief (TC Offset: 0xE4) Write Protect Mode Register */
  RoReg   Reserved2[4];
  RoReg   FEATURES;    /**< \brief (TC Offset: 0xF8) Features Register */
  RoReg   VERSION;     /**< \brief (TC Offset: 0xFC) Version Register */
} Tc;
#endif /* __ASSEMBLY__ */
/* -------- TC_CCR : (TC Offset: 0x00) Channel Channel Control Register Channel 0 -------- */
#define TC_CCR_CLKEN                (0x1u <<  0) /**< \brief (TC_CCR) Counter Clock Enable Command */
#define   TC_CCR_CLKEN_0            (0x0u <<  0) /**< \brief (TC_CCR) No effect. */
#define   TC_CCR_CLKEN_1            (0x1u <<  0) /**< \brief (TC_CCR) Enables the clock if CLKDIS is not 1. */
#define TC_CCR_CLKDIS               (0x1u <<  1) /**< \brief (TC_CCR) Counter Clock Disable Command */
#define   TC_CCR_CLKDIS_0           (0x0u <<  1) /**< \brief (TC_CCR) No effect. */
#define   TC_CCR_CLKDIS_1           (0x1u <<  1) /**< \brief (TC_CCR) Disables the clock. */
#define TC_CCR_SWTRG                (0x1u <<  2) /**< \brief (TC_CCR) Software Trigger Command */
#define   TC_CCR_SWTRG_0            (0x0u <<  2) /**< \brief (TC_CCR) No effect. */
#define   TC_CCR_SWTRG_1            (0x1u <<  2) /**< \brief (TC_CCR) A software trigger is performed:the counter is reset and clock is started. */
/* -------- TC_CAPTURE_CMR : (TC Offset: 0x04) Channel Channel Mode Register Channel 0 -------- */
#define TC_CAPTURE_CMR_TCCLKS_Pos    0
#define TC_CAPTURE_CMR_TCCLKS_Msk    (0x7u << TC_CAPTURE_CMR_TCCLKS_Pos) /**< \brief (TC_CAPTURE_CMR) Clock Selection */
#define TC_CAPTURE_CMR_TCCLKS(value) ((TC_CAPTURE_CMR_TCCLKS_Msk & ((value) << TC_CAPTURE_CMR_TCCLKS_Pos)))
#define   TC_CAPTURE_CMR_TCCLKS_TIMER_CLOCK1 (0x0u <<  0) /**< \brief (TC_CAPTURE_CMR) TIMER_CLOCK1 */
#define   TC_CAPTURE_CMR_TCCLKS_TIMER_CLOCK2 (0x1u <<  0) /**< \brief (TC_CAPTURE_CMR) TIMER_CLOCK2 */
#define   TC_CAPTURE_CMR_TCCLKS_TIMER_CLOCK3 (0x2u <<  0) /**< \brief (TC_CAPTURE_CMR) TIMER_CLOCK3 */
#define   TC_CAPTURE_CMR_TCCLKS_TIMER_CLOCK4 (0x3u <<  0) /**< \brief (TC_CAPTURE_CMR) TIMER_CLOCK4 */
#define   TC_CAPTURE_CMR_TCCLKS_TIMER_CLOCK5 (0x4u <<  0) /**< \brief (TC_CAPTURE_CMR) TIMER_CLOCK5 */
#define   TC_CAPTURE_CMR_TCCLKS_XC0 (0x5u <<  0) /**< \brief (TC_CAPTURE_CMR) XC0 */
#define   TC_CAPTURE_CMR_TCCLKS_XC1 (0x6u <<  0) /**< \brief (TC_CAPTURE_CMR) XC1 */
#define   TC_CAPTURE_CMR_TCCLKS_XC2 (0x7u <<  0) /**< \brief (TC_CAPTURE_CMR) XC2 */
#define TC_CAPTURE_CMR_CLKI         (0x1u <<  3) /**< \brief (TC_CAPTURE_CMR) Clock Invert */
#define   TC_CAPTURE_CMR_CLKI_0     (0x0u <<  3) /**< \brief (TC_CAPTURE_CMR) Counter is incremented on rising edge of the clock. */
#define   TC_CAPTURE_CMR_CLKI_1     (0x1u <<  3) /**< \brief (TC_CAPTURE_CMR) Counter is incremented on falling edge of the clock. */
#define TC_CAPTURE_CMR_BURST_Pos    4
#define TC_CAPTURE_CMR_BURST_Msk    (0x3u << TC_CAPTURE_CMR_BURST_Pos) /**< \brief (TC_CAPTURE_CMR) Burst Signal Selection */
#define TC_CAPTURE_CMR_BURST(value) ((TC_CAPTURE_CMR_BURST_Msk & ((value) << TC_CAPTURE_CMR_BURST_Pos)))
#define   TC_CAPTURE_CMR_BURST_NOT_GATED (0x0u <<  4) /**< \brief (TC_CAPTURE_CMR) The clock is not gated by an external signal. */
#define   TC_CAPTURE_CMR_BURST_CLK_AND_XC0 (0x1u <<  4) /**< \brief (TC_CAPTURE_CMR) XC0 is ANDed with the selected clock. */
#define   TC_CAPTURE_CMR_BURST_CLK_AND_XC1 (0x2u <<  4) /**< \brief (TC_CAPTURE_CMR) XC1 is ANDed with the selected clock. */
#define   TC_CAPTURE_CMR_BURST_CLK_AND_XC2 (0x3u <<  4) /**< \brief (TC_CAPTURE_CMR) XC2 is ANDed with the selected clock. */
#define TC_CAPTURE_CMR_LDBSTOP      (0x1u <<  6) /**< \brief (TC_CAPTURE_CMR) Counter Clock Stopped with RB Loading */
#define   TC_CAPTURE_CMR_LDBSTOP_0  (0x0u <<  6) /**< \brief (TC_CAPTURE_CMR) Counter clock is not stopped when RB loading occurs. */
#define   TC_CAPTURE_CMR_LDBSTOP_1  (0x1u <<  6) /**< \brief (TC_CAPTURE_CMR) Counter clock is stopped when RB loading occurs. */
#define TC_CAPTURE_CMR_LDBDIS       (0x1u <<  7) /**< \brief (TC_CAPTURE_CMR) Counter Clock Disable with RB Loading */
#define   TC_CAPTURE_CMR_LDBDIS_0   (0x0u <<  7) /**< \brief (TC_CAPTURE_CMR) Counter clock is not disabled when RB loading occurs. */
#define   TC_CAPTURE_CMR_LDBDIS_1   (0x1u <<  7) /**< \brief (TC_CAPTURE_CMR) Counter clock is disabled when RB loading occurs. */
#define TC_CAPTURE_CMR_ETRGEDG_Pos    8
#define TC_CAPTURE_CMR_ETRGEDG_Msk    (0x3u << TC_CAPTURE_CMR_ETRGEDG_Pos) /**< \brief (TC_CAPTURE_CMR) External Trigger Edge Selection */
#define TC_CAPTURE_CMR_ETRGEDG(value) ((TC_CAPTURE_CMR_ETRGEDG_Msk & ((value) << TC_CAPTURE_CMR_ETRGEDG_Pos)))
#define   TC_CAPTURE_CMR_ETRGEDG_NO_EDGE (0x0u <<  8) /**< \brief (TC_CAPTURE_CMR) none */
#define   TC_CAPTURE_CMR_ETRGEDG_POS_EDGE (0x1u <<  8) /**< \brief (TC_CAPTURE_CMR) rising edge */
#define   TC_CAPTURE_CMR_ETRGEDG_NEG_EDGE (0x2u <<  8) /**< \brief (TC_CAPTURE_CMR) falling edge */
#define   TC_CAPTURE_CMR_ETRGEDG_BOTH_EDGES (0x3u <<  8) /**< \brief (TC_CAPTURE_CMR) each edge */
#define TC_CAPTURE_CMR_ABETRG       (0x1u << 10) /**< \brief (TC_CAPTURE_CMR) TIOA or TIOB External Trigger Selection */
#define   TC_CAPTURE_CMR_ABETRG_0   (0x0u << 10) /**< \brief (TC_CAPTURE_CMR) TIOB is used as an external trigger. */
#define   TC_CAPTURE_CMR_ABETRG_1   (0x1u << 10) /**< \brief (TC_CAPTURE_CMR) TIOA is used as an external trigger. */
#define TC_CAPTURE_CMR_CPCTRG       (0x1u << 14) /**< \brief (TC_CAPTURE_CMR) RC Compare Trigger Enable */
#define   TC_CAPTURE_CMR_CPCTRG_0   (0x0u << 14) /**< \brief (TC_CAPTURE_CMR) RC Compare has no effect on the counter and its clock. */
#define   TC_CAPTURE_CMR_CPCTRG_1   (0x1u << 14) /**< \brief (TC_CAPTURE_CMR) RC Compare resets the counter and starts the counter clock. */
#define TC_CAPTURE_CMR_WAVE         (0x1u << 15) /**< \brief (TC_CAPTURE_CMR) Wave */
#define   TC_CAPTURE_CMR_WAVE_0     (0x0u << 15) /**< \brief (TC_CAPTURE_CMR) Capture Mode is enabled. */
#define   TC_CAPTURE_CMR_WAVE_1     (0x1u << 15) /**< \brief (TC_CAPTURE_CMR) Capture Mode is disabled (Waveform Mode is enabled). */
#define TC_CAPTURE_CMR_LDRA_Pos     16
#define TC_CAPTURE_CMR_LDRA_Msk     (0x3u << TC_CAPTURE_CMR_LDRA_Pos) /**< \brief (TC_CAPTURE_CMR) RA Loading Selection */
#define TC_CAPTURE_CMR_LDRA(value)  ((TC_CAPTURE_CMR_LDRA_Msk & ((value) << TC_CAPTURE_CMR_LDRA_Pos)))
#define   TC_CAPTURE_CMR_LDRA_NO_EDGE (0x0u << 16) /**< \brief (TC_CAPTURE_CMR) none */
#define   TC_CAPTURE_CMR_LDRA_POS_EDGE_TIOA (0x1u << 16) /**< \brief (TC_CAPTURE_CMR) rising edge of TIOA */
#define   TC_CAPTURE_CMR_LDRA_NEG_EDGE_TIOA (0x2u << 16) /**< \brief (TC_CAPTURE_CMR) falling edge of TIOA */
#define   TC_CAPTURE_CMR_LDRA_BIOTH_EDGES_TIOA (0x3u << 16) /**< \brief (TC_CAPTURE_CMR) each edge of TIOA */
#define TC_CAPTURE_CMR_LDRB_Pos     18
#define TC_CAPTURE_CMR_LDRB_Msk     (0x3u << TC_CAPTURE_CMR_LDRB_Pos) /**< \brief (TC_CAPTURE_CMR) RB Loading Selection */
#define TC_CAPTURE_CMR_LDRB(value)  ((TC_CAPTURE_CMR_LDRB_Msk & ((value) << TC_CAPTURE_CMR_LDRB_Pos)))
#define   TC_CAPTURE_CMR_LDRB_NO_EDGE (0x0u << 18) /**< \brief (TC_CAPTURE_CMR) none */
#define   TC_CAPTURE_CMR_LDRB_POS_EDGE_TIOA (0x1u << 18) /**< \brief (TC_CAPTURE_CMR) rising edge of TIOA */
#define   TC_CAPTURE_CMR_LDRB_NEG_EDGE_TIOA (0x2u << 18) /**< \brief (TC_CAPTURE_CMR) falling edge of TIOA */
#define   TC_CAPTURE_CMR_LDRB_BIOTH_EDGES_TIOA (0x3u << 18) /**< \brief (TC_CAPTURE_CMR) each edge of TIOA */
/* -------- TC_WAVEFORM_CMR : (TC Offset: 0x04) Channel Channel Mode Register Channel 0 -------- */
#define TC_WAVEFORM_CMR_TCCLKS_Pos    0
#define TC_WAVEFORM_CMR_TCCLKS_Msk    (0x7u << TC_WAVEFORM_CMR_TCCLKS_Pos) /**< \brief (TC_WAVEFORM_CMR) Clock Selection */
#define TC_WAVEFORM_CMR_TCCLKS(value) ((TC_WAVEFORM_CMR_TCCLKS_Msk & ((value) << TC_WAVEFORM_CMR_TCCLKS_Pos)))
#define   TC_WAVEFORM_CMR_TCCLKS_TIMER_DIV1_CLOCK (0x0u <<  0) /**< \brief (TC_WAVEFORM_CMR) TIMER_DIV1_CLOCK */
#define   TC_WAVEFORM_CMR_TCCLKS_TIMER_DIV2_CLOCK (0x1u <<  0) /**< \brief (TC_WAVEFORM_CMR) TIMER_DIV2_CLOCK */
#define   TC_WAVEFORM_CMR_TCCLKS_TIMER_DIV3_CLOCK (0x2u <<  0) /**< \brief (TC_WAVEFORM_CMR) TIMER_DIV3_CLOCK */
#define   TC_WAVEFORM_CMR_TCCLKS_TIMER_DIV4_CLOCK (0x3u <<  0) /**< \brief (TC_WAVEFORM_CMR) TIMER_DIV4_CLOCK */
#define   TC_WAVEFORM_CMR_TCCLKS_TIMER_DIV5_CLOCK (0x4u <<  0) /**< \brief (TC_WAVEFORM_CMR) TIMER_DIV5_CLOCK */
#define   TC_WAVEFORM_CMR_TCCLKS_XC0 (0x5u <<  0) /**< \brief (TC_WAVEFORM_CMR) XC0 */
#define   TC_WAVEFORM_CMR_TCCLKS_XC1 (0x6u <<  0) /**< \brief (TC_WAVEFORM_CMR) XC1 */
#define   TC_WAVEFORM_CMR_TCCLKS_XC2 (0x7u <<  0) /**< \brief (TC_WAVEFORM_CMR) XC2 */
#define TC_WAVEFORM_CMR_CLKI        (0x1u <<  3) /**< \brief (TC_WAVEFORM_CMR) Clock Invert */
#define   TC_WAVEFORM_CMR_CLKI_0    (0x0u <<  3) /**< \brief (TC_WAVEFORM_CMR) Counter is incremented on rising edge of the clock. */
#define   TC_WAVEFORM_CMR_CLKI_1    (0x1u <<  3) /**< \brief (TC_WAVEFORM_CMR) Counter is incremented on falling edge of the clock. */
#define TC_WAVEFORM_CMR_BURST_Pos    4
#define TC_WAVEFORM_CMR_BURST_Msk    (0x3u << TC_WAVEFORM_CMR_BURST_Pos) /**< \brief (TC_WAVEFORM_CMR) Burst Signal Selection */
#define TC_WAVEFORM_CMR_BURST(value) ((TC_WAVEFORM_CMR_BURST_Msk & ((value) << TC_WAVEFORM_CMR_BURST_Pos)))
#define   TC_WAVEFORM_CMR_BURST_NOT_GATED (0x0u <<  4) /**< \brief (TC_WAVEFORM_CMR) The clock is not gated by an external signal. */
#define   TC_WAVEFORM_CMR_BURST_CLK_AND_XC0 (0x1u <<  4) /**< \brief (TC_WAVEFORM_CMR) XC0 is ANDed with the selected clock. */
#define   TC_WAVEFORM_CMR_BURST_CLK_AND_XC1 (0x2u <<  4) /**< \brief (TC_WAVEFORM_CMR) XC1 is ANDed with the selected clock. */
#define   TC_WAVEFORM_CMR_BURST_CLK_AND_XC2 (0x3u <<  4) /**< \brief (TC_WAVEFORM_CMR) XC2 is ANDed with the selected clock. */
#define TC_WAVEFORM_CMR_CPCSTOP     (0x1u <<  6) /**< \brief (TC_WAVEFORM_CMR) Counter Clock Stopped with RC Compare */
#define   TC_WAVEFORM_CMR_CPCSTOP_0 (0x0u <<  6) /**< \brief (TC_WAVEFORM_CMR) Counter clock is not stopped when counter reaches RC. */
#define   TC_WAVEFORM_CMR_CPCSTOP_1 (0x1u <<  6) /**< \brief (TC_WAVEFORM_CMR) Counter clock is stopped when counter reaches RC. */
#define TC_WAVEFORM_CMR_CPCDIS      (0x1u <<  7) /**< \brief (TC_WAVEFORM_CMR) Counter Clock Disable with RC Compare */
#define   TC_WAVEFORM_CMR_CPCDIS_0  (0x0u <<  7) /**< \brief (TC_WAVEFORM_CMR) Counter clock is not disabled when counter reaches RC. */
#define   TC_WAVEFORM_CMR_CPCDIS_1  (0x1u <<  7) /**< \brief (TC_WAVEFORM_CMR) Counter clock is disabled when counter reaches RC. */
#define TC_WAVEFORM_CMR_EEVTEDG_Pos    8
#define TC_WAVEFORM_CMR_EEVTEDG_Msk    (0x3u << TC_WAVEFORM_CMR_EEVTEDG_Pos) /**< \brief (TC_WAVEFORM_CMR) External Event Edge Selection */
#define TC_WAVEFORM_CMR_EEVTEDG(value) ((TC_WAVEFORM_CMR_EEVTEDG_Msk & ((value) << TC_WAVEFORM_CMR_EEVTEDG_Pos)))
#define   TC_WAVEFORM_CMR_EEVTEDG_NO_EDGE (0x0u <<  8) /**< \brief (TC_WAVEFORM_CMR) none */
#define   TC_WAVEFORM_CMR_EEVTEDG_POS_EDGE (0x1u <<  8) /**< \brief (TC_WAVEFORM_CMR) rising edge */
#define   TC_WAVEFORM_CMR_EEVTEDG_NEG_EDGE (0x2u <<  8) /**< \brief (TC_WAVEFORM_CMR) falling edge */
#define   TC_WAVEFORM_CMR_EEVTEDG_BOTH_EDGES (0x3u <<  8) /**< \brief (TC_WAVEFORM_CMR) each edge */
#define TC_WAVEFORM_CMR_EEVT_Pos    10
#define TC_WAVEFORM_CMR_EEVT_Msk    (0x3u << TC_WAVEFORM_CMR_EEVT_Pos) /**< \brief (TC_WAVEFORM_CMR) External Event Selection */
#define TC_WAVEFORM_CMR_EEVT(value) ((TC_WAVEFORM_CMR_EEVT_Msk & ((value) << TC_WAVEFORM_CMR_EEVT_Pos)))
#define   TC_WAVEFORM_CMR_EEVT_TIOB_INPUT (0x0u << 10) /**< \brief (TC_WAVEFORM_CMR) TIOB input. If TIOB is chosen as the external event signal, it is configured as an input and no longer generates waveforms. */
#define   TC_WAVEFORM_CMR_EEVT_XC0_OUTPUT (0x1u << 10) /**< \brief (TC_WAVEFORM_CMR) XC0 output */
#define   TC_WAVEFORM_CMR_EEVT_XC1_OUTPUT (0x2u << 10) /**< \brief (TC_WAVEFORM_CMR) XC1 output */
#define   TC_WAVEFORM_CMR_EEVT_XC2_OUTPUT (0x3u << 10) /**< \brief (TC_WAVEFORM_CMR) XC2 output */
#define TC_WAVEFORM_CMR_ENETRG      (0x1u << 12) /**< \brief (TC_WAVEFORM_CMR) External Event Trigger Enable */
#define   TC_WAVEFORM_CMR_ENETRG_0  (0x0u << 12) /**< \brief (TC_WAVEFORM_CMR) The external event has no effect on the counter and its clock. In this case, the selected external event only controls the TIOA output. */
#define   TC_WAVEFORM_CMR_ENETRG_1  (0x1u << 12) /**< \brief (TC_WAVEFORM_CMR) The external event resets the counter and starts the counter clock. */
#define TC_WAVEFORM_CMR_WAVSEL_Pos    13
#define TC_WAVEFORM_CMR_WAVSEL_Msk    (0x3u << TC_WAVEFORM_CMR_WAVSEL_Pos) /**< \brief (TC_WAVEFORM_CMR) Waveform Selection */
#define TC_WAVEFORM_CMR_WAVSEL(value) ((TC_WAVEFORM_CMR_WAVSEL_Msk & ((value) << TC_WAVEFORM_CMR_WAVSEL_Pos)))
#define   TC_WAVEFORM_CMR_WAVSEL_UP_NO_AUTO (0x0u << 13) /**< \brief (TC_WAVEFORM_CMR) UP mode without automatic trigger on RC Compare */
#define   TC_WAVEFORM_CMR_WAVSEL_UPDOWN_NO_AUTO (0x1u << 13) /**< \brief (TC_WAVEFORM_CMR) UPDOWN mode without automatic trigger on RC Compare */
#define   TC_WAVEFORM_CMR_WAVSEL_UP_AUTO (0x2u << 13) /**< \brief (TC_WAVEFORM_CMR) UP mode with automatic trigger on RC Compare */
#define   TC_WAVEFORM_CMR_WAVSEL_UPDOWN_AUTO (0x3u << 13) /**< \brief (TC_WAVEFORM_CMR) UPDOWN mode with automatic trigger on RC Compare */
#define TC_WAVEFORM_CMR_WAVE        (0x1u << 15) /**< \brief (TC_WAVEFORM_CMR) WAVE */
#define   TC_WAVEFORM_CMR_WAVE_0    (0x0u << 15) /**< \brief (TC_WAVEFORM_CMR) Waveform Mode is disabled (Capture Mode is enabled). */
#define   TC_WAVEFORM_CMR_WAVE_1    (0x1u << 15) /**< \brief (TC_WAVEFORM_CMR) Waveform Mode is enabled. */
#define TC_WAVEFORM_CMR_ACPA_Pos    16
#define TC_WAVEFORM_CMR_ACPA_Msk    (0x3u << TC_WAVEFORM_CMR_ACPA_Pos) /**< \brief (TC_WAVEFORM_CMR) RA Compare Effect on TIOA */
#define TC_WAVEFORM_CMR_ACPA(value) ((TC_WAVEFORM_CMR_ACPA_Msk & ((value) << TC_WAVEFORM_CMR_ACPA_Pos)))
#define   TC_WAVEFORM_CMR_ACPA_NONE (0x0u << 16) /**< \brief (TC_WAVEFORM_CMR) none */
#define   TC_WAVEFORM_CMR_ACPA_SET  (0x1u << 16) /**< \brief (TC_WAVEFORM_CMR) set */
#define   TC_WAVEFORM_CMR_ACPA_CLEAR (0x2u << 16) /**< \brief (TC_WAVEFORM_CMR) clear */
#define   TC_WAVEFORM_CMR_ACPA_TOGGLE (0x3u << 16) /**< \brief (TC_WAVEFORM_CMR) toggle */
#define TC_WAVEFORM_CMR_ACPC_Pos    18
#define TC_WAVEFORM_CMR_ACPC_Msk    (0x3u << TC_WAVEFORM_CMR_ACPC_Pos) /**< \brief (TC_WAVEFORM_CMR) RC Compare Effect on TIOA */
#define TC_WAVEFORM_CMR_ACPC(value) ((TC_WAVEFORM_CMR_ACPC_Msk & ((value) << TC_WAVEFORM_CMR_ACPC_Pos)))
#define   TC_WAVEFORM_CMR_ACPC_NONE (0x0u << 18) /**< \brief (TC_WAVEFORM_CMR) none */
#define   TC_WAVEFORM_CMR_ACPC_SET  (0x1u << 18) /**< \brief (TC_WAVEFORM_CMR) set */
#define   TC_WAVEFORM_CMR_ACPC_CLEAR (0x2u << 18) /**< \brief (TC_WAVEFORM_CMR) clear */
#define   TC_WAVEFORM_CMR_ACPC_TOGGLE (0x3u << 18) /**< \brief (TC_WAVEFORM_CMR) toggle */
#define TC_WAVEFORM_CMR_AEEVT_Pos    20
#define TC_WAVEFORM_CMR_AEEVT_Msk    (0x3u << TC_WAVEFORM_CMR_AEEVT_Pos) /**< \brief (TC_WAVEFORM_CMR) External Event Effect on TIOA */
#define TC_WAVEFORM_CMR_AEEVT(value) ((TC_WAVEFORM_CMR_AEEVT_Msk & ((value) << TC_WAVEFORM_CMR_AEEVT_Pos)))
#define   TC_WAVEFORM_CMR_AEEVT_NONE (0x0u << 20) /**< \brief (TC_WAVEFORM_CMR) none */
#define   TC_WAVEFORM_CMR_AEEVT_SET (0x1u << 20) /**< \brief (TC_WAVEFORM_CMR) set */
#define   TC_WAVEFORM_CMR_AEEVT_CLEAR (0x2u << 20) /**< \brief (TC_WAVEFORM_CMR) clear */
#define   TC_WAVEFORM_CMR_AEEVT_TOGGLE (0x3u << 20) /**< \brief (TC_WAVEFORM_CMR) toggle */
#define TC_WAVEFORM_CMR_ASWTRG_Pos    22
#define TC_WAVEFORM_CMR_ASWTRG_Msk    (0x3u << TC_WAVEFORM_CMR_ASWTRG_Pos) /**< \brief (TC_WAVEFORM_CMR) Software Trigger Effect on TIOA */
#define TC_WAVEFORM_CMR_ASWTRG(value) ((TC_WAVEFORM_CMR_ASWTRG_Msk & ((value) << TC_WAVEFORM_CMR_ASWTRG_Pos)))
#define   TC_WAVEFORM_CMR_ASWTRG_NONE (0x0u << 22) /**< \brief (TC_WAVEFORM_CMR) none */
#define   TC_WAVEFORM_CMR_ASWTRG_SET (0x1u << 22) /**< \brief (TC_WAVEFORM_CMR) set */
#define   TC_WAVEFORM_CMR_ASWTRG_CLEAR (0x2u << 22) /**< \brief (TC_WAVEFORM_CMR) clear */
#define   TC_WAVEFORM_CMR_ASWTRG_TOGGLE (0x3u << 22) /**< \brief (TC_WAVEFORM_CMR) toggle */
#define TC_WAVEFORM_CMR_BCPB_Pos    24
#define TC_WAVEFORM_CMR_BCPB_Msk    (0x3u << TC_WAVEFORM_CMR_BCPB_Pos) /**< \brief (TC_WAVEFORM_CMR) RB Compare Effect on TIOB */
#define TC_WAVEFORM_CMR_BCPB(value) ((TC_WAVEFORM_CMR_BCPB_Msk & ((value) << TC_WAVEFORM_CMR_BCPB_Pos)))
#define   TC_WAVEFORM_CMR_BCPB_NONE (0x0u << 24) /**< \brief (TC_WAVEFORM_CMR) none */
#define   TC_WAVEFORM_CMR_BCPB_SET  (0x1u << 24) /**< \brief (TC_WAVEFORM_CMR) set */
#define   TC_WAVEFORM_CMR_BCPB_CLEAR (0x2u << 24) /**< \brief (TC_WAVEFORM_CMR) clear */
#define   TC_WAVEFORM_CMR_BCPB_TOGGLE (0x3u << 24) /**< \brief (TC_WAVEFORM_CMR) toggle */
#define TC_WAVEFORM_CMR_BCPC_Pos    26
#define TC_WAVEFORM_CMR_BCPC_Msk    (0x3u << TC_WAVEFORM_CMR_BCPC_Pos) /**< \brief (TC_WAVEFORM_CMR) RC Compare Effect on TIOB */
#define TC_WAVEFORM_CMR_BCPC(value) ((TC_WAVEFORM_CMR_BCPC_Msk & ((value) << TC_WAVEFORM_CMR_BCPC_Pos)))
#define   TC_WAVEFORM_CMR_BCPC_NONE (0x0u << 26) /**< \brief (TC_WAVEFORM_CMR) none */
#define   TC_WAVEFORM_CMR_BCPC_SET  (0x1u << 26) /**< \brief (TC_WAVEFORM_CMR) set */
#define   TC_WAVEFORM_CMR_BCPC_CLEAR (0x2u << 26) /**< \brief (TC_WAVEFORM_CMR) clear */
#define   TC_WAVEFORM_CMR_BCPC_TOGGLE (0x3u << 26) /**< \brief (TC_WAVEFORM_CMR) toggle */
#define TC_WAVEFORM_CMR_BEEVT_Pos    28
#define TC_WAVEFORM_CMR_BEEVT_Msk    (0x3u << TC_WAVEFORM_CMR_BEEVT_Pos) /**< \brief (TC_WAVEFORM_CMR) External Event Effect on TIOB */
#define TC_WAVEFORM_CMR_BEEVT(value) ((TC_WAVEFORM_CMR_BEEVT_Msk & ((value) << TC_WAVEFORM_CMR_BEEVT_Pos)))
#define   TC_WAVEFORM_CMR_BEEVT_NONE (0x0u << 28) /**< \brief (TC_WAVEFORM_CMR) none */
#define   TC_WAVEFORM_CMR_BEEVT_SET (0x1u << 28) /**< \brief (TC_WAVEFORM_CMR) set */
#define   TC_WAVEFORM_CMR_BEEVT_CLEAR (0x2u << 28) /**< \brief (TC_WAVEFORM_CMR) clear */
#define   TC_WAVEFORM_CMR_BEEVT_TOGGLE (0x3u << 28) /**< \brief (TC_WAVEFORM_CMR) toggle */
#define TC_WAVEFORM_CMR_BSWTRG_Pos    30
#define TC_WAVEFORM_CMR_BSWTRG_Msk    (0x3u << TC_WAVEFORM_CMR_BSWTRG_Pos) /**< \brief (TC_WAVEFORM_CMR) Software Trigger Effect on TIOB */
#define TC_WAVEFORM_CMR_BSWTRG(value) ((TC_WAVEFORM_CMR_BSWTRG_Msk & ((value) << TC_WAVEFORM_CMR_BSWTRG_Pos)))
#define   TC_WAVEFORM_CMR_BSWTRG_NONE (0x0u << 30) /**< \brief (TC_WAVEFORM_CMR) none */
#define   TC_WAVEFORM_CMR_BSWTRG_SET (0x1u << 30) /**< \brief (TC_WAVEFORM_CMR) set */
#define   TC_WAVEFORM_CMR_BSWTRG_CLEAR (0x2u << 30) /**< \brief (TC_WAVEFORM_CMR) clear */
#define   TC_WAVEFORM_CMR_BSWTRG_TOGGLE (0x3u << 30) /**< \brief (TC_WAVEFORM_CMR) toggle */
/* -------- TC_SMC : (TC Offset: 0x08) Channel Stepper Motor Mode Register -------- */
#define TC_SMC_GCEN                 (0x1u <<  0) /**< \brief (TC_SMC) Gray Count Enable */
#define TC_SMC_DOWN                 (0x1u <<  1) /**< \brief (TC_SMC) Down Count */
/* -------- TC_CV : (TC Offset: 0x10) Channel Counter Value Channel 0 -------- */
#define TC_CV_CV_Pos                0
#define TC_CV_CV_Msk                (0xFFFFu << TC_CV_CV_Pos) /**< \brief (TC_CV) Counter Value */
#define TC_CV_CV(value)             ((TC_CV_CV_Msk & ((value) << TC_CV_CV_Pos)))
/* -------- TC_RA : (TC Offset: 0x14) Channel Register A Channel 0 -------- */
#define TC_RA_RA_Pos                0
#define TC_RA_RA_Msk                (0xFFFFu << TC_RA_RA_Pos) /**< \brief (TC_RA) Register A */
#define TC_RA_RA(value)             ((TC_RA_RA_Msk & ((value) << TC_RA_RA_Pos)))
/* -------- TC_RB : (TC Offset: 0x18) Channel Register B Channel 0 -------- */
#define TC_RB_RB_Pos                0
#define TC_RB_RB_Msk                (0xFFFFu << TC_RB_RB_Pos) /**< \brief (TC_RB) Register B */
#define TC_RB_RB(value)             ((TC_RB_RB_Msk & ((value) << TC_RB_RB_Pos)))
/* -------- TC_RC : (TC Offset: 0x1C) Channel Register C Channel 0 -------- */
#define TC_RC_RC_Pos                0
#define TC_RC_RC_Msk                (0xFFFFu << TC_RC_RC_Pos) /**< \brief (TC_RC) Register C */
#define TC_RC_RC(value)             ((TC_RC_RC_Msk & ((value) << TC_RC_RC_Pos)))
/* -------- TC_SR : (TC Offset: 0x20) Channel Status Register Channel 0 -------- */
#define TC_SR_COVFS                 (0x1u <<  0) /**< \brief (TC_SR) Counter Overflow Status */
#define   TC_SR_COVFS_0             (0x0u <<  0) /**< \brief (TC_SR) No counter overflow has occurred since the last read of the Status Register. */
#define   TC_SR_COVFS_1             (0x1u <<  0) /**< \brief (TC_SR) A counter overflow has occurred since the last read of the Status Register. */
#define TC_SR_LOVRS                 (0x1u <<  1) /**< \brief (TC_SR) Load Overrun Status */
#define   TC_SR_LOVRS_0             (0x0u <<  1) /**< \brief (TC_SR) Load overrun has not occurred since the last read of the Status Register or WAVE:1. */
#define   TC_SR_LOVRS_1             (0x1u <<  1) /**< \brief (TC_SR) RA or RB have been loaded at least twice without any read of the corresponding register since the last read of the StatusRegister, if WAVE:0. */
#define TC_SR_CPAS                  (0x1u <<  2) /**< \brief (TC_SR) RA Compare Status */
#define   TC_SR_CPAS_0              (0x0u <<  2) /**< \brief (TC_SR) RA Compare has not occurred since the last read of the Status Register or WAVE:0. */
#define   TC_SR_CPAS_1              (0x1u <<  2) /**< \brief (TC_SR) RA Compare has occurred since the last read of the Status Register, if WAVE:1. */
#define TC_SR_CPBS                  (0x1u <<  3) /**< \brief (TC_SR) RB Compare Status */
#define   TC_SR_CPBS_0              (0x0u <<  3) /**< \brief (TC_SR) RB Compare has not occurred since the last read of the Status Register or WAVE:0. */
#define   TC_SR_CPBS_1              (0x1u <<  3) /**< \brief (TC_SR) RB Compare has occurred since the last read of the Status Register, if WAVE:1. */
#define TC_SR_CPCS                  (0x1u <<  4) /**< \brief (TC_SR) RC Compare Status */
#define   TC_SR_CPCS_0              (0x0u <<  4) /**< \brief (TC_SR) RC Compare has not occurred since the last read of the Status Register. */
#define   TC_SR_CPCS_1              (0x1u <<  4) /**< \brief (TC_SR) RC Compare has occurred since the last read of the Status Register. */
#define TC_SR_LDRAS                 (0x1u <<  5) /**< \brief (TC_SR) RA Loading Status */
#define   TC_SR_LDRAS_0             (0x0u <<  5) /**< \brief (TC_SR) RA Load has not occurred since the last read of the Status Register or WAVE:1. */
#define   TC_SR_LDRAS_1             (0x1u <<  5) /**< \brief (TC_SR) RA Load has occurred since the last read of the Status Register, if WAVE:0. */
#define TC_SR_LDRBS                 (0x1u <<  6) /**< \brief (TC_SR) RB Loading Status */
#define   TC_SR_LDRBS_0             (0x0u <<  6) /**< \brief (TC_SR) RB Load has not occurred since the last read of the Status Register or WAVE:1. */
#define   TC_SR_LDRBS_1             (0x1u <<  6) /**< \brief (TC_SR) RB Load has occurred since the last read of the Status Register, if WAVE:0. */
#define TC_SR_ETRGS                 (0x1u <<  7) /**< \brief (TC_SR) External Trigger Status */
#define   TC_SR_ETRGS_0             (0x0u <<  7) /**< \brief (TC_SR) External trigger has not occurred since the last read of the Status Register. */
#define   TC_SR_ETRGS_1             (0x1u <<  7) /**< \brief (TC_SR) External trigger has occurred since the last read of the Status Register. */
#define TC_SR_CLKSTA                (0x1u << 16) /**< \brief (TC_SR) Clock Enabling Status */
#define   TC_SR_CLKSTA_0            (0x0u << 16) /**< \brief (TC_SR) Clock is disabled. */
#define   TC_SR_CLKSTA_1            (0x1u << 16) /**< \brief (TC_SR) Clock is enabled. */
#define TC_SR_MTIOA                 (0x1u << 17) /**< \brief (TC_SR) TIOA Mirror */
#define   TC_SR_MTIOA_0             (0x0u << 17) /**< \brief (TC_SR) TIOA is low. If WAVE:0, this means that TIOA pin is low. If WAVE:1, this means that TIOA is driven low. */
#define   TC_SR_MTIOA_1             (0x1u << 17) /**< \brief (TC_SR) TIOA is high. If WAVE:0, this means that TIOA pin is high. If WAVE:1, this means that TIOA is driven high. */
#define TC_SR_MTIOB                 (0x1u << 18) /**< \brief (TC_SR) TIOB Mirror */
#define   TC_SR_MTIOB_0             (0x0u << 18) /**< \brief (TC_SR) TIOB is low. If WAVE:0, this means that TIOB pin is low. If WAVE:1, this means that TIOB is driven low. */
#define   TC_SR_MTIOB_1             (0x1u << 18) /**< \brief (TC_SR) TIOB is high. If WAVE:0, this means that TIOB pin is high. If WAVE:1, this means that TIOB is driven high. */
/* -------- TC_IER : (TC Offset: 0x24) Channel Interrupt Enable Register Channel 0 -------- */
#define TC_IER_COVFS                (0x1u <<  0) /**< \brief (TC_IER) Counter Overflow */
#define   TC_IER_COVFS_0            (0x0u <<  0) /**< \brief (TC_IER) No effect. */
#define   TC_IER_COVFS_1            (0x1u <<  0) /**< \brief (TC_IER) Enables the Counter Overflow Interrupt. */
#define TC_IER_LOVRS                (0x1u <<  1) /**< \brief (TC_IER) Load Overrun */
#define   TC_IER_LOVRS_0            (0x0u <<  1) /**< \brief (TC_IER) No effect. */
#define   TC_IER_LOVRS_1            (0x1u <<  1) /**< \brief (TC_IER) Enables the Load Overrun Interrupt. */
#define TC_IER_CPAS                 (0x1u <<  2) /**< \brief (TC_IER) RA Compare */
#define   TC_IER_CPAS_0             (0x0u <<  2) /**< \brief (TC_IER) No effect. */
#define   TC_IER_CPAS_1             (0x1u <<  2) /**< \brief (TC_IER) Enables the RA Compare Interrupt. */
#define TC_IER_CPBS                 (0x1u <<  3) /**< \brief (TC_IER) RB Compare */
#define   TC_IER_CPBS_0             (0x0u <<  3) /**< \brief (TC_IER) No effect. */
#define   TC_IER_CPBS_1             (0x1u <<  3) /**< \brief (TC_IER) Enables the RB Compare Interrupt. */
#define TC_IER_CPCS                 (0x1u <<  4) /**< \brief (TC_IER) RC Compare */
#define   TC_IER_CPCS_0             (0x0u <<  4) /**< \brief (TC_IER) No effect. */
#define   TC_IER_CPCS_1             (0x1u <<  4) /**< \brief (TC_IER) Enables the RC Compare Interrupt. */
#define TC_IER_LDRAS                (0x1u <<  5) /**< \brief (TC_IER) RA Loading */
#define   TC_IER_LDRAS_0            (0x0u <<  5) /**< \brief (TC_IER) No effect. */
#define   TC_IER_LDRAS_1            (0x1u <<  5) /**< \brief (TC_IER) Enables the RA Load Interrupt. */
#define TC_IER_LDRBS                (0x1u <<  6) /**< \brief (TC_IER) RB Loading */
#define   TC_IER_LDRBS_0            (0x0u <<  6) /**< \brief (TC_IER) No effect. */
#define   TC_IER_LDRBS_1            (0x1u <<  6) /**< \brief (TC_IER) Enables the RB Load Interrupt. */
#define TC_IER_ETRGS                (0x1u <<  7) /**< \brief (TC_IER) External Trigger */
#define   TC_IER_ETRGS_0            (0x0u <<  7) /**< \brief (TC_IER) No effect. */
#define   TC_IER_ETRGS_1            (0x1u <<  7) /**< \brief (TC_IER) Enables the External Trigger Interrupt. */
/* -------- TC_IDR : (TC Offset: 0x28) Channel Interrupt Disable Register Channel 0 -------- */
#define TC_IDR_COVFS                (0x1u <<  0) /**< \brief (TC_IDR) Counter Overflow */
#define   TC_IDR_COVFS_0            (0x0u <<  0) /**< \brief (TC_IDR) No effect. */
#define   TC_IDR_COVFS_1            (0x1u <<  0) /**< \brief (TC_IDR) Disables the Counter Overflow Interrupt. */
#define TC_IDR_LOVRS                (0x1u <<  1) /**< \brief (TC_IDR) Load Overrun */
#define   TC_IDR_LOVRS_0            (0x0u <<  1) /**< \brief (TC_IDR) No effect. */
#define   TC_IDR_LOVRS_1            (0x1u <<  1) /**< \brief (TC_IDR) Disables the Load Overrun Interrupt (if WAVE:0). */
#define TC_IDR_CPAS                 (0x1u <<  2) /**< \brief (TC_IDR) RA Compare */
#define   TC_IDR_CPAS_0             (0x0u <<  2) /**< \brief (TC_IDR) No effect. */
#define   TC_IDR_CPAS_1             (0x1u <<  2) /**< \brief (TC_IDR) Disables the RA Compare Interrupt (if WAVE:1). */
#define TC_IDR_CPBS                 (0x1u <<  3) /**< \brief (TC_IDR) RB Compare */
#define   TC_IDR_CPBS_0             (0x0u <<  3) /**< \brief (TC_IDR) No effect. */
#define   TC_IDR_CPBS_1             (0x1u <<  3) /**< \brief (TC_IDR) Disables the RB Compare Interrupt (if WAVE:1). */
#define TC_IDR_CPCS                 (0x1u <<  4) /**< \brief (TC_IDR) RC Compare */
#define   TC_IDR_CPCS_0             (0x0u <<  4) /**< \brief (TC_IDR) No effect. */
#define   TC_IDR_CPCS_1             (0x1u <<  4) /**< \brief (TC_IDR) Disables the RC Compare Interrupt. */
#define TC_IDR_LDRAS                (0x1u <<  5) /**< \brief (TC_IDR) RA Loading */
#define   TC_IDR_LDRAS_0            (0x0u <<  5) /**< \brief (TC_IDR) No effect. */
#define   TC_IDR_LDRAS_1            (0x1u <<  5) /**< \brief (TC_IDR) Disables the RA Load Interrupt (if WAVE:0). */
#define TC_IDR_LDRBS                (0x1u <<  6) /**< \brief (TC_IDR) RB Loading */
#define   TC_IDR_LDRBS_0            (0x0u <<  6) /**< \brief (TC_IDR) No effect. */
#define   TC_IDR_LDRBS_1            (0x1u <<  6) /**< \brief (TC_IDR) Disables the RB Load Interrupt (if WAVE:0). */
#define TC_IDR_ETRGS                (0x1u <<  7) /**< \brief (TC_IDR) External Trigger */
#define   TC_IDR_ETRGS_0            (0x0u <<  7) /**< \brief (TC_IDR) No effect. */
#define   TC_IDR_ETRGS_1            (0x1u <<  7) /**< \brief (TC_IDR) Disables the External Trigger Interrupt. */
/* -------- TC_IMR : (TC Offset: 0x2C) Channel Interrupt Mask Register Channel 0 -------- */
#define TC_IMR_COVFS                (0x1u <<  0) /**< \brief (TC_IMR) Counter Overflow */
#define   TC_IMR_COVFS_0            (0x0u <<  0) /**< \brief (TC_IMR) The Counter Overflow Interrupt is disabled. */
#define   TC_IMR_COVFS_1            (0x1u <<  0) /**< \brief (TC_IMR) The Counter Overflow Interrupt is enabled. */
#define TC_IMR_LOVRS                (0x1u <<  1) /**< \brief (TC_IMR) Load Overrun */
#define   TC_IMR_LOVRS_0            (0x0u <<  1) /**< \brief (TC_IMR) The Load Overrun Interrupt is disabled. */
#define   TC_IMR_LOVRS_1            (0x1u <<  1) /**< \brief (TC_IMR) The Load Overrun Interrupt is enabled. */
#define TC_IMR_CPAS                 (0x1u <<  2) /**< \brief (TC_IMR) RA Compare */
#define   TC_IMR_CPAS_0             (0x0u <<  2) /**< \brief (TC_IMR) The RA Compare Interrupt is disabled. */
#define   TC_IMR_CPAS_1             (0x1u <<  2) /**< \brief (TC_IMR) The RA Compare Interrupt is enabled. */
#define TC_IMR_CPBS                 (0x1u <<  3) /**< \brief (TC_IMR) RB Compare */
#define   TC_IMR_CPBS_0             (0x0u <<  3) /**< \brief (TC_IMR) The RB Compare Interrupt is disabled. */
#define   TC_IMR_CPBS_1             (0x1u <<  3) /**< \brief (TC_IMR) The RB Compare Interrupt is enabled. */
#define TC_IMR_CPCS                 (0x1u <<  4) /**< \brief (TC_IMR) RC Compare */
#define   TC_IMR_CPCS_0             (0x0u <<  4) /**< \brief (TC_IMR) The RC Compare Interrupt is disabled. */
#define   TC_IMR_CPCS_1             (0x1u <<  4) /**< \brief (TC_IMR) The RC Compare Interrupt is enabled. */
#define TC_IMR_LDRAS                (0x1u <<  5) /**< \brief (TC_IMR) RA Loading */
#define   TC_IMR_LDRAS_0            (0x0u <<  5) /**< \brief (TC_IMR) The Load RA Interrupt is disabled. */
#define   TC_IMR_LDRAS_1            (0x1u <<  5) /**< \brief (TC_IMR) The Load RA Interrupt is enabled. */
#define TC_IMR_LDRBS                (0x1u <<  6) /**< \brief (TC_IMR) RB Loading */
#define   TC_IMR_LDRBS_0            (0x0u <<  6) /**< \brief (TC_IMR) The Load RB Interrupt is disabled. */
#define   TC_IMR_LDRBS_1            (0x1u <<  6) /**< \brief (TC_IMR) The Load RB Interrupt is enabled. */
#define TC_IMR_ETRGS                (0x1u <<  7) /**< \brief (TC_IMR) External Trigger */
#define   TC_IMR_ETRGS_0            (0x0u <<  7) /**< \brief (TC_IMR) The External Trigger Interrupt is disabled. */
#define   TC_IMR_ETRGS_1            (0x1u <<  7) /**< \brief (TC_IMR) The External Trigger Interrupt is enabled. */
/* -------- TC_BCR : (TC Offset: 0xC0) TC Block Control Register -------- */
#define TC_BCR_SYNC                 (0x1u <<  0) /**< \brief (TC_BCR) Synchro Command */
#define   TC_BCR_SYNC_0             (0x0u <<  0) /**< \brief (TC_BCR) No effect. */
#define   TC_BCR_SYNC_1             (0x1u <<  0) /**< \brief (TC_BCR) Asserts the SYNC signal which generates a software trigger simultaneously for each of the channels. */
/* -------- TC_BMR : (TC Offset: 0xC4) TC Block Mode Register -------- */
#define TC_BMR_TC0XC0S_Pos          0
#define TC_BMR_TC0XC0S_Msk          (0x3u << TC_BMR_TC0XC0S_Pos) /**< \brief (TC_BMR) External Clock Signal 0 Selection */
#define TC_BMR_TC0XC0S(value)       ((TC_BMR_TC0XC0S_Msk & ((value) << TC_BMR_TC0XC0S_Pos)))
#define   TC_BMR_TC0XC0S_TCLK0      (0x0u <<  0) /**< \brief (TC_BMR) Select TCLK0 as clock signal 0. */
#define   TC_BMR_TC0XC0S_NO_CLK     (0x1u <<  0) /**< \brief (TC_BMR) Select no clock as clock signal 0. */
#define   TC_BMR_TC0XC0S_TIOA1      (0x2u <<  0) /**< \brief (TC_BMR) Select TIOA1 as clock signal 0. */
#define   TC_BMR_TC0XC0S_TIOA2      (0x3u <<  0) /**< \brief (TC_BMR) Select TIOA2 as clock signal 0. */
#define TC_BMR_TC1XC1S_Pos          2
#define TC_BMR_TC1XC1S_Msk          (0x3u << TC_BMR_TC1XC1S_Pos) /**< \brief (TC_BMR) External Clock Signal 1 Selection */
#define TC_BMR_TC1XC1S(value)       ((TC_BMR_TC1XC1S_Msk & ((value) << TC_BMR_TC1XC1S_Pos)))
#define   TC_BMR_TC1XC1S_TCLK1      (0x0u <<  2) /**< \brief (TC_BMR) Select TCLK1 as clock signal 1. */
#define   TC_BMR_TC1XC1S_NO_CLK     (0x1u <<  2) /**< \brief (TC_BMR) Select no clock as clock signal 1. */
#define   TC_BMR_TC1XC1S_TIOA0      (0x2u <<  2) /**< \brief (TC_BMR) Select TIOA0 as clock signal 1. */
#define   TC_BMR_TC1XC1S_TIOA2      (0x3u <<  2) /**< \brief (TC_BMR) Select TIOA2 as clock signal 1. */
#define TC_BMR_TC2XC2S_Pos          4
#define TC_BMR_TC2XC2S_Msk          (0x3u << TC_BMR_TC2XC2S_Pos) /**< \brief (TC_BMR) External Clock Signal 2 Selection */
#define TC_BMR_TC2XC2S(value)       ((TC_BMR_TC2XC2S_Msk & ((value) << TC_BMR_TC2XC2S_Pos)))
#define   TC_BMR_TC2XC2S_TCLK2      (0x0u <<  4) /**< \brief (TC_BMR) Select TCLK2 as clock signal 2. */
#define   TC_BMR_TC2XC2S_NO_CLK     (0x1u <<  4) /**< \brief (TC_BMR) Select no clock as clock signal 2. */
#define   TC_BMR_TC2XC2S_TIOA0      (0x2u <<  4) /**< \brief (TC_BMR) Select TIOA0 as clock signal 2. */
#define   TC_BMR_TC2XC2S_TIOA1      (0x3u <<  4) /**< \brief (TC_BMR) Select TIOA1 as clock signal 2. */
/* -------- TC_QIER : (TC Offset: 0xC8) QDEC Interrupt Enable Register -------- */
#define TC_QIER_IDX                 (0x1u <<  0) /**< \brief (TC_QIER) IDX Rising Edge */
#define TC_QIER_DIRCHG              (0x1u <<  1) /**< \brief (TC_QIER) Direction Change */
#define TC_QIER_QERR                (0x1u <<  2) /**< \brief (TC_QIER) Quadrature Error */
/* -------- TC_QIDR : (TC Offset: 0xCC) QDEC Interrupt Disable Register -------- */
#define TC_QIDR_IDX                 (0x1u <<  0) /**< \brief (TC_QIDR) IDX Rising Edge */
#define TC_QIDR_DIRCHG              (0x1u <<  1) /**< \brief (TC_QIDR) Direction Change */
#define TC_QIDR_QERR                (0x1u <<  2) /**< \brief (TC_QIDR) Quadrature Error */
/* -------- TC_QIMR : (TC Offset: 0xD0) QDEC Interrupt Mask Register -------- */
#define TC_QIMR_IDX                 (0x1u <<  0) /**< \brief (TC_QIMR) IDX Rising Edge */
#define TC_QIMR_DIRCHG              (0x1u <<  1) /**< \brief (TC_QIMR) Direction Change */
#define TC_QIMR_QERR                (0x1u <<  2) /**< \brief (TC_QIMR) Quadrature Error */
/* -------- TC_QISR : (TC Offset: 0xD4) QDEC Interrupt Status Register -------- */
#define TC_QISR_IDX                 (0x1u <<  0) /**< \brief (TC_QISR) IDX Rising Edge */
#define TC_QISR_DIRCHG              (0x1u <<  1) /**< \brief (TC_QISR) Direction Change */
#define TC_QISR_QERR                (0x1u <<  2) /**< \brief (TC_QISR) Quadrature Error */
/* -------- TC_FMR : (TC Offset: 0xD8) Fault Mode Register -------- */
#define TC_FMR_ENCF0                (0x1u <<  0) /**< \brief (TC_FMR) Enable Compare Fault Channel 0 */
#define TC_FMR_ENCF1                (0x1u <<  1) /**< \brief (TC_FMR) Enable Compare Fault Channel 1 */
/* -------- TC_WPMR : (TC Offset: 0xE4) Write Protect Mode Register -------- */
#define TC_WPMR_WPEN                (0x1u <<  0) /**< \brief (TC_WPMR) Write Protect Enable */
#define TC_WPMR_WPKEY_Pos           8
#define TC_WPMR_WPKEY_Msk           (0xFFFFFFu << TC_WPMR_WPKEY_Pos) /**< \brief (TC_WPMR) Write Protect Key */
#define TC_WPMR_WPKEY(value)        ((TC_WPMR_WPKEY_Msk & ((value) << TC_WPMR_WPKEY_Pos)))
/* -------- TC_FEATURES : (TC Offset: 0xF8) Features Register -------- */
#define TC_FEATURES_CTRSIZE_Pos     0
#define TC_FEATURES_CTRSIZE_Msk     (0xFFu << TC_FEATURES_CTRSIZE_Pos) /**< \brief (TC_FEATURES) Counter Size */
#define TC_FEATURES_CTRSIZE(value)  ((TC_FEATURES_CTRSIZE_Msk & ((value) << TC_FEATURES_CTRSIZE_Pos)))
#define TC_FEATURES_UPDNIMPL        (0x1u <<  8) /**< \brief (TC_FEATURES) Up Down is Implemented */
#define TC_FEATURES_BRPBHSB         (0x1u <<  9) /**< \brief (TC_FEATURES) Bridge Type is PB to HSB */
/* -------- TC_VERSION : (TC Offset: 0xFC) Version Register -------- */
#define TC_VERSION_VERSION_Pos      0
#define TC_VERSION_VERSION_Msk      (0xFFFu << TC_VERSION_VERSION_Pos) /**< \brief (TC_VERSION) Reserved. Value subject to change. No functionality associated. This is the Atmel internal version of the macrocell. */
#define TC_VERSION_VERSION(value)   ((TC_VERSION_VERSION_Msk & ((value) << TC_VERSION_VERSION_Pos)))
#define TC_VERSION_VARIANT_Pos      16
#define TC_VERSION_VARIANT_Msk      (0xFu << TC_VERSION_VARIANT_Pos) /**< \brief (TC_VERSION) Reserved.  Value subject to change.  No functionality associated. */
#define TC_VERSION_VARIANT(value)   ((TC_VERSION_VARIANT_Msk & ((value) << TC_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR TRNG */
/* ============================================================================= */
/** \addtogroup SAM4L4_TRNG True Random Number Generator */
/*@{*/

#define REV_TRNG       0x103

#ifndef __ASSEMBLY__
/** \brief TRNG hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (TRNG Offset: 0x00) Control Register */
  RoReg   Reserved1[3];
  WoReg   IER;         /**< \brief (TRNG Offset: 0x10) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (TRNG Offset: 0x14) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (TRNG Offset: 0x18) Interrupt Mask Register */
  RoReg   ISR;         /**< \brief (TRNG Offset: 0x1C) Interrupt Status Register */
  RoReg   Reserved2[12];
  RoReg   ODATA;       /**< \brief (TRNG Offset: 0x50) Output Data Register */
  RoReg   Reserved3[42];
  RoReg   VERSION;     /**< \brief (TRNG Offset: 0xFC) Version Register */
} Trng;
#endif /* __ASSEMBLY__ */
/* -------- TRNG_CR : (TRNG Offset: 0x00) Control Register -------- */
#define TRNG_CR_ENABLE              (0x1u <<  0) /**< \brief (TRNG_CR) Enables the TRNG to provide random values */
#define TRNG_CR_KEY_Pos             8
#define TRNG_CR_KEY_Msk             (0xFFFFFFu << TRNG_CR_KEY_Pos) /**< \brief (TRNG_CR) Security Key */
#define TRNG_CR_KEY(value)          ((TRNG_CR_KEY_Msk & ((value) << TRNG_CR_KEY_Pos)))
/* -------- TRNG_IER : (TRNG Offset: 0x10) Interrupt Enable Register -------- */
#define TRNG_IER_DATRDY             (0x1u <<  0) /**< \brief (TRNG_IER) Data Ready Interrupt Enable */
/* -------- TRNG_IDR : (TRNG Offset: 0x14) Interrupt Disable Register -------- */
#define TRNG_IDR_DATRDY             (0x1u <<  0) /**< \brief (TRNG_IDR) Data Ready Interrupt Disable */
/* -------- TRNG_IMR : (TRNG Offset: 0x18) Interrupt Mask Register -------- */
#define TRNG_IMR_DATRDY             (0x1u <<  0) /**< \brief (TRNG_IMR) Data Ready Interrupt Mask */
/* -------- TRNG_ISR : (TRNG Offset: 0x1C) Interrupt Status Register -------- */
#define TRNG_ISR_DATRDY             (0x1u <<  0) /**< \brief (TRNG_ISR) Data Ready Interrupt Status */
/* -------- TRNG_ODATA : (TRNG Offset: 0x50) Output Data Register -------- */
#define TRNG_ODATA_ODATA            (0x1u <<  0) /**< \brief (TRNG_ODATA) Output Data */
/* -------- TRNG_VERSION : (TRNG Offset: 0xFC) Version Register -------- */
#define TRNG_VERSION_VERSION_Pos    0
#define TRNG_VERSION_VERSION_Msk    (0xFFFu << TRNG_VERSION_VERSION_Pos) /**< \brief (TRNG_VERSION) Version Number */
#define TRNG_VERSION_VERSION(value) ((TRNG_VERSION_VERSION_Msk & ((value) << TRNG_VERSION_VERSION_Pos)))
#define TRNG_VERSION_VARIANT_Pos    16
#define TRNG_VERSION_VARIANT_Msk    (0x7u << TRNG_VERSION_VARIANT_Pos) /**< \brief (TRNG_VERSION) Variant Number */
#define TRNG_VERSION_VARIANT(value) ((TRNG_VERSION_VARIANT_Msk & ((value) << TRNG_VERSION_VARIANT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR TWIM */
/* ============================================================================= */
/** \addtogroup SAM4L4_TWIM Two-wire Master Interface */
/*@{*/

#define REV_TWIM       0x120

#ifndef __ASSEMBLY__
/** \brief TWIM hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (TWIM Offset: 0x00) Control Register */
  RwReg   CWGR;        /**< \brief (TWIM Offset: 0x04) Clock Waveform Generator Register */
  RwReg   SMBTR;       /**< \brief (TWIM Offset: 0x08) SMBus Timing Register */
  RwReg   CMDR;        /**< \brief (TWIM Offset: 0x0C) Command Register */
  RwReg   NCMDR;       /**< \brief (TWIM Offset: 0x10) Next Command Register */
  RoReg   RHR;         /**< \brief (TWIM Offset: 0x14) Receive Holding Register */
  WoReg   THR;         /**< \brief (TWIM Offset: 0x18) Transmit Holding Register */
  RoReg   SR;          /**< \brief (TWIM Offset: 0x1C) Status Register */
  WoReg   IER;         /**< \brief (TWIM Offset: 0x20) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (TWIM Offset: 0x24) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (TWIM Offset: 0x28) Interrupt Mask Register */
  WoReg   SCR;         /**< \brief (TWIM Offset: 0x2C) Status Clear Register */
  RoReg   PR;          /**< \brief (TWIM Offset: 0x30) Parameter Register */
  RoReg   VR;          /**< \brief (TWIM Offset: 0x34) Version Register */
  RwReg   HSCWGR;      /**< \brief (TWIM Offset: 0x38) HS-mode Clock Waveform Generator */
  RwReg   SRR;         /**< \brief (TWIM Offset: 0x3C) Slew Rate Register */
  RwReg   HSSRR;       /**< \brief (TWIM Offset: 0x40) HS-mode Slew Rate Register */
} Twim;
#endif /* __ASSEMBLY__ */
/* -------- TWIM_CR : (TWIM Offset: 0x00) Control Register -------- */
#define TWIM_CR_MEN                 (0x1u <<  0) /**< \brief (TWIM_CR) Master Enable */
#define TWIM_CR_MDIS                (0x1u <<  1) /**< \brief (TWIM_CR) Master Disable */
#define TWIM_CR_SMEN                (0x1u <<  4) /**< \brief (TWIM_CR) SMBus Enable */
#define TWIM_CR_SMDIS               (0x1u <<  5) /**< \brief (TWIM_CR) SMBus Disable */
#define TWIM_CR_SWRST               (0x1u <<  7) /**< \brief (TWIM_CR) Software Reset */
#define TWIM_CR_STOP                (0x1u <<  8) /**< \brief (TWIM_CR) Stop the current transfer */
/* -------- TWIM_CWGR : (TWIM Offset: 0x04) Clock Waveform Generator Register -------- */
#define TWIM_CWGR_LOW_Pos           0
#define TWIM_CWGR_LOW_Msk           (0xFFu << TWIM_CWGR_LOW_Pos) /**< \brief (TWIM_CWGR) Clock Low Cycles */
#define TWIM_CWGR_LOW(value)        ((TWIM_CWGR_LOW_Msk & ((value) << TWIM_CWGR_LOW_Pos)))
#define TWIM_CWGR_HIGH_Pos          8
#define TWIM_CWGR_HIGH_Msk          (0xFFu << TWIM_CWGR_HIGH_Pos) /**< \brief (TWIM_CWGR) Clock High Cycles */
#define TWIM_CWGR_HIGH(value)       ((TWIM_CWGR_HIGH_Msk & ((value) << TWIM_CWGR_HIGH_Pos)))
#define TWIM_CWGR_STASTO_Pos        16
#define TWIM_CWGR_STASTO_Msk        (0xFFu << TWIM_CWGR_STASTO_Pos) /**< \brief (TWIM_CWGR) START and STOP Cycles */
#define TWIM_CWGR_STASTO(value)     ((TWIM_CWGR_STASTO_Msk & ((value) << TWIM_CWGR_STASTO_Pos)))
#define TWIM_CWGR_DATA_Pos          24
#define TWIM_CWGR_DATA_Msk          (0xFu << TWIM_CWGR_DATA_Pos) /**< \brief (TWIM_CWGR) Data Setup and Hold Cycles */
#define TWIM_CWGR_DATA(value)       ((TWIM_CWGR_DATA_Msk & ((value) << TWIM_CWGR_DATA_Pos)))
#define TWIM_CWGR_EXP_Pos           28
#define TWIM_CWGR_EXP_Msk           (0x7u << TWIM_CWGR_EXP_Pos) /**< \brief (TWIM_CWGR) Clock Prescaler */
#define TWIM_CWGR_EXP(value)        ((TWIM_CWGR_EXP_Msk & ((value) << TWIM_CWGR_EXP_Pos)))
/* -------- TWIM_SMBTR : (TWIM Offset: 0x08) SMBus Timing Register -------- */
#define TWIM_SMBTR_TLOWS_Pos        0
#define TWIM_SMBTR_TLOWS_Msk        (0xFFu << TWIM_SMBTR_TLOWS_Pos) /**< \brief (TWIM_SMBTR) Slave Clock stretch maximum cycles */
#define TWIM_SMBTR_TLOWS(value)     ((TWIM_SMBTR_TLOWS_Msk & ((value) << TWIM_SMBTR_TLOWS_Pos)))
#define TWIM_SMBTR_TLOWM_Pos        8
#define TWIM_SMBTR_TLOWM_Msk        (0xFFu << TWIM_SMBTR_TLOWM_Pos) /**< \brief (TWIM_SMBTR) Master Clock stretch maximum cycles */
#define TWIM_SMBTR_TLOWM(value)     ((TWIM_SMBTR_TLOWM_Msk & ((value) << TWIM_SMBTR_TLOWM_Pos)))
#define TWIM_SMBTR_THMAX_Pos        16
#define TWIM_SMBTR_THMAX_Msk        (0xFFu << TWIM_SMBTR_THMAX_Pos) /**< \brief (TWIM_SMBTR) Clock High maximum cycles */
#define TWIM_SMBTR_THMAX(value)     ((TWIM_SMBTR_THMAX_Msk & ((value) << TWIM_SMBTR_THMAX_Pos)))
#define TWIM_SMBTR_EXP_Pos          28
#define TWIM_SMBTR_EXP_Msk          (0xFu << TWIM_SMBTR_EXP_Pos) /**< \brief (TWIM_SMBTR) SMBus Timeout Clock prescaler */
#define TWIM_SMBTR_EXP(value)       ((TWIM_SMBTR_EXP_Msk & ((value) << TWIM_SMBTR_EXP_Pos)))
/* -------- TWIM_CMDR : (TWIM Offset: 0x0C) Command Register -------- */
#define TWIM_CMDR_READ              (0x1u <<  0) /**< \brief (TWIM_CMDR) Transfer Direction */
#define TWIM_CMDR_SADR_Pos          1
#define TWIM_CMDR_SADR_Msk          (0x3FFu << TWIM_CMDR_SADR_Pos) /**< \brief (TWIM_CMDR) Slave Address */
#define TWIM_CMDR_SADR(value)       ((TWIM_CMDR_SADR_Msk & ((value) << TWIM_CMDR_SADR_Pos)))
#define TWIM_CMDR_TENBIT            (0x1u << 11) /**< \brief (TWIM_CMDR) Ten Bit Addressing Mode */
#define TWIM_CMDR_REPSAME           (0x1u << 12) /**< \brief (TWIM_CMDR) Transfer is to same address as previous address */
#define TWIM_CMDR_START             (0x1u << 13) /**< \brief (TWIM_CMDR) Send START condition */
#define TWIM_CMDR_STOP              (0x1u << 14) /**< \brief (TWIM_CMDR) Send STOP condition */
#define TWIM_CMDR_VALID             (0x1u << 15) /**< \brief (TWIM_CMDR) CMDR Valid */
#define TWIM_CMDR_NBYTES_Pos        16
#define TWIM_CMDR_NBYTES_Msk        (0xFFu << TWIM_CMDR_NBYTES_Pos) /**< \brief (TWIM_CMDR) Number of data bytes in transfer */
#define TWIM_CMDR_NBYTES(value)     ((TWIM_CMDR_NBYTES_Msk & ((value) << TWIM_CMDR_NBYTES_Pos)))
#define TWIM_CMDR_PECEN             (0x1u << 24) /**< \brief (TWIM_CMDR) Packet Error Checking Enable */
#define TWIM_CMDR_ACKLAST           (0x1u << 25) /**< \brief (TWIM_CMDR) ACK Last Master RX Byte */
#define TWIM_CMDR_HS                (0x1u << 26) /**< \brief (TWIM_CMDR) HS-mode */
#define TWIM_CMDR_HSMCODE_Pos       28
#define TWIM_CMDR_HSMCODE_Msk       (0x7u << TWIM_CMDR_HSMCODE_Pos) /**< \brief (TWIM_CMDR) HS-mode Master Code */
#define TWIM_CMDR_HSMCODE(value)    ((TWIM_CMDR_HSMCODE_Msk & ((value) << TWIM_CMDR_HSMCODE_Pos)))
/* -------- TWIM_NCMDR : (TWIM Offset: 0x10) Next Command Register -------- */
#define TWIM_NCMDR_READ             (0x1u <<  0) /**< \brief (TWIM_NCMDR) Transfer Direction */
#define TWIM_NCMDR_SADR_Pos         1
#define TWIM_NCMDR_SADR_Msk         (0x3FFu << TWIM_NCMDR_SADR_Pos) /**< \brief (TWIM_NCMDR) Slave Address */
#define TWIM_NCMDR_SADR(value)      ((TWIM_NCMDR_SADR_Msk & ((value) << TWIM_NCMDR_SADR_Pos)))
#define TWIM_NCMDR_TENBIT           (0x1u << 11) /**< \brief (TWIM_NCMDR) Ten Bit Addressing Mode */
#define TWIM_NCMDR_REPSAME          (0x1u << 12) /**< \brief (TWIM_NCMDR) Transfer is to same address as previous address */
#define TWIM_NCMDR_START            (0x1u << 13) /**< \brief (TWIM_NCMDR) Send START condition */
#define TWIM_NCMDR_STOP             (0x1u << 14) /**< \brief (TWIM_NCMDR) Send STOP condition */
#define TWIM_NCMDR_VALID            (0x1u << 15) /**< \brief (TWIM_NCMDR) CMDR Valid */
#define TWIM_NCMDR_NBYTES_Pos       16
#define TWIM_NCMDR_NBYTES_Msk       (0xFFu << TWIM_NCMDR_NBYTES_Pos) /**< \brief (TWIM_NCMDR) Number of data bytes in transfer */
#define TWIM_NCMDR_NBYTES(value)    ((TWIM_NCMDR_NBYTES_Msk & ((value) << TWIM_NCMDR_NBYTES_Pos)))
#define TWIM_NCMDR_PECEN            (0x1u << 24) /**< \brief (TWIM_NCMDR) Packet Error Checking Enable */
#define TWIM_NCMDR_ACKLAST          (0x1u << 25) /**< \brief (TWIM_NCMDR) ACK Last Master RX Byte */
#define TWIM_NCMDR_HS               (0x1u << 26) /**< \brief (TWIM_NCMDR) HS-mode */
#define TWIM_NCMDR_HSMCODE_Pos      28
#define TWIM_NCMDR_HSMCODE_Msk      (0x7u << TWIM_NCMDR_HSMCODE_Pos) /**< \brief (TWIM_NCMDR) HS-mode Master Code */
#define TWIM_NCMDR_HSMCODE(value)   ((TWIM_NCMDR_HSMCODE_Msk & ((value) << TWIM_NCMDR_HSMCODE_Pos)))
/* -------- TWIM_RHR : (TWIM Offset: 0x14) Receive Holding Register -------- */
#define TWIM_RHR_RXDATA_Pos         0
#define TWIM_RHR_RXDATA_Msk         (0xFFu << TWIM_RHR_RXDATA_Pos) /**< \brief (TWIM_RHR) Received Data */
#define TWIM_RHR_RXDATA(value)      ((TWIM_RHR_RXDATA_Msk & ((value) << TWIM_RHR_RXDATA_Pos)))
/* -------- TWIM_THR : (TWIM Offset: 0x18) Transmit Holding Register -------- */
#define TWIM_THR_TXDATA_Pos         0
#define TWIM_THR_TXDATA_Msk         (0xFFu << TWIM_THR_TXDATA_Pos) /**< \brief (TWIM_THR) Data to Transmit */
#define TWIM_THR_TXDATA(value)      ((TWIM_THR_TXDATA_Msk & ((value) << TWIM_THR_TXDATA_Pos)))
/* -------- TWIM_SR : (TWIM Offset: 0x1C) Status Register -------- */
#define TWIM_SR_RXRDY               (0x1u <<  0) /**< \brief (TWIM_SR) RHR Data Ready */
#define TWIM_SR_TXRDY               (0x1u <<  1) /**< \brief (TWIM_SR) THR Data Ready */
#define TWIM_SR_CRDY                (0x1u <<  2) /**< \brief (TWIM_SR) Ready for More Commands */
#define TWIM_SR_CCOMP               (0x1u <<  3) /**< \brief (TWIM_SR) Command Complete */
#define TWIM_SR_IDLE                (0x1u <<  4) /**< \brief (TWIM_SR) Master Interface is Idle */
#define TWIM_SR_BUSFREE             (0x1u <<  5) /**< \brief (TWIM_SR) Two-wire Bus is Free */
#define TWIM_SR_ANAK                (0x1u <<  8) /**< \brief (TWIM_SR) NAK in Address Phase Received */
#define TWIM_SR_DNAK                (0x1u <<  9) /**< \brief (TWIM_SR) NAK in Data Phase Received */
#define TWIM_SR_ARBLST              (0x1u << 10) /**< \brief (TWIM_SR) Arbitration Lost */
#define TWIM_SR_SMBALERT            (0x1u << 11) /**< \brief (TWIM_SR) SMBus Alert */
#define TWIM_SR_TOUT                (0x1u << 12) /**< \brief (TWIM_SR) Timeout */
#define TWIM_SR_PECERR              (0x1u << 13) /**< \brief (TWIM_SR) PEC Error */
#define TWIM_SR_STOP                (0x1u << 14) /**< \brief (TWIM_SR) Stop Request Accepted */
#define TWIM_SR_MENB                (0x1u << 16) /**< \brief (TWIM_SR) Master Interface Enable */
#define TWIM_SR_HSMCACK             (0x1u << 17) /**< \brief (TWIM_SR) ACK in HS-mode Master Code Phase Received */
/* -------- TWIM_IER : (TWIM Offset: 0x20) Interrupt Enable Register -------- */
#define TWIM_IER_RXRDY              (0x1u <<  0) /**< \brief (TWIM_IER) RHR Data Ready */
#define TWIM_IER_TXRDY              (0x1u <<  1) /**< \brief (TWIM_IER) THR Data Ready */
#define TWIM_IER_CRDY               (0x1u <<  2) /**< \brief (TWIM_IER) Ready for More Commands */
#define TWIM_IER_CCOMP              (0x1u <<  3) /**< \brief (TWIM_IER) Command Complete */
#define TWIM_IER_IDLE               (0x1u <<  4) /**< \brief (TWIM_IER) Master Interface is Idle */
#define TWIM_IER_BUSFREE            (0x1u <<  5) /**< \brief (TWIM_IER) Two-wire Bus is Free */
#define TWIM_IER_ANAK               (0x1u <<  8) /**< \brief (TWIM_IER) NAK in Address Phase Received */
#define TWIM_IER_DNAK               (0x1u <<  9) /**< \brief (TWIM_IER) NAK in Data Phase Received */
#define TWIM_IER_ARBLST             (0x1u << 10) /**< \brief (TWIM_IER) Arbitration Lost */
#define TWIM_IER_SMBALERT           (0x1u << 11) /**< \brief (TWIM_IER) SMBus Alert */
#define TWIM_IER_TOUT               (0x1u << 12) /**< \brief (TWIM_IER) Timeout */
#define TWIM_IER_PECERR             (0x1u << 13) /**< \brief (TWIM_IER) PEC Error */
#define TWIM_IER_STOP               (0x1u << 14) /**< \brief (TWIM_IER) Stop Request Accepted */
#define TWIM_IER_HSMCACK            (0x1u << 17) /**< \brief (TWIM_IER) ACK in HS-mode Master Code Phase Received */
/* -------- TWIM_IDR : (TWIM Offset: 0x24) Interrupt Disable Register -------- */
#define TWIM_IDR_RXRDY              (0x1u <<  0) /**< \brief (TWIM_IDR) RHR Data Ready */
#define TWIM_IDR_TXRDY              (0x1u <<  1) /**< \brief (TWIM_IDR) THR Data Ready */
#define TWIM_IDR_CRDY               (0x1u <<  2) /**< \brief (TWIM_IDR) Ready for More Commands */
#define TWIM_IDR_CCOMP              (0x1u <<  3) /**< \brief (TWIM_IDR) Command Complete */
#define TWIM_IDR_IDLE               (0x1u <<  4) /**< \brief (TWIM_IDR) Master Interface is Idle */
#define TWIM_IDR_BUSFREE            (0x1u <<  5) /**< \brief (TWIM_IDR) Two-wire Bus is Free */
#define TWIM_IDR_ANAK               (0x1u <<  8) /**< \brief (TWIM_IDR) NAK in Address Phase Received */
#define TWIM_IDR_DNAK               (0x1u <<  9) /**< \brief (TWIM_IDR) NAK in Data Phase Received */
#define TWIM_IDR_ARBLST             (0x1u << 10) /**< \brief (TWIM_IDR) Arbitration Lost */
#define TWIM_IDR_SMBALERT           (0x1u << 11) /**< \brief (TWIM_IDR) SMBus Alert */
#define TWIM_IDR_TOUT               (0x1u << 12) /**< \brief (TWIM_IDR) Timeout */
#define TWIM_IDR_PECERR             (0x1u << 13) /**< \brief (TWIM_IDR) PEC Error */
#define TWIM_IDR_STOP               (0x1u << 14) /**< \brief (TWIM_IDR) Stop Request Accepted */
#define TWIM_IDR_HSMCACK            (0x1u << 17) /**< \brief (TWIM_IDR) ACK in HS-mode Master Code Phase Received */
/* -------- TWIM_IMR : (TWIM Offset: 0x28) Interrupt Mask Register -------- */
#define TWIM_IMR_RXRDY              (0x1u <<  0) /**< \brief (TWIM_IMR) RHR Data Ready */
#define TWIM_IMR_TXRDY              (0x1u <<  1) /**< \brief (TWIM_IMR) THR Data Ready */
#define TWIM_IMR_CRDY               (0x1u <<  2) /**< \brief (TWIM_IMR) Ready for More Commands */
#define TWIM_IMR_CCOMP              (0x1u <<  3) /**< \brief (TWIM_IMR) Command Complete */
#define TWIM_IMR_IDLE               (0x1u <<  4) /**< \brief (TWIM_IMR) Master Interface is Idle */
#define TWIM_IMR_BUSFREE            (0x1u <<  5) /**< \brief (TWIM_IMR) Two-wire Bus is Free */
#define TWIM_IMR_ANAK               (0x1u <<  8) /**< \brief (TWIM_IMR) NAK in Address Phase Received */
#define TWIM_IMR_DNAK               (0x1u <<  9) /**< \brief (TWIM_IMR) NAK in Data Phase Received */
#define TWIM_IMR_ARBLST             (0x1u << 10) /**< \brief (TWIM_IMR) Arbitration Lost */
#define TWIM_IMR_SMBALERT           (0x1u << 11) /**< \brief (TWIM_IMR) SMBus Alert */
#define TWIM_IMR_TOUT               (0x1u << 12) /**< \brief (TWIM_IMR) Timeout */
#define TWIM_IMR_PECERR             (0x1u << 13) /**< \brief (TWIM_IMR) PEC Error */
#define TWIM_IMR_STOP               (0x1u << 14) /**< \brief (TWIM_IMR) Stop Request Accepted */
#define TWIM_IMR_HSMCACK            (0x1u << 17) /**< \brief (TWIM_IMR) ACK in HS-mode Master Code Phase Received */
/* -------- TWIM_SCR : (TWIM Offset: 0x2C) Status Clear Register -------- */
#define TWIM_SCR_CCOMP              (0x1u <<  3) /**< \brief (TWIM_SCR) Command Complete */
#define TWIM_SCR_ANAK               (0x1u <<  8) /**< \brief (TWIM_SCR) NAK in Address Phase Received */
#define TWIM_SCR_DNAK               (0x1u <<  9) /**< \brief (TWIM_SCR) NAK in Data Phase Received */
#define TWIM_SCR_ARBLST             (0x1u << 10) /**< \brief (TWIM_SCR) Arbitration Lost */
#define TWIM_SCR_SMBALERT           (0x1u << 11) /**< \brief (TWIM_SCR) SMBus Alert */
#define TWIM_SCR_TOUT               (0x1u << 12) /**< \brief (TWIM_SCR) Timeout */
#define TWIM_SCR_PECERR             (0x1u << 13) /**< \brief (TWIM_SCR) PEC Error */
#define TWIM_SCR_STOP               (0x1u << 14) /**< \brief (TWIM_SCR) Stop Request Accepted */
#define TWIM_SCR_HSMCACK            (0x1u << 17) /**< \brief (TWIM_SCR) ACK in HS-mode Master Code Phase Received */
/* -------- TWIM_PR : (TWIM Offset: 0x30) Parameter Register -------- */
#define TWIM_PR_HS                  (0x1u <<  0) /**< \brief (TWIM_PR) HS-mode */
/* -------- TWIM_VR : (TWIM Offset: 0x34) Version Register -------- */
#define TWIM_VR_VERSION_Pos         0
#define TWIM_VR_VERSION_Msk         (0xFFFu << TWIM_VR_VERSION_Pos) /**< \brief (TWIM_VR) Version number */
#define TWIM_VR_VERSION(value)      ((TWIM_VR_VERSION_Msk & ((value) << TWIM_VR_VERSION_Pos)))
#define TWIM_VR_VARIANT_Pos         16
#define TWIM_VR_VARIANT_Msk         (0xFu << TWIM_VR_VARIANT_Pos) /**< \brief (TWIM_VR) Variant number */
#define TWIM_VR_VARIANT(value)      ((TWIM_VR_VARIANT_Msk & ((value) << TWIM_VR_VARIANT_Pos)))
/* -------- TWIM_HSCWGR : (TWIM Offset: 0x38) HS-mode Clock Waveform Generator -------- */
#define TWIM_HSCWGR_LOW_Pos         0
#define TWIM_HSCWGR_LOW_Msk         (0xFFu << TWIM_HSCWGR_LOW_Pos) /**< \brief (TWIM_HSCWGR) Clock Low Cycles */
#define TWIM_HSCWGR_LOW(value)      ((TWIM_HSCWGR_LOW_Msk & ((value) << TWIM_HSCWGR_LOW_Pos)))
#define TWIM_HSCWGR_HIGH_Pos        8
#define TWIM_HSCWGR_HIGH_Msk        (0xFFu << TWIM_HSCWGR_HIGH_Pos) /**< \brief (TWIM_HSCWGR) Clock High Cycles */
#define TWIM_HSCWGR_HIGH(value)     ((TWIM_HSCWGR_HIGH_Msk & ((value) << TWIM_HSCWGR_HIGH_Pos)))
#define TWIM_HSCWGR_STASTO_Pos      16
#define TWIM_HSCWGR_STASTO_Msk      (0xFFu << TWIM_HSCWGR_STASTO_Pos) /**< \brief (TWIM_HSCWGR) START and STOP Cycles */
#define TWIM_HSCWGR_STASTO(value)   ((TWIM_HSCWGR_STASTO_Msk & ((value) << TWIM_HSCWGR_STASTO_Pos)))
#define TWIM_HSCWGR_DATA_Pos        24
#define TWIM_HSCWGR_DATA_Msk        (0xFu << TWIM_HSCWGR_DATA_Pos) /**< \brief (TWIM_HSCWGR) Data Setup and Hold Cycles */
#define TWIM_HSCWGR_DATA(value)     ((TWIM_HSCWGR_DATA_Msk & ((value) << TWIM_HSCWGR_DATA_Pos)))
#define TWIM_HSCWGR_EXP_Pos         28
#define TWIM_HSCWGR_EXP_Msk         (0x7u << TWIM_HSCWGR_EXP_Pos) /**< \brief (TWIM_HSCWGR) Clock Prescaler */
#define TWIM_HSCWGR_EXP(value)      ((TWIM_HSCWGR_EXP_Msk & ((value) << TWIM_HSCWGR_EXP_Pos)))
/* -------- TWIM_SRR : (TWIM Offset: 0x3C) Slew Rate Register -------- */
#define TWIM_SRR_DADRIVEL_Pos       0
#define TWIM_SRR_DADRIVEL_Msk       (0x7u << TWIM_SRR_DADRIVEL_Pos) /**< \brief (TWIM_SRR) Data Drive Strength LOW */
#define TWIM_SRR_DADRIVEL(value)    ((TWIM_SRR_DADRIVEL_Msk & ((value) << TWIM_SRR_DADRIVEL_Pos)))
#define TWIM_SRR_DASLEW_Pos         8
#define TWIM_SRR_DASLEW_Msk         (0x3u << TWIM_SRR_DASLEW_Pos) /**< \brief (TWIM_SRR) Data Slew Limit */
#define TWIM_SRR_DASLEW(value)      ((TWIM_SRR_DASLEW_Msk & ((value) << TWIM_SRR_DASLEW_Pos)))
#define TWIM_SRR_CLDRIVEL_Pos       16
#define TWIM_SRR_CLDRIVEL_Msk       (0x7u << TWIM_SRR_CLDRIVEL_Pos) /**< \brief (TWIM_SRR) Clock Drive Strength LOW */
#define TWIM_SRR_CLDRIVEL(value)    ((TWIM_SRR_CLDRIVEL_Msk & ((value) << TWIM_SRR_CLDRIVEL_Pos)))
#define TWIM_SRR_CLSLEW_Pos         24
#define TWIM_SRR_CLSLEW_Msk         (0x3u << TWIM_SRR_CLSLEW_Pos) /**< \brief (TWIM_SRR) Clock Slew Limit */
#define TWIM_SRR_CLSLEW(value)      ((TWIM_SRR_CLSLEW_Msk & ((value) << TWIM_SRR_CLSLEW_Pos)))
#define TWIM_SRR_FILTER_Pos         28
#define TWIM_SRR_FILTER_Msk         (0x3u << TWIM_SRR_FILTER_Pos) /**< \brief (TWIM_SRR) Input Spike Filter Control */
#define TWIM_SRR_FILTER(value)      ((TWIM_SRR_FILTER_Msk & ((value) << TWIM_SRR_FILTER_Pos)))
/* -------- TWIM_HSSRR : (TWIM Offset: 0x40) HS-mode Slew Rate Register -------- */
#define TWIM_HSSRR_DADRIVEL_Pos     0
#define TWIM_HSSRR_DADRIVEL_Msk     (0x7u << TWIM_HSSRR_DADRIVEL_Pos) /**< \brief (TWIM_HSSRR) Data Drive Strength LOW */
#define TWIM_HSSRR_DADRIVEL(value)  ((TWIM_HSSRR_DADRIVEL_Msk & ((value) << TWIM_HSSRR_DADRIVEL_Pos)))
#define TWIM_HSSRR_DASLEW_Pos       8
#define TWIM_HSSRR_DASLEW_Msk       (0x3u << TWIM_HSSRR_DASLEW_Pos) /**< \brief (TWIM_HSSRR) Data Slew Limit */
#define TWIM_HSSRR_DASLEW(value)    ((TWIM_HSSRR_DASLEW_Msk & ((value) << TWIM_HSSRR_DASLEW_Pos)))
#define TWIM_HSSRR_CLDRIVEL_Pos     16
#define TWIM_HSSRR_CLDRIVEL_Msk     (0x7u << TWIM_HSSRR_CLDRIVEL_Pos) /**< \brief (TWIM_HSSRR) Clock Drive Strength LOW */
#define TWIM_HSSRR_CLDRIVEL(value)  ((TWIM_HSSRR_CLDRIVEL_Msk & ((value) << TWIM_HSSRR_CLDRIVEL_Pos)))
#define TWIM_HSSRR_CLDRIVEH_Pos     20
#define TWIM_HSSRR_CLDRIVEH_Msk     (0x3u << TWIM_HSSRR_CLDRIVEH_Pos) /**< \brief (TWIM_HSSRR) Clock Drive Strength HIGH */
#define TWIM_HSSRR_CLDRIVEH(value)  ((TWIM_HSSRR_CLDRIVEH_Msk & ((value) << TWIM_HSSRR_CLDRIVEH_Pos)))
#define TWIM_HSSRR_CLSLEW_Pos       24
#define TWIM_HSSRR_CLSLEW_Msk       (0x3u << TWIM_HSSRR_CLSLEW_Pos) /**< \brief (TWIM_HSSRR) Clock Slew Limit */
#define TWIM_HSSRR_CLSLEW(value)    ((TWIM_HSSRR_CLSLEW_Msk & ((value) << TWIM_HSSRR_CLSLEW_Pos)))
#define TWIM_HSSRR_FILTER_Pos       28
#define TWIM_HSSRR_FILTER_Msk       (0x3u << TWIM_HSSRR_FILTER_Pos) /**< \brief (TWIM_HSSRR) Input Spike Filter Control */
#define TWIM_HSSRR_FILTER(value)    ((TWIM_HSSRR_FILTER_Msk & ((value) << TWIM_HSSRR_FILTER_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR TWIS */
/* ============================================================================= */
/** \addtogroup SAM4L4_TWIS Two-wire Slave Interface */
/*@{*/

#define REV_TWIS       0x140

#ifndef __ASSEMBLY__
/** \brief TWIS hardware registers */
typedef struct {
  RwReg   CR;          /**< \brief (TWIS Offset: 0x00) Control Register */
  RwReg   NBYTES;      /**< \brief (TWIS Offset: 0x04) NBYTES Register */
  RwReg   TR;          /**< \brief (TWIS Offset: 0x08) Timing Register */
  RoReg   RHR;         /**< \brief (TWIS Offset: 0x0C) Receive Holding Register */
  WoReg   THR;         /**< \brief (TWIS Offset: 0x10) Transmit Holding Register */
  RoReg   PECR;        /**< \brief (TWIS Offset: 0x14) Packet Error Check Register */
  RoReg   SR;          /**< \brief (TWIS Offset: 0x18) Status Register */
  WoReg   IER;         /**< \brief (TWIS Offset: 0x1C) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (TWIS Offset: 0x20) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (TWIS Offset: 0x24) Interrupt Mask Register */
  WoReg   SCR;         /**< \brief (TWIS Offset: 0x28) Status Clear Register */
  RoReg   PR;          /**< \brief (TWIS Offset: 0x2C) Parameter Register */
  RoReg   VR;          /**< \brief (TWIS Offset: 0x30) Version Register */
  RwReg   HSTR;        /**< \brief (TWIS Offset: 0x34) HS-mode Timing Register */
  RwReg   SRR;         /**< \brief (TWIS Offset: 0x38) Slew Rate Register */
  RwReg   HSSRR;       /**< \brief (TWIS Offset: 0x3C) HS-mode Slew Rate Register */
} Twis;
#endif /* __ASSEMBLY__ */
/* -------- TWIS_CR : (TWIS Offset: 0x00) Control Register -------- */
#define TWIS_CR_SEN                 (0x1u <<  0) /**< \brief (TWIS_CR) Slave Enable */
#define TWIS_CR_SMEN                (0x1u <<  1) /**< \brief (TWIS_CR) SMBus Mode Enable */
#define TWIS_CR_SMATCH              (0x1u <<  2) /**< \brief (TWIS_CR) Slave Address Match */
#define TWIS_CR_GCMATCH             (0x1u <<  3) /**< \brief (TWIS_CR) General Call Address Match */
#define TWIS_CR_STREN               (0x1u <<  4) /**< \brief (TWIS_CR) Clock Stretch Enable */
#define TWIS_CR_SWRST               (0x1u <<  7) /**< \brief (TWIS_CR) Software Reset */
#define TWIS_CR_SMBALERT            (0x1u <<  8) /**< \brief (TWIS_CR) SMBus Alert */
#define TWIS_CR_SMDA                (0x1u <<  9) /**< \brief (TWIS_CR) SMBus Default Address */
#define TWIS_CR_SMHH                (0x1u << 10) /**< \brief (TWIS_CR) SMBus Host Header */
#define TWIS_CR_PECEN               (0x1u << 11) /**< \brief (TWIS_CR) Packet Error Checking Enable */
#define TWIS_CR_ACK                 (0x1u << 12) /**< \brief (TWIS_CR) Slave Receiver Data Phase ACK Value */
#define TWIS_CR_CUP                 (0x1u << 13) /**< \brief (TWIS_CR) NBYTES Count Up */
#define TWIS_CR_SOAM                (0x1u << 14) /**< \brief (TWIS_CR) Stretch Clock on Address Match */
#define TWIS_CR_SODR                (0x1u << 15) /**< \brief (TWIS_CR) Stretch Clock on Data Byte Reception */
#define TWIS_CR_ADR_Pos             16
#define TWIS_CR_ADR_Msk             (0x3FFu << TWIS_CR_ADR_Pos) /**< \brief (TWIS_CR) Slave Address */
#define TWIS_CR_ADR(value)          ((TWIS_CR_ADR_Msk & ((value) << TWIS_CR_ADR_Pos)))
#define TWIS_CR_TENBIT              (0x1u << 26) /**< \brief (TWIS_CR) Ten Bit Address Match */
#define TWIS_CR_BRIDGE              (0x1u << 27) /**< \brief (TWIS_CR) Bridge Control Enable */
/* -------- TWIS_NBYTES : (TWIS Offset: 0x04) NBYTES Register -------- */
#define TWIS_NBYTES_NBYTES_Pos      0
#define TWIS_NBYTES_NBYTES_Msk      (0xFFu << TWIS_NBYTES_NBYTES_Pos) /**< \brief (TWIS_NBYTES) Number of Bytes to Transfer */
#define TWIS_NBYTES_NBYTES(value)   ((TWIS_NBYTES_NBYTES_Msk & ((value) << TWIS_NBYTES_NBYTES_Pos)))
/* -------- TWIS_TR : (TWIS Offset: 0x08) Timing Register -------- */
#define TWIS_TR_TLOWS_Pos           0
#define TWIS_TR_TLOWS_Msk           (0xFFu << TWIS_TR_TLOWS_Pos) /**< \brief (TWIS_TR) SMBus Tlow:sext Cycles */
#define TWIS_TR_TLOWS(value)        ((TWIS_TR_TLOWS_Msk & ((value) << TWIS_TR_TLOWS_Pos)))
#define TWIS_TR_TTOUT_Pos           8
#define TWIS_TR_TTOUT_Msk           (0xFFu << TWIS_TR_TTOUT_Pos) /**< \brief (TWIS_TR) SMBus Ttimeout Cycles */
#define TWIS_TR_TTOUT(value)        ((TWIS_TR_TTOUT_Msk & ((value) << TWIS_TR_TTOUT_Pos)))
#define TWIS_TR_SUDAT_Pos           16
#define TWIS_TR_SUDAT_Msk           (0xFFu << TWIS_TR_SUDAT_Pos) /**< \brief (TWIS_TR) Data Setup Cycles */
#define TWIS_TR_SUDAT(value)        ((TWIS_TR_SUDAT_Msk & ((value) << TWIS_TR_SUDAT_Pos)))
#define TWIS_TR_EXP_Pos             28
#define TWIS_TR_EXP_Msk             (0xFu << TWIS_TR_EXP_Pos) /**< \brief (TWIS_TR) Clock Prescaler */
#define TWIS_TR_EXP(value)          ((TWIS_TR_EXP_Msk & ((value) << TWIS_TR_EXP_Pos)))
/* -------- TWIS_RHR : (TWIS Offset: 0x0C) Receive Holding Register -------- */
#define TWIS_RHR_RXDATA_Pos         0
#define TWIS_RHR_RXDATA_Msk         (0xFFu << TWIS_RHR_RXDATA_Pos) /**< \brief (TWIS_RHR) Received Data Byte */
#define TWIS_RHR_RXDATA(value)      ((TWIS_RHR_RXDATA_Msk & ((value) << TWIS_RHR_RXDATA_Pos)))
/* -------- TWIS_THR : (TWIS Offset: 0x10) Transmit Holding Register -------- */
#define TWIS_THR_TXDATA_Pos         0
#define TWIS_THR_TXDATA_Msk         (0xFFu << TWIS_THR_TXDATA_Pos) /**< \brief (TWIS_THR) Data Byte to Transmit */
#define TWIS_THR_TXDATA(value)      ((TWIS_THR_TXDATA_Msk & ((value) << TWIS_THR_TXDATA_Pos)))
/* -------- TWIS_PECR : (TWIS Offset: 0x14) Packet Error Check Register -------- */
#define TWIS_PECR_PEC_Pos           0
#define TWIS_PECR_PEC_Msk           (0xFFu << TWIS_PECR_PEC_Pos) /**< \brief (TWIS_PECR) Calculated PEC Value */
#define TWIS_PECR_PEC(value)        ((TWIS_PECR_PEC_Msk & ((value) << TWIS_PECR_PEC_Pos)))
/* -------- TWIS_SR : (TWIS Offset: 0x18) Status Register -------- */
#define TWIS_SR_RXRDY               (0x1u <<  0) /**< \brief (TWIS_SR) RX Buffer Ready */
#define TWIS_SR_TXRDY               (0x1u <<  1) /**< \brief (TWIS_SR) TX Buffer Ready */
#define TWIS_SR_SEN                 (0x1u <<  2) /**< \brief (TWIS_SR) Slave Enabled */
#define TWIS_SR_TCOMP               (0x1u <<  3) /**< \brief (TWIS_SR) Transmission Complete */
#define TWIS_SR_TRA                 (0x1u <<  5) /**< \brief (TWIS_SR) Transmitter Mode */
#define TWIS_SR_URUN                (0x1u <<  6) /**< \brief (TWIS_SR) Underrun */
#define TWIS_SR_ORUN                (0x1u <<  7) /**< \brief (TWIS_SR) Overrun */
#define TWIS_SR_NAK                 (0x1u <<  8) /**< \brief (TWIS_SR) NAK Received */
#define TWIS_SR_SMBTOUT             (0x1u << 12) /**< \brief (TWIS_SR) SMBus Timeout */
#define TWIS_SR_SMBPECERR           (0x1u << 13) /**< \brief (TWIS_SR) SMBus PEC Error */
#define TWIS_SR_BUSERR              (0x1u << 14) /**< \brief (TWIS_SR) Bus Error */
#define TWIS_SR_SAM                 (0x1u << 16) /**< \brief (TWIS_SR) Slave Address Match */
#define TWIS_SR_GCM                 (0x1u << 17) /**< \brief (TWIS_SR) General Call Match */
#define TWIS_SR_SMBALERTM           (0x1u << 18) /**< \brief (TWIS_SR) SMBus Alert Response Address Match */
#define TWIS_SR_SMBHHM              (0x1u << 19) /**< \brief (TWIS_SR) SMBus Host Header Address Match */
#define TWIS_SR_SMBDAM              (0x1u << 20) /**< \brief (TWIS_SR) SMBus Default Address Match */
#define TWIS_SR_STO                 (0x1u << 21) /**< \brief (TWIS_SR) Stop Received */
#define TWIS_SR_REP                 (0x1u << 22) /**< \brief (TWIS_SR) Repeated Start Received */
#define TWIS_SR_BTF                 (0x1u << 23) /**< \brief (TWIS_SR) Byte Transfer Finished */
/* -------- TWIS_IER : (TWIS Offset: 0x1C) Interrupt Enable Register -------- */
#define TWIS_IER_RXRDY              (0x1u <<  0) /**< \brief (TWIS_IER) RX Buffer Ready */
#define TWIS_IER_TXRDY              (0x1u <<  1) /**< \brief (TWIS_IER) TX Buffer Ready */
#define TWIS_IER_TCOMP              (0x1u <<  3) /**< \brief (TWIS_IER) Transmission Complete */
#define TWIS_IER_URUN               (0x1u <<  6) /**< \brief (TWIS_IER) Underrun */
#define TWIS_IER_ORUN               (0x1u <<  7) /**< \brief (TWIS_IER) Overrun */
#define TWIS_IER_NAK                (0x1u <<  8) /**< \brief (TWIS_IER) NAK Received */
#define TWIS_IER_SMBTOUT            (0x1u << 12) /**< \brief (TWIS_IER) SMBus Timeout */
#define TWIS_IER_SMBPECERR          (0x1u << 13) /**< \brief (TWIS_IER) SMBus PEC Error */
#define TWIS_IER_BUSERR             (0x1u << 14) /**< \brief (TWIS_IER) Bus Error */
#define TWIS_IER_SAM                (0x1u << 16) /**< \brief (TWIS_IER) Slave Address Match */
#define TWIS_IER_GCM                (0x1u << 17) /**< \brief (TWIS_IER) General Call Match */
#define TWIS_IER_SMBALERTM          (0x1u << 18) /**< \brief (TWIS_IER) SMBus Alert Response Address Match */
#define TWIS_IER_SMBHHM             (0x1u << 19) /**< \brief (TWIS_IER) SMBus Host Header Address Match */
#define TWIS_IER_SMBDAM             (0x1u << 20) /**< \brief (TWIS_IER) SMBus Default Address Match */
#define TWIS_IER_STO                (0x1u << 21) /**< \brief (TWIS_IER) Stop Received */
#define TWIS_IER_REP                (0x1u << 22) /**< \brief (TWIS_IER) Repeated Start Received */
#define TWIS_IER_BTF                (0x1u << 23) /**< \brief (TWIS_IER) Byte Transfer Finished */
/* -------- TWIS_IDR : (TWIS Offset: 0x20) Interrupt Disable Register -------- */
#define TWIS_IDR_RXRDY              (0x1u <<  0) /**< \brief (TWIS_IDR) RX Buffer Ready */
#define TWIS_IDR_TXRDY              (0x1u <<  1) /**< \brief (TWIS_IDR) TX Buffer Ready */
#define TWIS_IDR_TCOMP              (0x1u <<  3) /**< \brief (TWIS_IDR) Transmission Complete */
#define TWIS_IDR_URUN               (0x1u <<  6) /**< \brief (TWIS_IDR) Underrun */
#define TWIS_IDR_ORUN               (0x1u <<  7) /**< \brief (TWIS_IDR) Overrun */
#define TWIS_IDR_NAK                (0x1u <<  8) /**< \brief (TWIS_IDR) NAK Received */
#define TWIS_IDR_SMBTOUT            (0x1u << 12) /**< \brief (TWIS_IDR) SMBus Timeout */
#define TWIS_IDR_SMBPECERR          (0x1u << 13) /**< \brief (TWIS_IDR) SMBus PEC Error */
#define TWIS_IDR_BUSERR             (0x1u << 14) /**< \brief (TWIS_IDR) Bus Error */
#define TWIS_IDR_SAM                (0x1u << 16) /**< \brief (TWIS_IDR) Slave Address Match */
#define TWIS_IDR_GCM                (0x1u << 17) /**< \brief (TWIS_IDR) General Call Match */
#define TWIS_IDR_SMBALERTM          (0x1u << 18) /**< \brief (TWIS_IDR) SMBus Alert Response Address Match */
#define TWIS_IDR_SMBHHM             (0x1u << 19) /**< \brief (TWIS_IDR) SMBus Host Header Address Match */
#define TWIS_IDR_SMBDAM             (0x1u << 20) /**< \brief (TWIS_IDR) SMBus Default Address Match */
#define TWIS_IDR_STO                (0x1u << 21) /**< \brief (TWIS_IDR) Stop Received */
#define TWIS_IDR_REP                (0x1u << 22) /**< \brief (TWIS_IDR) Repeated Start Received */
#define TWIS_IDR_BTF                (0x1u << 23) /**< \brief (TWIS_IDR) Byte Transfer Finished */
/* -------- TWIS_IMR : (TWIS Offset: 0x24) Interrupt Mask Register -------- */
#define TWIS_IMR_RXRDY              (0x1u <<  0) /**< \brief (TWIS_IMR) RX Buffer Ready */
#define TWIS_IMR_TXRDY              (0x1u <<  1) /**< \brief (TWIS_IMR) TX Buffer Ready */
#define TWIS_IMR_TCOMP              (0x1u <<  3) /**< \brief (TWIS_IMR) Transmission Complete */
#define TWIS_IMR_URUN               (0x1u <<  6) /**< \brief (TWIS_IMR) Underrun */
#define TWIS_IMR_ORUN               (0x1u <<  7) /**< \brief (TWIS_IMR) Overrun */
#define TWIS_IMR_NAK                (0x1u <<  8) /**< \brief (TWIS_IMR) NAK Received */
#define TWIS_IMR_SMBTOUT            (0x1u << 12) /**< \brief (TWIS_IMR) SMBus Timeout */
#define TWIS_IMR_SMBPECERR          (0x1u << 13) /**< \brief (TWIS_IMR) SMBus PEC Error */
#define TWIS_IMR_BUSERR             (0x1u << 14) /**< \brief (TWIS_IMR) Bus Error */
#define TWIS_IMR_SAM                (0x1u << 16) /**< \brief (TWIS_IMR) Slave Address Match */
#define TWIS_IMR_GCM                (0x1u << 17) /**< \brief (TWIS_IMR) General Call Match */
#define TWIS_IMR_SMBALERTM          (0x1u << 18) /**< \brief (TWIS_IMR) SMBus Alert Response Address Match */
#define TWIS_IMR_SMBHHM             (0x1u << 19) /**< \brief (TWIS_IMR) SMBus Host Header Address Match */
#define TWIS_IMR_SMBDAM             (0x1u << 20) /**< \brief (TWIS_IMR) SMBus Default Address Match */
#define TWIS_IMR_STO                (0x1u << 21) /**< \brief (TWIS_IMR) Stop Received */
#define TWIS_IMR_REP                (0x1u << 22) /**< \brief (TWIS_IMR) Repeated Start Received */
#define TWIS_IMR_BTF                (0x1u << 23) /**< \brief (TWIS_IMR) Byte Transfer Finished */
/* -------- TWIS_SCR : (TWIS Offset: 0x28) Status Clear Register -------- */
#define TWIS_SCR_TCOMP              (0x1u <<  3) /**< \brief (TWIS_SCR) Transmission Complete */
#define TWIS_SCR_URUN               (0x1u <<  6) /**< \brief (TWIS_SCR) Underrun */
#define TWIS_SCR_ORUN               (0x1u <<  7) /**< \brief (TWIS_SCR) Overrun */
#define TWIS_SCR_NAK                (0x1u <<  8) /**< \brief (TWIS_SCR) NAK Received */
#define TWIS_SCR_SMBTOUT            (0x1u << 12) /**< \brief (TWIS_SCR) SMBus Timeout */
#define TWIS_SCR_SMBPECERR          (0x1u << 13) /**< \brief (TWIS_SCR) SMBus PEC Error */
#define TWIS_SCR_BUSERR             (0x1u << 14) /**< \brief (TWIS_SCR) Bus Error */
#define TWIS_SCR_SAM                (0x1u << 16) /**< \brief (TWIS_SCR) Slave Address Match */
#define TWIS_SCR_GCM                (0x1u << 17) /**< \brief (TWIS_SCR) General Call Match */
#define TWIS_SCR_SMBALERTM          (0x1u << 18) /**< \brief (TWIS_SCR) SMBus Alert Response Address Match */
#define TWIS_SCR_SMBHHM             (0x1u << 19) /**< \brief (TWIS_SCR) SMBus Host Header Address Match */
#define TWIS_SCR_SMBDAM             (0x1u << 20) /**< \brief (TWIS_SCR) SMBus Default Address Match */
#define TWIS_SCR_STO                (0x1u << 21) /**< \brief (TWIS_SCR) Stop Received */
#define TWIS_SCR_REP                (0x1u << 22) /**< \brief (TWIS_SCR) Repeated Start Received */
#define TWIS_SCR_BTF                (0x1u << 23) /**< \brief (TWIS_SCR) Byte Transfer Finished */
/* -------- TWIS_PR : (TWIS Offset: 0x2C) Parameter Register -------- */
#define TWIS_PR_HS                  (0x1u <<  0) /**< \brief (TWIS_PR) HS-mode */
/* -------- TWIS_VR : (TWIS Offset: 0x30) Version Register -------- */
#define TWIS_VR_VERSION_Pos         0
#define TWIS_VR_VERSION_Msk         (0xFFFu << TWIS_VR_VERSION_Pos) /**< \brief (TWIS_VR) Version Number */
#define TWIS_VR_VERSION(value)      ((TWIS_VR_VERSION_Msk & ((value) << TWIS_VR_VERSION_Pos)))
#define TWIS_VR_VARIANT_Pos         16
#define TWIS_VR_VARIANT_Msk         (0xFu << TWIS_VR_VARIANT_Pos) /**< \brief (TWIS_VR) Variant Number */
#define TWIS_VR_VARIANT(value)      ((TWIS_VR_VARIANT_Msk & ((value) << TWIS_VR_VARIANT_Pos)))
/* -------- TWIS_HSTR : (TWIS Offset: 0x34) HS-mode Timing Register -------- */
#define TWIS_HSTR_HDDAT_Pos         16
#define TWIS_HSTR_HDDAT_Msk         (0xFFu << TWIS_HSTR_HDDAT_Pos) /**< \brief (TWIS_HSTR) Data Hold Cycles */
#define TWIS_HSTR_HDDAT(value)      ((TWIS_HSTR_HDDAT_Msk & ((value) << TWIS_HSTR_HDDAT_Pos)))
/* -------- TWIS_SRR : (TWIS Offset: 0x38) Slew Rate Register -------- */
#define TWIS_SRR_DADRIVEL_Pos       0
#define TWIS_SRR_DADRIVEL_Msk       (0x7u << TWIS_SRR_DADRIVEL_Pos) /**< \brief (TWIS_SRR) Data Drive Strength LOW */
#define TWIS_SRR_DADRIVEL(value)    ((TWIS_SRR_DADRIVEL_Msk & ((value) << TWIS_SRR_DADRIVEL_Pos)))
#define TWIS_SRR_DASLEW_Pos         8
#define TWIS_SRR_DASLEW_Msk         (0x3u << TWIS_SRR_DASLEW_Pos) /**< \brief (TWIS_SRR) Data Slew Limit */
#define TWIS_SRR_DASLEW(value)      ((TWIS_SRR_DASLEW_Msk & ((value) << TWIS_SRR_DASLEW_Pos)))
#define TWIS_SRR_FILTER_Pos         28
#define TWIS_SRR_FILTER_Msk         (0x3u << TWIS_SRR_FILTER_Pos) /**< \brief (TWIS_SRR) Input Spike Filter Control */
#define TWIS_SRR_FILTER(value)      ((TWIS_SRR_FILTER_Msk & ((value) << TWIS_SRR_FILTER_Pos)))
/* -------- TWIS_HSSRR : (TWIS Offset: 0x3C) HS-mode Slew Rate Register -------- */
#define TWIS_HSSRR_DADRIVEL_Pos     0
#define TWIS_HSSRR_DADRIVEL_Msk     (0x7u << TWIS_HSSRR_DADRIVEL_Pos) /**< \brief (TWIS_HSSRR) Data Drive Strength LOW */
#define TWIS_HSSRR_DADRIVEL(value)  ((TWIS_HSSRR_DADRIVEL_Msk & ((value) << TWIS_HSSRR_DADRIVEL_Pos)))
#define TWIS_HSSRR_DASLEW_Pos       8
#define TWIS_HSSRR_DASLEW_Msk       (0x3u << TWIS_HSSRR_DASLEW_Pos) /**< \brief (TWIS_HSSRR) Data Slew Limit */
#define TWIS_HSSRR_DASLEW(value)    ((TWIS_HSSRR_DASLEW_Msk & ((value) << TWIS_HSSRR_DASLEW_Pos)))
#define TWIS_HSSRR_FILTER_Pos       28
#define TWIS_HSSRR_FILTER_Msk       (0x3u << TWIS_HSSRR_FILTER_Pos) /**< \brief (TWIS_HSSRR) Input Spike Filter Control */
#define TWIS_HSSRR_FILTER(value)    ((TWIS_HSSRR_FILTER_Msk & ((value) << TWIS_HSSRR_FILTER_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR USART */
/* ============================================================================= */
/** \addtogroup SAM4L4_USART Universal Synchronous Asynchronous Receiver Transmitter */
/*@{*/

#define REV_USART      0x6021

#ifndef __ASSEMBLY__
/** \brief USART hardware registers */
typedef struct {
  WoReg   CR;          /**< \brief (USART Offset: 0x00) Control Register */
  RwReg   MR;          /**< \brief (USART Offset: 0x04) Mode Register */
  WoReg   IER;         /**< \brief (USART Offset: 0x08) Interrupt Enable Register */
  WoReg   IDR;         /**< \brief (USART Offset: 0x0C) Interrupt Disable Register */
  RoReg   IMR;         /**< \brief (USART Offset: 0x10) Interrupt Mask Register */
  RoReg   CSR;         /**< \brief (USART Offset: 0x14) Channel Status Register */
  RoReg   RHR;         /**< \brief (USART Offset: 0x18) Receiver Holding Register */
  WoReg   THR;         /**< \brief (USART Offset: 0x1C) Transmitter Holding Register */
  RwReg   BRGR;        /**< \brief (USART Offset: 0x20) Baud Rate Generator Register */
  RwReg   RTOR;        /**< \brief (USART Offset: 0x24) Receiver Time-out Register */
  RwReg   TTGR;        /**< \brief (USART Offset: 0x28) Transmitter Timeguard Register */
  RoReg   Reserved1[5];
  RwReg   FIDI;        /**< \brief (USART Offset: 0x40) FI DI Ratio Register */
  RoReg   NER;         /**< \brief (USART Offset: 0x44) Number of Errors Register */
  RoReg   Reserved2[1];
  RwReg   IFR;         /**< \brief (USART Offset: 0x4C) IrDA Filter Register */
  RwReg   MAN;         /**< \brief (USART Offset: 0x50) Manchester Configuration Register */
  RwReg   LINMR;       /**< \brief (USART Offset: 0x54) LIN Mode Register */
  RwReg   LINIR;       /**< \brief (USART Offset: 0x58) LIN Identifier Register */
  RoReg   LINBRR;      /**< \brief (USART Offset: 0x5C) LIN Baud Rate Register */
  RoReg   Reserved3[33];
  RwReg   WPMR;        /**< \brief (USART Offset: 0xE4) Write Protect Mode Register */
  RoReg   WPSR;        /**< \brief (USART Offset: 0xE8) Write Protect Status Register */
  RoReg   Reserved4[4];
  RoReg   VERSION;     /**< \brief (USART Offset: 0xFC) Version Register */
} Usart;
#endif /* __ASSEMBLY__ */
/* -------- US_LIN_CR : (USART Offset: 0x00) Control Register -------- */
#define US_LIN_CR_RSTRX             (0x1u <<  2) /**< \brief (US_LIN_CR) Reset Receiver */
#define   US_LIN_CR_RSTRX_0         (0x0u <<  2) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RSTRX_1         (0x1u <<  2) /**< \brief (US_LIN_CR) Resets the receiver */
#define US_LIN_CR_RSTTX             (0x1u <<  3) /**< \brief (US_LIN_CR) Reset Transmitter */
#define   US_LIN_CR_RSTTX_0         (0x0u <<  3) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RSTTX_1         (0x1u <<  3) /**< \brief (US_LIN_CR) Resets the transmitter */
#define US_LIN_CR_RXEN              (0x1u <<  4) /**< \brief (US_LIN_CR) Receiver Enable */
#define   US_LIN_CR_RXEN_0          (0x0u <<  4) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RXEN_1          (0x1u <<  4) /**< \brief (US_LIN_CR) Enables the receiver, if RXDIS is 0 */
#define US_LIN_CR_RXDIS             (0x1u <<  5) /**< \brief (US_LIN_CR) Receiver Disable */
#define   US_LIN_CR_RXDIS_0         (0x0u <<  5) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RXDIS_1         (0x1u <<  5) /**< \brief (US_LIN_CR) Disables the receiver */
#define US_LIN_CR_TXEN              (0x1u <<  6) /**< \brief (US_LIN_CR) Transmitter Enable */
#define   US_LIN_CR_TXEN_0          (0x0u <<  6) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_TXEN_1          (0x1u <<  6) /**< \brief (US_LIN_CR) Enables the transmitter if TXDIS is 0 */
#define US_LIN_CR_TXDIS             (0x1u <<  7) /**< \brief (US_LIN_CR) Transmitter Disable */
#define   US_LIN_CR_TXDIS_0         (0x0u <<  7) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_TXDIS_1         (0x1u <<  7) /**< \brief (US_LIN_CR) Disables the transmitter */
#define US_LIN_CR_RSTSTA            (0x1u <<  8) /**< \brief (US_LIN_CR) Reset Status Bits */
#define   US_LIN_CR_RSTSTA_0        (0x0u <<  8) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RSTSTA_1        (0x1u <<  8) /**< \brief (US_LIN_CR) Resets the status bits PARE, FRAME, OVRE and RXBRK in the CSR */
#define US_LIN_CR_STTBRK            (0x1u <<  9) /**< \brief (US_LIN_CR) Start Break */
#define   US_LIN_CR_STTBRK_0        (0x0u <<  9) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_STTBRK_1        (0x1u <<  9) /**< \brief (US_LIN_CR) Starts transmission of a break after the characters present in THR and the Transmit Shift Register have been transmitted. No effect if a break is already being transmitted */
#define US_LIN_CR_STPBRK            (0x1u << 10) /**< \brief (US_LIN_CR) Stop Break */
#define   US_LIN_CR_STPBRK_0        (0x0u << 10) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_STPBRK_1        (0x1u << 10) /**< \brief (US_LIN_CR) Stops transmission of the break after a minimum of one character length and transmits a high level during 12-bit periods.No effect if no break is being transmitted */
#define US_LIN_CR_STTTO             (0x1u << 11) /**< \brief (US_LIN_CR) Start Time-out */
#define   US_LIN_CR_STTTO_0         (0x0u << 11) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_STTTO_1         (0x1u << 11) /**< \brief (US_LIN_CR) Starts waiting for a character before clocking the time-out counter */
#define US_LIN_CR_SENDA             (0x1u << 12) /**< \brief (US_LIN_CR) Send Address */
#define   US_LIN_CR_SENDA_0         (0x0u << 12) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_SENDA_1         (0x1u << 12) /**< \brief (US_LIN_CR) In Multi-drop Mode only, the next character written to the THR is sent with the address bit set */
#define US_LIN_CR_RSTIT             (0x1u << 13) /**< \brief (US_LIN_CR) Reset Iterations */
#define   US_LIN_CR_RSTIT_0         (0x0u << 13) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RSTIT_1         (0x1u << 13) /**< \brief (US_LIN_CR) Resets ITERATION in CSR. No effect if the ISO7816 is not enabled */
#define US_LIN_CR_RSTNACK           (0x1u << 14) /**< \brief (US_LIN_CR) Reset Non Acknowledge */
#define   US_LIN_CR_RSTNACK_0       (0x0u << 14) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RSTNACK_1       (0x1u << 14) /**< \brief (US_LIN_CR) Resets NACK in CSR */
#define US_LIN_CR_RETTO             (0x1u << 15) /**< \brief (US_LIN_CR) Rearm Time-out */
#define   US_LIN_CR_RETTO_0         (0x0u << 15) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RETTO_1         (0x1u << 15) /**< \brief (US_LIN_CR) Restart Time-out */
#define US_LIN_CR_DTREN             (0x1u << 16) /**< \brief (US_LIN_CR) Data Terminal Ready Enable */
#define   US_LIN_CR_DTREN_0         (0x0u << 16) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_DTREN_1         (0x1u << 16) /**< \brief (US_LIN_CR) Drives the pin DTR at 0 */
#define US_LIN_CR_DTRDIS            (0x1u << 17) /**< \brief (US_LIN_CR) Data Terminal Ready Disable */
#define   US_LIN_CR_DTRDIS_0        (0x0u << 17) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_DTRDIS_1        (0x1u << 17) /**< \brief (US_LIN_CR) Drives the pin DTR to 1 */
#define US_LIN_CR_RTSEN             (0x1u << 18) /**< \brief (US_LIN_CR) Request to Send Enable */
#define   US_LIN_CR_RTSEN_0         (0x0u << 18) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RTSEN_1         (0x1u << 18) /**< \brief (US_LIN_CR) Drives the pin RTS to 0 */
#define US_LIN_CR_RTSDIS            (0x1u << 19) /**< \brief (US_LIN_CR) Request to Send Disable */
#define   US_LIN_CR_RTSDIS_0        (0x0u << 19) /**< \brief (US_LIN_CR) No effect */
#define   US_LIN_CR_RTSDIS_1        (0x1u << 19) /**< \brief (US_LIN_CR) Drives the pin RTS to 1 */
#define US_LIN_CR_LINABT            (0x1u << 20) /**< \brief (US_LIN_CR) Abort the current LIN transmission */
#define US_LIN_CR_LINWKUP           (0x1u << 21) /**< \brief (US_LIN_CR) Sends a wakeup signal on the LIN bus */
/* -------- US_SPI_MASTER_CR : (USART Offset: 0x00) Control Register -------- */
#define US_SPI_MASTER_CR_RSTRX      (0x1u <<  2) /**< \brief (US_SPI_MASTER_CR) Reset Receiver */
#define   US_SPI_MASTER_CR_RSTRX_0  (0x0u <<  2) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_RSTRX_1  (0x1u <<  2) /**< \brief (US_SPI_MASTER_CR) Resets the receiver */
#define US_SPI_MASTER_CR_RSTTX      (0x1u <<  3) /**< \brief (US_SPI_MASTER_CR) Reset Transmitter */
#define   US_SPI_MASTER_CR_RSTTX_0  (0x0u <<  3) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_RSTTX_1  (0x1u <<  3) /**< \brief (US_SPI_MASTER_CR) Resets the transmitter */
#define US_SPI_MASTER_CR_RXEN       (0x1u <<  4) /**< \brief (US_SPI_MASTER_CR) Receiver Enable */
#define   US_SPI_MASTER_CR_RXEN_0   (0x0u <<  4) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_RXEN_1   (0x1u <<  4) /**< \brief (US_SPI_MASTER_CR) Enables the receiver, if RXDIS is 0 */
#define US_SPI_MASTER_CR_RXDIS      (0x1u <<  5) /**< \brief (US_SPI_MASTER_CR) Receiver Disable */
#define   US_SPI_MASTER_CR_RXDIS_0  (0x0u <<  5) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_RXDIS_1  (0x1u <<  5) /**< \brief (US_SPI_MASTER_CR) Disables the receiver */
#define US_SPI_MASTER_CR_TXEN       (0x1u <<  6) /**< \brief (US_SPI_MASTER_CR) Transmitter Enable */
#define   US_SPI_MASTER_CR_TXEN_0   (0x0u <<  6) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_TXEN_1   (0x1u <<  6) /**< \brief (US_SPI_MASTER_CR) Enables the transmitter if TXDIS is 0 */
#define US_SPI_MASTER_CR_TXDIS      (0x1u <<  7) /**< \brief (US_SPI_MASTER_CR) Transmitter Disable */
#define   US_SPI_MASTER_CR_TXDIS_0  (0x0u <<  7) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_TXDIS_1  (0x1u <<  7) /**< \brief (US_SPI_MASTER_CR) Disables the transmitter */
#define US_SPI_MASTER_CR_RSTSTA     (0x1u <<  8) /**< \brief (US_SPI_MASTER_CR) Reset Status Bits */
#define   US_SPI_MASTER_CR_RSTSTA_0 (0x0u <<  8) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_RSTSTA_1 (0x1u <<  8) /**< \brief (US_SPI_MASTER_CR) Resets the status bits PARE, FRAME, OVRE and RXBRK in the CSR */
#define US_SPI_MASTER_CR_STTBRK     (0x1u <<  9) /**< \brief (US_SPI_MASTER_CR) Start Break */
#define   US_SPI_MASTER_CR_STTBRK_0 (0x0u <<  9) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_STTBRK_1 (0x1u <<  9) /**< \brief (US_SPI_MASTER_CR) Starts transmission of a break after the characters present in THR and the Transmit Shift Register have been transmitted. No effect if a break is already being transmitted */
#define US_SPI_MASTER_CR_STPBRK     (0x1u << 10) /**< \brief (US_SPI_MASTER_CR) Stop Break */
#define   US_SPI_MASTER_CR_STPBRK_0 (0x0u << 10) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_STPBRK_1 (0x1u << 10) /**< \brief (US_SPI_MASTER_CR) Stops transmission of the break after a minimum of one character length and transmits a high level during 12-bit periods.No effect if no break is being transmitted */
#define US_SPI_MASTER_CR_STTTO      (0x1u << 11) /**< \brief (US_SPI_MASTER_CR) Start Time-out */
#define   US_SPI_MASTER_CR_STTTO_0  (0x0u << 11) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_STTTO_1  (0x1u << 11) /**< \brief (US_SPI_MASTER_CR) Starts waiting for a character before clocking the time-out counter */
#define US_SPI_MASTER_CR_SENDA      (0x1u << 12) /**< \brief (US_SPI_MASTER_CR) Send Address */
#define   US_SPI_MASTER_CR_SENDA_0  (0x0u << 12) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_SENDA_1  (0x1u << 12) /**< \brief (US_SPI_MASTER_CR) In Multi-drop Mode only, the next character written to the THR is sent with the address bit set */
#define US_SPI_MASTER_CR_RSTIT      (0x1u << 13) /**< \brief (US_SPI_MASTER_CR) Reset Iterations */
#define   US_SPI_MASTER_CR_RSTIT_0  (0x0u << 13) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_RSTIT_1  (0x1u << 13) /**< \brief (US_SPI_MASTER_CR) Resets ITERATION in CSR. No effect if the ISO7816 is not enabled */
#define US_SPI_MASTER_CR_RSTNACK    (0x1u << 14) /**< \brief (US_SPI_MASTER_CR) Reset Non Acknowledge */
#define   US_SPI_MASTER_CR_RSTNACK_0 (0x0u << 14) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_RSTNACK_1 (0x1u << 14) /**< \brief (US_SPI_MASTER_CR) Resets NACK in CSR */
#define US_SPI_MASTER_CR_RETTO      (0x1u << 15) /**< \brief (US_SPI_MASTER_CR) Rearm Time-out */
#define   US_SPI_MASTER_CR_RETTO_0  (0x0u << 15) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_RETTO_1  (0x1u << 15) /**< \brief (US_SPI_MASTER_CR) Restart Time-out */
#define US_SPI_MASTER_CR_DTREN      (0x1u << 16) /**< \brief (US_SPI_MASTER_CR) Data Terminal Ready Enable */
#define   US_SPI_MASTER_CR_DTREN_0  (0x0u << 16) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_DTREN_1  (0x1u << 16) /**< \brief (US_SPI_MASTER_CR) Drives the pin DTR at 0 */
#define US_SPI_MASTER_CR_DTRDIS     (0x1u << 17) /**< \brief (US_SPI_MASTER_CR) Data Terminal Ready Disable */
#define   US_SPI_MASTER_CR_DTRDIS_0 (0x0u << 17) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_DTRDIS_1 (0x1u << 17) /**< \brief (US_SPI_MASTER_CR) Drives the pin DTR to 1 */
#define US_SPI_MASTER_CR_FCS        (0x1u << 18) /**< \brief (US_SPI_MASTER_CR) Force SPI Chip Select */
#define   US_SPI_MASTER_CR_FCS_0    (0x0u << 18) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_FCS_1    (0x1u << 18) /**< \brief (US_SPI_MASTER_CR) Forces the Slave Select Line NSS (RTS pin) to 0, even if USART is no transmitting, in order to address SPI slave devices supporting the CSAAT Mode (Chip Select Active After Transfer) */
#define US_SPI_MASTER_CR_RCS        (0x1u << 19) /**< \brief (US_SPI_MASTER_CR) Release SPI Chip Select */
#define   US_SPI_MASTER_CR_RCS_0    (0x0u << 19) /**< \brief (US_SPI_MASTER_CR) No effect */
#define   US_SPI_MASTER_CR_RCS_1    (0x1u << 19) /**< \brief (US_SPI_MASTER_CR) Releases the Slave Select Line NSS (RTS pin) */
/* -------- US_USART_CR : (USART Offset: 0x00) Control Register -------- */
#define US_USART_CR_RSTRX           (0x1u <<  2) /**< \brief (US_USART_CR) Reset Receiver */
#define   US_USART_CR_RSTRX_0       (0x0u <<  2) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RSTRX_1       (0x1u <<  2) /**< \brief (US_USART_CR) Resets the receiver */
#define US_USART_CR_RSTTX           (0x1u <<  3) /**< \brief (US_USART_CR) Reset Transmitter */
#define   US_USART_CR_RSTTX_0       (0x0u <<  3) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RSTTX_1       (0x1u <<  3) /**< \brief (US_USART_CR) Resets the transmitter */
#define US_USART_CR_RXEN            (0x1u <<  4) /**< \brief (US_USART_CR) Receiver Enable */
#define   US_USART_CR_RXEN_0        (0x0u <<  4) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RXEN_1        (0x1u <<  4) /**< \brief (US_USART_CR) Enables the receiver, if RXDIS is 0 */
#define US_USART_CR_RXDIS           (0x1u <<  5) /**< \brief (US_USART_CR) Receiver Disable */
#define   US_USART_CR_RXDIS_0       (0x0u <<  5) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RXDIS_1       (0x1u <<  5) /**< \brief (US_USART_CR) Disables the receiver */
#define US_USART_CR_TXEN            (0x1u <<  6) /**< \brief (US_USART_CR) Transmitter Enable */
#define   US_USART_CR_TXEN_0        (0x0u <<  6) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_TXEN_1        (0x1u <<  6) /**< \brief (US_USART_CR) Enables the transmitter if TXDIS is 0 */
#define US_USART_CR_TXDIS           (0x1u <<  7) /**< \brief (US_USART_CR) Transmitter Disable */
#define   US_USART_CR_TXDIS_0       (0x0u <<  7) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_TXDIS_1       (0x1u <<  7) /**< \brief (US_USART_CR) Disables the transmitter */
#define US_USART_CR_RSTSTA          (0x1u <<  8) /**< \brief (US_USART_CR) Reset Status Bits */
#define   US_USART_CR_RSTSTA_0      (0x0u <<  8) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RSTSTA_1      (0x1u <<  8) /**< \brief (US_USART_CR) Resets the status bits PARE, FRAME, OVRE and RXBRK in the CSR */
#define US_USART_CR_STTBRK          (0x1u <<  9) /**< \brief (US_USART_CR) Start Break */
#define   US_USART_CR_STTBRK_0      (0x0u <<  9) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_STTBRK_1      (0x1u <<  9) /**< \brief (US_USART_CR) Starts transmission of a break after the characters present in THR and the Transmit Shift Register have been transmitted. No effect if a break is already being transmitted */
#define US_USART_CR_STPBRK          (0x1u << 10) /**< \brief (US_USART_CR) Stop Break */
#define   US_USART_CR_STPBRK_0      (0x0u << 10) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_STPBRK_1      (0x1u << 10) /**< \brief (US_USART_CR) Stops transmission of the break after a minimum of one character length and transmits a high level during 12-bit periods.No effect if no break is being transmitted */
#define US_USART_CR_STTTO           (0x1u << 11) /**< \brief (US_USART_CR) Start Time-out */
#define   US_USART_CR_STTTO_0       (0x0u << 11) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_STTTO_1       (0x1u << 11) /**< \brief (US_USART_CR) Starts waiting for a character before clocking the time-out counter */
#define US_USART_CR_SENDA           (0x1u << 12) /**< \brief (US_USART_CR) Send Address */
#define   US_USART_CR_SENDA_0       (0x0u << 12) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_SENDA_1       (0x1u << 12) /**< \brief (US_USART_CR) In Multi-drop Mode only, the next character written to the THR is sent with the address bit set */
#define US_USART_CR_RSTIT           (0x1u << 13) /**< \brief (US_USART_CR) Reset Iterations */
#define   US_USART_CR_RSTIT_0       (0x0u << 13) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RSTIT_1       (0x1u << 13) /**< \brief (US_USART_CR) Resets ITERATION in CSR. No effect if the ISO7816 is not enabled */
#define US_USART_CR_RSTNACK         (0x1u << 14) /**< \brief (US_USART_CR) Reset Non Acknowledge */
#define   US_USART_CR_RSTNACK_0     (0x0u << 14) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RSTNACK_1     (0x1u << 14) /**< \brief (US_USART_CR) Resets NACK in CSR */
#define US_USART_CR_RETTO           (0x1u << 15) /**< \brief (US_USART_CR) Rearm Time-out */
#define   US_USART_CR_RETTO_0       (0x0u << 15) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RETTO_1       (0x1u << 15) /**< \brief (US_USART_CR) Restart Time-out */
#define US_USART_CR_DTREN           (0x1u << 16) /**< \brief (US_USART_CR) Data Terminal Ready Enable */
#define   US_USART_CR_DTREN_0       (0x0u << 16) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_DTREN_1       (0x1u << 16) /**< \brief (US_USART_CR) Drives the pin DTR at 0 */
#define US_USART_CR_DTRDIS          (0x1u << 17) /**< \brief (US_USART_CR) Data Terminal Ready Disable */
#define   US_USART_CR_DTRDIS_0      (0x0u << 17) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_DTRDIS_1      (0x1u << 17) /**< \brief (US_USART_CR) Drives the pin DTR to 1 */
#define US_USART_CR_RTSEN           (0x1u << 18) /**< \brief (US_USART_CR) Request to Send Enable */
#define   US_USART_CR_RTSEN_0       (0x0u << 18) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RTSEN_1       (0x1u << 18) /**< \brief (US_USART_CR) Drives the pin RTS to 0 */
#define US_USART_CR_RTSDIS          (0x1u << 19) /**< \brief (US_USART_CR) Request to Send Disable */
#define   US_USART_CR_RTSDIS_0      (0x0u << 19) /**< \brief (US_USART_CR) No effect */
#define   US_USART_CR_RTSDIS_1      (0x1u << 19) /**< \brief (US_USART_CR) Drives the pin RTS to 1 */
/* -------- US_SPI_MR : (USART Offset: 0x04) Mode Register -------- */
#define US_SPI_MR_MODE_Pos          0
#define US_SPI_MR_MODE_Msk          (0xFu << US_SPI_MR_MODE_Pos) /**< \brief (US_SPI_MR) Usart Mode */
#define US_SPI_MR_MODE(value)       ((US_SPI_MR_MODE_Msk & ((value) << US_SPI_MR_MODE_Pos)))
#define   US_SPI_MR_MODE_NORMAL     (0x0u <<  0) /**< \brief (US_SPI_MR) Normal */
#define   US_SPI_MR_MODE_RS485      (0x1u <<  0) /**< \brief (US_SPI_MR) RS485 */
#define   US_SPI_MR_MODE_HARDWARE   (0x2u <<  0) /**< \brief (US_SPI_MR) Hardware Handshaking */
#define   US_SPI_MR_MODE_MODEM      (0x3u <<  0) /**< \brief (US_SPI_MR) Modem */
#define   US_SPI_MR_MODE_ISO7816_T0 (0x4u <<  0) /**< \brief (US_SPI_MR) IS07816 Protocol: T = 0 */
#define   US_SPI_MR_MODE_ISO7816_T1 (0x6u <<  0) /**< \brief (US_SPI_MR) IS07816 Protocol: T = 1 */
#define   US_SPI_MR_MODE_IRDA       (0x8u <<  0) /**< \brief (US_SPI_MR) IrDA */
#define   US_SPI_MR_MODE_LIN_MASTER (0xAu <<  0) /**< \brief (US_SPI_MR) LIN Master */
#define   US_SPI_MR_MODE_LIN_SLAVE  (0xBu <<  0) /**< \brief (US_SPI_MR) LIN Slave */
#define   US_SPI_MR_MODE_SPI_MASTER (0xEu <<  0) /**< \brief (US_SPI_MR) SPI Master */
#define   US_SPI_MR_MODE_SPI_SLAVE  (0xFu <<  0) /**< \brief (US_SPI_MR) SPI Slave */
#define US_SPI_MR_USCLKS_Pos        4
#define US_SPI_MR_USCLKS_Msk        (0x3u << US_SPI_MR_USCLKS_Pos) /**< \brief (US_SPI_MR) Clock Selection */
#define US_SPI_MR_USCLKS(value)     ((US_SPI_MR_USCLKS_Msk & ((value) << US_SPI_MR_USCLKS_Pos)))
#define   US_SPI_MR_USCLKS_MCK      (0x0u <<  4) /**< \brief (US_SPI_MR) MCK */
#define   US_SPI_MR_USCLKS_MCK_DIV  (0x1u <<  4) /**< \brief (US_SPI_MR) MCK / DIV */
#define   US_SPI_MR_USCLKS_2        (0x2u <<  4) /**< \brief (US_SPI_MR) Reserved */
#define   US_SPI_MR_USCLKS_SCK      (0x3u <<  4) /**< \brief (US_SPI_MR) SCK */
#define US_SPI_MR_CHRL_Pos          6
#define US_SPI_MR_CHRL_Msk          (0x3u << US_SPI_MR_CHRL_Pos) /**< \brief (US_SPI_MR) Character Length. */
#define US_SPI_MR_CHRL(value)       ((US_SPI_MR_CHRL_Msk & ((value) << US_SPI_MR_CHRL_Pos)))
#define   US_SPI_MR_CHRL_5          (0x0u <<  6) /**< \brief (US_SPI_MR) 5 bits */
#define   US_SPI_MR_CHRL_6          (0x1u <<  6) /**< \brief (US_SPI_MR) 6 bits */
#define   US_SPI_MR_CHRL_7          (0x2u <<  6) /**< \brief (US_SPI_MR) 7 bits */
#define   US_SPI_MR_CHRL_8          (0x3u <<  6) /**< \brief (US_SPI_MR) 8 bits */
#define US_SPI_MR_CPHA              (0x1u <<  8) /**< \brief (US_SPI_MR) SPI CLock Phase */
#define   US_SPI_MR_CPHA_0          (0x0u <<  8) /**< \brief (US_SPI_MR) Data is changed on the leading edge of SPCK and captured on the following edge of SPCK */
#define   US_SPI_MR_CPHA_1          (0x1u <<  8) /**< \brief (US_SPI_MR) Data is captured on the leading edge of SPCK and changed on the following edge of SPCK */
#define US_SPI_MR_PAR_Pos           9
#define US_SPI_MR_PAR_Msk           (0x7u << US_SPI_MR_PAR_Pos) /**< \brief (US_SPI_MR) Parity Type */
#define US_SPI_MR_PAR(value)        ((US_SPI_MR_PAR_Msk & ((value) << US_SPI_MR_PAR_Pos)))
#define   US_SPI_MR_PAR_EVEN        (0x0u <<  9) /**< \brief (US_SPI_MR) Even parity */
#define   US_SPI_MR_PAR_ODD         (0x1u <<  9) /**< \brief (US_SPI_MR) Odd parity */
#define   US_SPI_MR_PAR_SPACE       (0x2u <<  9) /**< \brief (US_SPI_MR) Parity forced to 0 (Space) */
#define   US_SPI_MR_PAR_MARK        (0x3u <<  9) /**< \brief (US_SPI_MR) Parity forced to 1 (Mark) */
#define   US_SPI_MR_PAR_NONE        (0x4u <<  9) /**< \brief (US_SPI_MR) No Parity */
#define   US_SPI_MR_PAR_5           (0x5u <<  9) /**< \brief (US_SPI_MR) No Parity */
#define   US_SPI_MR_PAR_MULTI       (0x6u <<  9) /**< \brief (US_SPI_MR) Multi-drop mode */
#define   US_SPI_MR_PAR_7           (0x7u <<  9) /**< \brief (US_SPI_MR) Multi-drop mode */
#define US_SPI_MR_NBSTOP_Pos        12
#define US_SPI_MR_NBSTOP_Msk        (0x3u << US_SPI_MR_NBSTOP_Pos) /**< \brief (US_SPI_MR) Number of Stop Bits */
#define US_SPI_MR_NBSTOP(value)     ((US_SPI_MR_NBSTOP_Msk & ((value) << US_SPI_MR_NBSTOP_Pos)))
#define   US_SPI_MR_NBSTOP_1        (0x0u << 12) /**< \brief (US_SPI_MR) 1 stop bit */
#define   US_SPI_MR_NBSTOP_1_5      (0x1u << 12) /**< \brief (US_SPI_MR) 1.5 stop bits (Only valid if SYNC=0) */
#define   US_SPI_MR_NBSTOP_2        (0x2u << 12) /**< \brief (US_SPI_MR) 2 stop bits */
#define   US_SPI_MR_NBSTOP_3        (0x3u << 12) /**< \brief (US_SPI_MR) Reserved */
#define US_SPI_MR_CHMODE_Pos        14
#define US_SPI_MR_CHMODE_Msk        (0x3u << US_SPI_MR_CHMODE_Pos) /**< \brief (US_SPI_MR) Channel Mode */
#define US_SPI_MR_CHMODE(value)     ((US_SPI_MR_CHMODE_Msk & ((value) << US_SPI_MR_CHMODE_Pos)))
#define   US_SPI_MR_CHMODE_NORMAL   (0x0u << 14) /**< \brief (US_SPI_MR) Normal Mode */
#define   US_SPI_MR_CHMODE_ECHO     (0x1u << 14) /**< \brief (US_SPI_MR) Automatic Echo. Receiver input is connected to the TXD pin */
#define   US_SPI_MR_CHMODE_LOCAL_LOOP (0x2u << 14) /**< \brief (US_SPI_MR) Local Loopback. Transmitter output is connected to the Receiver Input */
#define   US_SPI_MR_CHMODE_REMOTE_LOOP (0x3u << 14) /**< \brief (US_SPI_MR) Remote Loopback. RXD pin is internally connected to the TXD pin */
#define US_SPI_MR_CPOL              (0x1u << 16) /**< \brief (US_SPI_MR) SPI Clock Polarity */
#define   US_SPI_MR_CPOL_ZERO       (0x0u << 16) /**< \brief (US_SPI_MR) The inactive state value of SPCK is logic level zero */
#define   US_SPI_MR_CPOL_ONE        (0x1u << 16) /**< \brief (US_SPI_MR) The inactive state value of SPCK is logic level one */
#define US_SPI_MR_MODE9             (0x1u << 17) /**< \brief (US_SPI_MR) 9-bit Character Length */
#define   US_SPI_MR_MODE9_0         (0x0u << 17) /**< \brief (US_SPI_MR) CHRL defines character length */
#define   US_SPI_MR_MODE9_1         (0x1u << 17) /**< \brief (US_SPI_MR) 9-bit character length */
#define US_SPI_MR_CLKO              (0x1u << 18) /**< \brief (US_SPI_MR) Clock Output Select */
#define   US_SPI_MR_CLKO_0          (0x0u << 18) /**< \brief (US_SPI_MR) The USART does not drive the SCK pin */
#define   US_SPI_MR_CLKO_1          (0x1u << 18) /**< \brief (US_SPI_MR) The USART drives the SCK pin if USCLKS does not select the external clock SCK */
#define US_SPI_MR_OVER              (0x1u << 19) /**< \brief (US_SPI_MR) Oversampling Mode */
#define   US_SPI_MR_OVER_X16        (0x0u << 19) /**< \brief (US_SPI_MR) 16x Oversampling */
#define   US_SPI_MR_OVER_X8         (0x1u << 19) /**< \brief (US_SPI_MR) 8x Oversampling */
#define US_SPI_MR_INACK             (0x1u << 20) /**< \brief (US_SPI_MR) Inhibit Non Acknowledge */
#define   US_SPI_MR_INACK_0         (0x0u << 20) /**< \brief (US_SPI_MR) The NACK is generated */
#define   US_SPI_MR_INACK_1         (0x1u << 20) /**< \brief (US_SPI_MR) The NACK is not generated */
#define US_SPI_MR_DSNACK            (0x1u << 21) /**< \brief (US_SPI_MR) Disable Successive NACK */
#define   US_SPI_MR_DSNACK_0        (0x0u << 21) /**< \brief (US_SPI_MR) NACK is sent on the ISO line as soon as a parity error occurs in the received character (unless INACK is set) */
#define   US_SPI_MR_DSNACK_1        (0x1u << 21) /**< \brief (US_SPI_MR) Successive parity errors are counted up to the value specified in the MAX_ITERATION field. These parity errors generatea NACK on the ISO line. As soon as this value is reached, no additional NACK is sent on the ISO line. The flag ITERATION is asserted */
#define US_SPI_MR_INVDATA           (0x1u << 23) /**< \brief (US_SPI_MR) Inverted data */
#define US_SPI_MR_MAX_ITERATION_Pos    24
#define US_SPI_MR_MAX_ITERATION_Msk    (0x7u << US_SPI_MR_MAX_ITERATION_Pos) /**< \brief (US_SPI_MR) Max interation */
#define US_SPI_MR_MAX_ITERATION(value) ((US_SPI_MR_MAX_ITERATION_Msk & ((value) << US_SPI_MR_MAX_ITERATION_Pos)))
#define US_SPI_MR_FILTER            (0x1u << 28) /**< \brief (US_SPI_MR) Infrared Receive Line Filter */
#define   US_SPI_MR_FILTER_0        (0x0u << 28) /**< \brief (US_SPI_MR) The USART does not filter the receive line */
#define   US_SPI_MR_FILTER_1        (0x1u << 28) /**< \brief (US_SPI_MR) The USART filters the receive line using a three-sample filter (1/16-bit clock) (2 over 3 majority) */
/* -------- US_USART_MR : (USART Offset: 0x04) Mode Register -------- */
#define US_USART_MR_MODE_Pos        0
#define US_USART_MR_MODE_Msk        (0xFu << US_USART_MR_MODE_Pos) /**< \brief (US_USART_MR) Usart Mode */
#define US_USART_MR_MODE(value)     ((US_USART_MR_MODE_Msk & ((value) << US_USART_MR_MODE_Pos)))
#define   US_USART_MR_MODE_NORMAL   (0x0u <<  0) /**< \brief (US_USART_MR) Normal */
#define   US_USART_MR_MODE_RS485    (0x1u <<  0) /**< \brief (US_USART_MR) RS485 */
#define   US_USART_MR_MODE_HARDWARE (0x2u <<  0) /**< \brief (US_USART_MR) Hardware Handshaking */
#define   US_USART_MR_MODE_MODEM    (0x3u <<  0) /**< \brief (US_USART_MR) Modem */
#define   US_USART_MR_MODE_ISO7816_T0 (0x4u <<  0) /**< \brief (US_USART_MR) IS07816 Protocol: T = 0 */
#define   US_USART_MR_MODE_ISO7816_T1 (0x6u <<  0) /**< \brief (US_USART_MR) IS07816 Protocol: T = 1 */
#define   US_USART_MR_MODE_IRDA     (0x8u <<  0) /**< \brief (US_USART_MR) IrDA */
#define   US_USART_MR_MODE_LIN_MASTER (0xAu <<  0) /**< \brief (US_USART_MR) LIN Master */
#define   US_USART_MR_MODE_LIN_SLAVE (0xBu <<  0) /**< \brief (US_USART_MR) LIN Slave */
#define   US_USART_MR_MODE_SPI_MASTER (0xEu <<  0) /**< \brief (US_USART_MR) SPI Master */
#define   US_USART_MR_MODE_SPI_SLAVE (0xFu <<  0) /**< \brief (US_USART_MR) SPI Slave */
#define US_USART_MR_USCLKS_Pos      4
#define US_USART_MR_USCLKS_Msk      (0x3u << US_USART_MR_USCLKS_Pos) /**< \brief (US_USART_MR) Clock Selection */
#define US_USART_MR_USCLKS(value)   ((US_USART_MR_USCLKS_Msk & ((value) << US_USART_MR_USCLKS_Pos)))
#define   US_USART_MR_USCLKS_MCK    (0x0u <<  4) /**< \brief (US_USART_MR) MCK */
#define   US_USART_MR_USCLKS_MCK_DIV (0x1u <<  4) /**< \brief (US_USART_MR) MCK / DIV */
#define   US_USART_MR_USCLKS_2      (0x2u <<  4) /**< \brief (US_USART_MR) Reserved */
#define   US_USART_MR_USCLKS_SCK    (0x3u <<  4) /**< \brief (US_USART_MR) SCK */
#define US_USART_MR_CHRL_Pos        6
#define US_USART_MR_CHRL_Msk        (0x3u << US_USART_MR_CHRL_Pos) /**< \brief (US_USART_MR) Character Length. */
#define US_USART_MR_CHRL(value)     ((US_USART_MR_CHRL_Msk & ((value) << US_USART_MR_CHRL_Pos)))
#define   US_USART_MR_CHRL_5        (0x0u <<  6) /**< \brief (US_USART_MR) 5 bits */
#define   US_USART_MR_CHRL_6        (0x1u <<  6) /**< \brief (US_USART_MR) 6 bits */
#define   US_USART_MR_CHRL_7        (0x2u <<  6) /**< \brief (US_USART_MR) 7 bits */
#define   US_USART_MR_CHRL_8        (0x3u <<  6) /**< \brief (US_USART_MR) 8 bits */
#define US_USART_MR_SYNC            (0x1u <<  8) /**< \brief (US_USART_MR) Synchronous Mode Select */
#define   US_USART_MR_SYNC_0        (0x0u <<  8) /**< \brief (US_USART_MR) USART operates in Synchronous Mode */
#define   US_USART_MR_SYNC_1        (0x1u <<  8) /**< \brief (US_USART_MR) USART operates in Asynchronous Mode */
#define US_USART_MR_PAR_Pos         9
#define US_USART_MR_PAR_Msk         (0x7u << US_USART_MR_PAR_Pos) /**< \brief (US_USART_MR) Parity Type */
#define US_USART_MR_PAR(value)      ((US_USART_MR_PAR_Msk & ((value) << US_USART_MR_PAR_Pos)))
#define   US_USART_MR_PAR_EVEN      (0x0u <<  9) /**< \brief (US_USART_MR) Even parity */
#define   US_USART_MR_PAR_ODD       (0x1u <<  9) /**< \brief (US_USART_MR) Odd parity */
#define   US_USART_MR_PAR_SPACE     (0x2u <<  9) /**< \brief (US_USART_MR) Parity forced to 0 (Space) */
#define   US_USART_MR_PAR_MARK      (0x3u <<  9) /**< \brief (US_USART_MR) Parity forced to 1 (Mark) */
#define   US_USART_MR_PAR_NONE      (0x4u <<  9) /**< \brief (US_USART_MR) No Parity */
#define   US_USART_MR_PAR_5         (0x5u <<  9) /**< \brief (US_USART_MR) No Parity */
#define   US_USART_MR_PAR_MULTI     (0x6u <<  9) /**< \brief (US_USART_MR) Multi-drop mode */
#define   US_USART_MR_PAR_7         (0x7u <<  9) /**< \brief (US_USART_MR) Multi-drop mode */
#define US_USART_MR_NBSTOP_Pos      12
#define US_USART_MR_NBSTOP_Msk      (0x3u << US_USART_MR_NBSTOP_Pos) /**< \brief (US_USART_MR) Number of Stop Bits */
#define US_USART_MR_NBSTOP(value)   ((US_USART_MR_NBSTOP_Msk & ((value) << US_USART_MR_NBSTOP_Pos)))
#define   US_USART_MR_NBSTOP_1      (0x0u << 12) /**< \brief (US_USART_MR) 1 stop bit */
#define   US_USART_MR_NBSTOP_1_5    (0x1u << 12) /**< \brief (US_USART_MR) 1.5 stop bits (Only valid if SYNC=0) */
#define   US_USART_MR_NBSTOP_2      (0x2u << 12) /**< \brief (US_USART_MR) 2 stop bits */
#define   US_USART_MR_NBSTOP_3      (0x3u << 12) /**< \brief (US_USART_MR) Reserved */
#define US_USART_MR_CHMODE_Pos      14
#define US_USART_MR_CHMODE_Msk      (0x3u << US_USART_MR_CHMODE_Pos) /**< \brief (US_USART_MR) Channel Mode */
#define US_USART_MR_CHMODE(value)   ((US_USART_MR_CHMODE_Msk & ((value) << US_USART_MR_CHMODE_Pos)))
#define   US_USART_MR_CHMODE_NORMAL (0x0u << 14) /**< \brief (US_USART_MR) Normal Mode */
#define   US_USART_MR_CHMODE_ECHO   (0x1u << 14) /**< \brief (US_USART_MR) Automatic Echo. Receiver input is connected to the TXD pin */
#define   US_USART_MR_CHMODE_LOCAL_LOOP (0x2u << 14) /**< \brief (US_USART_MR) Local Loopback. Transmitter output is connected to the Receiver Input */
#define   US_USART_MR_CHMODE_REMOTE_LOOP (0x3u << 14) /**< \brief (US_USART_MR) Remote Loopback. RXD pin is internally connected to the TXD pin */
#define US_USART_MR_MSBF            (0x1u << 16) /**< \brief (US_USART_MR) Bit Order */
#define   US_USART_MR_MSBF_LSBF     (0x0u << 16) /**< \brief (US_USART_MR) Least Significant Bit first */
#define   US_USART_MR_MSBF_MSBF     (0x1u << 16) /**< \brief (US_USART_MR) Most Significant Bit first */
#define US_USART_MR_MODE9           (0x1u << 17) /**< \brief (US_USART_MR) 9-bit Character Length */
#define   US_USART_MR_MODE9_0       (0x0u << 17) /**< \brief (US_USART_MR) CHRL defines character length */
#define   US_USART_MR_MODE9_1       (0x1u << 17) /**< \brief (US_USART_MR) 9-bit character length */
#define US_USART_MR_CLKO            (0x1u << 18) /**< \brief (US_USART_MR) Clock Output Select */
#define   US_USART_MR_CLKO_0        (0x0u << 18) /**< \brief (US_USART_MR) The USART does not drive the SCK pin */
#define   US_USART_MR_CLKO_1        (0x1u << 18) /**< \brief (US_USART_MR) The USART drives the SCK pin if USCLKS does not select the external clock SCK */
#define US_USART_MR_OVER            (0x1u << 19) /**< \brief (US_USART_MR) Oversampling Mode */
#define   US_USART_MR_OVER_X16      (0x0u << 19) /**< \brief (US_USART_MR) 16x Oversampling */
#define   US_USART_MR_OVER_X8       (0x1u << 19) /**< \brief (US_USART_MR) 8x Oversampling */
#define US_USART_MR_INACK           (0x1u << 20) /**< \brief (US_USART_MR) Inhibit Non Acknowledge */
#define   US_USART_MR_INACK_0       (0x0u << 20) /**< \brief (US_USART_MR) The NACK is generated */
#define   US_USART_MR_INACK_1       (0x1u << 20) /**< \brief (US_USART_MR) The NACK is not generated */
#define US_USART_MR_DSNACK          (0x1u << 21) /**< \brief (US_USART_MR) Disable Successive NACK */
#define   US_USART_MR_DSNACK_0      (0x0u << 21) /**< \brief (US_USART_MR) NACK is sent on the ISO line as soon as a parity error occurs in the received character (unless INACK is set) */
#define   US_USART_MR_DSNACK_1      (0x1u << 21) /**< \brief (US_USART_MR) Successive parity errors are counted up to the value specified in the MAX_ITERATION field. These parity errors generatea NACK on the ISO line. As soon as this value is reached, no additional NACK is sent on the ISO line. The flag ITERATION is asserted */
#define US_USART_MR_VAR_SYNC        (0x1u << 22) /**< \brief (US_USART_MR) Variable synchronization of command/data sync Start Frame Delimiter */
#define   US_USART_MR_VAR_SYNC_0    (0x0u << 22) /**< \brief (US_USART_MR) User defined configuration of command or data sync field depending on SYNC value */
#define   US_USART_MR_VAR_SYNC_1    (0x1u << 22) /**< \brief (US_USART_MR) The sync field is updated when a character is written into THR register */
#define US_USART_MR_INVDATA         (0x1u << 23) /**< \brief (US_USART_MR) Inverted data */
#define US_USART_MR_MAX_ITERATION_Pos    24
#define US_USART_MR_MAX_ITERATION_Msk    (0x7u << US_USART_MR_MAX_ITERATION_Pos) /**< \brief (US_USART_MR) Max interation */
#define US_USART_MR_MAX_ITERATION(value) ((US_USART_MR_MAX_ITERATION_Msk & ((value) << US_USART_MR_MAX_ITERATION_Pos)))
#define US_USART_MR_FILTER          (0x1u << 28) /**< \brief (US_USART_MR) Infrared Receive Line Filter */
#define   US_USART_MR_FILTER_0      (0x0u << 28) /**< \brief (US_USART_MR) The USART does not filter the receive line */
#define   US_USART_MR_FILTER_1      (0x1u << 28) /**< \brief (US_USART_MR) The USART filters the receive line using a three-sample filter (1/16-bit clock) (2 over 3 majority) */
#define US_USART_MR_MAN             (0x1u << 29) /**< \brief (US_USART_MR) Manchester Encoder/Decoder Enable */
#define   US_USART_MR_MAN_0         (0x0u << 29) /**< \brief (US_USART_MR) Manchester Encoder/Decoder is disabled */
#define   US_USART_MR_MAN_1         (0x1u << 29) /**< \brief (US_USART_MR) Manchester Encoder/Decoder is enabled */
#define US_USART_MR_MODSYNC         (0x1u << 30) /**< \brief (US_USART_MR) Manchester Synchronization Mode */
#define   US_USART_MR_MODSYNC_0     (0x0u << 30) /**< \brief (US_USART_MR) The Manchester Start bit is a 0 to 1 transition */
#define   US_USART_MR_MODSYNC_1     (0x1u << 30) /**< \brief (US_USART_MR) The Manchester Start bit is a 1 to 0 transition */
#define US_USART_MR_ONEBIT          (0x1u << 31) /**< \brief (US_USART_MR) Start Frame Delimiter selector */
#define   US_USART_MR_ONEBIT_0      (0x0u << 31) /**< \brief (US_USART_MR) Start Frame delimiter is COMMAND or DATA SYNC */
#define   US_USART_MR_ONEBIT_1      (0x1u << 31) /**< \brief (US_USART_MR) Start Frame delimiter is One Bit */
/* -------- US_LIN_IER : (USART Offset: 0x08) Interrupt Enable Register -------- */
#define US_LIN_IER_RXRDY            (0x1u <<  0) /**< \brief (US_LIN_IER) Receiver Ready Interrupt Enable */
#define   US_LIN_IER_RXRDY_0        (0x0u <<  0) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_RXRDY_1        (0x1u <<  0) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_TXRDY            (0x1u <<  1) /**< \brief (US_LIN_IER) Transmitter Ready Interrupt Enable */
#define   US_LIN_IER_TXRDY_0        (0x0u <<  1) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_TXRDY_1        (0x1u <<  1) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_RXBRK            (0x1u <<  2) /**< \brief (US_LIN_IER) Receiver Break Interrupt Enable */
#define   US_LIN_IER_RXBRK_0        (0x0u <<  2) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_RXBRK_1        (0x1u <<  2) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_ENDRX            (0x1u <<  3) /**< \brief (US_LIN_IER) End of Receive Transfer Interrupt Enable */
#define   US_LIN_IER_ENDRX_0        (0x0u <<  3) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_ENDRX_1        (0x1u <<  3) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_ENDTX            (0x1u <<  4) /**< \brief (US_LIN_IER) End of Transmit Interrupt Enable */
#define   US_LIN_IER_ENDTX_0        (0x0u <<  4) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_ENDTX_1        (0x1u <<  4) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_OVRE             (0x1u <<  5) /**< \brief (US_LIN_IER) Overrun Error Interrupt Enable */
#define   US_LIN_IER_OVRE_0         (0x0u <<  5) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_OVRE_1         (0x1u <<  5) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_FRAME            (0x1u <<  6) /**< \brief (US_LIN_IER) Framing Error Interrupt Enable */
#define   US_LIN_IER_FRAME_0        (0x0u <<  6) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_FRAME_1        (0x1u <<  6) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_PARE             (0x1u <<  7) /**< \brief (US_LIN_IER) Parity Error Interrupt Enable */
#define   US_LIN_IER_PARE_0         (0x0u <<  7) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_PARE_1         (0x1u <<  7) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_TIMEOUT          (0x1u <<  8) /**< \brief (US_LIN_IER) Time-out Interrupt Enable */
#define   US_LIN_IER_TIMEOUT_0      (0x0u <<  8) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_TIMEOUT_1      (0x1u <<  8) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_TXEMPTY          (0x1u <<  9) /**< \brief (US_LIN_IER) Transmitter Empty Interrupt Enable */
#define   US_LIN_IER_TXEMPTY_0      (0x0u <<  9) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_TXEMPTY_1      (0x1u <<  9) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_ITER             (0x1u << 10) /**< \brief (US_LIN_IER) Iteration Interrupt Enable */
#define   US_LIN_IER_ITER_0         (0x0u << 10) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_ITER_1         (0x1u << 10) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_TXBUFE           (0x1u << 11) /**< \brief (US_LIN_IER) Buffer Empty Interrupt Enable */
#define   US_LIN_IER_TXBUFE_0       (0x0u << 11) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_TXBUFE_1       (0x1u << 11) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_RXBUFF           (0x1u << 12) /**< \brief (US_LIN_IER) Buffer Full Interrupt Enable */
#define   US_LIN_IER_RXBUFF_0       (0x0u << 12) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_RXBUFF_1       (0x1u << 12) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_NACK             (0x1u << 13) /**< \brief (US_LIN_IER) Non Acknowledge  or LIN Break Sent or LIN Break Received Interrupt Enable */
#define   US_LIN_IER_NACK_0         (0x0u << 13) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_NACK_1         (0x1u << 13) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_LINID            (0x1u << 14) /**< \brief (US_LIN_IER) LIN Identifier Sent or LIN Identifier Received Interrupt Enable */
#define US_LIN_IER_LINTC            (0x1u << 15) /**< \brief (US_LIN_IER) LIN Transfer Conpleted Interrupt Enable */
#define US_LIN_IER_RIIC             (0x1u << 16) /**< \brief (US_LIN_IER) Ring Indicator Input Change Enable */
#define   US_LIN_IER_RIIC_0         (0x0u << 16) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_RIIC_1         (0x1u << 16) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_DSRIC            (0x1u << 17) /**< \brief (US_LIN_IER) Data Set Ready Input Change Enable */
#define   US_LIN_IER_DSRIC_0        (0x0u << 17) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_DSRIC_1        (0x1u << 17) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_DCDIC            (0x1u << 18) /**< \brief (US_LIN_IER) Data Carrier Detect Input Change Interrupt Enable */
#define   US_LIN_IER_DCDIC_0        (0x0u << 18) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_DCDIC_1        (0x1u << 18) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_CTSIC            (0x1u << 19) /**< \brief (US_LIN_IER) Clear to Send Input Change Interrupt Enable */
#define   US_LIN_IER_CTSIC_0        (0x0u << 19) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_CTSIC_1        (0x1u << 19) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_LINBE            (0x1u << 25) /**< \brief (US_LIN_IER) LIN Bus Error Interrupt Enable */
#define US_LIN_IER_LINISFE          (0x1u << 26) /**< \brief (US_LIN_IER) LIN Inconsistent Synch Field Error Interrupt Enable */
#define US_LIN_IER_LINIPE           (0x1u << 27) /**< \brief (US_LIN_IER) LIN Identifier Parity Interrupt Enable */
#define US_LIN_IER_LINCE            (0x1u << 28) /**< \brief (US_LIN_IER) LIN Checksum Error Interrupt Enable */
#define US_LIN_IER_LINSNRE          (0x1u << 29) /**< \brief (US_LIN_IER) LIN Slave Not Responding Error Interrupt Enable */
#define US_LIN_IER_LINSTE           (0x1u << 30) /**< \brief (US_LIN_IER) LIN Synch Tolerance Error Interrupt Enable */
#define   US_LIN_IER_LINSTE_0       (0x0u << 30) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_LINSTE_1       (0x1u << 30) /**< \brief (US_LIN_IER) Enables the interrupt */
#define US_LIN_IER_LINHTE           (0x1u << 31) /**< \brief (US_LIN_IER) LIN Header Timeout Error Interrupt Enable */
#define   US_LIN_IER_LINHTE_0       (0x0u << 31) /**< \brief (US_LIN_IER) No Effect */
#define   US_LIN_IER_LINHTE_1       (0x1u << 31) /**< \brief (US_LIN_IER) Enables the interrupt */
/* -------- US_SPI_SLAVE_IER : (USART Offset: 0x08) Interrupt Enable Register -------- */
#define US_SPI_SLAVE_IER_RXRDY      (0x1u <<  0) /**< \brief (US_SPI_SLAVE_IER) Receiver Ready Interrupt Enable */
#define   US_SPI_SLAVE_IER_RXRDY_0  (0x0u <<  0) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_RXRDY_1  (0x1u <<  0) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_TXRDY      (0x1u <<  1) /**< \brief (US_SPI_SLAVE_IER) Transmitter Ready Interrupt Enable */
#define   US_SPI_SLAVE_IER_TXRDY_0  (0x0u <<  1) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_TXRDY_1  (0x1u <<  1) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_RXBRK      (0x1u <<  2) /**< \brief (US_SPI_SLAVE_IER) Receiver Break Interrupt Enable */
#define   US_SPI_SLAVE_IER_RXBRK_0  (0x0u <<  2) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_RXBRK_1  (0x1u <<  2) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_ENDRX      (0x1u <<  3) /**< \brief (US_SPI_SLAVE_IER) End of Receive Transfer Interrupt Enable */
#define   US_SPI_SLAVE_IER_ENDRX_0  (0x0u <<  3) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_ENDRX_1  (0x1u <<  3) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_ENDTX      (0x1u <<  4) /**< \brief (US_SPI_SLAVE_IER) End of Transmit Interrupt Enable */
#define   US_SPI_SLAVE_IER_ENDTX_0  (0x0u <<  4) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_ENDTX_1  (0x1u <<  4) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_OVRE       (0x1u <<  5) /**< \brief (US_SPI_SLAVE_IER) Overrun Error Interrupt Enable */
#define   US_SPI_SLAVE_IER_OVRE_0   (0x0u <<  5) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_OVRE_1   (0x1u <<  5) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_FRAME      (0x1u <<  6) /**< \brief (US_SPI_SLAVE_IER) Framing Error Interrupt Enable */
#define   US_SPI_SLAVE_IER_FRAME_0  (0x0u <<  6) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_FRAME_1  (0x1u <<  6) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_PARE       (0x1u <<  7) /**< \brief (US_SPI_SLAVE_IER) Parity Error Interrupt Enable */
#define   US_SPI_SLAVE_IER_PARE_0   (0x0u <<  7) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_PARE_1   (0x1u <<  7) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_TIMEOUT    (0x1u <<  8) /**< \brief (US_SPI_SLAVE_IER) Time-out Interrupt Enable */
#define   US_SPI_SLAVE_IER_TIMEOUT_0 (0x0u <<  8) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_TIMEOUT_1 (0x1u <<  8) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_TXEMPTY    (0x1u <<  9) /**< \brief (US_SPI_SLAVE_IER) Transmitter Empty Interrupt Enable */
#define   US_SPI_SLAVE_IER_TXEMPTY_0 (0x0u <<  9) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_TXEMPTY_1 (0x1u <<  9) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_UNRE       (0x1u << 10) /**< \brief (US_SPI_SLAVE_IER) SPI Underrun Error Interrupt Enable */
#define   US_SPI_SLAVE_IER_UNRE_0   (0x0u << 10) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_UNRE_1   (0x1u << 10) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_TXBUFE     (0x1u << 11) /**< \brief (US_SPI_SLAVE_IER) Buffer Empty Interrupt Enable */
#define   US_SPI_SLAVE_IER_TXBUFE_0 (0x0u << 11) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_TXBUFE_1 (0x1u << 11) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_RXBUFF     (0x1u << 12) /**< \brief (US_SPI_SLAVE_IER) Buffer Full Interrupt Enable */
#define   US_SPI_SLAVE_IER_RXBUFF_0 (0x0u << 12) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_RXBUFF_1 (0x1u << 12) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_NACK       (0x1u << 13) /**< \brief (US_SPI_SLAVE_IER) Non Acknowledge Interrupt Enable */
#define   US_SPI_SLAVE_IER_NACK_0   (0x0u << 13) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_NACK_1   (0x1u << 13) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_RIIC       (0x1u << 16) /**< \brief (US_SPI_SLAVE_IER) Ring Indicator Input Change Enable */
#define   US_SPI_SLAVE_IER_RIIC_0   (0x0u << 16) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_RIIC_1   (0x1u << 16) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_DSRIC      (0x1u << 17) /**< \brief (US_SPI_SLAVE_IER) Data Set Ready Input Change Enable */
#define   US_SPI_SLAVE_IER_DSRIC_0  (0x0u << 17) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_DSRIC_1  (0x1u << 17) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_DCDIC      (0x1u << 18) /**< \brief (US_SPI_SLAVE_IER) Data Carrier Detect Input Change Interrupt Enable */
#define   US_SPI_SLAVE_IER_DCDIC_0  (0x0u << 18) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_DCDIC_1  (0x1u << 18) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
#define US_SPI_SLAVE_IER_CTSIC      (0x1u << 19) /**< \brief (US_SPI_SLAVE_IER) Clear to Send Input Change Interrupt Enable */
#define   US_SPI_SLAVE_IER_CTSIC_0  (0x0u << 19) /**< \brief (US_SPI_SLAVE_IER) No Effect */
#define   US_SPI_SLAVE_IER_CTSIC_1  (0x1u << 19) /**< \brief (US_SPI_SLAVE_IER) Enables the interrupt */
/* -------- US_USART_IER : (USART Offset: 0x08) Interrupt Enable Register -------- */
#define US_USART_IER_RXRDY          (0x1u <<  0) /**< \brief (US_USART_IER) Receiver Ready Interrupt Enable */
#define   US_USART_IER_RXRDY_0      (0x0u <<  0) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_RXRDY_1      (0x1u <<  0) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_TXRDY          (0x1u <<  1) /**< \brief (US_USART_IER) Transmitter Ready Interrupt Enable */
#define   US_USART_IER_TXRDY_0      (0x0u <<  1) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_TXRDY_1      (0x1u <<  1) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_RXBRK          (0x1u <<  2) /**< \brief (US_USART_IER) Receiver Break Interrupt Enable */
#define   US_USART_IER_RXBRK_0      (0x0u <<  2) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_RXBRK_1      (0x1u <<  2) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_ENDRX          (0x1u <<  3) /**< \brief (US_USART_IER) End of Receive Transfer Interrupt Enable */
#define   US_USART_IER_ENDRX_0      (0x0u <<  3) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_ENDRX_1      (0x1u <<  3) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_ENDTX          (0x1u <<  4) /**< \brief (US_USART_IER) End of Transmit Interrupt Enable */
#define   US_USART_IER_ENDTX_0      (0x0u <<  4) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_ENDTX_1      (0x1u <<  4) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_OVRE           (0x1u <<  5) /**< \brief (US_USART_IER) Overrun Error Interrupt Enable */
#define   US_USART_IER_OVRE_0       (0x0u <<  5) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_OVRE_1       (0x1u <<  5) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_FRAME          (0x1u <<  6) /**< \brief (US_USART_IER) Framing Error Interrupt Enable */
#define   US_USART_IER_FRAME_0      (0x0u <<  6) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_FRAME_1      (0x1u <<  6) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_PARE           (0x1u <<  7) /**< \brief (US_USART_IER) Parity Error Interrupt Enable */
#define   US_USART_IER_PARE_0       (0x0u <<  7) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_PARE_1       (0x1u <<  7) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_TIMEOUT        (0x1u <<  8) /**< \brief (US_USART_IER) Time-out Interrupt Enable */
#define   US_USART_IER_TIMEOUT_0    (0x0u <<  8) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_TIMEOUT_1    (0x1u <<  8) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_TXEMPTY        (0x1u <<  9) /**< \brief (US_USART_IER) Transmitter Empty Interrupt Enable */
#define   US_USART_IER_TXEMPTY_0    (0x0u <<  9) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_TXEMPTY_1    (0x1u <<  9) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_ITER           (0x1u << 10) /**< \brief (US_USART_IER) Iteration Interrupt Enable */
#define   US_USART_IER_ITER_0       (0x0u << 10) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_ITER_1       (0x1u << 10) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_TXBUFE         (0x1u << 11) /**< \brief (US_USART_IER) Buffer Empty Interrupt Enable */
#define   US_USART_IER_TXBUFE_0     (0x0u << 11) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_TXBUFE_1     (0x1u << 11) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_RXBUFF         (0x1u << 12) /**< \brief (US_USART_IER) Buffer Full Interrupt Enable */
#define   US_USART_IER_RXBUFF_0     (0x0u << 12) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_RXBUFF_1     (0x1u << 12) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_NACK           (0x1u << 13) /**< \brief (US_USART_IER) Non Acknowledge Interrupt Enable */
#define   US_USART_IER_NACK_0       (0x0u << 13) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_NACK_1       (0x1u << 13) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_RIIC           (0x1u << 16) /**< \brief (US_USART_IER) Ring Indicator Input Change Enable */
#define   US_USART_IER_RIIC_0       (0x0u << 16) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_RIIC_1       (0x1u << 16) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_DSRIC          (0x1u << 17) /**< \brief (US_USART_IER) Data Set Ready Input Change Enable */
#define   US_USART_IER_DSRIC_0      (0x0u << 17) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_DSRIC_1      (0x1u << 17) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_DCDIC          (0x1u << 18) /**< \brief (US_USART_IER) Data Carrier Detect Input Change Interrupt Enable */
#define   US_USART_IER_DCDIC_0      (0x0u << 18) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_DCDIC_1      (0x1u << 18) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_CTSIC          (0x1u << 19) /**< \brief (US_USART_IER) Clear to Send Input Change Interrupt Enable */
#define   US_USART_IER_CTSIC_0      (0x0u << 19) /**< \brief (US_USART_IER) No Effect */
#define   US_USART_IER_CTSIC_1      (0x1u << 19) /**< \brief (US_USART_IER) Enables the interrupt */
#define US_USART_IER_MANE           (0x1u << 20) /**< \brief (US_USART_IER) Manchester Error Interrupt Enable */
#define US_USART_IER_MANEA          (0x1u << 24) /**< \brief (US_USART_IER) Manchester Error Interrupt Enable */
#define   US_USART_IER_MANEA_0      (0x0u << 24) /**< \brief (US_USART_IER) No effect */
#define   US_USART_IER_MANEA_1      (0x1u << 24) /**< \brief (US_USART_IER) Enables the interrupt */
/* -------- US_LIN_IDR : (USART Offset: 0x0C) Interrupt Disable Register -------- */
#define US_LIN_IDR_RXRDY            (0x1u <<  0) /**< \brief (US_LIN_IDR) Receiver Ready Interrupt Disable */
#define   US_LIN_IDR_RXRDY_0        (0x0u <<  0) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_RXRDY_1        (0x1u <<  0) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_TXRDY            (0x1u <<  1) /**< \brief (US_LIN_IDR) Transmitter Ready Interrupt Disable */
#define   US_LIN_IDR_TXRDY_0        (0x0u <<  1) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_TXRDY_1        (0x1u <<  1) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_RXBRK            (0x1u <<  2) /**< \brief (US_LIN_IDR) Receiver Break Interrupt Disable */
#define   US_LIN_IDR_RXBRK_0        (0x0u <<  2) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_RXBRK_1        (0x1u <<  2) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_ENDRX            (0x1u <<  3) /**< \brief (US_LIN_IDR) End of Receive Transfer Interrupt Disable */
#define   US_LIN_IDR_ENDRX_0        (0x0u <<  3) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_ENDRX_1        (0x1u <<  3) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_ENDTX            (0x1u <<  4) /**< \brief (US_LIN_IDR) End of Transmit Interrupt Disable */
#define   US_LIN_IDR_ENDTX_0        (0x0u <<  4) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_ENDTX_1        (0x1u <<  4) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_OVRE             (0x1u <<  5) /**< \brief (US_LIN_IDR) Overrun Error Interrupt Disable */
#define   US_LIN_IDR_OVRE_0         (0x0u <<  5) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_OVRE_1         (0x1u <<  5) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_FRAME            (0x1u <<  6) /**< \brief (US_LIN_IDR) Framing Error Interrupt Disable */
#define   US_LIN_IDR_FRAME_0        (0x0u <<  6) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_FRAME_1        (0x1u <<  6) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_PARE             (0x1u <<  7) /**< \brief (US_LIN_IDR) Parity Error Interrupt Disable */
#define   US_LIN_IDR_PARE_0         (0x0u <<  7) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_PARE_1         (0x1u <<  7) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_TIMEOUT          (0x1u <<  8) /**< \brief (US_LIN_IDR) Time-out Interrupt Disable */
#define   US_LIN_IDR_TIMEOUT_0      (0x0u <<  8) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_TIMEOUT_1      (0x1u <<  8) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_TXEMPTY          (0x1u <<  9) /**< \brief (US_LIN_IDR) Transmitter Empty Interrupt Disable */
#define   US_LIN_IDR_TXEMPTY_0      (0x0u <<  9) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_TXEMPTY_1      (0x1u <<  9) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_ITER             (0x1u << 10) /**< \brief (US_LIN_IDR) Iteration Interrupt Disable */
#define   US_LIN_IDR_ITER_0         (0x0u << 10) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_ITER_1         (0x1u << 10) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_TXBUFE           (0x1u << 11) /**< \brief (US_LIN_IDR) Buffer Empty Interrupt Disable */
#define   US_LIN_IDR_TXBUFE_0       (0x0u << 11) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_TXBUFE_1       (0x1u << 11) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_RXBUFF           (0x1u << 12) /**< \brief (US_LIN_IDR) Buffer Full Interrupt Disable */
#define   US_LIN_IDR_RXBUFF_0       (0x0u << 12) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_RXBUFF_1       (0x1u << 12) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_NACK             (0x1u << 13) /**< \brief (US_LIN_IDR) Non Acknowledge  or LIN Break Sent or LIN Break Received Interrupt Disable */
#define   US_LIN_IDR_NACK_0         (0x0u << 13) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_NACK_1         (0x1u << 13) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_LINID            (0x1u << 14) /**< \brief (US_LIN_IDR) LIN Identifier Sent or LIN Identifier Received Interrupt Disable */
#define US_LIN_IDR_LINTC            (0x1u << 15) /**< \brief (US_LIN_IDR) LIN Transfer Conpleted Interrupt Disable */
#define US_LIN_IDR_RIIC             (0x1u << 16) /**< \brief (US_LIN_IDR) Ring Indicator Input Change Disable */
#define   US_LIN_IDR_RIIC_0         (0x0u << 16) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_RIIC_1         (0x1u << 16) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_DSRIC            (0x1u << 17) /**< \brief (US_LIN_IDR) Data Set Ready Input Change Disable */
#define   US_LIN_IDR_DSRIC_0        (0x0u << 17) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_DSRIC_1        (0x1u << 17) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_DCDIC            (0x1u << 18) /**< \brief (US_LIN_IDR) Data Carrier Detect Input Change Interrupt Disable */
#define   US_LIN_IDR_DCDIC_0        (0x0u << 18) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_DCDIC_1        (0x1u << 18) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_CTSIC            (0x1u << 19) /**< \brief (US_LIN_IDR) Clear to Send Input Change Interrupt Disable */
#define   US_LIN_IDR_CTSIC_0        (0x0u << 19) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_CTSIC_1        (0x1u << 19) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_LINBE            (0x1u << 25) /**< \brief (US_LIN_IDR) LIN Bus Error Interrupt Disable */
#define US_LIN_IDR_LINISFE          (0x1u << 26) /**< \brief (US_LIN_IDR) LIN Inconsistent Synch Field Error Interrupt Disable */
#define US_LIN_IDR_LINIPE           (0x1u << 27) /**< \brief (US_LIN_IDR) LIN Identifier Parity Interrupt Disable */
#define US_LIN_IDR_LINCE            (0x1u << 28) /**< \brief (US_LIN_IDR) LIN Checksum Error Interrupt Disable */
#define US_LIN_IDR_LINSNRE          (0x1u << 29) /**< \brief (US_LIN_IDR) LIN Slave Not Responding Error Interrupt Disable */
#define US_LIN_IDR_LINSTE           (0x1u << 30) /**< \brief (US_LIN_IDR) LIN Synch Tolerance Error Interrupt Disable */
#define   US_LIN_IDR_LINSTE_0       (0x0u << 30) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_LINSTE_1       (0x1u << 30) /**< \brief (US_LIN_IDR) Disables the interrupt */
#define US_LIN_IDR_LINHTE           (0x1u << 31) /**< \brief (US_LIN_IDR) LIN Header Timeout Error Interrupt Disable */
#define   US_LIN_IDR_LINHTE_0       (0x0u << 31) /**< \brief (US_LIN_IDR) No Effect */
#define   US_LIN_IDR_LINHTE_1       (0x1u << 31) /**< \brief (US_LIN_IDR) Disables the interrupt */
/* -------- US_SPI_SLAVE_IDR : (USART Offset: 0x0C) Interrupt Disable Register -------- */
#define US_SPI_SLAVE_IDR_RXRDY      (0x1u <<  0) /**< \brief (US_SPI_SLAVE_IDR) Receiver Ready Interrupt Disable */
#define   US_SPI_SLAVE_IDR_RXRDY_0  (0x0u <<  0) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_RXRDY_1  (0x1u <<  0) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_TXRDY      (0x1u <<  1) /**< \brief (US_SPI_SLAVE_IDR) Transmitter Ready Interrupt Disable */
#define   US_SPI_SLAVE_IDR_TXRDY_0  (0x0u <<  1) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_TXRDY_1  (0x1u <<  1) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_RXBRK      (0x1u <<  2) /**< \brief (US_SPI_SLAVE_IDR) Receiver Break Interrupt Disable */
#define   US_SPI_SLAVE_IDR_RXBRK_0  (0x0u <<  2) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_RXBRK_1  (0x1u <<  2) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_ENDRX      (0x1u <<  3) /**< \brief (US_SPI_SLAVE_IDR) End of Receive Transfer Interrupt Disable */
#define   US_SPI_SLAVE_IDR_ENDRX_0  (0x0u <<  3) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_ENDRX_1  (0x1u <<  3) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_ENDTX      (0x1u <<  4) /**< \brief (US_SPI_SLAVE_IDR) End of Transmit Interrupt Disable */
#define   US_SPI_SLAVE_IDR_ENDTX_0  (0x0u <<  4) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_ENDTX_1  (0x1u <<  4) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_OVRE       (0x1u <<  5) /**< \brief (US_SPI_SLAVE_IDR) Overrun Error Interrupt Disable */
#define   US_SPI_SLAVE_IDR_OVRE_0   (0x0u <<  5) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_OVRE_1   (0x1u <<  5) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_FRAME      (0x1u <<  6) /**< \brief (US_SPI_SLAVE_IDR) Framing Error Interrupt Disable */
#define   US_SPI_SLAVE_IDR_FRAME_0  (0x0u <<  6) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_FRAME_1  (0x1u <<  6) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_PARE       (0x1u <<  7) /**< \brief (US_SPI_SLAVE_IDR) Parity Error Interrupt Disable */
#define   US_SPI_SLAVE_IDR_PARE_0   (0x0u <<  7) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_PARE_1   (0x1u <<  7) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_TIMEOUT    (0x1u <<  8) /**< \brief (US_SPI_SLAVE_IDR) Time-out Interrupt Disable */
#define   US_SPI_SLAVE_IDR_TIMEOUT_0 (0x0u <<  8) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_TIMEOUT_1 (0x1u <<  8) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_TXEMPTY    (0x1u <<  9) /**< \brief (US_SPI_SLAVE_IDR) Transmitter Empty Interrupt Disable */
#define   US_SPI_SLAVE_IDR_TXEMPTY_0 (0x0u <<  9) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_TXEMPTY_1 (0x1u <<  9) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_UNRE       (0x1u << 10) /**< \brief (US_SPI_SLAVE_IDR) SPI Underrun Error Interrupt Disable */
#define   US_SPI_SLAVE_IDR_UNRE_0   (0x0u << 10) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_UNRE_1   (0x1u << 10) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_TXBUFE     (0x1u << 11) /**< \brief (US_SPI_SLAVE_IDR) Buffer Empty Interrupt Disable */
#define   US_SPI_SLAVE_IDR_TXBUFE_0 (0x0u << 11) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_TXBUFE_1 (0x1u << 11) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_RXBUFF     (0x1u << 12) /**< \brief (US_SPI_SLAVE_IDR) Buffer Full Interrupt Disable */
#define   US_SPI_SLAVE_IDR_RXBUFF_0 (0x0u << 12) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_RXBUFF_1 (0x1u << 12) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_NACK       (0x1u << 13) /**< \brief (US_SPI_SLAVE_IDR) Non Acknowledge Interrupt Disable */
#define   US_SPI_SLAVE_IDR_NACK_0   (0x0u << 13) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_NACK_1   (0x1u << 13) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_RIIC       (0x1u << 16) /**< \brief (US_SPI_SLAVE_IDR) Ring Indicator Input Change Disable */
#define   US_SPI_SLAVE_IDR_RIIC_0   (0x0u << 16) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_RIIC_1   (0x1u << 16) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_DSRIC      (0x1u << 17) /**< \brief (US_SPI_SLAVE_IDR) Data Set Ready Input Change Disable */
#define   US_SPI_SLAVE_IDR_DSRIC_0  (0x0u << 17) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_DSRIC_1  (0x1u << 17) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_DCDIC      (0x1u << 18) /**< \brief (US_SPI_SLAVE_IDR) Data Carrier Detect Input Change Interrupt Disable */
#define   US_SPI_SLAVE_IDR_DCDIC_0  (0x0u << 18) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_DCDIC_1  (0x1u << 18) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
#define US_SPI_SLAVE_IDR_CTSIC      (0x1u << 19) /**< \brief (US_SPI_SLAVE_IDR) Clear to Send Input Change Interrupt Disable */
#define   US_SPI_SLAVE_IDR_CTSIC_0  (0x0u << 19) /**< \brief (US_SPI_SLAVE_IDR) No Effect */
#define   US_SPI_SLAVE_IDR_CTSIC_1  (0x1u << 19) /**< \brief (US_SPI_SLAVE_IDR) Disables the interrupt */
/* -------- US_USART_IDR : (USART Offset: 0x0C) Interrupt Disable Register -------- */
#define US_USART_IDR_RXRDY          (0x1u <<  0) /**< \brief (US_USART_IDR) Receiver Ready Interrupt Disable */
#define   US_USART_IDR_RXRDY_0      (0x0u <<  0) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_RXRDY_1      (0x1u <<  0) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_TXRDY          (0x1u <<  1) /**< \brief (US_USART_IDR) Transmitter Ready Interrupt Disable */
#define   US_USART_IDR_TXRDY_0      (0x0u <<  1) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_TXRDY_1      (0x1u <<  1) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_RXBRK          (0x1u <<  2) /**< \brief (US_USART_IDR) Receiver Break Interrupt Disable */
#define   US_USART_IDR_RXBRK_0      (0x0u <<  2) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_RXBRK_1      (0x1u <<  2) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_ENDRX          (0x1u <<  3) /**< \brief (US_USART_IDR) End of Receive Transfer Interrupt Disable */
#define   US_USART_IDR_ENDRX_0      (0x0u <<  3) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_ENDRX_1      (0x1u <<  3) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_ENDTX          (0x1u <<  4) /**< \brief (US_USART_IDR) End of Transmit Interrupt Disable */
#define   US_USART_IDR_ENDTX_0      (0x0u <<  4) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_ENDTX_1      (0x1u <<  4) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_OVRE           (0x1u <<  5) /**< \brief (US_USART_IDR) Overrun Error Interrupt Disable */
#define   US_USART_IDR_OVRE_0       (0x0u <<  5) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_OVRE_1       (0x1u <<  5) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_FRAME          (0x1u <<  6) /**< \brief (US_USART_IDR) Framing Error Interrupt Disable */
#define   US_USART_IDR_FRAME_0      (0x0u <<  6) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_FRAME_1      (0x1u <<  6) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_PARE           (0x1u <<  7) /**< \brief (US_USART_IDR) Parity Error Interrupt Disable */
#define   US_USART_IDR_PARE_0       (0x0u <<  7) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_PARE_1       (0x1u <<  7) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_TIMEOUT        (0x1u <<  8) /**< \brief (US_USART_IDR) Time-out Interrupt Disable */
#define   US_USART_IDR_TIMEOUT_0    (0x0u <<  8) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_TIMEOUT_1    (0x1u <<  8) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_TXEMPTY        (0x1u <<  9) /**< \brief (US_USART_IDR) Transmitter Empty Interrupt Disable */
#define   US_USART_IDR_TXEMPTY_0    (0x0u <<  9) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_TXEMPTY_1    (0x1u <<  9) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_ITER           (0x1u << 10) /**< \brief (US_USART_IDR) Iteration Interrupt Disable */
#define   US_USART_IDR_ITER_0       (0x0u << 10) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_ITER_1       (0x1u << 10) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_TXBUFE         (0x1u << 11) /**< \brief (US_USART_IDR) Buffer Empty Interrupt Disable */
#define   US_USART_IDR_TXBUFE_0     (0x0u << 11) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_TXBUFE_1     (0x1u << 11) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_RXBUFF         (0x1u << 12) /**< \brief (US_USART_IDR) Buffer Full Interrupt Disable */
#define   US_USART_IDR_RXBUFF_0     (0x0u << 12) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_RXBUFF_1     (0x1u << 12) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_NACK           (0x1u << 13) /**< \brief (US_USART_IDR) Non Acknowledge Interrupt Disable */
#define   US_USART_IDR_NACK_0       (0x0u << 13) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_NACK_1       (0x1u << 13) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_RIIC           (0x1u << 16) /**< \brief (US_USART_IDR) Ring Indicator Input Change Disable */
#define   US_USART_IDR_RIIC_0       (0x0u << 16) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_RIIC_1       (0x1u << 16) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_DSRIC          (0x1u << 17) /**< \brief (US_USART_IDR) Data Set Ready Input Change Disable */
#define   US_USART_IDR_DSRIC_0      (0x0u << 17) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_DSRIC_1      (0x1u << 17) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_DCDIC          (0x1u << 18) /**< \brief (US_USART_IDR) Data Carrier Detect Input Change Interrupt Disable */
#define   US_USART_IDR_DCDIC_0      (0x0u << 18) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_DCDIC_1      (0x1u << 18) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_CTSIC          (0x1u << 19) /**< \brief (US_USART_IDR) Clear to Send Input Change Interrupt Disable */
#define   US_USART_IDR_CTSIC_0      (0x0u << 19) /**< \brief (US_USART_IDR) No Effect */
#define   US_USART_IDR_CTSIC_1      (0x1u << 19) /**< \brief (US_USART_IDR) Disables the interrupt */
#define US_USART_IDR_MANE           (0x1u << 20) /**< \brief (US_USART_IDR) Manchester Error Interrupt Disable */
#define US_USART_IDR_MANEA          (0x1u << 24) /**< \brief (US_USART_IDR) Manchester Error Interrupt Disable */
#define   US_USART_IDR_MANEA_0      (0x0u << 24) /**< \brief (US_USART_IDR) No effect */
#define   US_USART_IDR_MANEA_1      (0x1u << 24) /**< \brief (US_USART_IDR) Disables the corresponding interrupt */
/* -------- US_LIN_IMR : (USART Offset: 0x10) Interrupt Mask Register -------- */
#define US_LIN_IMR_RXRDY            (0x1u <<  0) /**< \brief (US_LIN_IMR) RXRDY Interrupt Mask */
#define   US_LIN_IMR_RXRDY_0        (0x0u <<  0) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_RXRDY_1        (0x1u <<  0) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_TXRDY            (0x1u <<  1) /**< \brief (US_LIN_IMR) TXRDY Interrupt Mask */
#define   US_LIN_IMR_TXRDY_0        (0x0u <<  1) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_TXRDY_1        (0x1u <<  1) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_RXBRK            (0x1u <<  2) /**< \brief (US_LIN_IMR) Receiver Break Interrupt Mask */
#define   US_LIN_IMR_RXBRK_0        (0x0u <<  2) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_RXBRK_1        (0x1u <<  2) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_ENDRX            (0x1u <<  3) /**< \brief (US_LIN_IMR) End of Receive Transfer Interrupt Mask */
#define   US_LIN_IMR_ENDRX_0        (0x0u <<  3) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_ENDRX_1        (0x1u <<  3) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_ENDTX            (0x1u <<  4) /**< \brief (US_LIN_IMR) End of Transmit Interrupt Mask */
#define   US_LIN_IMR_ENDTX_0        (0x0u <<  4) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_ENDTX_1        (0x1u <<  4) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_OVRE             (0x1u <<  5) /**< \brief (US_LIN_IMR) Overrun Error Interrupt Mask */
#define   US_LIN_IMR_OVRE_0         (0x0u <<  5) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_OVRE_1         (0x1u <<  5) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_FRAME            (0x1u <<  6) /**< \brief (US_LIN_IMR) Framing Error Interrupt Mask */
#define   US_LIN_IMR_FRAME_0        (0x0u <<  6) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_FRAME_1        (0x1u <<  6) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_PARE             (0x1u <<  7) /**< \brief (US_LIN_IMR) Parity Error Interrupt Mask */
#define   US_LIN_IMR_PARE_0         (0x0u <<  7) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_PARE_1         (0x1u <<  7) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_TIMEOUT          (0x1u <<  8) /**< \brief (US_LIN_IMR) Time-out Interrupt Mask */
#define   US_LIN_IMR_TIMEOUT_0      (0x0u <<  8) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_TIMEOUT_1      (0x1u <<  8) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_TXEMPTY          (0x1u <<  9) /**< \brief (US_LIN_IMR) TXEMPTY Interrupt Mask */
#define   US_LIN_IMR_TXEMPTY_0      (0x0u <<  9) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_TXEMPTY_1      (0x1u <<  9) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_ITER             (0x1u << 10) /**< \brief (US_LIN_IMR) Iteration Interrupt Mask */
#define   US_LIN_IMR_ITER_0         (0x0u << 10) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_ITER_1         (0x1u << 10) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_TXBUFE           (0x1u << 11) /**< \brief (US_LIN_IMR) Buffer Empty Interrupt Mask */
#define   US_LIN_IMR_TXBUFE_0       (0x0u << 11) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_TXBUFE_1       (0x1u << 11) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_RXBUFF           (0x1u << 12) /**< \brief (US_LIN_IMR) Buffer Full Interrupt Mask */
#define   US_LIN_IMR_RXBUFF_0       (0x0u << 12) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_RXBUFF_1       (0x1u << 12) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_NACK             (0x1u << 13) /**< \brief (US_LIN_IMR) Non Acknowledge  or LIN Break Sent or LIN Break Received Interrupt Mask */
#define   US_LIN_IMR_NACK_0         (0x0u << 13) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_NACK_1         (0x1u << 13) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_LINID            (0x1u << 14) /**< \brief (US_LIN_IMR) LIN Identifier Sent or LIN Received Interrupt Mask */
#define US_LIN_IMR_LINTC            (0x1u << 15) /**< \brief (US_LIN_IMR) LIN Transfer Conpleted Interrupt Mask */
#define US_LIN_IMR_RIIC             (0x1u << 16) /**< \brief (US_LIN_IMR) Ring Indicator Input Change Mask */
#define   US_LIN_IMR_RIIC_0         (0x0u << 16) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_RIIC_1         (0x1u << 16) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_DSRIC            (0x1u << 17) /**< \brief (US_LIN_IMR) Data Set Ready Input Change Mask */
#define   US_LIN_IMR_DSRIC_0        (0x0u << 17) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_DSRIC_1        (0x1u << 17) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_DCDIC            (0x1u << 18) /**< \brief (US_LIN_IMR) Data Carrier Detect Input Change Interrupt Mask */
#define   US_LIN_IMR_DCDIC_0        (0x0u << 18) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_DCDIC_1        (0x1u << 18) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_CTSIC            (0x1u << 19) /**< \brief (US_LIN_IMR) Clear to Send Input Change Interrupt Mask */
#define   US_LIN_IMR_CTSIC_0        (0x0u << 19) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_CTSIC_1        (0x1u << 19) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_LINBE            (0x1u << 25) /**< \brief (US_LIN_IMR) LIN Bus Error Interrupt Mask */
#define US_LIN_IMR_LINISFE          (0x1u << 26) /**< \brief (US_LIN_IMR) LIN Inconsistent Synch Field Error Interrupt Mask */
#define US_LIN_IMR_LINIPE           (0x1u << 27) /**< \brief (US_LIN_IMR) LIN Identifier Parity Interrupt Mask */
#define US_LIN_IMR_LINCE            (0x1u << 28) /**< \brief (US_LIN_IMR) LIN Checksum Error Interrupt Mask */
#define US_LIN_IMR_LINSNRE          (0x1u << 29) /**< \brief (US_LIN_IMR) LIN Slave Not Responding Error Interrupt Mask */
#define US_LIN_IMR_LINSTE           (0x1u << 30) /**< \brief (US_LIN_IMR) LIN Synch Tolerance Error Interrupt Mask */
#define   US_LIN_IMR_LINSTE_0       (0x0u << 30) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_LINSTE_1       (0x1u << 30) /**< \brief (US_LIN_IMR) The interrupt is enabled */
#define US_LIN_IMR_LINHTE           (0x1u << 31) /**< \brief (US_LIN_IMR) LIN Header Timeout Error Interrupt Mask */
#define   US_LIN_IMR_LINHTE_0       (0x0u << 31) /**< \brief (US_LIN_IMR) The interrupt is disabled */
#define   US_LIN_IMR_LINHTE_1       (0x1u << 31) /**< \brief (US_LIN_IMR) The interrupt is enabled */
/* -------- US_SPI_SLAVE_IMR : (USART Offset: 0x10) Interrupt Mask Register -------- */
#define US_SPI_SLAVE_IMR_RXRDY      (0x1u <<  0) /**< \brief (US_SPI_SLAVE_IMR) RXRDY Interrupt Mask */
#define   US_SPI_SLAVE_IMR_RXRDY_0  (0x0u <<  0) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_RXRDY_1  (0x1u <<  0) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_TXRDY      (0x1u <<  1) /**< \brief (US_SPI_SLAVE_IMR) TXRDY Interrupt Mask */
#define   US_SPI_SLAVE_IMR_TXRDY_0  (0x0u <<  1) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_TXRDY_1  (0x1u <<  1) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_RXBRK      (0x1u <<  2) /**< \brief (US_SPI_SLAVE_IMR) Receiver Break Interrupt Mask */
#define   US_SPI_SLAVE_IMR_RXBRK_0  (0x0u <<  2) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_RXBRK_1  (0x1u <<  2) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_ENDRX      (0x1u <<  3) /**< \brief (US_SPI_SLAVE_IMR) End of Receive Transfer Interrupt Mask */
#define   US_SPI_SLAVE_IMR_ENDRX_0  (0x0u <<  3) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_ENDRX_1  (0x1u <<  3) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_ENDTX      (0x1u <<  4) /**< \brief (US_SPI_SLAVE_IMR) End of Transmit Interrupt Mask */
#define   US_SPI_SLAVE_IMR_ENDTX_0  (0x0u <<  4) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_ENDTX_1  (0x1u <<  4) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_OVRE       (0x1u <<  5) /**< \brief (US_SPI_SLAVE_IMR) Overrun Error Interrupt Mask */
#define   US_SPI_SLAVE_IMR_OVRE_0   (0x0u <<  5) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_OVRE_1   (0x1u <<  5) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_FRAME      (0x1u <<  6) /**< \brief (US_SPI_SLAVE_IMR) Framing Error Interrupt Mask */
#define   US_SPI_SLAVE_IMR_FRAME_0  (0x0u <<  6) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_FRAME_1  (0x1u <<  6) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_PARE       (0x1u <<  7) /**< \brief (US_SPI_SLAVE_IMR) Parity Error Interrupt Mask */
#define   US_SPI_SLAVE_IMR_PARE_0   (0x0u <<  7) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_PARE_1   (0x1u <<  7) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_TIMEOUT    (0x1u <<  8) /**< \brief (US_SPI_SLAVE_IMR) Time-out Interrupt Mask */
#define   US_SPI_SLAVE_IMR_TIMEOUT_0 (0x0u <<  8) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_TIMEOUT_1 (0x1u <<  8) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_TXEMPTY    (0x1u <<  9) /**< \brief (US_SPI_SLAVE_IMR) TXEMPTY Interrupt Mask */
#define   US_SPI_SLAVE_IMR_TXEMPTY_0 (0x0u <<  9) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_TXEMPTY_1 (0x1u <<  9) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_UNRE       (0x1u << 10) /**< \brief (US_SPI_SLAVE_IMR) SPI Underrun Error Interrupt Mask */
#define   US_SPI_SLAVE_IMR_UNRE_0   (0x0u << 10) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_UNRE_1   (0x1u << 10) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_TXBUFE     (0x1u << 11) /**< \brief (US_SPI_SLAVE_IMR) Buffer Empty Interrupt Mask */
#define   US_SPI_SLAVE_IMR_TXBUFE_0 (0x0u << 11) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_TXBUFE_1 (0x1u << 11) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_RXBUFF     (0x1u << 12) /**< \brief (US_SPI_SLAVE_IMR) Buffer Full Interrupt Mask */
#define   US_SPI_SLAVE_IMR_RXBUFF_0 (0x0u << 12) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_RXBUFF_1 (0x1u << 12) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_NACK       (0x1u << 13) /**< \brief (US_SPI_SLAVE_IMR) Non Acknowledge Interrupt Mask */
#define   US_SPI_SLAVE_IMR_NACK_0   (0x0u << 13) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_NACK_1   (0x1u << 13) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_RIIC       (0x1u << 16) /**< \brief (US_SPI_SLAVE_IMR) Ring Indicator Input Change Mask */
#define   US_SPI_SLAVE_IMR_RIIC_0   (0x0u << 16) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_RIIC_1   (0x1u << 16) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_DSRIC      (0x1u << 17) /**< \brief (US_SPI_SLAVE_IMR) Data Set Ready Input Change Mask */
#define   US_SPI_SLAVE_IMR_DSRIC_0  (0x0u << 17) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_DSRIC_1  (0x1u << 17) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_DCDIC      (0x1u << 18) /**< \brief (US_SPI_SLAVE_IMR) Data Carrier Detect Input Change Interrupt Mask */
#define   US_SPI_SLAVE_IMR_DCDIC_0  (0x0u << 18) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_DCDIC_1  (0x1u << 18) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
#define US_SPI_SLAVE_IMR_CTSIC      (0x1u << 19) /**< \brief (US_SPI_SLAVE_IMR) Clear to Send Input Change Interrupt Mask */
#define   US_SPI_SLAVE_IMR_CTSIC_0  (0x0u << 19) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is disabled */
#define   US_SPI_SLAVE_IMR_CTSIC_1  (0x1u << 19) /**< \brief (US_SPI_SLAVE_IMR) The interrupt is enabled */
/* -------- US_USART_IMR : (USART Offset: 0x10) Interrupt Mask Register -------- */
#define US_USART_IMR_RXRDY          (0x1u <<  0) /**< \brief (US_USART_IMR) RXRDY Interrupt Mask */
#define   US_USART_IMR_RXRDY_0      (0x0u <<  0) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_RXRDY_1      (0x1u <<  0) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_TXRDY          (0x1u <<  1) /**< \brief (US_USART_IMR) TXRDY Interrupt Mask */
#define   US_USART_IMR_TXRDY_0      (0x0u <<  1) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_TXRDY_1      (0x1u <<  1) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_RXBRK          (0x1u <<  2) /**< \brief (US_USART_IMR) Receiver Break Interrupt Mask */
#define   US_USART_IMR_RXBRK_0      (0x0u <<  2) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_RXBRK_1      (0x1u <<  2) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_ENDRX          (0x1u <<  3) /**< \brief (US_USART_IMR) End of Receive Transfer Interrupt Mask */
#define   US_USART_IMR_ENDRX_0      (0x0u <<  3) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_ENDRX_1      (0x1u <<  3) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_ENDTX          (0x1u <<  4) /**< \brief (US_USART_IMR) End of Transmit Interrupt Mask */
#define   US_USART_IMR_ENDTX_0      (0x0u <<  4) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_ENDTX_1      (0x1u <<  4) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_OVRE           (0x1u <<  5) /**< \brief (US_USART_IMR) Overrun Error Interrupt Mask */
#define   US_USART_IMR_OVRE_0       (0x0u <<  5) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_OVRE_1       (0x1u <<  5) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_FRAME          (0x1u <<  6) /**< \brief (US_USART_IMR) Framing Error Interrupt Mask */
#define   US_USART_IMR_FRAME_0      (0x0u <<  6) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_FRAME_1      (0x1u <<  6) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_PARE           (0x1u <<  7) /**< \brief (US_USART_IMR) Parity Error Interrupt Mask */
#define   US_USART_IMR_PARE_0       (0x0u <<  7) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_PARE_1       (0x1u <<  7) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_TIMEOUT        (0x1u <<  8) /**< \brief (US_USART_IMR) Time-out Interrupt Mask */
#define   US_USART_IMR_TIMEOUT_0    (0x0u <<  8) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_TIMEOUT_1    (0x1u <<  8) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_TXEMPTY        (0x1u <<  9) /**< \brief (US_USART_IMR) TXEMPTY Interrupt Mask */
#define   US_USART_IMR_TXEMPTY_0    (0x0u <<  9) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_TXEMPTY_1    (0x1u <<  9) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_ITER           (0x1u << 10) /**< \brief (US_USART_IMR) Iteration Interrupt Mask */
#define   US_USART_IMR_ITER_0       (0x0u << 10) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_ITER_1       (0x1u << 10) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_TXBUFE         (0x1u << 11) /**< \brief (US_USART_IMR) Buffer Empty Interrupt Mask */
#define   US_USART_IMR_TXBUFE_0     (0x0u << 11) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_TXBUFE_1     (0x1u << 11) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_RXBUFF         (0x1u << 12) /**< \brief (US_USART_IMR) Buffer Full Interrupt Mask */
#define   US_USART_IMR_RXBUFF_0     (0x0u << 12) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_RXBUFF_1     (0x1u << 12) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_NACK           (0x1u << 13) /**< \brief (US_USART_IMR) Non Acknowledge Interrupt Mask */
#define   US_USART_IMR_NACK_0       (0x0u << 13) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_NACK_1       (0x1u << 13) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_RIIC           (0x1u << 16) /**< \brief (US_USART_IMR) Ring Indicator Input Change Mask */
#define   US_USART_IMR_RIIC_0       (0x0u << 16) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_RIIC_1       (0x1u << 16) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_DSRIC          (0x1u << 17) /**< \brief (US_USART_IMR) Data Set Ready Input Change Mask */
#define   US_USART_IMR_DSRIC_0      (0x0u << 17) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_DSRIC_1      (0x1u << 17) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_DCDIC          (0x1u << 18) /**< \brief (US_USART_IMR) Data Carrier Detect Input Change Interrupt Mask */
#define   US_USART_IMR_DCDIC_0      (0x0u << 18) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_DCDIC_1      (0x1u << 18) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_CTSIC          (0x1u << 19) /**< \brief (US_USART_IMR) Clear to Send Input Change Interrupt Mask */
#define   US_USART_IMR_CTSIC_0      (0x0u << 19) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_CTSIC_1      (0x1u << 19) /**< \brief (US_USART_IMR) The interrupt is enabled */
#define US_USART_IMR_MANE           (0x1u << 20) /**< \brief (US_USART_IMR)  */
#define US_USART_IMR_MANEA          (0x1u << 24) /**< \brief (US_USART_IMR) Manchester Error Interrupt Mask */
#define   US_USART_IMR_MANEA_0      (0x0u << 24) /**< \brief (US_USART_IMR) The interrupt is disabled */
#define   US_USART_IMR_MANEA_1      (0x1u << 24) /**< \brief (US_USART_IMR) The interrupt is enabled */
/* -------- US_LIN_CSR : (USART Offset: 0x14) Channel Status Register -------- */
#define US_LIN_CSR_RXRDY            (0x1u <<  0) /**< \brief (US_LIN_CSR) Receiver Ready */
#define   US_LIN_CSR_RXRDY_0        (0x0u <<  0) /**< \brief (US_LIN_CSR) No complete character has been received since the last read of RHR or the receiver is disabled. If characters werebeing received when the receiver was disabled, RXRDY changes to 1 when the receiver is enabled */
#define   US_LIN_CSR_RXRDY_1        (0x1u <<  0) /**< \brief (US_LIN_CSR) At least one complete character has been received and RHR has not yet been read */
#define US_LIN_CSR_TXRDY            (0x1u <<  1) /**< \brief (US_LIN_CSR) Transmitter Ready */
#define   US_LIN_CSR_TXRDY_0        (0x0u <<  1) /**< \brief (US_LIN_CSR) A character is in the THR waiting to be transferred to the Transmit Shift Register, or an STTBRK command has been requested, or the transmitter is disabled. As soon as the transmitter is enabled, TXRDY becomes 1 */
#define   US_LIN_CSR_TXRDY_1        (0x1u <<  1) /**< \brief (US_LIN_CSR) There is no character in the THR */
#define US_LIN_CSR_RXBRK            (0x1u <<  2) /**< \brief (US_LIN_CSR) Break Received/End of Break */
#define   US_LIN_CSR_RXBRK_0        (0x0u <<  2) /**< \brief (US_LIN_CSR) No Break received or End of Break detected since the last RSTSTA */
#define   US_LIN_CSR_RXBRK_1        (0x1u <<  2) /**< \brief (US_LIN_CSR) Break Received or End of Break detected since the last RSTSTA */
#define US_LIN_CSR_ENDRX            (0x1u <<  3) /**< \brief (US_LIN_CSR) End of Receiver Transfer */
#define   US_LIN_CSR_ENDRX_0        (0x0u <<  3) /**< \brief (US_LIN_CSR) The End of Transfer signal from the Receive PDC channel is inactive */
#define   US_LIN_CSR_ENDRX_1        (0x1u <<  3) /**< \brief (US_LIN_CSR) The End of Transfer signal from the Receive PDC channel is active */
#define US_LIN_CSR_ENDTX            (0x1u <<  4) /**< \brief (US_LIN_CSR) End of Transmitter Transfer */
#define   US_LIN_CSR_ENDTX_0        (0x0u <<  4) /**< \brief (US_LIN_CSR) The End of Transfer signal from the Transmit PDC channel is inactive */
#define   US_LIN_CSR_ENDTX_1        (0x1u <<  4) /**< \brief (US_LIN_CSR) The End of Transfer signal from the Transmit PDC channel is active */
#define US_LIN_CSR_OVRE             (0x1u <<  5) /**< \brief (US_LIN_CSR) Overrun Error */
#define   US_LIN_CSR_OVRE_0         (0x0u <<  5) /**< \brief (US_LIN_CSR) No overrun error has occurred since since the last RSTSTA */
#define   US_LIN_CSR_OVRE_1         (0x1u <<  5) /**< \brief (US_LIN_CSR) At least one overrun error has occurred since the last RSTSTA */
#define US_LIN_CSR_FRAME            (0x1u <<  6) /**< \brief (US_LIN_CSR) Framing Error */
#define   US_LIN_CSR_FRAME_0        (0x0u <<  6) /**< \brief (US_LIN_CSR) No stop bit has been detected low since the last RSTSTA */
#define   US_LIN_CSR_FRAME_1        (0x1u <<  6) /**< \brief (US_LIN_CSR) At least one stop bit has been detected low since the last RSTSTA */
#define US_LIN_CSR_PARE             (0x1u <<  7) /**< \brief (US_LIN_CSR) Parity Error */
#define   US_LIN_CSR_PARE_0         (0x0u <<  7) /**< \brief (US_LIN_CSR) No parity error has been detected since the last RSTSTA */
#define   US_LIN_CSR_PARE_1         (0x1u <<  7) /**< \brief (US_LIN_CSR) At least one parity error has been detected since the last RSTSTA */
#define US_LIN_CSR_TIMEOUT          (0x1u <<  8) /**< \brief (US_LIN_CSR) Receiver Time-out */
#define   US_LIN_CSR_TIMEOUT_0      (0x0u <<  8) /**< \brief (US_LIN_CSR) There has not been a time-out since the last Start Time-out command or the Time-out Register is 0 */
#define   US_LIN_CSR_TIMEOUT_1      (0x1u <<  8) /**< \brief (US_LIN_CSR) There has been a time-out since the last Start Time-out command */
#define US_LIN_CSR_TXEMPTY          (0x1u <<  9) /**< \brief (US_LIN_CSR) Transmitter Empty */
#define   US_LIN_CSR_TXEMPTY_0      (0x0u <<  9) /**< \brief (US_LIN_CSR) There are characters in either THR or the Transmit Shift Register, or the transmitter is disabled */
#define   US_LIN_CSR_TXEMPTY_1      (0x1u <<  9) /**< \brief (US_LIN_CSR) There is at least one character in either THR or the Transmit Shift Register */
#define US_LIN_CSR_ITER             (0x1u << 10) /**< \brief (US_LIN_CSR) Max number of Repetitions Reached */
#define   US_LIN_CSR_ITER_0         (0x0u << 10) /**< \brief (US_LIN_CSR) Maximum number of repetitions has not been reached since the last RSIT */
#define   US_LIN_CSR_ITER_1         (0x1u << 10) /**< \brief (US_LIN_CSR) Maximum number of repetitions has been reached since the last RSIT */
#define US_LIN_CSR_TXBUFE           (0x1u << 11) /**< \brief (US_LIN_CSR) Transmission Buffer Empty */
#define   US_LIN_CSR_TXBUFE_0       (0x0u << 11) /**< \brief (US_LIN_CSR) The signal Buffer Empty from the Transmit PDC channel is inactive */
#define   US_LIN_CSR_TXBUFE_1       (0x1u << 11) /**< \brief (US_LIN_CSR) The signal Buffer Empty from the Transmit PDC channel is active */
#define US_LIN_CSR_RXBUFF           (0x1u << 12) /**< \brief (US_LIN_CSR) Reception Buffer Full */
#define   US_LIN_CSR_RXBUFF_0       (0x0u << 12) /**< \brief (US_LIN_CSR) The signal Buffer Full from the Receive PDC channel is inactive */
#define   US_LIN_CSR_RXBUFF_1       (0x1u << 12) /**< \brief (US_LIN_CSR) The signal Buffer Full from the Receive PDC channel is active */
#define US_LIN_CSR_NACK             (0x1u << 13) /**< \brief (US_LIN_CSR) Non Acknowledge or LIN Break Sent or LIN Break Received */
#define   US_LIN_CSR_NACK_0         (0x0u << 13) /**< \brief (US_LIN_CSR) No Non Acknowledge has not been detected since the last RSTNACK */
#define   US_LIN_CSR_NACK_1         (0x1u << 13) /**< \brief (US_LIN_CSR) At least one Non Acknowledge has been detected since the last RSTNACK */
#define US_LIN_CSR_LINID            (0x1u << 14) /**< \brief (US_LIN_CSR) LIN Identifier Sent or LIN Identifier Received */
#define US_LIN_CSR_LINTC            (0x1u << 15) /**< \brief (US_LIN_CSR) LIN Transfer Conpleted */
#define US_LIN_CSR_RIIC             (0x1u << 16) /**< \brief (US_LIN_CSR) Ring Indicator Input Change Flag */
#define   US_LIN_CSR_RIIC_0         (0x0u << 16) /**< \brief (US_LIN_CSR) No input change has been detected on the RI pin since the last read of CSR */
#define   US_LIN_CSR_RIIC_1         (0x1u << 16) /**< \brief (US_LIN_CSR) At least one input change has been detected on the RI pin since the last read of CSR */
#define US_LIN_CSR_DSRIC            (0x1u << 17) /**< \brief (US_LIN_CSR) Data Set Ready Input Change Flag */
#define   US_LIN_CSR_DSRIC_0        (0x0u << 17) /**< \brief (US_LIN_CSR) No input change has been detected on the DSR pin since the last read of CSR */
#define   US_LIN_CSR_DSRIC_1        (0x1u << 17) /**< \brief (US_LIN_CSR) At least one input change has been detected on the DSR pin since the last read of CSR */
#define US_LIN_CSR_DCDIC            (0x1u << 18) /**< \brief (US_LIN_CSR) Data Carrier Detect Input Change Flag */
#define   US_LIN_CSR_DCDIC_0        (0x0u << 18) /**< \brief (US_LIN_CSR) No input change has been detected on the DCD pin since the last read of CSR */
#define   US_LIN_CSR_DCDIC_1        (0x1u << 18) /**< \brief (US_LIN_CSR) At least one input change has been detected on the DCD pin since the last read of CSR */
#define US_LIN_CSR_CTSIC            (0x1u << 19) /**< \brief (US_LIN_CSR) Clear to Send Input Change Flag */
#define   US_LIN_CSR_CTSIC_0        (0x0u << 19) /**< \brief (US_LIN_CSR) No input change has been detected on the CTS pin since the last read of CSR */
#define   US_LIN_CSR_CTSIC_1        (0x1u << 19) /**< \brief (US_LIN_CSR) At least one input change has been detected on the CTS pin since the last read of CSR */
#define US_LIN_CSR_RI               (0x1u << 20) /**< \brief (US_LIN_CSR) Image of RI Input */
#define   US_LIN_CSR_RI_0           (0x0u << 20) /**< \brief (US_LIN_CSR) RI is at 0 */
#define   US_LIN_CSR_RI_1           (0x1u << 20) /**< \brief (US_LIN_CSR) RI is at 1 */
#define US_LIN_CSR_DSR              (0x1u << 21) /**< \brief (US_LIN_CSR) Image of DSR Input */
#define   US_LIN_CSR_DSR_0          (0x0u << 21) /**< \brief (US_LIN_CSR) DSR is at 0 */
#define   US_LIN_CSR_DSR_1          (0x1u << 21) /**< \brief (US_LIN_CSR) DSR is at 1 */
#define US_LIN_CSR_DCD              (0x1u << 22) /**< \brief (US_LIN_CSR) Image of DCD Input */
#define   US_LIN_CSR_DCD_0          (0x0u << 22) /**< \brief (US_LIN_CSR) DCD is at 0 */
#define   US_LIN_CSR_DCD_1          (0x1u << 22) /**< \brief (US_LIN_CSR) DCD is at 1 */
#define US_LIN_CSR_LINBLS           (0x1u << 23) /**< \brief (US_LIN_CSR) LIN Bus Line Status */
#define   US_LIN_CSR_LINBLS_0       (0x0u << 23) /**< \brief (US_LIN_CSR) CTS is at 0 */
#define   US_LIN_CSR_LINBLS_1       (0x1u << 23) /**< \brief (US_LIN_CSR) CTS is at 1 */
#define US_LIN_CSR_LINBE            (0x1u << 25) /**< \brief (US_LIN_CSR) LIN Bit Error */
#define US_LIN_CSR_LINISFE          (0x1u << 26) /**< \brief (US_LIN_CSR) LIN Inconsistent Synch Field Error */
#define US_LIN_CSR_LINIPE           (0x1u << 27) /**< \brief (US_LIN_CSR) LIN Identifier Parity Error */
#define US_LIN_CSR_LINCE            (0x1u << 28) /**< \brief (US_LIN_CSR) LIN Checksum Error */
#define US_LIN_CSR_LINSNRE          (0x1u << 29) /**< \brief (US_LIN_CSR) LIN Slave Not Responding Error */
#define US_LIN_CSR_LINSTE           (0x1u << 30) /**< \brief (US_LIN_CSR) LIN Synch Tolerance Error */
#define   US_LIN_CSR_LINSTE_0       (0x0u << 30) /**< \brief (US_LIN_CSR) COMM_TX is at 0 */
#define   US_LIN_CSR_LINSTE_1       (0x1u << 30) /**< \brief (US_LIN_CSR) COMM_TX is at 1 */
#define US_LIN_CSR_LINHTE           (0x1u << 31) /**< \brief (US_LIN_CSR) LIN Header Timeout Error */
#define   US_LIN_CSR_LINHTE_0       (0x0u << 31) /**< \brief (US_LIN_CSR) COMM_RX is at 0 */
#define   US_LIN_CSR_LINHTE_1       (0x1u << 31) /**< \brief (US_LIN_CSR) COMM_RX is at 1 */
/* -------- US_SPI_SLAVE_CSR : (USART Offset: 0x14) Channel Status Register -------- */
#define US_SPI_SLAVE_CSR_RXRDY      (0x1u <<  0) /**< \brief (US_SPI_SLAVE_CSR) Receiver Ready */
#define   US_SPI_SLAVE_CSR_RXRDY_0  (0x0u <<  0) /**< \brief (US_SPI_SLAVE_CSR) No complete character has been received since the last read of RHR or the receiver is disabled. If characters werebeing received when the receiver was disabled, RXRDY changes to 1 when the receiver is enabled */
#define   US_SPI_SLAVE_CSR_RXRDY_1  (0x1u <<  0) /**< \brief (US_SPI_SLAVE_CSR) At least one complete character has been received and RHR has not yet been read */
#define US_SPI_SLAVE_CSR_TXRDY      (0x1u <<  1) /**< \brief (US_SPI_SLAVE_CSR) Transmitter Ready */
#define   US_SPI_SLAVE_CSR_TXRDY_0  (0x0u <<  1) /**< \brief (US_SPI_SLAVE_CSR) A character is in the THR waiting to be transferred to the Transmit Shift Register, or an STTBRK command has been requested, or the transmitter is disabled. As soon as the transmitter is enabled, TXRDY becomes 1 */
#define   US_SPI_SLAVE_CSR_TXRDY_1  (0x1u <<  1) /**< \brief (US_SPI_SLAVE_CSR) There is no character in the THR */
#define US_SPI_SLAVE_CSR_RXBRK      (0x1u <<  2) /**< \brief (US_SPI_SLAVE_CSR) Break Received/End of Break */
#define   US_SPI_SLAVE_CSR_RXBRK_0  (0x0u <<  2) /**< \brief (US_SPI_SLAVE_CSR) No Break received or End of Break detected since the last RSTSTA */
#define   US_SPI_SLAVE_CSR_RXBRK_1  (0x1u <<  2) /**< \brief (US_SPI_SLAVE_CSR) Break Received or End of Break detected since the last RSTSTA */
#define US_SPI_SLAVE_CSR_ENDRX      (0x1u <<  3) /**< \brief (US_SPI_SLAVE_CSR) End of Receiver Transfer */
#define   US_SPI_SLAVE_CSR_ENDRX_0  (0x0u <<  3) /**< \brief (US_SPI_SLAVE_CSR) The End of Transfer signal from the Receive PDC channel is inactive */
#define   US_SPI_SLAVE_CSR_ENDRX_1  (0x1u <<  3) /**< \brief (US_SPI_SLAVE_CSR) The End of Transfer signal from the Receive PDC channel is active */
#define US_SPI_SLAVE_CSR_ENDTX      (0x1u <<  4) /**< \brief (US_SPI_SLAVE_CSR) End of Transmitter Transfer */
#define   US_SPI_SLAVE_CSR_ENDTX_0  (0x0u <<  4) /**< \brief (US_SPI_SLAVE_CSR) The End of Transfer signal from the Transmit PDC channel is inactive */
#define   US_SPI_SLAVE_CSR_ENDTX_1  (0x1u <<  4) /**< \brief (US_SPI_SLAVE_CSR) The End of Transfer signal from the Transmit PDC channel is active */
#define US_SPI_SLAVE_CSR_OVRE       (0x1u <<  5) /**< \brief (US_SPI_SLAVE_CSR) Overrun Error */
#define   US_SPI_SLAVE_CSR_OVRE_0   (0x0u <<  5) /**< \brief (US_SPI_SLAVE_CSR) No overrun error has occurred since since the last RSTSTA */
#define   US_SPI_SLAVE_CSR_OVRE_1   (0x1u <<  5) /**< \brief (US_SPI_SLAVE_CSR) At least one overrun error has occurred since the last RSTSTA */
#define US_SPI_SLAVE_CSR_FRAME      (0x1u <<  6) /**< \brief (US_SPI_SLAVE_CSR) Framing Error */
#define   US_SPI_SLAVE_CSR_FRAME_0  (0x0u <<  6) /**< \brief (US_SPI_SLAVE_CSR) No stop bit has been detected low since the last RSTSTA */
#define   US_SPI_SLAVE_CSR_FRAME_1  (0x1u <<  6) /**< \brief (US_SPI_SLAVE_CSR) At least one stop bit has been detected low since the last RSTSTA */
#define US_SPI_SLAVE_CSR_PARE       (0x1u <<  7) /**< \brief (US_SPI_SLAVE_CSR) Parity Error */
#define   US_SPI_SLAVE_CSR_PARE_0   (0x0u <<  7) /**< \brief (US_SPI_SLAVE_CSR) No parity error has been detected since the last RSTSTA */
#define   US_SPI_SLAVE_CSR_PARE_1   (0x1u <<  7) /**< \brief (US_SPI_SLAVE_CSR) At least one parity error has been detected since the last RSTSTA */
#define US_SPI_SLAVE_CSR_TIMEOUT    (0x1u <<  8) /**< \brief (US_SPI_SLAVE_CSR) Receiver Time-out */
#define   US_SPI_SLAVE_CSR_TIMEOUT_0 (0x0u <<  8) /**< \brief (US_SPI_SLAVE_CSR) There has not been a time-out since the last Start Time-out command or the Time-out Register is 0 */
#define   US_SPI_SLAVE_CSR_TIMEOUT_1 (0x1u <<  8) /**< \brief (US_SPI_SLAVE_CSR) There has been a time-out since the last Start Time-out command */
#define US_SPI_SLAVE_CSR_TXEMPTY    (0x1u <<  9) /**< \brief (US_SPI_SLAVE_CSR) Transmitter Empty */
#define   US_SPI_SLAVE_CSR_TXEMPTY_0 (0x0u <<  9) /**< \brief (US_SPI_SLAVE_CSR) There are characters in either THR or the Transmit Shift Register, or the transmitter is disabled */
#define   US_SPI_SLAVE_CSR_TXEMPTY_1 (0x1u <<  9) /**< \brief (US_SPI_SLAVE_CSR) There is at least one character in either THR or the Transmit Shift Register */
#define US_SPI_SLAVE_CSR_UNRE       (0x1u << 10) /**< \brief (US_SPI_SLAVE_CSR) SPI Underrun Error */
#define   US_SPI_SLAVE_CSR_UNRE_0   (0x0u << 10) /**< \brief (US_SPI_SLAVE_CSR) No SPI underrun error has occurred since the last RSTSTA */
#define   US_SPI_SLAVE_CSR_UNRE_1   (0x1u << 10) /**< \brief (US_SPI_SLAVE_CSR) At least one SPI underrun error has occurred since the last RSTSTA */
#define US_SPI_SLAVE_CSR_TXBUFE     (0x1u << 11) /**< \brief (US_SPI_SLAVE_CSR) Transmission Buffer Empty */
#define   US_SPI_SLAVE_CSR_TXBUFE_0 (0x0u << 11) /**< \brief (US_SPI_SLAVE_CSR) The signal Buffer Empty from the Transmit PDC channel is inactive */
#define   US_SPI_SLAVE_CSR_TXBUFE_1 (0x1u << 11) /**< \brief (US_SPI_SLAVE_CSR) The signal Buffer Empty from the Transmit PDC channel is active */
#define US_SPI_SLAVE_CSR_RXBUFF     (0x1u << 12) /**< \brief (US_SPI_SLAVE_CSR) Reception Buffer Full */
#define   US_SPI_SLAVE_CSR_RXBUFF_0 (0x0u << 12) /**< \brief (US_SPI_SLAVE_CSR) The signal Buffer Full from the Receive PDC channel is inactive */
#define   US_SPI_SLAVE_CSR_RXBUFF_1 (0x1u << 12) /**< \brief (US_SPI_SLAVE_CSR) The signal Buffer Full from the Receive PDC channel is active */
#define US_SPI_SLAVE_CSR_NACK       (0x1u << 13) /**< \brief (US_SPI_SLAVE_CSR) Non Acknowledge */
#define   US_SPI_SLAVE_CSR_NACK_0   (0x0u << 13) /**< \brief (US_SPI_SLAVE_CSR) No Non Acknowledge has not been detected since the last RSTNACK */
#define   US_SPI_SLAVE_CSR_NACK_1   (0x1u << 13) /**< \brief (US_SPI_SLAVE_CSR) At least one Non Acknowledge has been detected since the last RSTNACK */
#define US_SPI_SLAVE_CSR_RIIC       (0x1u << 16) /**< \brief (US_SPI_SLAVE_CSR) Ring Indicator Input Change Flag */
#define   US_SPI_SLAVE_CSR_RIIC_0   (0x0u << 16) /**< \brief (US_SPI_SLAVE_CSR) No input change has been detected on the RI pin since the last read of CSR */
#define   US_SPI_SLAVE_CSR_RIIC_1   (0x1u << 16) /**< \brief (US_SPI_SLAVE_CSR) At least one input change has been detected on the RI pin since the last read of CSR */
#define US_SPI_SLAVE_CSR_DSRIC      (0x1u << 17) /**< \brief (US_SPI_SLAVE_CSR) Data Set Ready Input Change Flag */
#define   US_SPI_SLAVE_CSR_DSRIC_0  (0x0u << 17) /**< \brief (US_SPI_SLAVE_CSR) No input change has been detected on the DSR pin since the last read of CSR */
#define   US_SPI_SLAVE_CSR_DSRIC_1  (0x1u << 17) /**< \brief (US_SPI_SLAVE_CSR) At least one input change has been detected on the DSR pin since the last read of CSR */
#define US_SPI_SLAVE_CSR_DCDIC      (0x1u << 18) /**< \brief (US_SPI_SLAVE_CSR) Data Carrier Detect Input Change Flag */
#define   US_SPI_SLAVE_CSR_DCDIC_0  (0x0u << 18) /**< \brief (US_SPI_SLAVE_CSR) No input change has been detected on the DCD pin since the last read of CSR */
#define   US_SPI_SLAVE_CSR_DCDIC_1  (0x1u << 18) /**< \brief (US_SPI_SLAVE_CSR) At least one input change has been detected on the DCD pin since the last read of CSR */
#define US_SPI_SLAVE_CSR_CTSIC      (0x1u << 19) /**< \brief (US_SPI_SLAVE_CSR) Clear to Send Input Change Flag */
#define   US_SPI_SLAVE_CSR_CTSIC_0  (0x0u << 19) /**< \brief (US_SPI_SLAVE_CSR) No input change has been detected on the CTS pin since the last read of CSR */
#define   US_SPI_SLAVE_CSR_CTSIC_1  (0x1u << 19) /**< \brief (US_SPI_SLAVE_CSR) At least one input change has been detected on the CTS pin since the last read of CSR */
#define US_SPI_SLAVE_CSR_RI         (0x1u << 20) /**< \brief (US_SPI_SLAVE_CSR) Image of RI Input */
#define   US_SPI_SLAVE_CSR_RI_0     (0x0u << 20) /**< \brief (US_SPI_SLAVE_CSR) RI is at 0 */
#define   US_SPI_SLAVE_CSR_RI_1     (0x1u << 20) /**< \brief (US_SPI_SLAVE_CSR) RI is at 1 */
#define US_SPI_SLAVE_CSR_DSR        (0x1u << 21) /**< \brief (US_SPI_SLAVE_CSR) Image of DSR Input */
#define   US_SPI_SLAVE_CSR_DSR_0    (0x0u << 21) /**< \brief (US_SPI_SLAVE_CSR) DSR is at 0 */
#define   US_SPI_SLAVE_CSR_DSR_1    (0x1u << 21) /**< \brief (US_SPI_SLAVE_CSR) DSR is at 1 */
#define US_SPI_SLAVE_CSR_DCD        (0x1u << 22) /**< \brief (US_SPI_SLAVE_CSR) Image of DCD Input */
#define   US_SPI_SLAVE_CSR_DCD_0    (0x0u << 22) /**< \brief (US_SPI_SLAVE_CSR) DCD is at 0 */
#define   US_SPI_SLAVE_CSR_DCD_1    (0x1u << 22) /**< \brief (US_SPI_SLAVE_CSR) DCD is at 1 */
#define US_SPI_SLAVE_CSR_CTS        (0x1u << 23) /**< \brief (US_SPI_SLAVE_CSR) Image of CTS Input */
#define   US_SPI_SLAVE_CSR_CTS_0    (0x0u << 23) /**< \brief (US_SPI_SLAVE_CSR) CTS is at 0 */
#define   US_SPI_SLAVE_CSR_CTS_1    (0x1u << 23) /**< \brief (US_SPI_SLAVE_CSR) CTS is at 1 */
/* -------- US_USART_CSR : (USART Offset: 0x14) Channel Status Register -------- */
#define US_USART_CSR_RXRDY          (0x1u <<  0) /**< \brief (US_USART_CSR) Receiver Ready */
#define   US_USART_CSR_RXRDY_0      (0x0u <<  0) /**< \brief (US_USART_CSR) No complete character has been received since the last read of RHR or the receiver is disabled. If characters werebeing received when the receiver was disabled, RXRDY changes to 1 when the receiver is enabled */
#define   US_USART_CSR_RXRDY_1      (0x1u <<  0) /**< \brief (US_USART_CSR) At least one complete character has been received and RHR has not yet been read */
#define US_USART_CSR_TXRDY          (0x1u <<  1) /**< \brief (US_USART_CSR) Transmitter Ready */
#define   US_USART_CSR_TXRDY_0      (0x0u <<  1) /**< \brief (US_USART_CSR) A character is in the THR waiting to be transferred to the Transmit Shift Register, or an STTBRK command has been requested, or the transmitter is disabled. As soon as the transmitter is enabled, TXRDY becomes 1 */
#define   US_USART_CSR_TXRDY_1      (0x1u <<  1) /**< \brief (US_USART_CSR) There is no character in the THR */
#define US_USART_CSR_RXBRK          (0x1u <<  2) /**< \brief (US_USART_CSR) Break Received/End of Break */
#define   US_USART_CSR_RXBRK_0      (0x0u <<  2) /**< \brief (US_USART_CSR) No Break received or End of Break detected since the last RSTSTA */
#define   US_USART_CSR_RXBRK_1      (0x1u <<  2) /**< \brief (US_USART_CSR) Break Received or End of Break detected since the last RSTSTA */
#define US_USART_CSR_ENDRX          (0x1u <<  3) /**< \brief (US_USART_CSR) End of Receiver Transfer */
#define   US_USART_CSR_ENDRX_0      (0x0u <<  3) /**< \brief (US_USART_CSR) The End of Transfer signal from the Receive PDC channel is inactive */
#define   US_USART_CSR_ENDRX_1      (0x1u <<  3) /**< \brief (US_USART_CSR) The End of Transfer signal from the Receive PDC channel is active */
#define US_USART_CSR_ENDTX          (0x1u <<  4) /**< \brief (US_USART_CSR) End of Transmitter Transfer */
#define   US_USART_CSR_ENDTX_0      (0x0u <<  4) /**< \brief (US_USART_CSR) The End of Transfer signal from the Transmit PDC channel is inactive */
#define   US_USART_CSR_ENDTX_1      (0x1u <<  4) /**< \brief (US_USART_CSR) The End of Transfer signal from the Transmit PDC channel is active */
#define US_USART_CSR_OVRE           (0x1u <<  5) /**< \brief (US_USART_CSR) Overrun Error */
#define   US_USART_CSR_OVRE_0       (0x0u <<  5) /**< \brief (US_USART_CSR) No overrun error has occurred since since the last RSTSTA */
#define   US_USART_CSR_OVRE_1       (0x1u <<  5) /**< \brief (US_USART_CSR) At least one overrun error has occurred since the last RSTSTA */
#define US_USART_CSR_FRAME          (0x1u <<  6) /**< \brief (US_USART_CSR) Framing Error */
#define   US_USART_CSR_FRAME_0      (0x0u <<  6) /**< \brief (US_USART_CSR) No stop bit has been detected low since the last RSTSTA */
#define   US_USART_CSR_FRAME_1      (0x1u <<  6) /**< \brief (US_USART_CSR) At least one stop bit has been detected low since the last RSTSTA */
#define US_USART_CSR_PARE           (0x1u <<  7) /**< \brief (US_USART_CSR) Parity Error */
#define   US_USART_CSR_PARE_0       (0x0u <<  7) /**< \brief (US_USART_CSR) No parity error has been detected since the last RSTSTA */
#define   US_USART_CSR_PARE_1       (0x1u <<  7) /**< \brief (US_USART_CSR) At least one parity error has been detected since the last RSTSTA */
#define US_USART_CSR_TIMEOUT        (0x1u <<  8) /**< \brief (US_USART_CSR) Receiver Time-out */
#define   US_USART_CSR_TIMEOUT_0    (0x0u <<  8) /**< \brief (US_USART_CSR) There has not been a time-out since the last Start Time-out command or the Time-out Register is 0 */
#define   US_USART_CSR_TIMEOUT_1    (0x1u <<  8) /**< \brief (US_USART_CSR) There has been a time-out since the last Start Time-out command */
#define US_USART_CSR_TXEMPTY        (0x1u <<  9) /**< \brief (US_USART_CSR) Transmitter Empty */
#define   US_USART_CSR_TXEMPTY_0    (0x0u <<  9) /**< \brief (US_USART_CSR) There are characters in either THR or the Transmit Shift Register, or the transmitter is disabled */
#define   US_USART_CSR_TXEMPTY_1    (0x1u <<  9) /**< \brief (US_USART_CSR) There is at least one character in either THR or the Transmit Shift Register */
#define US_USART_CSR_ITER           (0x1u << 10) /**< \brief (US_USART_CSR) Max number of Repetitions Reached */
#define   US_USART_CSR_ITER_0       (0x0u << 10) /**< \brief (US_USART_CSR) Maximum number of repetitions has not been reached since the last RSIT */
#define   US_USART_CSR_ITER_1       (0x1u << 10) /**< \brief (US_USART_CSR) Maximum number of repetitions has been reached since the last RSIT */
#define US_USART_CSR_TXBUFE         (0x1u << 11) /**< \brief (US_USART_CSR) Transmission Buffer Empty */
#define   US_USART_CSR_TXBUFE_0     (0x0u << 11) /**< \brief (US_USART_CSR) The signal Buffer Empty from the Transmit PDC channel is inactive */
#define   US_USART_CSR_TXBUFE_1     (0x1u << 11) /**< \brief (US_USART_CSR) The signal Buffer Empty from the Transmit PDC channel is active */
#define US_USART_CSR_RXBUFF         (0x1u << 12) /**< \brief (US_USART_CSR) Reception Buffer Full */
#define   US_USART_CSR_RXBUFF_0     (0x0u << 12) /**< \brief (US_USART_CSR) The signal Buffer Full from the Receive PDC channel is inactive */
#define   US_USART_CSR_RXBUFF_1     (0x1u << 12) /**< \brief (US_USART_CSR) The signal Buffer Full from the Receive PDC channel is active */
#define US_USART_CSR_NACK           (0x1u << 13) /**< \brief (US_USART_CSR) Non Acknowledge */
#define   US_USART_CSR_NACK_0       (0x0u << 13) /**< \brief (US_USART_CSR) No Non Acknowledge has not been detected since the last RSTNACK */
#define   US_USART_CSR_NACK_1       (0x1u << 13) /**< \brief (US_USART_CSR) At least one Non Acknowledge has been detected since the last RSTNACK */
#define US_USART_CSR_RIIC           (0x1u << 16) /**< \brief (US_USART_CSR) Ring Indicator Input Change Flag */
#define   US_USART_CSR_RIIC_0       (0x0u << 16) /**< \brief (US_USART_CSR) No input change has been detected on the RI pin since the last read of CSR */
#define   US_USART_CSR_RIIC_1       (0x1u << 16) /**< \brief (US_USART_CSR) At least one input change has been detected on the RI pin since the last read of CSR */
#define US_USART_CSR_DSRIC          (0x1u << 17) /**< \brief (US_USART_CSR) Data Set Ready Input Change Flag */
#define   US_USART_CSR_DSRIC_0      (0x0u << 17) /**< \brief (US_USART_CSR) No input change has been detected on the DSR pin since the last read of CSR */
#define   US_USART_CSR_DSRIC_1      (0x1u << 17) /**< \brief (US_USART_CSR) At least one input change has been detected on the DSR pin since the last read of CSR */
#define US_USART_CSR_DCDIC          (0x1u << 18) /**< \brief (US_USART_CSR) Data Carrier Detect Input Change Flag */
#define   US_USART_CSR_DCDIC_0      (0x0u << 18) /**< \brief (US_USART_CSR) No input change has been detected on the DCD pin since the last read of CSR */
#define   US_USART_CSR_DCDIC_1      (0x1u << 18) /**< \brief (US_USART_CSR) At least one input change has been detected on the DCD pin since the last read of CSR */
#define US_USART_CSR_CTSIC          (0x1u << 19) /**< \brief (US_USART_CSR) Clear to Send Input Change Flag */
#define   US_USART_CSR_CTSIC_0      (0x0u << 19) /**< \brief (US_USART_CSR) No input change has been detected on the CTS pin since the last read of CSR */
#define   US_USART_CSR_CTSIC_1      (0x1u << 19) /**< \brief (US_USART_CSR) At least one input change has been detected on the CTS pin since the last read of CSR */
#define US_USART_CSR_RI             (0x1u << 20) /**< \brief (US_USART_CSR) Image of RI Input */
#define   US_USART_CSR_RI_0         (0x0u << 20) /**< \brief (US_USART_CSR) RI is at 0 */
#define   US_USART_CSR_RI_1         (0x1u << 20) /**< \brief (US_USART_CSR) RI is at 1 */
#define US_USART_CSR_DSR            (0x1u << 21) /**< \brief (US_USART_CSR) Image of DSR Input */
#define   US_USART_CSR_DSR_0        (0x0u << 21) /**< \brief (US_USART_CSR) DSR is at 0 */
#define   US_USART_CSR_DSR_1        (0x1u << 21) /**< \brief (US_USART_CSR) DSR is at 1 */
#define US_USART_CSR_DCD            (0x1u << 22) /**< \brief (US_USART_CSR) Image of DCD Input */
#define   US_USART_CSR_DCD_0        (0x0u << 22) /**< \brief (US_USART_CSR) DCD is at 0 */
#define   US_USART_CSR_DCD_1        (0x1u << 22) /**< \brief (US_USART_CSR) DCD is at 1 */
#define US_USART_CSR_CTS            (0x1u << 23) /**< \brief (US_USART_CSR) Image of CTS Input */
#define   US_USART_CSR_CTS_0        (0x0u << 23) /**< \brief (US_USART_CSR) CTS is at 0 */
#define   US_USART_CSR_CTS_1        (0x1u << 23) /**< \brief (US_USART_CSR) CTS is at 1 */
#define US_USART_CSR_MANERR         (0x1u << 24) /**< \brief (US_USART_CSR) Manchester Error */
#define   US_USART_CSR_MANERR_0     (0x0u << 24) /**< \brief (US_USART_CSR) No Manchester error has been detected since the last RSTSTA */
#define   US_USART_CSR_MANERR_1     (0x1u << 24) /**< \brief (US_USART_CSR) At least one Manchester error has been detected since the last RSTSTA */
/* -------- US_RHR : (USART Offset: 0x18) Receiver Holding Register -------- */
#define US_RHR_RXCHR_Pos            0
#define US_RHR_RXCHR_Msk            (0x1FFu << US_RHR_RXCHR_Pos) /**< \brief (US_RHR) Received Character */
#define US_RHR_RXCHR(value)         ((US_RHR_RXCHR_Msk & ((value) << US_RHR_RXCHR_Pos)))
#define US_RHR_RXSYNH               (0x1u << 15) /**< \brief (US_RHR) Received Sync */
#define   US_RHR_RXSYNH_0           (0x0u << 15) /**< \brief (US_RHR) Last character received is a Data */
#define   US_RHR_RXSYNH_1           (0x1u << 15) /**< \brief (US_RHR) Last character received is a Command */
/* -------- US_THR : (USART Offset: 0x1C) Transmitter Holding Register -------- */
#define US_THR_TXCHR_Pos            0
#define US_THR_TXCHR_Msk            (0x1FFu << US_THR_TXCHR_Pos) /**< \brief (US_THR) Character to be Transmitted */
#define US_THR_TXCHR(value)         ((US_THR_TXCHR_Msk & ((value) << US_THR_TXCHR_Pos)))
#define US_THR_TXSYNH               (0x1u << 15) /**< \brief (US_THR) Sync Field to be transmitted */
#define   US_THR_TXSYNH_0           (0x0u << 15) /**< \brief (US_THR) The next character sent is encoded as a data. Start Frame Delimiter is DATA SYNC */
#define   US_THR_TXSYNH_1           (0x1u << 15) /**< \brief (US_THR) The next character sent is encoded as a command. Start Frame Delimiter is COMMAND SYNC */
/* -------- US_BRGR : (USART Offset: 0x20) Baud Rate Generator Register -------- */
#define US_BRGR_CD_Pos              0
#define US_BRGR_CD_Msk              (0xFFFFu << US_BRGR_CD_Pos) /**< \brief (US_BRGR) Clock Divisor */
#define US_BRGR_CD(value)           ((US_BRGR_CD_Msk & ((value) << US_BRGR_CD_Pos)))
#define   US_BRGR_CD_DISABLE        (0x0u <<  0) /**< \brief (US_BRGR) Disables the clock */
#define   US_BRGR_CD_BYPASS         (0x1u <<  0) /**< \brief (US_BRGR) Clock Divisor Bypass */
#define   US_BRGR_CD_2              (0x2u <<  0) /**< \brief (US_BRGR) Baud Rate (Asynchronous Mode) = Selected Clock/(16 x CD) or (8 x CD); Baud Rate (Synchronous Mode) = Selected Clock/CD; */
#define US_BRGR_FP_Pos              16
#define US_BRGR_FP_Msk              (0x7u << US_BRGR_FP_Pos) /**< \brief (US_BRGR) Fractional Part */
#define US_BRGR_FP(value)           ((US_BRGR_FP_Msk & ((value) << US_BRGR_FP_Pos)))
#define   US_BRGR_FP_0              (0x0u << 16) /**< \brief (US_BRGR) Fractional divider is disabled */
/* -------- US_RTOR : (USART Offset: 0x24) Receiver Time-out Register -------- */
#define US_RTOR_TO_Pos              0
#define US_RTOR_TO_Msk              (0x1FFFFu << US_RTOR_TO_Pos) /**< \brief (US_RTOR) Time-out Value */
#define US_RTOR_TO(value)           ((US_RTOR_TO_Msk & ((value) << US_RTOR_TO_Pos)))
#define   US_RTOR_TO_DISABLE        (0x0u <<  0) /**< \brief (US_RTOR) Disables the RX Time-out function */
/* -------- US_TTGR : (USART Offset: 0x28) Transmitter Timeguard Register -------- */
#define US_TTGR_TG_Pos              0
#define US_TTGR_TG_Msk              (0xFFu << US_TTGR_TG_Pos) /**< \brief (US_TTGR) Timeguard Value */
#define US_TTGR_TG(value)           ((US_TTGR_TG_Msk & ((value) << US_TTGR_TG_Pos)))
#define   US_TTGR_TG_DISABLE        (0x0u <<  0) /**< \brief (US_TTGR) Disables the TX Timeguard function. */
/* -------- US_FIDI : (USART Offset: 0x40) FI DI Ratio Register -------- */
#define US_FIDI_FI_DI_RATIO_Pos     0
#define US_FIDI_FI_DI_RATIO_Msk     (0x7FFu << US_FIDI_FI_DI_RATIO_Pos) /**< \brief (US_FIDI) FI Over DI Ratio Value */
#define US_FIDI_FI_DI_RATIO(value)  ((US_FIDI_FI_DI_RATIO_Msk & ((value) << US_FIDI_FI_DI_RATIO_Pos)))
#define   US_FIDI_FI_DI_RATIO_DISABLE (0x0u <<  0) /**< \brief (US_FIDI) Baud Rate = 0 */
/* -------- US_NER : (USART Offset: 0x44) Number of Errors Register -------- */
#define US_NER_NB_ERRORS_Pos        0
#define US_NER_NB_ERRORS_Msk        (0xFFu << US_NER_NB_ERRORS_Pos) /**< \brief (US_NER) Error number during ISO7816 transfers */
#define US_NER_NB_ERRORS(value)     ((US_NER_NB_ERRORS_Msk & ((value) << US_NER_NB_ERRORS_Pos)))
/* -------- US_IFR : (USART Offset: 0x4C) IrDA Filter Register -------- */
#define US_IFR_IRDA_FILTER_Pos      0
#define US_IFR_IRDA_FILTER_Msk      (0xFFu << US_IFR_IRDA_FILTER_Pos) /**< \brief (US_IFR) Irda filter */
#define US_IFR_IRDA_FILTER(value)   ((US_IFR_IRDA_FILTER_Msk & ((value) << US_IFR_IRDA_FILTER_Pos)))
/* -------- US_MAN : (USART Offset: 0x50) Manchester Configuration Register -------- */
#define US_MAN_TX_PL_Pos            0
#define US_MAN_TX_PL_Msk            (0xFu << US_MAN_TX_PL_Pos) /**< \brief (US_MAN) Transmitter Preamble Length */
#define US_MAN_TX_PL(value)         ((US_MAN_TX_PL_Msk & ((value) << US_MAN_TX_PL_Pos)))
#define   US_MAN_TX_PL_0            (0x0u <<  0) /**< \brief (US_MAN) The Transmitter Preamble pattern generation is disabled */
#define US_MAN_TX_PP_Pos            8
#define US_MAN_TX_PP_Msk            (0x3u << US_MAN_TX_PP_Pos) /**< \brief (US_MAN) Transmitter Preamble Pattern */
#define US_MAN_TX_PP(value)         ((US_MAN_TX_PP_Msk & ((value) << US_MAN_TX_PP_Pos)))
#define   US_MAN_TX_PP_0            (0x0u <<  8) /**< \brief (US_MAN) ALL_ONE */
#define   US_MAN_TX_PP_1            (0x1u <<  8) /**< \brief (US_MAN) ALL_ZERO */
#define   US_MAN_TX_PP_2            (0x2u <<  8) /**< \brief (US_MAN) ZERO_ONE */
#define   US_MAN_TX_PP_3            (0x3u <<  8) /**< \brief (US_MAN) ONE_ZERO */
#define US_MAN_TX_MPOL              (0x1u << 12) /**< \brief (US_MAN) Transmitter Manchester Polarity */
#define   US_MAN_TX_MPOL_0          (0x0u << 12) /**< \brief (US_MAN) Logic Zero is coded as a zero-to-one transition, Logic One is coded as a one-to-zero transition */
#define   US_MAN_TX_MPOL_1          (0x1u << 12) /**< \brief (US_MAN) Logic Zero is coded as a one-to-zero transition, Logic One is coded as a zero-to-one transition */
#define US_MAN_RX_PL_Pos            16
#define US_MAN_RX_PL_Msk            (0xFu << US_MAN_RX_PL_Pos) /**< \brief (US_MAN) Receiver Preamble Length */
#define US_MAN_RX_PL(value)         ((US_MAN_RX_PL_Msk & ((value) << US_MAN_RX_PL_Pos)))
#define   US_MAN_RX_PL_0            (0x0u << 16) /**< \brief (US_MAN) The receiver preamble pattern detection is disabled */
#define US_MAN_RX_PP_Pos            24
#define US_MAN_RX_PP_Msk            (0x3u << US_MAN_RX_PP_Pos) /**< \brief (US_MAN) Receiver Preamble Pattern detected */
#define US_MAN_RX_PP(value)         ((US_MAN_RX_PP_Msk & ((value) << US_MAN_RX_PP_Pos)))
#define   US_MAN_RX_PP_0            (0x0u << 24) /**< \brief (US_MAN) ALL_ONE */
#define   US_MAN_RX_PP_1            (0x1u << 24) /**< \brief (US_MAN) ALL_ZERO */
#define   US_MAN_RX_PP_2            (0x2u << 24) /**< \brief (US_MAN) ZERO_ONE */
#define   US_MAN_RX_PP_3            (0x3u << 24) /**< \brief (US_MAN) ONE_ZERO */
#define US_MAN_RX_MPOL              (0x1u << 28) /**< \brief (US_MAN) Receiver Manchester Polarity */
#define   US_MAN_RX_MPOL_0          (0x0u << 28) /**< \brief (US_MAN) Logic Zero is coded as a zero-to-one transition, Logic One is coded as a one-to-zero transition */
#define   US_MAN_RX_MPOL_1          (0x1u << 28) /**< \brief (US_MAN) Logic Zero is coded as a one-to-zero transition, Logic One is coded as a zero-to-one transition */
#define US_MAN_DRIFT                (0x1u << 30) /**< \brief (US_MAN) Drift compensation */
#define   US_MAN_DRIFT_0            (0x0u << 30) /**< \brief (US_MAN) The USART can not recover from an important clock drift */
#define   US_MAN_DRIFT_1            (0x1u << 30) /**< \brief (US_MAN) The USART can recover from clock drift. The 16X clock mode must be enabled */
/* -------- US_LINMR : (USART Offset: 0x54) LIN Mode Register -------- */
#define US_LINMR_NACT_Pos           0
#define US_LINMR_NACT_Msk           (0x3u << US_LINMR_NACT_Pos) /**< \brief (US_LINMR) LIN Node Action */
#define US_LINMR_NACT(value)        ((US_LINMR_NACT_Msk & ((value) << US_LINMR_NACT_Pos)))
#define   US_LINMR_NACT_PUBLISH     (0x0u <<  0) /**< \brief (US_LINMR) The LIN Controller transmits the response */
#define   US_LINMR_NACT_SUBSCRIBE   (0x1u <<  0) /**< \brief (US_LINMR) The LIN Controller receives the response */
#define   US_LINMR_NACT_IGNORE      (0x2u <<  0) /**< \brief (US_LINMR) The LIN Controller doesn't transmit and doesn't receive the response */
#define US_LINMR_PARDIS             (0x1u <<  2) /**< \brief (US_LINMR) Parity Disable */
#define US_LINMR_CHKDIS             (0x1u <<  3) /**< \brief (US_LINMR) Checksum Disable */
#define US_LINMR_CHKTYP             (0x1u <<  4) /**< \brief (US_LINMR) Checksum Type */
#define US_LINMR_DLM                (0x1u <<  5) /**< \brief (US_LINMR) Data Length Mode */
#define US_LINMR_FSDIS              (0x1u <<  6) /**< \brief (US_LINMR) Frame Slot Mode Disable */
#define US_LINMR_WKUPTYP            (0x1u <<  7) /**< \brief (US_LINMR) Wakeup Signal Type */
#define US_LINMR_DLC_Pos            8
#define US_LINMR_DLC_Msk            (0xFFu << US_LINMR_DLC_Pos) /**< \brief (US_LINMR) Data Length Control */
#define US_LINMR_DLC(value)         ((US_LINMR_DLC_Msk & ((value) << US_LINMR_DLC_Pos)))
#define US_LINMR_PDCM               (0x1u << 16) /**< \brief (US_LINMR) PDC Mode */
#define US_LINMR_SYNCDIS            (0x1u << 17) /**< \brief (US_LINMR) Synchronization Disable */
/* -------- US_LINIR : (USART Offset: 0x58) LIN Identifier Register -------- */
#define US_LINIR_IDCHR_Pos          0
#define US_LINIR_IDCHR_Msk          (0xFFu << US_LINIR_IDCHR_Pos) /**< \brief (US_LINIR) Identifier Character */
#define US_LINIR_IDCHR(value)       ((US_LINIR_IDCHR_Msk & ((value) << US_LINIR_IDCHR_Pos)))
/* -------- US_LINBRR : (USART Offset: 0x5C) LIN Baud Rate Register -------- */
#define US_LINBRR_LINCD_Pos         0
#define US_LINBRR_LINCD_Msk         (0xFFFFu << US_LINBRR_LINCD_Pos) /**< \brief (US_LINBRR) Clock Divider after Synchronization */
#define US_LINBRR_LINCD(value)      ((US_LINBRR_LINCD_Msk & ((value) << US_LINBRR_LINCD_Pos)))
#define US_LINBRR_LINFP_Pos         16
#define US_LINBRR_LINFP_Msk         (0x7u << US_LINBRR_LINFP_Pos) /**< \brief (US_LINBRR) Fractional Part after Synchronization */
#define US_LINBRR_LINFP(value)      ((US_LINBRR_LINFP_Msk & ((value) << US_LINBRR_LINFP_Pos)))
/* -------- US_WPMR : (USART Offset: 0xE4) Write Protect Mode Register -------- */
#define US_WPMR_WPEN                (0x1u <<  0) /**< \brief (US_WPMR) Write Protect Enable */
#define   US_WPMR_WPEN_0            (0x0u <<  0) /**< \brief (US_WPMR) Disables the Write Protect if WPKEY corresponds to 0x858365 ("USA" in ACII) */
#define   US_WPMR_WPEN_1            (0x1u <<  0) /**< \brief (US_WPMR) Enables the Write Protect if WPKEY corresponds to 0x858365 ("USA" in ACII) */
#define US_WPMR_WPKEY_Pos           8
#define US_WPMR_WPKEY_Msk           (0xFFFFFFu << US_WPMR_WPKEY_Pos) /**< \brief (US_WPMR) Write Protect Key */
#define US_WPMR_WPKEY(value)        ((US_WPMR_WPKEY_Msk & ((value) << US_WPMR_WPKEY_Pos)))
/* -------- US_WPSR : (USART Offset: 0xE8) Write Protect Status Register -------- */
#define US_WPSR_WPV                 (0x1u <<  0) /**< \brief (US_WPSR) Write Protect Violation Status */
#define   US_WPSR_WPV_0             (0x0u <<  0) /**< \brief (US_WPSR) No Write Protect Violation has occurred since the last read of the WPSR register */
#define   US_WPSR_WPV_1             (0x1u <<  0) /**< \brief (US_WPSR) A Write Protect Violation has occurred since the last read of the WPSR register. If this violation is an unauthorized attempt to write a protected register, the associated violation is reported into field WPVSRC */
#define US_WPSR_WPVSRC_Pos          8
#define US_WPSR_WPVSRC_Msk          (0xFFFFu << US_WPSR_WPVSRC_Pos) /**< \brief (US_WPSR) Write Protect Violation Source */
#define US_WPSR_WPVSRC(value)       ((US_WPSR_WPVSRC_Msk & ((value) << US_WPSR_WPVSRC_Pos)))
/* -------- US_VERSION : (USART Offset: 0xFC) Version Register -------- */
#define US_VERSION_VERSION_Pos      0
#define US_VERSION_VERSION_Msk      (0xFFFu << US_VERSION_VERSION_Pos) /**< \brief (US_VERSION)  */
#define US_VERSION_VERSION(value)   ((US_VERSION_VERSION_Msk & ((value) << US_VERSION_VERSION_Pos)))
#define US_VERSION_MFN_Pos          16
#define US_VERSION_MFN_Msk          (0xFu << US_VERSION_MFN_Pos) /**< \brief (US_VERSION)  */
#define US_VERSION_MFN(value)       ((US_VERSION_MFN_Msk & ((value) << US_VERSION_MFN_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR USBC */
/* ============================================================================= */
/** \addtogroup SAM4L4_USBC USB 2.0 Interface */
/*@{*/

#define REV_USBC       0x310

#ifndef __ASSEMBLY__
/** \brief USBC hardware registers */
typedef struct {
  RwReg   UDCON;       /**< \brief (USBC Offset: 0x000) Device General Control Register */
  RoReg   UDINT;       /**< \brief (USBC Offset: 0x004) Device Global Interupt Register */
  WoReg   UDINTCLR;    /**< \brief (USBC Offset: 0x008) Device Global Interrupt Clear Register */
  WoReg   UDINTSET;    /**< \brief (USBC Offset: 0x00C) Device Global Interrupt Set Regsiter */
  RoReg   UDINTE;      /**< \brief (USBC Offset: 0x010) Device Global Interrupt Enable Register */
  WoReg   UDINTECLR;   /**< \brief (USBC Offset: 0x014) Device Global Interrupt Enable Clear Register */
  WoReg   UDINTESET;   /**< \brief (USBC Offset: 0x018) Device Global Interrupt Enable Set Register */
  RwReg   UERST;       /**< \brief (USBC Offset: 0x01C) Endpoint Enable/Reset Register */
  RoReg   UDFNUM;      /**< \brief (USBC Offset: 0x020) Device Frame Number Register */
  RoReg   Reserved1[55];
  RwReg   UECFG0;      /**< \brief (USBC Offset: 0x100) Endpoint Configuration Register */
  RwReg   UECFG1;      /**< \brief (USBC Offset: 0x104) Endpoint Configuration Register */
  RwReg   UECFG2;      /**< \brief (USBC Offset: 0x108) Endpoint Configuration Register */
  RwReg   UECFG3;      /**< \brief (USBC Offset: 0x10C) Endpoint Configuration Register */
  RwReg   UECFG4;      /**< \brief (USBC Offset: 0x110) Endpoint Configuration Register */
  RwReg   UECFG5;      /**< \brief (USBC Offset: 0x114) Endpoint Configuration Register */
  RwReg   UECFG6;      /**< \brief (USBC Offset: 0x118) Endpoint Configuration Register */
  RwReg   UECFG7;      /**< \brief (USBC Offset: 0x11C) Endpoint Configuration Register */
  RoReg   Reserved2[4];
  RoReg   UESTA0;      /**< \brief (USBC Offset: 0x130) Endpoint Status Register */
  RoReg   UESTA1;      /**< \brief (USBC Offset: 0x134) Endpoint Status Register */
  RoReg   UESTA2;      /**< \brief (USBC Offset: 0x138) Endpoint Status Register */
  RoReg   UESTA3;      /**< \brief (USBC Offset: 0x13C) Endpoint Status Register */
  RoReg   UESTA4;      /**< \brief (USBC Offset: 0x140) Endpoint Status Register */
  RoReg   UESTA5;      /**< \brief (USBC Offset: 0x144) Endpoint Status Register */
  RoReg   UESTA6;      /**< \brief (USBC Offset: 0x148) Endpoint Status Register */
  RoReg   UESTA7;      /**< \brief (USBC Offset: 0x14C) Endpoint Status Register */
  RoReg   Reserved3[4];
  WoReg   UESTA0CLR;   /**< \brief (USBC Offset: 0x160) Endpoint Status Clear Register */
  WoReg   UESTA1CLR;   /**< \brief (USBC Offset: 0x164) Endpoint Status Clear Register */
  WoReg   UESTA2CLR;   /**< \brief (USBC Offset: 0x168) Endpoint Status Clear Register */
  WoReg   UESTA3CLR;   /**< \brief (USBC Offset: 0x16C) Endpoint Status Clear Register */
  WoReg   UESTA4CLR;   /**< \brief (USBC Offset: 0x170) Endpoint Status Clear Register */
  WoReg   UESTA5CLR;   /**< \brief (USBC Offset: 0x174) Endpoint Status Clear Register */
  WoReg   UESTA6CLR;   /**< \brief (USBC Offset: 0x178) Endpoint Status Clear Register */
  WoReg   UESTA7CLR;   /**< \brief (USBC Offset: 0x17C) Endpoint Status Clear Register */
  RoReg   Reserved4[4];
  WoReg   UESTA0SET;   /**< \brief (USBC Offset: 0x190) Endpoint Status Set Register */
  WoReg   UESTA1SET;   /**< \brief (USBC Offset: 0x194) Endpoint Status Set Register */
  WoReg   UESTA2SET;   /**< \brief (USBC Offset: 0x198) Endpoint Status Set Register */
  WoReg   UESTA3SET;   /**< \brief (USBC Offset: 0x19C) Endpoint Status Set Register */
  WoReg   UESTA4SET;   /**< \brief (USBC Offset: 0x1A0) Endpoint Status Set Register */
  WoReg   UESTA5SET;   /**< \brief (USBC Offset: 0x1A4) Endpoint Status Set Register */
  WoReg   UESTA6SET;   /**< \brief (USBC Offset: 0x1A8) Endpoint Status Set Register */
  WoReg   UESTA7SET;   /**< \brief (USBC Offset: 0x1AC) Endpoint Status Set Register */
  RoReg   Reserved5[4];
  RoReg   UECON0;      /**< \brief (USBC Offset: 0x1C0) Endpoint Control Register */
  RoReg   UECON1;      /**< \brief (USBC Offset: 0x1C4) Endpoint Control Register */
  RoReg   UECON2;      /**< \brief (USBC Offset: 0x1C8) Endpoint Control Register */
  RoReg   UECON3;      /**< \brief (USBC Offset: 0x1CC) Endpoint Control Register */
  RoReg   UECON4;      /**< \brief (USBC Offset: 0x1D0) Endpoint Control Register */
  RoReg   UECON5;      /**< \brief (USBC Offset: 0x1D4) Endpoint Control Register */
  RoReg   UECON6;      /**< \brief (USBC Offset: 0x1D8) Endpoint Control Register */
  RoReg   UECON7;      /**< \brief (USBC Offset: 0x1DC) Endpoint Control Register */
  RoReg   Reserved6[4];
  WoReg   UECON0SET;   /**< \brief (USBC Offset: 0x1F0) Endpoint Control Set Register */
  WoReg   UECON1SET;   /**< \brief (USBC Offset: 0x1F4) Endpoint Control Set Register */
  WoReg   UECON2SET;   /**< \brief (USBC Offset: 0x1F8) Endpoint Control Set Register */
  WoReg   UECON3SET;   /**< \brief (USBC Offset: 0x1FC) Endpoint Control Set Register */
  WoReg   UECON4SET;   /**< \brief (USBC Offset: 0x200) Endpoint Control Set Register */
  WoReg   UECON5SET;   /**< \brief (USBC Offset: 0x204) Endpoint Control Set Register */
  WoReg   UECON6SET;   /**< \brief (USBC Offset: 0x208) Endpoint Control Set Register */
  WoReg   UECON7SET;   /**< \brief (USBC Offset: 0x20C) Endpoint Control Set Register */
  RoReg   Reserved7[4];
  WoReg   UECON0CLR;   /**< \brief (USBC Offset: 0x220) Endpoint Control Clear Register */
  WoReg   UECON1CLR;   /**< \brief (USBC Offset: 0x224) TXINE Clear */
  WoReg   UECON2CLR;   /**< \brief (USBC Offset: 0x228) TXINE Clear */
  WoReg   UECON3CLR;   /**< \brief (USBC Offset: 0x22C) TXINE Clear */
  WoReg   UECON4CLR;   /**< \brief (USBC Offset: 0x230) TXINE Clear */
  WoReg   UECON5CLR;   /**< \brief (USBC Offset: 0x234) TXINE Clear */
  WoReg   UECON6CLR;   /**< \brief (USBC Offset: 0x238) TXINE Clear */
  WoReg   UECON7CLR;   /**< \brief (USBC Offset: 0x23C) TXINE Clear */
  RoReg   Reserved8[112];
  RwReg   UHCON;       /**< \brief (USBC Offset: 0x400) Host General Control Register */
  RoReg   UHINT;       /**< \brief (USBC Offset: 0x404) Host Global Interrupt Register */
  WoReg   UHINTCLR;    /**< \brief (USBC Offset: 0x408) Host Global Interrrupt Clear Register */
  WoReg   UHINTSET;    /**< \brief (USBC Offset: 0x40C) Host Global Interrupt Set Register */
  RoReg   UHINTE;      /**< \brief (USBC Offset: 0x410) Host Global Interrupt Enable Register */
  WoReg   UHINTECLR;   /**< \brief (USBC Offset: 0x414) Host Global Interrupt Enable Clear Register */
  WoReg   UHINTESET;   /**< \brief (USBC Offset: 0x418) Host Global Interrupt Enable Set Register */
  RwReg   UPRST;       /**< \brief (USBC Offset: 0x41C) Pipe Reset Register */
  RwReg   UHFNUM;      /**< \brief (USBC Offset: 0x420) Host Frame Number Register */
  RwReg   UHSOFC;      /**< \brief (USBC Offset: 0x424) Host Start of Frame Control Register */
  RoReg   Reserved9[54];
  RwReg   UPCFG0;      /**< \brief (USBC Offset: 0x500) Pipe Configuration Register */
  RwReg   UPCFG1;      /**< \brief (USBC Offset: 0x504) Pipe Configuration Register */
  RwReg   UPCFG2;      /**< \brief (USBC Offset: 0x508) Pipe Configuration Register */
  RwReg   UPCFG3;      /**< \brief (USBC Offset: 0x50C) Pipe Configuration Register */
  RwReg   UPCFG4;      /**< \brief (USBC Offset: 0x510) Pipe Configuration Register */
  RwReg   UPCFG5;      /**< \brief (USBC Offset: 0x514) Pipe Configuration Register */
  RwReg   UPCFG6;      /**< \brief (USBC Offset: 0x518) Pipe Configuration Register */
  RwReg   UPCFG7;      /**< \brief (USBC Offset: 0x51C) Pipe Configuration Register */
  RoReg   Reserved10[4];
  RoReg   UPSTA0;      /**< \brief (USBC Offset: 0x530) Pipe Status Register */
  RoReg   UPSTA1;      /**< \brief (USBC Offset: 0x534) Pipe Status Register */
  RoReg   UPSTA2;      /**< \brief (USBC Offset: 0x538) Pipe Status Register */
  RoReg   UPSTA3;      /**< \brief (USBC Offset: 0x53C) Pipe Status Register */
  RoReg   UPSTA4;      /**< \brief (USBC Offset: 0x540) Pipe Status Register */
  RoReg   UPSTA5;      /**< \brief (USBC Offset: 0x544) Pipe Status Register */
  RoReg   UPSTA6;      /**< \brief (USBC Offset: 0x548) Pipe Status Register */
  RoReg   UPSTA7;      /**< \brief (USBC Offset: 0x54C) Pipe Status Register */
  RoReg   Reserved11[4];
  WoReg   UPSTA0CLR;   /**< \brief (USBC Offset: 0x560) Pipe Status Clear Register */
  WoReg   UPSTA1CLR;   /**< \brief (USBC Offset: 0x564) Pipe Status Clear Register */
  WoReg   UPSTA2CLR;   /**< \brief (USBC Offset: 0x568) Pipe Status Clear Register */
  WoReg   UPSTA3CLR;   /**< \brief (USBC Offset: 0x56C) Pipe Status Clear Register */
  WoReg   UPSTA4CLR;   /**< \brief (USBC Offset: 0x570) Pipe Status Clear Register */
  WoReg   UPSTA5CLR;   /**< \brief (USBC Offset: 0x574) Pipe Status Clear Register */
  WoReg   UPSTA6CLR;   /**< \brief (USBC Offset: 0x578) Pipe Status Clear Register */
  WoReg   UPSTA7CLR;   /**< \brief (USBC Offset: 0x57C) Pipe Status Clear Register */
  RoReg   Reserved12[4];
  WoReg   UPSTA0SET;   /**< \brief (USBC Offset: 0x590) Pipe Status Set Register */
  WoReg   UPSTA1SET;   /**< \brief (USBC Offset: 0x594) Pipe Status Set Register */
  WoReg   UPSTA2SET;   /**< \brief (USBC Offset: 0x598) Pipe Status Set Register */
  WoReg   UPSTA3SET;   /**< \brief (USBC Offset: 0x59C) Pipe Status Set Register */
  WoReg   UPSTA4SET;   /**< \brief (USBC Offset: 0x5A0) Pipe Status Set Register */
  WoReg   UPSTA5SET;   /**< \brief (USBC Offset: 0x5A4) Pipe Status Set Register */
  WoReg   UPSTA6SET;   /**< \brief (USBC Offset: 0x5A8) Pipe Status Set Register */
  WoReg   UPSTA7SET;   /**< \brief (USBC Offset: 0x5AC) Pipe Status Set Register */
  RoReg   Reserved13[4];
  RoReg   UPCON0;      /**< \brief (USBC Offset: 0x5C0) Pipe Control Register */
  RoReg   UPCON1;      /**< \brief (USBC Offset: 0x5C4) Pipe Control Register */
  RoReg   UPCON2;      /**< \brief (USBC Offset: 0x5C8) Pipe Control Register */
  RoReg   UPCON3;      /**< \brief (USBC Offset: 0x5CC) Pipe Control Register */
  RoReg   UPCON4;      /**< \brief (USBC Offset: 0x5D0) Pipe Control Register */
  RoReg   UPCON5;      /**< \brief (USBC Offset: 0x5D4) Pipe Control Register */
  RoReg   UPCON6;      /**< \brief (USBC Offset: 0x5D8) Pipe Control Register */
  RoReg   UPCON7;      /**< \brief (USBC Offset: 0x5DC) Pipe Control Register */
  RoReg   Reserved14[4];
  WoReg   UPCON0SET;   /**< \brief (USBC Offset: 0x5F0) Pipe Control Set Register */
  WoReg   UPCON1SET;   /**< \brief (USBC Offset: 0x5F4) Pipe Control Set Register */
  WoReg   UPCON2SET;   /**< \brief (USBC Offset: 0x5F8) Pipe Control Set Register */
  WoReg   UPCON3SET;   /**< \brief (USBC Offset: 0x5FC) Pipe Control Set Register */
  WoReg   UPCON4SET;   /**< \brief (USBC Offset: 0x600) Pipe Control Set Register */
  WoReg   UPCON5SET;   /**< \brief (USBC Offset: 0x604) Pipe Control Set Register */
  WoReg   UPCON6SET;   /**< \brief (USBC Offset: 0x608) Pipe Control Set Register */
  WoReg   UPCON7SET;   /**< \brief (USBC Offset: 0x60C) Pipe Control Set Register */
  RoReg   Reserved15[4];
  WoReg   UPCON0CLR;   /**< \brief (USBC Offset: 0x620) Pipe Control Clear Register */
  WoReg   UPCON1CLR;   /**< \brief (USBC Offset: 0x624) Pipe Control Clear Register */
  WoReg   UPCON2CLR;   /**< \brief (USBC Offset: 0x628) Pipe Control Clear Register */
  WoReg   UPCON3CLR;   /**< \brief (USBC Offset: 0x62C) Pipe Control Clear Register */
  WoReg   UPCON4CLR;   /**< \brief (USBC Offset: 0x630) Pipe Control Clear Register */
  WoReg   UPCON5CLR;   /**< \brief (USBC Offset: 0x634) Pipe Control Clear Register */
  WoReg   UPCON6CLR;   /**< \brief (USBC Offset: 0x638) Pipe Control Clear Register */
  WoReg   UPCON7CLR;   /**< \brief (USBC Offset: 0x63C) Pipe Control Clear Register */
  RoReg   Reserved16[4];
  RwReg   UPINRQ0;     /**< \brief (USBC Offset: 0x650) Pipe In Request */
  RwReg   UPINRQ1;     /**< \brief (USBC Offset: 0x654) Pipe In Request */
  RwReg   UPINRQ2;     /**< \brief (USBC Offset: 0x658) Pipe In Request */
  RwReg   UPINRQ3;     /**< \brief (USBC Offset: 0x65C) Pipe In Request */
  RwReg   UPINRQ4;     /**< \brief (USBC Offset: 0x660) Pipe In Request */
  RwReg   UPINRQ5;     /**< \brief (USBC Offset: 0x664) Pipe In Request */
  RwReg   UPINRQ6;     /**< \brief (USBC Offset: 0x668) Pipe In Request */
  RwReg   UPINRQ7;     /**< \brief (USBC Offset: 0x66C) Pipe In Request */
  RoReg   Reserved17[100];
  RwReg   USBCON;      /**< \brief (USBC Offset: 0x800) General Control Register */
  RoReg   USBSTA;      /**< \brief (USBC Offset: 0x804) General Status Register */
  WoReg   USBSTACLR;   /**< \brief (USBC Offset: 0x808) General Status Clear Register */
  WoReg   USBSTASET;   /**< \brief (USBC Offset: 0x80C) General Status Set Register */
  RoReg   Reserved18[2];
  RoReg   UVERS;       /**< \brief (USBC Offset: 0x818) IP Version Register */
  RoReg   UFEATURES;   /**< \brief (USBC Offset: 0x81C) IP Features Register */
  RoReg   UADDRSIZE;   /**< \brief (USBC Offset: 0x820) IP PB address size Register */
  RoReg   UNAME1;      /**< \brief (USBC Offset: 0x824) IP Name Part One: HUSB */
  RoReg   UNAME2;      /**< \brief (USBC Offset: 0x828) IP Name Part Two: HOST */
  RoReg   USBFSM;      /**< \brief (USBC Offset: 0x82C) USB internal finite state machine */
  RwReg   UDESC;       /**< \brief (USBC Offset: 0x830) Endpoint descriptor table */
} Usbc;
#endif /* __ASSEMBLY__ */
/* -------- USBC_UDCON : (USBC Offset: 0x000) Device General Control Register -------- */
#define USBC_UDCON_UADD_Pos         0
#define USBC_UDCON_UADD_Msk         (0x7Fu << USBC_UDCON_UADD_Pos) /**< \brief (USBC_UDCON) USB Address */
#define USBC_UDCON_UADD(value)      ((USBC_UDCON_UADD_Msk & ((value) << USBC_UDCON_UADD_Pos)))
#define USBC_UDCON_ADDEN            (0x1u <<  7) /**< \brief (USBC_UDCON) Address Enable */
#define USBC_UDCON_DETACH           (0x1u <<  8) /**< \brief (USBC_UDCON) Detach */
#define USBC_UDCON_RMWKUP           (0x1u <<  9) /**< \brief (USBC_UDCON) Remote Wake-Up */
#define USBC_UDCON_SPDCONF_Pos      10
#define USBC_UDCON_SPDCONF_Msk      (0x3u << USBC_UDCON_SPDCONF_Pos) /**< \brief (USBC_UDCON) Speed configuration */
#define USBC_UDCON_SPDCONF(value)   ((USBC_UDCON_SPDCONF_Msk & ((value) << USBC_UDCON_SPDCONF_Pos)))
#define USBC_UDCON_LS               (0x1u << 12) /**< \brief (USBC_UDCON) Low Speed Mode Force */
#define USBC_UDCON_TSTJ             (0x1u << 13) /**< \brief (USBC_UDCON) Test mode J */
#define USBC_UDCON_TSTK             (0x1u << 14) /**< \brief (USBC_UDCON) Test mode K */
#define USBC_UDCON_TSTPCKT          (0x1u << 15) /**< \brief (USBC_UDCON) Test Packet mode */
#define USBC_UDCON_OPMODE2          (0x1u << 16) /**< \brief (USBC_UDCON) Specific Operational mode */
#define USBC_UDCON_GNAK             (0x1u << 17) /**< \brief (USBC_UDCON) Global NAK */
/* -------- USBC_UDINT : (USBC Offset: 0x004) Device Global Interupt Register -------- */
#define USBC_UDINT_SUSP             (0x1u <<  0) /**< \brief (USBC_UDINT) Suspend Interrupt */
#define USBC_UDINT_MSOF             (0x1u <<  1) /**< \brief (USBC_UDINT) Micro Start of Frame Interrupt */
#define USBC_UDINT_SOF              (0x1u <<  2) /**< \brief (USBC_UDINT) Start of Frame Interrupt */
#define USBC_UDINT_EORST            (0x1u <<  3) /**< \brief (USBC_UDINT) End of Reset Interrupt */
#define USBC_UDINT_WAKEUP           (0x1u <<  4) /**< \brief (USBC_UDINT) Wake-Up Interrupt */
#define USBC_UDINT_EORSM            (0x1u <<  5) /**< \brief (USBC_UDINT) End Of Resume Interrupt */
#define USBC_UDINT_UPRSM            (0x1u <<  6) /**< \brief (USBC_UDINT) Upstream Resume Interrupt */
#define USBC_UDINT_EP0INT           (0x1u << 12) /**< \brief (USBC_UDINT) Endpoint 0 Interrupt */
#define USBC_UDINT_EP1INT           (0x1u << 13) /**< \brief (USBC_UDINT) Endpoint 1 Interrupt */
#define USBC_UDINT_EP2INT           (0x1u << 14) /**< \brief (USBC_UDINT) Endpoint 2 Interrupt */
#define USBC_UDINT_EP3INT           (0x1u << 15) /**< \brief (USBC_UDINT) Endpoint 3 Interrupt */
#define USBC_UDINT_EP4INT           (0x1u << 16) /**< \brief (USBC_UDINT) Endpoint 4 Interrupt */
#define USBC_UDINT_EP5INT           (0x1u << 17) /**< \brief (USBC_UDINT) Endpoint 5 Interrupt */
#define USBC_UDINT_EP6INT           (0x1u << 18) /**< \brief (USBC_UDINT) Endpoint 6 Interrupt */
#define USBC_UDINT_EP7INT           (0x1u << 19) /**< \brief (USBC_UDINT) Endpoint 7 Interrupt */
/* -------- USBC_UDINTCLR : (USBC Offset: 0x008) Device Global Interrupt Clear Register -------- */
#define USBC_UDINTCLR_SUSPC         (0x1u <<  0) /**< \brief (USBC_UDINTCLR) SUSP Interrupt Clear */
#define USBC_UDINTCLR_MSOFC         (0x1u <<  1) /**< \brief (USBC_UDINTCLR) MSOF Interrupt Clear */
#define USBC_UDINTCLR_SOFC          (0x1u <<  2) /**< \brief (USBC_UDINTCLR) SOF Interrupt Clear */
#define USBC_UDINTCLR_EORSTC        (0x1u <<  3) /**< \brief (USBC_UDINTCLR) EORST Interrupt Clear */
#define USBC_UDINTCLR_WAKEUPC       (0x1u <<  4) /**< \brief (USBC_UDINTCLR) WAKEUP Interrupt Clear */
#define USBC_UDINTCLR_EORSMC        (0x1u <<  5) /**< \brief (USBC_UDINTCLR) EORSM Interrupt Clear */
#define USBC_UDINTCLR_UPRSMC        (0x1u <<  6) /**< \brief (USBC_UDINTCLR) UPRSM Interrupt Clear */
/* -------- USBC_UDINTSET : (USBC Offset: 0x00C) Device Global Interrupt Set Regsiter -------- */
#define USBC_UDINTSET_SUSPS         (0x1u <<  0) /**< \brief (USBC_UDINTSET) SUSP Interrupt Set */
#define USBC_UDINTSET_MSOFS         (0x1u <<  1) /**< \brief (USBC_UDINTSET) MSOF Interrupt Set */
#define USBC_UDINTSET_SOFS          (0x1u <<  2) /**< \brief (USBC_UDINTSET) SOF Interrupt Set */
#define USBC_UDINTSET_EORSTS        (0x1u <<  3) /**< \brief (USBC_UDINTSET) EORST Interrupt Set */
#define USBC_UDINTSET_WAKEUPS       (0x1u <<  4) /**< \brief (USBC_UDINTSET) WAKEUP Interrupt Set */
#define USBC_UDINTSET_EORSMS        (0x1u <<  5) /**< \brief (USBC_UDINTSET) EORSM Interrupt Set */
#define USBC_UDINTSET_UPRSMS        (0x1u <<  6) /**< \brief (USBC_UDINTSET) UPRSM Interrupt Set */
/* -------- USBC_UDINTE : (USBC Offset: 0x010) Device Global Interrupt Enable Register -------- */
#define USBC_UDINTE_SUSPE           (0x1u <<  0) /**< \brief (USBC_UDINTE) SUSP Interrupt Enable */
#define USBC_UDINTE_MSOFE           (0x1u <<  1) /**< \brief (USBC_UDINTE) MSOF Interrupt Enable */
#define USBC_UDINTE_SOFE            (0x1u <<  2) /**< \brief (USBC_UDINTE) SOF Interrupt Enable */
#define USBC_UDINTE_EORSTE          (0x1u <<  3) /**< \brief (USBC_UDINTE) EORST Interrupt Enable */
#define USBC_UDINTE_WAKEUPE         (0x1u <<  4) /**< \brief (USBC_UDINTE) WAKEUP Interrupt Enable */
#define USBC_UDINTE_EORSME          (0x1u <<  5) /**< \brief (USBC_UDINTE) EORSM Interrupt Enable */
#define USBC_UDINTE_UPRSME          (0x1u <<  6) /**< \brief (USBC_UDINTE) UPRSM Interrupt Enable */
#define USBC_UDINTE_EP0INTE         (0x1u << 12) /**< \brief (USBC_UDINTE) EP0INT Interrupt Enable */
#define USBC_UDINTE_EP1INTE         (0x1u << 13) /**< \brief (USBC_UDINTE) EP1INT Interrupt Enable */
#define USBC_UDINTE_EP2INTE         (0x1u << 14) /**< \brief (USBC_UDINTE) EP2INT Interrupt Enable */
#define USBC_UDINTE_EP3INTE         (0x1u << 15) /**< \brief (USBC_UDINTE) EP3INT Interrupt Enable */
#define USBC_UDINTE_EP4INTE         (0x1u << 16) /**< \brief (USBC_UDINTE) EP4INT Interrupt Enable */
#define USBC_UDINTE_EP5INTE         (0x1u << 17) /**< \brief (USBC_UDINTE) EP5INT Interrupt Enable */
#define USBC_UDINTE_EP6INTE         (0x1u << 18) /**< \brief (USBC_UDINTE) EP6INT Interrupt Enable */
#define USBC_UDINTE_EP7INTE         (0x1u << 19) /**< \brief (USBC_UDINTE) EP7INT Interrupt Enable */
/* -------- USBC_UDINTECLR : (USBC Offset: 0x014) Device Global Interrupt Enable Clear Register -------- */
#define USBC_UDINTECLR_SUSPEC       (0x1u <<  0) /**< \brief (USBC_UDINTECLR) SUSP Interrupt Enable Clear */
#define USBC_UDINTECLR_MSOFEC       (0x1u <<  1) /**< \brief (USBC_UDINTECLR) MSOF Interrupt Enable Clear */
#define USBC_UDINTECLR_SOFEC        (0x1u <<  2) /**< \brief (USBC_UDINTECLR) SOF Interrupt Enable Clear */
#define USBC_UDINTECLR_EORSTEC      (0x1u <<  3) /**< \brief (USBC_UDINTECLR) EORST Interrupt Enable Clear */
#define USBC_UDINTECLR_WAKEUPEC     (0x1u <<  4) /**< \brief (USBC_UDINTECLR) WAKEUP Interrupt Enable Clear */
#define USBC_UDINTECLR_EORSMEC      (0x1u <<  5) /**< \brief (USBC_UDINTECLR) EORSM Interrupt Enable Clear */
#define USBC_UDINTECLR_UPRSMEC      (0x1u <<  6) /**< \brief (USBC_UDINTECLR) UPRSM Interrupt Enable Clear */
#define USBC_UDINTECLR_EP0INTEC     (0x1u << 12) /**< \brief (USBC_UDINTECLR) EP0INT Interrupt Enable Clear */
#define USBC_UDINTECLR_EP1INTEC     (0x1u << 13) /**< \brief (USBC_UDINTECLR) EP1INT Interrupt Enable Clear */
#define USBC_UDINTECLR_EP2INTEC     (0x1u << 14) /**< \brief (USBC_UDINTECLR) EP2INT Interrupt Enable Clear */
#define USBC_UDINTECLR_EP3INTEC     (0x1u << 15) /**< \brief (USBC_UDINTECLR) EP3INT Interrupt Enable Clear */
#define USBC_UDINTECLR_EP4INTEC     (0x1u << 16) /**< \brief (USBC_UDINTECLR) EP4INT Interrupt Enable Clear */
#define USBC_UDINTECLR_EP5INTEC     (0x1u << 17) /**< \brief (USBC_UDINTECLR) EP5INT Interrupt Enable Clear */
#define USBC_UDINTECLR_EP6INTEC     (0x1u << 18) /**< \brief (USBC_UDINTECLR) EP6INT Interrupt Enable Clear */
#define USBC_UDINTECLR_EP7INTEC     (0x1u << 19) /**< \brief (USBC_UDINTECLR) EP7INT Interrupt Enable Clear */
/* -------- USBC_UDINTESET : (USBC Offset: 0x018) Device Global Interrupt Enable Set Register -------- */
#define USBC_UDINTESET_SUSPES       (0x1u <<  0) /**< \brief (USBC_UDINTESET) SUSP Interrupt Enable Set */
#define USBC_UDINTESET_MSOFES       (0x1u <<  1) /**< \brief (USBC_UDINTESET) MSOF Interrupt Enable Set */
#define USBC_UDINTESET_SOFES        (0x1u <<  2) /**< \brief (USBC_UDINTESET) SOF Interrupt Enable Set */
#define USBC_UDINTESET_EORSTES      (0x1u <<  3) /**< \brief (USBC_UDINTESET) EORST Interrupt Enable Set */
#define USBC_UDINTESET_WAKEUPES     (0x1u <<  4) /**< \brief (USBC_UDINTESET) WAKEUP Interrupt Enable Set */
#define USBC_UDINTESET_EORSMES      (0x1u <<  5) /**< \brief (USBC_UDINTESET) EORSM Interrupt Enable Set */
#define USBC_UDINTESET_UPRSMES      (0x1u <<  6) /**< \brief (USBC_UDINTESET) UPRSM Interrupt Enable Set */
#define USBC_UDINTESET_EP0INTES     (0x1u << 12) /**< \brief (USBC_UDINTESET) EP0INT Interrupt Enable Set */
#define USBC_UDINTESET_EP1INTES     (0x1u << 13) /**< \brief (USBC_UDINTESET) EP1INT Interrupt Enable Set */
#define USBC_UDINTESET_EP2INTES     (0x1u << 14) /**< \brief (USBC_UDINTESET) EP2INT Interrupt Enable Set */
#define USBC_UDINTESET_EP3INTES     (0x1u << 15) /**< \brief (USBC_UDINTESET) EP3INT Interrupt Enable Set */
#define USBC_UDINTESET_EP4INTES     (0x1u << 16) /**< \brief (USBC_UDINTESET) EP4INT Interrupt Enable Set */
#define USBC_UDINTESET_EP5INTES     (0x1u << 17) /**< \brief (USBC_UDINTESET) EP5INT Interrupt Enable Set */
#define USBC_UDINTESET_EP6INTES     (0x1u << 18) /**< \brief (USBC_UDINTESET) EP6INT Interrupt Enable Set */
#define USBC_UDINTESET_EP7INTES     (0x1u << 19) /**< \brief (USBC_UDINTESET) EP7INT Interrupt Enable Set */
/* -------- USBC_UERST : (USBC Offset: 0x01C) Endpoint Enable/Reset Register -------- */
#define USBC_UERST_EPEN0            (0x1u <<  0) /**< \brief (USBC_UERST) Endpoint0 Enable */
#define USBC_UERST_EPEN1            (0x1u <<  1) /**< \brief (USBC_UERST) Endpoint1 Enable */
#define USBC_UERST_EPEN2            (0x1u <<  2) /**< \brief (USBC_UERST) Endpoint2 Enable */
#define USBC_UERST_EPEN3            (0x1u <<  3) /**< \brief (USBC_UERST) Endpoint3 Enable */
#define USBC_UERST_EPEN4            (0x1u <<  4) /**< \brief (USBC_UERST) Endpoint4 Enable */
#define USBC_UERST_EPEN5            (0x1u <<  5) /**< \brief (USBC_UERST) Endpoint5 Enable */
#define USBC_UERST_EPEN6            (0x1u <<  6) /**< \brief (USBC_UERST) Endpoint6 Enable */
#define USBC_UERST_EPEN7            (0x1u <<  7) /**< \brief (USBC_UERST) Endpoint7 Enable */
/* -------- USBC_UDFNUM : (USBC Offset: 0x020) Device Frame Number Register -------- */
#define USBC_UDFNUM_MFNUM_Pos       0
#define USBC_UDFNUM_MFNUM_Msk       (0x7u << USBC_UDFNUM_MFNUM_Pos) /**< \brief (USBC_UDFNUM) Micro Frame Number */
#define USBC_UDFNUM_MFNUM(value)    ((USBC_UDFNUM_MFNUM_Msk & ((value) << USBC_UDFNUM_MFNUM_Pos)))
#define USBC_UDFNUM_FNUM_Pos        3
#define USBC_UDFNUM_FNUM_Msk        (0x7FFu << USBC_UDFNUM_FNUM_Pos) /**< \brief (USBC_UDFNUM) Frame Number */
#define USBC_UDFNUM_FNUM(value)     ((USBC_UDFNUM_FNUM_Msk & ((value) << USBC_UDFNUM_FNUM_Pos)))
#define USBC_UDFNUM_FNCERR          (0x1u << 15) /**< \brief (USBC_UDFNUM) Frame Number CRC Error */
/* -------- USBC_UECFG0 : (USBC Offset: 0x100) Endpoint Configuration Register -------- */
#define USBC_UECFG0_EPBK            (0x1u <<  2) /**< \brief (USBC_UECFG0) Endpoint Bank */
#define   USBC_UECFG0_EPBK_SINGLE   (0x0u <<  2) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPBK_DOUBLE   (0x1u <<  2) /**< \brief (USBC_UECFG0)  */
#define USBC_UECFG0_EPSIZE_Pos      4
#define USBC_UECFG0_EPSIZE_Msk      (0x7u << USBC_UECFG0_EPSIZE_Pos) /**< \brief (USBC_UECFG0) Endpoint Size */
#define USBC_UECFG0_EPSIZE(value)   ((USBC_UECFG0_EPSIZE_Msk & ((value) << USBC_UECFG0_EPSIZE_Pos)))
#define   USBC_UECFG0_EPSIZE_8      (0x0u <<  4) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPSIZE_16     (0x1u <<  4) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPSIZE_32     (0x2u <<  4) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPSIZE_64     (0x3u <<  4) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPSIZE_128    (0x4u <<  4) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPSIZE_256    (0x5u <<  4) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPSIZE_512    (0x6u <<  4) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPSIZE_1024   (0x7u <<  4) /**< \brief (USBC_UECFG0)  */
#define USBC_UECFG0_EPDIR           (0x1u <<  8) /**< \brief (USBC_UECFG0) Endpoint Direction */
#define   USBC_UECFG0_EPDIR_OUT     (0x0u <<  8) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPDIR_IN      (0x1u <<  8) /**< \brief (USBC_UECFG0)  */
#define USBC_UECFG0_EPTYPE_Pos      11
#define USBC_UECFG0_EPTYPE_Msk      (0x3u << USBC_UECFG0_EPTYPE_Pos) /**< \brief (USBC_UECFG0) Endpoint Type */
#define USBC_UECFG0_EPTYPE(value)   ((USBC_UECFG0_EPTYPE_Msk & ((value) << USBC_UECFG0_EPTYPE_Pos)))
#define   USBC_UECFG0_EPTYPE_CONTROL (0x0u << 11) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPTYPE_ISOCHRONOUS (0x1u << 11) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPTYPE_BULK   (0x2u << 11) /**< \brief (USBC_UECFG0)  */
#define   USBC_UECFG0_EPTYPE_INTERRUPT (0x3u << 11) /**< \brief (USBC_UECFG0)  */
#define USBC_UECFG0_REPNB_Pos       16
#define USBC_UECFG0_REPNB_Msk       (0xFu << USBC_UECFG0_REPNB_Pos) /**< \brief (USBC_UECFG0) Redirected Endpoint Number */
#define USBC_UECFG0_REPNB(value)    ((USBC_UECFG0_REPNB_Msk & ((value) << USBC_UECFG0_REPNB_Pos)))
/* -------- USBC_UECFG1 : (USBC Offset: 0x104) Endpoint Configuration Register -------- */
#define USBC_UECFG1_EPBK            (0x1u <<  2) /**< \brief (USBC_UECFG1) Endpoint Bank */
#define   USBC_UECFG1_EPBK_SINGLE   (0x0u <<  2) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPBK_DOUBLE   (0x1u <<  2) /**< \brief (USBC_UECFG1)  */
#define USBC_UECFG1_EPSIZE_Pos      4
#define USBC_UECFG1_EPSIZE_Msk      (0x7u << USBC_UECFG1_EPSIZE_Pos) /**< \brief (USBC_UECFG1) Endpoint Size */
#define USBC_UECFG1_EPSIZE(value)   ((USBC_UECFG1_EPSIZE_Msk & ((value) << USBC_UECFG1_EPSIZE_Pos)))
#define   USBC_UECFG1_EPSIZE_8      (0x0u <<  4) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPSIZE_16     (0x1u <<  4) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPSIZE_32     (0x2u <<  4) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPSIZE_64     (0x3u <<  4) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPSIZE_128    (0x4u <<  4) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPSIZE_256    (0x5u <<  4) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPSIZE_512    (0x6u <<  4) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPSIZE_1024   (0x7u <<  4) /**< \brief (USBC_UECFG1)  */
#define USBC_UECFG1_EPDIR           (0x1u <<  8) /**< \brief (USBC_UECFG1) Endpoint Direction */
#define   USBC_UECFG1_EPDIR_OUT     (0x0u <<  8) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPDIR_IN      (0x1u <<  8) /**< \brief (USBC_UECFG1)  */
#define USBC_UECFG1_EPTYPE_Pos      11
#define USBC_UECFG1_EPTYPE_Msk      (0x3u << USBC_UECFG1_EPTYPE_Pos) /**< \brief (USBC_UECFG1) Endpoint Type */
#define USBC_UECFG1_EPTYPE(value)   ((USBC_UECFG1_EPTYPE_Msk & ((value) << USBC_UECFG1_EPTYPE_Pos)))
#define   USBC_UECFG1_EPTYPE_CONTROL (0x0u << 11) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPTYPE_ISOCHRONOUS (0x1u << 11) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPTYPE_BULK   (0x2u << 11) /**< \brief (USBC_UECFG1)  */
#define   USBC_UECFG1_EPTYPE_INTERRUPT (0x3u << 11) /**< \brief (USBC_UECFG1)  */
#define USBC_UECFG1_REPNB_Pos       16
#define USBC_UECFG1_REPNB_Msk       (0xFu << USBC_UECFG1_REPNB_Pos) /**< \brief (USBC_UECFG1) Redirected Endpoint Number */
#define USBC_UECFG1_REPNB(value)    ((USBC_UECFG1_REPNB_Msk & ((value) << USBC_UECFG1_REPNB_Pos)))
/* -------- USBC_UECFG2 : (USBC Offset: 0x108) Endpoint Configuration Register -------- */
#define USBC_UECFG2_EPBK            (0x1u <<  2) /**< \brief (USBC_UECFG2) Endpoint Bank */
#define   USBC_UECFG2_EPBK_SINGLE   (0x0u <<  2) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPBK_DOUBLE   (0x1u <<  2) /**< \brief (USBC_UECFG2)  */
#define USBC_UECFG2_EPSIZE_Pos      4
#define USBC_UECFG2_EPSIZE_Msk      (0x7u << USBC_UECFG2_EPSIZE_Pos) /**< \brief (USBC_UECFG2) Endpoint Size */
#define USBC_UECFG2_EPSIZE(value)   ((USBC_UECFG2_EPSIZE_Msk & ((value) << USBC_UECFG2_EPSIZE_Pos)))
#define   USBC_UECFG2_EPSIZE_8      (0x0u <<  4) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPSIZE_16     (0x1u <<  4) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPSIZE_32     (0x2u <<  4) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPSIZE_64     (0x3u <<  4) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPSIZE_128    (0x4u <<  4) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPSIZE_256    (0x5u <<  4) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPSIZE_512    (0x6u <<  4) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPSIZE_1024   (0x7u <<  4) /**< \brief (USBC_UECFG2)  */
#define USBC_UECFG2_EPDIR           (0x1u <<  8) /**< \brief (USBC_UECFG2) Endpoint Direction */
#define   USBC_UECFG2_EPDIR_OUT     (0x0u <<  8) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPDIR_IN      (0x1u <<  8) /**< \brief (USBC_UECFG2)  */
#define USBC_UECFG2_EPTYPE_Pos      11
#define USBC_UECFG2_EPTYPE_Msk      (0x3u << USBC_UECFG2_EPTYPE_Pos) /**< \brief (USBC_UECFG2) Endpoint Type */
#define USBC_UECFG2_EPTYPE(value)   ((USBC_UECFG2_EPTYPE_Msk & ((value) << USBC_UECFG2_EPTYPE_Pos)))
#define   USBC_UECFG2_EPTYPE_CONTROL (0x0u << 11) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPTYPE_ISOCHRONOUS (0x1u << 11) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPTYPE_BULK   (0x2u << 11) /**< \brief (USBC_UECFG2)  */
#define   USBC_UECFG2_EPTYPE_INTERRUPT (0x3u << 11) /**< \brief (USBC_UECFG2)  */
#define USBC_UECFG2_REPNB_Pos       16
#define USBC_UECFG2_REPNB_Msk       (0xFu << USBC_UECFG2_REPNB_Pos) /**< \brief (USBC_UECFG2) Redirected Endpoint Number */
#define USBC_UECFG2_REPNB(value)    ((USBC_UECFG2_REPNB_Msk & ((value) << USBC_UECFG2_REPNB_Pos)))
/* -------- USBC_UECFG3 : (USBC Offset: 0x10C) Endpoint Configuration Register -------- */
#define USBC_UECFG3_EPBK            (0x1u <<  2) /**< \brief (USBC_UECFG3) Endpoint Bank */
#define   USBC_UECFG3_EPBK_SINGLE   (0x0u <<  2) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPBK_DOUBLE   (0x1u <<  2) /**< \brief (USBC_UECFG3)  */
#define USBC_UECFG3_EPSIZE_Pos      4
#define USBC_UECFG3_EPSIZE_Msk      (0x7u << USBC_UECFG3_EPSIZE_Pos) /**< \brief (USBC_UECFG3) Endpoint Size */
#define USBC_UECFG3_EPSIZE(value)   ((USBC_UECFG3_EPSIZE_Msk & ((value) << USBC_UECFG3_EPSIZE_Pos)))
#define   USBC_UECFG3_EPSIZE_8      (0x0u <<  4) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPSIZE_16     (0x1u <<  4) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPSIZE_32     (0x2u <<  4) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPSIZE_64     (0x3u <<  4) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPSIZE_128    (0x4u <<  4) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPSIZE_256    (0x5u <<  4) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPSIZE_512    (0x6u <<  4) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPSIZE_1024   (0x7u <<  4) /**< \brief (USBC_UECFG3)  */
#define USBC_UECFG3_EPDIR           (0x1u <<  8) /**< \brief (USBC_UECFG3) Endpoint Direction */
#define   USBC_UECFG3_EPDIR_OUT     (0x0u <<  8) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPDIR_IN      (0x1u <<  8) /**< \brief (USBC_UECFG3)  */
#define USBC_UECFG3_EPTYPE_Pos      11
#define USBC_UECFG3_EPTYPE_Msk      (0x3u << USBC_UECFG3_EPTYPE_Pos) /**< \brief (USBC_UECFG3) Endpoint Type */
#define USBC_UECFG3_EPTYPE(value)   ((USBC_UECFG3_EPTYPE_Msk & ((value) << USBC_UECFG3_EPTYPE_Pos)))
#define   USBC_UECFG3_EPTYPE_CONTROL (0x0u << 11) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPTYPE_ISOCHRONOUS (0x1u << 11) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPTYPE_BULK   (0x2u << 11) /**< \brief (USBC_UECFG3)  */
#define   USBC_UECFG3_EPTYPE_INTERRUPT (0x3u << 11) /**< \brief (USBC_UECFG3)  */
#define USBC_UECFG3_REPNB_Pos       16
#define USBC_UECFG3_REPNB_Msk       (0xFu << USBC_UECFG3_REPNB_Pos) /**< \brief (USBC_UECFG3) Redirected Endpoint Number */
#define USBC_UECFG3_REPNB(value)    ((USBC_UECFG3_REPNB_Msk & ((value) << USBC_UECFG3_REPNB_Pos)))
/* -------- USBC_UECFG4 : (USBC Offset: 0x110) Endpoint Configuration Register -------- */
#define USBC_UECFG4_EPBK            (0x1u <<  2) /**< \brief (USBC_UECFG4) Endpoint Bank */
#define   USBC_UECFG4_EPBK_SINGLE   (0x0u <<  2) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPBK_DOUBLE   (0x1u <<  2) /**< \brief (USBC_UECFG4)  */
#define USBC_UECFG4_EPSIZE_Pos      4
#define USBC_UECFG4_EPSIZE_Msk      (0x7u << USBC_UECFG4_EPSIZE_Pos) /**< \brief (USBC_UECFG4) Endpoint Size */
#define USBC_UECFG4_EPSIZE(value)   ((USBC_UECFG4_EPSIZE_Msk & ((value) << USBC_UECFG4_EPSIZE_Pos)))
#define   USBC_UECFG4_EPSIZE_8      (0x0u <<  4) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPSIZE_16     (0x1u <<  4) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPSIZE_32     (0x2u <<  4) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPSIZE_64     (0x3u <<  4) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPSIZE_128    (0x4u <<  4) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPSIZE_256    (0x5u <<  4) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPSIZE_512    (0x6u <<  4) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPSIZE_1024   (0x7u <<  4) /**< \brief (USBC_UECFG4)  */
#define USBC_UECFG4_EPDIR           (0x1u <<  8) /**< \brief (USBC_UECFG4) Endpoint Direction */
#define   USBC_UECFG4_EPDIR_OUT     (0x0u <<  8) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPDIR_IN      (0x1u <<  8) /**< \brief (USBC_UECFG4)  */
#define USBC_UECFG4_EPTYPE_Pos      11
#define USBC_UECFG4_EPTYPE_Msk      (0x3u << USBC_UECFG4_EPTYPE_Pos) /**< \brief (USBC_UECFG4) Endpoint Type */
#define USBC_UECFG4_EPTYPE(value)   ((USBC_UECFG4_EPTYPE_Msk & ((value) << USBC_UECFG4_EPTYPE_Pos)))
#define   USBC_UECFG4_EPTYPE_CONTROL (0x0u << 11) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPTYPE_ISOCHRONOUS (0x1u << 11) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPTYPE_BULK   (0x2u << 11) /**< \brief (USBC_UECFG4)  */
#define   USBC_UECFG4_EPTYPE_INTERRUPT (0x3u << 11) /**< \brief (USBC_UECFG4)  */
#define USBC_UECFG4_REPNB_Pos       16
#define USBC_UECFG4_REPNB_Msk       (0xFu << USBC_UECFG4_REPNB_Pos) /**< \brief (USBC_UECFG4) Redirected Endpoint Number */
#define USBC_UECFG4_REPNB(value)    ((USBC_UECFG4_REPNB_Msk & ((value) << USBC_UECFG4_REPNB_Pos)))
/* -------- USBC_UECFG5 : (USBC Offset: 0x114) Endpoint Configuration Register -------- */
#define USBC_UECFG5_EPBK            (0x1u <<  2) /**< \brief (USBC_UECFG5) Endpoint Bank */
#define   USBC_UECFG5_EPBK_SINGLE   (0x0u <<  2) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPBK_DOUBLE   (0x1u <<  2) /**< \brief (USBC_UECFG5)  */
#define USBC_UECFG5_EPSIZE_Pos      4
#define USBC_UECFG5_EPSIZE_Msk      (0x7u << USBC_UECFG5_EPSIZE_Pos) /**< \brief (USBC_UECFG5) Endpoint Size */
#define USBC_UECFG5_EPSIZE(value)   ((USBC_UECFG5_EPSIZE_Msk & ((value) << USBC_UECFG5_EPSIZE_Pos)))
#define   USBC_UECFG5_EPSIZE_8      (0x0u <<  4) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPSIZE_16     (0x1u <<  4) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPSIZE_32     (0x2u <<  4) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPSIZE_64     (0x3u <<  4) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPSIZE_128    (0x4u <<  4) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPSIZE_256    (0x5u <<  4) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPSIZE_512    (0x6u <<  4) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPSIZE_1024   (0x7u <<  4) /**< \brief (USBC_UECFG5)  */
#define USBC_UECFG5_EPDIR           (0x1u <<  8) /**< \brief (USBC_UECFG5) Endpoint Direction */
#define   USBC_UECFG5_EPDIR_OUT     (0x0u <<  8) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPDIR_IN      (0x1u <<  8) /**< \brief (USBC_UECFG5)  */
#define USBC_UECFG5_EPTYPE_Pos      11
#define USBC_UECFG5_EPTYPE_Msk      (0x3u << USBC_UECFG5_EPTYPE_Pos) /**< \brief (USBC_UECFG5) Endpoint Type */
#define USBC_UECFG5_EPTYPE(value)   ((USBC_UECFG5_EPTYPE_Msk & ((value) << USBC_UECFG5_EPTYPE_Pos)))
#define   USBC_UECFG5_EPTYPE_CONTROL (0x0u << 11) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPTYPE_ISOCHRONOUS (0x1u << 11) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPTYPE_BULK   (0x2u << 11) /**< \brief (USBC_UECFG5)  */
#define   USBC_UECFG5_EPTYPE_INTERRUPT (0x3u << 11) /**< \brief (USBC_UECFG5)  */
#define USBC_UECFG5_REPNB_Pos       16
#define USBC_UECFG5_REPNB_Msk       (0xFu << USBC_UECFG5_REPNB_Pos) /**< \brief (USBC_UECFG5) Redirected Endpoint Number */
#define USBC_UECFG5_REPNB(value)    ((USBC_UECFG5_REPNB_Msk & ((value) << USBC_UECFG5_REPNB_Pos)))
/* -------- USBC_UECFG6 : (USBC Offset: 0x118) Endpoint Configuration Register -------- */
#define USBC_UECFG6_EPBK            (0x1u <<  2) /**< \brief (USBC_UECFG6) Endpoint Bank */
#define   USBC_UECFG6_EPBK_SINGLE   (0x0u <<  2) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPBK_DOUBLE   (0x1u <<  2) /**< \brief (USBC_UECFG6)  */
#define USBC_UECFG6_EPSIZE_Pos      4
#define USBC_UECFG6_EPSIZE_Msk      (0x7u << USBC_UECFG6_EPSIZE_Pos) /**< \brief (USBC_UECFG6) Endpoint Size */
#define USBC_UECFG6_EPSIZE(value)   ((USBC_UECFG6_EPSIZE_Msk & ((value) << USBC_UECFG6_EPSIZE_Pos)))
#define   USBC_UECFG6_EPSIZE_8      (0x0u <<  4) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPSIZE_16     (0x1u <<  4) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPSIZE_32     (0x2u <<  4) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPSIZE_64     (0x3u <<  4) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPSIZE_128    (0x4u <<  4) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPSIZE_256    (0x5u <<  4) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPSIZE_512    (0x6u <<  4) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPSIZE_1024   (0x7u <<  4) /**< \brief (USBC_UECFG6)  */
#define USBC_UECFG6_EPDIR           (0x1u <<  8) /**< \brief (USBC_UECFG6) Endpoint Direction */
#define   USBC_UECFG6_EPDIR_OUT     (0x0u <<  8) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPDIR_IN      (0x1u <<  8) /**< \brief (USBC_UECFG6)  */
#define USBC_UECFG6_EPTYPE_Pos      11
#define USBC_UECFG6_EPTYPE_Msk      (0x3u << USBC_UECFG6_EPTYPE_Pos) /**< \brief (USBC_UECFG6) Endpoint Type */
#define USBC_UECFG6_EPTYPE(value)   ((USBC_UECFG6_EPTYPE_Msk & ((value) << USBC_UECFG6_EPTYPE_Pos)))
#define   USBC_UECFG6_EPTYPE_CONTROL (0x0u << 11) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPTYPE_ISOCHRONOUS (0x1u << 11) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPTYPE_BULK   (0x2u << 11) /**< \brief (USBC_UECFG6)  */
#define   USBC_UECFG6_EPTYPE_INTERRUPT (0x3u << 11) /**< \brief (USBC_UECFG6)  */
#define USBC_UECFG6_REPNB_Pos       16
#define USBC_UECFG6_REPNB_Msk       (0xFu << USBC_UECFG6_REPNB_Pos) /**< \brief (USBC_UECFG6) Redirected Endpoint Number */
#define USBC_UECFG6_REPNB(value)    ((USBC_UECFG6_REPNB_Msk & ((value) << USBC_UECFG6_REPNB_Pos)))
/* -------- USBC_UECFG7 : (USBC Offset: 0x11C) Endpoint Configuration Register -------- */
#define USBC_UECFG7_EPBK            (0x1u <<  2) /**< \brief (USBC_UECFG7) Endpoint Bank */
#define   USBC_UECFG7_EPBK_SINGLE   (0x0u <<  2) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPBK_DOUBLE   (0x1u <<  2) /**< \brief (USBC_UECFG7)  */
#define USBC_UECFG7_EPSIZE_Pos      4
#define USBC_UECFG7_EPSIZE_Msk      (0x7u << USBC_UECFG7_EPSIZE_Pos) /**< \brief (USBC_UECFG7) Endpoint Size */
#define USBC_UECFG7_EPSIZE(value)   ((USBC_UECFG7_EPSIZE_Msk & ((value) << USBC_UECFG7_EPSIZE_Pos)))
#define   USBC_UECFG7_EPSIZE_8      (0x0u <<  4) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPSIZE_16     (0x1u <<  4) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPSIZE_32     (0x2u <<  4) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPSIZE_64     (0x3u <<  4) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPSIZE_128    (0x4u <<  4) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPSIZE_256    (0x5u <<  4) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPSIZE_512    (0x6u <<  4) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPSIZE_1024   (0x7u <<  4) /**< \brief (USBC_UECFG7)  */
#define USBC_UECFG7_EPDIR           (0x1u <<  8) /**< \brief (USBC_UECFG7) Endpoint Direction */
#define   USBC_UECFG7_EPDIR_OUT     (0x0u <<  8) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPDIR_IN      (0x1u <<  8) /**< \brief (USBC_UECFG7)  */
#define USBC_UECFG7_EPTYPE_Pos      11
#define USBC_UECFG7_EPTYPE_Msk      (0x3u << USBC_UECFG7_EPTYPE_Pos) /**< \brief (USBC_UECFG7) Endpoint Type */
#define USBC_UECFG7_EPTYPE(value)   ((USBC_UECFG7_EPTYPE_Msk & ((value) << USBC_UECFG7_EPTYPE_Pos)))
#define   USBC_UECFG7_EPTYPE_CONTROL (0x0u << 11) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPTYPE_ISOCHRONOUS (0x1u << 11) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPTYPE_BULK   (0x2u << 11) /**< \brief (USBC_UECFG7)  */
#define   USBC_UECFG7_EPTYPE_INTERRUPT (0x3u << 11) /**< \brief (USBC_UECFG7)  */
#define USBC_UECFG7_REPNB_Pos       16
#define USBC_UECFG7_REPNB_Msk       (0xFu << USBC_UECFG7_REPNB_Pos) /**< \brief (USBC_UECFG7) Redirected Endpoint Number */
#define USBC_UECFG7_REPNB(value)    ((USBC_UECFG7_REPNB_Msk & ((value) << USBC_UECFG7_REPNB_Pos)))
/* -------- USBC_UESTA0 : (USBC Offset: 0x130) Endpoint Status Register -------- */
#define USBC_UESTA0_TXINI           (0x1u <<  0) /**< \brief (USBC_UESTA0) Transmitted IN Data Interrupt */
#define USBC_UESTA0_RXOUTI          (0x1u <<  1) /**< \brief (USBC_UESTA0) Received OUT Data Interrupt */
#define USBC_UESTA0_RXSTPI          (0x1u <<  2) /**< \brief (USBC_UESTA0) Received SETUP Interrupt */
#define USBC_UESTA0_NAKOUTI         (0x1u <<  3) /**< \brief (USBC_UESTA0) NAKed OUT Interrupt */
#define USBC_UESTA0_NAKINI          (0x1u <<  4) /**< \brief (USBC_UESTA0) NAKed IN Interrupt */
#define USBC_UESTA0_STALLEDI        (0x1u <<  6) /**< \brief (USBC_UESTA0) STALLed Interrupt */
#define USBC_UESTA0_DTSEQ_Pos       8
#define USBC_UESTA0_DTSEQ_Msk       (0x3u << USBC_UESTA0_DTSEQ_Pos) /**< \brief (USBC_UESTA0) Data Toggle Sequence */
#define USBC_UESTA0_DTSEQ(value)    ((USBC_UESTA0_DTSEQ_Msk & ((value) << USBC_UESTA0_DTSEQ_Pos)))
#define USBC_UESTA0_RAMACERI        (0x1u << 11) /**< \brief (USBC_UESTA0) Ram Access Error Interrupt */
#define USBC_UESTA0_NBUSYBK_Pos     12
#define USBC_UESTA0_NBUSYBK_Msk     (0x3u << USBC_UESTA0_NBUSYBK_Pos) /**< \brief (USBC_UESTA0) Number Of Busy Banks */
#define USBC_UESTA0_NBUSYBK(value)  ((USBC_UESTA0_NBUSYBK_Msk & ((value) << USBC_UESTA0_NBUSYBK_Pos)))
#define USBC_UESTA0_CURRBK_Pos      14
#define USBC_UESTA0_CURRBK_Msk      (0x3u << USBC_UESTA0_CURRBK_Pos) /**< \brief (USBC_UESTA0) Current Bank */
#define USBC_UESTA0_CURRBK(value)   ((USBC_UESTA0_CURRBK_Msk & ((value) << USBC_UESTA0_CURRBK_Pos)))
#define USBC_UESTA0_CTRLDIR         (0x1u << 17) /**< \brief (USBC_UESTA0) Control Direction */
#define   USBC_UESTA0_CTRLDIR_OUT   (0x0u << 17) /**< \brief (USBC_UESTA0)  */
#define   USBC_UESTA0_CTRLDIR_IN    (0x1u << 17) /**< \brief (USBC_UESTA0)  */
/* -------- USBC_UESTA1 : (USBC Offset: 0x134) Endpoint Status Register -------- */
#define USBC_UESTA1_TXINI           (0x1u <<  0) /**< \brief (USBC_UESTA1) Transmitted IN Data Interrupt */
#define USBC_UESTA1_RXOUTI          (0x1u <<  1) /**< \brief (USBC_UESTA1) Received OUT Data Interrupt */
#define USBC_UESTA1_RXSTPI          (0x1u <<  2) /**< \brief (USBC_UESTA1) Received SETUP Interrupt */
#define USBC_UESTA1_NAKOUTI         (0x1u <<  3) /**< \brief (USBC_UESTA1) NAKed OUT Interrupt */
#define USBC_UESTA1_NAKINI          (0x1u <<  4) /**< \brief (USBC_UESTA1) NAKed IN Interrupt */
#define USBC_UESTA1_STALLEDI        (0x1u <<  6) /**< \brief (USBC_UESTA1) STALLed Interrupt */
#define USBC_UESTA1_DTSEQ_Pos       8
#define USBC_UESTA1_DTSEQ_Msk       (0x3u << USBC_UESTA1_DTSEQ_Pos) /**< \brief (USBC_UESTA1) Data Toggle Sequence */
#define USBC_UESTA1_DTSEQ(value)    ((USBC_UESTA1_DTSEQ_Msk & ((value) << USBC_UESTA1_DTSEQ_Pos)))
#define USBC_UESTA1_RAMACERI        (0x1u << 11) /**< \brief (USBC_UESTA1) Ram Access Error Interrupt */
#define USBC_UESTA1_NBUSYBK_Pos     12
#define USBC_UESTA1_NBUSYBK_Msk     (0x3u << USBC_UESTA1_NBUSYBK_Pos) /**< \brief (USBC_UESTA1) Number Of Busy Banks */
#define USBC_UESTA1_NBUSYBK(value)  ((USBC_UESTA1_NBUSYBK_Msk & ((value) << USBC_UESTA1_NBUSYBK_Pos)))
#define USBC_UESTA1_CURRBK_Pos      14
#define USBC_UESTA1_CURRBK_Msk      (0x3u << USBC_UESTA1_CURRBK_Pos) /**< \brief (USBC_UESTA1) Current Bank */
#define USBC_UESTA1_CURRBK(value)   ((USBC_UESTA1_CURRBK_Msk & ((value) << USBC_UESTA1_CURRBK_Pos)))
#define USBC_UESTA1_CTRLDIR         (0x1u << 17) /**< \brief (USBC_UESTA1) Control Direction */
#define   USBC_UESTA1_CTRLDIR_OUT   (0x0u << 17) /**< \brief (USBC_UESTA1)  */
#define   USBC_UESTA1_CTRLDIR_IN    (0x1u << 17) /**< \brief (USBC_UESTA1)  */
/* -------- USBC_UESTA2 : (USBC Offset: 0x138) Endpoint Status Register -------- */
#define USBC_UESTA2_TXINI           (0x1u <<  0) /**< \brief (USBC_UESTA2) Transmitted IN Data Interrupt */
#define USBC_UESTA2_RXOUTI          (0x1u <<  1) /**< \brief (USBC_UESTA2) Received OUT Data Interrupt */
#define USBC_UESTA2_RXSTPI          (0x1u <<  2) /**< \brief (USBC_UESTA2) Received SETUP Interrupt */
#define USBC_UESTA2_NAKOUTI         (0x1u <<  3) /**< \brief (USBC_UESTA2) NAKed OUT Interrupt */
#define USBC_UESTA2_NAKINI          (0x1u <<  4) /**< \brief (USBC_UESTA2) NAKed IN Interrupt */
#define USBC_UESTA2_STALLEDI        (0x1u <<  6) /**< \brief (USBC_UESTA2) STALLed Interrupt */
#define USBC_UESTA2_DTSEQ_Pos       8
#define USBC_UESTA2_DTSEQ_Msk       (0x3u << USBC_UESTA2_DTSEQ_Pos) /**< \brief (USBC_UESTA2) Data Toggle Sequence */
#define USBC_UESTA2_DTSEQ(value)    ((USBC_UESTA2_DTSEQ_Msk & ((value) << USBC_UESTA2_DTSEQ_Pos)))
#define USBC_UESTA2_RAMACERI        (0x1u << 11) /**< \brief (USBC_UESTA2) Ram Access Error Interrupt */
#define USBC_UESTA2_NBUSYBK_Pos     12
#define USBC_UESTA2_NBUSYBK_Msk     (0x3u << USBC_UESTA2_NBUSYBK_Pos) /**< \brief (USBC_UESTA2) Number Of Busy Banks */
#define USBC_UESTA2_NBUSYBK(value)  ((USBC_UESTA2_NBUSYBK_Msk & ((value) << USBC_UESTA2_NBUSYBK_Pos)))
#define USBC_UESTA2_CURRBK_Pos      14
#define USBC_UESTA2_CURRBK_Msk      (0x3u << USBC_UESTA2_CURRBK_Pos) /**< \brief (USBC_UESTA2) Current Bank */
#define USBC_UESTA2_CURRBK(value)   ((USBC_UESTA2_CURRBK_Msk & ((value) << USBC_UESTA2_CURRBK_Pos)))
#define USBC_UESTA2_CTRLDIR         (0x1u << 17) /**< \brief (USBC_UESTA2) Control Direction */
#define   USBC_UESTA2_CTRLDIR_OUT   (0x0u << 17) /**< \brief (USBC_UESTA2)  */
#define   USBC_UESTA2_CTRLDIR_IN    (0x1u << 17) /**< \brief (USBC_UESTA2)  */
/* -------- USBC_UESTA3 : (USBC Offset: 0x13C) Endpoint Status Register -------- */
#define USBC_UESTA3_TXINI           (0x1u <<  0) /**< \brief (USBC_UESTA3) Transmitted IN Data Interrupt */
#define USBC_UESTA3_RXOUTI          (0x1u <<  1) /**< \brief (USBC_UESTA3) Received OUT Data Interrupt */
#define USBC_UESTA3_RXSTPI          (0x1u <<  2) /**< \brief (USBC_UESTA3) Received SETUP Interrupt */
#define USBC_UESTA3_NAKOUTI         (0x1u <<  3) /**< \brief (USBC_UESTA3) NAKed OUT Interrupt */
#define USBC_UESTA3_NAKINI          (0x1u <<  4) /**< \brief (USBC_UESTA3) NAKed IN Interrupt */
#define USBC_UESTA3_STALLEDI        (0x1u <<  6) /**< \brief (USBC_UESTA3) STALLed Interrupt */
#define USBC_UESTA3_DTSEQ_Pos       8
#define USBC_UESTA3_DTSEQ_Msk       (0x3u << USBC_UESTA3_DTSEQ_Pos) /**< \brief (USBC_UESTA3) Data Toggle Sequence */
#define USBC_UESTA3_DTSEQ(value)    ((USBC_UESTA3_DTSEQ_Msk & ((value) << USBC_UESTA3_DTSEQ_Pos)))
#define USBC_UESTA3_RAMACERI        (0x1u << 11) /**< \brief (USBC_UESTA3) Ram Access Error Interrupt */
#define USBC_UESTA3_NBUSYBK_Pos     12
#define USBC_UESTA3_NBUSYBK_Msk     (0x3u << USBC_UESTA3_NBUSYBK_Pos) /**< \brief (USBC_UESTA3) Number Of Busy Banks */
#define USBC_UESTA3_NBUSYBK(value)  ((USBC_UESTA3_NBUSYBK_Msk & ((value) << USBC_UESTA3_NBUSYBK_Pos)))
#define USBC_UESTA3_CURRBK_Pos      14
#define USBC_UESTA3_CURRBK_Msk      (0x3u << USBC_UESTA3_CURRBK_Pos) /**< \brief (USBC_UESTA3) Current Bank */
#define USBC_UESTA3_CURRBK(value)   ((USBC_UESTA3_CURRBK_Msk & ((value) << USBC_UESTA3_CURRBK_Pos)))
#define USBC_UESTA3_CTRLDIR         (0x1u << 17) /**< \brief (USBC_UESTA3) Control Direction */
#define   USBC_UESTA3_CTRLDIR_OUT   (0x0u << 17) /**< \brief (USBC_UESTA3)  */
#define   USBC_UESTA3_CTRLDIR_IN    (0x1u << 17) /**< \brief (USBC_UESTA3)  */
/* -------- USBC_UESTA4 : (USBC Offset: 0x140) Endpoint Status Register -------- */
#define USBC_UESTA4_TXINI           (0x1u <<  0) /**< \brief (USBC_UESTA4) Transmitted IN Data Interrupt */
#define USBC_UESTA4_RXOUTI          (0x1u <<  1) /**< \brief (USBC_UESTA4) Received OUT Data Interrupt */
#define USBC_UESTA4_RXSTPI          (0x1u <<  2) /**< \brief (USBC_UESTA4) Received SETUP Interrupt */
#define USBC_UESTA4_NAKOUTI         (0x1u <<  3) /**< \brief (USBC_UESTA4) NAKed OUT Interrupt */
#define USBC_UESTA4_NAKINI          (0x1u <<  4) /**< \brief (USBC_UESTA4) NAKed IN Interrupt */
#define USBC_UESTA4_STALLEDI        (0x1u <<  6) /**< \brief (USBC_UESTA4) STALLed Interrupt */
#define USBC_UESTA4_DTSEQ_Pos       8
#define USBC_UESTA4_DTSEQ_Msk       (0x3u << USBC_UESTA4_DTSEQ_Pos) /**< \brief (USBC_UESTA4) Data Toggle Sequence */
#define USBC_UESTA4_DTSEQ(value)    ((USBC_UESTA4_DTSEQ_Msk & ((value) << USBC_UESTA4_DTSEQ_Pos)))
#define USBC_UESTA4_RAMACERI        (0x1u << 11) /**< \brief (USBC_UESTA4) Ram Access Error Interrupt */
#define USBC_UESTA4_NBUSYBK_Pos     12
#define USBC_UESTA4_NBUSYBK_Msk     (0x3u << USBC_UESTA4_NBUSYBK_Pos) /**< \brief (USBC_UESTA4) Number Of Busy Banks */
#define USBC_UESTA4_NBUSYBK(value)  ((USBC_UESTA4_NBUSYBK_Msk & ((value) << USBC_UESTA4_NBUSYBK_Pos)))
#define USBC_UESTA4_CURRBK_Pos      14
#define USBC_UESTA4_CURRBK_Msk      (0x3u << USBC_UESTA4_CURRBK_Pos) /**< \brief (USBC_UESTA4) Current Bank */
#define USBC_UESTA4_CURRBK(value)   ((USBC_UESTA4_CURRBK_Msk & ((value) << USBC_UESTA4_CURRBK_Pos)))
#define USBC_UESTA4_CTRLDIR         (0x1u << 17) /**< \brief (USBC_UESTA4) Control Direction */
#define   USBC_UESTA4_CTRLDIR_OUT   (0x0u << 17) /**< \brief (USBC_UESTA4)  */
#define   USBC_UESTA4_CTRLDIR_IN    (0x1u << 17) /**< \brief (USBC_UESTA4)  */
/* -------- USBC_UESTA5 : (USBC Offset: 0x144) Endpoint Status Register -------- */
#define USBC_UESTA5_TXINI           (0x1u <<  0) /**< \brief (USBC_UESTA5) Transmitted IN Data Interrupt */
#define USBC_UESTA5_RXOUTI          (0x1u <<  1) /**< \brief (USBC_UESTA5) Received OUT Data Interrupt */
#define USBC_UESTA5_RXSTPI          (0x1u <<  2) /**< \brief (USBC_UESTA5) Received SETUP Interrupt */
#define USBC_UESTA5_NAKOUTI         (0x1u <<  3) /**< \brief (USBC_UESTA5) NAKed OUT Interrupt */
#define USBC_UESTA5_NAKINI          (0x1u <<  4) /**< \brief (USBC_UESTA5) NAKed IN Interrupt */
#define USBC_UESTA5_STALLEDI        (0x1u <<  6) /**< \brief (USBC_UESTA5) STALLed Interrupt */
#define USBC_UESTA5_DTSEQ_Pos       8
#define USBC_UESTA5_DTSEQ_Msk       (0x3u << USBC_UESTA5_DTSEQ_Pos) /**< \brief (USBC_UESTA5) Data Toggle Sequence */
#define USBC_UESTA5_DTSEQ(value)    ((USBC_UESTA5_DTSEQ_Msk & ((value) << USBC_UESTA5_DTSEQ_Pos)))
#define USBC_UESTA5_RAMACERI        (0x1u << 11) /**< \brief (USBC_UESTA5) Ram Access Error Interrupt */
#define USBC_UESTA5_NBUSYBK_Pos     12
#define USBC_UESTA5_NBUSYBK_Msk     (0x3u << USBC_UESTA5_NBUSYBK_Pos) /**< \brief (USBC_UESTA5) Number Of Busy Banks */
#define USBC_UESTA5_NBUSYBK(value)  ((USBC_UESTA5_NBUSYBK_Msk & ((value) << USBC_UESTA5_NBUSYBK_Pos)))
#define USBC_UESTA5_CURRBK_Pos      14
#define USBC_UESTA5_CURRBK_Msk      (0x3u << USBC_UESTA5_CURRBK_Pos) /**< \brief (USBC_UESTA5) Current Bank */
#define USBC_UESTA5_CURRBK(value)   ((USBC_UESTA5_CURRBK_Msk & ((value) << USBC_UESTA5_CURRBK_Pos)))
#define USBC_UESTA5_CTRLDIR         (0x1u << 17) /**< \brief (USBC_UESTA5) Control Direction */
#define   USBC_UESTA5_CTRLDIR_OUT   (0x0u << 17) /**< \brief (USBC_UESTA5)  */
#define   USBC_UESTA5_CTRLDIR_IN    (0x1u << 17) /**< \brief (USBC_UESTA5)  */
/* -------- USBC_UESTA6 : (USBC Offset: 0x148) Endpoint Status Register -------- */
#define USBC_UESTA6_TXINI           (0x1u <<  0) /**< \brief (USBC_UESTA6) Transmitted IN Data Interrupt */
#define USBC_UESTA6_RXOUTI          (0x1u <<  1) /**< \brief (USBC_UESTA6) Received OUT Data Interrupt */
#define USBC_UESTA6_RXSTPI          (0x1u <<  2) /**< \brief (USBC_UESTA6) Received SETUP Interrupt */
#define USBC_UESTA6_NAKOUTI         (0x1u <<  3) /**< \brief (USBC_UESTA6) NAKed OUT Interrupt */
#define USBC_UESTA6_NAKINI          (0x1u <<  4) /**< \brief (USBC_UESTA6) NAKed IN Interrupt */
#define USBC_UESTA6_STALLEDI        (0x1u <<  6) /**< \brief (USBC_UESTA6) STALLed Interrupt */
#define USBC_UESTA6_DTSEQ_Pos       8
#define USBC_UESTA6_DTSEQ_Msk       (0x3u << USBC_UESTA6_DTSEQ_Pos) /**< \brief (USBC_UESTA6) Data Toggle Sequence */
#define USBC_UESTA6_DTSEQ(value)    ((USBC_UESTA6_DTSEQ_Msk & ((value) << USBC_UESTA6_DTSEQ_Pos)))
#define USBC_UESTA6_RAMACERI        (0x1u << 11) /**< \brief (USBC_UESTA6) Ram Access Error Interrupt */
#define USBC_UESTA6_NBUSYBK_Pos     12
#define USBC_UESTA6_NBUSYBK_Msk     (0x3u << USBC_UESTA6_NBUSYBK_Pos) /**< \brief (USBC_UESTA6) Number Of Busy Banks */
#define USBC_UESTA6_NBUSYBK(value)  ((USBC_UESTA6_NBUSYBK_Msk & ((value) << USBC_UESTA6_NBUSYBK_Pos)))
#define USBC_UESTA6_CURRBK_Pos      14
#define USBC_UESTA6_CURRBK_Msk      (0x3u << USBC_UESTA6_CURRBK_Pos) /**< \brief (USBC_UESTA6) Current Bank */
#define USBC_UESTA6_CURRBK(value)   ((USBC_UESTA6_CURRBK_Msk & ((value) << USBC_UESTA6_CURRBK_Pos)))
#define USBC_UESTA6_CTRLDIR         (0x1u << 17) /**< \brief (USBC_UESTA6) Control Direction */
#define   USBC_UESTA6_CTRLDIR_OUT   (0x0u << 17) /**< \brief (USBC_UESTA6)  */
#define   USBC_UESTA6_CTRLDIR_IN    (0x1u << 17) /**< \brief (USBC_UESTA6)  */
/* -------- USBC_UESTA7 : (USBC Offset: 0x14C) Endpoint Status Register -------- */
#define USBC_UESTA7_TXINI           (0x1u <<  0) /**< \brief (USBC_UESTA7) Transmitted IN Data Interrupt */
#define USBC_UESTA7_RXOUTI          (0x1u <<  1) /**< \brief (USBC_UESTA7) Received OUT Data Interrupt */
#define USBC_UESTA7_RXSTPI          (0x1u <<  2) /**< \brief (USBC_UESTA7) Received SETUP Interrupt */
#define USBC_UESTA7_NAKOUTI         (0x1u <<  3) /**< \brief (USBC_UESTA7) NAKed OUT Interrupt */
#define USBC_UESTA7_NAKINI          (0x1u <<  4) /**< \brief (USBC_UESTA7) NAKed IN Interrupt */
#define USBC_UESTA7_STALLEDI        (0x1u <<  6) /**< \brief (USBC_UESTA7) STALLed Interrupt */
#define USBC_UESTA7_DTSEQ_Pos       8
#define USBC_UESTA7_DTSEQ_Msk       (0x3u << USBC_UESTA7_DTSEQ_Pos) /**< \brief (USBC_UESTA7) Data Toggle Sequence */
#define USBC_UESTA7_DTSEQ(value)    ((USBC_UESTA7_DTSEQ_Msk & ((value) << USBC_UESTA7_DTSEQ_Pos)))
#define USBC_UESTA7_RAMACERI        (0x1u << 11) /**< \brief (USBC_UESTA7) Ram Access Error Interrupt */
#define USBC_UESTA7_NBUSYBK_Pos     12
#define USBC_UESTA7_NBUSYBK_Msk     (0x3u << USBC_UESTA7_NBUSYBK_Pos) /**< \brief (USBC_UESTA7) Number Of Busy Banks */
#define USBC_UESTA7_NBUSYBK(value)  ((USBC_UESTA7_NBUSYBK_Msk & ((value) << USBC_UESTA7_NBUSYBK_Pos)))
#define USBC_UESTA7_CURRBK_Pos      14
#define USBC_UESTA7_CURRBK_Msk      (0x3u << USBC_UESTA7_CURRBK_Pos) /**< \brief (USBC_UESTA7) Current Bank */
#define USBC_UESTA7_CURRBK(value)   ((USBC_UESTA7_CURRBK_Msk & ((value) << USBC_UESTA7_CURRBK_Pos)))
#define USBC_UESTA7_CTRLDIR         (0x1u << 17) /**< \brief (USBC_UESTA7) Control Direction */
#define   USBC_UESTA7_CTRLDIR_OUT   (0x0u << 17) /**< \brief (USBC_UESTA7)  */
#define   USBC_UESTA7_CTRLDIR_IN    (0x1u << 17) /**< \brief (USBC_UESTA7)  */
/* -------- USBC_UESTA0CLR : (USBC Offset: 0x160) Endpoint Status Clear Register -------- */
#define USBC_UESTA0CLR_TXINIC       (0x1u <<  0) /**< \brief (USBC_UESTA0CLR) TXINI Clear */
#define USBC_UESTA0CLR_RXOUTIC      (0x1u <<  1) /**< \brief (USBC_UESTA0CLR) RXOUTI Clear */
#define USBC_UESTA0CLR_RXSTPIC      (0x1u <<  2) /**< \brief (USBC_UESTA0CLR) RXSTPI Clear */
#define USBC_UESTA0CLR_NAKOUTIC     (0x1u <<  3) /**< \brief (USBC_UESTA0CLR) NAKOUTI Clear */
#define USBC_UESTA0CLR_NAKINIC      (0x1u <<  4) /**< \brief (USBC_UESTA0CLR) NAKINI Clear */
#define USBC_UESTA0CLR_STALLEDIC    (0x1u <<  6) /**< \brief (USBC_UESTA0CLR) STALLEDI Clear */
#define USBC_UESTA0CLR_RAMACERIC    (0x1u << 11) /**< \brief (USBC_UESTA0CLR) RAMACERI Clear */
/* -------- USBC_UESTA1CLR : (USBC Offset: 0x164) Endpoint Status Clear Register -------- */
#define USBC_UESTA1CLR_TXINIC       (0x1u <<  0) /**< \brief (USBC_UESTA1CLR) TXINI Clear */
#define USBC_UESTA1CLR_RXOUTIC      (0x1u <<  1) /**< \brief (USBC_UESTA1CLR) RXOUTI Clear */
#define USBC_UESTA1CLR_RXSTPIC      (0x1u <<  2) /**< \brief (USBC_UESTA1CLR) RXSTPI Clear */
#define USBC_UESTA1CLR_NAKOUTIC     (0x1u <<  3) /**< \brief (USBC_UESTA1CLR) NAKOUTI Clear */
#define USBC_UESTA1CLR_NAKINIC      (0x1u <<  4) /**< \brief (USBC_UESTA1CLR) NAKINI Clear */
#define USBC_UESTA1CLR_STALLEDIC    (0x1u <<  6) /**< \brief (USBC_UESTA1CLR) STALLEDI Clear */
#define USBC_UESTA1CLR_RAMACERIC    (0x1u << 11) /**< \brief (USBC_UESTA1CLR) RAMACERI Clear */
/* -------- USBC_UESTA2CLR : (USBC Offset: 0x168) Endpoint Status Clear Register -------- */
#define USBC_UESTA2CLR_TXINIC       (0x1u <<  0) /**< \brief (USBC_UESTA2CLR) TXINI Clear */
#define USBC_UESTA2CLR_RXOUTIC      (0x1u <<  1) /**< \brief (USBC_UESTA2CLR) RXOUTI Clear */
#define USBC_UESTA2CLR_RXSTPIC      (0x1u <<  2) /**< \brief (USBC_UESTA2CLR) RXSTPI Clear */
#define USBC_UESTA2CLR_NAKOUTIC     (0x1u <<  3) /**< \brief (USBC_UESTA2CLR) NAKOUTI Clear */
#define USBC_UESTA2CLR_NAKINIC      (0x1u <<  4) /**< \brief (USBC_UESTA2CLR) NAKINI Clear */
#define USBC_UESTA2CLR_STALLEDIC    (0x1u <<  6) /**< \brief (USBC_UESTA2CLR) STALLEDI Clear */
#define USBC_UESTA2CLR_RAMACERIC    (0x1u << 11) /**< \brief (USBC_UESTA2CLR) RAMACERI Clear */
/* -------- USBC_UESTA3CLR : (USBC Offset: 0x16C) Endpoint Status Clear Register -------- */
#define USBC_UESTA3CLR_TXINIC       (0x1u <<  0) /**< \brief (USBC_UESTA3CLR) TXINI Clear */
#define USBC_UESTA3CLR_RXOUTIC      (0x1u <<  1) /**< \brief (USBC_UESTA3CLR) RXOUTI Clear */
#define USBC_UESTA3CLR_RXSTPIC      (0x1u <<  2) /**< \brief (USBC_UESTA3CLR) RXSTPI Clear */
#define USBC_UESTA3CLR_NAKOUTIC     (0x1u <<  3) /**< \brief (USBC_UESTA3CLR) NAKOUTI Clear */
#define USBC_UESTA3CLR_NAKINIC      (0x1u <<  4) /**< \brief (USBC_UESTA3CLR) NAKINI Clear */
#define USBC_UESTA3CLR_STALLEDIC    (0x1u <<  6) /**< \brief (USBC_UESTA3CLR) STALLEDI Clear */
#define USBC_UESTA3CLR_RAMACERIC    (0x1u << 11) /**< \brief (USBC_UESTA3CLR) RAMACERI Clear */
/* -------- USBC_UESTA4CLR : (USBC Offset: 0x170) Endpoint Status Clear Register -------- */
#define USBC_UESTA4CLR_TXINIC       (0x1u <<  0) /**< \brief (USBC_UESTA4CLR) TXINI Clear */
#define USBC_UESTA4CLR_RXOUTIC      (0x1u <<  1) /**< \brief (USBC_UESTA4CLR) RXOUTI Clear */
#define USBC_UESTA4CLR_RXSTPIC      (0x1u <<  2) /**< \brief (USBC_UESTA4CLR) RXSTPI Clear */
#define USBC_UESTA4CLR_NAKOUTIC     (0x1u <<  3) /**< \brief (USBC_UESTA4CLR) NAKOUTI Clear */
#define USBC_UESTA4CLR_NAKINIC      (0x1u <<  4) /**< \brief (USBC_UESTA4CLR) NAKINI Clear */
#define USBC_UESTA4CLR_STALLEDIC    (0x1u <<  6) /**< \brief (USBC_UESTA4CLR) STALLEDI Clear */
#define USBC_UESTA4CLR_RAMACERIC    (0x1u << 11) /**< \brief (USBC_UESTA4CLR) RAMACERI Clear */
/* -------- USBC_UESTA5CLR : (USBC Offset: 0x174) Endpoint Status Clear Register -------- */
#define USBC_UESTA5CLR_TXINIC       (0x1u <<  0) /**< \brief (USBC_UESTA5CLR) TXINI Clear */
#define USBC_UESTA5CLR_RXOUTIC      (0x1u <<  1) /**< \brief (USBC_UESTA5CLR) RXOUTI Clear */
#define USBC_UESTA5CLR_RXSTPIC      (0x1u <<  2) /**< \brief (USBC_UESTA5CLR) RXSTPI Clear */
#define USBC_UESTA5CLR_NAKOUTIC     (0x1u <<  3) /**< \brief (USBC_UESTA5CLR) NAKOUTI Clear */
#define USBC_UESTA5CLR_NAKINIC      (0x1u <<  4) /**< \brief (USBC_UESTA5CLR) NAKINI Clear */
#define USBC_UESTA5CLR_STALLEDIC    (0x1u <<  6) /**< \brief (USBC_UESTA5CLR) STALLEDI Clear */
#define USBC_UESTA5CLR_RAMACERIC    (0x1u << 11) /**< \brief (USBC_UESTA5CLR) RAMACERI Clear */
/* -------- USBC_UESTA6CLR : (USBC Offset: 0x178) Endpoint Status Clear Register -------- */
#define USBC_UESTA6CLR_TXINIC       (0x1u <<  0) /**< \brief (USBC_UESTA6CLR) TXINI Clear */
#define USBC_UESTA6CLR_RXOUTIC      (0x1u <<  1) /**< \brief (USBC_UESTA6CLR) RXOUTI Clear */
#define USBC_UESTA6CLR_RXSTPIC      (0x1u <<  2) /**< \brief (USBC_UESTA6CLR) RXSTPI Clear */
#define USBC_UESTA6CLR_NAKOUTIC     (0x1u <<  3) /**< \brief (USBC_UESTA6CLR) NAKOUTI Clear */
#define USBC_UESTA6CLR_NAKINIC      (0x1u <<  4) /**< \brief (USBC_UESTA6CLR) NAKINI Clear */
#define USBC_UESTA6CLR_STALLEDIC    (0x1u <<  6) /**< \brief (USBC_UESTA6CLR) STALLEDI Clear */
#define USBC_UESTA6CLR_RAMACERIC    (0x1u << 11) /**< \brief (USBC_UESTA6CLR) RAMACERI Clear */
/* -------- USBC_UESTA7CLR : (USBC Offset: 0x17C) Endpoint Status Clear Register -------- */
#define USBC_UESTA7CLR_TXINIC       (0x1u <<  0) /**< \brief (USBC_UESTA7CLR) TXINI Clear */
#define USBC_UESTA7CLR_RXOUTIC      (0x1u <<  1) /**< \brief (USBC_UESTA7CLR) RXOUTI Clear */
#define USBC_UESTA7CLR_RXSTPIC      (0x1u <<  2) /**< \brief (USBC_UESTA7CLR) RXSTPI Clear */
#define USBC_UESTA7CLR_NAKOUTIC     (0x1u <<  3) /**< \brief (USBC_UESTA7CLR) NAKOUTI Clear */
#define USBC_UESTA7CLR_NAKINIC      (0x1u <<  4) /**< \brief (USBC_UESTA7CLR) NAKINI Clear */
#define USBC_UESTA7CLR_STALLEDIC    (0x1u <<  6) /**< \brief (USBC_UESTA7CLR) STALLEDI Clear */
#define USBC_UESTA7CLR_RAMACERIC    (0x1u << 11) /**< \brief (USBC_UESTA7CLR) RAMACERI Clear */
/* -------- USBC_UESTA0SET : (USBC Offset: 0x190) Endpoint Status Set Register -------- */
#define USBC_UESTA0SET_TXINIS       (0x1u <<  0) /**< \brief (USBC_UESTA0SET) TXINI Set */
#define USBC_UESTA0SET_RXOUTIS      (0x1u <<  1) /**< \brief (USBC_UESTA0SET) RXOUTI Set */
#define USBC_UESTA0SET_RXSTPIS      (0x1u <<  2) /**< \brief (USBC_UESTA0SET) RXSTPI Set */
#define USBC_UESTA0SET_NAKOUTIS     (0x1u <<  3) /**< \brief (USBC_UESTA0SET) NAKOUTI Set */
#define USBC_UESTA0SET_NAKINIS      (0x1u <<  4) /**< \brief (USBC_UESTA0SET) NAKINI Set */
#define USBC_UESTA0SET_STALLEDIS    (0x1u <<  6) /**< \brief (USBC_UESTA0SET) STALLEDI Set */
#define USBC_UESTA0SET_RAMACERIS    (0x1u << 11) /**< \brief (USBC_UESTA0SET) RAMACERI Set */
#define USBC_UESTA0SET_NBUSYBKS     (0x1u << 12) /**< \brief (USBC_UESTA0SET) NBUSYBK Set */
/* -------- USBC_UESTA1SET : (USBC Offset: 0x194) Endpoint Status Set Register -------- */
#define USBC_UESTA1SET_TXINIS       (0x1u <<  0) /**< \brief (USBC_UESTA1SET) TXINI Set */
#define USBC_UESTA1SET_RXOUTIS      (0x1u <<  1) /**< \brief (USBC_UESTA1SET) RXOUTI Set */
#define USBC_UESTA1SET_RXSTPIS      (0x1u <<  2) /**< \brief (USBC_UESTA1SET) RXSTPI Set */
#define USBC_UESTA1SET_NAKOUTIS     (0x1u <<  3) /**< \brief (USBC_UESTA1SET) NAKOUTI Set */
#define USBC_UESTA1SET_NAKINIS      (0x1u <<  4) /**< \brief (USBC_UESTA1SET) NAKINI Set */
#define USBC_UESTA1SET_STALLEDIS    (0x1u <<  6) /**< \brief (USBC_UESTA1SET) STALLEDI Set */
#define USBC_UESTA1SET_RAMACERIS    (0x1u << 11) /**< \brief (USBC_UESTA1SET) RAMACERI Set */
#define USBC_UESTA1SET_NBUSYBKS     (0x1u << 12) /**< \brief (USBC_UESTA1SET) NBUSYBK Set */
/* -------- USBC_UESTA2SET : (USBC Offset: 0x198) Endpoint Status Set Register -------- */
#define USBC_UESTA2SET_TXINIS       (0x1u <<  0) /**< \brief (USBC_UESTA2SET) TXINI Set */
#define USBC_UESTA2SET_RXOUTIS      (0x1u <<  1) /**< \brief (USBC_UESTA2SET) RXOUTI Set */
#define USBC_UESTA2SET_RXSTPIS      (0x1u <<  2) /**< \brief (USBC_UESTA2SET) RXSTPI Set */
#define USBC_UESTA2SET_NAKOUTIS     (0x1u <<  3) /**< \brief (USBC_UESTA2SET) NAKOUTI Set */
#define USBC_UESTA2SET_NAKINIS      (0x1u <<  4) /**< \brief (USBC_UESTA2SET) NAKINI Set */
#define USBC_UESTA2SET_STALLEDIS    (0x1u <<  6) /**< \brief (USBC_UESTA2SET) STALLEDI Set */
#define USBC_UESTA2SET_RAMACERIS    (0x1u << 11) /**< \brief (USBC_UESTA2SET) RAMACERI Set */
#define USBC_UESTA2SET_NBUSYBKS     (0x1u << 12) /**< \brief (USBC_UESTA2SET) NBUSYBK Set */
/* -------- USBC_UESTA3SET : (USBC Offset: 0x19C) Endpoint Status Set Register -------- */
#define USBC_UESTA3SET_TXINIS       (0x1u <<  0) /**< \brief (USBC_UESTA3SET) TXINI Set */
#define USBC_UESTA3SET_RXOUTIS      (0x1u <<  1) /**< \brief (USBC_UESTA3SET) RXOUTI Set */
#define USBC_UESTA3SET_RXSTPIS      (0x1u <<  2) /**< \brief (USBC_UESTA3SET) RXSTPI Set */
#define USBC_UESTA3SET_NAKOUTIS     (0x1u <<  3) /**< \brief (USBC_UESTA3SET) NAKOUTI Set */
#define USBC_UESTA3SET_NAKINIS      (0x1u <<  4) /**< \brief (USBC_UESTA3SET) NAKINI Set */
#define USBC_UESTA3SET_STALLEDIS    (0x1u <<  6) /**< \brief (USBC_UESTA3SET) STALLEDI Set */
#define USBC_UESTA3SET_RAMACERIS    (0x1u << 11) /**< \brief (USBC_UESTA3SET) RAMACERI Set */
#define USBC_UESTA3SET_NBUSYBKS     (0x1u << 12) /**< \brief (USBC_UESTA3SET) NBUSYBK Set */
/* -------- USBC_UESTA4SET : (USBC Offset: 0x1A0) Endpoint Status Set Register -------- */
#define USBC_UESTA4SET_TXINIS       (0x1u <<  0) /**< \brief (USBC_UESTA4SET) TXINI Set */
#define USBC_UESTA4SET_RXOUTIS      (0x1u <<  1) /**< \brief (USBC_UESTA4SET) RXOUTI Set */
#define USBC_UESTA4SET_RXSTPIS      (0x1u <<  2) /**< \brief (USBC_UESTA4SET) RXSTPI Set */
#define USBC_UESTA4SET_NAKOUTIS     (0x1u <<  3) /**< \brief (USBC_UESTA4SET) NAKOUTI Set */
#define USBC_UESTA4SET_NAKINIS      (0x1u <<  4) /**< \brief (USBC_UESTA4SET) NAKINI Set */
#define USBC_UESTA4SET_STALLEDIS    (0x1u <<  6) /**< \brief (USBC_UESTA4SET) STALLEDI Set */
#define USBC_UESTA4SET_RAMACERIS    (0x1u << 11) /**< \brief (USBC_UESTA4SET) RAMACERI Set */
#define USBC_UESTA4SET_NBUSYBKS     (0x1u << 12) /**< \brief (USBC_UESTA4SET) NBUSYBK Set */
/* -------- USBC_UESTA5SET : (USBC Offset: 0x1A4) Endpoint Status Set Register -------- */
#define USBC_UESTA5SET_TXINIS       (0x1u <<  0) /**< \brief (USBC_UESTA5SET) TXINI Set */
#define USBC_UESTA5SET_RXOUTIS      (0x1u <<  1) /**< \brief (USBC_UESTA5SET) RXOUTI Set */
#define USBC_UESTA5SET_RXSTPIS      (0x1u <<  2) /**< \brief (USBC_UESTA5SET) RXSTPI Set */
#define USBC_UESTA5SET_NAKOUTIS     (0x1u <<  3) /**< \brief (USBC_UESTA5SET) NAKOUTI Set */
#define USBC_UESTA5SET_NAKINIS      (0x1u <<  4) /**< \brief (USBC_UESTA5SET) NAKINI Set */
#define USBC_UESTA5SET_STALLEDIS    (0x1u <<  6) /**< \brief (USBC_UESTA5SET) STALLEDI Set */
#define USBC_UESTA5SET_RAMACERIS    (0x1u << 11) /**< \brief (USBC_UESTA5SET) RAMACERI Set */
#define USBC_UESTA5SET_NBUSYBKS     (0x1u << 12) /**< \brief (USBC_UESTA5SET) NBUSYBK Set */
/* -------- USBC_UESTA6SET : (USBC Offset: 0x1A8) Endpoint Status Set Register -------- */
#define USBC_UESTA6SET_TXINIS       (0x1u <<  0) /**< \brief (USBC_UESTA6SET) TXINI Set */
#define USBC_UESTA6SET_RXOUTIS      (0x1u <<  1) /**< \brief (USBC_UESTA6SET) RXOUTI Set */
#define USBC_UESTA6SET_RXSTPIS      (0x1u <<  2) /**< \brief (USBC_UESTA6SET) RXSTPI Set */
#define USBC_UESTA6SET_NAKOUTIS     (0x1u <<  3) /**< \brief (USBC_UESTA6SET) NAKOUTI Set */
#define USBC_UESTA6SET_NAKINIS      (0x1u <<  4) /**< \brief (USBC_UESTA6SET) NAKINI Set */
#define USBC_UESTA6SET_STALLEDIS    (0x1u <<  6) /**< \brief (USBC_UESTA6SET) STALLEDI Set */
#define USBC_UESTA6SET_RAMACERIS    (0x1u << 11) /**< \brief (USBC_UESTA6SET) RAMACERI Set */
#define USBC_UESTA6SET_NBUSYBKS     (0x1u << 12) /**< \brief (USBC_UESTA6SET) NBUSYBK Set */
/* -------- USBC_UESTA7SET : (USBC Offset: 0x1AC) Endpoint Status Set Register -------- */
#define USBC_UESTA7SET_TXINIS       (0x1u <<  0) /**< \brief (USBC_UESTA7SET) TXINI Set */
#define USBC_UESTA7SET_RXOUTIS      (0x1u <<  1) /**< \brief (USBC_UESTA7SET) RXOUTI Set */
#define USBC_UESTA7SET_RXSTPIS      (0x1u <<  2) /**< \brief (USBC_UESTA7SET) RXSTPI Set */
#define USBC_UESTA7SET_NAKOUTIS     (0x1u <<  3) /**< \brief (USBC_UESTA7SET) NAKOUTI Set */
#define USBC_UESTA7SET_NAKINIS      (0x1u <<  4) /**< \brief (USBC_UESTA7SET) NAKINI Set */
#define USBC_UESTA7SET_STALLEDIS    (0x1u <<  6) /**< \brief (USBC_UESTA7SET) STALLEDI Set */
#define USBC_UESTA7SET_RAMACERIS    (0x1u << 11) /**< \brief (USBC_UESTA7SET) RAMACERI Set */
#define USBC_UESTA7SET_NBUSYBKS     (0x1u << 12) /**< \brief (USBC_UESTA7SET) NBUSYBK Set */
/* -------- USBC_UECON0 : (USBC Offset: 0x1C0) Endpoint Control Register -------- */
#define USBC_UECON0_TXINE           (0x1u <<  0) /**< \brief (USBC_UECON0) TXIN Interrupt Enable */
#define USBC_UECON0_RXOUTE          (0x1u <<  1) /**< \brief (USBC_UECON0) RXOUT Interrupt Enable */
#define USBC_UECON0_RXSTPE          (0x1u <<  2) /**< \brief (USBC_UECON0) RXSTP Interrupt Enable */
#define USBC_UECON0_NAKOUTE         (0x1u <<  3) /**< \brief (USBC_UECON0) NAKOUT Interrupt Enable */
#define USBC_UECON0_NAKINE          (0x1u <<  4) /**< \brief (USBC_UECON0) NAKIN Interrupt Enable */
#define USBC_UECON0_STALLEDE        (0x1u <<  6) /**< \brief (USBC_UECON0) STALLED Interrupt Enable */
#define USBC_UECON0_NREPLY          (0x1u <<  8) /**< \brief (USBC_UECON0) No Reply */
#define USBC_UECON0_RAMACERE        (0x1u << 11) /**< \brief (USBC_UECON0) RAMACER Interrupt Enable */
#define USBC_UECON0_NBUSYBKE        (0x1u << 12) /**< \brief (USBC_UECON0) Number of Busy Banks Interrupt Enable */
#define USBC_UECON0_KILLBK          (0x1u << 13) /**< \brief (USBC_UECON0) Kill IN Bank */
#define USBC_UECON0_FIFOCON         (0x1u << 14) /**< \brief (USBC_UECON0) FIFO Control */
#define USBC_UECON0_NYETDIS         (0x1u << 17) /**< \brief (USBC_UECON0) NYET token disable */
#define USBC_UECON0_RSTDT           (0x1u << 18) /**< \brief (USBC_UECON0) Reset Data Toggle */
#define USBC_UECON0_STALLRQ         (0x1u << 19) /**< \brief (USBC_UECON0) STALL Request */
#define USBC_UECON0_BUSY0           (0x1u << 24) /**< \brief (USBC_UECON0) Busy Bank1 Enable */
#define USBC_UECON0_BUSY1           (0x1u << 25) /**< \brief (USBC_UECON0) Busy Bank0 Enable */
/* -------- USBC_UECON1 : (USBC Offset: 0x1C4) Endpoint Control Register -------- */
#define USBC_UECON1_TXINE           (0x1u <<  0) /**< \brief (USBC_UECON1) TXIN Interrupt Enable */
#define USBC_UECON1_RXOUTE          (0x1u <<  1) /**< \brief (USBC_UECON1) RXOUT Interrupt Enable */
#define USBC_UECON1_RXSTPE          (0x1u <<  2) /**< \brief (USBC_UECON1) RXSTP Interrupt Enable */
#define USBC_UECON1_NAKOUTE         (0x1u <<  3) /**< \brief (USBC_UECON1) NAKOUT Interrupt Enable */
#define USBC_UECON1_NAKINE          (0x1u <<  4) /**< \brief (USBC_UECON1) NAKIN Interrupt Enable */
#define USBC_UECON1_STALLEDE        (0x1u <<  6) /**< \brief (USBC_UECON1) STALLED Interrupt Enable */
#define USBC_UECON1_NREPLY          (0x1u <<  8) /**< \brief (USBC_UECON1) No Reply */
#define USBC_UECON1_RAMACERE        (0x1u << 11) /**< \brief (USBC_UECON1) RAMACER Interrupt Enable */
#define USBC_UECON1_NBUSYBKE        (0x1u << 12) /**< \brief (USBC_UECON1) Number of Busy Banks Interrupt Enable */
#define USBC_UECON1_KILLBK          (0x1u << 13) /**< \brief (USBC_UECON1) Kill IN Bank */
#define USBC_UECON1_FIFOCON         (0x1u << 14) /**< \brief (USBC_UECON1) FIFO Control */
#define USBC_UECON1_NYETDIS         (0x1u << 17) /**< \brief (USBC_UECON1) NYET Token Enable */
#define USBC_UECON1_RSTDT           (0x1u << 18) /**< \brief (USBC_UECON1) Reset Data Toggle */
#define USBC_UECON1_STALLRQ         (0x1u << 19) /**< \brief (USBC_UECON1) STALL Request */
#define USBC_UECON1_BUSY0           (0x1u << 24) /**< \brief (USBC_UECON1) Busy Bank1 Enable */
#define USBC_UECON1_BUSY1           (0x1u << 25) /**< \brief (USBC_UECON1) Busy Bank0 Enable */
/* -------- USBC_UECON2 : (USBC Offset: 0x1C8) Endpoint Control Register -------- */
#define USBC_UECON2_TXINE           (0x1u <<  0) /**< \brief (USBC_UECON2) TXIN Interrupt Enable */
#define USBC_UECON2_RXOUTE          (0x1u <<  1) /**< \brief (USBC_UECON2) RXOUT Interrupt Enable */
#define USBC_UECON2_RXSTPE          (0x1u <<  2) /**< \brief (USBC_UECON2) RXSTP Interrupt Enable */
#define USBC_UECON2_NAKOUTE         (0x1u <<  3) /**< \brief (USBC_UECON2) NAKOUT Interrupt Enable */
#define USBC_UECON2_NAKINE          (0x1u <<  4) /**< \brief (USBC_UECON2) NAKIN Interrupt Enable */
#define USBC_UECON2_STALLEDE        (0x1u <<  6) /**< \brief (USBC_UECON2) STALLED Interrupt Enable */
#define USBC_UECON2_NREPLY          (0x1u <<  8) /**< \brief (USBC_UECON2) No Reply */
#define USBC_UECON2_RAMACERE        (0x1u << 11) /**< \brief (USBC_UECON2) RAMACER Interrupt Enable */
#define USBC_UECON2_NBUSYBKE        (0x1u << 12) /**< \brief (USBC_UECON2) Number of Busy Banks Interrupt Enable */
#define USBC_UECON2_KILLBK          (0x1u << 13) /**< \brief (USBC_UECON2) Kill IN Bank */
#define USBC_UECON2_FIFOCON         (0x1u << 14) /**< \brief (USBC_UECON2) FIFO Control */
#define USBC_UECON2_NYETDIS         (0x1u << 17) /**< \brief (USBC_UECON2) NYET Token Enable */
#define USBC_UECON2_RSTDT           (0x1u << 18) /**< \brief (USBC_UECON2) Reset Data Toggle */
#define USBC_UECON2_STALLRQ         (0x1u << 19) /**< \brief (USBC_UECON2) STALL Request */
#define USBC_UECON2_BUSY0           (0x1u << 24) /**< \brief (USBC_UECON2) Busy Bank1 Enable */
#define USBC_UECON2_BUSY1           (0x1u << 25) /**< \brief (USBC_UECON2) Busy Bank0 Enable */
/* -------- USBC_UECON3 : (USBC Offset: 0x1CC) Endpoint Control Register -------- */
#define USBC_UECON3_TXINE           (0x1u <<  0) /**< \brief (USBC_UECON3) TXIN Interrupt Enable */
#define USBC_UECON3_RXOUTE          (0x1u <<  1) /**< \brief (USBC_UECON3) RXOUT Interrupt Enable */
#define USBC_UECON3_RXSTPE          (0x1u <<  2) /**< \brief (USBC_UECON3) RXSTP Interrupt Enable */
#define USBC_UECON3_NAKOUTE         (0x1u <<  3) /**< \brief (USBC_UECON3) NAKOUT Interrupt Enable */
#define USBC_UECON3_NAKINE          (0x1u <<  4) /**< \brief (USBC_UECON3) NAKIN Interrupt Enable */
#define USBC_UECON3_STALLEDE        (0x1u <<  6) /**< \brief (USBC_UECON3) STALLED Interrupt Enable */
#define USBC_UECON3_NREPLY          (0x1u <<  8) /**< \brief (USBC_UECON3) No Reply */
#define USBC_UECON3_RAMACERE        (0x1u << 11) /**< \brief (USBC_UECON3) RAMACER Interrupt Enable */
#define USBC_UECON3_NBUSYBKE        (0x1u << 12) /**< \brief (USBC_UECON3) Number of Busy Banks Interrupt Enable */
#define USBC_UECON3_KILLBK          (0x1u << 13) /**< \brief (USBC_UECON3) Kill IN Bank */
#define USBC_UECON3_FIFOCON         (0x1u << 14) /**< \brief (USBC_UECON3) FIFO Control */
#define USBC_UECON3_NYETDIS         (0x1u << 17) /**< \brief (USBC_UECON3) NYET Token Enable */
#define USBC_UECON3_RSTDT           (0x1u << 18) /**< \brief (USBC_UECON3) Reset Data Toggle */
#define USBC_UECON3_STALLRQ         (0x1u << 19) /**< \brief (USBC_UECON3) STALL Request */
#define USBC_UECON3_BUSY0           (0x1u << 24) /**< \brief (USBC_UECON3) Busy Bank1 Enable */
#define USBC_UECON3_BUSY1           (0x1u << 25) /**< \brief (USBC_UECON3) Busy Bank0 Enable */
/* -------- USBC_UECON4 : (USBC Offset: 0x1D0) Endpoint Control Register -------- */
#define USBC_UECON4_TXINE           (0x1u <<  0) /**< \brief (USBC_UECON4) TXIN Interrupt Enable */
#define USBC_UECON4_RXOUTE          (0x1u <<  1) /**< \brief (USBC_UECON4) RXOUT Interrupt Enable */
#define USBC_UECON4_RXSTPE          (0x1u <<  2) /**< \brief (USBC_UECON4) RXSTP Interrupt Enable */
#define USBC_UECON4_NAKOUTE         (0x1u <<  3) /**< \brief (USBC_UECON4) NAKOUT Interrupt Enable */
#define USBC_UECON4_NAKINE          (0x1u <<  4) /**< \brief (USBC_UECON4) NAKIN Interrupt Enable */
#define USBC_UECON4_STALLEDE        (0x1u <<  6) /**< \brief (USBC_UECON4) STALLED Interrupt Enable */
#define USBC_UECON4_NREPLY          (0x1u <<  8) /**< \brief (USBC_UECON4) No Reply */
#define USBC_UECON4_RAMACERE        (0x1u << 11) /**< \brief (USBC_UECON4) RAMACER Interrupt Enable */
#define USBC_UECON4_NBUSYBKE        (0x1u << 12) /**< \brief (USBC_UECON4) Number of Busy Banks Interrupt Enable */
#define USBC_UECON4_KILLBK          (0x1u << 13) /**< \brief (USBC_UECON4) Kill IN Bank */
#define USBC_UECON4_FIFOCON         (0x1u << 14) /**< \brief (USBC_UECON4) FIFO Control */
#define USBC_UECON4_NYETDIS         (0x1u << 17) /**< \brief (USBC_UECON4) NYET Token Enable */
#define USBC_UECON4_RSTDT           (0x1u << 18) /**< \brief (USBC_UECON4) Reset Data Toggle */
#define USBC_UECON4_STALLRQ         (0x1u << 19) /**< \brief (USBC_UECON4) STALL Request */
#define USBC_UECON4_BUSY0           (0x1u << 24) /**< \brief (USBC_UECON4) Busy Bank1 Enable */
#define USBC_UECON4_BUSY1           (0x1u << 25) /**< \brief (USBC_UECON4) Busy Bank0 Enable */
/* -------- USBC_UECON5 : (USBC Offset: 0x1D4) Endpoint Control Register -------- */
#define USBC_UECON5_TXINE           (0x1u <<  0) /**< \brief (USBC_UECON5) TXIN Interrupt Enable */
#define USBC_UECON5_RXOUTE          (0x1u <<  1) /**< \brief (USBC_UECON5) RXOUT Interrupt Enable */
#define USBC_UECON5_RXSTPE          (0x1u <<  2) /**< \brief (USBC_UECON5) RXSTP Interrupt Enable */
#define USBC_UECON5_NAKOUTE         (0x1u <<  3) /**< \brief (USBC_UECON5) NAKOUT Interrupt Enable */
#define USBC_UECON5_NAKINE          (0x1u <<  4) /**< \brief (USBC_UECON5) NAKIN Interrupt Enable */
#define USBC_UECON5_STALLEDE        (0x1u <<  6) /**< \brief (USBC_UECON5) STALLED Interrupt Enable */
#define USBC_UECON5_NREPLY          (0x1u <<  8) /**< \brief (USBC_UECON5) No Reply */
#define USBC_UECON5_RAMACERE        (0x1u << 11) /**< \brief (USBC_UECON5) RAMACER Interrupt Enable */
#define USBC_UECON5_NBUSYBKE        (0x1u << 12) /**< \brief (USBC_UECON5) Number of Busy Banks Interrupt Enable */
#define USBC_UECON5_KILLBK          (0x1u << 13) /**< \brief (USBC_UECON5) Kill IN Bank */
#define USBC_UECON5_FIFOCON         (0x1u << 14) /**< \brief (USBC_UECON5) FIFO Control */
#define USBC_UECON5_NYETDIS         (0x1u << 17) /**< \brief (USBC_UECON5) NYET Token Enable */
#define USBC_UECON5_RSTDT           (0x1u << 18) /**< \brief (USBC_UECON5) Reset Data Toggle */
#define USBC_UECON5_STALLRQ         (0x1u << 19) /**< \brief (USBC_UECON5) STALL Request */
#define USBC_UECON5_BUSY0           (0x1u << 24) /**< \brief (USBC_UECON5) Busy Bank1 Enable */
#define USBC_UECON5_BUSY1           (0x1u << 25) /**< \brief (USBC_UECON5) Busy Bank0 Enable */
/* -------- USBC_UECON6 : (USBC Offset: 0x1D8) Endpoint Control Register -------- */
#define USBC_UECON6_TXINE           (0x1u <<  0) /**< \brief (USBC_UECON6) TXIN Interrupt Enable */
#define USBC_UECON6_RXOUTE          (0x1u <<  1) /**< \brief (USBC_UECON6) RXOUT Interrupt Enable */
#define USBC_UECON6_RXSTPE          (0x1u <<  2) /**< \brief (USBC_UECON6) RXSTP Interrupt Enable */
#define USBC_UECON6_NAKOUTE         (0x1u <<  3) /**< \brief (USBC_UECON6) NAKOUT Interrupt Enable */
#define USBC_UECON6_NAKINE          (0x1u <<  4) /**< \brief (USBC_UECON6) NAKIN Interrupt Enable */
#define USBC_UECON6_STALLEDE        (0x1u <<  6) /**< \brief (USBC_UECON6) STALLED Interrupt Enable */
#define USBC_UECON6_NREPLY          (0x1u <<  8) /**< \brief (USBC_UECON6) No Reply */
#define USBC_UECON6_RAMACERE        (0x1u << 11) /**< \brief (USBC_UECON6) RAMACER Interrupt Enable */
#define USBC_UECON6_NBUSYBKE        (0x1u << 12) /**< \brief (USBC_UECON6) Number of Busy Banks Interrupt Enable */
#define USBC_UECON6_KILLBK          (0x1u << 13) /**< \brief (USBC_UECON6) Kill IN Bank */
#define USBC_UECON6_FIFOCON         (0x1u << 14) /**< \brief (USBC_UECON6) FIFO Control */
#define USBC_UECON6_NYETDIS         (0x1u << 17) /**< \brief (USBC_UECON6) NYET Token Enable */
#define USBC_UECON6_RSTDT           (0x1u << 18) /**< \brief (USBC_UECON6) Reset Data Toggle */
#define USBC_UECON6_STALLRQ         (0x1u << 19) /**< \brief (USBC_UECON6) STALL Request */
#define USBC_UECON6_BUSY0           (0x1u << 24) /**< \brief (USBC_UECON6) Busy Bank1 Enable */
#define USBC_UECON6_BUSY1           (0x1u << 25) /**< \brief (USBC_UECON6) Busy Bank0 Enable */
/* -------- USBC_UECON7 : (USBC Offset: 0x1DC) Endpoint Control Register -------- */
#define USBC_UECON7_TXINE           (0x1u <<  0) /**< \brief (USBC_UECON7) TXIN Interrupt Enable */
#define USBC_UECON7_RXOUTE          (0x1u <<  1) /**< \brief (USBC_UECON7) RXOUT Interrupt Enable */
#define USBC_UECON7_RXSTPE          (0x1u <<  2) /**< \brief (USBC_UECON7) RXSTP Interrupt Enable */
#define USBC_UECON7_NAKOUTE         (0x1u <<  3) /**< \brief (USBC_UECON7) NAKOUT Interrupt Enable */
#define USBC_UECON7_NAKINE          (0x1u <<  4) /**< \brief (USBC_UECON7) NAKIN Interrupt Enable */
#define USBC_UECON7_STALLEDE        (0x1u <<  6) /**< \brief (USBC_UECON7) STALLED Interrupt Enable */
#define USBC_UECON7_NREPLY          (0x1u <<  8) /**< \brief (USBC_UECON7) No Reply */
#define USBC_UECON7_RAMACERE        (0x1u << 11) /**< \brief (USBC_UECON7) RAMACER Interrupt Enable */
#define USBC_UECON7_NBUSYBKE        (0x1u << 12) /**< \brief (USBC_UECON7) Number of Busy Banks Interrupt Enable */
#define USBC_UECON7_KILLBK          (0x1u << 13) /**< \brief (USBC_UECON7) Kill IN Bank */
#define USBC_UECON7_FIFOCON         (0x1u << 14) /**< \brief (USBC_UECON7) FIFO Control */
#define USBC_UECON7_NYETDIS         (0x1u << 17) /**< \brief (USBC_UECON7) NYET Token Enable */
#define USBC_UECON7_RSTDT           (0x1u << 18) /**< \brief (USBC_UECON7) Reset Data Toggle */
#define USBC_UECON7_STALLRQ         (0x1u << 19) /**< \brief (USBC_UECON7) STALL Request */
#define USBC_UECON7_BUSY0           (0x1u << 24) /**< \brief (USBC_UECON7) Busy Bank1 Enable */
#define USBC_UECON7_BUSY1           (0x1u << 25) /**< \brief (USBC_UECON7) Busy Bank0 Enable */
/* -------- USBC_UECON0SET : (USBC Offset: 0x1F0) Endpoint Control Set Register -------- */
#define USBC_UECON0SET_TXINES       (0x1u <<  0) /**< \brief (USBC_UECON0SET) TXINE Set */
#define USBC_UECON0SET_RXOUTES      (0x1u <<  1) /**< \brief (USBC_UECON0SET) RXOUTE Set */
#define USBC_UECON0SET_RXSTPES      (0x1u <<  2) /**< \brief (USBC_UECON0SET) RXSTPE Set */
#define USBC_UECON0SET_NAKOUTES     (0x1u <<  3) /**< \brief (USBC_UECON0SET) NAKOUTE Set */
#define USBC_UECON0SET_NAKINES      (0x1u <<  4) /**< \brief (USBC_UECON0SET) NAKINE Set */
#define USBC_UECON0SET_STALLEDES    (0x1u <<  6) /**< \brief (USBC_UECON0SET) STALLEDE Set */
#define USBC_UECON0SET_NREPLYS      (0x1u <<  8) /**< \brief (USBC_UECON0SET) NREPLY Set */
#define USBC_UECON0SET_RAMACERES    (0x1u << 11) /**< \brief (USBC_UECON0SET) RAMACERE Set */
#define USBC_UECON0SET_NBUSYBKES    (0x1u << 12) /**< \brief (USBC_UECON0SET) NBUSYBKE Set */
#define USBC_UECON0SET_KILLBKS      (0x1u << 13) /**< \brief (USBC_UECON0SET) KILLBK Set */
#define USBC_UECON0SET_NYETDISS     (0x1u << 17) /**< \brief (USBC_UECON0SET) NYETDIS Set */
#define USBC_UECON0SET_RSTDTS       (0x1u << 18) /**< \brief (USBC_UECON0SET) RSTDT Set */
#define USBC_UECON0SET_STALLRQS     (0x1u << 19) /**< \brief (USBC_UECON0SET) STALLRQ Set */
#define USBC_UECON0SET_BUSY0S       (0x1u << 24) /**< \brief (USBC_UECON0SET) BUSY0 Set */
#define USBC_UECON0SET_BUSY1S       (0x1u << 25) /**< \brief (USBC_UECON0SET) BUSY1 Set */
/* -------- USBC_UECON1SET : (USBC Offset: 0x1F4) Endpoint Control Set Register -------- */
#define USBC_UECON1SET_TXINES       (0x1u <<  0) /**< \brief (USBC_UECON1SET) TXINE Set */
#define USBC_UECON1SET_RXOUTES      (0x1u <<  1) /**< \brief (USBC_UECON1SET) RXOUTE Set */
#define USBC_UECON1SET_RXSTPES      (0x1u <<  2) /**< \brief (USBC_UECON1SET) RXSTPE Set */
#define USBC_UECON1SET_NAKOUTES     (0x1u <<  3) /**< \brief (USBC_UECON1SET) NAKOUTE Set */
#define USBC_UECON1SET_NAKINES      (0x1u <<  4) /**< \brief (USBC_UECON1SET) NAKINE Set */
#define USBC_UECON1SET_STALLEDES    (0x1u <<  6) /**< \brief (USBC_UECON1SET) STALLEDE Set */
#define USBC_UECON1SET_NREPLYS      (0x1u <<  8) /**< \brief (USBC_UECON1SET) NREPLY Set */
#define USBC_UECON1SET_RAMACERES    (0x1u << 11) /**< \brief (USBC_UECON1SET) RAMACERE Set */
#define USBC_UECON1SET_NBUSYBKES    (0x1u << 12) /**< \brief (USBC_UECON1SET) NBUSYBKE Set */
#define USBC_UECON1SET_KILLBKS      (0x1u << 13) /**< \brief (USBC_UECON1SET) KILLBK Set */
#define USBC_UECON1SET_NYETDISS     (0x1u << 17) /**< \brief (USBC_UECON1SET) NYETDIS Set */
#define USBC_UECON1SET_RSTDTS       (0x1u << 18) /**< \brief (USBC_UECON1SET) RSTDT Set */
#define USBC_UECON1SET_STALLRQS     (0x1u << 19) /**< \brief (USBC_UECON1SET) STALLRQ Set */
#define USBC_UECON1SET_BUSY0S       (0x1u << 24) /**< \brief (USBC_UECON1SET) BUSY0 Set */
#define USBC_UECON1SET_BUSY1S       (0x1u << 25) /**< \brief (USBC_UECON1SET) BUSY1 Set */
/* -------- USBC_UECON2SET : (USBC Offset: 0x1F8) Endpoint Control Set Register -------- */
#define USBC_UECON2SET_TXINES       (0x1u <<  0) /**< \brief (USBC_UECON2SET) TXINE Set */
#define USBC_UECON2SET_RXOUTES      (0x1u <<  1) /**< \brief (USBC_UECON2SET) RXOUTE Set */
#define USBC_UECON2SET_RXSTPES      (0x1u <<  2) /**< \brief (USBC_UECON2SET) RXSTPE Set */
#define USBC_UECON2SET_NAKOUTES     (0x1u <<  3) /**< \brief (USBC_UECON2SET) NAKOUTE Set */
#define USBC_UECON2SET_NAKINES      (0x1u <<  4) /**< \brief (USBC_UECON2SET) NAKINE Set */
#define USBC_UECON2SET_STALLEDES    (0x1u <<  6) /**< \brief (USBC_UECON2SET) STALLEDE Set */
#define USBC_UECON2SET_NREPLYS      (0x1u <<  8) /**< \brief (USBC_UECON2SET) NREPLY Set */
#define USBC_UECON2SET_RAMACERES    (0x1u << 11) /**< \brief (USBC_UECON2SET) RAMACERE Set */
#define USBC_UECON2SET_NBUSYBKES    (0x1u << 12) /**< \brief (USBC_UECON2SET) NBUSYBKE Set */
#define USBC_UECON2SET_KILLBKS      (0x1u << 13) /**< \brief (USBC_UECON2SET) KILLBK Set */
#define USBC_UECON2SET_NYETDISS     (0x1u << 17) /**< \brief (USBC_UECON2SET) NYETDIS Set */
#define USBC_UECON2SET_RSTDTS       (0x1u << 18) /**< \brief (USBC_UECON2SET) RSTDT Set */
#define USBC_UECON2SET_STALLRQS     (0x1u << 19) /**< \brief (USBC_UECON2SET) STALLRQ Set */
#define USBC_UECON2SET_BUSY0S       (0x1u << 24) /**< \brief (USBC_UECON2SET) BUSY0 Set */
#define USBC_UECON2SET_BUSY1S       (0x1u << 25) /**< \brief (USBC_UECON2SET) BUSY1 Set */
/* -------- USBC_UECON3SET : (USBC Offset: 0x1FC) Endpoint Control Set Register -------- */
#define USBC_UECON3SET_TXINES       (0x1u <<  0) /**< \brief (USBC_UECON3SET) TXINE Set */
#define USBC_UECON3SET_RXOUTES      (0x1u <<  1) /**< \brief (USBC_UECON3SET) RXOUTE Set */
#define USBC_UECON3SET_RXSTPES      (0x1u <<  2) /**< \brief (USBC_UECON3SET) RXSTPE Set */
#define USBC_UECON3SET_NAKOUTES     (0x1u <<  3) /**< \brief (USBC_UECON3SET) NAKOUTE Set */
#define USBC_UECON3SET_NAKINES      (0x1u <<  4) /**< \brief (USBC_UECON3SET) NAKINE Set */
#define USBC_UECON3SET_STALLEDES    (0x1u <<  6) /**< \brief (USBC_UECON3SET) STALLEDE Set */
#define USBC_UECON3SET_NREPLYS      (0x1u <<  8) /**< \brief (USBC_UECON3SET) NREPLY Set */
#define USBC_UECON3SET_RAMACERES    (0x1u << 11) /**< \brief (USBC_UECON3SET) RAMACERE Set */
#define USBC_UECON3SET_NBUSYBKES    (0x1u << 12) /**< \brief (USBC_UECON3SET) NBUSYBKE Set */
#define USBC_UECON3SET_KILLBKS      (0x1u << 13) /**< \brief (USBC_UECON3SET) KILLBK Set */
#define USBC_UECON3SET_NYETDISS     (0x1u << 17) /**< \brief (USBC_UECON3SET) NYETDIS Set */
#define USBC_UECON3SET_RSTDTS       (0x1u << 18) /**< \brief (USBC_UECON3SET) RSTDT Set */
#define USBC_UECON3SET_STALLRQS     (0x1u << 19) /**< \brief (USBC_UECON3SET) STALLRQ Set */
#define USBC_UECON3SET_BUSY0S       (0x1u << 24) /**< \brief (USBC_UECON3SET) BUSY0 Set */
#define USBC_UECON3SET_BUSY1S       (0x1u << 25) /**< \brief (USBC_UECON3SET) BUSY1 Set */
/* -------- USBC_UECON4SET : (USBC Offset: 0x200) Endpoint Control Set Register -------- */
#define USBC_UECON4SET_TXINES       (0x1u <<  0) /**< \brief (USBC_UECON4SET) TXINE Set */
#define USBC_UECON4SET_RXOUTES      (0x1u <<  1) /**< \brief (USBC_UECON4SET) RXOUTE Set */
#define USBC_UECON4SET_RXSTPES      (0x1u <<  2) /**< \brief (USBC_UECON4SET) RXSTPE Set */
#define USBC_UECON4SET_NAKOUTES     (0x1u <<  3) /**< \brief (USBC_UECON4SET) NAKOUTE Set */
#define USBC_UECON4SET_NAKINES      (0x1u <<  4) /**< \brief (USBC_UECON4SET) NAKINE Set */
#define USBC_UECON4SET_STALLEDES    (0x1u <<  6) /**< \brief (USBC_UECON4SET) STALLEDE Set */
#define USBC_UECON4SET_NREPLYS      (0x1u <<  8) /**< \brief (USBC_UECON4SET) NREPLY Set */
#define USBC_UECON4SET_RAMACERES    (0x1u << 11) /**< \brief (USBC_UECON4SET) RAMACERE Set */
#define USBC_UECON4SET_NBUSYBKES    (0x1u << 12) /**< \brief (USBC_UECON4SET) NBUSYBKE Set */
#define USBC_UECON4SET_KILLBKS      (0x1u << 13) /**< \brief (USBC_UECON4SET) KILLBK Set */
#define USBC_UECON4SET_NYETDISS     (0x1u << 17) /**< \brief (USBC_UECON4SET) NYETDIS Set */
#define USBC_UECON4SET_RSTDTS       (0x1u << 18) /**< \brief (USBC_UECON4SET) RSTDT Set */
#define USBC_UECON4SET_STALLRQS     (0x1u << 19) /**< \brief (USBC_UECON4SET) STALLRQ Set */
#define USBC_UECON4SET_BUSY0S       (0x1u << 24) /**< \brief (USBC_UECON4SET) BUSY0 Set */
#define USBC_UECON4SET_BUSY1S       (0x1u << 25) /**< \brief (USBC_UECON4SET) BUSY1 Set */
/* -------- USBC_UECON5SET : (USBC Offset: 0x204) Endpoint Control Set Register -------- */
#define USBC_UECON5SET_TXINES       (0x1u <<  0) /**< \brief (USBC_UECON5SET) TXINE Set */
#define USBC_UECON5SET_RXOUTES      (0x1u <<  1) /**< \brief (USBC_UECON5SET) RXOUTE Set */
#define USBC_UECON5SET_RXSTPES      (0x1u <<  2) /**< \brief (USBC_UECON5SET) RXSTPE Set */
#define USBC_UECON5SET_NAKOUTES     (0x1u <<  3) /**< \brief (USBC_UECON5SET) NAKOUTE Set */
#define USBC_UECON5SET_NAKINES      (0x1u <<  4) /**< \brief (USBC_UECON5SET) NAKINE Set */
#define USBC_UECON5SET_STALLEDES    (0x1u <<  6) /**< \brief (USBC_UECON5SET) STALLEDE Set */
#define USBC_UECON5SET_NREPLYS      (0x1u <<  8) /**< \brief (USBC_UECON5SET) NREPLY Set */
#define USBC_UECON5SET_RAMACERES    (0x1u << 11) /**< \brief (USBC_UECON5SET) RAMACERE Set */
#define USBC_UECON5SET_NBUSYBKES    (0x1u << 12) /**< \brief (USBC_UECON5SET) NBUSYBKE Set */
#define USBC_UECON5SET_KILLBKS      (0x1u << 13) /**< \brief (USBC_UECON5SET) KILLBK Set */
#define USBC_UECON5SET_NYETDISS     (0x1u << 17) /**< \brief (USBC_UECON5SET) NYETDIS Set */
#define USBC_UECON5SET_RSTDTS       (0x1u << 18) /**< \brief (USBC_UECON5SET) RSTDT Set */
#define USBC_UECON5SET_STALLRQS     (0x1u << 19) /**< \brief (USBC_UECON5SET) STALLRQ Set */
#define USBC_UECON5SET_BUSY0S       (0x1u << 24) /**< \brief (USBC_UECON5SET) BUSY0 Set */
#define USBC_UECON5SET_BUSY1S       (0x1u << 25) /**< \brief (USBC_UECON5SET) BUSY1 Set */
/* -------- USBC_UECON6SET : (USBC Offset: 0x208) Endpoint Control Set Register -------- */
#define USBC_UECON6SET_TXINES       (0x1u <<  0) /**< \brief (USBC_UECON6SET) TXINE Set */
#define USBC_UECON6SET_RXOUTES      (0x1u <<  1) /**< \brief (USBC_UECON6SET) RXOUTE Set */
#define USBC_UECON6SET_RXSTPES      (0x1u <<  2) /**< \brief (USBC_UECON6SET) RXSTPE Set */
#define USBC_UECON6SET_NAKOUTES     (0x1u <<  3) /**< \brief (USBC_UECON6SET) NAKOUTE Set */
#define USBC_UECON6SET_NAKINES      (0x1u <<  4) /**< \brief (USBC_UECON6SET) NAKINE Set */
#define USBC_UECON6SET_STALLEDES    (0x1u <<  6) /**< \brief (USBC_UECON6SET) STALLEDE Set */
#define USBC_UECON6SET_NREPLYS      (0x1u <<  8) /**< \brief (USBC_UECON6SET) NREPLY Set */
#define USBC_UECON6SET_RAMACERES    (0x1u << 11) /**< \brief (USBC_UECON6SET) RAMACERE Set */
#define USBC_UECON6SET_NBUSYBKES    (0x1u << 12) /**< \brief (USBC_UECON6SET) NBUSYBKE Set */
#define USBC_UECON6SET_KILLBKS      (0x1u << 13) /**< \brief (USBC_UECON6SET) KILLBK Set */
#define USBC_UECON6SET_NYETDISS     (0x1u << 17) /**< \brief (USBC_UECON6SET) NYETDIS Set */
#define USBC_UECON6SET_RSTDTS       (0x1u << 18) /**< \brief (USBC_UECON6SET) RSTDT Set */
#define USBC_UECON6SET_STALLRQS     (0x1u << 19) /**< \brief (USBC_UECON6SET) STALLRQ Set */
#define USBC_UECON6SET_BUSY0S       (0x1u << 24) /**< \brief (USBC_UECON6SET) BUSY0 Set */
#define USBC_UECON6SET_BUSY1S       (0x1u << 25) /**< \brief (USBC_UECON6SET) BUSY1 Set */
/* -------- USBC_UECON7SET : (USBC Offset: 0x20C) Endpoint Control Set Register -------- */
#define USBC_UECON7SET_TXINES       (0x1u <<  0) /**< \brief (USBC_UECON7SET) TXINE Set */
#define USBC_UECON7SET_RXOUTES      (0x1u <<  1) /**< \brief (USBC_UECON7SET) RXOUTE Set */
#define USBC_UECON7SET_RXSTPES      (0x1u <<  2) /**< \brief (USBC_UECON7SET) RXSTPE Set */
#define USBC_UECON7SET_NAKOUTES     (0x1u <<  3) /**< \brief (USBC_UECON7SET) NAKOUTE Set */
#define USBC_UECON7SET_NAKINES      (0x1u <<  4) /**< \brief (USBC_UECON7SET) NAKINE Set */
#define USBC_UECON7SET_STALLEDES    (0x1u <<  6) /**< \brief (USBC_UECON7SET) STALLEDE Set */
#define USBC_UECON7SET_NREPLYS      (0x1u <<  8) /**< \brief (USBC_UECON7SET) NREPLY Set */
#define USBC_UECON7SET_RAMACERES    (0x1u << 11) /**< \brief (USBC_UECON7SET) RAMACERE Set */
#define USBC_UECON7SET_NBUSYBKES    (0x1u << 12) /**< \brief (USBC_UECON7SET) NBUSYBKE Set */
#define USBC_UECON7SET_KILLBKS      (0x1u << 13) /**< \brief (USBC_UECON7SET) KILLBK Set */
#define USBC_UECON7SET_NYETDISS     (0x1u << 17) /**< \brief (USBC_UECON7SET) NYETDIS Set */
#define USBC_UECON7SET_RSTDTS       (0x1u << 18) /**< \brief (USBC_UECON7SET) RSTDT Set */
#define USBC_UECON7SET_STALLRQS     (0x1u << 19) /**< \brief (USBC_UECON7SET) STALLRQ Set */
#define USBC_UECON7SET_BUSY0S       (0x1u << 24) /**< \brief (USBC_UECON7SET) BUSY0 Set */
#define USBC_UECON7SET_BUSY1S       (0x1u << 25) /**< \brief (USBC_UECON7SET) BUSY1 Set */
/* -------- USBC_UECON0CLR : (USBC Offset: 0x220) Endpoint Control Clear Register -------- */
#define USBC_UECON0CLR_TXINEC       (0x1u <<  0) /**< \brief (USBC_UECON0CLR) TXINE Clear */
#define USBC_UECON0CLR_RXOUTEC      (0x1u <<  1) /**< \brief (USBC_UECON0CLR) RXOUTE Clear */
#define USBC_UECON0CLR_RXSTPEC      (0x1u <<  2) /**< \brief (USBC_UECON0CLR) RXSTPE Clear */
#define USBC_UECON0CLR_NAKOUTEC     (0x1u <<  3) /**< \brief (USBC_UECON0CLR) NAKOUTE Clear */
#define USBC_UECON0CLR_NAKINEC      (0x1u <<  4) /**< \brief (USBC_UECON0CLR) NAKINE Clear */
#define USBC_UECON0CLR_STALLEDEC    (0x1u <<  6) /**< \brief (USBC_UECON0CLR) STALLEDE Clear */
#define USBC_UECON0CLR_NREPLYC      (0x1u <<  8) /**< \brief (USBC_UECON0CLR) NREPLY Clear */
#define USBC_UECON0CLR_RAMACEREC    (0x1u << 11) /**< \brief (USBC_UECON0CLR) RAMACERE Clear */
#define USBC_UECON0CLR_NBUSYBKEC    (0x1u << 12) /**< \brief (USBC_UECON0CLR) NBUSYBKE Clear */
#define USBC_UECON0CLR_FIFOCONC     (0x1u << 14) /**< \brief (USBC_UECON0CLR) FIFOCON Clear */
#define USBC_UECON0CLR_NYETDISC     (0x1u << 17) /**< \brief (USBC_UECON0CLR) NYETDIS Clear */
#define USBC_UECON0CLR_STALLRQC     (0x1u << 19) /**< \brief (USBC_UECON0CLR) STALLRQ Clear */
#define USBC_UECON0CLR_BUSY0C       (0x1u << 24) /**< \brief (USBC_UECON0CLR) BUSY0 Clear */
#define USBC_UECON0CLR_BUSY1C       (0x1u << 25) /**< \brief (USBC_UECON0CLR) BUSY1 Clear */
/* -------- USBC_UECON1CLR : (USBC Offset: 0x224) TXINE Clear -------- */
#define USBC_UECON1CLR_TXINEC       (0x1u <<  0) /**< \brief (USBC_UECON1CLR) TXINE Clear */
#define USBC_UECON1CLR_RXOUTEC      (0x1u <<  1) /**< \brief (USBC_UECON1CLR) RXOUTE Clear */
#define USBC_UECON1CLR_RXSTPEC      (0x1u <<  2) /**< \brief (USBC_UECON1CLR) RXOUTE Clear */
#define USBC_UECON1CLR_NAKOUTEC     (0x1u <<  3) /**< \brief (USBC_UECON1CLR) NAKOUTE Clear */
#define USBC_UECON1CLR_NAKINEC      (0x1u <<  4) /**< \brief (USBC_UECON1CLR) NAKINE Clear */
#define USBC_UECON1CLR_STALLEDEC    (0x1u <<  6) /**< \brief (USBC_UECON1CLR) RXSTPE Clear */
#define USBC_UECON1CLR_NREPLYC      (0x1u <<  8) /**< \brief (USBC_UECON1CLR) NREPLY Clear */
#define USBC_UECON1CLR_RAMACEREC    (0x1u << 11) /**< \brief (USBC_UECON1CLR) RAMACERE Clear */
#define USBC_UECON1CLR_NBUSYBKEC    (0x1u << 12) /**< \brief (USBC_UECON1CLR) NBUSYBKE Clear */
#define USBC_UECON1CLR_FIFOCONC     (0x1u << 14) /**< \brief (USBC_UECON1CLR) FIFOCON Clear */
#define USBC_UECON1CLR_NYETDISC     (0x1u << 17) /**< \brief (USBC_UECON1CLR) NYETDIS Clear */
#define USBC_UECON1CLR_STALLRQC     (0x1u << 19) /**< \brief (USBC_UECON1CLR) STALLEDE Clear */
#define USBC_UECON1CLR_BUSY0C       (0x1u << 24) /**< \brief (USBC_UECON1CLR) BUSY0 Clear */
#define USBC_UECON1CLR_BUSY1C       (0x1u << 25) /**< \brief (USBC_UECON1CLR) BUSY1 Clear */
/* -------- USBC_UECON2CLR : (USBC Offset: 0x228) TXINE Clear -------- */
#define USBC_UECON2CLR_TXINEC       (0x1u <<  0) /**< \brief (USBC_UECON2CLR) TXINE Clear */
#define USBC_UECON2CLR_RXOUTEC      (0x1u <<  1) /**< \brief (USBC_UECON2CLR) RXOUTE Clear */
#define USBC_UECON2CLR_RXSTPEC      (0x1u <<  2) /**< \brief (USBC_UECON2CLR) RXOUTE Clear */
#define USBC_UECON2CLR_NAKOUTEC     (0x1u <<  3) /**< \brief (USBC_UECON2CLR) NAKOUTE Clear */
#define USBC_UECON2CLR_NAKINEC      (0x1u <<  4) /**< \brief (USBC_UECON2CLR) NAKINE Clear */
#define USBC_UECON2CLR_STALLEDEC    (0x1u <<  6) /**< \brief (USBC_UECON2CLR) RXSTPE Clear */
#define USBC_UECON2CLR_NREPLYC      (0x1u <<  8) /**< \brief (USBC_UECON2CLR) NREPLY Clear */
#define USBC_UECON2CLR_RAMACEREC    (0x1u << 11) /**< \brief (USBC_UECON2CLR) RAMACERE Clear */
#define USBC_UECON2CLR_NBUSYBKEC    (0x1u << 12) /**< \brief (USBC_UECON2CLR) NBUSYBKE Clear */
#define USBC_UECON2CLR_FIFOCONC     (0x1u << 14) /**< \brief (USBC_UECON2CLR) FIFOCON Clear */
#define USBC_UECON2CLR_NYETDISC     (0x1u << 17) /**< \brief (USBC_UECON2CLR) NYETDIS Clear */
#define USBC_UECON2CLR_STALLRQC     (0x1u << 19) /**< \brief (USBC_UECON2CLR) STALLEDE Clear */
#define USBC_UECON2CLR_BUSY0C       (0x1u << 24) /**< \brief (USBC_UECON2CLR) BUSY0 Clear */
#define USBC_UECON2CLR_BUSY1C       (0x1u << 25) /**< \brief (USBC_UECON2CLR) BUSY1 Clear */
/* -------- USBC_UECON3CLR : (USBC Offset: 0x22C) TXINE Clear -------- */
#define USBC_UECON3CLR_TXINEC       (0x1u <<  0) /**< \brief (USBC_UECON3CLR) TXINE Clear */
#define USBC_UECON3CLR_RXOUTEC      (0x1u <<  1) /**< \brief (USBC_UECON3CLR) RXOUTE Clear */
#define USBC_UECON3CLR_RXSTPEC      (0x1u <<  2) /**< \brief (USBC_UECON3CLR) RXOUTE Clear */
#define USBC_UECON3CLR_NAKOUTEC     (0x1u <<  3) /**< \brief (USBC_UECON3CLR) NAKOUTE Clear */
#define USBC_UECON3CLR_NAKINEC      (0x1u <<  4) /**< \brief (USBC_UECON3CLR) NAKINE Clear */
#define USBC_UECON3CLR_STALLEDEC    (0x1u <<  6) /**< \brief (USBC_UECON3CLR) RXSTPE Clear */
#define USBC_UECON3CLR_NREPLYC      (0x1u <<  8) /**< \brief (USBC_UECON3CLR) NREPLY Clear */
#define USBC_UECON3CLR_RAMACEREC    (0x1u << 11) /**< \brief (USBC_UECON3CLR) RAMACERE Clear */
#define USBC_UECON3CLR_NBUSYBKEC    (0x1u << 12) /**< \brief (USBC_UECON3CLR) NBUSYBKE Clear */
#define USBC_UECON3CLR_FIFOCONC     (0x1u << 14) /**< \brief (USBC_UECON3CLR) FIFOCON Clear */
#define USBC_UECON3CLR_NYETDISC     (0x1u << 17) /**< \brief (USBC_UECON3CLR) NYETDIS Clear */
#define USBC_UECON3CLR_STALLRQC     (0x1u << 19) /**< \brief (USBC_UECON3CLR) STALLEDE Clear */
#define USBC_UECON3CLR_BUSY0C       (0x1u << 24) /**< \brief (USBC_UECON3CLR) BUSY0 Clear */
#define USBC_UECON3CLR_BUSY1C       (0x1u << 25) /**< \brief (USBC_UECON3CLR) BUSY1 Clear */
/* -------- USBC_UECON4CLR : (USBC Offset: 0x230) TXINE Clear -------- */
#define USBC_UECON4CLR_TXINEC       (0x1u <<  0) /**< \brief (USBC_UECON4CLR) TXINE Clear */
#define USBC_UECON4CLR_RXOUTEC      (0x1u <<  1) /**< \brief (USBC_UECON4CLR) RXOUTE Clear */
#define USBC_UECON4CLR_RXSTPEC      (0x1u <<  2) /**< \brief (USBC_UECON4CLR) RXOUTE Clear */
#define USBC_UECON4CLR_NAKOUTEC     (0x1u <<  3) /**< \brief (USBC_UECON4CLR) NAKOUTE Clear */
#define USBC_UECON4CLR_NAKINEC      (0x1u <<  4) /**< \brief (USBC_UECON4CLR) NAKINE Clear */
#define USBC_UECON4CLR_STALLEDEC    (0x1u <<  6) /**< \brief (USBC_UECON4CLR) RXSTPE Clear */
#define USBC_UECON4CLR_NREPLYC      (0x1u <<  8) /**< \brief (USBC_UECON4CLR) NREPLY Clear */
#define USBC_UECON4CLR_RAMACEREC    (0x1u << 11) /**< \brief (USBC_UECON4CLR) RAMACERE Clear */
#define USBC_UECON4CLR_NBUSYBKEC    (0x1u << 12) /**< \brief (USBC_UECON4CLR) NBUSYBKE Clear */
#define USBC_UECON4CLR_FIFOCONC     (0x1u << 14) /**< \brief (USBC_UECON4CLR) FIFOCON Clear */
#define USBC_UECON4CLR_NYETDISC     (0x1u << 17) /**< \brief (USBC_UECON4CLR) NYETDIS Clear */
#define USBC_UECON4CLR_STALLRQC     (0x1u << 19) /**< \brief (USBC_UECON4CLR) STALLEDE Clear */
#define USBC_UECON4CLR_BUSY0C       (0x1u << 24) /**< \brief (USBC_UECON4CLR) BUSY0 Clear */
#define USBC_UECON4CLR_BUSY1C       (0x1u << 25) /**< \brief (USBC_UECON4CLR) BUSY1 Clear */
/* -------- USBC_UECON5CLR : (USBC Offset: 0x234) TXINE Clear -------- */
#define USBC_UECON5CLR_TXINEC       (0x1u <<  0) /**< \brief (USBC_UECON5CLR) TXINE Clear */
#define USBC_UECON5CLR_RXOUTEC      (0x1u <<  1) /**< \brief (USBC_UECON5CLR) RXOUTE Clear */
#define USBC_UECON5CLR_RXSTPEC      (0x1u <<  2) /**< \brief (USBC_UECON5CLR) RXOUTE Clear */
#define USBC_UECON5CLR_NAKOUTEC     (0x1u <<  3) /**< \brief (USBC_UECON5CLR) NAKOUTE Clear */
#define USBC_UECON5CLR_NAKINEC      (0x1u <<  4) /**< \brief (USBC_UECON5CLR) NAKINE Clear */
#define USBC_UECON5CLR_STALLEDEC    (0x1u <<  6) /**< \brief (USBC_UECON5CLR) RXSTPE Clear */
#define USBC_UECON5CLR_NREPLYC      (0x1u <<  8) /**< \brief (USBC_UECON5CLR) NREPLY Clear */
#define USBC_UECON5CLR_RAMACEREC    (0x1u << 11) /**< \brief (USBC_UECON5CLR) RAMACERE Clear */
#define USBC_UECON5CLR_NBUSYBKEC    (0x1u << 12) /**< \brief (USBC_UECON5CLR) NBUSYBKE Clear */
#define USBC_UECON5CLR_FIFOCONC     (0x1u << 14) /**< \brief (USBC_UECON5CLR) FIFOCON Clear */
#define USBC_UECON5CLR_NYETDISC     (0x1u << 17) /**< \brief (USBC_UECON5CLR) NYETDIS Clear */
#define USBC_UECON5CLR_STALLRQC     (0x1u << 19) /**< \brief (USBC_UECON5CLR) STALLEDE Clear */
#define USBC_UECON5CLR_BUSY0C       (0x1u << 24) /**< \brief (USBC_UECON5CLR) BUSY0 Clear */
#define USB