/* ----------------------------------------------------------------------------
 *         ATMEL Microcontroller Software Support
 * ----------------------------------------------------------------------------
 * Copyright (c) 2010, Atmel Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Atmel's name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ----------------------------------------------------------------------------
 */

/*------------------------------------------------------------------------------ */
/*         Headers                                                               */
/*------------------------------------------------------------------------------ */

#include <stdint.h>
#include <libpmecc.h>
/*----------------------------------------------------------------------------
 *         Variables
 *----------------------------------------------------------------------------*/
/* Gallois Field tables for 1024 bytes sectors , First raw is "index_of" and second one is "alpha_to"    */
#if defined ( GALOIS_TABLE_1024_ROM_MAPPING ) && defined (GALOIS_TABLE_IN_ROM)
const int16_t *pmecc_gf_1024 = (int16_t *)(GALOIS_TABLE_1024_ROM_MAPPING);
#else
const uint16_t pmecc_gf_1024[2][PMECC_GF_SIZEOF_1024] = {
    /* "index_of" table */
    {
        0xffff, 0x0000, 0x0001, 0x0572, 0x0002, 0x0ae4, 0x0573, 0x015b, 0x0003, 0x06cd, 0x0ae5, 0x1ad9, 0x0574, 0x012e, 0x015c, 0x1056,
        0x0004, 0x15c8, 0x06ce, 0x288d, 0x0ae6, 0x02b6, 0x1ada, 0x06a0, 0x0575, 0x2ed2, 0x012f, 0x0c3f, 0x015d, 0x204b, 0x1057, 0x3812,
        0x0005, 0x3d84, 0x15c9, 0x0289, 0x06cf, 0x347d, 0x288e, 0x25bd, 0x0ae7, 0x10d1, 0x02b7, 0x3444, 0x1adb, 0x11b1, 0x06a1, 0x109c,
        0x0576, 0x1c34, 0x2ed3, 0x1b3a, 0x0130, 0x2dff, 0x0c40, 0x2238, 0x015e, 0x0c12, 0x204c, 0x3d67, 0x1058, 0x3f47, 0x3813, 0x0828,
        0x0006, 0x0d9a, 0x3d85, 0x15d2, 0x15ca, 0x35b2, 0x028a, 0x04ba, 0x06d0, 0x1f3c, 0x347e, 0x1184, 0x288f, 0x02da, 0x25be, 0x302d,
        0x0ae8, 0x025c, 0x10d2, 0x21a6, 0x02b8, 0x20ac, 0x3445, 0x034f, 0x1adc, 0x27aa, 0x11b2, 0x2bb3, 0x06a2, 0x396d, 0x109d, 0x3371,
        0x0577, 0x3bd2, 0x1c35, 0x02f7, 0x2ed4, 0x07fb, 0x1b3b, 0x1a8e, 0x0131, 0x2b2f, 0x2e00, 0x0411, 0x0c41, 0x0beb, 0x2239, 0x39ef,
        0x015f, 0x160e, 0x0c13, 0x0012, 0x204d, 0x363b, 0x3d68, 0x1723, 0x1059, 0x29e8, 0x3f48, 0x1643, 0x3814, 0x39b6, 0x0829, 0x1c07,
        0x0007, 0x2179, 0x0d9b, 0x2142, 0x3d86, 0x2393, 0x15d3, 0x3f28, 0x15cb, 0x1305, 0x35b3, 0x2f5a, 0x028b, 0x1bb5, 0x04bb, 0x2310,
        0x06d1, 0x270d, 0x1f3d, 0x1b80, 0x347f, 0x0584, 0x1185, 0x1d8f, 0x2890, 0x1c95, 0x02db, 0x3940, 0x25bf, 0x27e8, 0x302e, 0x3bad,
        0x0ae9, 0x3ec2, 0x025d, 0x0145, 0x10d3, 0x0869, 0x21a7, 0x3a22, 0x02b9, 0x2000, 0x20ad, 0x22b9, 0x3446, 0x0367, 0x0350, 0x0d6d,
        0x1add, 0x3f61, 0x27ab, 0x00a3, 0x11b3, 0x3000, 0x2bb4, 0x115d, 0x06a3, 0x10bd, 0x396e, 0x30a1, 0x109e, 0x0983, 0x3372, 0x37ad,
        0x0578, 0x3048, 0x3bd3, 0x130c, 0x1c36, 0x1b44, 0x02f8, 0x29bb, 0x2ed5, 0x0a2c, 0x07fc, 0x3744, 0x1b3c, 0x11f7, 0x1a8f, 0x3b24,
        0x0132, 0x359f, 0x2b30, 0x0488, 0x2e01, 0x3cf5, 0x0412, 0x084c, 0x0c42, 0x12ec, 0x0bec, 0x24ae, 0x223a, 0x16f6, 0x39f0, 0x122c,
        0x0160, 0x38e3, 0x160f, 0x09ac, 0x0c14, 0x03a2, 0x0013, 0x3edf, 0x204e, 0x03e4, 0x363c, 0x2d1c, 0x3d69, 0x3125, 0x1724, 0x14c0,
        0x105a, 0x1bca, 0x29e9, 0x07ce, 0x3f49, 0x2718, 0x1644, 0x193c, 0x3815, 0x08c1, 0x39b7, 0x35d8, 0x082a, 0x2d6b, 0x1c08, 0x261e,
        0x0008, 0x2b90, 0x217a, 0x0d46, 0x0d9c, 0x111b, 0x2143, 0x32dd, 0x3d87, 0x2b75, 0x2394, 0x0e33, 0x15d4, 0x3b4a, 0x3f29, 0x3e95,
        0x15cc, 0x056c, 0x1306, 0x213c, 0x35b4, 0x0d40, 0x2f5b, 0x26e5, 0x028c, 0x1eae, 0x1bb6, 0x327a, 0x04bc, 0x30fc, 0x2311, 0x2c8a,
        0x06d2, 0x0076, 0x270e, 0x3e55, 0x1f3e, 0x0f1e, 0x1b81, 0x3d2d, 0x3480, 0x0452, 0x0585, 0x1ab7, 0x1186, 0x3dd4, 0x1d90, 0x0914,
        0x2891, 0x1a32, 0x1c96, 0x2baa, 0x02dc, 0x1be9, 0x3941, 0x3697, 0x25c0, 0x2e82, 0x27e9, 0x0956, 0x302f, 0x328e, 0x3bae, 0x1665,
        0x0aea, 0x1da5, 0x3ec3, 0x35ba, 0x025e, 0x187e, 0x0146, 0x0f57, 0x10d4, 0x2f2d, 0x086a, 0x3796, 0x21a8, 0x1e5b, 0x3a23, 0x20b6,
        0x02ba, 0x0097, 0x2001, 0x2366, 0x20ae, 0x3025, 0x22ba, 0x1769, 0x3447, 0x016d, 0x0368, 0x0f9e, 0x0351, 0x3cb6, 0x0d6e, 0x13d5,
        0x1ade, 0x179e, 0x3f62, 0x072b, 0x27ac, 0x3b66, 0x00a4, 0x1c68, 0x11b4, 0x19c3, 0x3001, 0x185e, 0x2bb5, 0x2a20, 0x115e, 0x2b43,
        0x06a4, 0x0d33, 0x10be, 0x3b11, 0x396f, 0x09fa, 0x30a2, 0x16ed, 0x109f, 0x0dbe, 0x0984, 0x0242, 0x3373, 0x1d62, 0x37ae, 0x0268,
        0x0579, 0x2d0e, 0x3049, 0x26eb, 0x3bd4, 0x26b4, 0x130d, 0x0a5e, 0x1c37, 0x049b, 0x1b45, 0x2102, 0x02f9, 0x2c47, 0x29bc, 0x2905,
        0x2ed6, 0x2882, 0x0a2d, 0x3ac8, 0x07fd, 0x1841, 0x3745, 0x2127, 0x1b3d, 0x35ab, 0x11f8, 0x1877, 0x1a90, 0x34cc, 0x3b25, 0x08a8,
        0x0133, 0x0120, 0x35a0, 0x0c2e, 0x2b31, 0x04aa, 0x0489, 0x2d5a, 0x2e02, 0x2b20, 0x3cf6, 0x2207, 0x0413, 0x3eb2, 0x084d, 0x1a21,
        0x0c43, 0x081b, 0x12ed, 0x2c7f, 0x0bed, 0x20f2, 0x24af, 0x03b7, 0x223b, 0x2301, 0x16f7, 0x1760, 0x39f1, 0x2a10, 0x122d, 0x0af6,
        0x0161, 0x3d1f, 0x38e4, 0x2f61, 0x1610, 0x11ff, 0x09ad, 0x0ef5, 0x0c15, 0x172d, 0x03a3, 0x162f, 0x0014, 0x3613, 0x3ee0, 0x0b0e,
        0x204f, 0x20a0, 0x03e5, 0x04d4, 0x363d, 0x0615, 0x2d1d, 0x2218, 0x3d6a, 0x16cf, 0x3126, 0x370d, 0x1725, 0x0a24, 0x14c1, 0x3572,
        0x105b, 0x3d11, 0x1bcb, 0x0435, 0x29ea, 0x06b7, 0x07cf, 0x01b4, 0x3f4a, 0x3f94, 0x2719, 0x11ca, 0x1645, 0x3188, 0x193d, 0x0ddb,
        0x3816, 0x12df, 0x08c2, 0x1a3f, 0x39b8, 0x284e, 0x35d9, 0x08d9, 0x082b, 0x00ae, 0x2d6c, 0x2572, 0x1c09, 0x282b, 0x261f, 0x2097,
        0x0009, 0x2609, 0x2b91, 0x1eb4, 0x217b, 0x2e1a, 0x0d47, 0x2d9d, 0x0d9d, 0x3769, 0x111c, 0x0620, 0x2144, 0x2ae4, 0x32de, 0x1447,
        0x3d88, 0x085f, 0x2b76, 0x1851, 0x2395, 0x1fb1, 0x0e34, 0x0052, 0x15d5, 0x0e4b, 0x3b4b, 0x3ca0, 0x3f2a, 0x1387, 0x3e96, 0x2dc0,
        0x15cd, 0x02f2, 0x056d, 0x0284, 0x1307, 0x09a7, 0x213d, 0x0140, 0x35b5, 0x0726, 0x0d41, 0x3e50, 0x2f5c, 0x0430, 0x26e6, 0x0c29,
        0x028d, 0x134d, 0x1eaf, 0x027f, 0x1bb7, 0x068d, 0x327b, 0x36fa, 0x04bd, 0x05e3, 0x30fd, 0x0507, 0x2312, 0x173c, 0x2c8b, 0x1d0b,
        0x06d3, 0x1e28, 0x0077, 0x0292, 0x270f, 0x34d3, 0x3e56, 0x31a3, 0x1f3f, 0x1467, 0x0f1f, 0x3406, 0x1b82, 0x1a4b, 0x3d2e, 0x1771,
        0x3481, 0x1080, 0x0453, 0x2c3a, 0x0586, 0x2b16, 0x1ab8, 0x3b85, 0x1187, 0x17ac, 0x3dd5, 0x1c9f, 0x1d91, 0x1ba1, 0x0915, 0x1256,
        0x2892, 0x3ae4, 0x1a33, 0x1352, 0x1c97, 0x101e, 0x2bab, 0x0f96, 0x02dd, 0x22ec, 0x1bea, 0x1c41, 0x3942, 0x3c7f, 0x3698, 0x3143,
        0x25c1, 0x389f, 0x2e83, 0x2612, 0x27ea, 0x0a46, 0x0957, 0x090a, 0x3030, 0x278a, 0x328f, 0x1d35, 0x3baf, 0x3982, 0x1666, 0x0b87,
        0x0aeb, 0x3929, 0x1da6, 0x3280, 0x3ec4, 0x2c5d, 0x35bb, 0x2e59, 0x025f, 0x0fd0, 0x187f, 0x375a, 0x0147, 0x161b, 0x0f58, 0x2c26,
        0x10d5, 0x2e77, 0x2f2e, 0x3a15, 0x086b, 0x291f, 0x3797, 0x31b9, 0x21a9, 0x0bc5, 0x1e5c, 0x0a0d, 0x3a24, 0x2674, 0x20b7, 0x053f,
        0x02bb, 0x0e1a, 0x0098, 0x36ff, 0x2002, 0x1ec2, 0x2367, 0x3a3e, 0x20af, 0x0b07, 0x3026, 0x3b1d, 0x22bb, 0x1de9, 0x176a, 0x23fd,
        0x3448, 0x0d19, 0x016e, 0x2df4, 0x0369, 0x003b, 0x0f9f, 0x078f, 0x0352, 0x2699, 0x3cb7, 0x04fd, 0x0d6f, 0x0bcf, 0x13d6, 0x1db3,
        0x1adf, 0x1068, 0x179f, 0x1bbc, 0x3f63, 0x1a97, 0x072c, 0x2f82, 0x27ad, 0x357a, 0x3b67, 0x2873, 0x00a5, 0x1cd2, 0x1c69, 0x2404,
        0x11b5, 0x25fd, 0x19c4, 0x0d8d, 0x3002, 0x31f1, 0x185f, 0x1d25, 0x2bb6, 0x0929, 0x2a21, 0x16de, 0x115f, 0x30ab, 0x2b44, 0x2664,
        0x06a5, 0x3733, 0x0d34, 0x0692, 0x10bf, 0x11a0, 0x3b12, 0x108c, 0x3970, 0x32cc, 0x09fb, 0x395e, 0x30a3, 0x3d00, 0x16ee, 0x0a1c,
        0x10a0, 0x1f93, 0x0dbf, 0x2ec6, 0x0985, 0x34dc, 0x0243, 0x0425, 0x3374, 0x052e, 0x1d63, 0x3092, 0x37af, 0x2779, 0x0269, 0x110b,
        0x057a, 0x0baf, 0x2d0f, 0x3102, 0x304a, 0x12b8, 0x26ec, 0x08e4, 0x3bd5, 0x384f, 0x26b5, 0x315b, 0x130e, 0x1aeb, 0x0a5f, 0x168d,
        0x1c38, 0x0408, 0x049c, 0x2eb9, 0x1b46, 0x126a, 0x2103, 0x00bd, 0x02fa, 0x01fe, 0x2c48, 0x30e7, 0x29bd, 0x13a5, 0x2906, 0x0ccd,
        0x2ed7, 0x31fc, 0x2883, 0x050c, 0x0a2e, 0x206a, 0x3ac9, 0x366e, 0x07fe, 0x0ac6, 0x1842, 0x2420, 0x3746, 0x37ec, 0x2128, 0x1218,
        0x1b3e, 0x238d, 0x35ac, 0x0ade, 0x11f9, 0x26ae, 0x1878, 0x1115, 0x1a91, 0x2c57, 0x34cd, 0x2e14, 0x3b26, 0x3908, 0x08a9, 0x12b2,
        0x0134, 0x1bd7, 0x0121, 0x04c2, 0x35a1, 0x08af, 0x0c2f, 0x3800, 0x2b32, 0x1dd7, 0x04ab, 0x33f4, 0x048a, 0x0ec8, 0x2d5b, 0x22c2,
        0x2e03, 0x2414, 0x2b21, 0x1fa4, 0x3cf7, 0x311c, 0x2208, 0x1700, 0x0414, 0x3c09, 0x3eb3, 0x1026, 0x084e, 0x2350, 0x1a22, 0x215b,
        0x0c44, 0x0eda, 0x081c, 0x05e8, 0x12ee, 0x03c8, 0x2c80, 0x001e, 0x0bee, 0x02a0, 0x20f3, 0x333a, 0x24b0, 0x18dd, 0x03b8, 0x1490,
        0x223c, 0x0e86, 0x2302, 0x2b9e, 0x16f8, 0x3b7d, 0x1761, 0x0347, 0x39f2, 0x36e0, 0x2a11, 0x09c4, 0x122e, 0x2029, 0x0af7, 0x0fd9,
        0x0162, 0x07da, 0x3d20, 0x2c90, 0x38e5, 0x390e, 0x2f62, 0x22d4, 0x1611, 0x229d, 0x1200, 0x1330, 0x09ae, 0x07b4, 0x0ef6, 0x1360,
        0x0c16, 0x3567, 0x172e, 0x12a5, 0x03a4, 0x0084, 0x1630, 0x27d5, 0x0015, 0x1c5f, 0x3614, 0x24ee, 0x3ee1, 0x038a, 0x0b0f, 0x0f6c,
        0x2050, 0x28ad, 0x20a1, 0x1d10, 0x03e6, 0x0c9d, 0x04d5, 0x3f6e, 0x363e, 0x21da, 0x0616, 0x16ac, 0x2d1e, 0x246b, 0x2219, 0x00d9,
        0x3d6b, 0x30b5, 0x16d0, 0x047d, 0x3127, 0x34ed, 0x370e, 0x2f92, 0x1726, 0x2f26, 0x0a25, 0x1f35, 0x14c2, 0x1dd0, 0x3573, 0x1460,
        0x105c, 0x3a9b, 0x3d12, 0x2317, 0x1bcc, 0x3b2c, 0x0436, 0x3f11, 0x29eb, 0x14c9, 0x06b8, 0x3552, 0x07d0, 0x2634, 0x01b5, 0x1df0,
        0x3f4b, 0x2628, 0x3f95, 0x2943, 0x271a, 0x3f06, 0x11cb, 0x23cd, 0x1646, 0x2950, 0x3189, 0x349f, 0x193e, 0x3d08, 0x0ddc, 0x26c4,
        0x3817, 0x1947, 0x12e0, 0x1741, 0x08c3, 0x1eea, 0x1a40, 0x0229, 0x39b9, 0x0eb1, 0x284f, 0x06df, 0x35da, 0x1510, 0x08da, 0x2ce1,
        0x082c, 0x3fa3, 0x00af, 0x0609, 0x2d6d, 0x28d8, 0x2573, 0x2868, 0x1c0a, 0x1cdb, 0x282c, 0x14f4, 0x2620, 0x25f5, 0x2098, 0x3597,
        0x000a, 0x3b09, 0x260a, 0x2b96, 0x2b92, 0x0512, 0x1eb5, 0x2b67, 0x217c, 0x3623, 0x2e1b, 0x224d, 0x0d48, 0x1a66, 0x2d9e, 0x3ad5,
        0x0d9e, 0x28fb, 0x376a, 0x0516, 0x111d, 0x0b7b, 0x0621, 0x0976, 0x2145, 0x2dda, 0x2ae5, 0x2982, 0x32df, 0x13f4, 0x1448, 0x2e4a,
        0x3d89, 0x18bb, 0x0860, 0x1eb9, 0x2b77, 0x1cb3, 0x1852, 0x0dcd, 0x2396, 0x079b, 0x1fb2, 0x15ee, 0x0e35, 0x3e0d, 0x0053, 0x245c,
        0x15d6, 0x3253, 0x0e4c, 0x2b6b, 0x3b4c, 0x2501, 0x3ca1, 0x1a82, 0x3f2b, 0x1287, 0x1388, 0x1423, 0x3e97, 0x0c51, 0x2dc1, 0x33e5,
        0x15ce, 0x21a2, 0x02f3, 0x000e, 0x056e, 0x2889, 0x0285, 0x1b36, 0x1308, 0x0484, 0x09a8, 0x07ca, 0x213e, 0x1b7c, 0x0141, 0x009f,
        0x35b6, 0x2362, 0x0727, 0x3b0d, 0x0d42, 0x2138, 0x3e51, 0x2ba6, 0x2f5d, 0x04d0, 0x0431, 0x1a3b, 0x26e7, 0x3ac4, 0x0c2a, 0x2c7b,
        0x028e, 0x2c36, 0x134e, 0x260e, 0x1eb0, 0x184d, 0x0280, 0x027b, 0x1bb8, 0x0d89, 0x068e, 0x2ec2, 0x327c, 0x3a11, 0x36fb, 0x2df0,
        0x04be, 0x1fa0, 0x05e4, 0x2b9a, 0x30fe, 0x2eb5, 0x0508, 0x0ada, 0x2313, 0x293f, 0x173d, 0x0605, 0x2c8c, 0x12a1, 0x1d0c, 0x0479,
        0x06d4, 0x37c1, 0x1e29, 0x0d4c, 0x0078, 0x3202, 0x0293, 0x2e69, 0x2710, 0x2846, 0x34d4, 0x28d0, 0x3e57, 0x250e, 0x31a4, 0x3e80,
        0x1f40, 0x18d2, 0x1468, 0x1a6a, 0x0f20, 0x0bb9, 0x3407, 0x0d26, 0x1b83, 0x27cb, 0x1a4c, 0x280f, 0x3d2f, 0x18a2, 0x1772, 0x1e40,
        0x3482, 0x14de, 0x1081, 0x2da2, 0x0454, 0x3d92, 0x2c3b, 0x08fc, 0x0587, 0x1f70, 0x2b17, 0x21d1, 0x1ab9, 0x2a60, 0x3b86, 0x1893,
        0x1188, 0x225d, 0x17ad, 0x3ad9, 0x3dd6, 0x1817, 0x1ca0, 0x216d, 0x1d92, 0x2d47, 0x1ba2, 0x03fe, 0x0916, 0x1cf8, 0x1257, 0x05f6,
        0x2893, 0x19d2, 0x3ae5, 0x2180, 0x1a34, 0x2edd, 0x1353, 0x2342, 0x1c98, 0x16d7, 0x101f, 0x3498, 0x2bac, 0x24a7, 0x0f97, 0x3706,
        0x02de, 0x14fc, 0x22ed, 0x3627, 0x1beb, 0x09ef, 0x1c42, 0x211a, 0x3943, 0x3504, 0x3c80, 0x2ee4, 0x3699, 0x0a03, 0x3144, 0x3a5f,
        0x25c2, 0x2e99, 0x38a0, 0x2e1f, 0x2e84, 0x2282, 0x2613, 0x1f27, 0x27eb, 0x04e1, 0x0a47, 0x199c, 0x0958, 0x1709, 0x090b, 0x120f,
        0x3031, 0x064b, 0x278b, 0x2251, 0x3290, 0x3e5f, 0x1d36, 0x29dd, 0x3bb0, 0x3c23, 0x3983, 0x274c, 0x1667, 0x1c1e, 0x0b88, 0x137d,
        0x0aec, 0x3868, 0x392a, 0x1121, 0x1da7, 0x3674, 0x3281, 0x05b6, 0x3ec5, 0x0e56, 0x2c5e, 0x0746, 0x35bc, 0x2f3c, 0x2e5a, 0x182a,
        0x0260, 0x1bff, 0x0fd1, 0x0b7f, 0x1880, 0x0471, 0x375b, 0x205d, 0x0148, 0x38d0, 0x161c, 0x3dc1, 0x0f59, 0x36cd, 0x2c27, 0x0028,
        0x10d6, 0x123f, 0x2e78, 0x0625, 0x2f2f, 0x2373, 0x3a16, 0x1917, 0x086c, 0x3e23, 0x2920, 0x0770, 0x3798, 0x3659, 0x31ba, 0x0961,
        0x21aa, 0x1cef, 0x0bc6, 0x097a, 0x1e5d, 0x342b, 0x0a0e, 0x21fb, 0x3a25, 0x062f, 0x2675, 0x01e7, 0x20b8, 0x3537, 0x0540, 0x17dc,
        0x02bc, 0x1824, 0x0e1b, 0x0da2, 0x0099, 0x3acf, 0x3700, 0x3e7a, 0x2003, 0x30bc, 0x1ec3, 0x31c9, 0x2368, 0x3386, 0x3a3f, 0x02c2,
        0x20b0, 0x3e8f, 0x0b08, 0x28ff, 0x3027, 0x1050, 0x3b1e, 0x230a, 0x22bc, 0x1687, 0x1dea, 0x135a, 0x176b, 0x1441, 0x23fe, 0x2c20,
        0x3449, 0x0ce9, 0x0d1a, 0x376e, 0x016f, 0x0a7e, 0x2df5, 0x24f7, 0x036a, 0x3be0, 0x003c, 0x1901, 0x0fa0, 0x0c69, 0x0790, 0x25dc,
        0x0353, 0x178a, 0x269a, 0x051a, 0x3cb8, 0x141a, 0x04fe, 0x3d5e, 0x0d70, 0x2aa5, 0x0bd0, 0x1038, 0x13d7, 0x2992, 0x1db4, 0x1888,
        0x1ae0, 0x154b, 0x1069, 0x32e3, 0x17a0, 0x2070, 0x1bbd, 0x259b, 0x3f64, 0x2bdc, 0x1a98, 0x3c52, 0x072d, 0x0f36, 0x2f83, 0x0da8,
        0x27ae, 0x1325, 0x357b, 0x13f8, 0x3b68, 0x3110, 0x2874, 0x32bf, 0x00a6, 0x08b9, 0x1cd3, 0x0526, 0x1c6a, 0x3c1b, 0x2405, 0x00f0,
        0x11b6, 0x25a9, 0x25fe, 0x144c, 0x19c5, 0x0b5a, 0x0d8e, 0x3e6c, 0x3003, 0x0590, 0x31f2, 0x1d75, 0x1860, 0x054f, 0x1d26, 0x093a,
        0x2bb7, 0x1a02, 0x092a, 0x2e4e, 0x2a22, 0x030f, 0x16df, 0x1e4f, 0x1160, 0x19f9, 0x30ac, 0x0812, 0x2b45, 0x38ac, 0x2665, 0x3872,
        0x06a6, 0x2f14, 0x3734, 0x2149, 0x0d35, 0x0a34, 0x0693, 0x3a03, 0x10c0, 0x3d72, 0x11a1, 0x29a9, 0x3b13, 0x3176, 0x108d, 0x0e21,
        0x3971, 0x2834, 0x32cd, 0x2dde, 0x09fc, 0x3abd, 0x395f, 0x143a, 0x30a4, 0x1b9a, 0x3d01, 0x2349, 0x16ef, 0x3966, 0x0a1d, 0x3caf,
        0x10a1, 0x26cd, 0x1f94, 0x2ae9, 0x0dc0, 0x2f9e, 0x2ec7, 0x28c2, 0x0986, 0x3de9, 0x34dd, 0x017c, 0x0244, 0x1598, 0x0426, 0x0209,
        0x3375, 0x3824, 0x052f, 0x2986, 0x1d64, 0x2516, 0x3093, 0x3ba2, 0x37b0, 0x1c72, 0x277a, 0x24d6, 0x026a, 0x21f2, 0x110c, 0x368e,
        0x057b, 0x2916, 0x0bb0, 0x2b7b, 0x2d10, 0x2426, 0x3103, 0x1e7b, 0x304b, 0x330f, 0x12b9, 0x16b6, 0x26ed, 0x2c9e, 0x08e5, 0x338c,
        0x3bd6, 0x19b9, 0x3850, 0x1cb7, 0x26b6, 0x01a8, 0x315c, 0x3056, 0x130f, 0x0e04, 0x1aec, 0x3cdb, 0x0a60, 0x0b92, 0x168e, 0x1b1e,
        0x1c39, 0x3332, 0x0409, 0x1856, 0x049d, 0x0e93, 0x2eba, 0x18f9, 0x1b47, 0x0886, 0x126b, 0x13bd, 0x2104, 0x0213, 0x00be, 0x3a6e,
        0x02fb, 0x292b, 0x01ff, 0x0dd1, 0x2c49, 0x1dc3, 0x30e8, 0x358b, 0x29be, 0x05c4, 0x13a6, 0x3cc1, 0x2907, 0x2485, 0x0cce, 0x2523,
        0x2ed8, 0x227d, 0x31fd, 0x3d8d, 0x2884, 0x1848, 0x050d, 0x1cae, 0x0a2f, 0x2f99, 0x206b, 0x0b55, 0x3aca, 0x0a79, 0x366f, 0x236e,
        0x07ff, 0x142e, 0x0ac7, 0x18bf, 0x1843, 0x07f1, 0x2421, 0x0e8e, 0x3747, 0x3c6c, 0x37ed, 0x289a, 0x2129, 0x283b, 0x1219, 0x0bff,
        0x1b3f, 0x039d, 0x238e, 0x0864, 0x35ad, 0x07f6, 0x0adf, 0x3478, 0x11fa, 0x06b2, 0x26af, 0x04a5, 0x1879, 0x3b61, 0x1116, 0x0f19,
        0x1a92, 0x119b, 0x2c58, 0x1ebd, 0x34ce, 0x1019, 0x2e15, 0x09a2, 0x3b27, 0x1ee5, 0x3909, 0x0c98, 0x08aa, 0x03c3, 0x12b3, 0x2065,
        0x0135, 0x10f9, 0x1bd8, 0x0e39, 0x0122, 0x0acc, 0x04c3, 0x3ef4, 0x35a2, 0x1c56, 0x08b0, 0x2cfc, 0x0c30, 0x22a7, 0x3801, 0x02c8,
        0x2b33, 0x0e0f, 0x1dd8, 0x3e11, 0x04ac, 0x2b84, 0x33f5, 0x2270, 0x048b, 0x0e7c, 0x0ec9, 0x36a3, 0x2d5c, 0x1530, 0x22c3, 0x0fb8,
        0x2e04, 0x3415, 0x2415, 0x0057, 0x2b22, 0x18c4, 0x1fa5, 0x1fca, 0x3cf8, 0x1508, 0x311d, 0x3180, 0x2209, 0x1f59, 0x1701, 0x1590,
        0x0415, 0x36b5, 0x3c0a, 0x2460, 0x3eb4, 0x3892, 0x1027, 0x01f2, 0x084f, 0x24c1, 0x2351, 0x285e, 0x1a23, 0x21b3, 0x215c, 0x1000,
        0x0c45, 0x2ac3, 0x0edb, 0x239a, 0x081d, 0x0804, 0x05e9, 0x1f00, 0x12ef, 0x3715, 0x03c9, 0x243e, 0x2c81, 0x0cc4, 0x001f, 0x3a45,
        0x0bef, 0x1ce3, 0x02a1, 0x079f, 0x20f4, 0x10b2, 0x333b, 0x1fbd, 0x24b1, 0x031c, 0x18de, 0x19d9, 0x03b9, 0x3978, 0x1491, 0x1925,
        0x223d, 0x17c8, 0x0e87, 0x1fb6, 0x2303, 0x1433, 0x2b9f, 0x2113, 0x16f9, 0x23c6, 0x3b7e, 0x1d1e, 0x1762, 0x2211, 0x0348, 0x0845,
        0x39f3, 0x38f1, 0x36e1, 0x15f2, 0x2a12, 0x31ac, 0x09c5, 0x20e7, 0x122f, 0x00f8, 0x202a, 0x0fe4, 0x0af8, 0x3072, 0x0fda, 0x3088,
        0x0163, 0x167d, 0x07db, 0x3b50, 0x3d21, 0x121e, 0x2c91, 0x2ceb, 0x38e6, 0x0ea1, 0x390f, 0x0aa0, 0x2f63, 0x3604, 0x22d5, 0x30c2,
        0x1612, 0x1bac, 0x229e, 0x2505, 0x1201, 0x3438, 0x1331, 0x0b6e, 0x09af, 0x0997, 0x07b5, 0x1276, 0x0ef7, 0x1aa8, 0x1361, 0x3a4e,
        0x0c17, 0x1d7f, 0x3568, 0x3ca5, 0x172f, 0x0c04, 0x12a6, 0x174f, 0x03a5, 0x15fe, 0x0085, 0x26fc, 0x1631, 0x3ff0, 0x27d6, 0x1712,
        0x0016, 0x0f8e, 0x1c60, 0x1a86, 0x3615, 0x3470, 0x24ef, 0x0273, 0x3ee2, 0x2a00, 0x038b, 0x383e, 0x0b10, 0x3ed0, 0x0f6d, 0x2cd0,
        0x2051, 0x33d5, 0x28ae, 0x15da, 0x20a2, 0x212e, 0x1d11, 0x30d3, 0x03e7, 0x34f4, 0x0c9e, 0x0b22, 0x04d6, 0x2b07, 0x3f6f, 0x2009,
        0x363f, 0x2976, 0x21db, 0x3257, 0x0617, 0x1ad0, 0x16ad, 0x2244, 0x2d1f, 0x0461, 0x246c, 0x3aec, 0x221a, 0x2de5, 0x00da, 0x23e7,
        0x3d6c, 0x2bd6, 0x30b6, 0x0e50, 0x16d1, 0x2840, 0x047e, 0x361d, 0x3128, 0x33c5, 0x34ee, 0x0e9b, 0x370f, 0x1c50, 0x2f93, 0x3309,
        0x1727, 0x0495, 0x2f27, 0x2b6f, 0x0a26, 0x12ff, 0x1f36, 0x06c7, 0x14c3, 0x2297, 0x1dd1, 0x3849, 0x3574, 0x0fca, 0x1461, 0x3763,
        0x105d, 0x263e, 0x3a9c, 0x3e9b, 0x3d13, 0x37f2, 0x2318, 0x1564, 0x1bcd, 0x33cb, 0x3b2d, 0x1d44, 0x0437, 0x3063, 0x3f12, 0x31cf,
        0x29ec, 0x3198, 0x14ca, 0x0c55, 0x06b9, 0x11eb, 0x3553, 0x1b8d, 0x07d1, 0x2d05, 0x2635, 0x1542, 0x01b6, 0x3ccc, 0x1df1, 0x3221,
        0x3f4c, 0x0ab1, 0x2629, 0x2dc5, 0x3f96, 0x289f, 0x2944, 0x2be6, 0x271b, 0x1f79, 0x3f07, 0x1137, 0x11cc, 0x0f7f, 0x23ce, 0x2fdd,
        0x1647, 0x1169, 0x2951, 0x33e9, 0x318a, 0x3f87, 0x34a0, 0x31e5, 0x193f, 0x372b, 0x3d09, 0x38db, 0x0ddd, 0x17c0, 0x26c5, 0x2e91,
        0x3818, 0x2325, 0x1948, 0x3f2f, 0x12e1, 0x374c, 0x1742, 0x1141, 0x08c4, 0x312e, 0x1eeb, 0x2c0b, 0x1a41, 0x0a6f, 0x022a, 0x1ec9,
        0x39ba, 0x1c12, 0x0eb2, 0x128b, 0x2850, 0x3366, 0x06e0, 0x17cf, 0x35db, 0x0d01, 0x1511, 0x2187, 0x08db, 0x32d4, 0x2ce2, 0x05ad,
        0x082d, 0x0de5, 0x3fa4, 0x138c, 0x00b0, 0x3c71, 0x060a, 0x01d1, 0x2d6e, 0x3fb0, 0x28d9, 0x1800, 0x2574, 0x1f61, 0x2869, 0x2434,
        0x1c0b, 0x296f, 0x1cdc, 0x1427, 0x282d, 0x3e88, 0x14f5, 0x235b, 0x2621, 0x240d, 0x25f6, 0x1079, 0x2099, 0x0090, 0x3598, 0x0255,
        0x000b, 0x07c7, 0x3b0a, 0x1a38, 0x260b, 0x2ebf, 0x2b97, 0x0602, 0x2b93, 0x224a, 0x0513, 0x297f, 0x1eb6, 0x15eb, 0x2b68, 0x1420,
        0x217d, 0x3495, 0x3624, 0x2ee1, 0x2e1c, 0x1999, 0x224e, 0x2749, 0x0d49, 0x28cd, 0x1a67, 0x280c, 0x2d9f, 0x21ce, 0x3ad6, 0x03fb,
        0x0d9f, 0x31c6, 0x28fc, 0x1357, 0x376b, 0x18fe, 0x0517, 0x1035, 0x111e, 0x0743, 0x0b7c, 0x3dbe, 0x0622, 0x076d, 0x0977, 0x01e4,
        0x2146, 0x29a6, 0x2ddb, 0x2346, 0x2ae6, 0x0179, 0x2983, 0x24d3, 0x32e0, 0x3c4f, 0x13f5, 0x0523, 0x1449, 0x1d72, 0x2e4b, 0x080f,
        0x3d8a, 0x0b52, 0x18bc, 0x2897, 0x0861, 0x04a2, 0x1eba, 0x0c95, 0x2b78, 0x16b3, 0x1cb4, 0x3cd8, 0x1853, 0x13ba, 0x0dce, 0x3cbe,
        0x2397, 0x243b, 0x079c, 0x19d6, 0x1fb3, 0x1d1b, 0x15ef, 0x0fe1, 0x0e36, 0x2cf9, 0x3e0e, 0x36a0, 0x0054, 0x317d, 0x245d, 0x285b,
        0x15d7, 0x0b1f, 0x3254, 0x3ae9, 0x0e4d, 0x0e98, 0x2b6c, 0x3846, 0x3b4d, 0x0a9d, 0x2502, 0x1273, 0x3ca2, 0x26f9, 0x1a83, 0x383b,
        0x3f2c, 0x2c08, 0x1288, 0x2184, 0x1389, 0x17fd, 0x1424, 0x1076, 0x3e98, 0x1d41, 0x0c52, 0x153f, 0x2dc2, 0x1134, 0x33e6, 0x38d8,
        0x15cf, 0x1181, 0x21a3, 0x2bb0, 0x02f4, 0x040e, 0x000f, 0x1640, 0x056f, 0x1ad6, 0x288a, 0x0c3c, 0x0286, 0x3441, 0x1b37, 0x3d64,
        0x1309, 0x3741, 0x0485, 0x24ab, 0x09a9, 0x2d19, 0x07cb, 0x35d5, 0x213f, 0x2f57, 0x1b7d, 0x393d, 0x0142, 0x22b6, 0x00a0, 0x309e,
        0x35b7, 0x3793, 0x2363, 0x0f9b, 0x0728, 0x185b, 0x3b0e, 0x023f, 0x0d43, 0x0e30, 0x2139, 0x3277, 0x3e52, 0x1ab4, 0x2ba7, 0x0953,
        0x2f5e, 0x162c, 0x04d1, 0x370a, 0x0432, 0x11c7, 0x1a3c, 0x256f, 0x26e8, 0x20ff, 0x3ac5, 0x1874, 0x0c2b, 0x2204, 0x2c7c, 0x175d,
        0x028f, 0x3403, 0x2c37, 0x1c9c, 0x134f, 0x1c3e, 0x260f, 0x1d32, 0x1eb1, 0x061d, 0x184e, 0x3c9d, 0x0281, 0x3e4d, 0x027c, 0x0504,
        0x1bb9, 0x2870, 0x0d8a, 0x16db, 0x068f, 0x395b, 0x2ec3, 0x308f, 0x327d, 0x3757, 0x3a12, 0x0a0a, 0x36fc, 0x3b1a, 0x2df1, 0x04fa,
        0x04bf, 0x33f1, 0x1fa1, 0x1023, 0x05e5, 0x3337, 0x2b9b, 0x09c1, 0x30ff, 0x3158, 0x2eb6, 0x30e4, 0x0509, 0x241d, 0x0adb, 0x2e11,
        0x2314, 0x354f, 0x2940, 0x349c, 0x173e, 0x06dc, 0x0606, 0x14f1, 0x2c8d, 0x132d, 0x12a2, 0x24eb, 0x1d0d, 0x16a9, 0x047a, 0x1f32,
        0x06d5, 0x17f6, 0x37c2, 0x1bef, 0x1e2a, 0x00c3, 0x0d4d, 0x0d0a, 0x0079, 0x325d, 0x3203, 0x3b92, 0x0294, 0x3349, 0x2e6a, 0x1790,
        0x2711, 0x3634, 0x2847, 0x09f3, 0x34d5, 0x0a3f, 0x28d1, 0x3b76, 0x3e58, 0x2eae, 0x250f, 0x1413, 0x31a5, 0x1012, 0x3e81, 0x12f8,
        0x1f41, 0x3fc0, 0x18d3, 0x1c46, 0x1469, 0x3a73, 0x1a6b, 0x201a, 0x0f21, 0x0193, 0x0bba, 0x0f09, 0x3408, 0x17e8, 0x0d27, 0x0a50,
        0x1b84, 0x32b6, 0x27cc, 0x211e, 0x1a4d, 0x2a77, 0x2810, 0x24df, 0x3d30, 0x10e0, 0x18a3, 0x2db5, 0x1773, 0x2d3a, 0x1e41, 0x39aa,
        0x3483, 0x3242, 0x14df, 0x02e2, 0x1082, 0x2109, 0x2da3, 0x0443, 0x0455, 0x21e1, 0x3d93, 0x2f72, 0x2c3c, 0x3db0, 0x08fd, 0x0359,
        0x0588, 0x1f68, 0x1f71, 0x1500, 0x2b18, 0x1ff8, 0x21d2, 0x0aff, 0x1aba, 0x07e5, 0x2a61, 0x314b, 0x3b87, 0x0e28, 0x1894, 0x39e2,
        0x1189, 0x0b9e, 0x225e, 0x22f1, 0x17ae, 0x0218, 0x3ada, 0x0393, 0x3dd7, 0x1cc1, 0x1818, 0x13c5, 0x1ca1, 0x3e3f, 0x216e, 0x1176,
        0x1d93, 0x1c84, 0x2d48, 0x362b, 0x1ba3, 0x1bf6, 0x03ff, 0x0563, 0x0917, 0x3014, 0x1cf9, 0x1b70, 0x1258, 0x2c6e, 0x05f7, 0x0150,
        0x2894, 0x3cd5, 0x19d3, 0x369d, 0x3ae6, 0x1270, 0x2181, 0x153c, 0x1a35, 0x297c, 0x2ede, 0x2809, 0x1354, 0x3dbb, 0x2343, 0x0520,
        0x1c99, 0x3c9a, 0x16d8, 0x0a07, 0x1020, 0x30e1, 0x3499, 0x24e8, 0x2bad, 0x0c39, 0x24a8, 0x393a, 0x0f98, 0x3274, 0x3707, 0x1871,
        0x02df, 0x2f6f, 0x14fd, 0x3148, 0x22ee, 0x13c2, 0x3628, 0x1b6d, 0x1bec, 0x3b8f, 0x09f0, 0x1410, 0x1c43, 0x0f06, 0x211b, 0x2db2,
        0x3944, 0x387b, 0x3505, 0x3a63, 0x3c81, 0x09d0, 0x2ee5, 0x21c2, 0x369a, 0x2806, 0x0a04, 0x3937, 0x3145, 0x140d, 0x3a60, 0x3934,
        0x25c3, 0x0b33, 0x2e9a, 0x3947, 0x38a1, 0x1b4c, 0x2e20, 0x0df5, 0x2e85, 0x3645, 0x2283, 0x387e, 0x2614, 0x1373, 0x1f28, 0x26a0,
        0x27ec, 0x257b, 0x04e2, 0x3508, 0x0a48, 0x01dc, 0x199d, 0x3079, 0x0959, 0x2454, 0x170a, 0x3a66, 0x090c, 0x1094, 0x1210, 0x0c21,
        0x3032, 0x2959, 0x064c, 0x3c84, 0x278c, 0x088b, 0x2252, 0x3357, 0x3291, 0x0667, 0x3e60, 0x09d3, 0x1d37, 0x005f, 0x29de, 0x2935,
        0x3bb1, 0x2a30, 0x3c24, 0x2ee8, 0x3984, 0x37c9, 0x274d, 0x1a77, 0x1668, 0x27b6, 0x1c1f, 0x21c5, 0x0b89, 0x13eb, 0x137e, 0x2042,
        0x0aed, 0x1457, 0x3869, 0x2e88, 0x392b, 0x30ed, 0x1122, 0x2b56, 0x1da8, 0x23ed, 0x3675, 0x3648, 0x3282, 0x114f, 0x05b7, 0x2998,
        0x3ec6, 0x38fe, 0x0e57, 0x2286, 0x2c5f, 0x2563, 0x0747, 0x3210, 0x35bd, 0x05d8, 0x2f3d, 0x3881, 0x2e5b, 0x1c28, 0x182b, 0x18ae,
        0x0261, 0x2090, 0x1c00, 0x2617, 0x0fd2, 0x3590, 0x0b80, 0x1104, 0x1881, 0x3687, 0x0472, 0x1376, 0x375c, 0x024e, 0x205e, 0x3081,
        0x0149, 0x203b, 0x38d1, 0x1f2b, 0x161d, 0x2229, 0x3dc2, 0x0d5c, 0x0f5a, 0x35c8, 0x36ce, 0x26a3, 0x2c28, 0x15bb, 0x0029, 0x071a,
        0x10d7, 0x2a95, 0x1240, 0x25c6, 0x2e79, 0x2c4e, 0x0626, 0x29f7, 0x2f30, 0x00e0, 0x2374, 0x0b36, 0x3a17, 0x0234, 0x1918, 0x13dd,
        0x086d, 0x1807, 0x3e24, 0x2e9d, 0x2921, 0x1343, 0x0771, 0x2031, 0x3799, 0x3afd, 0x365a, 0x394a, 0x31bb, 0x3d79, 0x0962, 0x2335,
        0x21ab, 0x17b8, 0x1cf0, 0x38a4, 0x0bc7, 0x1dc8, 0x097b, 0x2a08, 0x1e5e, 0x1e6b, 0x342c, 0x1b4f, 0x0a0f, 0x34be, 0x21fc, 0x1405,
        0x3a26, 0x3fe0, 0x0630, 0x2e23, 0x2676, 0x00ca, 0x01e8, 0x0785, 0x20b9, 0x2bfb, 0x3538, 0x0df8, 0x0541, 0x192f, 0x17dd, 0x3dc9,
        0x02bd, 0x25d7, 0x1825, 0x095c, 0x0e1c, 0x0204, 0x0da3, 0x0935, 0x009a, 0x2deb, 0x3ad0, 0x2457, 0x3701, 0x120a, 0x3e7b, 0x188e,
        0x2004, 0x3304, 0x30bd, 0x170d, 0x1ec4, 0x242f, 0x31ca, 0x2fd8, 0x2369, 0x0f14, 0x3387, 0x3a69, 0x3a40, 0x0840, 0x02c3, 0x158b,
        0x20b1, 0x2b3e, 0x3e90, 0x090f, 0x0b09, 0x0dd6, 0x2900, 0x1a1c, 0x3028, 0x39ea, 0x1051, 0x1097, 0x3b1f, 0x14bb, 0x230b, 0x0d68,
        0x22bd, 0x148b, 0x1688, 0x1213, 0x1deb, 0x2cdc, 0x135b, 0x00d4, 0x176c, 0x313e, 0x1442, 0x0c24, 0x23ff, 0x0a17, 0x2c21, 0x23f8,
        0x344a, 0x2649, 0x0cea, 0x27ef, 0x0d1b, 0x0300, 0x376f, 0x33a3, 0x0170, 0x2220, 0x0a7f, 0x257e, 0x2df6, 0x0684, 0x24f8, 0x1dba,
        0x036b, 0x28e0, 0x3be1, 0x04e5, 0x003d, 0x28f0, 0x1902, 0x0feb, 0x0fa1, 0x1f1b, 0x0c6a, 0x350b, 0x0791, 0x10c7, 0x25dd, 0x0739,
        0x0354, 0x1171, 0x178b, 0x0a4b, 0x269b, 0x2930, 0x051b, 0x2dad, 0x3cb9, 0x3836, 0x141b, 0x01df, 0x04ff, 0x2e0c, 0x3d5f, 0x094e,
        0x0d71, 0x3da0, 0x2aa6, 0x19a0, 0x0bd1, 0x1e31, 0x1039, 0x36c2, 0x13d8, 0x1400, 0x2993, 0x307c, 0x1db5, 0x0949, 0x1889, 0x0d63,
        0x1ae1, 0x35fa, 0x154c, 0x3294, 0x106a, 0x0cd3, 0x32e4, 0x35e4, 0x17a1, 0x3af2, 0x2071, 0x066a, 0x1bbe, 0x1556, 0x259c, 0x2aab,
        0x3f65, 0x2d51, 0x2bdd, 0x3e63, 0x1a99, 0x1b64, 0x3c53, 0x1e0b, 0x072e, 0x2659, 0x0f37, 0x09d6, 0x2f84, 0x281f, 0x0da9, 0x371e,
        0x27af, 0x300d, 0x1326, 0x1d3a, 0x357c, 0x2528, 0x13f9, 0x2bf4, 0x3b69, 0x2685, 0x3111, 0x0062, 0x2875, 0x2bc8, 0x32c0, 0x19a5,
        0x00a7, 0x0db7, 0x08ba, 0x29e1, 0x1cd4, 0x36d9, 0x0527, 0x2783, 0x1c6b, 0x2a9e, 0x3c1c, 0x2938, 0x2406, 0x2290, 0x00f1, 0x1ede,
        0x11b7, 0x3b37, 0x25aa, 0x3035, 0x25ff, 0x290c, 0x144d, 0x3bf6, 0x19c6, 0x2472, 0x0b5b, 0x295c, 0x0d8f, 0x0b47, 0x3e6d, 0x0d76,
        0x3004, 0x3fb7, 0x0591, 0x064f, 0x31f3, 0x006d, 0x1d76, 0x1236, 0x1861, 0x316a, 0x0550, 0x3c87, 0x1d27, 0x29b0, 0x093b, 0x23da,
        0x2bb8, 0x1e97, 0x1a03, 0x278f, 0x092b, 0x248a, 0x2e4f, 0x3eea, 0x2a23, 0x196f, 0x0310, 0x088e, 0x16e0, 0x1f4b, 0x1e50, 0x3da5,
        0x1161, 0x36ad, 0x19fa, 0x2255, 0x30ad, 0x0d11, 0x0813, 0x3f59, 0x2b46, 0x252f, 0x38ad, 0x335a, 0x2666, 0x1483, 0x3873, 0x1624,
        0x06a7, 0x01bf, 0x2f15, 0x166b, 0x3735, 0x13ab, 0x214a, 0x0cb2, 0x0d36, 0x0467, 0x0a35, 0x27b9, 0x0694, 0x2e3c, 0x3a04, 0x103e,
        0x10c1, 0x083a, 0x3d73, 0x1c22, 0x11a2, 0x3268, 0x29aa, 0x2819, 0x3b14, 0x22b0, 0x3177, 0x21c8, 0x108e, 0x326e, 0x0e22, 0x100c,
        0x3972, 0x152a, 0x2835, 0x0b8c, 0x32ce, 0x3cc6, 0x2ddf, 0x1aa2, 0x09fd, 0x189c, 0x3abe, 0x13ee, 0x3960, 0x3c15, 0x143b, 0x36c7,
        0x30a5, 0x266e, 0x1b9b, 0x1381, 0x3d02, 0x0384, 0x234a, 0x139f, 0x16f0, 0x27e2, 0x3967, 0x2045, 0x0a1e, 0x34c6, 0x3cb0, 0x30f6,
        0x10a2, 0x1572, 0x26ce, 0x3bb4, 0x1f95, 0x29c3, 0x2aea, 0x2725, 0x0dc1, 0x2d25, 0x2f9f, 0x2a33, 0x2ec8, 0x2dd0, 0x28c3, 0x0bd6,
        0x0987, 0x2d75, 0x3dea, 0x3c27, 0x34de, 0x29d2, 0x017d, 0x00ff, 0x0245, 0x0764, 0x1599, 0x2eeb, 0x0427, 0x11a8, 0x020a, 0x3e04,
        0x3376, 0x164f, 0x3825, 0x3987, 0x0530, 0x05c9, 0x2987, 0x0702, 0x1d65, 0x253c, 0x2517, 0x37cc, 0x3094, 0x341d, 0x3ba3, 0x1e36,
        0x37b1, 0x1b02, 0x1c73, 0x2750, 0x277b, 0x0d54, 0x24d7, 0x24cb, 0x026b, 0x3583, 0x21f3, 0x1a7a, 0x110d, 0x36f2, 0x368f, 0x2230,
        0x057c, 0x1839, 0x2917, 0x007c, 0x0bb1, 0x3108, 0x2b7c, 0x11e3, 0x2d11, 0x30d9, 0x2427, 0x3260, 0x3104, 0x2fac, 0x1e7c, 0x0a84,
        0x304c, 0x0048, 0x3310, 0x3206, 0x12ba, 0x2fb0, 0x16b7, 0x1fd8, 0x26ee, 0x0be0, 0x2c9f, 0x3b95, 0x08e6, 0x27bf, 0x338d, 0x2fbc,
        0x3bd7, 0x33bc, 0x19ba, 0x0297, 0x3851, 0x1e80, 0x1cb8, 0x1966, 0x26b7, 0x25e7, 0x01a9, 0x334c, 0x315d, 0x2ef4, 0x3057, 0x2583,
        0x1310, 0x32fa, 0x0e05, 0x2e6d, 0x1aed, 0x0a88, 0x3cdc, 0x2758, 0x0a61, 0x0ee8, 0x0b93, 0x1793, 0x168f, 0x3235, 0x1b1f, 0x10ed,
        0x1c3a, 0x3957, 0x3333, 0x06d8, 0x040a, 0x2d15, 0x1857, 0x11c3, 0x049e, 0x1d17, 0x0e94, 0x17f9, 0x2ebb, 0x1995, 0x18fa, 0x0175,
        0x1b48, 0x01d8, 0x0887, 0x37c5, 0x126c, 0x30dd, 0x13be, 0x09cc, 0x2105, 0x1ff4, 0x0214, 0x1bf2, 0x00bf, 0x0a3b, 0x3a6f, 0x2a73,
        0x02fc, 0x28ec, 0x292c, 0x1e2d, 0x0200, 0x242b, 0x0dd2, 0x2cd8, 0x2c4a, 0x133f, 0x1dc4, 0x00c6, 0x30e9, 0x255f, 0x358c, 0x2225,
        0x29bf, 0x29ce, 0x05c5, 0x0d50, 0x13a7, 0x3264, 0x3cc2, 0x0380, 0x2908, 0x0069, 0x2486, 0x0d0d, 0x0ccf, 0x1b60, 0x2524, 0x36d5,
        0x2ed9, 0x09eb, 0x227e, 0x3e5b, 0x31fe, 0x0bb5, 0x3d8e, 0x1813, 0x2885, 0x2134, 0x1849, 0x2eb1, 0x050e, 0x0b77, 0x1caf, 0x24fd,
        0x0a30, 0x3ab9, 0x2f9a, 0x2512, 0x206c, 0x310c, 0x0b56, 0x030b, 0x3acb, 0x104c, 0x0a7a, 0x1416, 0x3670, 0x046d, 0x236f, 0x3427,
        0x0800, 0x10ae, 0x142f, 0x31a8, 0x0ac8, 0x2b80, 0x18c0, 0x388e, 0x1844, 0x07ed, 0x07f2, 0x1015, 0x2422, 0x01a4, 0x0e8f, 0x1dbf,
        0x3748, 0x3362, 0x3c6d, 0x3e84, 0x37ee, 0x11e7, 0x289b, 0x3f83, 0x212a, 0x1acc, 0x283c, 0x12fb, 0x121a, 0x3434, 0x0c00, 0x346c,
        0x1b40, 0x3cf1, 0x039e, 0x2714, 0x238f, 0x0580, 0x0865, 0x2ffc, 0x35ae, 0x20a8, 0x07f7, 0x3637, 0x0ae0, 0x02b2, 0x3479, 0x2dfb,
        0x11fb, 0x0611, 0x06b3, 0x284a, 0x26b0, 0x183d, 0x04a6, 0x20ee, 0x187a, 0x3021, 0x3b62, 0x09f6, 0x1117, 0x0d3c, 0x0f1a, 0x1be5,
        0x1a93, 0x31ed, 0x119c, 0x34d8, 0x2c59, 0x291b, 0x1ebe, 0x0037, 0x34cf, 0x2b12, 0x101a, 0x0a42, 0x2e16, 0x1fad, 0x09a3, 0x0689,
        0x3b28, 0x3f02, 0x1ee6, 0x28d4, 0x390a, 0x0080, 0x0c99, 0x34e9, 0x08ab, 0x3118, 0x03c4, 0x3b79, 0x12b4, 0x1266, 0x2066, 0x26aa,
        0x0136, 0x18ef, 0x10fa, 0x0f24, 0x1bd9, 0x08ea, 0x0e3a, 0x2190, 0x0123, 0x15e0, 0x0acd, 0x0196, 0x04c4, 0x2cbe, 0x3ef5, 0x0cef,
        0x35a3, 0x1c8d, 0x1c57, 0x0bbd, 0x08b1, 0x27c3, 0x2cfd, 0x0e74, 0x0c31, 0x2f4f, 0x22a8, 0x0f0c, 0x3802, 0x1044, 0x02c9, 0x03d2,
        0x2b34, 0x0658, 0x0e10, 0x340b, 0x1dd9, 0x3391, 0x3e12, 0x207e, 0x04ad, 0x2499, 0x2b85, 0x17eb, 0x33f6, 0x39d0, 0x2271, 0x27f4,
        0x048c, 0x1781, 0x0e7d, 0x0d2a, 0x0eca, 0x2fc0, 0x36a4, 0x1c7b, 0x2d5d, 0x1249, 0x1531, 0x0a53, 0x22c4, 0x1f0e, 0x0fb9, 0x2afb,
        0x2e05, 0x34b7, 0x3416, 0x1f44, 0x2416, 0x26f2, 0x0058, 0x3e38, 0x2b23, 0x28b4, 0x18c5, 0x3fc3, 0x1fa6, 0x2558, 0x1fcb, 0x344f,
        0x3cf9, 0x3c78, 0x1509, 0x18d6, 0x311e, 0x0be4, 0x3181, 0x2a19, 0x220a, 0x3b5a, 0x1f5a, 0x1c49, 0x1702, 0x3a0a, 0x1591, 0x0c62,
        0x0416, 0x3fd1, 0x36b6, 0x146c, 0x3c0b, 0x2ca3, 0x2461, 0x0f75, 0x3eb5, 0x385a, 0x3893, 0x3a76, 0x1028, 0x3456, 0x01f3, 0x264e,
        0x0850, 0x2fc9, 0x24c2, 0x1a6e, 0x2352, 0x3b99, 0x285f, 0x08d0, 0x1a24, 0x268c, 0x21b4, 0x201d, 0x215d, 0x070d, 0x1001, 0x0f61,
        0x0c46, 0x322a, 0x2ac4, 0x3d33, 0x0edc, 0x12be, 0x239b, 0x3a84, 0x081e, 0x33db, 0x0805, 0x10e3, 0x05ea, 0x3518, 0x1f01, 0x3774,
        0x12f0, 0x03f3, 0x3716, 0x18a6, 0x03ca, 0x2fb4, 0x243f, 0x2a80, 0x2c82, 0x380a, 0x0cc5, 0x2db8, 0x0020, 0x2e42, 0x3a46, 0x1b16,
        0x0bf0, 0x23b2, 0x1ce4, 0x1776, 0x02a2, 0x16bb, 0x07a0, 0x1e14, 0x20f5, 0x1ac2, 0x10b3, 0x2d3d, 0x333c, 0x2d81, 0x1fbe, 0x33a8,
        0x24b2, 0x38b5, 0x031d, 0x1e44, 0x18df, 0x1fdc, 0x19da, 0x0328, 0x03ba, 0x1298, 0x3979, 0x39ad, 0x1492, 0x1b57, 0x1926, 0x112b,
        0x223e, 0x0b68, 0x17c9, 0x1b87, 0x0e88, 0x3050, 0x1fb7, 0x226a, 0x2304, 0x2057, 0x1434, 0x32b9, 0x2ba0, 0x0970, 0x2114, 0x0d20,
        0x16fa, 0x00b7, 0x23c7, 0x27cf, 0x3b7f, 0x004c, 0x1d1f, 0x31b3, 0x1763, 0x26df, 0x2212, 0x2121, 0x0349, 0x069a, 0x0846, 0x1d89,
        0x39f4, 0x34a8, 0x38f2, 0x1a50, 0x36e2, 0x3314, 0x15f3, 0x14a2, 0x2a13, 0x0e6e, 0x31ad, 0x2a7a, 0x09c6, 0x1fd2, 0x20e8, 0x0305,
        0x1230, 0x1e05, 0x00f9, 0x2813, 0x202b, 0x320a, 0x0fe5, 0x2fd2, 0x0af9, 0x3b70, 0x3073, 0x24e2, 0x0fdb, 0x2743, 0x3089, 0x35cf,
        0x0164, 0x3c00, 0x167e, 0x0458, 0x07dc, 0x3161, 0x3b51, 0x2764, 0x3d22, 0x200f, 0x121f, 0x21e4, 0x2c92, 0x2a48, 0x2cec, 0x0c6f,
        0x38e7, 0x1f89, 0x0ea2, 0x3d96, 0x3910, 0x2ef8, 0x0aa1, 0x331a, 0x2f64, 0x0115, 0x3605, 0x2f75, 0x22d6, 0x1671, 0x30c3, 0x2a88,
        0x1613, 0x07ac, 0x1bad, 0x2c3f, 0x229f, 0x305b, 0x2506, 0x0f2e, 0x1202, 0x2e34, 0x3439, 0x3db3, 0x1332, 0x15a2, 0x0b6f, 0x3510,
        0x09b0, 0x077b, 0x0998, 0x0900, 0x07b6, 0x2587, 0x1277, 0x1b0a, 0x0ef8, 0x20da, 0x1aa9, 0x035c, 0x1362, 0x06ee, 0x3a4f, 0x38c4,
        0x0c18, 0x3dfb, 0x1d80, 0x3486, 0x3569, 0x26bb, 0x3ca6, 0x05a4, 0x1730, 0x3f75, 0x0c05, 0x3245, 0x12a7, 0x1ed3, 0x1750, 0x0fa6,
        0x03a6, 0x1393, 0x15ff, 0x14e2, 0x0086, 0x25eb, 0x26fd, 0x36e8, 0x1632, 0x2381, 0x3ff1, 0x02e5, 0x27d7, 0x2f1b, 0x1713, 0x1a0f,
        0x0017, 0x0222, 0x0f8f, 0x1085, 0x1c61, 0x01ad, 0x1a87, 0x3ed8, 0x3616, 0x01ca, 0x3471, 0x210c, 0x24f0, 0x28bb, 0x0274, 0x1f20,
        0x3ee3, 0x06fb, 0x2a01, 0x2da6, 0x038c, 0x3350, 0x383f, 0x09ba, 0x0b11, 0x19ac, 0x3ed1, 0x0446, 0x0f6e, 0x149b, 0x2cd1, 0x0030,
        0x2052, 0x0e69, 0x33d6, 0x1abd, 0x28af, 0x3855, 0x15db, 0x2494, 0x20a3, 0x2b0d, 0x212f, 0x07e8, 0x1d12, 0x133a, 0x30d4, 0x25e2,
        0x03e8, 0x131a, 0x34f5, 0x2a64, 0x0c9f, 0x1e84, 0x0b23, 0x14a8, 0x04d7, 0x03da, 0x2b08, 0x314e, 0x3f70, 0x01c5, 0x200a, 0x2e2f,
        0x3640, 0x0662, 0x2977, 0x3b8a, 0x21dc, 0x1cbc, 0x3258, 0x018e, 0x0618, 0x3153, 0x1ad1, 0x0e2b, 0x16ae, 0x0a98, 0x2245, 0x073e,
        0x2d20, 0x2537, 0x0462, 0x1897, 0x246d, 0x196a, 0x3aed, 0x2680, 0x221b, 0x3831, 0x2de6, 0x39e5, 0x00db, 0x1e66, 0x23e8, 0x3682,
        0x3d6d, 0x3de4, 0x2bd7, 0x058b, 0x30b7, 0x3bdb, 0x0e51, 0x3e1e, 0x16d2, 0x04dc, 0x2841, 0x1f6b, 0x047f, 0x0d84, 0x361e, 0x0796,
        0x3129, 0x3fab, 0x33c6, 0x1f74, 0x34ef, 0x33c0, 0x0e9c, 0x15f9, 0x3710, 0x23c1, 0x1c51, 0x1503, 0x2f94, 0x06ad, 0x330a, 0x0881,
        0x1728, 0x3f8f, 0x0496, 0x2b1b, 0x2f28, 0x19be, 0x2b70, 0x044d, 0x0a27, 0x03df, 0x1300, 0x1ffb, 0x1f37, 0x2b2a, 0x06c8, 0x10cc,
        0x14c4, 0x0eac, 0x2298, 0x21d5, 0x1dd2, 0x029b, 0x384a, 0x0ac1, 0x3575, 0x32c7, 0x0fcb, 0x0b02, 0x1462, 0x22e7, 0x3764, 0x0721,
        0x105e, 0x2ab9, 0x263f, 0x3dda, 0x3a9d, 0x1693, 0x3e9c, 0x151a, 0x3d14, 0x0b28, 0x37f3, 0x1cc4, 0x2319, 0x329e, 0x1565, 0x3be6,
        0x1bce, 0x1d9c, 0x33cc, 0x181b, 0x3b2e, 0x3239, 0x1d45, 0x34ae, 0x0438, 0x0f4c, 0x3064, 0x13c8, 0x3f13, 0x0cb8, 0x31d0, 0x2447,
        0x29ed, 0x059a, 0x3199, 0x1ca4, 0x14cb, 0x1b23, 0x0c56, 0x3c3f, 0x06ba, 0x14ad, 0x11ec, 0x3e42, 0x3554, 0x0334, 0x1b8e, 0x04ea,
        0x07d2, 0x3921, 0x2d06, 0x2171, 0x2636, 0x10f1, 0x1543, 0x37b9, 0x01b7, 0x25cf, 0x3ccd, 0x1179, 0x1df2, 0x0e61, 0x3222, 0x09e3,
        0x3f4d, 0x1d4e, 0x0ab2, 0x118c, 0x262a, 0x0a65, 0x2dc6, 0x3aa9, 0x3f97, 0x0ca4, 0x28a0, 0x0ba1, 0x2945, 0x0759, 0x2be7, 0x0370,
        0x271c, 0x0dec, 0x1f7a, 0x2261, 0x3f08, 0x0eec, 0x1138, 0x39fa, 0x11cd, 0x276d, 0x0f80, 0x22f4, 0x23cf, 0x2150, 0x2fde, 0x399d,
        0x1648, 0x1e90, 0x116a, 0x17b1, 0x2952, 0x0b97, 0x33ea, 0x0b18, 0x318b, 0x1e89, 0x3f88, 0x021b, 0x34a1, 0x3fca, 0x31e6, 0x28e5,
        0x1940, 0x0ed3, 0x372c, 0x3add, 0x3d0a, 0x1797, 0x38dc, 0x3bcb, 0x0dde, 0x2bcf, 0x17c1, 0x0396, 0x26c6, 0x0ce2, 0x2e92, 0x2c2f,
        0x3819, 0x1dfa, 0x2326, 0x091a, 0x1949, 0x1af1, 0x3f30, 0x2f04, 0x12e2, 0x34fa, 0x374d, 0x3017, 0x1743, 0x15aa, 0x1142, 0x1907,
        0x08c5, 0x3d53, 0x312f, 0x1cfc, 0x1eec, 0x0a8c, 0x2c0c, 0x1a56, 0x1a42, 0x02d1, 0x0a70, 0x1b73, 0x022b, 0x13b1, 0x1eca, 0x198c,
        0x39bb, 0x1955, 0x1c13, 0x125b, 0x0eb3, 0x3ce0, 0x128c, 0x3c5c, 0x2851, 0x2a69, 0x3367, 0x2c71, 0x06e1, 0x2cad, 0x17d0, 0x0ff0,
        0x35dc, 0x2b4e, 0x0d02, 0x05fa, 0x1512, 0x275c, 0x2188, 0x11db, 0x08dc, 0x2d95, 0x32d5, 0x0153, 0x2ce3, 0x1e73, 0x05ae, 0x2b5f,
        0x082e, 0x3d4d, 0x0de6, 0x1d96, 0x3fa5, 0x1314, 0x138d, 0x1f83, 0x00b1, 0x03ed, 0x3c72, 0x1c87, 0x060b, 0x3ab3, 0x01d2, 0x0042,
        0x2d6f, 0x0834, 0x3fb1, 0x2d4b, 0x28da, 0x32fe, 0x1801, 0x38f8, 0x2575, 0x3c94, 0x1f62, 0x362e, 0x286a, 0x373b, 0x2435, 0x348f,
        0x1c0c, 0x3192, 0x2970, 0x1ba6, 0x1cdd, 0x0e09, 0x1428, 0x19b3, 0x282e, 0x131f, 0x3e89, 0x1bf9, 0x14f6, 0x18cc, 0x235c, 0x28f5,
        0x2622, 0x3561, 0x240e, 0x0402, 0x25f7, 0x2e71, 0x107a, 0x0859, 0x209a, 0x287c, 0x0091, 0x0566, 0x3599, 0x2707, 0x0256, 0x15c2,
        0x000c, 0x1b34, 0x07c8, 0x009d, 0x3b0b, 0x2ba4, 0x1a39, 0x2c79, 0x260c, 0x0279, 0x2ec0, 0x2dee, 0x2b98, 0x0ad8, 0x0603, 0x0477,
        0x2b94, 0x2b65, 0x224b, 0x3ad3, 0x0514, 0x0974, 0x2980, 0x2e48, 0x1eb7, 0x0dcb, 0x15ec, 0x245a, 0x2b69, 0x1a80, 0x1421, 0x33e3,
        0x217e, 0x2340, 0x3496, 0x3704, 0x3625, 0x2118, 0x2ee2, 0x3a5d, 0x2e1d, 0x1f25, 0x199a, 0x120d, 0x224f, 0x29db, 0x274a, 0x137b,
        0x0d4a, 0x2e67, 0x28ce, 0x3e7e, 0x1a68, 0x0d24, 0x280d, 0x1e3e, 0x2da0, 0x08fa, 0x21cf, 0x1891, 0x3ad7, 0x216b, 0x03fc, 0x05f4,
        0x0da0, 0x3e78, 0x31c7, 0x02c0, 0x28fd, 0x2308, 0x1358, 0x2c1e, 0x376c, 0x24f5, 0x18ff, 0x25da, 0x0518, 0x3d5c, 0x1036, 0x1886,
        0x111f, 0x05b4, 0x0744, 0x1828, 0x0b7d, 0x205b, 0x3dbf, 0x0026, 0x0623, 0x1915, 0x076e, 0x095f, 0x0978, 0x21f9, 0x01e5, 0x17da,
        0x2147, 0x3a01, 0x29a7, 0x0e1f, 0x2ddc, 0x1438, 0x2347, 0x3cad, 0x2ae7, 0x28c0, 0x017a, 0x0207, 0x2984, 0x3ba0, 0x24d4, 0x368c,
        0x32e1, 0x2599, 0x3c50, 0x0da6, 0x13f6, 0x32bd, 0x0524, 0x00ee, 0x144a, 0x3e6a, 0x1d73, 0x0938, 0x2e4c, 0x1e4d, 0x0810, 0x3870,
        0x3d8b, 0x1cac, 0x0b53, 0x236c, 0x18bd, 0x0e8c, 0x2898, 0x0bfd, 0x0862, 0x3476, 0x04a3, 0x0f17, 0x1ebb, 0x09a0, 0x0c96, 0x2063,
        0x2b79, 0x1e79, 0x16b4, 0x338a, 0x1cb5, 0x3054, 0x3cd9, 0x1b1c, 0x1854, 0x18f7, 0x13bb, 0x3a6c, 0x0dcf, 0x3589, 0x3cbf, 0x2521,
        0x2398, 0x1efe, 0x243c, 0x3a43, 0x079d, 0x1fbb, 0x19d7, 0x1923, 0x1fb4, 0x2111, 0x1d1c, 0x0843, 0x15f0, 0x20e5, 0x0fe2, 0x3086,
        0x0e37, 0x3ef2, 0x2cfa, 0x02c6, 0x3e0f, 0x226e, 0x36a1, 0x0fb6, 0x0055, 0x1fc8, 0x317e, 0x158e, 0x245e, 0x01f0, 0x285c, 0x0ffe,
        0x15d8, 0x30d1, 0x0b20, 0x2007, 0x3255, 0x2242, 0x3aea, 0x23e5, 0x0e4e, 0x361b, 0x0e99, 0x3307, 0x2b6d, 0x06c5, 0x3847, 0x3761,
        0x3b4e, 0x2ce9, 0x0a9e, 0x30c0, 0x2503, 0x0b6c, 0x1274, 0x3a4c, 0x3ca3, 0x174d, 0x26fa, 0x1710, 0x1a84, 0x0271, 0x383c, 0x2cce,
        0x3f2d, 0x113f, 0x2c09, 0x1ec7, 0x1289, 0x17cd, 0x2185, 0x05ab, 0x138a, 0x01cf, 0x17fe, 0x2432, 0x1425, 0x2359, 0x1077, 0x0253,
        0x3e99, 0x1562, 0x1d42, 0x31cd, 0x0c53, 0x1b8b, 0x1540, 0x321f, 0x2dc3, 0x2be4, 0x1135, 0x2fdb, 0x33e7, 0x31e3, 0x38d9, 0x2e8f,
        0x15d0, 0x04b8, 0x1182, 0x302b, 0x21a4, 0x034d, 0x2bb1, 0x336f, 0x02f5, 0x1a8c, 0x040f, 0x39ed, 0x0010, 0x1721, 0x1641, 0x1c05,
        0x0570, 0x0159, 0x1ad7, 0x1054, 0x288b, 0x069e, 0x0c3d, 0x3810, 0x0287, 0x25bb, 0x3442, 0x109a, 0x1b38, 0x2236, 0x3d65, 0x0826,
        0x130a, 0x29b9, 0x3742, 0x3b22, 0x0486, 0x084a, 0x24ac, 0x122a, 0x09aa, 0x3edd, 0x2d1a, 0x14be, 0x07cc, 0x193a, 0x35d6, 0x261c,
        0x2140, 0x3f26, 0x2f58, 0x230e, 0x1b7e, 0x1d8d, 0x393e, 0x3bab, 0x0143, 0x3a20, 0x22b7, 0x0d6b, 0x00a1, 0x115b, 0x309f, 0x37ab,
        0x35b8, 0x0f55, 0x3794, 0x20b4, 0x2364, 0x1767, 0x0f9c, 0x13d3, 0x0729, 0x1c66, 0x185c, 0x2b41, 0x3b0f, 0x16eb, 0x0240, 0x0266,
        0x0d44, 0x32db, 0x0e31, 0x3e93, 0x213a, 0x26e3, 0x3278, 0x2c88, 0x3e53, 0x3d2b, 0x1ab5, 0x0912, 0x2ba8, 0x3695, 0x0954, 0x1663,
        0x2f5f, 0x0ef3, 0x162d, 0x0b0c, 0x04d2, 0x2216, 0x370b, 0x3570, 0x0433, 0x01b2, 0x11c8, 0x0dd9, 0x1a3d, 0x08d7, 0x2570, 0x2095,
        0x26e9, 0x0a5c, 0x2100, 0x2903, 0x3ac6, 0x2125, 0x1875, 0x08a6, 0x0c2c, 0x2d58, 0x2205, 0x1a1f, 0x2c7d, 0x03b5, 0x175e, 0x0af4,
        0x0290, 0x31a1, 0x3404, 0x176f, 0x2c38, 0x3b83, 0x1c9d, 0x1254, 0x1350, 0x0f94, 0x1c3f, 0x3141, 0x2610, 0x0908, 0x1d33, 0x0b85,
        0x1eb2, 0x2d9b, 0x061e, 0x1445, 0x184f, 0x0050, 0x3c9e, 0x2dbe, 0x0282, 0x013e, 0x3e4e, 0x0c27, 0x027d, 0x36f8, 0x0505, 0x1d09,
        0x1bba, 0x2f80, 0x2871, 0x2402, 0x0d8b, 0x1d23, 0x16dc, 0x2662, 0x0690, 0x108a, 0x395c, 0x0a1a, 0x2ec4, 0x0423, 0x3090, 0x1109,
        0x327e, 0x2e57, 0x3758, 0x2c24, 0x3a13, 0x31b7, 0x0a0b, 0x053d, 0x36fd, 0x3a3c, 0x3b1b, 0x23fb, 0x2df2, 0x078d, 0x04fb, 0x1db1,
        0x04c0, 0x37fe, 0x33f2, 0x22c0, 0x1fa2, 0x16fe, 0x1024, 0x2159, 0x05e6, 0x001c, 0x3338, 0x148e, 0x2b9c, 0x0345, 0x09c2, 0x0fd7,
        0x3100, 0x08e2, 0x3159, 0x168b, 0x2eb7, 0x00bb, 0x30e5, 0x0ccb, 0x050a, 0x366c, 0x241e, 0x1216, 0x0adc, 0x1113, 0x2e12, 0x12b0,
        0x2315, 0x3f0f, 0x3550, 0x1dee, 0x2941, 0x23cb, 0x349d, 0x26c2, 0x173f, 0x0227, 0x06dd, 0x2cdf, 0x0607, 0x2866, 0x14f2, 0x3595,
        0x2c8e, 0x22d2, 0x132e, 0x135e, 0x12a3, 0x27d3, 0x24ec, 0x0f6a, 0x1d0e, 0x3f6c, 0x16aa, 0x00d7, 0x047b, 0x2f90, 0x1f33, 0x145e,
        0x06d6, 0x11c1, 0x17f7, 0x0173, 0x37c3, 0x09ca, 0x1bf0, 0x2a71, 0x1e2b, 0x2cd6, 0x00c4, 0x2223, 0x0d4e, 0x037e, 0x0d0b, 0x36d3,
        0x007a, 0x11e1, 0x325e, 0x0a82, 0x3204, 0x1fd6, 0x3b93, 0x2fba, 0x0295, 0x1964, 0x334a, 0x2581, 0x2e6b, 0x2756, 0x1791, 0x10eb,
        0x2712, 0x2ffa, 0x3635, 0x2df9, 0x2848, 0x20ec, 0x09f4, 0x1be3, 0x34d6, 0x0035, 0x0a40, 0x0687, 0x28d2, 0x34e7, 0x3b77, 0x26a8,
        0x3e59, 0x1811, 0x2eaf, 0x24fb, 0x2510, 0x0309, 0x1414, 0x3425, 0x31a6, 0x388c, 0x1013, 0x1dbd, 0x3e82, 0x3f81, 0x12f9, 0x346a,
        0x1f42, 0x3e36, 0x3fc1, 0x344d, 0x18d4, 0x2a17, 0x1c47, 0x0c60, 0x146a, 0x0f73, 0x3a74, 0x264c, 0x1a6c, 0x08ce, 0x201b, 0x0f5f,
        0x0f22, 0x218e, 0x0194, 0x0ced, 0x0bbb, 0x0e72, 0x0f0a, 0x03d0, 0x3409, 0x207c, 0x17e9, 0x27f2, 0x0d28, 0x1c79, 0x0a51, 0x2af9,
        0x1b85, 0x2268, 0x32b7, 0x0d1e, 0x27cd, 0x31b1, 0x211f, 0x1d87, 0x1a4e, 0x14a0, 0x2a78, 0x0303, 0x2811, 0x2fd0, 0x24e0, 0x35cd,
        0x3d31, 0x3a82, 0x10e1, 0x3772, 0x18a4, 0x2a7e, 0x2db6, 0x1b14, 0x1774, 0x1e12, 0x2d3b, 0x33a6, 0x1e42, 0x0326, 0x39ab, 0x1129,
        0x3484, 0x05a2, 0x3243, 0x0fa4, 0x14e0, 0x36e6, 0x02e3, 0x1a0d, 0x1083, 0x3ed6, 0x210a, 0x1f1e, 0x2da4, 0x09b8, 0x0444, 0x002e,
        0x0456, 0x2762, 0x21e2, 0x0c6d, 0x3d94, 0x3318, 0x2f73, 0x2a86, 0x2c3d, 0x0f2c, 0x3db1, 0x350e, 0x08fe, 0x1b08, 0x035a, 0x38c2,
        0x0589, 0x3e1c, 0x1f69, 0x0794, 0x1f72, 0x15f7, 0x1501, 0x087f, 0x2b19, 0x044b, 0x1ff9, 0x10ca, 0x21d3, 0x0abf, 0x0b00, 0x071f,
        0x1abb, 0x2492, 0x07e6, 0x25e0, 0x2a62, 0x14a6, 0x314c, 0x2e2d, 0x3b88, 0x018c, 0x0e29, 0x073c, 0x1895, 0x267e, 0x39e3, 0x3680,
        0x118a, 0x3aa7, 0x0b9f, 0x036e, 0x225f, 0x39f8, 0x22f2, 0x399b, 0x17af, 0x0b16, 0x0219, 0x28e3, 0x3adb, 0x3bc9, 0x0394, 0x2c2d,
        0x3dd8, 0x1518, 0x1cc2, 0x3be4, 0x1819, 0x34ac, 0x13c6, 0x2445, 0x1ca2, 0x3c3d, 0x3e40, 0x04e8, 0x216f, 0x37b7, 0x1177, 0x09e1,
        0x1d94, 0x1f81, 0x1c85, 0x0040, 0x2d49, 0x38f6, 0x362c, 0x348d, 0x1ba4, 0x19b1, 0x1bf7, 0x28f3, 0x0400, 0x0857, 0x0564, 0x15c0,
        0x0918, 0x2f02, 0x3015, 0x1905, 0x1cfa, 0x1a54, 0x1b71, 0x198a, 0x1259, 0x3c5a, 0x2c6f, 0x0fee, 0x05f8, 0x11d9, 0x0151, 0x2b5d,
        0x2895, 0x0c93, 0x3cd6, 0x3cbc, 0x19d4, 0x0fdf, 0x369e, 0x2859, 0x3ae7, 0x3844, 0x1271, 0x3839, 0x2182, 0x1074, 0x153d, 0x38d6,
        0x1a36, 0x0600, 0x297d, 0x141e, 0x2edf, 0x2747, 0x280a, 0x03f9, 0x1355, 0x1033, 0x3dbc, 0x01e2, 0x2344, 0x24d1, 0x0521, 0x080d,
        0x1c9a, 0x1d30, 0x3c9b, 0x0502, 0x16d9, 0x308d, 0x0a08, 0x04f8, 0x1021, 0x09bf, 0x30e2, 0x2e0f, 0x349a, 0x14ef, 0x24e9, 0x1f30,
        0x2bae, 0x163e, 0x0c3a, 0x3d62, 0x24a9, 0x35d3, 0x393b, 0x309c, 0x0f99, 0x023d, 0x3275, 0x0951, 0x3708, 0x256d, 0x1872, 0x175b,
        0x02e0, 0x0441, 0x2f70, 0x0357, 0x14fe, 0x0afd, 0x3149, 0x39e0, 0x22ef, 0x0391, 0x13c3, 0x1174, 0x3629, 0x0561, 0x1b6e, 0x014e,
        0x1bed, 0x0d08, 0x3b90, 0x178e, 0x09f1, 0x3b74, 0x1411, 0x12f6, 0x1c44, 0x2018, 0x0f07, 0x0a4e, 0x211c, 0x24dd, 0x2db3, 0x39a8,
        0x3945, 0x0df3, 0x387c, 0x269e, 0x3506, 0x3077, 0x3a64, 0x0c1f, 0x3c82, 0x3355, 0x09d1, 0x2933, 0x2ee6, 0x1a75, 0x21c3, 0x2040,
        0x369b, 0x153a, 0x2807, 0x051e, 0x0a05, 0x24e6, 0x3938, 0x186f, 0x3146, 0x1b6b, 0x140e, 0x2db0, 0x3a61, 0x21c0, 0x3935, 0x3932,
        0x25c4, 0x29f5, 0x0b34, 0x13db, 0x2e9b, 0x202f, 0x3948, 0x2333, 0x38a2, 0x2a06, 0x1b4d, 0x1403, 0x2e21, 0x0783, 0x0df6, 0x3dc7,
        0x2e86, 0x2b54, 0x3646, 0x2996, 0x2284, 0x320e, 0x387f, 0x18ac, 0x2615, 0x1102, 0x1374, 0x307f, 0x1f29, 0x0d5a, 0x26a1, 0x0718,
        0x27ed, 0x33a1, 0x257c, 0x1db8, 0x04e3, 0x0fe9, 0x3509, 0x0737, 0x0a49, 0x2dab, 0x01dd, 0x094c, 0x199e, 0x36c0, 0x307a, 0x0d61,
        0x095a, 0x0933, 0x2455, 0x188c, 0x170b, 0x2fd6, 0x3a67, 0x1589, 0x090d, 0x1a1a, 0x1095, 0x0d66, 0x1211, 0x00d2, 0x0c22, 0x23f6,
        0x3033, 0x3bf4, 0x295a, 0x0d74, 0x064d, 0x1234, 0x3c85, 0x23d8, 0x278d, 0x3ee8, 0x088c, 0x3da3, 0x2253, 0x3f57, 0x3358, 0x1622,
        0x3292, 0x35e2, 0x0668, 0x2aa9, 0x3e61, 0x1e09, 0x09d4, 0x371c, 0x1d38, 0x2bf2, 0x0060, 0x19a3, 0x29df, 0x2781, 0x2936, 0x1edc,
        0x3bb2, 0x2723, 0x2a31, 0x0bd4, 0x3c25, 0x00fd, 0x2ee9, 0x3e02, 0x3985, 0x0700, 0x37ca, 0x1e34, 0x274e, 0x24c9, 0x1a78, 0x222e,
        0x1669, 0x0cb0, 0x27b7, 0x103c, 0x1c20, 0x2817, 0x21c6, 0x100a, 0x0b8a, 0x1aa0, 0x13ec, 0x36c5, 0x137f, 0x139d, 0x2043, 0x30f4,
        0x0aee, 0x37a5, 0x1458, 0x1dab, 0x386a, 0x05ee, 0x2e89, 0x0ff8, 0x392c, 0x1755, 0x30ee, 0x23f0, 0x1123, 0x3464, 0x2b57, 0x367a,
        0x1da9, 0x0ff6, 0x23ee, 0x3678, 0x3676, 0x351c, 0x3649, 0x351e, 0x3283, 0x2d2f, 0x1150, 0x364b, 0x05b8, 0x37d2, 0x2999, 0x3520,
        0x3ec7, 0x352e, 0x38ff, 0x3285, 0x0e58, 0x1f05, 0x2287, 0x2d31, 0x2c60, 0x0fab, 0x2564, 0x1152, 0x0748, 0x0108, 0x3211, 0x364d,
        0x35be, 0x20d0, 0x05d9, 0x05ba, 0x2f3e, 0x3778, 0x3882, 0x37d4, 0x2e5c, 0x254a, 0x1c29, 0x299b, 0x182c, 0x2acf, 0x18af, 0x3522,
        0x0262, 0x165f, 0x2091, 0x0af0, 0x1c01, 0x0822, 0x2618, 0x37a7, 0x0fd3, 0x12ac, 0x3591, 0x145a, 0x0b81, 0x1d05, 0x1105, 0x1dad,
        0x1882, 0x17d6, 0x3688, 0x386c, 0x0473, 0x33df, 0x1377, 0x05f0, 0x375d, 0x2cca, 0x024f, 0x2e8b, 0x205f, 0x251d, 0x3082, 0x0ffa,
        0x014a, 0x39a4, 0x203c, 0x392e, 0x38d2, 0x0809, 0x1f2c, 0x1757, 0x161e, 0x1ed8, 0x222a, 0x30f0, 0x3dc3, 0x0714, 0x0d5d, 0x23f2,
        0x0f5b, 0x2af5, 0x35c9, 0x1125, 0x36cf, 0x10e7, 0x26a4, 0x3466, 0x2c29, 0x09dd, 0x15bc, 0x2b59, 0x002a, 0x38be, 0x071b, 0x367c,
        0x10d8, 0x3c47, 0x2a96, 0x35c0, 0x1241, 0x0ee0, 0x25c7, 0x20d2, 0x2e7a, 0x0c0a, 0x2c4f, 0x05db, 0x0627, 0x127f, 0x29f8, 0x05bc,
        0x2f31, 0x2cb3, 0x00e1, 0x2f40, 0x2375, 0x12c2, 0x0b37, 0x377a, 0x3a18, 0x08f2, 0x0235, 0x3884, 0x1919, 0x2542, 0x13de, 0x37d6,
        0x086e, 0x20c7, 0x1808, 0x2e5e, 0x3e25, 0x239f, 0x2e9e, 0x254c, 0x2922, 0x324a, 0x1344, 0x1c2b, 0x0772, 0x32f1, 0x2032, 0x299d,
        0x379a, 0x2797, 0x3afe, 0x182e, 0x365b, 0x3a88, 0x394b, 0x2ad1, 0x31bc, 0x33b2, 0x3d7a, 0x18b1, 0x0963, 0x0638, 0x2336, 0x3524,
        0x21ac, 0x247e, 0x17b9, 0x3ec9, 0x1cf1, 0x0c4a, 0x38a5, 0x3530, 0x0bc8, 0x1735, 0x1dc9, 0x3901, 0x097c, 0x3f40, 0x2a09, 0x3287,
        0x1e5f, 0x06e7, 0x1e6c, 0x0e5a, 0x342d, 0x322e, 0x1b50, 0x1f07, 0x0a10, 0x15b4, 0x34bf, 0x2289, 0x21fd, 0x1d6b, 0x1406, 0x2d33,
        0x3a27, 0x2fe5, 0x3fe1, 0x2c62, 0x0631, 0x2ac8, 0x2e24, 0x0fad, 0x2677, 0x3f7a, 0x00cb, 0x2566, 0x01e9, 0x2164, 0x0786, 0x1154,
        0x20ba, 0x0c7d, 0x2bfc, 0x074a, 0x3539, 0x3d37, 0x0df9, 0x010a, 0x0542, 0x0f3e, 0x1930, 0x3213, 0x17de, 0x39c6, 0x3dca, 0x364f,
        0x02be, 0x2c1c, 0x25d8, 0x1884, 0x1826, 0x0024, 0x095d, 0x17d8, 0x0e1d, 0x3cab, 0x0205, 0x368a, 0x0da4, 0x00ec, 0x0936, 0x386e,
        0x009b, 0x2c77, 0x2dec, 0x0475, 0x3ad1, 0x2e46, 0x2458, 0x33e1, 0x3702, 0x3a5b, 0x120b, 0x1379, 0x3e7c, 0x1e3c, 0x188f, 0x05f2,
        0x2005, 0x23e3, 0x3305, 0x375f, 0x30be, 0x3a4a, 0x170e, 0x2ccc, 0x1ec5, 0x05a9, 0x2430, 0x0251, 0x31cb, 0x321d, 0x2fd9, 0x2e8d,
        0x236a, 0x0bfb, 0x0f15, 0x2061, 0x3388, 0x1b1a, 0x3a6a, 0x251f, 0x3a41, 0x1921, 0x0841, 0x3084, 0x02c4, 0x0fb4, 0x158c, 0x0ffc,
        0x20b2, 0x13d1, 0x2b3f, 0x0264, 0x3e91, 0x2c86, 0x0910, 0x1661, 0x0b0a, 0x356e, 0x0dd7, 0x2093, 0x2901, 0x08a4, 0x1a1d, 0x0af2,
        0x3029, 0x336d, 0x39eb, 0x1c03, 0x1052, 0x380e, 0x1098, 0x0824, 0x3b20, 0x1228, 0x14bc, 0x261a, 0x230c, 0x3ba9, 0x0d69, 0x37a9,
        0x22be, 0x2157, 0x148c, 0x0fd5, 0x1689, 0x0cc9, 0x1214, 0x12ae, 0x1dec, 0x26c0, 0x2cdd, 0x3593, 0x135c, 0x0f68, 0x00d5, 0x145c,
        0x176d, 0x1252, 0x313f, 0x0b83, 0x1443, 0x2dbc, 0x0c25, 0x1d07, 0x2400, 0x2660, 0x0a18, 0x1107, 0x2c22, 0x053b, 0x23f9, 0x1daf,
        0x344b, 0x0c5e, 0x264a, 0x0f5d, 0x0ceb, 0x03ce, 0x27f0, 0x2af7, 0x0d1c, 0x1d85, 0x0301, 0x35cb, 0x3770, 0x1b12, 0x33a4, 0x1127,
        0x0171, 0x2a6f, 0x2221, 0x36d1, 0x0a80, 0x2fb8, 0x257f, 0x10e9, 0x2df7, 0x1be1, 0x0685, 0x26a6, 0x24f9, 0x3423, 0x1dbb, 0x3468,
        0x036c, 0x3999, 0x28e1, 0x2c2b, 0x3be2, 0x2443, 0x04e6, 0x09df, 0x003e, 0x348b, 0x28f1, 0x15be, 0x1903, 0x1988, 0x0fec, 0x2b5b,
        0x0fa2, 0x1a0b, 0x1f1c, 0x002c, 0x0c6b, 0x2a84, 0x350c, 0x38c0, 0x0792, 0x087d, 0x10c8, 0x071d, 0x25de, 0x2e2b, 0x073a, 0x367e,
        0x0355, 0x39de, 0x1172, 0x014c, 0x178c, 0x12f4, 0x0a4c, 0x39a6, 0x269c, 0x0c1d, 0x2931, 0x203e, 0x051c, 0x186d, 0x2dae, 0x3930,
        0x3cba, 0x2857, 0x3837, 0x38d4, 0x141c, 0x03f7, 0x01e0, 0x080b, 0x0500, 0x04f6, 0x2e0d, 0x1f2e, 0x3d60, 0x309a, 0x094f, 0x1759,
        0x0d72, 0x23d6, 0x3da1, 0x1620, 0x2aa7, 0x371a, 0x19a1, 0x1eda, 0x0bd2, 0x3e00, 0x1e32, 0x222c, 0x103a, 0x1008, 0x36c3, 0x30f2,
        0x13d9, 0x2331, 0x1401, 0x3dc5, 0x2994, 0x18aa, 0x307d, 0x0716, 0x1db6, 0x0735, 0x094a, 0x0d5f, 0x188a, 0x1587, 0x0d64, 0x23f4,
        0x1ae2, 0x3b41, 0x35fb, 0x2f33, 0x154d, 0x3340, 0x3295, 0x2cb5, 0x106b, 0x1718, 0x0cd4, 0x00e3, 0x32e5, 0x2a54, 0x35e5, 0x2f42,
        0x17a2, 0x3c62, 0x3af3, 0x2377, 0x2072, 0x2d85, 0x066b, 0x12c4, 0x1bbf, 0x3544, 0x1557, 0x0b39, 0x259d, 0x398d, 0x2aac, 0x377c,
        0x3f66, 0x3a36, 0x2d52, 0x3a1a, 0x2bde, 0x1fc2, 0x3e64, 0x08f4, 0x1a9a, 0x1a14, 0x1b65, 0x0237, 0x3c54, 0x0186, 0x1e0c, 0x3886,
        0x072f, 0x0877, 0x265a, 0x191b, 0x0f38, 0x33ac, 0x09d7, 0x2544, 0x2f85, 0x37de, 0x2820, 0x13e0, 0x0daa, 0x2fec, 0x371f, 0x37d8,
        0x27b0, 0x2800, 0x300e, 0x10da, 0x1327, 0x20f9, 0x1d3b, 0x3c49, 0x357d, 0x27dc, 0x2529, 0x2a98, 0x13fa, 0x3138, 0x2bf5, 0x35c2,
        0x3b6a, 0x1292, 0x2686, 0x1243, 0x3112, 0x1ac6, 0x0063, 0x0ee2, 0x2876, 0x2d8f, 0x2bc9, 0x25c9, 0x32c1, 0x382b, 0x19a6, 0x20d4,
        0x00a8, 0x22fb, 0x0db8, 0x2e7c, 0x08bb, 0x10b7, 0x29e2, 0x0c0c, 0x1cd5, 0x2f20, 0x36da, 0x2c51, 0x0528, 0x2693, 0x2784, 0x05dd,
        0x1c6c, 0x19f3, 0x2a9f, 0x0629, 0x3c1d, 0x2d41, 0x2939, 0x1281, 0x2407, 0x3725, 0x2291, 0x29fa, 0x00f2, 0x24bb, 0x1edf, 0x05be,
        0x11b8, 0x1b2b, 0x3b38, 0x379c, 0x25ab, 0x02a6, 0x3036, 0x2799, 0x2600, 0x3ff6, 0x290d, 0x3b00, 0x144e, 0x07be, 0x3bf7, 0x1830,
        0x19c7, 0x3ce6, 0x2473, 0x365d, 0x0b5c, 0x16bf, 0x295d, 0x3a8a, 0x0d90, 0x2198, 0x0b48, 0x394d, 0x3e6e, 0x1655, 0x0d77, 0x2ad3,
        0x3005, 0x2088, 0x3fb8, 0x31be, 0x0592, 0x07a4, 0x0650, 0x33b4, 0x31f4, 0x02ea, 0x006e, 0x3d7c, 0x1d77, 0x332a, 0x1237, 0x18b3,
        0x1862, 0x1e9f, 0x316b, 0x0965, 0x0551, 0x1e18, 0x3c88, 0x063a, 0x1d28, 0x2ff2, 0x29b1, 0x2338, 0x093c, 0x3a2e, 0x23db, 0x3526,
        0x2bb9, 0x169d, 0x1e98, 0x0870, 0x1a04, 0x0bf4, 0x2790, 0x20c9, 0x092c, 0x1637, 0x248b, 0x180a, 0x2e50, 0x3f1f, 0x3eeb, 0x2e60,
        0x2a24, 0x0eb9, 0x1970, 0x3e27, 0x0311, 0x23b6, 0x088f, 0x23a1, 0x16e1, 0x089a, 0x1f4c, 0x2ea0, 0x1e51, 0x337c, 0x3da6, 0x254e,
        0x1162, 0x0f87, 0x36ae, 0x2924, 0x19fb, 0x1ce8, 0x2256, 0x324c, 0x30ae, 0x2386, 0x0d12, 0x1346, 0x0814, 0x1a2b, 0x3f5a, 0x1c2d,
        0x2b47, 0x391a, 0x2530, 0x0774, 0x38ae, 0x177a, 0x335b, 0x32f3, 0x2667, 0x0db0, 0x1484, 0x2034, 0x3874, 0x32af, 0x1625, 0x299f,
        0x06a8, 0x22e2, 0x01c0, 0x1e61, 0x2f16, 0x1496, 0x166c, 0x06e9, 0x3736, 0x2702, 0x13ac, 0x1e6e, 0x214b, 0x0cdd, 0x0cb3, 0x0e5c,
        0x0d37, 0x1261, 0x0468, 0x342f, 0x0a36, 0x1b5b, 0x27ba, 0x3230, 0x0695, 0x273e, 0x2e3d, 0x1b52, 0x3a05, 0x0708, 0x103f, 0x1f09,
        0x10c2, 0x0944, 0x083b, 0x0a12, 0x3d74, 0x192a, 0x1c23, 0x15b6, 0x11a3, 0x36ed, 0x3269, 0x34c1, 0x29ab, 0x147e, 0x281a, 0x228b,
        0x3b15, 0x16a4, 0x22b1, 0x21ff, 0x3178, 0x112f, 0x21c9, 0x1d6d, 0x108f, 0x13e6, 0x326f, 0x1408, 0x0e23, 0x2c69, 0x100d, 0x2d35,
        0x3973, 0x306d, 0x152b, 0x21ae, 0x2836, 0x03be, 0x0b8d, 0x2480, 0x32cf, 0x008b, 0x3cc7, 0x17bb, 0x2de0, 0x0fc5, 0x1aa3, 0x3ecb,
        0x09fe, 0x1c19, 0x189d, 0x1cf3, 0x3abf, 0x129c, 0x13ef, 0x0c4c, 0x3961, 0x21ed, 0x3c16, 0x38a7, 0x143c, 0x298d, 0x36c8, 0x3532,
        0x30a6, 0x2774, 0x266f, 0x0bca, 0x1b9c, 0x397d, 0x1382, 0x1737, 0x3d03, 0x25f0, 0x0385, 0x1dcb, 0x234b, 0x2024, 0x13a0, 0x3903,
        0x16f1, 0x2d66, 0x27e3, 0x097e, 0x3968, 0x39b1, 0x2046, 0x3f42, 0x0a1f, 0x2826, 0x34c7, 0x2a0b, 0x3cb1, 0x1d5d, 0x30f7, 0x3289,
        0x10a3, 0x14d3, 0x1573, 0x20bc, 0x26cf, 0x18e3, 0x3bb5, 0x0c7f, 0x1f96, 0x1604, 0x29c4, 0x2bfe, 0x2aeb, 0x258f, 0x2726, 0x074c,
        0x0dc2, 0x195b, 0x2d26, 0x353b, 0x2fa0, 0x1fe0, 0x2a34, 0x3d39, 0x2ec9, 0x0e42, 0x2dd1, 0x0dfb, 0x28c4, 0x05cf, 0x0bd7, 0x010c,
        0x0988, 0x197d, 0x2d76, 0x0544, 0x3deb, 0x19de, 0x3c28, 0x0f40, 0x34df, 0x14e7, 0x29d3, 0x1932, 0x017e, 0x1476, 0x0100, 0x3215,
        0x0246, 0x2bc0, 0x0765, 0x17e0, 0x159a, 0x032c, 0x2eec, 0x39c8, 0x0428, 0x37e4, 0x11a9, 0x3dcc, 0x020b, 0x3fe8, 0x3e05, 0x3651,
        0x3377, 0x32aa, 0x1650, 0x3a29, 0x3826, 0x24b6, 0x3988, 0x2fe7, 0x0531, 0x03ab, 0x05ca, 0x3fe3, 0x2988, 0x1d58, 0x0703, 0x2c64,
        0x1d66, 0x39c1, 0x253d, 0x0633, 0x2518, 0x38b9, 0x37cd, 0x2aca, 0x3095, 0x1582, 0x341e, 0x2e26, 0x3ba4, 0x0536, 0x1e37, 0x0faf,
        0x37b2, 0x11d4, 0x1b03, 0x2679, 0x1c74, 0x0321, 0x2751, 0x3f7c, 0x277c, 0x1398, 0x0d55, 0x00cd, 0x24d8, 0x21bb, 0x24cc, 0x2568,
        0x026c, 0x31de, 0x3584, 0x01eb, 0x21f4, 0x1e48, 0x1a7b, 0x2166, 0x110e, 0x2f8b, 0x36f3, 0x0788, 0x3690, 0x03b0, 0x2231, 0x1156,
        0x057d, 0x02af, 0x183a, 0x0d39, 0x2918, 0x1faa, 0x007d, 0x1263, 0x0bb2, 0x0b74, 0x3109, 0x046a, 0x2b7d, 0x01a1, 0x11e4, 0x3431,
        0x2d12, 0x1992, 0x30da, 0x0a38, 0x2428, 0x255c, 0x3261, 0x1b5d, 0x3105, 0x2fa9, 0x2fad, 0x27bc, 0x1e7d, 0x2ef1, 0x0a85, 0x3232,
        0x304d, 0x096d, 0x0049, 0x0697, 0x3311, 0x1fcf, 0x3207, 0x2740, 0x12bb, 0x3515, 0x2fb1, 0x2e3f, 0x16b8, 0x2d7e, 0x1fd9, 0x1b54,
        0x26ef, 0x2555, 0x0be1, 0x3a07, 0x2ca0, 0x3453, 0x3b96, 0x070a, 0x08e7, 0x2cbb, 0x27c0, 0x1041, 0x338e, 0x39cd, 0x2fbd, 0x1f0b,
        0x3bd8, 0x0d81, 0x33bd, 0x06aa, 0x19bb, 0x2b27, 0x0298, 0x22e4, 0x3852, 0x1337, 0x1e81, 0x01c2, 0x1cb9, 0x0a95, 0x1967, 0x1e63,
        0x26b8, 0x1ed0, 0x25e8, 0x2f18, 0x01aa, 0x28b8, 0x334d, 0x1498, 0x315e, 0x2a45, 0x2ef5, 0x166e, 0x3058, 0x159f, 0x2584, 0x06eb,
        0x1311, 0x3ab0, 0x32fb, 0x3738, 0x0e06, 0x18c9, 0x2e6e, 0x2704, 0x1aee, 0x15a7, 0x0a89, 0x13ae, 0x3cdd, 0x2caa, 0x2759, 0x1e70,
        0x0a62, 0x0756, 0x0ee9, 0x214d, 0x0b94, 0x3fc7, 0x1794, 0x0cdf, 0x1690, 0x329b, 0x3236, 0x0cb5, 0x1b20, 0x0331, 0x10ee, 0x0e5e,
        0x1c3b, 0x3e4a, 0x3958, 0x3b17, 0x3334, 0x241a, 0x06d9, 0x16a6, 0x040b, 0x343e, 0x2d16, 0x22b3, 0x1858, 0x1ab1, 0x11c4, 0x2201,
        0x049f, 0x13b7, 0x1d18, 0x317a, 0x0e95, 0x26f6, 0x17fa, 0x1131, 0x2ebc, 0x15e8, 0x1996, 0x21cb, 0x18fb, 0x076a, 0x0176, 0x1d6f,
        0x1b49, 0x1370, 0x01d9, 0x1091, 0x0888, 0x005c, 0x37c6, 0x13e8, 0x126d, 0x3db8, 0x30de, 0x3271, 0x13bf, 0x0f03, 0x09cd, 0x140a,
        0x2106, 0x3dad, 0x1ff5, 0x0e25, 0x0215, 0x3e3c, 0x1bf3, 0x2c6b, 0x00c0, 0x3346, 0x0a3c, 0x100f, 0x3a70, 0x17e5, 0x2a74, 0x2d37,
        0x02fd, 0x0681, 0x28ed, 0x10c4, 0x292d, 0x2e09, 0x1e2e, 0x0946, 0x0201, 0x1207, 0x242c, 0x083d, 0x0dd3, 0x14b8, 0x2cd9, 0x0a14,
        0x2c4b, 0x0231, 0x1340, 0x3d76, 0x1dc5, 0x34bb, 0x00c7, 0x192c, 0x30ea, 0x114c, 0x2560, 0x1c25, 0x358d, 0x024b, 0x2226, 0x15b8,
        0x29c0, 0x2dcd, 0x29cf, 0x11a5, 0x05c6, 0x341a, 0x0d51, 0x36ef, 0x13a8, 0x2e39, 0x3265, 0x326b, 0x3cc3, 0x3c12, 0x0381, 0x34c3,
        0x2909, 0x0b44, 0x006a, 0x29ad, 0x2487, 0x1f48, 0x0d0e, 0x1480, 0x0cd0, 0x1553, 0x1b61, 0x281c, 0x2525, 0x2bc5, 0x36d6, 0x228d,
        0x2eda, 0x24a4, 0x09ec, 0x0a00, 0x227f, 0x1706, 0x3e5c, 0x1c1b, 0x31ff, 0x250b, 0x0bb6, 0x189f, 0x3d8f, 0x2a5d, 0x1814, 0x1cf5,
        0x2886, 0x1b79, 0x2135, 0x3ac1, 0x184a, 0x3a0e, 0x2eb2, 0x129e, 0x050f, 0x1a63, 0x0b78, 0x13f1, 0x1cb0, 0x3e0a, 0x24fe, 0x0c4e,
        0x0a31, 0x3173, 0x3aba, 0x3963, 0x2f9b, 0x1595, 0x2513, 0x21ef, 0x206d, 0x0f33, 0x310d, 0x3c18, 0x0b57, 0x054c, 0x030c, 0x38a9,
        0x3acc, 0x3383, 0x104d, 0x143e, 0x0a7b, 0x0c66, 0x1417, 0x298f, 0x3671, 0x2f39, 0x046e, 0x36ca, 0x2370, 0x3656, 0x3428, 0x3534,
        0x0801, 0x0cc1, 0x10af, 0x3975, 0x1430, 0x220e, 0x31a9, 0x306f, 0x0ac9, 0x22a4, 0x2b81, 0x152d, 0x18c1, 0x1f56, 0x388f, 0x21b0,
        0x1845, 0x0a76, 0x07ee, 0x2838, 0x07f3, 0x3b5e, 0x1016, 0x03c0, 0x2423, 0x2c9b, 0x01a5, 0x0b8f, 0x0e90, 0x0210, 0x1dc0, 0x2482,
        0x3749, 0x0a6c, 0x3363, 0x32d1, 0x3c6e, 0x1f5e, 0x3e85, 0x008d, 0x37ef, 0x3060, 0x11e8, 0x3cc9, 0x289c, 0x0f7c, 0x3f84, 0x17bd,
        0x212b, 0x2b04, 0x1acd, 0x2de2, 0x283d, 0x1c4d, 0x12fc, 0x0fc7, 0x121b, 0x3601, 0x3435, 0x1aa5, 0x0c01, 0x3fed, 0x346d, 0x3ecd,
        0x1b41, 0x11f4, 0x3cf2, 0x16f3, 0x039f, 0x3122, 0x2715, 0x2d68, 0x2390, 0x1bb2, 0x0581, 0x27e5, 0x0866, 0x0364, 0x2ffd, 0x0980,
        0x35af, 0x02d7, 0x20a9, 0x396a, 0x07f8, 0x0be8, 0x3638, 0x39b3, 0x0ae1, 0x012b, 0x02b3, 0x2048, 0x347a, 0x11ae, 0x2dfc, 0x3f44,
        0x11fc, 0x3610, 0x0612, 0x0a21, 0x06b4, 0x3185, 0x284b, 0x2828, 0x26b1, 0x2c44, 0x183e, 0x34c9, 0x04a7, 0x3eaf, 0x20ef, 0x2a0d,
        0x187b, 0x1e58, 0x3022, 0x3cb3, 0x3b63, 0x2a1d, 0x09f7, 0x1d5f, 0x1118, 0x3b47, 0x0d3d, 0x30f9, 0x0f1b, 0x3dd1, 0x1be6, 0x328b,
        0x1a94, 0x1ccf, 0x31ee, 0x30a8, 0x119d, 0x3cfd, 0x34d9, 0x2776, 0x2c5a, 0x1618, 0x291c, 0x2671, 0x1ebf, 0x1de6, 0x0038, 0x0bcc,
        0x34d0, 0x1a48, 0x2b13, 0x1b9e, 0x101b, 0x3c7c, 0x0a43, 0x397f, 0x2e17, 0x2ae1, 0x1fae, 0x1384, 0x09a4, 0x042d, 0x068a, 0x1739,
        0x3b29, 0x2631, 0x3f03, 0x3d05, 0x1ee7, 0x150d, 0x28d5, 0x25f2, 0x390b, 0x07b1, 0x0081, 0x0387, 0x0c9a, 0x2468, 0x34ea, 0x1dcd,
        0x08ac, 0x0ec5, 0x3119, 0x234d, 0x03c5, 0x18da, 0x3b7a, 0x2026, 0x12b5, 0x1ae8, 0x1267, 0x13a2, 0x2067, 0x37e9, 0x26ab, 0x3905,
        0x0137, 0x25b4, 0x18f0, 0x0dc4, 0x10fb, 0x102c, 0x0f25, 0x195d, 0x1bda, 0x3a54, 0x08eb, 0x2d28, 0x0e3b, 0x2737, 0x2191, 0x353d,
        0x0124, 0x1a5c, 0x15e1, 0x2fa2, 0x0ace, 0x345a, 0x0197, 0x1fe2, 0x04c5, 0x1fe9, 0x2cbf, 0x2a36, 0x3ef6, 0x3c2d, 0x0cf0, 0x3d3b,
        0x35a4, 0x1ea7, 0x1c8e, 0x2ecb, 0x1c58, 0x01f7, 0x0bbe, 0x0e44, 0x08b2, 0x38c9, 0x27c4, 0x2dd3, 0x2cfe, 0x0990, 0x0e75, 0x0dfd,
        0x0c32, 0x2ea7, 0x2f50, 0x28c6, 0x22a9, 0x2652, 0x0f0d, 0x05d1, 0x3803, 0x2f48, 0x1045, 0x0bd9, 0x02ca, 0x0f45, 0x03d3, 0x010e,
        0x2b35, 0x378a, 0x0659, 0x10a5, 0x0e11, 0x3eb9, 0x340c, 0x14d5, 0x1dda, 0x1367, 0x3392, 0x1575, 0x3e13, 0x1ef5, 0x207f, 0x20be,
        0x04ae, 0x2c12, 0x249a, 0x26d1, 0x2b86, 0x385e, 0x17ec, 0x18e5, 0x33f7, 0x0675, 0x39d1, 0x3bb7, 0x2272, 0x3df0, 0x27f5, 0x0c81,
        0x048d, 0x1193, 0x1782, 0x1f98, 0x0e7e, 0x3897, 0x0d2b, 0x1606, 0x0ecb, 0x06f3, 0x2fc1, 0x29c6, 0x36a5, 0x3fd8, 0x1c7c, 0x2c00,
        0x2d5e, 0x19eb, 0x124a, 0x2aed, 0x1532, 0x3a7a, 0x0a54, 0x2591, 0x22c5, 0x35eb, 0x1f0f, 0x2728, 0x0fba, 0x19e3, 0x2afc, 0x074e,
        0x2e06, 0x14b5, 0x34b8, 0x0248, 0x3417, 0x3c0f, 0x1f45, 0x2bc2, 0x2417, 0x1aae, 0x26f3, 0x0767, 0x0059, 0x0f00, 0x3e39, 0x17e2,
        0x2b24, 0x0a92, 0x28b5, 0x159c, 0x18c6, 0x2ca7, 0x3fc4, 0x032e, 0x1fa7, 0x019e, 0x2559, 0x2eee, 0x1fcc, 0x2d7b, 0x3450, 0x39ca,
        0x3cfa, 0x1de3, 0x3c79, 0x042a, 0x150a, 0x2465, 0x18d7, 0x37e6, 0x311f, 0x0361, 0x0be5, 0x11ab, 0x3182, 0x3eac, 0x2a1a, 0x3dce,
        0x220b, 0x1f53, 0x3b5b, 0x020d, 0x1f5b, 0x0f79, 0x1c4a, 0x3fea, 0x1703, 0x2a5a, 0x3a0b, 0x3e07, 0x1592, 0x0549, 0x0c63, 0x3653,
        0x0417, 0x3ea6, 0x3fd2, 0x098a, 0x36b7, 0x041a, 0x146d, 0x197f, 0x3c0c, 0x0efd, 0x2ca4, 0x2d78, 0x2462, 0x3ea9, 0x0f76, 0x0546,
        0x3eb6, 0x1ef2, 0x385b, 0x3ded, 0x3894, 0x3fd5, 0x3a77, 0x19e0, 0x1029, 0x2734, 0x3457, 0x3c2a, 0x01f4, 0x098d, 0x264f, 0x0f42,
        0x0851, 0x0ab9, 0x2fca, 0x34e1, 0x24c3, 0x36ba, 0x1a6f, 0x14e9, 0x2353, 0x20df, 0x3b9a, 0x29d5, 0x2860, 0x041d, 0x08d1, 0x1934,
        0x1a25, 0x3324, 0x268d, 0x0180, 0x21b5, 0x1470, 0x201e, 0x1478, 0x215e, 0x32eb, 0x070e, 0x0102, 0x1002, 0x1982, 0x0f62, 0x3217,
        0x0c47, 0x3f3d, 0x322b, 0x1d68, 0x2ac5, 0x2161, 0x3d34, 0x39c3, 0x0edd, 0x127c, 0x12bf, 0x253f, 0x239c, 0x32ee, 0x3a85, 0x0635,
        0x081f, 0x1d02, 0x33dc, 0x251a, 0x0806, 0x0711, 0x10e4, 0x38bb, 0x05eb, 0x3461, 0x3519, 0x37cf, 0x1f02, 0x0105, 0x3775, 0x2acc,
        0x12f1, 0x186a, 0x03f4, 0x3097, 0x3717, 0x1005, 0x18a7, 0x1584, 0x03cb, 0x1b0f, 0x2fb5, 0x3420, 0x2440, 0x1985, 0x2a81, 0x2e28,
        0x2c83, 0x08a1, 0x380b, 0x3ba6, 0x0cc6, 0x0f65, 0x2db9, 0x0538, 0x0021, 0x00e9, 0x2e43, 0x1e39, 0x3a47, 0x321a, 0x1b17, 0x0fb1,
        0x0bf1, 0x3f1c, 0x23b3, 0x3379, 0x1ce5, 0x1a28, 0x1777, 0x32ac, 0x02a3, 0x07bb, 0x16bc, 0x1652, 0x07a1, 0x3327, 0x1e15, 0x3a2b,
        0x20f6, 0x3135, 0x1ac3, 0x3828, 0x10b4, 0x2690, 0x2d3e, 0x24b8, 0x333d, 0x2a51, 0x2d82, 0x398a, 0x1fbf, 0x0183, 0x33a9, 0x2fe9,
        0x24b3, 0x1d55, 0x38b6, 0x0533, 0x031e, 0x21b8, 0x1e45, 0x03ad, 0x18e0, 0x258c, 0x1fdd, 0x05cc, 0x19db, 0x1473, 0x0329, 0x3fe5,
        0x03bb, 0x0fc2, 0x1299, 0x298a, 0x397a, 0x2021, 0x39ae, 0x1d5a, 0x1493, 0x0cda, 0x1b58, 0x0705, 0x1927, 0x147b, 0x112c, 0x2c66,
        0x223f, 0x06c2, 0x0b69, 0x026e, 0x17ca, 0x2356, 0x1b88, 0x31e0, 0x0e89, 0x099d, 0x3051, 0x3586, 0x1fb8, 0x20e2, 0x226b, 0x01ed,
        0x2305, 0x3d59, 0x2058, 0x21f6, 0x1435, 0x3b9d, 0x32ba, 0x1e4a, 0x2ba1, 0x0ad5, 0x0971, 0x1a7d, 0x2115, 0x29d8, 0x0d21, 0x2168,
        0x16fb, 0x0342, 0x00b8, 0x1110, 0x23c8, 0x2863, 0x27d0, 0x2f8d, 0x3b80, 0x0905, 0x004d, 0x36f5, 0x1d20, 0x0420, 0x31b4, 0x078a,
        0x1764, 0x16e8, 0x26e0, 0x3692, 0x2213, 0x08d4, 0x2122, 0x03b2, 0x034a, 0x171e, 0x069b, 0x2233, 0x0847, 0x1937, 0x1d8a, 0x1158,
        0x39f5, 0x3bc6, 0x34a9, 0x37b4, 0x38f3, 0x0854, 0x1a51, 0x11d6, 0x36e3, 0x09b5, 0x3315, 0x1b05, 0x15f4, 0x0abc, 0x14a3, 0x267b,
        0x2a14, 0x08cb, 0x0e6f, 0x1c76, 0x31ae, 0x2fcd, 0x2a7b, 0x0323, 0x09c7, 0x037b, 0x1fd3, 0x2753, 0x20e9, 0x34e4, 0x0306, 0x3f7e,
        0x1231, 0x3f54, 0x1e06, 0x277e, 0x00fa, 0x24c6, 0x2814, 0x139a, 0x202c, 0x0780, 0x320b, 0x0d57, 0x0fe6, 0x36bd, 0x2fd3, 0x00cf,
        0x0afa, 0x055e, 0x3b71, 0x24da, 0x3074, 0x1a72, 0x24e3, 0x21bd, 0x0fdc, 0x1071, 0x2744, 0x24ce, 0x308a, 0x14ec, 0x35d0, 0x256a,
        0x0165, 0x27a2, 0x3c01, 0x17a4, 0x167f, 0x04c8, 0x0459, 0x3c64, 0x07dd, 0x2cf1, 0x3162, 0x3af5, 0x3b52, 0x1fec, 0x2765, 0x2379,
        0x3d23, 0x190d, 0x2010, 0x2074, 0x1220, 0x2cc2, 0x21e5, 0x2d87, 0x2c93, 0x2a3d, 0x2a49, 0x066d, 0x2ced, 0x2a39, 0x0c70, 0x12c6,
        0x38e8, 0x0642, 0x1f8a, 0x1bc1, 0x0ea3, 0x3ef9, 0x3d97, 0x3546, 0x3911, 0x0c74, 0x2ef9, 0x1559, 0x0aa2, 0x3c30, 0x331b, 0x0b3b,
        0x2f65, 0x23a8, 0x0116, 0x259f, 0x3606, 0x0cf3, 0x2f76, 0x398f, 0x22d7, 0x12ca, 0x1672, 0x2aae, 0x30c4, 0x3d3e, 0x2a89, 0x377e,
        0x1614, 0x2add, 0x07ad, 0x1ae4, 0x1bae, 0x0127, 0x2c40, 0x3b43, 0x22a0, 0x2c97, 0x305c, 0x35fd, 0x2507, 0x1a5f, 0x0f2f, 0x2f35,
        0x1203, 0x1148, 0x2e35, 0x154f, 0x343a, 0x15e4, 0x3db4, 0x3342, 0x1333, 0x2a41, 0x15a3, 0x3297, 0x0b70, 0x2fa5, 0x3511, 0x2cb7,
        0x09b1, 0x0377, 0x077c, 0x106d, 0x0999, 0x0ad1, 0x0901, 0x171a, 0x07b7, 0x2a4d, 0x2588, 0x0cd6, 0x1278, 0x345d, 0x1b0b, 0x00e5,
        0x0ef9, 0x2730, 0x20db, 0x32e7, 0x1aaa, 0x019a, 0x035d, 0x2a56, 0x1363, 0x0671, 0x06ef, 0x35e7, 0x3a50, 0x1fe5, 0x38c5, 0x2f44,
        0x0c19, 0x04f2, 0x3dfc, 0x0731, 0x1d81, 0x1bdd, 0x3487, 0x0879, 0x356a, 0x1224, 0x26bc, 0x265c, 0x3ca7, 0x3a57, 0x05a5, 0x191d,
        0x1731, 0x15b0, 0x3f76, 0x0f3a, 0x0c06, 0x08ee, 0x3246, 0x33ae, 0x12a8, 0x2cc6, 0x1ed4, 0x09d9, 0x1751, 0x2d2b, 0x0fa7, 0x2546,
        0x03a7, 0x157e, 0x1394, 0x2f87, 0x1600, 0x0e3e, 0x14e3, 0x37e0, 0x0087, 0x21e9, 0x25ec, 0x2822, 0x26fe, 0x273a, 0x36e9, 0x13e2,
        0x1633, 0x0896, 0x2382, 0x0dac, 0x3ff2, 0x2194, 0x02e6, 0x2fee, 0x27d8, 0x2d8b, 0x2f1c, 0x3721, 0x1714, 0x3540, 0x1a10, 0x37da,
        0x0018, 0x3668, 0x0223, 0x3f68, 0x0f90, 0x013a, 0x1086, 0x3a38, 0x1c62, 0x3d27, 0x01ae, 0x2d54, 0x1a88, 0x25b7, 0x3ed9, 0x3a1c,
        0x3617, 0x1749, 0x01cb, 0x2be0, 0x3472, 0x18f3, 0x210d, 0x1fc4, 0x24f1, 0x1911, 0x28bc, 0x3e66, 0x0275, 0x0dc7, 0x1f21, 0x08f6,
        0x3ee4, 0x2bee, 0x06fc, 0x1a9c, 0x2a02, 0x10fe, 0x2da7, 0x1a16, 0x038d, 0x2014, 0x3351, 0x1b67, 0x3840, 0x102f, 0x09bb, 0x0239,
        0x0b12, 0x3c39, 0x19ad, 0x3c56, 0x3ed2, 0x0f28, 0x0447, 0x0188, 0x0f6f, 0x2078, 0x149c, 0x1e0e, 0x2cd2, 0x1960, 0x0031, 0x3888,
        0x2053, 0x26db, 0x0e6a, 0x3b6c, 0x33d7, 0x3806, 0x1abe, 0x1294, 0x28b0, 0x3b56, 0x3856, 0x2688, 0x15dc, 0x2f4b, 0x2495, 0x1245,
        0x20a4, 0x301d, 0x2b0e, 0x3114, 0x2130, 0x1048, 0x07e9, 0x1ac8, 0x1d13, 0x1ff0, 0x133b, 0x0065, 0x30d5, 0x0bdc, 0x25e3, 0x0ee4,
        0x03e9, 0x3c90, 0x131b, 0x2878, 0x34f6, 0x02cd, 0x2a65, 0x2d91, 0x0ca0, 0x2769, 0x1e85, 0x2bcb, 0x0b24, 0x0f48, 0x14a9, 0x25cb,
        0x04d8, 0x23bd, 0x03db, 0x32c3, 0x2b09, 0x03d6, 0x314f, 0x382d, 0x3f71, 0x237d, 0x01c6, 0x19a8, 0x200b, 0x0111, 0x2e30, 0x20d6,
        0x3641, 0x2450, 0x0663, 0x27b2, 0x2978, 0x0c35, 0x3b8b, 0x2802, 0x21dd, 0x07e1, 0x1cbd, 0x3010, 0x3259, 0x2eaa, 0x018f, 0x10dc,
        0x0619, 0x3753, 0x3154, 0x1329, 0x1ad2, 0x2f53, 0x0e2c, 0x20fb, 0x16af, 0x2cf5, 0x0a99, 0x1d3d, 0x2246, 0x28c9, 0x073f, 0x3c4b,
        0x2d21, 0x0760, 0x2538, 0x357f, 0x0463, 0x22ac, 0x1898, 0x27de, 0x246e, 0x3166, 0x196b, 0x252b, 0x3aee, 0x2655, 0x2681, 0x2a9a,
        0x221c, 0x1f17, 0x3832, 0x13fc, 0x2de7, 0x0f10, 0x39e6, 0x313a, 0x00dc, 0x3af9, 0x1e67, 0x2bf7, 0x23e9, 0x05d4, 0x3683, 0x35c4,
        0x3d6e, 0x1b96, 0x3de5, 0x1c6e, 0x2bd8, 0x08b5, 0x058c, 0x19f5, 0x30b8, 0x1683, 0x3bdc, 0x2aa1, 0x0e52, 0x38cc, 0x3e1f, 0x062b,
        0x16d3, 0x3500, 0x04dd, 0x3c1f, 0x2842, 0x27c7, 0x1f6c, 0x2d43, 0x0480, 0x04cc, 0x0d85, 0x293b, 0x361f, 0x2dd6, 0x0797, 0x1283,
        0x312a, 0x0cfd, 0x3fac, 0x2409, 0x33c7, 0x2d01, 0x1f75, 0x3727, 0x34f0, 0x045d, 0x33c1, 0x2293, 0x0e9d, 0x0993, 0x15fa, 0x29fc,
        0x3711, 0x0318, 0x23c2, 0x00f4, 0x1c52, 0x0e78, 0x1504, 0x24bd, 0x2f95, 0x3c68, 0x06ae, 0x1ee1, 0x330b, 0x0e00, 0x0882, 0x05c0,
        0x1729, 0x16cb, 0x3f90, 0x00aa, 0x0497, 0x35a7, 0x2b1c, 0x22fd, 0x2f29, 0x0169, 0x19bf, 0x0dba, 0x2b71, 0x1eaa, 0x044e, 0x2e7e,
        0x0a28, 0x12e8, 0x03e0, 0x08bd, 0x1301, 0x1c91, 0x1ffc, 0x10b9, 0x1f38, 0x27a6, 0x2b2b, 0x29e4, 0x06c9, 0x2ece, 0x10cd, 0x0c0e,
        0x14c5, 0x294c, 0x0ead, 0x1cd7, 0x2299, 0x1c5b, 0x21d6, 0x2f22, 0x1dd3, 0x3c05, 0x029c, 0x36dc, 0x384b, 0x01fa, 0x0ac2, 0x2c53,
        0x3576, 0x0925, 0x32c8, 0x052a, 0x0fcc, 0x0bc1, 0x0b03, 0x2695, 0x1463, 0x17a8, 0x22e8, 0x2786, 0x3765, 0x0e47, 0x0722, 0x05df,
        0x105f, 0x303f, 0x2aba, 0x19c9, 0x2640, 0x33fa, 0x3ddb, 0x3ce8, 0x3a9e, 0x30c8, 0x1694, 0x2475, 0x3e9d, 0x0678, 0x151b, 0x365f,
        0x3d15, 0x2f0a, 0x0b29, 0x0b5e, 0x37f4, 0x39d4, 0x1cc5, 0x16c1, 0x231a, 0x3d42, 0x329f, 0x295f, 0x1566, 0x3bba, 0x3be7, 0x3a8c,
        0x1bcf, 0x1e20, 0x1d9d, 0x0d92, 0x33cd, 0x2275, 0x181c, 0x219a, 0x3b2f, 0x2a8d, 0x323a, 0x0b4a, 0x1d46, 0x3df3, 0x34af, 0x394f,
        0x0439, 0x3e2e, 0x0f4d, 0x3e70, 0x3065, 0x27f8, 0x13c9, 0x1657, 0x3f14, 0x3782, 0x0cb9, 0x0d79, 0x31d1, 0x0c84, 0x2448, 0x2ad5,
        0x29ee, 0x0c8c, 0x059b, 0x11ba, 0x319a, 0x04b1, 0x1ca5, 0x1b2d, 0x14cc, 0x22db, 0x1b24, 0x3b3a, 0x0c57, 0x2c15, 0x3c40, 0x379e,
        0x06bb, 0x3f36, 0x14ae, 0x25ad, 0x11ed, 0x249d, 0x3e43, 0x02a8, 0x3555, 0x12ce, 0x0335, 0x3038, 0x1b8f, 0x26d4, 0x04eb, 0x279b,
        0x07d3, 0x0ba8, 0x3922, 0x2602, 0x2d07, 0x2b89, 0x2172, 0x3ff8, 0x2637, 0x1676, 0x10f2, 0x290f, 0x1544, 0x3861, 0x37ba, 0x3b02,
        0x01b8, 0x35f3, 0x25d0, 0x1450, 0x3cce, 0x17ef, 0x117a, 0x07c0, 0x1df3, 0x2ab2, 0x0e62, 0x3bf9, 0x3223, 0x18e8, 0x09e4, 0x1832,
        0x3f4e, 0x033c, 0x1d4f, 0x1864, 0x0ab3, 0x1ddd, 0x118d, 0x1ea1, 0x262b, 0x360a, 0x0a66, 0x316d, 0x2dc7, 0x136a, 0x3aaa, 0x0967,
        0x3f98, 0x1af7, 0x0ca5, 0x0553, 0x28a1, 0x3395, 0x0ba2, 0x1e1a, 0x2946, 0x0cf7, 0x075a, 0x3c8a, 0x2be8, 0x1578, 0x0371, 0x063c,
        0x271d, 0x339b, 0x0ded, 0x1d2a, 0x1f7b, 0x3e16, 0x2262, 0x2ff4, 0x3f09, 0x2f7a, 0x0eed, 0x29b3, 0x1139, 0x1ef8, 0x39fb, 0x233a,
        0x11ce, 0x1977, 0x276e, 0x093e, 0x0f81, 0x2082, 0x22f5, 0x3a30, 0x23d0, 0x3993, 0x2151, 0x23dd, 0x2fdf, 0x20c1, 0x399e, 0x3528,
        0x1649, 0x1524, 0x1e91, 0x3007, 0x116b, 0x2b38, 0x17b2, 0x208a, 0x2953, 0x2f69, 0x0b98, 0x3fba, 0x33eb, 0x378d, 0x0b19, 0x31c0,
        0x318c, 0x194f, 0x1e8a, 0x0594, 0x3f89, 0x065c, 0x021c, 0x07a6, 0x34a2, 0x23ac, 0x3fcb, 0x0652, 0x31e7, 0x10a8, 0x28e6, 0x33b6,
        0x1941, 0x28a7, 0x0ed4, 0x31f6, 0x372d, 0x0e14, 0x3ade, 0x02ec, 0x3d0b, 0x011a, 0x1798, 0x0070, 0x38dd, 0x3ebc, 0x3bcc, 0x3d7e,
        0x0ddf, 0x0aab, 0x2bd0, 0x1d79, 0x17c2, 0x340f, 0x0397, 0x332c, 0x26c7, 0x25a3, 0x0ce3, 0x1239, 0x2e93, 0x14d8, 0x2c30, 0x18b5,
        0x381a, 0x12d5, 0x1dfb, 0x2a26, 0x2327, 0x22c8, 0x091b, 0x0ebb, 0x194a, 0x0aa6, 0x1af2, 0x1972, 0x3f31, 0x35ee, 0x2f05, 0x3e29,
        0x12e3, 0x0920, 0x34fb, 0x0313, 0x374e, 0x1f12, 0x3018, 0x23b8, 0x1744, 0x3c34, 0x15ab, 0x0891, 0x1143, 0x272b, 0x1908, 0x23a3,
        0x08c6, 0x0559, 0x3d54, 0x16e3, 0x3130, 0x0fbd, 0x1cfd, 0x089c, 0x1eed, 0x331f, 0x0a8d, 0x1f4e, 0x2c0d, 0x19e6, 0x1a57, 0x2ea2,
        0x1a43, 0x0ec0, 0x02d2, 0x1e53, 0x0a71, 0x2aff, 0x1b74, 0x337e, 0x022c, 0x0b3f, 0x13b2, 0x3da8, 0x1ecb, 0x0751, 0x198d, 0x2550,
        0x39bc, 0x31d9, 0x1956, 0x2bbb, 0x1c14, 0x2d61, 0x125c, 0x169f, 0x0eb4, 0x3915, 0x3ce1, 0x1e9a, 0x128d, 0x19ee, 0x3c5d, 0x0872,
        0x2852, 0x232c, 0x2a6a, 0x1a06, 0x3368, 0x124d, 0x2c72, 0x0bf6, 0x06e2, 0x0c78, 0x2cae, 0x2792, 0x17d1, 0x2af0, 0x0ff1, 0x20cb,
        0x35dd, 0x0cab, 0x2b4f, 0x092e, 0x0d03, 0x1535, 0x05fb, 0x1639, 0x1513, 0x2efd, 0x275d, 0x248d, 0x2189, 0x3a7d, 0x11dc, 0x180c,
        0x08dd, 0x22cd, 0x2d96, 0x2e52, 0x32d6, 0x0a57, 0x0154, 0x3f21, 0x2ce4, 0x155d, 0x1e74, 0x3eed, 0x05af, 0x2594, 0x2b60, 0x2e62,
        0x082f, 0x355c, 0x3d4e, 0x2b49, 0x0de7, 0x0ece, 0x1d97, 0x391c, 0x3fa6, 0x0ea7, 0x1315, 0x2532, 0x138e, 0x06f6, 0x1f84, 0x0776,
        0x00b2, 0x1e00, 0x03ee, 0x38b0, 0x3c73, 0x2fc4, 0x1c88, 0x177c, 0x060c, 0x3efd, 0x3ab4, 0x335d, 0x01d3, 0x29c9, 0x0043, 0x32f5,
        0x2d70, 0x1afd, 0x0835, 0x2669, 0x3fb2, 0x36a8, 0x2d4c, 0x0db2, 0x28db, 0x3d9b, 0x32ff, 0x1486, 0x1802, 0x3fdb, 0x38f9, 0x2036,
        0x2576, 0x2a2b, 0x3c95, 0x3876, 0x1f63, 0x1c7f, 0x362f, 0x32b1, 0x286b, 0x354a, 0x373c, 0x1627, 0x2436, 0x2c03, 0x3490, 0x29a1,
        0x1c0d, 0x296a, 0x3193, 0x1164, 0x2971, 0x0490, 0x1ba7, 0x0f89, 0x1cde, 0x38ec, 0x0e0a, 0x36b0, 0x1429, 0x1196, 0x19b4, 0x2926,
        0x282f, 0x381f, 0x1320, 0x19fd, 0x3e8a, 0x1785, 0x1bfa, 0x1cea, 0x14f7, 0x0646, 0x18cd, 0x2258, 0x235d, 0x1f9b, 0x28f6, 0x324e,
        0x2623, 0x3f9e, 0x3562, 0x30b0, 0x240f, 0x0e81, 0x0403, 0x2388, 0x25f8, 0x1f8e, 0x2e72, 0x0d14, 0x107b, 0x389a, 0x085a, 0x1348,
        0x209b, 0x12da, 0x287d, 0x0816, 0x0092, 0x0d2e, 0x0567, 0x1a2d, 0x359a, 0x1bc5, 0x2708, 0x3f5c, 0x0257, 0x1609, 0x15c3, 0x1c2f,
        0x000d, 0x21a1, 0x1b35, 0x2888, 0x07c9, 0x0483, 0x009e, 0x1b7b, 0x3b0c, 0x2361, 0x2ba5, 0x2137, 0x1a3a, 0x04cf, 0x2c7a, 0x3ac3,
        0x260d, 0x2c35, 0x027a, 0x184c, 0x2ec1, 0x0d88, 0x2def, 0x3a10, 0x2b99, 0x1f9f, 0x0ad9, 0x2eb4, 0x0604, 0x293e, 0x0478, 0x12a0,
        0x2b95, 0x3b08, 0x2b66, 0x0511, 0x224c, 0x3622, 0x3ad4, 0x1a65, 0x0515, 0x28fa, 0x0975, 0x0b7a, 0x2981, 0x2dd9, 0x2e49, 0x13f3,
        0x1eb8, 0x18ba, 0x0dcc, 0x1cb2, 0x15ed, 0x079a, 0x245b, 0x3e0c, 0x2b6a, 0x3252, 0x1a81, 0x2500, 0x1422, 0x1286, 0x33e4, 0x0c50,
        0x217f, 0x19d1, 0x2341, 0x2edc, 0x3497, 0x16d6, 0x3705, 0x24a6, 0x3626, 0x14fb, 0x2119, 0x09ee, 0x2ee3, 0x3503, 0x3a5e, 0x0a02,
        0x2e1e, 0x2e98, 0x1f26, 0x2281, 0x199b, 0x04e0, 0x120e, 0x1708, 0x2250, 0x064a, 0x29dc, 0x3e5e, 0x274b, 0x3c22, 0x137c, 0x1c1d,
        0x0d4b, 0x37c0, 0x2e68, 0x3201, 0x28cf, 0x2845, 0x3e7f, 0x250d, 0x1a69, 0x18d1, 0x0d25, 0x0bb8, 0x280e, 0x27ca, 0x1e3f, 0x18a1,
        0x2da1, 0x14dd, 0x08fb, 0x3d91, 0x21d0, 0x1f6f, 0x1892, 0x2a5f, 0x3ad8, 0x225c, 0x216c, 0x1816, 0x03fd, 0x2d46, 0x05f5, 0x1cf7,
        0x0da1, 0x1823, 0x3e79, 0x3ace, 0x31c8, 0x30bb, 0x02c1, 0x3385, 0x28fe, 0x3e8e, 0x2309, 0x104f, 0x1359, 0x1686, 0x2c1f, 0x1440,
        0x376d, 0x0ce8, 0x24f6, 0x0a7d, 0x1900, 0x3bdf, 0x25db, 0x0c68, 0x0519, 0x1789, 0x3d5d, 0x1419, 0x1037, 0x2aa4, 0x1887, 0x2991,
        0x1120, 0x3867, 0x05b5, 0x3673, 0x0745, 0x0e55, 0x1829, 0x2f3b, 0x0b7e, 0x1bfe, 0x205c, 0x0470, 0x3dc0, 0x38cf, 0x0027, 0x36cc,
        0x0624, 0x123e, 0x1916, 0x2372, 0x076f, 0x3e22, 0x0960, 0x3658, 0x0979, 0x1cee, 0x21fa, 0x342a, 0x01e6, 0x062e, 0x17db, 0x3536,
        0x2148, 0x2f13, 0x3a02, 0x0a33, 0x29a8, 0x3d71, 0x0e20, 0x3175, 0x2ddd, 0x2833, 0x1439, 0x3abc, 0x2348, 0x1b99, 0x3cae, 0x3965,
        0x2ae8, 0x26cc, 0x28c1, 0x2f9d, 0x017b, 0x3de8, 0x0208, 0x1597, 0x2985, 0x3823, 0x3ba1, 0x2515, 0x24d5, 0x1c71, 0x368d, 0x21f1,
        0x32e2, 0x154a, 0x259a, 0x206f, 0x3c51, 0x2bdb, 0x0da7, 0x0f35, 0x13f7, 0x1324, 0x32be, 0x310f, 0x0525, 0x08b8, 0x00ef, 0x3c1a,
        0x144b, 0x25a8, 0x3e6b, 0x0b59, 0x1d74, 0x058f, 0x0939, 0x054e, 0x2e4d, 0x1a01, 0x1e4e, 0x030e, 0x0811, 0x19f8, 0x3871, 0x38ab,
        0x3d8c, 0x227c, 0x1cad, 0x1847, 0x0b54, 0x2f98, 0x236d, 0x0a78, 0x18be, 0x142d, 0x0e8d, 0x07f0, 0x2899, 0x3c6b, 0x0bfe, 0x283a,
        0x0863, 0x039c, 0x3477, 0x07f5, 0x04a4, 0x06b1, 0x0f18, 0x3b60, 0x1ebc, 0x119a, 0x09a1, 0x1018, 0x0c97, 0x1ee4, 0x2064, 0x03c2,
        0x2b7a, 0x2915, 0x1e7a, 0x2425, 0x16b5, 0x330e, 0x338b, 0x2c9d, 0x1cb6, 0x19b8, 0x3055, 0x01a7, 0x3cda, 0x0e03, 0x1b1d, 0x0b91,
        0x1855, 0x3331, 0x18f8, 0x0e92, 0x13bc, 0x0885, 0x3a6d, 0x0212, 0x0dd0, 0x292a, 0x358a, 0x1dc2, 0x3cc0, 0x05c3, 0x2522, 0x2484,
        0x2399, 0x2ac2, 0x1eff, 0x0803, 0x243d, 0x3714, 0x3a44, 0x0cc3, 0x079e, 0x1ce2, 0x1fbc, 0x10b1, 0x19d8, 0x031b, 0x1924, 0x3977,
        0x1fb5, 0x17c7, 0x2112, 0x1432, 0x1d1d, 0x23c5, 0x0844, 0x2210, 0x15f1, 0x38f0, 0x20e6, 0x31ab, 0x0fe3, 0x00f7, 0x3087, 0x3071,
        0x0e38, 0x10f8, 0x3ef3, 0x0acb, 0x2cfb, 0x1c55, 0x02c7, 0x22a6, 0x3e10, 0x0e0e, 0x226f, 0x2b83, 0x36a2, 0x0e7b, 0x0fb7, 0x152f,
        0x0056, 0x3414, 0x1fc9, 0x18c3, 0x317f, 0x1507, 0x158f, 0x1f58, 0x245f, 0x36b4, 0x01f1, 0x3891, 0x285d, 0x24c0, 0x0fff, 0x21b2,
        0x15d9, 0x33d4, 0x30d2, 0x212d, 0x0b21, 0x34f3, 0x2008, 0x2b06, 0x3256, 0x2975, 0x2243, 0x1acf, 0x3aeb, 0x0460, 0x23e6, 0x2de4,
        0x0e4f, 0x2bd5, 0x361c, 0x283f, 0x0e9a, 0x33c4, 0x3308, 0x1c4f, 0x2b6e, 0x0494, 0x06c6, 0x12fe, 0x3848, 0x2296, 0x3762, 0x0fc9,
        0x3b4f, 0x167c, 0x2cea, 0x121d, 0x0a9f, 0x0ea0, 0x30c1, 0x3603, 0x2504, 0x1bab, 0x0b6d, 0x3437, 0x1275, 0x0996, 0x3a4d, 0x1aa7,
        0x3ca4, 0x1d7e, 0x174e, 0x0c03, 0x26fb, 0x15fd, 0x1711, 0x3fef, 0x1a85, 0x0f8d, 0x0272, 0x346f, 0x383d, 0x29ff, 0x2ccf, 0x3ecf,
        0x3f2e, 0x2324, 0x1140, 0x374b, 0x2c0a, 0x312d, 0x1ec8, 0x0a6e, 0x128a, 0x1c11, 0x17ce, 0x3365, 0x2186, 0x0d00, 0x05ac, 0x32d3,
        0x138b, 0x0de4, 0x01d0, 0x3c70, 0x17ff, 0x3faf, 0x2433, 0x1f60, 0x1426, 0x296e, 0x235a, 0x3e87, 0x1078, 0x240c, 0x0254, 0x008f,
        0x3e9a, 0x263d, 0x1563, 0x37f1, 0x1d43, 0x33ca, 0x31ce, 0x3062, 0x0c54, 0x3197, 0x1b8c, 0x11ea, 0x1541, 0x2d04, 0x3220, 0x3ccb,
        0x2dc4, 0x0ab0, 0x2be5, 0x289e, 0x1136, 0x1f78, 0x2fdc, 0x0f7e, 0x33e8, 0x1168, 0x31e4, 0x3f86, 0x38da, 0x372a, 0x2e90, 0x17bf,
        0x15d1, 0x0d99, 0x04b9, 0x35b1, 0x1183, 0x1f3b, 0x302c, 0x02d9, 0x21a5, 0x025b, 0x034e, 0x20ab, 0x2bb2, 0x27a9, 0x3370, 0x396c,
        0x02f6, 0x3bd1, 0x1a8d, 0x07fa, 0x0410, 0x2b2e, 0x39ee, 0x0bea, 0x0011, 0x160d, 0x1722, 0x363a, 0x1642, 0x29e7, 0x1c06, 0x39b5,
        0x0571, 0x3ffe, 0x015a, 0x0ae3, 0x1ad8, 0x06cc, 0x1055, 0x012d, 0x288c, 0x15c7, 0x069f, 0x02b5, 0x0c3e, 0x2ed1, 0x3811, 0x204a,
        0x0288, 0x3d83, 0x25bc, 0x347c, 0x3443, 0x10d0, 0x109b, 0x11b0, 0x1b39, 0x1c33, 0x2237, 0x2dfe, 0x3d66, 0x0c11, 0x0827, 0x3f46,
        0x130b, 0x3047, 0x29ba, 0x1b43, 0x3743, 0x0a2b, 0x3b23, 0x11f6, 0x0487, 0x359e, 0x084b, 0x3cf4, 0x24ad, 0x12eb, 0x122b, 0x16f5,
        0x09ab, 0x38e2, 0x3ede, 0x03a1, 0x2d1b, 0x03e3, 0x14bf, 0x3124, 0x07cd, 0x1bc9, 0x193b, 0x2717, 0x35d7, 0x08c0, 0x261d, 0x2d6a,
        0x2141, 0x2178, 0x3f27, 0x2392, 0x2f59, 0x1304, 0x230f, 0x1bb4, 0x1b7f, 0x270c, 0x1d8e, 0x0583, 0x393f, 0x1c94, 0x3bac, 0x27e7,
        0x0144, 0x3ec1, 0x3a21, 0x0868, 0x22b8, 0x1fff, 0x0d6c, 0x0366, 0x00a2, 0x3f60, 0x115c, 0x2fff, 0x30a0, 0x10bc, 0x37ac, 0x0982,
        0x35b9, 0x1da4, 0x0f56, 0x187d, 0x3795, 0x2f2c, 0x20b5, 0x1e5a, 0x2365, 0x0096, 0x1768, 0x3024, 0x0f9d, 0x016c, 0x13d4, 0x3cb5,
        0x072a, 0x179d, 0x1c67, 0x3b65, 0x185d, 0x19c2, 0x2b42, 0x2a1f, 0x3b10, 0x0d32, 0x16ec, 0x09f9, 0x0241, 0x0dbd, 0x0267, 0x1d61,
        0x0d45, 0x2b8f, 0x32dc, 0x111a, 0x0e32, 0x2b74, 0x3e94, 0x3b49, 0x213b, 0x056b, 0x26e4, 0x0d3f, 0x3279, 0x1ead, 0x2c89, 0x30fb,
        0x3e54, 0x0075, 0x3d2c, 0x0f1d, 0x1ab6, 0x0451, 0x0913, 0x3dd3, 0x2ba9, 0x1a31, 0x3696, 0x1be8, 0x0955, 0x2e81, 0x1664, 0x328d,
        0x2f60, 0x3d1e, 0x0ef4, 0x11fe, 0x162e, 0x172c, 0x0b0d, 0x3612, 0x04d3, 0x209f, 0x2217, 0x0614, 0x370c, 0x16ce, 0x3571, 0x0a23,
        0x0434, 0x3d10, 0x01b3, 0x06b6, 0x11c9, 0x3f93, 0x0dda, 0x3187, 0x1a3e, 0x12de, 0x08d8, 0x284d, 0x2571, 0x00ad, 0x2096, 0x282a,
        0x26ea, 0x2d0d, 0x0a5d, 0x26b3, 0x2101, 0x049a, 0x2904, 0x2c46, 0x3ac7, 0x2881, 0x2126, 0x1840, 0x1876, 0x35aa, 0x08a7, 0x34cb,
        0x0c2d, 0x011f, 0x2d59, 0x04a9, 0x2206, 0x2b1f, 0x1a20, 0x3eb1, 0x2c7e, 0x081a, 0x03b6, 0x20f1, 0x175f, 0x2300, 0x0af5, 0x2a0f,
        0x0291, 0x1e27, 0x31a2, 0x34d2, 0x3405, 0x1466, 0x1770, 0x1a4a, 0x2c39, 0x107f, 0x3b84, 0x2b15, 0x1c9e, 0x17ab, 0x1255, 0x1ba0,
        0x1351, 0x3ae3, 0x0f95, 0x101d, 0x1c40, 0x22eb, 0x3142, 0x3c7e, 0x2611, 0x389e, 0x0909, 0x0a45, 0x1d34, 0x2789, 0x0b86, 0x3981,
        0x1eb3, 0x2608, 0x2d9c, 0x2e19, 0x061f, 0x3768, 0x1446, 0x2ae3, 0x1850, 0x085e, 0x0051, 0x1fb0, 0x3c9f, 0x0e4a, 0x2dbf, 0x1386,
        0x0283, 0x02f1, 0x013f, 0x09a6, 0x3e4f, 0x0725, 0x0c28, 0x042f, 0x027e, 0x134c, 0x36f9, 0x068c, 0x0506, 0x05e2, 0x1d0a, 0x173b,
        0x1bbb, 0x1067, 0x2f81, 0x1a96, 0x2872, 0x3579, 0x2403, 0x1cd1, 0x0d8c, 0x25fc, 0x1d24, 0x31f0, 0x16dd, 0x0928, 0x2663, 0x30aa,
        0x0691, 0x3732, 0x108b, 0x119f, 0x395d, 0x32cb, 0x0a1b, 0x3cff, 0x2ec5, 0x1f92, 0x0424, 0x34db, 0x3091, 0x052d, 0x110a, 0x2778,
        0x327f, 0x3928, 0x2e58, 0x2c5c, 0x3759, 0x0fcf, 0x2c25, 0x161a, 0x3a14, 0x2e76, 0x31b8, 0x291e, 0x0a0c, 0x0bc4, 0x053e, 0x2673,
        0x36fe, 0x0e19, 0x3a3d, 0x1ec1, 0x3b1c, 0x0b06, 0x23fc, 0x1de8, 0x2df3, 0x0d18, 0x078e, 0x003a, 0x04fc, 0x2698, 0x1db2, 0x0bce,
        0x04c1, 0x1bd6, 0x37ff, 0x08ae, 0x33f3, 0x1dd6, 0x22c1, 0x0ec7, 0x1fa3, 0x2413, 0x16ff, 0x311b, 0x1025, 0x3c08, 0x215a, 0x234f,
        0x05e7, 0x0ed9, 0x001d, 0x03c7, 0x3339, 0x029f, 0x148f, 0x18dc, 0x2b9d, 0x0e85, 0x0346, 0x3b7c, 0x09c3, 0x36df, 0x0fd8, 0x2028,
        0x3101, 0x0bae, 0x08e3, 0x12b7, 0x315a, 0x384e, 0x168c, 0x1aea, 0x2eb8, 0x0407, 0x00bc, 0x1269, 0x30e6, 0x01fd, 0x0ccc, 0x13a4,
        0x050b, 0x31fb, 0x366d, 0x2069, 0x241f, 0x0ac5, 0x1217, 0x37eb, 0x0add, 0x238c, 0x1114, 0x26ad, 0x2e13, 0x2c56, 0x12b1, 0x3907,
        0x2316, 0x3a9a, 0x3f10, 0x3b2b, 0x3551, 0x14c8, 0x1def, 0x2633, 0x2942, 0x2627, 0x23cc, 0x3f05, 0x349e, 0x294f, 0x26c3, 0x3d07,
        0x1740, 0x1946, 0x0228, 0x1ee9, 0x06de, 0x0eb0, 0x2ce0, 0x150f, 0x0608, 0x3fa2, 0x2867, 0x28d7, 0x14f3, 0x1cda, 0x3596, 0x25f4,
        0x2c8f, 0x07d9, 0x22d3, 0x390d, 0x132f, 0x229c, 0x135f, 0x07b3, 0x12a4, 0x3566, 0x27d4, 0x0083, 0x24ed, 0x1c5e, 0x0f6b, 0x0389,
        0x1d0f, 0x28ac, 0x3f6d, 0x0c9c, 0x16ab, 0x21d9, 0x00d8, 0x246a, 0x047c, 0x30b4, 0x2f91, 0x34ec, 0x1f34, 0x2f25, 0x145f, 0x1dcf,
        0x06d7, 0x3956, 0x11c2, 0x2d14, 0x17f8, 0x1d16, 0x0174, 0x1994, 0x37c4, 0x01d7, 0x09cb, 0x30dc, 0x1bf1, 0x1ff3, 0x2a72, 0x0a3a,
        0x1e2c, 0x28eb, 0x2cd7, 0x242a, 0x00c5, 0x133e, 0x2224, 0x255e, 0x0d4f, 0x29cd, 0x037f, 0x3263, 0x0d0c, 0x0068, 0x36d4, 0x1b5f,
        0x007b, 0x1838, 0x11e2, 0x3107, 0x325f, 0x30d8, 0x0a83, 0x2fab, 0x3205, 0x0047, 0x1fd7, 0x2faf, 0x3b94, 0x0bdf, 0x2fbb, 0x27be,
        0x0296, 0x33bb, 0x1965, 0x1e7f, 0x334b, 0x25e6, 0x2582, 0x2ef3, 0x2e6c, 0x32f9, 0x2757, 0x0a87, 0x1792, 0x0ee7, 0x10ec, 0x3234,
        0x2713, 0x3cf0, 0x2ffb, 0x057f, 0x3636, 0x20a7, 0x2dfa, 0x02b1, 0x2849, 0x0610, 0x20ed, 0x183c, 0x09f5, 0x3020, 0x1be4, 0x0d3b,
        0x34d7, 0x31ec, 0x0036, 0x291a, 0x0a41, 0x2b11, 0x0688, 0x1fac, 0x28d3, 0x3f01, 0x34e8, 0x007f, 0x3b78, 0x3117, 0x26a9, 0x1265,
        0x3e5a, 0x09ea, 0x1812, 0x0bb4, 0x2eb0, 0x2133, 0x24fc, 0x0b76, 0x2511, 0x3ab8, 0x030a, 0x310b, 0x1415, 0x104b, 0x3426, 0x046c,
        0x31a7, 0x10ad, 0x388d, 0x2b7f, 0x1014, 0x07ec, 0x1dbe, 0x01a3, 0x3e83, 0x3361, 0x3f82, 0x11e6, 0x12fa, 0x1acb, 0x346b, 0x3433,
        0x1f43, 0x34b6, 0x3e37, 0x26f1, 0x3fc2, 0x28b3, 0x344e, 0x2557, 0x18d5, 0x3c77, 0x2a18, 0x0be3, 0x1c48, 0x3b59, 0x0c61, 0x3a09,
        0x146b, 0x3fd0, 0x0f74, 0x2ca2, 0x3a75, 0x3859, 0x264d, 0x3455, 0x1a6d, 0x2fc8, 0x08cf, 0x3b98, 0x201c, 0x268b, 0x0f60, 0x070c,
        0x0f23, 0x18ee, 0x218f, 0x08e9, 0x0195, 0x15df, 0x0cee, 0x2cbd, 0x0bbc, 0x1c8c, 0x0e73, 0x27c2, 0x0f0b, 0x2f4e, 0x03d1, 0x1043,
        0x340a, 0x0657, 0x207d, 0x3390, 0x17ea, 0x2498, 0x27f3, 0x39cf, 0x0d29, 0x1780, 0x1c7a, 0x2fbf, 0x0a52, 0x1248, 0x2afa, 0x1f0d,
        0x1b86, 0x0b67, 0x2269, 0x304f, 0x32b8, 0x2056, 0x0d1f, 0x096f, 0x27ce, 0x00b6, 0x31b2, 0x004b, 0x2120, 0x26de, 0x1d88, 0x0699,
        0x1a4f, 0x34a7, 0x14a1, 0x3313, 0x2a79, 0x0e6d, 0x0304, 0x1fd1, 0x2812, 0x1e04, 0x2fd1, 0x3209, 0x24e1, 0x3b6f, 0x35ce, 0x2742,
        0x3d32, 0x3229, 0x3a83, 0x12bd, 0x10e2, 0x33da, 0x3773, 0x3517, 0x18a5, 0x03f2, 0x2a7f, 0x2fb3, 0x2db7, 0x3809, 0x1b15, 0x2e41,
        0x1775, 0x23b1, 0x1e13, 0x16ba, 0x2d3c, 0x1ac1, 0x33a7, 0x2d80, 0x1e43, 0x38b4, 0x0327, 0x1fdb, 0x39ac, 0x1297, 0x112a, 0x1b56,
        0x3485, 0x3dfa, 0x05a3, 0x26ba, 0x3244, 0x3f74, 0x0fa5, 0x1ed2, 0x14e1, 0x1392, 0x36e7, 0x25ea, 0x02e4, 0x2380, 0x1a0e, 0x2f1a,
        0x1084, 0x0221, 0x3ed7, 0x01ac, 0x210b, 0x01c9, 0x1f1f, 0x28ba, 0x2da5, 0x06fa, 0x09b9, 0x334f, 0x0445, 0x19ab, 0x002f, 0x149a,
        0x0457, 0x3bff, 0x2763, 0x3160, 0x21e3, 0x200e, 0x0c6e, 0x2a47, 0x3d95, 0x1f88, 0x3319, 0x2ef7, 0x2f74, 0x0114, 0x2a87, 0x1670,
        0x2c3e, 0x07ab, 0x0f2d, 0x305a, 0x3db2, 0x2e33, 0x350f, 0x15a1, 0x08ff, 0x077a, 0x1b09, 0x2586, 0x035b, 0x20d9, 0x38c3, 0x06ed,
        0x058a, 0x3de3, 0x3e1d, 0x3bda, 0x1f6a, 0x04db, 0x0795, 0x0d83, 0x1f73, 0x3faa, 0x15f8, 0x33bf, 0x1502, 0x23c0, 0x0880, 0x06ac,
        0x2b1a, 0x3f8e, 0x044c, 0x19bd, 0x1ffa, 0x03de, 0x10cb, 0x2b29, 0x21d4, 0x0eab, 0x0ac0, 0x029a, 0x0b01, 0x32c6, 0x0720, 0x22e6,
        0x1abc, 0x0e68, 0x2493, 0x3854, 0x07e7, 0x2b0c, 0x25e1, 0x1339, 0x2a63, 0x1319, 0x14a7, 0x1e83, 0x314d, 0x03d9, 0x2e2e, 0x01c4,
        0x3b89, 0x0661, 0x018d, 0x1cbb, 0x0e2a, 0x3152, 0x073d, 0x0a97, 0x1896, 0x2536, 0x267f, 0x1969, 0x39e4, 0x3830, 0x3681, 0x1e65,
        0x118b, 0x1d4d, 0x3aa8, 0x0a64, 0x0ba0, 0x0ca3, 0x036f, 0x0758, 0x2260, 0x0deb, 0x39f9, 0x0eeb, 0x22f3, 0x276c, 0x399c, 0x214f,
        0x17b0, 0x1e8f, 0x0b17, 0x0b96, 0x021a, 0x1e88, 0x28e4, 0x3fc9, 0x3adc, 0x0ed2, 0x3bca, 0x1796, 0x0395, 0x2bce, 0x2c2e, 0x0ce1,
        0x3dd9, 0x2ab8, 0x1519, 0x1692, 0x1cc3, 0x0b27, 0x3be5, 0x329d, 0x181a, 0x1d9b, 0x34ad, 0x3238, 0x13c7, 0x0f4b, 0x2446, 0x0cb7,
        0x1ca3, 0x0599, 0x3c3e, 0x1b22, 0x3e41, 0x14ac, 0x04e9, 0x0333, 0x2170, 0x3920, 0x37b8, 0x10f0, 0x1178, 0x25ce, 0x09e2, 0x0e60,
        0x1d95, 0x3d4c, 0x1f82, 0x1313, 0x1c86, 0x03ec, 0x0041, 0x3ab2, 0x2d4a, 0x0833, 0x38f7, 0x32fd, 0x362d, 0x3c93, 0x348e, 0x373a,
        0x1ba5, 0x3191, 0x19b2, 0x0e08, 0x1bf8, 0x131e, 0x28f4, 0x18cb, 0x0401, 0x3560, 0x0858, 0x2e70, 0x0565, 0x287b, 0x15c1, 0x2706,
        0x0919, 0x1df9, 0x2f03, 0x1af0, 0x3016, 0x34f9, 0x1906, 0x15a9, 0x1cfb, 0x3d52, 0x1a55, 0x0a8b, 0x1b72, 0x02d0, 0x198b, 0x13b0,
        0x125a, 0x1954, 0x3c5b, 0x3cdf, 0x2c70, 0x2a68, 0x0fef, 0x2cac, 0x05f9, 0x2b4d, 0x11da, 0x275b, 0x0152, 0x2d94, 0x2b5e, 0x1e72,
        0x2896, 0x0b51, 0x0c94, 0x04a1, 0x3cd7, 0x16b2, 0x3cbd, 0x13b9, 0x19d5, 0x243a, 0x0fe0, 0x1d1a, 0x369f, 0x2cf8, 0x285a, 0x317c,
        0x3ae8, 0x0b1e, 0x3845, 0x0e97, 0x1272, 0x0a9c, 0x383a, 0x26f8, 0x2183, 0x2c07, 0x1075, 0x17fc, 0x153e, 0x1d40, 0x38d7, 0x1133,
        0x1a37, 0x07c6, 0x0601, 0x2ebe, 0x297e, 0x2249, 0x141f, 0x15ea, 0x2ee0, 0x3494, 0x2748, 0x1998, 0x280b, 0x28cc, 0x03fa, 0x21cd,
        0x1356, 0x31c5, 0x1034, 0x18fd, 0x3dbd, 0x0742, 0x01e3, 0x076c, 0x2345, 0x29a5, 0x24d2, 0x0178, 0x0522, 0x3c4e, 0x080e, 0x1d71,
        0x1c9b, 0x3402, 0x1d31, 0x1c3d, 0x3c9c, 0x061c, 0x0503, 0x3e4c, 0x16da, 0x286f, 0x308e, 0x395a, 0x0a09, 0x3756, 0x04f9, 0x3b19,
        0x1022, 0x33f0, 0x09c0, 0x3336, 0x30e3, 0x3157, 0x2e10, 0x241c, 0x349b, 0x354e, 0x14f0, 0x06db, 0x24ea, 0x132c, 0x1f31, 0x16a8,
        0x2baf, 0x1180, 0x163f, 0x040d, 0x0c3b, 0x1ad5, 0x3d63, 0x3440, 0x24aa, 0x3740, 0x35d4, 0x2d18, 0x393c, 0x2f56, 0x309d, 0x22b5,
        0x0f9a, 0x3792, 0x023e, 0x185a, 0x3276, 0x0e2f, 0x0952, 0x1ab3, 0x3709, 0x162b, 0x256e, 0x11c6, 0x1873, 0x20fe, 0x175c, 0x2203,
        0x02e1, 0x3241, 0x0442, 0x2108, 0x2f71, 0x21e0, 0x0358, 0x3daf, 0x14ff, 0x1f67, 0x0afe, 0x1ff7, 0x314a, 0x07e4, 0x39e1, 0x0e27,
        0x22f0, 0x0b9d, 0x0392, 0x0217, 0x13c4, 0x1cc0, 0x1175, 0x3e3e, 0x362a, 0x1c83, 0x0562, 0x1bf5, 0x1b6f, 0x3013, 0x014f, 0x2c6d,
        0x1bee, 0x17f5, 0x0d09, 0x00c2, 0x3b91, 0x325c, 0x178f, 0x3348, 0x09f2, 0x3633, 0x3b75, 0x0a3e, 0x1412, 0x2ead, 0x12f7, 0x1011,
        0x1c45, 0x3fbf, 0x2019, 0x3a72, 0x0f08, 0x0192, 0x0a4f, 0x17e7, 0x211d, 0x32b5, 0x24de, 0x2a76, 0x2db4, 0x10df, 0x39a9, 0x2d39,
        0x3946, 0x0b32, 0x0df4, 0x1b4b, 0x387d, 0x3644, 0x269f, 0x1372, 0x3507, 0x257a, 0x3078, 0x01db, 0x3a65, 0x2453, 0x0c20, 0x1093,
        0x3c83, 0x2958, 0x3356, 0x088a, 0x09d2, 0x0666, 0x2934, 0x005e, 0x2ee7, 0x2a2f, 0x1a76, 0x37c8, 0x21c4, 0x27b5, 0x2041, 0x13ea,
        0x369c, 0x3cd4, 0x153b, 0x126f, 0x2808, 0x297b, 0x051f, 0x3dba, 0x0a06, 0x3c99, 0x24e7, 0x30e0, 0x3939, 0x0c38, 0x1870, 0x3273,
        0x3147, 0x2f6e, 0x1b6c, 0x13c1, 0x140f, 0x3b8e, 0x2db1, 0x0f05, 0x3a62, 0x387a, 0x21c1, 0x09cf, 0x3936, 0x2805, 0x3933, 0x140c,
        0x25c5, 0x2a94, 0x29f6, 0x2c4d, 0x0b35, 0x00df, 0x13dc, 0x0233, 0x2e9c, 0x1806, 0x2030, 0x1342, 0x3949, 0x3afc, 0x2334, 0x3d78,
        0x38a3, 0x17b7, 0x2a07, 0x1dc7, 0x1b4e, 0x1e6a, 0x1404, 0x34bd, 0x2e22, 0x3fdf, 0x0784, 0x00c9, 0x0df7, 0x2bfa, 0x3dc8, 0x192e,
        0x2e87, 0x1456, 0x2b55, 0x30ec, 0x3647, 0x23ec, 0x2997, 0x114e, 0x2285, 0x38fd, 0x320f, 0x2562, 0x3880, 0x05d7, 0x18ad, 0x1c27,
        0x2616, 0x208f, 0x1103, 0x358f, 0x1375, 0x3686, 0x3080, 0x024d, 0x1f2a, 0x203a, 0x0d5b, 0x2228, 0x26a2, 0x35c7, 0x0719, 0x15ba,
        0x27ee, 0x2648, 0x33a2, 0x02ff, 0x257d, 0x221f, 0x1db9, 0x0683, 0x04e4, 0x28df, 0x0fea, 0x28ef, 0x350a, 0x1f1a, 0x0738, 0x10c6,
        0x0a4a, 0x1170, 0x2dac, 0x292f, 0x01de, 0x3835, 0x094d, 0x2e0b, 0x199f, 0x3d9f, 0x36c1, 0x1e30, 0x307b, 0x13ff, 0x0d62, 0x0948,
        0x095b, 0x25d6, 0x0934, 0x0203, 0x2456, 0x2dea, 0x188d, 0x1209, 0x170c, 0x3303, 0x2fd7, 0x242e, 0x3a68, 0x0f13, 0x158a, 0x083f,
        0x090e, 0x2b3d, 0x1a1b, 0x0dd5, 0x1096, 0x39e9, 0x0d67, 0x14ba, 0x1212, 0x148a, 0x00d3, 0x2cdb, 0x0c23, 0x313d, 0x23f7, 0x0a16,
        0x3034, 0x3b36, 0x3bf5, 0x290b, 0x295b, 0x2471, 0x0d75, 0x0b46, 0x064e, 0x3fb6, 0x1235, 0x006c, 0x3c86, 0x3169, 0x23d9, 0x29af,
        0x278e, 0x1e96, 0x3ee9, 0x2489, 0x088d, 0x196e, 0x3da4, 0x1f4a, 0x2254, 0x36ac, 0x3f58, 0x0d10, 0x3359, 0x252e, 0x1623, 0x1482,
        0x3293, 0x35f9, 0x35e3, 0x0cd2, 0x0669, 0x3af1, 0x2aaa, 0x1555, 0x3e62, 0x2d50, 0x1e0a, 0x1b63, 0x09d5, 0x2658, 0x371d, 0x281e,
        0x1d39, 0x300c, 0x2bf3, 0x2527, 0x0061, 0x2684, 0x19a4, 0x2bc7, 0x29e0, 0x0db6, 0x2782, 0x36d8, 0x2937, 0x2a9d, 0x1edd, 0x228f,
        0x3bb3, 0x1571, 0x2724, 0x29c2, 0x2a32, 0x2d24, 0x0bd5, 0x2dcf, 0x3c26, 0x2d74, 0x00fe, 0x29d1, 0x2eea, 0x0763, 0x3e03, 0x11a7,
        0x3986, 0x164e, 0x0701, 0x05c8, 0x37cb, 0x253b, 0x1e35, 0x341c, 0x274f, 0x1b01, 0x24ca, 0x0d53, 0x1a79, 0x3582, 0x222f, 0x36f1,
        0x166a, 0x01be, 0x0cb1, 0x13aa, 0x27b8, 0x0466, 0x103d, 0x2e3b, 0x1c21, 0x0839, 0x2818, 0x3267, 0x21c7, 0x22af, 0x100b, 0x326d,
        0x0b8b, 0x1529, 0x1aa1, 0x3cc5, 0x13ed, 0x189b, 0x36c6, 0x3c14, 0x1380, 0x266d, 0x139e, 0x0383, 0x2044, 0x27e1, 0x30f5, 0x34c5,
        0x0aef, 0x165e, 0x37a6, 0x0821, 0x1459, 0x12ab, 0x1dac, 0x1d04, 0x386b, 0x17d5, 0x05ef, 0x33de, 0x2e8a, 0x2cc9, 0x0ff9, 0x251c,
        0x392d, 0x39a3, 0x1756, 0x0808, 0x30ef, 0x1ed7, 0x23f1, 0x0713, 0x1124, 0x2af4, 0x3465, 0x10e6, 0x2b58, 0x09dc, 0x367b, 0x38bd,
        0x1daa, 0x37a4, 0x0ff7, 0x05ed, 0x23ef, 0x1754, 0x3679, 0x3463, 0x3677, 0x0ff5, 0x351d, 0x351b, 0x364a, 0x2d2e, 0x351f, 0x37d1,
        0x3284, 0x352d, 0x2d30, 0x1f04, 0x1151, 0x0faa, 0x364c, 0x0107, 0x05b9, 0x20cf, 0x37d3, 0x3777, 0x299a, 0x2549, 0x3521, 0x2ace,
        0x3ec8, 0x247d, 0x352f, 0x0c49, 0x3900, 0x1734, 0x3286, 0x3f3f, 0x0e59, 0x06e6, 0x1f06, 0x322d, 0x2288, 0x15b3, 0x2d32, 0x1d6a,
        0x2c61, 0x2fe4, 0x0fac, 0x2ac7, 0x2565, 0x3f79, 0x1153, 0x2163, 0x0749, 0x0c7c, 0x0109, 0x3d36, 0x3212, 0x0f3d, 0x364e, 0x39c5,
        0x35bf, 0x3c46, 0x20d1, 0x0edf, 0x05da, 0x0c09, 0x05bb, 0x127e, 0x2f3f, 0x2cb2, 0x3779, 0x12c1, 0x3883, 0x08f1, 0x37d5, 0x2541,
        0x2e5d, 0x20c6, 0x254b, 0x239e, 0x1c2a, 0x3249, 0x299c, 0x32f0, 0x182d, 0x2796, 0x2ad0, 0x3a87, 0x18b0, 0x33b1, 0x3523, 0x0637,
        0x0263, 0x13d0, 0x1660, 0x2c85, 0x2092, 0x356d, 0x0af1, 0x08a3, 0x1c02, 0x336c, 0x0823, 0x380d, 0x2619, 0x1227, 0x37a8, 0x3ba8,
        0x0fd4, 0x2156, 0x12ad, 0x0cc8, 0x3592, 0x26bf, 0x145b, 0x0f67, 0x0b82, 0x1251, 0x1d06, 0x2dbb, 0x1106, 0x265f, 0x1dae, 0x053a,
        0x1883, 0x2c1b, 0x17d7, 0x0023, 0x3689, 0x3caa, 0x386d, 0x00eb, 0x0474, 0x2c76, 0x33e0, 0x2e45, 0x1378, 0x3a5a, 0x05f1, 0x1e3b,
        0x375e, 0x23e2, 0x2ccb, 0x3a49, 0x0250, 0x05a8, 0x2e8c, 0x321c, 0x2060, 0x0bfa, 0x251e, 0x1b19, 0x3083, 0x1920, 0x0ffb, 0x0fb3,
        0x014b, 0x39dd, 0x39a5, 0x12f3, 0x203d, 0x0c1c, 0x392f, 0x186c, 0x38d3, 0x2856, 0x080a, 0x03f6, 0x1f2d, 0x04f5, 0x1758, 0x3099,
        0x161f, 0x23d5, 0x1ed9, 0x3719, 0x222b, 0x3dff, 0x30f1, 0x1007, 0x3dc4, 0x2330, 0x0715, 0x18a9, 0x0d5e, 0x0734, 0x23f3, 0x1586,
        0x0f5c, 0x0c5d, 0x2af6, 0x03cd, 0x35ca, 0x1d84, 0x1126, 0x1b11, 0x36d0, 0x2a6e, 0x10e8, 0x2fb7, 0x26a5, 0x1be0, 0x3467, 0x3422,
        0x2c2a, 0x3998, 0x09de, 0x2442, 0x15bd, 0x348a, 0x2b5a, 0x1987, 0x002b, 0x1a0a, 0x38bf, 0x2a83, 0x071c, 0x087c, 0x367d, 0x2e2a,
        0x10d9, 0x27ff, 0x3c48, 0x20f8, 0x2a97, 0x27db, 0x35c1, 0x3137, 0x1242, 0x1291, 0x0ee1, 0x1ac5, 0x25c8, 0x2d8e, 0x20d3, 0x382a,
        0x2e7b, 0x22fa, 0x0c0b, 0x10b6, 0x2c50, 0x2f1f, 0x05dc, 0x2692, 0x0628, 0x19f2, 0x1280, 0x2d40, 0x29f9, 0x3724, 0x05bd, 0x24ba,
        0x2f32, 0x3b40, 0x2cb4, 0x333f, 0x00e2, 0x1717, 0x2f41, 0x2a53, 0x2376, 0x3c61, 0x12c3, 0x2d84, 0x0b38, 0x3543, 0x377b, 0x398c,
        0x3a19, 0x3a35, 0x08f3, 0x1fc1, 0x0236, 0x1a13, 0x3885, 0x0185, 0x191a, 0x0876, 0x2543, 0x33ab, 0x13df, 0x37dd, 0x37d7, 0x2feb,
        0x086f, 0x169c, 0x20c8, 0x0bf3, 0x1809, 0x1636, 0x2e5f, 0x3f1e, 0x3e26, 0x0eb8, 0x23a0, 0x23b5, 0x2e9f, 0x0899, 0x254d, 0x337b,
        0x2923, 0x0f86, 0x324b, 0x1ce7, 0x1345, 0x2385, 0x1c2c, 0x1a2a, 0x0773, 0x3919, 0x32f2, 0x1779, 0x2033, 0x0daf, 0x299e, 0x32ae,
        0x379b, 0x1b2a, 0x2798, 0x02a5, 0x3aff, 0x3ff5, 0x182f, 0x07bd, 0x365c, 0x3ce5, 0x3a89, 0x16be, 0x394c, 0x2197, 0x2ad2, 0x1654,
        0x31bd, 0x2087, 0x33b3, 0x07a3, 0x3d7b, 0x02e9, 0x18b2, 0x3329, 0x0964, 0x1e9e, 0x0639, 0x1e17, 0x2337, 0x2ff1, 0x3525, 0x3a2d,
        0x21ad, 0x306c, 0x247f, 0x03bd, 0x17ba, 0x008a, 0x3eca, 0x0fc4, 0x1cf2, 0x1c18, 0x0c4b, 0x129b, 0x38a6, 0x21ec, 0x3531, 0x298c,
        0x0bc9, 0x2773, 0x1736, 0x397c, 0x1dca, 0x25ef, 0x3902, 0x2023, 0x097d, 0x2d65, 0x3f41, 0x39b0, 0x2a0a, 0x2825, 0x3288, 0x1d5c,
        0x1e60, 0x22e1, 0x06e8, 0x1495, 0x1e6d, 0x2701, 0x0e5b, 0x0cdc, 0x342e, 0x1260, 0x322f, 0x1b5a, 0x1b51, 0x273d, 0x1f08, 0x0707,
        0x0a11, 0x0943, 0x15b5, 0x1929, 0x34c0, 0x36ec, 0x228a, 0x147d, 0x21fe, 0x16a3, 0x1d6c, 0x112e, 0x1407, 0x13e5, 0x2d34, 0x2c68,
        0x3a28, 0x32a9, 0x2fe6, 0x24b5, 0x3fe2, 0x03aa, 0x2c63, 0x1d57, 0x0632, 0x39c0, 0x2ac9, 0x38b8, 0x2e25, 0x1581, 0x0fae, 0x0535,
        0x2678, 0x11d3, 0x3f7b, 0x0320, 0x00cc, 0x1397, 0x2567, 0x21ba, 0x01ea, 0x31dd, 0x2165, 0x1e47, 0x0787, 0x2f8a, 0x1155, 0x03af,
        0x20bb, 0x14d2, 0x0c7e, 0x18e2, 0x2bfd, 0x1603, 0x074b, 0x258e, 0x353a, 0x195a, 0x3d38, 0x1fdf, 0x0dfa, 0x0e41, 0x010b, 0x05ce,
        0x0543, 0x197c, 0x0f3f, 0x19dd, 0x1931, 0x14e6, 0x3214, 0x1475, 0x17df, 0x2bbf, 0x39c7, 0x032b, 0x3dcb, 0x37e3, 0x3650, 0x3fe7,
        0x02bf, 0x3e77, 0x2c1d, 0x2307, 0x25d9, 0x24f4, 0x1885, 0x3d5b, 0x1827, 0x05b3, 0x0025, 0x205a, 0x095e, 0x1914, 0x17d9, 0x21f8,
        0x0e1e, 0x3a00, 0x3cac, 0x1437, 0x0206, 0x28bf, 0x368b, 0x3b9f, 0x0da5, 0x2598, 0x00ed, 0x32bc, 0x0937, 0x3e69, 0x386f, 0x1e4c,
        0x009c, 0x1b33, 0x2c78, 0x2ba3, 0x2ded, 0x0278, 0x0476, 0x0ad7, 0x3ad2, 0x2b64, 0x2e47, 0x0973, 0x2459, 0x0dca, 0x33e2, 0x1a7f,
        0x3703, 0x233f, 0x3a5c, 0x2117, 0x120c, 0x1f24, 0x137a, 0x29da, 0x3e7d, 0x2e66, 0x1e3d, 0x0d23, 0x1890, 0x08f9, 0x05f3, 0x216a,
        0x2006, 0x30d0, 0x23e4, 0x2241, 0x3306, 0x361a, 0x3760, 0x06c4, 0x30bf, 0x2ce8, 0x3a4b, 0x0b6b, 0x170f, 0x174c, 0x2ccd, 0x0270,
        0x1ec6, 0x113e, 0x05aa, 0x17cc, 0x2431, 0x01ce, 0x0252, 0x2358, 0x31cc, 0x1561, 0x321e, 0x1b8a, 0x2fda, 0x2be3, 0x2e8e, 0x31e2,
        0x236b, 0x1cab, 0x0bfc, 0x0e8b, 0x0f16, 0x3475, 0x2062, 0x099f, 0x3389, 0x1e78, 0x1b1b, 0x3053, 0x3a6b, 0x18f6, 0x2520, 0x3588,
        0x3a42, 0x1efd, 0x1922, 0x1fba, 0x0842, 0x2110, 0x3085, 0x20e4, 0x02c5, 0x3ef1, 0x0fb5, 0x226d, 0x158d, 0x1fc7, 0x0ffd, 0x01ef,
        0x20b3, 0x0f54, 0x13d2, 0x1766, 0x2b40, 0x1c65, 0x0265, 0x16ea, 0x3e92, 0x32da, 0x2c87, 0x26e2, 0x0911, 0x3d2a, 0x1662, 0x3694,
        0x0b0b, 0x0ef2, 0x356f, 0x2215, 0x0dd8, 0x01b1, 0x2094, 0x08d6, 0x2902, 0x0a5b, 0x08a5, 0x2124, 0x1a1e, 0x2d57, 0x0af3, 0x03b4,
        0x302a, 0x04b7, 0x336e, 0x034c, 0x39ec, 0x1a8b, 0x1c04, 0x1720, 0x1053, 0x0158, 0x380f, 0x069d, 0x1099, 0x25ba, 0x0825, 0x2235,
        0x3b21, 0x29b8, 0x1229, 0x0849, 0x14bd, 0x3edc, 0x261b, 0x1939, 0x230d, 0x3f25, 0x3baa, 0x1d8c, 0x0d6a, 0x3a1f, 0x37aa, 0x115a,
        0x22bf, 0x37fd, 0x2158, 0x16fd, 0x148d, 0x001b, 0x0fd6, 0x0344, 0x168a, 0x08e1, 0x0cca, 0x00ba, 0x1215, 0x366b, 0x12af, 0x1112,
        0x1ded, 0x3f0e, 0x26c1, 0x23ca, 0x2cde, 0x0226, 0x3594, 0x2865, 0x135d, 0x22d1, 0x0f69, 0x27d2, 0x00d6, 0x3f6b, 0x145d, 0x2f8f,
        0x176e, 0x31a0, 0x1253, 0x3b82, 0x3140, 0x0f93, 0x0b84, 0x0907, 0x1444, 0x2d9a, 0x2dbd, 0x004f, 0x0c26, 0x013d, 0x1d08, 0x36f7,
        0x2401, 0x2f7f, 0x2661, 0x1d22, 0x0a19, 0x1089, 0x1108, 0x0422, 0x2c23, 0x2e56, 0x053c, 0x31b6, 0x23fa, 0x3a3b, 0x1db0, 0x078c,
        0x344c, 0x3e35, 0x0c5f, 0x2a16, 0x264b, 0x0f72, 0x0f5e, 0x08cd, 0x0cec, 0x218d, 0x03cf, 0x0e71, 0x27f1, 0x207b, 0x2af8, 0x1c78,
        0x0d1d, 0x2267, 0x1d86, 0x31b0, 0x0302, 0x149f, 0x35cc, 0x2fcf, 0x3771, 0x3a81, 0x1b13, 0x2a7d, 0x33a5, 0x1e11, 0x1128, 0x0325,
        0x0172, 0x11c0, 0x2a70, 0x09c9, 0x2222, 0x2cd5, 0x36d2, 0x037d, 0x0a81, 0x11e0, 0x2fb9, 0x1fd5, 0x2580, 0x1963, 0x10ea, 0x2755,
        0x2df8, 0x2ff9, 0x1be2, 0x20eb, 0x0686, 0x0034, 0x26a7, 0x34e6, 0x24fa, 0x1810, 0x3424, 0x0308, 0x1dbc, 0x388b, 0x3469, 0x3f80,
        0x036d, 0x3aa6, 0x399a, 0x39f7, 0x28e2, 0x0b15, 0x2c2c, 0x3bc8, 0x3be3, 0x1517, 0x2444, 0x34ab, 0x04e7, 0x3c3c, 0x09e0, 0x37b6,
        0x003f, 0x1f80, 0x348c, 0x38f5, 0x28f2, 0x19b0, 0x15bf, 0x0856, 0x1904, 0x2f01, 0x1989, 0x1a53, 0x0fed, 0x3c59, 0x2b5c, 0x11d8,
        0x0fa3, 0x05a1, 0x1a0c, 0x36e5, 0x1f1d, 0x3ed5, 0x002d, 0x09b7, 0x0c6c, 0x2761, 0x2a85, 0x3317, 0x350d, 0x0f2b, 0x38c1, 0x1b07,
        0x0793, 0x3e1b, 0x087e, 0x15f6, 0x10c9, 0x044a, 0x071e, 0x0abe, 0x25df, 0x2491, 0x2e2c, 0x14a5, 0x073b, 0x018b, 0x367f, 0x267d,
        0x0356, 0x0440, 0x39df, 0x0afc, 0x1173, 0x0390, 0x014d, 0x0560, 0x178d, 0x0d07, 0x12f5, 0x3b73, 0x0a4d, 0x2017, 0x39a7, 0x24dc,
        0x269d, 0x0df2, 0x0c1e, 0x3076, 0x2932, 0x3354, 0x203f, 0x1a74, 0x051d, 0x1539, 0x186e, 0x24e5, 0x2daf, 0x1b6a, 0x3931, 0x21bf,
        0x3cbb, 0x0c92, 0x2858, 0x0fde, 0x3838, 0x3843, 0x38d5, 0x1073, 0x141d, 0x05ff, 0x03f8, 0x2746, 0x01e1, 0x1032, 0x080c, 0x24d0,
        0x0501, 0x1d2f, 0x04f7, 0x308c, 0x2e0e, 0x09be, 0x1f2f, 0x14ee, 0x3d61, 0x163d, 0x309b, 0x35d2, 0x0950, 0x023c, 0x175a, 0x256c,
        0x0d73, 0x3bf3, 0x23d7, 0x1233, 0x3da2, 0x3ee7, 0x1621, 0x3f56, 0x2aa8, 0x35e1, 0x371b, 0x1e08, 0x19a2, 0x2bf1, 0x1edb, 0x2780,
        0x0bd3, 0x2722, 0x3e01, 0x00fc, 0x1e33, 0x06ff, 0x222d, 0x24c8, 0x103b, 0x0caf, 0x1009, 0x2816, 0x36c4, 0x1a9f, 0x30f3, 0x139c,
        0x13da, 0x29f4, 0x2332, 0x202e, 0x1402, 0x2a05, 0x3dc6, 0x0782, 0x2995, 0x2b53, 0x18ab, 0x320d, 0x307e, 0x1101, 0x0717, 0x0d59,
        0x1db7, 0x33a0, 0x0736, 0x0fe8, 0x094b, 0x2daa, 0x0d60, 0x36bf, 0x188b, 0x0932, 0x1588, 0x2fd5, 0x0d65, 0x1a19, 0x23f5, 0x00d1,
        0x1ae3, 0x2adc, 0x3b42, 0x0126, 0x35fc, 0x2c96, 0x2f34, 0x1a5e, 0x154e, 0x1147, 0x3341, 0x15e3, 0x3296, 0x2a40, 0x2cb6, 0x2fa4,
        0x106c, 0x0376, 0x1719, 0x0ad0, 0x0cd5, 0x2a4c, 0x00e4, 0x345c, 0x32e6, 0x272f, 0x2a55, 0x0199, 0x35e6, 0x0670, 0x2f43, 0x1fe4,
        0x17a3, 0x27a1, 0x3c63, 0x04c7, 0x3af4, 0x2cf0, 0x2378, 0x1feb, 0x2073, 0x190c, 0x2d86, 0x2cc1, 0x066c, 0x2a3c, 0x12c5, 0x2a38,
        0x1bc0, 0x0641, 0x3545, 0x3ef8, 0x1558, 0x0c73, 0x0b3a, 0x3c2f, 0x259e, 0x23a7, 0x398e, 0x0cf2, 0x2aad, 0x12c9, 0x377d, 0x3d3d,
        0x3f67, 0x3667, 0x3a37, 0x0139, 0x2d53, 0x3d26, 0x3a1b, 0x25b6, 0x2bdf, 0x1748, 0x1fc3, 0x18f2, 0x3e65, 0x1910, 0x08f5, 0x0dc6,
        0x1a9b, 0x2bed, 0x1a15, 0x10fd, 0x1b66, 0x2013, 0x0238, 0x102e, 0x3c55, 0x3c38, 0x0187, 0x0f27, 0x1e0d, 0x2077, 0x3887, 0x195f,
        0x0730, 0x04f1, 0x0878, 0x1bdc, 0x265b, 0x1223, 0x191c, 0x3a56, 0x0f39, 0x15af, 0x33ad, 0x08ed, 0x09d8, 0x2cc5, 0x2545, 0x2d2a,
        0x2f86, 0x157d, 0x37df, 0x0e3d, 0x2821, 0x21e8, 0x13e1, 0x2739, 0x0dab, 0x0895, 0x2fed, 0x2193, 0x3720, 0x2d8a, 0x37d9, 0x353f,
        0x27b1, 0x244f, 0x2801, 0x0c34, 0x300f, 0x07e0, 0x10db, 0x2ea9, 0x1328, 0x3752, 0x20fa, 0x2f52, 0x1d3c, 0x2cf4, 0x3c4a, 0x28c8,
        0x357e, 0x075f, 0x27dd, 0x22ab, 0x252a, 0x3165, 0x2a99, 0x2654, 0x13fb, 0x1f16, 0x3139, 0x0f0f, 0x2bf6, 0x3af8, 0x35c3, 0x05d3,
        0x3b6b, 0x26da, 0x1293, 0x3805, 0x2687, 0x3b55, 0x1244, 0x2f4a, 0x3113, 0x301c, 0x1ac7, 0x1047, 0x0064, 0x1fef, 0x0ee3, 0x0bdb,
        0x2877, 0x3c8f, 0x2d90, 0x02cc, 0x2bca, 0x2768, 0x25ca, 0x0f47, 0x32c2, 0x23bc, 0x382c, 0x03d5, 0x19a7, 0x237c, 0x20d5, 0x0110,
        0x00a9, 0x16ca, 0x22fc, 0x35a6, 0x0db9, 0x0168, 0x2e7d, 0x1ea9, 0x08bc, 0x12e7, 0x10b8, 0x1c90, 0x29e3, 0x27a5, 0x0c0d, 0x2ecd,
        0x1cd6, 0x294b, 0x2f21, 0x1c5a, 0x36db, 0x3c04, 0x2c52, 0x01f9, 0x0529, 0x0924, 0x2694, 0x0bc0, 0x2785, 0x17a7, 0x05de, 0x0e46,
        0x1c6d, 0x1b95, 0x19f4, 0x08b4, 0x2aa0, 0x1682, 0x062a, 0x38cb, 0x3c1e, 0x34ff, 0x2d42, 0x27c6, 0x293a, 0x04cb, 0x1282, 0x2dd5,
        0x2408, 0x0cfc, 0x3726, 0x2d00, 0x2292, 0x045c, 0x29fb, 0x0992, 0x00f3, 0x0317, 0x24bc, 0x0e77, 0x1ee0, 0x3c67, 0x05bf, 0x0dff,
        0x11b9, 0x0c8b, 0x1b2c, 0x04b0, 0x3b39, 0x22da, 0x379d, 0x2c14, 0x25ac, 0x3f35, 0x02a7, 0x249c, 0x3037, 0x12cd, 0x279a, 0x26d3,
        0x2601, 0x0ba7, 0x3ff7, 0x2b88, 0x290e, 0x1675, 0x3b01, 0x3860, 0x144f, 0x35f2, 0x07bf, 0x17ee, 0x3bf8, 0x2ab1, 0x1831, 0x18e7,
        0x19c8, 0x303e, 0x3ce7, 0x33f9, 0x2474, 0x30c7, 0x365e, 0x0677, 0x0b5d, 0x2f09, 0x16c0, 0x39d3, 0x295e, 0x3d41, 0x3a8b, 0x3bb9,
        0x0d91, 0x1e1f, 0x2199, 0x2274, 0x0b49, 0x2a8c, 0x394e, 0x3df2, 0x3e6f, 0x3e2d, 0x1656, 0x27f7, 0x0d78, 0x3781, 0x2ad4, 0x0c83,
        0x3006, 0x1523, 0x2089, 0x2b37, 0x3fb9, 0x2f68, 0x31bf, 0x378c, 0x0593, 0x194e, 0x07a5, 0x065b, 0x0651, 0x23ab, 0x33b5, 0x10a7,
        0x31f5, 0x28a6, 0x02eb, 0x0e13, 0x006f, 0x0119, 0x3d7d, 0x3ebb, 0x1d78, 0x0aaa, 0x332b, 0x340e, 0x1238, 0x25a2, 0x18b4, 0x14d7,
        0x1863, 0x033b, 0x1ea0, 0x1ddc, 0x316c, 0x3609, 0x0966, 0x1369, 0x0552, 0x1af6, 0x1e19, 0x3394, 0x3c89, 0x0cf6, 0x063b, 0x1577,
        0x1d29, 0x339a, 0x2ff3, 0x3e15, 0x29b2, 0x2f79, 0x2339, 0x1ef7, 0x093d, 0x1976, 0x3a2f, 0x2081, 0x23dc, 0x3992, 0x3527, 0x20c0,
        0x2bba, 0x31d8, 0x169e, 0x2d60, 0x1e99, 0x3914, 0x0871, 0x19ed, 0x1a05, 0x232b, 0x0bf5, 0x124c, 0x2791, 0x0c77, 0x20ca, 0x2aef,
        0x092d, 0x0caa, 0x1638, 0x1534, 0x248c, 0x2efc, 0x180b, 0x3a7c, 0x2e51, 0x22cc, 0x3f20, 0x0a56, 0x3eec, 0x155c, 0x2e61, 0x2593,
        0x2a25, 0x12d4, 0x0eba, 0x22c7, 0x1971, 0x0aa5, 0x3e28, 0x35ed, 0x0312, 0x091f, 0x23b7, 0x1f11, 0x0890, 0x3c33, 0x23a2, 0x272a,
        0x16e2, 0x0558, 0x089b, 0x0fbc, 0x1f4d, 0x331e, 0x2ea1, 0x19e5, 0x1e52, 0x0ebf, 0x337d, 0x2afe, 0x3da7, 0x0b3e, 0x254f, 0x0750,
        0x1163, 0x2969, 0x0f88, 0x048f, 0x36af, 0x38eb, 0x2925, 0x1195, 0x19fc, 0x381e, 0x1ce9, 0x1784, 0x2257, 0x0645, 0x324d, 0x1f9a,
        0x30af, 0x3f9d, 0x2387, 0x0e80, 0x0d13, 0x1f8d, 0x1347, 0x3899, 0x0815, 0x12d9, 0x1a2c, 0x0d2d, 0x3f5b, 0x1bc4, 0x1c2e, 0x1608,
        0x2b48, 0x355b, 0x391b, 0x0ecd, 0x2531, 0x0ea6, 0x0775, 0x06f5, 0x38af, 0x1dff, 0x177b, 0x2fc3, 0x335c, 0x3efc, 0x32f4, 0x29c8,
        0x2668, 0x1afc, 0x0db1, 0x36a7, 0x1485, 0x3d9a, 0x2035, 0x3fda, 0x3875, 0x2a2a, 0x32b0, 0x1c7e, 0x1626, 0x3549, 0x29a0, 0x2c02,
        0x06a9, 0x0d80, 0x22e3, 0x2b26, 0x01c1, 0x1336, 0x1e62, 0x0a94, 0x2f17, 0x1ecf, 0x1497, 0x28b7, 0x166d, 0x2a44, 0x06ea, 0x159e,
        0x3737, 0x3aaf, 0x2703, 0x18c8, 0x13ad, 0x15a6, 0x1e6f, 0x2ca9, 0x214c, 0x0755, 0x0cde, 0x3fc6, 0x0cb4, 0x329a, 0x0e5d, 0x0330,
        0x0d38, 0x02ae, 0x1262, 0x1fa9, 0x0469, 0x0b73, 0x3430, 0x01a0, 0x0a37, 0x1991, 0x1b5c, 0x255b, 0x27bb, 0x2fa8, 0x3231, 0x2ef0,
        0x0696, 0x096c, 0x273f, 0x1fce, 0x2e3e, 0x3514, 0x1b53, 0x2d7d, 0x3a06, 0x2554, 0x0709, 0x3452, 0x1040, 0x2cba, 0x1f0a, 0x39cc,
        0x10c3, 0x0680, 0x0945, 0x2e08, 0x083c, 0x1206, 0x0a13, 0x14b7, 0x3d75, 0x0230, 0x192b, 0x34ba, 0x1c24, 0x114b, 0x15b7, 0x024a,
        0x11a4, 0x2dcc, 0x36ee, 0x3419, 0x326a, 0x2e38, 0x34c2, 0x3c11, 0x29ac, 0x0b43, 0x147f, 0x1f47, 0x281b, 0x1552, 0x228c, 0x2bc4,
        0x3b16, 0x3e49, 0x16a5, 0x2419, 0x22b2, 0x343d, 0x2200, 0x1ab0, 0x3179, 0x13b6, 0x1130, 0x26f5, 0x21ca, 0x15e7, 0x1d6e, 0x0769,
        0x1090, 0x136f, 0x13e7, 0x005b, 0x3270, 0x3db7, 0x1409, 0x0f02, 0x0e24, 0x3dac, 0x2c6a, 0x3e3b, 0x100e, 0x3345, 0x2d36, 0x17e4,
        0x3974, 0x0cc0, 0x306e, 0x220d, 0x152c, 0x22a3, 0x21af, 0x1f55, 0x2837, 0x0a75, 0x03bf, 0x3b5d, 0x0b8e, 0x2c9a, 0x2481, 0x020f,
        0x32d0, 0x0a6b, 0x008c, 0x1f5d, 0x3cc8, 0x305f, 0x17bc, 0x0f7b, 0x2de1, 0x2b03, 0x0fc6, 0x1c4c, 0x1aa4, 0x3600, 0x3ecc, 0x3fec,
        0x09ff, 0x24a3, 0x1c1a, 0x1705, 0x189e, 0x250a, 0x1cf4, 0x2a5c, 0x3ac0, 0x1b78, 0x129d, 0x3a0d, 0x13f0, 0x1a62, 0x0c4d, 0x3e09,
        0x3962, 0x3172, 0x21ee, 0x1594, 0x3c17, 0x0f32, 0x38a8, 0x054b, 0x143d, 0x3382, 0x298e, 0x0c65, 0x36c9, 0x2f38, 0x3533, 0x3655,
        0x30a7, 0x1cce, 0x2775, 0x3cfc, 0x2670, 0x1617, 0x0bcb, 0x1de5, 0x1b9d, 0x1a47, 0x397e, 0x3c7b, 0x1383, 0x2ae0, 0x1738, 0x042c,
        0x3d04, 0x2630, 0x25f1, 0x150c, 0x0386, 0x07b0, 0x1dcc, 0x2467, 0x234c, 0x0ec4, 0x2025, 0x18d9, 0x13a1, 0x1ae7, 0x3904, 0x37e8,
        0x16f2, 0x11f3, 0x2d67, 0x3121, 0x27e4, 0x1bb1, 0x097f, 0x0363, 0x3969, 0x02d6, 0x39b2, 0x0be7, 0x2047, 0x012a, 0x3f43, 0x11ad,
        0x0a20, 0x360f, 0x2827, 0x3184, 0x34c8, 0x2c43, 0x2a0c, 0x3eae, 0x3cb2, 0x1e57, 0x1d5e, 0x2a1c, 0x30f8, 0x3b46, 0x328a, 0x3dd0,
        0x10a4, 0x3789, 0x14d4, 0x3eb8, 0x1574, 0x1366, 0x20bd, 0x1ef4, 0x26d0, 0x2c11, 0x18e4, 0x385d, 0x3bb6, 0x0674, 0x0c80, 0x3def,
        0x1f97, 0x1192, 0x1605, 0x3896, 0x29c5, 0x06f2, 0x2bff, 0x3fd7, 0x2aec, 0x19ea, 0x2590, 0x3a79, 0x2727, 0x35ea, 0x074d, 0x19e2,
        0x0dc3, 0x25b3, 0x195c, 0x102b, 0x2d27, 0x3a53, 0x353c, 0x2736, 0x2fa1, 0x1a5b, 0x1fe1, 0x3459, 0x2a35, 0x1fe8, 0x3d3a, 0x3c2c,
        0x2eca, 0x1ea6, 0x0e43, 0x01f6, 0x2dd2, 0x38c8, 0x0dfc, 0x098f, 0x28c5, 0x2ea6, 0x05d0, 0x2651, 0x0bd8, 0x2f47, 0x010d, 0x0f44,
        0x0989, 0x3ea5, 0x197e, 0x0419, 0x2d77, 0x0efc, 0x0545, 0x3ea8, 0x3dec, 0x1ef1, 0x19df, 0x3fd4, 0x3c29, 0x2733, 0x0f41, 0x098c,
        0x34e0, 0x0ab8, 0x14e8, 0x36b9, 0x29d4, 0x20de, 0x1933, 0x041c, 0x017f, 0x3323, 0x1477, 0x146f, 0x0101, 0x32ea, 0x3216, 0x1981,
        0x0247, 0x14b4, 0x2bc1, 0x3c0e, 0x0766, 0x1aad, 0x17e1, 0x0eff, 0x159b, 0x0a91, 0x032d, 0x2ca6, 0x2eed, 0x019d, 0x39c9, 0x2d7a,
        0x0429, 0x1de2, 0x37e5, 0x2464, 0x11aa, 0x0360, 0x3dcd, 0x3eab, 0x020c, 0x1f52, 0x3fe9, 0x0f78, 0x3e06, 0x2a59, 0x3652, 0x0548,
        0x3378, 0x3f1b, 0x32ab, 0x1a27, 0x1651, 0x07ba, 0x3a2a, 0x3326, 0x3827, 0x3134, 0x24b7, 0x268f, 0x3989, 0x2a50, 0x2fe8, 0x0182,
        0x0532, 0x1d54, 0x03ac, 0x21b7, 0x05cb, 0x258b, 0x3fe4, 0x1472, 0x2989, 0x0fc1, 0x1d59, 0x2020, 0x0704, 0x0cd9, 0x2c65, 0x147a,
        0x1d67, 0x3f3c, 0x39c2, 0x2160, 0x253e, 0x127b, 0x0634, 0x32ed, 0x2519, 0x1d01, 0x38ba, 0x0710, 0x37ce, 0x3460, 0x2acb, 0x0104,
        0x3096, 0x1869, 0x1583, 0x1004, 0x341f, 0x1b0e, 0x2e27, 0x1984, 0x3ba5, 0x08a0, 0x0537, 0x0f64, 0x1e38, 0x00e8, 0x0fb0, 0x3219,
        0x37b3, 0x3bc5, 0x11d5, 0x0853, 0x1b04, 0x09b4, 0x267a, 0x0abb, 0x1c75, 0x08ca, 0x0322, 0x2fcc, 0x2752, 0x037a, 0x3f7d, 0x34e3,
        0x277d, 0x3f53, 0x1399, 0x24c5, 0x0d56, 0x077f, 0x00ce, 0x36bc, 0x24d9, 0x055d, 0x21bc, 0x1a71, 0x24cd, 0x1070, 0x2569, 0x14eb,
        0x026d, 0x06c1, 0x31df, 0x2355, 0x3585, 0x099c, 0x01ec, 0x20e1, 0x21f5, 0x3d58, 0x1e49, 0x3b9c, 0x1a7c, 0x0ad4, 0x2167, 0x29d7,
        0x110f, 0x0341, 0x2f8c, 0x2862, 0x36f4, 0x0904, 0x0789, 0x041f, 0x3691, 0x16e7, 0x03b1, 0x08d3, 0x2232, 0x171d, 0x1157, 0x1936,
        0x057e, 0x3cef, 0x02b0, 0x20a6, 0x183b, 0x060f, 0x0d3a, 0x301f, 0x2919, 0x31eb, 0x1fab, 0x2b10, 0x007e, 0x3f00, 0x1264, 0x3116,
        0x0bb3, 0x09e9, 0x0b75, 0x2132, 0x310a, 0x3ab7, 0x046b, 0x104a, 0x2b7e, 0x10ac, 0x01a2, 0x07eb, 0x11e5, 0x3360, 0x3432, 0x1aca,
        0x2d13, 0x3955, 0x1993, 0x1d15, 0x30db, 0x01d6, 0x0a39, 0x1ff2, 0x2429, 0x28ea, 0x255d, 0x133d, 0x3262, 0x29cc, 0x1b5e, 0x0067,
        0x3106, 0x1837, 0x2faa, 0x30d7, 0x2fae, 0x0046, 0x27bd, 0x0bde, 0x1e7e, 0x33ba, 0x2ef2, 0x25e5, 0x0a86, 0x32f8, 0x3233, 0x0ee6,
        0x304e, 0x0b66, 0x096e, 0x2055, 0x004a, 0x00b5, 0x0698, 0x26dd, 0x3312, 0x34a6, 0x1fd0, 0x0e6c, 0x3208, 0x1e03, 0x2741, 0x3b6e,
        0x12bc, 0x3228, 0x3516, 0x33d9, 0x2fb2, 0x03f1, 0x2e40, 0x3808, 0x16b9, 0x23b0, 0x2d7f, 0x1ac0, 0x1fda, 0x38b3, 0x1b55, 0x1296,
        0x26f0, 0x34b5, 0x2556, 0x28b2, 0x0be2, 0x3c76, 0x3a08, 0x3b58, 0x2ca1, 0x3fcf, 0x3454, 0x3858, 0x3b97, 0x2fc7, 0x070b, 0x268a,
        0x08e8, 0x18ed, 0x2cbc, 0x15de, 0x27c1, 0x1c8b, 0x1042, 0x2f4d, 0x338f, 0x0656, 0x39ce, 0x2497, 0x2fbe, 0x177f, 0x1f0c, 0x1247,
        0x3bd9, 0x3de2, 0x0d82, 0x04da, 0x33be, 0x3fa9, 0x06ab, 0x23bf, 0x19bc, 0x3f8d, 0x2b28, 0x03dd, 0x0299, 0x0eaa, 0x22e5, 0x32c5,
        0x3853, 0x0e67, 0x1338, 0x2b0b, 0x1e82, 0x1318, 0x01c3, 0x03d8, 0x1cba, 0x0660, 0x0a96, 0x3151, 0x1968, 0x2535, 0x1e64, 0x382f,
        0x26b9, 0x3df9, 0x1ed1, 0x3f73, 0x25e9, 0x1391, 0x2f19, 0x237f, 0x01ab, 0x0220, 0x28b9, 0x01c8, 0x334e, 0x06f9, 0x1499, 0x19aa,
        0x315f, 0x3bfe, 0x2a46, 0x200d, 0x2ef6, 0x1f87, 0x166f, 0x0113, 0x3059, 0x07aa, 0x15a0, 0x2e32, 0x2585, 0x0779, 0x06ec, 0x20d8,
        0x1312, 0x3d4b, 0x3ab1, 0x03eb, 0x32fc, 0x0832, 0x3739, 0x3c92, 0x0e07, 0x3190, 0x18ca, 0x131d, 0x2e6f, 0x355f, 0x2705, 0x287a,
        0x1aef, 0x1df8, 0x15a8, 0x34f8, 0x0a8a, 0x3d51, 0x13af, 0x02cf, 0x3cde, 0x1953, 0x2cab, 0x2a67, 0x275a, 0x2b4c, 0x1e71, 0x2d93,
        0x0a63, 0x1d4c, 0x0757, 0x0ca2, 0x0eea, 0x0dea, 0x214e, 0x276b, 0x0b95, 0x1e8e, 0x3fc8, 0x1e87, 0x1795, 0x0ed1, 0x0ce0, 0x2bcd,
        0x1691, 0x2ab7, 0x329c, 0x0b26, 0x3237, 0x1d9a, 0x0cb6, 0x0f4a, 0x1b21, 0x0598, 0x0332, 0x14ab, 0x10ef, 0x391f, 0x0e5f, 0x25cd,
        0x1c3c, 0x3401, 0x3e4b, 0x061b, 0x3959, 0x286e, 0x3b18, 0x3755, 0x3335, 0x33ef, 0x241b, 0x3156, 0x06da, 0x354d, 0x16a7, 0x132b,
        0x040c, 0x117f, 0x343f, 0x1ad4, 0x2d17, 0x373f, 0x22b4, 0x2f55, 0x1859, 0x3791, 0x1ab2, 0x0e2e, 0x11c5, 0x162a, 0x2202, 0x20fd,
        0x04a0, 0x0b50, 0x13b8, 0x16b1, 0x1d19, 0x2439, 0x317b, 0x2cf7, 0x0e96, 0x0b1d, 0x26f7, 0x0a9b, 0x17fb, 0x2c06, 0x1132, 0x1d3f,
        0x2ebd, 0x07c5, 0x15e9, 0x2248, 0x1997, 0x3493, 0x21cc, 0x28cb, 0x18fc, 0x31c4, 0x076b, 0x0741, 0x0177, 0x29a4, 0x1d70, 0x3c4d,
        0x1b4a, 0x0b31, 0x1371, 0x3643, 0x01da, 0x2579, 0x1092, 0x2452, 0x0889, 0x2957, 0x005d, 0x0665, 0x37c7, 0x2a2e, 0x13e9, 0x27b4,
        0x126e, 0x3cd3, 0x3db9, 0x297a, 0x30df, 0x3c98, 0x3272, 0x0c37, 0x13c0, 0x2f6d, 0x0f04, 0x3b8d, 0x09ce, 0x3879, 0x140b, 0x2804,
        0x2107, 0x3240, 0x3dae, 0x21df, 0x1ff6, 0x1f66, 0x0e26, 0x07e3, 0x0216, 0x0b9c, 0x3e3d, 0x1cbf, 0x1bf4, 0x1c82, 0x2c6c, 0x3012,
        0x00c1, 0x17f4, 0x3347, 0x325b, 0x0a3d, 0x3632, 0x1010, 0x2eac, 0x3a71, 0x3fbe, 0x17e6, 0x0191, 0x2a75, 0x32b4, 0x2d38, 0x10de,
        0x02fe, 0x2647, 0x0682, 0x221e, 0x28ee, 0x28de, 0x10c5, 0x1f19, 0x292e, 0x116f, 0x2e0a, 0x3834, 0x1e2f, 0x3d9e, 0x0947, 0x13fe,
        0x0202, 0x25d5, 0x1208, 0x2de9, 0x242d, 0x3302, 0x083e, 0x0f12, 0x0dd4, 0x2b3c, 0x14b9, 0x39e8, 0x2cda, 0x1489, 0x0a15, 0x313c,
        0x2c4c, 0x2a93, 0x0232, 0x00de, 0x1341, 0x1805, 0x3d77, 0x3afb, 0x1dc6, 0x17b6, 0x34bc, 0x1e69, 0x00c8, 0x3fde, 0x192d, 0x2bf9,
        0x30eb, 0x1455, 0x114d, 0x23eb, 0x2561, 0x38fc, 0x1c26, 0x05d6, 0x358e, 0x208e, 0x024c, 0x3685, 0x2227, 0x2039, 0x15b9, 0x35c6,
        0x29c1, 0x1570, 0x2dce, 0x2d23, 0x29d0, 0x2d73, 0x11a6, 0x0762, 0x05c7, 0x164d, 0x341b, 0x253a, 0x0d52, 0x1b00, 0x36f0, 0x3581,
        0x13a9, 0x01bd, 0x2e3a, 0x0465, 0x3266, 0x0838, 0x326c, 0x22ae, 0x3cc4, 0x1528, 0x3c13, 0x189a, 0x0382, 0x266c, 0x34c4, 0x27e0,
        0x290a, 0x3b35, 0x0b45, 0x2470, 0x006b, 0x3fb5, 0x29ae, 0x3168, 0x2488, 0x1e95, 0x1f49, 0x196d, 0x0d0f, 0x36ab, 0x1481, 0x252d,
        0x0cd1, 0x35f8, 0x1554, 0x3af0, 0x1b62, 0x2d4f, 0x281d, 0x2657, 0x2526, 0x300b, 0x2bc6, 0x2683, 0x36d7, 0x0db5, 0x228e, 0x2a9c,
        0x2edb, 0x19d0, 0x24a5, 0x16d5, 0x09ed, 0x14fa, 0x0a01, 0x3502, 0x2280, 0x2e97, 0x1707, 0x04df, 0x3e5d, 0x0649, 0x1c1c, 0x3c21,
        0x3200, 0x37bf, 0x250c, 0x2844, 0x0bb7, 0x18d0, 0x18a0, 0x27c9, 0x3d90, 0x14dc, 0x2a5e, 0x1f6e, 0x1815, 0x225b, 0x1cf6, 0x2d45,
        0x2887, 0x21a0, 0x1b7a, 0x0482, 0x2136, 0x2360, 0x3ac2, 0x04ce, 0x184b, 0x2c34, 0x3a0f, 0x0d87, 0x2eb3, 0x1f9e, 0x129f, 0x293d,
        0x0510, 0x3b07, 0x1a64, 0x3621, 0x0b79, 0x28f9, 0x13f2, 0x2dd8, 0x1cb1, 0x18b9, 0x3e0b, 0x0799, 0x24ff, 0x3251, 0x0c4f, 0x1285,
        0x0a32, 0x2f12, 0x3174, 0x3d70, 0x3abb, 0x2832, 0x3964, 0x1b98, 0x2f9c, 0x26cb, 0x1596, 0x3de7, 0x2514, 0x3822, 0x21f0, 0x1c70,
        0x206e, 0x1549, 0x0f34, 0x2bda, 0x310e, 0x1323, 0x3c19, 0x08b7, 0x0b58, 0x25a7, 0x054d, 0x058e, 0x030d, 0x1a00, 0x38aa, 0x19f7,
        0x3acd, 0x1822, 0x3384, 0x30ba, 0x104e, 0x3e8d, 0x143f, 0x1685, 0x0a7c, 0x0ce7, 0x0c67, 0x3bde, 0x1418, 0x1788, 0x2990, 0x2aa3,
        0x3672, 0x3866, 0x2f3a, 0x0e54, 0x046f, 0x1bfd, 0x36cb, 0x38ce, 0x2371, 0x123d, 0x3657, 0x3e21, 0x3429, 0x1ced, 0x3535, 0x062d,
        0x0802, 0x2ac1, 0x0cc2, 0x3713, 0x10b0, 0x1ce1, 0x3976, 0x031a, 0x1431, 0x17c6, 0x220f, 0x23c4, 0x31aa, 0x38ef, 0x3070, 0x00f6,
        0x0aca, 0x10f7, 0x22a5, 0x1c54, 0x2b82, 0x0e0d, 0x152e, 0x0e7a, 0x18c2, 0x3413, 0x1f57, 0x1506, 0x3890, 0x36b3, 0x21b1, 0x24bf,
        0x1846, 0x227b, 0x0a77, 0x2f97, 0x07ef, 0x142c, 0x2839, 0x3c6a, 0x07f4, 0x039b, 0x3b5f, 0x06b0, 0x1017, 0x1199, 0x03c1, 0x1ee3,
        0x2424, 0x2914, 0x2c9c, 0x330d, 0x01a6, 0x19b7, 0x0b90, 0x0e02, 0x0e91, 0x3330, 0x0211, 0x0884, 0x1dc1, 0x2929, 0x2483, 0x05c2,
        0x374a, 0x2323, 0x0a6d, 0x312c, 0x3364, 0x1c10, 0x32d2, 0x0cff, 0x3c6f, 0x0de3, 0x1f5f, 0x3fae, 0x3e86, 0x296d, 0x008e, 0x240b,
        0x37f0, 0x263c, 0x3061, 0x33c9, 0x11e9, 0x3196, 0x3cca, 0x2d03, 0x289d, 0x0aaf, 0x0f7d, 0x1f77, 0x3f85, 0x1167, 0x17be, 0x3729,
        0x212c, 0x33d3, 0x2b05, 0x34f2, 0x1ace, 0x2974, 0x2de3, 0x045f, 0x283e, 0x2bd4, 0x1c4e, 0x33c3, 0x12fd, 0x0493, 0x0fc8, 0x2295,
        0x121c, 0x167b, 0x3602, 0x0e9f, 0x3436, 0x1baa, 0x1aa6, 0x0995, 0x0c02, 0x1d7d, 0x3fee, 0x15fc, 0x346e, 0x0f8c, 0x3ece, 0x29fe,
        0x1b42, 0x3046, 0x11f5, 0x0a2a, 0x3cf3, 0x359d, 0x16f4, 0x12ea, 0x03a0, 0x38e1, 0x3123, 0x03e2, 0x2716, 0x1bc8, 0x2d69, 0x08bf,
        0x2391, 0x2177, 0x1bb3, 0x1303, 0x0582, 0x270b, 0x27e6, 0x1c93, 0x0867, 0x3ec0, 0x0365, 0x1ffe, 0x2ffe, 0x3f5f, 0x0981, 0x10bb,
        0x35b0, 0x0d98, 0x02d8, 0x1f3a, 0x20aa, 0x025a, 0x396b, 0x27a8, 0x07f9, 0x3bd0, 0x0be9, 0x2b2d, 0x3639, 0x160c, 0x39b4, 0x29e6,
        0x0ae2, 0x3ffd, 0x012c, 0x06cb, 0x02b4, 0x15c6, 0x2049, 0x2ed0, 0x347b, 0x3d82, 0x11af, 0x10cf, 0x2dfd, 0x1c32, 0x3f45, 0x0c10,
        0x11fd, 0x3d1d, 0x3611, 0x172b, 0x0613, 0x209e, 0x0a22, 0x16cd, 0x06b5, 0x3d0f, 0x3186, 0x3f92, 0x284c, 0x12dd, 0x2829, 0x00ac,
        0x26b2, 0x2d0c, 0x2c45, 0x0499, 0x183f, 0x2880, 0x34ca, 0x35a9, 0x04a8, 0x011e, 0x3eb0, 0x2b1e, 0x20f0, 0x0819, 0x2a0e, 0x22ff,
        0x187c, 0x1da3, 0x1e59, 0x2f2b, 0x3023, 0x0095, 0x3cb4, 0x016b, 0x3b64, 0x179c, 0x2a1e, 0x19c1, 0x09f8, 0x0d31, 0x1d60, 0x0dbc,
        0x1119, 0x2b8e, 0x3b48, 0x2b73, 0x0d3e, 0x056a, 0x30fa, 0x1eac, 0x0f1c, 0x0074, 0x3dd2, 0x0450, 0x1be7, 0x1a30, 0x328c, 0x2e80,
        0x1a95, 0x1066, 0x1cd0, 0x3578, 0x31ef, 0x25fb, 0x30a9, 0x0927, 0x119e, 0x3731, 0x3cfe, 0x32ca, 0x34da, 0x1f91, 0x2777, 0x052c,
        0x2c5b, 0x3927, 0x1619, 0x0fce, 0x291d, 0x2e75, 0x2672, 0x0bc3, 0x1ec0, 0x0e18, 0x1de7, 0x0b05, 0x0039, 0x0d17, 0x0bcd, 0x2697,
        0x34d1, 0x1e26, 0x1a49, 0x1465, 0x2b14, 0x107e, 0x1b9f, 0x17aa, 0x101c, 0x3ae2, 0x3c7d, 0x22ea, 0x0a44, 0x389d, 0x3980, 0x2788,
        0x2e18, 0x2607, 0x2ae2, 0x3767, 0x1faf, 0x085d, 0x1385, 0x0e49, 0x09a5, 0x02f0, 0x042e, 0x0724, 0x068b, 0x134b, 0x173a, 0x05e1,
        0x3b2a, 0x3a99, 0x2632, 0x14c7, 0x3f04, 0x2626, 0x3d06, 0x294e, 0x1ee8, 0x1945, 0x150e, 0x0eaf, 0x28d6, 0x3fa1, 0x25f3, 0x1cd9,
        0x390c, 0x07d8, 0x07b2, 0x229b, 0x0082, 0x3565, 0x0388, 0x1c5d, 0x0c9b, 0x28ab, 0x2469, 0x21d8, 0x34eb, 0x30b3, 0x1dce, 0x2f24,
        0x08ad, 0x1bd5, 0x0ec6, 0x1dd5, 0x311a, 0x2412, 0x234e, 0x3c07, 0x03c6, 0x0ed8, 0x18db, 0x029e, 0x3b7b, 0x0e84, 0x2027, 0x36de,
        0x12b6, 0x0bad, 0x1ae9, 0x384d, 0x1268, 0x0406, 0x13a3, 0x01fc, 0x2068, 0x31fa, 0x37ea, 0x0ac4, 0x26ac, 0x238b, 0x3906, 0x2c55,
        0x0138, 0x3666, 0x25b5, 0x3d25, 0x18f1, 0x1747, 0x0dc5, 0x190f, 0x10fc, 0x2bec, 0x102d, 0x2012, 0x0f26, 0x3c37, 0x195e, 0x2076,
        0x1bdb, 0x04f0, 0x3a55, 0x1222, 0x08ec, 0x15ae, 0x2d29, 0x2cc4, 0x0e3c, 0x157c, 0x2738, 0x21e7, 0x2192, 0x0894, 0x353e, 0x2d89,
        0x0125, 0x2adb, 0x1a5d, 0x2c95, 0x15e2, 0x1146, 0x2fa3, 0x2a3f, 0x0acf, 0x0375, 0x345b, 0x2a4b, 0x0198, 0x272e, 0x1fe3, 0x066f,
        0x04c6, 0x27a0, 0x1fea, 0x2cef, 0x2cc0, 0x190b, 0x2a37, 0x2a3b, 0x3ef7, 0x0640, 0x3c2e, 0x0c72, 0x0cf1, 0x23a6, 0x3d3c, 0x12c8,
        0x35a5, 0x16c9, 0x1ea8, 0x0167, 0x1c8f, 0x12e6, 0x2ecc, 0x27a4, 0x1c59, 0x294a, 0x01f8, 0x3c03, 0x0bbf, 0x0923, 0x0e45, 0x17a6,
        0x08b3, 0x1b94, 0x38ca, 0x1681, 0x27c5, 0x34fe, 0x2dd4, 0x04ca, 0x2cff, 0x0cfb, 0x0991, 0x045b, 0x0e76, 0x0316, 0x0dfe, 0x3c66,
        0x0c33, 0x244e, 0x2ea8, 0x07df, 0x2f51, 0x3751, 0x28c7, 0x2cf3, 0x22aa, 0x075e, 0x2653, 0x3164, 0x0f0e, 0x1f15, 0x05d2, 0x3af7,
        0x3804, 0x26d9, 0x2f49, 0x3b54, 0x1046, 0x301b, 0x0bda, 0x1fee, 0x02cb, 0x3c8e, 0x0f46, 0x2767, 0x03d4, 0x23bb, 0x010f, 0x237b,
        0x2b36, 0x1522, 0x378b, 0x2f67, 0x065a, 0x194d, 0x10a6, 0x23aa, 0x0e12, 0x28a5, 0x3eba, 0x0118, 0x340d, 0x0aa9, 0x14d6, 0x25a1,
        0x1ddb, 0x033a, 0x1368, 0x3608, 0x3393, 0x1af5, 0x1576, 0x0cf5, 0x3e14, 0x3399, 0x1ef6, 0x2f78, 0x2080, 0x1975, 0x20bf, 0x3991,
        0x04af, 0x0c8a, 0x2c13, 0x22d9, 0x249b, 0x3f34, 0x26d2, 0x12cc, 0x2b87, 0x0ba6, 0x385f, 0x1674, 0x17ed, 0x35f1, 0x18e6, 0x2ab0,
        0x33f8, 0x303d, 0x0676, 0x30c6, 0x39d2, 0x2f08, 0x3bb8, 0x3d40, 0x2273, 0x1e1e, 0x3df1, 0x2a8b, 0x27f6, 0x3e2c, 0x0c82, 0x3780,
        0x048e, 0x2968, 0x1194, 0x38ea, 0x1783, 0x381d, 0x1f99, 0x0644, 0x0e7f, 0x3f9c, 0x3898, 0x1f8c, 0x0d2c, 0x12d8, 0x1607, 0x1bc3,
        0x0ecc, 0x355a, 0x06f4, 0x0ea5, 0x2fc2, 0x1dfe, 0x29c7, 0x3efb, 0x36a6, 0x1afb, 0x3fd9, 0x3d99, 0x1c7d, 0x2a29, 0x2c01, 0x3548,
        0x2d5f, 0x31d7, 0x19ec, 0x3913, 0x124b, 0x232a, 0x2aee, 0x0c76, 0x1533, 0x0ca9, 0x3a7b, 0x2efb, 0x0a55, 0x22cb, 0x2592, 0x155b,
        0x22c6, 0x12d3, 0x35ec, 0x0aa4, 0x1f10, 0x091e, 0x2729, 0x3c32, 0x0fbb, 0x0557, 0x19e4, 0x331d, 0x2afd, 0x0ebe, 0x074f, 0x0b3d,
        0x2e07, 0x067f, 0x14b6, 0x1205, 0x34b9, 0x022f, 0x0249, 0x114a, 0x3418, 0x2dcb, 0x3c10, 0x2e37, 0x1f46, 0x0b42, 0x2bc3, 0x1551,
        0x2418, 0x3e48, 0x1aaf, 0x343c, 0x26f4, 0x13b5, 0x0768, 0x15e6, 0x005a, 0x136e, 0x0f01, 0x3db6, 0x3e3a, 0x3dab, 0x17e3, 0x3344,
        0x2b25, 0x0d7f, 0x0a93, 0x1335, 0x28b6, 0x1ece, 0x159d, 0x2a43, 0x18c7, 0x3aae, 0x2ca8, 0x15a5, 0x3fc5, 0x0754, 0x032f, 0x3299,
        0x1fa8, 0x02ad, 0x019f, 0x0b72, 0x255a, 0x1990, 0x2eef, 0x2fa7, 0x1fcd, 0x096b, 0x2d7c, 0x3513, 0x3451, 0x2553, 0x39cb, 0x2cb9,
        0x3cfb, 0x1ccd, 0x1de4, 0x1616, 0x3c7a, 0x1a46, 0x042b, 0x2adf, 0x150b, 0x262f, 0x2466, 0x07af, 0x18d8, 0x0ec3, 0x37e7, 0x1ae6,
        0x3120, 0x11f2, 0x0362, 0x1bb0, 0x0be6, 0x02d5, 0x11ac, 0x0129, 0x3183, 0x360e, 0x3ead, 0x2c42, 0x2a1b, 0x1e56, 0x3dcf, 0x3b45,
        0x220c, 0x0cbf, 0x1f54, 0x22a2, 0x3b5c, 0x0a74, 0x020e, 0x2c99, 0x1f5c, 0x0a6a, 0x0f7a, 0x305e, 0x1c4b, 0x2b02, 0x3feb, 0x35ff,
        0x1704, 0x24a2, 0x2a5b, 0x2509, 0x3a0c, 0x1b77, 0x3e08, 0x1a61, 0x1593, 0x3171, 0x054a, 0x0f31, 0x0c64, 0x3381, 0x3654, 0x2f37,
        0x0418, 0x3ea4, 0x3ea7, 0x0efb, 0x3fd3, 0x1ef0, 0x098b, 0x2732, 0x36b8, 0x0ab7, 0x041b, 0x20dd, 0x146e, 0x3322, 0x1980, 0x32e9,
        0x3c0d, 0x14b3, 0x0efe, 0x1aac, 0x2ca5, 0x0a90, 0x2d79, 0x019c, 0x2463, 0x1de1, 0x3eaa, 0x035f, 0x0f77, 0x1f51, 0x0547, 0x2a58,
        0x3eb7, 0x3788, 0x1ef3, 0x1365, 0x385c, 0x2c10, 0x3dee, 0x0673, 0x3895, 0x1191, 0x3fd6, 0x06f1, 0x3a78, 0x19e9, 0x19e1, 0x35e9,
        0x102a, 0x25b2, 0x2735, 0x3a52, 0x3458, 0x1a5a, 0x3c2b, 0x1fe7, 0x01f5, 0x1ea5, 0x098e, 0x38c7, 0x2650, 0x2ea5, 0x0f43, 0x2f46,
        0x0852, 0x3bc4, 0x0aba, 0x09b3, 0x2fcb, 0x08c9, 0x34e2, 0x0379, 0x24c4, 0x3f52, 0x36bb, 0x077e, 0x1a70, 0x055c, 0x14ea, 0x106f,
        0x2354, 0x06c0, 0x20e0, 0x099b, 0x3b9b, 0x3d57, 0x29d6, 0x0ad3, 0x2861, 0x0340, 0x041e, 0x0903, 0x08d2, 0x16e6, 0x1935, 0x171c,
        0x1a26, 0x3f1a, 0x3325, 0x07b9, 0x268e, 0x3133, 0x0181, 0x2a4f, 0x21b6, 0x1d53, 0x1471, 0x258a, 0x201f, 0x0fc0, 0x1479, 0x0cd8,
        0x215f, 0x3f3b, 0x32ec, 0x127a, 0x070f, 0x1d00, 0x0103, 0x345f, 0x1003, 0x1868, 0x1983, 0x1b0d, 0x0f63, 0x089f, 0x3218, 0x00e7,
        0x0c48, 0x247c, 0x3f3e, 0x1733, 0x322c, 0x06e5, 0x1d69, 0x15b2, 0x2ac6, 0x2fe3, 0x2162, 0x3f78, 0x3d35, 0x0c7b, 0x39c4, 0x0f3c,
        0x0ede, 0x3c45, 0x127d, 0x0c08, 0x12c0, 0x2cb1, 0x2540, 0x08f0, 0x239d, 0x20c5, 0x32ef, 0x3248, 0x3a86, 0x2795, 0x0636, 0x33b0,
        0x0820, 0x165d, 0x1d03, 0x12aa, 0x33dd, 0x17d4, 0x251b, 0x2cc8, 0x0807, 0x39a2, 0x0712, 0x1ed6, 0x10e5, 0x2af3, 0x38bc, 0x09db,
        0x05ec, 0x37a3, 0x3462, 0x1753, 0x351a, 0x0ff4, 0x37d0, 0x2d2d, 0x1f03, 0x352c, 0x0106, 0x0fa9, 0x3776, 0x20ce, 0x2acd, 0x2548,
        0x12f2, 0x39dc, 0x186b, 0x0c1b, 0x03f5, 0x2855, 0x3098, 0x04f4, 0x3718, 0x23d4, 0x1006, 0x3dfe, 0x18a8, 0x232f, 0x1585, 0x0733,
        0x03cc, 0x0c5c, 0x1b10, 0x1d83, 0x2fb6, 0x2a6d, 0x3421, 0x1bdf, 0x2441, 0x3997, 0x1986, 0x3489, 0x2a82, 0x1a09, 0x2e29, 0x087b,
        0x2c84, 0x13cf, 0x08a2, 0x356c, 0x380c, 0x336b, 0x3ba7, 0x1226, 0x0cc7, 0x2155, 0x0f66, 0x26be, 0x2dba, 0x1250, 0x0539, 0x265e,
        0x0022, 0x2c1a, 0x00ea, 0x3ca9, 0x2e44, 0x2c75, 0x1e3a, 0x3a59, 0x3a48, 0x23e1, 0x321b, 0x05a7, 0x1b18, 0x0bf9, 0x0fb2, 0x191f,
        0x0bf2, 0x169b, 0x3f1d, 0x1635, 0x23b4, 0x0eb7, 0x337a, 0x0898, 0x1ce6, 0x0f85, 0x1a29, 0x2384, 0x1778, 0x3918, 0x32ad, 0x0dae,
        0x02a4, 0x1b29, 0x07bc, 0x3ff4, 0x16bd, 0x3ce4, 0x1653, 0x2196, 0x07a2, 0x2086, 0x3328, 0x02e8, 0x1e16, 0x1e9d, 0x3a2c, 0x2ff0,
        0x20f7, 0x27fe, 0x3136, 0x27da, 0x1ac4, 0x1290, 0x3829, 0x2d8d, 0x10b5, 0x22f9, 0x2691, 0x2f1e, 0x2d3f, 0x19f1, 0x24b9, 0x3723,
        0x333e, 0x3b3f, 0x2a52, 0x1716, 0x2d83, 0x3c60, 0x398b, 0x3542, 0x1fc0, 0x3a34, 0x0184, 0x1a12, 0x33aa, 0x0875, 0x2fea, 0x37dc,
        0x24b4, 0x32a8, 0x1d56, 0x03a9, 0x38b7, 0x39bf, 0x0534, 0x1580, 0x031f, 0x11d2, 0x21b9, 0x1396, 0x1e46, 0x31dc, 0x03ae, 0x2f89,
        0x18e1, 0x14d1, 0x258d, 0x1602, 0x1fde, 0x1959, 0x05cd, 0x0e40, 0x19dc, 0x197b, 0x1474, 0x14e5, 0x032a, 0x2bbe, 0x3fe6, 0x37e2,
        0x03bc, 0x306b, 0x0fc3, 0x0089, 0x129a, 0x1c17, 0x298b, 0x21eb, 0x397b, 0x2772, 0x2022, 0x25ee, 0x39af, 0x2d64, 0x1d5b, 0x2824,
        0x1494, 0x22e0, 0x0cdb, 0x2700, 0x1b59, 0x125f, 0x0706, 0x273c, 0x1928, 0x0942, 0x147c, 0x36eb, 0x112d, 0x16a2, 0x2c67, 0x13e4,
        0x2240, 0x30cf, 0x06c3, 0x3619, 0x0b6a, 0x2ce7, 0x026f, 0x174b, 0x17cb, 0x113d, 0x2357, 0x01cd, 0x1b89, 0x1560, 0x31e1, 0x2be2,
        0x0e8a, 0x1caa, 0x099e, 0x3474, 0x3052, 0x1e77, 0x3587, 0x18f5, 0x1fb9, 0x1efc, 0x20e3, 0x210f, 0x226c, 0x3ef0, 0x01ee, 0x1fc6,
        0x2306, 0x3e76, 0x3d5a, 0x24f3, 0x2059, 0x05b2, 0x21f7, 0x1913, 0x1436, 0x39ff, 0x3b9e, 0x28be, 0x32bb, 0x2597, 0x1e4b, 0x3e68,
        0x2ba2, 0x1b32, 0x0ad6, 0x0277, 0x0972, 0x2b63, 0x1a7e, 0x0dc9, 0x2116, 0x233e, 0x29d9, 0x1f23, 0x0d22, 0x2e65, 0x2169, 0x08f8,
        0x16fc, 0x37fc, 0x0343, 0x001a, 0x00b9, 0x08e0, 0x1111, 0x366a, 0x23c9, 0x3f0d, 0x2864, 0x0225, 0x27d1, 0x22d0, 0x2f8e, 0x3f6a,
        0x3b81, 0x319f, 0x0906, 0x0f92, 0x004e, 0x2d99, 0x36f6, 0x013c, 0x1d21, 0x2f7e, 0x0421, 0x1088, 0x31b5, 0x2e55, 0x078b, 0x3a3a,
        0x1765, 0x0f53, 0x16e9, 0x1c64, 0x26e1, 0x32d9, 0x3693, 0x3d29, 0x2214, 0x0ef1, 0x08d5, 0x01b0, 0x2123, 0x0a5a, 0x03b3, 0x2d56,
        0x034b, 0x04b6, 0x171f, 0x1a8a, 0x069c, 0x0157, 0x2234, 0x25b9, 0x0848, 0x29b7, 0x1938, 0x3edb, 0x1d8b, 0x3f24, 0x1159, 0x3a1e,
        0x39f6, 0x3aa5, 0x3bc7, 0x0b14, 0x34aa, 0x1516, 0x37b5, 0x3c3b, 0x38f4, 0x1f7f, 0x0855, 0x19af, 0x1a52, 0x2f00, 0x11d7, 0x3c58,
        0x36e4, 0x05a0, 0x09b6, 0x3ed4, 0x3316, 0x2760, 0x1b06, 0x0f2a, 0x15f5, 0x3e1a, 0x0abd, 0x0449, 0x14a4, 0x2490, 0x267c, 0x018a,
        0x2a15, 0x3e34, 0x08cc, 0x0f71, 0x0e70, 0x218c, 0x1c77, 0x207a, 0x31af, 0x2266, 0x2fce, 0x149e, 0x2a7c, 0x3a80, 0x0324, 0x1e10,
        0x09c8, 0x11bf, 0x037c, 0x2cd4, 0x1fd4, 0x11df, 0x2754, 0x1962, 0x20ea, 0x2ff8, 0x34e5, 0x0033, 0x0307, 0x180f, 0x3f7f, 0x388a,
        0x1232, 0x3bf2, 0x3f55, 0x3ee6, 0x1e07, 0x35e0, 0x277f, 0x2bf0, 0x00fb, 0x2721, 0x24c7, 0x06fe, 0x2815, 0x0cae, 0x139b, 0x1a9e,
        0x202d, 0x29f3, 0x0781, 0x2a04, 0x320c, 0x2b52, 0x0d58, 0x1100, 0x0fe7, 0x339f, 0x36be, 0x2da9, 0x2fd4, 0x0931, 0x00d0, 0x1a18,
        0x0afb, 0x043f, 0x055f, 0x038f, 0x3b72, 0x0d06, 0x24db, 0x2016, 0x3075, 0x0df1, 0x1a73, 0x3353, 0x24e4, 0x1538, 0x21be, 0x1b69,
        0x0fdd, 0x0c91, 0x1072, 0x3842, 0x2745, 0x05fe, 0x24cf, 0x1031, 0x308b, 0x1d2e, 0x14ed, 0x09bd, 0x35d1, 0x163c, 0x256b, 0x023b,
        0x0166, 0x16c8, 0x27a3, 0x12e5, 0x3c02, 0x2949, 0x17a5, 0x0922, 0x1680, 0x1b93, 0x04c9, 0x34fd, 0x045a, 0x0cfa, 0x3c65, 0x0315,
        0x07de, 0x244d, 0x2cf2, 0x3750, 0x3163, 0x075d, 0x3af6, 0x1f14, 0x3b53, 0x26d8, 0x1fed, 0x301a, 0x2766, 0x3c8d, 0x237a, 0x23ba,
        0x3d24, 0x3665, 0x190e, 0x1746, 0x2011, 0x2beb, 0x2075, 0x3c36, 0x1221, 0x04ef, 0x2cc3, 0x15ad, 0x21e6, 0x157b, 0x2d88, 0x0893,
        0x2c94, 0x2ada, 0x2a3e, 0x1145, 0x2a4a, 0x0374, 0x066e, 0x272d, 0x2cee, 0x279f, 0x2a3a, 0x190a, 0x0c71, 0x063f, 0x12c7, 0x23a5,
        0x38e9, 0x2967, 0x0643, 0x381c, 0x1f8b, 0x3f9b, 0x1bc2, 0x12d7, 0x0ea4, 0x3559, 0x3efa, 0x1dfd, 0x3d98, 0x1afa, 0x3547, 0x2a28,
        0x3912, 0x31d6, 0x0c75, 0x2329, 0x2efa, 0x0ca8, 0x155a, 0x22ca, 0x0aa3, 0x12d2, 0x3c31, 0x091d, 0x331c, 0x0556, 0x0b3c, 0x0ebd,
        0x2f66, 0x1521, 0x23a9, 0x194c, 0x0117, 0x28a4, 0x25a0, 0x0aa8, 0x3607, 0x0339, 0x0cf4, 0x1af4, 0x2f77, 0x3398, 0x3990, 0x1974,
        0x22d8, 0x0c89, 0x12cb, 0x3f33, 0x1673, 0x0ba5, 0x2aaf, 0x35f0, 0x30c5, 0x303c, 0x3d3f, 0x2f07, 0x2a8a, 0x1e1d, 0x377f, 0x3e2b,
        0x1615, 0x1ccc, 0x2ade, 0x1a45, 0x07ae, 0x262e, 0x1ae5, 0x0ec2, 0x1baf, 0x11f1, 0x0128, 0x02d4, 0x2c41, 0x360d, 0x3b44, 0x1e55,
        0x22a1, 0x0cbe, 0x2c98, 0x0a73, 0x305d, 0x0a69, 0x35fe, 0x2b01, 0x2508, 0x24a1, 0x1a60, 0x1b76, 0x0f30, 0x3170, 0x2f36, 0x3380,
        0x1204, 0x067e, 0x1149, 0x022e, 0x2e36, 0x2dca, 0x1550, 0x0b41, 0x343b, 0x3e47, 0x15e5, 0x13b4, 0x3db5, 0x136d, 0x3343, 0x3daa,
        0x1334, 0x0d7e, 0x2a42, 0x1ecd, 0x15a4, 0x3aad, 0x3298, 0x0753, 0x0b71, 0x02ac, 0x2fa6, 0x198f, 0x3512, 0x096a, 0x2cb8, 0x2552,
        0x09b2, 0x3bc3, 0x0378, 0x08c8, 0x077d, 0x3f51, 0x106e, 0x055b, 0x099a, 0x06bf, 0x0ad2, 0x3d56, 0x0902, 0x033f, 0x171b, 0x16e5,
        0x07b8, 0x3f19, 0x2a4e, 0x3132, 0x2589, 0x1d52, 0x0cd7, 0x0fbf, 0x1279, 0x3f3a, 0x345e, 0x1cff, 0x1b0c, 0x1867, 0x00e6, 0x089e,
        0x0efa, 0x3ea3, 0x2731, 0x1eef, 0x20dc, 0x0ab6, 0x32e8, 0x3321, 0x1aab, 0x14b2, 0x019b, 0x0a8f, 0x035e, 0x1de0, 0x2a57, 0x1f50,
        0x1364, 0x3787, 0x0672, 0x2c0f, 0x06f0, 0x1190, 0x35e8, 0x19e8, 0x3a51, 0x25b1, 0x1fe6, 0x1a59, 0x38c6, 0x1ea4, 0x2f45, 0x2ea4,
        0x0c1a, 0x39db, 0x04f3, 0x2854, 0x3dfd, 0x23d3, 0x0732, 0x232e, 0x1d82, 0x0c5b, 0x1bde, 0x2a6c, 0x3488, 0x3996, 0x087a, 0x1a08,
        0x356b, 0x13ce, 0x1225, 0x336a, 0x26bd, 0x2154, 0x265d, 0x124f, 0x3ca8, 0x2c19, 0x3a58, 0x2c74, 0x05a6, 0x23e0, 0x191e, 0x0bf8,
        0x1732, 0x247b, 0x15b1, 0x06e4, 0x3f77, 0x2fe2, 0x0f3b, 0x0c7a, 0x0c07, 0x3c44, 0x08ef, 0x2cb0, 0x3247, 0x20c4, 0x33af, 0x2794,
        0x12a9, 0x165c, 0x2cc7, 0x17d3, 0x1ed5, 0x39a1, 0x09da, 0x2af2, 0x1752, 0x37a2, 0x2d2c, 0x0ff3, 0x0fa8, 0x352b, 0x2547, 0x20cd,
        0x03a8, 0x32a7, 0x157f, 0x39be, 0x1395, 0x11d1, 0x2f88, 0x31db, 0x1601, 0x14d0, 0x0e3f, 0x1958, 0x14e4, 0x197a, 0x37e1, 0x2bbd,
        0x0088, 0x306a, 0x21ea, 0x1c16, 0x25ed, 0x2771, 0x2823, 0x2d63, 0x26ff, 0x22df, 0x273b, 0x125e, 0x36ea, 0x0941, 0x13e3, 0x16a1,
        0x1634, 0x169a, 0x0897, 0x0eb6, 0x2383, 0x0f84, 0x0dad, 0x3917, 0x3ff3, 0x1b28, 0x2195, 0x3ce3, 0x02e7, 0x2085, 0x2fef, 0x1e9c,
        0x27d9, 0x27fd, 0x2d8c, 0x128f, 0x2f1d, 0x22f8, 0x3722, 0x19f0, 0x1715, 0x3b3e, 0x3541, 0x3c5f, 0x1a11, 0x3a33, 0x37db, 0x0874,
        0x0019, 0x37fb, 0x3669, 0x08df, 0x0224, 0x3f0c, 0x3f69, 0x22cf, 0x0f91, 0x319e, 0x013b, 0x2d98, 0x1087, 0x2f7d, 0x3a39, 0x2e54,
        0x1c63, 0x0f52, 0x3d28, 0x32d8, 0x01af, 0x0ef0, 0x2d55, 0x0a59, 0x1a89, 0x04b5, 0x25b8, 0x0156, 0x3eda, 0x29b6, 0x3a1d, 0x3f23,
        0x3618, 0x30ce, 0x174a, 0x2ce6, 0x01cc, 0x113c, 0x2be1, 0x155f, 0x3473, 0x1ca9, 0x18f4, 0x1e76, 0x210e, 0x1efb, 0x1fc5, 0x3eef,
        0x24f2, 0x3e75, 0x1912, 0x05b1, 0x28bd, 0x39fe, 0x3e67, 0x2596, 0x0276, 0x1b31, 0x0dc8, 0x2b62, 0x1f22, 0x233d, 0x08f7, 0x2e64,
        0x3ee5, 0x3bf1, 0x2bef, 0x35df, 0x06fd, 0x2720, 0x1a9d, 0x0cad, 0x2a03, 0x29f2, 0x10ff, 0x2b51, 0x2da8, 0x339e, 0x1a17, 0x0930,
        0x038e, 0x043e, 0x2015, 0x0d05, 0x3352, 0x0df0, 0x1b68, 0x1537, 0x3841, 0x0c90, 0x1030, 0x05fd, 0x09bc, 0x1d2d, 0x023a, 0x163b,
        0x0b13, 0x3aa4, 0x3c3a, 0x1515, 0x19ae, 0x1f7e, 0x3c57, 0x2eff, 0x3ed3, 0x059f, 0x0f29, 0x275f, 0x0448, 0x3e19, 0x0189, 0x248f,
        0x0f70, 0x3e33, 0x2079, 0x218b, 0x149d, 0x2265, 0x1e0f, 0x3a7f, 0x2cd3, 0x11be, 0x1961, 0x11de, 0x0032, 0x2ff7, 0x3889, 0x180e,
        0x2054, 0x0b65, 0x26dc, 0x00b4, 0x0e6b, 0x34a5, 0x3b6d, 0x1e02, 0x33d8, 0x3227, 0x3807, 0x03f0, 0x1abf, 0x23af, 0x1295, 0x38b2,
        0x28b1, 0x34b4, 0x3b57, 0x3c75, 0x3857, 0x3fce, 0x2689, 0x2fc6, 0x15dd, 0x18ec, 0x2f4c, 0x1c8a, 0x2496, 0x0655, 0x1246, 0x177e,
        0x20a5, 0x3cee, 0x301e, 0x060e, 0x2b0f, 0x31ea, 0x3115, 0x3eff, 0x2131, 0x09e8, 0x1049, 0x3ab6, 0x07ea, 0x10ab, 0x1ac9, 0x335f,
        0x1d14, 0x3954, 0x1ff1, 0x01d5, 0x133c, 0x28e9, 0x0066, 0x29cb, 0x30d6, 0x1836, 0x0bdd, 0x0045, 0x25e4, 0x33b9, 0x0ee5, 0x32f7,
        0x03ea, 0x3d4a, 0x3c91, 0x0831, 0x131c, 0x318f, 0x2879, 0x355e, 0x34f7, 0x1df7, 0x02ce, 0x3d50, 0x2a66, 0x1952, 0x2d92, 0x2b4b,
        0x0ca1, 0x1d4b, 0x276a, 0x0de9, 0x1e86, 0x1e8d, 0x2bcc, 0x0ed0, 0x0b25, 0x2ab6, 0x0f49, 0x1d99, 0x14aa, 0x0597, 0x25cc, 0x391e,
        0x04d9, 0x3de1, 0x23be, 0x3fa8, 0x03dc, 0x3f8c, 0x32c4, 0x0ea9, 0x2b0a, 0x0e66, 0x03d7, 0x1317, 0x3150, 0x065f, 0x382e, 0x2534,
        0x3f72, 0x3df8, 0x237e, 0x1390, 0x01c7, 0x021f, 0x19a9, 0x06f8, 0x200c, 0x3bfd, 0x0112, 0x1f86, 0x2e31, 0x07a9, 0x20d7, 0x0778,
        0x3642, 0x0b30, 0x2451, 0x2578, 0x0664, 0x2956, 0x27b3, 0x2a2d, 0x2979, 0x3cd2, 0x0c36, 0x3c97, 0x3b8c, 0x2f6c, 0x2803, 0x3878,
        0x21de, 0x323f, 0x07e2, 0x1f65, 0x1cbe, 0x0b9b, 0x3011, 0x1c81, 0x325a, 0x17f3, 0x2eab, 0x3631, 0x0190, 0x3fbd, 0x10dd, 0x32b3,
        0x061a, 0x3400, 0x3754, 0x286d, 0x3155, 0x33ee, 0x132a, 0x354c, 0x1ad3, 0x117e, 0x2f54, 0x373e, 0x0e2d, 0x3790, 0x20fc, 0x1629,
        0x16b0, 0x0b4f, 0x2cf6, 0x2438, 0x0a9a, 0x0b1c, 0x1d3e, 0x2c05, 0x2247, 0x07c4, 0x28ca, 0x3492, 0x0740, 0x31c3, 0x3c4c, 0x29a3,
        0x2d22, 0x156f, 0x0761, 0x2d72, 0x2539, 0x164c, 0x3580, 0x1aff, 0x0464, 0x01bc, 0x22ad, 0x0837, 0x1899, 0x1527, 0x27df, 0x266b,
        0x246f, 0x3b34, 0x3167, 0x3fb4, 0x196c, 0x1e94, 0x252c, 0x36aa, 0x3aef, 0x35f7, 0x2656, 0x2d4e, 0x2682, 0x300a, 0x2a9b, 0x0db4,
        0x221d, 0x2646, 0x1f18, 0x28dd, 0x3833, 0x116e, 0x13fd, 0x3d9d, 0x2de8, 0x25d4, 0x0f11, 0x3301, 0x39e7, 0x2b3b, 0x313b, 0x1488,
        0x00dd, 0x2a92, 0x3afa, 0x1804, 0x1e68, 0x17b5, 0x2bf8, 0x3fdd, 0x23ea, 0x1454, 0x05d5, 0x38fb, 0x3684, 0x208d, 0x35c5, 0x2038,
        0x3d6f, 0x2f11, 0x1b97, 0x2831, 0x3de6, 0x26ca, 0x1c6f, 0x3821, 0x2bd9, 0x1548, 0x08b6, 0x1322, 0x058d, 0x25a6, 0x19f6, 0x19ff,
        0x30b9, 0x1821, 0x1684, 0x3e8c, 0x3bdd, 0x0ce6, 0x2aa2, 0x1787, 0x0e53, 0x3865, 0x38cd, 0x1bfc, 0x3e20, 0x123c, 0x062c, 0x1cec,
        0x16d4, 0x19cf, 0x3501, 0x14f9, 0x04de, 0x2e96, 0x3c20, 0x0648, 0x2843, 0x37be, 0x27c8, 0x18cf, 0x1f6d, 0x14db, 0x2d44, 0x225a,
        0x0481, 0x219f, 0x04cd, 0x235f, 0x0d86, 0x2c33, 0x293c, 0x1f9d, 0x3620, 0x3b06, 0x2dd7, 0x28f8, 0x0798, 0x18b8, 0x1284, 0x3250,
        0x312b, 0x2322, 0x0cfe, 0x1c0f, 0x3fad, 0x0de2, 0x240a, 0x296c, 0x33c8, 0x263b, 0x2d02, 0x3195, 0x1f76, 0x0aae, 0x3728, 0x1166,
        0x34f1, 0x33d2, 0x045e, 0x2973, 0x33c2, 0x2bd3, 0x2294, 0x0492, 0x0e9e, 0x167a, 0x0994, 0x1ba9, 0x15fb, 0x1d7c, 0x29fd, 0x0f8b,
        0x3712, 0x2ac0, 0x0319, 0x1ce0, 0x23c3, 0x17c5, 0x00f5, 0x38ee, 0x1c53, 0x10f6, 0x0e79, 0x0e0c, 0x1505, 0x3412, 0x24be, 0x36b2,
        0x2f96, 0x227a, 0x3c69, 0x142b, 0x06af, 0x039a, 0x1ee2, 0x1198, 0x330c, 0x2913, 0x0e01, 0x19b6, 0x0883, 0x332f, 0x05c1, 0x2928,
        0x172a, 0x3d1c, 0x16cc, 0x209d, 0x3f91, 0x3d0e, 0x00ab, 0x12dc, 0x0498, 0x2d0b, 0x35a8, 0x287f, 0x2b1d, 0x011d, 0x22fe, 0x0818,
        0x2f2a, 0x1da2, 0x016a, 0x0094, 0x19c0, 0x179b, 0x0dbb, 0x0d30, 0x2b72, 0x2b8d, 0x1eab, 0x0569, 0x044f, 0x0073, 0x2e7f, 0x1a2f,
        0x0a29, 0x3045, 0x12e9, 0x359c, 0x03e1, 0x38e0, 0x08be, 0x1bc7, 0x1302, 0x2176, 0x1c92, 0x270a, 0x1ffd, 0x3ebf, 0x10ba, 0x3f5e,
        0x1f39, 0x0d97, 0x27a7, 0x0259, 0x2b2c, 0x3bcf, 0x29e5, 0x160b, 0x06ca, 0x3ffc, 0x2ecf, 0x15c5, 0x10ce, 0x3d81, 0x0c0f, 0x1c31,
        0x14c6, 0x3a98, 0x294d, 0x2625, 0x0eae, 0x1944, 0x1cd8, 0x3fa0, 0x229a, 0x07d7, 0x1c5c, 0x3564, 0x21d7, 0x28aa, 0x2f23, 0x30b2,
        0x1dd4, 0x1bd4, 0x3c06, 0x2411, 0x029d, 0x0ed7, 0x36dd, 0x0e83, 0x384c, 0x0bac, 0x01fb, 0x0405, 0x0ac3, 0x31f9, 0x2c54, 0x238a,
        0x3577, 0x1065, 0x0926, 0x25fa, 0x32c9, 0x3730, 0x052b, 0x1f90, 0x0fcd, 0x3926, 0x0bc2, 0x2e74, 0x0b04, 0x0e17, 0x2696, 0x0d16,
        0x1464, 0x1e25, 0x17a9, 0x107d, 0x22e9, 0x3ae1, 0x2787, 0x389c, 0x3766, 0x2606, 0x0e48, 0x085c, 0x0723, 0x02ef, 0x05e0, 0x134a,
        0x1060, 0x3a93, 0x3040, 0x3d17, 0x2abb, 0x231d, 0x19ca, 0x2f0c, 0x2641, 0x156a, 0x33fb, 0x0b2b, 0x3ddc, 0x3d45, 0x3ce9, 0x0b60,
        0x3a9f, 0x3bec, 0x30c9, 0x37f6, 0x1695, 0x32a2, 0x2476, 0x39d6, 0x3e9e, 0x3bbe, 0x0679, 0x1cc7, 0x151c, 0x2962, 0x3660, 0x16c3,
        0x3d16, 0x3a92, 0x2f0b, 0x231c, 0x0b2a, 0x1569, 0x0b5f, 0x3d44, 0x37f5, 0x3beb, 0x39d5, 0x32a1, 0x1cc6, 0x3bbd, 0x16c2, 0x2961,
        0x231b, 0x3a91, 0x3d43, 0x1568, 0x32a0, 0x3bea, 0x2960, 0x3bbc, 0x1567, 0x3a90, 0x3bbb, 0x3be9, 0x3be8, 0x3a8f, 0x3a8d, 0x3a8e,
        0x1bd0, 0x3a94, 0x1e21, 0x1061, 0x1d9e, 0x3d18, 0x0d93, 0x3041, 0x33ce, 0x231e, 0x2276, 0x2abc, 0x181d, 0x2f0d, 0x219b, 0x19cb,
        0x3b30, 0x156b, 0x2a8e, 0x2642, 0x323b, 0x0b2c, 0x0b4b, 0x33fc, 0x1d47, 0x3d46, 0x3df4, 0x3ddd, 0x34b0, 0x0b61, 0x3950, 0x3cea,
        0x043a, 0x3bed, 0x3e2f, 0x3aa0, 0x0f4e, 0x37f7, 0x3e71, 0x30ca, 0x3066, 0x32a3, 0x27f9, 0x1696, 0x13ca, 0x39d7, 0x1658, 0x2477,
        0x3f15, 0x3bbf, 0x3783, 0x3e9f, 0x0cba, 0x1cc8, 0x0d7a, 0x067a, 0x31d2, 0x2963, 0x0c85, 0x151d, 0x2449, 0x16c4, 0x2ad6, 0x3661,
        0x29ef, 0x3bee, 0x0c8d, 0x043b, 0x059c, 0x3aa1, 0x11bb, 0x3e30, 0x319b, 0x37f8, 0x04b2, 0x0f4f, 0x1ca6, 0x30cb, 0x1b2e, 0x3e72,
        0x14cd, 0x32a4, 0x22dc, 0x3067, 0x1b25, 0x1697, 0x3b3b, 0x27fa, 0x0c58, 0x39d8, 0x2c16, 0x13cb, 0x3c41, 0x2478, 0x379f, 0x1659,
        0x06bc, 0x3bc0, 0x3f37, 0x3f16, 0x14af, 0x3ea0, 0x25ae, 0x3784, 0x11ee, 0x1cc9, 0x249e, 0x0cbb, 0x3e44, 0x067b, 0x02a9, 0x0d7b,
        0x3556, 0x2964, 0x12cf, 0x31d3, 0x0336, 0x151e, 0x3039, 0x0c86, 0x1b90, 0x16c5, 0x26d5, 0x244a, 0x04ec, 0x3662, 0x279c, 0x2ad7,
        0x07d4, 0x3a95, 0x0ba9, 0x1bd1, 0x3923, 0x1062, 0x2603, 0x1e22, 0x2d08, 0x3d19, 0x2b8a, 0x1d9f, 0x2173, 0x3042, 0x3ff9, 0x0d94,
        0x2638, 0x231f, 0x1677, 0x33cf, 0x10f3, 0x2abd, 0x2910, 0x2277, 0x1545, 0x2f0e, 0x3862, 0x181e, 0x37bb, 0x19cc, 0x3b03, 0x219c,
        0x01b9, 0x156c, 0x35f4, 0x3b31, 0x25d1, 0x2643, 0x1451, 0x2a8f, 0x3ccf, 0x0b2d, 0x17f0, 0x323c, 0x117b, 0x33fd, 0x07c1, 0x0b4c,
        0x1df4, 0x3d47, 0x2ab3, 0x1d48, 0x0e63, 0x3dde, 0x3bfa, 0x3df5, 0x3224, 0x0b62, 0x18e9, 0x34b1, 0x09e5, 0x3ceb, 0x1833, 0x3951,
        0x3f4f, 0x3bc1, 0x033d, 0x06bd, 0x1d50, 0x3f17, 0x1865, 0x3f38, 0x0ab4, 0x3ea1, 0x1dde, 0x14b0, 0x118e, 0x3785, 0x1ea2, 0x25af,
        0x262c, 0x1cca, 0x360b, 0x11ef, 0x0a67, 0x0cbc, 0x316e, 0x249f, 0x2dc8, 0x067c, 0x136b, 0x3e45, 0x3aab, 0x0d7c, 0x0968, 0x02aa,
        0x3f99, 0x2965, 0x1af8, 0x3557, 0x0ca6, 0x31d4, 0x0554, 0x12d0, 0x28a2, 0x151f, 0x3396, 0x0337, 0x0ba3, 0x0c87, 0x1e1b, 0x303a,
        0x2947, 0x16c6, 0x0cf8, 0x1b91, 0x075b, 0x244b, 0x3c8b, 0x26d6, 0x2be9, 0x3663, 0x1579, 0x04ed, 0x0372, 0x2ad8, 0x063d, 0x279d,
        0x271e, 0x3bef, 0x339c, 0x29f0, 0x0dee, 0x043c, 0x1d2b, 0x0c8e, 0x1f7c, 0x3aa2, 0x3e17, 0x059d, 0x2263, 0x3e31, 0x2ff5, 0x11bc,
        0x3f0a, 0x37f9, 0x2f7b, 0x319c, 0x0eee, 0x0f50, 0x29b4, 0x04b3, 0x113a, 0x30cc, 0x1ef9, 0x1ca7, 0x39fc, 0x3e73, 0x233b, 0x1b2f,
        0x11cf, 0x32a5, 0x1978, 0x14ce, 0x276f, 0x3068, 0x093f, 0x22dd, 0x0f82, 0x1698, 0x2083, 0x1b26, 0x22f6, 0x27fb, 0x3a31, 0x3b3c,
        0x23d1, 0x39d9, 0x3994, 0x0c59, 0x2152, 0x13cc, 0x23de, 0x2c17, 0x2fe0, 0x2479, 0x20c2, 0x3c42, 0x399f, 0x165a, 0x3529, 0x37a0,
        0x164a, 0x156d, 0x1525, 0x01ba, 0x1e92, 0x3b32, 0x3008, 0x35f5, 0x116c, 0x2644, 0x2b39, 0x25d2, 0x17b3, 0x2a90, 0x208b, 0x1452,
        0x2954, 0x0b2e, 0x2f6a, 0x3cd0, 0x0b99, 0x323d, 0x3fbb, 0x17f1, 0x33ec, 0x33fe, 0x378e, 0x117c, 0x0b1a, 0x0b4d, 0x31c1, 0x07c2,
        0x318d, 0x3d48, 0x1950, 0x1df5, 0x1e8b, 0x1d49, 0x0595, 0x2ab4, 0x3f8a, 0x3ddf, 0x065d, 0x0e64, 0x021d, 0x3df6, 0x07a7, 0x3bfb,
        0x34a3, 0x0b63, 0x23ad, 0x3225, 0x3fcc, 0x34b2, 0x0653, 0x18ea, 0x31e8, 0x3cec, 0x10a9, 0x09e6, 0x28e7, 0x3952, 0x33b7, 0x1834,
        0x1942, 0x3a96, 0x28a8, 0x07d5, 0x0ed5, 0x1bd2, 0x31f7, 0x0baa, 0x372e, 0x1063, 0x0e15, 0x3924, 0x3adf, 0x1e23, 0x02ed, 0x2604,
        0x3d0c, 0x3d1a, 0x011b, 0x2d09, 0x1799, 0x1da0, 0x0071, 0x2b8b, 0x38de, 0x3043, 0x3ebd, 0x2174, 0x3bcd, 0x0d95, 0x3d7f, 0x3ffa,
        0x0de0, 0x2320, 0x0aac, 0x2639, 0x2bd1, 0x33d0, 0x1d7a, 0x1678, 0x17c3, 0x2abe, 0x3410, 0x10f4, 0x0398, 0x2278, 0x332d, 0x2911,
        0x26c8, 0x2f0f, 0x25a4, 0x1546, 0x0ce4, 0x181f, 0x123a, 0x3863, 0x2e94, 0x19cd, 0x14d9, 0x37bc, 0x2c31, 0x219d, 0x18b6, 0x3b04,
        0x381b, 0x2966, 0x12d6, 0x3f9a, 0x1dfc, 0x3558, 0x2a27, 0x1af9, 0x2328, 0x31d5, 0x22c9, 0x0ca7, 0x091c, 0x12d1, 0x0ebc, 0x0555,
        0x194b, 0x1520, 0x0aa7, 0x28a3, 0x1af3, 0x0338, 0x1973, 0x3397, 0x3f32, 0x0c88, 0x35ef, 0x0ba4, 0x2f06, 0x303b, 0x3e2a, 0x1e1c,
        0x12e4, 0x16c7, 0x0921, 0x2948, 0x34fc, 0x1b92, 0x0314, 0x0cf9, 0x374f, 0x244c, 0x1f13, 0x075c, 0x3019, 0x26d7, 0x23b9, 0x3c8c,
        0x1745, 0x3664, 0x3c35, 0x2bea, 0x15ac, 0x04ee, 0x0892, 0x157a, 0x1144, 0x2ad9, 0x272c, 0x0373, 0x1909, 0x279e, 0x23a4, 0x063e,
        0x08c7, 0x3bc2, 0x055a, 0x3f50, 0x3d55, 0x06be, 0x16e4, 0x033e, 0x3131, 0x3f18, 0x0fbe, 0x1d51, 0x1cfe, 0x3f39, 0x089d, 0x1866,
        0x1eee, 0x3ea2, 0x3320, 0x0ab5, 0x0a8e, 0x14b1, 0x1f4f, 0x1ddf, 0x2c0e, 0x3786, 0x19e7, 0x118f, 0x1a58, 0x25b0, 0x2ea3, 0x1ea3,
        0x1a44, 0x1ccb, 0x0ec1, 0x262d, 0x02d3, 0x11f0, 0x1e54, 0x360c, 0x0a72, 0x0cbd, 0x2b00, 0x0a68, 0x1b75, 0x24a0, 0x337f, 0x316f,
        0x022d, 0x067d, 0x0b40, 0x2dc9, 0x13b3, 0x3e46, 0x3da9, 0x136c, 0x1ecc, 0x0d7d, 0x0752, 0x3aac, 0x198e, 0x02ab, 0x2551, 0x0969,
        0x39bd, 0x32a6, 0x31da, 0x11d0, 0x1957, 0x14cf, 0x2bbc, 0x1979, 0x1c15, 0x3069, 0x2d62, 0x2770, 0x125d, 0x22de, 0x16a0, 0x0940,
        0x0eb5, 0x1699, 0x3916, 0x0f83, 0x3ce2, 0x1b27, 0x1e9b, 0x2084, 0x128e, 0x27fc, 0x19ef, 0x22f7, 0x3c5e, 0x3b3d, 0x0873, 0x3a32,
        0x2853, 0x39da, 0x232d, 0x23d2, 0x2a6b, 0x0c5a, 0x1a07, 0x3995, 0x3369, 0x13cd, 0x124e, 0x2153, 0x2c73, 0x2c18, 0x0bf7, 0x23df,
        0x06e3, 0x247a, 0x0c79, 0x2fe1, 0x2caf, 0x3c43, 0x2793, 0x20c3, 0x17d2, 0x165b, 0x2af1, 0x39a0, 0x0ff2, 0x37a1, 0x20cc, 0x352a,
        0x35de, 0x3bf0, 0x0cac, 0x271f, 0x2b50, 0x29f1, 0x092f, 0x339d, 0x0d04, 0x043d, 0x1536, 0x0def, 0x05fc, 0x0c8f, 0x163a, 0x1d2c,
        0x1514, 0x3aa3, 0x2efe, 0x1f7d, 0x275e, 0x059e, 0x248e, 0x3e18, 0x218a, 0x3e32, 0x3a7e, 0x2264, 0x11dd, 0x11bd, 0x180d, 0x2ff6,
        0x08de, 0x37fa, 0x22ce, 0x3f0b, 0x2d97, 0x319d, 0x2e53, 0x2f7c, 0x32d7, 0x0f51, 0x0a58, 0x0eef, 0x0155, 0x04b4, 0x3f22, 0x29b5,
        0x2ce5, 0x30cd, 0x155e, 0x113b, 0x1e75, 0x1ca8, 0x3eee, 0x1efa, 0x05b0, 0x3e74, 0x2595, 0x39fd, 0x2b61, 0x1b30, 0x2e63, 0x233c,
        0x0830, 0x3d49, 0x355d, 0x318e, 0x3d4f, 0x1df6, 0x2b4a, 0x1951, 0x0de8, 0x1d4a, 0x0ecf, 0x1e8c, 0x1d98, 0x2ab5, 0x391d, 0x0596,
        0x3fa7, 0x3de0, 0x0ea8, 0x3f8b, 0x1316, 0x0e65, 0x2533, 0x065e, 0x138f, 0x3df7, 0x06f7, 0x021e, 0x1f85, 0x3bfc, 0x0777, 0x07a8,
        0x00b3, 0x0b64, 0x1e01, 0x34a4, 0x03ef, 0x3226, 0x38b1, 0x23ae, 0x3c74, 0x34b3, 0x2fc5, 0x3fcd, 0x1c89, 0x18eb, 0x177d, 0x0654,
        0x060d, 0x3ced, 0x3efe, 0x31e9, 0x3ab5, 0x09e7, 0x335e, 0x10aa, 0x01d4, 0x3953, 0x29ca, 0x28e8, 0x0044, 0x1835, 0x32f6, 0x33b8,
        0x2d71, 0x156e, 0x1afe, 0x164b, 0x0836, 0x01bb, 0x266a, 0x1526, 0x3fb3, 0x3b33, 0x36a9, 0x1e93, 0x2d4d, 0x35f6, 0x0db3, 0x3009,
        0x28dc, 0x2645, 0x3d9c, 0x116d, 0x3300, 0x25d3, 0x1487, 0x2b3a, 0x1803, 0x2a91, 0x3fdc, 0x17b4, 0x38fa, 0x1453, 0x2037, 0x208c,
        0x2577, 0x0b2f, 0x2a2c, 0x2955, 0x3c96, 0x3cd1, 0x3877, 0x2f6b, 0x1f64, 0x323e, 0x1c80, 0x0b9a, 0x3630, 0x17f2, 0x32b2, 0x3fbc,
        0x286c, 0x33ff, 0x354b, 0x33ed, 0x373d, 0x117d, 0x1628, 0x378f, 0x2437, 0x0b4e, 0x2c04, 0x0b1b, 0x3491, 0x07c3, 0x29a2, 0x31c2,
        0x1c0e, 0x2321, 0x296b, 0x0de1, 0x3194, 0x263a, 0x1165, 0x0aad, 0x2972, 0x33d1, 0x0491, 0x2bd2, 0x1ba8, 0x1679, 0x0f8a, 0x1d7b,
        0x1cdf, 0x2abf, 0x38ed, 0x17c4, 0x0e0b, 0x10f5, 0x36b1, 0x3411, 0x142a, 0x2279, 0x1197, 0x0399, 0x19b5, 0x2912, 0x2927, 0x332e,
        0x2830, 0x2f10, 0x3820, 0x26c9, 0x1321, 0x1547, 0x19fe, 0x25a5, 0x3e8b, 0x1820, 0x1786, 0x0ce5, 0x1bfb, 0x3864, 0x1ceb, 0x123b,
        0x14f8, 0x19ce, 0x0647, 0x2e95, 0x18ce, 0x37bd, 0x2259, 0x14da, 0x235e, 0x219e, 0x1f9c, 0x2c32, 0x28f7, 0x3b05, 0x324f, 0x18b7,
        0x2624, 0x3a97, 0x3f9f, 0x1943, 0x3563, 0x07d6, 0x30b1, 0x28a9, 0x2410, 0x1bd3, 0x0e82, 0x0ed6, 0x0404, 0x0bab, 0x2389, 0x31f8,
        0x25f9, 0x1064, 0x1f8f, 0x372f, 0x2e73, 0x3925, 0x0d15, 0x0e16, 0x107c, 0x1e24, 0x389b, 0x3ae0, 0x085b, 0x2605, 0x1349, 0x02ee,
        0x209c, 0x3d1b, 0x12db, 0x3d0d, 0x287e, 0x2d0a, 0x0817, 0x011c, 0x0093, 0x1da1, 0x0d2f, 0x179a, 0x0568, 0x2b8c, 0x1a2e, 0x0072,
        0x359b, 0x3044, 0x1bc6, 0x38df, 0x2709, 0x2175, 0x3f5d, 0x3ebe, 0x0258, 0x0d96, 0x160a, 0x3bce, 0x15c4, 0x3ffb, 0x1c30, 0x3d80
    },

    /* "alpha_to" table */
    {
        0x0001, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x0443, 0x0886,
        0x110c, 0x2218, 0x0073, 0x00e6, 0x01cc, 0x0398, 0x0730, 0x0e60, 0x1cc0, 0x3980, 0x3743, 0x2ac5, 0x11c9, 0x2392, 0x0367, 0x06ce,
        0x0d9c, 0x1b38, 0x3670, 0x28a3, 0x1505, 0x2a0a, 0x1057, 0x20ae, 0x051f, 0x0a3e, 0x147c, 0x28f8, 0x15b3, 0x2b66, 0x128f, 0x251e,
        0x0e7f, 0x1cfe, 0x39fc, 0x37bb, 0x2b35, 0x1229, 0x2452, 0x0ce7, 0x19ce, 0x339c, 0x237b, 0x02b5, 0x056a, 0x0ad4, 0x15a8, 0x2b50,
        0x12e3, 0x25c6, 0x0fcf, 0x1f9e, 0x3f3c, 0x3a3b, 0x3035, 0x2429, 0x0c11, 0x1822, 0x3044, 0x24cb, 0x0dd5, 0x1baa, 0x3754, 0x2aeb,
        0x1195, 0x232a, 0x0217, 0x042e, 0x085c, 0x10b8, 0x2170, 0x06a3, 0x0d46, 0x1a8c, 0x3518, 0x2e73, 0x18a5, 0x314a, 0x26d7, 0x09ed,
        0x13da, 0x27b4, 0x0b2b, 0x1656, 0x2cac, 0x1d1b, 0x3a36, 0x302f, 0x241d, 0x0c79, 0x18f2, 0x31e4, 0x278b, 0x0b55, 0x16aa, 0x2d54,
        0x1eeb, 0x3dd6, 0x3fef, 0x3b9d, 0x3379, 0x22b1, 0x0121, 0x0242, 0x0484, 0x0908, 0x1210, 0x2420, 0x0c03, 0x1806, 0x300c, 0x245b,
        0x0cf5, 0x19ea, 0x33d4, 0x23eb, 0x0395, 0x072a, 0x0e54, 0x1ca8, 0x3950, 0x36e3, 0x2985, 0x1749, 0x2e92, 0x1967, 0x32ce, 0x21df,
        0x07fd, 0x0ffa, 0x1ff4, 0x3fe8, 0x3b93, 0x3365, 0x2289, 0x0151, 0x02a2, 0x0544, 0x0a88, 0x1510, 0x2a20, 0x1003, 0x2006, 0x044f,
        0x089e, 0x113c, 0x2278, 0x00b3, 0x0166, 0x02cc, 0x0598, 0x0b30, 0x1660, 0x2cc0, 0x1dc3, 0x3b86, 0x334f, 0x22dd, 0x01f9, 0x03f2,
        0x07e4, 0x0fc8, 0x1f90, 0x3f20, 0x3a03, 0x3045, 0x24c9, 0x0dd1, 0x1ba2, 0x3744, 0x2acb, 0x11d5, 0x23aa, 0x0317, 0x062e, 0x0c5c,
        0x18b8, 0x3170, 0x26a3, 0x0905, 0x120a, 0x2414, 0x0c6b, 0x18d6, 0x31ac, 0x271b, 0x0a75, 0x14ea, 0x29d4, 0x17eb, 0x2fd6, 0x1bef,
        0x37de, 0x2bff, 0x13bd, 0x277a, 0x0ab7, 0x156e, 0x2adc, 0x11fb, 0x23f6, 0x03af, 0x075e, 0x0ebc, 0x1d78, 0x3af0, 0x31a3, 0x2705,
        0x0a49, 0x1492, 0x2924, 0x160b, 0x2c16, 0x1c6f, 0x38de, 0x35ff, 0x2fbd, 0x1b39, 0x3672, 0x28a7, 0x150d, 0x2a1a, 0x1077, 0x20ee,
        0x059f, 0x0b3e, 0x167c, 0x2cf8, 0x1db3, 0x3b66, 0x328f, 0x215d, 0x06f9, 0x0df2, 0x1be4, 0x37c8, 0x2bd3, 0x13e5, 0x27ca, 0x0bd7,
        0x17ae, 0x2f5c, 0x1afb, 0x35f6, 0x2faf, 0x1b1d, 0x363a, 0x2837, 0x142d, 0x285a, 0x14f7, 0x29ee, 0x179f, 0x2f3e, 0x1a3f, 0x347e,
        0x2cbf, 0x1d3d, 0x3a7a, 0x30b7, 0x252d, 0x0e19, 0x1c32, 0x3864, 0x348b, 0x2d55, 0x1ee9, 0x3dd2, 0x3fe7, 0x3b8d, 0x3359, 0x22f1,
        0x01a1, 0x0342, 0x0684, 0x0d08, 0x1a10, 0x3420, 0x2c03, 0x1c45, 0x388a, 0x3557, 0x2eed, 0x1999, 0x3332, 0x2227, 0x000d, 0x001a,
        0x0034, 0x0068, 0x00d0, 0x01a0, 0x0340, 0x0680, 0x0d00, 0x1a00, 0x3400, 0x2c43, 0x1cc5, 0x398a, 0x3757, 0x2aed, 0x1199, 0x2332,
        0x0227, 0x044e, 0x089c, 0x1138, 0x2270, 0x00a3, 0x0146, 0x028c, 0x0518, 0x0a30, 0x1460, 0x28c0, 0x15c3, 0x2b86, 0x134f, 0x269e,
        0x097f, 0x12fe, 0x25fc, 0x0fbb, 0x1f76, 0x3eec, 0x399b, 0x3775, 0x2aa9, 0x1111, 0x2222, 0x0007, 0x000e, 0x001c, 0x0038, 0x0070,
        0x00e0, 0x01c0, 0x0380, 0x0700, 0x0e00, 0x1c00, 0x3800, 0x3443, 0x2cc5, 0x1dc9, 0x3b92, 0x3367, 0x228d, 0x0159, 0x02b2, 0x0564,
        0x0ac8, 0x1590, 0x2b20, 0x1203, 0x2406, 0x0c4f, 0x189e, 0x313c, 0x263b, 0x0835, 0x106a, 0x20d4, 0x05eb, 0x0bd6, 0x17ac, 0x2f58,
        0x1af3, 0x35e6, 0x2f8f, 0x1b5d, 0x36ba, 0x2937, 0x162d, 0x2c5a, 0x1cf7, 0x39ee, 0x379f, 0x2b7d, 0x12b9, 0x2572, 0x0ea7, 0x1d4e,
        0x3a9c, 0x317b, 0x26b5, 0x0929, 0x1252, 0x24a4, 0x0d0b, 0x1a16, 0x342c, 0x2c1b, 0x1c75, 0x38ea, 0x3597, 0x2f6d, 0x1a99, 0x3532,
        0x2e27, 0x180d, 0x301a, 0x2477, 0x0cad, 0x195a, 0x32b4, 0x212b, 0x0615, 0x0c2a, 0x1854, 0x30a8, 0x2513, 0x0e65, 0x1cca, 0x3994,
        0x376b, 0x2a95, 0x1169, 0x22d2, 0x01e7, 0x03ce, 0x079c, 0x0f38, 0x1e70, 0x3ce0, 0x3d83, 0x3f45, 0x3ac9, 0x31d1, 0x27e1, 0x0b81,
        0x1702, 0x2e04, 0x184b, 0x3096, 0x256f, 0x0e9d, 0x1d3a, 0x3a74, 0x30ab, 0x2515, 0x0e69, 0x1cd2, 0x39a4, 0x370b, 0x2a55, 0x10e9,
        0x21d2, 0x07e7, 0x0fce, 0x1f9c, 0x3f38, 0x3a33, 0x3025, 0x2409, 0x0c51, 0x18a2, 0x3144, 0x26cb, 0x09d5, 0x13aa, 0x2754, 0x0aeb,
        0x15d6, 0x2bac, 0x131b, 0x2636, 0x082f, 0x105e, 0x20bc, 0x053b, 0x0a76, 0x14ec, 0x29d8, 0x17f3, 0x2fe6, 0x1b8f, 0x371e, 0x2a7f,
        0x10bd, 0x217a, 0x06b7, 0x0d6e, 0x1adc, 0x35b8, 0x2f33, 0x1a25, 0x344a, 0x2cd7, 0x1ded, 0x3bda, 0x33f7, 0x23ad, 0x0319, 0x0632,
        0x0c64, 0x18c8, 0x3190, 0x2763, 0x0a85, 0x150a, 0x2a14, 0x106b, 0x20d6, 0x05ef, 0x0bde, 0x17bc, 0x2f78, 0x1ab3, 0x3566, 0x2e8f,
        0x195d, 0x32ba, 0x2137, 0x062d, 0x0c5a, 0x18b4, 0x3168, 0x2693, 0x0965, 0x12ca, 0x2594, 0x0f6b, 0x1ed6, 0x3dac, 0x3f1b, 0x3a75,
        0x30a9, 0x2511, 0x0e61, 0x1cc2, 0x3984, 0x374b, 0x2ad5, 0x11e9, 0x23d2, 0x03e7, 0x07ce, 0x0f9c, 0x1f38, 0x3e70, 0x38a3, 0x3505,
        0x2e49, 0x18d1, 0x31a2, 0x2707, 0x0a4d, 0x149a, 0x2934, 0x162b, 0x2c56, 0x1cef, 0x39de, 0x37ff, 0x2bbd, 0x1339, 0x2672, 0x08a7,
        0x114e, 0x229c, 0x017b, 0x02f6, 0x05ec, 0x0bd8, 0x17b0, 0x2f60, 0x1a83, 0x3506, 0x2e4f, 0x18dd, 0x31ba, 0x2737, 0x0a2d, 0x145a,
        0x28b4, 0x152b, 0x2a56, 0x10ef, 0x21de, 0x07ff, 0x0ffe, 0x1ffc, 0x3ff8, 0x3bb3, 0x3325, 0x2209, 0x0051, 0x00a2, 0x0144, 0x0288,
        0x0510, 0x0a20, 0x1440, 0x2880, 0x1543, 0x2a86, 0x114f, 0x229e, 0x017f, 0x02fe, 0x05fc, 0x0bf8, 0x17f0, 0x2fe0, 0x1b83, 0x3706,
        0x2a4f, 0x10dd, 0x21ba, 0x0737, 0x0e6e, 0x1cdc, 0x39b8, 0x3733, 0x2a25, 0x1009, 0x2012, 0x0467, 0x08ce, 0x119c, 0x2338, 0x0233,
        0x0466, 0x08cc, 0x1198, 0x2330, 0x0223, 0x0446, 0x088c, 0x1118, 0x2230, 0x0023, 0x0046, 0x008c, 0x0118, 0x0230, 0x0460, 0x08c0,
        0x1180, 0x2300, 0x0243, 0x0486, 0x090c, 0x1218, 0x2430, 0x0c23, 0x1846, 0x308c, 0x255b, 0x0ef5, 0x1dea, 0x3bd4, 0x33eb, 0x2395,
        0x0369, 0x06d2, 0x0da4, 0x1b48, 0x3690, 0x2963, 0x1685, 0x2d0a, 0x1e57, 0x3cae, 0x3d1f, 0x3e7d, 0x38b9, 0x3531, 0x2e21, 0x1801,
        0x3002, 0x2447, 0x0ccd, 0x199a, 0x3334, 0x222b, 0x0015, 0x002a, 0x0054, 0x00a8, 0x0150, 0x02a0, 0x0540, 0x0a80, 0x1500, 0x2a00,
        0x1043, 0x2086, 0x054f, 0x0a9e, 0x153c, 0x2a78, 0x10b3, 0x2166, 0x068f, 0x0d1e, 0x1a3c, 0x3478, 0x2cb3, 0x1d25, 0x3a4a, 0x30d7,
        0x25ed, 0x0f99, 0x1f32, 0x3e64, 0x388b, 0x3555, 0x2ee9, 0x1991, 0x3322, 0x2207, 0x004d, 0x009a, 0x0134, 0x0268, 0x04d0, 0x09a0,
        0x1340, 0x2680, 0x0943, 0x1286, 0x250c, 0x0e5b, 0x1cb6, 0x396c, 0x369b, 0x2975, 0x16a9, 0x2d52, 0x1ee7, 0x3dce, 0x3fdf, 0x3bfd,
        0x33b9, 0x2331, 0x0221, 0x0442, 0x0884, 0x1108, 0x2210, 0x0063, 0x00c6, 0x018c, 0x0318, 0x0630, 0x0c60, 0x18c0, 0x3180, 0x2743,
        0x0ac5, 0x158a, 0x2b14, 0x126b, 0x24d6, 0x0def, 0x1bde, 0x37bc, 0x2b3b, 0x1235, 0x246a, 0x0c97, 0x192e, 0x325c, 0x20fb, 0x05b5,
        0x0b6a, 0x16d4, 0x2da8, 0x1f13, 0x3e26, 0x380f, 0x345d, 0x2cf9, 0x1db1, 0x3b62, 0x3287, 0x214d, 0x06d9, 0x0db2, 0x1b64, 0x36c8,
        0x29d3, 0x17e5, 0x2fca, 0x1bd7, 0x37ae, 0x2b1f, 0x127d, 0x24fa, 0x0db7, 0x1b6e, 0x36dc, 0x29fb, 0x17b5, 0x2f6a, 0x1a97, 0x352e,
        0x2e1f, 0x187d, 0x30fa, 0x25b7, 0x0f2d, 0x1e5a, 0x3cb4, 0x3d2b, 0x3e15, 0x3869, 0x3491, 0x2d61, 0x1e81, 0x3d02, 0x3e47, 0x38cd,
        0x35d9, 0x2ff1, 0x1ba1, 0x3742, 0x2ac7, 0x11cd, 0x239a, 0x0377, 0x06ee, 0x0ddc, 0x1bb8, 0x3770, 0x2aa3, 0x1105, 0x220a, 0x0057,
        0x00ae, 0x015c, 0x02b8, 0x0570, 0x0ae0, 0x15c0, 0x2b80, 0x1343, 0x2686, 0x094f, 0x129e, 0x253c, 0x0e3b, 0x1c76, 0x38ec, 0x359b,
        0x2f75, 0x1aa9, 0x3552, 0x2ee7, 0x198d, 0x331a, 0x2277, 0x00ad, 0x015a, 0x02b4, 0x0568, 0x0ad0, 0x15a0, 0x2b40, 0x12c3, 0x2586,
        0x0f4f, 0x1e9e, 0x3d3c, 0x3e3b, 0x3835, 0x3429, 0x2c11, 0x1c61, 0x38c2, 0x35c7, 0x2fcd, 0x1bd9, 0x37b2, 0x2b27, 0x120d, 0x241a,
        0x0c77, 0x18ee, 0x31dc, 0x27fb, 0x0bb5, 0x176a, 0x2ed4, 0x19eb, 0x33d6, 0x23ef, 0x039d, 0x073a, 0x0e74, 0x1ce8, 0x39d0, 0x37e3,
        0x2b85, 0x1349, 0x2692, 0x0967, 0x12ce, 0x259c, 0x0f7b, 0x1ef6, 0x3dec, 0x3f9b, 0x3b75, 0x32a9, 0x2111, 0x0661, 0x0cc2, 0x1984,
        0x3308, 0x2253, 0x00e5, 0x01ca, 0x0394, 0x0728, 0x0e50, 0x1ca0, 0x3940, 0x36c3, 0x29c5, 0x17c9, 0x2f92, 0x1b67, 0x36ce, 0x29df,
        0x17fd, 0x2ffa, 0x1bb7, 0x376e, 0x2a9f, 0x117d, 0x22fa, 0x01b7, 0x036e, 0x06dc, 0x0db8, 0x1b70, 0x36e0, 0x2983, 0x1745, 0x2e8a,
        0x1957, 0x32ae, 0x211f, 0x067d, 0x0cfa, 0x19f4, 0x33e8, 0x2393, 0x0365, 0x06ca, 0x0d94, 0x1b28, 0x3650, 0x28e3, 0x1585, 0x2b0a,
        0x1257, 0x24ae, 0x0d1f, 0x1a3e, 0x347c, 0x2cbb, 0x1d35, 0x3a6a, 0x3097, 0x256d, 0x0e99, 0x1d32, 0x3a64, 0x308b, 0x2555, 0x0ee9,
        0x1dd2, 0x3ba4, 0x330b, 0x2255, 0x00e9, 0x01d2, 0x03a4, 0x0748, 0x0e90, 0x1d20, 0x3a40, 0x30c3, 0x25c5, 0x0fc9, 0x1f92, 0x3f24,
        0x3a0b, 0x3055, 0x24e9, 0x0d91, 0x1b22, 0x3644, 0x28cb, 0x15d5, 0x2baa, 0x1317, 0x262e, 0x081f, 0x103e, 0x207c, 0x04bb, 0x0976,
        0x12ec, 0x25d8, 0x0ff3, 0x1fe6, 0x3fcc, 0x3bdb, 0x33f5, 0x23a9, 0x0311, 0x0622, 0x0c44, 0x1888, 0x3110, 0x2663, 0x0885, 0x110a,
        0x2214, 0x006b, 0x00d6, 0x01ac, 0x0358, 0x06b0, 0x0d60, 0x1ac0, 0x3580, 0x2f43, 0x1ac5, 0x358a, 0x2f57, 0x1aed, 0x35da, 0x2ff7,
        0x1bad, 0x375a, 0x2af7, 0x11ad, 0x235a, 0x02f7, 0x05ee, 0x0bdc, 0x17b8, 0x2f70, 0x1aa3, 0x3546, 0x2ecf, 0x19dd, 0x33ba, 0x2337,
        0x022d, 0x045a, 0x08b4, 0x1168, 0x22d0, 0x01e3, 0x03c6, 0x078c, 0x0f18, 0x1e30, 0x3c60, 0x3c83, 0x3d45, 0x3ec9, 0x39d1, 0x37e1,
        0x2b81, 0x1341, 0x2682, 0x0947, 0x128e, 0x251c, 0x0e7b, 0x1cf6, 0x39ec, 0x379b, 0x2b75, 0x12a9, 0x2552, 0x0ee7, 0x1dce, 0x3b9c,
        0x337b, 0x22b5, 0x0129, 0x0252, 0x04a4, 0x0948, 0x1290, 0x2520, 0x0e03, 0x1c06, 0x380c, 0x345b, 0x2cf5, 0x1da9, 0x3b52, 0x32e7,
        0x218d, 0x0759, 0x0eb2, 0x1d64, 0x3ac8, 0x31d3, 0x27e5, 0x0b89, 0x1712, 0x2e24, 0x180b, 0x3016, 0x246f, 0x0c9d, 0x193a, 0x3274,
        0x20ab, 0x0515, 0x0a2a, 0x1454, 0x28a8, 0x1513, 0x2a26, 0x100f, 0x201e, 0x047f, 0x08fe, 0x11fc, 0x23f8, 0x03b3, 0x0766, 0x0ecc,
        0x1d98, 0x3b30, 0x3223, 0x2005, 0x0449, 0x0892, 0x1124, 0x2248, 0x00d3, 0x01a6, 0x034c, 0x0698, 0x0d30, 0x1a60, 0x34c0, 0x2dc3,
        0x1fc5, 0x3f8a, 0x3b57, 0x32ed, 0x2199, 0x0771, 0x0ee2, 0x1dc4, 0x3b88, 0x3353, 0x22e5, 0x0189, 0x0312, 0x0624, 0x0c48, 0x1890,
        0x3120, 0x2603, 0x0845, 0x108a, 0x2114, 0x066b, 0x0cd6, 0x19ac, 0x3358, 0x22f3, 0x01a5, 0x034a, 0x0694, 0x0d28, 0x1a50, 0x34a0,
        0x2d03, 0x1e45, 0x3c8a, 0x3d57, 0x3eed, 0x3999, 0x3771, 0x2aa1, 0x1101, 0x2202, 0x0047, 0x008e, 0x011c, 0x0238, 0x0470, 0x08e0,
        0x11c0, 0x2380, 0x0343, 0x0686, 0x0d0c, 0x1a18, 0x3430, 0x2c23, 0x1c05, 0x380a, 0x3457, 0x2ced, 0x1d99, 0x3b32, 0x3227, 0x200d,
        0x0459, 0x08b2, 0x1164, 0x22c8, 0x01d3, 0x03a6, 0x074c, 0x0e98, 0x1d30, 0x3a60, 0x3083, 0x2545, 0x0ec9, 0x1d92, 0x3b24, 0x320b,
        0x2055, 0x04e9, 0x09d2, 0x13a4, 0x2748, 0x0ad3, 0x15a6, 0x2b4c, 0x12db, 0x25b6, 0x0f2f, 0x1e5e, 0x3cbc, 0x3d3b, 0x3e35, 0x3829,
        0x3411, 0x2c61, 0x1c81, 0x3902, 0x3647, 0x28cd, 0x15d9, 0x2bb2, 0x1327, 0x264e, 0x08df, 0x11be, 0x237c, 0x02bb, 0x0576, 0x0aec,
        0x15d8, 0x2bb0, 0x1323, 0x2646, 0x08cf, 0x119e, 0x233c, 0x023b, 0x0476, 0x08ec, 0x11d8, 0x23b0, 0x0323, 0x0646, 0x0c8c, 0x1918,
        0x3230, 0x2023, 0x0405, 0x080a, 0x1014, 0x2028, 0x0413, 0x0826, 0x104c, 0x2098, 0x0573, 0x0ae6, 0x15cc, 0x2b98, 0x1373, 0x26e6,
        0x098f, 0x131e, 0x263c, 0x083b, 0x1076, 0x20ec, 0x059b, 0x0b36, 0x166c, 0x2cd8, 0x1df3, 0x3be6, 0x338f, 0x235d, 0x02f9, 0x05f2,
        0x0be4, 0x17c8, 0x2f90, 0x1b63, 0x36c6, 0x29cf, 0x17dd, 0x2fba, 0x1b37, 0x366e, 0x289f, 0x157d, 0x2afa, 0x11b7, 0x236e, 0x029f,
        0x053e, 0x0a7c, 0x14f8, 0x29f0, 0x17a3, 0x2f46, 0x1acf, 0x359e, 0x2f7f, 0x1abd, 0x357a, 0x2eb7, 0x192d, 0x325a, 0x20f7, 0x05ad,
        0x0b5a, 0x16b4, 0x2d68, 0x1e93, 0x3d26, 0x3e0f, 0x385d, 0x34f9, 0x2db1, 0x1f21, 0x3e42, 0x38c7, 0x35cd, 0x2fd9, 0x1bf1, 0x37e2,
        0x2b87, 0x134d, 0x269a, 0x0977, 0x12ee, 0x25dc, 0x0ffb, 0x1ff6, 0x3fec, 0x3b9b, 0x3375, 0x22a9, 0x0111, 0x0222, 0x0444, 0x0888,
        0x1110, 0x2220, 0x0003, 0x0006, 0x000c, 0x0018, 0x0030, 0x0060, 0x00c0, 0x0180, 0x0300, 0x0600, 0x0c00, 0x1800, 0x3000, 0x2443,
        0x0cc5, 0x198a, 0x3314, 0x226b, 0x0095, 0x012a, 0x0254, 0x04a8, 0x0950, 0x12a0, 0x2540, 0x0ec3, 0x1d86, 0x3b0c, 0x325b, 0x20f5,
        0x05a9, 0x0b52, 0x16a4, 0x2d48, 0x1ed3, 0x3da6, 0x3f0f, 0x3a5d, 0x30f9, 0x25b1, 0x0f21, 0x1e42, 0x3c84, 0x3d4b, 0x3ed5, 0x39e9,
        0x3791, 0x2b61, 0x1281, 0x2502, 0x0e47, 0x1c8e, 0x391c, 0x367b, 0x28b5, 0x1529, 0x2a52, 0x10e7, 0x21ce, 0x07df, 0x0fbe, 0x1f7c,
        0x3ef8, 0x39b3, 0x3725, 0x2a09, 0x1051, 0x20a2, 0x0507, 0x0a0e, 0x141c, 0x2838, 0x1433, 0x2866, 0x148f, 0x291e, 0x167f, 0x2cfe,
        0x1dbf, 0x3b7e, 0x32bf, 0x213d, 0x0639, 0x0c72, 0x18e4, 0x31c8, 0x27d3, 0x0be5, 0x17ca, 0x2f94, 0x1b6b, 0x36d6, 0x29ef, 0x179d,
        0x2f3a, 0x1a37, 0x346e, 0x2c9f, 0x1d7d, 0x3afa, 0x31b7, 0x272d, 0x0a19, 0x1432, 0x2864, 0x148b, 0x2916, 0x166f, 0x2cde, 0x1dff,
        0x3bfe, 0x33bf, 0x233d, 0x0239, 0x0472, 0x08e4, 0x11c8, 0x2390, 0x0363, 0x06c6, 0x0d8c, 0x1b18, 0x3630, 0x2823, 0x1405, 0x280a,
        0x1457, 0x28ae, 0x151f, 0x2a3e, 0x103f, 0x207e, 0x04bf, 0x097e, 0x12fc, 0x25f8, 0x0fb3, 0x1f66, 0x3ecc, 0x39db, 0x37f5, 0x2ba9,
        0x1311, 0x2622, 0x0807, 0x100e, 0x201c, 0x047b, 0x08f6, 0x11ec, 0x23d8, 0x03f3, 0x07e6, 0x0fcc, 0x1f98, 0x3f30, 0x3a23, 0x3005,
        0x2449, 0x0cd1, 0x19a2, 0x3344, 0x22cb, 0x01d5, 0x03aa, 0x0754, 0x0ea8, 0x1d50, 0x3aa0, 0x3103, 0x2645, 0x08c9, 0x1192, 0x2324,
        0x020b, 0x0416, 0x082c, 0x1058, 0x20b0, 0x0523, 0x0a46, 0x148c, 0x2918, 0x1673, 0x2ce6, 0x1d8f, 0x3b1e, 0x327f, 0x20bd, 0x0539,
        0x0a72, 0x14e4, 0x29c8, 0x17d3, 0x2fa6, 0x1b0f, 0x361e, 0x287f, 0x14bd, 0x297a, 0x16b7, 0x2d6e, 0x1e9f, 0x3d3e, 0x3e3f, 0x383d,
        0x3439, 0x2c31, 0x1c21, 0x3842, 0x34c7, 0x2dcd, 0x1fd9, 0x3fb2, 0x3b27, 0x320d, 0x2059, 0x04f1, 0x09e2, 0x13c4, 0x2788, 0x0b53,
        0x16a6, 0x2d4c, 0x1edb, 0x3db6, 0x3f2f, 0x3a1d, 0x3079, 0x24b1, 0x0d21, 0x1a42, 0x3484, 0x2d4b, 0x1ed5, 0x3daa, 0x3f17, 0x3a6d,
        0x3099, 0x2571, 0x0ea1, 0x1d42, 0x3a84, 0x314b, 0x26d5, 0x09e9, 0x13d2, 0x27a4, 0x0b0b, 0x1616, 0x2c2c, 0x1c1b, 0x3836, 0x342f,
        0x2c1d, 0x1c79, 0x38f2, 0x35a7, 0x2f0d, 0x1a59, 0x34b2, 0x2d27, 0x1e0d, 0x3c1a, 0x3c77, 0x3cad, 0x3d19, 0x3e71, 0x38a1, 0x3501,
        0x2e41, 0x18c1, 0x3182, 0x2747, 0x0acd, 0x159a, 0x2b34, 0x122b, 0x2456, 0x0cef, 0x19de, 0x33bc, 0x233b, 0x0235, 0x046a, 0x08d4,
        0x11a8, 0x2350, 0x02e3, 0x05c6, 0x0b8c, 0x1718, 0x2e30, 0x1823, 0x3046, 0x24cf, 0x0ddd, 0x1bba, 0x3774, 0x2aab, 0x1115, 0x222a,
        0x0017, 0x002e, 0x005c, 0x00b8, 0x0170, 0x02e0, 0x05c0, 0x0b80, 0x1700, 0x2e00, 0x1843, 0x3086, 0x254f, 0x0edd, 0x1dba, 0x3b74,
        0x32ab, 0x2115, 0x0669, 0x0cd2, 0x19a4, 0x3348, 0x22d3, 0x01e5, 0x03ca, 0x0794, 0x0f28, 0x1e50, 0x3ca0, 0x3d03, 0x3e45, 0x38c9,
        0x35d1, 0x2fe1, 0x1b81, 0x3702, 0x2a47, 0x10cd, 0x219a, 0x0777, 0x0eee, 0x1ddc, 0x3bb8, 0x3333, 0x2225, 0x0009, 0x0012, 0x0024,
        0x0048, 0x0090, 0x0120, 0x0240, 0x0480, 0x0900, 0x1200, 0x2400, 0x0c43, 0x1886, 0x310c, 0x265b, 0x08f5, 0x11ea, 0x23d4, 0x03eb,
        0x07d6, 0x0fac, 0x1f58, 0x3eb0, 0x3923, 0x3605, 0x2849, 0x14d1, 0x29a2, 0x1707, 0x2e0e, 0x185f, 0x30be, 0x253f, 0x0e3d, 0x1c7a,
        0x38f4, 0x35ab, 0x2f15, 0x1a69, 0x34d2, 0x2de7, 0x1f8d, 0x3f1a, 0x3a77, 0x30ad, 0x2519, 0x0e71, 0x1ce2, 0x39c4, 0x37cb, 0x2bd5,
        0x13e9, 0x27d2, 0x0be7, 0x17ce, 0x2f9c, 0x1b7b, 0x36f6, 0x29af, 0x171d, 0x2e3a, 0x1837, 0x306e, 0x249f, 0x0d7d, 0x1afa, 0x35f4,
        0x2fab, 0x1b15, 0x362a, 0x2817, 0x146d, 0x28da, 0x15f7, 0x2bee, 0x139f, 0x273e, 0x0a3f, 0x147e, 0x28fc, 0x15bb, 0x2b76, 0x12af,
        0x255e, 0x0eff, 0x1dfe, 0x3bfc, 0x33bb, 0x2335, 0x0229, 0x0452, 0x08a4, 0x1148, 0x2290, 0x0163, 0x02c6, 0x058c, 0x0b18, 0x1630,
        0x2c60, 0x1c83, 0x3906, 0x364f, 0x28dd, 0x15f9, 0x2bf2, 0x13a7, 0x274e, 0x0adf, 0x15be, 0x2b7c, 0x12bb, 0x2576, 0x0eaf, 0x1d5e,
        0x3abc, 0x313b, 0x2635, 0x0829, 0x1052, 0x20a4, 0x050b, 0x0a16, 0x142c, 0x2858, 0x14f3, 0x29e6, 0x178f, 0x2f1e, 0x1a7f, 0x34fe,
        0x2dbf, 0x1f3d, 0x3e7a, 0x38b7, 0x352d, 0x2e19, 0x1871, 0x30e2, 0x2587, 0x0f4d, 0x1e9a, 0x3d34, 0x3e2b, 0x3815, 0x3469, 0x2c91,
        0x1d61, 0x3ac2, 0x31c7, 0x27cd, 0x0bd9, 0x17b2, 0x2f64, 0x1a8b, 0x3516, 0x2e6f, 0x189d, 0x313a, 0x2637, 0x082d, 0x105a, 0x20b4,
        0x052b, 0x0a56, 0x14ac, 0x2958, 0x16f3, 0x2de6, 0x1f8f, 0x3f1e, 0x3a7f, 0x30bd, 0x2539, 0x0e31, 0x1c62, 0x38c4, 0x35cb, 0x2fd5,
        0x1be9, 0x37d2, 0x2be7, 0x138d, 0x271a, 0x0a77, 0x14ee, 0x29dc, 0x17fb, 0x2ff6, 0x1baf, 0x375e, 0x2aff, 0x11bd, 0x237a, 0x02b7,
        0x056e, 0x0adc, 0x15b8, 0x2b70, 0x12a3, 0x2546, 0x0ecf, 0x1d9e, 0x3b3c, 0x323b, 0x2035, 0x0429, 0x0852, 0x10a4, 0x2148, 0x06d3,
        0x0da6, 0x1b4c, 0x3698, 0x2973, 0x16a5, 0x2d4a, 0x1ed7, 0x3dae, 0x3f1f, 0x3a7d, 0x30b9, 0x2531, 0x0e21, 0x1c42, 0x3884, 0x354b,
        0x2ed5, 0x19e9, 0x33d2, 0x23e7, 0x038d, 0x071a, 0x0e34, 0x1c68, 0x38d0, 0x35e3, 0x2f85, 0x1b49, 0x3692, 0x2967, 0x168d, 0x2d1a,
        0x1e77, 0x3cee, 0x3d9f, 0x3f7d, 0x3ab9, 0x3131, 0x2621, 0x0801, 0x1002, 0x2004, 0x044b, 0x0896, 0x112c, 0x2258, 0x00f3, 0x01e6,
        0x03cc, 0x0798, 0x0f30, 0x1e60, 0x3cc0, 0x3dc3, 0x3fc5, 0x3bc9, 0x33d1, 0x23e1, 0x0381, 0x0702, 0x0e04, 0x1c08, 0x3810, 0x3463,
        0x2c85, 0x1d49, 0x3a92, 0x3167, 0x268d, 0x0959, 0x12b2, 0x2564, 0x0e8b, 0x1d16, 0x3a2c, 0x301b, 0x2475, 0x0ca9, 0x1952, 0x32a4,
        0x210b, 0x0655, 0x0caa, 0x1954, 0x32a8, 0x2113, 0x0665, 0x0cca, 0x1994, 0x3328, 0x2213, 0x0065, 0x00ca, 0x0194, 0x0328, 0x0650,
        0x0ca0, 0x1940, 0x3280, 0x2143, 0x06c5, 0x0d8a, 0x1b14, 0x3628, 0x2813, 0x1465, 0x28ca, 0x15d7, 0x2bae, 0x131f, 0x263e, 0x083f,
        0x107e, 0x20fc, 0x05bb, 0x0b76, 0x16ec, 0x2dd8, 0x1ff3, 0x3fe6, 0x3b8f, 0x335d, 0x22f9, 0x01b1, 0x0362, 0x06c4, 0x0d88, 0x1b10,
        0x3620, 0x2803, 0x1445, 0x288a, 0x1557, 0x2aae, 0x111f, 0x223e, 0x003f, 0x007e, 0x00fc, 0x01f8, 0x03f0, 0x07e0, 0x0fc0, 0x1f80,
        0x3f00, 0x3a43, 0x30c5, 0x25c9, 0x0fd1, 0x1fa2, 0x3f44, 0x3acb, 0x31d5, 0x27e9, 0x0b91, 0x1722, 0x2e44, 0x18cb, 0x3196, 0x276f,
        0x0a9d, 0x153a, 0x2a74, 0x10ab, 0x2156, 0x06ef, 0x0dde, 0x1bbc, 0x3778, 0x2ab3, 0x1125, 0x224a, 0x00d7, 0x01ae, 0x035c, 0x06b8,
        0x0d70, 0x1ae0, 0x35c0, 0x2fc3, 0x1bc5, 0x378a, 0x2b57, 0x12ed, 0x25da, 0x0ff7, 0x1fee, 0x3fdc, 0x3bfb, 0x33b5, 0x2329, 0x0211,
        0x0422, 0x0844, 0x1088, 0x2110, 0x0663, 0x0cc6, 0x198c, 0x3318, 0x2273, 0x00a5, 0x014a, 0x0294, 0x0528, 0x0a50, 0x14a0, 0x2940,
        0x16c3, 0x2d86, 0x1f4f, 0x3e9e, 0x397f, 0x36bd, 0x2939, 0x1631, 0x2c62, 0x1c87, 0x390e, 0x365f, 0x28fd, 0x15b9, 0x2b72, 0x12a7,
        0x254e, 0x0edf, 0x1dbe, 0x3b7c, 0x32bb, 0x2135, 0x0629, 0x0c52, 0x18a4, 0x3148, 0x26d3, 0x09e5, 0x13ca, 0x2794, 0x0b6b, 0x16d6,
        0x2dac, 0x1f1b, 0x3e36, 0x382f, 0x341d, 0x2c79, 0x1cb1, 0x3962, 0x3687, 0x294d, 0x16d9, 0x2db2, 0x1f27, 0x3e4e, 0x38df, 0x35fd,
        0x2fb9, 0x1b31, 0x3662, 0x2887, 0x154d, 0x2a9a, 0x1177, 0x22ee, 0x019f, 0x033e, 0x067c, 0x0cf8, 0x19f0, 0x33e0, 0x2383, 0x0345,
        0x068a, 0x0d14, 0x1a28, 0x3450, 0x2ce3, 0x1d85, 0x3b0a, 0x3257, 0x20ed, 0x0599, 0x0b32, 0x1664, 0x2cc8, 0x1dd3, 0x3ba6, 0x330f,
        0x225d, 0x00f9, 0x01f2, 0x03e4, 0x07c8, 0x0f90, 0x1f20, 0x3e40, 0x38c3, 0x35c5, 0x2fc9, 0x1bd1, 0x37a2, 0x2b07, 0x124d, 0x249a,
        0x0d77, 0x1aee, 0x35dc, 0x2ffb, 0x1bb5, 0x376a, 0x2a97, 0x116d, 0x22da, 0x01f7, 0x03ee, 0x07dc, 0x0fb8, 0x1f70, 0x3ee0, 0x3983,
        0x3745, 0x2ac9, 0x11d1, 0x23a2, 0x0307, 0x060e, 0x0c1c, 0x1838, 0x3070, 0x24a3, 0x0d05, 0x1a0a, 0x3414, 0x2c6b, 0x1c95, 0x392a,
        0x3617, 0x286d, 0x1499, 0x2932, 0x1627, 0x2c4e, 0x1cdf, 0x39be, 0x373f, 0x2a3d, 0x1039, 0x2072, 0x04a7, 0x094e, 0x129c, 0x2538,
        0x0e33, 0x1c66, 0x38cc, 0x35db, 0x2ff5, 0x1ba9, 0x3752, 0x2ae7, 0x118d, 0x231a, 0x0277, 0x04ee, 0x09dc, 0x13b8, 0x2770, 0x0aa3,
        0x1546, 0x2a8c, 0x115b, 0x22b6, 0x012f, 0x025e, 0x04bc, 0x0978, 0x12f0, 0x25e0, 0x0f83, 0x1f06, 0x3e0c, 0x385b, 0x34f5, 0x2da9,
        0x1f11, 0x3e22, 0x3807, 0x344d, 0x2cd9, 0x1df1, 0x3be2, 0x3387, 0x234d, 0x02d9, 0x05b2, 0x0b64, 0x16c8, 0x2d90, 0x1f63, 0x3ec6,
        0x39cf, 0x37dd, 0x2bf9, 0x13b1, 0x2762, 0x0a87, 0x150e, 0x2a1c, 0x107b, 0x20f6, 0x05af, 0x0b5e, 0x16bc, 0x2d78, 0x1eb3, 0x3d66,
        0x3e8f, 0x395d, 0x36f9, 0x29b1, 0x1721, 0x2e42, 0x18c7, 0x318e, 0x275f, 0x0afd, 0x15fa, 0x2bf4, 0x13ab, 0x2756, 0x0aef, 0x15de,
        0x2bbc, 0x133b, 0x2676, 0x08af, 0x115e, 0x22bc, 0x013b, 0x0276, 0x04ec, 0x09d8, 0x13b0, 0x2760, 0x0a83, 0x1506, 0x2a0c, 0x105b,
        0x20b6, 0x052f, 0x0a5e, 0x14bc, 0x2978, 0x16b3, 0x2d66, 0x1e8f, 0x3d1e, 0x3e7f, 0x38bd, 0x3539, 0x2e31, 0x1821, 0x3042, 0x24c7,
        0x0dcd, 0x1b9a, 0x3734, 0x2a2b, 0x1015, 0x202a, 0x0417, 0x082e, 0x105c, 0x20b8, 0x0533, 0x0a66, 0x14cc, 0x2998, 0x1773, 0x2ee6,
        0x198f, 0x331e, 0x227f, 0x00bd, 0x017a, 0x02f4, 0x05e8, 0x0bd0, 0x17a0, 0x2f40, 0x1ac3, 0x3586, 0x2f4f, 0x1add, 0x35ba, 0x2f37,
        0x1a2d, 0x345a, 0x2cf7, 0x1dad, 0x3b5a, 0x32f7, 0x21ad, 0x0719, 0x0e32, 0x1c64, 0x38c8, 0x35d3, 0x2fe5, 0x1b89, 0x3712, 0x2a67,
        0x108d, 0x211a, 0x0677, 0x0cee, 0x19dc, 0x33b8, 0x2333, 0x0225, 0x044a, 0x0894, 0x1128, 0x2250, 0x00e3, 0x01c6, 0x038c, 0x0718,
        0x0e30, 0x1c60, 0x38c0, 0x35c3, 0x2fc5, 0x1bc9, 0x3792, 0x2b67, 0x128d, 0x251a, 0x0e77, 0x1cee, 0x39dc, 0x37fb, 0x2bb5, 0x1329,
        0x2652, 0x08e7, 0x11ce, 0x239c, 0x037b, 0x06f6, 0x0dec, 0x1bd8, 0x37b0, 0x2b23, 0x1205, 0x240a, 0x0c57, 0x18ae, 0x315c, 0x26fb,
        0x09b5, 0x136a, 0x26d4, 0x09eb, 0x13d6, 0x27ac, 0x0b1b, 0x1636, 0x2c6c, 0x1c9b, 0x3936, 0x362f, 0x281d, 0x1479, 0x28f2, 0x15a7,
        0x2b4e, 0x12df, 0x25be, 0x0f3f, 0x1e7e, 0x3cfc, 0x3dbb, 0x3f35, 0x3a29, 0x3011, 0x2461, 0x0c81, 0x1902, 0x3204, 0x204b, 0x04d5,
        0x09aa, 0x1354, 0x26a8, 0x0913, 0x1226, 0x244c, 0x0cdb, 0x19b6, 0x336c, 0x229b, 0x0175, 0x02ea, 0x05d4, 0x0ba8, 0x1750, 0x2ea0,
        0x1903, 0x3206, 0x204f, 0x04dd, 0x09ba, 0x1374, 0x26e8, 0x0993, 0x1326, 0x264c, 0x08db, 0x11b6, 0x236c, 0x029b, 0x0536, 0x0a6c,
        0x14d8, 0x29b0, 0x1723, 0x2e46, 0x18cf, 0x319e, 0x277f, 0x0abd, 0x157a, 0x2af4, 0x11ab, 0x2356, 0x02ef, 0x05de, 0x0bbc, 0x1778,
        0x2ef0, 0x19a3, 0x3346, 0x22cf, 0x01dd, 0x03ba, 0x0774, 0x0ee8, 0x1dd0, 0x3ba0, 0x3303, 0x2245, 0x00c9, 0x0192, 0x0324, 0x0648,
        0x0c90, 0x1920, 0x3240, 0x20c3, 0x05c5, 0x0b8a, 0x1714, 0x2e28, 0x1813, 0x3026, 0x240f, 0x0c5d, 0x18ba, 0x3174, 0x26ab, 0x0915,
        0x122a, 0x2454, 0x0ceb, 0x19d6, 0x33ac, 0x231b, 0x0275, 0x04ea, 0x09d4, 0x13a8, 0x2750, 0x0ae3, 0x15c6, 0x2b8c, 0x135b, 0x26b6,
        0x092f, 0x125e, 0x24bc, 0x0d3b, 0x1a76, 0x34ec, 0x2d9b, 0x1f75, 0x3eea, 0x3997, 0x376d, 0x2a99, 0x1171, 0x22e2, 0x0187, 0x030e,
        0x061c, 0x0c38, 0x1870, 0x30e0, 0x2583, 0x0f45, 0x1e8a, 0x3d14, 0x3e6b, 0x3895, 0x3569, 0x2e91, 0x1961, 0x32c2, 0x21c7, 0x07cd,
        0x0f9a, 0x1f34, 0x3e68, 0x3893, 0x3565, 0x2e89, 0x1951, 0x32a2, 0x2107, 0x064d, 0x0c9a, 0x1934, 0x3268, 0x2093, 0x0565, 0x0aca,
        0x1594, 0x2b28, 0x1213, 0x2426, 0x0c0f, 0x181e, 0x303c, 0x243b, 0x0c35, 0x186a, 0x30d4, 0x25eb, 0x0f95, 0x1f2a, 0x3e54, 0x38eb,
        0x3595, 0x2f69, 0x1a91, 0x3522, 0x2e07, 0x184d, 0x309a, 0x2577, 0x0ead, 0x1d5a, 0x3ab4, 0x312b, 0x2615, 0x0869, 0x10d2, 0x21a4,
        0x070b, 0x0e16, 0x1c2c, 0x3858, 0x34f3, 0x2da5, 0x1f09, 0x3e12, 0x3867, 0x348d, 0x2d59, 0x1ef1, 0x3de2, 0x3f87, 0x3b4d, 0x32d9,
        0x21f1, 0x07a1, 0x0f42, 0x1e84, 0x3d08, 0x3e53, 0x38e5, 0x3589, 0x2f51, 0x1ae1, 0x35c2, 0x2fc7, 0x1bcd, 0x379a, 0x2b77, 0x12ad,
        0x255a, 0x0ef7, 0x1dee, 0x3bdc, 0x33fb, 0x23b5, 0x0329, 0x0652, 0x0ca4, 0x1948, 0x3290, 0x2163, 0x0685, 0x0d0a, 0x1a14, 0x3428,
        0x2c13, 0x1c65, 0x38ca, 0x35d7, 0x2fed, 0x1b99, 0x3732, 0x2a27, 0x100d, 0x201a, 0x0477, 0x08ee, 0x11dc, 0x23b8, 0x0333, 0x0666,
        0x0ccc, 0x1998, 0x3330, 0x2223, 0x0005, 0x000a, 0x0014, 0x0028, 0x0050, 0x00a0, 0x0140, 0x0280, 0x0500, 0x0a00, 0x1400, 0x2800,
        0x1443, 0x2886, 0x154f, 0x2a9e, 0x117f, 0x22fe, 0x01bf, 0x037e, 0x06fc, 0x0df8, 0x1bf0, 0x37e0, 0x2b83, 0x1345, 0x268a, 0x0957,
        0x12ae, 0x255c, 0x0efb, 0x1df6, 0x3bec, 0x339b, 0x2375, 0x02a9, 0x0552, 0x0aa4, 0x1548, 0x2a90, 0x1163, 0x22c6, 0x01cf, 0x039e,
        0x073c, 0x0e78, 0x1cf0, 0x39e0, 0x3783, 0x2b45, 0x12c9, 0x2592, 0x0f67, 0x1ece, 0x3d9c, 0x3f7b, 0x3ab5, 0x3129, 0x2611, 0x0861,
        0x10c2, 0x2184, 0x074b, 0x0e96, 0x1d2c, 0x3a58, 0x30f3, 0x25a5, 0x0f09, 0x1e12, 0x3c24, 0x3c0b, 0x3c55, 0x3ce9, 0x3d91, 0x3f61,
        0x3a81, 0x3141, 0x26c1, 0x09c1, 0x1382, 0x2704, 0x0a4b, 0x1496, 0x292c, 0x161b, 0x2c36, 0x1c2f, 0x385e, 0x34ff, 0x2dbd, 0x1f39,
        0x3e72, 0x38a7, 0x350d, 0x2e59, 0x18f1, 0x31e2, 0x2787, 0x0b4d, 0x169a, 0x2d34, 0x1e2b, 0x3c56, 0x3cef, 0x3d9d, 0x3f79, 0x3ab1,
        0x3121, 0x2601, 0x0841, 0x1082, 0x2104, 0x064b, 0x0c96, 0x192c, 0x3258, 0x20f3, 0x05a5, 0x0b4a, 0x1694, 0x2d28, 0x1e13, 0x3c26,
        0x3c0f, 0x3c5d, 0x3cf9, 0x3db1, 0x3f21, 0x3a01, 0x3041, 0x24c1, 0x0dc1, 0x1b82, 0x3704, 0x2a4b, 0x10d5, 0x21aa, 0x0717, 0x0e2e,
        0x1c5c, 0x38b8, 0x3533, 0x2e25, 0x1809, 0x3012, 0x2467, 0x0c8d, 0x191a, 0x3234, 0x202b, 0x0415, 0x082a, 0x1054, 0x20a8, 0x0513,
        0x0a26, 0x144c, 0x2898, 0x1573, 0x2ae6, 0x118f, 0x231e, 0x027f, 0x04fe, 0x09fc, 0x13f8, 0x27f0, 0x0ba3, 0x1746, 0x2e8c, 0x195b,
        0x32b6, 0x212f, 0x061d, 0x0c3a, 0x1874, 0x30e8, 0x2593, 0x0f65, 0x1eca, 0x3d94, 0x3f6b, 0x3a95, 0x3169, 0x2691, 0x0961, 0x12c2,
        0x2584, 0x0f4b, 0x1e96, 0x3d2c, 0x3e1b, 0x3875, 0x34a9, 0x2d11, 0x1e61, 0x3cc2, 0x3dc7, 0x3fcd, 0x3bd9, 0x33f1, 0x23a1, 0x0301,
        0x0602, 0x0c04, 0x1808, 0x3010, 0x2463, 0x0c85, 0x190a, 0x3214, 0x206b, 0x0495, 0x092a, 0x1254, 0x24a8, 0x0d13, 0x1a26, 0x344c,
        0x2cdb, 0x1df5, 0x3bea, 0x3397, 0x236d, 0x0299, 0x0532, 0x0a64, 0x14c8, 0x2990, 0x1763, 0x2ec6, 0x19cf, 0x339e, 0x237f, 0x02bd,
        0x057a, 0x0af4, 0x15e8, 0x2bd0, 0x13e3, 0x27c6, 0x0bcf, 0x179e, 0x2f3c, 0x1a3b, 0x3476, 0x2caf, 0x1d1d, 0x3a3a, 0x3037, 0x242d,
        0x0c19, 0x1832, 0x3064, 0x248b, 0x0d55, 0x1aaa, 0x3554, 0x2eeb, 0x1995, 0x332a, 0x2217, 0x006d, 0x00da, 0x01b4, 0x0368, 0x06d0,
        0x0da0, 0x1b40, 0x3680, 0x2943, 0x16c5, 0x2d8a, 0x1f57, 0x3eae, 0x391f, 0x367d, 0x28b9, 0x1531, 0x2a62, 0x1087, 0x210e, 0x065f,
        0x0cbe, 0x197c, 0x32f8, 0x21b3, 0x0725, 0x0e4a, 0x1c94, 0x3928, 0x3613, 0x2865, 0x1489, 0x2912, 0x1667, 0x2cce, 0x1ddf, 0x3bbe,
        0x333f, 0x223d, 0x0039, 0x0072, 0x00e4, 0x01c8, 0x0390, 0x0720, 0x0e40, 0x1c80, 0x3900, 0x3643, 0x28c5, 0x15c9, 0x2b92, 0x1367,
        0x26ce, 0x09df, 0x13be, 0x277c, 0x0abb, 0x1576, 0x2aec, 0x119b, 0x2336, 0x022f, 0x045e, 0x08bc, 0x1178, 0x22f0, 0x01a3, 0x0346,
        0x068c, 0x0d18, 0x1a30, 0x3460, 0x2c83, 0x1d45, 0x3a8a, 0x3157, 0x26ed, 0x0999, 0x1332, 0x2664, 0x088b, 0x1116, 0x222c, 0x001b,
        0x0036, 0x006c, 0x00d8, 0x01b0, 0x0360, 0x06c0, 0x0d80, 0x1b00, 0x3600, 0x2843, 0x14c5, 0x298a, 0x1757, 0x2eae, 0x191f, 0x323e,
        0x203f, 0x043d, 0x087a, 0x10f4, 0x21e8, 0x0793, 0x0f26, 0x1e4c, 0x3c98, 0x3d73, 0x3ea5, 0x3909, 0x3651, 0x28e1, 0x1581, 0x2b02,
        0x1247, 0x248e, 0x0d5f, 0x1abe, 0x357c, 0x2ebb, 0x1935, 0x326a, 0x2097, 0x056d, 0x0ada, 0x15b4, 0x2b68, 0x1293, 0x2526, 0x0e0f,
        0x1c1e, 0x383c, 0x343b, 0x2c35, 0x1c29, 0x3852, 0x34e7, 0x2d8d, 0x1f59, 0x3eb2, 0x3927, 0x360d, 0x2859, 0x14f1, 0x29e2, 0x1787,
        0x2f0e, 0x1a5f, 0x34be, 0x2d3f, 0x1e3d, 0x3c7a, 0x3cb7, 0x3d2d, 0x3e19, 0x3871, 0x34a1, 0x2d01, 0x1e41, 0x3c82, 0x3d47, 0x3ecd,
        0x39d9, 0x37f1, 0x2ba1, 0x1301, 0x2602, 0x0847, 0x108e, 0x211c, 0x067b, 0x0cf6, 0x19ec, 0x33d8, 0x23f3, 0x03a5, 0x074a, 0x0e94,
        0x1d28, 0x3a50, 0x30e3, 0x2585, 0x0f49, 0x1e92, 0x3d24, 0x3e0b, 0x3855, 0x34e9, 0x2d91, 0x1f61, 0x3ec2, 0x39c7, 0x37cd, 0x2bd9,
        0x13f1, 0x27e2, 0x0b87, 0x170e, 0x2e1c, 0x187b, 0x30f6, 0x25af, 0x0f1d, 0x1e3a, 0x3c74, 0x3cab, 0x3d15, 0x3e69, 0x3891, 0x3561,
        0x2e81, 0x1941, 0x3282, 0x2147, 0x06cd, 0x0d9a, 0x1b34, 0x3668, 0x2893, 0x1565, 0x2aca, 0x11d7, 0x23ae, 0x031f, 0x063e, 0x0c7c,
        0x18f8, 0x31f0, 0x27a3, 0x0b05, 0x160a, 0x2c14, 0x1c6b, 0x38d6, 0x35ef, 0x2f9d, 0x1b79, 0x36f2, 0x29a7, 0x170d, 0x2e1a, 0x1877,
        0x30ee, 0x259f, 0x0f7d, 0x1efa, 0x3df4, 0x3fab, 0x3b15, 0x3269, 0x2091, 0x0561, 0x0ac2, 0x1584, 0x2b08, 0x1253, 0x24a6, 0x0d0f,
        0x1a1e, 0x343c, 0x2c3b, 0x1c35, 0x386a, 0x3497, 0x2d6d, 0x1e99, 0x3d32, 0x3e27, 0x380d, 0x3459, 0x2cf1, 0x1da1, 0x3b42, 0x32c7,
        0x21cd, 0x07d9, 0x0fb2, 0x1f64, 0x3ec8, 0x39d3, 0x37e5, 0x2b89, 0x1351, 0x26a2, 0x0907, 0x120e, 0x241c, 0x0c7b, 0x18f6, 0x31ec,
        0x279b, 0x0b75, 0x16ea, 0x2dd4, 0x1feb, 0x3fd6, 0x3bef, 0x339d, 0x2379, 0x02b1, 0x0562, 0x0ac4, 0x1588, 0x2b10, 0x1263, 0x24c6,
        0x0dcf, 0x1b9e, 0x373c, 0x2a3b, 0x1035, 0x206a, 0x0497, 0x092e, 0x125c, 0x24b8, 0x0d33, 0x1a66, 0x34cc, 0x2ddb, 0x1ff5, 0x3fea,
        0x3b97, 0x336d, 0x2299, 0x0171, 0x02e2, 0x05c4, 0x0b88, 0x1710, 0x2e20, 0x1803, 0x3006, 0x244f, 0x0cdd, 0x19ba, 0x3374, 0x22ab,
        0x0115, 0x022a, 0x0454, 0x08a8, 0x1150, 0x22a0, 0x0103, 0x0206, 0x040c, 0x0818, 0x1030, 0x2060, 0x0483, 0x0906, 0x120c, 0x2418,
        0x0c73, 0x18e6, 0x31cc, 0x27db, 0x0bf5, 0x17ea, 0x2fd4, 0x1beb, 0x37d6, 0x2bef, 0x139d, 0x273a, 0x0a37, 0x146e, 0x28dc, 0x15fb,
        0x2bf6, 0x13af, 0x275e, 0x0aff, 0x15fe, 0x2bfc, 0x13bb, 0x2776, 0x0aaf, 0x155e, 0x2abc, 0x113b, 0x2276, 0x00af, 0x015e, 0x02bc,
        0x0578, 0x0af0, 0x15e0, 0x2bc0, 0x13c3, 0x2786, 0x0b4f, 0x169e, 0x2d3c, 0x1e3b, 0x3c76, 0x3caf, 0x3d1d, 0x3e79, 0x38b1, 0x3521,
        0x2e01, 0x1841, 0x3082, 0x2547, 0x0ecd, 0x1d9a, 0x3b34, 0x322b, 0x2015, 0x0469, 0x08d2, 0x11a4, 0x2348, 0x02d3, 0x05a6, 0x0b4c,
        0x1698, 0x2d30, 0x1e23, 0x3c46, 0x3ccf, 0x3ddd, 0x3ff9, 0x3bb1, 0x3321, 0x2201, 0x0041, 0x0082, 0x0104, 0x0208, 0x0410, 0x0820,
        0x1040, 0x2080, 0x0543, 0x0a86, 0x150c, 0x2a18, 0x1073, 0x20e6, 0x058f, 0x0b1e, 0x163c, 0x2c78, 0x1cb3, 0x3966, 0x368f, 0x295d,
        0x16f9, 0x2df2, 0x1fa7, 0x3f4e, 0x3adf, 0x31fd, 0x27b9, 0x0b31, 0x1662, 0x2cc4, 0x1dcb, 0x3b96, 0x336f, 0x229d, 0x0179, 0x02f2,
        0x05e4, 0x0bc8, 0x1790, 0x2f20, 0x1a03, 0x3406, 0x2c4f, 0x1cdd, 0x39ba, 0x3737, 0x2a2d, 0x1019, 0x2032, 0x0427, 0x084e, 0x109c,
        0x2138, 0x0633, 0x0c66, 0x18cc, 0x3198, 0x2773, 0x0aa5, 0x154a, 0x2a94, 0x116b, 0x22d6, 0x01ef, 0x03de, 0x07bc, 0x0f78, 0x1ef0,
        0x3de0, 0x3f83, 0x3b45, 0x32c9, 0x21d1, 0x07e1, 0x0fc2, 0x1f84, 0x3f08, 0x3a53, 0x30e5, 0x2589, 0x0f51, 0x1ea2, 0x3d44, 0x3ecb,
        0x39d5, 0x37e9, 0x2b91, 0x1361, 0x26c2, 0x09c7, 0x138e, 0x271c, 0x0a7b, 0x14f6, 0x29ec, 0x179b, 0x2f36, 0x1a2f, 0x345e, 0x2cff,
        0x1dbd, 0x3b7a, 0x32b7, 0x212d, 0x0619, 0x0c32, 0x1864, 0x30c8, 0x25d3, 0x0fe5, 0x1fca, 0x3f94, 0x3b6b, 0x3295, 0x2169, 0x0691,
        0x0d22, 0x1a44, 0x3488, 0x2d53, 0x1ee5, 0x3dca, 0x3fd7, 0x3bed, 0x3399, 0x2371, 0x02a1, 0x0542, 0x0a84, 0x1508, 0x2a10, 0x1063,
        0x20c6, 0x05cf, 0x0b9e, 0x173c, 0x2e78, 0x18b3, 0x3166, 0x268f, 0x095d, 0x12ba, 0x2574, 0x0eab, 0x1d56, 0x3aac, 0x311b, 0x2675,
        0x08a9, 0x1152, 0x22a4, 0x010b, 0x0216, 0x042c, 0x0858, 0x10b0, 0x2160, 0x0683, 0x0d06, 0x1a0c, 0x3418, 0x2c73, 0x1ca5, 0x394a,
        0x36d7, 0x29ed, 0x1799, 0x2f32, 0x1a27, 0x344e, 0x2cdf, 0x1dfd, 0x3bfa, 0x33b7, 0x232d, 0x0219, 0x0432, 0x0864, 0x10c8, 0x2190,
        0x0763, 0x0ec6, 0x1d8c, 0x3b18, 0x3273, 0x20a5, 0x0509, 0x0a12, 0x1424, 0x2848, 0x14d3, 0x29a6, 0x170f, 0x2e1e, 0x187f, 0x30fe,
        0x25bf, 0x0f3d, 0x1e7a, 0x3cf4, 0x3dab, 0x3f15, 0x3a69, 0x3091, 0x2561, 0x0e81, 0x1d02, 0x3a04, 0x304b, 0x24d5, 0x0de9, 0x1bd2,
        0x37a4, 0x2b0b, 0x1255, 0x24aa, 0x0d17, 0x1a2e, 0x345c, 0x2cfb, 0x1db5, 0x3b6a, 0x3297, 0x216d, 0x0699, 0x0d32, 0x1a64, 0x34c8,
        0x2dd3, 0x1fe5, 0x3fca, 0x3bd7, 0x33ed, 0x2399, 0x0371, 0x06e2, 0x0dc4, 0x1b88, 0x3710, 0x2a63, 0x1085, 0x210a, 0x0657, 0x0cae,
        0x195c, 0x32b8, 0x2133, 0x0625, 0x0c4a, 0x1894, 0x3128, 0x2613, 0x0865, 0x10ca, 0x2194, 0x076b, 0x0ed6, 0x1dac, 0x3b58, 0x32f3,
        0x21a5, 0x0709, 0x0e12, 0x1c24, 0x3848, 0x34d3, 0x2de5, 0x1f89, 0x3f12, 0x3a67, 0x308d, 0x2559, 0x0ef1, 0x1de2, 0x3bc4, 0x33cb,
        0x23d5, 0x03e9, 0x07d2, 0x0fa4, 0x1f48, 0x3e90, 0x3963, 0x3685, 0x2949, 0x16d1, 0x2da2, 0x1f07, 0x3e0e, 0x385f, 0x34fd, 0x2db9,
        0x1f31, 0x3e62, 0x3887, 0x354d, 0x2ed9, 0x19f1, 0x33e2, 0x2387, 0x034d, 0x069a, 0x0d34, 0x1a68, 0x34d0, 0x2de3, 0x1f85, 0x3f0a,
        0x3a57, 0x30ed, 0x2599, 0x0f71, 0x1ee2, 0x3dc4, 0x3fcb, 0x3bd5, 0x33e9, 0x2391, 0x0361, 0x06c2, 0x0d84, 0x1b08, 0x3610, 0x2863,
        0x1485, 0x290a, 0x1657, 0x2cae, 0x1d1f, 0x3a3e, 0x303f, 0x243d, 0x0c39, 0x1872, 0x30e4, 0x258b, 0x0f55, 0x1eaa, 0x3d54, 0x3eeb,
        0x3995, 0x3769, 0x2a91, 0x1161, 0x22c2, 0x01c7, 0x038e, 0x071c, 0x0e38, 0x1c70, 0x38e0, 0x3583, 0x2f45, 0x1ac9, 0x3592, 0x2f67,
        0x1a8d, 0x351a, 0x2e77, 0x18ad, 0x315a, 0x26f7, 0x09ad, 0x135a, 0x26b4, 0x092b, 0x1256, 0x24ac, 0x0d1b, 0x1a36, 0x346c, 0x2c9b,
        0x1d75, 0x3aea, 0x3197, 0x276d, 0x0a99, 0x1532, 0x2a64, 0x108b, 0x2116, 0x066f, 0x0cde, 0x19bc, 0x3378, 0x22b3, 0x0125, 0x024a,
        0x0494, 0x0928, 0x1250, 0x24a0, 0x0d03, 0x1a06, 0x340c, 0x2c5b, 0x1cf5, 0x39ea, 0x3797, 0x2b6d, 0x1299, 0x2532, 0x0e27, 0x1c4e,
        0x389c, 0x357b, 0x2eb5, 0x1929, 0x3252, 0x20e7, 0x058d, 0x0b1a, 0x1634, 0x2c68, 0x1c93, 0x3926, 0x360f, 0x285d, 0x14f9, 0x29f2,
        0x17a7, 0x2f4e, 0x1adf, 0x35be, 0x2f3f, 0x1a3d, 0x347a, 0x2cb7, 0x1d2d, 0x3a5a, 0x30f7, 0x25ad, 0x0f19, 0x1e32, 0x3c64, 0x3c8b,
        0x3d55, 0x3ee9, 0x3991, 0x3761, 0x2a81, 0x1141, 0x2282, 0x0147, 0x028e, 0x051c, 0x0a38, 0x1470, 0x28e0, 0x1583, 0x2b06, 0x124f,
        0x249e, 0x0d7f, 0x1afe, 0x35fc, 0x2fbb, 0x1b35, 0x366a, 0x2897, 0x156d, 0x2ada, 0x11f7, 0x23ee, 0x039f, 0x073e, 0x0e7c, 0x1cf8,
        0x39f0, 0x37a3, 0x2b05, 0x1249, 0x2492, 0x0d67, 0x1ace, 0x359c, 0x2f7b, 0x1ab5, 0x356a, 0x2e97, 0x196d, 0x32da, 0x21f7, 0x07ad,
        0x0f5a, 0x1eb4, 0x3d68, 0x3e93, 0x3965, 0x3689, 0x2951, 0x16e1, 0x2dc2, 0x1fc7, 0x3f8e, 0x3b5f, 0x32fd, 0x21b9, 0x0731, 0x0e62,
        0x1cc4, 0x3988, 0x3753, 0x2ae5, 0x1189, 0x2312, 0x0267, 0x04ce, 0x099c, 0x1338, 0x2670, 0x08a3, 0x1146, 0x228c, 0x015b, 0x02b6,
        0x056c, 0x0ad8, 0x15b0, 0x2b60, 0x1283, 0x2506, 0x0e4f, 0x1c9e, 0x393c, 0x363b, 0x2835, 0x1429, 0x2852, 0x14e7, 0x29ce, 0x17df,
        0x2fbe, 0x1b3f, 0x367e, 0x28bf, 0x153d, 0x2a7a, 0x10b7, 0x216e, 0x069f, 0x0d3e, 0x1a7c, 0x34f8, 0x2db3, 0x1f25, 0x3e4a, 0x38d7,
        0x35ed, 0x2f99, 0x1b71, 0x36e2, 0x2987, 0x174d, 0x2e9a, 0x1977, 0x32ee, 0x219f, 0x077d, 0x0efa, 0x1df4, 0x3be8, 0x3393, 0x2365,
        0x0289, 0x0512, 0x0a24, 0x1448, 0x2890, 0x1563, 0x2ac6, 0x11cf, 0x239e, 0x037f, 0x06fe, 0x0dfc, 0x1bf8, 0x37f0, 0x2ba3, 0x1305,
        0x260a, 0x0857, 0x10ae, 0x215c, 0x06fb, 0x0df6, 0x1bec, 0x37d8, 0x2bf3, 0x13a5, 0x274a, 0x0ad7, 0x15ae, 0x2b5c, 0x12fb, 0x25f6,
        0x0faf, 0x1f5e, 0x3ebc, 0x393b, 0x3635, 0x2829, 0x1411, 0x2822, 0x1407, 0x280e, 0x145f, 0x28be, 0x153f, 0x2a7e, 0x10bf, 0x217e,
        0x06bf, 0x0d7e, 0x1afc, 0x35f8, 0x2fb3, 0x1b25, 0x364a, 0x28d7, 0x15ed, 0x2bda, 0x13f7, 0x27ee, 0x0b9f, 0x173e, 0x2e7c, 0x18bb,
        0x3176, 0x26af, 0x091d, 0x123a, 0x2474, 0x0cab, 0x1956, 0x32ac, 0x211b, 0x0675, 0x0cea, 0x19d4, 0x33a8, 0x2313, 0x0265, 0x04ca,
        0x0994, 0x1328, 0x2650, 0x08e3, 0x11c6, 0x238c, 0x035b, 0x06b6, 0x0d6c, 0x1ad8, 0x35b0, 0x2f23, 0x1a05, 0x340a, 0x2c57, 0x1ced,
        0x39da, 0x37f7, 0x2bad, 0x1319, 0x2632, 0x0827, 0x104e, 0x209c, 0x057b, 0x0af6, 0x15ec, 0x2bd8, 0x13f3, 0x27e6, 0x0b8f, 0x171e,
        0x2e3c, 0x183b, 0x3076, 0x24af, 0x0d1d, 0x1a3a, 0x3474, 0x2cab, 0x1d15, 0x3a2a, 0x3017, 0x246d, 0x0c99, 0x1932, 0x3264, 0x208b,
        0x0555, 0x0aaa, 0x1554, 0x2aa8, 0x1113, 0x2226, 0x000f, 0x001e, 0x003c, 0x0078, 0x00f0, 0x01e0, 0x03c0, 0x0780, 0x0f00, 0x1e00,
        0x3c00, 0x3c43, 0x3cc5, 0x3dc9, 0x3fd1, 0x3be1, 0x3381, 0x2341, 0x02c1, 0x0582, 0x0b04, 0x1608, 0x2c10, 0x1c63, 0x38c6, 0x35cf,
        0x2fdd, 0x1bf9, 0x37f2, 0x2ba7, 0x130d, 0x261a, 0x0877, 0x10ee, 0x21dc, 0x07fb, 0x0ff6, 0x1fec, 0x3fd8, 0x3bf3, 0x33a5, 0x2309,
        0x0251, 0x04a2, 0x0944, 0x1288, 0x2510, 0x0e63, 0x1cc6, 0x398c, 0x375b, 0x2af5, 0x11a9, 0x2352, 0x02e7, 0x05ce, 0x0b9c, 0x1738,
        0x2e70, 0x18a3, 0x3146, 0x26cf, 0x09dd, 0x13ba, 0x2774, 0x0aab, 0x1556, 0x2aac, 0x111b, 0x2236, 0x002f, 0x005e, 0x00bc, 0x0178,
        0x02f0, 0x05e0, 0x0bc0, 0x1780, 0x2f00, 0x1a43, 0x3486, 0x2d4f, 0x1edd, 0x3dba, 0x3f37, 0x3a2d, 0x3019, 0x2471, 0x0ca1, 0x1942,
        0x3284, 0x214b, 0x06d5, 0x0daa, 0x1b54, 0x36a8, 0x2913, 0x1665, 0x2cca, 0x1dd7, 0x3bae, 0x331f, 0x227d, 0x00b9, 0x0172, 0x02e4,
        0x05c8, 0x0b90, 0x1720, 0x2e40, 0x18c3, 0x3186, 0x274f, 0x0add, 0x15ba, 0x2b74, 0x12ab, 0x2556, 0x0eef, 0x1dde, 0x3bbc, 0x333b,
        0x2235, 0x0029, 0x0052, 0x00a4, 0x0148, 0x0290, 0x0520, 0x0a40, 0x1480, 0x2900, 0x1643, 0x2c86, 0x1d4f, 0x3a9e, 0x317f, 0x26bd,
        0x0939, 0x1272, 0x24e4, 0x0d8b, 0x1b16, 0x362c, 0x281b, 0x1475, 0x28ea, 0x1597, 0x2b2e, 0x121f, 0x243e, 0x0c3f, 0x187e, 0x30fc,
        0x25bb, 0x0f35, 0x1e6a, 0x3cd4, 0x3deb, 0x3f95, 0x3b69, 0x3291, 0x2161, 0x0681, 0x0d02, 0x1a04, 0x3408, 0x2c53, 0x1ce5, 0x39ca,
        0x37d7, 0x2bed, 0x1399, 0x2732, 0x0a27, 0x144e, 0x289c, 0x157b, 0x2af6, 0x11af, 0x235e, 0x02ff, 0x05fe, 0x0bfc, 0x17f8, 0x2ff0,
        0x1ba3, 0x3746, 0x2acf, 0x11dd, 0x23ba, 0x0337, 0x066e, 0x0cdc, 0x19b8, 0x3370, 0x22a3, 0x0105, 0x020a, 0x0414, 0x0828, 0x1050,
        0x20a0, 0x0503, 0x0a06, 0x140c, 0x2818, 0x1473, 0x28e6, 0x158f, 0x2b1e, 0x127f, 0x24fe, 0x0dbf, 0x1b7e, 0x36fc, 0x29bb, 0x1735,
        0x2e6a, 0x1897, 0x312e, 0x261f, 0x087d, 0x10fa, 0x21f4, 0x07ab, 0x0f56, 0x1eac, 0x3d58, 0x3ef3, 0x39a5, 0x3709, 0x2a51, 0x10e1,
        0x21c2, 0x07c7, 0x0f8e, 0x1f1c, 0x3e38, 0x3833, 0x3425, 0x2c09, 0x1c51, 0x38a2, 0x3507, 0x2e4d, 0x18d9, 0x31b2, 0x2727, 0x0a0d,
        0x141a, 0x2834, 0x142b, 0x2856, 0x14ef, 0x29de, 0x17ff, 0x2ffe, 0x1bbf, 0x377e, 0x2abf, 0x113d, 0x227a, 0x00b7, 0x016e, 0x02dc,
        0x05b8, 0x0b70, 0x16e0, 0x2dc0, 0x1fc3, 0x3f86, 0x3b4f, 0x32dd, 0x21f9, 0x07b1, 0x0f62, 0x1ec4, 0x3d88, 0x3f53, 0x3ae5, 0x3189,
        0x2751, 0x0ae1, 0x15c2, 0x2b84, 0x134b, 0x2696, 0x096f, 0x12de, 0x25bc, 0x0f3b, 0x1e76, 0x3cec, 0x3d9b, 0x3f75, 0x3aa9, 0x3111,
        0x2661, 0x0881, 0x1102, 0x2204, 0x004b, 0x0096, 0x012c, 0x0258, 0x04b0, 0x0960, 0x12c0, 0x2580, 0x0f43, 0x1e86, 0x3d0c, 0x3e5b,
        0x38f5, 0x35a9, 0x2f11, 0x1a61, 0x34c2, 0x2dc7, 0x1fcd, 0x3f9a, 0x3b77, 0x32ad, 0x2119, 0x0671, 0x0ce2, 0x19c4, 0x3388, 0x2353,
        0x02e5, 0x05ca, 0x0b94, 0x1728, 0x2e50, 0x18e3, 0x31c6, 0x27cf, 0x0bdd, 0x17ba, 0x2f74, 0x1aab, 0x3556, 0x2eef, 0x199d, 0x333a,
        0x2237, 0x002d, 0x005a, 0x00b4, 0x0168, 0x02d0, 0x05a0, 0x0b40, 0x1680, 0x2d00, 0x1e43, 0x3c86, 0x3d4f, 0x3edd, 0x39f9, 0x37b1,
        0x2b21, 0x1201, 0x2402, 0x0c47, 0x188e, 0x311c, 0x267b, 0x08b5, 0x116a, 0x22d4, 0x01eb, 0x03d6, 0x07ac, 0x0f58, 0x1eb0, 0x3d60,
        0x3e83, 0x3945, 0x36c9, 0x29d1, 0x17e1, 0x2fc2, 0x1bc7, 0x378e, 0x2b5f, 0x12fd, 0x25fa, 0x0fb7, 0x1f6e, 0x3edc, 0x39fb, 0x37b5,
        0x2b29, 0x1211, 0x2422, 0x0c07, 0x180e, 0x301c, 0x247b, 0x0cb5, 0x196a, 0x32d4, 0x21eb, 0x0795, 0x0f2a, 0x1e54, 0x3ca8, 0x3d13,
        0x3e65, 0x3889, 0x3551, 0x2ee1, 0x1981, 0x3302, 0x2247, 0x00cd, 0x019a, 0x0334, 0x0668, 0x0cd0, 0x19a0, 0x3340, 0x22c3, 0x01c5,
        0x038a, 0x0714, 0x0e28, 0x1c50, 0x38a0, 0x3503, 0x2e45, 0x18c9, 0x3192, 0x2767, 0x0a8d, 0x151a, 0x2a34, 0x102b, 0x2056, 0x04ef,
        0x09de, 0x13bc, 0x2778, 0x0ab3, 0x1566, 0x2acc, 0x11db, 0x23b6, 0x032f, 0x065e, 0x0cbc, 0x1978, 0x32f0, 0x21a3, 0x0705, 0x0e0a,
        0x1c14, 0x3828, 0x3413, 0x2c65, 0x1c89, 0x3912, 0x3667, 0x288d, 0x1559, 0x2ab2, 0x1127, 0x224e, 0x00df, 0x01be, 0x037c, 0x06f8,
        0x0df0, 0x1be0, 0x37c0, 0x2bc3, 0x13c5, 0x278a, 0x0b57, 0x16ae, 0x2d5c, 0x1efb, 0x3df6, 0x3faf, 0x3b1d, 0x3279, 0x20b1, 0x0521,
        0x0a42, 0x1484, 0x2908, 0x1653, 0x2ca6, 0x1d0f, 0x3a1e, 0x307f, 0x24bd, 0x0d39, 0x1a72, 0x34e4, 0x2d8b, 0x1f55, 0x3eaa, 0x3917,
        0x366d, 0x2899, 0x1571, 0x2ae2, 0x1187, 0x230e, 0x025f, 0x04be, 0x097c, 0x12f8, 0x25f0, 0x0fa3, 0x1f46, 0x3e8c, 0x395b, 0x36f5,
        0x29a9, 0x1711, 0x2e22, 0x1807, 0x300e, 0x245f, 0x0cfd, 0x19fa, 0x33f4, 0x23ab, 0x0315, 0x062a, 0x0c54, 0x18a8, 0x3150, 0x26e3,
        0x0985, 0x130a, 0x2614, 0x086b, 0x10d6, 0x21ac, 0x071b, 0x0e36, 0x1c6c, 0x38d8, 0x35f3, 0x2fa5, 0x1b09, 0x3612, 0x2867, 0x148d,
        0x291a, 0x1677, 0x2cee, 0x1d9f, 0x3b3e, 0x323f, 0x203d, 0x0439, 0x0872, 0x10e4, 0x21c8, 0x07d3, 0x0fa6, 0x1f4c, 0x3e98, 0x3973,
        0x36a5, 0x2909, 0x1651, 0x2ca2, 0x1d07, 0x3a0e, 0x305f, 0x24fd, 0x0db9, 0x1b72, 0x36e4, 0x298b, 0x1755, 0x2eaa, 0x1917, 0x322e,
        0x201f, 0x047d, 0x08fa, 0x11f4, 0x23e8, 0x0393, 0x0726, 0x0e4c, 0x1c98, 0x3930, 0x3623, 0x2805, 0x1449, 0x2892, 0x1567, 0x2ace,
        0x11df, 0x23be, 0x033f, 0x067e, 0x0cfc, 0x19f8, 0x33f0, 0x23a3, 0x0305, 0x060a, 0x0c14, 0x1828, 0x3050, 0x24e3, 0x0d85, 0x1b0a,
        0x3614, 0x286b, 0x1495, 0x292a, 0x1617, 0x2c2e, 0x1c1f, 0x383e, 0x343f, 0x2c3d, 0x1c39, 0x3872, 0x34a7, 0x2d0d, 0x1e59, 0x3cb2,
        0x3d27, 0x3e0d, 0x3859, 0x34f1, 0x2da1, 0x1f01, 0x3e02, 0x3847, 0x34cd, 0x2dd9, 0x1ff1, 0x3fe2, 0x3b87, 0x334d, 0x22d9, 0x01f1,
        0x03e2, 0x07c4, 0x0f88, 0x1f10, 0x3e20, 0x3803, 0x3445, 0x2cc9, 0x1dd1, 0x3ba2, 0x3307, 0x224d, 0x00d9, 0x01b2, 0x0364, 0x06c8,
        0x0d90, 0x1b20, 0x3640, 0x28c3, 0x15c5, 0x2b8a, 0x1357, 0x26ae, 0x091f, 0x123e, 0x247c, 0x0cbb, 0x1976, 0x32ec, 0x219b, 0x0775,
        0x0eea, 0x1dd4, 0x3ba8, 0x3313, 0x2265, 0x0089, 0x0112, 0x0224, 0x0448, 0x0890, 0x1120, 0x2240, 0x00c3, 0x0186, 0x030c, 0x0618,
        0x0c30, 0x1860, 0x30c0, 0x25c3, 0x0fc5, 0x1f8a, 0x3f14, 0x3a6b, 0x3095, 0x2569, 0x0e91, 0x1d22, 0x3a44, 0x30cb, 0x25d5, 0x0fe9,
        0x1fd2, 0x3fa4, 0x3b0b, 0x3255, 0x20e9, 0x0591, 0x0b22, 0x1644, 0x2c88, 0x1d53, 0x3aa6, 0x310f, 0x265d, 0x08f9, 0x11f2, 0x23e4,
        0x038b, 0x0716, 0x0e2c, 0x1c58, 0x38b0, 0x3523, 0x2e05, 0x1849, 0x3092, 0x2567, 0x0e8d, 0x1d1a, 0x3a34, 0x302b, 0x2415, 0x0c69,
        0x18d2, 0x31a4, 0x270b, 0x0a55, 0x14aa, 0x2954, 0x16eb, 0x2dd6, 0x1fef, 0x3fde, 0x3bff, 0x33bd, 0x2339, 0x0231, 0x0462, 0x08c4,
        0x1188, 0x2310, 0x0263, 0x04c6, 0x098c, 0x1318, 0x2630, 0x0823, 0x1046, 0x208c, 0x055b, 0x0ab6, 0x156c, 0x2ad8, 0x11f3, 0x23e6,
        0x038f, 0x071e, 0x0e3c, 0x1c78, 0x38f0, 0x35a3, 0x2f05, 0x1a49, 0x3492, 0x2d67, 0x1e8d, 0x3d1a, 0x3e77, 0x38ad, 0x3519, 0x2e71,
        0x18a1, 0x3142, 0x26c7, 0x09cd, 0x139a, 0x2734, 0x0a2b, 0x1456, 0x28ac, 0x151b, 0x2a36, 0x102f, 0x205e, 0x04ff, 0x09fe, 0x13fc,
        0x27f8, 0x0bb3, 0x1766, 0x2ecc, 0x19db, 0x33b6, 0x232f, 0x021d, 0x043a, 0x0874, 0x10e8, 0x21d0, 0x07e3, 0x0fc6, 0x1f8c, 0x3f18,
        0x3a73, 0x30a5, 0x2509, 0x0e51, 0x1ca2, 0x3944, 0x36cb, 0x29d5, 0x17e9, 0x2fd2, 0x1be7, 0x37ce, 0x2bdf, 0x13fd, 0x27fa, 0x0bb7,
        0x176e, 0x2edc, 0x19fb, 0x33f6, 0x23af, 0x031d, 0x063a, 0x0c74, 0x18e8, 0x31d0, 0x27e3, 0x0b85, 0x170a, 0x2e14, 0x186b, 0x30d6,
        0x25ef, 0x0f9d, 0x1f3a, 0x3e74, 0x38ab, 0x3515, 0x2e69, 0x1891, 0x3122, 0x2607, 0x084d, 0x109a, 0x2134, 0x062b, 0x0c56, 0x18ac,
        0x3158, 0x26f3, 0x09a5, 0x134a, 0x2694, 0x096b, 0x12d6, 0x25ac, 0x0f1b, 0x1e36, 0x3c6c, 0x3c9b, 0x3d75, 0x3ea9, 0x3911, 0x3661,
        0x2881, 0x1541, 0x2a82, 0x1147, 0x228e, 0x015f, 0x02be, 0x057c, 0x0af8, 0x15f0, 0x2be0, 0x1383, 0x2706, 0x0a4f, 0x149e, 0x293c,
        0x163b, 0x2c76, 0x1caf, 0x395e, 0x36ff, 0x29bd, 0x1739, 0x2e72, 0x18a7, 0x314e, 0x26df, 0x09fd, 0x13fa, 0x27f4, 0x0bab, 0x1756,
        0x2eac, 0x191b, 0x3236, 0x202f, 0x041d, 0x083a, 0x1074, 0x20e8, 0x0593, 0x0b26, 0x164c, 0x2c98, 0x1d73, 0x3ae6, 0x318f, 0x275d,
        0x0af9, 0x15f2, 0x2be4, 0x138b, 0x2716, 0x0a6f, 0x14de, 0x29bc, 0x173b, 0x2e76, 0x18af, 0x315e, 0x26ff, 0x09bd, 0x137a, 0x26f4,
        0x09ab, 0x1356, 0x26ac, 0x091b, 0x1236, 0x246c, 0x0c9b, 0x1936, 0x326c, 0x209b, 0x0575, 0x0aea, 0x15d4, 0x2ba8, 0x1313, 0x2626,
        0x080f, 0x101e, 0x203c, 0x043b, 0x0876, 0x10ec, 0x21d8, 0x07f3, 0x0fe6, 0x1fcc, 0x3f98, 0x3b73, 0x32a5, 0x2109, 0x0651, 0x0ca2,
        0x1944, 0x3288, 0x2153, 0x06e5, 0x0dca, 0x1b94, 0x3728, 0x2a13, 0x1065, 0x20ca, 0x05d7, 0x0bae, 0x175c, 0x2eb8, 0x1933, 0x3266,
        0x208f, 0x055d, 0x0aba, 0x1574, 0x2ae8, 0x1193, 0x2326, 0x020f, 0x041e, 0x083c, 0x1078, 0x20f0, 0x05a3, 0x0b46, 0x168c, 0x2d18,
        0x1e73, 0x3ce6, 0x3d8f, 0x3f5d, 0x3af9, 0x31b1, 0x2721, 0x0a01, 0x1402, 0x2804, 0x144b, 0x2896, 0x156f, 0x2ade, 0x11ff, 0x23fe,
        0x03bf, 0x077e, 0x0efc, 0x1df8, 0x3bf0, 0x33a3, 0x2305, 0x0249, 0x0492, 0x0924, 0x1248, 0x2490, 0x0d63, 0x1ac6, 0x358c, 0x2f5b,
        0x1af5, 0x35ea, 0x2f97, 0x1b6d, 0x36da, 0x29f7, 0x17ad, 0x2f5a, 0x1af7, 0x35ee, 0x2f9f, 0x1b7d, 0x36fa, 0x29b7, 0x172d, 0x2e5a,
        0x18f7, 0x31ee, 0x279f, 0x0b7d, 0x16fa, 0x2df4, 0x1fab, 0x3f56, 0x3aef, 0x319d, 0x2779, 0x0ab1, 0x1562, 0x2ac4, 0x11cb, 0x2396,
        0x036f, 0x06de, 0x0dbc, 0x1b78, 0x36f0, 0x29a3, 0x1705, 0x2e0a, 0x1857, 0x30ae, 0x251f, 0x0e7d, 0x1cfa, 0x39f4, 0x37ab, 0x2b15,
        0x1269, 0x24d2, 0x0de7, 0x1bce, 0x379c, 0x2b7b, 0x12b5, 0x256a, 0x0e97, 0x1d2e, 0x3a5c, 0x30fb, 0x25b5, 0x0f29, 0x1e52, 0x3ca4,
        0x3d0b, 0x3e55, 0x38e9, 0x3591, 0x2f61, 0x1a81, 0x3502, 0x2e47, 0x18cd, 0x319a, 0x2777, 0x0aad, 0x155a, 0x2ab4, 0x112b, 0x2256,
        0x00ef, 0x01de, 0x03bc, 0x0778, 0x0ef0, 0x1de0, 0x3bc0, 0x33c3, 0x23c5, 0x03c9, 0x0792, 0x0f24, 0x1e48, 0x3c90, 0x3d63, 0x3e85,
        0x3949, 0x36d1, 0x29e1, 0x1781, 0x2f02, 0x1a47, 0x348e, 0x2d5f, 0x1efd, 0x3dfa, 0x3fb7, 0x3b2d, 0x3219, 0x2071, 0x04a1, 0x0942,
        0x1284, 0x2508, 0x0e53, 0x1ca6, 0x394c, 0x36db, 0x29f5, 0x17a9, 0x2f52, 0x1ae7, 0x35ce, 0x2fdf, 0x1bfd, 0x37fa, 0x2bb7, 0x132d,
        0x265a, 0x08f7, 0x11ee, 0x23dc, 0x03fb, 0x07f6, 0x0fec, 0x1fd8, 0x3fb0, 0x3b23, 0x3205, 0x2049, 0x04d1, 0x09a2, 0x1344, 0x2688,
        0x0953, 0x12a6, 0x254c, 0x0edb, 0x1db6, 0x3b6c, 0x329b, 0x2175, 0x06a9, 0x0d52, 0x1aa4, 0x3548, 0x2ed3, 0x19e5, 0x33ca, 0x23d7,
        0x03ed, 0x07da, 0x0fb4, 0x1f68, 0x3ed0, 0x39e3, 0x3785, 0x2b49, 0x12d1, 0x25a2, 0x0f07, 0x1e0e, 0x3c1c, 0x3c7b, 0x3cb5, 0x3d29,
        0x3e11, 0x3861, 0x3481, 0x2d41, 0x1ec1, 0x3d82, 0x3f47, 0x3acd, 0x31d9, 0x27f1, 0x0ba1, 0x1742, 0x2e84, 0x194b, 0x3296, 0x216f,
        0x069d, 0x0d3a, 0x1a74, 0x34e8, 0x2d93, 0x1f65, 0x3eca, 0x39d7, 0x37ed, 0x2b99, 0x1371, 0x26e2, 0x0987, 0x130e, 0x261c, 0x087b,
        0x10f6, 0x21ec, 0x079b, 0x0f36, 0x1e6c, 0x3cd8, 0x3df3, 0x3fa5, 0x3b09, 0x3251, 0x20e1, 0x0581, 0x0b02, 0x1604, 0x2c08, 0x1c53,
        0x38a6, 0x350f, 0x2e5d, 0x18f9, 0x31f2, 0x27a7, 0x0b0d, 0x161a, 0x2c34, 0x1c2b, 0x3856, 0x34ef, 0x2d9d, 0x1f79, 0x3ef2, 0x39a7,
        0x370d, 0x2a59, 0x10f1, 0x21e2, 0x0787, 0x0f0e, 0x1e1c, 0x3c38, 0x3c33, 0x3c25, 0x3c09, 0x3c51, 0x3ce1, 0x3d81, 0x3f41, 0x3ac1,
        0x31c1, 0x27c1, 0x0bc1, 0x1782, 0x2f04, 0x1a4b, 0x3496, 0x2d6f, 0x1e9d, 0x3d3a, 0x3e37, 0x382d, 0x3419, 0x2c71, 0x1ca1, 0x3942,
        0x36c7, 0x29cd, 0x17d9, 0x2fb2, 0x1b27, 0x364e, 0x28df, 0x15fd, 0x2bfa, 0x13b7, 0x276e, 0x0a9f, 0x153e, 0x2a7c, 0x10bb, 0x2176,
        0x06af, 0x0d5e, 0x1abc, 0x3578, 0x2eb3, 0x1925, 0x324a, 0x20d7, 0x05ed, 0x0bda, 0x17b4, 0x2f68, 0x1a93, 0x3526, 0x2e0f, 0x185d,
        0x30ba, 0x2537, 0x0e2d, 0x1c5a, 0x38b4, 0x352b, 0x2e15, 0x1869, 0x30d2, 0x25e7, 0x0f8d, 0x1f1a, 0x3e34, 0x382b, 0x3415, 0x2c69,
        0x1c91, 0x3922, 0x3607, 0x284d, 0x14d9, 0x29b2, 0x1727, 0x2e4e, 0x18df, 0x31be, 0x273f, 0x0a3d, 0x147a, 0x28f4, 0x15ab, 0x2b56,
        0x12ef, 0x25de, 0x0fff, 0x1ffe, 0x3ffc, 0x3bbb, 0x3335, 0x2229, 0x0011, 0x0022, 0x0044, 0x0088, 0x0110, 0x0220, 0x0440, 0x0880,
        0x1100, 0x2200, 0x0043, 0x0086, 0x010c, 0x0218, 0x0430, 0x0860, 0x10c0, 0x2180, 0x0743, 0x0e86, 0x1d0c, 0x3a18, 0x3073, 0x24a5,
        0x0d09, 0x1a12, 0x3424, 0x2c0b, 0x1c55, 0x38aa, 0x3517, 0x2e6d, 0x1899, 0x3132, 0x2627, 0x080d, 0x101a, 0x2034, 0x042b, 0x0856,
        0x10ac, 0x2158, 0x06f3, 0x0de6, 0x1bcc, 0x3798, 0x2b73, 0x12a5, 0x254a, 0x0ed7, 0x1dae, 0x3b5c, 0x32fb, 0x21b5, 0x0729, 0x0e52,
        0x1ca4, 0x3948, 0x36d3, 0x29e5, 0x1789, 0x2f12, 0x1a67, 0x34ce, 0x2ddf, 0x1ffd, 0x3ffa, 0x3bb7, 0x332d, 0x2219, 0x0071, 0x00e2,
        0x01c4, 0x0388, 0x0710, 0x0e20, 0x1c40, 0x3880, 0x3543, 0x2ec5, 0x19c9, 0x3392, 0x2367, 0x028d, 0x051a, 0x0a34, 0x1468, 0x28d0,
        0x15e3, 0x2bc6, 0x13cf, 0x279e, 0x0b7f, 0x16fe, 0x2dfc, 0x1fbb, 0x3f76, 0x3aaf, 0x311d, 0x2679, 0x08b1, 0x1162, 0x22c4, 0x01cb,
        0x0396, 0x072c, 0x0e58, 0x1cb0, 0x3960, 0x3683, 0x2945, 0x16c9, 0x2d92, 0x1f67, 0x3ece, 0x39df, 0x37fd, 0x2bb9, 0x1331, 0x2662,
        0x0887, 0x110e, 0x221c, 0x007b, 0x00f6, 0x01ec, 0x03d8, 0x07b0, 0x0f60, 0x1ec0, 0x3d80, 0x3f43, 0x3ac5, 0x31c9, 0x27d1, 0x0be1,
        0x17c2, 0x2f84, 0x1b4b, 0x3696, 0x296f, 0x169d, 0x2d3a, 0x1e37, 0x3c6e, 0x3c9f, 0x3d7d, 0x3eb9, 0x3931, 0x3621, 0x2801, 0x1441,
        0x2882, 0x1547, 0x2a8e, 0x115f, 0x22be, 0x013f, 0x027e, 0x04fc, 0x09f8, 0x13f0, 0x27e0, 0x0b83, 0x1706, 0x2e0c, 0x185b, 0x30b6,
        0x252f, 0x0e1d, 0x1c3a, 0x3874, 0x34ab, 0x2d15, 0x1e69, 0x3cd2, 0x3de7, 0x3f8d, 0x3b59, 0x32f1, 0x21a1, 0x0701, 0x0e02, 0x1c04,
        0x3808, 0x3453, 0x2ce5, 0x1d89, 0x3b12, 0x3267, 0x208d, 0x0559, 0x0ab2, 0x1564, 0x2ac8, 0x11d3, 0x23a6, 0x030f, 0x061e, 0x0c3c,
        0x1878, 0x30f0, 0x25a3, 0x0f05, 0x1e0a, 0x3c14, 0x3c6b, 0x3c95, 0x3d69, 0x3e91, 0x3961, 0x3681, 0x2941, 0x16c1, 0x2d82, 0x1f47,
        0x3e8e, 0x395f, 0x36fd, 0x29b9, 0x1731, 0x2e62, 0x1887, 0x310e, 0x265f, 0x08fd, 0x11fa, 0x23f4, 0x03ab, 0x0756, 0x0eac, 0x1d58,
        0x3ab0, 0x3123, 0x2605, 0x0849, 0x1092, 0x2124, 0x060b, 0x0c16, 0x182c, 0x3058, 0x24f3, 0x0da5, 0x1b4a, 0x3694, 0x296b, 0x1695,
        0x2d2a, 0x1e17, 0x3c2e, 0x3c1f, 0x3c7d, 0x3cb9, 0x3d31, 0x3e21, 0x3801, 0x3441, 0x2cc1, 0x1dc1, 0x3b82, 0x3347, 0x22cd, 0x01d9,
        0x03b2, 0x0764, 0x0ec8, 0x1d90, 0x3b20, 0x3203, 0x2045, 0x04c9, 0x0992, 0x1324, 0x2648, 0x08d3, 0x11a6, 0x234c, 0x02db, 0x05b6,
        0x0b6c, 0x16d8, 0x2db0, 0x1f23, 0x3e46, 0x38cf, 0x35dd, 0x2ff9, 0x1bb1, 0x3762, 0x2a87, 0x114d, 0x229a, 0x0177, 0x02ee, 0x05dc,
        0x0bb8, 0x1770, 0x2ee0, 0x1983, 0x3306, 0x224f, 0x00dd, 0x01ba, 0x0374, 0x06e8, 0x0dd0, 0x1ba0, 0x3740, 0x2ac3, 0x11c5, 0x238a,
        0x0357, 0x06ae, 0x0d5c, 0x1ab8, 0x3570, 0x2ea3, 0x1905, 0x320a, 0x2057, 0x04ed, 0x09da, 0x13b4, 0x2768, 0x0a93, 0x1526, 0x2a4c,
        0x10db, 0x21b6, 0x072f, 0x0e5e, 0x1cbc, 0x3978, 0x36b3, 0x2925, 0x1609, 0x2c12, 0x1c67, 0x38ce, 0x35df, 0x2ffd, 0x1bb9, 0x3772,
        0x2aa7, 0x110d, 0x221a, 0x0077, 0x00ee, 0x01dc, 0x03b8, 0x0770, 0x0ee0, 0x1dc0, 0x3b80, 0x3343, 0x22c5, 0x01c9, 0x0392, 0x0724,
        0x0e48, 0x1c90, 0x3920, 0x3603, 0x2845, 0x14c9, 0x2992, 0x1767, 0x2ece, 0x19df, 0x33be, 0x233f, 0x023d, 0x047a, 0x08f4, 0x11e8,
        0x23d0, 0x03e3, 0x07c6, 0x0f8c, 0x1f18, 0x3e30, 0x3823, 0x3405, 0x2c49, 0x1cd1, 0x39a2, 0x3707, 0x2a4d, 0x10d9, 0x21b2, 0x0727,
        0x0e4e, 0x1c9c, 0x3938, 0x3633, 0x2825, 0x1409, 0x2812, 0x1467, 0x28ce, 0x15df, 0x2bbe, 0x133f, 0x267e, 0x08bf, 0x117e, 0x22fc,
        0x01bb, 0x0376, 0x06ec, 0x0dd8, 0x1bb0, 0x3760, 0x2a83, 0x1145, 0x228a, 0x0157, 0x02ae, 0x055c, 0x0ab8, 0x1570, 0x2ae0, 0x1183,
        0x2306, 0x024f, 0x049e, 0x093c, 0x1278, 0x24f0, 0x0da3, 0x1b46, 0x368c, 0x295b, 0x16f5, 0x2dea, 0x1f97, 0x3f2e, 0x3a1f, 0x307d,
        0x24b9, 0x0d31, 0x1a62, 0x34c4, 0x2dcb, 0x1fd5, 0x3faa, 0x3b17, 0x326d, 0x2099, 0x0571, 0x0ae2, 0x15c4, 0x2b88, 0x1353, 0x26a6,
        0x090f, 0x121e, 0x243c, 0x0c3b, 0x1876, 0x30ec, 0x259b, 0x0f75, 0x1eea, 0x3dd4, 0x3feb, 0x3b95, 0x3369, 0x2291, 0x0161, 0x02c2,
        0x0584, 0x0b08, 0x1610, 0x2c20, 0x1c03, 0x3806, 0x344f, 0x2cdd, 0x1df9, 0x3bf2, 0x33a7, 0x230d, 0x0259, 0x04b2, 0x0964, 0x12c8,
        0x2590, 0x0f63, 0x1ec6, 0x3d8c, 0x3f5b, 0x3af5, 0x31a9, 0x2711, 0x0a61, 0x14c2, 0x2984, 0x174b, 0x2e96, 0x196f, 0x32de, 0x21ff,
        0x07bd, 0x0f7a, 0x1ef4, 0x3de8, 0x3f93, 0x3b65, 0x3289, 0x2151, 0x06e1, 0x0dc2, 0x1b84, 0x3708, 0x2a53, 0x10e5, 0x21ca, 0x07d7,
        0x0fae, 0x1f5c, 0x3eb8, 0x3933, 0x3625, 0x2809, 0x1451, 0x28a2, 0x1507, 0x2a0e, 0x105f, 0x20be, 0x053f, 0x0a7e, 0x14fc, 0x29f8,
        0x17b3, 0x2f66, 0x1a8f, 0x351e, 0x2e7f, 0x18bd, 0x317a, 0x26b7, 0x092d, 0x125a, 0x24b4, 0x0d2b, 0x1a56, 0x34ac, 0x2d1b, 0x1e75,
        0x3cea, 0x3d97, 0x3f6d, 0x3a99, 0x3171, 0x26a1, 0x0901, 0x1202, 0x2404, 0x0c4b, 0x1896, 0x312c, 0x261b, 0x0875, 0x10ea, 0x21d4,
        0x07eb, 0x0fd6, 0x1fac, 0x3f58, 0x3af3, 0x31a5, 0x2709, 0x0a51, 0x14a2, 0x2944, 0x16cb, 0x2d96, 0x1f6f, 0x3ede, 0x39ff, 0x37bd,
        0x2b39, 0x1231, 0x2462, 0x0c87, 0x190e, 0x321c, 0x207b, 0x04b5, 0x096a, 0x12d4, 0x25a8, 0x0f13, 0x1e26, 0x3c4c, 0x3cdb, 0x3df5,
        0x3fa9, 0x3b11, 0x3261, 0x2081, 0x0541, 0x0a82, 0x1504, 0x2a08, 0x1053, 0x20a6, 0x050f, 0x0a1e, 0x143c, 0x2878, 0x14b3, 0x2966,
        0x168f, 0x2d1e, 0x1e7f, 0x3cfe, 0x3dbf, 0x3f3d, 0x3a39, 0x3031, 0x2421, 0x0c01, 0x1802, 0x3004, 0x244b, 0x0cd5, 0x19aa, 0x3354,
        0x22eb, 0x0195, 0x032a, 0x0654, 0x0ca8, 0x1950, 0x32a0, 0x2103, 0x0645, 0x0c8a, 0x1914, 0x3228, 0x2013, 0x0465, 0x08ca, 0x1194,
        0x2328, 0x0213, 0x0426, 0x084c, 0x1098, 0x2130, 0x0623, 0x0c46, 0x188c, 0x3118, 0x2673, 0x08a5, 0x114a, 0x2294, 0x016b, 0x02d6,
        0x05ac, 0x0b58, 0x16b0, 0x2d60, 0x1e83, 0x3d06, 0x3e4f, 0x38dd, 0x35f9, 0x2fb1, 0x1b21, 0x3642, 0x28c7, 0x15cd, 0x2b9a, 0x1377,
        0x26ee, 0x099f, 0x133e, 0x267c, 0x08bb, 0x1176, 0x22ec, 0x019b, 0x0336, 0x066c, 0x0cd8, 0x19b0, 0x3360, 0x2283, 0x0145, 0x028a,
        0x0514, 0x0a28, 0x1450, 0x28a0, 0x1503, 0x2a06, 0x104f, 0x209e, 0x057f, 0x0afe, 0x15fc, 0x2bf8, 0x13b3, 0x2766, 0x0a8f, 0x151e,
        0x2a3c, 0x103b, 0x2076, 0x04af, 0x095e, 0x12bc, 0x2578, 0x0eb3, 0x1d66, 0x3acc, 0x31db, 0x27f5, 0x0ba9, 0x1752, 0x2ea4, 0x190b,
        0x3216, 0x206f, 0x049d, 0x093a, 0x1274, 0x24e8, 0x0d93, 0x1b26, 0x364c, 0x28db, 0x15f5, 0x2bea, 0x1397, 0x272e, 0x0a1f, 0x143e,
        0x287c, 0x14bb, 0x2976, 0x16af, 0x2d5e, 0x1eff, 0x3dfe, 0x3fbf, 0x3b3d, 0x3239, 0x2031, 0x0421, 0x0842, 0x1084, 0x2108, 0x0653,
        0x0ca6, 0x194c, 0x3298, 0x2173, 0x06a5, 0x0d4a, 0x1a94, 0x3528, 0x2e13, 0x1865, 0x30ca, 0x25d7, 0x0fed, 0x1fda, 0x3fb4, 0x3b2b,
        0x3215, 0x2069, 0x0491, 0x0922, 0x1244, 0x2488, 0x0d53, 0x1aa6, 0x354c, 0x2edb, 0x19f5, 0x33ea, 0x2397, 0x036d, 0x06da, 0x0db4,
        0x1b68, 0x36d0, 0x29e3, 0x1785, 0x2f0a, 0x1a57, 0x34ae, 0x2d1f, 0x1e7d, 0x3cfa, 0x3db7, 0x3f2d, 0x3a19, 0x3071, 0x24a1, 0x0d01,
        0x1a02, 0x3404, 0x2c4b, 0x1cd5, 0x39aa, 0x3717, 0x2a6d, 0x1099, 0x2132, 0x0627, 0x0c4e, 0x189c, 0x3138, 0x2633, 0x0825, 0x104a,
        0x2094, 0x056b, 0x0ad6, 0x15ac, 0x2b58, 0x12f3, 0x25e6, 0x0f8f, 0x1f1e, 0x3e3c, 0x383b, 0x3435, 0x2c29, 0x1c11, 0x3822, 0x3407,
        0x2c4d, 0x1cd9, 0x39b2, 0x3727, 0x2a0d, 0x1059, 0x20b2, 0x0527, 0x0a4e, 0x149c, 0x2938, 0x1633, 0x2c66, 0x1c8f, 0x391e, 0x367f,
        0x28bd, 0x1539, 0x2a72, 0x10a7, 0x214e, 0x06df, 0x0dbe, 0x1b7c, 0x36f8, 0x29b3, 0x1725, 0x2e4a, 0x18d7, 0x31ae, 0x271f, 0x0a7d,
        0x14fa, 0x29f4, 0x17ab, 0x2f56, 0x1aef, 0x35de, 0x2fff, 0x1bbd, 0x377a, 0x2ab7, 0x112d, 0x225a, 0x00f7, 0x01ee, 0x03dc, 0x07b8,
        0x0f70, 0x1ee0, 0x3dc0, 0x3fc3, 0x3bc5, 0x33c9, 0x23d1, 0x03e1, 0x07c2, 0x0f84, 0x1f08, 0x3e10, 0x3863, 0x3485, 0x2d49, 0x1ed1,
        0x3da2, 0x3f07, 0x3a4d, 0x30d9, 0x25f1, 0x0fa1, 0x1f42, 0x3e84, 0x394b, 0x36d5, 0x29e9, 0x1791, 0x2f22, 0x1a07, 0x340e, 0x2c5f,
        0x1cfd, 0x39fa, 0x37b7, 0x2b2d, 0x1219, 0x2432, 0x0c27, 0x184e, 0x309c, 0x257b, 0x0eb5, 0x1d6a, 0x3ad4, 0x31eb, 0x2795, 0x0b69,
        0x16d2, 0x2da4, 0x1f0b, 0x3e16, 0x386f, 0x349d, 0x2d79, 0x1eb1, 0x3d62, 0x3e87, 0x394d, 0x36d9, 0x29f1, 0x17a1, 0x2f42, 0x1ac7,
        0x358e, 0x2f5f, 0x1afd, 0x35fa, 0x2fb7, 0x1b2d, 0x365a, 0x28f7, 0x15ad, 0x2b5a, 0x12f7, 0x25ee, 0x0f9f, 0x1f3e, 0x3e7c, 0x38bb,
        0x3535, 0x2e29, 0x1811, 0x3022, 0x2407, 0x0c4d, 0x189a, 0x3134, 0x262b, 0x0815, 0x102a, 0x2054, 0x04eb, 0x09d6, 0x13ac, 0x2758,
        0x0af3, 0x15e6, 0x2bcc, 0x13db, 0x27b6, 0x0b2f, 0x165e, 0x2cbc, 0x1d3b, 0x3a76, 0x30af, 0x251d, 0x0e79, 0x1cf2, 0x39e4, 0x378b,
        0x2b55, 0x12e9, 0x25d2, 0x0fe7, 0x1fce, 0x3f9c, 0x3b7b, 0x32b5, 0x2129, 0x0611, 0x0c22, 0x1844, 0x3088, 0x2553, 0x0ee5, 0x1dca,
        0x3b94, 0x336b, 0x2295, 0x0169, 0x02d2, 0x05a4, 0x0b48, 0x1690, 0x2d20, 0x1e03, 0x3c06, 0x3c4f, 0x3cdd, 0x3df9, 0x3fb1, 0x3b21,
        0x3201, 0x2041, 0x04c1, 0x0982, 0x1304, 0x2608, 0x0853, 0x10a6, 0x214c, 0x06db, 0x0db6, 0x1b6c, 0x36d8, 0x29f3, 0x17a5, 0x2f4a,
        0x1ad7, 0x35ae, 0x2f1f, 0x1a7d, 0x34fa, 0x2db7, 0x1f2d, 0x3e5a, 0x38f7, 0x35ad, 0x2f19, 0x1a71, 0x34e2, 0x2d87, 0x1f4d, 0x3e9a,
        0x3977, 0x36ad, 0x2919, 0x1671, 0x2ce2, 0x1d87, 0x3b0e, 0x325f, 0x20fd, 0x05b9, 0x0b72, 0x16e4, 0x2dc8, 0x1fd3, 0x3fa6, 0x3b0f,
        0x325d, 0x20f9, 0x05b1, 0x0b62, 0x16c4, 0x2d88, 0x1f53, 0x3ea6, 0x390f, 0x365d, 0x28f9, 0x15b1, 0x2b62, 0x1287, 0x250e, 0x0e5f,
        0x1cbe, 0x397c, 0x36bb, 0x2935, 0x1629, 0x2c52, 0x1ce7, 0x39ce, 0x37df, 0x2bfd, 0x13b9, 0x2772, 0x0aa7, 0x154e, 0x2a9c, 0x117b,
        0x22f6, 0x01af, 0x035e, 0x06bc, 0x0d78, 0x1af0, 0x35e0, 0x2f83, 0x1b45, 0x368a, 0x2957, 0x16ed, 0x2dda, 0x1ff7, 0x3fee, 0x3b9f,
        0x337d, 0x22b9, 0x0131, 0x0262, 0x04c4, 0x0988, 0x1310, 0x2620, 0x0803, 0x1006, 0x200c, 0x045b, 0x08b6, 0x116c, 0x22d8, 0x01f3,
        0x03e6, 0x07cc, 0x0f98, 0x1f30, 0x3e60, 0x3883, 0x3545, 0x2ec9, 0x19d1, 0x33a2, 0x2307, 0x024d, 0x049a, 0x0934, 0x1268, 0x24d0,
        0x0de3, 0x1bc6, 0x378c, 0x2b5b, 0x12f5, 0x25ea, 0x0f97, 0x1f2e, 0x3e5c, 0x38fb, 0x35b5, 0x2f29, 0x1a11, 0x3422, 0x2c07, 0x1c4d,
        0x389a, 0x3577, 0x2ead, 0x1919, 0x3232, 0x2027, 0x040d, 0x081a, 0x1034, 0x2068, 0x0493, 0x0926, 0x124c, 0x2498, 0x0d73, 0x1ae6,
        0x35cc, 0x2fdb, 0x1bf5, 0x37ea, 0x2b97, 0x136d, 0x26da, 0x09f7, 0x13ee, 0x27dc, 0x0bfb, 0x17f6, 0x2fec, 0x1b9b, 0x3736, 0x2a2f,
        0x101d, 0x203a, 0x0437, 0x086e, 0x10dc, 0x21b8, 0x0733, 0x0e66, 0x1ccc, 0x3998, 0x3773, 0x2aa5, 0x1109, 0x2212, 0x0067, 0x00ce,
        0x019c, 0x0338, 0x0670, 0x0ce0, 0x19c0, 0x3380, 0x2343, 0x02c5, 0x058a, 0x0b14, 0x1628, 0x2c50, 0x1ce3, 0x39c6, 0x37cf, 0x2bdd,
        0x13f9, 0x27f2, 0x0ba7, 0x174e, 0x2e9c, 0x197b, 0x32f6, 0x21af, 0x071d, 0x0e3a, 0x1c74, 0x38e8, 0x3593, 0x2f65, 0x1a89, 0x3512,
        0x2e67, 0x188d, 0x311a, 0x2677, 0x08ad, 0x115a, 0x22b4, 0x012b, 0x0256, 0x04ac, 0x0958, 0x12b0, 0x2560, 0x0e83, 0x1d06, 0x3a0c,
        0x305b, 0x24f5, 0x0da9, 0x1b52, 0x36a4, 0x290b, 0x1655, 0x2caa, 0x1d17, 0x3a2e, 0x301f, 0x247d, 0x0cb9, 0x1972, 0x32e4, 0x218b,
        0x0755, 0x0eaa, 0x1d54, 0x3aa8, 0x3113, 0x2665, 0x0889, 0x1112, 0x2224, 0x000b, 0x0016, 0x002c, 0x0058, 0x00b0, 0x0160, 0x02c0,
        0x0580, 0x0b00, 0x1600, 0x2c00, 0x1c43, 0x3886, 0x354f, 0x2edd, 0x19f9, 0x33f2, 0x23a7, 0x030d, 0x061a, 0x0c34, 0x1868, 0x30d0,
        0x25e3, 0x0f85, 0x1f0a, 0x3e14, 0x386b, 0x3495, 0x2d69, 0x1e91, 0x3d22, 0x3e07, 0x384d, 0x34d9, 0x2df1, 0x1fa1, 0x3f42, 0x3ac7,
        0x31cd, 0x27d9, 0x0bf1, 0x17e2, 0x2fc4, 0x1bcb, 0x3796, 0x2b6f, 0x129d, 0x253a, 0x0e37, 0x1c6e, 0x38dc, 0x35fb, 0x2fb5, 0x1b29,
        0x3652, 0x28e7, 0x158d, 0x2b1a, 0x1277, 0x24ee, 0x0d9f, 0x1b3e, 0x367c, 0x28bb, 0x1535, 0x2a6a, 0x1097, 0x212e, 0x061f, 0x0c3e,
        0x187c, 0x30f8, 0x25b3, 0x0f25, 0x1e4a, 0x3c94, 0x3d6b, 0x3e95, 0x3969, 0x3691, 0x2961, 0x1681, 0x2d02, 0x1e47, 0x3c8e, 0x3d5f,
        0x3efd, 0x39b9, 0x3731, 0x2a21, 0x1001, 0x2002, 0x0447, 0x088e, 0x111c, 0x2238, 0x0033, 0x0066, 0x00cc, 0x0198, 0x0330, 0x0660,
        0x0cc0, 0x1980, 0x3300, 0x2243, 0x00c5, 0x018a, 0x0314, 0x0628, 0x0c50, 0x18a0, 0x3140, 0x26c3, 0x09c5, 0x138a, 0x2714, 0x0a6b,
        0x14d6, 0x29ac, 0x171b, 0x2e36, 0x182f, 0x305e, 0x24ff, 0x0dbd, 0x1b7a, 0x36f4, 0x29ab, 0x1715, 0x2e2a, 0x1817, 0x302e, 0x241f,
        0x0c7d, 0x18fa, 0x31f4, 0x27ab, 0x0b15, 0x162a, 0x2c54, 0x1ceb, 0x39d6, 0x37ef, 0x2b9d, 0x1379, 0x26f2, 0x09a7, 0x134e, 0x269c,
        0x097b, 0x12f6, 0x25ec, 0x0f9b, 0x1f36, 0x3e6c, 0x389b, 0x3575, 0x2ea9, 0x1911, 0x3222, 0x2007, 0x044d, 0x089a, 0x1134, 0x2268,
        0x0093, 0x0126, 0x024c, 0x0498, 0x0930, 0x1260, 0x24c0, 0x0dc3, 0x1b86, 0x370c, 0x2a5b, 0x10f5, 0x21ea, 0x0797, 0x0f2e, 0x1e5c,
        0x3cb8, 0x3d33, 0x3e25, 0x3809, 0x3451, 0x2ce1, 0x1d81, 0x3b02, 0x3247, 0x20cd, 0x05d9, 0x0bb2, 0x1764, 0x2ec8, 0x19d3, 0x33a6,
        0x230f, 0x025d, 0x04ba, 0x0974, 0x12e8, 0x25d0, 0x0fe3, 0x1fc6, 0x3f8c, 0x3b5b, 0x32f5, 0x21a9, 0x0711, 0x0e22, 0x1c44, 0x3888,
        0x3553, 0x2ee5, 0x1989, 0x3312, 0x2267, 0x008d, 0x011a, 0x0234, 0x0468, 0x08d0, 0x11a0, 0x2340, 0x02c3, 0x0586, 0x0b0c, 0x1618,
        0x2c30, 0x1c23, 0x3846, 0x34cf, 0x2ddd, 0x1ff9, 0x3ff2, 0x3ba7, 0x330d, 0x2259, 0x00f1, 0x01e2, 0x03c4, 0x0788, 0x0f10, 0x1e20,
        0x3c40, 0x3cc3, 0x3dc5, 0x3fc9, 0x3bd1, 0x33e1, 0x2381, 0x0341, 0x0682, 0x0d04, 0x1a08, 0x3410, 0x2c63, 0x1c85, 0x390a, 0x3657,
        0x28ed, 0x1599, 0x2b32, 0x1227, 0x244e, 0x0cdf, 0x19be, 0x337c, 0x22bb, 0x0135, 0x026a, 0x04d4, 0x09a8, 0x1350, 0x26a0, 0x0903,
        0x1206, 0x240c, 0x0c5b, 0x18b6, 0x316c, 0x269b, 0x0975, 0x12ea, 0x25d4, 0x0feb, 0x1fd6, 0x3fac, 0x3b1b, 0x3275, 0x20a9, 0x0511,
        0x0a22, 0x1444, 0x2888, 0x1553, 0x2aa6, 0x110f, 0x221e, 0x007f, 0x00fe, 0x01fc, 0x03f8, 0x07f0, 0x0fe0, 0x1fc0, 0x3f80, 0x3b43,
        0x32c5, 0x21c9, 0x07d1, 0x0fa2, 0x1f44, 0x3e88, 0x3953, 0x36e5, 0x2989, 0x1751, 0x2ea2, 0x1907, 0x320e, 0x205f, 0x04fd, 0x09fa,
        0x13f4, 0x27e8, 0x0b93, 0x1726, 0x2e4c, 0x18db, 0x31b6, 0x272f, 0x0a1d, 0x143a, 0x2874, 0x14ab, 0x2956, 0x16ef, 0x2dde, 0x1fff,
        0x3ffe, 0x3bbf, 0x333d, 0x2239, 0x0031, 0x0062, 0x00c4, 0x0188, 0x0310, 0x0620, 0x0c40, 0x1880, 0x3100, 0x2643, 0x08c5, 0x118a,
        0x2314, 0x026b, 0x04d6, 0x09ac, 0x1358, 0x26b0, 0x0923, 0x1246, 0x248c, 0x0d5b, 0x1ab6, 0x356c, 0x2e9b, 0x1975, 0x32ea, 0x2197,
        0x076d, 0x0eda, 0x1db4, 0x3b68, 0x3293, 0x2165, 0x0689, 0x0d12, 0x1a24, 0x3448, 0x2cd3, 0x1de5, 0x3bca, 0x33d7, 0x23ed, 0x0399,
        0x0732, 0x0e64, 0x1cc8, 0x3990, 0x3763, 0x2a85, 0x1149, 0x2292, 0x0167, 0x02ce, 0x059c, 0x0b38, 0x1670, 0x2ce0, 0x1d83, 0x3b06,
        0x324f, 0x20dd, 0x05f9, 0x0bf2, 0x17e4, 0x2fc8, 0x1bd3, 0x37a6, 0x2b0f, 0x125d, 0x24ba, 0x0d37, 0x1a6e, 0x34dc, 0x2dfb, 0x1fb5,
        0x3f6a, 0x3a97, 0x316d, 0x2699, 0x0971, 0x12e2, 0x25c4, 0x0fcb, 0x1f96, 0x3f2c, 0x3a1b, 0x3075, 0x24a9, 0x0d11, 0x1a22, 0x3444,
        0x2ccb, 0x1dd5, 0x3baa, 0x3317, 0x226d, 0x0099, 0x0132, 0x0264, 0x04c8, 0x0990, 0x1320, 0x2640, 0x08c3, 0x1186, 0x230c, 0x025b,
        0x04b6, 0x096c, 0x12d8, 0x25b0, 0x0f23, 0x1e46, 0x3c8c, 0x3d5b, 0x3ef5, 0x39a9, 0x3711, 0x2a61, 0x1081, 0x2102, 0x0647, 0x0c8e,
        0x191c, 0x3238, 0x2033, 0x0425, 0x084a, 0x1094, 0x2128, 0x0613, 0x0c26, 0x184c, 0x3098, 0x2573, 0x0ea5, 0x1d4a, 0x3a94, 0x316b,
        0x2695, 0x0969, 0x12d2, 0x25a4, 0x0f0b, 0x1e16, 0x3c2c, 0x3c1b, 0x3c75, 0x3ca9, 0x3d11, 0x3e61, 0x3881, 0x3541, 0x2ec1, 0x19c1,
        0x3382, 0x2347, 0x02cd, 0x059a, 0x0b34, 0x1668, 0x2cd0, 0x1de3, 0x3bc6, 0x33cf, 0x23dd, 0x03f9, 0x07f2, 0x0fe4, 0x1fc8, 0x3f90,
        0x3b63, 0x3285, 0x2149, 0x06d1, 0x0da2, 0x1b44, 0x3688, 0x2953, 0x16e5, 0x2dca, 0x1fd7, 0x3fae, 0x3b1f, 0x327d, 0x20b9, 0x0531,
        0x0a62, 0x14c4, 0x2988, 0x1753, 0x2ea6, 0x190f, 0x321e, 0x207f, 0x04bd, 0x097a, 0x12f4, 0x25e8, 0x0f93, 0x1f26, 0x3e4c, 0x38db,
        0x35f5, 0x2fa9, 0x1b11, 0x3622, 0x2807, 0x144d, 0x289a, 0x1577, 0x2aee, 0x119f, 0x233e, 0x023f, 0x047e, 0x08fc, 0x11f8, 0x23f0,
        0x03a3, 0x0746, 0x0e8c, 0x1d18, 0x3a30, 0x3023, 0x2405, 0x0c49, 0x1892, 0x3124, 0x260b, 0x0855, 0x10aa, 0x2154, 0x06eb, 0x0dd6,
        0x1bac, 0x3758, 0x2af3, 0x11a5, 0x234a, 0x02d7, 0x05ae, 0x0b5c, 0x16b8, 0x2d70, 0x1ea3, 0x3d46, 0x3ecf, 0x39dd, 0x37f9, 0x2bb1,
        0x1321, 0x2642, 0x08c7, 0x118e, 0x231c, 0x027b, 0x04f6, 0x09ec, 0x13d8, 0x27b0, 0x0b23, 0x1646, 0x2c8c, 0x1d5b, 0x3ab6, 0x312f,
        0x261d, 0x0879, 0x10f2, 0x21e4, 0x078b, 0x0f16, 0x1e2c, 0x3c58, 0x3cf3, 0x3da5, 0x3f09, 0x3a51, 0x30e1, 0x2581, 0x0f41, 0x1e82,
        0x3d04, 0x3e4b, 0x38d5, 0x35e9, 0x2f91, 0x1b61, 0x36c2, 0x29c7, 0x17cd, 0x2f9a, 0x1b77, 0x36ee, 0x299f, 0x177d, 0x2efa, 0x19b7,
        0x336e, 0x229f, 0x017d, 0x02fa, 0x05f4, 0x0be8, 0x17d0, 0x2fa0, 0x1b03, 0x3606, 0x284f, 0x14dd, 0x29ba, 0x1737, 0x2e6e, 0x189f,
        0x313e, 0x263f, 0x083d, 0x107a, 0x20f4, 0x05ab, 0x0b56, 0x16ac, 0x2d58, 0x1ef3, 0x3de6, 0x3f8f, 0x3b5d, 0x32f9, 0x21b1, 0x0721,
        0x0e42, 0x1c84, 0x3908, 0x3653, 0x28e5, 0x1589, 0x2b12, 0x1267, 0x24ce, 0x0ddf, 0x1bbe, 0x377c, 0x2abb, 0x1135, 0x226a, 0x0097,
        0x012e, 0x025c, 0x04b8, 0x0970, 0x12e0, 0x25c0, 0x0fc3, 0x1f86, 0x3f0c, 0x3a5b, 0x30f5, 0x25a9, 0x0f11, 0x1e22, 0x3c44, 0x3ccb,
        0x3dd5, 0x3fe9, 0x3b91, 0x3361, 0x2281, 0x0141, 0x0282, 0x0504, 0x0a08, 0x1410, 0x2820, 0x1403, 0x2806, 0x144f, 0x289e, 0x157f,
        0x2afe, 0x11bf, 0x237e, 0x02bf, 0x057e, 0x0afc, 0x15f8, 0x2bf0, 0x13a3, 0x2746, 0x0acf, 0x159e, 0x2b3c, 0x123b, 0x2476, 0x0caf,
        0x195e, 0x32bc, 0x213b, 0x0635, 0x0c6a, 0x18d4, 0x31a8, 0x2713, 0x0a65, 0x14ca, 0x2994, 0x176b, 0x2ed6, 0x19ef, 0x33de, 0x23ff,
        0x03bd, 0x077a, 0x0ef4, 0x1de8, 0x3bd0, 0x33e3, 0x2385, 0x0349, 0x0692, 0x0d24, 0x1a48, 0x3490, 0x2d63, 0x1e85, 0x3d0a, 0x3e57,
        0x38ed, 0x3599, 0x2f71, 0x1aa1, 0x3542, 0x2ec7, 0x19cd, 0x339a, 0x2377, 0x02ad, 0x055a, 0x0ab4, 0x1568, 0x2ad0, 0x11e3, 0x23c6,
        0x03cf, 0x079e, 0x0f3c, 0x1e78, 0x3cf0, 0x3da3, 0x3f05, 0x3a49, 0x30d1, 0x25e1, 0x0f81, 0x1f02, 0x3e04, 0x384b, 0x34d5, 0x2de9,
        0x1f91, 0x3f22, 0x3a07, 0x304d, 0x24d9, 0x0df1, 0x1be2, 0x37c4, 0x2bcb, 0x13d5, 0x27aa, 0x0b17, 0x162e, 0x2c5c, 0x1cfb, 0x39f6,
        0x37af, 0x2b1d, 0x1279, 0x24f2, 0x0da7, 0x1b4e, 0x369c, 0x297b, 0x16b5, 0x2d6a, 0x1e97, 0x3d2e, 0x3e1f, 0x387d, 0x34b9, 0x2d31,
        0x1e21, 0x3c42, 0x3cc7, 0x3dcd, 0x3fd9, 0x3bf1, 0x33a1, 0x2301, 0x0241, 0x0482, 0x0904, 0x1208, 0x2410, 0x0c63, 0x18c6, 0x318c,
        0x275b, 0x0af5, 0x15ea, 0x2bd4, 0x13eb, 0x27d6, 0x0bef, 0x17de, 0x2fbc, 0x1b3b, 0x3676, 0x28af, 0x151d, 0x2a3a, 0x1037, 0x206e,
        0x049f, 0x093e, 0x127c, 0x24f8, 0x0db3, 0x1b66, 0x36cc, 0x29db, 0x17f5, 0x2fea, 0x1b97, 0x372e, 0x2a1f, 0x107d, 0x20fa, 0x05b7,
        0x0b6e, 0x16dc, 0x2db8, 0x1f33, 0x3e66, 0x388f, 0x355d, 0x2ef9, 0x19b1, 0x3362, 0x2287, 0x014d, 0x029a, 0x0534, 0x0a68, 0x14d0,
        0x29a0, 0x1703, 0x2e06, 0x184f, 0x309e, 0x257f, 0x0ebd, 0x1d7a, 0x3af4, 0x31ab, 0x2715, 0x0a69, 0x14d2, 0x29a4, 0x170b, 0x2e16,
        0x186f, 0x30de, 0x25ff, 0x0fbd, 0x1f7a, 0x3ef4, 0x39ab, 0x3715, 0x2a69, 0x1091, 0x2122, 0x0607, 0x0c0e, 0x181c, 0x3038, 0x2433,
        0x0c25, 0x184a, 0x3094, 0x256b, 0x0e95, 0x1d2a, 0x3a54, 0x30eb, 0x2595, 0x0f69, 0x1ed2, 0x3da4, 0x3f0b, 0x3a55, 0x30e9, 0x2591,
        0x0f61, 0x1ec2, 0x3d84, 0x3f4b, 0x3ad5, 0x31e9, 0x2791, 0x0b61, 0x16c2, 0x2d84, 0x1f4b, 0x3e96, 0x396f, 0x369d, 0x2979, 0x16b1,
        0x2d62, 0x1e87, 0x3d0e, 0x3e5f, 0x38fd, 0x35b9, 0x2f31, 0x1a21, 0x3442, 0x2cc7, 0x1dcd, 0x3b9a, 0x3377, 0x22ad, 0x0119, 0x0232,
        0x0464, 0x08c8, 0x1190, 0x2320, 0x0203, 0x0406, 0x080c, 0x1018, 0x2030, 0x0423, 0x0846, 0x108c, 0x2118, 0x0673, 0x0ce6, 0x19cc,
        0x3398, 0x2373, 0x02a5, 0x054a, 0x0a94, 0x1528, 0x2a50, 0x10e3, 0x21c6, 0x07cf, 0x0f9e, 0x1f3c, 0x3e78, 0x38b3, 0x3525, 0x2e09,
        0x1851, 0x30a2, 0x2507, 0x0e4d, 0x1c9a, 0x3934, 0x362b, 0x2815, 0x1469, 0x28d2, 0x15e7, 0x2bce, 0x13df, 0x27be, 0x0b3f, 0x167e,
        0x2cfc, 0x1dbb, 0x3b76, 0x32af, 0x211d, 0x0679, 0x0cf2, 0x19e4, 0x33c8, 0x23d3, 0x03e5, 0x07ca, 0x0f94, 0x1f28, 0x3e50, 0x38e3,
        0x3585, 0x2f49, 0x1ad1, 0x35a2, 0x2f07, 0x1a4d, 0x349a, 0x2d77, 0x1ead, 0x3d5a, 0x3ef7, 0x39ad, 0x3719, 0x2a71, 0x10a1, 0x2142,
        0x06c7, 0x0d8e, 0x1b1c, 0x3638, 0x2833, 0x1425, 0x284a, 0x14d7, 0x29ae, 0x171f, 0x2e3e, 0x183f, 0x307e, 0x24bf, 0x0d3d, 0x1a7a,
        0x34f4, 0x2dab, 0x1f15, 0x3e2a, 0x3817, 0x346d, 0x2c99, 0x1d71, 0x3ae2, 0x3187, 0x274d, 0x0ad9, 0x15b2, 0x2b64, 0x128b, 0x2516,
        0x0e6f, 0x1cde, 0x39bc, 0x373b, 0x2a35, 0x1029, 0x2052, 0x04e7, 0x09ce, 0x139c, 0x2738, 0x0a33, 0x1466, 0x28cc, 0x15db, 0x2bb6,
        0x132f, 0x265e, 0x08ff, 0x11fe, 0x23fc, 0x03bb, 0x0776, 0x0eec, 0x1dd8, 0x3bb0, 0x3323, 0x2205, 0x0049, 0x0092, 0x0124, 0x0248,
        0x0490, 0x0920, 0x1240, 0x2480, 0x0d43, 0x1a86, 0x350c, 0x2e5b, 0x18f5, 0x31ea, 0x2797, 0x0b6d, 0x16da, 0x2db4, 0x1f2b, 0x3e56,
        0x38ef, 0x359d, 0x2f79, 0x1ab1, 0x3562, 0x2e87, 0x194d, 0x329a, 0x2177, 0x06ad, 0x0d5a, 0x1ab4, 0x3568, 0x2e93, 0x1965, 0x32ca,
        0x21d7, 0x07ed, 0x0fda, 0x1fb4, 0x3f68, 0x3a93, 0x3165, 0x2689, 0x0951, 0x12a2, 0x2544, 0x0ecb, 0x1d96, 0x3b2c, 0x321b, 0x2075,
        0x04a9, 0x0952, 0x12a4, 0x2548, 0x0ed3, 0x1da6, 0x3b4c, 0x32db, 0x21f5, 0x07a9, 0x0f52, 0x1ea4, 0x3d48, 0x3ed3, 0x39e5, 0x3789,
        0x2b51, 0x12e1, 0x25c2, 0x0fc7, 0x1f8e, 0x3f1c, 0x3a7b, 0x30b5, 0x2529, 0x0e11, 0x1c22, 0x3844, 0x34cb, 0x2dd5, 0x1fe9, 0x3fd2,
        0x3be7, 0x338d, 0x2359, 0x02f1, 0x05e2, 0x0bc4, 0x1788, 0x2f10, 0x1a63, 0x34c6, 0x2dcf, 0x1fdd, 0x3fba, 0x3b37, 0x322d, 0x2019,
        0x0471, 0x08e2, 0x11c4, 0x2388, 0x0353, 0x06a6, 0x0d4c, 0x1a98, 0x3530, 0x2e23, 0x1805, 0x300a, 0x2457, 0x0ced, 0x19da, 0x33b4,
        0x232b, 0x0215, 0x042a, 0x0854, 0x10a8, 0x2150, 0x06e3, 0x0dc6, 0x1b8c, 0x3718, 0x2a73, 0x10a5, 0x214a, 0x06d7, 0x0dae, 0x1b5c,
        0x36b8, 0x2933, 0x1625, 0x2c4a, 0x1cd7, 0x39ae, 0x371f, 0x2a7d, 0x10b9, 0x2172, 0x06a7, 0x0d4e, 0x1a9c, 0x3538, 0x2e33, 0x1825,
        0x304a, 0x24d7, 0x0ded, 0x1bda, 0x37b4, 0x2b2b, 0x1215, 0x242a, 0x0c17, 0x182e, 0x305c, 0x24fb, 0x0db5, 0x1b6a, 0x36d4, 0x29eb,
        0x1795, 0x2f2a, 0x1a17, 0x342e, 0x2c1f, 0x1c7d, 0x38fa, 0x35b7, 0x2f2d, 0x1a19, 0x3432, 0x2c27, 0x1c0d, 0x381a, 0x3477, 0x2cad,
        0x1d19, 0x3a32, 0x3027, 0x240d, 0x0c59, 0x18b2, 0x3164, 0x268b, 0x0955, 0x12aa, 0x2554, 0x0eeb, 0x1dd6, 0x3bac, 0x331b, 0x2275,
        0x00a9, 0x0152, 0x02a4, 0x0548, 0x0a90, 0x1520, 0x2a40, 0x10c3, 0x2186, 0x074f, 0x0e9e, 0x1d3c, 0x3a78, 0x30b3, 0x2525, 0x0e09,
        0x1c12, 0x3824, 0x340b, 0x2c55, 0x1ce9, 0x39d2, 0x37e7, 0x2b8d, 0x1359, 0x26b2, 0x0927, 0x124e, 0x249c, 0x0d7b, 0x1af6, 0x35ec,
        0x2f9b, 0x1b75, 0x36ea, 0x2997, 0x176d, 0x2eda, 0x19f7, 0x33ee, 0x239f, 0x037d, 0x06fa, 0x0df4, 0x1be8, 0x37d0, 0x2be3, 0x1385,
        0x270a, 0x0a57, 0x14ae, 0x295c, 0x16fb, 0x2df6, 0x1faf, 0x3f5e, 0x3aff, 0x31bd, 0x2739, 0x0a31, 0x1462, 0x28c4, 0x15cb, 0x2b96,
        0x136f, 0x26de, 0x09ff, 0x13fe, 0x27fc, 0x0bbb, 0x1776, 0x2eec, 0x199b, 0x3336, 0x222f, 0x001d, 0x003a, 0x0074, 0x00e8, 0x01d0,
        0x03a0, 0x0740, 0x0e80, 0x1d00, 0x3a00, 0x3043, 0x24c5, 0x0dc9, 0x1b92, 0x3724, 0x2a0b, 0x1055, 0x20aa, 0x0517, 0x0a2e, 0x145c,
        0x28b8, 0x1533, 0x2a66, 0x108f, 0x211e, 0x067f, 0x0cfe, 0x19fc, 0x33f8, 0x23b3, 0x0325, 0x064a, 0x0c94, 0x1928, 0x3250, 0x20e3,
        0x0585, 0x0b0a, 0x1614, 0x2c28, 0x1c13, 0x3826, 0x340f, 0x2c5d, 0x1cf9, 0x39f2, 0x37a7, 0x2b0d, 0x1259, 0x24b2, 0x0d27, 0x1a4e,
        0x349c, 0x2d7b, 0x1eb5, 0x3d6a, 0x3e97, 0x396d, 0x3699, 0x2971, 0x16a1, 0x2d42, 0x1ec7, 0x3d8e, 0x3f5f, 0x3afd, 0x31b9, 0x2731,
        0x0a21, 0x1442, 0x2884, 0x154b, 0x2a96, 0x116f, 0x22de, 0x01ff, 0x03fe, 0x07fc, 0x0ff8, 0x1ff0, 0x3fe0, 0x3b83, 0x3345, 0x22c9,
        0x01d1, 0x03a2, 0x0744, 0x0e88, 0x1d10, 0x3a20, 0x3003, 0x2445, 0x0cc9, 0x1992, 0x3324, 0x220b, 0x0055, 0x00aa, 0x0154, 0x02a8,
        0x0550, 0x0aa0, 0x1540, 0x2a80, 0x1143, 0x2286, 0x014f, 0x029e, 0x053c, 0x0a78, 0x14f0, 0x29e0, 0x1783, 0x2f06, 0x1a4f, 0x349e,
        0x2d7f, 0x1ebd, 0x3d7a, 0x3eb7, 0x392d, 0x3619, 0x2871, 0x14a1, 0x2942, 0x16c7, 0x2d8e, 0x1f5f, 0x3ebe, 0x393f, 0x363d, 0x2839,
        0x1431, 0x2862, 0x1487, 0x290e, 0x165f, 0x2cbe, 0x1d3f, 0x3a7e, 0x30bf, 0x253d, 0x0e39, 0x1c72, 0x38e4, 0x358b, 0x2f55, 0x1ae9,
        0x35d2, 0x2fe7, 0x1b8d, 0x371a, 0x2a77, 0x10ad, 0x215a, 0x06f7, 0x0dee, 0x1bdc, 0x37b8, 0x2b33, 0x1225, 0x244a, 0x0cd7, 0x19ae,
        0x335c, 0x22fb, 0x01b5, 0x036a, 0x06d4, 0x0da8, 0x1b50, 0x36a0, 0x2903, 0x1645, 0x2c8a, 0x1d57, 0x3aae, 0x311f, 0x267d, 0x08b9,
        0x1172, 0x22e4, 0x018b, 0x0316, 0x062c, 0x0c58, 0x18b0, 0x3160, 0x2683, 0x0945, 0x128a, 0x2514, 0x0e6b, 0x1cd6, 0x39ac, 0x371b,
        0x2a75, 0x10a9, 0x2152, 0x06e7, 0x0dce, 0x1b9c, 0x3738, 0x2a33, 0x1025, 0x204a, 0x04d7, 0x09ae, 0x135c, 0x26b8, 0x0933, 0x1266,
        0x24cc, 0x0ddb, 0x1bb6, 0x376c, 0x2a9b, 0x1175, 0x22ea, 0x0197, 0x032e, 0x065c, 0x0cb8, 0x1970, 0x32e0, 0x2183, 0x0745, 0x0e8a,
        0x1d14, 0x3a28, 0x3013, 0x2465, 0x0c89, 0x1912, 0x3224, 0x200b, 0x0455, 0x08aa, 0x1154, 0x22a8, 0x0113, 0x0226, 0x044c, 0x0898,
        0x1130, 0x2260, 0x0083, 0x0106, 0x020c, 0x0418, 0x0830, 0x1060, 0x20c0, 0x05c3, 0x0b86, 0x170c, 0x2e18, 0x1873, 0x30e6, 0x258f,
        0x0f5d, 0x1eba, 0x3d74, 0x3eab, 0x3915, 0x3669, 0x2891, 0x1561, 0x2ac2, 0x11c7, 0x238e, 0x035f, 0x06be, 0x0d7c, 0x1af8, 0x35f0,
        0x2fa3, 0x1b05, 0x360a, 0x2857, 0x14ed, 0x29da, 0x17f7, 0x2fee, 0x1b9f, 0x373e, 0x2a3f, 0x103d, 0x207a, 0x04b7, 0x096e, 0x12dc,
        0x25b8, 0x0f33, 0x1e66, 0x3ccc, 0x3ddb, 0x3ff5, 0x3ba9, 0x3311, 0x2261, 0x0081, 0x0102, 0x0204, 0x0408, 0x0810, 0x1020, 0x2040,
        0x04c3, 0x0986, 0x130c, 0x2618, 0x0873, 0x10e6, 0x21cc, 0x07db, 0x0fb6, 0x1f6c, 0x3ed8, 0x39f3, 0x37a5, 0x2b09, 0x1251, 0x24a2,
        0x0d07, 0x1a0e, 0x341c, 0x2c7b, 0x1cb5, 0x396a, 0x3697, 0x296d, 0x1699, 0x2d32, 0x1e27, 0x3c4e, 0x3cdf, 0x3dfd, 0x3fb9, 0x3b31,
        0x3221, 0x2001, 0x0441, 0x0882, 0x1104, 0x2208, 0x0053, 0x00a6, 0x014c, 0x0298, 0x0530, 0x0a60, 0x14c0, 0x2980, 0x1743, 0x2e86,
        0x194f, 0x329e, 0x217f, 0x06bd, 0x0d7a, 0x1af4, 0x35e8, 0x2f93, 0x1b65, 0x36ca, 0x29d7, 0x17ed, 0x2fda, 0x1bf7, 0x37ee, 0x2b9f,
        0x137d, 0x26fa, 0x09b7, 0x136e, 0x26dc, 0x09fb, 0x13f6, 0x27ec, 0x0b9b, 0x1736, 0x2e6c, 0x189b, 0x3136, 0x262f, 0x081d, 0x103a,
        0x2074, 0x04ab, 0x0956, 0x12ac, 0x2558, 0x0ef3, 0x1de6, 0x3bcc, 0x33db, 0x23f5, 0x03a9, 0x0752, 0x0ea4, 0x1d48, 0x3a90, 0x3163,
        0x2685, 0x0949, 0x1292, 0x2524, 0x0e0b, 0x1c16, 0x382c, 0x341b, 0x2c75, 0x1ca9, 0x3952, 0x36e7, 0x298d, 0x1759, 0x2eb2, 0x1927,
        0x324e, 0x20df, 0x05fd, 0x0bfa, 0x17f4, 0x2fe8, 0x1b93, 0x3726, 0x2a0f, 0x105d, 0x20ba, 0x0537, 0x0a6e, 0x14dc, 0x29b8, 0x1733,
        0x2e66, 0x188f, 0x311e, 0x267f, 0x08bd, 0x117a, 0x22f4, 0x01ab, 0x0356, 0x06ac, 0x0d58, 0x1ab0, 0x3560, 0x2e83, 0x1945, 0x328a,
        0x2157, 0x06ed, 0x0dda, 0x1bb4, 0x3768, 0x2a93, 0x1165, 0x22ca, 0x01d7, 0x03ae, 0x075c, 0x0eb8, 0x1d70, 0x3ae0, 0x3183, 0x2745,
        0x0ac9, 0x1592, 0x2b24, 0x120b, 0x2416, 0x0c6f, 0x18de, 0x31bc, 0x273b, 0x0a35, 0x146a, 0x28d4, 0x15eb, 0x2bd6, 0x13ef, 0x27de,
        0x0bff, 0x17fe, 0x2ffc, 0x1bbb, 0x3776, 0x2aaf, 0x111d, 0x223a, 0x0037, 0x006e, 0x00dc, 0x01b8, 0x0370, 0x06e0, 0x0dc0, 0x1b80,
        0x3700, 0x2a43, 0x10c5, 0x218a, 0x0757, 0x0eae, 0x1d5c, 0x3ab8, 0x3133, 0x2625, 0x0809, 0x1012, 0x2024, 0x040b, 0x0816, 0x102c,
        0x2058, 0x04f3, 0x09e6, 0x13cc, 0x2798, 0x0b73, 0x16e6, 0x2dcc, 0x1fdb, 0x3fb6, 0x3b2f, 0x321d, 0x2079, 0x04b1, 0x0962, 0x12c4,
        0x2588, 0x0f53, 0x1ea6, 0x3d4c, 0x3edb, 0x39f5, 0x37a9, 0x2b11, 0x1261, 0x24c2, 0x0dc7, 0x1b8e, 0x371c, 0x2a7b, 0x10b5, 0x216a,
        0x0697, 0x0d2e, 0x1a5c, 0x34b8, 0x2d33, 0x1e25, 0x3c4a, 0x3cd7, 0x3ded, 0x3f99, 0x3b71, 0x32a1, 0x2101, 0x0641, 0x0c82, 0x1904,
        0x3208, 0x2053, 0x04e5, 0x09ca, 0x1394, 0x2728, 0x0a13, 0x1426, 0x284c, 0x14db, 0x29b6, 0x172f, 0x2e5e, 0x18ff, 0x31fe, 0x27bf,
        0x0b3d, 0x167a, 0x2cf4, 0x1dab, 0x3b56, 0x32ef, 0x219d, 0x0779, 0x0ef2, 0x1de4, 0x3bc8, 0x33d3, 0x23e5, 0x0389, 0x0712, 0x0e24,
        0x1c48, 0x3890, 0x3563, 0x2e85, 0x1949, 0x3292, 0x2167, 0x068d, 0x0d1a, 0x1a34, 0x3468, 0x2c93, 0x1d65, 0x3aca, 0x31d7, 0x27ed,
        0x0b99, 0x1732, 0x2e64, 0x188b, 0x3116, 0x266f, 0x089d, 0x113a, 0x2274, 0x00ab, 0x0156, 0x02ac, 0x0558, 0x0ab0, 0x1560, 0x2ac0,
        0x11c3, 0x2386, 0x034f, 0x069e, 0x0d3c, 0x1a78, 0x34f0, 0x2da3, 0x1f05, 0x3e0a, 0x3857, 0x34ed, 0x2d99, 0x1f71, 0x3ee2, 0x3987,
        0x374d, 0x2ad9, 0x11f1, 0x23e2, 0x0387, 0x070e, 0x0e1c, 0x1c38, 0x3870, 0x34a3, 0x2d05, 0x1e49, 0x3c92, 0x3d67, 0x3e8d, 0x3959,
        0x36f1, 0x29a1, 0x1701, 0x2e02, 0x1847, 0x308e, 0x255f, 0x0efd, 0x1dfa, 0x3bf4, 0x33ab, 0x2315, 0x0269, 0x04d2, 0x09a4, 0x1348,
        0x2690, 0x0963, 0x12c6, 0x258c, 0x0f5b, 0x1eb6, 0x3d6c, 0x3e9b, 0x3975, 0x36a9, 0x2911, 0x1661, 0x2cc2, 0x1dc7, 0x3b8e, 0x335f,
        0x22fd, 0x01b9, 0x0372, 0x06e4, 0x0dc8, 0x1b90, 0x3720, 0x2a03, 0x1045, 0x208a, 0x0557, 0x0aae, 0x155c, 0x2ab8, 0x1133, 0x2266,
        0x008f, 0x011e, 0x023c, 0x0478, 0x08f0, 0x11e0, 0x23c0, 0x03c3, 0x0786, 0x0f0c, 0x1e18, 0x3c30, 0x3c23, 0x3c05, 0x3c49, 0x3cd1,
        0x3de1, 0x3f81, 0x3b41, 0x32c1, 0x21c1, 0x07c1, 0x0f82, 0x1f04, 0x3e08, 0x3853, 0x34e5, 0x2d89, 0x1f51, 0x3ea2, 0x3907, 0x364d,
        0x28d9, 0x15f1, 0x2be2, 0x1387, 0x270e, 0x0a5f, 0x14be, 0x297c, 0x16bb, 0x2d76, 0x1eaf, 0x3d5e, 0x3eff, 0x39bd, 0x3739, 0x2a31,
        0x1021, 0x2042, 0x04c7, 0x098e, 0x131c, 0x2638, 0x0833, 0x1066, 0x20cc, 0x05db, 0x0bb6, 0x176c, 0x2ed8, 0x19f3, 0x33e6, 0x238f,
        0x035d, 0x06ba, 0x0d74, 0x1ae8, 0x35d0, 0x2fe3, 0x1b85, 0x370a, 0x2a57, 0x10ed, 0x21da, 0x07f7, 0x0fee, 0x1fdc, 0x3fb8, 0x3b33,
        0x3225, 0x2009, 0x0451, 0x08a2, 0x1144, 0x2288, 0x0153, 0x02a6, 0x054c, 0x0a98, 0x1530, 0x2a60, 0x1083, 0x2106, 0x064f, 0x0c9e,
        0x193c, 0x3278, 0x20b3, 0x0525, 0x0a4a, 0x1494, 0x2928, 0x1613, 0x2c26, 0x1c0f, 0x381e, 0x347f, 0x2cbd, 0x1d39, 0x3a72, 0x30a7,
        0x250d, 0x0e59, 0x1cb2, 0x3964, 0x368b, 0x2955, 0x16e9, 0x2dd2, 0x1fe7, 0x3fce, 0x3bdf, 0x33fd, 0x23b9, 0x0331, 0x0662, 0x0cc4,
        0x1988, 0x3310, 0x2263, 0x0085, 0x010a, 0x0214, 0x0428, 0x0850, 0x10a0, 0x2140, 0x06c3, 0x0d86, 0x1b0c, 0x3618, 0x2873, 0x14a5,
        0x294a, 0x16d7, 0x2dae, 0x1f1f, 0x3e3e, 0x383f, 0x343d, 0x2c39, 0x1c31, 0x3862, 0x3487, 0x2d4d, 0x1ed9, 0x3db2, 0x3f27, 0x3a0d,
        0x3059, 0x24f1, 0x0da1, 0x1b42, 0x3684, 0x294b, 0x16d5, 0x2daa, 0x1f17, 0x3e2e, 0x381f, 0x347d, 0x2cb9, 0x1d31, 0x3a62, 0x3087,
        0x254d, 0x0ed9, 0x1db2, 0x3b64, 0x328b, 0x2155, 0x06e9, 0x0dd2, 0x1ba4, 0x3748, 0x2ad3, 0x11e5, 0x23ca, 0x03d7, 0x07ae, 0x0f5c,
        0x1eb8, 0x3d70, 0x3ea3, 0x3905, 0x3649, 0x28d1, 0x15e1, 0x2bc2, 0x13c7, 0x278e, 0x0b5f, 0x16be, 0x2d7c, 0x1ebb, 0x3d76, 0x3eaf,
        0x391d, 0x3679, 0x28b1, 0x1521, 0x2a42, 0x10c7, 0x218e, 0x075f, 0x0ebe, 0x1d7c, 0x3af8, 0x31b3, 0x2725, 0x0a09, 0x1412, 0x2824,
        0x140b, 0x2816, 0x146f, 0x28de, 0x15ff, 0x2bfe, 0x13bf, 0x277e, 0x0abf, 0x157e, 0x2afc, 0x11bb, 0x2376, 0x02af, 0x055e, 0x0abc,
        0x1578, 0x2af0, 0x11a3, 0x2346, 0x02cf, 0x059e, 0x0b3c, 0x1678, 0x2cf0, 0x1da3, 0x3b46, 0x32cf, 0x21dd, 0x07f9, 0x0ff2, 0x1fe4,
        0x3fc8, 0x3bd3, 0x33e5, 0x2389, 0x0351, 0x06a2, 0x0d44, 0x1a88, 0x3510, 0x2e63, 0x1885, 0x310a, 0x2657, 0x08ed, 0x11da, 0x23b4,
        0x032b, 0x0656, 0x0cac, 0x1958, 0x32b0, 0x2123, 0x0605, 0x0c0a, 0x1814, 0x3028, 0x2413, 0x0c65, 0x18ca, 0x3194, 0x276b, 0x0a95,
        0x152a, 0x2a54, 0x10eb, 0x21d6, 0x07ef, 0x0fde, 0x1fbc, 0x3f78, 0x3ab3, 0x3125, 0x2609, 0x0851, 0x10a2, 0x2144, 0x06cb, 0x0d96,
        0x1b2c, 0x3658, 0x28f3, 0x15a5, 0x2b4a, 0x12d7, 0x25ae, 0x0f1f, 0x1e3e, 0x3c7c, 0x3cbb, 0x3d35, 0x3e29, 0x3811, 0x3461, 0x2c81,
        0x1d41, 0x3a82, 0x3147, 0x26cd, 0x09d9, 0x13b2, 0x2764, 0x0a8b, 0x1516, 0x2a2c, 0x101b, 0x2036, 0x042f, 0x085e, 0x10bc, 0x2178,
        0x06b3, 0x0d66, 0x1acc, 0x3598, 0x2f73, 0x1aa5, 0x354a, 0x2ed7, 0x19ed, 0x33da, 0x23f7, 0x03ad, 0x075a, 0x0eb4, 0x1d68, 0x3ad0,
        0x31e3, 0x2785, 0x0b49, 0x1692, 0x2d24, 0x1e0b, 0x3c16, 0x3c6f, 0x3c9d, 0x3d79, 0x3eb1, 0x3921, 0x3601, 0x2841, 0x14c1, 0x2982,
        0x1747, 0x2e8e, 0x195f, 0x32be, 0x213f, 0x063d, 0x0c7a, 0x18f4, 0x31e8, 0x2793, 0x0b65, 0x16ca, 0x2d94, 0x1f6b, 0x3ed6, 0x39ef,
        0x379d, 0x2b79, 0x12b1, 0x2562, 0x0e87, 0x1d0e, 0x3a1c, 0x307b, 0x24b5, 0x0d29, 0x1a52, 0x34a4, 0x2d0b, 0x1e55, 0x3caa, 0x3d17,
        0x3e6d, 0x3899, 0x3571, 0x2ea1, 0x1901, 0x3202, 0x2047, 0x04cd, 0x099a, 0x1334, 0x2668, 0x0893, 0x1126, 0x224c, 0x00db, 0x01b6,
        0x036c, 0x06d8, 0x0db0, 0x1b60, 0x36c0, 0x29c3, 0x17c5, 0x2f8a, 0x1b57, 0x36ae, 0x291f, 0x167d, 0x2cfa, 0x1db7, 0x3b6e, 0x329f,
        0x217d, 0x06b9, 0x0d72, 0x1ae4, 0x35c8, 0x2fd3, 0x1be5, 0x37ca, 0x2bd7, 0x13ed, 0x27da, 0x0bf7, 0x17ee, 0x2fdc, 0x1bfb, 0x37f6,
        0x2baf, 0x131d, 0x263a, 0x0837, 0x106e, 0x20dc, 0x05fb, 0x0bf6, 0x17ec, 0x2fd8, 0x1bf3, 0x37e6, 0x2b8f, 0x135d, 0x26ba, 0x0937,
        0x126e, 0x24dc, 0x0dfb, 0x1bf6, 0x37ec, 0x2b9b, 0x1375, 0x26ea, 0x0997, 0x132e, 0x265c, 0x08fb, 0x11f6, 0x23ec, 0x039b, 0x0736,
        0x0e6c, 0x1cd8, 0x39b0, 0x3723, 0x2a05, 0x1049, 0x2092, 0x0567, 0x0ace, 0x159c, 0x2b38, 0x1233, 0x2466, 0x0c8f, 0x191e, 0x323c,
        0x203b, 0x0435, 0x086a, 0x10d4, 0x21a8, 0x0713, 0x0e26, 0x1c4c, 0x3898, 0x3573, 0x2ea5, 0x1909, 0x3212, 0x2067, 0x048d, 0x091a,
        0x1234, 0x2468, 0x0c93, 0x1926, 0x324c, 0x20db, 0x05f5, 0x0bea, 0x17d4, 0x2fa8, 0x1b13, 0x3626, 0x280f, 0x145d, 0x28ba, 0x1537,
        0x2a6e, 0x109f, 0x213e, 0x063f, 0x0c7e, 0x18fc, 0x31f8, 0x27b3, 0x0b25, 0x164a, 0x2c94, 0x1d6b, 0x3ad6, 0x31ef, 0x279d, 0x0b79,
        0x16f2, 0x2de4, 0x1f8b, 0x3f16, 0x3a6f, 0x309d, 0x2579, 0x0eb1, 0x1d62, 0x3ac4, 0x31cb, 0x27d5, 0x0be9, 0x17d2, 0x2fa4, 0x1b0b,
        0x3616, 0x286f, 0x149d, 0x293a, 0x1637, 0x2c6e, 0x1c9f, 0x393e, 0x363f, 0x283d, 0x1439, 0x2872, 0x14a7, 0x294e, 0x16df, 0x2dbe,
        0x1f3f, 0x3e7e, 0x38bf, 0x353d, 0x2e39, 0x1831, 0x3062, 0x2487, 0x0d4d, 0x1a9a, 0x3534, 0x2e2b, 0x1815, 0x302a, 0x2417, 0x0c6d,
        0x18da, 0x31b4, 0x272b, 0x0a15, 0x142a, 0x2854, 0x14eb, 0x29d6, 0x17ef, 0x2fde, 0x1bff, 0x37fe, 0x2bbf, 0x133d, 0x267a, 0x08b7,
        0x116e, 0x22dc, 0x01fb, 0x03f6, 0x07ec, 0x0fd8, 0x1fb0, 0x3f60, 0x3a83, 0x3145, 0x26c9, 0x09d1, 0x13a2, 0x2744, 0x0acb, 0x1596,
        0x2b2c, 0x121b, 0x2436, 0x0c2f, 0x185e, 0x30bc, 0x253b, 0x0e35, 0x1c6a, 0x38d4, 0x35eb, 0x2f95, 0x1b69, 0x36d2, 0x29e7, 0x178d,
        0x2f1a, 0x1a77, 0x34ee, 0x2d9f, 0x1f7d, 0x3efa, 0x39b7, 0x372d, 0x2a19, 0x1071, 0x20e2, 0x0587, 0x0b0e, 0x161c, 0x2c38, 0x1c33,
        0x3866, 0x348f, 0x2d5d, 0x1ef9, 0x3df2, 0x3fa7, 0x3b0d, 0x3259, 0x20f1, 0x05a1, 0x0b42, 0x1684, 0x2d08, 0x1e53, 0x3ca6, 0x3d0f,
        0x3e5d, 0x38f9, 0x35b1, 0x2f21, 0x1a01, 0x3402, 0x2c47, 0x1ccd, 0x399a, 0x3777, 0x2aad, 0x1119, 0x2232, 0x0027, 0x004e, 0x009c,
        0x0138, 0x0270, 0x04e0, 0x09c0, 0x1380, 0x2700, 0x0a43, 0x1486, 0x290c, 0x165b, 0x2cb6, 0x1d2f, 0x3a5e, 0x30ff, 0x25bd, 0x0f39,
        0x1e72, 0x3ce4, 0x3d8b, 0x3f55, 0x3ae9, 0x3191, 0x2761, 0x0a81, 0x1502, 0x2a04, 0x104b, 0x2096, 0x056f, 0x0ade, 0x15bc, 0x2b78,
        0x12b3, 0x2566, 0x0e8f, 0x1d1e, 0x3a3c, 0x303b, 0x2435, 0x0c29, 0x1852, 0x30a4, 0x250b, 0x0e55, 0x1caa, 0x3954, 0x36eb, 0x2995,
        0x1769, 0x2ed2, 0x19e7, 0x33ce, 0x23df, 0x03fd, 0x07fa, 0x0ff4, 0x1fe8, 0x3fd0, 0x3be3, 0x3385, 0x2349, 0x02d1, 0x05a2, 0x0b44,
        0x1688, 0x2d10, 0x1e63, 0x3cc6, 0x3dcf, 0x3fdd, 0x3bf9, 0x33b1, 0x2321, 0x0201, 0x0402, 0x0804, 0x1008, 0x2010, 0x0463, 0x08c6,
        0x118c, 0x2318, 0x0273, 0x04e6, 0x09cc, 0x1398, 0x2730, 0x0a23, 0x1446, 0x288c, 0x155b, 0x2ab6, 0x112f, 0x225e, 0x00ff, 0x01fe,
        0x03fc, 0x07f8, 0x0ff0, 0x1fe0, 0x3fc0, 0x3bc3, 0x33c5, 0x23c9, 0x03d1, 0x07a2, 0x0f44, 0x1e88, 0x3d10, 0x3e63, 0x3885, 0x3549,
        0x2ed1, 0x19e1, 0x33c2, 0x23c7, 0x03cd, 0x079a, 0x0f34, 0x1e68, 0x3cd0, 0x3de3, 0x3f85, 0x3b49, 0x32d1, 0x21e1, 0x0781, 0x0f02,
        0x1e04, 0x3c08, 0x3c53, 0x3ce5, 0x3d89, 0x3f51, 0x3ae1, 0x3181, 0x2741, 0x0ac1, 0x1582, 0x2b04, 0x124b, 0x2496, 0x0d6f, 0x1ade,
        0x35bc, 0x2f3b, 0x1a35, 0x346a, 0x2c97, 0x1d6d, 0x3ada, 0x31f7, 0x27ad, 0x0b19, 0x1632, 0x2c64, 0x1c8b, 0x3916, 0x366f, 0x289d,
        0x1579, 0x2af2, 0x11a7, 0x234e, 0x02df, 0x05be, 0x0b7c, 0x16f8, 0x2df0, 0x1fa3, 0x3f46, 0x3acf, 0x31dd, 0x27f9, 0x0bb1, 0x1762,
        0x2ec4, 0x19cb, 0x3396, 0x236f, 0x029d, 0x053a, 0x0a74, 0x14e8, 0x29d0, 0x17e3, 0x2fc6, 0x1bcf, 0x379e, 0x2b7f, 0x12bd, 0x257a,
        0x0eb7, 0x1d6e, 0x3adc, 0x31fb, 0x27b5, 0x0b29, 0x1652, 0x2ca4, 0x1d0b, 0x3a16, 0x306f, 0x249d, 0x0d79, 0x1af2, 0x35e4, 0x2f8b,
        0x1b55, 0x36aa, 0x2917, 0x166d, 0x2cda, 0x1df7, 0x3bee, 0x339f, 0x237d, 0x02b9, 0x0572, 0x0ae4, 0x15c8, 0x2b90, 0x1363, 0x26c6,
        0x09cf, 0x139e, 0x273c, 0x0a3b, 0x1476, 0x28ec, 0x159b, 0x2b36, 0x122f, 0x245e, 0x0cff, 0x19fe, 0x33fc, 0x23bb, 0x0335, 0x066a,
        0x0cd4, 0x19a8, 0x3350, 0x22e3, 0x0185, 0x030a, 0x0614, 0x0c28, 0x1850, 0x30a0, 0x2503, 0x0e45, 0x1c8a, 0x3914, 0x366b, 0x2895,
        0x1569, 0x2ad2, 0x11e7, 0x23ce, 0x03df, 0x07be, 0x0f7c, 0x1ef8, 0x3df0, 0x3fa3, 0x3b05, 0x3249, 0x20d1, 0x05e1, 0x0bc2, 0x1784,
        0x2f08, 0x1a53, 0x34a6, 0x2d0f, 0x1e5d, 0x3cba, 0x3d37, 0x3e2d, 0x3819, 0x3471, 0x2ca1, 0x1d01, 0x3a02, 0x3047, 0x24cd, 0x0dd9,
        0x1bb2, 0x3764, 0x2a8b, 0x1155, 0x22aa, 0x0117, 0x022e, 0x045c, 0x08b8, 0x1170, 0x22e0, 0x0183, 0x0306, 0x060c, 0x0c18, 0x1830,
        0x3060, 0x2483, 0x0d45, 0x1a8a, 0x3514, 0x2e6b, 0x1895, 0x312a, 0x2617, 0x086d, 0x10da, 0x21b4, 0x072b, 0x0e56, 0x1cac, 0x3958,
        0x36f3, 0x29a5, 0x1709, 0x2e12, 0x1867, 0x30ce, 0x25df, 0x0ffd, 0x1ffa, 0x3ff4, 0x3bab, 0x3315, 0x2269, 0x0091, 0x0122, 0x0244,
        0x0488, 0x0910, 0x1220, 0x2440, 0x0cc3, 0x1986, 0x330c, 0x225b, 0x00f5, 0x01ea, 0x03d4, 0x07a8, 0x0f50, 0x1ea0, 0x3d40, 0x3ec3,
        0x39c5, 0x37c9, 0x2bd1, 0x13e1, 0x27c2, 0x0bc7, 0x178e, 0x2f1c, 0x1a7b, 0x34f6, 0x2daf, 0x1f1d, 0x3e3a, 0x3837, 0x342d, 0x2c19,
        0x1c71, 0x38e2, 0x3587, 0x2f4d, 0x1ad9, 0x35b2, 0x2f27, 0x1a0d, 0x341a, 0x2c77, 0x1cad, 0x395a, 0x36f7, 0x29ad, 0x1719, 0x2e32,
        0x1827, 0x304e, 0x24df, 0x0dfd, 0x1bfa, 0x37f4, 0x2bab, 0x1315, 0x262a, 0x0817, 0x102e, 0x205c, 0x04fb, 0x09f6, 0x13ec, 0x27d8,
        0x0bf3, 0x17e6, 0x2fcc, 0x1bdb, 0x37b6, 0x2b2f, 0x121d, 0x243a, 0x0c37, 0x186e, 0x30dc, 0x25fb, 0x0fb5, 0x1f6a, 0x3ed4, 0x39eb,
        0x3795, 0x2b69, 0x1291, 0x2522, 0x0e07, 0x1c0e, 0x381c, 0x347b, 0x2cb5, 0x1d29, 0x3a52, 0x30e7, 0x258d, 0x0f59, 0x1eb2, 0x3d64,
        0x3e8b, 0x3955, 0x36e9, 0x2991, 0x1761, 0x2ec2, 0x19c7, 0x338e, 0x235f, 0x02fd, 0x05fa, 0x0bf4, 0x17e8, 0x2fd0, 0x1be3, 0x37c6,
        0x2bcf, 0x13dd, 0x27ba, 0x0b37, 0x166e, 0x2cdc, 0x1dfb, 0x3bf6, 0x33af, 0x231d, 0x0279, 0x04f2, 0x09e4, 0x13c8, 0x2790, 0x0b63,
        0x16c6, 0x2d8c, 0x1f5b, 0x3eb6, 0x392f, 0x361d, 0x2879, 0x14b1, 0x2962, 0x1687, 0x2d0e, 0x1e5f, 0x3cbe, 0x3d3f, 0x3e3d, 0x3839,
        0x3431, 0x2c21, 0x1c01, 0x3802, 0x3447, 0x2ccd, 0x1dd9, 0x3bb2, 0x3327, 0x220d, 0x0059, 0x00b2, 0x0164, 0x02c8, 0x0590, 0x0b20,
        0x1640, 0x2c80, 0x1d43, 0x3a86, 0x314f, 0x26dd, 0x09f9, 0x13f2, 0x27e4, 0x0b8b, 0x1716, 0x2e2c, 0x181b, 0x3036, 0x242f, 0x0c1d,
        0x183a, 0x3074, 0x24ab, 0x0d15, 0x1a2a, 0x3454, 0x2ceb, 0x1d95, 0x3b2a, 0x3217, 0x206d, 0x0499, 0x0932, 0x1264, 0x24c8, 0x0dd3,
        0x1ba6, 0x374c, 0x2adb, 0x11f5, 0x23ea, 0x0397, 0x072e, 0x0e5c, 0x1cb8, 0x3970, 0x36a3, 0x2905, 0x1649, 0x2c92, 0x1d67, 0x3ace,
        0x31df, 0x27fd, 0x0bb9, 0x1772, 0x2ee4, 0x198b, 0x3316, 0x226f, 0x009d, 0x013a, 0x0274, 0x04e8, 0x09d0, 0x13a0, 0x2740, 0x0ac3,
        0x1586, 0x2b0c, 0x125b, 0x24b6, 0x0d2f, 0x1a5e, 0x34bc, 0x2d3b, 0x1e35, 0x3c6a, 0x3c97, 0x3d6d, 0x3e99, 0x3971, 0x36a1, 0x2901,
        0x1641, 0x2c82, 0x1d47, 0x3a8e, 0x315f, 0x26fd, 0x09b9, 0x1372, 0x26e4, 0x098b, 0x1316, 0x262c, 0x081b, 0x1036, 0x206c, 0x049b,
        0x0936, 0x126c, 0x24d8, 0x0df3, 0x1be6, 0x37cc, 0x2bdb, 0x13f5, 0x27ea, 0x0b97, 0x172e, 0x2e5c, 0x18fb, 0x31f6, 0x27af, 0x0b1d,
        0x163a, 0x2c74, 0x1cab, 0x3956, 0x36ef, 0x299d, 0x1779, 0x2ef2, 0x19a7, 0x334e, 0x22df, 0x01fd, 0x03fa, 0x07f4, 0x0fe8, 0x1fd0,
        0x3fa0, 0x3b03, 0x3245, 0x20c9, 0x05d1, 0x0ba2, 0x1744, 0x2e88, 0x1953, 0x32a6, 0x210f, 0x065d, 0x0cba, 0x1974, 0x32e8, 0x2193,
        0x0765, 0x0eca, 0x1d94, 0x3b28, 0x3213, 0x2065, 0x0489, 0x0912, 0x1224, 0x2448, 0x0cd3, 0x19a6, 0x334c, 0x22db, 0x01f5, 0x03ea,
        0x07d4, 0x0fa8, 0x1f50, 0x3ea0, 0x3903, 0x3645, 0x28c9, 0x15d1, 0x2ba2, 0x1307, 0x260e, 0x085f, 0x10be, 0x217c, 0x06bb, 0x0d76,
        0x1aec, 0x35d8, 0x2ff3, 0x1ba5, 0x374a, 0x2ad7, 0x11ed, 0x23da, 0x03f7, 0x07ee, 0x0fdc, 0x1fb8, 0x3f70, 0x3aa3, 0x3105, 0x2649,
        0x08d1, 0x11a2, 0x2344, 0x02cb, 0x0596, 0x0b2c, 0x1658, 0x2cb0, 0x1d23, 0x3a46, 0x30cf, 0x25dd, 0x0ff9, 0x1ff2, 0x3fe4, 0x3b8b,
        0x3355, 0x22e9, 0x0191, 0x0322, 0x0644, 0x0c88, 0x1910, 0x3220, 0x2003, 0x0445, 0x088a, 0x1114, 0x2228, 0x0013, 0x0026, 0x004c,
        0x0098, 0x0130, 0x0260, 0x04c0, 0x0980, 0x1300, 0x2600, 0x0843, 0x1086, 0x210c, 0x065b, 0x0cb6, 0x196c, 0x32d8, 0x21f3, 0x07a5,
        0x0f4a, 0x1e94, 0x3d28, 0x3e13, 0x3865, 0x3489, 0x2d51, 0x1ee1, 0x3dc2, 0x3fc7, 0x3bcd, 0x33d9, 0x23f1, 0x03a1, 0x0742, 0x0e84,
        0x1d08, 0x3a10, 0x3063, 0x2485, 0x0d49, 0x1a92, 0x3524, 0x2e0b, 0x1855, 0x30aa, 0x2517, 0x0e6d, 0x1cda, 0x39b4, 0x372b, 0x2a15,
        0x1069, 0x20d2, 0x05e7, 0x0bce, 0x179c, 0x2f38, 0x1a33, 0x3466, 0x2c8f, 0x1d5d, 0x3aba, 0x3137, 0x262d, 0x0819, 0x1032, 0x2064,
        0x048b, 0x0916, 0x122c, 0x2458, 0x0cf3, 0x19e6, 0x33cc, 0x23db, 0x03f5, 0x07ea, 0x0fd4, 0x1fa8, 0x3f50, 0x3ae3, 0x3185, 0x2749,
        0x0ad1, 0x15a2, 0x2b44, 0x12cb, 0x2596, 0x0f6f, 0x1ede, 0x3dbc, 0x3f3b, 0x3a35, 0x3029, 0x2411, 0x0c61, 0x18c2, 0x3184, 0x274b,
        0x0ad5, 0x15aa, 0x2b54, 0x12eb, 0x25d6, 0x0fef, 0x1fde, 0x3fbc, 0x3b3b, 0x3235, 0x2029, 0x0411, 0x0822, 0x1044, 0x2088, 0x0553,
        0x0aa6, 0x154c, 0x2a98, 0x1173, 0x22e6, 0x018f, 0x031e, 0x063c, 0x0c78, 0x18f0, 0x31e0, 0x2783, 0x0b45, 0x168a, 0x2d14, 0x1e6b,
        0x3cd6, 0x3def, 0x3f9d, 0x3b79, 0x32b1, 0x2121, 0x0601, 0x0c02, 0x1804, 0x3008, 0x2453, 0x0ce5, 0x19ca, 0x3394, 0x236b, 0x0295,
        0x052a, 0x0a54, 0x14a8, 0x2950, 0x16e3, 0x2dc6, 0x1fcf, 0x3f9e, 0x3b7f, 0x32bd, 0x2139, 0x0631, 0x0c62, 0x18c4, 0x3188, 0x2753,
        0x0ae5, 0x15ca, 0x2b94, 0x136b, 0x26d6, 0x09ef, 0x13de, 0x27bc, 0x0b3b, 0x1676, 0x2cec, 0x1d9b, 0x3b36, 0x322f, 0x201d, 0x0479,
        0x08f2, 0x11e4, 0x23c8, 0x03d3, 0x07a6, 0x0f4c, 0x1e98, 0x3d30, 0x3e23, 0x3805, 0x3449, 0x2cd1, 0x1de1, 0x3bc2, 0x33c7, 0x23cd,
        0x03d9, 0x07b2, 0x0f64, 0x1ec8, 0x3d90, 0x3f63, 0x3a85, 0x3149, 0x26d1, 0x09e1, 0x13c2, 0x2784, 0x0b4b, 0x1696, 0x2d2c, 0x1e1b,
        0x3c36, 0x3c2f, 0x3c1d, 0x3c79, 0x3cb1, 0x3d21, 0x3e01, 0x3841, 0x34c1, 0x2dc1, 0x1fc1, 0x3f82, 0x3b47, 0x32cd, 0x21d9, 0x07f1,
        0x0fe2, 0x1fc4, 0x3f88, 0x3b53, 0x32e5, 0x2189, 0x0751, 0x0ea2, 0x1d44, 0x3a88, 0x3153, 0x26e5, 0x0989, 0x1312, 0x2624, 0x080b,
        0x1016, 0x202c, 0x041b, 0x0836, 0x106c, 0x20d8, 0x05f3, 0x0be6, 0x17cc, 0x2f98, 0x1b73, 0x36e6, 0x298f, 0x175d, 0x2eba, 0x1937,
        0x326e, 0x209f, 0x057d, 0x0afa, 0x15f4, 0x2be8, 0x1393, 0x2726, 0x0a0f, 0x141e, 0x283c, 0x143b, 0x2876, 0x14af, 0x295e, 0x16ff,
        0x2dfe, 0x1fbf, 0x3f7e, 0x3abf, 0x313d, 0x2639, 0x0831, 0x1062, 0x20c4, 0x05cb, 0x0b96, 0x172c, 0x2e58, 0x18f3, 0x31e6, 0x278f,
        0x0b5d, 0x16ba, 0x2d74, 0x1eab, 0x3d56, 0x3eef, 0x399d, 0x3779, 0x2ab1, 0x1121, 0x2242, 0x00c7, 0x018e, 0x031c, 0x0638, 0x0c70,
        0x18e0, 0x31c0, 0x27c3, 0x0bc5, 0x178a, 0x2f14, 0x1a6b, 0x34d6, 0x2def, 0x1f9d, 0x3f3a, 0x3a37, 0x302d, 0x2419, 0x0c71, 0x18e2,
        0x31c4, 0x27cb, 0x0bd5, 0x17aa, 0x2f54, 0x1aeb, 0x35d6, 0x2fef, 0x1b9d, 0x373a, 0x2a37, 0x102d, 0x205a, 0x04f7, 0x09ee, 0x13dc,
        0x27b8, 0x0b33, 0x1666, 0x2ccc, 0x1ddb, 0x3bb6, 0x332f, 0x221d, 0x0079, 0x00f2, 0x01e4, 0x03c8, 0x0790, 0x0f20, 0x1e40, 0x3c80,
        0x3d43, 0x3ec5, 0x39c9, 0x37d1, 0x2be1, 0x1381, 0x2702, 0x0a47, 0x148e, 0x291c, 0x167b, 0x2cf6, 0x1daf, 0x3b5e, 0x32ff, 0x21bd,
        0x0739, 0x0e72, 0x1ce4, 0x39c8, 0x37d3, 0x2be5, 0x1389, 0x2712, 0x0a67, 0x14ce, 0x299c, 0x177b, 0x2ef6, 0x19af, 0x335e, 0x22ff,
        0x01bd, 0x037a, 0x06f4, 0x0de8, 0x1bd0, 0x37a0, 0x2b03, 0x1245, 0x248a, 0x0d57, 0x1aae, 0x355c, 0x2efb, 0x19b5, 0x336a, 0x2297,
        0x016d, 0x02da, 0x05b4, 0x0b68, 0x16d0, 0x2da0, 0x1f03, 0x3e06, 0x384f, 0x34dd, 0x2df9, 0x1fb1, 0x3f62, 0x3a87, 0x314d, 0x26d9,
        0x09f1, 0x13e2, 0x27c4, 0x0bcb, 0x1796, 0x2f2c, 0x1a1b, 0x3436, 0x2c2f, 0x1c1d, 0x383a, 0x3437, 0x2c2d, 0x1c19, 0x3832, 0x3427,
        0x2c0d, 0x1c59, 0x38b2, 0x3527, 0x2e0d, 0x1859, 0x30b2, 0x2527, 0x0e0d, 0x1c1a, 0x3834, 0x342b, 0x2c15, 0x1c69, 0x38d2, 0x35e7,
        0x2f8d, 0x1b59, 0x36b2, 0x2927, 0x160d, 0x2c1a, 0x1c77, 0x38ee, 0x359f, 0x2f7d, 0x1ab9, 0x3572, 0x2ea7, 0x190d, 0x321a, 0x2077,
        0x04ad, 0x095a, 0x12b4, 0x2568, 0x0e93, 0x1d26, 0x3a4c, 0x30db, 0x25f5, 0x0fa9, 0x1f52, 0x3ea4, 0x390b, 0x3655, 0x28e9, 0x1591,
        0x2b22, 0x1207, 0x240e, 0x0c5f, 0x18be, 0x317c, 0x26bb, 0x0935, 0x126a, 0x24d4, 0x0deb, 0x1bd6, 0x37ac, 0x2b1b, 0x1275, 0x24ea,
        0x0d97, 0x1b2e, 0x365c, 0x28fb, 0x15b5, 0x2b6a, 0x1297, 0x252e, 0x0e1f, 0x1c3e, 0x387c, 0x34bb, 0x2d35, 0x1e29, 0x3c52, 0x3ce7,
        0x3d8d, 0x3f59, 0x3af1, 0x31a1, 0x2701, 0x0a41, 0x1482, 0x2904, 0x164b, 0x2c96, 0x1d6f, 0x3ade, 0x31ff, 0x27bd, 0x0b39, 0x1672,
        0x2ce4, 0x1d8b, 0x3b16, 0x326f, 0x209d, 0x0579, 0x0af2, 0x15e4, 0x2bc8, 0x13d3, 0x27a6, 0x0b0f, 0x161e, 0x2c3c, 0x1c3b, 0x3876,
        0x34af, 0x2d1d, 0x1e79, 0x3cf2, 0x3da7, 0x3f0d, 0x3a59, 0x30f1, 0x25a1, 0x0f01, 0x1e02, 0x3c04, 0x3c4b, 0x3cd5, 0x3de9, 0x3f91,
        0x3b61, 0x3281, 0x2141, 0x06c1, 0x0d82, 0x1b04, 0x3608, 0x2853, 0x14e5, 0x29ca, 0x17d7, 0x2fae, 0x1b1f, 0x363e, 0x283f, 0x143d,
        0x287a, 0x14b7, 0x296e, 0x169f, 0x2d3e, 0x1e3f, 0x3c7e, 0x3cbf, 0x3d3d, 0x3e39, 0x3831, 0x3421, 0x2c01, 0x1c41, 0x3882, 0x3547,
        0x2ecd, 0x19d9, 0x33b2, 0x2327, 0x020d, 0x041a, 0x0834, 0x1068, 0x20d0, 0x05e3, 0x0bc6, 0x178c, 0x2f18, 0x1a73, 0x34e6, 0x2d8f,
        0x1f5d, 0x3eba, 0x3937, 0x362d, 0x2819, 0x1471, 0x28e2, 0x1587, 0x2b0e, 0x125f, 0x24be, 0x0d3f, 0x1a7e, 0x34fc, 0x2dbb, 0x1f35,
        0x3e6a, 0x3897, 0x356d, 0x2e99, 0x1971, 0x32e2, 0x2187, 0x074d, 0x0e9a, 0x1d34, 0x3a68, 0x3093, 0x2565, 0x0e89, 0x1d12, 0x3a24,
        0x300b, 0x2455, 0x0ce9, 0x19d2, 0x33a4, 0x230b, 0x0255, 0x04aa, 0x0954, 0x12a8, 0x2550, 0x0ee3, 0x1dc6, 0x3b8c, 0x335b, 0x22f5,
        0x01a9, 0x0352, 0x06a4, 0x0d48, 0x1a90, 0x3520, 0x2e03, 0x1845, 0x308a, 0x2557, 0x0eed, 0x1dda, 0x3bb4, 0x332b, 0x2215, 0x0069,
        0x00d2, 0x01a4, 0x0348, 0x0690, 0x0d20, 0x1a40, 0x3480, 0x2d43, 0x1ec5, 0x3d8a, 0x3f57, 0x3aed, 0x3199, 0x2771, 0x0aa1, 0x1542,
        0x2a84, 0x114b, 0x2296, 0x016f, 0x02de, 0x05bc, 0x0b78, 0x16f0, 0x2de0, 0x1f83, 0x3f06, 0x3a4f, 0x30dd, 0x25f9, 0x0fb1, 0x1f62,
        0x3ec4, 0x39cb, 0x37d5, 0x2be9, 0x1391, 0x2722, 0x0a07, 0x140e, 0x281c, 0x147b, 0x28f6, 0x15af, 0x2b5e, 0x12ff, 0x25fe, 0x0fbf,
        0x1f7e, 0x3efc, 0x39bb, 0x3735, 0x2a29, 0x1011, 0x2022, 0x0407, 0x080e, 0x101c, 0x2038, 0x0433, 0x0866, 0x10cc, 0x2198, 0x0773,
        0x0ee6, 0x1dcc, 0x3b98, 0x3373, 0x22a5, 0x0109, 0x0212, 0x0424, 0x0848, 0x1090, 0x2120, 0x0603, 0x0c06, 0x180c, 0x3018, 0x2473,
        0x0ca5, 0x194a, 0x3294, 0x216b, 0x0695, 0x0d2a, 0x1a54, 0x34a8, 0x2d13, 0x1e65, 0x3cca, 0x3dd7, 0x3fed, 0x3b99, 0x3371, 0x22a1,
        0x0101, 0x0202, 0x0404, 0x0808, 0x1010, 0x2020, 0x0403, 0x0806, 0x100c, 0x2018, 0x0473, 0x08e6, 0x11cc, 0x2398, 0x0373, 0x06e6,
        0x0dcc, 0x1b98, 0x3730, 0x2a23, 0x1005, 0x200a, 0x0457, 0x08ae, 0x115c, 0x22b8, 0x0133, 0x0266, 0x04cc, 0x0998, 0x1330, 0x2660,
        0x0883, 0x1106, 0x220c, 0x005b, 0x00b6, 0x016c, 0x02d8, 0x05b0, 0x0b60, 0x16c0, 0x2d80, 0x1f43, 0x3e86, 0x394f, 0x36dd, 0x29f9,
        0x17b1, 0x2f62, 0x1a87, 0x350e, 0x2e5f, 0x18fd, 0x31fa, 0x27b7, 0x0b2d, 0x165a, 0x2cb4, 0x1d2b, 0x3a56, 0x30ef, 0x259d, 0x0f79,
        0x1ef2, 0x3de4, 0x3f8b, 0x3b55, 0x32e9, 0x2191, 0x0761, 0x0ec2, 0x1d84, 0x3b08, 0x3253, 0x20e5, 0x0589, 0x0b12, 0x1624, 0x2c48,
        0x1cd3, 0x39a6, 0x370f, 0x2a5d, 0x10f9, 0x21f2, 0x07a7, 0x0f4e, 0x1e9c, 0x3d38, 0x3e33, 0x3825, 0x3409, 0x2c51, 0x1ce1, 0x39c2,
        0x37c7, 0x2bcd, 0x13d9, 0x27b2, 0x0b27, 0x164e, 0x2c9c, 0x1d7b, 0x3af6, 0x31af, 0x271d, 0x0a79, 0x14f2, 0x29e4, 0x178b, 0x2f16,
        0x1a6f, 0x34de, 0x2dff, 0x1fbd, 0x3f7a, 0x3ab7, 0x312d, 0x2619, 0x0871, 0x10e2, 0x21c4, 0x07cb, 0x0f96, 0x1f2c, 0x3e58, 0x38f3,
        0x35a5, 0x2f09, 0x1a51, 0x34a2, 0x2d07, 0x1e4d, 0x3c9a, 0x3d77, 0x3ead, 0x3919, 0x3671, 0x28a1, 0x1501, 0x2a02, 0x1047, 0x208e,
        0x055f, 0x0abe, 0x157c, 0x2af8, 0x11b3, 0x2366, 0x028f, 0x051e, 0x0a3c, 0x1478, 0x28f0, 0x15a3, 0x2b46, 0x12cf, 0x259e, 0x0f7f,
        0x1efe, 0x3dfc, 0x3fbb, 0x3b35, 0x3229, 0x2011, 0x0461, 0x08c2, 0x1184, 0x2308, 0x0253, 0x04a6, 0x094c, 0x1298, 0x2530, 0x0e23,
        0x1c46, 0x388c, 0x355b, 0x2ef5, 0x19a9, 0x3352, 0x22e7, 0x018d, 0x031a, 0x0634, 0x0c68, 0x18d0, 0x31a0, 0x2703, 0x0a45, 0x148a,
        0x2914, 0x166b, 0x2cd6, 0x1def, 0x3bde, 0x33ff, 0x23bd, 0x0339, 0x0672, 0x0ce4, 0x19c8, 0x3390, 0x2363, 0x0285, 0x050a, 0x0a14,
        0x1428, 0x2850, 0x14e3, 0x29c6, 0x17cf, 0x2f9e, 0x1b7f, 0x36fe, 0x29bf, 0x173d, 0x2e7a, 0x18b7, 0x316e, 0x269f, 0x097d, 0x12fa,
        0x25f4, 0x0fab, 0x1f56, 0x3eac, 0x391b, 0x3675, 0x28a9, 0x1511, 0x2a22, 0x1007, 0x200e, 0x045f, 0x08be, 0x117c, 0x22f8, 0x01b3,
        0x0366, 0x06cc, 0x0d98, 0x1b30, 0x3660, 0x2883, 0x1545, 0x2a8a, 0x1157, 0x22ae, 0x011f, 0x023e, 0x047c, 0x08f8, 0x11f0, 0x23e0,
        0x0383, 0x0706, 0x0e0c, 0x1c18, 0x3830, 0x3423, 0x2c05, 0x1c49, 0x3892, 0x3567, 0x2e8d, 0x1959, 0x32b2, 0x2127, 0x060d, 0x0c1a,
        0x1834, 0x3068, 0x2493, 0x0d65, 0x1aca, 0x3594, 0x2f6b, 0x1a95, 0x352a, 0x2e17, 0x186d, 0x30da, 0x25f7, 0x0fad, 0x1f5a, 0x3eb4,
        0x392b, 0x3615, 0x2869, 0x1491, 0x2922, 0x1607, 0x2c0e, 0x1c5f, 0x38be, 0x353f, 0x2e3d, 0x1839, 0x3072, 0x24a7, 0x0d0d, 0x1a1a,
        0x3434, 0x2c2b, 0x1c15, 0x382a, 0x3417, 0x2c6d, 0x1c99, 0x3932, 0x3627, 0x280d, 0x1459, 0x28b2, 0x1527, 0x2a4e, 0x10df, 0x21be,
        0x073f, 0x0e7e, 0x1cfc, 0x39f8, 0x37b3, 0x2b25, 0x1209, 0x2412, 0x0c67, 0x18ce, 0x319c, 0x277b, 0x0ab5, 0x156a, 0x2ad4, 0x11eb,
        0x23d6, 0x03ef, 0x07de, 0x0fbc, 0x1f78, 0x3ef0, 0x39a3, 0x3705, 0x2a49, 0x10d1, 0x21a2, 0x0707, 0x0e0e, 0x1c1c, 0x3838, 0x3433,
        0x2c25, 0x1c09, 0x3812, 0x3467, 0x2c8d, 0x1d59, 0x3ab2, 0x3127, 0x260d, 0x0859, 0x10b2, 0x2164, 0x068b, 0x0d16, 0x1a2c, 0x3458,
        0x2cf3, 0x1da5, 0x3b4a, 0x32d7, 0x21ed, 0x0799, 0x0f32, 0x1e64, 0x3cc8, 0x3dd3, 0x3fe5, 0x3b89, 0x3351, 0x22e1, 0x0181, 0x0302,
        0x0604, 0x0c08, 0x1810, 0x3020, 0x2403, 0x0c45, 0x188a, 0x3114, 0x266b, 0x0895, 0x112a, 0x2254, 0x00eb, 0x01d6, 0x03ac, 0x0758,
        0x0eb0, 0x1d60, 0x3ac0, 0x31c3, 0x27c5, 0x0bc9, 0x1792, 0x2f24, 0x1a0b, 0x3416, 0x2c6f, 0x1c9d, 0x393a, 0x3637, 0x282d, 0x1419,
        0x2832, 0x1427, 0x284e, 0x14df, 0x29be, 0x173f, 0x2e7e, 0x18bf, 0x317e, 0x26bf, 0x093d, 0x127a, 0x24f4, 0x0dab, 0x1b56, 0x36ac,
        0x291b, 0x1675, 0x2cea, 0x1d97, 0x3b2e, 0x321f, 0x207d, 0x04b9, 0x0972, 0x12e4, 0x25c8, 0x0fd3, 0x1fa6, 0x3f4c, 0x3adb, 0x31f5,
        0x27a9, 0x0b11, 0x1622, 0x2c44, 0x1ccb, 0x3996, 0x376f, 0x2a9d, 0x1179, 0x22f2, 0x01a7, 0x034e, 0x069c, 0x0d38, 0x1a70, 0x34e0,
        0x2d83, 0x1f45, 0x3e8a, 0x3957, 0x36ed, 0x2999, 0x1771, 0x2ee2, 0x1987, 0x330e, 0x225f, 0x00fd, 0x01fa, 0x03f4, 0x07e8, 0x0fd0,
        0x1fa0, 0x3f40, 0x3ac3, 0x31c5, 0x27c9, 0x0bd1, 0x17a2, 0x2f44, 0x1acb, 0x3596, 0x2f6f, 0x1a9d, 0x353a, 0x2e37, 0x182d, 0x305a,
        0x24f7, 0x0dad, 0x1b5a, 0x36b4, 0x292b, 0x1615, 0x2c2a, 0x1c17, 0x382e, 0x341f, 0x2c7d, 0x1cb9, 0x3972, 0x36a7, 0x290d, 0x1659,
        0x2cb2, 0x1d27, 0x3a4e, 0x30df, 0x25fd, 0x0fb9, 0x1f72, 0x3ee4, 0x398b, 0x3755, 0x2ae9, 0x1191, 0x2322, 0x0207, 0x040e, 0x081c,
        0x1038, 0x2070, 0x04a3, 0x0946, 0x128c, 0x2518, 0x0e73, 0x1ce6, 0x39cc, 0x37db, 0x2bf5, 0x13a9, 0x2752, 0x0ae7, 0x15ce, 0x2b9c,
        0x137b, 0x26f6, 0x09af, 0x135e, 0x26bc, 0x093b, 0x1276, 0x24ec, 0x0d9b, 0x1b36, 0x366c, 0x289b, 0x1575, 0x2aea, 0x1197, 0x232e,
        0x021f, 0x043e, 0x087c, 0x10f8, 0x21f0, 0x07a3, 0x0f46, 0x1e8c, 0x3d18, 0x3e73, 0x38a5, 0x3509, 0x2e51, 0x18e1, 0x31c2, 0x27c7,
        0x0bcd, 0x179a, 0x2f34, 0x1a2b, 0x3456, 0x2cef, 0x1d9d, 0x3b3a, 0x3237, 0x202d, 0x0419, 0x0832, 0x1064, 0x20c8, 0x05d3, 0x0ba6,
        0x174c, 0x2e98, 0x1973, 0x32e6, 0x218f, 0x075d, 0x0eba, 0x1d74, 0x3ae8, 0x3193, 0x2765, 0x0a89, 0x1512, 0x2a24, 0x100b, 0x2016,
        0x046f, 0x08de, 0x11bc, 0x2378, 0x02b3, 0x0566, 0x0acc, 0x1598, 0x2b30, 0x1223, 0x2446, 0x0ccf, 0x199e, 0x333c, 0x223b, 0x0035,
        0x006a, 0x00d4, 0x01a8, 0x0350, 0x06a0, 0x0d40, 0x1a80, 0x3500, 0x2e43, 0x18c5, 0x318a, 0x2757, 0x0aed, 0x15da, 0x2bb4, 0x132b,
        0x2656, 0x08ef, 0x11de, 0x23bc, 0x033b, 0x0676, 0x0cec, 0x19d8, 0x33b0, 0x2323, 0x0205, 0x040a, 0x0814, 0x1028, 0x2050, 0x04e3,
        0x09c6, 0x138c, 0x2718, 0x0a73, 0x14e6, 0x29cc, 0x17db, 0x2fb6, 0x1b2f, 0x365e, 0x28ff, 0x15bd, 0x2b7a, 0x12b7, 0x256e, 0x0e9f,
        0x1d3e, 0x3a7c, 0x30bb, 0x2535, 0x0e29, 0x1c52, 0x38a4, 0x350b, 0x2e55, 0x18e9, 0x31d2, 0x27e7, 0x0b8d, 0x171a, 0x2e34, 0x182b,
        0x3056, 0x24ef, 0x0d9d, 0x1b3a, 0x3674, 0x28ab, 0x1515, 0x2a2a, 0x1017, 0x202e, 0x041f, 0x083e, 0x107c, 0x20f8, 0x05b3, 0x0b66,
        0x16cc, 0x2d98, 0x1f73, 0x3ee6, 0x398f, 0x375d, 0x2af9, 0x11b1, 0x2362, 0x0287, 0x050e, 0x0a1c, 0x1438, 0x2870, 0x14a3, 0x2946,
        0x16cf, 0x2d9e, 0x1f7f, 0x3efe, 0x39bf, 0x373d, 0x2a39, 0x1031, 0x2062, 0x0487, 0x090e, 0x121c, 0x2438, 0x0c33, 0x1866, 0x30cc,
        0x25db, 0x0ff5, 0x1fea, 0x3fd4, 0x3beb, 0x3395, 0x2369, 0x0291, 0x0522, 0x0a44, 0x1488, 0x2910, 0x1663, 0x2cc6, 0x1dcf, 0x3b9e,
        0x337f, 0x22bd, 0x0139, 0x0272, 0x04e4, 0x09c8, 0x1390, 0x2720, 0x0a03, 0x1406, 0x280c, 0x145b, 0x28b6, 0x152f, 0x2a5e, 0x10ff,
        0x21fe, 0x07bf, 0x0f7e, 0x1efc, 0x3df8, 0x3fb3, 0x3b25, 0x3209, 0x2051, 0x04e1, 0x09c2, 0x1384, 0x2708, 0x0a53, 0x14a6, 0x294c,
        0x16db, 0x2db6, 0x1f2f, 0x3e5e, 0x38ff, 0x35bd, 0x2f39, 0x1a31, 0x3462, 0x2c87, 0x1d4d, 0x3a9a, 0x3177, 0x26ad, 0x0919, 0x1232,
        0x2464, 0x0c8b, 0x1916, 0x322c, 0x201b, 0x0475, 0x08ea, 0x11d4, 0x23a8, 0x0313, 0x0626, 0x0c4c, 0x1898, 0x3130, 0x2623, 0x0805,
        0x100a, 0x2014, 0x046b, 0x08d6, 0x11ac, 0x2358, 0x02f3, 0x05e6, 0x0bcc, 0x1798, 0x2f30, 0x1a23, 0x3446, 0x2ccf, 0x1ddd, 0x3bba,
        0x3337, 0x222d, 0x0019, 0x0032, 0x0064, 0x00c8, 0x0190, 0x0320, 0x0640, 0x0c80, 0x1900, 0x3200, 0x2043, 0x04c5, 0x098a, 0x1314,
        0x2628, 0x0813, 0x1026, 0x204c, 0x04db, 0x09b6, 0x136c, 0x26d8, 0x09f3, 0x13e6, 0x27cc, 0x0bdb, 0x17b6, 0x2f6c, 0x1a9b, 0x3536,
        0x2e2f, 0x181d, 0x303a, 0x2437, 0x0c2d, 0x185a, 0x30b4, 0x252b, 0x0e15, 0x1c2a, 0x3854, 0x34eb, 0x2d95, 0x1f69, 0x3ed2, 0x39e7,
        0x378d, 0x2b59, 0x12f1, 0x25e2, 0x0f87, 0x1f0e, 0x3e1c, 0x387b, 0x34b5, 0x2d29, 0x1e11, 0x3c22, 0x3c07, 0x3c4d, 0x3cd9, 0x3df1,
        0x3fa1, 0x3b01, 0x3241, 0x20c1, 0x05c1, 0x0b82, 0x1704, 0x2e08, 0x1853, 0x30a6, 0x250f, 0x0e5d, 0x1cba, 0x3974, 0x36ab, 0x2915,
        0x1669, 0x2cd2, 0x1de7, 0x3bce, 0x33df, 0x23fd, 0x03b9, 0x0772, 0x0ee4, 0x1dc8, 0x3b90, 0x3363, 0x2285, 0x0149, 0x0292, 0x0524,
        0x0a48, 0x1490, 0x2920, 0x1603, 0x2c06, 0x1c4f, 0x389e, 0x357f, 0x2ebd, 0x1939, 0x3272, 0x20a7, 0x050d, 0x0a1a, 0x1434, 0x2868,
        0x1493, 0x2926, 0x160f, 0x2c1e, 0x1c7f, 0x38fe, 0x35bf, 0x2f3d, 0x1a39, 0x3472, 0x2ca7, 0x1d0d, 0x3a1a, 0x3077, 0x24ad, 0x0d19,
        0x1a32, 0x3464, 0x2c8b, 0x1d55, 0x3aaa, 0x3117, 0x266d, 0x0899, 0x1132, 0x2264, 0x008b, 0x0116, 0x022c, 0x0458, 0x08b0, 0x1160,
        0x22c0, 0x01c3, 0x0386, 0x070c, 0x0e18, 0x1c30, 0x3860, 0x3483, 0x2d45, 0x1ec9, 0x3d92, 0x3f67, 0x3a8d, 0x3159, 0x26f1, 0x09a1,
        0x1342, 0x2684, 0x094b, 0x1296, 0x252c, 0x0e1b, 0x1c36, 0x386c, 0x349b, 0x2d75, 0x1ea9, 0x3d52, 0x3ee7, 0x398d, 0x3759, 0x2af1,
        0x11a1, 0x2342, 0x02c7, 0x058e, 0x0b1c, 0x1638, 0x2c70, 0x1ca3, 0x3946, 0x36cf, 0x29dd, 0x17f9, 0x2ff2, 0x1ba7, 0x374e, 0x2adf,
        0x11fd, 0x23fa, 0x03b7, 0x076e, 0x0edc, 0x1db8, 0x3b70, 0x32a3, 0x2105, 0x0649, 0x0c92, 0x1924, 0x3248, 0x20d3, 0x05e5, 0x0bca,
        0x1794, 0x2f28, 0x1a13, 0x3426, 0x2c0f, 0x1c5d, 0x38ba, 0x3537, 0x2e2d, 0x1819, 0x3032, 0x2427, 0x0c0d, 0x181a, 0x3034, 0x242b,
        0x0c15, 0x182a, 0x3054, 0x24eb, 0x0d95, 0x1b2a, 0x3654, 0x28eb, 0x1595, 0x2b2a, 0x1217, 0x242e, 0x0c1f, 0x183e, 0x307c, 0x24bb,
        0x0d35, 0x1a6a, 0x34d4, 0x2deb, 0x1f95, 0x3f2a, 0x3a17, 0x306d, 0x2499, 0x0d71, 0x1ae2, 0x35c4, 0x2fcb, 0x1bd5, 0x37aa, 0x2b17,
        0x126d, 0x24da, 0x0df7, 0x1bee, 0x37dc, 0x2bfb, 0x13b5, 0x276a, 0x0a97, 0x152e, 0x2a5c, 0x10fb, 0x21f6, 0x07af, 0x0f5e, 0x1ebc,
        0x3d78, 0x3eb3, 0x3925, 0x3609, 0x2851, 0x14e1, 0x29c2, 0x17c7, 0x2f8e, 0x1b5f, 0x36be, 0x293f, 0x163d, 0x2c7a, 0x1cb7, 0x396e,
        0x369f, 0x297d, 0x16b9, 0x2d72, 0x1ea7, 0x3d4e, 0x3edf, 0x39fd, 0x37b9, 0x2b31, 0x1221, 0x2442, 0x0cc7, 0x198e, 0x331c, 0x227b,
        0x00b5, 0x016a, 0x02d4, 0x05a8, 0x0b50, 0x16a0, 0x2d40, 0x1ec3, 0x3d86, 0x3f4f, 0x3add, 0x31f9, 0x27b1, 0x0b21, 0x1642, 0x2c84,
        0x1d4b, 0x3a96, 0x316f, 0x269d, 0x0979, 0x12f2, 0x25e4, 0x0f8b, 0x1f16, 0x3e2c, 0x381b, 0x3475, 0x2ca9, 0x1d11, 0x3a22, 0x3007,
        0x244d, 0x0cd9, 0x19b2, 0x3364, 0x228b, 0x0155, 0x02aa, 0x0554, 0x0aa8, 0x1550, 0x2aa0, 0x1103, 0x2206, 0x004f, 0x009e, 0x013c,
        0x0278, 0x04f0, 0x09e0, 0x13c0, 0x2780, 0x0b43, 0x1686, 0x2d0c, 0x1e5b, 0x3cb6, 0x3d2f, 0x3e1d, 0x3879, 0x34b1, 0x2d21, 0x1e01,
        0x3c02, 0x3c47, 0x3ccd, 0x3dd9, 0x3ff1, 0x3ba1, 0x3301, 0x2241, 0x00c1, 0x0182, 0x0304, 0x0608, 0x0c10, 0x1820, 0x3040, 0x24c3,
        0x0dc5, 0x1b8a, 0x3714, 0x2a6b, 0x1095, 0x212a, 0x0617, 0x0c2e, 0x185c, 0x30b8, 0x2533, 0x0e25, 0x1c4a, 0x3894, 0x356b, 0x2e95,
        0x1969, 0x32d2, 0x21e7, 0x078d, 0x0f1a, 0x1e34, 0x3c68, 0x3c93, 0x3d65, 0x3e89, 0x3951, 0x36e1, 0x2981, 0x1741, 0x2e82, 0x1947,
        0x328e, 0x215f, 0x06fd, 0x0dfa, 0x1bf4, 0x37e8, 0x2b93, 0x1365, 0x26ca, 0x09d7, 0x13ae, 0x275c, 0x0afb, 0x15f6, 0x2bec, 0x139b,
        0x2736, 0x0a2f, 0x145e, 0x28bc, 0x153b, 0x2a76, 0x10af, 0x215e, 0x06ff, 0x0dfe, 0x1bfc, 0x37f8, 0x2bb3, 0x1325, 0x264a, 0x08d7,
        0x11ae, 0x235c, 0x02fb, 0x05f6, 0x0bec, 0x17d8, 0x2fb0, 0x1b23, 0x3646, 0x28cf, 0x15dd, 0x2bba, 0x1337, 0x266e, 0x089f, 0x113e,
        0x227c, 0x00bb, 0x0176, 0x02ec, 0x05d8, 0x0bb0, 0x1760, 0x2ec0, 0x19c3, 0x3386, 0x234f, 0x02dd, 0x05ba, 0x0b74, 0x16e8, 0x2dd0,
        0x1fe3, 0x3fc6, 0x3bcf, 0x33dd, 0x23f9, 0x03b1, 0x0762, 0x0ec4, 0x1d88, 0x3b10, 0x3263, 0x2085, 0x0549, 0x0a92, 0x1524, 0x2a48,
        0x10d3, 0x21a6, 0x070f, 0x0e1e, 0x1c3c, 0x3878, 0x34b3, 0x2d25, 0x1e09, 0x3c12, 0x3c67, 0x3c8d, 0x3d59, 0x3ef1, 0x39a1, 0x3701,
        0x2a41, 0x10c1, 0x2182, 0x0747, 0x0e8e, 0x1d1c, 0x3a38, 0x3033, 0x2425, 0x0c09, 0x1812, 0x3024, 0x240b, 0x0c55, 0x18aa, 0x3154,
        0x26eb, 0x0995, 0x132a, 0x2654, 0x08eb, 0x11d6, 0x23ac, 0x031b, 0x0636, 0x0c6c, 0x18d8, 0x31b0, 0x2723, 0x0a05, 0x140a, 0x2814,
        0x146b, 0x28d6, 0x15ef, 0x2bde, 0x13ff, 0x27fe, 0x0bbf, 0x177e, 0x2efc, 0x19bb, 0x3376, 0x22af, 0x011d, 0x023a, 0x0474, 0x08e8,
        0x11d0, 0x23a0, 0x0303, 0x0606, 0x0c0c, 0x1818, 0x3030, 0x2423, 0x0c05, 0x180a, 0x3014, 0x246b, 0x0c95, 0x192a, 0x3254, 0x20eb,
        0x0595, 0x0b2a, 0x1654, 0x2ca8, 0x1d13, 0x3a26, 0x300f, 0x245d, 0x0cf9, 0x19f2, 0x33e4, 0x238b, 0x0355, 0x06aa, 0x0d54, 0x1aa8,
        0x3550, 0x2ee3, 0x1985, 0x330a, 0x2257, 0x00ed, 0x01da, 0x03b4, 0x0768, 0x0ed0, 0x1da0, 0x3b40, 0x32c3, 0x21c5, 0x07c9, 0x0f92,
        0x1f24, 0x3e48, 0x38d3, 0x35e5, 0x2f89, 0x1b51, 0x36a2, 0x2907, 0x164d, 0x2c9a, 0x1d77, 0x3aee, 0x319f, 0x277d, 0x0ab9, 0x1572,
        0x2ae4, 0x118b, 0x2316, 0x026f, 0x04de, 0x09bc, 0x1378, 0x26f0, 0x09a3, 0x1346, 0x268c, 0x095b, 0x12b6, 0x256c, 0x0e9b, 0x1d36,
        0x3a6c, 0x309b, 0x2575, 0x0ea9, 0x1d52, 0x3aa4, 0x310b, 0x2655, 0x08e9, 0x11d2, 0x23a4, 0x030b, 0x0616, 0x0c2c, 0x1858, 0x30b0,
        0x2523, 0x0e05, 0x1c0a, 0x3814, 0x346b, 0x2c95, 0x1d69, 0x3ad2, 0x31e7, 0x278d, 0x0b59, 0x16b2, 0x2d64, 0x1e8b, 0x3d16, 0x3e6f,
        0x389d, 0x3579, 0x2eb1, 0x1921, 0x3242, 0x20c7, 0x05cd, 0x0b9a, 0x1734, 0x2e68, 0x1893, 0x3126, 0x260f, 0x085d, 0x10ba, 0x2174,
        0x06ab, 0x0d56, 0x1aac, 0x3558, 0x2ef3, 0x19a5, 0x334a, 0x22d7, 0x01ed, 0x03da, 0x07b4, 0x0f68, 0x1ed0, 0x3da0, 0x3f03, 0x3a45,
        0x30c9, 0x25d1, 0x0fe1, 0x1fc2, 0x3f84, 0x3b4b, 0x32d5, 0x21e9, 0x0791, 0x0f22, 0x1e44, 0x3c88, 0x3d53, 0x3ee5, 0x3989, 0x3751,
        0x2ae1, 0x1181, 0x2302, 0x0247, 0x048e, 0x091c, 0x1238, 0x2470, 0x0ca3, 0x1946, 0x328c, 0x215b, 0x06f5, 0x0dea, 0x1bd4, 0x37a8,
        0x2b13, 0x1265, 0x24ca, 0x0dd7, 0x1bae, 0x375c, 0x2afb, 0x11b5, 0x236a, 0x0297, 0x052e, 0x0a5c, 0x14b8, 0x2970, 0x16a3, 0x2d46,
        0x1ecf, 0x3d9e, 0x3f7f, 0x3abd, 0x3139, 0x2631, 0x0821, 0x1042, 0x2084, 0x054b, 0x0a96, 0x152c, 0x2a58, 0x10f3, 0x21e6, 0x078f,
        0x0f1e, 0x1e3c, 0x3c78, 0x3cb3, 0x3d25, 0x3e09, 0x3851, 0x34e1, 0x2d81, 0x1f41, 0x3e82, 0x3947, 0x36cd, 0x29d9, 0x17f1, 0x2fe2,
        0x1b87, 0x370e, 0x2a5f, 0x10fd, 0x21fa, 0x07b7, 0x0f6e, 0x1edc, 0x3db8, 0x3f33, 0x3a25, 0x3009, 0x2451, 0x0ce1, 0x19c2, 0x3384,
        0x234b, 0x02d5, 0x05aa, 0x0b54, 0x16a8, 0x2d50, 0x1ee3, 0x3dc6, 0x3fcf, 0x3bdd, 0x33f9, 0x23b1, 0x0321, 0x0642, 0x0c84, 0x1908,
        0x3210, 0x2063, 0x0485, 0x090a, 0x1214, 0x2428, 0x0c13, 0x1826, 0x304c, 0x24db, 0x0df5, 0x1bea, 0x37d4, 0x2beb, 0x1395, 0x272a,
        0x0a17, 0x142e, 0x285c, 0x14fb, 0x29f6, 0x17af, 0x2f5e, 0x1aff, 0x35fe, 0x2fbf, 0x1b3d, 0x367a, 0x28b7, 0x152d, 0x2a5a, 0x10f7,
        0x21ee, 0x079f, 0x0f3e, 0x1e7c, 0x3cf8, 0x3db3, 0x3f25, 0x3a09, 0x3051, 0x24e1, 0x0d81, 0x1b02, 0x3604, 0x284b, 0x14d5, 0x29aa,
        0x1717, 0x2e2e, 0x181f, 0x303e, 0x243f, 0x0c3d, 0x187a, 0x30f4, 0x25ab, 0x0f15, 0x1e2a, 0x3c54, 0x3ceb, 0x3d95, 0x3f69, 0x3a91,
        0x3161, 0x2681, 0x0941, 0x1282, 0x2504, 0x0e4b, 0x1c96, 0x392c, 0x361b, 0x2875, 0x14a9, 0x2952, 0x16e7, 0x2dce, 0x1fdf, 0x3fbe,
        0x3b3f, 0x323d, 0x2039, 0x0431, 0x0862, 0x10c4, 0x2188, 0x0753, 0x0ea6, 0x1d4c, 0x3a98, 0x3173, 0x26a5, 0x0909, 0x1212, 0x2424,
        0x0c0b, 0x1816, 0x302c, 0x241b, 0x0c75, 0x18ea, 0x31d4, 0x27eb, 0x0b95, 0x172a, 0x2e54, 0x18eb, 0x31d6, 0x27ef, 0x0b9d, 0x173a,
        0x2e74, 0x18ab, 0x3156, 0x26ef, 0x099d, 0x133a, 0x2674, 0x08ab, 0x1156, 0x22ac, 0x011b, 0x0236, 0x046c, 0x08d8, 0x11b0, 0x2360,
        0x0283, 0x0506, 0x0a0c, 0x1418, 0x2830, 0x1423, 0x2846, 0x14cf, 0x299e, 0x177f, 0x2efe, 0x19bf, 0x337e, 0x22bf, 0x013d, 0x027a,
        0x04f4, 0x09e8, 0x13d0, 0x27a0, 0x0b03, 0x1606, 0x2c0c, 0x1c5b, 0x38b6, 0x352f, 0x2e1d, 0x1879, 0x30f2, 0x25a7, 0x0f0d, 0x1e1a,
        0x3c34, 0x3c2b, 0x3c15, 0x3c69, 0x3c91, 0x3d61, 0x3e81, 0x3941, 0x36c1, 0x29c1, 0x17c1, 0x2f82, 0x1b47, 0x368e, 0x295f, 0x16fd,
        0x2dfa, 0x1fb7, 0x3f6e, 0x3a9f, 0x317d, 0x26b9, 0x0931, 0x1262, 0x24c4, 0x0dcb, 0x1b96, 0x372c, 0x2a1b, 0x1075, 0x20ea, 0x0597,
        0x0b2e, 0x165c, 0x2cb8, 0x1d33, 0x3a66, 0x308f, 0x255d, 0x0ef9, 0x1df2, 0x3be4, 0x338b, 0x2355, 0x02e9, 0x05d2, 0x0ba4, 0x1748,
        0x2e90, 0x1963, 0x32c6, 0x21cf, 0x07dd, 0x0fba, 0x1f74, 0x3ee8, 0x3993, 0x3765, 0x2a89, 0x1151, 0x22a2, 0x0107, 0x020e, 0x041c,
        0x0838, 0x1070, 0x20e0, 0x0583, 0x0b06, 0x160c, 0x2c18, 0x1c73, 0x38e6, 0x358f, 0x2f5d, 0x1af9, 0x35f2, 0x2fa7, 0x1b0d, 0x361a,
        0x2877, 0x14ad, 0x295a, 0x16f7, 0x2dee, 0x1f9f, 0x3f3e, 0x3a3f, 0x303d, 0x2439, 0x0c31, 0x1862, 0x30c4, 0x25cb, 0x0fd5, 0x1faa,
        0x3f54, 0x3aeb, 0x3195, 0x2769, 0x0a91, 0x1522, 0x2a44, 0x10cb, 0x2196, 0x076f, 0x0ede, 0x1dbc, 0x3b78, 0x32b3, 0x2125, 0x0609,
        0x0c12, 0x1824, 0x3048, 0x24d3, 0x0de5, 0x1bca, 0x3794, 0x2b6b, 0x1295, 0x252a, 0x0e17, 0x1c2e, 0x385c, 0x34fb, 0x2db5, 0x1f29,
        0x3e52, 0x38e7, 0x358d, 0x2f59, 0x1af1, 0x35e2, 0x2f87, 0x1b4d, 0x369a, 0x2977, 0x16ad, 0x2d5a, 0x1ef7, 0x3dee, 0x3f9f, 0x3b7d,
        0x32b9, 0x2131, 0x0621, 0x0c42, 0x1884, 0x3108, 0x2653, 0x08e5, 0x11ca, 0x2394, 0x036b, 0x06d6, 0x0dac, 0x1b58, 0x36b0, 0x2923,
        0x1605, 0x2c0a, 0x1c57, 0x38ae, 0x351f, 0x2e7d, 0x18b9, 0x3172, 0x26a7, 0x090d, 0x121a, 0x2434, 0x0c2b, 0x1856, 0x30ac, 0x251b,
        0x0e75, 0x1cea, 0x39d4, 0x37eb, 0x2b95, 0x1369, 0x26d2, 0x09e7, 0x13ce, 0x279c, 0x0b7b, 0x16f6, 0x2dec, 0x1f9b, 0x3f36, 0x3a2f,
        0x301d, 0x2479, 0x0cb1, 0x1962, 0x32c4, 0x21cb, 0x07d5, 0x0faa, 0x1f54, 0x3ea8, 0x3913, 0x3665, 0x2889, 0x1551, 0x2aa2, 0x1107,
        0x220e, 0x005f, 0x00be, 0x017c, 0x02f8, 0x05f0, 0x0be0, 0x17c0, 0x2f80, 0x1b43, 0x3686, 0x294f, 0x16dd, 0x2dba, 0x1f37, 0x3e6e,
        0x389f, 0x357d, 0x2eb9, 0x1931, 0x3262, 0x2087, 0x054d, 0x0a9a, 0x1534, 0x2a68, 0x1093, 0x2126, 0x060f, 0x0c1e, 0x183c, 0x3078,
        0x24b3, 0x0d25, 0x1a4a, 0x3494, 0x2d6b, 0x1e95, 0x3d2a, 0x3e17, 0x386d, 0x3499, 0x2d71, 0x1ea1, 0x3d42, 0x3ec7, 0x39cd, 0x37d9,
        0x2bf1, 0x13a1, 0x2742, 0x0ac7, 0x158e, 0x2b1c, 0x127b, 0x24f6, 0x0daf, 0x1b5e, 0x36bc, 0x293b, 0x1635, 0x2c6a, 0x1c97, 0x392e,
        0x361f, 0x287d, 0x14b9, 0x2972, 0x16a7, 0x2d4e, 0x1edf, 0x3dbe, 0x3f3f, 0x3a3d, 0x3039, 0x2431, 0x0c21, 0x1842, 0x3084, 0x254b,
        0x0ed5, 0x1daa, 0x3b54, 0x32eb, 0x2195, 0x0769, 0x0ed2, 0x1da4, 0x3b48, 0x32d3, 0x21e5, 0x0789, 0x0f12, 0x1e24, 0x3c48, 0x3cd3,
        0x3de5, 0x3f89, 0x3b51, 0x32e1, 0x2181, 0x0741, 0x0e82, 0x1d04, 0x3a08, 0x3053, 0x24e5, 0x0d89, 0x1b12, 0x3624, 0x280b, 0x1455,
        0x28aa, 0x1517, 0x2a2e, 0x101f, 0x203e, 0x043f, 0x087e, 0x10fc, 0x21f8, 0x07b3, 0x0f66, 0x1ecc, 0x3d98, 0x3f73, 0x3aa5, 0x3109,
        0x2651, 0x08e1, 0x11c2, 0x2384, 0x034b, 0x0696, 0x0d2c, 0x1a58, 0x34b0, 0x2d23, 0x1e05, 0x3c0a, 0x3c57, 0x3ced, 0x3d99, 0x3f71,
        0x3aa1, 0x3101, 0x2641, 0x08c1, 0x1182, 0x2304, 0x024b, 0x0496, 0x092c, 0x1258, 0x24b0, 0x0d23, 0x1a46, 0x348c, 0x2d5b, 0x1ef5,
        0x3dea, 0x3f97, 0x3b6d, 0x3299, 0x2171, 0x06a1, 0x0d42, 0x1a84, 0x3508, 0x2e53, 0x18e5, 0x31ca, 0x27d7, 0x0bed, 0x17da, 0x2fb4,
        0x1b2b, 0x3656, 0x28ef, 0x159d, 0x2b3a, 0x1237, 0x246e, 0x0c9f, 0x193e, 0x327c, 0x20bb, 0x0535, 0x0a6a, 0x14d4, 0x29a8, 0x1713,
        0x2e26, 0x180f, 0x301e, 0x247f, 0x0cbd, 0x197a, 0x32f4, 0x21ab, 0x0715, 0x0e2a, 0x1c54, 0x38a8, 0x3513, 0x2e65, 0x1889, 0x3112,
        0x2667, 0x088d, 0x111a, 0x2234, 0x002b, 0x0056, 0x00ac, 0x0158, 0x02b0, 0x0560, 0x0ac0, 0x1580, 0x2b00, 0x1243, 0x2486, 0x0d4f,
        0x1a9e, 0x353c, 0x2e3b, 0x1835, 0x306a, 0x2497, 0x0d6d, 0x1ada, 0x35b4, 0x2f2b, 0x1a15, 0x342a, 0x2c17, 0x1c6d, 0x38da, 0x35f7,
        0x2fad, 0x1b19, 0x3632, 0x2827, 0x140d, 0x281a, 0x1477, 0x28ee, 0x159f, 0x2b3e, 0x123f, 0x247e, 0x0cbf, 0x197e, 0x32fc, 0x21bb,
        0x0735, 0x0e6a, 0x1cd4, 0x39a8, 0x3713, 0x2a65, 0x1089, 0x2112, 0x0667, 0x0cce, 0x199c, 0x3338, 0x2233, 0x0025, 0x004a, 0x0094,
        0x0128, 0x0250, 0x04a0, 0x0940, 0x1280, 0x2500, 0x0e43, 0x1c86, 0x390c, 0x365b, 0x28f5, 0x15a9, 0x2b52, 0x12e7, 0x25ce, 0x0fdf,
        0x1fbe, 0x3f7c, 0x3abb, 0x3135, 0x2629, 0x0811, 0x1022, 0x2044, 0x04cb, 0x0996, 0x132c, 0x2658, 0x08f3, 0x11e6, 0x23cc, 0x03db,
        0x07b6, 0x0f6c, 0x1ed8, 0x3db0, 0x3f23, 0x3a05, 0x3049, 0x24d1, 0x0de1, 0x1bc2, 0x3784, 0x2b4b, 0x12d5, 0x25aa, 0x0f17, 0x1e2e,
        0x3c5c, 0x3cfb, 0x3db5, 0x3f29, 0x3a11, 0x3061, 0x2481, 0x0d41, 0x1a82, 0x3504, 0x2e4b, 0x18d5, 0x31aa, 0x2717, 0x0a6d, 0x14da,
        0x29b4, 0x172b, 0x2e56, 0x18ef, 0x31de, 0x27ff, 0x0bbd, 0x177a, 0x2ef4, 0x19ab, 0x3356, 0x22ef, 0x019d, 0x033a, 0x0674, 0x0ce8,
        0x19d0, 0x33a0, 0x2303, 0x0245, 0x048a, 0x0914, 0x1228, 0x2450, 0x0ce3, 0x19c6, 0x338c, 0x235b, 0x02f5, 0x05ea, 0x0bd4, 0x17a8,
        0x2f50, 0x1ae3, 0x35c6, 0x2fcf, 0x1bdd, 0x37ba, 0x2b37, 0x122d, 0x245a, 0x0cf7, 0x19ee, 0x33dc, 0x23fb, 0x03b5, 0x076a, 0x0ed4,
        0x1da8, 0x3b50, 0x32e3, 0x2185, 0x0749, 0x0e92, 0x1d24, 0x3a48, 0x30d3, 0x25e5, 0x0f89, 0x1f12, 0x3e24, 0x380b, 0x3455, 0x2ce9,
        0x1d91, 0x3b22, 0x3207, 0x204d, 0x04d9, 0x09b2, 0x1364, 0x26c8, 0x09d3, 0x13a6, 0x274c, 0x0adb, 0x15b6, 0x2b6c, 0x129b, 0x2536,
        0x0e2f, 0x1c5e, 0x38bc, 0x353b, 0x2e35, 0x1829, 0x3052, 0x24e7, 0x0d8d, 0x1b1a, 0x3634, 0x282b, 0x1415, 0x282a, 0x1417, 0x282e,
        0x141f, 0x283e, 0x143f, 0x287e, 0x14bf, 0x297e, 0x16bf, 0x2d7e, 0x1ebf, 0x3d7e, 0x3ebf, 0x393d, 0x3639, 0x2831, 0x1421, 0x2842,
        0x14c7, 0x298e, 0x175f, 0x2ebe, 0x193f, 0x327e, 0x20bf, 0x053d, 0x0a7a, 0x14f4, 0x29e8, 0x1793, 0x2f26, 0x1a0f, 0x341e, 0x2c7f,
        0x1cbd, 0x397a, 0x36b7, 0x292d, 0x1619, 0x2c32, 0x1c27, 0x384e, 0x34df, 0x2dfd, 0x1fb9, 0x3f72, 0x3aa7, 0x310d, 0x2659, 0x08f1,
        0x11e2, 0x23c4, 0x03cb, 0x0796, 0x0f2c, 0x1e58, 0x3cb0, 0x3d23, 0x3e05, 0x3849, 0x34d1, 0x2de1, 0x1f81, 0x3f02, 0x3a47, 0x30cd,
        0x25d9, 0x0ff1, 0x1fe2, 0x3fc4, 0x3bcb, 0x33d5, 0x23e9, 0x0391, 0x0722, 0x0e44, 0x1c88, 0x3910, 0x3663, 0x2885, 0x1549, 0x2a92,
        0x1167, 0x22ce, 0x01df, 0x03be, 0x077c, 0x0ef8, 0x1df0, 0x3be0, 0x3383, 0x2345, 0x02c9, 0x0592, 0x0b24, 0x1648, 0x2c90, 0x1d63,
        0x3ac6, 0x31cf, 0x27dd, 0x0bf9, 0x17f2, 0x2fe4, 0x1b8b, 0x3716, 0x2a6f, 0x109d, 0x213a, 0x0637, 0x0c6e, 0x18dc, 0x31b8, 0x2733,
        0x0a25, 0x144a, 0x2894, 0x156b, 0x2ad6, 0x11ef, 0x23de, 0x03ff, 0x07fe, 0x0ffc, 0x1ff8, 0x3ff0, 0x3ba3, 0x3305, 0x2249, 0x00d1,
        0x01a2, 0x0344, 0x0688, 0x0d10, 0x1a20, 0x3440, 0x2cc3, 0x1dc5, 0x3b8a, 0x3357, 0x22ed, 0x0199, 0x0332, 0x0664, 0x0cc8, 0x1990,
        0x3320, 0x2203, 0x0045, 0x008a, 0x0114, 0x0228, 0x0450, 0x08a0, 0x1140, 0x2280, 0x0143, 0x0286, 0x050c, 0x0a18, 0x1430, 0x2860,
        0x1483, 0x2906, 0x164f, 0x2c9e, 0x1d7f, 0x3afe, 0x31bf, 0x273d, 0x0a39, 0x1472, 0x28e4, 0x158b, 0x2b16, 0x126f, 0x24de, 0x0dff,
        0x1bfe, 0x37fc, 0x2bbb, 0x1335, 0x266a, 0x0897, 0x112e, 0x225c, 0x00fb, 0x01f6, 0x03ec, 0x07d8, 0x0fb0, 0x1f60, 0x3ec0, 0x39c3,
        0x37c5, 0x2bc9, 0x13d1, 0x27a2, 0x0b07, 0x160e, 0x2c1c, 0x1c7b, 0x38f6, 0x35af, 0x2f1d, 0x1a79, 0x34f2, 0x2da7, 0x1f0d, 0x3e1a,
        0x3877, 0x34ad, 0x2d19, 0x1e71, 0x3ce2, 0x3d87, 0x3f4d, 0x3ad9, 0x31f1, 0x27a1, 0x0b01, 0x1602, 0x2c04, 0x1c4b, 0x3896, 0x356f,
        0x2e9d, 0x1979, 0x32f2, 0x21a7, 0x070d, 0x0e1a, 0x1c34, 0x3868, 0x3493, 0x2d65, 0x1e89, 0x3d12, 0x3e67, 0x388d, 0x3559, 0x2ef1,
        0x19a1, 0x3342, 0x22c7, 0x01cd, 0x039a, 0x0734, 0x0e68, 0x1cd0, 0x39a0, 0x3703, 0x2a45, 0x10c9, 0x2192, 0x0767, 0x0ece, 0x1d9c,
        0x3b38, 0x3233, 0x2025, 0x0409, 0x0812, 0x1024, 0x2048, 0x04d3, 0x09a6, 0x134c, 0x2698, 0x0973, 0x12e6, 0x25cc, 0x0fdb, 0x1fb6,
        0x3f6c, 0x3a9b, 0x3175, 0x26a9, 0x0911, 0x1222, 0x2444, 0x0ccb, 0x1996, 0x332c, 0x221b, 0x0075, 0x00ea, 0x01d4, 0x03a8, 0x0750,
        0x0ea0, 0x1d40, 0x3a80, 0x3143, 0x26c5, 0x09c9, 0x1392, 0x2724, 0x0a0b, 0x1416, 0x282c, 0x141b, 0x2836, 0x142f, 0x285e, 0x14ff,
        0x29fe, 0x17bf, 0x2f7e, 0x1abf, 0x357e, 0x2ebf, 0x193d, 0x327a, 0x20b7, 0x052d, 0x0a5a, 0x14b4, 0x2968, 0x1693, 0x2d26, 0x1e0f,
        0x3c1e, 0x3c7f, 0x3cbd, 0x3d39, 0x3e31, 0x3821, 0x3401, 0x2c41, 0x1cc1, 0x3982, 0x3747, 0x2acd, 0x11d9, 0x23b2, 0x0327, 0x064e,
        0x0c9c, 0x1938, 0x3270, 0x20a3, 0x0505, 0x0a0a, 0x1414, 0x2828, 0x1413, 0x2826, 0x140f, 0x281e, 0x147f, 0x28fe, 0x15bf, 0x2b7e,
        0x12bf, 0x257e, 0x0ebf, 0x1d7e, 0x3afc, 0x31bb, 0x2735, 0x0a29, 0x1452, 0x28a4, 0x150b, 0x2a16, 0x106f, 0x20de, 0x05ff, 0x0bfe,
        0x17fc, 0x2ff8, 0x1bb3, 0x3766, 0x2a8f, 0x115d, 0x22ba, 0x0137, 0x026e, 0x04dc, 0x09b8, 0x1370, 0x26e0, 0x0983, 0x1306, 0x260c,
        0x085b, 0x10b6, 0x216c, 0x069b, 0x0d36, 0x1a6c, 0x34d8, 0x2df3, 0x1fa5, 0x3f4a, 0x3ad7, 0x31ed, 0x2799, 0x0b71, 0x16e2, 0x2dc4,
        0x1fcb, 0x3f96, 0x3b6f, 0x329d, 0x2179, 0x06b1, 0x0d62, 0x1ac4, 0x3588, 0x2f53, 0x1ae5, 0x35ca, 0x2fd7, 0x1bed, 0x37da, 0x2bf7,
        0x13ad, 0x275a, 0x0af7, 0x15ee, 0x2bdc, 0x13fb, 0x27f6, 0x0baf, 0x175e, 0x2ebc, 0x193b, 0x3276, 0x20af, 0x051d, 0x0a3a, 0x1474,
        0x28e8, 0x1593, 0x2b26, 0x120f, 0x241e, 0x0c7f, 0x18fe, 0x31fc, 0x27bb, 0x0b35, 0x166a, 0x2cd4, 0x1deb, 0x3bd6, 0x33ef, 0x239d,
        0x0379, 0x06f2, 0x0de4, 0x1bc8, 0x3790, 0x2b63, 0x1285, 0x250a, 0x0e57, 0x1cae, 0x395c, 0x36fb, 0x29b5, 0x1729, 0x2e52, 0x18e7,
        0x31ce, 0x27df, 0x0bfd, 0x17fa, 0x2ff4, 0x1bab, 0x3756, 0x2aef, 0x119d, 0x233a, 0x0237, 0x046e, 0x08dc, 0x11b8, 0x2370, 0x02a3,
        0x0546, 0x0a8c, 0x1518, 0x2a30, 0x1023, 0x2046, 0x04cf, 0x099e, 0x133c, 0x2678, 0x08b3, 0x1166, 0x22cc, 0x01db, 0x03b6, 0x076c,
        0x0ed8, 0x1db0, 0x3b60, 0x3283, 0x2145, 0x06c9, 0x0d92, 0x1b24, 0x3648, 0x28d3, 0x15e5, 0x2bca, 0x13d7, 0x27ae, 0x0b1f, 0x163e,
        0x2c7c, 0x1cbb, 0x3976, 0x36af, 0x291d, 0x1679, 0x2cf2, 0x1da7, 0x3b4e, 0x32df, 0x21fd, 0x07b9, 0x0f72, 0x1ee4, 0x3dc8, 0x3fd3,
        0x3be5, 0x3389, 0x2351, 0x02e1, 0x05c2, 0x0b84, 0x1708, 0x2e10, 0x1863, 0x30c6, 0x25cf, 0x0fdd, 0x1fba, 0x3f74, 0x3aab, 0x3115,
        0x2669, 0x0891, 0x1122, 0x2244, 0x00cb, 0x0196, 0x032c, 0x0658, 0x0cb0, 0x1960, 0x32c0, 0x21c3, 0x07c5, 0x0f8a, 0x1f14, 0x3e28,
        0x3813, 0x3465, 0x2c89, 0x1d51, 0x3aa2, 0x3107, 0x264d, 0x08d9, 0x11b2, 0x2364, 0x028b, 0x0516, 0x0a2c, 0x1458, 0x28b0, 0x1523,
        0x2a46, 0x10cf, 0x219e, 0x077f, 0x0efe, 0x1dfc, 0x3bf8, 0x33b3, 0x2325, 0x0209, 0x0412, 0x0824, 0x1048, 0x2090, 0x0563, 0x0ac6,
        0x158c, 0x2b18, 0x1273, 0x24e6, 0x0d8f, 0x1b1e, 0x363c, 0x283b, 0x1435, 0x286a, 0x1497, 0x292e, 0x161f, 0x2c3e, 0x1c3f, 0x387e,
        0x34bf, 0x2d3d, 0x1e39, 0x3c72, 0x3ca7, 0x3d0d, 0x3e59, 0x38f1, 0x35a1, 0x2f01, 0x1a41, 0x3482, 0x2d47, 0x1ecd, 0x3d9a, 0x3f77,
        0x3aad, 0x3119, 0x2671, 0x08a1, 0x1142, 0x2284, 0x014b, 0x0296, 0x052c, 0x0a58, 0x14b0, 0x2960, 0x1683, 0x2d06, 0x1e4f, 0x3c9e,
        0x3d7f, 0x3ebd, 0x3939, 0x3631, 0x2821, 0x1401, 0x2802, 0x1447, 0x288e, 0x155f, 0x2abe, 0x113f, 0x227e, 0x00bf, 0x017e, 0x02fc,
        0x05f8, 0x0bf0, 0x17e0, 0x2fc0, 0x1bc3, 0x3786, 0x2b4f, 0x12dd, 0x25ba, 0x0f37, 0x1e6e, 0x3cdc, 0x3dfb, 0x3fb5, 0x3b29, 0x3211,
        0x2061, 0x0481, 0x0902, 0x1204, 0x2408, 0x0c53, 0x18a6, 0x314c, 0x26db, 0x09f5, 0x13ea, 0x27d4, 0x0beb, 0x17d6, 0x2fac, 0x1b1b,
        0x3636, 0x282f, 0x141d, 0x283a, 0x1437, 0x286e, 0x149f, 0x293e, 0x163f, 0x2c7e, 0x1cbf, 0x397e, 0x36bf, 0x293d, 0x1639, 0x2c72,
        0x1ca7, 0x394e, 0x36df, 0x29fd, 0x17b9, 0x2f72, 0x1aa7, 0x354e, 0x2edf, 0x19fd, 0x33fa, 0x23b7, 0x032d, 0x065a, 0x0cb4, 0x1968,
        0x32d0, 0x21e3, 0x0785, 0x0f0a, 0x1e14, 0x3c28, 0x3c13, 0x3c65, 0x3c89, 0x3d51, 0x3ee1, 0x3981, 0x3741, 0x2ac1, 0x11c1, 0x2382,
        0x0347, 0x068e, 0x0d1c, 0x1a38, 0x3470, 0x2ca3, 0x1d05, 0x3a0a, 0x3057, 0x24ed, 0x0d99, 0x1b32, 0x3664, 0x288b, 0x1555, 0x2aaa,
        0x1117, 0x222e, 0x001f, 0x003e, 0x007c, 0x00f8, 0x01f0, 0x03e0, 0x07c0, 0x0f80, 0x1f00, 0x3e00, 0x3843, 0x34c5, 0x2dc9, 0x1fd1,
        0x3fa2, 0x3b07, 0x324d, 0x20d9, 0x05f1, 0x0be2, 0x17c4, 0x2f88, 0x1b53, 0x36a6, 0x290f, 0x165d, 0x2cba, 0x1d37, 0x3a6e, 0x309f,
        0x257d, 0x0eb9, 0x1d72, 0x3ae4, 0x318b, 0x2755, 0x0ae9, 0x15d2, 0x2ba4, 0x130b, 0x2616, 0x086f, 0x10de, 0x21bc, 0x073b, 0x0e76,
        0x1cec, 0x39d8, 0x37f3, 0x2ba5, 0x1309, 0x2612, 0x0867, 0x10ce, 0x219c, 0x077b, 0x0ef6, 0x1dec, 0x3bd8, 0x33f3, 0x23a5, 0x0309,
        0x0612, 0x0c24, 0x1848, 0x3090, 0x2563, 0x0e85, 0x1d0a, 0x3a14, 0x306b, 0x2495, 0x0d69, 0x1ad2, 0x35a4, 0x2f0b, 0x1a55, 0x34aa,
        0x2d17, 0x1e6d, 0x3cda, 0x3df7, 0x3fad, 0x3b19, 0x3271, 0x20a1, 0x0501, 0x0a02, 0x1404, 0x2808, 0x1453, 0x28a6, 0x150f, 0x2a1e,
        0x107f, 0x20fe, 0x05bf, 0x0b7e, 0x16fc, 0x2df8, 0x1fb3, 0x3f66, 0x3a8f, 0x315d, 0x26f9, 0x09b1, 0x1362, 0x26c4, 0x09cb, 0x1396,
        0x272c, 0x0a1b, 0x1436, 0x286c, 0x149b, 0x2936, 0x162f, 0x2c5e, 0x1cff, 0x39fe, 0x37bf, 0x2b3d, 0x1239, 0x2472, 0x0ca7, 0x194e,
        0x329c, 0x217b, 0x06b5, 0x0d6a, 0x1ad4, 0x35a8, 0x2f13, 0x1a65, 0x34ca, 0x2dd7, 0x1fed, 0x3fda, 0x3bf7, 0x33ad, 0x2319, 0x0271,
        0x04e2, 0x09c4, 0x1388, 0x2710, 0x0a63, 0x14c6, 0x298c, 0x175b, 0x2eb6, 0x192f, 0x325e, 0x20ff, 0x05bd, 0x0b7a, 0x16f4, 0x2de8,
        0x1f93, 0x3f26, 0x3a0f, 0x305d, 0x24f9, 0x0db1, 0x1b62, 0x36c4, 0x29cb, 0x17d5, 0x2faa, 0x1b17, 0x362e, 0x281f, 0x147d, 0x28fa,
        0x15b7, 0x2b6e, 0x129f, 0x253e, 0x0e3f, 0x1c7e, 0x38fc, 0x35bb, 0x2f35, 0x1a29, 0x3452, 0x2ce7, 0x1d8d, 0x3b1a, 0x3277, 0x20ad,
        0x0519, 0x0a32, 0x1464, 0x28c8, 0x15d3, 0x2ba6, 0x130f, 0x261e, 0x087f, 0x10fe, 0x21fc, 0x07bb, 0x0f76, 0x1eec, 0x3dd8, 0x3ff3,
        0x3ba5, 0x3309, 0x2251, 0x00e1, 0x01c2, 0x0384, 0x0708, 0x0e10, 0x1c20, 0x3840, 0x34c3, 0x2dc5, 0x1fc9, 0x3f92, 0x3b67, 0x328d,
        0x2159, 0x06f1, 0x0de2, 0x1bc4, 0x3788, 0x2b53, 0x12e5, 0x25ca, 0x0fd7, 0x1fae, 0x3f5c, 0x3afb, 0x31b5, 0x2729, 0x0a11, 0x1422,
        0x2844, 0x14cb, 0x2996, 0x176f, 0x2ede, 0x19ff, 0x33fe, 0x23bf, 0x033d, 0x067a, 0x0cf4, 0x19e8, 0x33d0, 0x23e3, 0x0385, 0x070a,
        0x0e14, 0x1c28, 0x3850, 0x34e3, 0x2d85, 0x1f49, 0x3e92, 0x3967, 0x368d, 0x2959, 0x16f1, 0x2de2, 0x1f87, 0x3f0e, 0x3a5f, 0x30fd,
        0x25b9, 0x0f31, 0x1e62, 0x3cc4, 0x3dcb, 0x3fd5, 0x3be9, 0x3391, 0x2361, 0x0281, 0x0502, 0x0a04, 0x1408, 0x2810, 0x1463, 0x28c6,
        0x15cf, 0x2b9e, 0x137f, 0x26fe, 0x09bf, 0x137e, 0x26fc, 0x09bb, 0x1376, 0x26ec, 0x099b, 0x1336, 0x266c, 0x089b, 0x1136, 0x226c,
        0x009b, 0x0136, 0x026c, 0x04d8, 0x09b0, 0x1360, 0x26c0, 0x09c3, 0x1386, 0x270c, 0x0a5b, 0x14b6, 0x296c, 0x169b, 0x2d36, 0x1e2f,
        0x3c5e, 0x3cff, 0x3dbd, 0x3f39, 0x3a31, 0x3021, 0x2401, 0x0c41, 0x1882, 0x3104, 0x264b, 0x08d5, 0x11aa, 0x2354, 0x02eb, 0x05d6,
        0x0bac, 0x1758, 0x2eb0, 0x1923, 0x3246, 0x20cf, 0x05dd, 0x0bba, 0x1774, 0x2ee8, 0x1993, 0x3326, 0x220f, 0x005d, 0x00ba, 0x0174,
        0x02e8, 0x05d0, 0x0ba0, 0x1740, 0x2e80, 0x1943, 0x3286, 0x214f, 0x06dd, 0x0dba, 0x1b74, 0x36e8, 0x2993, 0x1765, 0x2eca, 0x19d7,
        0x33ae, 0x231f, 0x027d, 0x04fa, 0x09f4, 0x13e8, 0x27d0, 0x0be3, 0x17c6, 0x2f8c, 0x1b5b, 0x36b6, 0x292f, 0x161d, 0x2c3a, 0x1c37,
        0x386e, 0x349f, 0x2d7d, 0x1eb9, 0x3d72, 0x3ea7, 0x390d, 0x3659, 0x28f1, 0x15a1, 0x2b42, 0x12c7, 0x258e, 0x0f5f, 0x1ebe, 0x3d7c,
        0x3ebb, 0x3935, 0x3629, 0x2811, 0x1461, 0x28c2, 0x15c7, 0x2b8e, 0x135f, 0x26be, 0x093f, 0x127e, 0x24fc, 0x0dbb, 0x1b76, 0x36ec,
        0x299b, 0x1775, 0x2eea, 0x1997, 0x332e, 0x221f, 0x007d, 0x00fa, 0x01f4, 0x03e8, 0x07d0, 0x0fa0, 0x1f40, 0x3e80, 0x3943, 0x36c5,
        0x29c9, 0x17d1, 0x2fa2, 0x1b07, 0x360e, 0x285f, 0x14fd, 0x29fa, 0x17b7, 0x2f6e, 0x1a9f, 0x353e, 0x2e3f, 0x183d, 0x307a, 0x24b7,
        0x0d2d, 0x1a5a, 0x34b4, 0x2d2b, 0x1e15, 0x3c2a, 0x3c17, 0x3c6d, 0x3c99, 0x3d71, 0x3ea1, 0x3901, 0x3641, 0x28c1, 0x15c1, 0x2b82,
        0x1347, 0x268e, 0x095f, 0x12be, 0x257c, 0x0ebb, 0x1d76, 0x3aec, 0x319b, 0x2775, 0x0aa9, 0x1552, 0x2aa4, 0x110b, 0x2216, 0x006f,
        0x00de, 0x01bc, 0x0378, 0x06f0, 0x0de0, 0x1bc0, 0x3780, 0x2b43, 0x12c5, 0x258a, 0x0f57, 0x1eae, 0x3d5c, 0x3efb, 0x39b5, 0x3729,
        0x2a11, 0x1061, 0x20c2, 0x05c7, 0x0b8e, 0x171c, 0x2e38, 0x1833, 0x3066, 0x248f, 0x0d5d, 0x1aba, 0x3574, 0x2eab, 0x1915, 0x322a,
        0x2017, 0x046d, 0x08da, 0x11b4, 0x2368, 0x0293, 0x0526, 0x0a4c, 0x1498, 0x2930, 0x1623, 0x2c46, 0x1ccf, 0x399e, 0x377f, 0x2abd,
        0x1139, 0x2272, 0x00a7, 0x014e, 0x029c, 0x0538, 0x0a70, 0x14e0, 0x29c0, 0x17c3, 0x2f86, 0x1b4f, 0x369e, 0x297f, 0x16bd, 0x2d7a,
        0x1eb7, 0x3d6e, 0x3e9f, 0x397d, 0x36b9, 0x2931, 0x1621, 0x2c42, 0x1cc7, 0x398e, 0x375f, 0x2afd, 0x11b9, 0x2372, 0x02a7, 0x054e,
        0x0a9c, 0x1538, 0x2a70, 0x10a3, 0x2146, 0x06cf, 0x0d9e, 0x1b3c, 0x3678, 0x28b3, 0x1525, 0x2a4a, 0x10d7, 0x21ae, 0x071f, 0x0e3e,
        0x1c7c, 0x38f8, 0x35b3, 0x2f25, 0x1a09, 0x3412, 0x2c67, 0x1c8d, 0x391a, 0x3677, 0x28ad, 0x1519, 0x2a32, 0x1027, 0x204e, 0x04df,
        0x09be, 0x137c, 0x26f8, 0x09b3, 0x1366, 0x26cc, 0x09db, 0x13b6, 0x276c, 0x0a9b, 0x1536, 0x2a6c, 0x109b, 0x2136, 0x062f, 0x0c5e,
        0x18bc, 0x3178, 0x26b3, 0x0925, 0x124a, 0x2494, 0x0d6b, 0x1ad6, 0x35ac, 0x2f1b, 0x1a75, 0x34ea, 0x2d97, 0x1f6d, 0x3eda, 0x39f7,
        0x37ad, 0x2b19, 0x1271, 0x24e2, 0x0d87, 0x1b0e, 0x361c, 0x287b, 0x14b5, 0x296a, 0x1697, 0x2d2e, 0x1e1f, 0x3c3e, 0x3c3f, 0x3c3d,
        0x3c39, 0x3c31, 0x3c21, 0x3c01, 0x3c41, 0x3cc1, 0x3dc1, 0x3fc1, 0x3bc1, 0x33c1, 0x23c1, 0x03c1, 0x0782, 0x0f04, 0x1e08, 0x3c10,
        0x3c63, 0x3c85, 0x3d49, 0x3ed1, 0x39e1, 0x3781, 0x2b41, 0x12c1, 0x2582, 0x0f47, 0x1e8e, 0x3d1c, 0x3e7b, 0x38b5, 0x3529, 0x2e11,
        0x1861, 0x30c2, 0x25c7, 0x0fcd, 0x1f9a, 0x3f34, 0x3a2b, 0x3015, 0x2469, 0x0c91, 0x1922, 0x3244, 0x20cb, 0x05d5, 0x0baa, 0x1754,
        0x2ea8, 0x1913, 0x3226, 0x200f, 0x045d, 0x08ba, 0x1174, 0x22e8, 0x0193, 0x0326, 0x064c, 0x0c98, 0x1930, 0x3260, 0x2083, 0x0545,
        0x0a8a, 0x1514, 0x2a28, 0x1013, 0x2026, 0x040f, 0x081e, 0x103c, 0x2078, 0x04b3, 0x0966, 0x12cc, 0x2598, 0x0f73, 0x1ee6, 0x3dcc,
        0x3fdb, 0x3bf5, 0x33a9, 0x2311, 0x0261, 0x04c2, 0x0984, 0x1308, 0x2610, 0x0863, 0x10c6, 0x218c, 0x075b, 0x0eb6, 0x1d6c, 0x3ad8,
        0x31f3, 0x27a5, 0x0b09, 0x1612, 0x2c24, 0x1c0b, 0x3816, 0x346f, 0x2c9d, 0x1d79, 0x3af2, 0x31a7, 0x270d, 0x0a59, 0x14b2, 0x2964,
        0x168b, 0x2d16, 0x1e6f, 0x3cde, 0x3dff, 0x3fbd, 0x3b39, 0x3231, 0x2021, 0x0401, 0x0802, 0x1004, 0x2008, 0x0453, 0x08a6, 0x114c,
        0x2298, 0x0173, 0x02e6, 0x05cc, 0x0b98, 0x1730, 0x2e60, 0x1883, 0x3106, 0x264f, 0x08dd, 0x11ba, 0x2374, 0x02ab, 0x0556, 0x0aac,
        0x1558, 0x2ab0, 0x1123, 0x2246, 0x00cf, 0x019e, 0x033c, 0x0678, 0x0cf0, 0x19e0, 0x33c0, 0x23c3, 0x03c5, 0x078a, 0x0f14, 0x1e28,
        0x3c50, 0x3ce3, 0x3d85, 0x3f49, 0x3ad1, 0x31e1, 0x2781, 0x0b41, 0x1682, 0x2d04, 0x1e4b, 0x3c96, 0x3d6f, 0x3e9d, 0x3979, 0x36b1,
        0x2921, 0x1601, 0x2c02, 0x1c47, 0x388e, 0x355f, 0x2efd, 0x19b9, 0x3372, 0x22a7, 0x010d, 0x021a, 0x0434, 0x0868, 0x10d0, 0x21a0,
        0x0703, 0x0e06, 0x1c0c, 0x3818, 0x3473, 0x2ca5, 0x1d09, 0x3a12, 0x3067, 0x248d, 0x0d59, 0x1ab2, 0x3564, 0x2e8b, 0x1955, 0x32aa,
        0x2117, 0x066d, 0x0cda, 0x19b4, 0x3368, 0x2293, 0x0165, 0x02ca, 0x0594, 0x0b28, 0x1650, 0x2ca0, 0x1d03, 0x3a06, 0x304f, 0x24dd,
        0x0df9, 0x1bf2, 0x37e4, 0x2b8b, 0x1355, 0x26aa, 0x0917, 0x122e, 0x245c, 0x0cfb, 0x19f6, 0x33ec, 0x239b, 0x0375, 0x06ea, 0x0dd4,
        0x1ba8, 0x3750, 0x2ae3, 0x1185, 0x230a, 0x0257, 0x04ae, 0x095c, 0x12b8, 0x2570, 0x0ea3, 0x1d46, 0x3a8c, 0x315b, 0x26f5, 0x09a9,
        0x1352, 0x26a4, 0x090b, 0x1216, 0x242c, 0x0c1b, 0x1836, 0x306c, 0x249b, 0x0d75, 0x1aea, 0x35d4, 0x2feb, 0x1b95, 0x372a, 0x2a17,
        0x106d, 0x20da, 0x05f7, 0x0bee, 0x17dc, 0x2fb8, 0x1b33, 0x3666, 0x288f, 0x155d, 0x2aba, 0x1137, 0x226e, 0x009f, 0x013e, 0x027c,
        0x04f8, 0x09f0, 0x13e0, 0x27c0, 0x0bc3, 0x1786, 0x2f0c, 0x1a5b, 0x34b6, 0x2d2f, 0x1e1d, 0x3c3a, 0x3c37, 0x3c2d, 0x3c19, 0x3c71,
        0x3ca1, 0x3d01, 0x3e41, 0x38c1, 0x35c1, 0x2fc1, 0x1bc1, 0x3782, 0x2b47, 0x12cd, 0x259a, 0x0f77, 0x1eee, 0x3ddc, 0x3ffb, 0x3bb5,
        0x3329, 0x2211, 0x0061, 0x00c2, 0x0184, 0x0308, 0x0610, 0x0c20, 0x1840, 0x3080, 0x2543, 0x0ec5, 0x1d8a, 0x3b14, 0x326b, 0x2095,
        0x0569, 0x0ad2, 0x15a4, 0x2b48, 0x12d3, 0x25a6, 0x0f0f, 0x1e1e, 0x3c3c, 0x3c3b, 0x3c35, 0x3c29, 0x3c11, 0x3c61, 0x3c81, 0x3d41,
        0x3ec1, 0x39c1, 0x37c1, 0x2bc1, 0x13c1, 0x2782, 0x0b47, 0x168e, 0x2d1c, 0x1e7b, 0x3cf6, 0x3daf, 0x3f1d, 0x3a79, 0x30b1, 0x2521,
        0x0e01, 0x1c02, 0x3804, 0x344b, 0x2cd5, 0x1de9, 0x3bd2, 0x33e7, 0x238d, 0x0359, 0x06b2, 0x0d64, 0x1ac8, 0x3590, 0x2f63, 0x1a85,
        0x350a, 0x2e57, 0x18ed, 0x31da, 0x27f7, 0x0bad, 0x175a, 0x2eb4, 0x192b, 0x3256, 0x20ef, 0x059d, 0x0b3a, 0x1674, 0x2ce8, 0x1d93,
        0x3b26, 0x320f, 0x205d, 0x04f9, 0x09f2, 0x13e4, 0x27c8, 0x0bd3, 0x17a6, 0x2f4c, 0x1adb, 0x35b6, 0x2f2f, 0x1a1d, 0x343a, 0x2c37,
        0x1c2d, 0x385a, 0x34f7, 0x2dad, 0x1f19, 0x3e32, 0x3827, 0x340d, 0x2c59, 0x1cf1, 0x39e2, 0x3787, 0x2b4d, 0x12d9, 0x25b2, 0x0f27,
        0x1e4e, 0x3c9c, 0x3d7b, 0x3eb5, 0x3929, 0x3611, 0x2861, 0x1481, 0x2902, 0x1647, 0x2c8e, 0x1d5f, 0x3abe, 0x313f, 0x263d, 0x0839,
        0x1072, 0x20e4, 0x058b, 0x0b16, 0x162c, 0x2c58, 0x1cf3, 0x39e6, 0x378f, 0x2b5d, 0x12f9, 0x25f2, 0x0fa7, 0x1f4e, 0x3e9c, 0x397b,
        0x36b5, 0x2929, 0x1611, 0x2c22, 0x1c07, 0x380e, 0x345f, 0x2cfd, 0x1db9, 0x3b72, 0x32a7, 0x210d, 0x0659, 0x0cb2, 0x1964, 0x32c8,
        0x21d3, 0x07e5, 0x0fca, 0x1f94, 0x3f28, 0x3a13, 0x3065, 0x2489, 0x0d51, 0x1aa2, 0x3544, 0x2ecb, 0x19d5, 0x33aa, 0x2317, 0x026d,
        0x04da, 0x09b4, 0x1368, 0x26d0, 0x09e3, 0x13c6, 0x278c, 0x0b5b, 0x16b6, 0x2d6c, 0x1e9b, 0x3d36, 0x3e2f, 0x381d, 0x3479, 0x2cb1,
        0x1d21, 0x3a42, 0x30c7, 0x25cd, 0x0fd9, 0x1fb2, 0x3f64, 0x3a8b, 0x3155, 0x26e9, 0x0991, 0x1322, 0x2644, 0x08cb, 0x1196, 0x232c,
        0x021b, 0x0436, 0x086c, 0x10d8, 0x21b0, 0x0723, 0x0e46, 0x1c8c, 0x3918, 0x3673, 0x28a5, 0x1509, 0x2a12, 0x1067, 0x20ce, 0x05df,
        0x0bbe, 0x177c, 0x2ef8, 0x19b3, 0x3366, 0x228f, 0x015d, 0x02ba, 0x0574, 0x0ae8, 0x15d0, 0x2ba0, 0x1303, 0x2606, 0x084f, 0x109e,
        0x213c, 0x063b, 0x0c76, 0x18ec, 0x31d8, 0x27f3, 0x0ba5, 0x174a, 0x2e94, 0x196b, 0x32d6, 0x21ef, 0x079d, 0x0f3a, 0x1e74, 0x3ce8,
        0x3d93, 0x3f65, 0x3a89, 0x3151, 0x26e1, 0x0981, 0x1302, 0x2604, 0x084b, 0x1096, 0x212c, 0x061b, 0x0c36, 0x186c, 0x30d8, 0x25f3,
        0x0fa5, 0x1f4a, 0x3e94, 0x396b, 0x3695, 0x2969, 0x1691, 0x2d22, 0x1e07, 0x3c0e, 0x3c5f, 0x3cfd, 0x3db9, 0x3f31, 0x3a21, 0x3001,
        0x2441, 0x0cc1, 0x1982, 0x3304, 0x224b, 0x00d5, 0x01aa, 0x0354, 0x06a8, 0x0d50, 0x1aa0, 0x3540, 0x2ec3, 0x19c5, 0x338a, 0x2357,
        0x02ed, 0x05da, 0x0bb4, 0x1768, 0x2ed0, 0x19e3, 0x33c6, 0x23cf, 0x03dd, 0x07ba, 0x0f74, 0x1ee8, 0x3dd0, 0x3fe3, 0x3b85, 0x3349,
        0x22d1, 0x01e1, 0x03c2, 0x0784, 0x0f08, 0x1e10, 0x3c20, 0x3c03, 0x3c45, 0x3cc9, 0x3dd1, 0x3fe1, 0x3b81, 0x3341, 0x22c1, 0x01c1,
        0x0382, 0x0704, 0x0e08, 0x1c10, 0x3820, 0x3403, 0x2c45, 0x1cc9, 0x3992, 0x3767, 0x2a8d, 0x1159, 0x22b2, 0x0127, 0x024e, 0x049c,
        0x0938, 0x1270, 0x24e0, 0x0d83, 0x1b06, 0x360c, 0x285b, 0x14f5, 0x29ea, 0x1797, 0x2f2e, 0x1a1f, 0x343e, 0x2c3f, 0x1c3d, 0x387a,
        0x34b7, 0x2d2d, 0x1e19, 0x3c32, 0x3c27, 0x3c0d, 0x3c59, 0x3cf1, 0x3da1, 0x3f01, 0x3a41, 0x30c1, 0x25c1, 0x0fc1, 0x1f82, 0x3f04,
        0x3a4b, 0x30d5, 0x25e9, 0x0f91, 0x1f22, 0x3e44, 0x38cb, 0x35d5, 0x2fe9, 0x1b91, 0x3722, 0x2a07, 0x104d, 0x209a, 0x0577, 0x0aee,
        0x15dc, 0x2bb8, 0x1333, 0x2666, 0x088f, 0x111e, 0x223c, 0x003b, 0x0076, 0x00ec, 0x01d8, 0x03b0, 0x0760, 0x0ec0, 0x1d80, 0x3b00,
        0x3243, 0x20c5, 0x05c9, 0x0b92, 0x1724, 0x2e48, 0x18d3, 0x31a6, 0x270f, 0x0a5d, 0x14ba, 0x2974, 0x16ab, 0x2d56, 0x1eef, 0x3dde,
        0x3fff, 0x3bbd, 0x3339, 0x2231, 0x0021, 0x0042, 0x0084, 0x0108, 0x0210, 0x0420, 0x0840, 0x1080, 0x2100, 0x0643, 0x0c86, 0x190c,
        0x3218, 0x2073, 0x04a5, 0x094a, 0x1294, 0x2528, 0x0e13, 0x1c26, 0x384c, 0x34db, 0x2df5, 0x1fa9, 0x3f52, 0x3ae7, 0x318d, 0x2759,
        0x0af1, 0x15e2, 0x2bc4, 0x13cb, 0x2796, 0x0b6f, 0x16de, 0x2dbc, 0x1f3b, 0x3e76, 0x38af, 0x351d, 0x2e79, 0x18b1, 0x3162, 0x2687,
        0x094d, 0x129a, 0x2534, 0x0e2b, 0x1c56, 0x38ac, 0x351b, 0x2e75, 0x18a9, 0x3152, 0x26e7, 0x098d, 0x131a, 0x2634, 0x082b, 0x1056,
        0x20ac, 0x051b, 0x0a36, 0x146c, 0x28d8, 0x15f3, 0x2be6, 0x138f, 0x271e, 0x0a7f, 0x14fe, 0x29fc, 0x17bb, 0x2f76, 0x1aaf, 0x355e,
        0x2eff, 0x19bd, 0x337a, 0x22b7, 0x012d, 0x025a, 0x04b4, 0x0968, 0x12d0, 0x25a0, 0x0f03, 0x1e06, 0x3c0c, 0x3c5b, 0x3cf5, 0x3da9,
        0x3f11, 0x3a61, 0x3081, 0x2541, 0x0ec1, 0x1d82, 0x3b04, 0x324b, 0x20d5, 0x05e9, 0x0bd2, 0x17a4, 0x2f48, 0x1ad3, 0x35a6, 0x2f0f,
        0x1a5d, 0x34ba, 0x2d37, 0x1e2d, 0x3c5a, 0x3cf7, 0x3dad, 0x3f19, 0x3a71, 0x30a1, 0x2501, 0x0e41, 0x1c82, 0x3904, 0x364b, 0x28d5,
        0x15e9, 0x2bd2, 0x13e7, 0x27ce, 0x0bdf, 0x17be, 0x2f7c, 0x1abb, 0x3576, 0x2eaf, 0x191d, 0x323a, 0x2037, 0x042d, 0x085a, 0x10b4,
        0x2168, 0x0693, 0x0d26, 0x1a4c, 0x3498, 0x2d73, 0x1ea5, 0x3d4a, 0x3ed7, 0x39ed, 0x3799, 0x2b71, 0x12a1, 0x2542, 0x0ec7, 0x1d8e,
        0x3b1c, 0x327b, 0x20b5, 0x0529, 0x0a52, 0x14a4, 0x2948, 0x16d3, 0x2da6, 0x1f0f, 0x3e1e, 0x387f, 0x34bd, 0x2d39, 0x1e31, 0x3c62,
        0x3c87, 0x3d4d, 0x3ed9, 0x39f1, 0x37a1, 0x2b01, 0x1241, 0x2482, 0x0d47, 0x1a8e, 0x351c, 0x2e7b, 0x18b5, 0x316a, 0x2697, 0x096d,
        0x12da, 0x25b4, 0x0f2b, 0x1e56, 0x3cac, 0x3d1b, 0x3e75, 0x38a9, 0x3511, 0x2e61, 0x1881, 0x3102, 0x2647, 0x08cd, 0x119a, 0x2334,
        0x022b, 0x0456, 0x08ac, 0x1158, 0x22b0, 0x0123, 0x0246, 0x048c, 0x0918, 0x1230, 0x2460, 0x0c83, 0x1906, 0x320c, 0x205b, 0x04f5,
        0x09ea, 0x13d4, 0x27a8, 0x0b13, 0x1626, 0x2c4c, 0x1cdb, 0x39b6, 0x372f, 0x2a1d, 0x1079, 0x20f2, 0x05a7, 0x0b4e, 0x169c, 0x2d38,
        0x1e33, 0x3c66, 0x3c8f, 0x3d5d, 0x3ef9, 0x39b1, 0x3721, 0x2a01, 0x1041, 0x2082, 0x0547, 0x0a8e, 0x151c, 0x2a38, 0x1033, 0x2066,
        0x048f, 0x091e, 0x123c, 0x2478, 0x0cb3, 0x1966, 0x32cc, 0x21db, 0x07f5, 0x0fea, 0x1fd4, 0x3fa8, 0x3b13, 0x3265, 0x2089, 0x0551,
        0x0aa2, 0x1544, 0x2a88, 0x1153, 0x22a6, 0x010f, 0x021e, 0x043c, 0x0878, 0x10f0, 0x21e0, 0x0783, 0x0f06, 0x1e0c, 0x3c18, 0x3c73,
        0x3ca5, 0x3d09, 0x3e51, 0x38e1, 0x3581, 0x2f41, 0x1ac1, 0x3582, 0x2f47, 0x1acd, 0x359a, 0x2f77, 0x1aad, 0x355a, 0x2ef7, 0x19ad,
        0x335a, 0x22f7, 0x01ad, 0x035a, 0x06b4, 0x0d68, 0x1ad0, 0x35a0, 0x2f03, 0x1a45, 0x348a, 0x2d57, 0x1eed, 0x3dda, 0x3ff7, 0x3bad,
        0x3319, 0x2271, 0x00a1, 0x0142, 0x0284, 0x0508, 0x0a10, 0x1420, 0x2840, 0x14c3, 0x2986, 0x174f, 0x2e9e, 0x197f, 0x32fe, 0x21bf,
        0x073d, 0x0e7a, 0x1cf4, 0x39e8, 0x3793, 0x2b65, 0x1289, 0x2512, 0x0e67, 0x1cce, 0x399c, 0x377b, 0x2ab5, 0x1129, 0x2252, 0x00e7,
        0x01ce, 0x039c, 0x0738, 0x0e70, 0x1ce0, 0x39c0, 0x37c3, 0x2bc5, 0x13c9, 0x2792, 0x0b67, 0x16ce, 0x2d9c, 0x1f7b, 0x3ef6, 0x39af,
        0x371d, 0x2a79, 0x10b1, 0x2162, 0x0687, 0x0d0e, 0x1a1c, 0x3438, 0x2c33, 0x1c25, 0x384a, 0x34d7, 0x2ded, 0x1f99, 0x3f32, 0x3a27,
        0x300d, 0x2459, 0x0cf1, 0x19e2, 0x33c4, 0x23cb, 0x03d5, 0x07aa, 0x0f54, 0x1ea8, 0x3d50, 0x3ee3, 0x3985, 0x3749, 0x2ad1, 0x11e1,
        0x23c2, 0x03c7, 0x078e, 0x0f1c, 0x1e38, 0x3c70, 0x3ca3, 0x3d05, 0x3e49, 0x38d1, 0x35e1, 0x2f81, 0x1b41, 0x3682, 0x2947, 0x16cd,
        0x2d9a, 0x1f77, 0x3eee, 0x399f, 0x377d, 0x2ab9, 0x1131, 0x2262, 0x0087, 0x010e, 0x021c, 0x0438, 0x0870, 0x10e0, 0x21c0, 0x07c3,
        0x0f86, 0x1f0c, 0x3e18, 0x3873, 0x34a5, 0x2d09, 0x1e51, 0x3ca2, 0x3d07, 0x3e4d, 0x38d9, 0x35f1, 0x2fa1, 0x1b01, 0x3602, 0x2847,
        0x14cd, 0x299a, 0x1777, 0x2eee, 0x199f, 0x333e, 0x223f, 0x003d, 0x007a, 0x00f4, 0x01e8, 0x03d0, 0x07a0, 0x0f40, 0x1e80, 0x3d00,
        0x3e43, 0x38c5, 0x35c9, 0x2fd1, 0x1be1, 0x37c2, 0x2bc7, 0x13cd, 0x279a, 0x0b77, 0x16ee, 0x2ddc, 0x1ffb, 0x3ff6, 0x3baf, 0x331d,
        0x2279, 0x00b1, 0x0162, 0x02c4, 0x0588, 0x0b10, 0x1620, 0x2c40, 0x1cc3, 0x3986, 0x374f, 0x2add, 0x11f9, 0x23f2, 0x03a7, 0x074e,
        0x0e9c, 0x1d38, 0x3a70, 0x30a3, 0x2505, 0x0e49, 0x1c92, 0x3924, 0x360b, 0x2855, 0x14e9, 0x29d2, 0x17e7, 0x2fce, 0x1bdf, 0x37be,
        0x2b3f, 0x123d, 0x247a, 0x0cb7, 0x196e, 0x32dc, 0x21fb, 0x07b5, 0x0f6a, 0x1ed4, 0x3da8, 0x3f13, 0x3a65, 0x3089, 0x2551, 0x0ee1,
        0x1dc2, 0x3b84, 0x334b, 0x22d5, 0x01e9, 0x03d2, 0x07a4, 0x0f48, 0x1e90, 0x3d20, 0x3e03, 0x3845, 0x34c9, 0x2dd1, 0x1fe1, 0x3fc2,
        0x3bc7, 0x33cd, 0x23d9, 0x03f1, 0x07e2, 0x0fc4, 0x1f88, 0x3f10, 0x3a63, 0x3085, 0x2549, 0x0ed1, 0x1da2, 0x3b44, 0x32cb, 0x21d5,
        0x07e9, 0x0fd2, 0x1fa4, 0x3f48, 0x3ad3, 0x31e5, 0x2789, 0x0b51, 0x16a2, 0x2d44, 0x1ecb, 0x3d96, 0x3f6f, 0x3a9d, 0x3179, 0x26b1,
        0x0921, 0x1242, 0x2484, 0x0d4b, 0x1a96, 0x352c, 0x2e1b, 0x1875, 0x30ea, 0x2597, 0x0f6d, 0x1eda, 0x3db4, 0x3f2b, 0x3a15, 0x3069,
        0x2491, 0x0d61, 0x1ac2, 0x3584, 0x2f4b, 0x1ad5, 0x35aa, 0x2f17, 0x1a6d, 0x34da, 0x2df7, 0x1fad, 0x3f5a, 0x3af7, 0x31ad, 0x2719,
        0x0a71, 0x14e2, 0x29c4, 0x17cb, 0x2f96, 0x1b6f, 0x36de, 0x29ff, 0x17bd, 0x2f7a, 0x1ab7, 0x356e, 0x2e9f, 0x197d, 0x32fa, 0x21b7,
        0x072d, 0x0e5a, 0x1cb4, 0x3968, 0x3693, 0x2965, 0x1689, 0x2d12, 0x1e67, 0x3cce, 0x3ddf, 0x3ffd, 0x3bb9, 0x3331, 0x2221, 0x0001
    }
};
#endif
