#include "nvm.h"


enum status_code nvm_write_buffer
(
const uint32_t destination_address,
const uint8_t *buffer,
uint16_t length
)
{
		
		uint32_t *dst = (uint32_t *)destination_address;
		uint32_t *src = (uint32_t*)buffer;		
		if (destination_address >(FLASH_NB_OF_PAGES * FLASH_PAGE_SIZE))
		{
			return STATUS_ERR_BAD_ADDRESS;
		}
		while (0 == NVMCTRL->STATUS.bit.READY);
		NVMCTRL->ADDR.reg = destination_address;
		for (int i = 0; i < WORDS(FLASH_PAGE_SIZE); i++)
			dst[i] = src[i];
		while (0 == NVMCTRL->STATUS.bit.READY);
		return STATUS_OK;
}

enum status_code nvm_erase_row
(
const uint32_t row_address
)
{
		/* Check if the row address is valid */
		if (row_address >((uint32_t)FLASH_PAGE_SIZE * FLASH_NB_OF_PAGES)) 
		{
			return STATUS_ERR_BAD_ADDRESS;
		}

		NVMCTRL->ADDR.reg = row_address;
		NVMCTRL->CTRLB.reg = NVMCTRL_CTRLB_CMDEX_KEY | NVMCTRL_CTRLB_CMD_EB;
		while (0 == NVMCTRL->STATUS.bit.READY);
		return STATUS_OK;
}

enum status_code nvm_execute_command
(
const enum nvm_command command,
const uint32_t address,
const uint32_t parameter
)
{
	
	if (address > ((uint32_t)FLASH_PAGE_SIZE * FLASH_NB_OF_PAGES))
	{
		return STATUS_ERR_BAD_ADDRESS;
	}
	while (0 == NVMCTRL->STATUS.bit.READY)
	{
		return STATUS_BUSY;
	}
	switch (command)
	{
		case NVM_COMMAND_LOCK_REGION: NVMCTRL->ADDR.reg = address;
										break;
		case NVM_COMMAND_UNLOCK_REGION: NVMCTRL->ADDR.reg = address;
										break;
		case NVM_COMMAND_SET_SECURITY_BIT: break;
		default:	return STATUS_ERR_INVALID_ARG;	
	}
	NVMCTRL->CTRLB.reg = NVMCTRL_CTRLB_CMDEX_KEY | command;
	while (0 == NVMCTRL->STATUS.bit.READY);
	return STATUS_OK;
}

bool nvm_is_page_locked(uint16_t page_number)
{
		uint16_t pages_in_region;
		uint32_t region_number;
		pages_in_region = FLASH_NB_OF_PAGES / 32;
		region_number = page_number / pages_in_region;
		return !(NVMCTRL->RUNLOCK.reg & (1 << region_number));
}
void nvm_init(void)
{
	MCLK->APBBMASK.reg |= MCLK_APBBMASK_NVMCTRL;
	MCLK->AHBMASK.reg |= MCLK_AHBMASK_NVMCTRL | MCLK_AHBMASK_NVMCTRL_CACHE;
	NVMCTRL->CTRLA.reg = NVMCTRL_CTRLA_CACHEDIS1 | NVMCTRL_CTRLA_CACHEDIS0 | NVMCTRL_CTRLA_AUTOWS | NVMCTRL_CTRLA_WMODE_AP;
}