/**
 * \file
 *
 * \brief Peripheral I/O description for SAML22G18A
 *
 * Copyright (c) 2015 Atmel Corporation. All rights reserved.
 *
 * \asf_license_start
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 *    Atmel microcontroller product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * \asf_license_stop
 *
 */

#ifndef _SAML22G18A_PIO_
#define _SAML22G18A_PIO_

#define PIN_PA00                           0  /**< \brief Pin Number for PA00 */
#define PORT_PA00                 (1ul <<  0) /**< \brief PORT Mask  for PA00 */
#define PIN_PA01                           1  /**< \brief Pin Number for PA01 */
#define PORT_PA01                 (1ul <<  1) /**< \brief PORT Mask  for PA01 */
#define PIN_PA02                           2  /**< \brief Pin Number for PA02 */
#define PORT_PA02                 (1ul <<  2) /**< \brief PORT Mask  for PA02 */
#define PIN_PA03                           3  /**< \brief Pin Number for PA03 */
#define PORT_PA03                 (1ul <<  3) /**< \brief PORT Mask  for PA03 */
#define PIN_PA04                           4  /**< \brief Pin Number for PA04 */
#define PORT_PA04                 (1ul <<  4) /**< \brief PORT Mask  for PA04 */
#define PIN_PA05                           5  /**< \brief Pin Number for PA05 */
#define PORT_PA05                 (1ul <<  5) /**< \brief PORT Mask  for PA05 */
#define PIN_PA06                           6  /**< \brief Pin Number for PA06 */
#define PORT_PA06                 (1ul <<  6) /**< \brief PORT Mask  for PA06 */
#define PIN_PA07                           7  /**< \brief Pin Number for PA07 */
#define PORT_PA07                 (1ul <<  7) /**< \brief PORT Mask  for PA07 */
#define PIN_PA08                           8  /**< \brief Pin Number for PA08 */
#define PORT_PA08                 (1ul <<  8) /**< \brief PORT Mask  for PA08 */
#define PIN_PA09                           9  /**< \brief Pin Number for PA09 */
#define PORT_PA09                 (1ul <<  9) /**< \brief PORT Mask  for PA09 */
#define PIN_PA10                          10  /**< \brief Pin Number for PA10 */
#define PORT_PA10                 (1ul << 10) /**< \brief PORT Mask  for PA10 */
#define PIN_PA11                          11  /**< \brief Pin Number for PA11 */
#define PORT_PA11                 (1ul << 11) /**< \brief PORT Mask  for PA11 */
#define PIN_PA12                          12  /**< \brief Pin Number for PA12 */
#define PORT_PA12                 (1ul << 12) /**< \brief PORT Mask  for PA12 */
#define PIN_PA13                          13  /**< \brief Pin Number for PA13 */
#define PORT_PA13                 (1ul << 13) /**< \brief PORT Mask  for PA13 */
#define PIN_PA14                          14  /**< \brief Pin Number for PA14 */
#define PORT_PA14                 (1ul << 14) /**< \brief PORT Mask  for PA14 */
#define PIN_PA15                          15  /**< \brief Pin Number for PA15 */
#define PORT_PA15                 (1ul << 15) /**< \brief PORT Mask  for PA15 */
#define PIN_PA16                          16  /**< \brief Pin Number for PA16 */
#define PORT_PA16                 (1ul << 16) /**< \brief PORT Mask  for PA16 */
#define PIN_PA17                          17  /**< \brief Pin Number for PA17 */
#define PORT_PA17                 (1ul << 17) /**< \brief PORT Mask  for PA17 */
#define PIN_PA18                          18  /**< \brief Pin Number for PA18 */
#define PORT_PA18                 (1ul << 18) /**< \brief PORT Mask  for PA18 */
#define PIN_PA19                          19  /**< \brief Pin Number for PA19 */
#define PORT_PA19                 (1ul << 19) /**< \brief PORT Mask  for PA19 */
#define PIN_PA20                          20  /**< \brief Pin Number for PA20 */
#define PORT_PA20                 (1ul << 20) /**< \brief PORT Mask  for PA20 */
#define PIN_PA21                          21  /**< \brief Pin Number for PA21 */
#define PORT_PA21                 (1ul << 21) /**< \brief PORT Mask  for PA21 */
#define PIN_PA22                          22  /**< \brief Pin Number for PA22 */
#define PORT_PA22                 (1ul << 22) /**< \brief PORT Mask  for PA22 */
#define PIN_PA23                          23  /**< \brief Pin Number for PA23 */
#define PORT_PA23                 (1ul << 23) /**< \brief PORT Mask  for PA23 */
#define PIN_PA24                          24  /**< \brief Pin Number for PA24 */
#define PORT_PA24                 (1ul << 24) /**< \brief PORT Mask  for PA24 */
#define PIN_PA25                          25  /**< \brief Pin Number for PA25 */
#define PORT_PA25                 (1ul << 25) /**< \brief PORT Mask  for PA25 */
#define PIN_PA27                          27  /**< \brief Pin Number for PA27 */
#define PORT_PA27                 (1ul << 27) /**< \brief PORT Mask  for PA27 */
#define PIN_PA30                          30  /**< \brief Pin Number for PA30 */
#define PORT_PA30                 (1ul << 30) /**< \brief PORT Mask  for PA30 */
#define PIN_PA31                          31  /**< \brief Pin Number for PA31 */
#define PORT_PA31                 (1ul << 31) /**< \brief PORT Mask  for PA31 */
#define PIN_PB02                          34  /**< \brief Pin Number for PB02 */
#define PORT_PB02                 (1ul <<  2) /**< \brief PORT Mask  for PB02 */
#define PIN_PB03                          35  /**< \brief Pin Number for PB03 */
#define PORT_PB03                 (1ul <<  3) /**< \brief PORT Mask  for PB03 */
#define PIN_PB08                          40  /**< \brief Pin Number for PB08 */
#define PORT_PB08                 (1ul <<  8) /**< \brief PORT Mask  for PB08 */
#define PIN_PB09                          41  /**< \brief Pin Number for PB09 */
#define PORT_PB09                 (1ul <<  9) /**< \brief PORT Mask  for PB09 */
#define PIN_PB11                          43  /**< \brief Pin Number for PB11 */
#define PORT_PB11                 (1ul << 11) /**< \brief PORT Mask  for PB11 */
#define PIN_PB22                          54  /**< \brief Pin Number for PB22 */
#define PORT_PB22                 (1ul << 22) /**< \brief PORT Mask  for PB22 */
#define PIN_PB23                          55  /**< \brief Pin Number for PB23 */
#define PORT_PB23                 (1ul << 23) /**< \brief PORT Mask  for PB23 */
/* ========== PORT definition for SUPC peripheral ========== */
#define PIN_PB02H_SUPC_OUT1               34L  /**< \brief SUPC signal: OUT1 on PB02 mux H */
#define MUX_PB02H_SUPC_OUT1                7L
#define PINMUX_PB02H_SUPC_OUT1     ((PIN_PB02H_SUPC_OUT1 << 16) | MUX_PB02H_SUPC_OUT1)
#define PORT_PB02H_SUPC_OUT1       (1ul <<  2)
#define PIN_PB03H_SUPC_VBAT               35L  /**< \brief SUPC signal: VBAT on PB03 mux H */
#define MUX_PB03H_SUPC_VBAT                7L
#define PINMUX_PB03H_SUPC_VBAT     ((PIN_PB03H_SUPC_VBAT << 16) | MUX_PB03H_SUPC_VBAT)
#define PORT_PB03H_SUPC_VBAT       (1ul <<  3)
/* ========== PORT definition for GCLK peripheral ========== */
#define PIN_PB22H_GCLK_IO0                54L  /**< \brief GCLK signal: IO0 on PB22 mux H */
#define MUX_PB22H_GCLK_IO0                 7L
#define PINMUX_PB22H_GCLK_IO0      ((PIN_PB22H_GCLK_IO0 << 16) | MUX_PB22H_GCLK_IO0)
#define PORT_PB22H_GCLK_IO0        (1ul << 22)
#define PIN_PA14H_GCLK_IO0                14L  /**< \brief GCLK signal: IO0 on PA14 mux H */
#define MUX_PA14H_GCLK_IO0                 7L
#define PINMUX_PA14H_GCLK_IO0      ((PIN_PA14H_GCLK_IO0 << 16) | MUX_PA14H_GCLK_IO0)
#define PORT_PA14H_GCLK_IO0        (1ul << 14)
#define PIN_PA27H_GCLK_IO0                27L  /**< \brief GCLK signal: IO0 on PA27 mux H */
#define MUX_PA27H_GCLK_IO0                 7L
#define PINMUX_PA27H_GCLK_IO0      ((PIN_PA27H_GCLK_IO0 << 16) | MUX_PA27H_GCLK_IO0)
#define PORT_PA27H_GCLK_IO0        (1ul << 27)
#define PIN_PA30H_GCLK_IO0                30L  /**< \brief GCLK signal: IO0 on PA30 mux H */
#define MUX_PA30H_GCLK_IO0                 7L
#define PINMUX_PA30H_GCLK_IO0      ((PIN_PA30H_GCLK_IO0 << 16) | MUX_PA30H_GCLK_IO0)
#define PORT_PA30H_GCLK_IO0        (1ul << 30)
#define PIN_PB23H_GCLK_IO1                55L  /**< \brief GCLK signal: IO1 on PB23 mux H */
#define MUX_PB23H_GCLK_IO1                 7L
#define PINMUX_PB23H_GCLK_IO1      ((PIN_PB23H_GCLK_IO1 << 16) | MUX_PB23H_GCLK_IO1)
#define PORT_PB23H_GCLK_IO1        (1ul << 23)
#define PIN_PA15H_GCLK_IO1                15L  /**< \brief GCLK signal: IO1 on PA15 mux H */
#define MUX_PA15H_GCLK_IO1                 7L
#define PINMUX_PA15H_GCLK_IO1      ((PIN_PA15H_GCLK_IO1 << 16) | MUX_PA15H_GCLK_IO1)
#define PORT_PA15H_GCLK_IO1        (1ul << 15)
#define PIN_PA16H_GCLK_IO2                16L  /**< \brief GCLK signal: IO2 on PA16 mux H */
#define MUX_PA16H_GCLK_IO2                 7L
#define PINMUX_PA16H_GCLK_IO2      ((PIN_PA16H_GCLK_IO2 << 16) | MUX_PA16H_GCLK_IO2)
#define PORT_PA16H_GCLK_IO2        (1ul << 16)
#define PIN_PA17H_GCLK_IO3                17L  /**< \brief GCLK signal: IO3 on PA17 mux H */
#define MUX_PA17H_GCLK_IO3                 7L
#define PINMUX_PA17H_GCLK_IO3      ((PIN_PA17H_GCLK_IO3 << 16) | MUX_PA17H_GCLK_IO3)
#define PORT_PA17H_GCLK_IO3        (1ul << 17)
#define PIN_PA10H_GCLK_IO4                10L  /**< \brief GCLK signal: IO4 on PA10 mux H */
#define MUX_PA10H_GCLK_IO4                 7L
#define PINMUX_PA10H_GCLK_IO4      ((PIN_PA10H_GCLK_IO4 << 16) | MUX_PA10H_GCLK_IO4)
#define PORT_PA10H_GCLK_IO4        (1ul << 10)
#define PIN_PA20H_GCLK_IO4                20L  /**< \brief GCLK signal: IO4 on PA20 mux H */
#define MUX_PA20H_GCLK_IO4                 7L
#define PINMUX_PA20H_GCLK_IO4      ((PIN_PA20H_GCLK_IO4 << 16) | MUX_PA20H_GCLK_IO4)
#define PORT_PA20H_GCLK_IO4        (1ul << 20)
/* ========== PORT definition for RTC peripheral ========== */
#define PIN_PB02G_RTC_IN1                 34L  /**< \brief RTC signal: IN1 on PB02 mux G */
#define MUX_PB02G_RTC_IN1                  6L
#define PINMUX_PB02G_RTC_IN1       ((PIN_PB02G_RTC_IN1 << 16) | MUX_PB02G_RTC_IN1)
#define PORT_PB02G_RTC_IN1         (1ul <<  2)
#define PIN_PA02G_RTC_IN2                  2L  /**< \brief RTC signal: IN2 on PA02 mux G */
#define MUX_PA02G_RTC_IN2                  6L
#define PINMUX_PA02G_RTC_IN2       ((PIN_PA02G_RTC_IN2 << 16) | MUX_PA02G_RTC_IN2)
#define PORT_PA02G_RTC_IN2         (1ul <<  2)
/* ========== PORT definition for EIC peripheral ========== */
#define PIN_PA16A_EIC_EXTINT0             16L  /**< \brief EIC signal: EXTINT0 on PA16 mux A */
#define MUX_PA16A_EIC_EXTINT0              0L
#define PINMUX_PA16A_EIC_EXTINT0   ((PIN_PA16A_EIC_EXTINT0 << 16) | MUX_PA16A_EIC_EXTINT0)
#define PORT_PA16A_EIC_EXTINT0     (1ul << 16)
#define PIN_PA00A_EIC_EXTINT0              0L  /**< \brief EIC signal: EXTINT0 on PA00 mux A */
#define MUX_PA00A_EIC_EXTINT0              0L
#define PINMUX_PA00A_EIC_EXTINT0   ((PIN_PA00A_EIC_EXTINT0 << 16) | MUX_PA00A_EIC_EXTINT0)
#define PORT_PA00A_EIC_EXTINT0     (1ul <<  0)
#define PIN_PA17A_EIC_EXTINT1             17L  /**< \brief EIC signal: EXTINT1 on PA17 mux A */
#define MUX_PA17A_EIC_EXTINT1              0L
#define PINMUX_PA17A_EIC_EXTINT1   ((PIN_PA17A_EIC_EXTINT1 << 16) | MUX_PA17A_EIC_EXTINT1)
#define PORT_PA17A_EIC_EXTINT1     (1ul << 17)
#define PIN_PA01A_EIC_EXTINT1              1L  /**< \brief EIC signal: EXTINT1 on PA01 mux A */
#define MUX_PA01A_EIC_EXTINT1              0L
#define PINMUX_PA01A_EIC_EXTINT1   ((PIN_PA01A_EIC_EXTINT1 << 16) | MUX_PA01A_EIC_EXTINT1)
#define PORT_PA01A_EIC_EXTINT1     (1ul <<  1)
#define PIN_PA02A_EIC_EXTINT2              2L  /**< \brief EIC signal: EXTINT2 on PA02 mux A */
#define MUX_PA02A_EIC_EXTINT2              0L
#define PINMUX_PA02A_EIC_EXTINT2   ((PIN_PA02A_EIC_EXTINT2 << 16) | MUX_PA02A_EIC_EXTINT2)
#define PORT_PA02A_EIC_EXTINT2     (1ul <<  2)
#define PIN_PA18A_EIC_EXTINT2             18L  /**< \brief EIC signal: EXTINT2 on PA18 mux A */
#define MUX_PA18A_EIC_EXTINT2              0L
#define PINMUX_PA18A_EIC_EXTINT2   ((PIN_PA18A_EIC_EXTINT2 << 16) | MUX_PA18A_EIC_EXTINT2)
#define PORT_PA18A_EIC_EXTINT2     (1ul << 18)
#define PIN_PB02A_EIC_EXTINT2             34L  /**< \brief EIC signal: EXTINT2 on PB02 mux A */
#define MUX_PB02A_EIC_EXTINT2              0L
#define PINMUX_PB02A_EIC_EXTINT2   ((PIN_PB02A_EIC_EXTINT2 << 16) | MUX_PB02A_EIC_EXTINT2)
#define PORT_PB02A_EIC_EXTINT2     (1ul <<  2)
#define PIN_PA03A_EIC_EXTINT3              3L  /**< \brief EIC signal: EXTINT3 on PA03 mux A */
#define MUX_PA03A_EIC_EXTINT3              0L
#define PINMUX_PA03A_EIC_EXTINT3   ((PIN_PA03A_EIC_EXTINT3 << 16) | MUX_PA03A_EIC_EXTINT3)
#define PORT_PA03A_EIC_EXTINT3     (1ul <<  3)
#define PIN_PA19A_EIC_EXTINT3             19L  /**< \brief EIC signal: EXTINT3 on PA19 mux A */
#define MUX_PA19A_EIC_EXTINT3              0L
#define PINMUX_PA19A_EIC_EXTINT3   ((PIN_PA19A_EIC_EXTINT3 << 16) | MUX_PA19A_EIC_EXTINT3)
#define PORT_PA19A_EIC_EXTINT3     (1ul << 19)
#define PIN_PB03A_EIC_EXTINT3             35L  /**< \brief EIC signal: EXTINT3 on PB03 mux A */
#define MUX_PB03A_EIC_EXTINT3              0L
#define PINMUX_PB03A_EIC_EXTINT3   ((PIN_PB03A_EIC_EXTINT3 << 16) | MUX_PB03A_EIC_EXTINT3)
#define PORT_PB03A_EIC_EXTINT3     (1ul <<  3)
#define PIN_PA04A_EIC_EXTINT4              4L  /**< \brief EIC signal: EXTINT4 on PA04 mux A */
#define MUX_PA04A_EIC_EXTINT4              0L
#define PINMUX_PA04A_EIC_EXTINT4   ((PIN_PA04A_EIC_EXTINT4 << 16) | MUX_PA04A_EIC_EXTINT4)
#define PORT_PA04A_EIC_EXTINT4     (1ul <<  4)
#define PIN_PA20A_EIC_EXTINT4             20L  /**< \brief EIC signal: EXTINT4 on PA20 mux A */
#define MUX_PA20A_EIC_EXTINT4              0L
#define PINMUX_PA20A_EIC_EXTINT4   ((PIN_PA20A_EIC_EXTINT4 << 16) | MUX_PA20A_EIC_EXTINT4)
#define PORT_PA20A_EIC_EXTINT4     (1ul << 20)
#define PIN_PA05A_EIC_EXTINT5              5L  /**< \brief EIC signal: EXTINT5 on PA05 mux A */
#define MUX_PA05A_EIC_EXTINT5              0L
#define PINMUX_PA05A_EIC_EXTINT5   ((PIN_PA05A_EIC_EXTINT5 << 16) | MUX_PA05A_EIC_EXTINT5)
#define PORT_PA05A_EIC_EXTINT5     (1ul <<  5)
#define PIN_PA21A_EIC_EXTINT5             21L  /**< \brief EIC signal: EXTINT5 on PA21 mux A */
#define MUX_PA21A_EIC_EXTINT5              0L
#define PINMUX_PA21A_EIC_EXTINT5   ((PIN_PA21A_EIC_EXTINT5 << 16) | MUX_PA21A_EIC_EXTINT5)
#define PORT_PA21A_EIC_EXTINT5     (1ul << 21)
#define PIN_PA06A_EIC_EXTINT6              6L  /**< \brief EIC signal: EXTINT6 on PA06 mux A */
#define MUX_PA06A_EIC_EXTINT6              0L
#define PINMUX_PA06A_EIC_EXTINT6   ((PIN_PA06A_EIC_EXTINT6 << 16) | MUX_PA06A_EIC_EXTINT6)
#define PORT_PA06A_EIC_EXTINT6     (1ul <<  6)
#define PIN_PA22A_EIC_EXTINT6             22L  /**< \brief EIC signal: EXTINT6 on PA22 mux A */
#define MUX_PA22A_EIC_EXTINT6              0L
#define PINMUX_PA22A_EIC_EXTINT6   ((PIN_PA22A_EIC_EXTINT6 << 16) | MUX_PA22A_EIC_EXTINT6)
#define PORT_PA22A_EIC_EXTINT6     (1ul << 22)
#define PIN_PB22A_EIC_EXTINT6             54L  /**< \brief EIC signal: EXTINT6 on PB22 mux A */
#define MUX_PB22A_EIC_EXTINT6              0L
#define PINMUX_PB22A_EIC_EXTINT6   ((PIN_PB22A_EIC_EXTINT6 << 16) | MUX_PB22A_EIC_EXTINT6)
#define PORT_PB22A_EIC_EXTINT6     (1ul << 22)
#define PIN_PA07A_EIC_EXTINT7              7L  /**< \brief EIC signal: EXTINT7 on PA07 mux A */
#define MUX_PA07A_EIC_EXTINT7              0L
#define PINMUX_PA07A_EIC_EXTINT7   ((PIN_PA07A_EIC_EXTINT7 << 16) | MUX_PA07A_EIC_EXTINT7)
#define PORT_PA07A_EIC_EXTINT7     (1ul <<  7)
#define PIN_PA23A_EIC_EXTINT7             23L  /**< \brief EIC signal: EXTINT7 on PA23 mux A */
#define MUX_PA23A_EIC_EXTINT7              0L
#define PINMUX_PA23A_EIC_EXTINT7   ((PIN_PA23A_EIC_EXTINT7 << 16) | MUX_PA23A_EIC_EXTINT7)
#define PORT_PA23A_EIC_EXTINT7     (1ul << 23)
#define PIN_PB23A_EIC_EXTINT7             55L  /**< \brief EIC signal: EXTINT7 on PB23 mux A */
#define MUX_PB23A_EIC_EXTINT7              0L
#define PINMUX_PB23A_EIC_EXTINT7   ((PIN_PB23A_EIC_EXTINT7 << 16) | MUX_PB23A_EIC_EXTINT7)
#define PORT_PB23A_EIC_EXTINT7     (1ul << 23)
#define PIN_PB08A_EIC_EXTINT8             40L  /**< \brief EIC signal: EXTINT8 on PB08 mux A */
#define MUX_PB08A_EIC_EXTINT8              0L
#define PINMUX_PB08A_EIC_EXTINT8   ((PIN_PB08A_EIC_EXTINT8 << 16) | MUX_PB08A_EIC_EXTINT8)
#define PORT_PB08A_EIC_EXTINT8     (1ul <<  8)
#define PIN_PA09A_EIC_EXTINT9              9L  /**< \brief EIC signal: EXTINT9 on PA09 mux A */
#define MUX_PA09A_EIC_EXTINT9              0L
#define PINMUX_PA09A_EIC_EXTINT9   ((PIN_PA09A_EIC_EXTINT9 << 16) | MUX_PA09A_EIC_EXTINT9)
#define PORT_PA09A_EIC_EXTINT9     (1ul <<  9)
#define PIN_PB09A_EIC_EXTINT9             41L  /**< \brief EIC signal: EXTINT9 on PB09 mux A */
#define MUX_PB09A_EIC_EXTINT9              0L
#define PINMUX_PB09A_EIC_EXTINT9   ((PIN_PB09A_EIC_EXTINT9 << 16) | MUX_PB09A_EIC_EXTINT9)
#define PORT_PB09A_EIC_EXTINT9     (1ul <<  9)
#define PIN_PA10A_EIC_EXTINT10            10L  /**< \brief EIC signal: EXTINT10 on PA10 mux A */
#define MUX_PA10A_EIC_EXTINT10             0L
#define PINMUX_PA10A_EIC_EXTINT10  ((PIN_PA10A_EIC_EXTINT10 << 16) | MUX_PA10A_EIC_EXTINT10)
#define PORT_PA10A_EIC_EXTINT10    (1ul << 10)
#define PIN_PA30A_EIC_EXTINT10            30L  /**< \brief EIC signal: EXTINT10 on PA30 mux A */
#define MUX_PA30A_EIC_EXTINT10             0L
#define PINMUX_PA30A_EIC_EXTINT10  ((PIN_PA30A_EIC_EXTINT10 << 16) | MUX_PA30A_EIC_EXTINT10)
#define PORT_PA30A_EIC_EXTINT10    (1ul << 30)
#define PIN_PA11A_EIC_EXTINT11            11L  /**< \brief EIC signal: EXTINT11 on PA11 mux A */
#define MUX_PA11A_EIC_EXTINT11             0L
#define PINMUX_PA11A_EIC_EXTINT11  ((PIN_PA11A_EIC_EXTINT11 << 16) | MUX_PA11A_EIC_EXTINT11)
#define PORT_PA11A_EIC_EXTINT11    (1ul << 11)
#define PIN_PA31A_EIC_EXTINT11            31L  /**< \brief EIC signal: EXTINT11 on PA31 mux A */
#define MUX_PA31A_EIC_EXTINT11             0L
#define PINMUX_PA31A_EIC_EXTINT11  ((PIN_PA31A_EIC_EXTINT11 << 16) | MUX_PA31A_EIC_EXTINT11)
#define PORT_PA31A_EIC_EXTINT11    (1ul << 31)
#define PIN_PB11A_EIC_EXTINT11            43L  /**< \brief EIC signal: EXTINT11 on PB11 mux A */
#define MUX_PB11A_EIC_EXTINT11             0L
#define PINMUX_PB11A_EIC_EXTINT11  ((PIN_PB11A_EIC_EXTINT11 << 16) | MUX_PB11A_EIC_EXTINT11)
#define PORT_PB11A_EIC_EXTINT11    (1ul << 11)
#define PIN_PA12A_EIC_EXTINT12            12L  /**< \brief EIC signal: EXTINT12 on PA12 mux A */
#define MUX_PA12A_EIC_EXTINT12             0L
#define PINMUX_PA12A_EIC_EXTINT12  ((PIN_PA12A_EIC_EXTINT12 << 16) | MUX_PA12A_EIC_EXTINT12)
#define PORT_PA12A_EIC_EXTINT12    (1ul << 12)
#define PIN_PA24A_EIC_EXTINT12            24L  /**< \brief EIC signal: EXTINT12 on PA24 mux A */
#define MUX_PA24A_EIC_EXTINT12             0L
#define PINMUX_PA24A_EIC_EXTINT12  ((PIN_PA24A_EIC_EXTINT12 << 16) | MUX_PA24A_EIC_EXTINT12)
#define PORT_PA24A_EIC_EXTINT12    (1ul << 24)
#define PIN_PA13A_EIC_EXTINT13            13L  /**< \brief EIC signal: EXTINT13 on PA13 mux A */
#define MUX_PA13A_EIC_EXTINT13             0L
#define PINMUX_PA13A_EIC_EXTINT13  ((PIN_PA13A_EIC_EXTINT13 << 16) | MUX_PA13A_EIC_EXTINT13)
#define PORT_PA13A_EIC_EXTINT13    (1ul << 13)
#define PIN_PA25A_EIC_EXTINT13            25L  /**< \brief EIC signal: EXTINT13 on PA25 mux A */
#define MUX_PA25A_EIC_EXTINT13             0L
#define PINMUX_PA25A_EIC_EXTINT13  ((PIN_PA25A_EIC_EXTINT13 << 16) | MUX_PA25A_EIC_EXTINT13)
#define PORT_PA25A_EIC_EXTINT13    (1ul << 25)
#define PIN_PA14A_EIC_EXTINT14            14L  /**< \brief EIC signal: EXTINT14 on PA14 mux A */
#define MUX_PA14A_EIC_EXTINT14             0L
#define PINMUX_PA14A_EIC_EXTINT14  ((PIN_PA14A_EIC_EXTINT14 << 16) | MUX_PA14A_EIC_EXTINT14)
#define PORT_PA14A_EIC_EXTINT14    (1ul << 14)
#define PIN_PA27A_EIC_EXTINT15            27L  /**< \brief EIC signal: EXTINT15 on PA27 mux A */
#define MUX_PA27A_EIC_EXTINT15             0L
#define PINMUX_PA27A_EIC_EXTINT15  ((PIN_PA27A_EIC_EXTINT15 << 16) | MUX_PA27A_EIC_EXTINT15)
#define PORT_PA27A_EIC_EXTINT15    (1ul << 27)
#define PIN_PA15A_EIC_EXTINT15            15L  /**< \brief EIC signal: EXTINT15 on PA15 mux A */
#define MUX_PA15A_EIC_EXTINT15             0L
#define PINMUX_PA15A_EIC_EXTINT15  ((PIN_PA15A_EIC_EXTINT15 << 16) | MUX_PA15A_EIC_EXTINT15)
#define PORT_PA15A_EIC_EXTINT15    (1ul << 15)
#define PIN_PA08A_EIC_NMI                  8L  /**< \brief EIC signal: NMI on PA08 mux A */
#define MUX_PA08A_EIC_NMI                  0L
#define PINMUX_PA08A_EIC_NMI       ((PIN_PA08A_EIC_NMI << 16) | MUX_PA08A_EIC_NMI)
#define PORT_PA08A_EIC_NMI         (1ul <<  8)
/* ========== PORT definition for TAL peripheral ========== */
#define PIN_PA27G_TAL_BRK                 27L  /**< \brief TAL signal: BRK on PA27 mux G */
#define MUX_PA27G_TAL_BRK                  6L
#define PINMUX_PA27G_TAL_BRK       ((PIN_PA27G_TAL_BRK << 16) | MUX_PA27G_TAL_BRK)
#define PORT_PA27G_TAL_BRK         (1ul << 27)
/* ========== PORT definition for USB peripheral ========== */
#define PIN_PA24G_USB_DM                  24L  /**< \brief USB signal: DM on PA24 mux G */
#define MUX_PA24G_USB_DM                   6L
#define PINMUX_PA24G_USB_DM        ((PIN_PA24G_USB_DM << 16) | MUX_PA24G_USB_DM)
#define PORT_PA24G_USB_DM          (1ul << 24)
#define PIN_PA25G_USB_DP                  25L  /**< \brief USB signal: DP on PA25 mux G */
#define MUX_PA25G_USB_DP                   6L
#define PINMUX_PA25G_USB_DP        ((PIN_PA25G_USB_DP << 16) | MUX_PA25G_USB_DP)
#define PORT_PA25G_USB_DP          (1ul << 25)
#define PIN_PA23G_USB_SOF_1KHZ            23L  /**< \brief USB signal: SOF_1KHZ on PA23 mux G */
#define MUX_PA23G_USB_SOF_1KHZ             6L
#define PINMUX_PA23G_USB_SOF_1KHZ  ((PIN_PA23G_USB_SOF_1KHZ << 16) | MUX_PA23G_USB_SOF_1KHZ)
#define PORT_PA23G_USB_SOF_1KHZ    (1ul << 23)
#define PIN_PB22G_USB_SOF_1KHZ            54L  /**< \brief USB signal: SOF_1KHZ on PB22 mux G */
#define MUX_PB22G_USB_SOF_1KHZ             6L
#define PINMUX_PB22G_USB_SOF_1KHZ  ((PIN_PB22G_USB_SOF_1KHZ << 16) | MUX_PB22G_USB_SOF_1KHZ)
#define PORT_PB22G_USB_SOF_1KHZ    (1ul << 22)
/* ========== PORT definition for SERCOM0 peripheral ========== */
#define PIN_PA04D_SERCOM0_PAD0             4L  /**< \brief SERCOM0 signal: PAD0 on PA04 mux D */
#define MUX_PA04D_SERCOM0_PAD0             3L
#define PINMUX_PA04D_SERCOM0_PAD0  ((PIN_PA04D_SERCOM0_PAD0 << 16) | MUX_PA04D_SERCOM0_PAD0)
#define PORT_PA04D_SERCOM0_PAD0    (1ul <<  4)
#define PIN_PA08C_SERCOM0_PAD0             8L  /**< \brief SERCOM0 signal: PAD0 on PA08 mux C */
#define MUX_PA08C_SERCOM0_PAD0             2L
#define PINMUX_PA08C_SERCOM0_PAD0  ((PIN_PA08C_SERCOM0_PAD0 << 16) | MUX_PA08C_SERCOM0_PAD0)
#define PORT_PA08C_SERCOM0_PAD0    (1ul <<  8)
#define PIN_PA20C_SERCOM0_PAD0            20L  /**< \brief SERCOM0 signal: PAD0 on PA20 mux C */
#define MUX_PA20C_SERCOM0_PAD0             2L
#define PINMUX_PA20C_SERCOM0_PAD0  ((PIN_PA20C_SERCOM0_PAD0 << 16) | MUX_PA20C_SERCOM0_PAD0)
#define PORT_PA20C_SERCOM0_PAD0    (1ul << 20)
#define PIN_PA05D_SERCOM0_PAD1             5L  /**< \brief SERCOM0 signal: PAD1 on PA05 mux D */
#define MUX_PA05D_SERCOM0_PAD1             3L
#define PINMUX_PA05D_SERCOM0_PAD1  ((PIN_PA05D_SERCOM0_PAD1 << 16) | MUX_PA05D_SERCOM0_PAD1)
#define PORT_PA05D_SERCOM0_PAD1    (1ul <<  5)
#define PIN_PA09C_SERCOM0_PAD1             9L  /**< \brief SERCOM0 signal: PAD1 on PA09 mux C */
#define MUX_PA09C_SERCOM0_PAD1             2L
#define PINMUX_PA09C_SERCOM0_PAD1  ((PIN_PA09C_SERCOM0_PAD1 << 16) | MUX_PA09C_SERCOM0_PAD1)
#define PORT_PA09C_SERCOM0_PAD1    (1ul <<  9)
#define PIN_PA21C_SERCOM0_PAD1            21L  /**< \brief SERCOM0 signal: PAD1 on PA21 mux C */
#define MUX_PA21C_SERCOM0_PAD1             2L
#define PINMUX_PA21C_SERCOM0_PAD1  ((PIN_PA21C_SERCOM0_PAD1 << 16) | MUX_PA21C_SERCOM0_PAD1)
#define PORT_PA21C_SERCOM0_PAD1    (1ul << 21)
#define PIN_PA06D_SERCOM0_PAD2             6L  /**< \brief SERCOM0 signal: PAD2 on PA06 mux D */
#define MUX_PA06D_SERCOM0_PAD2             3L
#define PINMUX_PA06D_SERCOM0_PAD2  ((PIN_PA06D_SERCOM0_PAD2 << 16) | MUX_PA06D_SERCOM0_PAD2)
#define PORT_PA06D_SERCOM0_PAD2    (1ul <<  6)
#define PIN_PA10C_SERCOM0_PAD2            10L  /**< \brief SERCOM0 signal: PAD2 on PA10 mux C */
#define MUX_PA10C_SERCOM0_PAD2             2L
#define PINMUX_PA10C_SERCOM0_PAD2  ((PIN_PA10C_SERCOM0_PAD2 << 16) | MUX_PA10C_SERCOM0_PAD2)
#define PORT_PA10C_SERCOM0_PAD2    (1ul << 10)
#define PIN_PA22C_SERCOM0_PAD2            22L  /**< \brief SERCOM0 signal: PAD2 on PA22 mux C */
#define MUX_PA22C_SERCOM0_PAD2             2L
#define PINMUX_PA22C_SERCOM0_PAD2  ((PIN_PA22C_SERCOM0_PAD2 << 16) | MUX_PA22C_SERCOM0_PAD2)
#define PORT_PA22C_SERCOM0_PAD2    (1ul << 22)
#define PIN_PB22C_SERCOM0_PAD2            54L  /**< \brief SERCOM0 signal: PAD2 on PB22 mux C */
#define MUX_PB22C_SERCOM0_PAD2             2L
#define PINMUX_PB22C_SERCOM0_PAD2  ((PIN_PB22C_SERCOM0_PAD2 << 16) | MUX_PB22C_SERCOM0_PAD2)
#define PORT_PB22C_SERCOM0_PAD2    (1ul << 22)
#define PIN_PA07D_SERCOM0_PAD3             7L  /**< \brief SERCOM0 signal: PAD3 on PA07 mux D */
#define MUX_PA07D_SERCOM0_PAD3             3L
#define PINMUX_PA07D_SERCOM0_PAD3  ((PIN_PA07D_SERCOM0_PAD3 << 16) | MUX_PA07D_SERCOM0_PAD3)
#define PORT_PA07D_SERCOM0_PAD3    (1ul <<  7)
#define PIN_PA11C_SERCOM0_PAD3            11L  /**< \brief SERCOM0 signal: PAD3 on PA11 mux C */
#define MUX_PA11C_SERCOM0_PAD3             2L
#define PINMUX_PA11C_SERCOM0_PAD3  ((PIN_PA11C_SERCOM0_PAD3 << 16) | MUX_PA11C_SERCOM0_PAD3)
#define PORT_PA11C_SERCOM0_PAD3    (1ul << 11)
#define PIN_PA23C_SERCOM0_PAD3            23L  /**< \brief SERCOM0 signal: PAD3 on PA23 mux C */
#define MUX_PA23C_SERCOM0_PAD3             2L
#define PINMUX_PA23C_SERCOM0_PAD3  ((PIN_PA23C_SERCOM0_PAD3 << 16) | MUX_PA23C_SERCOM0_PAD3)
#define PORT_PA23C_SERCOM0_PAD3    (1ul << 23)
#define PIN_PB23C_SERCOM0_PAD3            55L  /**< \brief SERCOM0 signal: PAD3 on PB23 mux C */
#define MUX_PB23C_SERCOM0_PAD3             2L
#define PINMUX_PB23C_SERCOM0_PAD3  ((PIN_PB23C_SERCOM0_PAD3 << 16) | MUX_PB23C_SERCOM0_PAD3)
#define PORT_PB23C_SERCOM0_PAD3    (1ul << 23)
/* ========== PORT definition for SERCOM1 peripheral ========== */
#define PIN_PA00D_SERCOM1_PAD0             0L  /**< \brief SERCOM1 signal: PAD0 on PA00 mux D */
#define MUX_PA00D_SERCOM1_PAD0             3L
#define PINMUX_PA00D_SERCOM1_PAD0  ((PIN_PA00D_SERCOM1_PAD0 << 16) | MUX_PA00D_SERCOM1_PAD0)
#define PORT_PA00D_SERCOM1_PAD0    (1ul <<  0)
#define PIN_PA16C_SERCOM1_PAD0            16L  /**< \brief SERCOM1 signal: PAD0 on PA16 mux C */
#define MUX_PA16C_SERCOM1_PAD0             2L
#define PINMUX_PA16C_SERCOM1_PAD0  ((PIN_PA16C_SERCOM1_PAD0 << 16) | MUX_PA16C_SERCOM1_PAD0)
#define PORT_PA16C_SERCOM1_PAD0    (1ul << 16)
#define PIN_PA01D_SERCOM1_PAD1             1L  /**< \brief SERCOM1 signal: PAD1 on PA01 mux D */
#define MUX_PA01D_SERCOM1_PAD1             3L
#define PINMUX_PA01D_SERCOM1_PAD1  ((PIN_PA01D_SERCOM1_PAD1 << 16) | MUX_PA01D_SERCOM1_PAD1)
#define PORT_PA01D_SERCOM1_PAD1    (1ul <<  1)
#define PIN_PA17C_SERCOM1_PAD1            17L  /**< \brief SERCOM1 signal: PAD1 on PA17 mux C */
#define MUX_PA17C_SERCOM1_PAD1             2L
#define PINMUX_PA17C_SERCOM1_PAD1  ((PIN_PA17C_SERCOM1_PAD1 << 16) | MUX_PA17C_SERCOM1_PAD1)
#define PORT_PA17C_SERCOM1_PAD1    (1ul << 17)
#define PIN_PA30D_SERCOM1_PAD2            30L  /**< \brief SERCOM1 signal: PAD2 on PA30 mux D */
#define MUX_PA30D_SERCOM1_PAD2             3L
#define PINMUX_PA30D_SERCOM1_PAD2  ((PIN_PA30D_SERCOM1_PAD2 << 16) | MUX_PA30D_SERCOM1_PAD2)
#define PORT_PA30D_SERCOM1_PAD2    (1ul << 30)
#define PIN_PA18C_SERCOM1_PAD2            18L  /**< \brief SERCOM1 signal: PAD2 on PA18 mux C */
#define MUX_PA18C_SERCOM1_PAD2             2L
#define PINMUX_PA18C_SERCOM1_PAD2  ((PIN_PA18C_SERCOM1_PAD2 << 16) | MUX_PA18C_SERCOM1_PAD2)
#define PORT_PA18C_SERCOM1_PAD2    (1ul << 18)
#define PIN_PA31D_SERCOM1_PAD3            31L  /**< \brief SERCOM1 signal: PAD3 on PA31 mux D */
#define MUX_PA31D_SERCOM1_PAD3             3L
#define PINMUX_PA31D_SERCOM1_PAD3  ((PIN_PA31D_SERCOM1_PAD3 << 16) | MUX_PA31D_SERCOM1_PAD3)
#define PORT_PA31D_SERCOM1_PAD3    (1ul << 31)
#define PIN_PA19C_SERCOM1_PAD3            19L  /**< \brief SERCOM1 signal: PAD3 on PA19 mux C */
#define MUX_PA19C_SERCOM1_PAD3             2L
#define PINMUX_PA19C_SERCOM1_PAD3  ((PIN_PA19C_SERCOM1_PAD3 << 16) | MUX_PA19C_SERCOM1_PAD3)
#define PORT_PA19C_SERCOM1_PAD3    (1ul << 19)
/* ========== PORT definition for SERCOM2 peripheral ========== */
#define PIN_PA22D_SERCOM2_PAD0            22L  /**< \brief SERCOM2 signal: PAD0 on PA22 mux D */
#define MUX_PA22D_SERCOM2_PAD0             3L
#define PINMUX_PA22D_SERCOM2_PAD0  ((PIN_PA22D_SERCOM2_PAD0 << 16) | MUX_PA22D_SERCOM2_PAD0)
#define PORT_PA22D_SERCOM2_PAD0    (1ul << 22)
#define PIN_PA16D_SERCOM2_PAD0            16L  /**< \brief SERCOM2 signal: PAD0 on PA16 mux D */
#define MUX_PA16D_SERCOM2_PAD0             3L
#define PINMUX_PA16D_SERCOM2_PAD0  ((PIN_PA16D_SERCOM2_PAD0 << 16) | MUX_PA16D_SERCOM2_PAD0)
#define PORT_PA16D_SERCOM2_PAD0    (1ul << 16)
#define PIN_PA23D_SERCOM2_PAD1            23L  /**< \brief SERCOM2 signal: PAD1 on PA23 mux D */
#define MUX_PA23D_SERCOM2_PAD1             3L
#define PINMUX_PA23D_SERCOM2_PAD1  ((PIN_PA23D_SERCOM2_PAD1 << 16) | MUX_PA23D_SERCOM2_PAD1)
#define PORT_PA23D_SERCOM2_PAD1    (1ul << 23)
#define PIN_PA17D_SERCOM2_PAD1            17L  /**< \brief SERCOM2 signal: PAD1 on PA17 mux D */
#define MUX_PA17D_SERCOM2_PAD1             3L
#define PINMUX_PA17D_SERCOM2_PAD1  ((PIN_PA17D_SERCOM2_PAD1 << 16) | MUX_PA17D_SERCOM2_PAD1)
#define PORT_PA17D_SERCOM2_PAD1    (1ul << 17)
#define PIN_PA18D_SERCOM2_PAD2            18L  /**< \brief SERCOM2 signal: PAD2 on PA18 mux D */
#define MUX_PA18D_SERCOM2_PAD2             3L
#define PINMUX_PA18D_SERCOM2_PAD2  ((PIN_PA18D_SERCOM2_PAD2 << 16) | MUX_PA18D_SERCOM2_PAD2)
#define PORT_PA18D_SERCOM2_PAD2    (1ul << 18)
#define PIN_PA20D_SERCOM2_PAD2            20L  /**< \brief SERCOM2 signal: PAD2 on PA20 mux D */
#define MUX_PA20D_SERCOM2_PAD2             3L
#define PINMUX_PA20D_SERCOM2_PAD2  ((PIN_PA20D_SERCOM2_PAD2 << 16) | MUX_PA20D_SERCOM2_PAD2)
#define PORT_PA20D_SERCOM2_PAD2    (1ul << 20)
#define PIN_PA24C_SERCOM2_PAD2            24L  /**< \brief SERCOM2 signal: PAD2 on PA24 mux C */
#define MUX_PA24C_SERCOM2_PAD2             2L
#define PINMUX_PA24C_SERCOM2_PAD2  ((PIN_PA24C_SERCOM2_PAD2 << 16) | MUX_PA24C_SERCOM2_PAD2)
#define PORT_PA24C_SERCOM2_PAD2    (1ul << 24)
#define PIN_PA19D_SERCOM2_PAD3            19L  /**< \brief SERCOM2 signal: PAD3 on PA19 mux D */
#define MUX_PA19D_SERCOM2_PAD3             3L
#define PINMUX_PA19D_SERCOM2_PAD3  ((PIN_PA19D_SERCOM2_PAD3 << 16) | MUX_PA19D_SERCOM2_PAD3)
#define PORT_PA19D_SERCOM2_PAD3    (1ul << 19)
#define PIN_PA21D_SERCOM2_PAD3            21L  /**< \brief SERCOM2 signal: PAD3 on PA21 mux D */
#define MUX_PA21D_SERCOM2_PAD3             3L
#define PINMUX_PA21D_SERCOM2_PAD3  ((PIN_PA21D_SERCOM2_PAD3 << 16) | MUX_PA21D_SERCOM2_PAD3)
#define PORT_PA21D_SERCOM2_PAD3    (1ul << 21)
#define PIN_PA25C_SERCOM2_PAD3            25L  /**< \brief SERCOM2 signal: PAD3 on PA25 mux C */
#define MUX_PA25C_SERCOM2_PAD3             2L
#define PINMUX_PA25C_SERCOM2_PAD3  ((PIN_PA25C_SERCOM2_PAD3 << 16) | MUX_PA25C_SERCOM2_PAD3)
#define PORT_PA25C_SERCOM2_PAD3    (1ul << 25)
/* ========== PORT definition for TCC0 peripheral ========== */
#define PIN_PA24F_TCC0_WO0                24L  /**< \brief TCC0 signal: WO0 on PA24 mux F */
#define MUX_PA24F_TCC0_WO0                 5L
#define PINMUX_PA24F_TCC0_WO0      ((PIN_PA24F_TCC0_WO0 << 16) | MUX_PA24F_TCC0_WO0)
#define PORT_PA24F_TCC0_WO0        (1ul << 24)
#define PIN_PA04E_TCC0_WO0                 4L  /**< \brief TCC0 signal: WO0 on PA04 mux E */
#define MUX_PA04E_TCC0_WO0                 4L
#define PINMUX_PA04E_TCC0_WO0      ((PIN_PA04E_TCC0_WO0 << 16) | MUX_PA04E_TCC0_WO0)
#define PORT_PA04E_TCC0_WO0        (1ul <<  4)
#define PIN_PA08E_TCC0_WO0                 8L  /**< \brief TCC0 signal: WO0 on PA08 mux E */
#define MUX_PA08E_TCC0_WO0                 4L
#define PINMUX_PA08E_TCC0_WO0      ((PIN_PA08E_TCC0_WO0 << 16) | MUX_PA08E_TCC0_WO0)
#define PORT_PA08E_TCC0_WO0        (1ul <<  8)
#define PIN_PA25F_TCC0_WO1                25L  /**< \brief TCC0 signal: WO1 on PA25 mux F */
#define MUX_PA25F_TCC0_WO1                 5L
#define PINMUX_PA25F_TCC0_WO1      ((PIN_PA25F_TCC0_WO1 << 16) | MUX_PA25F_TCC0_WO1)
#define PORT_PA25F_TCC0_WO1        (1ul << 25)
#define PIN_PA05E_TCC0_WO1                 5L  /**< \brief TCC0 signal: WO1 on PA05 mux E */
#define MUX_PA05E_TCC0_WO1                 4L
#define PINMUX_PA05E_TCC0_WO1      ((PIN_PA05E_TCC0_WO1 << 16) | MUX_PA05E_TCC0_WO1)
#define PORT_PA05E_TCC0_WO1        (1ul <<  5)
#define PIN_PA09E_TCC0_WO1                 9L  /**< \brief TCC0 signal: WO1 on PA09 mux E */
#define MUX_PA09E_TCC0_WO1                 4L
#define PINMUX_PA09E_TCC0_WO1      ((PIN_PA09E_TCC0_WO1 << 16) | MUX_PA09E_TCC0_WO1)
#define PORT_PA09E_TCC0_WO1        (1ul <<  9)
#define PIN_PA10F_TCC0_WO2                10L  /**< \brief TCC0 signal: WO2 on PA10 mux F */
#define MUX_PA10F_TCC0_WO2                 5L
#define PINMUX_PA10F_TCC0_WO2      ((PIN_PA10F_TCC0_WO2 << 16) | MUX_PA10F_TCC0_WO2)
#define PORT_PA10F_TCC0_WO2        (1ul << 10)
#define PIN_PA18F_TCC0_WO2                18L  /**< \brief TCC0 signal: WO2 on PA18 mux F */
#define MUX_PA18F_TCC0_WO2                 5L
#define PINMUX_PA18F_TCC0_WO2      ((PIN_PA18F_TCC0_WO2 << 16) | MUX_PA18F_TCC0_WO2)
#define PORT_PA18F_TCC0_WO2        (1ul << 18)
#define PIN_PB22F_TCC0_WO2                54L  /**< \brief TCC0 signal: WO2 on PB22 mux F */
#define MUX_PB22F_TCC0_WO2                 5L
#define PINMUX_PB22F_TCC0_WO2      ((PIN_PB22F_TCC0_WO2 << 16) | MUX_PB22F_TCC0_WO2)
#define PORT_PB22F_TCC0_WO2        (1ul << 22)
#define PIN_PA11F_TCC0_WO3                11L  /**< \brief TCC0 signal: WO3 on PA11 mux F */
#define MUX_PA11F_TCC0_WO3                 5L
#define PINMUX_PA11F_TCC0_WO3      ((PIN_PA11F_TCC0_WO3 << 16) | MUX_PA11F_TCC0_WO3)
#define PORT_PA11F_TCC0_WO3        (1ul << 11)
#define PIN_PA19F_TCC0_WO3                19L  /**< \brief TCC0 signal: WO3 on PA19 mux F */
#define MUX_PA19F_TCC0_WO3                 5L
#define PINMUX_PA19F_TCC0_WO3      ((PIN_PA19F_TCC0_WO3 << 16) | MUX_PA19F_TCC0_WO3)
#define PORT_PA19F_TCC0_WO3        (1ul << 19)
#define PIN_PB23F_TCC0_WO3                55L  /**< \brief TCC0 signal: WO3 on PB23 mux F */
#define MUX_PB23F_TCC0_WO3                 5L
#define PINMUX_PB23F_TCC0_WO3      ((PIN_PB23F_TCC0_WO3 << 16) | MUX_PB23F_TCC0_WO3)
#define PORT_PB23F_TCC0_WO3        (1ul << 23)
#define PIN_PA22F_TCC0_WO4                22L  /**< \brief TCC0 signal: WO4 on PA22 mux F */
#define MUX_PA22F_TCC0_WO4                 5L
#define PINMUX_PA22F_TCC0_WO4      ((PIN_PA22F_TCC0_WO4 << 16) | MUX_PA22F_TCC0_WO4)
#define PORT_PA22F_TCC0_WO4        (1ul << 22)
#define PIN_PA14F_TCC0_WO4                14L  /**< \brief TCC0 signal: WO4 on PA14 mux F */
#define MUX_PA14F_TCC0_WO4                 5L
#define PINMUX_PA14F_TCC0_WO4      ((PIN_PA14F_TCC0_WO4 << 16) | MUX_PA14F_TCC0_WO4)
#define PORT_PA14F_TCC0_WO4        (1ul << 14)
#define PIN_PA15F_TCC0_WO5                15L  /**< \brief TCC0 signal: WO5 on PA15 mux F */
#define MUX_PA15F_TCC0_WO5                 5L
#define PINMUX_PA15F_TCC0_WO5      ((PIN_PA15F_TCC0_WO5 << 16) | MUX_PA15F_TCC0_WO5)
#define PORT_PA15F_TCC0_WO5        (1ul << 15)
#define PIN_PA23F_TCC0_WO5                23L  /**< \brief TCC0 signal: WO5 on PA23 mux F */
#define MUX_PA23F_TCC0_WO5                 5L
#define PINMUX_PA23F_TCC0_WO5      ((PIN_PA23F_TCC0_WO5 << 16) | MUX_PA23F_TCC0_WO5)
#define PORT_PA23F_TCC0_WO5        (1ul << 23)
#define PIN_PA27F_TCC0_WO5                27L  /**< \brief TCC0 signal: WO5 on PA27 mux F */
#define MUX_PA27F_TCC0_WO5                 5L
#define PINMUX_PA27F_TCC0_WO5      ((PIN_PA27F_TCC0_WO5 << 16) | MUX_PA27F_TCC0_WO5)
#define PORT_PA27F_TCC0_WO5        (1ul << 27)
#define PIN_PB11F_TCC0_WO5                43L  /**< \brief TCC0 signal: WO5 on PB11 mux F */
#define MUX_PB11F_TCC0_WO5                 5L
#define PINMUX_PB11F_TCC0_WO5      ((PIN_PB11F_TCC0_WO5 << 16) | MUX_PB11F_TCC0_WO5)
#define PORT_PB11F_TCC0_WO5        (1ul << 11)
#define PIN_PA12F_TCC0_WO6                12L  /**< \brief TCC0 signal: WO6 on PA12 mux F */
#define MUX_PA12F_TCC0_WO6                 5L
#define PINMUX_PA12F_TCC0_WO6      ((PIN_PA12F_TCC0_WO6 << 16) | MUX_PA12F_TCC0_WO6)
#define PORT_PA12F_TCC0_WO6        (1ul << 12)
#define PIN_PA16F_TCC0_WO6                16L  /**< \brief TCC0 signal: WO6 on PA16 mux F */
#define MUX_PA16F_TCC0_WO6                 5L
#define PINMUX_PA16F_TCC0_WO6      ((PIN_PA16F_TCC0_WO6 << 16) | MUX_PA16F_TCC0_WO6)
#define PORT_PA16F_TCC0_WO6        (1ul << 16)
#define PIN_PA20F_TCC0_WO6                20L  /**< \brief TCC0 signal: WO6 on PA20 mux F */
#define MUX_PA20F_TCC0_WO6                 5L
#define PINMUX_PA20F_TCC0_WO6      ((PIN_PA20F_TCC0_WO6 << 16) | MUX_PA20F_TCC0_WO6)
#define PORT_PA20F_TCC0_WO6        (1ul << 20)
#define PIN_PA13F_TCC0_WO7                13L  /**< \brief TCC0 signal: WO7 on PA13 mux F */
#define MUX_PA13F_TCC0_WO7                 5L
#define PINMUX_PA13F_TCC0_WO7      ((PIN_PA13F_TCC0_WO7 << 16) | MUX_PA13F_TCC0_WO7)
#define PORT_PA13F_TCC0_WO7        (1ul << 13)
#define PIN_PA17F_TCC0_WO7                17L  /**< \brief TCC0 signal: WO7 on PA17 mux F */
#define MUX_PA17F_TCC0_WO7                 5L
#define PINMUX_PA17F_TCC0_WO7      ((PIN_PA17F_TCC0_WO7 << 16) | MUX_PA17F_TCC0_WO7)
#define PORT_PA17F_TCC0_WO7        (1ul << 17)
#define PIN_PA21F_TCC0_WO7                21L  /**< \brief TCC0 signal: WO7 on PA21 mux F */
#define MUX_PA21F_TCC0_WO7                 5L
#define PINMUX_PA21F_TCC0_WO7      ((PIN_PA21F_TCC0_WO7 << 16) | MUX_PA21F_TCC0_WO7)
#define PORT_PA21F_TCC0_WO7        (1ul << 21)
/* ========== PORT definition for TC0 peripheral ========== */
#define PIN_PA22E_TC0_WO0                 22L  /**< \brief TC0 signal: WO0 on PA22 mux E */
#define MUX_PA22E_TC0_WO0                  4L
#define PINMUX_PA22E_TC0_WO0       ((PIN_PA22E_TC0_WO0 << 16) | MUX_PA22E_TC0_WO0)
#define PORT_PA22E_TC0_WO0         (1ul << 22)
#define PIN_PB08E_TC0_WO0                 40L  /**< \brief TC0 signal: WO0 on PB08 mux E */
#define MUX_PB08E_TC0_WO0                  4L
#define PINMUX_PB08E_TC0_WO0       ((PIN_PB08E_TC0_WO0 << 16) | MUX_PB08E_TC0_WO0)
#define PORT_PB08E_TC0_WO0         (1ul <<  8)
#define PIN_PA23E_TC0_WO1                 23L  /**< \brief TC0 signal: WO1 on PA23 mux E */
#define MUX_PA23E_TC0_WO1                  4L
#define PINMUX_PA23E_TC0_WO1       ((PIN_PA23E_TC0_WO1 << 16) | MUX_PA23E_TC0_WO1)
#define PORT_PA23E_TC0_WO1         (1ul << 23)
#define PIN_PB09E_TC0_WO1                 41L  /**< \brief TC0 signal: WO1 on PB09 mux E */
#define MUX_PB09E_TC0_WO1                  4L
#define PINMUX_PB09E_TC0_WO1       ((PIN_PB09E_TC0_WO1 << 16) | MUX_PB09E_TC0_WO1)
#define PORT_PB09E_TC0_WO1         (1ul <<  9)
/* ========== PORT definition for TC1 peripheral ========== */
#define PIN_PA24E_TC1_WO0                 24L  /**< \brief TC1 signal: WO0 on PA24 mux E */
#define MUX_PA24E_TC1_WO0                  4L
#define PINMUX_PA24E_TC1_WO0       ((PIN_PA24E_TC1_WO0 << 16) | MUX_PA24E_TC1_WO0)
#define PORT_PA24E_TC1_WO0         (1ul << 24)
#define PIN_PA25E_TC1_WO1                 25L  /**< \brief TC1 signal: WO1 on PA25 mux E */
#define MUX_PA25E_TC1_WO1                  4L
#define PINMUX_PA25E_TC1_WO1       ((PIN_PA25E_TC1_WO1 << 16) | MUX_PA25E_TC1_WO1)
#define PORT_PA25E_TC1_WO1         (1ul << 25)
#define PIN_PB11E_TC1_WO1                 43L  /**< \brief TC1 signal: WO1 on PB11 mux E */
#define MUX_PB11E_TC1_WO1                  4L
#define PINMUX_PB11E_TC1_WO1       ((PIN_PB11E_TC1_WO1 << 16) | MUX_PB11E_TC1_WO1)
#define PORT_PB11E_TC1_WO1         (1ul << 11)
/* ========== PORT definition for TC2 peripheral ========== */
#define PIN_PB02E_TC2_WO0                 34L  /**< \brief TC2 signal: WO0 on PB02 mux E */
#define MUX_PB02E_TC2_WO0                  4L
#define PINMUX_PB02E_TC2_WO0       ((PIN_PB02E_TC2_WO0 << 16) | MUX_PB02E_TC2_WO0)
#define PORT_PB02E_TC2_WO0         (1ul <<  2)
#define PIN_PB03E_TC2_WO1                 35L  /**< \brief TC2 signal: WO1 on PB03 mux E */
#define MUX_PB03E_TC2_WO1                  4L
#define PINMUX_PB03E_TC2_WO1       ((PIN_PB03E_TC2_WO1 << 16) | MUX_PB03E_TC2_WO1)
#define PORT_PB03E_TC2_WO1         (1ul <<  3)
/* ========== PORT definition for TC3 peripheral ========== */
#define PIN_PA20E_TC3_WO0                 20L  /**< \brief TC3 signal: WO0 on PA20 mux E */
#define MUX_PA20E_TC3_WO0                  4L
#define PINMUX_PA20E_TC3_WO0       ((PIN_PA20E_TC3_WO0 << 16) | MUX_PA20E_TC3_WO0)
#define PORT_PA20E_TC3_WO0         (1ul << 20)
#define PIN_PB22E_TC3_WO0                 54L  /**< \brief TC3 signal: WO0 on PB22 mux E */
#define MUX_PB22E_TC3_WO0                  4L
#define PINMUX_PB22E_TC3_WO0       ((PIN_PB22E_TC3_WO0 << 16) | MUX_PB22E_TC3_WO0)
#define PORT_PB22E_TC3_WO0         (1ul << 22)
#define PIN_PA21E_TC3_WO1                 21L  /**< \brief TC3 signal: WO1 on PA21 mux E */
#define MUX_PA21E_TC3_WO1                  4L
#define PINMUX_PA21E_TC3_WO1       ((PIN_PA21E_TC3_WO1 << 16) | MUX_PA21E_TC3_WO1)
#define PORT_PA21E_TC3_WO1         (1ul << 21)
#define PIN_PB23E_TC3_WO1                 55L  /**< \brief TC3 signal: WO1 on PB23 mux E */
#define MUX_PB23E_TC3_WO1                  4L
#define PINMUX_PB23E_TC3_WO1       ((PIN_PB23E_TC3_WO1 << 16) | MUX_PB23E_TC3_WO1)
#define PORT_PB23E_TC3_WO1         (1ul << 23)
/* ========== PORT definition for ADC peripheral ========== */
#define PIN_PA02B_ADC_AIN0                 2L  /**< \brief ADC signal: AIN0 on PA02 mux B */
#define MUX_PA02B_ADC_AIN0                 1L
#define PINMUX_PA02B_ADC_AIN0      ((PIN_PA02B_ADC_AIN0 << 16) | MUX_PA02B_ADC_AIN0)
#define PORT_PA02B_ADC_AIN0        (1ul <<  2)
#define PIN_PA03B_ADC_AIN1                 3L  /**< \brief ADC signal: AIN1 on PA03 mux B */
#define MUX_PA03B_ADC_AIN1                 1L
#define PINMUX_PA03B_ADC_AIN1      ((PIN_PA03B_ADC_AIN1 << 16) | MUX_PA03B_ADC_AIN1)
#define PORT_PA03B_ADC_AIN1        (1ul <<  3)
#define PIN_PB08B_ADC_AIN2                40L  /**< \brief ADC signal: AIN2 on PB08 mux B */
#define MUX_PB08B_ADC_AIN2                 1L
#define PINMUX_PB08B_ADC_AIN2      ((PIN_PB08B_ADC_AIN2 << 16) | MUX_PB08B_ADC_AIN2)
#define PORT_PB08B_ADC_AIN2        (1ul <<  8)
#define PIN_PB09B_ADC_AIN3                41L  /**< \brief ADC signal: AIN3 on PB09 mux B */
#define MUX_PB09B_ADC_AIN3                 1L
#define PINMUX_PB09B_ADC_AIN3      ((PIN_PB09B_ADC_AIN3 << 16) | MUX_PB09B_ADC_AIN3)
#define PORT_PB09B_ADC_AIN3        (1ul <<  9)
#define PIN_PA04B_ADC_AIN4                 4L  /**< \brief ADC signal: AIN4 on PA04 mux B */
#define MUX_PA04B_ADC_AIN4                 1L
#define PINMUX_PA04B_ADC_AIN4      ((PIN_PA04B_ADC_AIN4 << 16) | MUX_PA04B_ADC_AIN4)
#define PORT_PA04B_ADC_AIN4        (1ul <<  4)
#define PIN_PA05B_ADC_AIN5                 5L  /**< \brief ADC signal: AIN5 on PA05 mux B */
#define MUX_PA05B_ADC_AIN5                 1L
#define PINMUX_PA05B_ADC_AIN5      ((PIN_PA05B_ADC_AIN5 << 16) | MUX_PA05B_ADC_AIN5)
#define PORT_PA05B_ADC_AIN5        (1ul <<  5)
#define PIN_PA06B_ADC_AIN6                 6L  /**< \brief ADC signal: AIN6 on PA06 mux B */
#define MUX_PA06B_ADC_AIN6                 1L
#define PINMUX_PA06B_ADC_AIN6      ((PIN_PA06B_ADC_AIN6 << 16) | MUX_PA06B_ADC_AIN6)
#define PORT_PA06B_ADC_AIN6        (1ul <<  6)
#define PIN_PA07B_ADC_AIN7                 7L  /**< \brief ADC signal: AIN7 on PA07 mux B */
#define MUX_PA07B_ADC_AIN7                 1L
#define PINMUX_PA07B_ADC_AIN7      ((PIN_PA07B_ADC_AIN7 << 16) | MUX_PA07B_ADC_AIN7)
#define PORT_PA07B_ADC_AIN7        (1ul <<  7)
#define PIN_PB02B_ADC_AIN10               34L  /**< \brief ADC signal: AIN10 on PB02 mux B */
#define MUX_PB02B_ADC_AIN10                1L
#define PINMUX_PB02B_ADC_AIN10     ((PIN_PB02B_ADC_AIN10 << 16) | MUX_PB02B_ADC_AIN10)
#define PORT_PB02B_ADC_AIN10       (1ul <<  2)
#define PIN_PB03B_ADC_AIN11               35L  /**< \brief ADC signal: AIN11 on PB03 mux B */
#define MUX_PB03B_ADC_AIN11                1L
#define PINMUX_PB03B_ADC_AIN11     ((PIN_PB03B_ADC_AIN11 << 16) | MUX_PB03B_ADC_AIN11)
#define PORT_PB03B_ADC_AIN11       (1ul <<  3)
#define PIN_PA03B_ADC_VREFA                3L  /**< \brief ADC signal: VREFA on PA03 mux B */
#define MUX_PA03B_ADC_VREFA                1L
#define PINMUX_PA03B_ADC_VREFA     ((PIN_PA03B_ADC_VREFA << 16) | MUX_PA03B_ADC_VREFA)
#define PORT_PA03B_ADC_VREFA       (1ul <<  3)
#define PIN_PA02B_ADC_VREFB                2L  /**< \brief ADC signal: VREFB on PA02 mux B */
#define MUX_PA02B_ADC_VREFB                1L
#define PINMUX_PA02B_ADC_VREFB     ((PIN_PA02B_ADC_VREFB << 16) | MUX_PA02B_ADC_VREFB)
#define PORT_PA02B_ADC_VREFB       (1ul <<  2)
/* ========== PORT definition for AC peripheral ========== */
#define PIN_PA02B_AC_AIN0                  2L  /**< \brief AC signal: AIN0 on PA02 mux B */
#define MUX_PA02B_AC_AIN0                  1L
#define PINMUX_PA02B_AC_AIN0       ((PIN_PA02B_AC_AIN0 << 16) | MUX_PA02B_AC_AIN0)
#define PORT_PA02B_AC_AIN0         (1ul <<  2)
#define PIN_PA03B_AC_AIN1                  3L  /**< \brief AC signal: AIN1 on PA03 mux B */
#define MUX_PA03B_AC_AIN1                  1L
#define PINMUX_PA03B_AC_AIN1       ((PIN_PA03B_AC_AIN1 << 16) | MUX_PA03B_AC_AIN1)
#define PORT_PA03B_AC_AIN1         (1ul <<  3)
#define PIN_PA12H_AC_CMP0                 12L  /**< \brief AC signal: CMP0 on PA12 mux H */
#define MUX_PA12H_AC_CMP0                  7L
#define PINMUX_PA12H_AC_CMP0       ((PIN_PA12H_AC_CMP0 << 16) | MUX_PA12H_AC_CMP0)
#define PORT_PA12H_AC_CMP0         (1ul << 12)
#define PIN_PA18H_AC_CMP0                 18L  /**< \brief AC signal: CMP0 on PA18 mux H */
#define MUX_PA18H_AC_CMP0                  7L
#define PINMUX_PA18H_AC_CMP0       ((PIN_PA18H_AC_CMP0 << 16) | MUX_PA18H_AC_CMP0)
#define PORT_PA18H_AC_CMP0         (1ul << 18)
#define PIN_PA13H_AC_CMP1                 13L  /**< \brief AC signal: CMP1 on PA13 mux H */
#define MUX_PA13H_AC_CMP1                  7L
#define PINMUX_PA13H_AC_CMP1       ((PIN_PA13H_AC_CMP1 << 16) | MUX_PA13H_AC_CMP1)
#define PORT_PA13H_AC_CMP1         (1ul << 13)
#define PIN_PA19H_AC_CMP1                 19L  /**< \brief AC signal: CMP1 on PA19 mux H */
#define MUX_PA19H_AC_CMP1                  7L
#define PINMUX_PA19H_AC_CMP1       ((PIN_PA19H_AC_CMP1 << 16) | MUX_PA19H_AC_CMP1)
#define PORT_PA19H_AC_CMP1         (1ul << 19)
/* ========== PORT definition for SLCD peripheral ========== */
#define PIN_PB08B_SLCD_LP2                40L  /**< \brief SLCD signal: LP2 on PB08 mux B */
#define MUX_PB08B_SLCD_LP2                 1L
#define PINMUX_PB08B_SLCD_LP2      ((PIN_PB08B_SLCD_LP2 << 16) | MUX_PB08B_SLCD_LP2)
#define PORT_PB08B_SLCD_LP2        (1ul <<  8)
#define PIN_PB09B_SLCD_LP3                41L  /**< \brief SLCD signal: LP3 on PB09 mux B */
#define MUX_PB09B_SLCD_LP3                 1L
#define PINMUX_PB09B_SLCD_LP3      ((PIN_PB09B_SLCD_LP3 << 16) | MUX_PB09B_SLCD_LP3)
#define PORT_PB09B_SLCD_LP3        (1ul <<  9)
#define PIN_PA04B_SLCD_LP4                 4L  /**< \brief SLCD signal: LP4 on PA04 mux B */
#define MUX_PA04B_SLCD_LP4                 1L
#define PINMUX_PA04B_SLCD_LP4      ((PIN_PA04B_SLCD_LP4 << 16) | MUX_PA04B_SLCD_LP4)
#define PORT_PA04B_SLCD_LP4        (1ul <<  4)
#define PIN_PA05B_SLCD_LP5                 5L  /**< \brief SLCD signal: LP5 on PA05 mux B */
#define MUX_PA05B_SLCD_LP5                 1L
#define PINMUX_PA05B_SLCD_LP5      ((PIN_PA05B_SLCD_LP5 << 16) | MUX_PA05B_SLCD_LP5)
#define PORT_PA05B_SLCD_LP5        (1ul <<  5)
#define PIN_PA06B_SLCD_LP6                 6L  /**< \brief SLCD signal: LP6 on PA06 mux B */
#define MUX_PA06B_SLCD_LP6                 1L
#define PINMUX_PA06B_SLCD_LP6      ((PIN_PA06B_SLCD_LP6 << 16) | MUX_PA06B_SLCD_LP6)
#define PORT_PA06B_SLCD_LP6        (1ul <<  6)
#define PIN_PA07B_SLCD_LP7                 7L  /**< \brief SLCD signal: LP7 on PA07 mux B */
#define MUX_PA07B_SLCD_LP7                 1L
#define PINMUX_PA07B_SLCD_LP7      ((PIN_PA07B_SLCD_LP7 << 16) | MUX_PA07B_SLCD_LP7)
#define PORT_PA07B_SLCD_LP7        (1ul <<  7)
#define PIN_PA08B_SLCD_LP11                8L  /**< \brief SLCD signal: LP11 on PA08 mux B */
#define MUX_PA08B_SLCD_LP11                1L
#define PINMUX_PA08B_SLCD_LP11     ((PIN_PA08B_SLCD_LP11 << 16) | MUX_PA08B_SLCD_LP11)
#define PORT_PA08B_SLCD_LP11       (1ul <<  8)
#define PIN_PA09B_SLCD_LP12                9L  /**< \brief SLCD signal: LP12 on PA09 mux B */
#define MUX_PA09B_SLCD_LP12                1L
#define PINMUX_PA09B_SLCD_LP12     ((PIN_PA09B_SLCD_LP12 << 16) | MUX_PA09B_SLCD_LP12)
#define PORT_PA09B_SLCD_LP12       (1ul <<  9)
#define PIN_PA10B_SLCD_LP13               10L  /**< \brief SLCD signal: LP13 on PA10 mux B */
#define MUX_PA10B_SLCD_LP13                1L
#define PINMUX_PA10B_SLCD_LP13     ((PIN_PA10B_SLCD_LP13 << 16) | MUX_PA10B_SLCD_LP13)
#define PORT_PA10B_SLCD_LP13       (1ul << 10)
#define PIN_PA11B_SLCD_LP14               11L  /**< \brief SLCD signal: LP14 on PA11 mux B */
#define MUX_PA11B_SLCD_LP14                1L
#define PINMUX_PA11B_SLCD_LP14     ((PIN_PA11B_SLCD_LP14 << 16) | MUX_PA11B_SLCD_LP14)
#define PORT_PA11B_SLCD_LP14       (1ul << 11)
#define PIN_PB11B_SLCD_LP21               43L  /**< \brief SLCD signal: LP21 on PB11 mux B */
#define MUX_PB11B_SLCD_LP21                1L
#define PINMUX_PB11B_SLCD_LP21     ((PIN_PB11B_SLCD_LP21 << 16) | MUX_PB11B_SLCD_LP21)
#define PORT_PB11B_SLCD_LP21       (1ul << 11)
#define PIN_PA12B_SLCD_LP28               12L  /**< \brief SLCD signal: LP28 on PA12 mux B */
#define MUX_PA12B_SLCD_LP28                1L
#define PINMUX_PA12B_SLCD_LP28     ((PIN_PA12B_SLCD_LP28 << 16) | MUX_PA12B_SLCD_LP28)
#define PORT_PA12B_SLCD_LP28       (1ul << 12)
#define PIN_PA13B_SLCD_LP29               13L  /**< \brief SLCD signal: LP29 on PA13 mux B */
#define MUX_PA13B_SLCD_LP29                1L
#define PINMUX_PA13B_SLCD_LP29     ((PIN_PA13B_SLCD_LP29 << 16) | MUX_PA13B_SLCD_LP29)
#define PORT_PA13B_SLCD_LP29       (1ul << 13)
#define PIN_PA14B_SLCD_LP30               14L  /**< \brief SLCD signal: LP30 on PA14 mux B */
#define MUX_PA14B_SLCD_LP30                1L
#define PINMUX_PA14B_SLCD_LP30     ((PIN_PA14B_SLCD_LP30 << 16) | MUX_PA14B_SLCD_LP30)
#define PORT_PA14B_SLCD_LP30       (1ul << 14)
#define PIN_PA15B_SLCD_LP31               15L  /**< \brief SLCD signal: LP31 on PA15 mux B */
#define MUX_PA15B_SLCD_LP31                1L
#define PINMUX_PA15B_SLCD_LP31     ((PIN_PA15B_SLCD_LP31 << 16) | MUX_PA15B_SLCD_LP31)
#define PORT_PA15B_SLCD_LP31       (1ul << 15)
#define PIN_PA16B_SLCD_LP32               16L  /**< \brief SLCD signal: LP32 on PA16 mux B */
#define MUX_PA16B_SLCD_LP32                1L
#define PINMUX_PA16B_SLCD_LP32     ((PIN_PA16B_SLCD_LP32 << 16) | MUX_PA16B_SLCD_LP32)
#define PORT_PA16B_SLCD_LP32       (1ul << 16)
#define PIN_PA17B_SLCD_LP33               17L  /**< \brief SLCD signal: LP33 on PA17 mux B */
#define MUX_PA17B_SLCD_LP33                1L
#define PINMUX_PA17B_SLCD_LP33     ((PIN_PA17B_SLCD_LP33 << 16) | MUX_PA17B_SLCD_LP33)
#define PORT_PA17B_SLCD_LP33       (1ul << 17)
#define PIN_PA18B_SLCD_LP34               18L  /**< \brief SLCD signal: LP34 on PA18 mux B */
#define MUX_PA18B_SLCD_LP34                1L
#define PINMUX_PA18B_SLCD_LP34     ((PIN_PA18B_SLCD_LP34 << 16) | MUX_PA18B_SLCD_LP34)
#define PORT_PA18B_SLCD_LP34       (1ul << 18)
#define PIN_PA19B_SLCD_LP35               19L  /**< \brief SLCD signal: LP35 on PA19 mux B */
#define MUX_PA19B_SLCD_LP35                1L
#define PINMUX_PA19B_SLCD_LP35     ((PIN_PA19B_SLCD_LP35 << 16) | MUX_PA19B_SLCD_LP35)
#define PORT_PA19B_SLCD_LP35       (1ul << 19)
#define PIN_PA20B_SLCD_LP48               20L  /**< \brief SLCD signal: LP48 on PA20 mux B */
#define MUX_PA20B_SLCD_LP48                1L
#define PINMUX_PA20B_SLCD_LP48     ((PIN_PA20B_SLCD_LP48 << 16) | MUX_PA20B_SLCD_LP48)
#define PORT_PA20B_SLCD_LP48       (1ul << 20)
#define PIN_PA21B_SLCD_LP49               21L  /**< \brief SLCD signal: LP49 on PA21 mux B */
#define MUX_PA21B_SLCD_LP49                1L
#define PINMUX_PA21B_SLCD_LP49     ((PIN_PA21B_SLCD_LP49 << 16) | MUX_PA21B_SLCD_LP49)
#define PORT_PA21B_SLCD_LP49       (1ul << 21)
#define PIN_PA22B_SLCD_LP50               22L  /**< \brief SLCD signal: LP50 on PA22 mux B */
#define MUX_PA22B_SLCD_LP50                1L
#define PINMUX_PA22B_SLCD_LP50     ((PIN_PA22B_SLCD_LP50 << 16) | MUX_PA22B_SLCD_LP50)
#define PORT_PA22B_SLCD_LP50       (1ul << 22)
#define PIN_PA23B_SLCD_LP51               23L  /**< \brief SLCD signal: LP51 on PA23 mux B */
#define MUX_PA23B_SLCD_LP51                1L
#define PINMUX_PA23B_SLCD_LP51     ((PIN_PA23B_SLCD_LP51 << 16) | MUX_PA23B_SLCD_LP51)
#define PORT_PA23B_SLCD_LP51       (1ul << 23)
/* ========== PORT definition for CCL peripheral ========== */
#define PIN_PA04I_CCL_IN0                  4L  /**< \brief CCL signal: IN0 on PA04 mux I */
#define MUX_PA04I_CCL_IN0                  8L
#define PINMUX_PA04I_CCL_IN0       ((PIN_PA04I_CCL_IN0 << 16) | MUX_PA04I_CCL_IN0)
#define PORT_PA04I_CCL_IN0         (1ul <<  4)
#define PIN_PA16I_CCL_IN0                 16L  /**< \brief CCL signal: IN0 on PA16 mux I */
#define MUX_PA16I_CCL_IN0                  8L
#define PINMUX_PA16I_CCL_IN0       ((PIN_PA16I_CCL_IN0 << 16) | MUX_PA16I_CCL_IN0)
#define PORT_PA16I_CCL_IN0         (1ul << 16)
#define PIN_PB22I_CCL_IN0                 54L  /**< \brief CCL signal: IN0 on PB22 mux I */
#define MUX_PB22I_CCL_IN0                  8L
#define PINMUX_PB22I_CCL_IN0       ((PIN_PB22I_CCL_IN0 << 16) | MUX_PB22I_CCL_IN0)
#define PORT_PB22I_CCL_IN0         (1ul << 22)
#define PIN_PA05I_CCL_IN1                  5L  /**< \brief CCL signal: IN1 on PA05 mux I */
#define MUX_PA05I_CCL_IN1                  8L
#define PINMUX_PA05I_CCL_IN1       ((PIN_PA05I_CCL_IN1 << 16) | MUX_PA05I_CCL_IN1)
#define PORT_PA05I_CCL_IN1         (1ul <<  5)
#define PIN_PA17I_CCL_IN1                 17L  /**< \brief CCL signal: IN1 on PA17 mux I */
#define MUX_PA17I_CCL_IN1                  8L
#define PINMUX_PA17I_CCL_IN1       ((PIN_PA17I_CCL_IN1 << 16) | MUX_PA17I_CCL_IN1)
#define PORT_PA17I_CCL_IN1         (1ul << 17)
#define PIN_PA06I_CCL_IN2                  6L  /**< \brief CCL signal: IN2 on PA06 mux I */
#define MUX_PA06I_CCL_IN2                  8L
#define PINMUX_PA06I_CCL_IN2       ((PIN_PA06I_CCL_IN2 << 16) | MUX_PA06I_CCL_IN2)
#define PORT_PA06I_CCL_IN2         (1ul <<  6)
#define PIN_PA18I_CCL_IN2                 18L  /**< \brief CCL signal: IN2 on PA18 mux I */
#define MUX_PA18I_CCL_IN2                  8L
#define PINMUX_PA18I_CCL_IN2       ((PIN_PA18I_CCL_IN2 << 16) | MUX_PA18I_CCL_IN2)
#define PORT_PA18I_CCL_IN2         (1ul << 18)
#define PIN_PA08I_CCL_IN3                  8L  /**< \brief CCL signal: IN3 on PA08 mux I */
#define MUX_PA08I_CCL_IN3                  8L
#define PINMUX_PA08I_CCL_IN3       ((PIN_PA08I_CCL_IN3 << 16) | MUX_PA08I_CCL_IN3)
#define PORT_PA08I_CCL_IN3         (1ul <<  8)
#define PIN_PA30I_CCL_IN3                 30L  /**< \brief CCL signal: IN3 on PA30 mux I */
#define MUX_PA30I_CCL_IN3                  8L
#define PINMUX_PA30I_CCL_IN3       ((PIN_PA30I_CCL_IN3 << 16) | MUX_PA30I_CCL_IN3)
#define PORT_PA30I_CCL_IN3         (1ul << 30)
#define PIN_PA09I_CCL_IN4                  9L  /**< \brief CCL signal: IN4 on PA09 mux I */
#define MUX_PA09I_CCL_IN4                  8L
#define PINMUX_PA09I_CCL_IN4       ((PIN_PA09I_CCL_IN4 << 16) | MUX_PA09I_CCL_IN4)
#define PORT_PA09I_CCL_IN4         (1ul <<  9)
#define PIN_PA10I_CCL_IN5                 10L  /**< \brief CCL signal: IN5 on PA10 mux I */
#define MUX_PA10I_CCL_IN5                  8L
#define PINMUX_PA10I_CCL_IN5       ((PIN_PA10I_CCL_IN5 << 16) | MUX_PA10I_CCL_IN5)
#define PORT_PA10I_CCL_IN5         (1ul << 10)
#define PIN_PA22I_CCL_IN6                 22L  /**< \brief CCL signal: IN6 on PA22 mux I */
#define MUX_PA22I_CCL_IN6                  8L
#define PINMUX_PA22I_CCL_IN6       ((PIN_PA22I_CCL_IN6 << 16) | MUX_PA22I_CCL_IN6)
#define PORT_PA22I_CCL_IN6         (1ul << 22)
#define PIN_PA23I_CCL_IN7                 23L  /**< \brief CCL signal: IN7 on PA23 mux I */
#define MUX_PA23I_CCL_IN7                  8L
#define PINMUX_PA23I_CCL_IN7       ((PIN_PA23I_CCL_IN7 << 16) | MUX_PA23I_CCL_IN7)
#define PORT_PA23I_CCL_IN7         (1ul << 23)
#define PIN_PA24I_CCL_IN8                 24L  /**< \brief CCL signal: IN8 on PA24 mux I */
#define MUX_PA24I_CCL_IN8                  8L
#define PINMUX_PA24I_CCL_IN8       ((PIN_PA24I_CCL_IN8 << 16) | MUX_PA24I_CCL_IN8)
#define PORT_PA24I_CCL_IN8         (1ul << 24)
#define PIN_PB08I_CCL_IN8                 40L  /**< \brief CCL signal: IN8 on PB08 mux I */
#define MUX_PB08I_CCL_IN8                  8L
#define PINMUX_PB08I_CCL_IN8       ((PIN_PB08I_CCL_IN8 << 16) | MUX_PB08I_CCL_IN8)
#define PORT_PB08I_CCL_IN8         (1ul <<  8)
#define PIN_PA07I_CCL_OUT0                 7L  /**< \brief CCL signal: OUT0 on PA07 mux I */
#define MUX_PA07I_CCL_OUT0                 8L
#define PINMUX_PA07I_CCL_OUT0      ((PIN_PA07I_CCL_OUT0 << 16) | MUX_PA07I_CCL_OUT0)
#define PORT_PA07I_CCL_OUT0        (1ul <<  7)
#define PIN_PA19I_CCL_OUT0                19L  /**< \brief CCL signal: OUT0 on PA19 mux I */
#define MUX_PA19I_CCL_OUT0                 8L
#define PINMUX_PA19I_CCL_OUT0      ((PIN_PA19I_CCL_OUT0 << 16) | MUX_PA19I_CCL_OUT0)
#define PORT_PA19I_CCL_OUT0        (1ul << 19)
#define PIN_PB02I_CCL_OUT0                34L  /**< \brief CCL signal: OUT0 on PB02 mux I */
#define MUX_PB02I_CCL_OUT0                 8L
#define PINMUX_PB02I_CCL_OUT0      ((PIN_PB02I_CCL_OUT0 << 16) | MUX_PB02I_CCL_OUT0)
#define PORT_PB02I_CCL_OUT0        (1ul <<  2)
#define PIN_PB23I_CCL_OUT0                55L  /**< \brief CCL signal: OUT0 on PB23 mux I */
#define MUX_PB23I_CCL_OUT0                 8L
#define PINMUX_PB23I_CCL_OUT0      ((PIN_PB23I_CCL_OUT0 << 16) | MUX_PB23I_CCL_OUT0)
#define PORT_PB23I_CCL_OUT0        (1ul << 23)
#define PIN_PA11I_CCL_OUT1                11L  /**< \brief CCL signal: OUT1 on PA11 mux I */
#define MUX_PA11I_CCL_OUT1                 8L
#define PINMUX_PA11I_CCL_OUT1      ((PIN_PA11I_CCL_OUT1 << 16) | MUX_PA11I_CCL_OUT1)
#define PORT_PA11I_CCL_OUT1        (1ul << 11)
#define PIN_PA31I_CCL_OUT1                31L  /**< \brief CCL signal: OUT1 on PA31 mux I */
#define MUX_PA31I_CCL_OUT1                 8L
#define PINMUX_PA31I_CCL_OUT1      ((PIN_PA31I_CCL_OUT1 << 16) | MUX_PA31I_CCL_OUT1)
#define PORT_PA31I_CCL_OUT1        (1ul << 31)
#define PIN_PB11I_CCL_OUT1                43L  /**< \brief CCL signal: OUT1 on PB11 mux I */
#define MUX_PB11I_CCL_OUT1                 8L
#define PINMUX_PB11I_CCL_OUT1      ((PIN_PB11I_CCL_OUT1 << 16) | MUX_PB11I_CCL_OUT1)
#define PORT_PB11I_CCL_OUT1        (1ul << 11)
#define PIN_PA25I_CCL_OUT2                25L  /**< \brief CCL signal: OUT2 on PA25 mux I */
#define MUX_PA25I_CCL_OUT2                 8L
#define PINMUX_PA25I_CCL_OUT2      ((PIN_PA25I_CCL_OUT2 << 16) | MUX_PA25I_CCL_OUT2)
#define PORT_PA25I_CCL_OUT2        (1ul << 25)
#define PIN_PB09I_CCL_OUT2                41L  /**< \brief CCL signal: OUT2 on PB09 mux I */
#define MUX_PB09I_CCL_OUT2                 8L
#define PINMUX_PB09I_CCL_OUT2      ((PIN_PB09I_CCL_OUT2 << 16) | MUX_PB09I_CCL_OUT2)
#define PORT_PB09I_CCL_OUT2        (1ul <<  9)

#endif /* _SAML22G18A_PIO_ */
