This is binutils.info, produced by makeinfo version 4.0 from
/djgpp/gnu/binutl-2.112/binutils/binutils.texi.

START-INFO-DIR-ENTRY
* Binutils: (binutils).         The GNU binary utilities.
* ar: (binutils)ar.               Create, modify, and extract from archives
* nm: (binutils)nm.               List symbols from object files
* objcopy: (binutils)objcopy.	  Copy and translate object files
* objdump: (binutils)objdump.     Display information from object files
* ranlib: (binutils)ranlib.       Generate index to archive contents
* readelf: (binutils)readelf.	  Display the contents of ELF format files.
* size: (binutils)size.           List section sizes and total size
* strings: (binutils)strings.     List printable strings from files
* strip: (binutils)strip.         Discard symbols
* c++filt: (binutils)c++filt.	  Filter to demangle encoded C++ symbols
* cxxfilt: (binutils)c++filt.     MS-DOS name for c++filt
* addr2line: (binutils)addr2line. Convert addresses to file and line
* nlmconv: (binutils)nlmconv.     Converts object code into an NLM
* windres: (binutils)windres.	  Manipulate Windows resources
* dlltool: (binutils)dlltool.	  Create files needed to build and use DLLs
END-INFO-DIR-ENTRY

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97, 98, 99, 2000, 2001 Free
Software Foundation, Inc.

   Permission is granted to copy, distribute and/or modify this document
     under the terms of the GNU Free Documentation License, Version 1.1
     or any later version published by the Free Software Foundation;
   with no Invariant Sections, with no Front-Cover Texts, and with no
    Back-Cover Texts.  A copy of the license is included in the
section entitled "GNU Free Documentation License".


File: binutils.info,  Node: Linker Emulation Selection,  Prev: Architecture Selection,  Up: Selecting The Target System

Linker emulation selection
==========================

   A linker "emulation" is a "personality" of the linker, which gives
the linker default values for the other aspects of the target system.
In particular, it consists of

   * the linker script

   * the target

   * several "hook" functions that are run at certain stages of the
     linking process to do special things that some targets require

   The command to list valid linker emulation values is `ld -V'.

   Sample values: `hp300bsd', `mipslit', `sun4'.

   Ways to specify:

  1. command line option: `-m' (*note Options: (ld.info)Options.)

  2. environment variable `LDEMULATION'

  3. compiled-in `DEFAULT_EMULATION' from `Makefile', which comes from
     `EMUL' in `config/TARGET.mt'


File: binutils.info,  Node: Reporting Bugs,  Next: GNU Free Documentation License,  Prev: Selecting The Target System,  Up: Top

Reporting Bugs
**************

   Your bug reports play an essential role in making the binary
utilities reliable.

   Reporting a bug may help you by bringing a solution to your problem,
or it may not.  But in any case the principal function of a bug report
is to help the entire community by making the next version of the binary
utilities work better.  Bug reports are your contribution to their
maintenance.

   In order for a bug report to serve its purpose, you must include the
information that enables us to fix the bug.

* Menu:

* Bug Criteria::                Have you found a bug?
* Bug Reporting::               How to report bugs


File: binutils.info,  Node: Bug Criteria,  Next: Bug Reporting,  Up: Reporting Bugs

Have you found a bug?
=====================

   If you are not sure whether you have found a bug, here are some
guidelines:

   * If a binary utility gets a fatal signal, for any input whatever,
     that is a bug.  Reliable utilities never crash.

   * If a binary utility produces an error message for valid input,
     that is a bug.

   * If you are an experienced user of binary utilities, your
     suggestions for improvement are welcome in any case.


File: binutils.info,  Node: Bug Reporting,  Prev: Bug Criteria,  Up: Reporting Bugs

How to report bugs
==================

   A number of companies and individuals offer support for GNU
products.  If you obtained the binary utilities from a support
organization, we recommend you contact that organization first.

   You can find contact information for many support companies and
individuals in the file `etc/SERVICE' in the GNU Emacs distribution.

   In any event, we also recommend that you send bug reports for the
binary utilities to `bug-binutils@gnu.org'.

   The fundamental principle of reporting bugs usefully is this:
*report all the facts*.  If you are not sure whether to state a fact or
leave it out, state it!

   Often people omit facts because they think they know what causes the
problem and assume that some details do not matter.  Thus, you might
assume that the name of a file you use in an example does not matter.
Well, probably it does not, but one cannot be sure.  Perhaps the bug is
a stray memory reference which happens to fetch from the location where
that pathname is stored in memory; perhaps, if the pathname were
different, the contents of that location would fool the utility into
doing the right thing despite the bug.  Play it safe and give a
specific, complete example.  That is the easiest thing for you to do,
and the most helpful.

   Keep in mind that the purpose of a bug report is to enable us to fix
the bug if it is new to us.  Therefore, always write your bug reports
on the assumption that the bug has not been reported previously.

   Sometimes people give a few sketchy facts and ask, "Does this ring a
bell?"  Those bug reports are useless, and we urge everyone to _refuse
to respond to them_ except to chide the sender to report bugs properly.

   To enable us to fix the bug, you should include all these things:

   * The version of the utility.  Each utility announces it if you
     start it with the `--version' argument.

     Without this, we will not know whether there is any point in
     looking for the bug in the current version of the binary utilities.

   * Any patches you may have applied to the source, including any
     patches made to the `BFD' library.

   * The type of machine you are using, and the operating system name
     and version number.

   * What compiler (and its version) was used to compile the
     utilities--e.g.  "`gcc-2.7'".

   * The command arguments you gave the utility to observe the bug.  To
     guarantee you will not omit something important, list them all.  A
     copy of the Makefile (or the output from make) is sufficient.

     If we were to try to guess the arguments, we would probably guess
     wrong and then we might not encounter the bug.

   * A complete input file, or set of input files, that will reproduce
     the bug.  If the utility is reading an object file or files, then
     it is generally most helpful to send the actual object files,
     uuencoded if necessary to get them through the mail system.  Note
     that `bug-binutils@gnu.org' is a mailing list, so you should avoid
     sending very large files to it.  Making the files available for
     anonymous FTP is OK.

     If the source files were produced exclusively using GNU programs
     (e.g., `gcc', `gas', and/or the GNU `ld'), then it may be OK to
     send the source files rather than the object files.  In this case,
     be sure to say exactly what version of `gcc', or whatever, was
     used to produce the object files.  Also say how `gcc', or
     whatever, was configured.

   * A description of what behavior you observe that you believe is
     incorrect.  For example, "It gets a fatal signal."

     Of course, if the bug is that the utility gets a fatal signal,
     then we will certainly notice it.  But if the bug is incorrect
     output, we might not notice unless it is glaringly wrong.  You
     might as well not give us a chance to make a mistake.

     Even if the problem you experience is a fatal signal, you should
     still say so explicitly.  Suppose something strange is going on,
     such as your copy of the utility is out of synch, or you have
     encountered a bug in the C library on your system.  (This has
     happened!)  Your copy might crash and ours would not.  If you told
     us to expect a crash, then when ours fails to crash, we would know
     that the bug was not happening for us.  If you had not told us to
     expect a crash, then we would not be able to draw any conclusion
     from our observations.

   * If you wish to suggest changes to the source, send us context
     diffs, as generated by `diff' with the `-u', `-c', or `-p' option.
     Always send diffs from the old file to the new file.  If you wish
     to discuss something in the `ld' source, refer to it by context,
     not by line number.

     The line numbers in our development sources will not match those
     in your sources.  Your line numbers would convey no useful
     information to us.

   Here are some things that are not necessary:

   * A description of the envelope of the bug.

     Often people who encounter a bug spend a lot of time investigating
     which changes to the input file will make the bug go away and which
     changes will not affect it.

     This is often time consuming and not very useful, because the way
     we will find the bug is by running a single example under the
     debugger with breakpoints, not by pure deduction from a series of
     examples.  We recommend that you save your time for something else.

     Of course, if you can find a simpler example to report _instead_
     of the original one, that is a convenience for us.  Errors in the
     output will be easier to spot, running under the debugger will take
     less time, and so on.

     However, simplification is not vital; if you do not want to do
     this, report the bug anyway and send us the entire test case you
     used.

   * A patch for the bug.

     A patch for the bug does help us if it is a good one.  But do not
     omit the necessary information, such as the test case, on the
     assumption that a patch is all we need.  We might see problems
     with your patch and decide to fix the problem another way, or we
     might not understand it at all.

     Sometimes with programs as complicated as the binary utilities it
     is very hard to construct an example that will make the program
     follow a certain path through the code.  If you do not send us the
     example, we will not be able to construct one, so we will not be
     able to verify that the bug is fixed.

     And if we cannot understand what bug you are trying to fix, or why
     your patch should be an improvement, we will not install it.  A
     test case will help us to understand.

   * A guess about what the bug is or what it depends on.

     Such guesses are usually wrong.  Even we cannot guess right about
     such things without first using the debugger to find the facts.


File: binutils.info,  Node: GNU Free Documentation License,  Next: Index,  Prev: Reporting Bugs,  Up: Top

GNU Free Documentation License
******************************

   GNU Free Documentation License

   Version 1.1, March 2000

   Copyright (C) 2000  Free Software Foundation, Inc.    59 Temple
Place, Suite 330, Boston, MA  02111-1307  USA

   Everyone is permitted to copy and distribute verbatim copies  of
this license document, but changing it is not allowed.

   0. PREAMBLE

   The purpose of this License is to make a manual, textbook, or other
written document "free" in the sense of freedom: to assure everyone the
effective freedom to copy and redistribute it, with or without
modifying it, either commercially or noncommercially.  Secondarily,
this License preserves for the author and publisher a way to get credit
for their work, while not being considered responsible for
modifications made by others.

   This License is a kind of "copyleft", which means that derivative
works of the document must themselves be free in the same sense.  It
complements the GNU General Public License, which is a copyleft license
designed for free software.

   We have designed this License in order to use it for manuals for free
software, because free software needs free documentation: a free
program should come with manuals providing the same freedoms that the
software does.  But this License is not limited to software manuals; it
can be used for any textual work, regardless of subject matter or
whether it is published as a printed book.  We recommend this License
principally for works whose purpose is instruction or reference.

   1. APPLICABILITY AND DEFINITIONS

   This License applies to any manual or other work that contains a
notice placed by the copyright holder saying it can be distributed
under the terms of this License.  The "Document", below, refers to any
such manual or work.  Any member of the public is a licensee, and is
addressed as "you".

   A "Modified Version" of the Document means any work containing the
Document or a portion of it, either copied verbatim, or with
modifications and/or translated into another language.

   A "Secondary Section" is a named appendix or a front-matter section
of the Document that deals exclusively with the relationship of the
publishers or authors of the Document to the Document's overall subject
(or to related matters) and contains nothing that could fall directly
within that overall subject.  (For example, if the Document is in part a
textbook of mathematics, a Secondary Section may not explain any
mathematics.)  The relationship could be a matter of historical
connection with the subject or with related matters, or of legal,
commercial, philosophical, ethical or political position regarding them.

   The "Invariant Sections" are certain Secondary Sections whose titles
are designated, as being those of Invariant Sections, in the notice
that says that the Document is released under this License.

   The "Cover Texts" are certain short passages of text that are listed,
as Front-Cover Texts or Back-Cover Texts, in the notice that says that
the Document is released under this License.

   A "Transparent" copy of the Document means a machine-readable copy,
represented in a format whose specification is available to the general
public, whose contents can be viewed and edited directly and
straightforwardly with generic text editors or (for images composed of
pixels) generic paint programs or (for drawings) some widely available
drawing editor, and that is suitable for input to text formatters or
for automatic translation to a variety of formats suitable for input to
text formatters.  A copy made in an otherwise Transparent file format
whose markup has been designed to thwart or discourage subsequent
modification by readers is not Transparent.  A copy that is not
"Transparent" is called "Opaque".

   Examples of suitable formats for Transparent copies include plain
ASCII without markup, Texinfo input format, LaTeX input format, SGML or
XML using a publicly available DTD, and standard-conforming simple HTML
designed for human modification.  Opaque formats include PostScript,
PDF, proprietary formats that can be read and edited only by
proprietary word processors, SGML or XML for which the DTD and/or
processing tools are not generally available, and the machine-generated
HTML produced by some word processors for output purposes only.

   The "Title Page" means, for a printed book, the title page itself,
plus such following pages as are needed to hold, legibly, the material
this License requires to appear in the title page.  For works in
formats which do not have any title page as such, "Title Page" means
the text near the most prominent appearance of the work's title,
preceding the beginning of the body of the text.

   2. VERBATIM COPYING

   You may copy and distribute the Document in any medium, either
commercially or noncommercially, provided that this License, the
copyright notices, and the license notice saying this License applies
to the Document are reproduced in all copies, and that you add no other
conditions whatsoever to those of this License.  You may not use
technical measures to obstruct or control the reading or further
copying of the copies you make or distribute.  However, you may accept
compensation in exchange for copies.  If you distribute a large enough
number of copies you must also follow the conditions in section 3.

   You may also lend copies, under the same conditions stated above, and
you may publicly display copies.

   3. COPYING IN QUANTITY

   If you publish printed copies of the Document numbering more than
100, and the Document's license notice requires Cover Texts, you must
enclose the copies in covers that carry, clearly and legibly, all these
Cover Texts: Front-Cover Texts on the front cover, and Back-Cover Texts
on the back cover.  Both covers must also clearly and legibly identify
you as the publisher of these copies.  The front cover must present the
full title with all words of the title equally prominent and visible.
You may add other material on the covers in addition.  Copying with
changes limited to the covers, as long as they preserve the title of
the Document and satisfy these conditions, can be treated as verbatim
copying in other respects.

   If the required texts for either cover are too voluminous to fit
legibly, you should put the first ones listed (as many as fit
reasonably) on the actual cover, and continue the rest onto adjacent
pages.

   If you publish or distribute Opaque copies of the Document numbering
more than 100, you must either include a machine-readable Transparent
copy along with each Opaque copy, or state in or with each Opaque copy
a publicly-accessible computer-network location containing a complete
Transparent copy of the Document, free of added material, which the
general network-using public has access to download anonymously at no
charge using public-standard network protocols.  If you use the latter
option, you must take reasonably prudent steps, when you begin
distribution of Opaque copies in quantity, to ensure that this
Transparent copy will remain thus accessible at the stated location
until at least one year after the last time you distribute an Opaque
copy (directly or through your agents or retailers) of that edition to
the public.

   It is requested, but not required, that you contact the authors of
the Document well before redistributing any large number of copies, to
give them a chance to provide you with an updated version of the
Document.

   4. MODIFICATIONS

   You may copy and distribute a Modified Version of the Document under
the conditions of sections 2 and 3 above, provided that you release the
Modified Version under precisely this License, with the Modified
Version filling the role of the Document, thus licensing distribution
and modification of the Modified Version to whoever possesses a copy of
it.  In addition, you must do these things in the Modified Version:

   A. Use in the Title Page (and on the covers, if any) a title distinct
  from that of the Document, and from those of previous versions
(which should, if there were any, be listed in the History section
of the Document).  You may use the same title as a previous version
if the original publisher of that version gives permission.  B. List on
the Title Page, as authors, one or more persons or entities
responsible for authorship of the modifications in the Modified
Version, together with at least five of the principal authors of the
Document (all of its principal authors, if it has less than five).  C.
State on the Title page the name of the publisher of the    Modified
Version, as the publisher.  D. Preserve all the copyright notices of
the Document.  E. Add an appropriate copyright notice for your
modifications    adjacent to the other copyright notices.  F. Include,
immediately after the copyright notices, a license notice    giving the
public permission to use the Modified Version under the    terms of
this License, in the form shown in the Addendum below.  G. Preserve in
that license notice the full lists of Invariant Sections    and
required Cover Texts given in the Document's license notice.  H.
Include an unaltered copy of this License.  I. Preserve the section
entitled "History", and its title, and add to    it an item stating at
least the title, year, new authors, and    publisher of the Modified
Version as given on the Title Page.  If    there is no section entitled
"History" in the Document, create one    stating the title, year,
authors, and publisher of the Document as    given on its Title Page,
then add an item describing the Modified    Version as stated in the
previous sentence.  J. Preserve the network location, if any, given in
the Document for    public access to a Transparent copy of the
Document, and likewise    the network locations given in the Document
for previous versions    it was based on.  These may be placed in the
"History" section.     You may omit a network location for a work that
was published at    least four years before the Document itself, or if
the original    publisher of the version it refers to gives permission.
K. In any section entitled "Acknowledgements" or "Dedications",
preserve the section's title, and preserve in the section all the
substance and tone of each of the contributor acknowledgements
and/or dedications given therein.  L. Preserve all the Invariant
Sections of the Document,    unaltered in their text and in their
titles.  Section numbers    or the equivalent are not considered part
of the section titles.  M. Delete any section entitled "Endorsements".
Such a section    may not be included in the Modified Version.  N. Do
not retitle any existing section as "Endorsements"    or to conflict in
title with any Invariant Section.

   If the Modified Version includes new front-matter sections or
appendices that qualify as Secondary Sections and contain no material
copied from the Document, you may at your option designate some or all
of these sections as invariant.  To do this, add their titles to the
list of Invariant Sections in the Modified Version's license notice.
These titles must be distinct from any other section titles.

   You may add a section entitled "Endorsements", provided it contains
nothing but endorsements of your Modified Version by various
parties-for example, statements of peer review or that the text has
been approved by an organization as the authoritative definition of a
standard.

   You may add a passage of up to five words as a Front-Cover Text, and
a passage of up to 25 words as a Back-Cover Text, to the end of the list
of Cover Texts in the Modified Version.  Only one passage of
Front-Cover Text and one of Back-Cover Text may be added by (or through
arrangements made by) any one entity.  If the Document already includes
a cover text for the same cover, previously added by you or by
arrangement made by the same entity you are acting on behalf of, you
may not add another; but you may replace the old one, on explicit
permission from the previous publisher that added the old one.

   The author(s) and publisher(s) of the Document do not by this License
give permission to use their names for publicity for or to assert or
imply endorsement of any Modified Version.

   5. COMBINING DOCUMENTS

   You may combine the Document with other documents released under this
License, under the terms defined in section 4 above for modified
versions, provided that you include in the combination all of the
Invariant Sections of all of the original documents, unmodified, and
list them all as Invariant Sections of your combined work in its
license notice.

   The combined work need only contain one copy of this License, and
multiple identical Invariant Sections may be replaced with a single
copy.  If there are multiple Invariant Sections with the same name but
different contents, make the title of each such section unique by
adding at the end of it, in parentheses, the name of the original
author or publisher of that section if known, or else a unique number.
Make the same adjustment to the section titles in the list of Invariant
Sections in the license notice of the combined work.

   In the combination, you must combine any sections entitled "History"
in the various original documents, forming one section entitled
"History"; likewise combine any sections entitled "Acknowledgements",
and any sections entitled "Dedications".  You must delete all sections
entitled "Endorsements."

   6. COLLECTIONS OF DOCUMENTS

   You may make a collection consisting of the Document and other
documents released under this License, and replace the individual
copies of this License in the various documents with a single copy that
is included in the collection, provided that you follow the rules of
this License for verbatim copying of each of the documents in all other
respects.

   You may extract a single document from such a collection, and
distribute it individually under this License, provided you insert a
copy of this License into the extracted document, and follow this
License in all other respects regarding verbatim copying of that
document.

   7. AGGREGATION WITH INDEPENDENT WORKS

   A compilation of the Document or its derivatives with other separate
and independent documents or works, in or on a volume of a storage or
distribution medium, does not as a whole count as a Modified Version of
the Document, provided no compilation copyright is claimed for the
compilation.  Such a compilation is called an "aggregate", and this
License does not apply to the other self-contained works thus compiled
with the Document, on account of their being thus compiled, if they are
not themselves derivative works of the Document.

   If the Cover Text requirement of section 3 is applicable to these
copies of the Document, then if the Document is less than one quarter
of the entire aggregate, the Document's Cover Texts may be placed on
covers that surround only the Document within the aggregate.  Otherwise
they must appear on covers around the whole aggregate.

   8. TRANSLATION

   Translation is considered a kind of modification, so you may
distribute translations of the Document under the terms of section 4.
Replacing Invariant Sections with translations requires special
permission from their copyright holders, but you may include
translations of some or all Invariant Sections in addition to the
original versions of these Invariant Sections.  You may include a
translation of this License provided that you also include the original
English version of this License.  In case of a disagreement between the
translation and the original English version of this License, the
original English version will prevail.

   9. TERMINATION

   You may not copy, modify, sublicense, or distribute the Document
except as expressly provided for under this License.  Any other attempt
to copy, modify, sublicense or distribute the Document is void, and will
automatically terminate your rights under this License.  However,
parties who have received copies, or rights, from you under this
License will not have their licenses terminated so long as such parties
remain in full compliance.

   10. FUTURE REVISIONS OF THIS LICENSE

   The Free Software Foundation may publish new, revised versions of
the GNU Free Documentation License from time to time.  Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.  See
http://www.gnu.org/copyleft/.

   Each version of the License is given a distinguishing version number.
If the Document specifies that a particular numbered version of this
License "or any later version" applies to it, you have the option of
following the terms and conditions either of that specified version or
of any later version that has been published (not as a draft) by the
Free Software Foundation.  If the Document does not specify a version
number of this License, you may choose any version ever published (not
as a draft) by the Free Software Foundation.

   ADDENDUM: How to use this License for your documents

   To use this License in a document you have written, include a copy of
the License in the document and put the following copyright and license
notices just after the title page:

         Copyright (c)  YEAR  YOUR NAME.
         Permission is granted to copy, distribute and/or modify this document
         under the terms of the GNU Free Documentation License, Version 1.1
         or any later version published by the Free Software Foundation;
         with the Invariant Sections being LIST THEIR TITLES, with the
         Front-Cover Texts being LIST, and with the Back-Cover Texts being LIST.
         A copy of the license is included in the section entitled "GNU
         Free Documentation License".

   If you have no Invariant Sections, write "with no Invariant Sections"
instead of saying which ones are invariant.  If you have no Front-Cover
Texts, write "no Front-Cover Texts" instead of "Front-Cover Texts being
LIST"; likewise for Back-Cover Texts.

   If your document contains nontrivial examples of program code, we
recommend releasing these examples in parallel under your choice of
free software license, such as the GNU General Public License, to
permit their use in free software.


File: binutils.info,  Node: Index,  Prev: GNU Free Documentation License,  Up: Top

Index
*****

* Menu:

* .stab:                                 objdump.
* addr2line:                             addr2line.
* address to file name and line number:  addr2line.
* all header information, object file:   objdump.
* ar:                                    ar.
* ar compatibility:                      ar.
* architecture:                          objdump.
* architectures available:               objdump.
* archive contents:                      ranlib.
* archive headers:                       objdump.
* archives:                              ar.
* base files:                            dlltool.
* bug criteria:                          Bug Criteria.
* bug reports:                           Bug Reporting.
* bugs:                                  Reporting Bugs.
* bugs, reporting:                       Bug Reporting.
* c++filt:                               c++filt.
* changing object addresses:             objcopy.
* changing section address:              objcopy.
* changing section LMA:                  objcopy.
* changing section VMA:                  objcopy.
* changing start address:                objcopy.
* collections of files:                  ar.
* compatibility, ar:                     ar.
* contents of archive:                   ar cmdline.
* crash:                                 Bug Criteria.
* creating archives:                     ar cmdline.
* cxxfilt:                               c++filt.
* dates in archive:                      ar cmdline.
* debug symbols:                         objdump.
* debugging symbols:                     nm.
* deleting from archive:                 ar cmdline.
* demangling C++ symbols:                c++filt.
* demangling in nm:                      nm.
* demangling in objdump <1>:             addr2line.
* demangling in objdump:                 objdump.
* disassembling object code:             objdump.
* disassembly architecture:              objdump.
* disassembly endianness:                objdump.
* disassembly, with source:              objdump.
* discarding symbols:                    strip.
* DLL:                                   dlltool.
* dlltool:                               dlltool.
* dynamic relocation entries, in object file: objdump.
* dynamic symbol table entries, printing: objdump.
* dynamic symbols:                       nm.
* ELF core notes:                        readelf.
* ELF dynamic section information:       readelf.
* ELF file header information:           readelf.
* ELF file information:                  readelf.
* ELF object file format:                objdump.
* ELF program header information:        readelf.
* ELF reloc information:                 readelf.
* ELF section information:               readelf.
* ELF segment information:               readelf.
* ELF symbol table information:          readelf.
* ELF version sections informations:     readelf.
* endianness:                            objdump.
* error on valid input:                  Bug Criteria.
* external symbols:                      nm.
* extract from archive:                  ar cmdline.
* fatal signal:                          Bug Criteria.
* file name:                             nm.
* GNU Free Documentation License:        GNU Free Documentation License.
* header information, all:               objdump.
* input .def file:                       dlltool.
* input file name:                       nm.
* libraries:                             ar.
* listings strings:                      strings.
* machine instructions:                  objdump.
* moving in archive:                     ar cmdline.
* MRI compatibility, ar:                 ar scripts.
* name duplication in archive:           ar cmdline.
* name length:                           ar.
* nm:                                    nm.
* nm compatibility:                      nm.
* nm format:                             nm.
* not writing archive index:             ar cmdline.
* objdump:                               objdump.
* object code format <1>:                strings.
* object code format <2>:                size.
* object code format <3>:                nm.
* object code format <4>:                addr2line.
* object code format:                    objdump.
* object file header:                    objdump.
* object file information:               objdump.
* object file sections:                  objdump.
* object formats available:              objdump.
* operations on archive:                 ar cmdline.
* printing from archive:                 ar cmdline.
* printing strings:                      strings.
* quick append to archive:               ar cmdline.
* radix for section sizes:               size.
* ranlib:                                ranlib.
* readelf:                               readelf.
* relative placement in archive:         ar cmdline.
* relocation entries, in object file:    objdump.
* removing symbols:                      strip.
* repeated names in archive:             ar cmdline.
* replacement in archive:                ar cmdline.
* reporting bugs:                        Reporting Bugs.
* scripts, ar:                           ar scripts.
* section addresses in objdump:          objdump.
* section headers:                       objdump.
* section information:                   objdump.
* section sizes:                         size.
* sections, full contents:               objdump.
* size:                                  size.
* size display format:                   size.
* size number format:                    size.
* sorting symbols:                       nm.
* source code context:                   objdump.
* source disassembly:                    objdump.
* source file name:                      nm.
* source filenames for object files:     objdump.
* stab:                                  objdump.
* start-address:                         objdump.
* stop-address:                          objdump.
* strings:                               strings.
* strings, printing:                     strings.
* strip:                                 strip.
* symbol index <1>:                      ranlib.
* symbol index:                          ar.
* symbol index, listing:                 nm.
* symbol line numbers:                   nm.
* symbol table entries, printing:        objdump.
* symbols:                               nm.
* symbols, discarding:                   strip.
* undefined symbols:                     nm.
* Unix compatibility, ar:                ar cmdline.
* updating an archive:                   ar cmdline.
* version:                               Top.
* VMA in objdump:                        objdump.
* wide output, printing:                 objdump.
* writing archive index:                 ar cmdline.


