*** orig/make-3.71/vpath.c	Thu Jul 21 01:30:12 1994
--- src/make-3.71/vpath.c	Thu Jul 21 01:33:14 1994
***************
*** 20,25 ****
--- 20,30 ----
  #include "file.h"
  #include "variable.h"
  
+ #ifdef __MSDOS__
+ #define PATH_SEPARATOR_CHAR ';'
+ #else
+ #define PATH_SEPARATOR_CHAR ':'
+ #endif
  
  /* Structure used to represent a selective VPATH searchpath.  */
  
***************
*** 177,183 ****
    maxelem = 2;
    p = dirpath;
    while (*p != '\0')
!     if (*p++ == ':' || isblank (*p))
        ++maxelem;
  
    vpath = (char **) xmalloc (maxelem * sizeof (char *));
--- 182,188 ----
    maxelem = 2;
    p = dirpath;
    while (*p != '\0')
!     if (*p++ == PATH_SEPARATOR_CHAR || isblank (*p))
        ++maxelem;
  
    vpath = (char **) xmalloc (maxelem * sizeof (char *));
***************
*** 185,191 ****
  
    /* Skip over any initial colons and blanks.  */
    p = dirpath;
!   while (*p == ':' || isblank (*p))
      ++p;
  
    elem = 0;
--- 190,196 ----
  
    /* Skip over any initial colons and blanks.  */
    p = dirpath;
!   while (*p == PATH_SEPARATOR_CHAR || isblank (*p))
      ++p;
  
    elem = 0;
***************
*** 196,202 ****
  
        /* Find the end of this entry.  */
        v = p;
!       while (*p != '\0' && *p != ':' && !isblank (*p))
  	++p;
  
        len = p - v;
--- 201,207 ----
  
        /* Find the end of this entry.  */
        v = p;
!       while (*p != '\0' && *p != PATH_SEPARATOR_CHAR && !isblank (*p))
  	++p;
  
        len = p - v;
***************
*** 225,231 ****
  	}
  
        /* Skip over colons and blanks between entries.  */
!       while (*p == ':' || isblank (*p))
  	++p;
      }
  
--- 230,236 ----
  	}
  
        /* Skip over colons and blanks between entries.  */
!       while (*p == PATH_SEPARATOR_CHAR || isblank (*p))
  	++p;
      }
  
***************
*** 461,467 ****
  
        for (i = 0; v->searchpath[i] != 0; ++i)
  	printf ("%s%c", v->searchpath[i],
! 		v->searchpath[i + 1] == 0 ? '\n' : ':');
      }
  
    if (vpaths == 0)
--- 466,472 ----
  
        for (i = 0; v->searchpath[i] != 0; ++i)
  	printf ("%s%c", v->searchpath[i],
! 		v->searchpath[i + 1] == 0 ? '\n' : PATH_SEPARATOR_CHAR);
      }
  
    if (vpaths == 0)
***************
*** 479,484 ****
        fputs ("\n# General (`VPATH' variable) search path:\n# ", stdout);
  
        for (i = 0; path[i] != 0; ++i)
! 	printf ("%s%c", path[i], path[i + 1] == 0 ? '\n' : ':');
      }
  }
--- 484,489 ----
        fputs ("\n# General (`VPATH' variable) search path:\n# ", stdout);
  
        for (i = 0; path[i] != 0; ++i)
! 	printf ("%s%c", path[i], path[i + 1] == 0 ? '\n' : PATH_SEPARATOR_CHAR);
      }
  }
