
	include		head.h			;segment ̒`


	_DATA	segment	public 'DATA'
;---------------------------------------------------------------

_SyncParameter	dw	80	;C/R	;24kHz 400Line
		dw	8	;HS
		dw	10	;HFP
		dw	8	;HBP
		dw	8	;VS
		dw	7	;VFP
		dw	41	;VBP
		dw	400	;L/F

		dw	80	;C/R#	;31kHz 400Line
		dw	10	;HS
		dw	10	;HFP
		dw	6	;HBP   26
		dw	8	;VS
		dw	45	;VFP
		dw	55	;VBP
		dw	400	;L/F

;---------------------------------------------------------------
	_DATA	ENDS
	_TEXT	segment	public 'CODE'

;###############################################################
;
;
;	fcbFIFȌԂ𒲂ׂ%
;
;	void CheckGDCbuffer( INT16 SelectGDC )
;
;	In:	SelectGDC.0	0: TextGDC	1:GraphicGDC
;
;	Out			0: empty
;				1: disable
;				2: enable
;
;
_CheckGDCbuffer	proc
		push	bp
		mov	bp,sp
		push	dx

		test	byte ptr [bp+4],1
		jnz	@f

		in	al,060h			;TextGDC States
		jmp	_FIFOTestPhase
@@:
		in	al,0A0h			;GraphicGDC States
;        
_FIFOTestPhase:
		mov	dl,al

		test	dl,4
		jz	@f

		mov	ax,0			;empty
		jmp	exit_CheckGDCbuffer

@@:		test	dl,4
		jz	@f

		mov	ax,2			;Full
		jmp	exit_CheckGDCbuffer

@@:		mov	ax,1			;disable

exit_CheckGDCbuffer:
		pop	dx
		pop	bp
		ret
_CheckGDCbuffer	endp



;
;
;	urԏI҂%
;
;	void VSyncOutWait( void )
;
;
_VSyncOutWait	proc
		push	ax
@@:		in	al,60h
		test	al,20h
		jnz	@b
		pop	ax
		ret
_VSyncOutWait	endp



;
;
;	ur҂%
;
;	void VSyncInWait( void )
;
;
_VSyncInWait	proc
		push	ax
@@:		in	al,60h
		test	al,20h
		jz	@b
		pop	ax
		ret
_VSyncInWait	endp



;
;
;	fcb̃NbNς%
;
;	void SetGDCClock( INT16 Mode )
;
;	In:	Mode.0	0: GDC Clock 2.5MHz
;
;
_SetGDCClock	proc
		push	bp
		mov	bp,sp
		push	ax
		push	dx
		push	bx
		push	es

		xor	ax,ax
		mov	es,ax
		test	byte ptr [bp+4],1
		jnz	GDC5MHz
;
		mov	dx,06Ah
		mov	al,084h			;GDC 2.5MHz
		out	dx,al			;GDC 2.5MHz

		mov	bx,054Dh		;BIOSܰر
		and	byte ptr es:[bx],0FBh

		jmp	exit_SetGDCClock
;
GDC5MHz:	mov	dx,06Ah
		mov	al,083h			;GDC 5MHz
		out	dx,al			;GDC 5MHz
		mov	al,085h			;GDC 5MHz
		out	dx,al			;GDC 5MHz
	
		mov	bx,054Dh
		or	byte ptr es:[bx],004h
;
exit_SetGDCClock:
		call	_GetCRTStates
		and	ax,3
		push	ax
		call	_SyncSet
		add	sp,2

		pop	es
		pop	bx
		pop	dx
		pop	ax
		pop	bp
		ret
_SetGDCClock	endp



;
;
;	PUFOtBbNn%
;
;	void 16GraphicOn( void )
;
;
_16GraphicOn	proc
		push	ax
		push	dx
		push	bx

		mov	al,02h			;J[OtBbN[h
		out	68h,al			;J[OtBbN[h

		mov	dx,6Ah

		mov	al,41h			;vY}fBXvB
		out	dx,al			;vY}fBXvB

		mov	al,01h			;16 COLOR MODE
		out	dx,al			;16 COLOR MODE

		mov	Al,4Bh
		out	0A2H,al			;CSRFORM
		mov	Al,0
		out	0A0H,al			;c{P

		mov	al,08H			;𑜓x
		out	68H,al			;𑜓x

		mov	al,0			;VRAM View Page 0
		out	0A4h,al			;VRAM View Page 0

		mov	al,0			;VRAM Access Page 0
		out	0A6h,al			;VRAM Access Page 0

		mov	al,0Dh
		out	0A2h,al			;Graphic On

		pop	bx
		pop	dx
		pop	ax

		ret
_16GraphicOn	endp



;
;
;	PUFOtBbNn%
;
;	void 16GraphicOn( void )
;
;
_16GraphicOff	proc
		push	ax

		mov	al,0Ch
		out	0A2h,al			;Graphic Off

		pop	ax
		ret
_16GraphicOff	endp



;
;
;	QTUFOtBbNn%
;
;	void 256GraphicOn( void )
;
;
_256GraphicOn	proc
		push	ax
		push	dx

		call	_16GraphicOn

		mov	dx,6ah

		mov	al,07h
		out	dx,al		;g[hύX

		mov	al,21h
		out	dx,al		;g[h

		mov	al,06h
		out	dx,al		;g[hύXs

		pop	dx
		pop	ax
		ret
_256GraphicOn	endp



;
;
;	QTUFOtBbNn%
;
;	void 256GraphicOn( void )
;
;
_256GraphicOff	proc
		push	ax
		push	dx

		mov	dx,6ah

		mov	al,07h
		out	dx,al		;g[hύX

		mov	al,20h
		out	dx,al		;W[h

		mov	al,06h
		out	dx,al		;g[hύXs

		pop	dx
		pop	ax
		ret
_256GraphicOff	endp



;
;
;	ʂ̉ς**********
;
;	void SetHolizSize( INT16 size )
;
;
_SetHorizonalSize	proc
		push	bx
		mov	bp,sp
		push	ax
		push	dx

		mov	al,47h
		out	0A2h,al

		mov	ax,[bp+4]
		out	0A0h,al

		pop	dx
		pop	ax
		pop	bp
		ret
_SetHorizonalSize	endp



;
;
;	ʂ̏cς(OtBbN)%
;
;	void SetVerticalSize( INT16 size )
;
;
_SetVerticalSize	proc
		push	bx
		mov	bp,sp
		push	ax
		push	dx

		mov	al,4Bh
		out	0A2h,al

		mov	ax,[bp+4]
		dec	ax
		out	0A0h,al

		pop	dx
		pop	ax
		pop	bp
		ret
_SetVerticalSize	endp



;
;
;	rxmb̐ݒ%
;
;	void SyncSet( INT16 Mode )
;
;	In:	Mode.0	GDC Clock 0: 2.5MHz 1: 5Mhz
;		Mode.1	SyncClock 0: 24kHz  1: 31kHz
;
;   GDC̃NbN̈Ⴂɂĸ̨GDCɗ^p[^ςĂ.
;  ̓IɂͤGDCۯ2.5MHẑƂ̃p[^̒lɂȂ܂.
;   ܂AXL[hɂăp[^ςĂ̂͌܂łȂ.
;
	CR	equ	[bx+0]
	HS	equ	[bx+2]
	HFP	equ	[bx+4]
	HBP	equ	[bx+6]
	VS	equ	[bx+8]
	VFP	equ	[bx+10]
	VBP	equ	[bx+12]
	LF	equ	[bx+14]
;
_SyncSet	proc
		push	bp
		mov	bp,sp
		push	ax
		push	cx
		push	dx
		push	bx

		mov	bx,[bp+4]
		shl	bx,3
		and	bx,018h
		add	bx,offset _SyncParameter
;
 ;eLXgfcb̐ݒ
		mov	dx,060h
	;command		-SYNC-
		mov	al,0Eh
		out	062h,al

	;parameter0
		mov	al,00000000b
		out	dx,al

	;parameter1
		mov	ax,CR
		sub	ax,2
		out	dx,al

	;parameter2
		mov	ax,VS
		mov	cx,HS
		dec	cx
		shl	ax,5
		and	cx,00011111b
		or	ax,cx
		out	dx,al

	;parameter3
		mov	ax,VS
		mov	cx,HFP
		and	ax,00011111b
		dec	cx
		shr	ax,3
		shl	cx,2
		or	ax,cx
		out	dx,al

	;parameter4
		mov	ax,HBP
		dec	ax
		and	ax,00111111b
		out	dx,al

	;parameter5
		mov	ax,VFP
		and	ax,00111111b
		out	dx,al

	;parameter6
		mov	ax,LF
		out	dx,al

	;parameter7
		shr	ax,8
		and	al,3
		mov	cx,VBP
		shl	cx,2
		or	ax,cx
		out	dx,al

	;command		-Pitch-
		mov	al,47h
		out	062h,al
	;parameter
		mov	ax,80
		out	060h,al

;
 ;OtBbNfcb̐ݒ
		mov	dx,0a0h

		test	byte ptr [bp+4],1
		jnz	GDC5

GDC25:
	;command		-SYNC-
		mov	al,0eh
		out	0A2h,al

	;parameter0
		mov	al,00000110b
		out	dx,al

	;parameter1
		mov	ax,CR
		sub	ax,2
		out	dx,al

	;parameter2
		mov	ax,VS
		mov	cx,HS
		shr	cx,1
		dec	cx
		shl	ax,5
		and	cx,00011111b
		or	ax,cx
		out	dx,al

	;parameter3
		mov	ax,VS
		mov	cx,HFP
		shr	ax,1
		and	ax,00011111b
		dec	cx
		shr	ax,3
		shl	cx,2
		or	ax,cx
		out	dx,al

	;parameter4
		mov	ax,HBP
		shr	ax,1
		dec	ax
		and	ax,00111111b
		out	dx,al

	;parameter5
		mov	ax,VFP
		and	ax,00111111b
		out	dx,al

	;parameter6
		mov	ax,LF
		out	dx,al

	;parameter7
		shr	ax,8
		and	al,3
		mov	cx,VBP
		shl	cx,2
		or	ax,cx
		out	dx,al


	;command		-Pitch-
		mov	al,47h
		out	0A2h,al
	;parameter
		mov	ax,40
		out	0A0h,al
		jmp	ExitSyncSet
;                
GDC5:
	;command		-SYNC-
		mov	al,0eh
		out	0A2h,al

	;parameter0
		mov	al,00000110b
		out	dx,al

	;parameter1
		mov	ax,CR
		sub	ax,2
		out	dx,al

	;parameter2
		mov	ax,VS
		mov	cx,HS
		dec	cx
		shl	ax,5
		and	cx,00011111b
		or	ax,cx
		out	dx,al

	;parameter3
		mov	ax,VS
		mov	cx,HFP
		and	ax,00011111b
		dec	cx
		shr	ax,3
		shl	cx,2
		or	ax,cx
		out	dx,al

	;parameter4
		mov	ax,HBP
		dec	ax
		and	ax,00111111b
		out	dx,al

	;parameter5
		mov	ax,VFP
		and	ax,00111111b
		out	dx,al

	;parameter6
		mov	ax,LF
		out	dx,al

	;parameter7
		shr	ax,8
		and	al,3
		mov	cx,VBP
		shl	cx,2
		or	ax,cx
		out	dx,al


	;command		-Pitch-
		mov	al,47h
		out	0A2h,al
	;parameter
		mov	ax,80
		out	0A0h,al

;
ExitSyncSet:

		mov	al,0fh
		out	062h,al
		out	0A2h,al

		mov	al,0dh
		out	060h,al		;Text On
		out	0A0h,al		;Graphic On

		mov	al,0ffh
		out	068h,al

		pop	bx
		pop	dx
		pop	cx
		pop	ax
		pop	bp
		ret
_SyncSet	endp



;
;
;	ʎXe[^X̎擾
;
;	INT16 GetCRTStates( void )
;
;	Out	.0	0: GDC Clock2.5MHz
;		.1	0: HSync 24kHz
;		.2	1: g[h
;		.3	1: ̨ެL
;		.4	1: 256Mode
;
;
;
_GetCRTStates	proc
		push	cx
		push	dx
		push	si
		push	es
;
		xor	ax,ax
		mov	es,ax

		mov	si,045Ch
		mov	al,es:[si]
		and	al,40h		;256Mode݂邩
		shr	al,2

		mov	si,054Ch
		mov	cx,es:[si]

		and	ch,04h		;GDC Clock
		shr	ch,2
		and	al,ch

		mov	ch,cl

		and	cl,20h		;HSyncMode
		shr	cl,4
		and	al,cl

		and	ch,04h		;Graphic Charger
		shl	ch,2
		and	al,ch

		test	al,10h
		jz	@f

		push	ax
		mov	al,08
		mov	dx,09A0h
		out	dx,al
		out	5Fh,al
		in	al,dx		;g[h
		mov	cl,al
		pop	ax

		and	cx,1
		shl	cx,2
		or	ax,cx

@@:
;
		pop	es
		pop	si
		pop	dx
		pop	cx
		ret
_GetCRTStates	endp



;
;
;	XL[h̕ύX%
;
;	void SetScanMode( INT16 Mode )
;
;	In:	Mode.0	0: NoemalSCAN (24kHz)
;
;
_SetScanMode	proc
		push	bp
		mov	bp,sp

		push	ax
		push	dx
		push	si
		push	di
		push	es

		mov	al,07h
		out	6Ah,al			;g[hύX

		mov	si,045Ch		;[NGA
		mov	di,054Ch
		mov	al,00100000b

		test	byte ptr [bp+4],1
		jz	NormalScan
;
HiScan:		or	es:[si],al
		or	es:[di],al		;[NGA
		mov	al,1
		mov	dx,09A8h
		out	dx,al			;31kHz Mode

		jmp	exit_SetScanMode	;I֔
;
NormalScan:	not	al
		and	es:[si],al
		and	es:[di],al		;[NGA
		mov	al,0
		mov	dx,09A8h
		out	dx,al			;24kHz Mode
;

		mov	al,06h
		out	6Ah,al			;g[hύXs


		call	_GetCRTStates
		and	ax,3
		push	ax
		call	_SyncSet
		add	sp,2

exit_SetScanMode:
		pop	es
		pop	di
		pop	si
		pop	dx
		pop	ax
		pop	bp
		ret
_SetScanMode	endp

;###############################################################



	public	_CheckGDCbuffer		
	public	_VSyncOutWait		
	public	_VSyncInWait		
	public	_SetGDCClock		
	public	_16GraphicOn		
	public	_16GraphicOff		
	public	_256GraphicOn		
	public	_256GraphicOff		
	public	_SetHorizonalSize	
	public	_SetVerticalSize	
	public	_SyncSet		
	public	_GetCRTStates		
	public	_SetScanMode		


		_TEXT	ENDS














	end
