#pragma		check_pointer(off)
#pragma		check_stack(off)

#include	<stdio.h>
#include	<conio.h>

#include	"def.h"


/*********************************************************
**		fcbɂeʐݒ/[hݒ			**
**														**
**	GetCRTStates		ʎXe[^X擾			**
**	CheckGDCBuffer		fcb̃obt@Ԃ̎擾		**
**	VSyncOutWait		urԏI҂			**
**	VSyncInWait			ur҂				**
**	SyncSet				r̐ݒ					**
**	_16GraphicOn		PUFOtBbNn			**
**	_256GraphicOn		QTUFOtBbNn		**
**	_256GraphicOff		QTUFOtBbNn		**
**	SetVerticalSize		ʂ̏cς(̨)		**
**	SetGDCClock			fcbς			**
**	SetScanMode			XL[h̕ύX			**
**														**
**							Written By You				**
*********************************************************/



/* r̐ݒɎg\ */
struct SYNCPARAMETER
{
	INT16 CR;				/* \̕() */
	INT16 HS;				/* M̕() */
	INT16 HFP;				/* ʉE[̔\̕() */
	INT16 HBP;				/* ʍ[̔\̕() */
	INT16 VS;				/* M̕(C) */
	INT16 VBP;				/* ʏ̔\̕(C) */
	INT16 VFP;				/* ʉ̔\̕(C) */
	INT16 LF;				/* ʕ\̕(C) */
};



/*********************************************
**											**
**	ʂ̎Xe[^X擾				**
**											**
**	out:		.0	0: GDC ۯ2.5MHz		**
**				.1	0: HSync 24kHz			**
**				.2	1: g[h			**
**				.3	1: ̨ެL	**
**				.4	1: 256Mode			**
**											**
*********************************************/
INT16 GetCRTStates( void )
{
	INT16	ret=0;

	LPINT8	lpWorkArea=(LPINT8)0;		/* VXeʈQƗp*/

	lpWorkArea = (LPINT8)0x45c;
	ret |= (*lpWorkArea&0x40) >> 2;		/* 256Mode ݂邩 */

	lpWorkArea = (LPINT8)0x54d;
	ret |= (*lpWorkArea&0x04) >> 2;		/* GDC Clock */

	lpWorkArea--;
	ret |= (*lpWorkArea&0x20) >> 4;		/* Sync Mode */

	ret |= (*lpWorkArea&0x04) << 2;		/* Graphic Charger */

	if( ret&0x10 != 0 )					/* 256Mode݂ĂƂ256Mode */
	{									/* ǂ𒲂ׂ					 */
		outp( 0x09a0, 0x21 );
		ret |= (inp( 0x09a0 )&0x01) << 2;
	}

	return ret;
}



/*********************************************
**											**
**		fcbFIFȌԂ𒲂ׂ			**
**											**
**	In:	SelectGDC	0:Text					**
**					1:Graphic				**
**											**
**	Out:			0 :empty				**
**					1 :disable				**
**					2 :enable				**
**					-1:error				**
*********************************************/
INT16 CheckGDCBuffer( INT16 SelectGDC )
{
	INT16   GDCState;

	switch( SelectGDC )
	{
		case 0:		/* TEXT */
		{
			GDCState = inp( 0x60 );
			break;
		}
		case 1:		/* TEXT */
		{
			GDCState = inp( 0xa0 );
			break;
		}
		default:
		{
			return -1;
		}
	}/* end switch */

	if( (GDCState & 0x04) != 0 )	/* bit3 */
	{
		return 0;				/* Empty */
	}else
	if( (GDCState & 0x02) != 0 )	/* bit2 */
	{
		return 2;				/* Enable */
	}else
	{
		return 1;				/* Disable */
	}/* end if */

}



/*********************************************
**											**
**		urԏI҂				**
**											**
*********************************************/
void VSyncOutWait( void )
{
	while( inp( 0x60 )&0x20 != 0 ){}		/* GDCXe[^X擾 */
	return;
}



/*********************************************
**											**
**		ur҂					**
**											**
*********************************************/
void VSyncInWait( void )
{
	while( inp( 0x60 )&0x20 == 0 ){}		/* GDCXe[^X擾 */
	return;
}



/*********************************************
**											**
**		r̐ݒ						**
**											**
**	In:	spSyncParameter SYNCPARAMETER\ **
**		ւ̃|C^						**
**											**
**		Mode GDCۯ̎w	0:2.5MHz		**
**							1:5MHz			**
**											**
**  GDC̃NbN̈Ⴂɂĸ̨GDC **
** ^p[^ςĂ.			**
**  ̓IɂͤGDCۯ2.5MHẑƂ **
** ̃p[^̒lɂȂ܂.		**
**  ܂AXL[hɂăp[^**
** ςĂ̂͌܂łȂ.			**
*********************************************/
void SyncSet( struct SYNCPARAMETER* spSyncParameter )
{
	struct SYNCPARAMETER SyncParameter;
	UINT16	Mode;


	SyncParameter.CR  = 80;
	SyncParameter.HS  = 8;
	SyncParameter.VFP = 10;
	SyncParameter.VBP = 8;
	SyncParameter.VS  = 8;
	SyncParameter.HFP = 7;
	SyncParameter.HBP = 41;
	SyncParameter.LF  = 400;

	if( spSyncParameter == NULL )
	{
		spSyncParameter = &SyncParameter;
	}

 /*	Text GDC */
 
	while( CheckGDCBuffer( 0 ) != 0 ){}		/*obt@󂫑҂*/

/* SYNC Command */
	outp( 0x62, 0x0e );

/* parameter0 */
	outp( 0x60, 0x00 );

/* parameter1 */
	outp( 0x60, (INT8)(spSyncParameter->CR-2) );

/* parameter2 */
	outp( 0x60, (spSyncParameter->VS << 5)|(spSyncParameter->HS - 1 ) );

/* parameter3 */
	outp( 0x60, (spSyncParameter->VS >> 3)|((spSyncParameter->HFP-1) << 2) );

/* parameter4 */
	outp( 0x60, (spSyncParameter->HBP - 1) );

/* parameter5 */
	outp( 0x60, spSyncParameter->VFP );

/* parameter6 */
	outp( 0x60, spSyncParameter->LF );

/* parameter7 */
	outp( 0x60, (spSyncParameter->LF >> 8)|(spSyncParameter->VBP << 2) );

/* PITCH Command */
	outp( 0x62, 0x47 );

/* parameter */
	outp( 0x60, 0x50 );

/************************************************************/
 /*	Graphic GDC */

	while( CheckGDCBuffer( 1 ) != 0 ){}		/*obt@󂫑҂*/
	if( GetCRTStates()&0x01 == 0 )
	{
	/* SYNC Command */
		outp( 0xa2, 0x0e );	

	/* parameter0 */
		outp( 0xa0, 0x00 );

	/* parameter1 */
		outp( 0xa0, (INT8)((spSyncParameter->CR>>1)-2) );

	/* parameter2 */
		outp( 0xa0, (spSyncParameter->VS << 5)|((spSyncParameter->HS>>1) - 1 ) );

	/* parameter3 */
		outp( 0xa0, (spSyncParameter->VS >> 3)|(((spSyncParameter->HFP>>1)-1) << 2) );

	/* parameter4 */
		outp( 0xa0, ((spSyncParameter->HBP>>1) - 1) );

	/* parameter5 */
		outp( 0xa0, spSyncParameter->VFP );

	/* parameter6 */
		outp( 0xa0, spSyncParameter->LF );

	/* parameter7 */
		outp( 0xa0, (spSyncParameter->LF >> 8)|(spSyncParameter->VBP << 2) );

	/* PITCH Command */
		outp( 0xa2, 0x47 );

	/* parameter */
		outp( 0xa0, 0x28 );
	}else
	{
	/* SYNC Command */
		outp( 0xa2, 0x0e );	

	/* parameter0 */
		outp( 0xa0, 0x00 );

	/* parameter1 */
		outp( 0xa0, spSyncParameter->CR-2 );

	/* parameter2 */
		outp( 0xa0, (spSyncParameter->VS << 5)|(spSyncParameter->HS - 1 ) );

	/* parameter3 */
		outp( 0xa0, (spSyncParameter->VS >> 3)|((spSyncParameter->HFP-1) << 2) );

	/* parameter4 */
		outp( 0xa0, (spSyncParameter->HBP - 1) );

	/* parameter5 */
		outp( 0xa0, spSyncParameter->VFP );

	/* parameter6 */
		outp( 0xa0, spSyncParameter->LF );

	/* parameter7 */
		outp( 0xa0, (spSyncParameter->LF >> 8)|(spSyncParameter->VBP << 2) );

	/* PITCH Command */
		outp( 0xa2, 0x47 );

	/* parameter */
		outp( 0xa0, 0x50 );
	}


	/* ʂ\ */
	outp( 0x62, 0x0f );
	outp( 0xa2, 0x0f );	


	return;
}



/*********************************************
**											**
**		PUFOtBbNn				**
**											**
*********************************************/
void _16GraphicOn(void)
{
	outp( 0x68, 0x02 );		/*J[OtBbN[h*/
	outp( 0x68, 0x08 );		/*𑜓x*/
	outp( 0x6a, 0x41 );		/*vY}fBXvB*/
	outp( 0x6a, 0x01 );		/*16 COLOR MODE*/

	outp( 0xa2, 0x4b );		/*CݒR}h*/
	outp( 0xa0, 0x00 );		/*c{ {*/

	outp( 0xa4, 0x00 );		/*\y[W\*/
	outp( 0xa6, 0x00 );		/*\y[W`*/
	outp( 0xa2, 0x0D );		/*OtBbNn*/

	return;
}



/*********************************************
**											**
**		QTUFOtBbNn			**
**											**
*********************************************/
void _256GraphicOn(void)
{
	_16GraphicOn();

	outp( 0x6a, 0x07 );		/* g[hύX */
	outp( 0x6a, 0x21 );		/* gOtBbN[h */
	outp( 0x6a, 0x06 );		/* g[hύXs */

	return;
}



/*********************************************
**											**
**	QTUFOtBbNn				**
**											**
*********************************************/
void _256GraphicOff(void)
{

	outp( 0x6a, 0x07 );		/* g[hύX */
	outp( 0x6a, 0x20 );		/* gOtBbN[h */
	outp( 0x6a, 0x06 );		/* g[hύXs */

	return;
}



/*********************************************
**											**
**	ʂ̏cς(OtBbN)		**
**											**
**	In:		size VRAMPC̃C	**
**											**
*********************************************/
void SetVerticalSize( INT16 size )
{

	outp( 0xa2, 0x4b );			/* CݒR}h */
	outp( 0xa0, size-1 );

	return;
}



/*********************************************
**											**
**		fcb̃NbNς			**
**											**
**	In:	SelectGDC	0:2.5MHz				**
**					1:5MHz					**
**											**
**	GDCۯύX炻ɍl		**
**	VXeʗ̈(ܰر)ςĂ	**
**											**
*********************************************/
void SetGDCClock( INT16 Mode )
{
	LPINT8	lpWorkArea=(LPINT8)0x054d;		/*[NGAp*/
	INT8	Mask=0xfb;

	if( Mode&0x01 == 0 )
	{
		outp( 0x6a, 0x84);					/* 2.5MHz */
		*lpWorkArea &= Mask;
	}else
	{
		outp( 0x6a, 0x83);
		outp( 0x6a, 0x85);					/* 5MHz */
		*lpWorkArea |= (!Mask);
	}/* end if */

	return;
}



/*********************************************
**											**
**		XL[h̕ύX				**
**											**
**	In:		Mode.0	0:Normal Scan			**
**					1:High Scan				**
*********************************************/
void SetScanMode( INT16 Mode )
{
/* [NGȀςKv */
	LPINT8	lpWorkArea1=(LPINT8)0x045c;
	LPINT8	lpWorkArea2=(LPINT8)0x054c;

/*   XL[hmɕύXɂ́Ag[hύX */
/* ȂĂȂ΂Ȃ܂ 								*/
	outp( 0x6a, 0x07 );			/* g[hύX */

	if( Mode&0x01 == 0 )
	{							/* Normal */
		*lpWorkArea1 &= 0xdf;
		*lpWorkArea2 &= 0xdf;

		outp(0x09a8, 0);
	}else
	{							/* High */
		*lpWorkArea1 |= 0x20;
		*lpWorkArea2 |= 0x20;

		outp(0x09a8, 1);
	}

	outp( 0x6a, 0x06 );			/* g[hύXs */

	return;
}






















