/*		L[{[hahnrTvvO܂Ƃ							*/
/*										Written By T.Noda					*/

#include <stdio.h>
#include <dos.h>

/* L[{[hԂԂ\ */
typedef struct {
	unsigned char KeyCode;					/* L[R[h */
	unsigned char KeyData;					/* L[f[^ */
	unsigned char DataEffective;			/* ǂݍ݃f[^̗L */
											/* 0 :ǂݏof[^͖ */
											/* 1 :ǂݏof[^͗L */
	unsigned char ExtraKeyData;				/* L[̏ԃ}bv */
} KeyInfo;

/* ---------------------- vg^Cv錾 ----------------------------------*/
/* L[{[hC^[tFCX̏ */
void KeyBiosInit(void);
/* L[f[^ǂ݂i|C^̈ړj*/
void KeyBufferRead(KeyInfo *Keyboard_info);
/* L[obt@ǂ݂i|C^̈ړȂj*/
void KeyBufferSense(KeyInfo *Keyboard_info);
/* L[̓ǂ݂ */
void ExtraKeySense(KeyInfo *Keyboard_info);
/* L[}gbNX̓ǂ݂ǂ݂ */
unsigned char KeyMatrixSense(unsigned char KeyCodeGroupNumber);
/* L[obt@ǂ݂i|C^̈ړj*/
void KeyBufferSense_MP(KeyInfo *Keyboard_info);

/* L[{[hC^[tFCX̏	*/
/*		֐:	void KeyBiosInit(void)										*/
/*		@\:	L[{[hC^[tFCX̏܂BahnrgpO*/
/*				Ȃ炸sĂ									*/
/*		:	Ȃ														*/
/*		o:	Ȃ														*/
void KeyBiosInit(void)
{
	union	REGS	inregs,outregs;				/* WX^ϐ̏ */

	inregs.h.ah = 0x03;								/* @\R[h̑ */
	int86(0x18,&inregs,&outregs);				/* \tgEFA荞 */

}
/* L[obt@ǂ݂i|C^̈ړj*/
/*		֐:	void KeyBufferRead(KeyInfo *Keyboard_info)					*/
/*		@\:	L[obt@ǂ݂s܂BǂݏIƃ|C^̈ړ*/
/*				s܂̂ŁAobt@̓e͕ω܂B				*/
/*				܂AL[͂Ƃ͓͑҂ɂȂ܂̂ŁAӂKv*/
/*				łB														*/
/*		:	KeyInfo^̍\̂̃|C^									*/
/*		o:	KeyInfo^̍\̂ɕԂ										*/
/*					KeyCode				L[R[h 							*/
/*					KeyData				L[f[^ 							*/
/*					DataEffective		ǂݍ݃f[^̗L				*/
/*							̊֐ł͏ 1 Ԃ 						*/
/*					ExtraKeyData										*/
void KeyBufferRead(KeyInfo *Keyboard_info)
{
	union	REGS	inregs,outregs;				/* WX^ϐ̏ */

	inregs.h.ah = 0x00;							/* @\R[h̑ */
	int86(0x18,&inregs,&outregs);				/* \tgEFA荞 */

	Keyboard_info -> KeyCode = outregs.h.ah;	/* L[R[h̊i[ */
	Keyboard_info -> KeyData = outregs.h.al;	/* L[f[^̊i[ */
	Keyboard_info -> DataEffective = 0x01;		/* f[^͏ɗL */

}
/* L[obt@ǂ݂i|C^̈ړȂj */
/*		֐:	void KeyBufferSense(KeyInfo *Keyboard_info)					*/
/*		@\:	L[obt@ǂ݂s܂BǂݏIĂ|C^̈ړ*/
/*				sȂ̂ŁAobt@̓e͕ω܂B				*/
/*				܂AL[͂Ƃ̓f[^̖ԂAɖ߂܂*/
/*				̂ŁA͑҂ɂȂ܂B								*/
/*		:	KeyInfo^̍\̂̃|C^									*/
/*		o:	KeyInfo^̍\̂ɕԂ										*/
/*					KeyCode				L[R[h 							*/
/*					KeyData				L[f[^ 							*/
/*					DataEffective		ǂݍ݃f[^̗L				*/
/*											0 :ǂݏof[^͖		*/
/*											1 :ǂݏof[^͗L		*/
/*					ExtraKeyData										*/
void KeyBufferSense(KeyInfo *Keyboard_info)
{
	union	REGS	inregs,outregs;				/* WX^ϐ̏ */

	inregs.h.ah = 0x01;							/* @\R[h̑ */
	int86(0x18,&inregs,&outregs);				/* \tgEFA荞 */

	Keyboard_info -> KeyCode = outregs.h.ah;		/* L[R[h̊i[ */
	Keyboard_info -> KeyData = outregs.h.al;		/* L[f[^̊i[ */
	Keyboard_info -> DataEffective = outregs.h.bh;	/* f[^L̊i[ */

}
/* L[̓ǂ݂ */
/*		֐:void ExtraKeySense(KeyInfo *Keyboard_info)					*/
/*		@\:	L[̓ǂ݂s܂B								*/
/*				Ԃ̂̓rbg}bvȂ̂ŎŃ}XNƃVtgs	*/
/*				肵ĂB											*/
/*		:	KeyInfo^̍\̂̃|C^									*/
/*		o:	KeyInfo^̍\̂ɕԂ										*/
/*					KeyCode					 							*/
/*					KeyData				 								*/
/*					DataEffective										*/
/*					ExtraKeyData		L[̃rbg}bv				*/
/*								 D7 D6 D5 D4 D3 D2 D1 D0 					*/
/*								-------------------------					*/
/*								| /| /| /|  |  |  |  |  |					*/
/*								-------------------------					*/
/*										      					*/
/*										       SHIFT				*/
/*										     CAPS						*/
/*										    							*/
/*										   GRPH							*/
/*										  CTRL								*/
/*																			*/
/*										erbg 0 : ĂȂ		*/
/*										erbg 1 : Ă			*/
void ExtraKeySense(KeyInfo *Keyboard_info)
{
	union	REGS	inregs,outregs;				/* WX^ϐ̏ */

	inregs.h.ah = 0x02;							/* @\R[h̑ */
	int86(0x18,&inregs,&outregs);				/* \tgEFA荞 */

	Keyboard_info -> ExtraKeyData = outregs.h.al;/* L[rbg}bv̊i[ */

}

/* L[}gbNX̓ǂ݂ǂ݂ */
/*	֐:	unsigned char KeyMatrixSense(unsigned char KeyCodeGroupNumber)	*/
/*		@\:	L[}gbNX̓ǂ݂s܂B						*/
/*				L[}gbNX̃O[vԍ͕\ŊmFĂ		*/
/*				Ԃ̂̓rbg}bvȂ̂ŎŃ}XNƃVtgs	*/
/*				肵ĂB											*/
/*		:	(unsigned char)f[^O[vԍ							*/
/*		o:	unsigned char^̕ϐɕԂ									*/
/*										erbg 0 : ĂȂ		*/
/*										erbg 1 : Ă			*/
unsigned char KeyMatrixSense(unsigned char KeyCodeGroupNumber)
{
	union	REGS	inregs,outregs;				/* WX^ϐ̏ */

	inregs.h.ah = 0x04;							/* @\R[h̑ */
	inregs.h.al = KeyCodeGroupNumber;			/* L[R[hO[vio[ */
	int86(0x18,&inregs,&outregs);				/* \tgEFA荞 */

	return outregs.h.ah;						/* L[R[hO[v̏ */

}

/* L[obt@ǂ݂i|C^̈ړj */
/*		֐:	void KeyBufferSense_MP(KeyInfo *Keyboard_info)				*/
/*		@\:	L[obt@̐擪Ɋi[ĂL[R[hf[^		*/
/*				݂AOPgƂ͈قȂobt@|C^ړ܂		*/
/*				B															*/
/*				@̂ƂAȂɂ͂Ȃ΁Aagɂ̏		*/
/*				L[͂ĕԂ̂AĕԂĂ̂o		*/
/*				܂B̂߂̋@\͓͑҂ɂȂ炸AɎg		*/
/*				₷@\łB											*/
/*		:	KeyInfo^̍\̂̃|C^									*/
/*		o:	KeyInfo^̍\̂ɕԂ										*/
/*					KeyCode				L[R[h 							*/
/*					KeyData				L[f[^ 							*/
/*					DataEffective		ǂݍ݃f[^̗L				*/
/*											0 :ǂݏof[^͖		*/
/*											1 :ǂݏof[^͗L		*/
/*					ExtraKeyData										*/
void KeyBufferSense_MP(KeyInfo *Keyboard_info)
{
	union	REGS	inregs,outregs;				/* WX^ϐ̏ */

	inregs.h.ah = 0x05;							/* @\R[h̑ */
	int86(0x18,&inregs,&outregs);				/* \tgEFA荞 */

	Keyboard_info -> KeyCode = outregs.h.ah;		/* L[R[h̊i[ */
	Keyboard_info -> KeyData = outregs.h.al;		/* L[f[^̊i[ */
	Keyboard_info -> DataEffective = outregs.h.bh;	/* f[^L̊i[ */

}

