/* Emacs style mode select   -*- C++ -*- */
/*----------------------------------------------------------------------------- */
/* */
/* $Id:$ */
/* */
/* Copyright (C) 1993-1996 by id Software, Inc. */
/* */
/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */
/* */
/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */
/* */
/* $Log:$ */
/* */
/* DESCRIPTION: */
/*	System interface for sound. */
/* */
/*----------------------------------------------------------------------------- */

static const char
        rcsid[] = "$Id: i_unix.c,v 1.5 1997/02/03 22:45:10 b1 Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <math.h>
/*
#include <sys/time.h>
#include <sys/types.h>
*/
#ifndef LINUX
/*#include <sys/filio.h> */
#endif

#include <fcntl.h>
/*#include <unistd.h>*/


/* Linux voxware output. */
/*#include <linux/soundcard.h> */

/* Timer stuff. Experimental. */
/*#include <time.h>
#include <signal.h>
*/
#include "z_zone.h"

#include "i_system.h"
#include "i_sound.h"
#include "m_argv.h"
#include "m_misc.h"
#include "w_wad.h"

#include "doomdef.h"

#define SAMPLECOUNT 512
int lengths[NUMSFX];

/* */
/* This function loads the sound data from the WAD lump, */
/*  for single sound. */
/* */
void*
getsfx
        ( char*         sfxname,
        int*          len )
{
	unsigned char*      sfx;
	unsigned char*      paddedsfx;
	int i;
	int size;
	int paddedsize;
	char name[20];
	int sfxlump;


	/* Get the sound data from the WAD, allocate lump */
	/*  in zone memory. */
	sprintf(name, "ds%s", sfxname);

	/* Now, there is a severe problem with the */
	/*  sound handling, in it is not (yet/anymore) */
	/*  gamemode aware. That means, sounds from */
	/*  DOOM II will be requested even with DOOM */
	/*  shareware. */
	/* The sound list is wired into sounds.c, */
	/*  which sets the external variable. */
	/* I do not do runtime patches to that */
	/*  variable. Instead, we will use a */
	/*  default sound for replacement. */
	if ( W_CheckNumForName(name) == -1 )
		sfxlump = W_GetNumForName("dspistol");
	else
		sfxlump = W_GetNumForName(name);

	size = W_LumpLength( sfxlump );

	/* Debug. */
	/* fprintf( stderr, "." ); */
	/*fprintf( stderr, " -loading  %s (lump %d, %d bytes)\n", */
	/*	     sfxname, sfxlump, size ); */
	/*fflush( stderr ); */

	sfx = (unsigned char*)W_CacheLumpNum( sfxlump, PU_STATIC );

	/* Pads the sound effect out to the mixing buffer size. */
	/* The original realloc would interfere with zone memory. */
	paddedsize = ((size-8 + (SAMPLECOUNT-1)) / SAMPLECOUNT) * SAMPLECOUNT;

	/* Allocate from zone memory. */
	paddedsfx = (unsigned char*)Z_Malloc( paddedsize+8, PU_STATIC, 0 );
	/* ddt: (unsigned char *) realloc(sfx, paddedsize+8); */
	/* This should interfere with zone memory handling, */
	/*  which does not kick in in the soundserver. */

	/* Now copy and pad. */
	memcpy(  paddedsfx, sfx, size );
	for (i=size; i<paddedsize+8; i++)
		paddedsfx[i] = 128;

	/* Remove the cached lump. */
	Z_Free( sfx );

	/* Preserve padded length. */
	*len = paddedsize;

	/* Return allocated padded data. */
	return (void *) (paddedsfx + 8);
}

void I_InitSound()
{
	int i;

	fprintf( stderr, "I_InitSound: ");
	fprintf(stderr, " configured audio device (well, not really...)\n" );
	for (i=1; i<NUMSFX; i++)
	{
		/* Alias? Example is the chaingun sound linked to pistol. */
		if (!S_sfx[i].link)
		{
			/* Load data from WAD file. */
			S_sfx[i].data = getsfx( S_sfx[i].name, &lengths[i] );
		}
		else
		{
			/* Previously loaded already? */
			S_sfx[i].data = S_sfx[i].link->data;
			lengths[i] = lengths[(S_sfx[i].link - S_sfx)/sizeof(sfxinfo_t)];
		}
	}

	fprintf( stderr, " pre-cached all sound data\n");

	/* Finished initialization. */
	fprintf(stderr, "I_InitSound: sound module ready\n");

}
void I_UpdateSound(void) {
}
void I_SubmitSound(void) {
}
void I_ShutdownSound(void) {
}
void I_SetChannels() {
}
int I_GetSfxLumpNum (sfxinfo_t* sfx )
{
	char namebuf[9];
	sprintf(namebuf,"ds%s",sfx->name);
	return W_GetNumForName(namebuf);
}

int
I_StartSound
        ( int id,
        int vol,
        int sep,
        int pitch,
        int priority ) {
	return id;
}
void I_StopSound(int handle) {
}
int I_SoundIsPlaying(int handle) {
	return gametic<handle;
}
void
I_UpdateSoundParams
        ( int handle,
        int vol,
        int sep,
        int pitch ) {
}
void I_InitMusic(void) {
}
void I_ShutdownMusic(void) {
}
void I_SetMusicVolume(int volume) {
}
void I_PauseSong(int handle) {
}
void I_ResumeSong(int handle) {
}
int I_RegisterSong(void *data) {
	return 1;
}
void
I_PlaySong
        ( int handle,
        int looping ) {
}
void I_StopSong(int handle) {
}
void I_UnRegisterSong(int handle) {
}


