/* Emacs style mode select   -*- C++ -*- */
/*----------------------------------------------------------------------------- */
/* */
/* $Id:$ */
/* */
/* Copyright (C) 1993-1996 by id Software, Inc. */
/* */
/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */
/* */
/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */
/* */
/* $Log:$ */
/* */
/* DESCRIPTION: */
/*	Endianess handling, swapping 16bit and 32bit. */
/* */
/*----------------------------------------------------------------------------- */

static const char
        rcsid[] = "$Id: m_bbox.c,v 1.1 1997/02/03 22:45:10 b1 Exp $";


#ifdef __GNUG__
#pragma implementation "m_swap.h"
#endif
#include "m_swap.h"

#define __BIG_ENDIAN__
/* Not needed with big endian. */
#ifdef mc68000

/* Swap 16bit, that is, MSB and LSB byte. */
unsigned short SwapSHORT(unsigned short x)
{
	/* No masking with 0xFF should be necessary. */
	return (x>>8) | (x<<8);
}

/* Swapping 32bit. */
unsigned long SwapLONG( unsigned long x)
{
	return
	        (x>>24)
	        | ((x>>8) & 0xff00)
	        | ((x<<8) & 0xff0000)
	        | (x<<24);
}


#endif


