/* HS_wlib.h	͂ĂȂƂĂ̂낤o[W	*/
/*	1991 }V SPS-NET:SPS0783 COR.			*/
/*	v0.00: 1991 9/18					*/

#include	<parts.h>

typedef struct {
	int	x1, y1, x2, y2;
} ClipPart;

typedef	struct	{
	int	type;
	int	check;
	int	client;
	void	*clientp;
	int	ownerid;
	int	attr;
	int	eventattr;
	ClipClass curclip;
	int	hx, hy;
	void	*parent;
	void	*last, *next;
	void	*childtop, *childbottom;
	int	id;
	int	(*event)();
} WindowPart;

typedef struct  {
	ClipPart	clip;
	WindowPart	window;
} WindowClass;

typedef struct	{
	int	id,
		(*event)();
} SimplePart;

typedef struct	{
	int	id,
		(*event)();
	int	button;
	char	label[31+1];
	ClipClass	close,
			push,
			icon,
			resize,
			zoom;
} TitlePart;

typedef struct	{
	int	id,
		(*event)();
	int	dir;
	int	maxh,
		maxv;
	SliderClass	xslider,
			yslider;
	int	xstep,
		ystep;
} ScrollPart;

typedef struct  {
	ClipPart	clip;
	WindowPart	window;
	SimplePart	simple;
} SimpleClass;

typedef struct  {
	ClipPart	clip;
	WindowPart	window;
	SimplePart	simple;
	TitlePart	title;
} TitleClass;

typedef struct  {
	ClipPart	clip;
	WindowPart	window;
	ScrollPart	scroll;
} ScrollClass;

#define	SimpleType	1
#define	TitleType	2
#define	ScrollType	3

typedef WindowClass	*WP;

#define	HS_WindowGetEventAttr(wp)	(((WP)wp)->window.eventattr)
#define	HS_WindowGetAttr(wp)		(((WP)wp)->window.attr)

#define	HS_WindowSetHome(wp,hx,hy)	(((WP)wp)->window.hx=(hx),\
					 ((WP)wp)->window.hy=(hy))
#define HS_WindowGetEventAttr(wp)	(((WP)wp)->window.eventattr)
#define HS_WindowGetClientData(wp)	(((WP)wp)->window.client)
#define HS_WindowGetClientPointer(wp)	(((WP)wp)->window.clientp)
#define HS_WindowGetPosition(wp,xp,yp)	(*(xp)=((WP)wp)->clip.x1,\
					 *(yp)=((WP)wp)->clip.y1)
#define HS_WindowGetClip(wp)		(((WP)wp)->clip)
#define HS_WindowGetPositionX(wp)	(((WP)wp)->clip.x1)
#define HS_WindowGetPositionY(wp)	(((WP)wp)->clip.y1)
#define HS_WindowGetSizeX(wp)		(((WP)wp)->clip.x2-((WP)wp)->clip.x1+1)
#define HS_WindowGetSizeY(wp)		(((WP)wp)->clip.y2-((WP)wp)->clip.y1+1)
#define HS_WindowGetScreenPositionX(wp)	(((WP)wp)->clip.x1+\
					((WP)wp)->window.curclip.clip.x1)
#define HS_WindowGetScreenPositionY(wp)	(((WP)wp)->clip.y1+\
					((WP)wp)->window.curclip.clip.y1)
#define	HS_WindowGetViewPosition(wp,xp,yp) (*(xp)=((WP)wp)->window.curclip.x1,\
					    *(yp)=((WP)wp)->window.curclip.y1)
#define	HS_WindowGetViewPositionX(wp)	(((WP)wp)->window.curclip.x1)
#define	HS_WindowGetViewPositionY(wp)	(((WP)wp)->window.curclip.y1)
#define HS_WindowGetViewSize(wp,hp,vp)	(*(hp)=((WP)wp)->window.curclip.x2-\
						((WP)wp)->window.curclip.x1+1,\
					 *(vp)=((WP)wp)->window.curclip.y2-\
						((WP)wp)->window.curclip.y1+1)
#define HS_WindowGetViewSizeX(wp)	(((WP)wp)->window.curclip.x2-	\
						((WP)wp)->window.curclip.x1+1)
#define HS_WindowGetViewSizeY(wp)	(((WP)wp)->window.curclip.y2-	\
						((WP)wp)->window.curclip.y1+1)
#define	HS_WindowGetHome(wp,xp,yp)	(*(xp)=((WP)wp)->window.hx,	\
					 *(yp)=((WP)wp)->window.hy)
#define	HS_WindowGetHomeX(wp)		(((WP)wp)->window.hx)
#define	HS_WindowGetHomeY(wp)		(((WP)wp)->window.hy)
#define	HS_WindowGetParent(wp)		(((WP)wp)->window.parent)
#define	HS_WindowGetClipX1(wp)		(((WP)wp)->window.curclip.x1)
#define	HS_WindowGetClipY1(wp)		(((WP)wp)->window.curclip.y1)
#define	HS_WindowGetClipX2(wp)		(((WP)wp)->window.curclip.x2)
#define	HS_WindowGetClipY2(wp)		(((WP)wp)->window.curclip.y2)

#define	HS_WindowGetParent(wp)		(((WP)wp)->window.parent)
#define	HS_WindowGetLast(wp)		(((WP)wp)->window.last)
#define	HS_WindowGetNext(wp)		(((WP)wp)->window.next)
#define	HS_WindowGetChildTop(wp)	(((WP)wp)->window.childtop)
#define	HS_WindowGetChildBottom(wp)	(((WP)wp)->window.childbottom)
#define	HS_WindowGetExecAddress(wp)	(((WP)wp)->window.event)
#define	HS_WindowGetExec(wp)		(\
		(((WP)wp)->window.type)==TitleType ?\
			(((TitleClass*)wp)->title.event):\
			(\
				(((WP)wp)->window.type) ?\
					((SimpleClass*)wp)->simple.event:\
					(((WP)wp)->window.event)\
			)\
		)

