/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id:
 */

#ifndef __audio_h__
#define __audio_h__

#ifndef __cdecl_h__
#include <cdecl.h>
#endif

#ifndef __sys_iocs_h__
#include <sys/iocs.h>
#endif

#ifndef _NASI
#define _NASI 0x4e415349	/* 'NASI' */
#endif

_EXTERN (int_ a_stat (void_));
_EXTERN (void a_cont (void_));
_EXTERN (void a_end (void_));
_EXTERN (void a_play (const void *, int_, int_, int_, int_));
_EXTERN (void a_rec (void *, int_, int_, int_));
_EXTERN (void a_stop (void_));

static __inline int_ _a_stat (void_)
{
    /* ԂZX */
    return _iocs_adpcmsns ();
}

static __inline void _a_cont (void_)
{
    /* ĂȂ... */
    if (_iocs_adpcmsns () != 0) {

	/* ĊJ */
	_iocs_adpcmmod (2);
    }
}

static __inline void _a_end (void_)
{
    /* I */
    _iocs_adpcmmod (0);
}

static __inline void
_a_play (const void *buffer, int_ size, int_ freq, int_ mode, int_ length)
{
    /* LoCgݒ肳Ă΁AꂪD */
    if (length != _NASI && length < size)
	size = length;

    /* l`FbN */
    if (size <= 0 || freq < 0 || freq > 4 || mode < 0 || mode > 3)
	return;

    /* ۂɏo͂ */
    _iocs_adpcmout (buffer, (freq << 8) | mode, size);
}

static __inline void _a_rec (void *buffer, int_ size, int_ freq, int_ length)
{
    /* LoCgw肳Ă΁AꂪD */
    if (length != _NASI && length < size)
	size = length;

    /* l`FbN */
    if (size <= 0 || freq < 0 || freq > 4)
	return;

    /* ۂɓ͂ */
    _iocs_adpcminp (buffer, (freq << 8) | 3, size);

    /* ͂I܂őҋ@ */
    while (_iocs_adpcmsns () != 0)
	;
}

static __inline void _a_stop (void_)
{
    /* f */
    _iocs_adpcmmod (1);
}

#define a_stat	_a_stat
#define a_cont	_a_cont
#define a_end	_a_end
#define a_play	_a_play
#define a_rec	_a_rec
#define a_stop	_a_stop

#endif
