/*
	Ko-Window IWiCu

	Copyright 1991,1992,1993,1994,1995 }V COR.
	MgButton  MenuButton ǉ@1994 b`a
*/

#ifndef	__CORLIB__
#define	__CORLIB__

#ifndef	NULL
#  include	<stdio.h>
#endif
#ifndef	__WLIB__
#  include	<wlib.h>
#endif
#ifndef	__PARTS__
#  include	<parts.h>
#endif
#ifndef	__UGRAPHIC__
#  include	<UserGraphic.h>
#endif

extern int	SheetGetSize( FILE*, Sheet* );
extern void	SheetLoad( FILE*, Sheet* );
extern void	SheetSave( FILE*, Sheet*, int, char* );
extern void	SheetCut( Sheet*, Sheet*, int, int );

extern void	UserSendOperation( WindowID, EventInfo*, int, void* );
extern void	SendData( WindowID, EventInfo*, int, void* );
extern int	UserSendExec( char*, char*, char* );
extern int	UserSendPaste( WindowID, EventInfo* );

extern void	IconEnt( WindowID, char*, int, int );

extern char	*TitleGetAddress( WindowID );
extern char	*TitleSetLabel( WindowID, char* );
extern char	*GetTitleAddress( WindowID );
extern char	*SetTitleLabel( WindowID, char* );

extern char	*PathGetFullName( char* );
extern char	*PathGetFullName2( char*, char* );
extern char	*fullname( char* );
extern void	PathGetExecDir( char* );
extern void	StringGetEsc( char*, char* );

extern void	ClipSetOperation( WindowID, EventInfo*, char**,int,int,int,int,int,int );
extern void	ClipSetSimpleOperation(WindowID,EventInfo*,char**,int,int,int);
extern int	ClipGetKeyboard( WindowID, EventInfo* );
extern int	ClipGetKeyboardAll( WindowID, EventInfo* );
extern void	SetClipBoard( WindowID, EventInfo*, char**, int, int, int );

extern unsigned	IntervalTime( void );
extern int	IntervalWait( unsigned, unsigned* );

extern int	PidSearch( char*, int );
extern int	PidSendEvent( char*, EventInfo*, int );

/* Console Lib */
struct WindowConsoleType  {
        unsigned short  flag;
	WindowID        wp;
	void            (*exec)();
};

extern void	*ConsoleOpen( void );
extern void	ConsolePrint( char* );
extern void	ConsoleChar( int );
extern void	ConsolePrintf( char*, ... );

/* DefGraphic Lib */
typedef	struct {
	unsigned short	mode,
			sleep;
	int		(*f_sleep)();
	void		*palet;
} DefGraphic;

extern void	DefGraphicInit( DefGraphic*, int, int (*)(), unsigned short* );
extern int	DefGraphicSleep( WindowID, EventInfo* );
extern int	DefGraphicRedraw( DefGraphic*, WindowID, EventInfo* );
extern int	DefGraphicEnt( DefGraphic*, WindowID, EventInfo* );
extern void	DefGraphicPalet( DefGraphic* );

#define	DefGraphicCheck( gra )	((gra)->sleep)
#define	DefGraphicMode( gra )	((gra)->mode)

extern unsigned short	DefGraphicPal16[];
extern unsigned short	DefGraphicPal256[];

/* MgLIB */
extern WindowID	MgWindowDefaultOpen( int, int, int, int, char*, int,int(*)() );
extern WindowID	MgWindowDefaultOpenArgs( int, int, int, int, char*, int,
						char**, int, int(*)() );
extern void	MgWindowSetClientData( WindowID, int, void* );
extern int	MgWindowGetClientData( WindowID );
extern void	*MgWindowSetClientPointer( WindowID );

#define	MgTitleItem	(31)
#define	MgSwitchHV	128
#define	MgGraphicUse	(12<<8)
#define	MgGraphic16	(4<<8)
#define	MgGraphic256	(8<<8)
#define	MgGraphic65536	(12<<8)

/* MgButton Lib */
typedef struct {
	int	x1, y1, x2, y2;
	int	nbuf, type, ret;
} MgButton;

extern void	MgButtonInit( MgButton* );
extern int	MgButtonSet( MgButton*, int, int, int, int, int );
extern int	MgButtonSetSymbol( MgButton*, int, int, int, int, char*,
								int, int );
extern int	MgButtonSetSheet( MgButton*, int, int, int, Sheet*, Sheet* );
extern int	MgButtonSetToggle( MgButton*, int, int, int, int, int, int* );
extern int	MgButtonSetTouch( MgButton*, int, int, int, int, int );
extern int	MgButtonSetMenu( MgButton*, int, int, int, int, int,
							int(*)(), int );
extern int	MgButtonSetDraw( MgButton*, DrawBuf* );
extern int	MgButtonOperation( WindowID, EventInfo*, MgButton* );
extern void	MgButtonClear( MgButton* );

/* MgInput Lib */
typedef struct {
	int		x, y, h, v;
	WindowID	wp, pwp;
	InputClass	input;
	char		buf[128];	/* MGINPUTMAX */
} MgInput;

extern void	MgInputRedraw( MgInput* );
extern void	MgInputClear( MgInput* );
extern void	MgInputSetCursorVisible( MgInput*, int );
extern int	MgInputSendEvent( MgInput*, EventInfo* );
extern void	MgInputKey( MgInput*, int, int );
extern WindowID	MgInputScrollOpen( MgInput*, int, int, WindowID,int,int,int);
extern WindowID	MgInputSimpleOpen( MgInput*, int, int, WindowID,int,int,int);
#define		MgInputGetPointer(mp)	((mp)->buf)


extern char	*KoWindowGetEnv( char* );
#define	getenv	KoWindowGetEnv
extern int	KoWindowVersionCnv( char* );
extern int	KoWindowVersionCheck( char* );
extern int	KoWindowHeapAlloc( void );
extern void	KoWindowSetHeapPtr( void*, int );
extern int	KoWindowXfStat( void );

extern void	MouseSetPattern( int, Sheet*, int, int );
extern void	MouseSetDefPat_TUKAMI( void );
extern void	MouseSetNormalPat( void );

extern int	GposSetOffset( int, int, int, int );
extern void	GposGraphicRedraw( WindowID );
extern int	GposSetAndMove( WindowID, EventInfo* );
extern int	GposInit( WindowID );
extern int	GposSetClear( WindowID, DrawBuf*, int, int );
extern int	GposSetFill( WindowID, DrawBuf*, int, int, int, int, int,int);

extern int	DialogYesNo( char*, EventInfo* );
extern WindowID	DialogMessageOpen( char*, int );

#endif

