/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id: ctype.h,v 1.6 1994/05/02 16:34:01 mura Exp $
 */

#ifndef __ctype_h__
#define __ctype_h__

#ifndef __cdecl_h__
#include <cdecl.h>
#endif

#define _ISUPPER 0x001
#define _ISLOWER 0x002
#define _ISDIGIT 0x004
#define _ISSPACE 0x008
#define _ISPUNCT 0x010
#define _ISCNTRL 0x020
#define _ISXDIGT 0x040
#define _ISBLANK 0x080

#define _ISALNUM (_ISUPPER | _ISLOWER | _ISDIGIT)
#define _ISALPHA (_ISUPPER | _ISLOWER)
#define _ISGRAPH (_ISUPPER | _ISLOWER | _ISDIGIT | _ISPUNCT)
#define _ISPRINT (_ISUPPER | _ISLOWER | _ISDIGIT | _ISPUNCT | _ISBLANK)

#define _tolower(c) (((int_) (c)) |  0x20)
#define _toupper(c) (((int_) (c)) & ~0x20)

extern __common const unsigned char *_ctype_lower;
extern __common const unsigned char *_ctype_upper;
extern __common const unsigned char *_ctype;

_EXTERN (int_ __const isascii (int_));
_EXTERN (int_ __const isiso (int_));
_EXTERN (int_ __const isodigit (int_));
_EXTERN (int_ __const toascii (int_));
_EXTERN (int_ __const toiso (int_));
_EXTERN (int_ isalnum (int_));
_EXTERN (int_ isalpha (int_));
_EXTERN (int_ isblank (int_));
_EXTERN (int_ iscntrl (int_));
_EXTERN (int_ iscsym (int_));
_EXTERN (int_ iscsymf (int_));
_EXTERN (int_ isdigit (int_));
_EXTERN (int_ isgraph (int_));
_EXTERN (int_ islower (int_));
_EXTERN (int_ isprint (int_));
_EXTERN (int_ ispunct (int_));
_EXTERN (int_ isspace (int_));
_EXTERN (int_ isupper (int_));
_EXTERN (int_ isxdigit (int_));
_EXTERN (int_ tolower (int_));
_EXTERN (int_ toupper (int_));

#ifndef __NO_CTYPE_INLINE__

#define isalnum(c)  ((int_) (_ctype[(c)] & _ISALNUM))
#define isalpha(c)  ((int_) (_ctype[(c)] & _ISALPHA))
#define iscntrl(c)  ((int_) (_ctype[(c)] & _ISCNTRL))
#define isdigit(c)  ((int_) (_ctype[(c)] & _ISDIGIT))
#define isgraph(c)  ((int_) (_ctype[(c)] & _ISGRAPH))
#define islower(c)  ((int_) (_ctype[(c)] & _ISLOWER))
#define isprint(c)  ((int_) (_ctype[(c)] & _ISPRINT))
#define ispunct(c)  ((int_) (_ctype[(c)] & _ISPUNCT))
#define isspace(c)  ((int_) (_ctype[(c)] & _ISSPACE))
#define isupper(c)  ((int_) (_ctype[(c)] & _ISUPPER))
#define isxdigit(c) ((int_) (_ctype[(c)] & _ISXDIGT))

#define isascii(c)  ((int_) ((c) & ~0x7f) == 0)
#define isiso(c)    ((int_) ((c) & ~0xff) == 0)

#define iscsym(c)   ((int_) ((_ctype[(c)] & _ISALNUM) || (c) == '_'))
#define iscsymf(c)  ((int_) ((_ctype[(c)] & _ISALPHA) || (c) == '_'))
#define isblank(c)  ((int_) (_ctype[(c)] & _ISBLANK))
#define isodigit(c) ((int_) ('0' <= (c) && (c) <= '7'))

#define toascii(c)  ((int_) ((c) & 0x7f))
#define toiso(c)    ((int_) ((c) & 0xff))
#define tolower(c)  ((c) < 0 ? (int_) (c) : (int_) _ctype_lower[(c)])
#define toupper(c)  ((c) < 0 ? (int_) (c) : (int_) _ctype_upper[(c)])

#ifndef __NO_LOCALE_INLINE__

#undef isalpha
#undef isblank
#undef iscntrl
#undef isdigit
#undef isgraph
#undef isprint
#undef isspace
#undef islower
#undef isupper
#undef tolower
#undef toupper

#define isalpha(c)  ((int_) ((unsigned char) (_tolower (c) - 'a') <= ('z' - 'a')))
#define isblank(c)  ((int_) ((unsigned char) (c) == ' ' || (unsigned char) (c) == '\t'))
#define iscntrl(c)  ((int_) ((unsigned char) (c) <= 0x1f || (unsigned char) (c) == 0x7f))
#define isdigit(c)  ((int_) ((unsigned char) ((c) - '0') <= ('9' - '0')))
#define isgraph(c)  ((int_) ((unsigned char) ((c) - 0x21) <= (0x7e - 0x21)))
#define isprint(c)  ((int_) ((unsigned char) ((c) - 0x20) <= (0x7e - 0x20)))
#define isspace(c)  ((int_) ((unsigned char) (c) == ' ' || (unsigned char) ((c) - '\t') <= ('\r' - '\t')))
#define islower(c)  ((int_) ((unsigned char) ((c) - 'a') <= ('z' - 'a')))
#define isupper(c)  ((int_) ((unsigned char) ((c) - 'A') <= ('Z' - 'A')))

#define tolower(c)  (isupper(c) ? _tolower(c) : (int_) (c))
#define toupper(c)  (islower(c) ? _toupper(c) : (int_) (c))

#endif

#endif

#endif
