/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id: float.h,v 1.1.1.1 1993/04/18 16:13:03 mura Exp $
 */

#ifndef __float_h__
#define __float_h__

#define FLT_RADIX	 2
#define FLT_ROUNDS	 1

#define FLT_MANT_DIG	 24
#define FLT_DIG		 6
#define FLT_EPSILON	 1.19209290e-7F
#define FLT_MIN_EXP	-125
#define FLT_MAX_EXP	+128
#define FLT_MIN_10_EXP	-37
#define FLT_MAX_10_EXP	+38
#define FLT_MIN		 1.17549435e-38F
#define FLT_MAX		 3.40282347e+38F

#define DBL_MANT_DIG	 53
#define DBL_DIG		 15
#define DBL_EPSILON	 2.2204460492503131e-16
#define DBL_MIN_EXP	-1021
#define DBL_MAX_EXP	+1024
#define DBL_MIN_10_EXP	-307
#define DBL_MAX_10_EXP	+308
#define DBL_MIN		 2.2250738585072014e-308
#define DBL_MAX		 1.7976931348623157e+308

#if defined(__MARIKO_CC__) && (__GNUC__ == 1)
#define LDBL_MANT_DIG	DBL_MANT_DIG
#define LDBL_DIG	DBL_DIG
#define LDBL_EPSILON	DBL_EPSILON
#define LDBL_MIN_EXP	DBL_MIN_EXP
#define LDBL_MAX_EXP	DBL_MAX_EXP
#define LDBL_MIN_10_EXP	DBL_MIN_10_EXP
#define LDBL_MAX_10_EXP	DBL_MAX_10_EXP
#define LDBL_MIN	DBL_MIN
#define LDBL_MAX	DBL_MAX
#else
#define LDBL_MANT_DIG	 64
#define LDBL_DIG	 18
#define LDBL_EPSILON	 1.08420217248550443e-19L
#define LDBL_MIN_EXP	-16381
#define LDBL_MAX_EXP	+16384
#define LDBL_MIN_10_EXP	-4931
#define LDBL_MAX_10_EXP	+4932
#define LDBL_MIN	 3.36210314311209351e-4932L
#define LDBL_MAX	 1.18973149535723176e+4932L
#endif

#endif
