/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id:
 */

/*
** PLEASE DO NOT USE THIS HEADER FILE !!!
** ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
** The following features will be supported in the long long
** future,  but not supprted now.   If you want to use these
** features, please make the following interfaces, and contribute
** them to us.
*/

#ifndef __image_h__
#define __image_h__

#ifndef __cdecl_h__
#include <cdecl.h>
#endif

#ifndef __sys_dos_h__
#include <sys/dos.h>
#endif

#ifndef __sys_iocs_h__
#include <sys/iocs.h>
#endif

_EXTERN (int_ img_load (char *, int_, int_, int_));
_EXTERN (int_ img_save (const char *, int_, int_));
_EXTERN (int_ keysns (void_));
_EXTERN (void crt (char));
_EXTERN (void img_color (char));
_EXTERN (void img_home (int_, int_, char, int_, int_));
_EXTERN (void img_ht (int_, int_, int_, int_, char, char));
_EXTERN (void img_pos (char));
_EXTERN (void img_put (int_, int_, int_, int_, const void *, int_));
_EXTERN (void img_scrn (char, char, char));
_EXTERN (void img_set (char, int_, int_, int_, int_));
_EXTERN (void img_still (char));
_EXTERN (void v_cut (char));

static __inline int_ _keysns (void_)
{
    return _dos_keysns ();
}

static __inline void _crt (char mode)
{
    if (mode < 4)
	_iocs_tvctrl (0x1c + mode);
}

#define img_load	_img_load
#define img_save	_img_save
#define keysns		_keysns
#define crt		_crt
#define img_color	_img_color
#define img_home	_img_home
#define img_ht		_img_ht
#define img_pos		_img_pos
#define img_put		_img_put
#define img_scrn	_img_scrn
#define img_set		_img_set
#define img_still	_img_still
#define v_cut		_v_cut

#endif
