/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id:
 */

#ifndef __mouse_h__
#define __mouse_h__

#ifndef __cdecl_h__
#include <cdecl.h>
#endif

#ifndef __sys_iocs_h__
#include <sys/iocs.h>
#endif

_EXTERN (int_ mouse (int_));
_EXTERN (int_ msarea (int_, int_, int_, int_));
_EXTERN (int_ msbtn (int_, int_, int_));
_EXTERN (int_ mspos (int_ *, int_ *));
_EXTERN (int_ msstat (int_ *, int_ *, int_ *, int_ *));
_EXTERN (int_ setmspos (int_, int_));

static __inline int_ _mouse (int_ mode)
{
    switch (mode) {
    case 0:
	/* }EXA\tgL[{[h\ */
	_iocs_ms_init ();
	_iocs_skey_mod (-1, 0, 0);
	break;
    case 1:
	/* }EXJ[\\ */
	_iocs_ms_curon ();
	break;
    case 2:
	/* }EXJ[\ */
	_iocs_ms_curof ();
	break;
    case 3:
	/* }EXJ[\\Ԃ̎ */
	return (short) _iocs_ms_stat ();
    case 4:
	/* \tgL[{[h */
	_iocs_skey_mod (0, 0, 0);
	break;
    default:
	return -1;
    }

    return 0;
}

static __inline int_ _msarea (int_ xs, int_ ys, int_ xe, int_ ye)
{
    /* }EXJ[\̈ړ͈͂ݒ */
    return _iocs_ms_limit (xs, ys, xe, ye);
}

static __inline int_ _msbtn (int_ onoff, int_ mode, int_ time)
{
    /* G[`FbN */
    if (onoff < 0 || onoff > 1 || mode < 0 || mode > 1 || time < 0 || time > 65535)
	return -2;

    /* }EX̃{^w肵ԂɂȂ܂ł̎Ԃv */
    return onoff ? _iocs_ms_ontm (-mode, time)
		 : _iocs_ms_offtm (-mode, time);
}

static __inline int_ _mspos (int_ *x, int_ *y)
{
    int_ pos = _iocs_ms_curgt ();

    /* }EXJ[\̍W */
    *x = (pos >> 16) & 0xffff;
    *y = pos & 0xffff;

    return pos;
}

static __inline int_ _msstat (int_ *x, int_ *y, int_ *bl, int_ *br)
{
    int ms = _iocs_ms_getdt ();

    /* }EX̏Ԃ */
    *x = (signed char) ((ms >> 24) & 0xff);
    *y = (signed char) ((ms >> 16) & 0xff);
    *bl = (signed char) ((ms >> 8) & 0xff);
    *br = (signed char) (ms & 0xff);

    return ms;
}

static __inline int_ _setmspos (int_ x, int_ y)
{
    /* }EXJ[\ړ */
    return _iocs_ms_curst (x, y);
}

#define mouse		_mouse
#define msarea		_msarea
#define msbtn		_msbtn
#define mspos		_mspos
#define msstat		_msstat
#define setmspos	_setmspos

#endif
