/* parts     1990-1991 T.Kobayashi			*/
/* parts +13 1992-1995 H.Ogasawara(COR.)	*/

#ifndef	_WLIB_
#include "wlib.h"
#endif

#ifndef	_PARTS_
#define	_PARTS_

typedef	struct	{
		int		x1, y1, x2, y2 ;
	}
		ClipClass ;

typedef	struct	{
		int		x1, y1, x2, y2 ;
		int		dir ;
		int		width ;
		int		length ;
		int		min, max ;
		int		top ;
		int		size ;
	}
		SliderClass ;

typedef	struct	{
		int		x1, y1, x2, y2 ;
		char	*str ;
		int		max ;
		int		attr ;
		int		font ;
		int		cur ;
		int		curflag ;
	}
		InputClass ;


/*
	proto -e clip.c slider.c sheet.c > temp
	proto -e input.c > temp
*/
extern	void	ClipSet( ClipClass*, int, int, int, int );
extern	void	ClipMove( ClipClass*, int, int );
extern	int		ClipInner( ClipClass*, int, int );
extern	void	ClipGetSize( ClipClass*, int*, int* );
extern	int		ClipOverlap( ClipClass*, ClipClass*, ClipClass* );

extern	void	SliderSet( SliderClass*, int, int, int, int, int, int, int );
extern	int		SliderGetCurrentPosition( SliderClass* );
extern	int		SliderGetPosition( SliderClass*, int, int );
extern	int		SliderSetPosition( DrawBuf*, SliderClass*, int, int );
extern	int		SliderSetDraw( DrawBuf*, SliderClass* );

extern	void	SheetClear( Sheet*, ClipClass*, int );
extern	void	SheetLine( Sheet*, ClipClass*, int, int, int, int, int, SheetOption );
extern	void	SheetPutPattern( Sheet*, ClipClass*, Sheet* );
extern	void	SheetCopy( Sheet*, ClipClass*, int, int, Sheet* );
extern	void	SheetScroll( Sheet*, ClipClass*, int, int );
extern	void	SheetSymbol( Sheet*, ClipClass*, int, int, char*, int, int );

/*  by M.Tatsumi ( UQ ) & COR. */
extern	void	SheetDot( Sheet*, ClipClass*, int, int, int );
extern	void	SheetCircle( Sheet*, ClipClass*, int, int, int, int, int, SheetOption );


extern	void	InputSet( InputClass*, int, int, char*, int, int, int );
/* 1991 COR.
extern	void	InputSetCursor( InputClass*, int );
extern	int		InputGetCursor( InputClass* );
*/
#define			InputSetCursor( ip, a )		((ip)->cur=(a))
#define			InputGetCursor( ip )		((ip)->cur)
extern	int		InputSetCursorVisible( DrawBuf*, InputClass*, int );
extern	int		InputSetDraw( DrawBuf*, InputClass* );
extern	int		InputKey( DrawBuf*, InputClass*, int, int );
/* 1993 COR. */
extern int	_kk_EmacsMode;
#define			InputGetMode()	(_kk_EmacsMode)

/* 1991 COR. */
extern	int		KanjiIsDbcs( int );
extern	int		KanjiStrlen( char* );
extern 	int		KanjiTestPosition( char*, int );
extern	int		KanjiGetPosition( char*, int );

#endif
