/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id: setjmp.h,v 1.3 1994/05/02 16:06:16 mura Exp $
 */

#ifndef __setjmp_h__
#define __setjmp_h__

#ifndef __cdecl_h__
#include <cdecl.h>
#endif

/*
** setjmp saves data registers (d3-d7), address registers (a3-a7),
** floating-point registers (fp2-fp7), and program counter (pc).
** sigsetjmp saves signal mask in addition to the registers.
*/

typedef struct {
    int_ ret;
    int_ dregs[5];
    int_ aregs[5];
    int_ fpregs[6][3];
    int_ sigmask;
} jmp_buf[1];

typedef struct {
    int_ ret;
    int_ dregs[5];
    int_ aregs[5];
    int_ fpregs[6][3];
    int_ sigmask;
} sigjmp_buf[1];

_EXTERN (int_ _setjmp (jmp_buf));
_EXTERN (int_ sigsetjmp (sigjmp_buf, int_));
_EXTERN (void __volatile longjmp (jmp_buf, int_));
_EXTERN (void __volatile siglongjmp (sigjmp_buf, int_));

#define setjmp _setjmp

#endif
