/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id:
 */

#ifndef __stick_h__
#define __stick_h__

#ifndef __cdecl_h__
#include <cdecl.h>
#endif

#ifndef __sys_iocs_h__
#include <sys/iocs.h>
#endif

_EXTERN (int_ stick (int_));
_EXTERN (int_ strig (int_));

static __inline int_ _stick (int_ no)
{
    /* WCXeBbNԍ̃`FbN */
    if (--no < 0 || no > 1)
	return -1;

    /* XeBbN̏ԂԂ */
    return (int_) "\x05\x02\x08\x05\x06\x03\x09\x06\x04\x01\x07\x04\x05\x02\x08\x05"
			[_iocs_joyget (no) & 0x0f];
}

static __inline int_ _strig (int_ no)
{
    /* WCXeBbNԍ̃`FbN */
    if (--no < 0 || no > 1)
	return -1;

    /* {^̏ԂԂ  */
    return (~_iocs_joyget (no) >> 5) & 3;
}

#define stick	_stick
#define strig	_strig

#endif
