/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id: iocs_i.h,v 1.11 1994/07/27 13:44:54 mura Exp $
 */

#ifndef __sys_iocs_i_h__
#define __sys_iocs_i_h__

#if !defined (__GNUC__) && !defined (__GNUG__)
#error You lose. This file can be compiled only by GNU-C compiler.
#endif

static __inline int_ _iocs_adpcmsns (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__ADPCMSNS,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ __const _iocs_akconv (int_ code, int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm ("move.w %1,d1\n\t"
	   "swap.w d1\n\t"
	   "move.w %2,d1\n\t"
	   "moveq.l #__AKCONV,%0\n\t"
	   "trap #15"
		: "=d" (reg_d0)
		: "ri" ((int_) code), "ri" ((short) mode)
		: "d1");

    return reg_d0;
}

static __inline int_ _iocs_alarmget (int_ *datetime, int_ *offtime, int_ *job)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ *reg_a0 __asm("a0") = datetime;
    register int_ *reg_a1 __asm("a1") = offtime;
    register int_ *reg_a2 __asm("a2") = job;

    __asm __volatile ("moveq.l #__ALARMGET,%0\n\t"
		      "trap #15\n\t"
		      "move.l d0,(a0)\n\t"
		      "move.l d1,(a1)\n\t"
		      "move.l d2,(a2)"
			: "=d" (reg_d0), "=m" (*datetime), "=m" (*offtime), "=m" (*job)
			: "a" (reg_a0), "a" (reg_a1), "a" (reg_a2)
			: "d1", "d2");

    return reg_d0;
}

static __inline int_ _iocs_alarmmod (int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__ALARMMOD,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_alarmset (int_ datetime, int_ offtime, int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = datetime;
    register int_ reg_d2 __asm ("d2") = offtime;
    register int_ reg_a1 __asm ("a1") = mode;

    __asm __volatile ("moveq.l #__ALARMSET,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_apage (int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__APAGE,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_bgctrlgt (int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__BGCTRLGT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_bgctrlst (int_ mode, int_ page, int_ onoff)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;
    register int_ reg_d2 __asm ("d2") = page;
    register int_ reg_d3 __asm ("d3") = onoff;

    __asm __volatile ("moveq.l #__BGCTRLST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3));

    return reg_d0;
}

static __inline int_ _iocs_bgscrlgt (int_ mode, int_ *x, int_ *y)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;
    register int_ reg_d2 __asm ("d2");
    register int_ reg_d3 __asm ("d3");

    __asm __volatile ("moveq.l #__BGSCRLGT,d0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=d" (reg_d2), "=d" (reg_d3)
			: "d" (reg_d1));

    if (reg_d0 == 0) {
	*x = reg_d2;
	*y = reg_d3;
    }
    return reg_d0;
}

static __inline int_ _iocs_bgscrlst (int_ mode, int_ x, int_ y)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;
    register int_ reg_d2 __asm ("d2") = x;
    register int_ reg_d3 __asm ("d3") = y;

    __asm __volatile ("moveq.l #__BGSCRLST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3));

    return reg_d0;
}

static __inline int_ _iocs_bgtextcl (int_ page, int_ code)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = page;
    register int_ reg_d2 __asm ("d2") = code;

    __asm __volatile ("moveq.l #__BGTEXTCL,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_bgtextgt (int_ page, int_ x, int_ y)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = page;
    register int_ reg_d2 __asm ("d2") = x;
    register int_ reg_d3 __asm ("d3") = y;

    __asm __volatile ("moveq.l #__BGTEXTGT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3));

    return reg_d0;
}

static __inline int_ _iocs_bgtextst (int_ page, int_ x, int_ y, int_ code)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = page;
    register int_ reg_d2 __asm ("d2") = x;
    register int_ reg_d3 __asm ("d3") = y;
    register int_ reg_d4 __asm ("d4") = code;

    __asm __volatile ("moveq.l #__BGTEXTST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "d" (reg_d4));

    return reg_d0;
}

static __inline int_ _iocs_bindatebcd (int_ bindate)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = bindate;

    __asm __volatile ("moveq.l #__DATEBCD,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_bindateget (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__DATEGET,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_bitsns (int_ group)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = group;

    __asm __volatile ("moveq.l #__BITSNS,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ __const _iocs_bootinf (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm ("moveq.l #__BOOTINF,%0\n\t"
	   "trap #15"
		: "=d" (reg_d0)
		: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_box (const struct _boxptr *boxptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const struct _boxptr *reg_a1 __asm ("a1") = boxptr;

    __asm __volatile ("moveq.l #__BOX,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_b_assign (int_ drive, int_ recno, int_ icode, const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;
    register int_ reg_d3 __asm ("d3") = icode;
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_ASSIGN,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_b_badfmt (int_ drive, int_ recno, int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;
    register int_ reg_d3 __asm ("d3") = mode;

    __asm __volatile ("moveq.l #__B_BADFMT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3));

    return reg_d0;
}

static __inline int_ _iocs_b_bpeek (const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_BPEEK,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_color (int_ color)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = color;

    __asm __volatile ("moveq.l #__B_COLOR,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_b_consol (int_ xs, int_ ys, int_ xl, int_ yl)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("move.w %1,d1\n\t"
		      "swap.w d1\n\t"
		      "move.w %2,d1\n\t"
		      "move.w %3,d2\n\t"
		      "swap.w d2\n\t"
		      "move.w %4,d2\n\t"
		      "moveq.l #__B_CONSOL,%0\n\t"
		      "trap #15\n\t"
		      "move.l d2,%0"
			: "=d" (reg_d0)
			: "ri" ((short) xs), "ri" ((short) ys),
			  "ri" ((short) xl), "ri" ((short) yl)
			: "d1", "d2");

    return reg_d0;
}

static __inline int_ _iocs_b_drvchk (int_ drive, int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = mode;

    __asm __volatile ("moveq.l #__B_DRVCHK,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_b_drvsns (int_ drive)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;

    __asm __volatile ("moveq.l #__B_DRVSNS,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_b_dskini (int_ drive, const void *addr, int_ offtm)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = offtm;
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_DSKINI,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "a" (reg_a1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_b_eject (int_ drive)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;

    __asm __volatile ("moveq.l #__B_EJECT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_b_format (int_ drive, int_ recno, int_ length, const void *idp)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;
    register int_ reg_d3 __asm ("d3") = length;
    register const void *reg_a1 __asm ("a1") = idp;

    __asm __volatile ("moveq.l #__B_FORMAT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_b_intvcs (int_ vector, int_ addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = vector;
    register int_ reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_INTVCS,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_b_super (int_ ssp)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_a1 __asm ("a1") = ssp;

    __asm __volatile ("move.l sp,a0\n\t"
		      "moveq.l #__B_SUPER,%0\n\t"
		      "trap #15\n\t"
		      "move.l a0,sp"
			: "=d" (reg_d0)
			: "a" (reg_a1)
			: "a0", "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_keyinp (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__B_KEYINP,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_b_keysns (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__B_KEYSNS,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_b_locate (int_ x, int_ y)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;

    __asm __volatile ("moveq.l #__B_LOCATE,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_b_lpeek (const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_LPEEK,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_print (const char *msg)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const char *reg_a1 __asm ("a1") = msg;

    __asm __volatile ("moveq.l #__B_PRINT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_putc (int_ code)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = code;

    __asm __volatile ("moveq.l #__B_PUTC,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_b_putmes (int_ color, int_ x, int_ y,
				    int_ max, const char *msg)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = color;
    register int_ reg_d2 __asm ("d2") = x;
    register int_ reg_d3 __asm ("d3") = y;
    register int_ reg_d4 __asm ("d4") = max;
    register const char *reg_a1 __asm ("a1") = msg;

    __asm __volatile ("moveq.l #__B_PUTMES,%0\n\t"
		      "trap #15\n\t"
		      "move.l d2,%0\n\t"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "d" (reg_d4),
			  "a" (reg_a1)
			: "d2", "d4", "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_read (int_ drive,
				  int_ recno, int_ length, void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;
    register int_ reg_d3 __asm ("d3") = length;
    register void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_READ,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*(char *) addr)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "a" (reg_a1)
			: "d2", "d3", "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_readdi (int_ drive,
				     int_ recno, int_ length, void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;
    register int_ reg_d3 __asm ("d3") = length;
    register void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_READDI,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*(char *) addr)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "a" (reg_a1)
			: "d2", "d3", "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_readdl (int_ drive,
				     int_ recno, int_ length, void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;
    register int_ reg_d3 __asm ("d3") = length;
    register void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_READDL,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*(char *) addr)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "a" (reg_a1)
			: "d2", "d3", "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_readid (int_ drive, int_ track, void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = track;

    __asm __volatile ("moveq.l #__B_READID,%0\n\t"
		      "trap #15\n\t"
		      "move.l d2,%1"
			: "=d" (reg_d0), "=m" (*(char *) addr)
			: "d" (reg_d1), "d" (reg_d2)
			: "d2");

    return reg_d0;
}

static __inline int_ _iocs_b_recali (int_ drive)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;

    __asm __volatile ("moveq.l #__B_RECALI,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_b_seek (int_ drive, int_ recno)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;

    __asm __volatile ("moveq.l #__B_SEEK,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_b_sftsns (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__B_SFTSNS,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_b_verify (int_ drive,
				     int_ recno, int_ length, const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;
    register int_ reg_d3 __asm ("d3") = length;
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_VERIFY,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "a" (reg_a1)
			: "d2", "d3", "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_wpeek (const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_WPEEK,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_write (int_ drive,
				    int_ recno, int_ length, const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;
    register int_ reg_d3 __asm ("d3") = length;
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_WRITE,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "a" (reg_a1)
			: "d2", "d3", "a1");

    return reg_d0;
}

static __inline int_ _iocs_b_writed (int_ drive,
				     int_ recno, int_ length, const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = drive;
    register int_ reg_d2 __asm ("d2") = recno;
    register int_ reg_d3 __asm ("d3") = length;
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__B_WRITED,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "a" (reg_a1)
			: "d2", "d3", "a1");

    return reg_d0;
}

static __inline int_ _iocs_cache_st (void_)
{
    register int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = 1;

    __asm __volatile ("moveq.l #__SYS_STAT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_circle (const struct _circleptr *ptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const struct _circleptr *reg_a1 __asm ("a1") = ptr;

    __asm __volatile ("moveq.l #__CIRCLE,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_contrast (int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__CONTRAST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_crtcras (const void *addr, int_ luster)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = luster;
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__CRTCRAS,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_crtmod (int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__CRTMOD,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_dakjob (char *bufend)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register char *reg_a1 __asm ("a1") = bufend;

    __asm __volatile ("moveq.l #__DAKJOB,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*bufend)
			: "a" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ _iocs_dateasc (int_ bindate, char *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_  reg_d1 __asm ("d1") = bindate;
    register char *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__DATEASC,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*addr)
			: "d" (reg_d1), "d" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ __const _iocs_datebin (int_ bcddate)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = bcddate;

    __asm ("moveq.l #__DATEBIN,%0\n\t"
	   "trap #15"
		: "=d" (reg_d0)
		: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_datecnv (const char *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const char *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__DATECNV,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ _iocs_defchr (int_ type, int_ code, const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("move.w %1,d1\n\t"
		      "swap.w d1\n\t"
		      "move.w %2,d1\n\t"
		      "moveq.l #__DEFCHR,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "ri" ((short) type), "ri" ((short) code), "a" (reg_a1)
			: "d1");

    return reg_d0;
}

static __inline int_ _iocs_dmamode (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__DMAMODE,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_drawmode (int_ mode)
{
    register int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__DRAWMODE,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_fill (const struct _fillptr *ptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const struct _fillptr *reg_a1 __asm ("a1") = ptr;

    __asm __volatile ("moveq.l #__FILL,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_fntadr (int_ code, int_ type)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = code;
    register int_ reg_d2 __asm ("d2") = type;

    __asm __volatile ("moveq.l #__FNTADR,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2)
			: "d1", "d2");

    return reg_d0;
}

static __inline int_ _iocs_fntget (int_ type, int_ code, struct _fntbuf *ptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register struct _fntbuf *reg_a1 __asm ("a1") = ptr;

    __asm __volatile ("move.w %2,d1\n\t"
		      "swap.w d1\n\t"
		      "move.w %3,d1\n\t"
		      "moveq.l #__FNTGET,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*ptr)
			: "ri" ((short) type), "ri" ((short) code), "a" (reg_a1)
			: "d1");

    return reg_d0;
}

static __inline int_ _iocs_getgrm (struct _getptr *ptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register struct _getptr *reg_a1 __asm ("a1") = ptr;

    __asm __volatile ("moveq.l #__GETGRM,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*ptr)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_gpalet (int_ no, int_ color)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = no;
    register int_ reg_d2 __asm ("d2") = color;

    __asm __volatile ("moveq.l #__GPALET,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_hanjob (char *bufend)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register char *reg_a1 __asm ("a1") = bufend;

    __asm __volatile ("moveq.l #__HANJOB,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*bufend)
			: "a" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ _iocs_home (int_ page, int_ x, int_ y)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = page;
    register int_ reg_d2 __asm ("d2") = x;
    register int_ reg_d3 __asm ("d3") = y;

    __asm __volatile ("moveq.l #__HOME,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3));

    return reg_d0;
}

static __inline int_ __const _iocs_hsvtorgb (int_ h, int_ s, int_ v)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register unsigned int_ reg_d1 __asm ("d1")
	= ((h & 0xff) << 16) | ((s & 0x1f) << 8) | (v & 0x1f);

    __asm ("moveq.l #__HSVTORGB,%0\n\t"
	   "trap #15"
		: "=d" (reg_d0)
		: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_hsyncst (const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__HSYNCST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_init_prn (int_ line, int_ width)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register unsigned int_ reg_d1 __asm ("d1") = ((line & 0xff) << 8) | (width & 0xff);

    __asm __volatile ("moveq.l #__INIT_PRN,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_inp232c (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__INP232C,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_isns232c (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__ISNS232C,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ __const _iocs_jissft (int_ code)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = code;

    __asm ("moveq.l #__JISSFT,%0\n\t"
	   "trap #15"
		: "=d" (reg_d0)
		: "d" (reg_d1)
		: "d1");

    return reg_d0;
}

static __inline int_ _iocs_joyget (int_ no)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = no;

    __asm __volatile ("moveq.l #__JOYGET,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_line (const struct _lineptr *lineptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const struct _lineptr *reg_a1 __asm ("a1") = lineptr;

    __asm __volatile ("moveq.l #__LINE,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_lof232c (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__LOF232C,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ __const _iocs_mpu_stat (void_)
{
    register int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = 0;

    __asm __volatile ("moveq.l #__SYS_STAT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_ms_curgt (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__MS_CURGT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_ms_curst (int_ x, int_ y)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("move.w %1,d1\n\t"
		      "swap.w d1\n\t"
		      "move.w %2,d1\n\t"
		      "moveq.l #__MS_CURST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "ri" ((short) x), "ri" ((short) y)
			: "d1");

    return reg_d0;
}

static __inline int_ _iocs_ms_getdt (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__MS_GETDT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_ms_limit (int_ xs, int_ ys, int_ xe, int_ ye)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("move.w %1,d1\n\t"
		      "swap.w d1\n\t"
		      "move.w %2,d1\n\t"
		      "move.w %3,d2\n\t"
		      "swap.w d2\n\t"
		      "move.w %4,d2\n\t"
		      "moveq.l #__MS_LIMIT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "ri" ((short) xs), "ri" ((short) ys),
			  "ri" ((short) xe), "ri" ((short) ye)
			: "d1", "d2");

    return reg_d0;
}

static __inline int_ _iocs_ms_offtm (int_ mode, int_ max)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;
    register int_ reg_d2 __asm ("d2") = max;

    __asm __volatile ("moveq.l #__MS_OFFTM,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_ms_ontm (int_ mode, int_ max)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;
    register int_ reg_d2 __asm ("d2") = max;

    __asm __volatile ("moveq.l #__MS_ONTM,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_ms_stat (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__MS_STAT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_ontime (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__ONTIME,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */
			: "d1");

    return reg_d0;
}

static __inline struct _ontime _iocs_ontime2 (void_)
{
    register struct _ontime reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__ONTIME,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_opmintst (const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__OPMINTST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_opmsns (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__OPMSNS,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_osns232c (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__OSNS232C,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_paint (struct _paintptr *ptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register struct _paintptr *reg_a1 __asm ("a1") = ptr;

    __asm __volatile ("moveq.l #__PAINT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_point (const struct _pointptr *ptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const struct _pointptr *reg_a1 __asm ("a1") = ptr;

    __asm __volatile ("moveq.l #__POINT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_prnintst (const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__PRNINTST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_pset (const struct _psetptr *ptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const struct _psetptr *reg_a1 __asm ("a1") = ptr;

    __asm __volatile ("moveq.l #__PSET,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_putgrm (const struct _putptr *ptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const struct _putptr *reg_a1 __asm ("a1") = ptr;

    __asm __volatile ("moveq.l #__PUTGRM,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_rmacnv (int_ code, char *wptr, char *aptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_  reg_d1 __asm ("d1") = code;
    register char *reg_a1 __asm ("a1") = wptr;
    register char *reg_a2 __asm ("a2") = aptr;

    __asm __volatile ("moveq.l #__RMACNV,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*wptr), "=m" (*aptr)
			: "d" (reg_d1), "a" (reg_a1), "a" (reg_a2));

    return reg_d0;
}

static __inline int_ __const _iocs_romver (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm ("moveq.l #__ROMVER,%0\n\t"
	   "trap #15"
		: "=d" (reg_d0)
		: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_set232c (int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__SET232C,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_setescadr (void *addr)
{
    register int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = (int_) addr;

    __asm __volatile ("moveq.l #__SETESCADR,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return (int_) reg_d0;
}

static __inline int_ _iocs_setfntadr (const char *buf, int_ type)
{
    register int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = (int_) buf;
    register int_ reg_d2 __asm ("d2") = type;

    __asm __volatile ("moveq.l #__SETFNTADR,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ __const _iocs_sftjis (int_ code)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = code;

    __asm ("moveq.l #__SFTJIS,%0\n\t"
	   "trap #15"
		: "=d" (reg_d0)
		: "d" (reg_d1)
		: "d1");

    return reg_d0;
}

static __inline int_ _iocs_skey_mod (int_ mode, int_ x, int_ y)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("move.w %2,d2\n\t"
		      "swap.w d2\n\t"
		      "move.w %3,d2\n\t"
		      "moveq.l #__SKEY_MOD,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "ri" ((short) x), "ri" ((short) y)
			: "d2");

    return reg_d0;
}

static __inline int_ _iocs_snsprn (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__SNSPRN,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_spalet (int_ code, int_ block, int_ color)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = code;
    register int_ reg_d2 __asm ("d2") = block;
    register int_ reg_d3 __asm ("d3") = color;

    __asm __volatile ("moveq.l #__SPALET,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3));

    return reg_d0;
}

static __inline int_ _iocs_sp_cgclr (int_ code)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = code;

    __asm __volatile ("moveq.l #__SP_CGCLR,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_sp_defcg (int_ code, int_ size, const void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = code;
    register int_ reg_d2 __asm ("d2") = size;
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__SP_DEFCG,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_sp_gtpcg (int_ code, int_ size, void *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_  reg_d1 __asm ("d1") = code;
    register int_  reg_d2 __asm ("d2") = size;
    register void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__SP_GTPCG,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*(char *) addr)
			: "d" (reg_d1), "d" (reg_d2), "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_sp_init (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__SP_INIT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_sp_on (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__SP_ON,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_sp_reggt (int_ spno, int_ *x, int_ *y, int_ *code, int_ *prw)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = spno;
    register int_ reg_d2 __asm ("d2");
    register int_ reg_d3 __asm ("d3");
    register int_ reg_d4 __asm ("d4");
    register int_ reg_d5 __asm ("d5");

    __asm __volatile ("moveq.l #__SP_REGGT,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=d" (reg_d2), "=d" (reg_d3),
			  "=d" (reg_d4), "=d" (reg_d5)
			: "d" (reg_d1));

    if (reg_d0 == 0) {
	*x = reg_d2;
	*y = reg_d3;
	*code = reg_d4;
	*prw = reg_d5;
    }
    return reg_d0;
}

static __inline int_ _iocs_sp_regst (int_ spno, int_ x, int_ y, int_ code, int_ prw)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = spno;
    register int_ reg_d2 __asm ("d2") = x;
    register int_ reg_d3 __asm ("d3") = y;
    register int_ reg_d4 __asm ("d4") = code;
    register int_ reg_d5 __asm ("d5") = prw;

    __asm __volatile ("moveq.l #__SP_REGST,%0\n\t"
		      "trap #15\n\t"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3),
			  "d" (reg_d4), "d" (reg_d5));

    return reg_d0;
}

static __inline int_ _iocs_symbol (const struct _symbolptr *ptr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const struct _symbolptr *reg_a1 __asm ("a1") = ptr;

    __asm __volatile ("moveq.l #__SYMBOL,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_tgusemd (int_ tg, int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = tg;
    register int_ reg_d2 __asm ("d2") = mode;

    __asm __volatile ("moveq.l #__TGUSEMD,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_timeasc (int_ bintime, char *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = bintime;
    register char *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__TIMEASC,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0), "=m" (*addr)
			: "d" (reg_d1), "a" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ __const _iocs_timebcd (int_ bintime)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = bintime;

    __asm ("moveq.l #__TIMEBCD,%0\n\t"
	   "trap #15"
		: "=d" (reg_d0)
		: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ __const _iocs_timebin (int_ bcddate)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = bcddate;

    __asm ("moveq.l #__TIMEBIN,%0\n\t"
	   "trap #15"
		: "=d" (reg_d0)
		: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_timecnv (const char *addr)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const char *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__TIMECNV,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "a" (reg_a1)
			: "a1");

    return reg_d0;
}

static __inline int_ _iocs_timeget (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__TIMEGET,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline int_ _iocs_timerdst (const void *addr, int_ mode, int_ cnt)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register unsigned int_ reg_d1 __asm ("d1") = ((mode & 0xff) << 8) | (cnt & 0xff);
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__TIMERDST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_tpalet (int_ no, int_ col)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = no;
    register int_ reg_d2 __asm ("d2") = col;

    __asm __volatile ("moveq.l #__TPALET,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_tpalet2 (int_ no, int_ col)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = no;
    register int_ reg_d2 __asm ("d2") = col;

    __asm __volatile ("moveq.l #__TPALET2,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2));

    return reg_d0;
}

static __inline int_ _iocs_trap15 (const struct _regs *in, struct _regs *out)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register const struct _regs *reg_a0 __asm ("a0") = in;
    register       struct _regs *reg_a1 __asm ("a1") = out;

    __asm __volatile ("movem.l d1-d7/a0-a6,-(sp)\n\t"
		      "move.l %3,-(sp)\n\t"
		      "movem.l (%2),d0-d7/a1-a6\n\t"
		      "lea (sp),%2\n\t"
		      "trap #15\n\t"
		      "lea (%2),sp\n\t"
		      "movea.l (sp)+,%2\n\t"
		      "movem.l d0-d7/a1-a6,(%2)\n\t"
		      "movem.l (sp)+,d1-d7/a0-a6"
			: "=d" (reg_d0), "=m" (*out)
			: "a" (reg_a0), "a" (reg_a1), "m" (*in));

    return reg_d0;
}

static __inline int_ _iocs_vc_r0 (int_ mode)
{
    register int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__VC_R0,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_vc_r1 (int_ prw)
{
    register int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = prw;

    __asm __volatile ("moveq.l #__VC_R1,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_vc_r2 (int_ mode)
{
    register int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__VC_R2,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_vdispst (const void *addr, int_ mode, int_ cnt)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register unsigned int_ reg_d1 __asm ("d1") = ((mode & 0xff) << 8) | (cnt & 0xff);
    register const void *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__VDISPST,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "a" (reg_a1));

    return reg_d0;
}

static __inline int_ _iocs_vpage (int_ mode)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__VPAGE,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1));

    return reg_d0;
}

static __inline int_ _iocs_window (int_ sx, int_ sy, int_ ex, int_ ey)
{
    register unsigned int_ reg_d0 __asm ("d0");
    register int_ reg_d1 __asm ("d1") = sx;
    register int_ reg_d2 __asm ("d2") = sy;
    register int_ reg_d3 __asm ("d3") = ex;
    register int_ reg_d4 __asm ("d4") = ey;

    __asm __volatile ("moveq.l #__WINDOW,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "d" (reg_d4));

    return reg_d0;
}

static __inline int_ _iocs_wipe (void_)
{
    register unsigned int_ reg_d0 __asm ("d0");

    __asm __volatile ("moveq.l #__WIPE,%0\n\t"
		      "trap #15"
			: "=d" (reg_d0)
			: /* no inputs */ );

    return reg_d0;
}

static __inline void __volatile _iocs_abortjob (void_)
{
    __asm __volatile ("moveq.l #__ABORTJOB,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_abortrst (void_)
{
    __asm __volatile ("moveq.l #__ABORTRST,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_adpcmain (const struct _chain *addr, int_ mode, int_ cnt)
{
    register const struct _chain *reg_a1 __asm ("a1") = addr;
    register int_ reg_d1 __asm ("d1") = mode;
    register int_ reg_d2 __asm ("d2") = cnt;

    __asm __volatile ("moveq.l #__ADPCMAIN,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1), "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_adpcmaot (const struct _chain *addr, int_ mode, int_ cnt)
{
    register const struct _chain *reg_a1 __asm ("a1") = addr;
    register int_ reg_d1 __asm ("d1") = mode;
    register int_ reg_d2 __asm ("d2") = cnt;

    __asm __volatile ("moveq.l #__ADPCMAOT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1), "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_adpcminp (void *addr, int_ mode, int_ len)
{
    register void *reg_a1 __asm ("a1") = addr;
    register int_  reg_d1 __asm ("d1") = mode;
    register int_  reg_d2 __asm ("d2") = len;

    __asm __volatile ("moveq.l #__ADPCMINP,d0\n\t"
		      "trap #15"
			: "=m" (*(char *) addr)
			: "a" (reg_a1), "d" (reg_d1), "d" (reg_d2)
			: "d0", "d2", "a1");
}

static __inline void _iocs_adpcmlin (const struct _chain2 *addr, int_ mode)
{
    register const struct _chain2 *reg_a1 __asm ("a1") = addr;
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__ADPCMLIN,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1), "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_adpcmlot (const struct _chain2 *addr, int_ mode)
{
    register const struct _chain2 *reg_a1 __asm ("a1") = addr;
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__ADPCMLOT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1), "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_adpcmmod (int_ mode)
{
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__ADPCMMOD,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_adpcmout (const void *addr, int_ mode, int_ len)
{
    register const void *reg_a1 __asm ("a1") = addr;
    register int_ reg_d1 __asm ("d1") = mode;
    register int_ reg_d2 __asm ("d2") = len;

    __asm __volatile ("moveq.l #__ADPCMOUT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1), "d" (reg_d1), "d" (reg_d2)
			: "d0", "d2", "a1");
}

static __inline void _iocs_apage2 (int_ mode)
{
    register int_ reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__APAGE2,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_bindateset (int_ bcddate)
{
    register int_ reg_d1 __asm ("d1") = bcddate;

    __asm __volatile ("moveq.l #__DATESET,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_bpoke (void *addr, int_ data)
{
    register void *reg_a1 __asm ("a1") = addr;
    register int_  reg_d1 __asm ("d1") = data;

    __asm __volatile ("moveq.l #__B_BPOKE,d0\n\t"
		      "trap #15"
			: "=m" (*(char *) addr)
			: "a" (reg_a1), "d" (reg_d1)
			: "d0", "a1");
}

static __inline void _iocs_b_clr_al (void_)
{
    register int_ reg_d1 __asm ("d1") = 2;

    __asm __volatile ("moveq.l #__B_CLR_ST,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_clr_ed (void_)
{
    register int_ reg_d1 __asm ("d1") = 0;

    __asm __volatile ("moveq.l #__B_CLR_ST,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_clr_st (void_)
{
    register int_ reg_d1 __asm ("d1") = 1;

    __asm __volatile ("moveq.l #__B_CLR_ST,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_curdef (const char *addr)
{
    register int_ reg_d2 __asm ("d2") = (int_) addr;
    register int_ reg_d1 __asm ("d1") = 3;

    __asm __volatile ("moveq.l #__B_CONMOD,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_b_curmod (int_ mode)
{
    register int_ reg_d1 __asm ("d1") = mode;

    if ((unsigned int_)mode > 1)
	return;

    __asm __volatile ("moveq.l #__B_CONMOD,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_curoff (void_)
{
    __asm __volatile ("moveq.l #__B_CUROFF,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_b_curon (void_)
{
    __asm __volatile ("moveq.l #__B_CURON,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_b_curpat (int_ pat)
{
    register int_ reg_d1 __asm ("d1") = 2;
    register int_ reg_d2 __asm ("d2") = pat;

    if ((short)pat == 0)
	return;

    __asm __volatile ("moveq.l #__B_CONMOD,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_b_curpat1 (void_)
{
    register int_ reg_d1 __asm ("d1") = 2;
    register int_ reg_d2 __asm ("d2") = 0;

    __asm __volatile ("moveq.l #__B_CONMOD,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_b_del (int_ num)
{
    register int_ reg_d1 __asm ("d1") = num;

    __asm __volatile ("moveq.l #__B_DEL,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_down (int_ num)
{
    register int_ reg_d1 __asm ("d1") = num;

    __asm __volatile ("moveq.l #__B_DOWN,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_down_s (void_)
{
    __asm __volatile ("moveq.l #__B_DOWN_S,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_b_era_al (void_)
{
    register int_ reg_d1 __asm ("d1") = 2;

    __asm __volatile ("moveq.l #__B_ERA_ST,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_era_ed (void_)
{
    register int_ reg_d1 __asm ("d1") = 0;

    __asm __volatile ("moveq.l #__B_ERA_ST,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_era_st (void_)
{
    register int_ reg_d1 __asm ("d1") = 1;

    __asm __volatile ("moveq.l #__B_ERA_ST,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_ins (int_ num)
{
    register int_ reg_d1 __asm ("d1") = num;

    __asm __volatile ("moveq.l #__B_INS,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_left (int_ num)
{
    register int_ reg_d1 __asm ("d1") = num;

    __asm __volatile ("moveq.l #__B_LEFT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_lpoke (void *addr, int_ data)
{
    register void *reg_a1 __asm ("a1") = addr;
    register int_  reg_d1 __asm ("d1") = data;

    __asm __volatile ("moveq.l #__B_LPOKE,d0\n\t"
		      "trap #15"
			: "=m" (*(char *) addr)
			: "a" (reg_a1), "d" (reg_d1)
			: "d0", "a1");
}

static __inline void _iocs_b_memset (void *addr, const void *buf, int_ cnt)
{
    register       void *reg_a1 __asm ("a1") = addr;
    register const void *reg_a2 __asm ("a2") = buf;
    register int_ reg_d1 __asm ("d1") = cnt;

    __asm __volatile ("moveq.l #__B_MEMSET,d0\n\t"
		      "trap #15"
			: "=m" (*(char *) addr)
			: "a" (reg_a1), "a" (reg_a2), "d" (reg_d1)
			: "d0", "d1", "a1", "a2");
}

static __inline void _iocs_b_memstr (const void *addr, void *buf, int_ cnt)
{
    register const void *reg_a1 __asm ("a1") = addr;
    register       void *reg_a2 __asm ("a2") = buf;
    register int_ reg_d1 __asm ("d1") = cnt;

    __asm __volatile ("moveq.l #__B_MEMSTR,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1), "a" (reg_a2), "d" (reg_d1)
			: "d0", "d1", "a1", "a2");
}

static __inline void _iocs_b_right (int_ num)
{
    register int_ reg_d1 __asm ("d1") = num;

    __asm __volatile ("moveq.l #__B_RIGHT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

/*
 * XC  B_SCROLL() ݊̊֐CCWĴ͖B
 */

static __inline void _iocs_b_scroll (int_ mode)
{
    if ((unsigned int_)mode >= 17) {
	register int_ reg_d1 __asm ("d1") = mode;

	__asm __volatile ("moveq.l #__CONMOD,d0\n\t"
			  "trap #15"
			    : /* no outputs */
			    : "d" (reg_d1)
			    : "d0" );
    }
    else {
	register int_ reg_d1 __asm ("d1") = 16;
	register int_ reg_d2 __asm ("d2") = mode & 3;

	__asm __volatile ("moveq.l #__CONMOD,d0\n\t"
			  "trap #15"
			    : /* no outputs */
			    : "d" (reg_d1), "d" (reg_d2)
			    : "d0" );
    }
}

static __inline void _iocs_b_up (int_ num)
{
    register int_ reg_d1 __asm ("d1") = num;

    __asm __volatile ("moveq.l #__B_UP,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_b_up_s (void_)
{
    __asm __volatile ("moveq.l #__B_UP_S,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_b_wpoke (void *addr, int_ data)
{
    register void *reg_a1 __asm ("a1") = addr;
    register int_  reg_d1 __asm ("d1") = data;

    __asm __volatile ("moveq.l #__B_WPOKE,d0\n\t"
		      "trap #15"
			: "=m" (*(char *) addr)
			: "a" (reg_a1), "d" (reg_d1)
			: "d0", "a1");
}

static __inline void _iocs_cache_md (int_ mode)
{
    register int_ reg_d1 __asm ("d1") = 4;
    register int_ reg_d2 __asm ("d2") = mode;

    if (mode < 0) {
	if (mode == -1)
	    reg_d1 = 3;
	else if (mode == -2)
	    reg_d1 = 2;
	else
	    return;
    }

    __asm __volatile ("moveq.l #__SYS_STAT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_clipput (int_ x, int_ y, const struct _fntbuf *buf1,
				    const struct _clipxy *buf2)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register const struct _fntbuf *reg_a1 __asm ("a1") = buf1;
    register const struct _clipxy *reg_a2 __asm ("a2") = buf2;

    __asm __volatile ("moveq.l #__CLIPPUT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2), "a" (reg_a1), "a" (reg_a2)
			: "d0");
}

static __inline void _iocs_dayasc (int_ binday, char *addr)
{
    register int_  reg_d1 __asm ("d1") = binday;
    register char *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__DAYASC,d0\n\t"
		      "trap #15"
			: "=m" (*addr)
			: "d" (reg_d1), "a" (reg_a1)
			: "d0", "a1");
}

static __inline void _iocs_densns (void_)
{
    __asm __volatile ("moveq.l #__DENSNS,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_dmamove (void *addr1, void *addr2,
				    int_ mode, int_ cnt)
{
    register void *reg_a1 __asm ("a1") = addr1;
    register void *reg_a2 __asm ("a2") = addr2;
    register int_  reg_d1 __asm ("d1") = mode;
    register int_  reg_d2 __asm ("d2") = cnt;

    __asm __volatile ("moveq.l #__DMAMOVE,d0\n\t"
		      "trap #15"
			: "=m" (*(char *) addr1), "=m" (*(char *) addr2)
			: "a" (reg_a1), "a" (reg_a2), "d" (reg_d1), "d" (reg_d2)
			: "d0", "d2", "a1", "a2");
}

static __inline void _iocs_dmamov_a (const struct _chain *addr1, void *addr2,
				     int_ mode, int_ cnt)
{
    register const struct _chain *reg_a1 __asm ("a1") = addr1;
    register void *reg_a2 __asm ("a2") = addr2;
    register int_  reg_d1 __asm ("d1") = mode;
    register int_  reg_d2 __asm ("d2") = cnt;

    __asm __volatile ("moveq.l #__DMAMOV_A,d0\n\t"
		      "trap #15"
			: "=m" (*(char *) addr2)
			: "a" (reg_a1), "a" (reg_a2), "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_dmamov_l (const struct _chain2 *addr1, void *addr2,
				     int_ mode)
{
    register const struct _chain2 *reg_a1 __asm ("a1") = addr1;
    register void *reg_a2 __asm ("a2") = addr2;
    register int_  reg_d1 __asm ("d1") = mode;

    __asm __volatile ("moveq.l #__DMAMOV_L,d0\n\t"
		      "trap #15"
			: "=m" (*(char *) addr2)
			: "a" (reg_a1), "a" (reg_a2), "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_gbitput (int_ x, int_ y, const struct _fntbuf *buf)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register const struct _fntbuf *reg_a1 __asm ("a1") = buf;

    __asm __volatile ("moveq.l #__GBITPUT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2), "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_gbitput2 (int_ x, int_ y, int_ color,
					const struct _fntbuf *buf)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register int_ reg_d3 __asm ("d3") = color;
    register const struct _fntbuf *reg_a1 __asm ("a1") = buf;

    __asm __volatile ("moveq.l #__GBITPUT2,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3),
			  "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_gbitput3 (int_ x, int_ y, int_ x_ratio,
				int_ y_ratio, const struct _fntbuf *buf)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register int_ reg_d3 __asm ("d3") = x_ratio;
    register int_ reg_d4 __asm ("d4") = y_ratio;
    register const struct _fntbuf *reg_a1 __asm ("a1") = buf;

    __asm __volatile ("moveq.l #__GBITPUT3,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2),
			  "d" (reg_d3), "d" (reg_d4), "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_gcolor (int_ color)
{
    register int_ reg_d1 __asm ("d1") = color;

    __asm __volatile ("moveq.l #__GCOLOR,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_gv_get (int_ x, int_ y, struct _gvrambuf *buf)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register struct _gvrambuf *reg_a1 __asm ("a1") = buf;

    __asm __volatile ("moveq.l #__GV_GET,d0\n\t"
		      "trap #15"
			: "=m" (*buf)
			: "d" (reg_d1), "d" (reg_d2), "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_gv_put (int_ x, int_ y, const struct _gvrambuf *buf)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register const struct _gvrambuf *reg_a1 __asm ("a1") = buf;

    __asm __volatile ("moveq.l #__GV_PUT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2), "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_gv_put2 (int_ x, int_ y, int_ color,
					const struct _gvrambuf *buf)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register int_ reg_d3 __asm ("d3") = color;
    register const struct _gvrambuf *reg_a1 __asm ("a1") = buf;

    __asm __volatile ("moveq.l #__GV_PUT2,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3), "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_g_clr_on (void_)
{
    __asm __volatile ("moveq.l #__G_CLR_ON,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void __volatile _iocs_iplerr (void_)
{
    __asm __volatile ("moveq.l #__IPLERR,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_keydly (int_ delay)
{
    register int_ reg_d1 __asm ("d1") = delay;

    __asm __volatile ("moveq.l #__KEYDLY,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_keyrep (int_ rep)
{
    register int_ reg_d1 __asm ("d1") = rep;

    __asm __volatile ("moveq.l #__KEYREP,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_key_init (int_ led)
{
    register int_ reg_d1 __asm ("d1") = led;

    __asm __volatile ("moveq.l #__KEY_INIT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_ledctrl (int_ led)
{
    register int_ reg_d1 __asm ("d1") = led;

    __asm __volatile ("moveq.l #__LEDCTRL,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_ledmod (int_ code, int_ onoff)
{
    register int_ reg_d1 __asm ("d1") = code;
    register int_ reg_d2 __asm ("d2") = onoff;

    __asm __volatile ("moveq.l #__LEDMOD,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_ledset (void)
{
    __asm __volatile ("moveq.l #__LEDSET,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_ms_curof (void_)
{
    __asm __volatile ("moveq.l #__MS_CUROF,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_ms_curon (void_)
{
    __asm __volatile ("moveq.l #__MS_CURON,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_ms_init (void_)
{
    __asm __volatile ("moveq.l #__MS_INIT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_ms_patst (int_ no, const struct _patst *addr)
{
    register int_ reg_d1 __asm ("d1") = no;
    register const struct _patst *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__MS_PATST,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_ms_sel (int_ no)
{
    register int_ reg_d1 __asm ("d1") = no;

    __asm __volatile ("moveq.l #__MS_SEL,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_ms_sel2 (const short *addr)
{
    register const short *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__MS_SEL2,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_opmset (int_ addr, int_ data)
{
    register int_ reg_d1 __asm ("d1") = addr;
    register int_ reg_d2 __asm ("d2") = data;

    __asm __volatile ("moveq.l #__OPMSET,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2)
			: "d0", "d2");
}

static __inline void _iocs_opt2normal (void)
{
    __asm __volatile ("moveq.l #__OPT2NORMAL,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_opt2tvctrl (void)
{
    __asm __volatile ("moveq.l #__OPT2TVCTRL,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_os_curof (void_)
{
    __asm __volatile ("moveq.l #__OS_CUROF,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_os_curon (void_)
{
    __asm __volatile ("moveq.l #__OS_CURON,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_out232c (int_ code)
{
    register int_ reg_d1 __asm ("d1") = code;

    __asm __volatile ("moveq.l #__OUT232C,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_outlpt (int_ code)
{
    register int_ reg_d1 __asm ("d1") = code;

    __asm __volatile ("moveq.l #__OUTLPT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_outprn (int_ code)
{
    register int_ reg_d1 __asm ("d1") = code;

    __asm __volatile ("moveq.l #__OUTPRN,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0", "d1");
}

static __inline void _iocs_scroll (int_ mode, int_ x, int_ y)
{
    register int_ reg_d1 __asm ("d1") = mode;
    register int_ reg_d2 __asm ("d2") = x;
    register int_ reg_d3 __asm ("d3") = y;

    __asm __volatile ("moveq.l #__SCROLL,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3)
			: "d0");
}

static __inline void _iocs_setmsadr (void *addr, int_ cnt)
{
    register int_ reg_d1 __asm ("d1") = (int_) addr;
    register int_ reg_d2 __asm ("d2") = cnt;

    __asm __volatile ("moveq.l #__SETMSADR,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_set_beep (const char *buf, int_ size)
{
    register int_ reg_d1 __asm ("d1") = (int_) buf;
    register int_ reg_d2 __asm ("d2") = size;

    __asm __volatile ("moveq.l #__SET_BEEP,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2)
			: "d0");
}

static __inline void _iocs_set_prn (void *param)
{
    register void *reg_a1 __asm ("a1") = param;

    __asm __volatile ("moveq.l #__SET_PRN,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_skeyset (int_ key)
{
    register int_ reg_d1 __asm ("d1") = key;

    __asm __volatile ("moveq.l #__SKEYSET,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_sp_off (void_)
{
    __asm __volatile ("moveq.l #__SP_OFF,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: /* no inputs */
			: "d0");
}

static __inline void _iocs_tcolor (int_ color)
{
    register int_ reg_d1 __asm ("d1") = color;

    __asm __volatile ("moveq.l #__TCOLOR,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0", "d1");
}

static __inline void _iocs_textget (int_ x, int_ y, struct _fntbuf *buf)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register struct _fntbuf *reg_a1 __asm ("a1") = buf;

    __asm __volatile ("moveq.l #__TEXTGET,d0\n\t"
		      "trap #15"
			: "=m" (*buf)
			: "d" (reg_d1), "d" (reg_d2), "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_textput (int_ x, int_ y, const struct _fntbuf *buf)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register const struct _fntbuf *reg_a1 __asm ("a1") = buf;

    __asm __volatile ("moveq.l #__TEXTPUT,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2), "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_timeset (int_ bcdtime)
{
    register int_ reg_d1 __asm ("d1") = bcdtime;

    __asm __volatile ("moveq.l #__TIMESET,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0");
}

static __inline void _iocs_tvctrl (int_ code)
{
    register int_ reg_d1 __asm ("d1") = code;

    __asm __volatile ("moveq.l #__TVCTRL,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1)
			: "d0", "d1");
}

static __inline void _iocs_txbox (const struct _tboxptr *addr)
{
    register const struct _tboxptr *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__TXBOX,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_txfill (const struct _txfillptr *addr)
{
    register const struct _txfillptr *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__TXFILL,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_txline (const struct _tlineptr *addr)
{
    register const struct _tlineptr *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__TXLINE,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_txrascpy (int_ sor_dst, int_ copy, int_ mode)
{
    register int_ reg_d1 __asm ("d1") = sor_dst;
    register int_ reg_d2 __asm ("d2") = copy;
    register int_ reg_d3 __asm ("d3") = mode;

    __asm __volatile ("moveq.l #__TXRASCPY,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3)
			: "d0");
}

static __inline void _iocs_txrev (const struct _trevptr *addr)
{
    register const struct _trevptr *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__TXREV,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_txxline (const struct _xlineptr *addr)
{
    register const struct _xlineptr *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__TXXLINE,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_txyline (const struct _ylineptr *addr)
{
    register const struct _ylineptr *reg_a1 __asm ("a1") = addr;

    __asm __volatile ("moveq.l #__TXYLINE,d0\n\t"
		      "trap #15"
			: /* no outputs */
			: "a" (reg_a1)
			: "d0");
}

static __inline void _iocs_vramget (int_ x, int_ y, int_ rest,
					char *buf, const char *vram)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register int_ reg_d3 __asm ("d3") = rest;
    register char *reg_a1 __asm ("a1") = buf;
    register const char *reg_a2 __asm ("a2") = vram;

    __asm __volatile ("moveq.l #__VRAMGET,d0\n\t"
		      "trap #15"
			: "=m" (*buf)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3),
			  "a" (reg_a1), "a" (reg_a2)
			: "d0", "d1", "d2", "a1", "a2");
}

static __inline void _iocs_vramput (int_ x, int_ y, int_ rest,
					const char *buf, char *vram)
{
    register int_ reg_d1 __asm ("d1") = x;
    register int_ reg_d2 __asm ("d2") = y;
    register int_ reg_d3 __asm ("d3") = rest;
    register const char *reg_a1 __asm ("a1") = buf;
    register char *reg_a2 __asm ("a2") = vram;

    __asm __volatile ("moveq.l #__VRAMPUT,d0\n\t"
		      "trap #15"
			: "=m" (*vram)
			: "d" (reg_d1), "d" (reg_d2), "d" (reg_d3),
			  "a" (reg_a1), "a" (reg_a2)
			: "d0", "d1", "d2", "a1", "a2");
}

#endif
