/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id: $
 */

#ifndef __sys_math_i_h__
#define __sys_math_i_h__

#ifndef __cdecl_h__
#include <cdecl.h>
#endif

#ifndef __sys_xmath_h__
#include <sys/xmath.h>
#endif


#ifdef acos
#undef acos
#endif
#ifdef acosh
#undef acosh
#endif
#ifdef asin
#undef asin
#endif
#ifdef asinh
#undef asinh
#endif
#ifdef atan
#undef atan
#endif
#ifdef atan2
#undef atan2
#endif
#ifdef atanh
#undef atanh
#endif
#ifdef ceil
#undef ceil
#endif
#ifdef cos
#undef cos
#endif
#ifdef cosh
#undef cosh
#endif
#ifdef exp
#undef exp
#endif
#ifdef fabs
#undef fabs
#endif
#ifdef floor
#undef floor
#endif
#ifdef fmod
#undef fmod
#endif
#ifdef ldexp
#undef ldexp
#endif
#ifdef log
#undef log
#endif
#ifdef log10
#undef log10
#endif
#ifdef pow
#undef pow
#endif
#ifdef sin
#undef sin
#endif
#ifdef sinh
#undef sinh
#endif
#ifdef sqrt
#undef sqrt
#endif
#ifdef tan
#undef tan
#endif
#ifdef tanh
#undef tanh
#endif
#ifdef frexp
#undef frexp
#endif
#ifdef modf
#undef modf
#endif
#ifdef isinf
#undef isinf
#endif
#ifdef isnan
#undef isnan
#endif

#define acos(x)		__inline_acos (x)
#define acosh(x)	__inline_acosh (x)
#define asin(x)		__inline_asin (x)
#define asinh(x)	__inline_asinh (x)
#define atan(x)		__inline_atan (x)
#define atan2(y ,x)	__inline_atan2 (y, x)
#define atanh(x)	__inline_atanh (x)
#define ceil(x)		__inline_ceil (x)
#define cos(x)		__inline_cos (x)
#define cosh(x)		__inline_cosh (x)
#define exp(x)		__inline_exp (x)
#define fabs(x)		__inline_fabs (x)
#define floor(x)	__inline_floor (x)
#define fmod(x, y)	__inline_fmod (x, y)
#define ldexp(x, exp)	__inline_ldexp (x, exp)
#define log(x)		__inline_log (x)
#define log10(x)	__inline_log10 (x)
#define pow(x, y)	__inline_pow (x, y)
#define sin(x)		__inline_sin (x)
#define sinh(x)		__inline_sinh (x)
#define sqrt(x)		__inline_sqrt (x)
#define tan(x)		__inline_tan (x)
#define tanh(x)		__inline_tanh (x)
#define frexp(x, exp)	__inline_frexp (x, exp)
#define modf(x, iptr)	__inline_modf (x, iptr)
#define isinf(x)	__inline_isinf (x)
#define isnan(x)	__inline_isnan (x)


static __inline __const double __inline_acos (double);
static __inline __const double __inline_acosh (double);
static __inline __const double __inline_asin (double);
static __inline __const double __inline_asinh (double);
static __inline __const double __inline_atan (double);
static __inline __const double __inline_atan2 (double, double);
static __inline __const double __inline_atanh (double);
static __inline __const double __inline_ceil (double);
static __inline __const double __inline_cos (double);
static __inline __const double __inline_cosh (double);
static __inline __const double __inline_exp (double);
static __inline __const double __inline_fabs (double);
static __inline __const double __inline_floor (double);
static __inline __const double __inline_fmod (double, double);
static __inline __const double __inline_ldexp (double, int_);
static __inline __const double __inline_log (double);
static __inline __const double __inline_log10 (double);
static __inline __const double __inline_pow (double, double);
static __inline __const double __inline_sin (double);
static __inline __const double __inline_sinh (double);
static __inline __const double __inline_sqrt (double);
static __inline __const double __inline_tan (double);
static __inline __const double __inline_tanh (double);
static __inline double __inline_frexp (double, int_*);
static __inline double __inline_modf (double, double*);
static __inline __const int_ __inline_isinf (double);
static __inline __const int_ __inline_isnan (double);


/*
** If you want to use other inline headers, please add your selection
** mechanism here...
*/

#if defined (__MC68020__) && defined (__HAVE68881__)
#include <sys/math_f.h>
#else
#include <sys/math_fe.h>
#endif

#endif
