/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id: termios.h,v 1.2 1993/10/06 16:45:14 mura Exp $
 */

/*
** PLEASE DO NOT USE THIS HEADER FILE !!!
** ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
** The following features will be supported in the long long
** future,  but not supprted now.   If you want to use these
** features, please make the following interfaces, and contribute
** them to us.
*/

#ifndef __termios_h__
#define __termios_h__

#ifndef __cdecl_h__
#include <cdecl.h>
#endif

#define VEOF		0	/* ICANON */
#define VEOL		1	/* ICANON */
#define VEOL2		2	/* ICANON together with IEXTEN */
#define VERASE		3	/* ICANON */
#define VWERASE		4	/* ICANON together with IEXTEN */
#define VKILL		5	/* ICANON */
#define VREPRINT	6	/* ICANON together with IEXTEN */
				/* spare 1 */
#define VINTR		8	/* ISIG */
#define VQUIT		9	/* ISIG */
#define VSUSP		10	/* ISIG */
#define VDSUSP		11	/* ISIG together with IEXTEN */
#define VSTART		12	/* IXON, IXOFF */
#define VSTOP		13	/* IXON, IXOFF */
#define VLNEXT		14	/* IEXTEN */
#define VDISCARD	15	/* IEXTEN */
#define VMIN		16	/* !ICANON */
#define VTIME		17	/* !ICANON */
#define VSTATUS		18	/* ICANON together with IEXTEN */
				/* spare 2 */
#define NCCS		20

typedef long speed_t;
typedef unsigned char cc_t;
typedef unsigned long tcflag_t;

struct termios {
    tcflag_t c_iflag;		/* input flags */
    tcflag_t c_oflag;		/* output flags */
    tcflag_t c_cflag;		/* control flags */
    tcflag_t c_lflag;		/* local flags */
    cc_t c_cc[NCCS];		/* control chars */
    tcflag_t c_ispeed;		/* input speed */
    tcflag_t c_ospeed;		/* output speed */
};

#define IGNBRK	0x00000001	/* ignore BREAK condition */
#define BRKINT	0x00000002	/* map BREAK to SIGINTR */
#define IGNPAR	0x00000004	/* ignore (discard) parity errors */
#define PARMRK	0x00000008	/* mark parity and framing errors */
#define INPCK	0x00000010	/* enable checking of parity errors */
#define ISTRIP	0x00000020	/* strip 8th bit off chars */
#define INLCR	0x00000040	/* map NL into CR */
#define IGNCR	0x00000080	/* ignore CR */
#define ICRNL	0x00000100	/* map CR to NL (ala CRMOD) */
#define IXON	0x00000200	/* enable output flow control */
#define IXOFF	0x00000400	/* enable input flow control */
#define IXANY	0x00000800	/* any char will restart after stop */
#define IUCLC	0x00001000	/* upper character to lower character */
#define IMAXBEL	0x00002000	/* ring bell on input queue full */

#define OPOST	0x00000001	/* enable following output processing */
#define OLCUC	0x00000002
#define ONLCR	0x00000004	/* map NL to CR-NL (ala CRMOD) */
#define OCRNL	0x00000008
#define ONOEOT	0x00000010	/* discard EOT's (^D) on output) */
#define ONOCR	0x00000020
#define ONLRET	0x00000040
#define OFILL	0x00000080
#define OFDEL	0x00000100

#define NL0	0x00000100
#define NL1	0x00000200
#define NLDLY	0x00000300
#define TAB0	0x00000000
#define TAB1	0x00000400
#define TAB2	0x00000800
#define TAB3	0x00001000
#define OXTABS	0x00000c00	/* expand tabs to spaces */
#define TABDLY	0x00001c00
#define CR0	0x00000000
#define CR1	0x00020000
#define CR2	0x00040000
#define CR3	0x00080000
#define CRDLY	0x000e0000
#define BS0	0x00000000
#define BS1	0x00800000
#define BSDLY	0x00800000
#define VT0	0x00000000
#define VT1	0x01000000
#define VTDLY	0x01000000
#define FF0	0x00000000
#define FF1	0x02000000
#define FFDLY	0x02000000

#define CIGNORE	0x00000001	/* ignore control flags */
#define CSIZE	0x00000300	/* character size mask */
#define CS5	0x00000000		/* 5 bits (pseudo) */
#define CS6	0x00000100		/* 6 bits */
#define CS7	0x00000200		/* 7 bits */
#define CS8	0x00000300		/* 8 bits */
#define CSTOPB	0x00000400	/* send 2 stop bits */
#define CREAD	0x00000800	/* enable receiver */
#define PARENB	0x00001000	/* parity enable */
#define PARODD	0x00002000	/* odd parity, else even */
#define HUPCL	0x00004000	/* hang up on last close */
#define CLOCAL	0x00008000	/* ignore modem status lines */
#define CRTSCTS	0x00010000	/* RTS/CTS full-duplex flow control */
#define MDMBUF	0x00100000	/* DTR/DCD hardware flow control */
#define CHWFLOW	(MDMBUF | CRTSCTS) /* all types of hw flow control */
#define CRTS_IFLOW CRTSCTS	/* XXX compat */
#define CCTS_OFLOW CRTSCTS	/* XXX compat */

#define ECHOKE		0x00000001	/* visual erase for line kill */
#define ECHOE		0x00000002	/* visually erase chars */
#define ECHOK		0x00000004	/* echo NL after line kill */
#define ECHO		0x00000008	/* enable echoing */
#define ECHONL		0x00000010	/* echo NL even if ECHO is off */
#define ECHOPRT		0x00000020	/* visual erase mode for hardcopy */
#define ECHOCTL		0x00000040	/* echo control chars as ^(Char) */
#define ISIG		0x00000080	/* enable signals INTR, QUIT, [D]SUSP */
#define ICANON		0x00000100	/* canonicalize input lines */
#define ALTWERASE	0x00000200	/* use alternate WERASE algorithm */
#define IEXTEN		0x00000400	/* enable DISCARD and LNEXT */
#define EXTPROC		0x00000800	/* external processing */
#define XCASE		0x00100000
#define TOSTOP		0x00400000	/* stop background jobs from output */
#define FLUSHO		0x00800000	/* output being flushed (state) */
#define NOKERNINFO	0x02000000	/* no kernel output from VSTATUS */
#define PENDIN		0x20000000	/* XXX retype pending input (state) */
#define NOFLSH		0x80000000	/* don't flush after interrupt */

#define B0	0
#define B50	50
#define B75	75
#define B110	110
#define B134	134
#define B150	150
#define B200	200
#define B300	300
#define B600	600
#define B1200	1200
#define B1800	1800
#define B2400	2400
#define B4800	4800
#define B7200	7200
#define B9600	9600
#define B14400	14400
#define B19200	19200
#define B28800	28800
#define B38400	38400
#define B57600	57600
#define B115200	115200
#define B230400	230400
#define EXTA	19200
#define EXTB	38400

#define TCSANOW   0		/* make change immediate */
#define TCSADRAIN 1		/* drain output, then change */
#define TCSAFLUSH 2		/* drain output, flush input */
#define TCSASOFT  0x10		/* flag - don't alter h.w. state */

#define TCIFLUSH  1
#define TCOFLUSH  2
#define TCIOFLUSH (TCIFLUSH | TCOFLUSH)

#define TCOOFF 1
#define TCOON  2
#define TCIOFF 3
#define TCION  4

#ifndef _POSIX_VDISABLE
#define _POSIX_VDISABLE		((unsigned char) 0xff)
#endif

#define CCEQ(val, c) ((val) == (c) && (val) != _POSIX_VDISABLE)
#include <sys/ttydefaults.h>

_EXTERN (int_ cfsetispeed (struct termios *, speed_t));
_EXTERN (int_ cfsetospeed (struct termios *, speed_t));
_EXTERN (int_ tcdrain (int_));
_EXTERN (int_ tcflow (int_, int_));
_EXTERN (int_ tcflush (int_, int_));
_EXTERN (int_ tcgetattr (int_, struct termios *));
_EXTERN (int_ tcsendbreak (int_, int_));
_EXTERN (int_ tcsetattr (int_, int_, const struct termios *));
_EXTERN (speed_t cfgetispeed (const struct termios *));
_EXTERN (speed_t cfgetospeed (const struct termios *));
_EXTERN (void cfmakeraw (struct termios *));
_EXTERN (void cfsetspeed (struct termios *, speed_t));

#endif
