/*
 *		EChECu
 *
 *			Copyright	T.Kobayashi
 *			1990.6.30
 */

/*: v2.24+14 :*/

#ifndef	TRUE
# define	TRUE	1
# define	FALSE	0
# define	ON		TRUE
# define	OFF		FALSE
#endif
#ifndef	NULL
# define	NULL	((void*)0)
#endif

/*
 *		`IvV
 */

#ifndef	AttrDefault
# define	ColorBlack		0
# define	ColorGray		1
# define	ColorGraphic	2
# define	ColorWhite		3
# define	AttrDefault		9
# define	AttrHighLight	4
# define	AttrReverse		8
# define	AttrMesh		16
# define	AttrWhiteRev	32
# define	AttrUnderLine	64
# define	AttrMesh2		128
# define	OptionXor		0x10
	typedef	enum {
			OptionLine,
			OptionBox,
			OptionFill,
			OptionShadow
		} SheetOption;
# define	ShadowUp	0
# define	ShadowDown	1
	typedef struct {
			int			h, v, hword;		/*	傫					*/
			unsigned short	*buf1;			/*	obt@ւ̃|C^	*/
			unsigned short	*buf2;			/*	obt@ւ̃|C^	*/
		} Sheet;
	typedef	char	DrawBuf[28];
#endif


#ifndef	_WLIB_

#define	_WLIB_

/*
 *		EChEhc
 */
typedef	char	*WindowID;

/*
 *		萔
 */
#define	WindowAttrTra			1	/* 					*/
#define	WindowAttrInvisible		2	/* s				*/
#define	WindowAttrGraphic		4	/* OtBbNgp()	*/
#define	WindowAttrGraphic16		4	/* 16F[h				*/
#define	WindowAttrGraphic256	8	/* 256F[h				*/
#define	WindowAttrGraphic65536	12	/* 65536F[h			*/
#define	WindowAttrGraphicS256	16	/* Single 256x2(gp`)	*/
#define	WindowAttrGraphicS16X4	20	/* Single 16x4 (V)			*/
#define	WindowAttrGraphicS16	24	/* Single 16x1 (V)			*/
#define	WindowAttrGraphicS65536	28	/* Single 65536(V)			*/
#define	WindowAttrGraphicUse	28	/* OtBbNgp		*/
#define	Close					1	/* N[Y{bNX			*/
#define	Push					2	/* vbV{bNX			*/
#define	Icon					4	/* ACR{bNX		*/
#define	Resize					8	/* TCY{bNX			*/
#define	Zoom					16	/* Y[{bNX			*/
#define	DirectionX				1	/* wXN[			*/
#define	DirectionY				2	/* xXN[			*/
#define	OffsetDefaultLevel		4	/* ItZbgύXx		*/
#define	OffsetManagerLevel		8	/* ItZbgύXx		*/

/*  t@NVL[̓R[h  */
#define	FuncKey			0x8000
#define	FuncKeyF(key)	(0x8000+(key))		/* F1`F20 */
#define	FuncKeyRollUp	0x8015
#define	FuncKeyRollDown	0x8016
#define	FuncKeyIns		0x8017
#define	FuncKeyDel		0x8018
#define	FuncKeyUp		0x8019
#define	FuncKeyLeft		0x801A
#define	FuncKeyRight	0x801B
#define	FuncKeyDown		0x801C
#define	FuncKeyClr		0x801D
#define	FuncKeyHelp		0x801E
#define	FuncKeyHome		0x801F
#define	FuncKeyUnDo		0x8020



/*
 *		Cxg
 */
#define	EventAttrDefault	(EventOpenON | EventRedrawON | EventCloseON | 	\
							EventResizeON | EventIconifyON | EventZoomON |	\
							EventMouseSwitchON | EventMouseEnterON |		\
							EventMouseOutON | EventKeyON					)

#define	EventOpenON			(1<<EventOpen)
#define	EventRedrawON		(1<<EventRedraw)
#define	EventCloseON		(1<<EventClose)
#define	EventPopON			(1<<EventPop)
#define	EventPushON			(1<<EventPush)
#define	EventMoveON			(1<<EventMove)
#define	EventResizeON		(1<<EventResize)
#define	EventIconifyON		(1<<EventIconify)
#define	EventZoomON			(1<<EventZoom)
#define	EventScrollON		(1<<EventScroll)
#define	EventMouseSwitchON	(1<<EventMouseSwitch)
#define	EventMouseMoveON	(1<<EventMouseMove)
#define	EventMouseEnterON	(1<<EventMouseEnter)
#define	EventMouseOutON		(1<<EventMouseOut)
#define	EventKeyON			(1<<EventKey)
#define	EventIntervalON		(1<<EventInterval)
#define	EventNonON			(1<<EventNon)
#define	EventUserON			(1<<EventUser)
#define	EventGraphicON		(1<<EventGraphic)

typedef	enum {
		EventOpen,
		EventRedraw,
		EventClose,
		EventPop,
		EventPush,
		EventMove,
		EventResize,
		EventIconify,
		EventZoom,
		EventScroll,
		EventMouseSwitch,
		EventMouseMove,
		EventMouseEnter,
		EventMouseOut,
		EventKey,
		EventInterval,
		EventNon,
		EventUser,
		EventGraphic,
	} EventOption;

typedef	struct	{
		EventOption	option ;
		int			x, y, h, v ;
		int			RightStat, LeftStat ;
		int			LeftON, LeftOFF ;
		int			RightON, RightOFF ;
		int			MoveFlag ;
		int			KeyCode ;
		int			ShiftStat ;
		int			Counter ;
		int			ComData ;
		void		*ComBuffer ;
	} EventInfo;

/*
 *		[UCxg̎
 */
typedef	enum {
		UserPaste,
		UserString,
		UserStrings,
		UserSheet,
		UserGraphic= 5,
	}
		UserEventOption ;

/*
 *		VOi
 */
typedef	enum {
		SignalOpen,
		SignalKill,
		SignalChildKill,
	}
		SignalCode ;

/*
 *		vZX
 */
typedef	struct	{
		char	*Entry ;
		int		Status ;
		int		Parent ;
		char	*PSP ;
		int		Level ;
		int		HeapSize ;
		char	*Heap ;
		char	*SignalEntry ;
	}
		ProcessInfo ;

/*
 *		ϐ
 */
#ifndef	WLIB
	extern	WindowID	WindowRootID ;
	extern	Sheet		*WindowBackPattern ;
	extern	int			WindowProcessID ;
#endif

/*
	proto -e wlib.c > temp
	proto -e draw.c > temp
	proto -e winop.c > temp
	proto -e winget.c > temp
	proto -e winman.c > temp
	proto -e wgraph.c > temp
*/
extern	int		WindowConnectionClose( void );
extern	int		WindowLoadExec( char*, char*, char*, void(*)() );
extern	char	*WindowGetVersion( void );
extern	void	WindowSetSignal( int(*)() );
extern	int		WindowSendSignal( int, int, void* );
extern	ProcessInfo	*WindowGetProcessInfo( int );
extern	int		WindowSetParameter( int, int, void* );

extern	void	DrawSetClear( DrawBuf*, int );
extern	void	DrawSetLine( DrawBuf*, int, int, int, int, int, int );
extern	void	DrawSetPut( DrawBuf*, int, int, void* );
extern	void	DrawSetSymbol( DrawBuf*, int, int, char*, int, int );
extern	void	DrawSetPattern( DrawBuf*, void* );
extern	void	DrawSetGraphicClear( DrawBuf*, int );
extern	void	DrawSetGraphicLine( DrawBuf*, int, int, int, int, int, int );
extern	void	DrawSetGraphicPut( DrawBuf*, int, int, int, int, short* );

/*	1992 by M.Tatsumi (UQ), H.Ogasawara (COR.) */
extern 	void	DrawSetDot( DrawBuf*, int, int, int );
extern 	void	DrawSetGraphicDot( DrawBuf*, int, int, int );
extern 	void	DrawSetCircle( DrawBuf*, int, int, int, int, int, int );
extern 	void	DrawSetGraphicCircle( DrawBuf*, int, int, int, int, int, int );

extern	WindowID	WindowOpen( int, int, int, int, WindowID, int(*)() );
extern	WindowID	WindowSimpleOpen( int, int, int, int, WindowID, int(*)() );
extern	WindowID	WindowTitleOpen( int, int, int, int, WindowID, char*, int, int(*)() );
extern	WindowID	WindowScrollOpen( int, int, int, int, WindowID, int, int, int, int, int, int(*)() );
extern	void	WindowClose( WindowID );
extern	void	WindowPop( WindowID );
extern	void	WindowPush( WindowID );
extern	void	WindowRedraw( WindowID );
extern	void	WindowMove( WindowID, int, int );
extern	void	WindowResize( WindowID, int, int, int, int );
extern	void	WindowScroll( WindowID, int, int );
extern	void	WindowDrawAbs( WindowID, void*, int );
extern	void	WindowDraw( WindowID, void*, int );
extern	int		WindowSendEvent( WindowID, void* );
extern	int		WindowSendEventAll( int, void* );

extern	void	WindowSetHome( WindowID, int, int );
extern	void	WindowSetAttr( WindowID, int );
extern	void	WindowSetEventAttr( WindowID, int );
extern	void	WindowSetClientData( WindowID, int, void* );
extern	int		WindowGetEventAttr( WindowID );
extern	void	WindowGetSize( WindowID, int*, int* );
extern	int		WindowInner( WindowID, int, int );
extern	int		WindowGetClientData( WindowID );
extern	void	*WindowGetClientPointer( WindowID );
extern	void	WindowGetPosition( WindowID, int*, int* );
extern	void	WindowGetViewPosition( WindowID, int*, int* );
extern	void	WindowGetScreenPosition( WindowID, int*, int* );
extern	void	WindowGetViewSize( WindowID, int*, int* );
extern	void	WindowGetHome( WindowID, int*, int* );
extern	WindowID	WindowGetParent( WindowID );
extern	WindowID	WindowGetNext( WindowID );
extern	WindowID	WindowGetLast( WindowID );
extern	WindowID	WindowGetChildTop( WindowID );
extern	WindowID	WindowGetChildBottom( WindowID );
extern	WindowID	WindowGetChild( WindowID, void* );

extern	void	WindowScreenInit( void );
extern	void	WindowRootScroll( int, int );
extern	void	WindowGetRootScroll( int*, int* );
extern	void	WindowScreenQuit( void );
extern	void	WindowSetPalet( int, int );
extern	void	WindowSetRootEvent( int(*)() );
extern	void	WindowSetBackPattern( void* );
extern	void	WindowSetFocus( WindowID );
extern	int		WindowGetEventInfo( void* );
extern	int		WindowCheckEventInfo( void* );
extern	void	WindowMouseCursor( int );
extern	void	*WindowGetCommon( char*, int );
extern	int		WindowResetCommon( char* );
extern	int		WindowMoveOperation( WindowID, void* );
extern	int		WindowResizeOperation( WindowID, void* );
extern	void	*WindowGetResource( char*, char*, char* );
extern	void	WindowReadResource( void );
extern	void	WindowReadRC( void );
extern	void	*WindowMemoryAlloc( int );
extern	void	WindowMemoryFree( void* );

extern	void	WindowSetGraphicMode( int );
extern	int		WindowGetGraphicMode( void );
extern	int		WindowPaletInit( void );

/* 1991-1995 wsrv2.24+7`+14 by H.Ogasawara(COR.) */
extern	void	*WindowSetFontAddress( int, void* );
extern	void	*WindowGetFontAddress( int );
extern	int		WindowSetScreenMode( int );
extern	int		WindowGetScreenMode();
extern	int		WindowGetScreenSize( int*, int* );
extern	int		WindowGetAttr( WindowID );
extern	void	*WindowSetHenDsp( void* );
extern	int		WindowSetGraphicOffset( int, int, int );
extern	void	WindowGetGraphicOffset( int*, int* );
extern	void	*WindowSetManagerExec( int, int, void* );
#define			WindowGetScreenTable(mode)	((unsigned short*)	\
										WindowSetScreenMode((mode)+256))

/* ŏIXV 1995/12/01 H.Ogasawara (COR.) */
#endif

/* :vi:se ts=4 sw=4: */
