/*
 * doslib.h X68k XC Compiler v2.11 Copyright 1990,91,92,93 SHARP/Hudson
 */
#ifndef	__DOSLIB_H
#define	__DOSLIB_H

#include	<class.h>

#ifdef	FORWORD
#define	__PROTO_TYPE
#endif
#ifdef	__STDC__
#define	__PROTO_TYPE
#endif

struct	PDBADR	{
	UINT	env;
	UINT	exit;
	UINT	ctrlc;
	UINT	errexit;
	UINT	comline;
	UBYTE	handle[12];
	UINT	bss;
	UINT	heep;
	UINT	stack;
	UINT	usp;
	UINT	ssp;
	UWORD	sr;
	UWORD	abort_sr;
	UINT	abort_ssp;
	UINT	trap10;
	UINT	trap11;
	UINT	trap12;
	UINT	trap13;
	UINT	trap14;
	UINT	osflg;
	UBYTE	reserve[28];
	UBYTE	exe_path[68];
	UBYTE	exe_name[24];
};

struct	INPPTR	{
	UBYTE	max;
	UBYTE	length;
	UBYTE	buffer[256];
};

struct	COMLINE	{
	UBYTE	len;
	UBYTE	buffer[255];
};

struct	NAMESTBUF	{
	UBYTE	flg;
	UBYTE	drive;
	UBYTE	path[65];
	UBYTE	name1[8];
	UBYTE	ext[3];
	UBYTE	name2[10];
};

struct	FREEINF	{
	UWORD	free;
	UWORD	max;
	UWORD	sec;
	UWORD	byte;
};

struct	NAMECKBUF	{
	UBYTE	drive[2];
	UBYTE	path[65];
	UBYTE	name[19];
	UBYTE	ext[5];
};

struct	DPBPTR	{
	UBYTE	drive;
	UBYTE	unit;
	UWORD	byte;
	UBYTE	sec;
	UBYTE	shift;
	UWORD	fatsec;
	UBYTE	fatcount;
	UBYTE	fatlen;
	UWORD	dircount;
	UWORD	datasec;
	UWORD	maxfat;
	UWORD	dirsec;
	INT	driver;
	UBYTE	id;
	UBYTE	flg;
	struct	DPBPTR	*next;
	UWORD	dirfat;
	UBYTE	dirbuf[64];
};

struct	FILBUF	{
	UBYTE	os[21];
	UBYTE	atr;
	UWORD	time;
	UWORD	date;
	UINT	filelen;
	UBYTE	name[23];
};

struct	EXFILBUF {
	UBYTE	os[21];
	UBYTE	atr;
	UWORD	time;
	UWORD	date;
	UINT	filelen;
	UBYTE	name[23];
	UBYTE   drive[2];
	UBYTE	path[65];
	UBYTE	exos[21];
};

struct	DREGS	{
	int	d0;
	int	d1;
	int	d2;
	int	d3;
	int	d4;
	int	d5;
	int	d6;
	int	d7;
	int	a0;
	int	a1;
	int	a2;
	int	a3;
	int	a4;
	int	a5;
	int	a6;
};

struct	PRCCTRL	{
	long	length;
	UBYTE	*buf_ptr;
	UWORD	command;
	UWORD	your_id;
};

struct	PRCPTR	{
	struct	PRCPTR	*next_ptr;
	UBYTE	wait_flg;
	UBYTE	counter;
	UBYTE	max_counter;
	UBYTE	doscmd;
	UINT	psp_id;
	UINT	usp_reg;
	UINT	d_reg[8];
	UINT	a_reg[7];
	UWORD	sr_reg;
	UINT	pc_reg;
	UINT	ssp_reg;
	UWORD	indosf;
	UINT	indosp;
	struct	PRCCTRL	*buf_ptr;
	UBYTE	name[16];
	long	wait_time;
};

struct	FCBS	{
	UBYTE	hnd_cnt; /* handle use count */
	UBYTE	dev_type; /* bit 7=0..file                  1..CHAR I/O  */
			  /* bit 6=write_flg               |   input_EOF */
			  /* bit 5=special_drive           |   raw_mode  */
			  /* bit 4~0  drive no(a=0)        |bit 3~0 =clock,null,stdout,stdin */
	UBYTE * dev_adr; /* or dpb_adr */
	UBYTE os_work[30];
	UBYTE name1[8];
	UBYTE ext[3];
	UBYTE atr;
	UBYTE name2[10];
	UWORD time;
	UWORD date;
	UWORD start_fat;
	long file_len;
	UBYTE os_work2[28];
};

struct	OSDPBPTR {
	UBYTE	drive;
	UBYTE	unit;
	INT	driver;
	struct	DPBPTR	*next;
	UWORD	byte;
	UBYTE	sec;
	UBYTE	shift;
	UWORD	fatsec;
	UBYTE	fatcount;
	UBYTE	fatlen;
	UWORD	dircount;
	UWORD	datasec;
	UWORD	maxfat;
	UWORD	dirsec;
	UBYTE	id;
	UBYTE	sect_sft;
	UWORD	new_fat;
	UBYTE	resv[26];
};

#define BREAKCK_CHECK	-1
#define BREAKCK_KILL	2
#define BREAKCK_ON	1
#define BREAKCK_OFF	0
#define CTRL_C_CHECK	0x01ff
#define CTRL_C_ON	0x0101
#define CTRL_C_OFF	0x0100
#define CTRL_N_CHECK	0x02ff
#define CTRL_N_ON	0x0201
#define CTRL_N_OFF	0x0200
#define CTRL_P_CHECK	0x03ff
#define CTRL_P_ON	0x0301
#define CTRL_P_OFF	0x0300
#define CTRL_Q_CHECK	0x04ff
#define CTRL_Q_ON	0x0401
#define CTRL_Q_OFF	0x0400
#define CTRL_S_CHECK	0x05ff
#define CTRL_S_ON	0x0501
#define CTRL_S_OFF	0x0500

#ifdef	__PROTO_TYPE

void	EXIT(void);
int	GETCHAR(void);
void	PUTCHAR(int);
int	COMINP(void);
void	COMOUT(int);
void	PRNOUT(int);
int	INPOUT(int);
int	INKEY(void);
int	GETC(void);
void	PRINT(UBYTE *);
int	GETS(struct INPPTR *);
int	KEYSNS(void);

int	KFLUSHGP(void);
int	KFLUSHIO(int);
int	KFLUSHIN(void);
int	KFLUSHGC(void);
int	KFLUSHGS(struct INPPTR *);

void	FFLUSH(void);
int	CHGDRV(int);
int	DRVCTRL(int, int);
int	CONSNS(void);
int	PRNSNS(void);
int	CINSNS(void);
int	COUTSNS(void);

int	FATCHK(UBYTE *, UWORD *);
int	FATCHK2(UBYTE *, UWORD *, int);

int	HENDSPMO(void);
int	HENDSPMP(int, UBYTE *);
int	HENDSPMR(int, UBYTE *);
void	HENDSPMC(void);
int	HENDSPIO(void);
int	HENDSPIP(int, UBYTE *);
int	HENDSPIR(int, UBYTE *);
void	HENDSPIC(int);
int	HENDSPSO(void);
int	HENDSPSP(int, UBYTE *);
int	HENDSPSR(int, UBYTE *);
void	HENDSPSC(void);

int	CURDRV(void);
int	GETSS(struct INPPTR *);
int	FGETC(int);
int	FGETS(struct INPPTR *, int);
void	FPUTC(int, int);
void	FPUTS(UBYTE *, int);
void	ALLCLOSE(void);
int	SUPER(int);

void	FNCKEYGT(int, UBYTE *);
void	FNCKEYST(int, UBYTE *);

int	C_PUTC(int);
int	C_PRINT(UBYTE *);
int	C_COLOR(int);
int	C_LOCATE(int, int);
int	C_DOWN_S(void);
int	C_UP_S(void);
int	C_UP(int);
int	C_DOWN(int);
int	C_RIGHT(int);
int	C_LEFT(int);
int	C_CLS_ED(void);
int	C_CLS_ST(void);
int	C_CLS_AL(void);
int	C_ERA_ED(void);
int	C_ERA_ST(void);
int	C_ERA_AL(void);
int	C_INS(int);
int	C_DEL(int);
int	C_FNKMOD(int);
int	C_WINDOW(int, int);
int	C_WIDTH(int);
int	C_CURON(void);
int	C_CUROFF(void);

int	K_KEYINP(void);
int	K_KEYSNS(void);
int	K_SFTSNS(void);
int	K_KEYBIT(int);
void	K_INSMOD(int);

int	INTVCS(int, char *);
void	PSPSET(struct PDBADR *);
int	GETTIM2(void);
int	SETTIM2(int);
int	NAMESTS(UBYTE *, struct NAMESTBUF *);
int	GETDATE(void);
int	SETDATE(int);
int	GETTIME(void);
int	SETTIME(int);
void	VERIFY(int);
int	DUP0(int, int);
int	VERNUM(void);
void	KEEPPR(int, int);
int	GETDPB(int, struct DPBPTR *);
int	BREAKCK(int);
void	DRVXCHG(int, int);
int	INTVCG(int);
int	DSKFRE(int, struct FREEINF *);
int	NAMECK(UBYTE *, struct NAMECKBUF *);
int	MKDIR(UBYTE *);
int	RMDIR(UBYTE *);
int	CHDIR(UBYTE *);
int	CREATE(UBYTE *, int);
int	OPEN(UBYTE *, int);
int	CLOSE(int);
int	READ(int, UBYTE *, int);
int	WRITE(int, UBYTE *, int);
int	DELETE(UBYTE *);
int	SEEK(int, int, int);
int	CHMOD(UBYTE *, int);

int	IOCTRLGT(int);
int	IOCTRLST(int, int);
int	IOCTRLRH(int, UBYTE *, int);
int	IOCTRLWH(int, UBYTE *, int);
int	IOCTRLRD(int, UBYTE *, int);
int	IOCTRLWD(int, UBYTE *, int);
int	IOCTRLIS(int);
int	IOCTRLOS(int);
int	IOCTRLDVGT(int);
int	IOCTRLFDGT(int);
int	IOCTRLRTSET(int, int);
int	IOCTRLDVCTL(int, int, UBYTE *);
int	IOCTRLFDCTL(int, int, UBYTE *);

int	DUP(int);
int	DUP2(int,int);
int	CURDIR(int, UBYTE *);
int	MALLOC(int);
int	MFREE(int);
int	SETBLOCK(int, int);

int	LOADEXEC(UBYTE *, struct COMLINE *, UBYTE *);
int	LOAD(UBYTE *, struct COMLINE *, UBYTE *);
int	PATHCHK(UBYTE *, struct COMLINE *, UBYTE *);
int	LOADONLY(UBYTE *, UBYTE *, UBYTE *);
int	EXECONLY(int);
int	BINDNO(UBYTE *, UBYTE *);
int	EXEC2(int, UBYTE *, UBYTE *, UBYTE **);

void	EXIT2(int);
int	WAIT(void);
int	FILES(struct FILBUF *, UBYTE *, int);
int	EXFILES(struct EXFILBUF *, UBYTE *, int);
int	NFILES(struct FILBUF *);
int	EXNFILES(struct EXFILBUF *);
int	SETPDB(struct PDBADR *);
struct	PDBADR	*GETPDB(void);
int	SETENV(UBYTE *, UBYTE *, UBYTE *);
int	GETENV(UBYTE *, UBYTE *, UBYTE *);
int	VERIFYG(void);

int	COMMON_CK(UBYTE *);
int	COMMON_RD(UBYTE *, int, UBYTE *, int);
int	COMMON_WT(UBYTE *, int, UBYTE *, int);
int	COMMON_LK(UBYTE *, int, int, int);
int	COMMON_FRE(UBYTE *, int, int, int);
int	COMMON_DEL(UBYTE *);

int	MOVE(UBYTE *, UBYTE *);
int	RENAME(UBYTE *, UBYTE *);

int	FILEDATE(int, int);
int	MALLOC2(int, int);
int	MALLOC0(int, int, int);
int	MAKETMP(UBYTE *, int);
int	NEWFILE(UBYTE *, int);

int	LOCK(int, int, int);
int	UNLOCK(int, int, int);

int	MAKEASSIGN(UBYTE *, UBYTE *, int);
int	GETASSIGN(UBYTE *, UBYTE *);
int	RASSIGN(UBYTE *);

int	FFLUSH_SET(int);
int	OS_PATCH(int,char *);
struct FCBS *  GET_FCB_ADR(int);
int	S_MALLOC(int, int);
int	S_MALLOC0(int, int, int);
int	S_MFREE(int);
int	S_PROCESS(int, int, int, int);

void	DISKRED(UBYTE *, int, int, int);
void	DISKRED2(UBYTE *, int, int, int);
void	DISKWRT(UBYTE *, int, int, int);
void	DISKWRT2(UBYTE *, int, int, int);
int	INDOSFLG(void);
void	SUPER_JSR(void (*)(void), struct DREGS *, struct DREGS *);
int	BUS_ERR(UBYTE *, UBYTE *, int);

int	OPEN_PR(UBYTE *, int, int, int, int, int, struct PRCCTRL *, long);
int	KILL_PR(void);
int	GET_PR(int, struct PRCPTR *);
int	SUSPEND_PR(int);
long	SLEEP_PR(long);
int	SEND_PR(int, int, int, UBYTE *, long);
long	TIME_PR(void);
void	CHANGE_PR(void);

#undef	__PROTO_TYPE
#else

void	EXIT();
int	GETCHAR();
void	PUTCHAR();
int	COMINP();
void	COMOUT();
void	PRNOUT();
int	INPOUT();
int	INKEY();
int	GETC();
void	PRINT();
int	GETS();
int	KEYSNS();

int	KFLUSHGP();
int	KFLUSHIO();
int	KFLUSHIN();
int	KFLUSHGC();
int	KFLUSHGS();

void	FFLUSH();
int	CHGDRV();
int	DRVCTRL();
int	CONSNS();
int	PRNSNS();
int	CINSNS();
int	COUTSNS();

int	FATCHK();
int	FATCHK2();

int	HENDSPMO();
int	HENDSPMP();
int	HENDSPMR();
void	HENDSPMC();
int	HENDSPIO();
int	HENDSPIP();
int	HENDSPIR();
void	HENDSPIC();
int	HENDSPSO();
int	HENDSPSP();
int	HENDSPSR();
void	HENDSPSC();

int	CURDRV();
int	GETSS();
int	FGETC();
int	FGETS();
void	FPUTC();
void	FPUTS();
void	ALLCLOSE();
int	SUPER();

void	FNCKEYGT();
void	FNCKEYST();

int	C_PUTC();
int	C_PRINT();
int	C_COLOR();
int	C_LOCATE();
int	C_DOWN_S();
int	C_UP_S();
int	C_UP();
int	C_DOWN();
int	C_RIGHT();
int	C_LEFT();
int	C_CLS_ED();
int	C_CLS_ST();
int	C_CLS_AL();
int	C_ERA_ED();
int	C_ERA_ST();
int	C_ERA_AL();
int	C_INS();
int	C_DEL();
int	C_FNKMOD();
int	C_WINDOW();
int	C_WIDTH();
int	C_CURON();
int	C_CUROFF();

int	K_KEYINP();
int	K_KEYSNS();
int	K_SFTSNS();
int	K_KEYBIT();
void	K_INSMOD();

int	INTVCS();
void	PSPSET();
int	GETTIM2();
int	SETTIM2();
int	NAMESTS();
int	GETDATE();
int	SETDATE();
int	GETTIME();
int	SETTIME();
void	VERIFY();
int	DUP0();
int	VERNUM();
void	KEEPPR();
int	GETDPB();
int	BREAKCK();
void	DRVXCHG();
int	INTVCG();
int	DSKFRE();
int	NAMECK();
int	MKDIR();
int	RMDIR();
int	CHDIR();
int	CREATE();
int	OPEN();
int	CLOSE();
int	READ();
int	WRITE();
int	DELETE();
int	SEEK();
int	CHMOD();

int	IOCTRLGT();
int	IOCTRLST();
int	IOCTRLRH();
int	IOCTRLWH();
int	IOCTRLRD();
int	IOCTRLWD();
int	IOCTRLIS();
int	IOCTRLOS();
int	IOCTRLDVGT();
int	IOCTRLFDGT();
int	IOCTRLRTSET();
int	IOCTRLDVCTL();
int	IOCTRLFDCTL();

int	DUP();
int	DUP2();
int	CURDIR();
int	MALLOC();
int	MFREE();
int	SETBLOCK();

int	LOADEXEC();
int	LOAD();
int	PATHCHK();
int	LOADONLY();
int	EXECONLY();
int	BINDNO();
int	EXEC2();

void	EXIT2();
int	WAIT();
int	FILES();
int	EXFILES();
int	NFILES();
int	EXNFILES();
int	SETPDB();
struct	PDBADR	*GETPDB();
int	SETENV();
int	GETENV();
int	VERIFYG();

int	COMMON_CK();
int	COMMON_RD();
int	COMMON_WT();
int	COMMON_LK();
int	COMMON_FRE();
int	COMMON_DEL();

int	MOVE();
int	RENAME();

int	FILEDATE();
int	MALLOC2();
int	MALLOC0();
int	MAKETMP();
int	NEWFILE();

int	LOCK();
int	UNLOCK();

int	MAKEASSIGN();
int	GETASSIGN();
int	RASSIGN();

int	FFLUSH_SET();
int	OS_PATCH();
struct FCBS *  GET_FCB_ADR();
int	S_MALLOC();
int	S_MALLOC0();
int	S_MFREE();
int	S_PROCESS();

void	DISKRED();
void	DISKRED2();
void	DISKWRT();
void	DISKWRT2();
int	INDOSFLG();
void	SUPER_JSR();
int	BUS_ERR();

int	OPEN_PR();
int	KILL_PR();
int	GET_PR();
int	SUSPEND_PR();
long	SLEEP_PR();
int	SEND_PR();
long	TIME_PR();
void	CHANGE_PR();

#endif

#endif
