/*
 * float.h X68k XC Compiler v2.10 Copyright 1990,91,92 SHARP/Hudson
 */
#ifndef	__FLOAT_H
#define	__FLOAT_H

#define	FLT_RADIX	2	/* radix of exponent			*/
#define	FLT_ROUNDS	-1	/* addition rounds indeterminable	*/
#define	FLT_MANT_DIG	24	/* base 2 digits in float mantissa	*/
#define	DBL_MANT_DIG	53	/* base 2 digits in double mantissa	*/
#define	LDBL_MANT_DIG	53	/* base 2 digits in long double mantissa*/
#define	FLT_EPSILON	1.1920928955079E-7
				/* minimum number x such that 1.0+x!=1.0*/
#define	DBL_EPSILON	2.2204460492504E-16
				/* minimum number x such that 1.0+x!=1.0*/
#define	LDBL_EPSILON	2.2204460492504E-16
				/* minimum number x such that 1.0+x!=1.0*/
#define	FLT_DIG		6	/* maximum decimal digits for float	*/
#define	DBL_DIG		14	/* maximum decimal digits for double	*/
#define	LDBL_DIG	14	/* maximum decimal digits for long double*/
#define	FLT_MIN_EXP	-126	/* minimun exponent for float		*/
#define	DBL_MIN_EXP	-1022	/* minimum exponent for double		*/
#define	LDBL_MIN_EXP	-1022	/* minimum exponent for long double	*/
#define	FLT_MIN		1.1754943508223E-38
				/* minimum normal number for float	*/
#define	DBL_MIN		2.2250738585072E-308
				/* minimum normal number for double	*/
#define	LDBL_MIN	2.2250738585072E-308
				/* minimum normal number for long double*/
#define	FLT_MIN_10_EXP	-38	/* minimum decimal exponent for float	*/
#define	DBL_MIN_10_EXP	-308	/* minimum decimal exponent for double	*/
#define	LDBL_MIN_10_EXP	-308	/* minimum decimal exponent for long double*/
#define	FLT_MAX_EXP	+128	/* maximum exponent for float		*/
#define	DBL_MAX_EXP	+1024	/* maximum exponent for double		*/
#define	LDBL_MAX_EXP	+1024	/* maximum exponent for long double	*/
#define	FLT_MAX		3.4028236692094E+38
				/* maximum normal number for float	*/
#define	DBL_MAX		1.7976931348624E+308
				/* maximum normal number for double	*/
#define	LDBL_MAX	1.7976931348624E+308
				/* maximum normal number for long double*/
#define	FLT_MAX_10_EXP	+38	/* maximum decimal exponent for float	*/
#define	DBL_MAX_10_EXP	+308	/* maximum decimal exponent for double	*/
#define	LDBL_MAX_10_EXP	+308	/* maximum decimal exponent for long double*/

#ifndef	HUGE_VAL
#define	HUGE_VAL	3.5953862697247E+308	/* huge double value	*/
/*			1.1125369292536E-308				*/
#endif

#ifndef	NULL
#define	NULL	0
#endif

#endif
