/*
 * iocslib.h X68k XC Compiler v2.11 Copyright 1990,91,92,93 SHARP/Hudson
 */
#ifndef	__IOCSLIB_H
#define	__IOCSLIB_H

#include	<class.h>

#ifdef	FORWORD
#define	__PROTO_TYPE
#endif
#ifdef	__STDC__
#define	__PROTO_TYPE
#endif

struct	REGS	{
	int	d0;
	int	d1;
	int	d2;
	int	d3;
	int	d4;
	int	d5;
	int	d6;
	int	d7;
	int	a1;
	int	a2;
	int	a3;
	int	a4;
	int	a5;
	int	a6;
};

struct	FNTBUF	{
	WORD	xl;
	WORD	yl;
	UBYTE	buffer[72];
};

struct	CLIPXY	{
	WORD	xs;
	WORD	ys;
	WORD	xe;
	WORD	ye;
};

struct	CHAIN	{
	INT	adr;
	UWORD	len;
};

struct	CHAIN2	{
	INT	adr;
	UWORD	len;
	struct	CHAIN2	*next;
};

struct	PSETPTR	{
	WORD	x;
	WORD	y;
	UWORD	color;
};

struct	POINTPTR	{
	WORD	x;
	WORD	y;
	UWORD	color;
};

struct	LINEPTR	{
	WORD	x1;
	WORD	y1;
	WORD	x2;
	WORD	y2;
	UWORD	color;
	UWORD	linestyle;
};

struct	BOXPTR	{
	WORD	x1;
	WORD	y1;
	WORD	x2;
	WORD	y2;
	UWORD	color;
	UWORD	linestyle;
};

struct	FILLPTR	{
	WORD	x1;
	WORD	y1;
	WORD	x2;
	WORD	y2;
	UWORD	color;
};

struct	CIRCLEPTR	{
	WORD	x;
	WORD	y;
	UWORD	radius;
	UWORD	color;
	WORD	start;
	WORD	end;
	UWORD	ratio;
};

struct	PAINTPTR	{
	WORD	x;
	WORD	y;
	UWORD	color;
	UBYTE	*buf_start;
	UBYTE	*buf_end;
};

struct	SYMBOLPTR	{
	WORD	x1;
	WORD	y1;
	UBYTE	*string_address;
	UBYTE	mag_x;
	UBYTE	mag_y;
	UWORD	color;
	UBYTE	font_type;
	UBYTE	angle;
};

struct	GETPTR	{
	WORD	x1;
	WORD	y1;
	WORD	x2;
	WORD	y2;
	UBYTE	*buf_start;
	UBYTE	*buf_end;
};

struct	PUTPTR	{
	WORD	x1;
	WORD	y1;
	WORD	x2;
	WORD	y2;
	UBYTE	*buf_start;
	UBYTE	*buf_end;
};

struct	XLINEPTR	{
	UWORD	vram_page;
	WORD	x;
	WORD	y;
	WORD	x1;
	UWORD	line_style;
};

struct	YLINEPTR	{
	UWORD	vram_page;
	WORD	x;
	WORD	y;
	WORD	y1;
	UWORD	line_style;
};

struct	TLINEPTR	{
	UWORD	vram_page;
	WORD	x;
	WORD	y;
	WORD	x1;
	WORD	y1;
	UWORD	line_style;
};

struct	TBOXPTR	{
	UWORD	vram_page;
	WORD	x;
	WORD	y;
	WORD	x1;
	WORD	y1;
	UWORD	line_style;
};

struct	TXFILLPTR	{
	UWORD	vram_page;
	WORD	x;
	WORD	y;
	WORD	x1;
	WORD	y1;
	UWORD	fill_patn;
};

struct	TREVPTR	{
	UWORD	vram_page;
	WORD	x;
	WORD	y;
	WORD	x1;
	WORD	y1;
};

struct	PATST	{
	short	OFFSETX;
	short	OFFSETY;
	short	shadow[16];
	short	pattern[16];
};

struct READCAP {
	unsigned int block;
	unsigned int size;
};

struct INQUIRY {
	unsigned char unit;
	unsigned char info;
	unsigned char ver;
	unsigned char reserve;
	unsigned char size;
	unsigned char buff[];
};

#ifdef	__PROTO_TYPE

int	TRAP15(struct REGS *, struct REGS *);
int	B_KEYINP(void);
int	B_KEYSNS(void);
int	B_SFTSNS(void);
int	BITSNS(int);
void	SKEYSET(int);
void	TVCTRL(int);
void	LEDMOD(int, int);
int	TGUSEMD(int, int);
int	DEFCHR(int, int, UBYTE *);
int	CRTMOD(int);
int	CONTRAST(int);
int	HSVTORGB(int, int, int);
int	TPALET(int, int);
int	TPALET2(int, int);
void	TCOLOR(int);
int	FNTGET(int, int, struct FNTBUF *);
void	TEXTGET(int, int, struct FNTBUF *);
void	TEXTPUT(int, int, struct FNTBUF *);
void	CLIPPUT(int, int, struct FNTBUF *, struct CLIPXY *);
void	SCROLL(int, int, int);
void	B_CURON(void);
void	B_CUROFF(void);
int	B_PUTC(int);
int	B_PRINT(UBYTE *);
int	B_COLOR(int);
int	B_LOCATE(int, int);
void	B_DOWN_S(void);
void	B_UP_S(void);
void	B_UP(int);
void	B_DOWN(int);
void	B_RIGHT(int);
void	B_LEFT(int);
void	B_CLR_ED(void);
void	B_CLR_ST(void);
void	B_CLR_AL(void);
void	B_ERA_ED(void);
void	B_ERA_ST(void);
void	B_ERA_AL(void);
void	B_INS(int);
void	B_DEL(int);
int	B_CONSOL(int, int, int, int);
int	B_PUTMES(int, int, int, int, UBYTE *);
int	SET232C(int);
int	LOF232C(void);
int	INP232C(void);
int	ISNS232C(void);
int	OSNS232C(void);
void	OUT232C(int);
int	JOYGET(int);
int	INIT_PRN(int, int);
int	SNSPRN(void);
void	OUTLPT(int);
void	OUTPRN(int);
int	B_SEEK(int, int);
int	B_VERIFY(int, int, int, UBYTE *);
int	B_READDI(int, int, int, UBYTE *);
int	B_DSKINI(int, UBYTE *, int);
int	B_DRVSNS(int);
int	B_WRITE(int, int, int, UBYTE *);
int	B_READ(int, int, int, UBYTE *);
int	B_RECALI(int);
int	B_ASSIGN(int, int, int, UBYTE *);
int	B_WRITED(int, int, int, UBYTE *);
int	B_READID(int, int, UBYTE *);
int	B_BADFMT(int, int, int);
int	B_READDL(int, int, int, UBYTE *);
int	B_FORMAT(int, int, int, UBYTE *);
int	B_DRVCHK(int, int);
int	B_EJECT(int);
int	BINDATEBCD(int);
void	BINDATESET(int);
int	TIMEBCD(int);
void	TIMESET(int);
int	BINDATEGET(void);
int	DATEBIN(int);
int	TIMEGET(void);
int	TIMEBIN(int);
int	DATECNV(UBYTE *);
int	TIMECNV(UBYTE *);
int	DATEASC(int, UBYTE *);
int	TIMEASC(int, UBYTE *);
void	DAYASC(int, UBYTE *);
int	ALARMMOD(int);
int	ALARMSET(int, int, int);
int	ALARMGET(int *, int *, int *);
void	ADPCMOUT(UBYTE *, int, int);
void	ADPCMINP(UBYTE *, int, int);
void	ADPCMAOT(struct CHAIN *, int, int);
void	ADPCMAIN(struct CHAIN *, int, int);
void	ADPCMLOT(struct CHAIN2 *, int);
void	ADPCMLIN(struct CHAIN2 *, int);
int	ADPCMSNS(void);
void	ADPCMMOD(int);
void	OPMSET(int, int);
int	OPMSNS(void);
int	OPMINTST(UBYTE *);
int	TIMERDST(UBYTE *, int, int);
int	VDISPST(UBYTE *, int, int);
int	CRTCRAS(UBYTE *, int);
int	HSYNCST(UBYTE *);
int	PRNINTST(UBYTE *);
void	MS_INIT(void);
void	MS_CURON(void);
void	MS_CUROF(void);
int	MS_STAT(void);
int	MS_GETDT(void);
int	MS_CURGT(void);
int	MS_CURST(int, int);
int	MS_LIMIT(int, int, int, int);
int	MS_OFFTM(int, int);
int	MS_ONTM(int, int);
void	MS_PATST(int, struct PATST *);
void	MS_SEL(int);
void	MS_SEL2(WORD *);
int	SKEY_MOD(int, int, int);
void	DENSNS(void);
int	ONTIME(void);
int	B_INTVCS(int, int);
int	B_SUPER(int);
int	B_BPEEK(UBYTE *);
int	B_WPEEK(UWORD *);
int	B_LPEEK(ULONG *);
void	B_MEMSTR(UBYTE *, UBYTE *, int);
void	B_BPOKE(UBYTE *, int);
void	B_WPOKE(UWORD *, int);
void	B_LPOKE(ULONG *, int);
void	B_MEMSET(UBYTE *, UBYTE *, int);
void	DMAMOVE(UBYTE *, UBYTE *, int, int);
void	DMAMOV_A(struct CHAIN *, UBYTE *, int, int);
void	DMAMOV_L(struct CHAIN2 *, UBYTE *, int);
int	DMAMODE(void);
int	BOOTINF(void);
int	ROMVER(void);
void	G_CLR_ON(void);
int	GPALET(int, int);
int	SFTJIS(int);
int	JISSFT(int);
int	AKCONV(int, int);
int	RMACNV(int, UBYTE *, UBYTE *);
int	DAKJOB(UBYTE *);
int	HANJOB(UBYTE *);
void	OS_CURON(void);
void	OS_CUROF(void);
int	APAGE(int);
int	VPAGE(int);
int	HOME(int, int, int);
int	WINDOW(int, int, int, int);
int	WIPE(void);
int	PSET(struct PSETPTR *);
int	POINT(struct POINTPTR *);
int	LINE(struct LINEPTR *);
int	BOX(struct BOXPTR *);
int	FILL(struct FILLPTR *);
int	CIRCLE(struct CIRCLEPTR *);
int	PAINT(struct PAINTPTR *);
int	SYMBOL(struct SYMBOLPTR *);
int	GETGRM(struct GETPTR *);
int	PUTGRM(struct PUTPTR *);
int	SP_INIT(void);
int	SP_ON(void);
void	SP_OFF(void);
int	SP_CGCLR(int);
int	SP_DEFCG(int, int, UBYTE *);
int	SP_GTPCG(int, int, UBYTE *);
int	SP_REGST(int, int, int, int, int);
int	SP_REGGT(int, int *, int *, int *, int *);
int	BGSCRLST(int, int, int);
int	BGSCRLGT(int, int *, int *);
int	BGCTRLST(int, int, int);
int	BGCTRLGT(int);
int	BGTEXTCL(int, int);
int	BGTEXTST(int, int, int, int);
int	BGTEXTGT(int, int, int);
int	SPALET(int, int, int);
void	TXXLINE(struct XLINEPTR *);
void	TXYLINE(struct YLINEPTR *);
void	TXBOX(struct TBOXPTR *);
void	TXFILL(struct TXFILLPTR *);
void	TXREV(struct TREVPTR *);
void	TXRASCPY(int, int, int);
void	ABORTRST(void);
void	IPLERR(void);
void	ABORTJOB(void);
void	S_RESET(void);				/* S_RESET	$00 */
int	S_SELECT(int);				/* S_SELECT	$01 */
int	S_CMDOUT(int,UBYTE *);			/* S_CMDOUT	$03 */
int	S_DATAIN(int,UBYTE *);			/* S_DATAIN	$04 */
int	S_DATAOUT(int,UBYTE *);			/* S_DATAOUT	$05 */
int	S_STSIN(UBYTE *);			/* S_STSIN	$06 */
int	S_MSGIN(UBYTE *);			/* S_MSGIN	$07 */
int	S_MSGOUT(UBYTE *);			/* S_MSGOUT	$08 */
int	S_PHASE(void);				/* S_PHASE	$09 */
int	S_INQUIRY(int,int,struct INQUIRY *);	/* inquiry	$20 */
int	S_READ(int,int,int,int,UBYTE *);	/* read		$21 */
int	S_WRITE(int,int,int,int,UBYTE *);	/* write	$22 */
int	S_FORMAT(int,int);			/* format	$23 */
int	S_TESTUNIT(int);			/* testunit	$24 */
int	S_READCAP(int,struct READCAP *);	/* readcap	$25 */
int	S_READEXT(int,int,int,int,UBYTE *);	/* readext	$26 */
int	S_WRITEEXT(int,int,int,int,UBYTE *);	/* writeext	$27 */
int	S_REZEROUNIT(int);			/* rezerounit	$2b */
int	S_REQUEST(int,int,UBYTE *);		/* request	$2c */
int	S_SEEK(int,int);			/* seek		$2d */
int	S_STARTSTOP(int,int);			/* startstop	$2f */
int	S_REASSIGN(int,int,UBYTE *);		/* reassign	$31 */
int	S_PAMEDIUM(int,int);			/* pamedium	$32 */

void	B_CURMOD(int);
void	B_CURPAT(int);
void	B_CURPAT1(void);
void	B_CURDEF(UBYTE *);
void	B_SCROLL(int);

int	DRAWMODE(int);

void	TXLINE(struct TLINEPTR);

void	CACHE_MD(int);
int	CACHE_ST(void);
int	MPU_STAT(void);

#undef	__PROTO_TYPE
#else

int	TRAP15();
int	B_KEYINP();
int	B_KEYSNS();
int	B_SFTSNS();
int	BITSNS();
void	SKEYSET();
void	TVCTRL();
void	LEDMOD();
int	TGUSEMD();
int	DEFCHR();
int	CRTMOD();
int	CONTRAST();
int	HSVTORGB();
int	TPALET();
int	TPALET2();
void	TCOLOR();
int	FNTGET();
void	TEXTGET();
void	TEXTPUT();
void	CLIPPUT();
void	SCROLL();
void	B_CURON();
void	B_CUROFF();
int	B_PUTC();
int	B_PRINT();
int	B_COLOR();
int	B_LOCATE();
void	B_DOWN_S();
void	B_UP_S();
void	B_UP();
void	B_DOWN();
void	B_RIGHT();
void	B_LEFT();
void	B_CLR_ED();
void	B_CLR_ST();
void	B_CLR_AL();
void	B_ERA_ED();
void	B_ERA_ST();
void	B_ERA_AL();
void	B_INS();
void	B_DEL();
int	B_CONSOL();
int	B_PUTMES();
int	SET232C();
int	LOF232C();
int	INP232C();
int	ISNS232C();
int	OSNS232C();
void	OUT232C();
int	JOYGET();
int	INIT_PRN();
int	SNSPRN();
void	OUTLPT();
void	OUTPRN();
int	B_SEEK();
int	B_VERIFY();
int	B_READDI();
int	B_DSKINI();
int	B_DRVSNS();
int	B_WRITE();
int	B_READ();
int	B_RECALI();
int	B_ASSIGN();
int	B_WRITED();
int	B_READID();
int	B_BADFMT();
int	B_READDL();
int	B_FORMAT();
int	B_DRVCHK();
int	B_EJECT();
int	BINDATEBCD();
void	BINDATESET();
int	TIMEBCD();
void	TIMESET();
int	BINDATEGET();
int	DATEBIN();
int	TIMEGET();
int	TIMEBIN();
int	DATECNV();
int	TIMECNV();
int	DATEASC();
int	TIMEASC();
void	DAYASC();
int	ALARMMOD();
int	ALARMSET();
int	ALARMGET();
void	ADPCMOUT();
void	ADPCMINP();
void	ADPCMAOT();
void	ADPCMAIN();
void	ADPCMLOT();
void	ADPCMLIN();
int	ADPCMSNS();
void	ADPCMMOD();
void	OPMSET();
int	OPMSNS();
int	OPMINTST();
int	TIMERDST();
int	VDISPST();
int	CRTCRAS();
int	HSYNCST();
int	PRNINTST();
void	MS_INIT();
void	MS_CURON();
void	MS_CUROF();
int	MS_STAT();
int	MS_GETDT();
int	MS_CURGT();
int	MS_CURST();
int	MS_LIMIT();
int	MS_OFFTM();
int	MS_ONTM();
void	MS_PATST();
void	MS_SEL();
void	MS_SEL2();
int	SKEY_MOD();
void	DENSNS();
int	ONTIME();
int	B_INTVCS();
int	B_SUPER();
int	B_BPEEK();
int	B_WPEEK();
int	B_LPEEK();
void	B_MEMSTR();
void	B_BPOKE();
void	B_WPOKE();
void	B_LPOKE();
void	B_MEMSET();
void	DMAMOVE();
void	DMAMOV_A();
void	DMAMOV_L();
int	DMAMODE();
int	BOOTINF();
int	ROMVER();
void	G_CLR_ON();
int	GPALET();
int	SFTJIS();
int	JISSFT();
int	AKCONV();
int	RMACNV();
int	DAKJOB();
int	HANJOB();
void	OS_CURON();
void	OS_CUROF();
int	APAGE();
int	VPAGE();
int	HOME();
int	WINDOW();
int	WIPE();
int	PSET();
int	POINT();
int	LINE();
int	BOX();
int	FILL();
int	CIRCLE();
int	PAINT();
int	SYMBOL();
int	GETGRM();
int	PUTGRM();
int	SP_INIT();
int	SP_ON();
void	SP_OFF();
int	SP_CGCLR();
int	SP_DEFCG();
int	SP_GTPCG();
int	SP_REGST();
int	SP_REGGT();
int	BGSCRLST();
int	BGSCRLGT();
int	BGCTRLST();
int	BGCTRLGT();
int	BGTEXTCL();
int	BGTEXTST();
int	BGTEXTGT();
int	SPALET();
void	TXXLINE();
void	TXYLINE();
void	TXBOX();
void	TXFILL();
void	TXREV();
void	TXRASCPY();
void	ABORTRST();
void	IPLERR();
void	ABORTJOB();
void	S_RESET();
int	S_SELECT();
int	S_CMDOUT();
int	S_DATAIN();
int	S_DATAOUT();
int	S_STSIN();
int	S_MSGIN();
int	S_MSGOUT();
int	S_PHASE();
int	S_INQUIRY();
int	S_READ();
int	S_WRITE();
int	S_FORMAT();
int	S_TESTUNIT();
int	S_READCAP();
int	S_READEXT();
int	S_WRITEEXT();
int	S_REZEROUNIT();
int	S_REQUEST();
int	S_SEEK();
int	S_STARTSTOP();
int	S_REASSIGN();
int	S_PAMEDIUM();

void	B_CURMOD();
void	B_CURPAT();
void	B_CURPAT1();
void	B_CURDEF();
void	B_SCROLL();

int	DRAWMODE();

void	TXLINE();

void	CACHE_MD();
int	CACHE_ST();
int	MPU_STAT();

#endif

#endif
