/*
 * time.h X68k XC Compiler v2.10 Copyright 1990,91,92 SHARP/Hudson
 */
#ifndef	__TIME_H
#define	__TIME_H

#include	<stddef.h>

#ifdef	FORWORD
#define	__PROTO_TYPE
#endif
#ifdef	__STDC__
#define	__PROTO_TYPE
#endif

struct	tm	{
	int	tm_sec;
	int	tm_min;
	int	tm_hour;
	int	tm_mday;
	int	tm_mon;
	int	tm_year;
	int	tm_wday;
	int	tm_yday;
	int	tm_isdst;
};

extern	time_t	timezone;
extern	int	daylight;
extern	char	*tzname[2];
extern	char	tzstn[];
extern	char	tzdtn[];

#ifdef	__PROTO_TYPE

void	tzset(void);
time_t	time(time_t *);
char	*asctime(const struct tm *);
char	*ctime(time_t *);
struct tm	*gmtime(const time_t *);
struct tm	*localtime(const time_t *);
clock_t	clock(void);
double	difftime(time_t, time_t);
time_t	mktime(struct tm *);
size_t	strftime(char *, size_t, const char *, const struct tm *);

#undef	__PROTO_TYPE
#else

char	*asctime();
char	*ctime();
struct tm	*gmtime();
struct tm	*localtime();
void	tzset();
double	difftime();
time_t	time();
clock_t	clock();
time_t	mktime();
size_t	strftime();

#endif

#endif
